/* Notifications.c generated by valac 0.56.14, the Vala compiler
 * generated from Notifications.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include "deja.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NOTIFICATIONS (notifications_get_type ())
#define NOTIFICATIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATIONS, Notifications))
#define NOTIFICATIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATIONS, NotificationsClass))
#define IS_NOTIFICATIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATIONS))
#define IS_NOTIFICATIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATIONS))
#define NOTIFICATIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATIONS, NotificationsClass))

typedef struct _Notifications Notifications;
typedef struct _NotificationsClass NotificationsClass;
typedef struct _NotificationsPrivate NotificationsPrivate;
enum  {
	NOTIFICATIONS_0_PROPERTY,
	NOTIFICATIONS_NUM_PROPERTIES
};
static GParamSpec* notifications_properties[NOTIFICATIONS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Notifications {
	GObject parent_instance;
	NotificationsPrivate * priv;
};

struct _NotificationsClass {
	GObjectClass parent_class;
};

static gpointer notifications_parent_class = NULL;

VALA_EXTERN GType notifications_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Notifications, g_object_unref)
VALA_EXTERN void notifications_automatic_backup_started (void);
static void notifications_send_status (const gchar* title,
                                const gchar* body,
                                GNotificationPriority priority);
VALA_EXTERN void notifications_automatic_backup_delayed (const gchar* reason);
VALA_EXTERN void notifications_backup_finished (GtkWindow* win,
                                    gboolean success,
                                    gboolean cancelled,
                                    const gchar* detail);
static gboolean notifications_window_is_active (GtkWindow* win);
static void notifications_withdraw_status (void);
VALA_EXTERN void notifications_restore_finished (GtkWindow* win,
                                     gboolean success,
                                     gboolean cancelled,
                                     const gchar* detail);
VALA_EXTERN void notifications_operation_blocked (GtkWindow* win,
                                      const gchar* title,
                                      const gchar* body);
VALA_EXTERN void notifications_operation_unblocked (void);
VALA_EXTERN void notifications_attention_needed (GtkWindow* win,
                                     const gchar* title,
                                     const gchar* body);
VALA_EXTERN void notifications_prompt (void);
static GNotification* notifications_make_note (const gchar* title,
                                        const gchar* body);
VALA_EXTERN void notifications_close_all (void);
VALA_EXTERN Notifications* notifications_new (void);
VALA_EXTERN Notifications* notifications_construct (GType object_type);
static GType notifications_get_type_once (void);

void
notifications_automatic_backup_started (void)
{
	notifications_send_status (_ ("Starting scheduled backup"), NULL, G_NOTIFICATION_PRIORITY_LOW);
}

void
notifications_automatic_backup_delayed (const gchar* reason)
{
	g_return_if_fail (reason != NULL);
	notifications_send_status (_ ("Scheduled backup delayed"), reason, G_NOTIFICATION_PRIORITY_NORMAL);
}

void
notifications_backup_finished (GtkWindow* win,
                               gboolean success,
                               gboolean cancelled,
                               const gchar* detail)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (win != NULL);
	if (!notifications_window_is_active (win)) {
		_tmp1_ = success;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !cancelled;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* title = NULL;
		gchar* _tmp2_;
		GNotificationPriority priority = 0;
		gchar* body = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = g_strdup (_ ("Backup completed"));
		title = _tmp2_;
		priority = G_NOTIFICATION_PRIORITY_LOW;
		body = NULL;
		if (detail != NULL) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_strdup (_ ("Backup finished"));
			_g_free0 (title);
			title = _tmp3_;
			_tmp4_ = g_strdup (_ ("But not all files were successfully backed up."));
			_g_free0 (body);
			body = _tmp4_;
			priority = G_NOTIFICATION_PRIORITY_NORMAL;
		}
		_tmp5_ = title;
		_tmp6_ = body;
		notifications_send_status (_tmp5_, _tmp6_, priority);
		_g_free0 (body);
		_g_free0 (title);
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		if (!notifications_window_is_active (win)) {
			_tmp8_ = !success;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_tmp7_ = !cancelled;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			notifications_send_status (_ ("Backup failed"), NULL, G_NOTIFICATION_PRIORITY_NORMAL);
		} else {
			notifications_withdraw_status ();
		}
	}
}

void
notifications_restore_finished (GtkWindow* win,
                                gboolean success,
                                gboolean cancelled,
                                const gchar* detail)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (win != NULL);
	if (!notifications_window_is_active (win)) {
		_tmp1_ = !success;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !cancelled;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		notifications_send_status (_ ("Restore failed"), NULL, G_NOTIFICATION_PRIORITY_NORMAL);
	}
}

void
notifications_operation_blocked (GtkWindow* win,
                                 const gchar* title,
                                 const gchar* body)
{
	g_return_if_fail (win != NULL);
	g_return_if_fail (title != NULL);
	if (!notifications_window_is_active (win)) {
		notifications_send_status (title, body, G_NOTIFICATION_PRIORITY_NORMAL);
	}
}

void
notifications_operation_unblocked (void)
{
	notifications_withdraw_status ();
}

void
notifications_attention_needed (GtkWindow* win,
                                const gchar* title,
                                const gchar* body)
{
	g_return_if_fail (win != NULL);
	g_return_if_fail (title != NULL);
	if (!notifications_window_is_active (win)) {
		notifications_send_status (title, body, G_NOTIFICATION_PRIORITY_HIGH);
	}
}

void
notifications_prompt (void)
{
	GNotification* note = NULL;
	GNotification* _tmp0_;
	GApplication* _tmp1_;
	deja_dup_update_prompt_time (FALSE);
	_tmp0_ = notifications_make_note (_ ("Keep your files safe by backing up regularly"), _ ("Important documents, data, and settings can be " "protected by storing them in a backup. In the " "case of a disaster, you would be able to recover " "them from that backup."));
	note = _tmp0_;
	g_notification_set_default_action (note, "app.prompt-ok");
	g_notification_add_button (note, _ ("Don’t Show Again"), "app.prompt-cancel");
	g_notification_add_button (note, _ ("Open Backups"), "app.prompt-ok");
	_tmp1_ = g_application_get_default ();
	g_application_send_notification (_tmp1_, "prompt", note);
	_g_object_unref0 (note);
}

void
notifications_close_all (void)
{
	GApplication* _tmp0_;
	notifications_withdraw_status ();
	_tmp0_ = g_application_get_default ();
	g_application_withdraw_notification (_tmp0_, "prompt");
}

static GNotification*
notifications_make_note (const gchar* title,
                         const gchar* body)
{
	GNotification* note = NULL;
	GNotification* _tmp0_;
	gchar* icon_env = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GNotification* _tmp14_;
	GNotification* result;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_notification_new (title);
	note = _tmp0_;
	if (body != NULL) {
		GNotification* _tmp1_;
		_tmp1_ = note;
		g_notification_set_body (_tmp1_, body);
	}
	_tmp2_ = g_getenv ("DEJA_DUP_NOTIFICATION_ICON");
	_tmp3_ = g_strdup (_tmp2_);
	icon_env = _tmp3_;
	_tmp4_ = icon_env;
	if (_tmp4_ != NULL) {
		GNotification* _tmp5_;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFileIcon* _tmp9_;
		GFileIcon* _tmp10_;
		_tmp5_ = note;
		_tmp6_ = icon_env;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = (GFileIcon*) g_file_icon_new (_tmp8_);
		_tmp10_ = _tmp9_;
		g_notification_set_icon (_tmp5_, (GIcon*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	} else {
		GNotification* _tmp11_;
		GThemedIcon* _tmp12_;
		GThemedIcon* _tmp13_;
		_tmp11_ = note;
		_tmp12_ = (GThemedIcon*) g_themed_icon_new (ICON_NAME);
		_tmp13_ = _tmp12_;
		g_notification_set_icon (_tmp11_, (GIcon*) _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	_tmp14_ = note;
	g_notification_set_default_action (_tmp14_, "app.show");
	result = note;
	_g_free0 (icon_env);
	return result;
}

static void
notifications_send_status (const gchar* title,
                           const gchar* body,
                           GNotificationPriority priority)
{
	GNotification* note = NULL;
	GNotification* _tmp0_;
	GApplication* _tmp1_;
	g_return_if_fail (title != NULL);
	_tmp0_ = notifications_make_note (title, body);
	note = _tmp0_;
	g_notification_set_priority (note, priority);
	_tmp1_ = g_application_get_default ();
	g_application_send_notification (_tmp1_, "backup-status", note);
	_g_object_unref0 (note);
}

static void
notifications_withdraw_status (void)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_application_withdraw_notification (_tmp0_, "backup-status");
}

static gboolean
notifications_window_is_active (GtkWindow* win)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (win != NULL, FALSE);
	g_object_get (win, "is-active", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) win);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Notifications*
notifications_construct (GType object_type)
{
	Notifications * self = NULL;
	self = (Notifications*) g_object_new (object_type, NULL);
	return self;
}

Notifications*
notifications_new (void)
{
	return notifications_construct (TYPE_NOTIFICATIONS);
}

static void
notifications_class_init (NotificationsClass * klass,
                          gpointer klass_data)
{
	notifications_parent_class = g_type_class_peek_parent (klass);
}

static void
notifications_instance_init (Notifications * self,
                             gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
notifications_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notifications), 0, (GInstanceInitFunc) notifications_instance_init, NULL };
	GType notifications_type_id;
	notifications_type_id = g_type_register_static (G_TYPE_OBJECT, "Notifications", &g_define_type_info, 0);
	return notifications_type_id;
}

GType
notifications_get_type (void)
{
	static gsize notifications_type_id__once = 0;
	if (g_once_init_enter (&notifications_type_id__once)) {
		GType notifications_type_id;
		notifications_type_id = notifications_get_type_once ();
		g_once_init_leave (&notifications_type_id__once, notifications_type_id);
	}
	return notifications_type_id__once;
}

