/* MountOperationAssistant.c generated by valac 0.56.14, the Vala compiler
 * generated from MountOperationAssistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _MountOperationAssistantPrivate MountOperationAssistantPrivate;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
enum  {
	MOUNT_OPERATION_ASSISTANT_0_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_NUM_PROPERTIES
};
static GParamSpec* mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

struct _MountOperationAssistant {
	GMountOperation parent_instance;
	MountOperationAssistantPrivate * priv;
};

struct _MountOperationAssistantClass {
	GMountOperationClass parent_class;
};

struct _MountOperationAssistantPrivate {
	gchar* _label_help;
	gchar* _label_username;
	gchar* _label_password;
	gchar* _label_remember_password;
	gboolean _go_forward;
	gboolean _retry_mode;
	AssistantOperation* assist;
	GtkBox* password_page;
	GtkBox* layout;
	GtkGrid* table;
	GtkCheckButton* anonymous_w;
	GtkCheckButton* remember_w;
	GtkEntry* username_w;
	GtkEntry* domain_w;
	GtkPasswordEntry* password_w;
	GMainLoop* loop;
};

static gint MountOperationAssistant_private_offset;
static gpointer mount_operation_assistant_parent_class = NULL;

VALA_EXTERN GType mount_operation_assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountOperationAssistant, g_object_unref)
VALA_EXTERN GType assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Assistant, g_object_unref)
VALA_EXTERN GType assistant_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantOperation, g_object_unref)
VALA_EXTERN MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
VALA_EXTERN MountOperationAssistant* mount_operation_assistant_construct (GType object_type,
                                                              AssistantOperation* assist);
static void mount_operation_assistant_do_prepare (MountOperationAssistant* self,
                                           Assistant* assist,
                                           GtkWidget* page);
static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender,
                                                              GtkWidget* page,
                                                              gpointer self);
static void mount_operation_assistant_do_backward (MountOperationAssistant* self,
                                            Assistant* assist);
static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender,
                                                                gpointer self);
static void mount_operation_assistant_do_forward (MountOperationAssistant* self,
                                           Assistant* assist);
static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender,
                                                              gpointer self);
static void mount_operation_assistant_do_close (MountOperationAssistant* self,
                                         AssistantOperation* op);
static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender,
                                                                      gpointer self);
static void mount_operation_assistant_add_password_page (MountOperationAssistant* self);
static void mount_operation_assistant_go_forward_changed (MountOperationAssistant* self);
VALA_EXTERN gboolean mount_operation_assistant_get_go_forward (MountOperationAssistant* self);
VALA_EXTERN void assistant_go_forward (Assistant* self);
static void mount_operation_assistant_real_aborted (GMountOperation* base);
VALA_EXTERN void assistant_operation_show_error (AssistantOperation* self,
                                     const gchar* _error_,
                                     const gchar* detail);
static void mount_operation_assistant_real_ask_password (GMountOperation* base,
                                                  const gchar* message,
                                                  const gchar* default_user,
                                                  const gchar* default_domain,
                                                  GAskPasswordFlags flags);
VALA_EXTERN gboolean mount_operation_assistant_get_retry_mode (MountOperationAssistant* self);
static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self,
                                                        const gchar* message,
                                                        const gchar* default_user,
                                                        const gchar* default_domain,
                                                        GAskPasswordFlags flags);
VALA_EXTERN void assistant_interrupt (Assistant* self,
                          GtkWidget* page,
                          gboolean can_continue,
                          gboolean stay_visible);
static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self);
VALA_EXTERN void notifications_attention_needed (GtkWindow* win,
                                     const gchar* title,
                                     const gchar* body);
static void mount_operation_assistant_real_ask_question (GMountOperation* base,
                                                  const gchar* message,
                                                  gchar** choices);
static void __lambda11_ (MountOperationAssistant* self,
                  GMountOperation* t,
                  GMountOperationResult r);
static void mount_operation_assistant_send_reply (MountOperationAssistant* self,
                                           GMountOperationResult _result_);
static void ___lambda11__g_mount_operation_reply (GMountOperation* _sender,
                                           GMountOperationResult _result_,
                                           gpointer self);
VALA_EXTERN GType assistant_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void assistant_append_page (Assistant* self,
                            GtkWidget* page,
                            AssistantType type,
                            const gchar* forward_text);
VALA_EXTERN void deja_dup_set_margins (GtkWidget* w,
                           gint margin);
VALA_EXTERN void assistant_set_page_title (Assistant* self,
                               GtkWidget* page,
                               const gchar* title);
VALA_EXTERN const gchar* mount_operation_assistant_get_label_help (MountOperationAssistant* self);
static void ___lambda7_ (MountOperationAssistant* self,
                  GtkCheckButton* b);
static void ____lambda7__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void ___lambda8_ (MountOperationAssistant* self,
                  GtkCheckButton* b);
static void ____lambda8__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void ___lambda9_ (MountOperationAssistant* self,
                  GtkEditable* e);
static void ____lambda9__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
VALA_EXTERN const gchar* mount_operation_assistant_get_label_username (MountOperationAssistant* self);
static void ___lambda10_ (MountOperationAssistant* self,
                   GtkEditable* e);
static void ____lambda10__gtk_editable_changed (GtkEditable* _sender,
                                         gpointer self);
VALA_EXTERN const gchar* mount_operation_assistant_get_label_password (MountOperationAssistant* self);
VALA_EXTERN const gchar* mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self);
static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self,
                                                   GtkEntry* e);
static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self);
VALA_EXTERN void assistant_allow_forward (Assistant* self,
                              gboolean allow);
VALA_EXTERN void mount_operation_assistant_set_label_help (MountOperationAssistant* self,
                                               const gchar* value);
VALA_EXTERN void mount_operation_assistant_set_label_username (MountOperationAssistant* self,
                                                   const gchar* value);
VALA_EXTERN void mount_operation_assistant_set_label_password (MountOperationAssistant* self,
                                                   const gchar* value);
VALA_EXTERN void mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self,
                                                            const gchar* value);
VALA_EXTERN void mount_operation_assistant_set_go_forward (MountOperationAssistant* self,
                                               gboolean value);
VALA_EXTERN void mount_operation_assistant_set_retry_mode (MountOperationAssistant* self,
                                               gboolean value);
static GObject * mount_operation_assistant_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _mount_operation_assistant_go_forward_changed_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void mount_operation_assistant_finalize (GObject * obj);
static GType mount_operation_assistant_get_type_once (void);
static void _vala_mount_operation_assistant_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_mount_operation_assistant_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mount_operation_assistant_get_instance_private (MountOperationAssistant* self)
{
	return G_STRUCT_MEMBER_P (self, MountOperationAssistant_private_offset);
}

static void
_mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender,
                                                         GtkWidget* page,
                                                         gpointer self)
{
	mount_operation_assistant_do_prepare ((MountOperationAssistant*) self, _sender, page);
}

static void
_mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender,
                                                           gpointer self)
{
	mount_operation_assistant_do_backward ((MountOperationAssistant*) self, _sender);
}

static void
_mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender,
                                                         gpointer self)
{
	mount_operation_assistant_do_forward ((MountOperationAssistant*) self, _sender);
}

static void
_mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender,
                                                                 gpointer self)
{
	mount_operation_assistant_do_close ((MountOperationAssistant*) self, _sender);
}

MountOperationAssistant*
mount_operation_assistant_construct (GType object_type,
                                     AssistantOperation* assist)
{
	MountOperationAssistant * self = NULL;
	g_return_val_if_fail (assist != NULL, NULL);
	self = (MountOperationAssistant*) g_object_new (object_type, NULL);
	self->priv->assist = assist;
	g_signal_connect_object ((Assistant*) assist, "prepare", (GCallback) _mount_operation_assistant_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((Assistant*) assist, "backward", (GCallback) _mount_operation_assistant_do_backward_assistant_backward, self, 0);
	g_signal_connect_object ((Assistant*) assist, "forward", (GCallback) _mount_operation_assistant_do_forward_assistant_forward, self, 0);
	g_signal_connect_object (assist, "closing", (GCallback) _mount_operation_assistant_do_close_assistant_operation_closing, self, 0);
	mount_operation_assistant_add_password_page (self);
	return self;
}

MountOperationAssistant*
mount_operation_assistant_new (AssistantOperation* assist)
{
	return mount_operation_assistant_construct (TYPE_MOUNT_OPERATION_ASSISTANT, assist);
}

static void
mount_operation_assistant_go_forward_changed (MountOperationAssistant* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_go_forward;
	if (_tmp0_) {
		AssistantOperation* _tmp1_;
		_tmp1_ = self->priv->assist;
		assistant_go_forward ((Assistant*) _tmp1_);
	}
}

static void
mount_operation_assistant_real_aborted (GMountOperation* base)
{
	MountOperationAssistant * self;
	AssistantOperation* _tmp0_;
	self = (MountOperationAssistant*) base;
	_tmp0_ = self->priv->assist;
	assistant_operation_show_error (_tmp0_, _ ("Location not available"), NULL);
}

static void
mount_operation_assistant_real_ask_password (GMountOperation* base,
                                             const gchar* message,
                                             const gchar* default_user,
                                             const gchar* default_domain,
                                             GAskPasswordFlags flags)
{
	MountOperationAssistant * self;
	gboolean _tmp0_;
	AssistantOperation* _tmp1_;
	GtkBox* _tmp2_;
	GMainLoop* _tmp3_;
	AssistantOperation* _tmp4_;
	GMainLoop* _tmp5_;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	_tmp0_ = self->priv->_retry_mode;
	if (_tmp0_) {
		g_mount_operation_reply ((GMountOperation*) self, G_MOUNT_OPERATION_HANDLED);
		return;
	}
	mount_operation_assistant_flesh_out_password_page (self, message, default_user, default_domain, flags);
	_tmp1_ = self->priv->assist;
	_tmp2_ = self->priv->password_page;
	assistant_interrupt ((Assistant*) _tmp1_, (GtkWidget*) _tmp2_, TRUE, FALSE);
	_tmp3_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp3_;
	mount_operation_assistant_check_valid_inputs (self);
	_tmp4_ = self->priv->assist;
	notifications_attention_needed ((GtkWindow*) _tmp4_, _ ("Backups needs your password to continue"), NULL);
	_tmp5_ = self->priv->loop;
	g_main_loop_run (_tmp5_);
}

static void
__lambda11_ (MountOperationAssistant* self,
             GMountOperation* t,
             GMountOperationResult r)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (t != NULL);
	_tmp0_ = g_mount_operation_get_choice (t);
	_tmp1_ = _tmp0_;
	g_mount_operation_set_choice ((GMountOperation*) self, _tmp1_);
	mount_operation_assistant_send_reply (self, r);
}

static void
___lambda11__g_mount_operation_reply (GMountOperation* _sender,
                                      GMountOperationResult _result_,
                                      gpointer self)
{
	__lambda11_ ((MountOperationAssistant*) self, _sender, _result_);
}

static void
mount_operation_assistant_real_ask_question (GMountOperation* base,
                                             const gchar* message,
                                             gchar** choices)
{
	MountOperationAssistant * self;
	GtkMountOperation* t = NULL;
	AssistantOperation* _tmp0_;
	GtkMountOperation* _tmp1_;
	GMainLoop* _tmp2_;
	GMainLoop* _tmp3_;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->assist;
	_tmp1_ = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) _tmp0_);
	t = _tmp1_;
	g_signal_connect_object ((GMountOperation*) t, "reply", (GCallback) ___lambda11__g_mount_operation_reply, self, 0);
	_tmp2_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp2_;
	g_signal_emit_by_name ((GMountOperation*) t, "ask-question", message, choices);
	_tmp3_ = self->priv->loop;
	g_main_loop_run (_tmp3_);
	_g_object_unref0 (t);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mount_operation_assistant_add_password_page (MountOperationAssistant* self)
{
	GtkBox* page = NULL;
	GtkBox* _tmp0_;
	AssistantOperation* _tmp1_;
	GtkBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	_tmp1_ = self->priv->assist;
	assistant_append_page ((Assistant*) _tmp1_, (GtkWidget*) page, ASSISTANT_TYPE_INTERRUPT, _ ("_Forward"));
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->password_page);
	self->priv->password_page = _tmp2_;
	_g_object_unref0 (page);
}

static void
___lambda7_ (MountOperationAssistant* self,
             GtkCheckButton* b)
{
	g_return_if_fail (b != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}

static void
____lambda7__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	___lambda7_ ((MountOperationAssistant*) self, _sender);
}

static void
___lambda8_ (MountOperationAssistant* self,
             GtkCheckButton* b)
{
	GtkGrid* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->table;
	_tmp1_ = gtk_check_button_get_active (b);
	_tmp2_ = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !_tmp2_);
}

static void
____lambda8__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	___lambda8_ ((MountOperationAssistant*) self, _sender);
}

static void
___lambda9_ (MountOperationAssistant* self,
             GtkEditable* e)
{
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}

static void
____lambda9__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	___lambda9_ ((MountOperationAssistant*) self, _sender);
}

static void
___lambda10_ (MountOperationAssistant* self,
              GtkEditable* e)
{
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}

static void
____lambda10__gtk_editable_changed (GtkEditable* _sender,
                                    gpointer self)
{
	___lambda10_ ((MountOperationAssistant*) self, _sender);
}

static void
mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self,
                                                   const gchar* message,
                                                   const gchar* default_user,
                                                   const gchar* default_domain,
                                                   GAskPasswordFlags flags)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	gint rows = 0;
	gint ucol = 0;
	GtkLabel* label = NULL;
	AssistantOperation* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkLabel* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	_tmp0_ = self->priv->layout;
	if (_tmp0_ != NULL) {
		GtkBox* _tmp1_;
		GtkBox* _tmp2_;
		_tmp1_ = self->priv->password_page;
		_tmp2_ = self->priv->layout;
		gtk_box_remove (_tmp1_, (GtkWidget*) _tmp2_);
	}
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp3_;
	_tmp4_ = self->priv->layout;
	deja_dup_set_margins ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->table);
	self->priv->table = _tmp5_;
	_tmp6_ = self->priv->table;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->table;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->table;
	gtk_grid_set_row_spacing (_tmp8_, 6);
	_tmp9_ = self->priv->table;
	gtk_grid_set_column_spacing (_tmp9_, 6);
	_tmp10_ = self->priv->password_page;
	_tmp11_ = self->priv->layout;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	rows = 0;
	ucol = 0;
	_tmp12_ = self->priv->assist;
	_tmp13_ = self->priv->password_page;
	assistant_set_page_title ((Assistant*) _tmp12_, (GtkWidget*) _tmp13_, "");
	_tmp14_ = (GtkLabel*) gtk_label_new (message);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (label);
	label = _tmp14_;
	_tmp15_ = label;
	gtk_label_set_xalign (_tmp15_, 0.0f);
	_tmp16_ = label;
	gtk_label_set_wrap (_tmp16_, TRUE);
	_tmp17_ = label;
	gtk_label_set_max_width_chars (_tmp17_, 25);
	_tmp18_ = self->priv->layout;
	_tmp19_ = label;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->_label_help;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkBox* _tmp25_;
		GtkLabel* _tmp26_;
		_tmp21_ = self->priv->_label_help;
		_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
		g_object_ref_sink (_tmp22_);
		_g_object_unref0 (label);
		label = _tmp22_;
		_tmp23_ = label;
		gtk_label_set_use_markup (_tmp23_, TRUE);
		_tmp24_ = label;
		gtk_label_set_xalign (_tmp24_, (gfloat) 0);
		_tmp25_ = self->priv->layout;
		_tmp26_ = label;
		gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	}
	_tmp27_ = label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp27_, 6);
	if ((flags & G_ASK_PASSWORD_ANONYMOUS_SUPPORTED) != 0) {
		GtkCheckButton* _tmp28_;
		GtkCheckButton* _tmp29_;
		GtkCheckButton* _tmp30_;
		GtkBox* _tmp31_;
		GtkCheckButton* _tmp32_;
		GtkCheckButton* w = NULL;
		GtkCheckButton* _tmp33_;
		GtkCheckButton* _tmp34_;
		GtkCheckButton* _tmp35_;
		GtkCheckButton* _tmp36_;
		GtkGrid* _tmp37_;
		GtkBox* _tmp38_;
		GtkCheckButton* _tmp39_;
		GtkBox* hbox = NULL;
		GtkBox* _tmp40_;
		GtkBox* _tmp41_;
		GtkLabel* _tmp42_;
		GtkLabel* _tmp43_;
		GtkBox* _tmp44_;
		GtkGrid* _tmp45_;
		GtkBox* _tmp46_;
		GtkBox* _tmp47_;
		_tmp28_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Connect _anonymously"));
		g_object_ref_sink (_tmp28_);
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = _tmp28_;
		_tmp29_ = self->priv->anonymous_w;
		g_signal_connect_object (_tmp29_, "toggled", (GCallback) ____lambda7__gtk_check_button_toggled, self, 0);
		_tmp30_ = self->priv->anonymous_w;
		gtk_check_button_set_active (_tmp30_, TRUE);
		_tmp31_ = self->priv->layout;
		_tmp32_ = self->priv->anonymous_w;
		gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
		_tmp33_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Connect as u_ser"));
		g_object_ref_sink (_tmp33_);
		w = _tmp33_;
		_tmp34_ = w;
		_tmp35_ = self->priv->anonymous_w;
		gtk_check_button_set_group (_tmp34_, _tmp35_);
		_tmp36_ = self->priv->anonymous_w;
		g_signal_connect_object (_tmp36_, "toggled", (GCallback) ____lambda8__gtk_check_button_toggled, self, 0);
		_tmp37_ = self->priv->table;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp37_, FALSE);
		_tmp38_ = self->priv->layout;
		_tmp39_ = w;
		gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
		_tmp40_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp40_);
		hbox = _tmp40_;
		_tmp41_ = hbox;
		_tmp42_ = (GtkLabel*) gtk_label_new ("    ");
		g_object_ref_sink (_tmp42_);
		_tmp43_ = _tmp42_;
		gtk_box_append (_tmp41_, (GtkWidget*) _tmp43_);
		_g_object_unref0 (_tmp43_);
		_tmp44_ = hbox;
		_tmp45_ = self->priv->table;
		gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
		_tmp46_ = self->priv->layout;
		_tmp47_ = hbox;
		gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
		ucol = 1;
		_g_object_unref0 (hbox);
		_g_object_unref0 (w);
	} else {
		GtkBox* _tmp48_;
		GtkGrid* _tmp49_;
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = NULL;
		_tmp48_ = self->priv->layout;
		_tmp49_ = self->priv->table;
		gtk_box_append (_tmp48_, (GtkWidget*) _tmp49_);
	}
	if ((flags & G_ASK_PASSWORD_NEED_USERNAME) != 0) {
		GtkEntry* _tmp50_;
		GtkEntry* _tmp51_;
		GtkEntry* _tmp52_;
		GtkEntry* _tmp53_;
		const gchar* _tmp54_;
		GtkLabel* _tmp55_;
		GtkLabel* _tmp56_;
		GtkEntry* _tmp57_;
		GtkGrid* _tmp58_;
		GtkLabel* _tmp59_;
		GtkGrid* _tmp60_;
		GtkEntry* _tmp61_;
		gint _tmp62_;
		_tmp50_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp50_);
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = _tmp50_;
		_tmp51_ = self->priv->username_w;
		g_object_set ((GObject*) _tmp51_, "activates-default", TRUE, "text", default_user, NULL);
		_tmp52_ = self->priv->username_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp52_, TRUE);
		_tmp53_ = self->priv->username_w;
		g_signal_connect_object ((GtkEditable*) _tmp53_, "changed", (GCallback) ____lambda9__gtk_editable_changed, self, 0);
		_tmp54_ = self->priv->_label_username;
		_tmp55_ = (GtkLabel*) gtk_label_new (_tmp54_);
		g_object_ref_sink (_tmp55_);
		_g_object_unref0 (label);
		label = _tmp55_;
		_tmp56_ = label;
		_tmp57_ = self->priv->username_w;
		g_object_set ((GObject*) _tmp56_, "mnemonic-widget", _tmp57_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp58_ = self->priv->table;
		_tmp59_ = label;
		gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, ucol, rows, 1, 1);
		_tmp60_ = self->priv->table;
		_tmp61_ = self->priv->username_w;
		gtk_grid_attach (_tmp60_, (GtkWidget*) _tmp61_, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_tmp62_ = rows;
	} else {
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_NEED_DOMAIN) != 0) {
		GtkEntry* _tmp63_;
		GtkEntry* _tmp64_;
		GtkEntry* _tmp65_;
		GtkEntry* _tmp66_;
		GtkLabel* _tmp67_;
		GtkLabel* _tmp68_;
		GtkEntry* _tmp69_;
		GtkGrid* _tmp70_;
		GtkLabel* _tmp71_;
		GtkGrid* _tmp72_;
		GtkEntry* _tmp73_;
		gint _tmp74_;
		_tmp63_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp63_);
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = _tmp63_;
		_tmp64_ = self->priv->domain_w;
		g_object_set ((GObject*) _tmp64_, "activates-default", TRUE, "text", default_domain, NULL);
		_tmp65_ = self->priv->domain_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp65_, TRUE);
		_tmp66_ = self->priv->domain_w;
		g_signal_connect_object ((GtkEditable*) _tmp66_, "changed", (GCallback) ____lambda10__gtk_editable_changed, self, 0);
		_tmp67_ = (GtkLabel*) gtk_label_new (_ ("_Domain"));
		g_object_ref_sink (_tmp67_);
		_g_object_unref0 (label);
		label = _tmp67_;
		_tmp68_ = label;
		_tmp69_ = self->priv->domain_w;
		g_object_set ((GObject*) _tmp68_, "mnemonic-widget", _tmp69_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp70_ = self->priv->table;
		_tmp71_ = label;
		gtk_grid_attach (_tmp70_, (GtkWidget*) _tmp71_, ucol, rows, 1, 1);
		_tmp72_ = self->priv->table;
		_tmp73_ = self->priv->domain_w;
		gtk_grid_attach (_tmp72_, (GtkWidget*) _tmp73_, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_tmp74_ = rows;
	} else {
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_NEED_PASSWORD) != 0) {
		GtkPasswordEntry* _tmp75_;
		GtkPasswordEntry* _tmp76_;
		GtkPasswordEntry* _tmp77_;
		GtkPasswordEntry* _tmp78_;
		const gchar* _tmp79_;
		GtkLabel* _tmp80_;
		GtkLabel* _tmp81_;
		GtkPasswordEntry* _tmp82_;
		GtkGrid* _tmp83_;
		GtkLabel* _tmp84_;
		GtkGrid* _tmp85_;
		GtkPasswordEntry* _tmp86_;
		gint _tmp87_;
		_tmp75_ = (GtkPasswordEntry*) gtk_password_entry_new ();
		g_object_ref_sink (_tmp75_);
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = _tmp75_;
		_tmp76_ = self->priv->password_w;
		g_object_set (_tmp76_, "activates-default", TRUE, NULL);
		_tmp77_ = self->priv->password_w;
		gtk_password_entry_set_show_peek_icon (_tmp77_, TRUE);
		_tmp78_ = self->priv->password_w;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp78_, TRUE);
		_tmp79_ = self->priv->_label_password;
		_tmp80_ = (GtkLabel*) gtk_label_new (_tmp79_);
		g_object_ref_sink (_tmp80_);
		_g_object_unref0 (label);
		label = _tmp80_;
		_tmp81_ = label;
		_tmp82_ = self->priv->password_w;
		g_object_set ((GObject*) _tmp81_, "mnemonic-widget", _tmp82_, "use-underline", TRUE, "xalign", 1.0f, NULL);
		_tmp83_ = self->priv->table;
		_tmp84_ = label;
		gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, ucol, rows, 1, 1);
		_tmp85_ = self->priv->table;
		_tmp86_ = self->priv->password_w;
		gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_tmp87_ = rows;
	} else {
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_SAVING_SUPPORTED) != 0) {
		const gchar* _tmp88_;
		GtkCheckButton* _tmp89_;
		GtkGrid* _tmp90_;
		GtkCheckButton* _tmp91_;
		gint _tmp92_;
		_tmp88_ = self->priv->_label_remember_password;
		_tmp89_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp88_);
		g_object_ref_sink (_tmp89_);
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = _tmp89_;
		_tmp90_ = self->priv->table;
		_tmp91_ = self->priv->remember_w;
		gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_tmp92_ = rows;
	} else {
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = NULL;
	}
	_g_object_unref0 (label);
}

static gboolean
mount_operation_assistant_is_valid_entry (MountOperationAssistant* self,
                                          GtkEntry* e)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (e == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = gtk_editable_get_text ((GtkEditable*) e);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = gtk_editable_get_text ((GtkEditable*) e);
			_tmp5_ = _tmp4_;
			_tmp1_ = g_strcmp0 (_tmp5_, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static gboolean
mount_operation_assistant_is_anonymous (MountOperationAssistant* self)
{
	gboolean _tmp0_ = FALSE;
	GtkCheckButton* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->anonymous_w;
	if (_tmp1_ != NULL) {
		GtkCheckButton* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->anonymous_w;
		_tmp3_ = gtk_check_button_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean valid = FALSE;
	AssistantOperation* _tmp4_;
	g_return_if_fail (self != NULL);
	if (mount_operation_assistant_is_anonymous (self)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		GtkEntry* _tmp2_;
		_tmp2_ = self->priv->username_w;
		if (mount_operation_assistant_is_valid_entry (self, _tmp2_)) {
			GtkEntry* _tmp3_;
			_tmp3_ = self->priv->domain_w;
			_tmp1_ = mount_operation_assistant_is_valid_entry (self, _tmp3_);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	valid = _tmp0_;
	_tmp4_ = self->priv->assist;
	assistant_allow_forward ((Assistant*) _tmp4_, valid);
}

static void
mount_operation_assistant_send_reply (MountOperationAssistant* self,
                                      GMountOperationResult _result_)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->loop;
	if (_tmp0_ != NULL) {
		GMainLoop* _tmp1_;
		_tmp1_ = self->priv->loop;
		g_main_loop_quit (_tmp1_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		g_mount_operation_reply ((GMountOperation*) self, _result_);
	}
}

static void
mount_operation_assistant_do_close (MountOperationAssistant* self,
                                    AssistantOperation* op)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}

static void
mount_operation_assistant_do_backward (MountOperationAssistant* self,
                                       Assistant* assist)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}

static void
mount_operation_assistant_do_forward (MountOperationAssistant* self,
                                      Assistant* assist)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
mount_operation_assistant_do_prepare (MountOperationAssistant* self,
                                      Assistant* assist,
                                      GtkWidget* page)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->loop;
	if (_tmp0_ != NULL) {
		GtkEntry* _tmp1_;
		GtkEntry* _tmp8_;
		GtkPasswordEntry* _tmp15_;
		GtkCheckButton* _tmp22_;
		GtkCheckButton* _tmp24_;
		_tmp1_ = self->priv->username_w;
		if (_tmp1_ != NULL) {
			gchar* txt = NULL;
			GtkEntry* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp2_ = self->priv->username_w;
			_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			txt = _tmp4_;
			_tmp5_ = txt;
			_tmp6_ = string_strip (_tmp5_);
			_tmp7_ = _tmp6_;
			g_mount_operation_set_username ((GMountOperation*) self, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (txt);
		}
		_tmp8_ = self->priv->domain_w;
		if (_tmp8_ != NULL) {
			gchar* txt = NULL;
			GtkEntry* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp9_ = self->priv->domain_w;
			_tmp10_ = gtk_editable_get_text ((GtkEditable*) _tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			txt = _tmp11_;
			_tmp12_ = txt;
			_tmp13_ = string_strip (_tmp12_);
			_tmp14_ = _tmp13_;
			g_mount_operation_set_domain ((GMountOperation*) self, _tmp14_);
			_g_free0 (_tmp14_);
			_g_free0 (txt);
		}
		_tmp15_ = self->priv->password_w;
		if (_tmp15_ != NULL) {
			gchar* txt = NULL;
			GtkPasswordEntry* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp16_ = self->priv->password_w;
			_tmp17_ = gtk_editable_get_text ((GtkEditable*) _tmp16_);
			_tmp18_ = g_strdup (_tmp17_);
			txt = _tmp18_;
			_tmp19_ = txt;
			_tmp20_ = string_strip (_tmp19_);
			_tmp21_ = _tmp20_;
			g_mount_operation_set_password ((GMountOperation*) self, _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (txt);
		}
		_tmp22_ = self->priv->anonymous_w;
		if (_tmp22_ != NULL) {
			GtkCheckButton* _tmp23_;
			_tmp23_ = self->priv->anonymous_w;
			g_mount_operation_set_anonymous ((GMountOperation*) self, gtk_check_button_get_active (_tmp23_));
		}
		_tmp24_ = self->priv->remember_w;
		if (_tmp24_ != NULL) {
			GPasswordSave _tmp25_ = 0;
			GtkCheckButton* _tmp26_;
			_tmp26_ = self->priv->remember_w;
			if (gtk_check_button_get_active (_tmp26_)) {
				_tmp25_ = G_PASSWORD_SAVE_PERMANENTLY;
			} else {
				_tmp25_ = G_PASSWORD_SAVE_NEVER;
			}
			g_mount_operation_set_password_save ((GMountOperation*) self, _tmp25_);
		}
		mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_HANDLED);
	}
}

const gchar*
mount_operation_assistant_get_label_help (MountOperationAssistant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_help;
	result = _tmp0_;
	return result;
}

void
mount_operation_assistant_set_label_help (MountOperationAssistant* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_label_help (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_help);
		self->priv->_label_help = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY]);
	}
}

const gchar*
mount_operation_assistant_get_label_username (MountOperationAssistant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_username;
	result = _tmp0_;
	return result;
}

void
mount_operation_assistant_set_label_username (MountOperationAssistant* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_label_username (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_username);
		self->priv->_label_username = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY]);
	}
}

const gchar*
mount_operation_assistant_get_label_password (MountOperationAssistant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_password;
	result = _tmp0_;
	return result;
}

void
mount_operation_assistant_set_label_password (MountOperationAssistant* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_label_password (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_password);
		self->priv->_label_password = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY]);
	}
}

const gchar*
mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_remember_password;
	result = _tmp0_;
	return result;
}

void
mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self,
                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_label_remember_password (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_remember_password);
		self->priv->_label_remember_password = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY]);
	}
}

gboolean
mount_operation_assistant_get_go_forward (MountOperationAssistant* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_go_forward;
	return result;
}

void
mount_operation_assistant_set_go_forward (MountOperationAssistant* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_go_forward (self);
	if (old_value != value) {
		self->priv->_go_forward = value;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY]);
	}
}

gboolean
mount_operation_assistant_get_retry_mode (MountOperationAssistant* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_retry_mode;
	return result;
}

void
mount_operation_assistant_set_retry_mode (MountOperationAssistant* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mount_operation_assistant_get_retry_mode (self);
	if (old_value != value) {
		self->priv->_retry_mode = value;
		g_object_notify_by_pspec ((GObject *) self, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY]);
	}
}

static void
_mount_operation_assistant_go_forward_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	mount_operation_assistant_go_forward_changed ((MountOperationAssistant*) self);
}

static GObject *
mount_operation_assistant_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MountOperationAssistant * self;
	parent_class = G_OBJECT_CLASS (mount_operation_assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	g_signal_connect_object ((GObject*) self, "notify::go-forward", (GCallback) _mount_operation_assistant_go_forward_changed_g_object_notify, self, 0);
	return obj;
}

static void
mount_operation_assistant_class_init (MountOperationAssistantClass * klass,
                                      gpointer klass_data)
{
	mount_operation_assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MountOperationAssistant_private_offset);
	((GMountOperationClass *) klass)->aborted = (void (*) (GMountOperation*)) mount_operation_assistant_real_aborted;
	((GMountOperationClass *) klass)->ask_password = (void (*) (GMountOperation*, const gchar*, const gchar*, const gchar*, GAskPasswordFlags)) mount_operation_assistant_real_ask_password;
	((GMountOperationClass *) klass)->ask_question = (void (*) (GMountOperation*, const gchar*, gchar**)) mount_operation_assistant_real_ask_question;
	G_OBJECT_CLASS (klass)->get_property = _vala_mount_operation_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mount_operation_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = mount_operation_assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = mount_operation_assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY] = g_param_spec_string ("label-help", "label-help", "label-help", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY] = g_param_spec_string ("label-username", "label-username", "label-username", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY] = g_param_spec_string ("label-password", "label-password", "label-password", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY] = g_param_spec_string ("label-remember-password", "label-remember-password", "label-remember-password", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY] = g_param_spec_boolean ("go-forward", "go-forward", "go-forward", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY, mount_operation_assistant_properties[MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY] = g_param_spec_boolean ("retry-mode", "retry-mode", "retry-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
mount_operation_assistant_instance_init (MountOperationAssistant * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = mount_operation_assistant_get_instance_private (self);
	_tmp0_ = g_strdup (_ ("_Username"));
	self->priv->_label_username = _tmp0_;
	_tmp1_ = g_strdup (_ ("_Password"));
	self->priv->_label_password = _tmp1_;
	_tmp2_ = g_strdup (_ ("_Remember password"));
	self->priv->_label_remember_password = _tmp2_;
	self->priv->_go_forward = FALSE;
	self->priv->_retry_mode = FALSE;
}

static void
mount_operation_assistant_finalize (GObject * obj)
{
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	_g_free0 (self->priv->_label_help);
	_g_free0 (self->priv->_label_username);
	_g_free0 (self->priv->_label_password);
	_g_free0 (self->priv->_label_remember_password);
	_g_object_unref0 (self->priv->password_page);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->anonymous_w);
	_g_object_unref0 (self->priv->remember_w);
	_g_object_unref0 (self->priv->username_w);
	_g_object_unref0 (self->priv->domain_w);
	_g_object_unref0 (self->priv->password_w);
	_g_main_loop_unref0 (self->priv->loop);
	G_OBJECT_CLASS (mount_operation_assistant_parent_class)->finalize (obj);
}

/**
 * This class can be used by backends in one of two ways:
 * 1) Traditional way, by having this ask the user for info and then sending
 *    a reply signal.
 * 2) Or by driving the authentication themselves in some secret way.  If so,
 *    they will ask for a button to be shown to start the authentication.
 *    When they are done, they will set the 'go_forward' property to true.
 *    This was used by the U1 backend.
 */
 G_GNUC_NO_INLINE static GType
mount_operation_assistant_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MountOperationAssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_operation_assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountOperationAssistant), 0, (GInstanceInitFunc) mount_operation_assistant_instance_init, NULL };
	GType mount_operation_assistant_type_id;
	mount_operation_assistant_type_id = g_type_register_static (g_mount_operation_get_type (), "MountOperationAssistant", &g_define_type_info, 0);
	MountOperationAssistant_private_offset = g_type_add_instance_private (mount_operation_assistant_type_id, sizeof (MountOperationAssistantPrivate));
	return mount_operation_assistant_type_id;
}

GType
mount_operation_assistant_get_type (void)
{
	static gsize mount_operation_assistant_type_id__once = 0;
	if (g_once_init_enter (&mount_operation_assistant_type_id__once)) {
		GType mount_operation_assistant_type_id;
		mount_operation_assistant_type_id = mount_operation_assistant_get_type_once ();
		g_once_init_leave (&mount_operation_assistant_type_id__once, mount_operation_assistant_type_id);
	}
	return mount_operation_assistant_type_id__once;
}

static void
_vala_mount_operation_assistant_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY:
		g_value_set_string (value, mount_operation_assistant_get_label_help (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY:
		g_value_set_string (value, mount_operation_assistant_get_label_username (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY:
		g_value_set_string (value, mount_operation_assistant_get_label_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY:
		g_value_set_string (value, mount_operation_assistant_get_label_remember_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY:
		g_value_set_boolean (value, mount_operation_assistant_get_go_forward (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY:
		g_value_set_boolean (value, mount_operation_assistant_get_retry_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mount_operation_assistant_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	MountOperationAssistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP_PROPERTY:
		mount_operation_assistant_set_label_help (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME_PROPERTY:
		mount_operation_assistant_set_label_username (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD_PROPERTY:
		mount_operation_assistant_set_label_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD_PROPERTY:
		mount_operation_assistant_set_label_remember_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD_PROPERTY:
		mount_operation_assistant_set_go_forward (self, g_value_get_boolean (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_RETRY_MODE_PROPERTY:
		mount_operation_assistant_set_retry_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

