/* ConfigLocationRow.c generated by valac 0.56.14, the Vala compiler
 * generated from ConfigLocationRow.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include "deja.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONFIG_LOCATION_ROW (config_location_row_get_type ())
#define CONFIG_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow))
#define CONFIG_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_LOCATION_ROW, ConfigLocationRowClass))
#define IS_CONFIG_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_LOCATION_ROW))
#define IS_CONFIG_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_LOCATION_ROW))
#define CONFIG_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_LOCATION_ROW, ConfigLocationRowClass))

typedef struct _ConfigLocationRow ConfigLocationRow;
typedef struct _ConfigLocationRowClass ConfigLocationRowClass;
typedef struct _ConfigLocationRowPrivate ConfigLocationRowPrivate;
enum  {
	CONFIG_LOCATION_ROW_0_PROPERTY,
	CONFIG_LOCATION_ROW_SETTINGS_PROPERTY,
	CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY,
	CONFIG_LOCATION_ROW_NUM_PROPERTIES
};
static GParamSpec* config_location_row_properties[CONFIG_LOCATION_ROW_NUM_PROPERTIES];
typedef enum  {
	CONFIG_LOCATION_ROW_GROUP_CLOUD,
	CONFIG_LOCATION_ROW_GROUP_REMOTE,
	CONFIG_LOCATION_ROW_GROUP_VOLUMES,
	CONFIG_LOCATION_ROW_GROUP_LOCAL
} ConfigLocationRowGroup;

#define CONFIG_LOCATION_ROW_TYPE_GROUP (config_location_row_group_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONFIG_LOCATION_ROW_TYPE_ITEM (config_location_row_item_get_type ())
#define CONFIG_LOCATION_ROW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem))
#define CONFIG_LOCATION_ROW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItemClass))
#define CONFIG_LOCATION_ROW_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_LOCATION_ROW_TYPE_ITEM))
#define CONFIG_LOCATION_ROW_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_LOCATION_ROW_TYPE_ITEM))
#define CONFIG_LOCATION_ROW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItemClass))

typedef struct _ConfigLocationRowItem ConfigLocationRowItem;
typedef struct _ConfigLocationRowItemClass ConfigLocationRowItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConfigLocationRowItemPrivate ConfigLocationRowItemPrivate;
enum  {
	CONFIG_LOCATION_ROW_ITEM_0_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY,
	CONFIG_LOCATION_ROW_ITEM_NUM_PROPERTIES
};
static GParamSpec* config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_NUM_PROPERTIES];

struct _ConfigLocationRow {
	AdwComboRow parent_instance;
	ConfigLocationRowPrivate * priv;
};

struct _ConfigLocationRowClass {
	AdwComboRowClass parent_class;
};

struct _ConfigLocationRowPrivate {
	DejaDupFilteredSettings* _settings;
	DejaDupFilteredSettings* _drive_settings;
	GListStore* store;
};

struct _ConfigLocationRowItem {
	GObject parent_instance;
	ConfigLocationRowItemPrivate * priv;
};

struct _ConfigLocationRowItemClass {
	GObjectClass parent_class;
};

struct _ConfigLocationRowItemPrivate {
	GIcon* _icon;
	gchar* _text;
	gchar* _sort_key;
	gchar* _id;
	gchar* _page;
	DejaDupBackendKind _backend_kind;
};

static gint ConfigLocationRow_private_offset;
static gpointer config_location_row_parent_class = NULL;
static gint ConfigLocationRowItem_private_offset;
static gpointer config_location_row_item_parent_class = NULL;

VALA_EXTERN GType config_location_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigLocationRow, g_object_unref)
static GType config_location_row_group_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN void config_location_row_setup (ConfigLocationRow* self,
                                DejaDupFilteredSettings* settings,
                                DejaDupFilteredSettings* drive_settings);
static void config_location_row_set_settings (ConfigLocationRow* self,
                                       DejaDupFilteredSettings* value);
static void config_location_row_set_drive_settings (ConfigLocationRow* self,
                                             DejaDupFilteredSettings* value);
static void config_location_row_add_entry (ConfigLocationRow* self,
                                    const gchar* id,
                                    const gchar* icon,
                                    const gchar* label,
                                    ConfigLocationRowGroup group,
                                    DejaDupBackendKind kind);
static void config_location_row_handle_drive_uuid_change (ConfigLocationRow* self);
static void _config_location_row_handle_drive_uuid_change_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void config_location_row_add_volume (ConfigLocationRow* self,
                                     GVolumeMonitor* monitor,
                                     GVolume* v);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static guint config_location_row_add_saved_volume (ConfigLocationRow* self);
static void _config_location_row_add_volume_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self);
static void config_location_row_update_volume (ConfigLocationRow* self,
                                        GVolumeMonitor* monitor,
                                        GVolume* v);
static void _config_location_row_update_volume_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                         GVolume* volume,
                                                                         gpointer self);
static void config_location_row_remove_volume (ConfigLocationRow* self,
                                        GVolumeMonitor* monitor,
                                        GVolume* v);
static void _config_location_row_remove_volume_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                         GVolume* volume,
                                                                         gpointer self);
static gboolean config_location_row_get_mapping (GValue* val,
                                          GVariant* variant,
                                          void* data);
static gboolean _config_location_row_get_mapping_gsettings_bind_get_mapping (GValue* value,
                                                                      GVariant* variant,
                                                                      void* user_data);
static GVariant* config_location_row_set_mapping (GValue* val,
                                           const GVariantType* expected_type,
                                           void* data);
static GVariant* _config_location_row_set_mapping_gsettings_bind_set_mapping (GValue* value,
                                                                       const GVariantType* expected_type,
                                                                       void* user_data);
static void _g_object_unref_gdestroy_notify (void* data);
VALA_EXTERN DejaDupFilteredSettings* config_location_row_get_settings (ConfigLocationRow* self);
static guint config_location_row_add_entry_full (ConfigLocationRow* self,
                                          const gchar* id,
                                          GIcon* icon,
                                          const gchar* label,
                                          ConfigLocationRowGroup group,
                                          const gchar* page,
                                          DejaDupBackendKind backend_kind);
VALA_EXTERN GType config_location_row_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigLocationRowItem, g_object_unref)
VALA_EXTERN ConfigLocationRowItem* config_location_row_item_new (GIcon* icon,
                                                     const gchar* text,
                                                     const gchar* sort_key,
                                                     const gchar* id,
                                                     const gchar* page,
                                                     DejaDupBackendKind backend_kind);
VALA_EXTERN ConfigLocationRowItem* config_location_row_item_construct (GType object_type,
                                                           GIcon* icon,
                                                           const gchar* text,
                                                           const gchar* sort_key,
                                                           const gchar* id,
                                                           const gchar* page,
                                                           DejaDupBackendKind backend_kind);
static gint config_location_row_itemcmp (ConfigLocationRowItem* a,
                                  ConfigLocationRowItem* b);
VALA_EXTERN const gchar* config_location_row_item_get_sort_key (ConfigLocationRowItem* self);
static ConfigLocationRowItem* config_location_row_lookup_id (ConfigLocationRow* self,
                                                      const gchar* prefix,
                                                      const gchar* id,
                                                      guint* position);
VALA_EXTERN const gchar* config_location_row_item_get_id (ConfigLocationRowItem* self);
static guint config_location_row_add_volume_full (ConfigLocationRow* self,
                                           const gchar* uuid,
                                           const gchar* name,
                                           GIcon* icon);
static guint config_location_row_update_volume_full (ConfigLocationRow* self,
                                              const gchar* uuid,
                                              const gchar* name,
                                              GIcon* icon);
VALA_EXTERN void config_location_row_item_set_icon (ConfigLocationRowItem* self,
                                        GIcon* value);
VALA_EXTERN void config_location_row_item_set_text (ConfigLocationRowItem* self,
                                        const gchar* value);
static void config_location_row_remove_volume_full (ConfigLocationRow* self,
                                             const gchar* uuid);
VALA_EXTERN DejaDupFilteredSettings* config_location_row_get_drive_settings (ConfigLocationRow* self);
static void config_location_row_set_volume_info (ConfigLocationRow* self,
                                          const gchar* uuid);
VALA_EXTERN ConfigLocationRow* config_location_row_new (void);
VALA_EXTERN ConfigLocationRow* config_location_row_construct (GType object_type);
VALA_EXTERN GIcon* config_location_row_item_get_icon (ConfigLocationRowItem* self);
VALA_EXTERN const gchar* config_location_row_item_get_text (ConfigLocationRowItem* self);
static void config_location_row_item_set_sort_key (ConfigLocationRowItem* self,
                                            const gchar* value);
static void config_location_row_item_set_id (ConfigLocationRowItem* self,
                                      const gchar* value);
VALA_EXTERN const gchar* config_location_row_item_get_page (ConfigLocationRowItem* self);
static void config_location_row_item_set_page (ConfigLocationRowItem* self,
                                        const gchar* value);
VALA_EXTERN DejaDupBackendKind config_location_row_item_get_backend_kind (ConfigLocationRowItem* self);
static void config_location_row_item_set_backend_kind (ConfigLocationRowItem* self,
                                                DejaDupBackendKind value);
static void config_location_row_item_finalize (GObject * obj);
static GType config_location_row_item_get_type_once (void);
static void _vala_config_location_row_item_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_config_location_row_item_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static GObject * config_location_row_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void config_location_row_finalize (GObject * obj);
static GType config_location_row_get_type_once (void);
static void _vala_config_location_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_config_location_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
config_location_row_get_instance_private (ConfigLocationRow* self)
{
	return G_STRUCT_MEMBER_P (self, ConfigLocationRow_private_offset);
}

 G_GNUC_NO_INLINE static GType
config_location_row_group_get_type_once (void)
{
	static const GEnumValue values[] = {{CONFIG_LOCATION_ROW_GROUP_CLOUD, "CONFIG_LOCATION_ROW_GROUP_CLOUD", "cloud"}, {CONFIG_LOCATION_ROW_GROUP_REMOTE, "CONFIG_LOCATION_ROW_GROUP_REMOTE", "remote"}, {CONFIG_LOCATION_ROW_GROUP_VOLUMES, "CONFIG_LOCATION_ROW_GROUP_VOLUMES", "volumes"}, {CONFIG_LOCATION_ROW_GROUP_LOCAL, "CONFIG_LOCATION_ROW_GROUP_LOCAL", "local"}, {0, NULL, NULL}};
	GType config_location_row_group_type_id;
	config_location_row_group_type_id = g_enum_register_static ("ConfigLocationRowGroup", values);
	return config_location_row_group_type_id;
}

static GType
config_location_row_group_get_type (void)
{
	static gsize config_location_row_group_type_id__once = 0;
	if (g_once_init_enter (&config_location_row_group_type_id__once)) {
		GType config_location_row_group_type_id;
		config_location_row_group_type_id = config_location_row_group_get_type_once ();
		g_once_init_leave (&config_location_row_group_type_id__once, config_location_row_group_type_id);
	}
	return config_location_row_group_type_id__once;
}

static void
_config_location_row_handle_drive_uuid_change_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	config_location_row_handle_drive_uuid_change ((ConfigLocationRow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_config_location_row_add_volume_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                               GVolume* volume,
                                                               gpointer self)
{
	config_location_row_add_volume ((ConfigLocationRow*) self, _sender, volume);
}

static void
_config_location_row_update_volume_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self)
{
	config_location_row_update_volume ((ConfigLocationRow*) self, _sender, volume);
}

static void
_config_location_row_remove_volume_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self)
{
	config_location_row_remove_volume ((ConfigLocationRow*) self, _sender, volume);
}

static gboolean
_config_location_row_get_mapping_gsettings_bind_get_mapping (GValue* value,
                                                             GVariant* variant,
                                                             void* user_data)
{
	gboolean result;
	result = config_location_row_get_mapping (value, variant, user_data);
	return result;
}

static GVariant*
_config_location_row_set_mapping_gsettings_bind_set_mapping (GValue* value,
                                                             const GVariantType* expected_type,
                                                             void* user_data)
{
	GVariant* result;
	result = config_location_row_set_mapping (value, expected_type, user_data);
	return result;
}

static void
_g_object_unref_gdestroy_notify (void* data)
{
	g_object_unref (data);
}

void
config_location_row_setup (ConfigLocationRow* self,
                           DejaDupFilteredSettings* settings,
                           DejaDupFilteredSettings* drive_settings)
{
	gchar* _tmp0_;
	GVolumeMonitor* monitor = NULL;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GList* _tmp3_;
	GVolumeMonitor* _tmp7_;
	GVolumeMonitor* _tmp8_;
	GVolumeMonitor* _tmp9_;
	GObject* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (drive_settings != NULL);
	config_location_row_set_settings (self, settings);
	config_location_row_set_drive_settings (self, drive_settings);
	config_location_row_add_entry (self, "google", "deja-dup-google-drive", _ ("Google Drive"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_GOOGLE);
	config_location_row_add_entry (self, "microsoft", "deja-dup-microsoft-onedrive", _ ("Microsoft OneDrive"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_MICROSOFT);
	config_location_row_add_entry (self, "local", "folder", _ ("Local Folder"), CONFIG_LOCATION_ROW_GROUP_LOCAL, DEJA_DUP_BACKEND_KIND_LOCAL);
	config_location_row_add_entry (self, "remote", "network-server", _ ("Network Server"), CONFIG_LOCATION_ROW_GROUP_REMOTE, DEJA_DUP_BACKEND_KIND_GVFS);
	config_location_row_add_entry (self, "gcs", NULL, _ ("Google Cloud Storage"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_UNKNOWN);
	config_location_row_add_entry (self, "openstack", NULL, _ ("OpenStack Swift"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_UNKNOWN);
	config_location_row_add_entry (self, "rackspace", NULL, _ ("Rackspace Cloud Files"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_UNKNOWN);
	config_location_row_add_entry (self, "s3", NULL, _ ("Amazon S3"), CONFIG_LOCATION_ROW_GROUP_CLOUD, DEJA_DUP_BACKEND_KIND_UNKNOWN);
	_tmp0_ = g_strconcat ("notify::", DEJA_DUP_DRIVE_UUID_KEY, NULL);
	g_signal_connect_object ((GObject*) drive_settings, _tmp0_, (GCallback) _config_location_row_handle_drive_uuid_change_g_object_notify, self, 0);
	_g_free0 (_tmp0_);
	_tmp1_ = deja_dup_get_volume_monitor ();
	monitor = _tmp1_;
	_tmp2_ = monitor;
	_tmp3_ = g_volume_monitor_get_volumes (_tmp2_);
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
		v_collection = _tmp3_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* _tmp4_;
			GVolume* v = NULL;
			_tmp4_ = _g_object_ref0 ((GVolume*) v_it->data);
			v = _tmp4_;
			{
				GVolumeMonitor* _tmp5_;
				GVolume* _tmp6_;
				_tmp5_ = monitor;
				_tmp6_ = v;
				config_location_row_add_volume (self, _tmp5_, _tmp6_);
				_g_object_unref0 (v);
			}
		}
		(v_collection == NULL) ? NULL : (v_collection = (_g_list_free__g_object_unref0_ (v_collection), NULL));
	}
	config_location_row_add_saved_volume (self);
	_tmp7_ = monitor;
	g_signal_connect_object (_tmp7_, "volume-added", (GCallback) _config_location_row_add_volume_g_volume_monitor_volume_added, self, 0);
	_tmp8_ = monitor;
	g_signal_connect_object (_tmp8_, "volume-changed", (GCallback) _config_location_row_update_volume_g_volume_monitor_volume_changed, self, 0);
	_tmp9_ = monitor;
	g_signal_connect_object (_tmp9_, "volume-removed", (GCallback) _config_location_row_remove_volume_g_volume_monitor_volume_removed, self, 0);
	_tmp10_ = g_object_ref ((GObject*) self);
	g_settings_bind_with_mapping ((GSettings*) settings, DEJA_DUP_BACKEND_KEY, (GObject*) self, "selected", G_SETTINGS_BIND_DEFAULT, _config_location_row_get_mapping_gsettings_bind_get_mapping, _config_location_row_set_mapping_gsettings_bind_set_mapping, _tmp10_, _g_object_unref_gdestroy_notify);
	_g_object_unref0 (monitor);
}

static void
config_location_row_add_entry (ConfigLocationRow* self,
                               const gchar* id,
                               const gchar* icon,
                               const gchar* label,
                               ConfigLocationRowGroup group,
                               DejaDupBackendKind kind)
{
	gchar* backend_key = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GThemedIcon* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = deja_dup_backend_get_key_name ((GSettings*) _tmp0_);
	backend_key = _tmp1_;
	_tmp3_ = backend_key;
	if (g_strcmp0 (_tmp3_, id) != 0) {
		DejaDupToolPlugin* _tmp4_;
		DejaDupToolPlugin* _tmp5_;
		_tmp4_ = deja_dup_get_tool ();
		_tmp5_ = _tmp4_;
		_tmp2_ = !deja_dup_tool_plugin_supports_backend (_tmp5_, kind, NULL);
		_g_object_unref0 (_tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_free0 (backend_key);
		return;
	}
	if (icon == NULL) {
		_g_object_unref0 (_tmp6_);
		_tmp6_ = NULL;
	} else {
		GThemedIcon* _tmp7_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new (icon);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp7_;
	}
	config_location_row_add_entry_full (self, id, (GIcon*) _tmp6_, label, group, NULL, kind);
	_g_object_unref0 (_tmp6_);
	_g_free0 (backend_key);
}

static guint
config_location_row_add_entry_full (ConfigLocationRow* self,
                                    const gchar* id,
                                    GIcon* icon,
                                    const gchar* label,
                                    ConfigLocationRowGroup group,
                                    const gchar* page,
                                    DejaDupBackendKind backend_kind)
{
	const gchar* _tmp0_ = NULL;
	gchar* calculated_page = NULL;
	gchar* _tmp1_;
	gchar* sort_key = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ConfigLocationRowItem* item = NULL;
	ConfigLocationRowItem* _tmp8_;
	GListStore* _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (id != NULL, 0U);
	g_return_val_if_fail (label != NULL, 0U);
	if (page == NULL) {
		_tmp0_ = id;
	} else {
		_tmp0_ = page;
	}
	_tmp1_ = g_strdup (_tmp0_);
	calculated_page = _tmp1_;
	_tmp2_ = g_utf8_casefold (label, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate_key (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%d%s", (gint) group, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	sort_key = _tmp7_;
	_tmp8_ = config_location_row_item_new (icon, label, sort_key, id, calculated_page, backend_kind);
	item = _tmp8_;
	_tmp9_ = self->priv->store;
	result = g_list_store_insert_sorted (_tmp9_, (GObject*) item, (GCompareDataFunc) config_location_row_itemcmp, NULL);
	_g_object_unref0 (item);
	_g_free0 (sort_key);
	_g_free0 (calculated_page);
	return result;
}

static gint
config_location_row_itemcmp (ConfigLocationRowItem* a,
                             ConfigLocationRowItem* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = config_location_row_item_get_sort_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = config_location_row_item_get_sort_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static ConfigLocationRowItem*
config_location_row_lookup_id (ConfigLocationRow* self,
                               const gchar* prefix,
                               const gchar* id,
                               guint* position)
{
	guint _vala_position = 0U;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* full_id = NULL;
	gchar* _tmp6_;
	ConfigLocationRowItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_position = G_MAXUINT;
	if (prefix != NULL) {
		_tmp1_ = id != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_strconcat (prefix, ":", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, id, NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
		_g_free0 (_tmp3_);
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (id);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	full_id = _tmp6_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GListStore* _tmp9_;
				ConfigLocationRowItem* item = NULL;
				GListStore* _tmp10_;
				GObject* _tmp11_;
				gboolean _tmp12_ = FALSE;
				const gchar* _tmp13_;
				if (!_tmp7_) {
					guint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = self->priv->store;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp9_))) {
					break;
				}
				_tmp10_ = self->priv->store;
				_tmp11_ = g_list_model_get_item ((GListModel*) _tmp10_, i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem);
				_tmp13_ = full_id;
				if (_tmp13_ == NULL) {
					_tmp12_ = TRUE;
				} else {
					ConfigLocationRowItem* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp14_ = item;
					_tmp15_ = config_location_row_item_get_id (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = full_id;
					_tmp12_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
				}
				if (_tmp12_) {
					_vala_position = i;
					result = item;
					_g_free0 (full_id);
					_g_free0 (_tmp0_);
					if (position) {
						*position = _vala_position;
					}
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	_g_free0 (full_id);
	_g_free0 (_tmp0_);
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static void
config_location_row_add_volume (ConfigLocationRow* self,
                                GVolumeMonitor* monitor,
                                GVolume* v)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (v != NULL);
	if (deja_dup_backend_drive_is_allowed_volume (v)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GIcon* _tmp4_;
		GIcon* _tmp5_;
		_tmp0_ = deja_dup_backend_drive_get_uuid (v);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_volume_get_name (v);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_volume_get_icon (v);
		_tmp5_ = _tmp4_;
		config_location_row_add_volume_full (self, _tmp1_, _tmp3_, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
	}
}

static guint
config_location_row_add_volume_full (ConfigLocationRow* self,
                                     const gchar* uuid,
                                     const gchar* name,
                                     GIcon* icon)
{
	guint position = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (uuid != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	g_return_val_if_fail (icon != NULL, 0U);
	position = config_location_row_update_volume_full (self, uuid, name, icon);
	if (position != G_MAXUINT) {
		result = position;
		return result;
	}
	_tmp0_ = g_strconcat ("drive:", uuid, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = config_location_row_add_entry_full (self, _tmp1_, icon, name, CONFIG_LOCATION_ROW_GROUP_VOLUMES, "drive", DEJA_DUP_BACKEND_KIND_LOCAL);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
config_location_row_update_volume (ConfigLocationRow* self,
                                   GVolumeMonitor* monitor,
                                   GVolume* v)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = deja_dup_backend_drive_get_uuid (v);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_volume_get_name (v);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_volume_get_icon (v);
	_tmp5_ = _tmp4_;
	config_location_row_update_volume_full (self, _tmp1_, _tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static guint
config_location_row_update_volume_full (ConfigLocationRow* self,
                                        const gchar* uuid,
                                        const gchar* name,
                                        GIcon* icon)
{
	guint position = 0U;
	ConfigLocationRowItem* item = NULL;
	guint _tmp0_ = 0U;
	ConfigLocationRowItem* _tmp1_;
	ConfigLocationRowItem* _tmp2_;
	ConfigLocationRowItem* _tmp3_;
	ConfigLocationRowItem* _tmp4_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (uuid != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	g_return_val_if_fail (icon != NULL, 0U);
	_tmp1_ = config_location_row_lookup_id (self, "drive", uuid, &_tmp0_);
	position = _tmp0_;
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ == NULL) {
		result = G_MAXUINT;
		_g_object_unref0 (item);
		return result;
	}
	_tmp3_ = item;
	config_location_row_item_set_icon (_tmp3_, icon);
	_tmp4_ = item;
	config_location_row_item_set_text (_tmp4_, name);
	result = position;
	_g_object_unref0 (item);
	return result;
}

static void
config_location_row_remove_volume (ConfigLocationRow* self,
                                   GVolumeMonitor* monitor,
                                   GVolume* v)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = deja_dup_backend_drive_get_uuid (v);
	_tmp1_ = _tmp0_;
	config_location_row_remove_volume_full (self, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
config_location_row_remove_volume_full (ConfigLocationRow* self,
                                        const gchar* uuid)
{
	guint position = 0U;
	ConfigLocationRowItem* item = NULL;
	guint _tmp0_ = 0U;
	ConfigLocationRowItem* _tmp1_;
	ConfigLocationRowItem* _tmp2_;
	gchar* saved_uuid = NULL;
	DejaDupFilteredSettings* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GListStore* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp1_ = config_location_row_lookup_id (self, "drive", uuid, &_tmp0_);
	position = _tmp0_;
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (item);
		return;
	}
	_tmp3_ = self->priv->_drive_settings;
	_tmp4_ = g_settings_get_string ((GSettings*) _tmp3_, DEJA_DUP_DRIVE_UUID_KEY);
	saved_uuid = _tmp4_;
	_tmp5_ = saved_uuid;
	if (g_strcmp0 (uuid, _tmp5_) == 0) {
		_g_free0 (saved_uuid);
		_g_object_unref0 (item);
		return;
	}
	_tmp6_ = self->priv->store;
	g_list_store_remove (_tmp6_, position);
	_g_free0 (saved_uuid);
	_g_object_unref0 (item);
}

static guint
config_location_row_add_saved_volume (ConfigLocationRow* self)
{
	gchar* uuid = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	guint position = 0U;
	ConfigLocationRowItem* item = NULL;
	const gchar* _tmp3_;
	guint _tmp4_ = 0U;
	ConfigLocationRowItem* _tmp5_;
	ConfigLocationRowItem* _tmp6_;
	GIcon* vol_icon = NULL;
	gchar* vol_name = NULL;
	DejaDupFilteredSettings* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GIcon* _tmp20_;
	GError* _inner_error0_ = NULL;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_drive_settings;
	_tmp1_ = g_settings_get_string ((GSettings*) _tmp0_, DEJA_DUP_DRIVE_UUID_KEY);
	uuid = _tmp1_;
	_tmp2_ = uuid;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		result = G_MAXUINT;
		_g_free0 (uuid);
		return result;
	}
	_tmp3_ = uuid;
	_tmp5_ = config_location_row_lookup_id (self, "drive", _tmp3_, &_tmp4_);
	position = _tmp4_;
	item = _tmp5_;
	_tmp6_ = item;
	if (_tmp6_ != NULL) {
		result = position;
		_g_object_unref0 (item);
		_g_free0 (uuid);
		return result;
	}
	vol_icon = NULL;
	{
		gchar* icon_string = NULL;
		DejaDupFilteredSettings* _tmp7_;
		gchar* _tmp8_;
		GIcon* _tmp9_ = NULL;
		const gchar* _tmp10_;
		GIcon* _tmp11_;
		GIcon* _tmp12_;
		_tmp7_ = self->priv->_drive_settings;
		_tmp8_ = g_settings_get_string ((GSettings*) _tmp7_, DEJA_DUP_DRIVE_ICON_KEY);
		icon_string = _tmp8_;
		_tmp10_ = icon_string;
		_tmp11_ = g_icon_new_for_string (_tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (icon_string);
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (vol_icon);
		vol_icon = _tmp12_;
		_g_object_unref0 (_tmp9_);
		_g_free0 (icon_string);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("ConfigLocationRow.vala:205: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint _tmp15_ = 0U;
		_g_object_unref0 (vol_icon);
		_g_object_unref0 (item);
		_g_free0 (uuid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	_tmp16_ = self->priv->_drive_settings;
	_tmp17_ = g_settings_get_string ((GSettings*) _tmp16_, DEJA_DUP_DRIVE_NAME_KEY);
	vol_name = _tmp17_;
	_tmp18_ = uuid;
	_tmp19_ = vol_name;
	_tmp20_ = vol_icon;
	result = config_location_row_add_volume_full (self, _tmp18_, _tmp19_, _tmp20_);
	_g_free0 (vol_name);
	_g_object_unref0 (vol_icon);
	_g_object_unref0 (item);
	_g_free0 (uuid);
	return result;
}

static gboolean
config_location_row_get_mapping (GValue* val,
                                 GVariant* variant,
                                 void* data)
{
	ConfigLocationRow* _self_ = NULL;
	ConfigLocationRow* _tmp0_;
	guint position = 0U;
	gchar* id = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (data, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow));
	_self_ = _tmp0_;
	_tmp1_ = g_variant_get_string (variant, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	id = _tmp2_;
	if (deja_dup_in_demo_mode ()) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("google");
		_g_free0 (id);
		id = _tmp3_;
	}
	_tmp4_ = id;
	if (g_strcmp0 (_tmp4_, "drive") == 0) {
		ConfigLocationRow* _tmp5_;
		_tmp5_ = _self_;
		position = config_location_row_add_saved_volume (_tmp5_);
	} else {
		ConfigLocationRow* _tmp6_;
		const gchar* _tmp7_;
		guint _tmp8_ = 0U;
		ConfigLocationRowItem* _tmp9_;
		ConfigLocationRowItem* _tmp10_;
		_tmp6_ = _self_;
		_tmp7_ = id;
		_tmp9_ = config_location_row_lookup_id (_tmp6_, NULL, _tmp7_, &_tmp8_);
		position = _tmp8_;
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
	}
	if (position == G_MAXUINT) {
		result = FALSE;
		_g_free0 (id);
		_g_object_unref0 (_self_);
		return result;
	}
	g_value_set_uint (val, position);
	result = TRUE;
	_g_free0 (id);
	_g_object_unref0 (_self_);
	return result;
}

static GVariant*
config_location_row_set_mapping (GValue* val,
                                 const GVariantType* expected_type,
                                 void* data)
{
	ConfigLocationRow* _self_ = NULL;
	ConfigLocationRow* _tmp0_;
	guint position = 0U;
	ConfigLocationRowItem* item = NULL;
	ConfigLocationRow* _tmp1_;
	GListStore* _tmp2_;
	GObject* _tmp3_;
	gchar* id = NULL;
	ConfigLocationRowItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** parts = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp20_;
	GVariant* _tmp21_;
	GVariant* result;
	g_return_val_if_fail (val != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (data, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow));
	_self_ = _tmp0_;
	position = g_value_get_uint (val);
	_tmp1_ = _self_;
	_tmp2_ = _tmp1_->priv->store;
	_tmp3_ = g_list_model_get_item ((GListModel*) _tmp2_, position);
	item = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem);
	_tmp4_ = item;
	_tmp5_ = config_location_row_item_get_id (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	id = _tmp7_;
	_tmp8_ = id;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ":", 2);
	parts = _tmp10_;
	parts_length1 = _vala_array_length (_tmp9_);
	_parts_size_ = parts_length1;
	_tmp11_ = parts;
	_tmp11__length1 = parts_length1;
	if (_tmp11__length1 == 2) {
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp12_ = parts;
		_tmp12__length1 = parts_length1;
		_tmp13_ = _tmp12_[0];
		if (g_strcmp0 (_tmp13_, "drive") == 0) {
			ConfigLocationRow* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			_tmp14_ = _self_;
			_tmp15_ = parts;
			_tmp15__length1 = parts_length1;
			_tmp16_ = _tmp15_[1];
			config_location_row_set_volume_info (_tmp14_, _tmp16_);
		}
		_tmp17_ = parts;
		_tmp17__length1 = parts_length1;
		_tmp18_ = _tmp17_[0];
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (id);
		id = _tmp19_;
	}
	_tmp20_ = id;
	_tmp21_ = g_variant_new_string (_tmp20_);
	g_variant_ref_sink (_tmp21_);
	result = _tmp21_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (id);
	_g_object_unref0 (item);
	_g_object_unref0 (_self_);
	return result;
}

static void
config_location_row_handle_drive_uuid_change (ConfigLocationRow* self)
{
	guint position = 0U;
	g_return_if_fail (self != NULL);
	position = config_location_row_add_saved_volume (self);
	if (position != G_MAXUINT) {
		adw_combo_row_set_selected ((AdwComboRow*) self, position);
	}
}

static void
config_location_row_set_volume_info (ConfigLocationRow* self,
                                     const gchar* uuid)
{
	DejaDupFilteredSettings* _tmp0_;
	GVolume* vol = NULL;
	GVolume* _tmp1_;
	GVolume* _tmp2_;
	DejaDupFilteredSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->_drive_settings;
	deja_dup_filtered_settings_set_string (_tmp0_, DEJA_DUP_DRIVE_UUID_KEY, uuid);
	_tmp1_ = deja_dup_backend_drive_find_volume (uuid);
	vol = _tmp1_;
	_tmp2_ = vol;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (vol);
		return;
	}
	_tmp3_ = self->priv->_drive_settings;
	_tmp4_ = deja_dup_filtered_settings_get_read_only (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GVolume* _tmp6_;
		DejaDupFilteredSettings* _tmp7_;
		_tmp6_ = vol;
		_tmp7_ = self->priv->_drive_settings;
		deja_dup_backend_drive_update_volume_info (_tmp6_, (GSettings*) _tmp7_);
	}
	_g_object_unref0 (vol);
}

ConfigLocationRow*
config_location_row_construct (GType object_type)
{
	ConfigLocationRow * self = NULL;
	self = (ConfigLocationRow*) g_object_new (object_type, NULL);
	return self;
}

ConfigLocationRow*
config_location_row_new (void)
{
	return config_location_row_construct (TYPE_CONFIG_LOCATION_ROW);
}

DejaDupFilteredSettings*
config_location_row_get_settings (ConfigLocationRow* self)
{
	DejaDupFilteredSettings* result;
	DejaDupFilteredSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
config_location_row_set_settings (ConfigLocationRow* self,
                                  DejaDupFilteredSettings* value)
{
	DejaDupFilteredSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_get_settings (self);
	if (old_value != value) {
		DejaDupFilteredSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_properties[CONFIG_LOCATION_ROW_SETTINGS_PROPERTY]);
	}
}

DejaDupFilteredSettings*
config_location_row_get_drive_settings (ConfigLocationRow* self)
{
	DejaDupFilteredSettings* result;
	DejaDupFilteredSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drive_settings;
	result = _tmp0_;
	return result;
}

static void
config_location_row_set_drive_settings (ConfigLocationRow* self,
                                        DejaDupFilteredSettings* value)
{
	DejaDupFilteredSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_get_drive_settings (self);
	if (old_value != value) {
		DejaDupFilteredSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drive_settings);
		self->priv->_drive_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_properties[CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY]);
	}
}

static inline gpointer
config_location_row_item_get_instance_private (ConfigLocationRowItem* self)
{
	return G_STRUCT_MEMBER_P (self, ConfigLocationRowItem_private_offset);
}

ConfigLocationRowItem*
config_location_row_item_construct (GType object_type,
                                    GIcon* icon,
                                    const gchar* text,
                                    const gchar* sort_key,
                                    const gchar* id,
                                    const gchar* page,
                                    DejaDupBackendKind backend_kind)
{
	ConfigLocationRowItem * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (sort_key != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	self = (ConfigLocationRowItem*) g_object_new (object_type, "icon", icon, "text", text, "sort-key", sort_key, "id", id, "page", page, "backend-kind", backend_kind, NULL);
	return self;
}

ConfigLocationRowItem*
config_location_row_item_new (GIcon* icon,
                              const gchar* text,
                              const gchar* sort_key,
                              const gchar* id,
                              const gchar* page,
                              DejaDupBackendKind backend_kind)
{
	return config_location_row_item_construct (CONFIG_LOCATION_ROW_TYPE_ITEM, icon, text, sort_key, id, page, backend_kind);
}

GIcon*
config_location_row_item_get_icon (ConfigLocationRowItem* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

void
config_location_row_item_set_icon (ConfigLocationRowItem* self,
                                   GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY]);
	}
}

const gchar*
config_location_row_item_get_text (ConfigLocationRowItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
config_location_row_item_set_text (ConfigLocationRowItem* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY]);
	}
}

const gchar*
config_location_row_item_get_sort_key (ConfigLocationRowItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sort_key;
	result = _tmp0_;
	return result;
}

static void
config_location_row_item_set_sort_key (ConfigLocationRowItem* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_sort_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sort_key);
		self->priv->_sort_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY]);
	}
}

const gchar*
config_location_row_item_get_id (ConfigLocationRowItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
config_location_row_item_set_id (ConfigLocationRowItem* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY]);
	}
}

const gchar*
config_location_row_item_get_page (ConfigLocationRowItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_page;
	result = _tmp0_;
	return result;
}

static void
config_location_row_item_set_page (ConfigLocationRowItem* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_page (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_page);
		self->priv->_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY]);
	}
}

DejaDupBackendKind
config_location_row_item_get_backend_kind (ConfigLocationRowItem* self)
{
	DejaDupBackendKind result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_backend_kind;
	return result;
}

static void
config_location_row_item_set_backend_kind (ConfigLocationRowItem* self,
                                           DejaDupBackendKind value)
{
	DejaDupBackendKind old_value;
	g_return_if_fail (self != NULL);
	old_value = config_location_row_item_get_backend_kind (self);
	if (old_value != value) {
		self->priv->_backend_kind = value;
		g_object_notify_by_pspec ((GObject *) self, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY]);
	}
}

static void
config_location_row_item_class_init (ConfigLocationRowItemClass * klass,
                                     gpointer klass_data)
{
	config_location_row_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConfigLocationRowItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_config_location_row_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_config_location_row_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = config_location_row_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY] = g_param_spec_string ("sort-key", "sort-key", "sort-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY] = g_param_spec_string ("page", "page", "page", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY, config_location_row_item_properties[CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY] = g_param_spec_enum ("backend-kind", "backend-kind", "backend-kind", DEJA_DUP_BACKEND_TYPE_KIND, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
config_location_row_item_instance_init (ConfigLocationRowItem * self,
                                        gpointer klass)
{
	self->priv = config_location_row_item_get_instance_private (self);
}

static void
config_location_row_item_finalize (GObject * obj)
{
	ConfigLocationRowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_sort_key);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_page);
	G_OBJECT_CLASS (config_location_row_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
config_location_row_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigLocationRowItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_location_row_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigLocationRowItem), 0, (GInstanceInitFunc) config_location_row_item_instance_init, NULL };
	GType config_location_row_item_type_id;
	config_location_row_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigLocationRowItem", &g_define_type_info, 0);
	ConfigLocationRowItem_private_offset = g_type_add_instance_private (config_location_row_item_type_id, sizeof (ConfigLocationRowItemPrivate));
	return config_location_row_item_type_id;
}

GType
config_location_row_item_get_type (void)
{
	static gsize config_location_row_item_type_id__once = 0;
	if (g_once_init_enter (&config_location_row_item_type_id__once)) {
		GType config_location_row_item_type_id;
		config_location_row_item_type_id = config_location_row_item_get_type_once ();
		g_once_init_leave (&config_location_row_item_type_id__once, config_location_row_item_type_id);
	}
	return config_location_row_item_type_id__once;
}

static void
_vala_config_location_row_item_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ConfigLocationRowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem);
	switch (property_id) {
		case CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY:
		g_value_set_object (value, config_location_row_item_get_icon (self));
		break;
		case CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY:
		g_value_set_string (value, config_location_row_item_get_text (self));
		break;
		case CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY:
		g_value_set_string (value, config_location_row_item_get_sort_key (self));
		break;
		case CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY:
		g_value_set_string (value, config_location_row_item_get_id (self));
		break;
		case CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY:
		g_value_set_string (value, config_location_row_item_get_page (self));
		break;
		case CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY:
		g_value_set_enum (value, config_location_row_item_get_backend_kind (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_config_location_row_item_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ConfigLocationRowItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONFIG_LOCATION_ROW_TYPE_ITEM, ConfigLocationRowItem);
	switch (property_id) {
		case CONFIG_LOCATION_ROW_ITEM_ICON_PROPERTY:
		config_location_row_item_set_icon (self, g_value_get_object (value));
		break;
		case CONFIG_LOCATION_ROW_ITEM_TEXT_PROPERTY:
		config_location_row_item_set_text (self, g_value_get_string (value));
		break;
		case CONFIG_LOCATION_ROW_ITEM_SORT_KEY_PROPERTY:
		config_location_row_item_set_sort_key (self, g_value_get_string (value));
		break;
		case CONFIG_LOCATION_ROW_ITEM_ID_PROPERTY:
		config_location_row_item_set_id (self, g_value_get_string (value));
		break;
		case CONFIG_LOCATION_ROW_ITEM_PAGE_PROPERTY:
		config_location_row_item_set_page (self, g_value_get_string (value));
		break;
		case CONFIG_LOCATION_ROW_ITEM_BACKEND_KIND_PROPERTY:
		config_location_row_item_set_backend_kind (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
config_location_row_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConfigLocationRow * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	parent_class = G_OBJECT_CLASS (config_location_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow);
	_tmp0_ = g_list_store_new (CONFIG_LOCATION_ROW_TYPE_ITEM);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	_tmp1_ = self->priv->store;
	adw_combo_row_set_model ((AdwComboRow*) self, (GListModel*) _tmp1_);
	return obj;
}

static void
config_location_row_class_init (ConfigLocationRowClass * klass,
                                gpointer klass_data)
{
	config_location_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConfigLocationRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_config_location_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_config_location_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = config_location_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_location_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_SETTINGS_PROPERTY, config_location_row_properties[CONFIG_LOCATION_ROW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", DEJA_DUP_TYPE_FILTERED_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY, config_location_row_properties[CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY] = g_param_spec_object ("drive-settings", "drive-settings", "drive-settings", DEJA_DUP_TYPE_FILTERED_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/ConfigLocationRow.ui");
}

static void
config_location_row_instance_init (ConfigLocationRow * self,
                                   gpointer klass)
{
	self->priv = config_location_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
config_location_row_finalize (GObject * obj)
{
	ConfigLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_drive_settings);
	_g_object_unref0 (self->priv->store);
	G_OBJECT_CLASS (config_location_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
config_location_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConfigLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigLocationRow), 0, (GInstanceInitFunc) config_location_row_instance_init, NULL };
	GType config_location_row_type_id;
	config_location_row_type_id = g_type_register_static (adw_combo_row_get_type (), "ConfigLocationRow", &g_define_type_info, 0);
	ConfigLocationRow_private_offset = g_type_add_instance_private (config_location_row_type_id, sizeof (ConfigLocationRowPrivate));
	return config_location_row_type_id;
}

GType
config_location_row_get_type (void)
{
	static gsize config_location_row_type_id__once = 0;
	if (g_once_init_enter (&config_location_row_type_id__once)) {
		GType config_location_row_type_id;
		config_location_row_type_id = config_location_row_get_type_once ();
		g_once_init_leave (&config_location_row_type_id__once, config_location_row_type_id);
	}
	return config_location_row_type_id__once;
}

static void
_vala_config_location_row_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ConfigLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow);
	switch (property_id) {
		case CONFIG_LOCATION_ROW_SETTINGS_PROPERTY:
		g_value_set_object (value, config_location_row_get_settings (self));
		break;
		case CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY:
		g_value_set_object (value, config_location_row_get_drive_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_config_location_row_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ConfigLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONFIG_LOCATION_ROW, ConfigLocationRow);
	switch (property_id) {
		case CONFIG_LOCATION_ROW_SETTINGS_PROPERTY:
		config_location_row_set_settings (self, g_value_get_object (value));
		break;
		case CONFIG_LOCATION_ROW_DRIVE_SETTINGS_PROPERTY:
		config_location_row_set_drive_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

