/* Browser.c generated by valac 0.56.14, the Vala compiler
 * generated from Browser.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BROWSER (browser_get_type ())
#define BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER, Browser))
#define BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER, BrowserClass))
#define IS_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER))
#define IS_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER))
#define BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER, BrowserClass))

typedef struct _Browser Browser;
typedef struct _BrowserClass BrowserClass;
typedef struct _BrowserPrivate BrowserPrivate;

#define TYPE_DEJA_DUP_APP (deja_dup_app_get_type ())
#define DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEJA_DUP_APP, DejaDupApp))
#define DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEJA_DUP_APP, DejaDupAppClass))
#define IS_DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEJA_DUP_APP))
#define IS_DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEJA_DUP_APP))
#define DEJA_DUP_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEJA_DUP_APP, DejaDupAppClass))

typedef struct _DejaDupApp DejaDupApp;
typedef struct _DejaDupAppClass DejaDupAppClass;

#define TYPE_FILE_STORE (file_store_get_type ())
#define FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_STORE, FileStore))
#define FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_STORE, FileStoreClass))
#define IS_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_STORE))
#define IS_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_STORE))
#define FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_STORE, FileStoreClass))

typedef struct _FileStore FileStore;
typedef struct _FileStoreClass FileStoreClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_TIME_COMBO (time_combo_get_type ())
#define TIME_COMBO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIME_COMBO, TimeCombo))
#define TIME_COMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIME_COMBO, TimeComboClass))
#define IS_TIME_COMBO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIME_COMBO))
#define IS_TIME_COMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIME_COMBO))
#define TIME_COMBO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIME_COMBO, TimeComboClass))

typedef struct _TimeCombo TimeCombo;
typedef struct _TimeComboClass TimeComboClass;
enum  {
	BROWSER_0_PROPERTY,
	BROWSER_TIME_FILLED_PROPERTY,
	BROWSER_FILES_FILLED_PROPERTY,
	BROWSER_HAS_SELECTION_PROPERTY,
	BROWSER_OPERATION_PROPERTY,
	BROWSER_CAN_GO_UP_PROPERTY,
	BROWSER_SEARCH_FILTER_PROPERTY,
	BROWSER_IS_VISIBLE_PAGE_PROPERTY,
	BROWSER_NUM_PROPERTIES
};
static GParamSpec* browser_properties[BROWSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _gtk_bitset_unref0(var) ((var == NULL) ? NULL : (var = (gtk_bitset_unref (var), NULL)))

#define TYPE_PASSPHRASE_DIALOG (passphrase_dialog_get_type ())
#define PASSPHRASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PASSPHRASE_DIALOG, PassphraseDialog))
#define PASSPHRASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PASSPHRASE_DIALOG, PassphraseDialogClass))
#define IS_PASSPHRASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PASSPHRASE_DIALOG))
#define IS_PASSPHRASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PASSPHRASE_DIALOG))
#define PASSPHRASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PASSPHRASE_DIALOG, PassphraseDialogClass))

typedef struct _PassphraseDialog PassphraseDialog;
typedef struct _PassphraseDialogClass PassphraseDialogClass;
typedef struct _BrowserGrapPassphraseAsyncData BrowserGrapPassphraseAsyncData;
typedef struct _BrowserPackagekitInstallData BrowserPackagekitInstallData;
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))
enum  {
	BROWSER_FOLDER_CHANGED_SIGNAL,
	BROWSER_NUM_SIGNALS
};
static guint browser_signals[BROWSER_NUM_SIGNALS] = {0};

struct _Browser {
	GtkGrid parent_instance;
	BrowserPrivate * priv;
};

struct _BrowserClass {
	GtkGridClass parent_class;
};

struct _BrowserPrivate {
	gboolean _time_filled;
	gboolean _files_filled;
	gboolean _has_selection;
	DejaDupOperation* _operation;
	gboolean _can_go_up;
	gchar* _search_filter;
	gboolean _is_visible_page;
	GtkStack* view_stack;
	GtkStack* overlay_stack;
	GtkLabel* auth_label;
	GtkLabel* error_label;
	GtkLabel* pause_label;
	GtkGridView* icon_view;
	GtkColumnView* list_view;
	GtkSpinner* spinner;
	DejaDupApp* application;
	FileStore* store;
	GtkMultiSelection* selection;
	gchar* auth_url;
	GMountOperation* mount_op;
	GMainLoop* passphrase_loop;
	gchar* saved_passphrase;
	MainWindow* app_window;
	TimeCombo* timecombo;
	gboolean operation_blocked;
};

struct _BrowserGrapPassphraseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Browser* self;
	PassphraseDialog* dialog;
	PassphraseDialog* _tmp0_;
	PassphraseDialog* _tmp1_;
	MainWindow* _tmp2_;
	gchar* passphrase;
	PassphraseDialog* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	DejaDupOperation* _tmp6_;
	const gchar* _tmp7_;
	DejaDupOperation* _tmp8_;
	const gchar* _tmp9_;
};

struct _BrowserPackagekitInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	Browser* self;
};

static gint Browser_private_offset;
static gpointer browser_parent_class = NULL;

VALA_EXTERN GType browser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Browser, g_object_unref)
VALA_EXTERN GType deja_dup_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DejaDupApp, g_object_unref)
VALA_EXTERN GType file_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileStore, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType time_combo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeCombo, g_object_unref)
VALA_EXTERN void browser_bind_to_window (Browser* self,
                             MainWindow* win,
                             TimeCombo* combo);
static void browser_maybe_start_operation (Browser* self);
static void _browser_maybe_start_operation_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void __lambda22_ (Browser* self);
VALA_EXTERN gboolean browser_get_time_filled (Browser* self);
static void browser_start_files_operation (Browser* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void browser_selection_changed (Browser* self);
static void browser_set_has_selection (Browser* self,
                                gboolean value);
static void browser_items_changed (Browser* self);
VALA_EXTERN gboolean browser_get_files_filled (Browser* self);
static void browser_update_content_view (Browser* self);
VALA_EXTERN void browser_select_all (Browser* self);
VALA_EXTERN void browser_go_up (Browser* self);
VALA_EXTERN gboolean file_store_go_up (FileStore* self);
static void browser_go_down (Browser* self,
                      guint position);
VALA_EXTERN gboolean file_store_go_down (FileStore* self,
                             guint position);
static void _browser_go_down_gtk_column_view_activate (GtkColumnView* _sender,
                                                guint position,
                                                gpointer self);
VALA_EXTERN const gchar* browser_get_search_filter (Browser* self);
static void browser_switch_overlay_to_empty_search (Browser* self);
static void browser_switch_overlay_off (Browser* self);
static void browser_switch_overlay_to_empty_folder (Browser* self);
static void browser_update_search_filter (Browser* self);
VALA_EXTERN void file_store_set_search_filter (FileStore* self,
                                   const gchar* value);
static void browser_grab_passphrase (Browser* self);
static void browser_grap_passphrase_async (Browser* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void browser_grap_passphrase_finish (Browser* self,
                                     GAsyncResult* _res_);
static void _browser_grab_passphrase_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void browser_grap_passphrase_async_data_free (gpointer _data);
static gboolean browser_grap_passphrase_async_co (BrowserGrapPassphraseAsyncData* _data_);
VALA_EXTERN GType passphrase_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PassphraseDialog, g_object_unref)
VALA_EXTERN PassphraseDialog* passphrase_dialog_new (void);
VALA_EXTERN PassphraseDialog* passphrase_dialog_construct (GType object_type);
VALA_EXTERN void passphrase_dialog_prompt_user (PassphraseDialog* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN gchar* passphrase_dialog_prompt_user_finish (PassphraseDialog* self,
                                             GAsyncResult* _res_);
static void browser_grap_passphrase_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN DejaDupOperation* browser_get_operation (Browser* self);
static void browser_switch_overlay_to_spinner (Browser* self);
static void browser_switch_overlay_to (Browser* self,
                                const gchar* name);
static void browser_switch_overlay_to_error (Browser* self,
                                      const gchar* msg);
static void browser_switch_overlay_to_pause (Browser* self,
                                      const gchar* msg);
static void browser_switch_overlay_to_mount_needed (Browser* self);
static void browser_handle_operation_error (Browser* self,
                                     DejaDupOperation* op,
                                     const gchar* _error_,
                                     const gchar* detail);
static void _browser_handle_operation_error_deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                                     const gchar* errstr,
                                                                     const gchar* detail,
                                                                     gpointer self);
static void browser_switch_overlay_to_oauth_needed (Browser* self,
                                             const gchar* msg,
                                             const gchar* url);
static void browser_switch_overlay_to_passphrase (Browser* self);
static void browser_packagekit_install_data_free (gpointer _data);
static void browser_packagekit_install (Browser* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void browser_packagekit_install_finish (Browser* self,
                                        GAsyncResult* _res_);
static gboolean browser_packagekit_install_co (BrowserPackagekitInstallData* _data_);
static void _browser_packagekit_install_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void browser_start_auth (Browser* self);
static void browser_retry_operation (Browser* self);
static void _browser_start_auth_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self);
VALA_EXTERN void browser_start_restore (Browser* self);
VALA_EXTERN GFile* file_store_get_file (FileStore* self,
                            guint position);
VALA_EXTERN void deja_dup_app_restore_files (DejaDupApp* self,
                                 GList* file_list,
                                 const gchar* when,
                                 DejaDupFileTree* tree);
VALA_EXTERN const gchar* time_combo_get_when (TimeCombo* self);
VALA_EXTERN DejaDupFileTree* file_store_get_tree (FileStore* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void browser_connect_and_begin_operation (Browser* self);
static void __lambda20_ (Browser* self,
                  const gchar* header,
                  const gchar* msg);
static void ___lambda20__deja_dup_backend_pause_op (DejaDupBackend* _sender,
                                             const gchar* header,
                                             const gchar* msg,
                                             gpointer self);
static void __lambda21_ (Browser* self,
                  const gchar* msg,
                  const gchar* url);
static void ___lambda21__deja_dup_backend_show_oauth_consent_page (DejaDupBackend* _sender,
                                                            const gchar* message,
                                                            const gchar* url,
                                                            gpointer self);
static void _browser_switch_overlay_to_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                                   gpointer self);
static void _browser_switch_overlay_to_mount_needed_deja_dup_backend_needed_mount_op (DejaDupBackend* _sender,
                                                                               gpointer self);
static void browser_start_time_operation (Browser* self);
static void browser_stop_operation (Browser* self);
static void browser_set_time_filled (Browser* self,
                              gboolean value);
VALA_EXTERN DejaDupBackend* deja_dup_app_get_restore_backend (DejaDupApp* self);
static void browser_set_operation (Browser* self,
                            DejaDupOperation* value);
static void __lambda18_ (Browser* self,
                  DejaDupOperation* op,
                  gboolean success,
                  gboolean cancelled,
                  const gchar* detail);
static void ___lambda18__deja_dup_operation_done (DejaDupOperation* _sender,
                                           gboolean success,
                                           gboolean cancelled,
                                           const gchar* detail,
                                           gpointer self);
VALA_EXTERN void time_combo_register_operation (TimeCombo* self,
                                    DejaDupOperationStatus* op);
static void browser_set_files_filled (Browser* self,
                               gboolean value);
static void __lambda19_ (Browser* self,
                  DejaDupOperation* op,
                  gboolean success,
                  gboolean cancelled,
                  const gchar* detail);
static void ___lambda19__deja_dup_operation_done (DejaDupOperation* _sender,
                                           gboolean success,
                                           gboolean cancelled,
                                           const gchar* detail,
                                           gpointer self);
VALA_EXTERN void file_store_register_operation (FileStore* self,
                                    DejaDupOperationFiles* op);
static void browser_clear_operation (Browser* self);
VALA_EXTERN void file_store_clear (FileStore* self);
VALA_EXTERN void time_combo_clear (TimeCombo* self);
static gboolean browser_app_window_is_active (Browser* self);
VALA_EXTERN GList* main_window_get_modals (MainWindow* self);
static void _browser_retry_operation_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
VALA_EXTERN gboolean browser_get_is_visible_page (Browser* self);
VALA_EXTERN Browser* browser_new (void);
VALA_EXTERN Browser* browser_construct (GType object_type);
VALA_EXTERN gboolean browser_get_has_selection (Browser* self);
VALA_EXTERN gboolean browser_get_can_go_up (Browser* self);
VALA_EXTERN void browser_set_can_go_up (Browser* self,
                            gboolean value);
VALA_EXTERN void browser_set_search_filter (Browser* self,
                                const gchar* value);
VALA_EXTERN void browser_set_is_visible_page (Browser* self,
                                  gboolean value);
static GObject * browser_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties);
VALA_EXTERN DejaDupApp* deja_dup_app_get_instance (void);
static void _browser___lambda28_ (Browser* self);
static void __browser___lambda28__g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self);
static void _browser___lambda29_ (Browser* self);
static void __browser___lambda29__deja_dup_app_operation_started (DejaDupApp* _sender,
                                                           gpointer self);
VALA_EXTERN FileStore* file_store_new (void);
VALA_EXTERN FileStore* file_store_construct (GType object_type);
static void _browser_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                       guint position,
                                                                       guint n_items,
                                                                       gpointer self);
static void _browser_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                        guint position,
                                                        guint removed,
                                                        guint added,
                                                        gpointer self);
static void _browser_update_search_filter_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _browser_selection_changed_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self);
static void _browser_clear_operation_deja_dup_backend_watcher_changed (DejaDupBackendWatcher* _sender,
                                                                gpointer self);
static void _browser_clear_operation_deja_dup_backend_watcher_new_backup (DejaDupBackendWatcher* _sender,
                                                                   gpointer self);
static void _browser_clear_operation_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
static void _browser___lambda30_ (Browser* self);
static void __browser___lambda30__g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self);
static void browser_finalize (GObject * obj);
static GType browser_get_type_once (void);
static void _vala_browser_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_browser_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);

static inline gpointer
browser_get_instance_private (Browser* self)
{
	return G_STRUCT_MEMBER_P (self, Browser_private_offset);
}

static void
_browser_maybe_start_operation_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	browser_maybe_start_operation ((Browser*) self);
}

static void
__lambda22_ (Browser* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_time_filled;
	if (_tmp0_) {
		browser_start_files_operation (self);
	}
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ ((Browser*) self);
}

void
browser_bind_to_window (Browser* self,
                        MainWindow* win,
                        TimeCombo* combo)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	TimeCombo* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	g_return_if_fail (combo != NULL);
	self->priv->app_window = win;
	_tmp0_ = self->priv->app_window;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::is-active", (GCallback) _browser_maybe_start_operation_g_object_notify, self, 0);
	_tmp1_ = self->priv->app_window;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::visible", (GCallback) _browser_maybe_start_operation_g_object_notify, self, 0);
	self->priv->timecombo = combo;
	_tmp2_ = self->priv->timecombo;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::when", (GCallback) ___lambda22__g_object_notify, self, 0);
	browser_selection_changed (self);
}

static void
browser_selection_changed (Browser* self)
{
	GtkBitset* bitset = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	bitset = _tmp1_;
	browser_set_has_selection (self, !gtk_bitset_is_empty (bitset));
	_gtk_bitset_unref0 (bitset);
}

static void
browser_items_changed (Browser* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_files_filled;
	if (_tmp0_) {
		browser_update_content_view (self);
		browser_selection_changed (self);
	}
}

void
browser_select_all (Browser* self)
{
	GtkMultiSelection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection;
	gtk_selection_model_select_all ((GtkSelectionModel*) _tmp0_);
}

void
browser_go_up (Browser* self)
{
	FileStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	if (file_store_go_up (_tmp0_)) {
		g_signal_emit (self, browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL], 0);
	}
}

static void
browser_go_down (Browser* self,
                 guint position)
{
	FileStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	if (file_store_go_down (_tmp0_, position)) {
		g_signal_emit (self, browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL], 0);
	}
}

static void
_browser_go_down_gtk_column_view_activate (GtkColumnView* _sender,
                                           guint position,
                                           gpointer self)
{
	browser_go_down ((Browser*) self, position);
}

static void
browser_update_content_view (Browser* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_filter;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		GtkStack* _tmp1_;
		GtkGridView* _tmp2_;
		GtkColumnView* _tmp3_;
		GtkMultiSelection* _tmp4_;
		GtkMultiSelection* _tmp5_;
		_tmp1_ = self->priv->view_stack;
		gtk_stack_set_visible_child_name (_tmp1_, "list");
		_tmp2_ = self->priv->icon_view;
		gtk_grid_view_set_model (_tmp2_, NULL);
		_tmp3_ = self->priv->list_view;
		_tmp4_ = self->priv->selection;
		gtk_column_view_set_model (_tmp3_, (GtkSelectionModel*) _tmp4_);
		_tmp5_ = self->priv->selection;
		if (g_list_model_get_n_items ((GListModel*) _tmp5_) == ((guint) 0)) {
			browser_switch_overlay_to_empty_search (self);
		} else {
			browser_switch_overlay_off (self);
		}
	} else {
		GtkStack* _tmp6_;
		GtkColumnView* _tmp7_;
		GtkGridView* _tmp8_;
		GtkMultiSelection* _tmp9_;
		GtkMultiSelection* _tmp10_;
		_tmp6_ = self->priv->view_stack;
		gtk_stack_set_visible_child_name (_tmp6_, "icons");
		_tmp7_ = self->priv->list_view;
		gtk_column_view_set_model (_tmp7_, NULL);
		_tmp8_ = self->priv->icon_view;
		_tmp9_ = self->priv->selection;
		gtk_grid_view_set_model (_tmp8_, (GtkSelectionModel*) _tmp9_);
		_tmp10_ = self->priv->selection;
		if (g_list_model_get_n_items ((GListModel*) _tmp10_) == ((guint) 0)) {
			browser_switch_overlay_to_empty_folder (self);
		} else {
			browser_switch_overlay_off (self);
		}
	}
}

static void
browser_update_search_filter (Browser* self)
{
	FileStore* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	browser_update_content_view (self);
	_tmp0_ = self->priv->store;
	_tmp1_ = self->priv->_search_filter;
	file_store_set_search_filter (_tmp0_, _tmp1_);
}

static void
browser_grab_passphrase (Browser* self)
{
	g_return_if_fail (self != NULL);
	browser_grap_passphrase_async (self, NULL, NULL);
}

static void
_browser_grab_passphrase_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	browser_grab_passphrase ((Browser*) self);
}

static void
browser_grap_passphrase_async_data_free (gpointer _data)
{
	BrowserGrapPassphraseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BrowserGrapPassphraseAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
browser_grap_passphrase_async (Browser* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	BrowserGrapPassphraseAsyncData* _data_;
	Browser* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BrowserGrapPassphraseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, browser_grap_passphrase_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	browser_grap_passphrase_async_co (_data_);
}

static void
browser_grap_passphrase_finish (Browser* self,
                                GAsyncResult* _res_)
{
	BrowserGrapPassphraseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
browser_grap_passphrase_async_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	BrowserGrapPassphraseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	browser_grap_passphrase_async_co (_data_);
}

static gboolean
browser_grap_passphrase_async_co (BrowserGrapPassphraseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = passphrase_dialog_new ();
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	_data_->_tmp2_ = _data_->self->priv->app_window;
	gtk_window_set_transient_for ((GtkWindow*) _data_->_tmp1_, (GtkWindow*) _data_->_tmp2_);
	_data_->_tmp3_ = _data_->dialog;
	_data_->_state_ = 1;
	passphrase_dialog_prompt_user (_data_->_tmp3_, browser_grap_passphrase_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = passphrase_dialog_prompt_user_finish (_data_->_tmp3_, _data_->_res_);
	_data_->passphrase = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->_operation;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->passphrase;
		_data_->_tmp5_ = _data_->_tmp7_ != NULL;
	} else {
		_data_->_tmp5_ = FALSE;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp8_ = _data_->self->priv->_operation;
		_data_->_tmp9_ = _data_->passphrase;
		deja_dup_operation_set_passphrase (_data_->_tmp8_, _data_->_tmp9_);
		browser_switch_overlay_to_spinner (_data_->self);
	}
	_g_free0 (_data_->passphrase);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
browser_switch_overlay_to_spinner (Browser* self)
{
	GtkSpinner* _tmp0_;
	g_return_if_fail (self != NULL);
	browser_switch_overlay_to (self, "spinner");
	_tmp0_ = self->priv->spinner;
	gtk_spinner_set_spinning (_tmp0_, TRUE);
}

static void
browser_switch_overlay_to_error (Browser* self,
                                 const gchar* msg)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->error_label;
	gtk_label_set_label (_tmp0_, msg);
	browser_switch_overlay_to (self, "error");
}

static void
browser_switch_overlay_to_pause (Browser* self,
                                 const gchar* msg)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->pause_label;
	gtk_label_set_label (_tmp0_, msg);
	browser_switch_overlay_to (self, "pause");
}

static void
_browser_handle_operation_error_deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                                const gchar* errstr,
                                                                const gchar* detail,
                                                                gpointer self)
{
	browser_handle_operation_error ((Browser*) self, _sender, errstr, detail);
}

static void
browser_switch_overlay_to_mount_needed (Browser* self)
{
	GtkLabel* _tmp0_;
	DejaDupOperation* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	browser_switch_overlay_to (self, "auth");
	_tmp0_ = self->priv->auth_label;
	gtk_label_set_label (_tmp0_, _ ("Authentication needed"));
	_g_free0 (self->priv->auth_url);
	self->priv->auth_url = NULL;
	_tmp1_ = self->priv->_operation;
	g_signal_parse_name ("raise-error", DEJA_DUP_TYPE_OPERATION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _browser_handle_operation_error_deja_dup_operation_raise_error, self);
}

static void
browser_switch_overlay_to_oauth_needed (Browser* self,
                                        const gchar* msg,
                                        const gchar* url)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (url != NULL);
	browser_switch_overlay_to (self, "auth");
	_tmp0_ = self->priv->auth_label;
	gtk_label_set_label (_tmp0_, msg);
	_tmp1_ = g_strdup (url);
	_g_free0 (self->priv->auth_url);
	self->priv->auth_url = _tmp1_;
}

static void
browser_switch_overlay_to_passphrase (Browser* self)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	browser_switch_overlay_to (self, "passphrase");
	_tmp0_ = self->priv->passphrase_loop;
	g_main_loop_run (_tmp0_);
}

static void
browser_packagekit_install_data_free (gpointer _data)
{
	BrowserPackagekitInstallData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BrowserPackagekitInstallData, _data_);
}

static void
browser_packagekit_install (Browser* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	BrowserPackagekitInstallData* _data_;
	Browser* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BrowserPackagekitInstallData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, browser_packagekit_install_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	browser_packagekit_install_co (_data_);
}

static void
browser_packagekit_install_finish (Browser* self,
                                   GAsyncResult* _res_)
{
	BrowserPackagekitInstallData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
browser_packagekit_install_co (BrowserPackagekitInstallData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_browser_packagekit_install_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	browser_packagekit_install ((Browser*) self, NULL, NULL);
}

static void
browser_switch_overlay_to_empty_folder (Browser* self)
{
	g_return_if_fail (self != NULL);
	browser_switch_overlay_to (self, "empty-folder");
}

static void
browser_switch_overlay_to_empty_search (Browser* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "icons");
	browser_switch_overlay_to (self, "empty-search");
}

static void
browser_switch_overlay_to (Browser* self,
                           const gchar* name)
{
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkSpinner* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->overlay_stack;
	gtk_stack_set_visible_child_name (_tmp0_, name);
	_tmp1_ = self->priv->overlay_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->spinner;
	gtk_spinner_set_spinning (_tmp2_, FALSE);
}

static void
browser_switch_overlay_off (Browser* self)
{
	GtkStack* _tmp0_;
	GtkSpinner* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->overlay_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->spinner;
	gtk_spinner_set_spinning (_tmp1_, FALSE);
}

static void
browser_start_auth (Browser* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->auth_url;
	if (_tmp0_ == NULL) {
		browser_retry_operation (self);
	} else {
		GtkUriLauncher* launcher = NULL;
		const gchar* _tmp1_;
		GtkUriLauncher* _tmp2_;
		GtkUriLauncher* _tmp3_;
		MainWindow* _tmp4_;
		_tmp1_ = self->priv->auth_url;
		_tmp2_ = gtk_uri_launcher_new (_tmp1_);
		launcher = _tmp2_;
		_tmp3_ = launcher;
		_tmp4_ = self->priv->app_window;
		gtk_uri_launcher_launch (_tmp3_, (GtkWindow*) _tmp4_, NULL, NULL, NULL);
		_g_object_unref0 (launcher);
	}
}

static void
_browser_start_auth_gtk_button_clicked (GtkButton* _sender,
                                        gpointer self)
{
	browser_start_auth ((Browser*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
browser_start_restore (Browser* self)
{
	GtkBitset* bitset = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	GtkBitsetIter iter = {0};
	guint position = 0U;
	GtkBitset* _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp4_;
	GList* files = NULL;
	FileStore* _tmp5_;
	GFile* _tmp6_;
	DejaDupApp* _tmp11_;
	GList* _tmp12_;
	TimeCombo* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	FileStore* _tmp16_;
	DejaDupFileTree* _tmp17_;
	DejaDupFileTree* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	bitset = _tmp1_;
	memset (&iter, 0, sizeof (GtkBitsetIter));
	_tmp2_ = bitset;
	_tmp4_ = gtk_bitset_iter_init_first (&iter, _tmp2_, &_tmp3_);
	position = _tmp3_;
	if (!_tmp4_) {
		_gtk_bitset_unref0 (bitset);
		return;
	}
	files = NULL;
	_tmp5_ = self->priv->store;
	_tmp6_ = file_store_get_file (_tmp5_, position);
	files = g_list_append (files, _tmp6_);
	while (TRUE) {
		guint _tmp7_ = 0U;
		gboolean _tmp8_;
		FileStore* _tmp9_;
		GFile* _tmp10_;
		_tmp8_ = gtk_bitset_iter_next (&iter, &_tmp7_);
		position = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = self->priv->store;
		_tmp10_ = file_store_get_file (_tmp9_, position);
		files = g_list_append (files, _tmp10_);
	}
	_tmp11_ = self->priv->application;
	_tmp12_ = files;
	_tmp13_ = self->priv->timecombo;
	_tmp14_ = time_combo_get_when (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->store;
	_tmp17_ = file_store_get_tree (_tmp16_);
	_tmp18_ = _tmp17_;
	deja_dup_app_restore_files (_tmp11_, _tmp12_, _tmp15_, _tmp18_);
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_gtk_bitset_unref0 (bitset);
}

static void
browser_handle_operation_error (Browser* self,
                                DejaDupOperation* op,
                                const gchar* _error_,
                                const gchar* detail)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (_error_ != NULL);
	browser_switch_overlay_to_error (self, _error_);
}

static void
__lambda20_ (Browser* self,
             const gchar* header,
             const gchar* msg)
{
	if (msg == NULL) {
		browser_switch_overlay_to_spinner (self);
	} else {
		browser_switch_overlay_to_pause (self, msg);
	}
}

static void
___lambda20__deja_dup_backend_pause_op (DejaDupBackend* _sender,
                                        const gchar* header,
                                        const gchar* msg,
                                        gpointer self)
{
	__lambda20_ ((Browser*) self, header, msg);
}

static void
__lambda21_ (Browser* self,
             const gchar* msg,
             const gchar* url)
{
	if (url == NULL) {
		browser_switch_overlay_to_spinner (self);
	} else {
		browser_switch_overlay_to_oauth_needed (self, msg, url);
	}
}

static void
___lambda21__deja_dup_backend_show_oauth_consent_page (DejaDupBackend* _sender,
                                                       const gchar* message,
                                                       const gchar* url,
                                                       gpointer self)
{
	__lambda21_ ((Browser*) self, message, url);
}

static void
_browser_switch_overlay_to_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                              gpointer self)
{
	browser_switch_overlay_to_passphrase ((Browser*) self);
}

static void
_browser_switch_overlay_to_mount_needed_deja_dup_backend_needed_mount_op (DejaDupBackend* _sender,
                                                                          gpointer self)
{
	browser_switch_overlay_to_mount_needed ((Browser*) self);
}

static void
browser_connect_and_begin_operation (Browser* self)
{
	DejaDupOperation* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupBackend* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupBackend* _tmp4_;
	DejaDupBackend* _tmp5_;
	DejaDupOperation* _tmp6_;
	const gchar* _tmp7_;
	DejaDupOperation* _tmp8_;
	DejaDupOperation* _tmp9_;
	DejaDupBackend* _tmp10_;
	DejaDupBackend* _tmp11_;
	DejaDupOperation* _tmp12_;
	DejaDupBackend* _tmp13_;
	DejaDupBackend* _tmp14_;
	GMountOperation* _tmp15_;
	DejaDupOperation* _tmp16_;
	DejaDupOperation* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_operation;
	_tmp1_ = deja_dup_operation_get_backend (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (_tmp2_, "pause-op", (GCallback) ___lambda20__deja_dup_backend_pause_op, self, 0);
	_tmp3_ = self->priv->_operation;
	_tmp4_ = deja_dup_operation_get_backend (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "show-oauth-consent-page", (GCallback) ___lambda21__deja_dup_backend_show_oauth_consent_page, self, 0);
	_tmp6_ = self->priv->_operation;
	_tmp7_ = self->priv->saved_passphrase;
	deja_dup_operation_set_passphrase (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->_operation;
	g_signal_connect_object (_tmp8_, "passphrase-required", (GCallback) _browser_switch_overlay_to_passphrase_deja_dup_operation_passphrase_required, self, 0);
	_tmp9_ = self->priv->_operation;
	_tmp10_ = deja_dup_operation_get_backend (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "needed-mount-op", (GCallback) _browser_switch_overlay_to_mount_needed_deja_dup_backend_needed_mount_op, self, 0);
	_tmp12_ = self->priv->_operation;
	_tmp13_ = deja_dup_operation_get_backend (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->mount_op;
	deja_dup_backend_set_mount_op (_tmp14_, _tmp15_);
	_g_object_unref0 (self->priv->mount_op);
	self->priv->mount_op = NULL;
	_tmp16_ = self->priv->_operation;
	g_signal_connect_object (_tmp16_, "raise-error", (GCallback) _browser_handle_operation_error_deja_dup_operation_raise_error, self, 0);
	_tmp17_ = self->priv->_operation;
	deja_dup_operation_start (_tmp17_, NULL, NULL);
}

static void
__lambda18_ (Browser* self,
             DejaDupOperation* op,
             gboolean success,
             gboolean cancelled,
             const gchar* detail)
{
	DejaDupOperation* _tmp0_;
	g_return_if_fail (op != NULL);
	_tmp0_ = self->priv->_operation;
	if (op != _tmp0_) {
		return;
	}
	browser_set_operation (self, NULL);
	if (success) {
		DejaDupOperationState* _tmp1_;
		DejaDupOperationState* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		TimeCombo* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = deja_dup_operation_get_state (op);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_->passphrase;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->saved_passphrase);
		self->priv->saved_passphrase = _tmp4_;
		_deja_dup_operation_state_unref0 (_tmp2_);
		_tmp5_ = self->priv->timecombo;
		_tmp6_ = time_combo_get_when (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NULL) {
			browser_switch_overlay_to_error (self, _ ("No backup files found"));
		} else {
			browser_set_time_filled (self, TRUE);
			browser_start_files_operation (self);
		}
	}
}

static void
___lambda18__deja_dup_operation_done (DejaDupOperation* _sender,
                                      gboolean success,
                                      gboolean cancelled,
                                      const gchar* detail,
                                      gpointer self)
{
	__lambda18_ ((Browser*) self, _sender, success, cancelled, detail);
}

static void
browser_start_time_operation (Browser* self)
{
	DejaDupBackend* backend = NULL;
	DejaDupApp* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupOperationStatus* _tmp2_;
	DejaDupOperationStatus* _tmp3_;
	DejaDupOperation* _tmp4_;
	TimeCombo* _tmp5_;
	DejaDupOperation* _tmp6_;
	g_return_if_fail (self != NULL);
	browser_stop_operation (self);
	browser_set_time_filled (self, FALSE);
	_tmp0_ = self->priv->application;
	_tmp1_ = deja_dup_app_get_restore_backend (_tmp0_);
	backend = _tmp1_;
	_tmp2_ = deja_dup_operation_status_new (backend);
	_tmp3_ = _tmp2_;
	browser_set_operation (self, (DejaDupOperation*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_operation;
	g_signal_connect_object (_tmp4_, "done", (GCallback) ___lambda18__deja_dup_operation_done, self, 0);
	_tmp5_ = self->priv->timecombo;
	_tmp6_ = self->priv->_operation;
	time_combo_register_operation (_tmp5_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, DEJA_DUP_TYPE_OPERATION_STATUS) ? ((DejaDupOperationStatus*) _tmp6_) : NULL);
	browser_connect_and_begin_operation (self);
	_g_object_unref0 (backend);
}

static void
__lambda19_ (Browser* self,
             DejaDupOperation* op,
             gboolean success,
             gboolean cancelled,
             const gchar* detail)
{
	DejaDupOperation* _tmp0_;
	g_return_if_fail (op != NULL);
	_tmp0_ = self->priv->_operation;
	if (op != _tmp0_) {
		return;
	}
	browser_set_operation (self, NULL);
	if (success) {
		DejaDupOperationState* _tmp1_;
		DejaDupOperationState* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = deja_dup_operation_get_state (op);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_->passphrase;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->saved_passphrase);
		self->priv->saved_passphrase = _tmp4_;
		_deja_dup_operation_state_unref0 (_tmp2_);
		browser_set_files_filled (self, TRUE);
		browser_update_content_view (self);
	}
}

static void
___lambda19__deja_dup_operation_done (DejaDupOperation* _sender,
                                      gboolean success,
                                      gboolean cancelled,
                                      const gchar* detail,
                                      gpointer self)
{
	__lambda19_ ((Browser*) self, _sender, success, cancelled, detail);
}

static void
browser_start_files_operation (Browser* self)
{
	DejaDupBackend* backend = NULL;
	DejaDupApp* _tmp0_;
	DejaDupBackend* _tmp1_;
	TimeCombo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	DejaDupOperationFiles* _tmp5_;
	DejaDupOperationFiles* _tmp6_;
	DejaDupOperation* _tmp7_;
	FileStore* _tmp8_;
	DejaDupOperation* _tmp9_;
	g_return_if_fail (self != NULL);
	browser_stop_operation (self);
	browser_set_files_filled (self, FALSE);
	g_signal_emit (self, browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL], 0);
	_tmp0_ = self->priv->application;
	_tmp1_ = deja_dup_app_get_restore_backend (_tmp0_);
	backend = _tmp1_;
	_tmp2_ = self->priv->timecombo;
	_tmp3_ = time_combo_get_when (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = deja_dup_operation_files_new (backend, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	browser_set_operation (self, (DejaDupOperation*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_operation;
	g_signal_connect_object (_tmp7_, "done", (GCallback) ___lambda19__deja_dup_operation_done, self, 0);
	_tmp8_ = self->priv->store;
	_tmp9_ = self->priv->_operation;
	file_store_register_operation (_tmp8_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, DEJA_DUP_TYPE_OPERATION_FILES) ? ((DejaDupOperationFiles*) _tmp9_) : NULL);
	browser_connect_and_begin_operation (self);
	_g_object_unref0 (backend);
}

static void
browser_clear_operation (Browser* self)
{
	FileStore* _tmp0_;
	TimeCombo* _tmp1_;
	g_return_if_fail (self != NULL);
	browser_stop_operation (self);
	browser_set_time_filled (self, FALSE);
	browser_set_files_filled (self, FALSE);
	_tmp0_ = self->priv->store;
	file_store_clear (_tmp0_);
	_tmp1_ = self->priv->timecombo;
	time_combo_clear (_tmp1_);
	browser_maybe_start_operation (self);
}

static gboolean
browser_app_window_is_active (Browser* self)
{
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	MainWindow* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	gboolean _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->app_window;
	g_object_get ((GtkWindow*) _tmp1_, "is-active", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		MainWindow* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->app_window;
		_tmp5_ = gtk_widget_get_visible ((GtkWidget*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = self->priv->app_window;
	_tmp8_ = main_window_get_modals (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (_g_list_free__g_object_unref0_ (_tmp9_), NULL));
	if (_tmp10_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
browser_retry_operation (Browser* self)
{
	MainWindow* _tmp0_;
	GtkMountOperation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_window;
	_tmp1_ = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) _tmp0_);
	_g_object_unref0 (self->priv->mount_op);
	self->priv->mount_op = (GMountOperation*) _tmp1_;
	browser_maybe_start_operation (self);
}

static void
_browser_retry_operation_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	browser_retry_operation ((Browser*) self);
}

static void
browser_maybe_start_operation (Browser* self)
{
	DejaDupOperation* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_operation;
	if (_tmp0_ != NULL) {
		return;
	}
	if (self->priv->operation_blocked) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !browser_app_window_is_active (self);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_is_visible_page;
		_tmp1_ = !_tmp3_;
	}
	if (_tmp1_) {
		return;
	}
	_tmp4_ = self->priv->_time_filled;
	if (!_tmp4_) {
		browser_start_time_operation (self);
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_files_filled;
		if (!_tmp5_) {
			browser_start_files_operation (self);
		}
	}
}

static void
browser_stop_operation (Browser* self)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_operation;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_operation;
	deja_dup_operation_cancel (_tmp1_);
	browser_set_operation (self, NULL);
}

Browser*
browser_construct (GType object_type)
{
	Browser * self = NULL;
	self = (Browser*) g_object_new (object_type, NULL);
	return self;
}

Browser*
browser_new (void)
{
	return browser_construct (TYPE_BROWSER);
}

gboolean
browser_get_time_filled (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_time_filled;
	return result;
}

static void
browser_set_time_filled (Browser* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_time_filled (self);
	if (old_value != value) {
		self->priv->_time_filled = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_TIME_FILLED_PROPERTY]);
	}
}

gboolean
browser_get_files_filled (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_files_filled;
	return result;
}

static void
browser_set_files_filled (Browser* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_files_filled (self);
	if (old_value != value) {
		self->priv->_files_filled = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_FILES_FILLED_PROPERTY]);
	}
}

gboolean
browser_get_has_selection (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_selection;
	return result;
}

static void
browser_set_has_selection (Browser* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_has_selection (self);
	if (old_value != value) {
		self->priv->_has_selection = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_HAS_SELECTION_PROPERTY]);
	}
}

DejaDupOperation*
browser_get_operation (Browser* self)
{
	DejaDupOperation* result;
	DejaDupOperation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operation;
	result = _tmp0_;
	return result;
}

static void
browser_set_operation (Browser* self,
                       DejaDupOperation* value)
{
	DejaDupOperation* old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_operation (self);
	if (old_value != value) {
		DejaDupOperation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_operation);
		self->priv->_operation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_OPERATION_PROPERTY]);
	}
}

gboolean
browser_get_can_go_up (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_up;
	return result;
}

void
browser_set_can_go_up (Browser* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_can_go_up (self);
	if (old_value != value) {
		self->priv->_can_go_up = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_CAN_GO_UP_PROPERTY]);
	}
}

const gchar*
browser_get_search_filter (Browser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_filter;
	result = _tmp0_;
	return result;
}

void
browser_set_search_filter (Browser* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_search_filter (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_filter);
		self->priv->_search_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_SEARCH_FILTER_PROPERTY]);
	}
}

gboolean
browser_get_is_visible_page (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_visible_page;
	return result;
}

void
browser_set_is_visible_page (Browser* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_is_visible_page (self);
	if (old_value != value) {
		self->priv->_is_visible_page = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_IS_VISIBLE_PAGE_PROPERTY]);
	}
}

static void
_browser___lambda28_ (Browser* self)
{
	DejaDupOperation* _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = self->priv->_operation;
	if (_tmp0_ != NULL) {
		browser_switch_overlay_to_spinner (self);
	}
	_tmp1_ = self->priv->passphrase_loop;
	g_main_loop_quit (_tmp1_);
}

static void
__browser___lambda28__g_object_notify (GObject* _sender,
                                       GParamSpec* pspec,
                                       gpointer self)
{
	_browser___lambda28_ ((Browser*) self);
}

static void
_browser___lambda29_ (Browser* self)
{
	browser_stop_operation (self);
}

static void
__browser___lambda29__deja_dup_app_operation_started (DejaDupApp* _sender,
                                                      gpointer self)
{
	_browser___lambda29_ ((Browser*) self);
}

static void
_browser_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                  guint position,
                                                                  guint n_items,
                                                                  gpointer self)
{
	browser_selection_changed ((Browser*) self);
}

static void
_browser_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                   guint position,
                                                   guint removed,
                                                   guint added,
                                                   gpointer self)
{
	browser_items_changed ((Browser*) self);
}

static void
_browser_update_search_filter_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	browser_update_search_filter ((Browser*) self);
}

static void
_browser_selection_changed_g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self)
{
	browser_selection_changed ((Browser*) self);
}

static void
_browser_clear_operation_deja_dup_backend_watcher_changed (DejaDupBackendWatcher* _sender,
                                                           gpointer self)
{
	browser_clear_operation ((Browser*) self);
}

static void
_browser_clear_operation_deja_dup_backend_watcher_new_backup (DejaDupBackendWatcher* _sender,
                                                              gpointer self)
{
	browser_clear_operation ((Browser*) self);
}

static void
_browser_clear_operation_g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	browser_clear_operation ((Browser*) self);
}

static void
_browser___lambda30_ (Browser* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->overlay_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "passphrase") != 0) {
		GMainLoop* _tmp3_;
		_tmp3_ = self->priv->passphrase_loop;
		g_main_loop_quit (_tmp3_);
	}
}

static void
__browser___lambda30__g_object_notify (GObject* _sender,
                                       GParamSpec* pspec,
                                       gpointer self)
{
	_browser___lambda30_ ((Browser*) self);
}

static GObject *
browser_constructor (GType type,
                     guint n_construct_properties,
                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Browser * self;
	DejaDupApp* _tmp0_;
	DejaDupApp* _tmp1_;
	FileStore* _tmp2_;
	FileStore* _tmp3_;
	FileStore* _tmp4_;
	GListModel* _tmp5_;
	GtkMultiSelection* _tmp6_;
	GtkMultiSelection* _tmp7_;
	GtkMultiSelection* _tmp8_;
	GtkColumnView* _tmp9_;
	GtkGridView* _tmp10_;
	GtkGridView* _tmp11_;
	GtkMultiSelection* _tmp12_;
	GtkGridView* _tmp13_;
	GtkBuilderListItemFactory* _tmp14_;
	GtkBuilderListItemFactory* _tmp15_;
	DejaDupBackendWatcher* watcher = NULL;
	DejaDupBackendWatcher* _tmp16_;
	DejaDupBackendWatcher* _tmp17_;
	DejaDupBackendWatcher* _tmp18_;
	DejaDupApp* _tmp19_;
	GMainLoop* _tmp20_;
	GtkStack* _tmp21_;
	parent_class = G_OBJECT_CLASS (browser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER, Browser);
	_tmp0_ = deja_dup_app_get_instance ();
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp0_;
	g_signal_connect_object ((GObject*) self, "notify::operation", (GCallback) __browser___lambda28__g_object_notify, self, 0);
	_tmp1_ = self->priv->application;
	g_signal_connect_object (_tmp1_, "operation-started", (GCallback) __browser___lambda29__deja_dup_app_operation_started, self, 0);
	_tmp2_ = file_store_new ();
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp2_;
	_tmp3_ = self->priv->store;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "can-go-up", (GObject*) self, "can-go-up", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = self->priv->store;
	_tmp5_ = _g_object_ref0 ((GListModel*) _tmp4_);
	_tmp6_ = gtk_multi_selection_new (_tmp5_);
	_g_object_unref0 (self->priv->selection);
	self->priv->selection = _tmp6_;
	_tmp7_ = self->priv->selection;
	g_signal_connect_object ((GtkSelectionModel*) _tmp7_, "selection-changed", (GCallback) _browser_selection_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp8_ = self->priv->selection;
	g_signal_connect_object ((GListModel*) _tmp8_, "items-changed", (GCallback) _browser_items_changed_g_list_model_items_changed, self, 0);
	_tmp9_ = self->priv->list_view;
	g_object_bind_property_with_closures ((GObject*) self, "files-filled", (GObject*) _tmp9_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->icon_view;
	g_object_bind_property_with_closures ((GObject*) self, "files-filled", (GObject*) _tmp10_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->icon_view;
	_tmp12_ = self->priv->selection;
	gtk_grid_view_set_model (_tmp11_, (GtkSelectionModel*) _tmp12_);
	_tmp13_ = self->priv->icon_view;
	_tmp14_ = (GtkBuilderListItemFactory*) gtk_builder_list_item_factory_new_from_resource (NULL, "/org/gnome/DejaDup/BrowserGridItem.ui");
	_tmp15_ = _tmp14_;
	gtk_grid_view_set_factory (_tmp13_, (GtkListItemFactory*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_signal_connect_object ((GObject*) self, "notify::is-visible-page", (GCallback) _browser_maybe_start_operation_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::search-filter", (GCallback) _browser_update_search_filter_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::folder-changed", (GCallback) _browser_selection_changed_g_object_notify, self, 0);
	_tmp16_ = deja_dup_backend_watcher_get_instance ();
	watcher = _tmp16_;
	_tmp17_ = watcher;
	g_signal_connect_object (_tmp17_, "changed", (GCallback) _browser_clear_operation_deja_dup_backend_watcher_changed, self, 0);
	_tmp18_ = watcher;
	g_signal_connect_object (_tmp18_, "new-backup", (GCallback) _browser_clear_operation_deja_dup_backend_watcher_new_backup, self, 0);
	_tmp19_ = self->priv->application;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::custom-backend", (GCallback) _browser_clear_operation_g_object_notify, self, 0);
	_tmp20_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->passphrase_loop);
	self->priv->passphrase_loop = _tmp20_;
	_tmp21_ = self->priv->overlay_stack;
	g_signal_connect_object ((GObject*) _tmp21_, "notify::visible-child-name", (GCallback) __browser___lambda30__g_object_notify, self, 0);
	_g_object_unref0 (watcher);
	return obj;
}

static void
browser_class_init (BrowserClass * klass,
                    gpointer klass_data)
{
	browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Browser_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_browser_set_property;
	G_OBJECT_CLASS (klass)->constructor = browser_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_TIME_FILLED_PROPERTY, browser_properties[BROWSER_TIME_FILLED_PROPERTY] = g_param_spec_boolean ("time-filled", "time-filled", "time-filled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_FILES_FILLED_PROPERTY, browser_properties[BROWSER_FILES_FILLED_PROPERTY] = g_param_spec_boolean ("files-filled", "files-filled", "files-filled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_HAS_SELECTION_PROPERTY, browser_properties[BROWSER_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_OPERATION_PROPERTY, browser_properties[BROWSER_OPERATION_PROPERTY] = g_param_spec_object ("operation", "operation", "operation", DEJA_DUP_TYPE_OPERATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_CAN_GO_UP_PROPERTY, browser_properties[BROWSER_CAN_GO_UP_PROPERTY] = g_param_spec_boolean ("can-go-up", "can-go-up", "can-go-up", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_SEARCH_FILTER_PROPERTY, browser_properties[BROWSER_SEARCH_FILTER_PROPERTY] = g_param_spec_string ("search-filter", "search-filter", "search-filter", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_IS_VISIBLE_PAGE_PROPERTY, browser_properties[BROWSER_IS_VISIBLE_PAGE_PROPERTY] = g_param_spec_boolean ("is-visible-page", "is-visible-page", "is-visible-page", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/Browser.ui");
	browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL] = g_signal_new ("folder-changed", TYPE_BROWSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_stack", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, view_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay_stack", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, overlay_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "auth_label", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, auth_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_label", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, pause_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon_view", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, icon_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_view", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, list_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, spinner));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "go_down", G_CALLBACK(_browser_go_down_gtk_column_view_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "grab_passphrase", G_CALLBACK(_browser_grab_passphrase_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "packagekit_install", G_CALLBACK(_browser_packagekit_install_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_auth", G_CALLBACK(_browser_start_auth_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retry_operation", G_CALLBACK(_browser_retry_operation_gtk_button_clicked));
}

static void
browser_instance_init (Browser * self,
                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = browser_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_search_filter = _tmp0_;
	self->priv->_is_visible_page = FALSE;
	self->priv->operation_blocked = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
browser_finalize (GObject * obj)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER, Browser);
	_g_object_unref0 (self->priv->_operation);
	_g_free0 (self->priv->_search_filter);
	_g_object_unref0 (self->priv->application);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->selection);
	_g_free0 (self->priv->auth_url);
	_g_object_unref0 (self->priv->mount_op);
	_g_main_loop_unref0 (self->priv->passphrase_loop);
	_g_free0 (self->priv->saved_passphrase);
	G_OBJECT_CLASS (browser_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
browser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Browser), 0, (GInstanceInitFunc) browser_instance_init, NULL };
	GType browser_type_id;
	browser_type_id = g_type_register_static (gtk_grid_get_type (), "Browser", &g_define_type_info, 0);
	Browser_private_offset = g_type_add_instance_private (browser_type_id, sizeof (BrowserPrivate));
	return browser_type_id;
}

GType
browser_get_type (void)
{
	static gsize browser_type_id__once = 0;
	if (g_once_init_enter (&browser_type_id__once)) {
		GType browser_type_id;
		browser_type_id = browser_get_type_once ();
		g_once_init_leave (&browser_type_id__once, browser_type_id);
	}
	return browser_type_id__once;
}

static void
_vala_browser_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER, Browser);
	switch (property_id) {
		case BROWSER_TIME_FILLED_PROPERTY:
		g_value_set_boolean (value, browser_get_time_filled (self));
		break;
		case BROWSER_FILES_FILLED_PROPERTY:
		g_value_set_boolean (value, browser_get_files_filled (self));
		break;
		case BROWSER_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, browser_get_has_selection (self));
		break;
		case BROWSER_OPERATION_PROPERTY:
		g_value_set_object (value, browser_get_operation (self));
		break;
		case BROWSER_CAN_GO_UP_PROPERTY:
		g_value_set_boolean (value, browser_get_can_go_up (self));
		break;
		case BROWSER_SEARCH_FILTER_PROPERTY:
		g_value_set_string (value, browser_get_search_filter (self));
		break;
		case BROWSER_IS_VISIBLE_PAGE_PROPERTY:
		g_value_set_boolean (value, browser_get_is_visible_page (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_browser_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER, Browser);
	switch (property_id) {
		case BROWSER_TIME_FILLED_PROPERTY:
		browser_set_time_filled (self, g_value_get_boolean (value));
		break;
		case BROWSER_FILES_FILLED_PROPERTY:
		browser_set_files_filled (self, g_value_get_boolean (value));
		break;
		case BROWSER_HAS_SELECTION_PROPERTY:
		browser_set_has_selection (self, g_value_get_boolean (value));
		break;
		case BROWSER_OPERATION_PROPERTY:
		browser_set_operation (self, g_value_get_object (value));
		break;
		case BROWSER_CAN_GO_UP_PROPERTY:
		browser_set_can_go_up (self, g_value_get_boolean (value));
		break;
		case BROWSER_SEARCH_FILTER_PROPERTY:
		browser_set_search_filter (self, g_value_get_string (value));
		break;
		case BROWSER_IS_VISIBLE_PAGE_PROPERTY:
		browser_set_is_visible_page (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

