/* AssistantRestore.c generated by valac 0.56.14, the Vala compiler
 * generated from AssistantRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "deja.h"
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;

#define TYPE_TIME_COMBO (time_combo_get_type ())
#define TIME_COMBO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIME_COMBO, TimeCombo))
#define TIME_COMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIME_COMBO, TimeComboClass))
#define IS_TIME_COMBO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIME_COMBO))
#define IS_TIME_COMBO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIME_COMBO))
#define TIME_COMBO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIME_COMBO, TimeComboClass))

typedef struct _TimeCombo TimeCombo;
typedef struct _TimeComboClass TimeComboClass;
enum  {
	ASSISTANT_RESTORE_0_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY,
	ASSISTANT_RESTORE_WHEN_PROPERTY,
	ASSISTANT_RESTORE_TREE_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY,
	ASSISTANT_RESTORE_NUM_PROPERTIES
};
static GParamSpec* assistant_restore_properties[ASSISTANT_RESTORE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

#define TYPE_DEJA_DUP_APP (deja_dup_app_get_type ())
#define DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEJA_DUP_APP, DejaDupApp))
#define DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEJA_DUP_APP, DejaDupAppClass))
#define IS_DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEJA_DUP_APP))
#define IS_DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEJA_DUP_APP))
#define DEJA_DUP_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEJA_DUP_APP, DejaDupAppClass))

typedef struct _DejaDupApp DejaDupApp;
typedef struct _DejaDupAppClass DejaDupAppClass;
typedef struct _Block1Data Block1Data;

#define TYPE_FOLDER_CHOOSER_BUTTON (folder_chooser_button_get_type ())
#define FOLDER_CHOOSER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOLDER_CHOOSER_BUTTON, FolderChooserButton))
#define FOLDER_CHOOSER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOLDER_CHOOSER_BUTTON, FolderChooserButtonClass))
#define IS_FOLDER_CHOOSER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOLDER_CHOOSER_BUTTON))
#define IS_FOLDER_CHOOSER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOLDER_CHOOSER_BUTTON))
#define FOLDER_CHOOSER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOLDER_CHOOSER_BUTTON, FolderChooserButtonClass))

typedef struct _FolderChooserButton FolderChooserButton;
typedef struct _FolderChooserButtonClass FolderChooserButtonClass;
typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
typedef struct _AssistantRestoreCreateOpData AssistantRestoreCreateOpData;
typedef struct _AssistantRestoreDoStatusQueryData AssistantRestoreDoStatusQueryData;
typedef struct _AssistantRestoreDoFilesQueryData AssistantRestoreDoFilesQueryData;
typedef struct _AssistantPageInfoPrivate AssistantPageInfoPrivate;

struct _Assistant {
	AdwWindow parent_instance;
	AssistantPrivate * priv;
	gchar* default_title;
	GtkWidget* forward_button;
	GtkStack* page_box;
	gboolean can_resume;
	GList* first_shown;
	GList* current;
};

struct _AssistantClass {
	AdwWindowClass parent_class;
	void (*set_buttons) (Assistant* self);
	guint (*inhibit) (Assistant* self, GtkApplication* app);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	void (*create_op) (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	DejaDupOperation* (*create_op_finish) (AssistantOperation* self, GAsyncResult* _res_);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	gchar* (*get_apply_text) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
	GList* _restore_files;
	DejaDupOperationState* op_state;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
	void (*status_op_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*files_op_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
};

struct _AssistantRestorePrivate {
	gchar* _restore_location;
	gchar* _when;
	DejaDupFileTree* _tree;
	GtkProgressBar* files_progress_bar;
	guint files_timeout_id;
	GtkProgressBar* status_progress_bar;
	guint status_timeout_id;
	TimeCombo* date_combo;
	AdwEntryRow* cust_entry_row;
	GtkGrid* confirm_table;
	GtkImage* confirm_storage_image;
	GtkLabel* confirm_storage_label;
	GtkLabel* confirm_location_label;
	GtkLabel* confirm_location;
	GtkLabel* confirm_date_label;
	GtkLabel* confirm_date;
	GtkLabel* confirm_files_label;
	GtkBox* confirm_files;
	GtkWidget* status_progress_page;
	GtkWidget* date_page;
	GtkWidget* restore_dest_page;
	GtkGrid* bad_files_grid;
	GtkLabel* bad_files_label;
	GtkWidget* files_progress_page;
	gboolean show_confirm_page;
};

struct _Block1Data {
	int _ref_count_;
	AssistantRestore* self;
	gchar* label;
};

struct _AssistantRestoreCreateOpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantRestore* self;
	DejaDupOperation* result;
	DejaDupBackend* backend;
	DejaDupApp* _tmp0_;
	DejaDupApp* _tmp1_;
	DejaDupBackend* _tmp2_;
	DejaDupBackend* _tmp3_;
	DejaDupOperationRestore* rest_op;
	DejaDupBackend* _tmp4_;
	const gchar* _tmp5_;
	DejaDupFileTree* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	DejaDupOperationRestore* _tmp11_;
	DejaDupOperationRestore* _tmp12_;
	DejaDupOperationState* _tmp13_;
	DejaDupOperationRestore* _tmp14_;
	DejaDupOperationState* _tmp15_;
};

struct _AssistantRestoreDoStatusQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantRestore* self;
	DejaDupOperationStatus* status_op;
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupOperationStatus* _tmp2_;
	DejaDupOperationStatus* _tmp3_;
	DejaDupOperation* _tmp4_;
	TimeCombo* _tmp5_;
	DejaDupOperation* _tmp6_;
};

struct _AssistantRestoreDoFilesQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantRestore* self;
	DejaDupOperationFiles* files_op;
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	DejaDupOperationFiles* _tmp4_;
	DejaDupOperationFiles* _tmp5_;
	DejaDupOperationState* _tmp6_;
	DejaDupOperationFiles* _tmp7_;
	DejaDupOperationState* _tmp8_;
	DejaDupOperationFiles* _tmp9_;
	DejaDupOperation* _tmp10_;
	DejaDupOperationFiles* _tmp11_;
	DejaDupOperationFiles* _tmp12_;
	DejaDupOperationFiles* _tmp13_;
	DejaDupOperation* _tmp14_;
};

struct _AssistantPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AssistantPageInfoPrivate * priv;
	GtkWidget* page;
	gchar* title;
	AssistantType type;
	gchar* forward_text;
};

struct _AssistantPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (AssistantPageInfo *self);
};

static gint AssistantRestore_private_offset;
static gpointer assistant_restore_parent_class = NULL;

VALA_EXTERN GType assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Assistant, g_object_unref)
VALA_EXTERN gpointer assistant_page_info_ref (gpointer instance);
VALA_EXTERN void assistant_page_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* assistant_param_spec_page_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void assistant_value_set_page_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void assistant_value_take_page_info (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer assistant_value_get_page_info (const GValue* value);
VALA_EXTERN GType assistant_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantPageInfo, assistant_page_info_unref)
VALA_EXTERN GType assistant_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantOperation, g_object_unref)
VALA_EXTERN GType assistant_restore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantRestore, g_object_unref)
VALA_EXTERN GType time_combo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeCombo, g_object_unref)
VALA_EXTERN gchar* assistant_operation_get_apply_text (AssistantOperation* self);
VALA_EXTERN void assistant_operation_add_setup_pages (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
VALA_EXTERN void assistant_operation_create_op (AssistantOperation* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN DejaDupOperation* assistant_operation_create_op_finish (AssistantOperation* self,
                                                        GAsyncResult* _res_);
VALA_EXTERN gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
VALA_EXTERN void assistant_restore_status_op_finished (AssistantRestore* self,
                                           DejaDupOperation* op,
                                           gboolean success,
                                           gboolean cancelled,
                                           const gchar* detail);
VALA_EXTERN void assistant_restore_files_op_finished (AssistantRestore* self,
                                          DejaDupOperation* op,
                                          gboolean success,
                                          gboolean cancelled,
                                          const gchar* detail);
VALA_EXTERN void assistant_operation_do_prepare (AssistantOperation* self,
                                     Assistant* assist,
                                     GtkWidget* page);
VALA_EXTERN void assistant_set_buttons (Assistant* self);
VALA_EXTERN void assistant_operation_do_close (AssistantOperation* self);
VALA_EXTERN void assistant_operation_apply_finished (AssistantOperation* self,
                                         DejaDupOperation* op,
                                         gboolean success,
                                         gboolean cancelled,
                                         const gchar* detail);
VALA_EXTERN guint assistant_inhibit (Assistant* self,
                         GtkApplication* app);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN AssistantRestore* assistant_restore_new_with_files (GList* files,
                                                    const gchar* when,
                                                    DejaDupFileTree* tree);
VALA_EXTERN AssistantRestore* assistant_restore_construct_with_files (GType object_type,
                                                          GList* files,
                                                          const gchar* when,
                                                          DejaDupFileTree* tree);
static gchar* assistant_restore_real_get_apply_text (AssistantOperation* base);
static DejaDupBackend* assistant_restore_get_backend (AssistantRestore* self);
VALA_EXTERN GType deja_dup_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DejaDupApp, g_object_unref)
VALA_EXTERN DejaDupApp* deja_dup_app_get_instance (void);
VALA_EXTERN DejaDupBackend* deja_dup_app_get_restore_backend (DejaDupApp* self);
static void assistant_restore_real_add_setup_pages (AssistantOperation* base);
VALA_EXTERN const gchar* assistant_restore_get_when (AssistantRestore* self);
static void assistant_restore_add_status_query_page (AssistantRestore* self);
static void assistant_restore_add_date_page (AssistantRestore* self);
VALA_EXTERN DejaDupFileTree* assistant_restore_get_tree (AssistantRestore* self);
static void assistant_restore_add_files_query_page (AssistantRestore* self);
static void assistant_restore_add_restore_dest_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_status_query_page (AssistantRestore* self);
VALA_EXTERN void deja_dup_set_margins (GtkWidget* w,
                           gint margin);
static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self);
VALA_EXTERN TimeCombo* time_combo_new (void);
VALA_EXTERN TimeCombo* time_combo_construct (GType object_type);
static void assistant_restore_allow_restore_location_forward (AssistantRestore* self,
                                                       gboolean allowed);
VALA_EXTERN void assistant_allow_forward (Assistant* self,
                              gboolean allow);
static void assistant_restore_restore_location_updated (AssistantRestore* self);
VALA_EXTERN const gchar* assistant_restore_get_restore_location (AssistantRestore* self);
VALA_EXTERN GList* restore_file_tester_get_bad_paths (const gchar* prefix,
                                          DejaDupFileTree* tree,
                                          gboolean* all_bad,
                                          GList* files);
VALA_EXTERN GList* assistant_restore_get_restore_files (AssistantRestore* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda24_ (Block1Data* _data1_,
                   const gchar* file);
static void ____lambda24__gfunc (gconstpointer data,
                          gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self);
VALA_EXTERN GType folder_chooser_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FolderChooserButton, g_object_unref)
VALA_EXTERN FolderChooserButton* folder_chooser_button_new (void);
VALA_EXTERN FolderChooserButton* folder_chooser_button_construct (GType object_type);
static void __lambda23_ (AssistantRestore* self,
                  GtkCheckButton* r);
VALA_EXTERN void assistant_restore_set_restore_location (AssistantRestore* self,
                                             const gchar* value);
static void ___lambda23__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void __lambda25_ (AssistantRestore* self,
                  GtkCheckButton* r);
static void ___lambda25__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void __lambda26_ (AssistantRestore* self);
static void ___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void __lambda27_ (AssistantRestore* self,
                  FolderChooserButton* b);
VALA_EXTERN const gchar* folder_chooser_button_get_path (FolderChooserButton* self);
static void ___lambda27__folder_chooser_button_file_selected (FolderChooserButton* _sender,
                                                       gpointer self);
static GtkWidget* assistant_restore_make_files_query_page (AssistantRestore* self);
static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base);
VALA_EXTERN GType assistant_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void assistant_append_page (Assistant* self,
                            GtkWidget* page,
                            AssistantType type,
                            const gchar* forward_text);
VALA_EXTERN void assistant_set_page_title (Assistant* self,
                               GtkWidget* page,
                               const gchar* title);
static gchar* assistant_restore_get_tag (AssistantRestore* self);
VALA_EXTERN const gchar* time_combo_get_when (TimeCombo* self);
static void assistant_restore_real_create_op_data_free (gpointer _data);
static void assistant_restore_real_create_op (AssistantOperation* base,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean assistant_restore_real_create_op_co (AssistantRestoreCreateOpData* _data_);
static gchar* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_restore_real_status_op_finished (AssistantRestore* self,
                                                DejaDupOperation* op,
                                                gboolean success,
                                                gboolean cancelled,
                                                const gchar* detail);
VALA_EXTERN void assistant_operation_show_error (AssistantOperation* self,
                                     const gchar* _error_,
                                     const gchar* detail);
VALA_EXTERN void assistant_go_forward (Assistant* self);
static gboolean assistant_restore_status_pulse (AssistantRestore* self);
static void assistant_restore_do_status_query_data_free (gpointer _data);
VALA_EXTERN void assistant_restore_do_status_query (AssistantRestore* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void assistant_restore_do_status_query_finish (AssistantRestore* self,
                                               GAsyncResult* _res_);
static gboolean assistant_restore_do_status_query_co (AssistantRestoreDoStatusQueryData* _data_);
VALA_EXTERN void assistant_operation_connect_operation (AssistantOperation* self,
                                            DejaDupOperation* operation);
static void _assistant_restore_status_op_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                                    gboolean success,
                                                                    gboolean cancelled,
                                                                    const gchar* detail,
                                                                    gpointer self);
VALA_EXTERN void time_combo_register_operation (TimeCombo* self,
                                    DejaDupOperationStatus* op);
static void assistant_restore_do_status_query_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void assistant_restore_handle_listed_current_files (AssistantRestore* self,
                                                    DejaDupOperationFiles* op,
                                                    DejaDupFileTree* tree);
VALA_EXTERN void assistant_restore_set_tree (AssistantRestore* self,
                                 DejaDupFileTree* value);
static void assistant_restore_real_files_op_finished (AssistantRestore* self,
                                               DejaDupOperation* op,
                                               gboolean success,
                                               gboolean cancelled,
                                               const gchar* detail);
static gboolean assistant_restore_files_pulse (AssistantRestore* self);
static void assistant_restore_do_files_query_data_free (gpointer _data);
VALA_EXTERN void assistant_restore_do_files_query (AssistantRestore* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void assistant_restore_do_files_query_finish (AssistantRestore* self,
                                              GAsyncResult* _res_);
static gboolean assistant_restore_do_files_query_co (AssistantRestoreDoFilesQueryData* _data_);
static void _assistant_restore_files_op_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                                   gboolean success,
                                                                   gboolean cancelled,
                                                                   const gchar* detail,
                                                                   gpointer self);
static void _assistant_restore_handle_listed_current_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender,
                                                                                                   DejaDupFileTree* tree,
                                                                                                   gpointer self);
static void assistant_restore_do_files_query_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void assistant_restore_real_do_prepare (AssistantOperation* base,
                                        Assistant* assist,
                                        GtkWidget* page);
static void assistant_restore_stop_timers (AssistantRestore* self);
VALA_EXTERN GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
VALA_EXTERN gchar* time_combo_get_active_text (TimeCombo* self);
VALA_EXTERN GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
VALA_EXTERN gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
VALA_EXTERN gboolean assistant_get_last_op_was_back (Assistant* self);
VALA_EXTERN void assistant_skip (Assistant* self);
static gboolean _assistant_restore_status_pulse_gsource_func (gpointer self);
VALA_EXTERN void assistant_operation_provide_password (AssistantOperation* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void assistant_operation_provide_password_finish (AssistantOperation* self,
                                                  GAsyncResult* _res_);
static gboolean _assistant_restore_files_pulse_gsource_func (gpointer self);
static void assistant_restore_real_set_buttons (Assistant* base);
static void assistant_restore_real_do_close (AssistantOperation* base);
static void assistant_restore_real_apply_finished (AssistantOperation* base,
                                            DejaDupOperation* op,
                                            gboolean success,
                                            gboolean cancelled,
                                            const gchar* detail);
VALA_EXTERN void notifications_restore_finished (GtkWindow* win,
                                     gboolean success,
                                     gboolean cancelled,
                                     const gchar* detail);
static guint assistant_restore_real_inhibit (Assistant* base,
                                      GtkApplication* app);
VALA_EXTERN AssistantRestore* assistant_restore_new (void);
VALA_EXTERN AssistantRestore* assistant_restore_construct (GType object_type);
VALA_EXTERN AssistantOperation* assistant_operation_construct (GType object_type);
VALA_EXTERN void assistant_restore_set_when (AssistantRestore* self,
                                 const gchar* value);
VALA_EXTERN void assistant_restore_set_restore_files (AssistantRestore* self,
                                          GList* value);
static GObject * assistant_restore_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void assistant_restore_finalize (GObject * obj);
static GType assistant_restore_get_type_once (void);
static void _vala_assistant_restore_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_assistant_restore_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
assistant_restore_get_instance_private (AssistantRestore* self)
{
	return G_STRUCT_MEMBER_P (self, AssistantRestore_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

AssistantRestore*
assistant_restore_construct_with_files (GType object_type,
                                        GList* files,
                                        const gchar* when,
                                        DejaDupFileTree* tree)
{
	AssistantRestore * self = NULL;
	self = (AssistantRestore*) g_object_new (object_type, "restore-files", files, "when", when, "tree", tree, NULL);
	return self;
}

AssistantRestore*
assistant_restore_new_with_files (GList* files,
                                  const gchar* when,
                                  DejaDupFileTree* tree)
{
	return assistant_restore_construct_with_files (TYPE_ASSISTANT_RESTORE, files, when, tree);
}

static gchar*
assistant_restore_real_get_apply_text (AssistantOperation* base)
{
	AssistantRestore * self;
	gchar* _tmp0_;
	gchar* result;
	self = (AssistantRestore*) base;
	_tmp0_ = g_strdup (_ ("_Restore"));
	result = _tmp0_;
	return result;
}

static DejaDupBackend*
assistant_restore_get_backend (AssistantRestore* self)
{
	DejaDupApp* _tmp0_;
	DejaDupApp* _tmp1_;
	DejaDupBackend* _tmp2_;
	DejaDupBackend* _tmp3_;
	DejaDupBackend* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_app_get_restore_backend (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
assistant_restore_real_add_setup_pages (AssistantOperation* base)
{
	AssistantRestore * self;
	const gchar* _tmp0_;
	DejaDupFileTree* _tmp1_;
	self = (AssistantRestore*) base;
	_tmp0_ = self->priv->_when;
	if (_tmp0_ == NULL) {
		assistant_restore_add_status_query_page (self);
		assistant_restore_add_date_page (self);
	} else {
		self->priv->show_confirm_page = FALSE;
	}
	_tmp1_ = self->priv->_tree;
	if (_tmp1_ == NULL) {
		assistant_restore_add_files_query_page (self);
	}
	assistant_restore_add_restore_dest_page (self);
}

static GtkWidget*
assistant_restore_make_status_query_page (AssistantRestore* self)
{
	GtkProgressBar* _tmp0_;
	GtkBox* page = NULL;
	GtkBox* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->status_progress_bar);
	self->priv->status_progress_bar = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp2_ = self->priv->status_progress_bar;
	gtk_box_append (page, (GtkWidget*) _tmp2_);
	result = (GtkWidget*) page;
	return result;
}

static GtkWidget*
assistant_restore_make_date_page (AssistantRestore* self)
{
	TimeCombo* _tmp0_;
	GtkBox* page = NULL;
	GtkBox* _tmp1_;
	TimeCombo* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time_combo_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->date_combo);
	self->priv->date_combo = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp2_ = self->priv->date_combo;
	gtk_box_append (page, (GtkWidget*) _tmp2_);
	result = (GtkWidget*) page;
	return result;
}

static void
assistant_restore_allow_restore_location_forward (AssistantRestore* self,
                                                  gboolean allowed)
{
	g_return_if_fail (self != NULL);
	assistant_allow_forward ((Assistant*) self, allowed);
	if (allowed) {
		AdwEntryRow* _tmp0_;
		_tmp0_ = self->priv->cust_entry_row;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp0_, "error");
	} else {
		AdwEntryRow* _tmp1_;
		_tmp1_ = self->priv->cust_entry_row;
		gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "error");
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AssistantRestore* self;
		self = _data1_->self;
		_g_free0 (_data1_->label);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda24_ (Block1Data* _data1_,
              const gchar* file)
{
	AssistantRestore* self;
	const gchar* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = _data1_->label;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (file);
		_g_free0 (_data1_->label);
		_data1_->label = _tmp1_;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = _data1_->label;
		_tmp3_ = g_strconcat ("\n", file, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
		_g_free0 (_data1_->label);
		_data1_->label = _tmp5_;
		_g_free0 (_tmp4_);
	}
}

static void
____lambda24__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda24_ (self, (const gchar*) data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
assistant_restore_restore_location_updated (AssistantRestore* self)
{
	const gchar* _tmp0_;
	GtkGrid* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean all_bad = FALSE;
	GList* bad_files = NULL;
	const gchar* _tmp5_;
	DejaDupFileTree* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GList* _tmp10_;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_restore_location;
	assistant_restore_allow_restore_location_forward (self, _tmp0_ != NULL);
	_tmp1_ = self->priv->bad_files_grid;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp3_ = self->priv->_restore_location;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		DejaDupFileTree* _tmp4_;
		_tmp4_ = self->priv->_tree;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		return;
	}
	_tmp5_ = self->priv->_restore_location;
	_tmp6_ = self->priv->_tree;
	_tmp7_ = assistant_restore_get_restore_files (self);
	_tmp8_ = _tmp7_;
	_tmp10_ = restore_file_tester_get_bad_paths (_tmp5_, _tmp6_, &_tmp9_, _tmp8_);
	all_bad = _tmp9_;
	bad_files = _tmp10_;
	_tmp11_ = bad_files;
	if (g_list_length (_tmp11_) > ((guint) 0)) {
		Block1Data* _data1_;
		GCompareFunc _tmp12_;
		GList* _tmp13_;
		GtkLabel* _tmp14_;
		const gchar* _tmp15_;
		GtkGrid* _tmp16_;
		gboolean _tmp17_ = FALSE;
		GList* _tmp18_;
		GList* _tmp19_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_data1_->label = NULL;
		_tmp12_ = ((GCompareFunc) g_strcmp0);
		bad_files = g_list_sort (bad_files, _tmp12_);
		_tmp13_ = bad_files;
		g_list_foreach (_tmp13_, ____lambda24__gfunc, _data1_);
		_tmp14_ = self->priv->bad_files_label;
		_tmp15_ = _data1_->label;
		gtk_label_set_label (_tmp14_, _tmp15_);
		_tmp16_ = self->priv->bad_files_grid;
		gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
		_tmp18_ = assistant_restore_get_restore_files (self);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = all_bad;
		}
		if (_tmp17_) {
			assistant_restore_allow_restore_location_forward (self, FALSE);
		}
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	(bad_files == NULL) ? NULL : (bad_files = (_g_list_free__g_free0_ (bad_files), NULL));
}

static void
__lambda23_ (AssistantRestore* self,
             GtkCheckButton* r)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (r != NULL);
	_tmp0_ = gtk_check_button_get_active (r);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		assistant_restore_set_restore_location (self, "/");
		assistant_restore_restore_location_updated (self);
	}
}

static void
___lambda23__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	__lambda23_ ((AssistantRestore*) self, _sender);
}

static void
__lambda25_ (AssistantRestore* self,
             GtkCheckButton* r)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	AdwEntryRow* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (r != NULL);
	_tmp0_ = gtk_check_button_get_active (r);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		AdwEntryRow* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = self->priv->cust_entry_row;
		_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = deja_dup_resolve_user_dir (_tmp4_);
		_tmp6_ = _tmp5_;
		assistant_restore_set_restore_location (self, _tmp6_);
		_g_free0 (_tmp6_);
		assistant_restore_restore_location_updated (self);
	}
	_tmp7_ = self->priv->cust_entry_row;
	_tmp8_ = gtk_check_button_get_active (r);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp9_);
}

static void
___lambda25__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	__lambda25_ ((AssistantRestore*) self, _sender);
}

static void
__lambda26_ (AssistantRestore* self)
{
	AdwEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->cust_entry_row;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_resolve_user_dir (_tmp2_);
	_tmp4_ = _tmp3_;
	assistant_restore_set_restore_location (self, _tmp4_);
	_g_free0 (_tmp4_);
	assistant_restore_restore_location_updated (self);
}

static void
___lambda26__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda26_ ((AssistantRestore*) self);
}

static void
__lambda27_ (AssistantRestore* self,
             FolderChooserButton* b)
{
	AdwEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->cust_entry_row;
	_tmp1_ = folder_chooser_button_get_path (b);
	_tmp2_ = _tmp1_;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, _tmp2_);
}

static void
___lambda27__folder_chooser_button_file_selected (FolderChooserButton* _sender,
                                                  gpointer self)
{
	__lambda27_ ((AssistantRestore*) self, _sender);
}

static GtkWidget*
assistant_restore_make_restore_dest_page (AssistantRestore* self)
{
	AdwActionRow* orig_row = NULL;
	AdwActionRow* _tmp0_;
	GtkCheckButton* orig_radio = NULL;
	GtkCheckButton* _tmp1_;
	AdwActionRow* cust_row = NULL;
	AdwActionRow* _tmp2_;
	GtkCheckButton* cust_radio = NULL;
	GtkCheckButton* _tmp3_;
	AdwEntryRow* _tmp4_;
	FolderChooserButton* open_button = NULL;
	FolderChooserButton* _tmp5_;
	AdwEntryRow* _tmp6_;
	AdwEntryRow* _tmp7_;
	AdwEntryRow* _tmp8_;
	AdwEntryRow* _tmp9_;
	AdwEntryRow* _tmp10_;
	AdwEntryRow* _tmp11_;
	AdwEntryRow* _tmp12_;
	GtkImage* bad_icon = NULL;
	GtkImage* _tmp13_;
	GtkLabel* bad_header = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	AdwPreferencesGroup* group = NULL;
	AdwPreferencesGroup* _tmp30_;
	AdwEntryRow* _tmp31_;
	GtkGrid* _tmp32_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp33_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (AdwActionRow*) adw_action_row_new ();
	g_object_ref_sink (_tmp0_);
	orig_row = _tmp0_;
	_tmp1_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp1_);
	orig_radio = _tmp1_;
	_tmp2_ = (AdwActionRow*) adw_action_row_new ();
	g_object_ref_sink (_tmp2_);
	cust_row = _tmp2_;
	_tmp3_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp3_);
	cust_radio = _tmp3_;
	_tmp4_ = (AdwEntryRow*) adw_entry_row_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->cust_entry_row);
	self->priv->cust_entry_row = _tmp4_;
	_tmp5_ = folder_chooser_button_new ();
	g_object_ref_sink (_tmp5_);
	open_button = _tmp5_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) orig_row, _ ("Restore files to _original locations"));
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) orig_row, TRUE);
	adw_action_row_set_activatable_widget (orig_row, (GtkWidget*) orig_radio);
	adw_action_row_add_prefix (orig_row, (GtkWidget*) orig_radio);
	gtk_check_button_set_active (orig_radio, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) orig_radio, FALSE);
	g_signal_connect_object (orig_radio, "toggled", (GCallback) ___lambda23__gtk_check_button_toggled, self, 0);
	adw_preferences_row_set_title ((AdwPreferencesRow*) cust_row, _ ("Restore to _specific folder"));
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) cust_row, TRUE);
	adw_action_row_set_activatable_widget (cust_row, (GtkWidget*) cust_radio);
	adw_action_row_add_prefix (cust_row, (GtkWidget*) cust_radio);
	gtk_check_button_set_group (cust_radio, orig_radio);
	gtk_widget_set_can_focus ((GtkWidget*) cust_radio, FALSE);
	g_signal_connect_object (cust_radio, "toggled", (GCallback) ___lambda25__gtk_check_button_toggled, self, 0);
	_tmp6_ = self->priv->cust_entry_row;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp6_, _ ("_Folder"));
	_tmp7_ = self->priv->cust_entry_row;
	adw_entry_row_set_input_hints (_tmp7_, GTK_INPUT_HINT_NO_SPELLCHECK);
	_tmp8_ = self->priv->cust_entry_row;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
	_tmp9_ = self->priv->cust_entry_row;
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) _tmp9_, TRUE);
	_tmp10_ = self->priv->cust_entry_row;
	adw_entry_row_set_activates_default (_tmp10_, TRUE);
	_tmp11_ = self->priv->cust_entry_row;
	adw_entry_row_add_suffix (_tmp11_, (GtkWidget*) open_button);
	_tmp12_ = self->priv->cust_entry_row;
	g_signal_connect_object ((GtkEditable*) _tmp12_, "changed", (GCallback) ___lambda26__gtk_editable_changed, self, 0);
	gtk_widget_set_valign ((GtkWidget*) open_button, GTK_ALIGN_CENTER);
	gtk_widget_add_css_class ((GtkWidget*) open_button, "flat");
	g_signal_connect_object (open_button, "file-selected", (GCallback) ___lambda27__folder_chooser_button_file_selected, self, 0);
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning");
	g_object_ref_sink (_tmp13_);
	bad_icon = _tmp13_;
	gtk_widget_set_valign ((GtkWidget*) bad_icon, GTK_ALIGN_START);
	_tmp14_ = (GtkLabel*) gtk_label_new (_ ("Backups does not have permission to restore the following files:"));
	g_object_ref_sink (_tmp14_);
	bad_header = _tmp14_;
	gtk_label_set_xalign (bad_header, (gfloat) 0);
	gtk_label_set_yalign (bad_header, (gfloat) 0);
	gtk_widget_set_valign ((GtkWidget*) bad_header, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) bad_header, TRUE);
	gtk_label_set_wrap (bad_header, TRUE);
	gtk_label_set_wrap_mode (bad_header, PANGO_WRAP_WORD);
	_tmp15_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->bad_files_label);
	self->priv->bad_files_label = _tmp15_;
	_tmp16_ = self->priv->bad_files_label;
	gtk_label_set_xalign (_tmp16_, (gfloat) 0);
	_tmp17_ = self->priv->bad_files_label;
	gtk_label_set_yalign (_tmp17_, (gfloat) 0);
	_tmp18_ = self->priv->bad_files_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	_tmp19_ = self->priv->bad_files_label;
	gtk_label_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->bad_files_grid);
	self->priv->bad_files_grid = _tmp20_;
	_tmp21_ = self->priv->bad_files_grid;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 12);
	_tmp22_ = self->priv->bad_files_grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp22_, 6);
	_tmp23_ = self->priv->bad_files_grid;
	gtk_grid_set_column_spacing (_tmp23_, 6);
	_tmp24_ = self->priv->bad_files_grid;
	gtk_grid_set_row_spacing (_tmp24_, 6);
	_tmp25_ = self->priv->bad_files_grid;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = self->priv->bad_files_grid;
	gtk_grid_attach (_tmp26_, (GtkWidget*) bad_icon, 0, 0, 1, 1);
	_tmp27_ = self->priv->bad_files_grid;
	gtk_grid_attach (_tmp27_, (GtkWidget*) bad_header, 1, 0, 1, 1);
	_tmp28_ = self->priv->bad_files_grid;
	_tmp29_ = self->priv->bad_files_label;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 1, 2, 1);
	_tmp30_ = (AdwPreferencesGroup*) adw_preferences_group_new ();
	g_object_ref_sink (_tmp30_);
	group = _tmp30_;
	deja_dup_set_margins ((GtkWidget*) group, 12);
	adw_preferences_group_add (group, (GtkWidget*) orig_row);
	adw_preferences_group_add (group, (GtkWidget*) cust_row);
	_tmp31_ = self->priv->cust_entry_row;
	adw_preferences_group_add (group, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->bad_files_grid;
	adw_preferences_group_add (group, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp33_);
	scroll = _tmp33_;
	g_object_set (scroll, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_child (scroll, (GtkWidget*) group);
	result = (GtkWidget*) scroll;
	_g_object_unref0 (group);
	_g_object_unref0 (bad_header);
	_g_object_unref0 (bad_icon);
	_g_object_unref0 (open_button);
	_g_object_unref0 (cust_radio);
	_g_object_unref0 (cust_row);
	_g_object_unref0 (orig_radio);
	_g_object_unref0 (orig_row);
	return result;
}

static GtkWidget*
assistant_restore_make_files_query_page (AssistantRestore* self)
{
	GtkProgressBar* _tmp0_;
	GtkBox* page = NULL;
	GtkBox* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->files_progress_bar);
	self->priv->files_progress_bar = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp2_ = self->priv->files_progress_bar;
	gtk_box_append (page, (GtkWidget*) _tmp2_);
	result = (GtkWidget*) page;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
assistant_restore_real_make_confirm_page (AssistantOperation* base)
{
	AssistantRestore * self;
	gint rows = 0;
	GtkWidget* label = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* page = NULL;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkLabel* _tmp6_;
	GtkWidget* _tmp7_;
	GtkImage* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* box = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkImage* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	GtkGrid* _tmp18_;
	GtkWidget* _tmp19_;
	GtkGrid* _tmp20_;
	GtkBox* _tmp21_;
	gint _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkLabel* _tmp30_;
	gint _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkLabel* _tmp39_;
	gint _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkGrid* _tmp43_;
	GtkLabel* _tmp44_;
	gint _tmp45_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp46_;
	GtkScrolledWindow* _tmp47_;
	GtkScrolledWindow* _tmp48_;
	GtkGrid* _tmp49_;
	GtkWidget* result;
	self = (AssistantRestore*) base;
	if (!self->priv->show_confirm_page) {
		result = NULL;
		return result;
	}
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->confirm_table);
	self->priv->confirm_table = _tmp0_;
	_tmp1_ = self->priv->confirm_table;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	gtk_grid_set_row_spacing (_tmp3_, 6);
	_tmp4_ = page;
	gtk_grid_set_column_spacing (_tmp4_, 6);
	_tmp5_ = page;
	deja_dup_set_margins ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Backup location"));
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp6_;
	_tmp7_ = label;
	g_object_set ((GObject*) _tmp7_, "xalign", 1.0f, "yalign", 0.0f, NULL);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("folder");
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->confirm_storage_image);
	self->priv->confirm_storage_image = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->confirm_storage_label);
	self->priv->confirm_storage_label = _tmp9_;
	_tmp10_ = self->priv->confirm_storage_label;
	gtk_label_set_xalign (_tmp10_, (gfloat) 0);
	_tmp11_ = self->priv->confirm_storage_label;
	gtk_label_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp12_);
	box = _tmp12_;
	_tmp13_ = box;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = box;
	_tmp15_ = self->priv->confirm_storage_image;
	gtk_box_append (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = box;
	_tmp17_ = self->priv->confirm_storage_label;
	gtk_box_append (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = page;
	_tmp19_ = label;
	gtk_grid_attach (_tmp18_, _tmp19_, 0, rows, 1, 1);
	_tmp20_ = page;
	_tmp21_ = box;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, rows, 1, 1);
	rows = rows + 1;
	_tmp22_ = rows;
	_tmp23_ = (GtkLabel*) gtk_label_new (_ ("Restore date"));
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->confirm_date_label);
	self->priv->confirm_date_label = _tmp23_;
	_tmp24_ = self->priv->confirm_date_label;
	g_object_set ((GObject*) _tmp24_, "xalign", 1.0f, NULL);
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->confirm_date);
	self->priv->confirm_date = _tmp25_;
	_tmp26_ = self->priv->confirm_date;
	g_object_set ((GObject*) _tmp26_, "xalign", 0.0f, NULL);
	_tmp27_ = page;
	_tmp28_ = self->priv->confirm_date_label;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, rows, 1, 1);
	_tmp29_ = page;
	_tmp30_ = self->priv->confirm_date;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 1, rows, 1, 1);
	rows = rows + 1;
	_tmp31_ = rows;
	_tmp32_ = (GtkLabel*) gtk_label_new (_ ("Restore folder"));
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->confirm_location_label);
	self->priv->confirm_location_label = _tmp32_;
	_tmp33_ = self->priv->confirm_location_label;
	g_object_set ((GObject*) _tmp33_, "xalign", 1.0f, NULL);
	_tmp34_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->confirm_location);
	self->priv->confirm_location = _tmp34_;
	_tmp35_ = self->priv->confirm_location;
	g_object_set ((GObject*) _tmp35_, "xalign", 0.0f, NULL);
	_tmp36_ = page;
	_tmp37_ = self->priv->confirm_location_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 0, rows, 1, 1);
	_tmp38_ = page;
	_tmp39_ = self->priv->confirm_location;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, rows, 1, 1);
	rows = rows + 1;
	_tmp40_ = rows;
	_tmp41_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->confirm_files_label);
	self->priv->confirm_files_label = _tmp41_;
	_tmp42_ = self->priv->confirm_files_label;
	g_object_set ((GObject*) _tmp42_, "xalign", 1.0f, "yalign", 0.0f, NULL);
	_tmp43_ = page;
	_tmp44_ = self->priv->confirm_files_label;
	gtk_grid_attach (_tmp43_, (GtkWidget*) _tmp44_, 0, rows, 1, 1);
	rows = rows + 1;
	_tmp45_ = rows;
	_tmp46_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp46_);
	scroll = _tmp46_;
	_tmp47_ = scroll;
	g_object_set (_tmp47_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp48_ = scroll;
	_tmp49_ = page;
	gtk_scrolled_window_set_child (_tmp48_, (GtkWidget*) _tmp49_);
	result = (GtkWidget*) scroll;
	_g_object_unref0 (box);
	_g_object_unref0 (page);
	_g_object_unref0 (label);
	return result;
}

static void
assistant_restore_add_status_query_page (AssistantRestore* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_status_query_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS, _ ("_Forward"));
	assistant_set_page_title ((Assistant*) self, page, _ ("Checking for Backups…"));
	_tmp1_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->status_progress_page);
	self->priv->status_progress_page = _tmp1_;
	_g_object_unref0 (page);
}

static void
assistant_restore_add_date_page (AssistantRestore* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_date_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL, _ ("_Forward"));
	assistant_set_page_title ((Assistant*) self, page, _ ("Restore From When?"));
	_tmp1_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->date_page);
	self->priv->date_page = _tmp1_;
	_g_object_unref0 (page);
}

static void
assistant_restore_add_restore_dest_page (AssistantRestore* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_restore_dest_page (self);
	page = _tmp0_;
	if (self->priv->show_confirm_page) {
		GtkWidget* _tmp1_;
		_tmp1_ = page;
		assistant_append_page ((Assistant*) self, _tmp1_, ASSISTANT_TYPE_NORMAL, _ ("_Forward"));
	} else {
		GtkWidget* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = page;
		_tmp3_ = assistant_operation_get_apply_text ((AssistantOperation*) self);
		_tmp4_ = _tmp3_;
		assistant_append_page ((Assistant*) self, _tmp2_, ASSISTANT_TYPE_NORMAL, _tmp4_);
		_g_free0 (_tmp4_);
	}
	_tmp5_ = page;
	assistant_set_page_title ((Assistant*) self, _tmp5_, _ ("Restore to Where?"));
	_tmp6_ = page;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->restore_dest_page);
	self->priv->restore_dest_page = _tmp7_;
	_g_object_unref0 (page);
}

static void
assistant_restore_add_files_query_page (AssistantRestore* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_files_query_page (self);
	_g_object_unref0 (self->priv->files_progress_page);
	self->priv->files_progress_page = _tmp0_;
	_tmp1_ = self->priv->files_progress_page;
	assistant_append_page ((Assistant*) self, _tmp1_, ASSISTANT_TYPE_PROGRESS, _ ("_Forward"));
}

static gchar*
assistant_restore_get_tag (AssistantRestore* self)
{
	const gchar* _tmp0_;
	TimeCombo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_when;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_when;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->date_combo;
	_tmp4_ = time_combo_get_when (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	return result;
}

static void
assistant_restore_real_create_op_data_free (gpointer _data)
{
	AssistantRestoreCreateOpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantRestoreCreateOpData, _data_);
}

static void
assistant_restore_real_create_op (AssistantOperation* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AssistantRestore * self;
	AssistantRestoreCreateOpData* _data_;
	AssistantRestore* _tmp0_;
	self = (AssistantRestore*) base;
	_data_ = g_slice_new0 (AssistantRestoreCreateOpData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_restore_real_create_op_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_restore_real_create_op_co (_data_);
}

static DejaDupOperation*
assistant_restore_create_op_finish (AssistantOperation* base,
                                    GAsyncResult* _res_)
{
	DejaDupOperation* result;
	AssistantRestoreCreateOpData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
assistant_restore_real_create_op_co (AssistantRestoreCreateOpData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_app_get_instance ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = deja_dup_app_get_restore_backend (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->backend = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->backend;
	_data_->_tmp5_ = _data_->self->priv->_restore_location;
	_data_->_tmp6_ = _data_->self->priv->_tree;
	_data_->_tmp7_ = assistant_restore_get_tag (_data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = assistant_restore_get_restore_files (_data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = deja_dup_operation_restore_new (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_g_free0 (_data_->_tmp8_);
	_data_->rest_op = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->self->op_state;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->rest_op;
		_data_->_tmp15_ = _data_->self->op_state;
		deja_dup_operation_set_state ((DejaDupOperation*) _data_->_tmp14_, _data_->_tmp15_);
	}
	_data_->result = (DejaDupOperation*) _data_->rest_op;
	_g_object_unref0 (_data_->backend);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
assistant_restore_real_get_progress_file_prefix (AssistantOperation* base)
{
	AssistantRestore * self;
	gchar* _tmp0_;
	gchar* result;
	self = (AssistantRestore*) base;
	_tmp0_ = g_strdup (_ ("Restoring:"));
	result = _tmp0_;
	return result;
}

static void
assistant_restore_real_status_op_finished (AssistantRestore* self,
                                           DejaDupOperation* op,
                                           gboolean success,
                                           gboolean cancelled,
                                           const gchar* detail)
{
	DejaDupOperationState* _tmp0_;
	g_return_if_fail (op != NULL);
	_tmp0_ = deja_dup_operation_get_state (op);
	_deja_dup_operation_state_unref0 (self->op_state);
	self->op_state = _tmp0_;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	if (cancelled) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		if (success) {
			TimeCombo* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = self->priv->date_combo;
			_tmp2_ = time_combo_get_when (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == NULL) {
				assistant_operation_show_error ((AssistantOperation*) self, _ ("No backups to restore"), NULL);
			} else {
				assistant_go_forward ((Assistant*) self);
			}
		}
	}
}

void
assistant_restore_status_op_finished (AssistantRestore* self,
                                      DejaDupOperation* op,
                                      gboolean success,
                                      gboolean cancelled,
                                      const gchar* detail)
{
	AssistantRestoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_RESTORE_GET_CLASS (self);
	if (_klass_->status_op_finished) {
		_klass_->status_op_finished (self, op, success, cancelled, detail);
	}
}

static gboolean
assistant_restore_status_pulse (AssistantRestore* self)
{
	GtkProgressBar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->status_progress_bar;
	gtk_progress_bar_pulse (_tmp0_);
	result = TRUE;
	return result;
}

static void
assistant_restore_do_status_query_data_free (gpointer _data)
{
	AssistantRestoreDoStatusQueryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantRestoreDoStatusQueryData, _data_);
}

void
assistant_restore_do_status_query (AssistantRestore* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AssistantRestoreDoStatusQueryData* _data_;
	AssistantRestore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AssistantRestoreDoStatusQueryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_restore_do_status_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_restore_do_status_query_co (_data_);
}

void
assistant_restore_do_status_query_finish (AssistantRestore* self,
                                          GAsyncResult* _res_)
{
	AssistantRestoreDoStatusQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_assistant_restore_status_op_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                               gboolean success,
                                                               gboolean cancelled,
                                                               const gchar* detail,
                                                               gpointer self)
{
	assistant_restore_status_op_finished ((AssistantRestore*) self, _sender, success, cancelled, detail);
}

static void
assistant_restore_do_status_query_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	AssistantRestoreDoStatusQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_restore_do_status_query_co (_data_);
}

static gboolean
assistant_restore_do_status_query_co (AssistantRestoreDoStatusQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = assistant_restore_get_backend (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = deja_dup_operation_status_new (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->status_op = _data_->_tmp3_;
	_data_->_tmp4_ = _g_object_ref0 ((DejaDupOperation*) _data_->status_op);
	_g_object_unref0 (((AssistantOperation*) _data_->self)->op);
	((AssistantOperation*) _data_->self)->op = _data_->_tmp4_;
	assistant_operation_connect_operation ((AssistantOperation*) _data_->self, (DejaDupOperation*) _data_->status_op);
	g_signal_connect_object ((DejaDupOperation*) _data_->status_op, "done", (GCallback) _assistant_restore_status_op_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp5_ = _data_->self->priv->date_combo;
	time_combo_register_operation (_data_->_tmp5_, _data_->status_op);
	_data_->_tmp6_ = ((AssistantOperation*) _data_->self)->op;
	_data_->_state_ = 1;
	deja_dup_operation_start (_data_->_tmp6_, assistant_restore_do_status_query_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_operation_start_finish (_data_->_tmp6_, _data_->_res_);
	_g_object_unref0 (_data_->status_op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
assistant_restore_handle_listed_current_files (AssistantRestore* self,
                                               DejaDupOperationFiles* op,
                                               DejaDupFileTree* tree)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (tree != NULL);
	assistant_restore_set_tree (self, tree);
}

static void
assistant_restore_real_files_op_finished (AssistantRestore* self,
                                          DejaDupOperation* op,
                                          gboolean success,
                                          gboolean cancelled,
                                          const gchar* detail)
{
	DejaDupOperationState* _tmp0_;
	g_return_if_fail (op != NULL);
	_tmp0_ = deja_dup_operation_get_state (op);
	_deja_dup_operation_state_unref0 (self->op_state);
	self->op_state = _tmp0_;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	if (cancelled) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		if (success) {
			assistant_go_forward ((Assistant*) self);
		}
	}
}

void
assistant_restore_files_op_finished (AssistantRestore* self,
                                     DejaDupOperation* op,
                                     gboolean success,
                                     gboolean cancelled,
                                     const gchar* detail)
{
	AssistantRestoreClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_RESTORE_GET_CLASS (self);
	if (_klass_->files_op_finished) {
		_klass_->files_op_finished (self, op, success, cancelled, detail);
	}
}

static gboolean
assistant_restore_files_pulse (AssistantRestore* self)
{
	GtkProgressBar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->files_progress_bar;
	gtk_progress_bar_pulse (_tmp0_);
	result = TRUE;
	return result;
}

static void
assistant_restore_do_files_query_data_free (gpointer _data)
{
	AssistantRestoreDoFilesQueryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantRestoreDoFilesQueryData, _data_);
}

void
assistant_restore_do_files_query (AssistantRestore* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	AssistantRestoreDoFilesQueryData* _data_;
	AssistantRestore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AssistantRestoreDoFilesQueryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_restore_do_files_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_restore_do_files_query_co (_data_);
}

void
assistant_restore_do_files_query_finish (AssistantRestore* self,
                                         GAsyncResult* _res_)
{
	AssistantRestoreDoFilesQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_assistant_restore_files_op_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                              gboolean success,
                                                              gboolean cancelled,
                                                              const gchar* detail,
                                                              gpointer self)
{
	assistant_restore_files_op_finished ((AssistantRestore*) self, _sender, success, cancelled, detail);
}

static void
_assistant_restore_handle_listed_current_files_deja_dup_operation_files_listed_current_files (DejaDupOperationFiles* _sender,
                                                                                              DejaDupFileTree* tree,
                                                                                              gpointer self)
{
	assistant_restore_handle_listed_current_files ((AssistantRestore*) self, _sender, tree);
}

static void
assistant_restore_do_files_query_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	AssistantRestoreDoFilesQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_restore_do_files_query_co (_data_);
}

static gboolean
assistant_restore_do_files_query_co (AssistantRestoreDoFilesQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = assistant_restore_get_backend (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = assistant_restore_get_tag (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = deja_dup_operation_files_new (_data_->_tmp1_, _data_->_tmp3_, NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp1_);
	_data_->files_op = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->op_state;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->files_op;
		_data_->_tmp8_ = _data_->self->op_state;
		deja_dup_operation_set_state ((DejaDupOperation*) _data_->_tmp7_, _data_->_tmp8_);
	}
	_data_->_tmp9_ = _data_->files_op;
	_data_->_tmp10_ = _g_object_ref0 ((DejaDupOperation*) _data_->_tmp9_);
	_g_object_unref0 (((AssistantOperation*) _data_->self)->op);
	((AssistantOperation*) _data_->self)->op = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->files_op;
	assistant_operation_connect_operation ((AssistantOperation*) _data_->self, (DejaDupOperation*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->files_op;
	g_signal_connect_object ((DejaDupOperation*) _data_->_tmp12_, "done", (GCallback) _assistant_restore_files_op_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp13_ = _data_->files_op;
	g_signal_connect_object (_data_->_tmp13_, "listed-current-files", (GCallback) _assistant_restore_handle_listed_current_files_deja_dup_operation_files_listed_current_files, _data_->self, 0);
	_data_->_tmp14_ = ((AssistantOperation*) _data_->self)->op;
	_data_->_state_ = 1;
	deja_dup_operation_start (_data_->_tmp14_, assistant_restore_do_files_query_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_operation_start_finish (_data_->_tmp14_, _data_->_res_);
	_g_object_unref0 (_data_->files_op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_assistant_restore_status_pulse_gsource_func (gpointer self)
{
	gboolean result;
	result = assistant_restore_status_pulse ((AssistantRestore*) self);
	return result;
}

static gboolean
_assistant_restore_files_pulse_gsource_func (gpointer self)
{
	gboolean result;
	result = assistant_restore_files_pulse ((AssistantRestore*) self);
	return result;
}

static void
assistant_restore_real_do_prepare (AssistantOperation* base,
                                   Assistant* assist,
                                   GtkWidget* page)
{
	AssistantRestore * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = (AssistantRestore*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation), assist, page);
	assistant_restore_stop_timers (self);
	_tmp0_ = assistant_operation_get_confirm_page ((AssistantOperation*) self);
	_tmp1_ = _tmp0_;
	if (page == _tmp1_) {
		DejaDupBackend* backend = NULL;
		DejaDupBackend* _tmp2_;
		gchar* desc = NULL;
		DejaDupBackend* _tmp3_;
		gchar* _tmp4_;
		GIcon* icon = NULL;
		DejaDupBackend* _tmp5_;
		GIcon* _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		GtkLabel* _tmp10_;
		GIcon* _tmp11_;
		GtkLabel* _tmp15_;
		TimeCombo* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkLabel* _tmp19_;
		GtkLabel* _tmp20_;
		GList* _tmp21_;
		GList* _tmp22_;
		_tmp2_ = assistant_restore_get_backend (self);
		backend = _tmp2_;
		_tmp3_ = backend;
		_tmp4_ = deja_dup_backend_get_location_pretty (_tmp3_);
		desc = _tmp4_;
		_tmp5_ = backend;
		_tmp6_ = deja_dup_backend_get_icon (_tmp5_);
		icon = _tmp6_;
		_tmp8_ = desc;
		if (_tmp8_ == NULL) {
			_tmp7_ = "";
		} else {
			const gchar* _tmp9_;
			_tmp9_ = desc;
			_tmp7_ = _tmp9_;
		}
		_tmp10_ = self->priv->confirm_storage_label;
		gtk_label_set_label (_tmp10_, _tmp7_);
		_tmp11_ = icon;
		if (_tmp11_ == NULL) {
			GtkImage* _tmp12_;
			_tmp12_ = self->priv->confirm_storage_image;
			gtk_image_set_from_icon_name (_tmp12_, "folder");
		} else {
			GtkImage* _tmp13_;
			GIcon* _tmp14_;
			_tmp13_ = self->priv->confirm_storage_image;
			_tmp14_ = icon;
			gtk_image_set_from_gicon (_tmp13_, _tmp14_);
		}
		_tmp15_ = self->priv->confirm_date;
		_tmp16_ = self->priv->date_combo;
		_tmp17_ = time_combo_get_active_text (_tmp16_);
		_tmp18_ = _tmp17_;
		gtk_label_set_label (_tmp15_, _tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = self->priv->confirm_date_label;
		gtk_widget_show ((GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->confirm_date;
		gtk_widget_show ((GtkWidget*) _tmp20_);
		_tmp21_ = assistant_restore_get_restore_files (self);
		_tmp22_ = _tmp21_;
		if (_tmp22_ == NULL) {
			const gchar* _tmp23_;
			GtkLabel* _tmp31_;
			GtkLabel* _tmp32_;
			GtkLabel* _tmp33_;
			GtkBox* _tmp34_;
			_tmp23_ = self->priv->_restore_location;
			if (g_strcmp0 (_tmp23_, "/") == 0) {
				GtkLabel* _tmp24_;
				_tmp24_ = self->priv->confirm_location;
				gtk_label_set_label (_tmp24_, _ ("Original location"));
			} else {
				GtkLabel* _tmp25_;
				const gchar* _tmp26_;
				GFile* _tmp27_;
				GFile* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp25_ = self->priv->confirm_location;
				_tmp26_ = self->priv->_restore_location;
				_tmp27_ = g_file_new_for_path (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = deja_dup_get_file_desc (_tmp28_);
				_tmp30_ = _tmp29_;
				gtk_label_set_label (_tmp25_, _tmp30_);
				_g_free0 (_tmp30_);
				_g_object_unref0 (_tmp28_);
			}
			_tmp31_ = self->priv->confirm_location_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp31_, TRUE);
			_tmp32_ = self->priv->confirm_location;
			gtk_widget_set_visible ((GtkWidget*) _tmp32_, TRUE);
			_tmp33_ = self->priv->confirm_files_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp33_, FALSE);
			_tmp34_ = self->priv->confirm_files;
			if (_tmp34_ != NULL) {
				GtkGrid* _tmp35_;
				GtkBox* _tmp36_;
				_tmp35_ = self->priv->confirm_table;
				_tmp36_ = self->priv->confirm_files;
				gtk_grid_remove (_tmp35_, (GtkWidget*) _tmp36_);
				_g_object_unref0 (self->priv->confirm_files);
				self->priv->confirm_files = NULL;
			}
		} else {
			GtkLabel* _tmp37_;
			GList* _tmp38_;
			GList* _tmp39_;
			GtkBox* _tmp40_;
			GtkBox* _tmp43_;
			GtkBox* _tmp44_;
			GtkGrid* _tmp45_;
			GtkBox* _tmp46_;
			GtkLabel* _tmp47_;
			GList* _tmp48_;
			GList* _tmp49_;
			GtkLabel* _tmp63_;
			GtkLabel* _tmp64_;
			GtkLabel* _tmp65_;
			_tmp37_ = self->priv->confirm_files_label;
			_tmp38_ = assistant_restore_get_restore_files (self);
			_tmp39_ = _tmp38_;
			gtk_label_set_label (_tmp37_, g_dngettext (GETTEXT_PACKAGE, "File to restore", "Files to restore", (gulong) g_list_length (_tmp39_)));
			_tmp40_ = self->priv->confirm_files;
			if (_tmp40_ != NULL) {
				GtkGrid* _tmp41_;
				GtkBox* _tmp42_;
				_tmp41_ = self->priv->confirm_table;
				_tmp42_ = self->priv->confirm_files;
				gtk_grid_remove (_tmp41_, (GtkWidget*) _tmp42_);
			}
			_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
			g_object_ref_sink (_tmp43_);
			_g_object_unref0 (self->priv->confirm_files);
			self->priv->confirm_files = _tmp43_;
			_tmp44_ = self->priv->confirm_files;
			gtk_box_set_homogeneous (_tmp44_, TRUE);
			_tmp45_ = self->priv->confirm_table;
			_tmp46_ = self->priv->confirm_files;
			_tmp47_ = self->priv->confirm_files_label;
			gtk_grid_attach_next_to (_tmp45_, (GtkWidget*) _tmp46_, (GtkWidget*) _tmp47_, GTK_POS_RIGHT, 1, 1);
			_tmp48_ = assistant_restore_get_restore_files (self);
			_tmp49_ = _tmp48_;
			{
				GList* f_collection = NULL;
				GList* f_it = NULL;
				f_collection = _tmp49_;
				for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
					GFile* _tmp50_;
					GFile* f = NULL;
					_tmp50_ = _g_object_ref0 ((GFile*) f_it->data);
					f = _tmp50_;
					{
						gchar* parse_name = NULL;
						GFile* _tmp51_;
						gchar* _tmp52_;
						GtkLabel* file_label = NULL;
						const gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						GtkLabel* _tmp56_;
						GtkLabel* _tmp57_;
						GtkLabel* _tmp58_;
						const gchar* _tmp59_;
						GtkLabel* _tmp60_;
						GtkBox* _tmp61_;
						GtkLabel* _tmp62_;
						_tmp51_ = f;
						_tmp52_ = g_file_get_parse_name (_tmp51_);
						parse_name = _tmp52_;
						_tmp53_ = parse_name;
						_tmp54_ = g_path_get_basename (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = (GtkLabel*) gtk_label_new (_tmp55_);
						g_object_ref_sink (_tmp56_);
						_tmp57_ = _tmp56_;
						_g_free0 (_tmp55_);
						file_label = _tmp57_;
						_tmp58_ = file_label;
						_tmp59_ = parse_name;
						gtk_widget_set_tooltip_text ((GtkWidget*) _tmp58_, _tmp59_);
						_tmp60_ = file_label;
						g_object_set ((GObject*) _tmp60_, "xalign", 0.0f, NULL);
						_tmp61_ = self->priv->confirm_files;
						_tmp62_ = file_label;
						gtk_box_append (_tmp61_, (GtkWidget*) _tmp62_);
						_g_object_unref0 (file_label);
						_g_free0 (parse_name);
						_g_object_unref0 (f);
					}
				}
			}
			_tmp63_ = self->priv->confirm_location_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp63_, FALSE);
			_tmp64_ = self->priv->confirm_location;
			gtk_widget_set_visible ((GtkWidget*) _tmp64_, FALSE);
			_tmp65_ = self->priv->confirm_files_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp65_, TRUE);
		}
		_g_object_unref0 (icon);
		_g_free0 (desc);
		_g_object_unref0 (backend);
	} else {
		GtkWidget* _tmp66_;
		GtkWidget* _tmp67_;
		_tmp66_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
		_tmp67_ = _tmp66_;
		if (page == _tmp67_) {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
			_tmp69_ = _tmp68_;
			if (_tmp69_) {
				assistant_set_page_title ((Assistant*) self, page, _ ("Restore Failed"));
			} else {
				GtkWidget* _tmp70_;
				assistant_set_page_title ((Assistant*) self, page, _ ("Restore Finished"));
				_tmp70_ = ((AssistantOperation*) self)->detail_widget;
				if (!gtk_widget_get_visible (_tmp70_)) {
					GList* _tmp71_;
					GList* _tmp72_;
					_tmp71_ = assistant_restore_get_restore_files (self);
					_tmp72_ = _tmp71_;
					if (_tmp72_ == NULL) {
						GtkLabel* _tmp73_;
						_tmp73_ = ((AssistantOperation*) self)->summary_label;
						gtk_label_set_label (_tmp73_, _ ("Your files were successfully restored."));
					} else {
						GtkLabel* _tmp74_;
						GList* _tmp75_;
						GList* _tmp76_;
						_tmp74_ = ((AssistantOperation*) self)->summary_label;
						_tmp75_ = assistant_restore_get_restore_files (self);
						_tmp76_ = _tmp75_;
						gtk_label_set_label (_tmp74_, g_dngettext (GETTEXT_PACKAGE, "Your file was successfully restored.", "Your files were successfully restored.", (gulong) g_list_length (_tmp76_)));
					}
				}
			}
		} else {
			GtkWidget* _tmp77_;
			GtkWidget* _tmp78_;
			_tmp77_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
			_tmp78_ = _tmp77_;
			if (page == _tmp78_) {
				assistant_set_page_title ((Assistant*) self, page, _ ("Restoring…"));
			} else {
				GtkWidget* _tmp79_;
				_tmp79_ = self->priv->status_progress_page;
				if (page == _tmp79_) {
					gboolean _tmp80_;
					gboolean _tmp81_;
					_tmp80_ = assistant_get_last_op_was_back ((Assistant*) self);
					_tmp81_ = _tmp80_;
					if (_tmp81_) {
						assistant_skip ((Assistant*) self);
					} else {
						GtkProgressBar* _tmp82_;
						gboolean _tmp83_ = FALSE;
						DejaDupOperation* _tmp84_;
						_tmp82_ = self->priv->status_progress_bar;
						gtk_progress_bar_set_fraction (_tmp82_, (gdouble) 0);
						self->priv->status_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_restore_status_pulse_gsource_func, g_object_ref (self), g_object_unref);
						_tmp84_ = ((AssistantOperation*) self)->op;
						if (_tmp84_ != NULL) {
							DejaDupOperation* _tmp85_;
							gboolean _tmp86_;
							gboolean _tmp87_;
							_tmp85_ = ((AssistantOperation*) self)->op;
							_tmp86_ = deja_dup_operation_get_needs_password (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp83_ = _tmp87_;
						} else {
							_tmp83_ = FALSE;
						}
						if (_tmp83_) {
							assistant_operation_provide_password ((AssistantOperation*) self, NULL, NULL);
						} else {
							DejaDupOperation* _tmp88_;
							_tmp88_ = ((AssistantOperation*) self)->op;
							if (_tmp88_ == NULL) {
								assistant_restore_do_status_query (self, NULL, NULL);
							}
						}
					}
				} else {
					GtkWidget* _tmp89_;
					_tmp89_ = self->priv->files_progress_page;
					if (page == _tmp89_) {
						gboolean _tmp90_;
						gboolean _tmp91_;
						_tmp90_ = assistant_get_last_op_was_back ((Assistant*) self);
						_tmp91_ = _tmp90_;
						if (_tmp91_) {
							assistant_skip ((Assistant*) self);
						} else {
							GtkProgressBar* _tmp92_;
							gboolean _tmp93_ = FALSE;
							DejaDupOperation* _tmp94_;
							_tmp92_ = self->priv->files_progress_bar;
							gtk_progress_bar_set_fraction (_tmp92_, (gdouble) 0);
							self->priv->files_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_restore_files_pulse_gsource_func, g_object_ref (self), g_object_unref);
							_tmp94_ = ((AssistantOperation*) self)->op;
							if (_tmp94_ != NULL) {
								DejaDupOperation* _tmp95_;
								gboolean _tmp96_;
								gboolean _tmp97_;
								_tmp95_ = ((AssistantOperation*) self)->op;
								_tmp96_ = deja_dup_operation_get_needs_password (_tmp95_);
								_tmp97_ = _tmp96_;
								_tmp93_ = _tmp97_;
							} else {
								_tmp93_ = FALSE;
							}
							if (_tmp93_) {
								assistant_operation_provide_password ((AssistantOperation*) self, NULL, NULL);
							} else {
								DejaDupOperation* _tmp98_;
								_tmp98_ = ((AssistantOperation*) self)->op;
								if (_tmp98_ == NULL) {
									assistant_restore_do_files_query (self, NULL, NULL);
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
assistant_restore_real_set_buttons (Assistant* base)
{
	AssistantRestore * self;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	self = (AssistantRestore*) base;
	ASSISTANT_CLASS (assistant_restore_parent_class)->set_buttons ((Assistant*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation));
	_tmp0_ = ((Assistant*) self)->current;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = ((AssistantPageInfo*) _tmp1_)->page;
	_tmp3_ = self->priv->restore_dest_page;
	if (_tmp2_ == _tmp3_) {
		assistant_restore_restore_location_updated (self);
	}
}

static void
assistant_restore_real_do_close (AssistantOperation* base)
{
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	assistant_restore_stop_timers (self);
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation));
}

static void
assistant_restore_stop_timers (AssistantRestore* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->status_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->status_timeout_id);
		self->priv->status_timeout_id = (guint) 0;
	}
	if (self->priv->files_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->files_timeout_id);
		self->priv->files_timeout_id = (guint) 0;
	}
}

static void
assistant_restore_real_apply_finished (AssistantOperation* base,
                                       DejaDupOperation* op,
                                       gboolean success,
                                       gboolean cancelled,
                                       const gchar* detail)
{
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	g_return_if_fail (op != NULL);
	notifications_restore_finished ((GtkWindow*) self, success, cancelled, detail);
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->apply_finished (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation), op, success, cancelled, detail);
}

static guint
assistant_restore_real_inhibit (Assistant* base,
                                GtkApplication* app)
{
	AssistantRestore * self;
	guint result;
	self = (AssistantRestore*) base;
	g_return_val_if_fail (app != NULL, 0U);
	result = gtk_application_inhibit (app, (GtkWindow*) self, GTK_APPLICATION_INHIBIT_LOGOUT | GTK_APPLICATION_INHIBIT_SUSPEND, _ ("Restore in progress"));
	return result;
}

AssistantRestore*
assistant_restore_construct (GType object_type)
{
	AssistantRestore * self = NULL;
	self = (AssistantRestore*) assistant_operation_construct (object_type);
	return self;
}

AssistantRestore*
assistant_restore_new (void)
{
	return assistant_restore_construct (TYPE_ASSISTANT_RESTORE);
}

const gchar*
assistant_restore_get_restore_location (AssistantRestore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_restore_location;
	result = _tmp0_;
	return result;
}

void
assistant_restore_set_restore_location (AssistantRestore* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_restore_get_restore_location (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_restore_location);
		self->priv->_restore_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_restore_properties[ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY]);
	}
}

const gchar*
assistant_restore_get_when (AssistantRestore* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_when;
	result = _tmp0_;
	return result;
}

void
assistant_restore_set_when (AssistantRestore* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_restore_get_when (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_when);
		self->priv->_when = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_restore_properties[ASSISTANT_RESTORE_WHEN_PROPERTY]);
	}
}

DejaDupFileTree*
assistant_restore_get_tree (AssistantRestore* self)
{
	DejaDupFileTree* result;
	DejaDupFileTree* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tree;
	result = _tmp0_;
	return result;
}

void
assistant_restore_set_tree (AssistantRestore* self,
                            DejaDupFileTree* value)
{
	DejaDupFileTree* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_restore_get_tree (self);
	if (old_value != value) {
		DejaDupFileTree* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tree);
		self->priv->_tree = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_restore_properties[ASSISTANT_RESTORE_TREE_PROPERTY]);
	}
}

GList*
assistant_restore_get_restore_files (AssistantRestore* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_restore_files;
	result = _tmp0_;
	return result;
}

void
assistant_restore_set_restore_files (AssistantRestore* self,
                                     GList* value)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_copy_deep (value, (GCopyFunc) g_object_ref, NULL);
	(self->_restore_files == NULL) ? NULL : (self->_restore_files = (_g_list_free__g_object_unref0_ (self->_restore_files), NULL));
	self->_restore_files = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, assistant_restore_properties[ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY]);
}

static GObject *
assistant_restore_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AssistantRestore * self;
	gchar* _tmp0_;
	parent_class = G_OBJECT_CLASS (assistant_restore_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	_tmp0_ = g_strdup (_ ("Restore"));
	_g_free0 (((Assistant*) self)->default_title);
	((Assistant*) self)->default_title = _tmp0_;
	return obj;
}

static void
assistant_restore_class_init (AssistantRestoreClass * klass,
                              gpointer klass_data)
{
	assistant_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AssistantRestore_private_offset);
	((AssistantOperationClass *) klass)->get_apply_text = (gchar* (*) (AssistantOperation*)) assistant_restore_real_get_apply_text;
	((AssistantOperationClass *) klass)->add_setup_pages = (void (*) (AssistantOperation*)) assistant_restore_real_add_setup_pages;
	((AssistantOperationClass *) klass)->make_confirm_page = (GtkWidget* (*) (AssistantOperation*)) assistant_restore_real_make_confirm_page;
	((AssistantOperationClass *) klass)->create_op = (void (*) (AssistantOperation*, GAsyncReadyCallback, gpointer)) assistant_restore_real_create_op;
	((AssistantOperationClass *) klass)->create_op_finish = (DejaDupOperation* (*) (AssistantOperation*, GAsyncResult*)) assistant_restore_create_op_finish;
	((AssistantOperationClass *) klass)->get_progress_file_prefix = (gchar* (*) (AssistantOperation*)) assistant_restore_real_get_progress_file_prefix;
	((AssistantRestoreClass *) klass)->status_op_finished = (void (*) (AssistantRestore*, DejaDupOperation*, gboolean, gboolean, const gchar*)) assistant_restore_real_status_op_finished;
	((AssistantRestoreClass *) klass)->files_op_finished = (void (*) (AssistantRestore*, DejaDupOperation*, gboolean, gboolean, const gchar*)) assistant_restore_real_files_op_finished;
	((AssistantOperationClass *) klass)->do_prepare = (void (*) (AssistantOperation*, Assistant*, GtkWidget*)) assistant_restore_real_do_prepare;
	((AssistantClass *) klass)->set_buttons = (void (*) (Assistant*)) assistant_restore_real_set_buttons;
	((AssistantOperationClass *) klass)->do_close = (void (*) (AssistantOperation*)) assistant_restore_real_do_close;
	((AssistantOperationClass *) klass)->apply_finished = (void (*) (AssistantOperation*, DejaDupOperation*, gboolean, gboolean, const gchar*)) assistant_restore_real_apply_finished;
	((AssistantClass *) klass)->inhibit = (guint (*) (Assistant*, GtkApplication*)) assistant_restore_real_inhibit;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_restore_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_restore_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY, assistant_restore_properties[ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY] = g_param_spec_string ("restore-location", "restore-location", "restore-location", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_WHEN_PROPERTY, assistant_restore_properties[ASSISTANT_RESTORE_WHEN_PROPERTY] = g_param_spec_string ("when", "when", "when", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_TREE_PROPERTY, assistant_restore_properties[ASSISTANT_RESTORE_TREE_PROPERTY] = g_param_spec_object ("tree", "tree", "tree", DEJA_DUP_TYPE_FILE_TREE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY, assistant_restore_properties[ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY] = g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
assistant_restore_instance_init (AssistantRestore * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = assistant_restore_get_instance_private (self);
	_tmp0_ = g_strdup ("/");
	self->priv->_restore_location = _tmp0_;
	self->priv->_when = NULL;
	self->priv->_tree = NULL;
	self->priv->show_confirm_page = TRUE;
}

static void
assistant_restore_finalize (GObject * obj)
{
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	_g_free0 (self->priv->_restore_location);
	_g_free0 (self->priv->_when);
	_g_object_unref0 (self->priv->_tree);
	(self->_restore_files == NULL) ? NULL : (self->_restore_files = (_g_list_free__g_object_unref0_ (self->_restore_files), NULL));
	_deja_dup_operation_state_unref0 (self->op_state);
	_g_object_unref0 (self->priv->files_progress_bar);
	_g_object_unref0 (self->priv->status_progress_bar);
	_g_object_unref0 (self->priv->date_combo);
	_g_object_unref0 (self->priv->cust_entry_row);
	_g_object_unref0 (self->priv->confirm_table);
	_g_object_unref0 (self->priv->confirm_storage_image);
	_g_object_unref0 (self->priv->confirm_storage_label);
	_g_object_unref0 (self->priv->confirm_location_label);
	_g_object_unref0 (self->priv->confirm_location);
	_g_object_unref0 (self->priv->confirm_date_label);
	_g_object_unref0 (self->priv->confirm_date);
	_g_object_unref0 (self->priv->confirm_files_label);
	_g_object_unref0 (self->priv->confirm_files);
	_g_object_unref0 (self->priv->status_progress_page);
	_g_object_unref0 (self->priv->date_page);
	_g_object_unref0 (self->priv->restore_dest_page);
	_g_object_unref0 (self->priv->bad_files_grid);
	_g_object_unref0 (self->priv->bad_files_label);
	_g_object_unref0 (self->priv->files_progress_page);
	G_OBJECT_CLASS (assistant_restore_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
assistant_restore_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestore), 0, (GInstanceInitFunc) assistant_restore_instance_init, NULL };
	GType assistant_restore_type_id;
	assistant_restore_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantRestore", &g_define_type_info, 0);
	AssistantRestore_private_offset = g_type_add_instance_private (assistant_restore_type_id, sizeof (AssistantRestorePrivate));
	return assistant_restore_type_id;
}

GType
assistant_restore_get_type (void)
{
	static gsize assistant_restore_type_id__once = 0;
	if (g_once_init_enter (&assistant_restore_type_id__once)) {
		GType assistant_restore_type_id;
		assistant_restore_type_id = assistant_restore_get_type_once ();
		g_once_init_leave (&assistant_restore_type_id__once, assistant_restore_type_id);
	}
	return assistant_restore_type_id__once;
}

static void
_vala_assistant_restore_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY:
		g_value_set_string (value, assistant_restore_get_restore_location (self));
		break;
		case ASSISTANT_RESTORE_WHEN_PROPERTY:
		g_value_set_string (value, assistant_restore_get_when (self));
		break;
		case ASSISTANT_RESTORE_TREE_PROPERTY:
		g_value_set_object (value, assistant_restore_get_tree (self));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY:
		g_value_set_pointer (value, assistant_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_assistant_restore_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION_PROPERTY:
		assistant_restore_set_restore_location (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_WHEN_PROPERTY:
		assistant_restore_set_when (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_TREE_PROPERTY:
		assistant_restore_set_tree (self, g_value_get_object (value));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES_PROPERTY:
		assistant_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

