/* AssistantOperation.c generated by valac 0.56.14, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "deja.h"
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#define ASSISTANT_OPERATION_LOGS_LINES_TO_KEEP 10000
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_SWITCH_ROW (switch_row_get_type ())
#define SWITCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCH_ROW, SwitchRow))
#define SWITCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCH_ROW, SwitchRowClass))
#define IS_SWITCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCH_ROW))
#define IS_SWITCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCH_ROW))
#define SWITCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCH_ROW, SwitchRowClass))

typedef struct _SwitchRow SwitchRow;
typedef struct _SwitchRowClass SwitchRowClass;
enum  {
	ASSISTANT_OPERATION_0_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY,
	ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY,
	ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY,
	ASSISTANT_OPERATION_NAG_PAGE_PROPERTY,
	ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY,
	ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY,
	ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY,
	ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY,
	ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY,
	ASSISTANT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* assistant_operation_properties[ASSISTANT_OPERATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
typedef struct _AssistantOperationDoApplyData AssistantOperationDoApplyData;

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantPageInfoPrivate AssistantPageInfoPrivate;
typedef struct _AssistantOperationProvidePasswordData AssistantOperationProvidePasswordData;
enum  {
	ASSISTANT_OPERATION_CLOSING_SIGNAL,
	ASSISTANT_OPERATION_NUM_SIGNALS
};
static guint assistant_operation_signals[ASSISTANT_OPERATION_NUM_SIGNALS] = {0};

struct _Assistant {
	AdwWindow parent_instance;
	AssistantPrivate * priv;
	gchar* default_title;
	GtkWidget* forward_button;
	GtkStack* page_box;
	gboolean can_resume;
	GList* first_shown;
	GList* current;
};

struct _AssistantClass {
	AdwWindowClass parent_class;
	void (*set_buttons) (Assistant* self);
	guint (*inhibit) (Assistant* self, GtkApplication* app);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	void (*create_op) (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	DejaDupOperation* (*create_op_finish) (AssistantOperation* self, GAsyncResult* _res_);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	gchar* (*get_apply_text) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	GtkWidget* _backend_install_page;
	GtkLabel* backend_install_desc;
	GtkLabel* backend_install_packages;
	GtkProgressBar* backend_install_progress;
	AdwPasswordEntryRow* nag_entry;
	AdwPasswordEntryRow* encrypt_entry;
	AdwPasswordEntryRow* confirm_entry;
	SwitchRow* encrypt_enabled;
	SwitchRow* encrypt_remember;
	GtkWidget* _password_page;
	GtkWidget* _nag_page;
	GList* encryption_choice_widgets;
	GList* first_password_widgets;
	GMainLoop* password_ask_loop;
	GtkLabel* consent_label;
	gchar* consent_url;
	GtkGrid* _consent_page;
	GtkLabel* question_label;
	GtkWidget* _question_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkLabel* secondary_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkExpander* progress_expander;
	GtkWidget* _progress_page;
	GtkTextView* detail_text_view;
	GtkWidget* _summary_page;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean adjustment_at_end;
	gboolean adjusting_text;
};

struct _AssistantOperationDoApplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantOperation* self;
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	DejaDupOperation* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupOperation* _tmp5_;
	DejaDupOperation* _tmp6_;
	DejaDupOperation* _tmp7_;
};

struct _AssistantPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AssistantPageInfoPrivate * priv;
	GtkWidget* page;
	gchar* title;
	AssistantType type;
	gchar* forward_text;
};

struct _AssistantPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (AssistantPageInfo *self);
};

struct _AssistantOperationProvidePasswordData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantOperation* self;
	gchar* passphrase;
	gchar* _tmp0_;
	DejaDupOperation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SwitchRow* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	AdwPasswordEntryRow* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	SwitchRow* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean remember;
	const gchar* _tmp15_;
	AdwPasswordEntryRow* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	DejaDupOperation* _tmp20_;
	const gchar* _tmp21_;
};

static gint AssistantOperation_private_offset;
static gpointer assistant_operation_parent_class = NULL;

VALA_EXTERN GType assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Assistant, g_object_unref)
VALA_EXTERN gpointer assistant_page_info_ref (gpointer instance);
VALA_EXTERN void assistant_page_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* assistant_param_spec_page_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void assistant_value_set_page_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void assistant_value_take_page_info (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer assistant_value_get_page_info (const GValue* value);
VALA_EXTERN GType assistant_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantPageInfo, assistant_page_info_unref)
VALA_EXTERN GType assistant_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantOperation, g_object_unref)
VALA_EXTERN GType switch_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchRow, g_object_unref)
VALA_EXTERN GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
VALA_EXTERN void assistant_operation_add_setup_pages (AssistantOperation* self);
VALA_EXTERN void assistant_operation_add_custom_config_pages (AssistantOperation* self);
VALA_EXTERN gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
VALA_EXTERN gchar* assistant_operation_get_apply_text (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
VALA_EXTERN void assistant_operation_show_error (AssistantOperation* self,
                                     const gchar* _error_,
                                     const gchar* detail);
VALA_EXTERN GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
VALA_EXTERN void assistant_operation_apply_finished (AssistantOperation* self,
                                         DejaDupOperation* op,
                                         gboolean success,
                                         gboolean cancelled,
                                         const gchar* detail);
VALA_EXTERN void assistant_operation_do_prepare (AssistantOperation* self,
                                     Assistant* assist,
                                     GtkWidget* page);
VALA_EXTERN void assistant_operation_do_cancel (AssistantOperation* self);
VALA_EXTERN void assistant_operation_do_close (AssistantOperation* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
VALA_EXTERN void assistant_operation_create_op (AssistantOperation* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN DejaDupOperation* assistant_operation_create_op_finish (AssistantOperation* self,
                                                        GAsyncResult* _res_);
static gchar* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
static gchar* assistant_operation_real_get_apply_text (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self,
                                        DejaDupOperation* op,
                                        gdouble percent);
static void assistant_operation_set_progress_label (AssistantOperation* self,
                                             DejaDupOperation* op,
                                             const gchar* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self,
                                                  DejaDupOperation* op,
                                                  GFile* file,
                                                  gboolean actual);
static void assistant_operation_maybe_autoscroll (AssistantOperation* self);
VALA_EXTERN void assistant_operation_set_secondary_label (AssistantOperation* self,
                                              const gchar* text);
static void assistant_operation_update_autoscroll (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
static void _assistant_operation_update_autoscroll_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                          gpointer self);
static void _assistant_operation_update_autoscroll_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
VALA_EXTERN void deja_dup_set_margins (GtkWidget* w,
                           gint margin);
static void assistant_operation_show_detail (AssistantOperation* self,
                                      const gchar* detail);
static void assistant_operation_real_show_error (AssistantOperation* self,
                                          const gchar* _error_,
                                          const gchar* detail);
static void assistant_operation_set_error_occurred (AssistantOperation* self,
                                             gboolean value);
VALA_EXTERN void assistant_go_to_page (Assistant* self,
                           GtkWidget* page);
VALA_EXTERN GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_make_backend_install_page (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_make_password_page (AssistantOperation* self);
VALA_EXTERN SwitchRow* switch_row_new (void);
VALA_EXTERN SwitchRow* switch_row_construct (GType object_type);
VALA_EXTERN void switch_row_set_active (SwitchRow* self,
                            gboolean value);
static void assistant_operation_check_password_validity (AssistantOperation* self);
static void _assistant_operation_check_password_validity_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _assistant_operation_check_password_validity_gtk_editable_changed (GtkEditable* _sender,
                                                                        gpointer self);
VALA_EXTERN GtkWidget* assistant_operation_make_nag_page (AssistantOperation* self);
static void assistant_operation_check_nag_validity (AssistantOperation* self);
static void _assistant_operation_check_nag_validity_gtk_editable_changed (GtkEditable* _sender,
                                                                   gpointer self);
static void __lambda4_ (AssistantOperation* self,
                 GObject* row,
                 GParamSpec* spec);
VALA_EXTERN gboolean switch_row_get_active (SwitchRow* self);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN GtkGrid* assistant_operation_make_consent_page (AssistantOperation* self);
static void __lambda5_ (AssistantOperation* self,
                 GtkButton* button);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
VALA_EXTERN GtkWidget* assistant_operation_make_question_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_backend_install_page (AssistantOperation* self);
VALA_EXTERN GType assistant_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void assistant_append_page (Assistant* self,
                            GtkWidget* page,
                            AssistantType type,
                            const gchar* forward_text);
VALA_EXTERN void assistant_set_page_title (Assistant* self,
                               GtkWidget* page,
                               const gchar* title);
static void assistant_operation_set_backend_install_page (AssistantOperation* self,
                                                   GtkWidget* value);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
static void assistant_operation_set_confirm_page (AssistantOperation* self,
                                           GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self,
                                            GtkWidget* value);
static void assistant_operation_add_password_page (AssistantOperation* self);
static void assistant_operation_set_password_page (AssistantOperation* self,
                                            GtkWidget* value);
static void assistant_operation_add_nag_page (AssistantOperation* self);
static void assistant_operation_set_nag_page (AssistantOperation* self,
                                       GtkWidget* value);
static void assistant_operation_add_consent_page (AssistantOperation* self);
static void assistant_operation_set_consent_page (AssistantOperation* self,
                                           GtkGrid* value);
VALA_EXTERN GtkGrid* assistant_operation_get_consent_page (AssistantOperation* self);
static void assistant_operation_add_question_page (AssistantOperation* self);
static void assistant_operation_set_question_page (AssistantOperation* self,
                                            GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self,
                                           GtkWidget* value);
static void assistant_operation_real_apply_finished (AssistantOperation* self,
                                              DejaDupOperation* op,
                                              gboolean success,
                                              gboolean cancelled,
                                              const gchar* detail);
VALA_EXTERN void assistant_operation_show_oauth_consent_page (AssistantOperation* self,
                                                  const gchar* message,
                                                  const gchar* url);
VALA_EXTERN void assistant_go_forward (Assistant* self);
VALA_EXTERN void assistant_interrupt (Assistant* self,
                          GtkWidget* page,
                          gboolean can_continue,
                          gboolean stay_visible);
static void assistant_operation_do_apply_data_free (gpointer _data);
VALA_EXTERN void assistant_operation_do_apply (AssistantOperation* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void assistant_operation_do_apply_finish (AssistantOperation* self,
                                          GAsyncResult* _res_);
static gboolean assistant_operation_do_apply_co (AssistantOperationDoApplyData* _data_);
static void assistant_operation_do_apply_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
VALA_EXTERN void assistant_operation_connect_operation (AssistantOperation* self,
                                            DejaDupOperation* operation);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                                  gboolean success,
                                                                  gboolean cancelled,
                                                                  const gchar* detail,
                                                                  gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender,
                                                                                     const gchar* action,
                                                                                     gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender,
                                                                                          GFile* file,
                                                                                          gboolean actual,
                                                                                          gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender,
                                                                     gdouble percent,
                                                                     gpointer self);
static void __lambda6_ (AssistantOperation* self,
                 DejaDupOperation* o,
                 const gchar* e,
                 const gchar* d);
static void ___lambda6__deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                                 const gchar* errstr,
                                                 const gchar* detail,
                                                 gpointer self);
VALA_EXTERN void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                                 gpointer self);
static void assistant_operation_show_question (AssistantOperation* self,
                                        DejaDupOperation* op,
                                        const gchar* title,
                                        const gchar* message);
static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender,
                                                                     const gchar* title,
                                                                     const gchar* msg,
                                                                     gpointer self);
VALA_EXTERN MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
VALA_EXTERN MountOperationAssistant* mount_operation_assistant_construct (GType object_type,
                                                              AssistantOperation* assist);
VALA_EXTERN GType mount_operation_assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountOperationAssistant, g_object_unref)
VALA_EXTERN void assistant_operation_pause_op (AssistantOperation* self,
                                   DejaDupBackend* back,
                                   const gchar* header,
                                   const gchar* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender,
                                                              const gchar* header,
                                                              const gchar* msg,
                                                              gpointer self);
static void _assistant_operation_show_oauth_consent_page_deja_dup_backend_show_oauth_consent_page (DejaDupBackend* _sender,
                                                                                            const gchar* message,
                                                                                            const gchar* url,
                                                                                            gpointer self);
static void assistant_operation_real_do_prepare (AssistantOperation* self,
                                          Assistant* assist,
                                          GtkWidget* page);
VALA_EXTERN GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
VALA_EXTERN void assistant_operation_provide_password (AssistantOperation* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void assistant_operation_provide_password_finish (AssistantOperation* self,
                                                  GAsyncResult* _res_);
VALA_EXTERN void assistant_operation_hide_everything (AssistantOperation* self);
VALA_EXTERN void notifications_close_all (void);
VALA_EXTERN void assistant_operation_stop (AssistantOperation* self);
VALA_EXTERN gboolean assistant_operation_has_active_op (AssistantOperation* self);
VALA_EXTERN gboolean assistant_is_interrupt_type (AssistantType type);
static void assistant_operation_real_do_cancel (AssistantOperation* self);
VALA_EXTERN void assistant_operation_do_delete (AssistantOperation* self);
static void assistant_operation_real_do_close (AssistantOperation* self);
VALA_EXTERN void assistant_operation_ask_passphrase (AssistantOperation* self,
                                         gboolean first);
VALA_EXTERN void assistant_allow_forward (Assistant* self,
                              gboolean allow);
static void assistant_operation_configure_password_page (AssistantOperation* self,
                                                  gboolean first);
VALA_EXTERN GtkWidget* assistant_operation_get_password_page (AssistantOperation* self);
static void assistant_operation_configure_nag_page (AssistantOperation* self);
static void assistant_operation_stop_password_loop (AssistantOperation* self);
static void _assistant_operation_stop_password_loop_assistant_operation_closing (AssistantOperation* _sender,
                                                                          gpointer self);
VALA_EXTERN GtkWidget* assistant_operation_get_nag_page (AssistantOperation* self);
VALA_EXTERN void notifications_attention_needed (GtkWindow* win,
                                     const gchar* title,
                                     const gchar* body);
static void assistant_operation_provide_password_data_free (gpointer _data);
static gboolean assistant_operation_provide_password_co (AssistantOperationProvidePasswordData* _data_);
static void assistant_operation_provide_password_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
VALA_EXTERN GtkWidget* assistant_operation_get_question_page (AssistantOperation* self);
static void _g_main_loop_quit_assistant_operation_closing (AssistantOperation* _sender,
                                                    gpointer self);
static void _g_main_loop_quit_assistant_forward (Assistant* _sender,
                                          gpointer self);
VALA_EXTERN void notifications_operation_unblocked (void);
VALA_EXTERN void notifications_operation_blocked (GtkWindow* win,
                                      const gchar* title,
                                      const gchar* body);
VALA_EXTERN AssistantOperation* assistant_operation_construct (GType object_type);
VALA_EXTERN Assistant* assistant_new (void);
VALA_EXTERN Assistant* assistant_construct (GType object_type);
VALA_EXTERN GtkWidget* assistant_operation_get_backend_install_page (AssistantOperation* self);
VALA_EXTERN gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static GObject * assistant_operation_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _assistant_operation___lambda12_ (AssistantOperation* self);
static gboolean __assistant_operation___lambda12__gsource_func (gpointer self);
static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender,
                                                        gpointer self);
static void _assistant_operation_do_delete_assistant_closed (Assistant* _sender,
                                                      gpointer self);
static void _assistant_operation_do_delete_assistant_resumed (Assistant* _sender,
                                                       gpointer self);
static gboolean _assistant_operation___lambda13_ (AssistantOperation* self);
static gboolean __assistant_operation___lambda13__gtk_window_close_request (GtkWindow* _sender,
                                                                     gpointer self);
static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender,
                                                        GtkWidget* page,
                                                        gpointer self);
static void assistant_operation_finalize (GObject * obj);
static GType assistant_operation_get_type_once (void);
static void _vala_assistant_operation_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_assistant_operation_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
assistant_operation_get_instance_private (AssistantOperation* self)
{
	return G_STRUCT_MEMBER_P (self, AssistantOperation_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GtkWidget*
assistant_operation_real_make_confirm_page (AssistantOperation* self)
{
	GtkWidget* result;
	result = NULL;
	return result;
}

GtkWidget*
assistant_operation_make_confirm_page (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->make_confirm_page) {
		return _klass_->make_confirm_page (self);
	}
	return NULL;
}

static void
assistant_operation_real_add_setup_pages (AssistantOperation* self)
{
}

void
assistant_operation_add_setup_pages (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->add_setup_pages) {
		_klass_->add_setup_pages (self);
	}
}

static void
assistant_operation_real_add_custom_config_pages (AssistantOperation* self)
{
}

void
assistant_operation_add_custom_config_pages (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->add_custom_config_pages) {
		_klass_->add_custom_config_pages (self);
	}
}

void
assistant_operation_create_op (AssistantOperation* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	AssistantOperationClass* _klass_;
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->create_op) {
		_klass_->create_op (self, _callback_, _user_data_);
	}
}

DejaDupOperation*
assistant_operation_create_op_finish (AssistantOperation* self,
                                      GAsyncResult* _res_)
{
	AssistantOperationClass* _klass_;
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->create_op_finish) {
		return _klass_->create_op_finish (self, _res_);
	}
	return NULL;
}

static gchar*
assistant_operation_real_get_progress_file_prefix (AssistantOperation* self)
{
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
assistant_operation_get_progress_file_prefix (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->get_progress_file_prefix) {
		return _klass_->get_progress_file_prefix (self);
	}
	return NULL;
}

static gchar*
assistant_operation_real_get_apply_text (AssistantOperation* self)
{
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_apply_text'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
assistant_operation_get_apply_text (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->get_apply_text) {
		return _klass_->get_apply_text (self);
	}
	return NULL;
}

static gboolean
assistant_operation_pulse (AssistantOperation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		GtkProgressBar* _tmp0_;
		_tmp0_ = self->priv->progress_bar;
		gtk_progress_bar_pulse (_tmp0_);
	}
	result = TRUE;
	return result;
}

static void
assistant_operation_show_progress (AssistantOperation* self,
                                   DejaDupOperation* op,
                                   gdouble percent)
{
	GtkProgressBar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, percent);
	self->priv->gives_progress = TRUE;
}

static void
assistant_operation_set_progress_label (AssistantOperation* self,
                                        DejaDupOperation* op,
                                        const gchar* label)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->progress_label;
	gtk_label_set_label (_tmp0_, label);
	_tmp1_ = self->priv->progress_file_label;
	gtk_label_set_label (_tmp1_, "");
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
assistant_operation_set_progress_label_file (AssistantOperation* self,
                                             DejaDupOperation* op,
                                             GFile* file,
                                             gboolean actual)
{
	gchar* prefix = NULL;
	gchar* log_line = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkTextBuffer* buffer = NULL;
	GtkTextView* _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GtkTextBuffer* _tmp22_;
	GtkTextIter iter = {0};
	GtkTextBuffer* _tmp25_;
	GtkTextIter _tmp26_ = {0};
	GtkTextBuffer* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gboolean _tmp32_ = FALSE;
	GtkTextBuffer* _tmp33_;
	GtkExpander* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkTextView* _tmp42_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	if (actual) {
		gchar* _tmp0_;
		GtkLabel* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkLabel* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = assistant_operation_get_progress_file_prefix (self);
		_g_free0 (prefix);
		prefix = _tmp0_;
		_tmp1_ = self->priv->progress_label;
		_tmp2_ = prefix;
		_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
		_tmp4_ = _tmp3_;
		gtk_label_set_label (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->progress_file_label;
		_tmp6_ = deja_dup_get_display_name (file);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp5_, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		gchar* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		_tmp8_ = g_strdup (_ ("Scanning:"));
		_g_free0 (prefix);
		prefix = _tmp8_;
		_tmp9_ = self->priv->progress_label;
		gtk_label_set_label (_tmp9_, _ ("Scanning…"));
		_tmp10_ = self->priv->progress_file_label;
		gtk_label_set_label (_tmp10_, "");
	}
	self->priv->adjusting_text = TRUE;
	_tmp11_ = prefix;
	_tmp12_ = g_strconcat (_tmp11_, " ", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_parse_name (file);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	log_line = _tmp17_;
	_tmp18_ = self->priv->progress_text;
	_tmp19_ = gtk_text_view_get_buffer (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	buffer = _tmp21_;
	_tmp22_ = buffer;
	if (gtk_text_buffer_get_char_count (_tmp22_) > 0) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = log_line;
		_tmp24_ = g_strconcat ("\n", _tmp23_, NULL);
		_g_free0 (log_line);
		log_line = _tmp24_;
	}
	_tmp25_ = buffer;
	gtk_text_buffer_get_end_iter (_tmp25_, &_tmp26_);
	iter = _tmp26_;
	_tmp27_ = buffer;
	_tmp28_ = log_line;
	_tmp29_ = log_line;
	_tmp30_ = strlen (_tmp29_);
	_tmp31_ = _tmp30_;
	g_signal_emit_by_name (_tmp27_, "insert-text", &iter, _tmp28_, (gint) _tmp31_);
	_tmp33_ = buffer;
	if (gtk_text_buffer_get_line_count (_tmp33_) >= ASSISTANT_OPERATION_LOGS_LINES_TO_KEEP) {
		_tmp32_ = self->priv->adjustment_at_end;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GtkTextIter start = {0};
		GtkTextIter cutoff = {0};
		GtkTextBuffer* _tmp34_;
		GtkTextIter _tmp35_ = {0};
		GtkTextBuffer* _tmp36_;
		GtkTextBuffer* _tmp37_;
		GtkTextIter _tmp38_ = {0};
		GtkTextBuffer* _tmp39_;
		_tmp34_ = buffer;
		gtk_text_buffer_get_start_iter (_tmp34_, &_tmp35_);
		start = _tmp35_;
		_tmp36_ = buffer;
		_tmp37_ = buffer;
		gtk_text_buffer_get_iter_at_line (_tmp36_, &_tmp38_, gtk_text_buffer_get_line_count (_tmp37_) - ASSISTANT_OPERATION_LOGS_LINES_TO_KEEP);
		cutoff = _tmp38_;
		_tmp39_ = buffer;
		gtk_text_buffer_delete (_tmp39_, &start, &cutoff);
	}
	assistant_operation_maybe_autoscroll (self);
	self->priv->adjusting_text = FALSE;
	_tmp40_ = self->priv->progress_expander;
	gtk_widget_set_visible ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = self->priv->progress_scroll;
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, TRUE);
	_tmp42_ = self->priv->progress_text;
	gtk_widget_set_visible ((GtkWidget*) _tmp42_, TRUE);
	_g_object_unref0 (buffer);
	_g_free0 (log_line);
	_g_free0 (prefix);
}

void
assistant_operation_set_secondary_label (AssistantOperation* self,
                                         const gchar* text)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (text != NULL) {
		_tmp0_ = g_strcmp0 (text, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		_tmp1_ = self->priv->secondary_label;
		gtk_label_set_label (_tmp1_, text);
		_tmp2_ = self->priv->secondary_label;
		gtk_widget_show ((GtkWidget*) _tmp2_);
	} else {
		GtkLabel* _tmp3_;
		_tmp3_ = self->priv->secondary_label;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
}

static void
assistant_operation_maybe_autoscroll (AssistantOperation* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->adjustment_at_end) {
		GtkAdjustment* adjust = NULL;
		GtkScrolledWindow* _tmp0_;
		GtkAdjustment* _tmp1_;
		GtkAdjustment* _tmp2_;
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GtkAdjustment* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		GtkAdjustment* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp0_ = self->priv->progress_scroll;
		_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		adjust = _tmp3_;
		_tmp4_ = adjust;
		_tmp5_ = adjust;
		_tmp6_ = gtk_adjustment_get_upper (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = adjust;
		_tmp9_ = gtk_adjustment_get_page_size (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_adjustment_set_value (_tmp4_, _tmp7_ - _tmp10_);
		_g_object_unref0 (adjust);
	}
}

static void
assistant_operation_update_autoscroll (AssistantOperation* self)
{
	GtkAdjustment* adjust = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GtkAdjustment* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	g_return_if_fail (self != NULL);
	if (self->priv->adjusting_text) {
		return;
	}
	_tmp0_ = self->priv->progress_scroll;
	_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	adjust = _tmp3_;
	_tmp6_ = adjust;
	_tmp7_ = gtk_adjustment_get_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = adjust;
	_tmp10_ = gtk_adjustment_get_upper (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = adjust;
	_tmp13_ = gtk_adjustment_get_page_size (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp8_ >= (_tmp11_ - (_tmp14_ * 2))) {
		_tmp5_ = TRUE;
	} else {
		GtkAdjustment* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		_tmp15_ = adjust;
		_tmp16_ = gtk_adjustment_get_page_size (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp5_ = _tmp17_ == ((gdouble) 0);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		GtkExpander* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->progress_expander;
		_tmp19_ = gtk_expander_get_expanded (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp4_ = !_tmp20_;
	}
	self->priv->adjustment_at_end = _tmp4_;
	_g_object_unref0 (adjust);
}

static void
_assistant_operation_update_autoscroll_gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                     gpointer self)
{
	assistant_operation_update_autoscroll ((AssistantOperation*) self);
}

static void
_assistant_operation_update_autoscroll_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	assistant_operation_update_autoscroll ((AssistantOperation*) self);
}

static GtkWidget*
assistant_operation_real_make_progress_page (AssistantOperation* self)
{
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_;
	gint row = 0;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	gint _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	gint _tmp16_;
	GtkProgressBar* _tmp17_;
	GtkProgressBar* _tmp18_;
	gint _tmp19_;
	GtkTextView* _tmp20_;
	GtkTextView* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkAdjustment* _tmp24_;
	GtkAdjustment* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkScrolledWindow* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkTextView* _tmp32_;
	GtkExpander* _tmp33_;
	GtkExpander* _tmp34_;
	GtkExpander* _tmp35_;
	GtkExpander* _tmp36_;
	GtkExpander* _tmp37_;
	GtkScrolledWindow* _tmp38_;
	GtkScrolledWindow* _tmp39_;
	GtkExpander* _tmp40_;
	gint _tmp41_;
	GtkWidget* result;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) page, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (page, 6);
	row = 0;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = _tmp1_;
	_tmp2_ = self->priv->progress_label;
	gtk_label_set_xalign (_tmp2_, 0.0f);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->progress_file_label);
	self->priv->progress_file_label = _tmp3_;
	_tmp4_ = self->priv->progress_file_label;
	gtk_label_set_xalign (_tmp4_, 0.0f);
	_tmp5_ = self->priv->progress_file_label;
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp6_ = self->priv->progress_file_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->progress_label;
	gtk_grid_attach (page, (GtkWidget*) _tmp7_, 0, row, 1, 1);
	_tmp8_ = self->priv->progress_file_label;
	gtk_grid_attach (page, (GtkWidget*) _tmp8_, 1, row, 1, 1);
	row = row + 1;
	_tmp9_ = row;
	_tmp10_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->secondary_label);
	self->priv->secondary_label = _tmp10_;
	_tmp11_ = self->priv->secondary_label;
	gtk_label_set_xalign (_tmp11_, 0.0f);
	_tmp12_ = self->priv->secondary_label;
	gtk_label_set_wrap (_tmp12_, TRUE);
	_tmp13_ = self->priv->secondary_label;
	gtk_label_set_max_width_chars (_tmp13_, 30);
	_tmp14_ = self->priv->secondary_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
	_tmp15_ = self->priv->secondary_label;
	gtk_grid_attach (page, (GtkWidget*) _tmp15_, 0, row, 2, 1);
	row = row + 1;
	_tmp16_ = row;
	_tmp17_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp17_;
	_tmp18_ = self->priv->progress_bar;
	gtk_grid_attach (page, (GtkWidget*) _tmp18_, 0, row, 2, 1);
	row = row + 1;
	_tmp19_ = row;
	_tmp20_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->progress_text);
	self->priv->progress_text = _tmp20_;
	_tmp21_ = self->priv->progress_text;
	gtk_text_view_set_editable (_tmp21_, FALSE);
	_tmp22_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->progress_scroll);
	self->priv->progress_scroll = _tmp22_;
	_tmp23_ = self->priv->progress_scroll;
	_tmp24_ = gtk_scrolled_window_get_vadjustment (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_connect_object (_tmp25_, "value-changed", (GCallback) _assistant_operation_update_autoscroll_gtk_adjustment_value_changed, self, 0);
	_tmp26_ = self->priv->progress_scroll;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
	_tmp27_ = self->priv->progress_scroll;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp27_, TRUE);
	_tmp28_ = self->priv->progress_scroll;
	g_object_set (_tmp28_, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	_tmp29_ = self->priv->progress_scroll;
	g_object_set (_tmp29_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	_tmp30_ = self->priv->progress_scroll;
	gtk_scrolled_window_set_min_content_height (_tmp30_, 200);
	_tmp31_ = self->priv->progress_scroll;
	_tmp32_ = self->priv->progress_text;
	gtk_scrolled_window_set_child (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Details"));
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->progress_expander);
	self->priv->progress_expander = _tmp33_;
	_tmp34_ = self->priv->progress_expander;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp34_, TRUE);
	_tmp35_ = self->priv->progress_expander;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp35_, TRUE);
	_tmp36_ = self->priv->progress_expander;
	gtk_widget_set_visible ((GtkWidget*) _tmp36_, FALSE);
	_tmp37_ = self->priv->progress_expander;
	_tmp38_ = self->priv->progress_scroll;
	gtk_expander_set_child (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->progress_scroll;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::expanded", (GCallback) _assistant_operation_update_autoscroll_g_object_notify, self, 0);
	_tmp40_ = self->priv->progress_expander;
	gtk_grid_attach (page, (GtkWidget*) _tmp40_, 0, row, 2, 1);
	row = row + 1;
	_tmp41_ = row;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	gtk_widget_set_size_request ((GtkWidget*) page, -1, 200);
	result = (GtkWidget*) page;
	return result;
}

GtkWidget*
assistant_operation_make_progress_page (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->make_progress_page) {
		return _klass_->make_progress_page (self);
	}
	return NULL;
}

static void
assistant_operation_show_detail (AssistantOperation* self,
                                 const gchar* detail)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkTextView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (detail != NULL);
	_tmp0_ = ((Assistant*) self)->page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, 300, 200);
	_tmp1_ = self->detail_widget;
	gtk_widget_set_visible (_tmp1_, TRUE);
	_tmp2_ = self->priv->detail_text_view;
	_tmp3_ = gtk_text_view_get_buffer (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_set_text (_tmp4_, detail, -1);
}

static void
assistant_operation_real_show_error (AssistantOperation* self,
                                     const gchar* _error_,
                                     const gchar* detail)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStack* _tmp3_;
	g_return_if_fail (_error_ != NULL);
	assistant_operation_set_error_occurred (self, TRUE);
	_tmp0_ = self->summary_label;
	gtk_label_set_label (_tmp0_, _error_);
	_tmp1_ = self->summary_label;
	gtk_label_set_selectable (_tmp1_, TRUE);
	if (detail != NULL) {
		assistant_operation_show_detail (self, detail);
	}
	_tmp2_ = self->priv->_summary_page;
	assistant_go_to_page ((Assistant*) self, _tmp2_);
	_tmp3_ = ((Assistant*) self)->page_box;
	gtk_widget_queue_resize ((GtkWidget*) _tmp3_);
}

void
assistant_operation_show_error (AssistantOperation* self,
                                const gchar* _error_,
                                const gchar* detail)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->show_error) {
		_klass_->show_error (self, _error_, detail);
	}
}

GtkWidget*
assistant_operation_make_backend_install_page (AssistantOperation* self)
{
	gint rows = 0;
	GtkLabel* l = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	gint _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	gint _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkProgressBar* _tmp19_;
	GtkProgressBar* _tmp20_;
	GtkProgressBar* _tmp21_;
	GtkProgressBar* _tmp22_;
	gint _tmp23_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	gtk_grid_set_row_spacing (page, 6);
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("In order to continue, the following packages need to be installed:"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (l);
	l = _tmp1_;
	_tmp2_ = l;
	gtk_label_set_xalign (_tmp2_, 0.0f);
	_tmp3_ = l;
	gtk_label_set_max_width_chars (_tmp3_, 35);
	_tmp4_ = l;
	gtk_label_set_wrap (_tmp4_, TRUE);
	_tmp5_ = l;
	_tmp6_ = rows;
	rows = _tmp6_ + 1;
	gtk_grid_attach (page, (GtkWidget*) _tmp5_, 0, _tmp6_, 1, 1);
	_tmp7_ = l;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->backend_install_desc);
	self->priv->backend_install_desc = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (l);
	l = _tmp9_;
	_tmp10_ = l;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
	_tmp11_ = l;
	gtk_label_set_max_width_chars (_tmp11_, 35);
	_tmp12_ = l;
	gtk_label_set_wrap (_tmp12_, TRUE);
	_tmp13_ = l;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp13_, 12);
	_tmp14_ = l;
	gtk_label_set_use_markup (_tmp14_, TRUE);
	_tmp15_ = l;
	_tmp16_ = rows;
	rows = _tmp16_ + 1;
	gtk_grid_attach (page, (GtkWidget*) _tmp15_, 0, _tmp16_, 1, 1);
	_tmp17_ = l;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->backend_install_packages);
	self->priv->backend_install_packages = _tmp18_;
	_tmp19_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->backend_install_progress);
	self->priv->backend_install_progress = _tmp19_;
	_tmp20_ = self->priv->backend_install_progress;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = self->priv->backend_install_progress;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = self->priv->backend_install_progress;
	_tmp23_ = rows;
	rows = _tmp23_ + 1;
	gtk_grid_attach (page, (GtkWidget*) _tmp22_, 0, _tmp23_, 1, 1);
	result = (GtkWidget*) page;
	_g_object_unref0 (l);
	return result;
}

static void
_assistant_operation_check_password_validity_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	assistant_operation_check_password_validity ((AssistantOperation*) self);
}

static void
_assistant_operation_check_password_validity_gtk_editable_changed (GtkEditable* _sender,
                                                                   gpointer self)
{
	assistant_operation_check_password_validity ((AssistantOperation*) self);
}

GtkWidget*
assistant_operation_make_password_page (AssistantOperation* self)
{
	AdwClamp* page = NULL;
	AdwClamp* _tmp0_;
	AdwPreferencesGroup* group = NULL;
	AdwPreferencesGroup* _tmp1_;
	SwitchRow* _tmp2_;
	SwitchRow* _tmp3_;
	SwitchRow* _tmp4_;
	SwitchRow* _tmp5_;
	SwitchRow* _tmp6_;
	SwitchRow* _tmp7_;
	SwitchRow* _tmp8_;
	GtkWidget* _tmp9_;
	AdwPasswordEntryRow* _tmp10_;
	AdwPasswordEntryRow* _tmp11_;
	AdwPasswordEntryRow* _tmp12_;
	AdwPasswordEntryRow* _tmp13_;
	AdwPasswordEntryRow* _tmp14_;
	SwitchRow* _tmp15_;
	AdwPasswordEntryRow* _tmp16_;
	AdwPasswordEntryRow* _tmp17_;
	AdwPasswordEntryRow* _tmp18_;
	AdwPasswordEntryRow* _tmp19_;
	AdwPasswordEntryRow* _tmp20_;
	AdwPasswordEntryRow* _tmp21_;
	AdwPasswordEntryRow* _tmp22_;
	SwitchRow* _tmp23_;
	AdwPasswordEntryRow* _tmp24_;
	AdwPasswordEntryRow* _tmp25_;
	AdwPasswordEntryRow* _tmp26_;
	GtkWidget* _tmp27_;
	SwitchRow* _tmp28_;
	SwitchRow* _tmp29_;
	SwitchRow* _tmp30_;
	SwitchRow* _tmp31_;
	SwitchRow* _tmp32_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (AdwClamp*) adw_clamp_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp1_ = (AdwPreferencesGroup*) adw_preferences_group_new ();
	g_object_ref_sink (_tmp1_);
	group = _tmp1_;
	adw_clamp_set_child (page, (GtkWidget*) group);
	_tmp2_ = switch_row_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->encrypt_enabled);
	self->priv->encrypt_enabled = _tmp2_;
	_tmp3_ = self->priv->encrypt_enabled;
	switch_row_set_active (_tmp3_, TRUE);
	_tmp4_ = self->priv->encrypt_enabled;
	adw_action_row_set_subtitle ((AdwActionRow*) _tmp4_, _ ("You will need your password to restore your files. You might want to w" \
"rite it down."));
	_tmp5_ = self->priv->encrypt_enabled;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp5_, _ ("_Password-protect your backup"));
	_tmp6_ = self->priv->encrypt_enabled;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::active", (GCallback) _assistant_operation_check_password_validity_g_object_notify, self, 0);
	_tmp7_ = self->priv->encrypt_enabled;
	adw_preferences_group_add (group, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->encrypt_enabled;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	self->priv->encryption_choice_widgets = g_list_append (self->priv->encryption_choice_widgets, _tmp9_);
	_tmp10_ = (AdwPasswordEntryRow*) adw_password_entry_row_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->encrypt_entry);
	self->priv->encrypt_entry = _tmp10_;
	_tmp11_ = self->priv->encrypt_entry;
	adw_entry_row_set_activates_default ((AdwEntryRow*) _tmp11_, TRUE);
	_tmp12_ = self->priv->encrypt_entry;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp12_, _ ("E_ncryption password"));
	_tmp13_ = self->priv->encrypt_entry;
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) _tmp13_, TRUE);
	_tmp14_ = self->priv->encrypt_entry;
	g_signal_connect_object ((GtkEditable*) _tmp14_, "changed", (GCallback) _assistant_operation_check_password_validity_gtk_editable_changed, self, 0);
	_tmp15_ = self->priv->encrypt_enabled;
	_tmp16_ = self->priv->encrypt_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp15_, "active", (GObject*) _tmp16_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = self->priv->encrypt_entry;
	adw_preferences_group_add (group, (GtkWidget*) _tmp17_);
	_tmp18_ = (AdwPasswordEntryRow*) adw_password_entry_row_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->confirm_entry);
	self->priv->confirm_entry = _tmp18_;
	_tmp19_ = self->priv->confirm_entry;
	adw_entry_row_set_activates_default ((AdwEntryRow*) _tmp19_, TRUE);
	_tmp20_ = self->priv->confirm_entry;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp20_, _ ("Confir_m password"));
	_tmp21_ = self->priv->confirm_entry;
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) _tmp21_, TRUE);
	_tmp22_ = self->priv->confirm_entry;
	g_signal_connect_object ((GtkEditable*) _tmp22_, "changed", (GCallback) _assistant_operation_check_password_validity_gtk_editable_changed, self, 0);
	_tmp23_ = self->priv->encrypt_enabled;
	_tmp24_ = self->priv->confirm_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp23_, "active", (GObject*) _tmp24_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp25_ = self->priv->confirm_entry;
	adw_preferences_group_add (group, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->confirm_entry;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	self->priv->first_password_widgets = g_list_append (self->priv->first_password_widgets, _tmp27_);
	_tmp28_ = switch_row_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->encrypt_remember);
	self->priv->encrypt_remember = _tmp28_;
	_tmp29_ = self->priv->encrypt_remember;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp29_, _ ("_Remember password"));
	_tmp30_ = self->priv->encrypt_enabled;
	_tmp31_ = self->priv->encrypt_remember;
	g_object_bind_property_with_closures ((GObject*) _tmp30_, "active", (GObject*) _tmp31_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp32_ = self->priv->encrypt_remember;
	adw_preferences_group_add (group, (GtkWidget*) _tmp32_);
	result = (GtkWidget*) page;
	_g_object_unref0 (group);
	return result;
}

static void
_assistant_operation_check_nag_validity_gtk_editable_changed (GtkEditable* _sender,
                                                              gpointer self)
{
	assistant_operation_check_nag_validity ((AssistantOperation*) self);
}

static void
__lambda4_ (AssistantOperation* self,
            GObject* row,
            GParamSpec* spec)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (row != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = switch_row_get_active (G_TYPE_CHECK_INSTANCE_CAST (row, TYPE_SWITCH_ROW, SwitchRow));
	_tmp1_ = _tmp0_;
	deja_dup_update_nag_time (!_tmp1_);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((AssistantOperation*) self, _sender, pspec);
}

GtkWidget*
assistant_operation_make_nag_page (AssistantOperation* self)
{
	AdwClamp* page = NULL;
	AdwClamp* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	AdwPreferencesGroup* group = NULL;
	AdwPreferencesGroup* _tmp3_;
	AdwPasswordEntryRow* _tmp4_;
	AdwPasswordEntryRow* _tmp5_;
	AdwPasswordEntryRow* _tmp6_;
	AdwPasswordEntryRow* _tmp7_;
	AdwPasswordEntryRow* _tmp8_;
	AdwPasswordEntryRow* _tmp9_;
	SwitchRow* nag_row = NULL;
	SwitchRow* _tmp10_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (AdwClamp*) adw_clamp_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	adw_clamp_set_child (page, (GtkWidget*) box);
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("In order to check that you will be able to retrieve your files in the " \
"case " "of an emergency, please enter your encryption password again to perfor" \
"m a " "brief restore test."));
	g_object_ref_sink (_tmp2_);
	label = _tmp2_;
	gtk_label_set_wrap (label, TRUE);
	gtk_label_set_xalign (label, (gfloat) 0);
	gtk_box_append (box, (GtkWidget*) label);
	_tmp3_ = (AdwPreferencesGroup*) adw_preferences_group_new ();
	g_object_ref_sink (_tmp3_);
	group = _tmp3_;
	gtk_box_append (box, (GtkWidget*) group);
	_tmp4_ = (AdwPasswordEntryRow*) adw_password_entry_row_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->nag_entry);
	self->priv->nag_entry = _tmp4_;
	_tmp5_ = self->priv->nag_entry;
	adw_entry_row_set_activates_default ((AdwEntryRow*) _tmp5_, TRUE);
	_tmp6_ = self->priv->nag_entry;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp6_, _ ("E_ncryption password"));
	_tmp7_ = self->priv->nag_entry;
	adw_preferences_row_set_use_underline ((AdwPreferencesRow*) _tmp7_, TRUE);
	_tmp8_ = self->priv->nag_entry;
	g_signal_connect_object ((GtkEditable*) _tmp8_, "changed", (GCallback) _assistant_operation_check_nag_validity_gtk_editable_changed, self, 0);
	_tmp9_ = self->priv->nag_entry;
	adw_preferences_group_add (group, (GtkWidget*) _tmp9_);
	_tmp10_ = switch_row_new ();
	g_object_ref_sink (_tmp10_);
	nag_row = _tmp10_;
	switch_row_set_active (nag_row, TRUE);
	adw_preferences_row_set_title ((AdwPreferencesRow*) nag_row, _ ("Test every two _months"));
	g_signal_connect_object ((GObject*) nag_row, "notify::active", (GCallback) ___lambda4__g_object_notify, self, 0);
	adw_preferences_group_add (group, (GtkWidget*) nag_row);
	result = (GtkWidget*) page;
	_g_object_unref0 (nag_row);
	_g_object_unref0 (group);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	return result;
}

static void
__lambda5_ (AssistantOperation* self,
            GtkButton* button)
{
	GtkUriLauncher* launcher = NULL;
	const gchar* _tmp0_;
	GtkUriLauncher* _tmp1_;
	GtkRoot* _tmp2_;
	GtkRoot* _tmp3_;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->consent_url;
	_tmp1_ = gtk_uri_launcher_new (_tmp0_);
	launcher = _tmp1_;
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) button);
	_tmp3_ = _tmp2_;
	gtk_uri_launcher_launch (launcher, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL, NULL, NULL, NULL);
	_g_object_unref0 (launcher);
}

static void
___lambda5__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda5_ ((AssistantOperation*) self, _sender);
}

GtkGrid*
assistant_operation_make_consent_page (AssistantOperation* self)
{
	gint rows = 0;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* l = NULL;
	GtkLabel* _tmp1_;
	gint _tmp2_;
	GtkLabel* _tmp3_;
	GtkButton* b = NULL;
	GtkButton* _tmp4_;
	gint _tmp5_;
	GtkGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	gtk_grid_set_row_spacing (page, 36);
	gtk_grid_set_column_spacing (page, 6);
	gtk_widget_set_halign ((GtkWidget*) page, GTK_ALIGN_CENTER);
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	l = _tmp1_;
	gtk_label_set_xalign (l, 0.0f);
	gtk_label_set_max_width_chars (l, 35);
	gtk_label_set_wrap (l, TRUE);
	gtk_grid_attach (page, (GtkWidget*) l, 0, rows, 3, 1);
	rows = rows + 1;
	_tmp2_ = rows;
	_tmp3_ = _g_object_ref0 (l);
	_g_object_unref0 (self->priv->consent_label);
	self->priv->consent_label = _tmp3_;
	_tmp4_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Grant Access"));
	g_object_ref_sink (_tmp4_);
	b = _tmp4_;
	g_signal_connect_object (b, "clicked", (GCallback) ___lambda5__gtk_button_clicked, self, 0);
	gtk_grid_attach (page, (GtkWidget*) b, 1, rows, 1, 1);
	rows = rows + 1;
	_tmp5_ = rows;
	result = page;
	_g_object_unref0 (b);
	_g_object_unref0 (l);
	return result;
}

GtkWidget*
assistant_operation_make_question_page (AssistantOperation* self)
{
	gint rows = 0;
	GtkGrid* page = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp1_;
	gint _tmp2_;
	GtkLabel* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	page = _tmp0_;
	gtk_grid_set_row_spacing (page, 6);
	gtk_grid_set_column_spacing (page, 6);
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	g_object_set ((GObject*) label, "use-underline", TRUE, "wrap", TRUE, "max-width-chars", 25, "hexpand", TRUE, "xalign", 0.0f, NULL);
	gtk_grid_attach (page, (GtkWidget*) label, 0, rows, 1, 1);
	rows = rows + 1;
	_tmp2_ = rows;
	_tmp3_ = _g_object_ref0 (label);
	_g_object_unref0 (self->priv->question_label);
	self->priv->question_label = _tmp3_;
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	return result;
}

static GtkWidget*
assistant_operation_real_make_summary_page (AssistantOperation* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkTextView* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextView* _tmp6_;
	GtkTextView* _tmp7_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp8_;
	GtkTextView* _tmp9_;
	GtkWidget* _tmp10_;
	GtkBox* page = NULL;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* result;
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->summary_label);
	self->summary_label = _tmp0_;
	_tmp1_ = self->summary_label;
	gtk_label_set_xalign (_tmp1_, 0.0f);
	_tmp2_ = self->summary_label;
	gtk_label_set_wrap (_tmp2_, TRUE);
	_tmp3_ = self->summary_label;
	gtk_label_set_max_width_chars (_tmp3_, 25);
	_tmp4_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->detail_text_view);
	self->priv->detail_text_view = _tmp4_;
	_tmp5_ = self->priv->detail_text_view;
	gtk_text_view_set_editable (_tmp5_, FALSE);
	_tmp6_ = self->priv->detail_text_view;
	gtk_text_view_set_wrap_mode (_tmp6_, GTK_WRAP_WORD);
	_tmp7_ = self->priv->detail_text_view;
	g_object_set ((GtkWidget*) _tmp7_, "height-request", 150, NULL);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp8_);
	scroll = _tmp8_;
	_tmp9_ = self->priv->detail_text_view;
	gtk_scrolled_window_set_child (scroll, (GtkWidget*) _tmp9_);
	gtk_widget_set_vexpand ((GtkWidget*) scroll, TRUE);
	gtk_widget_set_visible ((GtkWidget*) scroll, FALSE);
	_tmp10_ = _g_object_ref0 ((GtkWidget*) scroll);
	_g_object_unref0 (self->detail_widget);
	self->detail_widget = _tmp10_;
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp11_);
	page = _tmp11_;
	deja_dup_set_margins ((GtkWidget*) page, 12);
	_tmp12_ = self->summary_label;
	gtk_box_append (page, (GtkWidget*) _tmp12_);
	_tmp13_ = self->detail_widget;
	gtk_box_append (page, _tmp13_);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}

GtkWidget*
assistant_operation_make_summary_page (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->make_summary_page) {
		return _klass_->make_summary_page (self);
	}
	return NULL;
}

static void
assistant_operation_add_backend_install_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_backend_install_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT, _ ("_Forward"));
	assistant_set_page_title ((Assistant*) self, page, _ ("Install Packages"));
	assistant_operation_set_backend_install_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_confirm_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_confirm_page (self);
	page = _tmp0_;
	_tmp1_ = page;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp2_ = page;
	_tmp3_ = assistant_operation_get_apply_text (self);
	_tmp4_ = _tmp3_;
	assistant_append_page ((Assistant*) self, _tmp2_, ASSISTANT_TYPE_NORMAL, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = page;
	assistant_set_page_title ((Assistant*) self, _tmp5_, _ ("Summary"));
	_tmp6_ = page;
	assistant_operation_set_confirm_page (self, _tmp6_);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_progress_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_progress_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS, _ ("_Forward"));
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_password_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_password_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT, _ ("_Forward"));
	assistant_operation_set_password_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_nag_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_nag_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_CHECK, _ ("_Forward"));
	assistant_set_page_title ((Assistant*) self, page, _ ("Restore Test"));
	assistant_operation_set_nag_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_consent_page (AssistantOperation* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_consent_page (self);
	_tmp1_ = _tmp0_;
	assistant_operation_set_consent_page (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_consent_page;
	assistant_append_page ((Assistant*) self, (GtkWidget*) _tmp2_, ASSISTANT_TYPE_INTERRUPT, _ ("_Forward"));
	_tmp3_ = self->priv->_consent_page;
	assistant_set_page_title ((Assistant*) self, (GtkWidget*) _tmp3_, _ ("Grant Access"));
}

static void
assistant_operation_add_question_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_question_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT, _ ("_Forward"));
	assistant_operation_set_question_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_add_summary_page (AssistantOperation* self)
{
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_operation_make_summary_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_FINISH, _ ("_Forward"));
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}

static void
assistant_operation_real_apply_finished (AssistantOperation* self,
                                         DejaDupOperation* op,
                                         gboolean success,
                                         gboolean cancelled,
                                         const gchar* detail)
{
	g_return_if_fail (op != NULL);
	_g_object_unref0 (self->op);
	self->op = NULL;
	if (cancelled) {
		assistant_operation_do_close (self);
	} else {
		if (success) {
			GtkWidget* _tmp10_;
			if (detail != NULL) {
				gchar** halves = NULL;
				gchar** _tmp0_;
				gchar** _tmp1_;
				gint halves_length1;
				gint _halves_size_;
				gchar** _tmp2_;
				gint _tmp2__length1;
				_tmp1_ = _tmp0_ = g_strsplit (detail, "\n\n", 2);
				halves = _tmp1_;
				halves_length1 = _vala_array_length (_tmp0_);
				_halves_size_ = halves_length1;
				_tmp2_ = halves;
				_tmp2__length1 = halves_length1;
				if (_tmp2__length1 == 1) {
					GtkLabel* _tmp3_;
					_tmp3_ = self->summary_label;
					gtk_label_set_label (_tmp3_, detail);
				} else {
					gchar** _tmp4_;
					gint _tmp4__length1;
					_tmp4_ = halves;
					_tmp4__length1 = halves_length1;
					if (_tmp4__length1 == 2) {
						GtkLabel* _tmp5_;
						gchar** _tmp6_;
						gint _tmp6__length1;
						const gchar* _tmp7_;
						gchar** _tmp8_;
						gint _tmp8__length1;
						const gchar* _tmp9_;
						_tmp5_ = self->summary_label;
						_tmp6_ = halves;
						_tmp6__length1 = halves_length1;
						_tmp7_ = _tmp6_[0];
						gtk_label_set_label (_tmp5_, _tmp7_);
						_tmp8_ = halves;
						_tmp8__length1 = halves_length1;
						_tmp9_ = _tmp8_[1];
						assistant_operation_show_detail (self, _tmp9_);
					}
				}
				halves = (_vala_array_free (halves, halves_length1, (GDestroyNotify) g_free), NULL);
			}
			_tmp10_ = self->priv->_summary_page;
			assistant_go_to_page ((Assistant*) self, _tmp10_);
		}
	}
}

void
assistant_operation_apply_finished (AssistantOperation* self,
                                    DejaDupOperation* op,
                                    gboolean success,
                                    gboolean cancelled,
                                    const gchar* detail)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->apply_finished) {
		_klass_->apply_finished (self, op, success, cancelled, detail);
	}
}

void
assistant_operation_show_oauth_consent_page (AssistantOperation* self,
                                             const gchar* message,
                                             const gchar* url)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->consent_label;
	gtk_label_set_label (_tmp0_, message);
	_tmp1_ = g_strdup (url);
	_g_free0 (self->priv->consent_url);
	self->priv->consent_url = _tmp1_;
	if (url == NULL) {
		assistant_go_forward ((Assistant*) self);
	} else {
		GtkGrid* _tmp2_;
		_tmp2_ = self->priv->_consent_page;
		assistant_interrupt ((Assistant*) self, (GtkWidget*) _tmp2_, FALSE, FALSE);
	}
}

static void
assistant_operation_do_apply_data_free (gpointer _data)
{
	AssistantOperationDoApplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantOperationDoApplyData, _data_);
}

void
assistant_operation_do_apply (AssistantOperation* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	AssistantOperationDoApplyData* _data_;
	AssistantOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AssistantOperationDoApplyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_operation_do_apply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_operation_do_apply_co (_data_);
}

void
assistant_operation_do_apply_finish (AssistantOperation* self,
                                     GAsyncResult* _res_)
{
	AssistantOperationDoApplyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
assistant_operation_do_apply_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	AssistantOperationDoApplyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_operation_do_apply_co (_data_);
}

static void
_assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender,
                                                             gboolean success,
                                                             gboolean cancelled,
                                                             const gchar* detail,
                                                             gpointer self)
{
	assistant_operation_apply_finished ((AssistantOperation*) self, _sender, success, cancelled, detail);
}

static void
_assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender,
                                                                                const gchar* action,
                                                                                gpointer self)
{
	assistant_operation_set_progress_label ((AssistantOperation*) self, _sender, action);
}

static void
_assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender,
                                                                                     GFile* file,
                                                                                     gboolean actual,
                                                                                     gpointer self)
{
	assistant_operation_set_progress_label_file ((AssistantOperation*) self, _sender, file, actual);
}

static void
_assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender,
                                                                gdouble percent,
                                                                gpointer self)
{
	assistant_operation_show_progress ((AssistantOperation*) self, _sender, percent);
}

static gboolean
assistant_operation_do_apply_co (AssistantOperationDoApplyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	assistant_operation_create_op (_data_->self, assistant_operation_do_apply_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = assistant_operation_create_op_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->self->op);
	_data_->self->op = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->op;
	if (_data_->_tmp1_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->op;
	assistant_operation_connect_operation (_data_->self, _data_->_tmp2_);
	_data_->_tmp3_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp3_, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp4_, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, _data_->self, 0);
	_data_->_tmp5_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp5_, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, _data_->self, 0);
	_data_->_tmp6_ = _data_->self->op;
	g_signal_connect_object (_data_->_tmp6_, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, _data_->self, 0);
	_data_->_tmp7_ = _data_->self->op;
	deja_dup_operation_start (_data_->_tmp7_, NULL, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda6_ (AssistantOperation* self,
            DejaDupOperation* o,
            const gchar* e,
            const gchar* d)
{
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error (self, e, d);
}

static void
___lambda6__deja_dup_operation_raise_error (DejaDupOperation* _sender,
                                            const gchar* errstr,
                                            const gchar* detail,
                                            gpointer self)
{
	__lambda6_ ((AssistantOperation*) self, _sender, errstr, detail);
}

static void
_assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender,
                                                                            gpointer self)
{
	assistant_operation_get_passphrase ((AssistantOperation*) self);
}

static void
_assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender,
                                                                const gchar* title,
                                                                const gchar* msg,
                                                                gpointer self)
{
	assistant_operation_show_question ((AssistantOperation*) self, _sender, title, msg);
}

static void
_assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender,
                                                         const gchar* header,
                                                         const gchar* msg,
                                                         gpointer self)
{
	assistant_operation_pause_op ((AssistantOperation*) self, _sender, header, msg);
}

static void
_assistant_operation_show_oauth_consent_page_deja_dup_backend_show_oauth_consent_page (DejaDupBackend* _sender,
                                                                                       const gchar* message,
                                                                                       const gchar* url,
                                                                                       gpointer self)
{
	assistant_operation_show_oauth_consent_page ((AssistantOperation*) self, message, url);
}

void
assistant_operation_connect_operation (AssistantOperation* self,
                                       DejaDupOperation* operation)
{
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	MountOperationAssistant* _tmp2_;
	MountOperationAssistant* _tmp3_;
	DejaDupBackend* _tmp4_;
	DejaDupBackend* _tmp5_;
	DejaDupBackend* _tmp6_;
	DejaDupBackend* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_signal_connect_object (operation, "raise-error", (GCallback) ___lambda6__deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object (operation, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, self, 0);
	g_signal_connect_object (operation, "question", (GCallback) _assistant_operation_show_question_deja_dup_operation_question, self, 0);
	_tmp0_ = deja_dup_operation_get_backend (operation);
	_tmp1_ = _tmp0_;
	_tmp2_ = mount_operation_assistant_new (self);
	_tmp3_ = _tmp2_;
	deja_dup_backend_set_mount_op (_tmp1_, (GMountOperation*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = deja_dup_operation_get_backend (operation);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, self, 0);
	_tmp6_ = deja_dup_operation_get_backend (operation);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "show-oauth-consent-page", (GCallback) _assistant_operation_show_oauth_consent_page_deja_dup_backend_show_oauth_consent_page, self, 0);
}

static gboolean
_assistant_operation_pulse_gsource_func (gpointer self)
{
	gboolean result;
	result = assistant_operation_pulse ((AssistantOperation*) self);
	return result;
}

static void
assistant_operation_real_do_prepare (AssistantOperation* self,
                                     Assistant* assist,
                                     GtkWidget* page)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = self->priv->_confirm_page;
	if (page == _tmp0_) {
		DejaDupOperation* _tmp1_;
		_tmp1_ = self->op;
		if (_tmp1_ != NULL) {
			DejaDupOperation* _tmp2_;
			guint _tmp3_;
			DejaDupOperation* _tmp4_;
			_tmp2_ = self->op;
			g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp3_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			_tmp4_ = self->op;
			deja_dup_operation_cancel (_tmp4_);
			_g_object_unref0 (self->op);
			self->op = NULL;
		}
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->_progress_page;
		if (page == _tmp5_) {
			GtkProgressBar* _tmp6_;
			gboolean _tmp7_ = FALSE;
			DejaDupOperation* _tmp8_;
			_tmp6_ = self->priv->progress_bar;
			gtk_progress_bar_set_fraction (_tmp6_, (gdouble) 0);
			self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
			_tmp8_ = self->op;
			if (_tmp8_ != NULL) {
				DejaDupOperation* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = self->op;
				_tmp10_ = deja_dup_operation_get_needs_password (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				assistant_operation_provide_password (self, NULL, NULL);
			} else {
				DejaDupOperation* _tmp12_;
				_tmp12_ = self->op;
				if (_tmp12_ == NULL) {
					assistant_operation_do_apply (self, NULL, NULL);
				}
			}
		}
	}
}

void
assistant_operation_do_prepare (AssistantOperation* self,
                                Assistant* assist,
                                GtkWidget* page)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->do_prepare) {
		_klass_->do_prepare (self, assist, page);
	}
}

void
assistant_operation_hide_everything (AssistantOperation* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	notifications_close_all ();
}

void
assistant_operation_stop (AssistantOperation* self)
{
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything (self);
	_tmp0_ = self->op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_;
		_tmp1_ = self->op;
		deja_dup_operation_stop (_tmp1_);
	}
}

gboolean
assistant_operation_has_active_op (AssistantOperation* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	DejaDupOperation* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->op;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		_tmp3_ = ((Assistant*) self)->current;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		_tmp4_ = ((Assistant*) self)->current;
		_tmp5_ = _tmp4_->data;
		_tmp0_ = !assistant_is_interrupt_type (((AssistantPageInfo*) _tmp5_)->type);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
assistant_operation_real_do_cancel (AssistantOperation* self)
{
	DejaDupOperation* _tmp0_;
	assistant_operation_hide_everything (self);
	_tmp0_ = self->op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_;
		_tmp1_ = self->op;
		deja_dup_operation_cancel (_tmp1_);
	} else {
		assistant_operation_do_close (self);
	}
}

void
assistant_operation_do_cancel (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->do_cancel) {
		_klass_->do_cancel (self);
	}
}

void
assistant_operation_do_delete (AssistantOperation* self)
{
	DejaDupOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything (self);
	_tmp0_ = self->op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_;
		_tmp1_ = self->op;
		deja_dup_operation_stop (_tmp1_);
	} else {
		assistant_operation_do_close (self);
	}
}

static void
assistant_operation_real_do_close (AssistantOperation* self)
{
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	g_signal_emit (self, assistant_operation_signals[ASSISTANT_OPERATION_CLOSING_SIGNAL], 0);
	gtk_window_destroy ((GtkWindow*) self);
}

void
assistant_operation_do_close (AssistantOperation* self)
{
	AssistantOperationClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_OPERATION_GET_CLASS (self);
	if (_klass_->do_close) {
		_klass_->do_close (self);
	}
}

void
assistant_operation_get_passphrase (AssistantOperation* self)
{
	g_return_if_fail (self != NULL);
	assistant_operation_ask_passphrase (self, FALSE);
}

static void
assistant_operation_check_password_validity (AssistantOperation* self)
{
	SwitchRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* passphrase = NULL;
	AdwPasswordEntryRow* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean passphrase_entered = FALSE;
	const gchar* _tmp6_;
	AdwPasswordEntryRow* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->encrypt_enabled;
	_tmp1_ = switch_row_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		assistant_allow_forward ((Assistant*) self, TRUE);
		return;
	}
	_tmp3_ = self->priv->encrypt_entry;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	passphrase = _tmp5_;
	_tmp6_ = passphrase;
	passphrase_entered = g_strcmp0 (_tmp6_, "") != 0;
	_tmp7_ = self->priv->confirm_entry;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gchar* passphrase2 = NULL;
		AdwPasswordEntryRow* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean valid = FALSE;
		_tmp10_ = self->priv->confirm_entry;
		_tmp11_ = gtk_editable_get_text ((GtkEditable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		passphrase2 = _tmp13_;
		_tmp15_ = passphrase;
		_tmp16_ = passphrase2;
		if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
			_tmp14_ = passphrase_entered;
		} else {
			_tmp14_ = FALSE;
		}
		valid = _tmp14_;
		if (passphrase_entered) {
			AdwPasswordEntryRow* _tmp17_;
			_tmp17_ = self->priv->encrypt_entry;
			gtk_widget_remove_css_class ((GtkWidget*) _tmp17_, "error");
		} else {
			AdwPasswordEntryRow* _tmp18_;
			_tmp18_ = self->priv->encrypt_entry;
			gtk_widget_add_css_class ((GtkWidget*) _tmp18_, "error");
		}
		if (valid) {
			AdwPasswordEntryRow* _tmp19_;
			_tmp19_ = self->priv->confirm_entry;
			gtk_widget_remove_css_class ((GtkWidget*) _tmp19_, "error");
		} else {
			AdwPasswordEntryRow* _tmp20_;
			_tmp20_ = self->priv->confirm_entry;
			gtk_widget_add_css_class ((GtkWidget*) _tmp20_, "error");
		}
		assistant_allow_forward ((Assistant*) self, valid);
		_g_free0 (passphrase2);
	} else {
		assistant_allow_forward ((Assistant*) self, passphrase_entered);
	}
	_g_free0 (passphrase);
}

static void
assistant_operation_configure_password_page (AssistantOperation* self,
                                             gboolean first)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp8_;
	GList* _tmp16_;
	AdwPasswordEntryRow* _tmp19_;
	AdwPasswordEntryRow* _tmp20_;
	g_return_if_fail (self != NULL);
	if (first) {
		DejaDupToolPlugin* _tmp1_;
		DejaDupToolPlugin* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = deja_dup_get_tool ();
		_tmp2_ = _tmp1_;
		_tmp3_ = deja_dup_tool_plugin_get_requires_encryption (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->_password_page;
		assistant_set_page_title ((Assistant*) self, _tmp5_, _ ("Set Encryption Password"));
	} else {
		if (first) {
			GtkWidget* _tmp6_;
			_tmp6_ = self->priv->_password_page;
			assistant_set_page_title ((Assistant*) self, _tmp6_, _ ("Require Password?"));
		} else {
			GtkWidget* _tmp7_;
			_tmp7_ = self->priv->_password_page;
			assistant_set_page_title ((Assistant*) self, _tmp7_, _ ("Encryption Password Needed"));
		}
	}
	_tmp8_ = self->priv->encryption_choice_widgets;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp8_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp9_;
			GtkWidget* w = NULL;
			_tmp9_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				GtkWidget* _tmp15_;
				if (first) {
					DejaDupToolPlugin* _tmp11_;
					DejaDupToolPlugin* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp11_ = deja_dup_get_tool ();
					_tmp12_ = _tmp11_;
					_tmp13_ = deja_dup_tool_plugin_get_requires_encryption (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = !_tmp14_;
					_g_object_unref0 (_tmp12_);
				} else {
					_tmp10_ = FALSE;
				}
				_tmp15_ = w;
				gtk_widget_set_visible (_tmp15_, _tmp10_);
				_g_object_unref0 (w);
			}
		}
	}
	_tmp16_ = self->priv->first_password_widgets;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp16_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp17_;
			GtkWidget* w = NULL;
			_tmp17_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp17_;
			{
				GtkWidget* _tmp18_;
				_tmp18_ = w;
				gtk_widget_set_visible (_tmp18_, first);
				_g_object_unref0 (w);
			}
		}
	}
	assistant_operation_check_password_validity (self);
	_tmp19_ = self->priv->encrypt_entry;
	gtk_editable_select_region ((GtkEditable*) _tmp19_, 0, -1);
	_tmp20_ = self->priv->encrypt_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp20_);
}

static void
assistant_operation_check_nag_validity (AssistantOperation* self)
{
	AdwPasswordEntryRow* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nag_entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		assistant_allow_forward ((Assistant*) self, FALSE);
	} else {
		assistant_allow_forward ((Assistant*) self, TRUE);
	}
}

static void
assistant_operation_configure_nag_page (AssistantOperation* self)
{
	AdwPasswordEntryRow* _tmp0_;
	AdwPasswordEntryRow* _tmp1_;
	g_return_if_fail (self != NULL);
	assistant_operation_check_nag_validity (self);
	_tmp0_ = self->priv->nag_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, "");
	_tmp1_ = self->priv->nag_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}

static void
_assistant_operation_stop_password_loop_assistant_operation_closing (AssistantOperation* _sender,
                                                                     gpointer self)
{
	assistant_operation_stop_password_loop ((AssistantOperation*) self);
}

static void
assistant_operation_stop_password_loop (AssistantOperation* self)
{
	GMainLoop* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->password_ask_loop;
	g_main_loop_quit (_tmp0_);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = NULL;
	g_signal_parse_name ("closing", TYPE_ASSISTANT_OPERATION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _assistant_operation_stop_password_loop_assistant_operation_closing, self);
}

void
assistant_operation_ask_passphrase (AssistantOperation* self,
                                    gboolean first)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GMainLoop* _tmp6_;
	GMainLoop* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->op;
	deja_dup_operation_set_needs_password (_tmp0_, TRUE);
	_tmp1_ = self->op;
	_tmp2_ = deja_dup_operation_get_use_cached_password (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkWidget* _tmp4_;
		_tmp4_ = self->priv->_password_page;
		assistant_interrupt ((Assistant*) self, _tmp4_, TRUE, FALSE);
		assistant_operation_configure_password_page (self, first);
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->_nag_page;
		assistant_interrupt ((Assistant*) self, _tmp5_, TRUE, TRUE);
		assistant_operation_configure_nag_page (self);
		self->nagged = TRUE;
	}
	notifications_attention_needed ((GtkWindow*) self, _ ("Backups needs your encryption password to continue"), NULL);
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	self->priv->password_ask_loop = _tmp6_;
	g_signal_connect_object (self, "closing", (GCallback) _assistant_operation_stop_password_loop_assistant_operation_closing, self, 0);
	_tmp7_ = self->priv->password_ask_loop;
	g_main_loop_run (_tmp7_);
}

static void
assistant_operation_provide_password_data_free (gpointer _data)
{
	AssistantOperationProvidePasswordData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantOperationProvidePasswordData, _data_);
}

void
assistant_operation_provide_password (AssistantOperation* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	AssistantOperationProvidePasswordData* _data_;
	AssistantOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AssistantOperationProvidePasswordData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_operation_provide_password_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_operation_provide_password_co (_data_);
}

void
assistant_operation_provide_password_finish (AssistantOperation* self,
                                             GAsyncResult* _res_)
{
	AssistantOperationProvidePasswordData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
assistant_operation_provide_password_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	AssistantOperationProvidePasswordData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_operation_provide_password_co (_data_);
}

static gboolean
assistant_operation_provide_password_co (AssistantOperationProvidePasswordData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->passphrase = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->op;
	_data_->_tmp2_ = deja_dup_operation_get_use_cached_password (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = _data_->self->priv->encrypt_enabled;
		_data_->_tmp5_ = switch_row_get_active (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->encrypt_entry;
			_data_->_tmp8_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp7_);
			_data_->_tmp9_ = deja_dup_process_passphrase (_data_->_tmp8_);
			_g_free0 (_data_->passphrase);
			_data_->passphrase = _data_->_tmp9_;
		}
		_data_->_tmp11_ = _data_->passphrase;
		if (g_strcmp0 (_data_->_tmp11_, "") != 0) {
			_data_->_tmp12_ = _data_->self->priv->encrypt_remember;
			_data_->_tmp13_ = switch_row_get_active (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_tmp10_ = _data_->_tmp14_;
		} else {
			_data_->_tmp10_ = FALSE;
		}
		_data_->remember = _data_->_tmp10_;
		_data_->_tmp15_ = _data_->passphrase;
		_data_->_state_ = 1;
		deja_dup_store_passphrase (_data_->_tmp15_, _data_->remember, assistant_operation_provide_password_ready, _data_);
		return FALSE;
		_state_1:
		deja_dup_store_passphrase_finish (_data_->_res_);
	} else {
		_data_->_tmp16_ = _data_->self->priv->nag_entry;
		_data_->_tmp17_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = deja_dup_process_passphrase (_data_->_tmp18_);
		_g_free0 (_data_->passphrase);
		_data_->passphrase = _data_->_tmp19_;
	}
	_data_->_tmp20_ = _data_->self->op;
	_data_->_tmp21_ = _data_->passphrase;
	deja_dup_operation_set_passphrase (_data_->_tmp20_, _data_->_tmp21_);
	assistant_operation_stop_password_loop (_data_->self);
	_g_free0 (_data_->passphrase);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_main_loop_quit_assistant_operation_closing (AssistantOperation* _sender,
                                               gpointer self)
{
	g_main_loop_quit ((GMainLoop*) self);
}

static void
_g_main_loop_quit_assistant_forward (Assistant* _sender,
                                     gpointer self)
{
	g_main_loop_quit ((GMainLoop*) self);
}

static void
assistant_operation_show_question (AssistantOperation* self,
                                   DejaDupOperation* op,
                                   const gchar* title,
                                   const gchar* message)
{
	GtkWidget* _tmp0_;
	GtkLabel* _tmp1_;
	GtkWidget* _tmp2_;
	GMainLoop* loop = NULL;
	GMainLoop* _tmp3_;
	gulong closing_id = 0UL;
	gulong _tmp4_;
	gulong forward_id = 0UL;
	gulong _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_question_page;
	assistant_set_page_title ((Assistant*) self, _tmp0_, title);
	_tmp1_ = self->priv->question_label;
	gtk_label_set_label (_tmp1_, message);
	_tmp2_ = self->priv->_question_page;
	assistant_interrupt ((Assistant*) self, _tmp2_, TRUE, FALSE);
	notifications_attention_needed ((GtkWindow*) self, _ ("Backups needs your input to continue"), title);
	_tmp3_ = g_main_loop_new (NULL, FALSE);
	loop = _tmp3_;
	_tmp4_ = g_signal_connect (self, "closing", (GCallback) _g_main_loop_quit_assistant_operation_closing, loop);
	closing_id = _tmp4_;
	_tmp5_ = g_signal_connect ((Assistant*) self, "forward", (GCallback) _g_main_loop_quit_assistant_forward, loop);
	forward_id = _tmp5_;
	g_main_loop_run (loop);
	g_signal_handler_disconnect ((GObject*) self, closing_id);
	g_signal_handler_disconnect ((GObject*) self, forward_id);
	_g_main_loop_unref0 (loop);
}

void
assistant_operation_pause_op (AssistantOperation* self,
                              DejaDupBackend* back,
                              const gchar* header,
                              const gchar* msg)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (back != NULL);
	if (header == NULL) {
		notifications_operation_unblocked ();
		assistant_go_forward ((Assistant*) self);
	} else {
		GtkWidget* _tmp0_;
		GtkLabel* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = self->priv->_question_page;
		assistant_set_page_title ((Assistant*) self, _tmp0_, header);
		_tmp1_ = self->priv->question_label;
		gtk_label_set_label (_tmp1_, msg);
		_tmp2_ = self->priv->_question_page;
		assistant_interrupt ((Assistant*) self, _tmp2_, FALSE, FALSE);
		notifications_operation_blocked ((GtkWindow*) self, header, msg);
	}
}

AssistantOperation*
assistant_operation_construct (GType object_type)
{
	AssistantOperation * self = NULL;
	self = (AssistantOperation*) assistant_construct (object_type);
	return self;
}

GtkWidget*
assistant_operation_get_confirm_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_confirm_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_confirm_page (AssistantOperation* self,
                                      GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_confirm_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_confirm_page);
		self->priv->_confirm_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_backend_install_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_install_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_backend_install_page (AssistantOperation* self,
                                              GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_backend_install_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_backend_install_page);
		self->priv->_backend_install_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_password_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_password_page (AssistantOperation* self,
                                       GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_password_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_password_page);
		self->priv->_password_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_nag_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nag_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_nag_page (AssistantOperation* self,
                                  GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_nag_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_nag_page);
		self->priv->_nag_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_NAG_PAGE_PROPERTY]);
	}
}

GtkGrid*
assistant_operation_get_consent_page (AssistantOperation* self)
{
	GtkGrid* result;
	GtkGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_consent_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_consent_page (AssistantOperation* self,
                                      GtkGrid* value)
{
	GtkGrid* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_consent_page (self);
	if (old_value != value) {
		GtkGrid* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_consent_page);
		self->priv->_consent_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_question_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_question_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_question_page (AssistantOperation* self,
                                       GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_question_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_question_page);
		self->priv->_question_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_progress_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_progress_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_progress_page (AssistantOperation* self,
                                       GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_progress_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_progress_page);
		self->priv->_progress_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY]);
	}
}

GtkWidget*
assistant_operation_get_summary_page (AssistantOperation* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary_page;
	result = _tmp0_;
	return result;
}

static void
assistant_operation_set_summary_page (AssistantOperation* self,
                                      GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_summary_page (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_summary_page);
		self->priv->_summary_page = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY]);
	}
}

gboolean
assistant_operation_get_error_occurred (AssistantOperation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_occurred;
	return result;
}

static void
assistant_operation_set_error_occurred (AssistantOperation* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_operation_get_error_occurred (self);
	if (old_value != value) {
		self->priv->_error_occurred = value;
		g_object_notify_by_pspec ((GObject *) self, assistant_operation_properties[ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY]);
	}
}

static gboolean
_assistant_operation___lambda12_ (AssistantOperation* self)
{
	gboolean result;
	assistant_operation_add_custom_config_pages (self);
	assistant_operation_add_backend_install_page (self);
	assistant_operation_add_setup_pages (self);
	assistant_operation_add_confirm_page (self);
	assistant_operation_add_password_page (self);
	assistant_operation_add_nag_page (self);
	assistant_operation_add_consent_page (self);
	assistant_operation_add_question_page (self);
	assistant_operation_add_progress_page (self);
	assistant_operation_add_summary_page (self);
	result = FALSE;
	return result;
}

static gboolean
__assistant_operation___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = _assistant_operation___lambda12_ ((AssistantOperation*) self);
	return result;
}

static void
_assistant_operation_do_cancel_assistant_canceled (Assistant* _sender,
                                                   gpointer self)
{
	assistant_operation_do_cancel ((AssistantOperation*) self);
}

static void
_assistant_operation_do_delete_assistant_closed (Assistant* _sender,
                                                 gpointer self)
{
	assistant_operation_do_delete ((AssistantOperation*) self);
}

static void
_assistant_operation_do_delete_assistant_resumed (Assistant* _sender,
                                                  gpointer self)
{
	assistant_operation_do_delete ((AssistantOperation*) self);
}

static gboolean
_assistant_operation___lambda13_ (AssistantOperation* self)
{
	gboolean result;
	assistant_operation_do_delete (self);
	result = TRUE;
	return result;
}

static gboolean
__assistant_operation___lambda13__gtk_window_close_request (GtkWindow* _sender,
                                                            gpointer self)
{
	gboolean result;
	result = _assistant_operation___lambda13_ ((AssistantOperation*) self);
	return result;
}

static void
_assistant_operation_do_prepare_assistant_prepare (Assistant* _sender,
                                                   GtkWidget* page,
                                                   gpointer self)
{
	assistant_operation_do_prepare ((AssistantOperation*) self, _sender, page);
}

static GObject *
assistant_operation_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __assistant_operation___lambda12__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((Assistant*) self, "canceled", (GCallback) _assistant_operation_do_cancel_assistant_canceled, self, 0);
	g_signal_connect_object ((Assistant*) self, "closed", (GCallback) _assistant_operation_do_delete_assistant_closed, self, 0);
	g_signal_connect_object ((Assistant*) self, "resumed", (GCallback) _assistant_operation_do_delete_assistant_resumed, self, 0);
	g_signal_connect_object ((GtkWindow*) self, "close-request", (GCallback) __assistant_operation___lambda13__gtk_window_close_request, self, 0);
	g_signal_connect_object ((Assistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_assistant_prepare, self, 0);
	return obj;
}

static void
assistant_operation_class_init (AssistantOperationClass * klass,
                                gpointer klass_data)
{
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AssistantOperation_private_offset);
	((AssistantOperationClass *) klass)->make_confirm_page = (GtkWidget* (*) (AssistantOperation*)) assistant_operation_real_make_confirm_page;
	((AssistantOperationClass *) klass)->add_setup_pages = (void (*) (AssistantOperation*)) assistant_operation_real_add_setup_pages;
	((AssistantOperationClass *) klass)->add_custom_config_pages = (void (*) (AssistantOperation*)) assistant_operation_real_add_custom_config_pages;
	((AssistantOperationClass *) klass)->get_progress_file_prefix = (gchar* (*) (AssistantOperation*)) assistant_operation_real_get_progress_file_prefix;
	((AssistantOperationClass *) klass)->get_apply_text = (gchar* (*) (AssistantOperation*)) assistant_operation_real_get_apply_text;
	((AssistantOperationClass *) klass)->make_progress_page = (GtkWidget* (*) (AssistantOperation*)) assistant_operation_real_make_progress_page;
	((AssistantOperationClass *) klass)->show_error = (void (*) (AssistantOperation*, const gchar*, const gchar*)) assistant_operation_real_show_error;
	((AssistantOperationClass *) klass)->make_summary_page = (GtkWidget* (*) (AssistantOperation*)) assistant_operation_real_make_summary_page;
	((AssistantOperationClass *) klass)->apply_finished = (void (*) (AssistantOperation*, DejaDupOperation*, gboolean, gboolean, const gchar*)) assistant_operation_real_apply_finished;
	((AssistantOperationClass *) klass)->do_prepare = (void (*) (AssistantOperation*, Assistant*, GtkWidget*)) assistant_operation_real_do_prepare;
	((AssistantOperationClass *) klass)->do_cancel = (void (*) (AssistantOperation*)) assistant_operation_real_do_cancel;
	((AssistantOperationClass *) klass)->do_close = (void (*) (AssistantOperation*)) assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY] = g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY] = g_param_spec_object ("backend-install-page", "backend-install-page", "backend-install-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY] = g_param_spec_object ("password-page", "password-page", "password-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_NAG_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_NAG_PAGE_PROPERTY] = g_param_spec_object ("nag-page", "nag-page", "nag-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY] = g_param_spec_object ("consent-page", "consent-page", "consent-page", gtk_grid_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY] = g_param_spec_object ("question-page", "question-page", "question-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY] = g_param_spec_object ("progress-page", "progress-page", "progress-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY] = g_param_spec_object ("summary-page", "summary-page", "summary-page", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY, assistant_operation_properties[ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY] = g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	assistant_operation_signals[ASSISTANT_OPERATION_CLOSING_SIGNAL] = g_signal_new ("closing", TYPE_ASSISTANT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
assistant_operation_instance_init (AssistantOperation * self,
                                   gpointer klass)
{
	self->priv = assistant_operation_get_instance_private (self);
	self->priv->adjustment_at_end = TRUE;
	self->priv->adjusting_text = FALSE;
}

static void
assistant_operation_finalize (GObject * obj)
{
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->priv->_backend_install_page);
	_g_object_unref0 (self->priv->backend_install_desc);
	_g_object_unref0 (self->priv->backend_install_packages);
	_g_object_unref0 (self->priv->backend_install_progress);
	_g_object_unref0 (self->priv->nag_entry);
	_g_object_unref0 (self->priv->encrypt_entry);
	_g_object_unref0 (self->priv->confirm_entry);
	_g_object_unref0 (self->priv->encrypt_enabled);
	_g_object_unref0 (self->priv->encrypt_remember);
	_g_object_unref0 (self->priv->_password_page);
	_g_object_unref0 (self->priv->_nag_page);
	(self->priv->encryption_choice_widgets == NULL) ? NULL : (self->priv->encryption_choice_widgets = (_g_list_free__g_object_unref0_ (self->priv->encryption_choice_widgets), NULL));
	(self->priv->first_password_widgets == NULL) ? NULL : (self->priv->first_password_widgets = (_g_list_free__g_object_unref0_ (self->priv->first_password_widgets), NULL));
	_g_main_loop_unref0 (self->priv->password_ask_loop);
	_g_object_unref0 (self->priv->consent_label);
	_g_free0 (self->priv->consent_url);
	_g_object_unref0 (self->priv->_consent_page);
	_g_object_unref0 (self->priv->question_label);
	_g_object_unref0 (self->priv->_question_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->secondary_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->progress_expander);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->detail_widget);
	_g_object_unref0 (self->priv->detail_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
assistant_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
	GType assistant_operation_type_id;
	assistant_operation_type_id = g_type_register_static (TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	AssistantOperation_private_offset = g_type_add_instance_private (assistant_operation_type_id, sizeof (AssistantOperationPrivate));
	return assistant_operation_type_id;
}

GType
assistant_operation_get_type (void)
{
	static gsize assistant_operation_type_id__once = 0;
	if (g_once_init_enter (&assistant_operation_type_id__once)) {
		GType assistant_operation_type_id;
		assistant_operation_type_id = assistant_operation_get_type_once ();
		g_once_init_leave (&assistant_operation_type_id__once, assistant_operation_type_id);
	}
	return assistant_operation_type_id__once;
}

static void
_vala_assistant_operation_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_backend_install_page (self));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_password_page (self));
		break;
		case ASSISTANT_OPERATION_NAG_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_nag_page (self));
		break;
		case ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_consent_page (self));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_question_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_assistant_operation_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	AssistantOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_OPERATION, AssistantOperation);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE_PROPERTY:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_BACKEND_INSTALL_PAGE_PROPERTY:
		assistant_operation_set_backend_install_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE_PROPERTY:
		assistant_operation_set_password_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_NAG_PAGE_PROPERTY:
		assistant_operation_set_nag_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_CONSENT_PAGE_PROPERTY:
		assistant_operation_set_consent_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE_PROPERTY:
		assistant_operation_set_question_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE_PROPERTY:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE_PROPERTY:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED_PROPERTY:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

