/* AssistantBackup.c generated by valac 0.56.14, the Vala compiler
 * generated from AssistantBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "deja.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_ASSISTANT_BACKUP (assistant_backup_get_type ())
#define ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackup))
#define ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))
#define IS_ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_BACKUP))
#define IS_ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_BACKUP))
#define ASSISTANT_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))

typedef struct _AssistantBackup AssistantBackup;
typedef struct _AssistantBackupClass AssistantBackupClass;
typedef struct _AssistantBackupPrivate AssistantBackupPrivate;
enum  {
	ASSISTANT_BACKUP_0_PROPERTY,
	ASSISTANT_BACKUP_AUTOMATIC_PROPERTY,
	ASSISTANT_BACKUP_NUM_PROPERTIES
};
static GParamSpec* assistant_backup_properties[ASSISTANT_BACKUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONFIG_FOLDER_PAGE (config_folder_page_get_type ())
#define CONFIG_FOLDER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_FOLDER_PAGE, ConfigFolderPage))
#define CONFIG_FOLDER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_FOLDER_PAGE, ConfigFolderPageClass))
#define IS_CONFIG_FOLDER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_FOLDER_PAGE))
#define IS_CONFIG_FOLDER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_FOLDER_PAGE))
#define CONFIG_FOLDER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_FOLDER_PAGE, ConfigFolderPageClass))

typedef struct _ConfigFolderPage ConfigFolderPage;
typedef struct _ConfigFolderPageClass ConfigFolderPageClass;
typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_DYNAMIC_PREFERENCES_GROUP (dynamic_preferences_group_get_type ())
#define DYNAMIC_PREFERENCES_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DYNAMIC_PREFERENCES_GROUP, DynamicPreferencesGroup))
#define DYNAMIC_PREFERENCES_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DYNAMIC_PREFERENCES_GROUP, DynamicPreferencesGroupClass))
#define IS_DYNAMIC_PREFERENCES_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DYNAMIC_PREFERENCES_GROUP))
#define IS_DYNAMIC_PREFERENCES_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DYNAMIC_PREFERENCES_GROUP))
#define DYNAMIC_PREFERENCES_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DYNAMIC_PREFERENCES_GROUP, DynamicPreferencesGroupClass))

typedef struct _DynamicPreferencesGroup DynamicPreferencesGroup;
typedef struct _DynamicPreferencesGroupClass DynamicPreferencesGroupClass;

#define TYPE_CONFIG_LOCATION_GROUP (config_location_group_get_type ())
#define CONFIG_LOCATION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_LOCATION_GROUP, ConfigLocationGroup))
#define CONFIG_LOCATION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_LOCATION_GROUP, ConfigLocationGroupClass))
#define IS_CONFIG_LOCATION_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_LOCATION_GROUP))
#define IS_CONFIG_LOCATION_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_LOCATION_GROUP))
#define CONFIG_LOCATION_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_LOCATION_GROUP, ConfigLocationGroupClass))

typedef struct _ConfigLocationGroup ConfigLocationGroup;
typedef struct _ConfigLocationGroupClass ConfigLocationGroupClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AssistantBackupGetUnavailableIncludesData AssistantBackupGetUnavailableIncludesData;
typedef struct _AssistantBackupCreateOpData AssistantBackupCreateOpData;

struct _Assistant {
	AdwWindow parent_instance;
	AssistantPrivate * priv;
	gchar* default_title;
	GtkWidget* forward_button;
	GtkStack* page_box;
	gboolean can_resume;
	GList* first_shown;
	GList* current;
};

struct _AssistantClass {
	AdwWindowClass parent_class;
	void (*set_buttons) (Assistant* self);
	guint (*inhibit) (Assistant* self, GtkApplication* app);
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	void (*create_op) (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	DejaDupOperation* (*create_op_finish) (AssistantOperation* self, GAsyncResult* _res_);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	gchar* (*get_apply_text) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantBackup {
	AssistantOperation parent_instance;
	AssistantBackupPrivate * priv;
};

struct _AssistantBackupClass {
	AssistantOperationClass parent_class;
};

struct _AssistantBackupPrivate {
	gboolean _automatic;
	GtkWidget* include_exclude_page;
};

struct _AssistantBackupGetUnavailableIncludesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantBackup* self;
	gchar** result;
	gint result_length1;
	gchar** unavailable;
	gchar** _tmp0_;
	gint unavailable_length1;
	gint _unavailable_size_;
	DejaDupInstallEnv* install_env;
	DejaDupInstallEnv* _tmp1_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp2_;
	GFile** include_list;
	DejaDupFilteredSettings* _tmp3_;
	gint _tmp4_;
	GFile** _tmp5_;
	gint include_list_length1;
	gint _include_list_size_;
	GFile** _tmp6_;
	gint _tmp6__length1;
	GFile** include_collection;
	gint include_collection_length1;
	gint _include_collection_size_;
	gint include_it;
	GFile* _tmp7_;
	GFile* include;
	DejaDupInstallEnv* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
};

struct _AssistantBackupCreateOpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AssistantBackup* self;
	DejaDupOperation* result;
	gchar** unavailable;
	gint _tmp0_;
	gchar** _tmp1_;
	gint unavailable_length1;
	gint _unavailable_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* msg;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	DejaDupOperationBackup* rv;
	DejaDupBackend* _tmp12_;
	DejaDupBackend* _tmp13_;
	DejaDupOperationBackup* _tmp14_;
	DejaDupOperationBackup* _tmp15_;
	gboolean _tmp16_;
	DejaDupOperationBackup* _tmp17_;
	DejaDupOperationBackup* _tmp18_;
};

static gint AssistantBackup_private_offset;
static gpointer assistant_backup_parent_class = NULL;

VALA_EXTERN GType assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Assistant, g_object_unref)
VALA_EXTERN gpointer assistant_page_info_ref (gpointer instance);
VALA_EXTERN void assistant_page_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* assistant_param_spec_page_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void assistant_value_set_page_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void assistant_value_take_page_info (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer assistant_value_get_page_info (const GValue* value);
VALA_EXTERN GType assistant_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantPageInfo, assistant_page_info_unref)
VALA_EXTERN GType assistant_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantOperation, g_object_unref)
VALA_EXTERN GType assistant_backup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantBackup, g_object_unref)
VALA_EXTERN gchar* assistant_operation_get_apply_text (AssistantOperation* self);
VALA_EXTERN void assistant_operation_add_custom_config_pages (AssistantOperation* self);
VALA_EXTERN void assistant_operation_create_op (AssistantOperation* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN DejaDupOperation* assistant_operation_create_op_finish (AssistantOperation* self,
                                                        GAsyncResult* _res_);
VALA_EXTERN gchar* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
VALA_EXTERN void assistant_operation_do_prepare (AssistantOperation* self,
                                     Assistant* assist,
                                     GtkWidget* page);
VALA_EXTERN void assistant_operation_apply_finished (AssistantOperation* self,
                                         DejaDupOperation* op,
                                         gboolean success,
                                         gboolean cancelled,
                                         const gchar* detail);
VALA_EXTERN guint assistant_inhibit (Assistant* self,
                         GtkApplication* app);
VALA_EXTERN AssistantBackup* assistant_backup_new (gboolean automatic);
VALA_EXTERN AssistantBackup* assistant_backup_construct (GType object_type,
                                             gboolean automatic);
static gchar* assistant_backup_real_get_apply_text (AssistantOperation* base);
static void assistant_backup_real_add_custom_config_pages (AssistantOperation* base);
VALA_EXTERN ConfigFolderPage* config_folder_page_new (void);
VALA_EXTERN ConfigFolderPage* config_folder_page_construct (GType object_type);
VALA_EXTERN GType config_folder_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFolderPage, g_object_unref)
VALA_EXTERN GType assistant_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void assistant_append_page (Assistant* self,
                            GtkWidget* page,
                            AssistantType type,
                            const gchar* forward_text);
VALA_EXTERN ConfigLocationGroup* config_location_group_new (gboolean read_only);
VALA_EXTERN ConfigLocationGroup* config_location_group_construct (GType object_type,
                                                      gboolean read_only);
VALA_EXTERN GType dynamic_preferences_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DynamicPreferencesGroup, g_object_unref)
VALA_EXTERN GType config_location_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigLocationGroup, g_object_unref)
VALA_EXTERN void deja_dup_set_margins (GtkWidget* w,
                           gint margin);
static void assistant_backup_get_unavailable_includes_data_free (gpointer _data);
static void assistant_backup_get_unavailable_includes (AssistantBackup* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gchar** assistant_backup_get_unavailable_includes_finish (AssistantBackup* self,
                                                          GAsyncResult* _res_,
                                                          gint* result_length1);
static gboolean assistant_backup_get_unavailable_includes_co (AssistantBackupGetUnavailableIncludesData* _data_);
static void assistant_backup_get_unavailable_includes_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void assistant_backup_real_create_op_data_free (gpointer _data);
static void assistant_backup_real_create_op (AssistantOperation* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean assistant_backup_real_create_op_co (AssistantBackupCreateOpData* _data_);
static void assistant_backup_create_op_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
VALA_EXTERN void assistant_operation_show_error (AssistantOperation* self,
                                     const gchar* _error_,
                                     const gchar* detail);
VALA_EXTERN void notifications_backup_finished (GtkWindow* win,
                                    gboolean success,
                                    gboolean cancelled,
                                    const gchar* detail);
VALA_EXTERN gboolean assistant_backup_get_automatic (AssistantBackup* self);
static void __lambda33_ (AssistantBackup* self,
                  DejaDupOperation* op,
                  gboolean first);
VALA_EXTERN void assistant_operation_set_secondary_label (AssistantOperation* self,
                                              const gchar* text);
VALA_EXTERN void assistant_operation_ask_passphrase (AssistantOperation* self,
                                         gboolean first);
static void ___lambda33__deja_dup_operation_is_full (DejaDupOperation* _sender,
                                              gboolean first,
                                              gpointer self);
static gchar* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_backup_real_do_prepare (AssistantOperation* base,
                                       Assistant* assist,
                                       GtkWidget* page);
VALA_EXTERN GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
VALA_EXTERN gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
VALA_EXTERN void assistant_set_page_title (Assistant* self,
                               GtkWidget* page,
                               const gchar* title);
VALA_EXTERN void assistant_operation_do_delete (AssistantOperation* self);
VALA_EXTERN GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
VALA_EXTERN void notifications_attention_needed (GtkWindow* win,
                                     const gchar* title,
                                     const gchar* body);
static void assistant_backup_real_apply_finished (AssistantOperation* base,
                                           DejaDupOperation* op,
                                           gboolean success,
                                           gboolean cancelled,
                                           const gchar* detail);
static guint assistant_backup_real_inhibit (Assistant* base,
                                     GtkApplication* app);
static void assistant_backup_set_automatic (AssistantBackup* self,
                                     gboolean value);
static GObject * assistant_backup_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void assistant_backup_finalize (GObject * obj);
static GType assistant_backup_get_type_once (void);
static void _vala_assistant_backup_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_assistant_backup_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
assistant_backup_get_instance_private (AssistantBackup* self)
{
	return G_STRUCT_MEMBER_P (self, AssistantBackup_private_offset);
}

AssistantBackup*
assistant_backup_construct (GType object_type,
                            gboolean automatic)
{
	AssistantBackup * self = NULL;
	self = (AssistantBackup*) g_object_new (object_type, "automatic", automatic, NULL);
	return self;
}

AssistantBackup*
assistant_backup_new (gboolean automatic)
{
	return assistant_backup_construct (TYPE_ASSISTANT_BACKUP, automatic);
}

static gchar*
assistant_backup_real_get_apply_text (AssistantOperation* base)
{
	AssistantBackup * self;
	gchar* _tmp0_;
	gchar* result;
	self = (AssistantBackup*) base;
	_tmp0_ = g_strdup (C_ ("back up is verb", "_Back Up"));
	result = _tmp0_;
	return result;
}

static void
assistant_backup_real_add_custom_config_pages (AssistantOperation* base)
{
	AssistantBackup * self;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* last_run = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	self = (AssistantBackup*) base;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_LAST_RUN_KEY);
	last_run = _tmp2_;
	_tmp3_ = last_run;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkScrolledWindow* scroll = NULL;
		GtkScrolledWindow* _tmp4_;
		GtkScrolledWindow* _tmp5_;
		ConfigFolderPage* _tmp6_;
		ConfigFolderPage* _tmp7_;
		GtkScrolledWindow* _tmp8_;
		AdwClamp* clamp = NULL;
		AdwClamp* _tmp9_;
		AdwClamp* _tmp10_;
		ConfigLocationGroup* _tmp11_;
		ConfigLocationGroup* _tmp12_;
		AdwClamp* _tmp13_;
		AdwClamp* _tmp14_;
		_tmp4_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
		g_object_ref_sink (_tmp4_);
		scroll = _tmp4_;
		_tmp5_ = scroll;
		_tmp6_ = config_folder_page_new ();
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		gtk_scrolled_window_set_child (_tmp5_, (GtkWidget*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = scroll;
		assistant_append_page ((Assistant*) self, (GtkWidget*) _tmp8_, ASSISTANT_TYPE_NORMAL, _ ("_Forward"));
		_tmp9_ = (AdwClamp*) adw_clamp_new ();
		g_object_ref_sink (_tmp9_);
		clamp = _tmp9_;
		_tmp10_ = clamp;
		_tmp11_ = config_location_group_new (FALSE);
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		adw_clamp_set_child (_tmp10_, (GtkWidget*) _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = clamp;
		deja_dup_set_margins ((GtkWidget*) _tmp13_, 12);
		_tmp14_ = clamp;
		assistant_append_page ((Assistant*) self, (GtkWidget*) _tmp14_, ASSISTANT_TYPE_NORMAL, _ ("_Forward"));
		_g_object_unref0 (clamp);
		_g_object_unref0 (scroll);
	}
	_g_free0 (last_run);
	_g_object_unref0 (settings);
}

static void
assistant_backup_get_unavailable_includes_data_free (gpointer _data)
{
	AssistantBackupGetUnavailableIncludesData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantBackupGetUnavailableIncludesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
assistant_backup_get_unavailable_includes (AssistantBackup* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	AssistantBackupGetUnavailableIncludesData* _data_;
	AssistantBackup* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AssistantBackupGetUnavailableIncludesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_backup_get_unavailable_includes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_backup_get_unavailable_includes_co (_data_);
}

static gchar**
assistant_backup_get_unavailable_includes_finish (AssistantBackup* self,
                                                  GAsyncResult* _res_,
                                                  gint* result_length1)
{
	gchar** result;
	AssistantBackupGetUnavailableIncludesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
assistant_backup_get_unavailable_includes_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	AssistantBackupGetUnavailableIncludesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_backup_get_unavailable_includes_co (_data_);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
assistant_backup_get_unavailable_includes_co (AssistantBackupGetUnavailableIncludesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->unavailable = _data_->_tmp0_;
	_data_->unavailable_length1 = 0;
	_data_->_unavailable_size_ = _data_->unavailable_length1;
	_data_->_tmp1_ = deja_dup_install_env_instance ();
	_data_->install_env = _data_->_tmp1_;
	_data_->_tmp2_ = deja_dup_get_settings (NULL);
	_data_->settings = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->settings;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = deja_dup_filtered_settings_get_file_list (_data_->_tmp3_, DEJA_DUP_INCLUDE_LIST_KEY, &_data_->_tmp4_);
	_data_->include_list = _data_->_tmp5_;
	_data_->include_list_length1 = _data_->_tmp4_;
	_data_->_include_list_size_ = _data_->include_list_length1;
	_data_->_tmp6_ = _data_->include_list;
	_data_->_tmp6__length1 = _data_->include_list_length1;
	{
		_data_->include_collection_length1 = 0;
		_data_->_include_collection_size_ = 0;
		_data_->include_collection = _data_->_tmp6_;
		_data_->include_collection_length1 = _data_->_tmp6__length1;
		for (_data_->include_it = 0; _data_->include_it < _data_->include_collection_length1; _data_->include_it = _data_->include_it + 1) {
			_data_->_tmp7_ = _g_object_ref0 (_data_->include_collection[_data_->include_it]);
			_data_->include = _data_->_tmp7_;
			{
				_data_->_tmp8_ = _data_->install_env;
				_data_->_tmp9_ = _data_->include;
				if (!deja_dup_install_env_is_file_available (_data_->_tmp8_, _data_->_tmp9_)) {
					_data_->_tmp10_ = _data_->include;
					_data_->_state_ = 1;
					deja_dup_get_nickname (_data_->_tmp10_, assistant_backup_get_unavailable_includes_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp11_ = deja_dup_get_nickname_finish (_data_->_res_);
					_vala_array_add1 (&_data_->unavailable, &_data_->unavailable_length1, &_data_->_unavailable_size_, _data_->_tmp11_);
				}
				_g_object_unref0 (_data_->include);
			}
		}
	}
	_data_->_tmp12_ = _data_->unavailable;
	_data_->_tmp12__length1 = _data_->unavailable_length1;
	_data_->result_length1 = _data_->_tmp12__length1;
	_data_->result = _data_->_tmp12_;
	_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->settings);
	_g_object_unref0 (_data_->install_env);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
assistant_backup_real_create_op_data_free (gpointer _data)
{
	AssistantBackupCreateOpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantBackupCreateOpData, _data_);
}

static void
assistant_backup_real_create_op (AssistantOperation* base,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AssistantBackup * self;
	AssistantBackupCreateOpData* _data_;
	AssistantBackup* _tmp0_;
	self = (AssistantBackup*) base;
	_data_ = g_slice_new0 (AssistantBackupCreateOpData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, assistant_backup_real_create_op_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_backup_real_create_op_co (_data_);
}

static DejaDupOperation*
assistant_backup_create_op_finish (AssistantOperation* base,
                                   GAsyncResult* _res_)
{
	DejaDupOperation* result;
	AssistantBackupCreateOpData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
assistant_backup_create_op_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	AssistantBackupCreateOpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	assistant_backup_real_create_op_co (_data_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
__lambda33_ (AssistantBackup* self,
             DejaDupOperation* op,
             gboolean first)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (op != NULL);
	deja_dup_operation_set_use_progress (op, TRUE);
	if (first) {
		_tmp0_ = _ ("Creating the first backup.  This may take a while.");
	} else {
		_tmp0_ = _ ("Creating a fresh backup to protect against backup corruption.  " "This will take longer than normal.");
	}
	assistant_operation_set_secondary_label ((AssistantOperation*) self, _tmp0_);
	if (first) {
		assistant_operation_ask_passphrase ((AssistantOperation*) self, first);
	}
}

static void
___lambda33__deja_dup_operation_is_full (DejaDupOperation* _sender,
                                         gboolean first,
                                         gpointer self)
{
	__lambda33_ ((AssistantBackup*) self, _sender, first);
}

static gboolean
assistant_backup_real_create_op_co (AssistantBackupCreateOpData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_state_ = 1;
	assistant_backup_get_unavailable_includes (_data_->self, assistant_backup_create_op_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = assistant_backup_get_unavailable_includes_finish (_data_->self, _data_->_res_, &_data_->_tmp0_);
	_data_->unavailable = _data_->_tmp1_;
	_data_->unavailable_length1 = _data_->_tmp0_;
	_data_->_unavailable_size_ = _data_->unavailable_length1;
	_data_->_tmp2_ = _data_->unavailable;
	_data_->_tmp2__length1 = _data_->unavailable_length1;
	if (_data_->_tmp2__length1 > 0) {
		_data_->_tmp3_ = g_strdup (_ ("The following folders cannot be backed up because Backups does not hav" \
"e access to them:"));
		_data_->msg = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->msg;
		_data_->_tmp5_ = _data_->unavailable;
		_data_->_tmp5__length1 = _data_->unavailable_length1;
		_data_->_tmp6_ = _vala_g_strjoinv (", ", _data_->_tmp5_, (gint) _data_->_tmp5__length1);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = g_strconcat (" ", _data_->_tmp7_, NULL);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_strconcat (_data_->_tmp4_, _data_->_tmp9_, NULL);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_g_free0 (_data_->_tmp7_);
		_data_->_tmp11_ = _data_->msg;
		assistant_operation_show_error ((AssistantOperation*) _data_->self, _data_->_tmp11_, NULL);
		notifications_backup_finished ((GtkWindow*) _data_->self, FALSE, FALSE, NULL);
		_data_->result = NULL;
		_g_free0 (_data_->msg);
		_data_->unavailable = (_vala_array_free (_data_->unavailable, _data_->unavailable_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = deja_dup_backend_get_default ();
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = deja_dup_operation_backup_new (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_g_object_unref0 (_data_->_tmp13_);
	_data_->rv = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->self->priv->_automatic;
	if (_data_->_tmp16_) {
		_data_->_tmp17_ = _data_->rv;
		deja_dup_operation_set_use_progress ((DejaDupOperation*) _data_->_tmp17_, FALSE);
	}
	_data_->_tmp18_ = _data_->rv;
	g_signal_connect_object ((DejaDupOperation*) _data_->_tmp18_, "is-full", (GCallback) ___lambda33__deja_dup_operation_is_full, _data_->self, 0);
	_data_->result = (DejaDupOperation*) _data_->rv;
	_data_->unavailable = (_vala_array_free (_data_->unavailable, _data_->unavailable_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
assistant_backup_real_get_progress_file_prefix (AssistantOperation* base)
{
	AssistantBackup * self;
	gchar* _tmp0_;
	gchar* result;
	self = (AssistantBackup*) base;
	_tmp0_ = g_strdup (_ ("Backing up:"));
	result = _tmp0_;
	return result;
}

static void
assistant_backup_real_do_prepare (AssistantOperation* base,
                                  Assistant* assist,
                                  GtkWidget* page)
{
	AssistantBackup * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = (AssistantBackup*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->do_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation), assist, page);
	_tmp0_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
	_tmp1_ = _tmp0_;
	if (page == _tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			assistant_set_page_title ((Assistant*) self, page, _ ("Backup Failed"));
		} else {
			gboolean _tmp4_ = FALSE;
			assistant_set_page_title ((Assistant*) self, page, _ ("Backup Finished"));
			if (((AssistantOperation*) self)->nagged) {
				GtkLabel* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = ((AssistantOperation*) self)->summary_label;
				_tmp6_ = gtk_label_get_label (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp4_ = g_strcmp0 (_tmp7_, "") == 0;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				GtkLabel* _tmp8_;
				_tmp8_ = ((AssistantOperation*) self)->summary_label;
				gtk_label_set_label (_tmp8_, _ ("Your files were successfully backed up and tested."));
			} else {
				GtkWidget* _tmp9_;
				_tmp9_ = ((AssistantOperation*) self)->detail_widget;
				if (!gtk_widget_get_visible (_tmp9_)) {
					assistant_operation_do_delete ((AssistantOperation*) self);
				}
			}
		}
	} else {
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		_tmp10_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
		_tmp11_ = _tmp10_;
		if (page == _tmp11_) {
			assistant_set_page_title ((Assistant*) self, page, _ ("Backing Up…"));
		} else {
			GtkWidget* _tmp12_;
			_tmp12_ = self->priv->include_exclude_page;
			if (page == _tmp12_) {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = gtk_window_get_title ((GtkWindow*) self);
				_tmp14_ = _tmp13_;
				notifications_attention_needed ((GtkWindow*) self, _ ("Backups needs your input to continue"), _tmp14_);
			}
		}
	}
}

static void
assistant_backup_real_apply_finished (AssistantOperation* base,
                                      DejaDupOperation* op,
                                      gboolean success,
                                      gboolean cancelled,
                                      const gchar* detail)
{
	AssistantBackup * self;
	self = (AssistantBackup*) base;
	g_return_if_fail (op != NULL);
	notifications_backup_finished ((GtkWindow*) self, success, cancelled, detail);
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->apply_finished (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation), op, success, cancelled, detail);
}

static guint
assistant_backup_real_inhibit (Assistant* base,
                               GtkApplication* app)
{
	AssistantBackup * self;
	GtkApplicationInhibitFlags flags = 0U;
	gboolean _tmp0_;
	guint result;
	self = (AssistantBackup*) base;
	g_return_val_if_fail (app != NULL, 0U);
	flags = GTK_APPLICATION_INHIBIT_SUSPEND;
	_tmp0_ = self->priv->_automatic;
	if (!_tmp0_) {
		flags |= GTK_APPLICATION_INHIBIT_LOGOUT;
	}
	result = gtk_application_inhibit (app, (GtkWindow*) self, flags, _ ("Backup in progress"));
	return result;
}

gboolean
assistant_backup_get_automatic (AssistantBackup* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}

static void
assistant_backup_set_automatic (AssistantBackup* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_backup_get_automatic (self);
	if (old_value != value) {
		self->priv->_automatic = value;
		g_object_notify_by_pspec ((GObject *) self, assistant_backup_properties[ASSISTANT_BACKUP_AUTOMATIC_PROPERTY]);
	}
}

static GObject *
assistant_backup_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AssistantBackup * self;
	gchar* _tmp0_;
	parent_class = G_OBJECT_CLASS (assistant_backup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_BACKUP, AssistantBackup);
	_tmp0_ = g_strdup (C_ ("back up is verb", "Back Up"));
	_g_free0 (((Assistant*) self)->default_title);
	((Assistant*) self)->default_title = _tmp0_;
	((Assistant*) self)->can_resume = TRUE;
	return obj;
}

static void
assistant_backup_class_init (AssistantBackupClass * klass,
                             gpointer klass_data)
{
	assistant_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AssistantBackup_private_offset);
	((AssistantOperationClass *) klass)->get_apply_text = (gchar* (*) (AssistantOperation*)) assistant_backup_real_get_apply_text;
	((AssistantOperationClass *) klass)->add_custom_config_pages = (void (*) (AssistantOperation*)) assistant_backup_real_add_custom_config_pages;
	((AssistantOperationClass *) klass)->create_op = (void (*) (AssistantOperation*, GAsyncReadyCallback, gpointer)) assistant_backup_real_create_op;
	((AssistantOperationClass *) klass)->create_op_finish = (DejaDupOperation* (*) (AssistantOperation*, GAsyncResult*)) assistant_backup_create_op_finish;
	((AssistantOperationClass *) klass)->get_progress_file_prefix = (gchar* (*) (AssistantOperation*)) assistant_backup_real_get_progress_file_prefix;
	((AssistantOperationClass *) klass)->do_prepare = (void (*) (AssistantOperation*, Assistant*, GtkWidget*)) assistant_backup_real_do_prepare;
	((AssistantOperationClass *) klass)->apply_finished = (void (*) (AssistantOperation*, DejaDupOperation*, gboolean, gboolean, const gchar*)) assistant_backup_real_apply_finished;
	((AssistantClass *) klass)->inhibit = (guint (*) (Assistant*, GtkApplication*)) assistant_backup_real_inhibit;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_backup_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_backup_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_backup_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_backup_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_BACKUP_AUTOMATIC_PROPERTY, assistant_backup_properties[ASSISTANT_BACKUP_AUTOMATIC_PROPERTY] = g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
assistant_backup_instance_init (AssistantBackup * self,
                                gpointer klass)
{
	self->priv = assistant_backup_get_instance_private (self);
	self->priv->_automatic = FALSE;
}

static void
assistant_backup_finalize (GObject * obj)
{
	AssistantBackup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_BACKUP, AssistantBackup);
	_g_object_unref0 (self->priv->include_exclude_page);
	G_OBJECT_CLASS (assistant_backup_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
assistant_backup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssistantBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantBackup), 0, (GInstanceInitFunc) assistant_backup_instance_init, NULL };
	GType assistant_backup_type_id;
	assistant_backup_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantBackup", &g_define_type_info, 0);
	AssistantBackup_private_offset = g_type_add_instance_private (assistant_backup_type_id, sizeof (AssistantBackupPrivate));
	return assistant_backup_type_id;
}

GType
assistant_backup_get_type (void)
{
	static gsize assistant_backup_type_id__once = 0;
	if (g_once_init_enter (&assistant_backup_type_id__once)) {
		GType assistant_backup_type_id;
		assistant_backup_type_id = assistant_backup_get_type_once ();
		g_once_init_leave (&assistant_backup_type_id__once, assistant_backup_type_id);
	}
	return assistant_backup_type_id__once;
}

static void
_vala_assistant_backup_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	AssistantBackup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_BACKUP, AssistantBackup);
	switch (property_id) {
		case ASSISTANT_BACKUP_AUTOMATIC_PROPERTY:
		g_value_set_boolean (value, assistant_backup_get_automatic (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_assistant_backup_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	AssistantBackup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_BACKUP, AssistantBackup);
	switch (property_id) {
		case ASSISTANT_BACKUP_AUTOMATIC_PROPERTY:
		assistant_backup_set_automatic (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

