/* Assistant.c generated by valac 0.56.14, the Vala compiler
 * generated from Assistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Canonical Ltd
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define ASSISTANT_CUSTOM_RESPONSE -1
#define ASSISTANT_APPLY 1
#define ASSISTANT_BACK 2
#define ASSISTANT_FORWARD 3
#define ASSISTANT_CANCEL 4
#define ASSISTANT_CLOSE 5
#define ASSISTANT_RESUME 6
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;
enum  {
	ASSISTANT_0_PROPERTY,
	ASSISTANT_LAST_OP_WAS_BACK_PROPERTY,
	ASSISTANT_NUM_PROPERTIES
};
static GParamSpec* assistant_properties[ASSISTANT_NUM_PROPERTIES];
typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AssistantPageInfoPrivate AssistantPageInfoPrivate;
#define _assistant_page_info_unref0(var) ((var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL)))

#define TYPE_DEJA_DUP_APP (deja_dup_app_get_type ())
#define DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEJA_DUP_APP, DejaDupApp))
#define DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEJA_DUP_APP, DejaDupAppClass))
#define IS_DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEJA_DUP_APP))
#define IS_DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEJA_DUP_APP))
#define DEJA_DUP_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEJA_DUP_APP, DejaDupAppClass))

typedef struct _DejaDupApp DejaDupApp;
typedef struct _DejaDupAppClass DejaDupAppClass;
typedef struct _AssistantParamSpecPageInfo AssistantParamSpecPageInfo;
enum  {
	ASSISTANT_RESPONSE_SIGNAL,
	ASSISTANT_CANCELED_SIGNAL,
	ASSISTANT_CLOSED_SIGNAL,
	ASSISTANT_RESUMED_SIGNAL,
	ASSISTANT_PREPARE_SIGNAL,
	ASSISTANT_FORWARD_SIGNAL,
	ASSISTANT_BACKWARD_SIGNAL,
	ASSISTANT_NUM_SIGNALS
};
static guint assistant_signals[ASSISTANT_NUM_SIGNALS] = {0};

struct _Assistant {
	AdwWindow parent_instance;
	AssistantPrivate * priv;
	gchar* default_title;
	GtkWidget* forward_button;
	GtkStack* page_box;
	gboolean can_resume;
	GList* first_shown;
	GList* current;
};

struct _AssistantClass {
	AdwWindowClass parent_class;
	void (*set_buttons) (Assistant* self);
	guint (*inhibit) (Assistant* self, GtkApplication* app);
};

struct _AssistantPrivate {
	gboolean _last_op_was_back;
	AdwHeaderBar* header_bar;
	GtkWidget* back_button;
	GtkWidget* cancel_button;
	GtkWidget* close_button;
	GtkWidget* resume_button;
	GtkWidget* apply_button;
	guint inhibit_id;
	gboolean interrupt_can_continue;
	gboolean interrupted_from_hidden;
	GList* interrupted;
	GList* infos;
};

struct _AssistantPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AssistantPageInfoPrivate * priv;
	GtkWidget* page;
	gchar* title;
	AssistantType type;
	gchar* forward_text;
};

struct _AssistantPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (AssistantPageInfo *self);
};

struct _AssistantParamSpecPageInfo {
	GParamSpec parent_instance;
};

static gint Assistant_private_offset;
static gpointer assistant_parent_class = NULL;
static gpointer assistant_page_info_parent_class = NULL;

VALA_EXTERN GType assistant_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Assistant, g_object_unref)
VALA_EXTERN gpointer assistant_page_info_ref (gpointer instance);
VALA_EXTERN void assistant_page_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* assistant_param_spec_page_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void assistant_value_set_page_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void assistant_value_take_page_info (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer assistant_value_get_page_info (const GValue* value);
VALA_EXTERN GType assistant_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AssistantPageInfo, assistant_page_info_unref)
VALA_EXTERN void assistant_set_buttons (Assistant* self);
VALA_EXTERN guint assistant_inhibit (Assistant* self,
                         GtkApplication* app);
static void assistant_set_inhibited (Assistant* self,
                              gboolean inhibited);
VALA_EXTERN GType assistant_type_get_type (void) G_GNUC_CONST ;
static void _assistant_page_info_unref0_ (gpointer var);
static inline void _g_list_free__assistant_page_info_unref0_ (GList* self);
VALA_EXTERN void assistant_allow_forward (Assistant* self,
                              gboolean allow);
static void assistant_handle_response (Assistant* self,
                                gint resp);
VALA_EXTERN void assistant_go_back (Assistant* self);
VALA_EXTERN void assistant_go_forward (Assistant* self);
VALA_EXTERN gboolean assistant_is_interrupted (Assistant* self);
VALA_EXTERN void assistant_skip (Assistant* self);
VALA_EXTERN gboolean assistant_get_last_op_was_back (Assistant* self);
VALA_EXTERN gboolean assistant_is_interrupt_type (AssistantType type);
static void assistant_set_last_op_was_back (Assistant* self,
                                     gboolean value);
static void assistant_page_changed (Assistant* self);
VALA_EXTERN void assistant_go_to_page (Assistant* self,
                           GtkWidget* page);
VALA_EXTERN void assistant_interrupt (Assistant* self,
                          GtkWidget* page,
                          gboolean can_continue,
                          gboolean stay_visible);
static void assistant_use_title (Assistant* self,
                          AssistantPageInfo* info);
static void assistant_button_clicked (Assistant* self,
                               GtkButton* button);
VALA_EXTERN GtkButton* assistant_add_button (Assistant* self,
                                 const gchar* label,
                                 gint response_id);
static void _assistant_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self);
VALA_EXTERN void assistant_make_button_default (Assistant* self,
                                    GtkWidget* button);
static void assistant_real_set_buttons (Assistant* self);
static gboolean assistant_set_first_page (Assistant* self);
VALA_EXTERN void assistant_append_page (Assistant* self,
                            GtkWidget* page,
                            AssistantType type,
                            const gchar* forward_text);
VALA_EXTERN AssistantPageInfo* assistant_page_info_new (void);
VALA_EXTERN AssistantPageInfo* assistant_page_info_construct (GType object_type);
static gboolean _assistant_set_first_page_gsource_func (gpointer self);
VALA_EXTERN void assistant_set_page_title (Assistant* self,
                               GtkWidget* page,
                               const gchar* title);
static guint assistant_real_inhibit (Assistant* self,
                              GtkApplication* app);
VALA_EXTERN GType deja_dup_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DejaDupApp, g_object_unref)
VALA_EXTERN DejaDupApp* deja_dup_app_get_instance (void);
VALA_EXTERN Assistant* assistant_new (void);
VALA_EXTERN Assistant* assistant_construct (GType object_type);
static void assistant_page_info_finalize (AssistantPageInfo * obj);
static GType assistant_page_info_get_type_once (void);
static GObject * assistant_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void _assistant_handle_response_assistant_response (Assistant* _sender,
                                                    gint response,
                                                    gpointer self);
static void assistant_finalize (GObject * obj);
static GType assistant_get_type_once (void);
static void _vala_assistant_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_assistant_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
assistant_get_instance_private (Assistant* self)
{
	return G_STRUCT_MEMBER_P (self, Assistant_private_offset);
}

 G_GNUC_NO_INLINE static GType
assistant_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ASSISTANT_TYPE_NORMAL, "ASSISTANT_TYPE_NORMAL", "normal"}, {ASSISTANT_TYPE_INTERRUPT, "ASSISTANT_TYPE_INTERRUPT", "interrupt"}, {ASSISTANT_TYPE_CHECK, "ASSISTANT_TYPE_CHECK", "check"}, {ASSISTANT_TYPE_PROGRESS, "ASSISTANT_TYPE_PROGRESS", "progress"}, {ASSISTANT_TYPE_FINISH, "ASSISTANT_TYPE_FINISH", "finish"}, {0, NULL, NULL}};
	GType assistant_type_type_id;
	assistant_type_type_id = g_enum_register_static ("AssistantType", values);
	return assistant_type_type_id;
}

GType
assistant_type_get_type (void)
{
	static gsize assistant_type_type_id__once = 0;
	if (g_once_init_enter (&assistant_type_type_id__once)) {
		GType assistant_type_type_id;
		assistant_type_type_id = assistant_type_get_type_once ();
		g_once_init_leave (&assistant_type_type_id__once, assistant_type_type_id);
	}
	return assistant_type_type_id__once;
}

static void
_assistant_page_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (assistant_page_info_unref (var), NULL));
}

static inline void
_g_list_free__assistant_page_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _assistant_page_info_unref0_);
}

void
assistant_allow_forward (Assistant* self,
                         gboolean allow)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->current;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->forward_button;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWidget* _tmp3_;
		_tmp3_ = self->forward_button;
		gtk_widget_set_sensitive (_tmp3_, allow);
	}
}

static void
assistant_handle_response (Assistant* self,
                           gint resp)
{
	g_return_if_fail (self != NULL);
	switch (resp) {
		case ASSISTANT_BACK:
		{
			assistant_go_back (self);
			break;
		}
		case ASSISTANT_APPLY:
		case ASSISTANT_FORWARD:
		{
			assistant_go_forward (self);
			break;
		}
		default:
		case ASSISTANT_CANCEL:
		{
			g_signal_emit (self, assistant_signals[ASSISTANT_CANCELED_SIGNAL], 0);
			break;
		}
		case ASSISTANT_CLOSE:
		{
			g_signal_emit (self, assistant_signals[ASSISTANT_CLOSED_SIGNAL], 0);
			break;
		}
		case ASSISTANT_RESUME:
		{
			g_signal_emit (self, assistant_signals[ASSISTANT_RESUMED_SIGNAL], 0);
			break;
		}
		case ASSISTANT_CUSTOM_RESPONSE:
		{
			break;
		}
	}
}

gboolean
assistant_is_interrupted (Assistant* self)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->interrupted;
	result = _tmp0_ != NULL;
	return result;
}

void
assistant_skip (Assistant* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_last_op_was_back;
	if (_tmp0_) {
		assistant_go_back (self);
	} else {
		assistant_go_forward (self);
	}
}

gboolean
assistant_is_interrupt_type (AssistantType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (type == ASSISTANT_TYPE_INTERRUPT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == ASSISTANT_TYPE_CHECK;
	}
	result = _tmp0_;
	return result;
}

void
assistant_go_back (Assistant* self)
{
	GList* next = NULL;
	GList* _tmp0_;
	GList* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interrupted;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = self->priv->interrupted;
		_tmp2_ = _tmp1_->prev;
		next = _tmp2_;
	} else {
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = self->current;
		_tmp4_ = _tmp3_->prev;
		next = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			GList* _tmp6_;
			GList* _tmp9_;
			GList* _tmp10_;
			_tmp6_ = next;
			if (_tmp6_ != NULL) {
				GList* _tmp7_;
				gconstpointer _tmp8_;
				_tmp7_ = next;
				_tmp8_ = _tmp7_->data;
				_tmp5_ = assistant_is_interrupt_type (((AssistantPageInfo*) _tmp8_)->type);
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp9_ = next;
			_tmp10_ = _tmp9_->prev;
			next = _tmp10_;
		}
	}
	_tmp11_ = next;
	if (_tmp11_ != NULL) {
		GList* _tmp12_;
		assistant_set_last_op_was_back (self, TRUE);
		_tmp12_ = next;
		self->current = _tmp12_;
		assistant_page_changed (self);
		g_signal_emit (self, assistant_signals[ASSISTANT_BACKWARD_SIGNAL], 0);
	}
}

void
assistant_go_forward (Assistant* self)
{
	GList* next = NULL;
	GList* _tmp0_;
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interrupted;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		_tmp1_ = self->priv->interrupted;
		next = _tmp1_;
		if (self->priv->interrupted_from_hidden) {
			gtk_widget_hide ((GtkWidget*) self);
		}
	} else {
		GList* _tmp2_ = NULL;
		GList* _tmp3_;
		_tmp3_ = self->current;
		if (_tmp3_ == NULL) {
			GList* _tmp4_;
			_tmp4_ = self->priv->infos;
			_tmp2_ = _tmp4_;
		} else {
			GList* _tmp5_;
			GList* _tmp6_;
			_tmp5_ = self->current;
			_tmp6_ = _tmp5_->next;
			_tmp2_ = _tmp6_;
		}
		next = _tmp2_;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			GList* _tmp8_;
			GList* _tmp11_;
			GList* _tmp12_;
			_tmp8_ = next;
			if (_tmp8_ != NULL) {
				GList* _tmp9_;
				gconstpointer _tmp10_;
				_tmp9_ = next;
				_tmp10_ = _tmp9_->data;
				_tmp7_ = assistant_is_interrupt_type (((AssistantPageInfo*) _tmp10_)->type);
			} else {
				_tmp7_ = FALSE;
			}
			if (!_tmp7_) {
				break;
			}
			_tmp11_ = next;
			_tmp12_ = _tmp11_->next;
			next = _tmp12_;
		}
	}
	_tmp13_ = next;
	if (_tmp13_ != NULL) {
		GList* _tmp14_;
		assistant_set_last_op_was_back (self, FALSE);
		_tmp14_ = next;
		self->current = _tmp14_;
		assistant_page_changed (self);
		g_signal_emit (self, assistant_signals[ASSISTANT_FORWARD_SIGNAL], 0);
	}
}

void
assistant_go_to_page (Assistant* self,
                      GtkWidget* page)
{
	GList* i = NULL;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->infos;
	i = _tmp0_;
	while (TRUE) {
		GList* _tmp1_;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		GtkWidget* _tmp4_;
		GList* _tmp6_;
		GList* _tmp7_;
		_tmp1_ = i;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = i;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = ((AssistantPageInfo*) _tmp3_)->page;
		if (_tmp4_ == page) {
			GList* _tmp5_;
			_tmp5_ = i;
			self->current = _tmp5_;
			assistant_page_changed (self);
			break;
		}
		_tmp6_ = i;
		_tmp7_ = _tmp6_->next;
		i = _tmp7_;
	}
}

void
assistant_interrupt (Assistant* self,
                     GtkWidget* page,
                     gboolean can_continue,
                     gboolean stay_visible)
{
	GList* was = NULL;
	GList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->current;
	was = _tmp0_;
	self->priv->interrupt_can_continue = can_continue;
	assistant_go_to_page (self, page);
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		_tmp1_ = !stay_visible;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->interrupted_from_hidden = TRUE;
	}
	_tmp4_ = was;
	self->priv->interrupted = _tmp4_;
}

static void
assistant_use_title (Assistant* self,
                     AssistantPageInfo* info)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info->title;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		const gchar* _tmp1_;
		_tmp1_ = self->default_title;
		gtk_window_set_title ((GtkWindow*) self, _tmp1_);
	} else {
		const gchar* _tmp2_;
		_tmp2_ = info->title;
		gtk_window_set_title ((GtkWindow*) self, _tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
assistant_page_changed (Assistant* self)
{
	GList* _tmp0_;
	AssistantPageInfo* info = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	AssistantPageInfo* _tmp3_;
	GtkWidget* _tmp4_;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	GtkWidget* _tmp7_;
	AssistantPageInfo* _tmp8_;
	GtkWidget* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current;
	g_return_if_fail (_tmp0_ != NULL);
	self->priv->interrupted = NULL;
	self->priv->interrupted_from_hidden = FALSE;
	_tmp1_ = self->current;
	_tmp2_ = _tmp1_->data;
	info = (AssistantPageInfo*) _tmp2_;
	_tmp3_ = info;
	_tmp4_ = _tmp3_->page;
	g_signal_emit (self, assistant_signals[ASSISTANT_PREPARE_SIGNAL], 0, _tmp4_);
	_tmp5_ = self->current;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = ((AssistantPageInfo*) _tmp6_)->page;
	_tmp8_ = info;
	_tmp9_ = _tmp8_->page;
	if (_tmp7_ == _tmp9_) {
		gboolean _tmp10_ = FALSE;
		GList* _tmp11_;
		AssistantPageInfo* _tmp14_;
		AssistantPageInfo* _tmp15_;
		GtkStack* _tmp16_;
		AssistantPageInfo* _tmp17_;
		GtkWidget* _tmp18_;
		GtkWidget* w = NULL;
		GtkWidget* _tmp19_;
		GtkWidget* _tmp20_;
		gboolean _tmp21_ = FALSE;
		GtkWidget* _tmp22_;
		_tmp11_ = self->first_shown;
		if (_tmp11_ == NULL) {
			AssistantPageInfo* _tmp12_;
			_tmp12_ = info;
			_tmp10_ = _tmp12_->type != ASSISTANT_TYPE_PROGRESS;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GList* _tmp13_;
			_tmp13_ = self->current;
			self->first_shown = _tmp13_;
		}
		_tmp14_ = info;
		assistant_use_title (self, _tmp14_);
		assistant_set_buttons (self);
		_tmp15_ = info;
		assistant_set_inhibited (self, _tmp15_->type == ASSISTANT_TYPE_PROGRESS);
		_tmp16_ = self->page_box;
		_tmp17_ = info;
		_tmp18_ = _tmp17_->page;
		gtk_stack_set_visible_child (_tmp16_, _tmp18_);
		_tmp19_ = gtk_root_get_focus ((GtkRoot*) self);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		w = _tmp20_;
		_tmp22_ = w;
		if (_tmp22_ != NULL) {
			GtkWidget* _tmp23_;
			_tmp23_ = w;
			_tmp21_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp23_) == gtk_label_get_type ();
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GtkWidget* _tmp24_;
			_tmp24_ = w;
			gtk_label_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_label_get_type (), GtkLabel), -1, -1);
		}
		_g_object_unref0 (w);
	}
}

static void
assistant_button_clicked (Assistant* self,
                          GtkButton* button)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = g_object_get_data ((GObject*) button, "response-id");
	g_signal_emit (self, assistant_signals[ASSISTANT_RESPONSE_SIGNAL], 0, (gint) ((gintptr) _tmp0_));
}

static void
_assistant_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                              gpointer self)
{
	assistant_button_clicked ((Assistant*) self, _sender);
}

GtkButton*
assistant_add_button (Assistant* self,
                      const gchar* label,
                      gint response_id)
{
	GtkButton* btn = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (label);
	g_object_ref_sink (_tmp0_);
	btn = _tmp0_;
	_tmp1_ = btn;
	gtk_widget_set_receives_default ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = btn;
	g_object_set_data_full ((GObject*) _tmp2_, "response-id", (gpointer) ((gintptr) response_id), NULL);
	_tmp3_ = btn;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) _assistant_button_clicked_gtk_button_clicked, self, 0);
	if (response_id == ASSISTANT_CANCEL) {
		AdwHeaderBar* _tmp4_;
		GtkButton* _tmp5_;
		_tmp4_ = self->priv->header_bar;
		_tmp5_ = btn;
		adw_header_bar_pack_start (_tmp4_, (GtkWidget*) _tmp5_);
	} else {
		AdwHeaderBar* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = self->priv->header_bar;
		_tmp7_ = btn;
		adw_header_bar_pack_end (_tmp6_, (GtkWidget*) _tmp7_);
	}
	result = btn;
	return result;
}

void
assistant_make_button_default (Assistant* self,
                               GtkWidget* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_window_set_default_widget ((GtkWindow*) self, button);
	gtk_widget_add_css_class (button, "default");
	gtk_widget_add_css_class (button, "suggested-action");
}

static void
assistant_real_set_buttons (Assistant* self)
{
	GList* _tmp0_;
	AssistantPageInfo* info = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	gboolean show_cancel = FALSE;
	gboolean show_back = FALSE;
	gboolean show_forward = FALSE;
	gboolean show_close = FALSE;
	gboolean show_resume = FALSE;
	gboolean has_default = FALSE;
	gchar* forward_text = NULL;
	AssistantPageInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	AssistantPageInfo* _tmp6_;
	AdwHeaderBar* area = NULL;
	AdwHeaderBar* _tmp14_;
	AdwHeaderBar* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp19_;
	GtkWidget* _tmp22_;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp28_;
	GtkWidget* _tmp31_;
	_tmp0_ = self->current;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->current;
	_tmp2_ = _tmp1_->data;
	info = (AssistantPageInfo*) _tmp2_;
	show_cancel = FALSE;
	show_back = FALSE;
	show_forward = FALSE;
	show_close = FALSE;
	show_resume = FALSE;
	has_default = FALSE;
	_tmp3_ = info;
	_tmp4_ = _tmp3_->forward_text;
	_tmp5_ = g_strdup (_tmp4_);
	forward_text = _tmp5_;
	_tmp6_ = info;
	switch (_tmp6_->type) {
		default:
		case ASSISTANT_TYPE_NORMAL:
		{
			gboolean _tmp7_ = FALSE;
			GList* _tmp8_;
			GList* _tmp9_;
			show_cancel = TRUE;
			_tmp8_ = self->current;
			_tmp9_ = _tmp8_->prev;
			if (_tmp9_ != NULL) {
				GList* _tmp10_;
				GList* _tmp11_;
				_tmp10_ = self->current;
				_tmp11_ = self->first_shown;
				_tmp7_ = _tmp10_ != _tmp11_;
			} else {
				_tmp7_ = FALSE;
			}
			show_back = _tmp7_;
			show_forward = TRUE;
			break;
		}
		case ASSISTANT_TYPE_INTERRUPT:
		{
			show_cancel = TRUE;
			if (self->priv->interrupt_can_continue) {
				gchar* _tmp12_;
				show_forward = TRUE;
				_tmp12_ = g_strdup (_ ("Co_ntinue"));
				_g_free0 (forward_text);
				forward_text = _tmp12_;
			}
			break;
		}
		case ASSISTANT_TYPE_CHECK:
		{
			gchar* _tmp13_;
			show_cancel = TRUE;
			show_forward = TRUE;
			_tmp13_ = g_strdup (C_ ("verb", "_Test"));
			_g_free0 (forward_text);
			forward_text = _tmp13_;
			break;
		}
		case ASSISTANT_TYPE_PROGRESS:
		{
			show_cancel = TRUE;
			if (self->can_resume) {
				show_resume = TRUE;
			}
			break;
		}
		case ASSISTANT_TYPE_FINISH:
		{
			show_close = TRUE;
			break;
		}
	}
	gtk_window_set_default_widget ((GtkWindow*) self, NULL);
	_tmp14_ = self->priv->header_bar;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	area = _tmp15_;
	_tmp16_ = self->priv->cancel_button;
	if (_tmp16_ != NULL) {
		AdwHeaderBar* _tmp17_;
		GtkWidget* _tmp18_;
		_tmp17_ = area;
		_tmp18_ = self->priv->cancel_button;
		adw_header_bar_remove (_tmp17_, _tmp18_);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = NULL;
	}
	_tmp19_ = self->priv->close_button;
	if (_tmp19_ != NULL) {
		AdwHeaderBar* _tmp20_;
		GtkWidget* _tmp21_;
		_tmp20_ = area;
		_tmp21_ = self->priv->close_button;
		adw_header_bar_remove (_tmp20_, _tmp21_);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = NULL;
	}
	_tmp22_ = self->priv->back_button;
	if (_tmp22_ != NULL) {
		AdwHeaderBar* _tmp23_;
		GtkWidget* _tmp24_;
		_tmp23_ = area;
		_tmp24_ = self->priv->back_button;
		adw_header_bar_remove (_tmp23_, _tmp24_);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = NULL;
	}
	_tmp25_ = self->priv->resume_button;
	if (_tmp25_ != NULL) {
		AdwHeaderBar* _tmp26_;
		GtkWidget* _tmp27_;
		_tmp26_ = area;
		_tmp27_ = self->priv->resume_button;
		adw_header_bar_remove (_tmp26_, _tmp27_);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = NULL;
	}
	_tmp28_ = self->forward_button;
	if (_tmp28_ != NULL) {
		AdwHeaderBar* _tmp29_;
		GtkWidget* _tmp30_;
		_tmp29_ = area;
		_tmp30_ = self->forward_button;
		adw_header_bar_remove (_tmp29_, _tmp30_);
		_g_object_unref0 (self->forward_button);
		self->forward_button = NULL;
	}
	_tmp31_ = self->priv->apply_button;
	if (_tmp31_ != NULL) {
		AdwHeaderBar* _tmp32_;
		GtkWidget* _tmp33_;
		_tmp32_ = area;
		_tmp33_ = self->priv->apply_button;
		adw_header_bar_remove (_tmp32_, _tmp33_);
		_g_object_unref0 (self->priv->apply_button);
		self->priv->apply_button = NULL;
	}
	if (show_forward) {
		AssistantPageInfo* _tmp34_;
		const gchar* _tmp35_;
		GtkButton* _tmp36_;
		_tmp34_ = info;
		_tmp35_ = _tmp34_->forward_text;
		_tmp36_ = assistant_add_button (self, _tmp35_, ASSISTANT_FORWARD);
		_g_object_unref0 (self->forward_button);
		self->forward_button = (GtkWidget*) _tmp36_;
		if (!has_default) {
			GtkWidget* _tmp37_;
			_tmp37_ = self->forward_button;
			assistant_make_button_default (self, _tmp37_);
		}
		has_default = TRUE;
	}
	if (show_resume) {
		GtkButton* _tmp38_;
		_tmp38_ = assistant_add_button (self, _ ("_Resume Later"), ASSISTANT_RESUME);
		_g_object_unref0 (self->priv->resume_button);
		self->priv->resume_button = (GtkWidget*) _tmp38_;
		if (!has_default) {
			GtkWidget* _tmp39_;
			_tmp39_ = self->priv->resume_button;
			assistant_make_button_default (self, _tmp39_);
		}
		has_default = TRUE;
	}
	if (show_back) {
		GtkButton* _tmp40_;
		_tmp40_ = assistant_add_button (self, _ ("_Back"), ASSISTANT_BACK);
		_g_object_unref0 (self->priv->back_button);
		self->priv->back_button = (GtkWidget*) _tmp40_;
	}
	if (show_close) {
		GtkButton* _tmp41_;
		_tmp41_ = assistant_add_button (self, _ ("_Close"), ASSISTANT_CLOSE);
		_g_object_unref0 (self->priv->close_button);
		self->priv->close_button = (GtkWidget*) _tmp41_;
		if (!has_default) {
			GtkWidget* _tmp42_;
			_tmp42_ = self->priv->close_button;
			assistant_make_button_default (self, _tmp42_);
		}
		has_default = TRUE;
	}
	if (show_cancel) {
		GtkButton* _tmp43_;
		_tmp43_ = assistant_add_button (self, _ ("_Cancel"), ASSISTANT_CANCEL);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = (GtkWidget*) _tmp43_;
	}
	_g_object_unref0 (area);
	_g_free0 (forward_text);
}

void
assistant_set_buttons (Assistant* self)
{
	AssistantClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ASSISTANT_GET_CLASS (self);
	if (_klass_->set_buttons) {
		_klass_->set_buttons (self);
	}
}

static gboolean
assistant_set_first_page (Assistant* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->current = NULL;
	assistant_go_forward (self);
	result = FALSE;
	return result;
}

static gpointer
_assistant_page_info_ref0 (gpointer self)
{
	return self ? assistant_page_info_ref (self) : NULL;
}

static gboolean
_assistant_set_first_page_gsource_func (gpointer self)
{
	gboolean result;
	result = assistant_set_first_page ((Assistant*) self);
	return result;
}

void
assistant_append_page (Assistant* self,
                       GtkWidget* page,
                       AssistantType type,
                       const gchar* forward_text)
{
	gboolean was_empty = FALSE;
	GList* _tmp0_;
	AssistantPageInfo* info = NULL;
	AssistantPageInfo* _tmp1_;
	AssistantPageInfo* _tmp2_;
	GtkWidget* _tmp3_;
	AssistantPageInfo* _tmp4_;
	AssistantPageInfo* _tmp5_;
	gchar* _tmp6_;
	AssistantPageInfo* _tmp7_;
	AssistantPageInfo* _tmp8_;
	GtkStack* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (forward_text != NULL);
	_tmp0_ = self->priv->infos;
	was_empty = _tmp0_ == NULL;
	gtk_widget_set_hexpand (page, TRUE);
	gtk_widget_set_vexpand (page, TRUE);
	_tmp1_ = assistant_page_info_new ();
	info = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = _g_object_ref0 (page);
	_g_object_unref0 (_tmp2_->page);
	_tmp2_->page = _tmp3_;
	_tmp4_ = info;
	_tmp4_->type = type;
	_tmp5_ = info;
	_tmp6_ = g_strdup (forward_text);
	_g_free0 (_tmp5_->forward_text);
	_tmp5_->forward_text = _tmp6_;
	_tmp7_ = info;
	_tmp8_ = _assistant_page_info_ref0 (_tmp7_);
	self->priv->infos = g_list_append (self->priv->infos, _tmp8_);
	_tmp9_ = self->page_box;
	gtk_stack_add_child (_tmp9_, page);
	if (was_empty) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _assistant_set_first_page_gsource_func, g_object_ref (self), g_object_unref);
	}
	_assistant_page_info_unref0 (info);
}

void
assistant_set_page_title (Assistant* self,
                          GtkWidget* page,
                          const gchar* title)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->infos;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp0_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			AssistantPageInfo* _tmp1_;
			AssistantPageInfo* info = NULL;
			_tmp1_ = _assistant_page_info_ref0 ((AssistantPageInfo*) info_it->data);
			info = _tmp1_;
			{
				AssistantPageInfo* _tmp2_;
				GtkWidget* _tmp3_;
				_tmp2_ = info;
				_tmp3_ = _tmp2_->page;
				if (_tmp3_ == page) {
					AssistantPageInfo* _tmp4_;
					gchar* _tmp5_;
					gboolean _tmp6_ = FALSE;
					GList* _tmp7_;
					_tmp4_ = info;
					_tmp5_ = g_strdup (title);
					_g_free0 (_tmp4_->title);
					_tmp4_->title = _tmp5_;
					_tmp7_ = self->current;
					if (_tmp7_ != NULL) {
						GList* _tmp8_;
						gconstpointer _tmp9_;
						GtkWidget* _tmp10_;
						_tmp8_ = self->current;
						_tmp9_ = _tmp8_->data;
						_tmp10_ = ((AssistantPageInfo*) _tmp9_)->page;
						_tmp6_ = _tmp10_ == page;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						AssistantPageInfo* _tmp11_;
						_tmp11_ = info;
						assistant_use_title (self, _tmp11_);
					}
					_assistant_page_info_unref0 (info);
					break;
				}
				_assistant_page_info_unref0 (info);
			}
		}
	}
}

static guint
assistant_real_inhibit (Assistant* self,
                        GtkApplication* app)
{
	guint result;
	g_return_val_if_fail (app != NULL, 0U);
	result = (guint) 0;
	return result;
}

guint
assistant_inhibit (Assistant* self,
                   GtkApplication* app)
{
	AssistantClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = ASSISTANT_GET_CLASS (self);
	if (_klass_->inhibit) {
		return _klass_->inhibit (self, app);
	}
	return 0U;
}

static void
assistant_set_inhibited (Assistant* self,
                         gboolean inhibited)
{
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_app_get_instance ();
	app = _tmp0_;
	if (inhibited) {
		_tmp1_ = self->priv->inhibit_id == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		DejaDupApp* _tmp2_;
		_tmp2_ = app;
		self->priv->inhibit_id = assistant_inhibit (self, (GtkApplication*) _tmp2_);
	} else {
		gboolean _tmp3_ = FALSE;
		if (!inhibited) {
			_tmp3_ = self->priv->inhibit_id > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			DejaDupApp* _tmp4_;
			_tmp4_ = app;
			gtk_application_uninhibit ((GtkApplication*) _tmp4_, self->priv->inhibit_id);
			self->priv->inhibit_id = (guint) 0;
		}
	}
	_g_object_unref0 (app);
}

Assistant*
assistant_construct (GType object_type)
{
	Assistant * self = NULL;
	self = (Assistant*) g_object_new (object_type, NULL);
	return self;
}

Assistant*
assistant_new (void)
{
	return assistant_construct (TYPE_ASSISTANT);
}

gboolean
assistant_get_last_op_was_back (Assistant* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_last_op_was_back;
	return result;
}

static void
assistant_set_last_op_was_back (Assistant* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = assistant_get_last_op_was_back (self);
	if (old_value != value) {
		self->priv->_last_op_was_back = value;
		g_object_notify_by_pspec ((GObject *) self, assistant_properties[ASSISTANT_LAST_OP_WAS_BACK_PROPERTY]);
	}
}

AssistantPageInfo*
assistant_page_info_construct (GType object_type)
{
	AssistantPageInfo* self = NULL;
	self = (AssistantPageInfo*) g_type_create_instance (object_type);
	return self;
}

AssistantPageInfo*
assistant_page_info_new (void)
{
	return assistant_page_info_construct (ASSISTANT_TYPE_PAGE_INFO);
}

static void
assistant_value_page_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
assistant_value_page_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		assistant_page_info_unref (value->data[0].v_pointer);
	}
}

static void
assistant_value_page_info_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = assistant_page_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
assistant_value_page_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
assistant_value_page_info_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AssistantPageInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = assistant_page_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
assistant_value_page_info_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	AssistantPageInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = assistant_page_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
assistant_param_spec_page_info (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	AssistantParamSpecPageInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ASSISTANT_TYPE_PAGE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
assistant_value_get_page_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO), NULL);
	return value->data[0].v_pointer;
}

void
assistant_value_set_page_info (GValue* value,
                               gpointer v_object)
{
	AssistantPageInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		assistant_page_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}

void
assistant_value_take_page_info (GValue* value,
                                gpointer v_object)
{
	AssistantPageInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ASSISTANT_TYPE_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ASSISTANT_TYPE_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		assistant_page_info_unref (old);
	}
}

static void
assistant_page_info_class_init (AssistantPageInfoClass * klass,
                                gpointer klass_data)
{
	assistant_page_info_parent_class = g_type_class_peek_parent (klass);
	((AssistantPageInfoClass *) klass)->finalize = assistant_page_info_finalize;
}

static void
assistant_page_info_instance_init (AssistantPageInfo * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup ("");
	self->title = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->forward_text = _tmp1_;
	self->ref_count = 1;
}

static void
assistant_page_info_finalize (AssistantPageInfo * obj)
{
	AssistantPageInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->page);
	_g_free0 (self->title);
	_g_free0 (self->forward_text);
}

 G_GNUC_NO_INLINE static GType
assistant_page_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { assistant_value_page_info_init, assistant_value_page_info_free_value, assistant_value_page_info_copy_value, assistant_value_page_info_peek_pointer, "p", assistant_value_page_info_collect_value, "p", assistant_value_page_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AssistantPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantPageInfo), 0, (GInstanceInitFunc) assistant_page_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType assistant_page_info_type_id;
	assistant_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AssistantPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return assistant_page_info_type_id;
}

GType
assistant_page_info_get_type (void)
{
	static gsize assistant_page_info_type_id__once = 0;
	if (g_once_init_enter (&assistant_page_info_type_id__once)) {
		GType assistant_page_info_type_id;
		assistant_page_info_type_id = assistant_page_info_get_type_once ();
		g_once_init_leave (&assistant_page_info_type_id__once, assistant_page_info_type_id);
	}
	return assistant_page_info_type_id__once;
}

gpointer
assistant_page_info_ref (gpointer instance)
{
	AssistantPageInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
assistant_page_info_unref (gpointer instance)
{
	AssistantPageInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ASSISTANT_PAGE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_assistant_handle_response_assistant_response (Assistant* _sender,
                                               gint response,
                                               gpointer self)
{
	assistant_handle_response ((Assistant*) self, response);
}

static GObject *
assistant_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Assistant * self;
	GtkBox* dialog_box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	AdwHeaderBar* _tmp2_;
	AdwHeaderBar* _tmp3_;
	AdwHeaderBar* _tmp4_;
	GtkBox* _tmp5_;
	AdwHeaderBar* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkBox* _tmp10_;
	GtkStack* _tmp11_;
	DejaDupApp* _tmp12_;
	DejaDupApp* _tmp13_;
	parent_class = G_OBJECT_CLASS (assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT, Assistant);
	gtk_widget_add_css_class ((GtkWidget*) self, "dialog");
	g_object_set ((GtkWindow*) self, "default-width", 450, NULL);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	(self->priv->infos == NULL) ? NULL : (self->priv->infos = (_g_list_free__assistant_page_info_unref0_ (self->priv->infos), NULL));
	self->priv->infos = NULL;
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	dialog_box = _tmp0_;
	_tmp1_ = dialog_box;
	adw_window_set_content ((AdwWindow*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (AdwHeaderBar*) adw_header_bar_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp2_;
	_tmp3_ = self->priv->header_bar;
	adw_header_bar_set_show_start_title_buttons (_tmp3_, FALSE);
	_tmp4_ = self->priv->header_bar;
	adw_header_bar_set_show_end_title_buttons (_tmp4_, FALSE);
	_tmp5_ = dialog_box;
	_tmp6_ = self->priv->header_bar;
	gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->page_box);
	self->page_box = _tmp7_;
	_tmp8_ = self->page_box;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->page_box;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = dialog_box;
	_tmp11_ = self->page_box;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	g_signal_connect_object (self, "response", (GCallback) _assistant_handle_response_assistant_response, self, 0);
	_tmp12_ = deja_dup_app_get_instance ();
	_tmp13_ = _tmp12_;
	gtk_window_set_application ((GtkWindow*) self, (GtkApplication*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (dialog_box);
	return obj;
}

static void
assistant_class_init (AssistantClass * klass,
                      gpointer klass_data)
{
	assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Assistant_private_offset);
	((AssistantClass *) klass)->set_buttons = (void (*) (Assistant*)) assistant_real_set_buttons;
	((AssistantClass *) klass)->inhibit = (guint (*) (Assistant*, GtkApplication*)) assistant_real_inhibit;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_LAST_OP_WAS_BACK_PROPERTY, assistant_properties[ASSISTANT_LAST_OP_WAS_BACK_PROPERTY] = g_param_spec_boolean ("last-op-was-back", "last-op-was-back", "last-op-was-back", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	assistant_signals[ASSISTANT_RESPONSE_SIGNAL] = g_signal_new ("response", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	assistant_signals[ASSISTANT_CANCELED_SIGNAL] = g_signal_new ("canceled", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	assistant_signals[ASSISTANT_CLOSED_SIGNAL] = g_signal_new ("closed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	assistant_signals[ASSISTANT_RESUMED_SIGNAL] = g_signal_new ("resumed", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	assistant_signals[ASSISTANT_PREPARE_SIGNAL] = g_signal_new ("prepare", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gtk_widget_get_type ());
	assistant_signals[ASSISTANT_FORWARD_SIGNAL] = g_signal_new ("forward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	assistant_signals[ASSISTANT_BACKWARD_SIGNAL] = g_signal_new ("backward", TYPE_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
assistant_instance_init (Assistant * self,
                         gpointer klass)
{
	self->priv = assistant_get_instance_private (self);
	self->priv->_last_op_was_back = FALSE;
	self->priv->interrupt_can_continue = TRUE;
	self->priv->interrupted_from_hidden = FALSE;
	self->can_resume = FALSE;
	self->first_shown = NULL;
}

static void
assistant_finalize (GObject * obj)
{
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT, Assistant);
	g_debug ("Assistant.vala:96: Finalizing Assistant\n");
	assistant_set_inhibited (self, FALSE);
	_g_free0 (self->default_title);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->forward_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resume_button);
	_g_object_unref0 (self->priv->apply_button);
	_g_object_unref0 (self->page_box);
	(self->priv->infos == NULL) ? NULL : (self->priv->infos = (_g_list_free__assistant_page_info_unref0_ (self->priv->infos), NULL));
	G_OBJECT_CLASS (assistant_parent_class)->finalize (obj);
}

/**
 * Yes, this is a silly reimplementation of Gtk.Assistant.
 * But Gtk.Assistant has some ridiculous map/unmap logic that resets the page
 * history when unmapped and generally doesn't work when unmapped.  Since
 * continuing to work when hidden is important for us, this is a
 * reimplementation of just the bits we use.
 */
 G_GNUC_NO_INLINE static GType
assistant_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Assistant), 0, (GInstanceInitFunc) assistant_instance_init, NULL };
	GType assistant_type_id;
	assistant_type_id = g_type_register_static (adw_window_get_type (), "Assistant", &g_define_type_info, 0);
	Assistant_private_offset = g_type_add_instance_private (assistant_type_id, sizeof (AssistantPrivate));
	return assistant_type_id;
}

GType
assistant_get_type (void)
{
	static gsize assistant_type_id__once = 0;
	if (g_once_init_enter (&assistant_type_id__once)) {
		GType assistant_type_id;
		assistant_type_id = assistant_get_type_once ();
		g_once_init_leave (&assistant_type_id__once, assistant_type_id);
	}
	return assistant_type_id__once;
}

static void
_vala_assistant_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT, Assistant);
	switch (property_id) {
		case ASSISTANT_LAST_OP_WAS_BACK_PROPERTY:
		g_value_set_boolean (value, assistant_get_last_op_was_back (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_assistant_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Assistant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT, Assistant);
	switch (property_id) {
		case ASSISTANT_LAST_OP_WAS_BACK_PROPERTY:
		assistant_set_last_op_was_back (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

