/* schemas-utility.c generated by valac 0.56.13, the Vala compiler
 * generated from schemas-utility.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCHEMAS_UTILITY (schemas_utility_get_type ())
#define SCHEMAS_UTILITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMAS_UTILITY, SchemasUtility))
#define SCHEMAS_UTILITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMAS_UTILITY, SchemasUtilityClass))
#define IS_SCHEMAS_UTILITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMAS_UTILITY))
#define IS_SCHEMAS_UTILITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMAS_UTILITY))
#define SCHEMAS_UTILITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMAS_UTILITY, SchemasUtilityClass))

typedef struct _SchemasUtility SchemasUtility;
typedef struct _SchemasUtilityClass SchemasUtilityClass;
typedef struct _SchemasUtilityPrivate SchemasUtilityPrivate;
enum  {
	SCHEMAS_UTILITY_0_PROPERTY,
	SCHEMAS_UTILITY_NUM_PROPERTIES
};
static GParamSpec* schemas_utility_properties[SCHEMAS_UTILITY_NUM_PROPERTIES];
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _SchemasUtility {
	GObject parent_instance;
	SchemasUtilityPrivate * priv;
};

struct _SchemasUtilityClass {
	GObjectClass parent_class;
};

struct _SchemasUtilityPrivate {
	GSettingsSchemaSource* settings_schema_source;
	gchar** non_relocatable_schemas;
	gint non_relocatable_schemas_length1;
	gint _non_relocatable_schemas_size_;
	gchar** relocatable_schemas;
	gint relocatable_schemas_length1;
	gint _relocatable_schemas_size_;
};

static gint SchemasUtility_private_offset;
static gpointer schemas_utility_parent_class = NULL;

VALA_EXTERN GType schemas_utility_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SchemasUtility, g_object_unref)
VALA_EXTERN gboolean schemas_utility_is_relocatable_schema (SchemasUtility* self,
                                                const gchar* id);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN gboolean schemas_utility_is_non_relocatable_schema (SchemasUtility* self,
                                                    const gchar* id);
VALA_EXTERN gchar* schemas_utility_get_schema_path (SchemasUtility* self,
                                        const gchar* id);
VALA_EXTERN SchemasUtility* schemas_utility_new (void);
VALA_EXTERN SchemasUtility* schemas_utility_construct (GType object_type);
static GObject * schemas_utility_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void schemas_utility_finalize (GObject * obj);
static GType schemas_utility_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
schemas_utility_get_instance_private (SchemasUtility* self)
{
	return G_STRUCT_MEMBER_P (self, SchemasUtility_private_offset);
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
schemas_utility_is_relocatable_schema (SchemasUtility* self,
                                       const gchar* id)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = self->priv->relocatable_schemas;
	_tmp0__length1 = self->priv->relocatable_schemas_length1;
	result = _vala_string_array_contains (_tmp0_, _tmp0__length1, id);
	return result;
}

gboolean
schemas_utility_is_non_relocatable_schema (SchemasUtility* self,
                                           const gchar* id)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = self->priv->non_relocatable_schemas;
	_tmp0__length1 = self->priv->non_relocatable_schemas_length1;
	result = _vala_string_array_contains (_tmp0_, _tmp0__length1, id);
	return result;
}

gchar*
schemas_utility_get_schema_path (SchemasUtility* self,
                                 const gchar* id)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->settings_schema_source;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->settings_schema_source;
	_tmp2_ = g_settings_schema_source_lookup ((GSettingsSchemaSource*) _tmp1_, id, TRUE);
	schema = _tmp2_;
	_tmp3_ = schema;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_settings_schema_unref0 (schema);
		return result;
	}
	_tmp4_ = schema;
	_tmp5_ = g_settings_schema_get_path ((GSettingsSchema*) _tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_settings_schema_unref0 (schema);
	return result;
}

SchemasUtility*
schemas_utility_construct (GType object_type)
{
	SchemasUtility * self = NULL;
	self = (SchemasUtility*) g_object_new (object_type, NULL);
	return self;
}

SchemasUtility*
schemas_utility_new (void)
{
	return schemas_utility_construct (TYPE_SCHEMAS_UTILITY);
}

static GObject *
schemas_utility_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SchemasUtility * self;
	GSettingsSchemaSource* _tmp0_;
	parent_class = G_OBJECT_CLASS (schemas_utility_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCHEMAS_UTILITY, SchemasUtility);
	_tmp0_ = self->priv->settings_schema_source;
	if (_tmp0_ != NULL) {
		GSettingsSchemaSource* _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		_tmp1_ = self->priv->settings_schema_source;
		g_settings_schema_source_list_schemas ((GSettingsSchemaSource*) _tmp1_, TRUE, &_tmp2_, &_tmp3_);
		self->priv->non_relocatable_schemas = (_vala_array_free (self->priv->non_relocatable_schemas, self->priv->non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		self->priv->non_relocatable_schemas = _tmp2_;
		self->priv->non_relocatable_schemas_length1 = -1;
		self->priv->_non_relocatable_schemas_size_ = self->priv->non_relocatable_schemas_length1;
		self->priv->non_relocatable_schemas_length1 = _vala_array_length (self->priv->non_relocatable_schemas);
		self->priv->relocatable_schemas = (_vala_array_free (self->priv->relocatable_schemas, self->priv->relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
		self->priv->relocatable_schemas = _tmp3_;
		self->priv->relocatable_schemas_length1 = -1;
		self->priv->_relocatable_schemas_size_ = self->priv->relocatable_schemas_length1;
		self->priv->relocatable_schemas_length1 = _vala_array_length (self->priv->relocatable_schemas);
	}
	return obj;
}

static void
schemas_utility_class_init (SchemasUtilityClass * klass,
                            gpointer klass_data)
{
	schemas_utility_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SchemasUtility_private_offset);
	G_OBJECT_CLASS (klass)->constructor = schemas_utility_constructor;
	G_OBJECT_CLASS (klass)->finalize = schemas_utility_finalize;
}

static void
schemas_utility_instance_init (SchemasUtility * self,
                               gpointer klass)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	self->priv = schemas_utility_get_instance_private (self);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = _g_settings_schema_source_ref0 (_tmp0_);
	self->priv->settings_schema_source = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->non_relocatable_schemas = _tmp2_;
	self->priv->non_relocatable_schemas_length1 = 0;
	self->priv->_non_relocatable_schemas_size_ = self->priv->non_relocatable_schemas_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->relocatable_schemas = _tmp3_;
	self->priv->relocatable_schemas_length1 = 0;
	self->priv->_relocatable_schemas_size_ = self->priv->relocatable_schemas_length1;
}

static void
schemas_utility_finalize (GObject * obj)
{
	SchemasUtility * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCHEMAS_UTILITY, SchemasUtility);
	_g_settings_schema_source_unref0 (self->priv->settings_schema_source);
	self->priv->non_relocatable_schemas = (_vala_array_free (self->priv->non_relocatable_schemas, self->priv->non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	self->priv->relocatable_schemas = (_vala_array_free (self->priv->relocatable_schemas, self->priv->relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (schemas_utility_parent_class)->finalize (obj);
}

static GType
schemas_utility_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SchemasUtilityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schemas_utility_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemasUtility), 0, (GInstanceInitFunc) schemas_utility_instance_init, NULL };
	GType schemas_utility_type_id;
	schemas_utility_type_id = g_type_register_static (G_TYPE_OBJECT, "SchemasUtility", &g_define_type_info, 0);
	SchemasUtility_private_offset = g_type_add_instance_private (schemas_utility_type_id, sizeof (SchemasUtilityPrivate));
	return schemas_utility_type_id;
}

GType
schemas_utility_get_type (void)
{
	static volatile gsize schemas_utility_type_id__once = 0;
	if (g_once_init_enter (&schemas_utility_type_id__once)) {
		GType schemas_utility_type_id;
		schemas_utility_type_id = schemas_utility_get_type_once ();
		g_once_init_leave (&schemas_utility_type_id__once, schemas_utility_type_id);
	}
	return schemas_utility_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

