/* dconf-headerbar.c generated by valac 0.56.13, the Vala compiler
 * generated from dconf-headerbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
typedef struct _BaseHeaderBarPrivate BaseHeaderBarPrivate;

#define TYPE_BROWSER_HEADER_BAR (browser_header_bar_get_type ())
#define BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar))
#define BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))
#define IS_BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_HEADER_BAR))
#define IS_BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_HEADER_BAR))
#define BROWSER_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))

typedef struct _BrowserHeaderBar BrowserHeaderBar;
typedef struct _BrowserHeaderBarClass BrowserHeaderBarClass;
typedef struct _BrowserHeaderBarPrivate BrowserHeaderBarPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BOOKMARKS_HEADER_BAR (bookmarks_header_bar_get_type ())
#define BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar))
#define BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))
#define IS_BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_HEADER_BAR))
#define IS_BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_HEADER_BAR))
#define BOOKMARKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))

typedef struct _BookmarksHeaderBar BookmarksHeaderBar;
typedef struct _BookmarksHeaderBarClass BookmarksHeaderBarClass;
typedef struct _BookmarksHeaderBarPrivate BookmarksHeaderBarPrivate;

#define TYPE_DCONF_HEADER_BAR (dconf_header_bar_get_type ())
#define DCONF_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_HEADER_BAR, DConfHeaderBar))
#define DCONF_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_HEADER_BAR, DConfHeaderBarClass))
#define IS_DCONF_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_HEADER_BAR))
#define IS_DCONF_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_HEADER_BAR))
#define DCONF_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_HEADER_BAR, DConfHeaderBarClass))

typedef struct _DConfHeaderBar DConfHeaderBar;
typedef struct _DConfHeaderBarClass DConfHeaderBarClass;
typedef struct _DConfHeaderBarPrivate DConfHeaderBarPrivate;
enum  {
	DCONF_HEADER_BAR_0_PROPERTY,
	DCONF_HEADER_BAR_DELAY_MODE_PROPERTY,
	DCONF_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* dconf_header_bar_properties[DCONF_HEADER_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseHeaderBar {
	GtkHeaderBar parent_instance;
	BaseHeaderBarPrivate * priv;
	GtkBox* center_box;
	gboolean disable_popovers;
	gboolean disable_action_bar;
};

struct _BaseHeaderBarClass {
	GtkHeaderBarClass parent_class;
	void (*set_window_size) (BaseHeaderBar* self, AdaptativeWidgetWindowSize new_size);
	void (*populate_menu) (BaseHeaderBar* self, GMenu** menu);
	void (*toggle_view_menu) (BaseHeaderBar* self);
	void (*set_default_widgets_default_states) (BaseHeaderBar* self, BaseHeaderBar* _this);
	void (*close_popovers) (BaseHeaderBar* self);
	gboolean (*has_popover) (BaseHeaderBar* self);
};

struct _BrowserHeaderBar {
	BaseHeaderBar parent_instance;
	BrowserHeaderBarPrivate * priv;
};

struct _BrowserHeaderBarClass {
	BaseHeaderBarClass parent_class;
	void (*set_path) (BrowserHeaderBar* self, ViewType type, const gchar* path);
};

struct _BookmarksHeaderBar {
	BrowserHeaderBar parent_instance;
	BookmarksHeaderBarPrivate * priv;
};

struct _BookmarksHeaderBarClass {
	BrowserHeaderBarClass parent_class;
	gboolean (*next_match) (BookmarksHeaderBar* self);
	gboolean (*previous_match) (BookmarksHeaderBar* self);
};

struct _DConfHeaderBar {
	BookmarksHeaderBar parent_instance;
	DConfHeaderBarPrivate * priv;
};

struct _DConfHeaderBarClass {
	BookmarksHeaderBarClass parent_class;
};

struct _DConfHeaderBarPrivate {
	gboolean _delay_mode;
	gboolean is_folder_view;
	GtkMenuButton* modifications_actions_button;
	GMenu* changes_pending_menu;
	GMenu* quit_delayed_mode_menu;
	gboolean has_pending_changes;
	guint8 modifications_mode_id;
	gboolean modifications_mode_on;
};

static gint DConfHeaderBar_private_offset;
static gpointer dconf_header_bar_parent_class = NULL;
static AdaptativeWidgetIface * dconf_header_bar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType browser_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserHeaderBar, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bookmarks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksHeaderBar, g_object_unref)
VALA_EXTERN GType dconf_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DConfHeaderBar, g_object_unref)
VALA_EXTERN void browser_header_bar_set_path (BrowserHeaderBar* self,
                                  ViewType type,
                                  const gchar* path);
VALA_EXTERN void base_header_bar_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_header_bar_toggle_view_menu (BaseHeaderBar* self);
VALA_EXTERN void base_header_bar_populate_menu (BaseHeaderBar* self,
                                    GMenu** menu);
VALA_EXTERN DConfHeaderBar* dconf_header_bar_new (void);
VALA_EXTERN DConfHeaderBar* dconf_header_bar_construct (GType object_type);
static void dconf_header_bar_real_set_path (BrowserHeaderBar* base,
                                     ViewType type,
                                     const gchar* path);
static void dconf_header_bar_real_set_window_size (AdaptativeWidget* base,
                                            AdaptativeWidgetWindowSize new_size);
static void dconf_header_bar_update_modifications_button (DConfHeaderBar* self);
static inline void dconf_header_bar_add_show_modifications_button (DConfHeaderBar* self);
static inline void dconf_header_bar_create_show_modifications_button (GtkButton** show_modifications_button);
VALA_EXTERN void base_header_bar_add_named_widget_to_quit_button_stack (BaseHeaderBar* self,
                                                            GtkWidget* widget,
                                                            const gchar* name);
static inline void dconf_header_bar_add_modification_actions_button (DConfHeaderBar* self);
static inline void dconf_header_bar_create_modification_actions_button (GtkMenuButton** modification_actions_button);
static void dconf_header_bar_add_modifications_actions_button (GtkMenuButton** modifications_actions_button,
                                                        DConfHeaderBar** _this);
static void dconf_header_bar_construct_changes_pending_menu (GMenu** changes_pending_menu);
static void dconf_header_bar_construct_quit_delayed_mode_menu (GMenu** quit_delayed_mode_menu);
VALA_EXTERN void dconf_header_bar_set_has_pending_changes (DConfHeaderBar* self,
                                               gboolean new_value,
                                               gboolean mode_is_temporary);
VALA_EXTERN void base_header_bar_set_quit_button_stack_child (BaseHeaderBar* self,
                                                  const gchar* name);
static void dconf_header_bar_real_toggle_view_menu (BaseHeaderBar* base);
static void dconf_header_bar_real_populate_menu (BaseHeaderBar* base,
                                          GMenu** menu);
static void dconf_header_bar_append_or_not_delay_mode_section (gboolean delay_mode,
                                                        gboolean is_folder_view,
                                                        GMenu** menu);
static gboolean dconf_header_bar_get_delay_mode (DConfHeaderBar* self);
VALA_EXTERN void dconf_header_bar_show_modifications_view (DConfHeaderBar* self);
static void dconf_header_bar_register_modifications_mode (DConfHeaderBar* self);
VALA_EXTERN guint8 base_header_bar_register_new_mode (BaseHeaderBar* self);
static void dconf_header_bar_mode_changed_modifications (BaseHeaderBar* _this,
                                                  guint8 requested_mode_id);
static void _dconf_header_bar_mode_changed_modifications_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                               guint8 mode_id,
                                                                               gpointer self);
VALA_EXTERN gboolean base_header_bar_is_not_requested_mode (guint8 mode_id,
                                                guint8 requested_mode_id,
                                                gboolean* mode_is_active);
VALA_EXTERN void base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                                 const gchar* title_label_text_or_null,
                                                 gboolean show_go_back_button,
                                                 gboolean show_ltr_left_separator,
                                                 gboolean show_info_button,
                                                 gboolean show_ltr_right_separator,
                                                 gboolean show_quit_button_stack);
VALA_EXTERN void base_header_bar_set_quit_button_stack_visibility (BaseHeaderBar* self,
                                                       gboolean visible);
VALA_EXTERN void dconf_header_bar_set_delay_mode (DConfHeaderBar* self,
                                      gboolean value);
VALA_EXTERN void base_header_bar_update_hamburger_menu (BaseHeaderBar* self);
static GObject * dconf_header_bar_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void dconf_header_bar_finalize (GObject * obj);
static GType dconf_header_bar_get_type_once (void);
static void _vala_dconf_header_bar_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_dconf_header_bar_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dconf_header_bar_get_instance_private (DConfHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, DConfHeaderBar_private_offset);
}

DConfHeaderBar*
dconf_header_bar_construct (GType object_type)
{
	DConfHeaderBar * self = NULL;
	self = (DConfHeaderBar*) g_object_new (object_type, "about-action-label", _ ("About Dconf Editor"), "has-help", FALSE, "has-keyboard-shortcuts", TRUE, NULL);
	return self;
}

DConfHeaderBar*
dconf_header_bar_new (void)
{
	return dconf_header_bar_construct (TYPE_DCONF_HEADER_BAR);
}

static void
dconf_header_bar_real_set_path (BrowserHeaderBar* base,
                                ViewType type,
                                const gchar* path)
{
	DConfHeaderBar * self;
	self = (DConfHeaderBar*) base;
	g_return_if_fail (path != NULL);
	self->priv->is_folder_view = type == VIEW_TYPE_FOLDER;
	BROWSER_HEADER_BAR_CLASS (dconf_header_bar_parent_class)->set_path ((BrowserHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar), type, path);
}

static void
dconf_header_bar_real_set_window_size (AdaptativeWidget* base,
                                       AdaptativeWidgetWindowSize new_size)
{
	DConfHeaderBar * self;
	self = (DConfHeaderBar*) base;
	BASE_HEADER_BAR_CLASS (dconf_header_bar_parent_class)->set_window_size ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar), new_size);
	dconf_header_bar_update_modifications_button (self);
}

static inline void
dconf_header_bar_add_show_modifications_button (DConfHeaderBar* self)
{
	GtkButton* show_modifications_button = NULL;
	GtkButton* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	dconf_header_bar_create_show_modifications_button (&_tmp0_);
	_g_object_unref0 (show_modifications_button);
	show_modifications_button = _tmp0_;
	base_header_bar_add_named_widget_to_quit_button_stack ((BaseHeaderBar*) self, (GtkWidget*) show_modifications_button, "show-modifications");
	_g_object_unref0 (show_modifications_button);
}

static inline void
dconf_header_bar_create_show_modifications_button (GtkButton** show_modifications_button)
{
	GtkButton* _vala_show_modifications_button = NULL;
	GtkButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_vala_show_modifications_button);
	_vala_show_modifications_button = _tmp0_;
	gtk_widget_set_valign ((GtkWidget*) _vala_show_modifications_button, GTK_ALIGN_CENTER);
	gtk_actionable_set_action_name ((GtkActionable*) _vala_show_modifications_button, "ui.show-in-window-modifications");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _vala_show_modifications_button);
	gtk_style_context_add_class (_tmp1_, "titlebutton");
	gtk_widget_set_visible ((GtkWidget*) _vala_show_modifications_button, TRUE);
	if (show_modifications_button) {
		*show_modifications_button = _vala_show_modifications_button;
	} else {
		_g_object_unref0 (_vala_show_modifications_button);
	}
}

static inline void
dconf_header_bar_add_modification_actions_button (DConfHeaderBar* self)
{
	GtkMenuButton* modification_actions_button = NULL;
	GtkMenuButton* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	dconf_header_bar_create_modification_actions_button (&_tmp0_);
	_g_object_unref0 (modification_actions_button);
	modification_actions_button = _tmp0_;
	base_header_bar_add_named_widget_to_quit_button_stack ((BaseHeaderBar*) self, (GtkWidget*) modification_actions_button, "modification-actions");
	_g_object_unref0 (modification_actions_button);
}

static inline void
dconf_header_bar_create_modification_actions_button (GtkMenuButton** modification_actions_button)
{
	GtkMenuButton* _vala_modification_actions_button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* view_more_image = NULL;
	GtkImage* _tmp1_;
	GtkStyleContext* _tmp2_;
	GMenu* change_pending_menu = NULL;
	GMenu* _tmp3_;
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_vala_modification_actions_button);
	_vala_modification_actions_button = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp1_);
	view_more_image = _tmp1_;
	gtk_button_set_image ((GtkButton*) _vala_modification_actions_button, (GtkWidget*) view_more_image);
	gtk_widget_set_valign ((GtkWidget*) _vala_modification_actions_button, GTK_ALIGN_CENTER);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _vala_modification_actions_button);
	gtk_style_context_add_class (_tmp2_, "titlebutton");
	_tmp3_ = g_menu_new ();
	change_pending_menu = _tmp3_;
	g_menu_append (change_pending_menu, _ ("Apply"), "ui.apply-delayed-settings");
	g_menu_append (change_pending_menu, _ ("Dismiss"), "ui.dismiss-delayed-settings");
	g_menu_freeze (change_pending_menu);
	gtk_menu_button_set_menu_model (_vala_modification_actions_button, (GMenuModel*) change_pending_menu);
	gtk_widget_set_visible ((GtkWidget*) _vala_modification_actions_button, TRUE);
	_g_object_unref0 (change_pending_menu);
	_g_object_unref0 (view_more_image);
	if (modification_actions_button) {
		*modification_actions_button = _vala_modification_actions_button;
	} else {
		_g_object_unref0 (_vala_modification_actions_button);
	}
}

static void
dconf_header_bar_add_modifications_actions_button (GtkMenuButton** modifications_actions_button,
                                                   DConfHeaderBar** _this)
{
	GtkMenuButton* _vala_modifications_actions_button = NULL;
	GtkMenuButton* _tmp0_;
	GtkImage* view_more_image = NULL;
	GtkImage* _tmp1_;
	GtkStyleContext* _tmp2_;
	g_return_if_fail (*_this != NULL);
	_tmp0_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_vala_modifications_actions_button);
	_vala_modifications_actions_button = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("view-more-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp1_);
	view_more_image = _tmp1_;
	gtk_button_set_image ((GtkButton*) _vala_modifications_actions_button, (GtkWidget*) view_more_image);
	gtk_widget_set_valign ((GtkWidget*) _vala_modifications_actions_button, GTK_ALIGN_CENTER);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _vala_modifications_actions_button);
	gtk_style_context_add_class (_tmp2_, "image-button");
	gtk_widget_set_visible ((GtkWidget*) _vala_modifications_actions_button, FALSE);
	gtk_header_bar_pack_end ((GtkHeaderBar*) (*_this), (GtkWidget*) _vala_modifications_actions_button);
	_g_object_unref0 (view_more_image);
	if (modifications_actions_button) {
		*modifications_actions_button = _vala_modifications_actions_button;
	} else {
		_g_object_unref0 (_vala_modifications_actions_button);
	}
}

static void
dconf_header_bar_construct_changes_pending_menu (GMenu** changes_pending_menu)
{
	GMenu* _vala_changes_pending_menu = NULL;
	GMenu* _tmp0_;
	_tmp0_ = g_menu_new ();
	_g_object_unref0 (_vala_changes_pending_menu);
	_vala_changes_pending_menu = _tmp0_;
	g_menu_append (_vala_changes_pending_menu, _ ("Apply all"), "ui.apply-delayed-settings");
	g_menu_append (_vala_changes_pending_menu, _ ("Dismiss all"), "ui.dismiss-delayed-settings");
	g_menu_freeze (_vala_changes_pending_menu);
	if (changes_pending_menu) {
		*changes_pending_menu = _vala_changes_pending_menu;
	} else {
		_g_object_unref0 (_vala_changes_pending_menu);
	}
}

static void
dconf_header_bar_construct_quit_delayed_mode_menu (GMenu** quit_delayed_mode_menu)
{
	GMenu* _vala_quit_delayed_mode_menu = NULL;
	GMenu* _tmp0_;
	_tmp0_ = g_menu_new ();
	_g_object_unref0 (_vala_quit_delayed_mode_menu);
	_vala_quit_delayed_mode_menu = _tmp0_;
	g_menu_append (_vala_quit_delayed_mode_menu, _ ("Quit mode"), "ui.dismiss-delayed-settings");
	g_menu_freeze (_vala_quit_delayed_mode_menu);
	if (quit_delayed_mode_menu) {
		*quit_delayed_mode_menu = _vala_quit_delayed_mode_menu;
	} else {
		_g_object_unref0 (_vala_quit_delayed_mode_menu);
	}
}

void
dconf_header_bar_set_has_pending_changes (DConfHeaderBar* self,
                                          gboolean new_value,
                                          gboolean mode_is_temporary)
{
	g_return_if_fail (self != NULL);
	self->priv->has_pending_changes = new_value;
	if (new_value) {
		GtkMenuButton* _tmp0_;
		GMenu* _tmp1_;
		_tmp0_ = self->priv->modifications_actions_button;
		_tmp1_ = self->priv->changes_pending_menu;
		gtk_menu_button_set_menu_model (_tmp0_, (GMenuModel*) _tmp1_);
		if (mode_is_temporary) {
			base_header_bar_set_quit_button_stack_child ((BaseHeaderBar*) self, "modification-actions");
		}
	} else {
		GtkMenuButton* _tmp2_;
		GMenu* _tmp3_;
		_tmp2_ = self->priv->modifications_actions_button;
		_tmp3_ = self->priv->quit_delayed_mode_menu;
		gtk_menu_button_set_menu_model (_tmp2_, (GMenuModel*) _tmp3_);
		if (mode_is_temporary) {
			base_header_bar_set_quit_button_stack_child ((BaseHeaderBar*) self, "quit-button");
		}
	}
}

static void
dconf_header_bar_real_toggle_view_menu (BaseHeaderBar* base)
{
	DConfHeaderBar * self;
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (DConfHeaderBar*) base;
	_tmp0_ = self->priv->modifications_actions_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkMenuButton* _tmp3_;
		GtkMenuButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->modifications_actions_button;
		_tmp4_ = self->priv->modifications_actions_button;
		_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, !_tmp6_);
	} else {
		BASE_HEADER_BAR_CLASS (dconf_header_bar_parent_class)->toggle_view_menu ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar));
	}
}

static void
dconf_header_bar_real_populate_menu (BaseHeaderBar* base,
                                     GMenu** menu)
{
	DConfHeaderBar * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (DConfHeaderBar*) base;
	g_return_if_fail (*menu != NULL);
	BASE_HEADER_BAR_CLASS (dconf_header_bar_parent_class)->populate_menu ((BaseHeaderBar*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar), menu);
	_tmp0_ = dconf_header_bar_get_delay_mode (self);
	_tmp1_ = _tmp0_;
	dconf_header_bar_append_or_not_delay_mode_section (_tmp1_, self->priv->is_folder_view, menu);
}

static void
dconf_header_bar_append_or_not_delay_mode_section (gboolean delay_mode,
                                                   gboolean is_folder_view,
                                                   GMenu** menu)
{
	gboolean _tmp0_ = FALSE;
	GMenu* section = NULL;
	GMenu* _tmp1_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	g_return_if_fail (*menu != NULL);
	if (delay_mode) {
		_tmp0_ = !is_folder_view;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_menu_new ();
	section = _tmp1_;
	if (!delay_mode) {
		GMenu* _tmp2_;
		_tmp2_ = section;
		g_menu_append (_tmp2_, _ ("Enter delay mode"), "ui.enter-delay-mode");
	}
	if (is_folder_view) {
		GMenu* _tmp3_;
		GMenu* _tmp4_;
		_tmp3_ = section;
		g_menu_append (_tmp3_, _ ("Reset visible keys"), "ui.reset-current-non-recursively");
		_tmp4_ = section;
		g_menu_append (_tmp4_, _ ("Reset view recursively"), "ui.reset-current-recursively");
	}
	_tmp5_ = section;
	g_menu_freeze (_tmp5_);
	_tmp6_ = section;
	g_menu_append_section (*menu, NULL, (GMenuModel*) _tmp6_);
	_g_object_unref0 (section);
}

void
dconf_header_bar_show_modifications_view (DConfHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (((gint) self->priv->modifications_mode_id) > 0, "modifications_mode_id > 0");
	g_signal_emit_by_name ((BaseHeaderBar*) self, "change-mode", self->priv->modifications_mode_id);
}

static void
_dconf_header_bar_mode_changed_modifications_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                          guint8 mode_id,
                                                                          gpointer self)
{
	dconf_header_bar_mode_changed_modifications (_sender, mode_id);
}

static void
dconf_header_bar_register_modifications_mode (DConfHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	self->priv->modifications_mode_id = base_header_bar_register_new_mode ((BaseHeaderBar*) self);
	g_signal_connect ((BaseHeaderBar*) self, "change-mode", (GCallback) _dconf_header_bar_mode_changed_modifications_base_header_bar_change_mode, NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
dconf_header_bar_mode_changed_modifications (BaseHeaderBar* _this,
                                             guint8 requested_mode_id)
{
	DConfHeaderBar* real_this = NULL;
	DConfHeaderBar* _tmp0_;
	DConfHeaderBar* _tmp1_;
	DConfHeaderBar* _tmp2_;
	gboolean _tmp3_;
	DConfHeaderBar* _tmp6_;
	DConfHeaderBar* _tmp7_;
	GtkMenuButton* _tmp8_;
	g_return_if_fail (_this != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_DCONF_HEADER_BAR, DConfHeaderBar));
	real_this = _tmp0_;
	_tmp1_ = real_this;
	_tmp2_ = real_this;
	_tmp3_ = base_header_bar_is_not_requested_mode (_tmp1_->priv->modifications_mode_id, requested_mode_id, &_tmp2_->priv->modifications_mode_on);
	if (_tmp3_) {
		DConfHeaderBar* _tmp4_;
		GtkMenuButton* _tmp5_;
		_tmp4_ = real_this;
		_tmp5_ = _tmp4_->priv->modifications_actions_button;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_g_object_unref0 (real_this);
		return;
	}
	_tmp6_ = real_this;
	base_header_bar_set_default_widgets_states ((BaseHeaderBar*) _tmp6_, _ ("Pending"), TRUE, FALSE, FALSE, FALSE, FALSE);
	_tmp7_ = real_this;
	_tmp8_ = _tmp7_->priv->modifications_actions_button;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	_g_object_unref0 (real_this);
}

static void
dconf_header_bar_update_modifications_button (DConfHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	if (!((BaseHeaderBar*) self)->disable_action_bar) {
		return;
	}
	if (self->priv->modifications_mode_on) {
		base_header_bar_set_quit_button_stack_visibility ((BaseHeaderBar*) self, FALSE);
	} else {
		gboolean _tmp0_;
		gboolean _tmp1_;
		base_header_bar_set_quit_button_stack_visibility ((BaseHeaderBar*) self, TRUE);
		_tmp0_ = dconf_header_bar_get_delay_mode (self);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			base_header_bar_set_quit_button_stack_child ((BaseHeaderBar*) self, "show-modifications");
		} else {
			if (self->priv->has_pending_changes) {
				base_header_bar_set_quit_button_stack_child ((BaseHeaderBar*) self, "modification-actions");
			} else {
				base_header_bar_set_quit_button_stack_child ((BaseHeaderBar*) self, "quit-button");
			}
		}
	}
}

static gboolean
dconf_header_bar_get_delay_mode (DConfHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_delay_mode;
	return result;
}

void
dconf_header_bar_set_delay_mode (DConfHeaderBar* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_delay_mode == value) {
		return;
	}
	self->priv->_delay_mode = value;
	dconf_header_bar_update_modifications_button (self);
	base_header_bar_update_hamburger_menu ((BaseHeaderBar*) self);
}

static GObject *
dconf_header_bar_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DConfHeaderBar * self;
	GtkMenuButton* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	GMenu* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (dconf_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_HEADER_BAR, DConfHeaderBar);
	dconf_header_bar_add_show_modifications_button (self);
	dconf_header_bar_add_modification_actions_button (self);
	dconf_header_bar_add_modifications_actions_button (&_tmp0_, &self);
	_g_object_unref0 (self->priv->modifications_actions_button);
	self->priv->modifications_actions_button = _tmp0_;
	dconf_header_bar_construct_changes_pending_menu (&_tmp1_);
	_g_object_unref0 (self->priv->changes_pending_menu);
	self->priv->changes_pending_menu = _tmp1_;
	dconf_header_bar_construct_quit_delayed_mode_menu (&_tmp2_);
	_g_object_unref0 (self->priv->quit_delayed_mode_menu);
	self->priv->quit_delayed_mode_menu = _tmp2_;
	dconf_header_bar_register_modifications_mode (self);
	return obj;
}

static void
dconf_header_bar_class_init (DConfHeaderBarClass * klass,
                             gpointer klass_data)
{
	dconf_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DConfHeaderBar_private_offset);
	((BrowserHeaderBarClass *) klass)->set_path = (void (*) (BrowserHeaderBar*, ViewType, const gchar*)) dconf_header_bar_real_set_path;
	((BaseHeaderBarClass *) klass)->set_window_size = (void (*) (BaseHeaderBar*, AdaptativeWidgetWindowSize)) dconf_header_bar_real_set_window_size;
	((BaseHeaderBarClass *) klass)->toggle_view_menu = (void (*) (BaseHeaderBar*)) dconf_header_bar_real_toggle_view_menu;
	((BaseHeaderBarClass *) klass)->populate_menu = (void (*) (BaseHeaderBar*, GMenu**)) dconf_header_bar_real_populate_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_header_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_header_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = dconf_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = dconf_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_HEADER_BAR_DELAY_MODE_PROPERTY, dconf_header_bar_properties[DCONF_HEADER_BAR_DELAY_MODE_PROPERTY] = g_param_spec_boolean ("delay-mode", "delay-mode", "delay-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
dconf_header_bar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                   gpointer iface_data)
{
	dconf_header_bar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) dconf_header_bar_real_set_window_size;
}

static void
dconf_header_bar_instance_init (DConfHeaderBar * self,
                                gpointer klass)
{
	self->priv = dconf_header_bar_get_instance_private (self);
	self->priv->_delay_mode = FALSE;
	self->priv->is_folder_view = TRUE;
	self->priv->has_pending_changes = FALSE;
	self->priv->modifications_mode_id = (guint8) 0;
	self->priv->modifications_mode_on = FALSE;
}

static void
dconf_header_bar_finalize (GObject * obj)
{
	DConfHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_HEADER_BAR, DConfHeaderBar);
	_g_object_unref0 (self->priv->modifications_actions_button);
	_g_object_unref0 (self->priv->changes_pending_menu);
	_g_object_unref0 (self->priv->quit_delayed_mode_menu);
	G_OBJECT_CLASS (dconf_header_bar_parent_class)->finalize (obj);
}

static GType
dconf_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DConfHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfHeaderBar), 0, (GInstanceInitFunc) dconf_header_bar_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) dconf_header_bar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dconf_header_bar_type_id;
	dconf_header_bar_type_id = g_type_register_static (TYPE_BOOKMARKS_HEADER_BAR, "DConfHeaderBar", &g_define_type_info, 0);
	g_type_add_interface_static (dconf_header_bar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	DConfHeaderBar_private_offset = g_type_add_instance_private (dconf_header_bar_type_id, sizeof (DConfHeaderBarPrivate));
	return dconf_header_bar_type_id;
}

GType
dconf_header_bar_get_type (void)
{
	static volatile gsize dconf_header_bar_type_id__once = 0;
	if (g_once_init_enter (&dconf_header_bar_type_id__once)) {
		GType dconf_header_bar_type_id;
		dconf_header_bar_type_id = dconf_header_bar_get_type_once ();
		g_once_init_leave (&dconf_header_bar_type_id__once, dconf_header_bar_type_id);
	}
	return dconf_header_bar_type_id__once;
}

static void
_vala_dconf_header_bar_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	DConfHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_HEADER_BAR, DConfHeaderBar);
	switch (property_id) {
		case DCONF_HEADER_BAR_DELAY_MODE_PROPERTY:
		g_value_set_boolean (value, dconf_header_bar_get_delay_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dconf_header_bar_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	DConfHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_HEADER_BAR, DConfHeaderBar);
	switch (property_id) {
		case DCONF_HEADER_BAR_DELAY_MODE_PROPERTY:
		dconf_header_bar_set_delay_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

