/* adaptative-pathbar.c generated by valac 0.56.13, the Vala compiler
 * generated from adaptative-pathbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PATHBAR (pathbar_get_type ())
#define PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATHBAR, Pathbar))
#define IS_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATHBAR))
#define PATHBAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATHBAR, PathbarIface))

typedef struct _Pathbar Pathbar;
typedef struct _PathbarIface PathbarIface;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_ADAPTATIVE_PATHBAR (adaptative_pathbar_get_type ())
#define ADAPTATIVE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbar))
#define ADAPTATIVE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbarClass))
#define IS_ADAPTATIVE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_PATHBAR))
#define IS_ADAPTATIVE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_PATHBAR))
#define ADAPTATIVE_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbarClass))

typedef struct _AdaptativePathbar AdaptativePathbar;
typedef struct _AdaptativePathbarClass AdaptativePathbarClass;
typedef struct _AdaptativePathbarPrivate AdaptativePathbarPrivate;

#define TYPE_LARGE_PATHBAR (large_pathbar_get_type ())
#define LARGE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LARGE_PATHBAR, LargePathbar))
#define LARGE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LARGE_PATHBAR, LargePathbarClass))
#define IS_LARGE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LARGE_PATHBAR))
#define IS_LARGE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LARGE_PATHBAR))
#define LARGE_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LARGE_PATHBAR, LargePathbarClass))

typedef struct _LargePathbar LargePathbar;
typedef struct _LargePathbarClass LargePathbarClass;

#define TYPE_SHORT_PATHBAR (short_pathbar_get_type ())
#define SHORT_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHORT_PATHBAR, ShortPathbar))
#define SHORT_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHORT_PATHBAR, ShortPathbarClass))
#define IS_SHORT_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHORT_PATHBAR))
#define IS_SHORT_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHORT_PATHBAR))
#define SHORT_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHORT_PATHBAR, ShortPathbarClass))

typedef struct _ShortPathbar ShortPathbar;
typedef struct _ShortPathbarClass ShortPathbarClass;
enum  {
	ADAPTATIVE_PATHBAR_0_PROPERTY,
	ADAPTATIVE_PATHBAR_NUM_PROPERTIES
};
static GParamSpec* adaptative_pathbar_properties[ADAPTATIVE_PATHBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PathbarIface {
	GTypeInterface parent_iface;
	gboolean (*has_popover) (Pathbar* self);
	void (*close_menu) (Pathbar* self);
	void (*toggle_menu) (Pathbar* self);
	void (*set_path) (Pathbar* self, ViewType type, const gchar* path);
	void (*update_ghosts) (Pathbar* self, const gchar* non_ghost_path, gboolean is_search);
	void (*get_complete_path) (Pathbar* self, gchar** _complete_path);
	void (*get_fallback_path_and_complete_path) (Pathbar* self, gchar** _fallback_path, gchar** _complete_path);
	gchar* (*get_selected_child) (Pathbar* self, const gchar* current_path);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _AdaptativePathbar {
	GtkStack parent_instance;
	AdaptativePathbarPrivate * priv;
};

struct _AdaptativePathbarClass {
	GtkStackClass parent_class;
};

struct _AdaptativePathbarPrivate {
	gboolean start_infos_not_given;
	gboolean window_size_not_given;
	gboolean large_pathbar_created;
	gboolean short_pathbar_created;
	LargePathbar* large_pathbar;
	ShortPathbar* short_pathbar;
	gboolean thin_window;
	ViewType current_type;
	gchar* current_path;
	gchar* complete_path;
};

static gint AdaptativePathbar_private_offset;
static gpointer adaptative_pathbar_parent_class = NULL;
static PathbarIface * adaptative_pathbar_pathbar_parent_iface = NULL;
static AdaptativeWidgetIface * adaptative_pathbar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pathbar_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType adaptative_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativePathbar, g_object_unref)
VALA_EXTERN GType large_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LargePathbar, g_object_unref)
VALA_EXTERN GType short_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShortPathbar, g_object_unref)
static void adaptative_pathbar_create_large_pathbar (AdaptativePathbar* self);
VALA_EXTERN LargePathbar* large_pathbar_new (const gchar* complete_path_or_empty,
                                 ViewType type,
                                 const gchar* path);
VALA_EXTERN LargePathbar* large_pathbar_construct (GType object_type,
                                       const gchar* complete_path_or_empty,
                                       ViewType type,
                                       const gchar* path);
static void adaptative_pathbar_create_short_pathbar (AdaptativePathbar* self);
VALA_EXTERN ShortPathbar* short_pathbar_new (const gchar* complete_path_or_empty,
                                 ViewType type,
                                 const gchar* path);
VALA_EXTERN ShortPathbar* short_pathbar_construct (GType object_type,
                                       const gchar* complete_path_or_empty,
                                       ViewType type,
                                       const gchar* path);
static void adaptative_pathbar_create_initial_pathbar (AdaptativePathbar* self);
static void adaptative_pathbar_real_set_window_size (AdaptativeWidget* base,
                                              AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
static void adaptative_pathbar_real_set_path (Pathbar* base,
                                       ViewType type,
                                       const gchar* path);
VALA_EXTERN void pathbar_set_path (Pathbar* self,
                       ViewType type,
                       const gchar* path);
static gboolean adaptative_pathbar_real_has_popover (Pathbar* base);
VALA_EXTERN gboolean pathbar_has_popover (Pathbar* self);
static void adaptative_pathbar_real_close_menu (Pathbar* base);
VALA_EXTERN void pathbar_close_menu (Pathbar* self);
static void adaptative_pathbar_real_toggle_menu (Pathbar* base);
VALA_EXTERN void pathbar_toggle_menu (Pathbar* self);
static void adaptative_pathbar_real_get_complete_path (Pathbar* base,
                                                gchar** _complete_path);
static void adaptative_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                                  gchar** _fallback_path,
                                                                  gchar** _complete_path);
VALA_EXTERN void pathbar_get_fallback_path_and_complete_path (Pathbar* self,
                                                  gchar** _fallback_path,
                                                  gchar** _complete_path);
static void adaptative_pathbar_real_update_ghosts (Pathbar* base,
                                            const gchar* non_ghost_path,
                                            gboolean is_search);
VALA_EXTERN void pathbar_update_ghosts (Pathbar* self,
                            const gchar* non_ghost_path,
                            gboolean is_search);
VALA_EXTERN AdaptativePathbar* adaptative_pathbar_new (void);
VALA_EXTERN AdaptativePathbar* adaptative_pathbar_construct (GType object_type);
static GObject * adaptative_pathbar_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN void pathbar_get_complete_path (Pathbar* self,
                                gchar** _complete_path);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void adaptative_pathbar_finalize (GObject * obj);
static GType adaptative_pathbar_get_type_once (void);
VALA_EXTERN gchar* pathbar_get_selected_child (Pathbar* self,
                                   const gchar* current_path);
static gchar* pathbar_real_get_selected_child (Pathbar* self,
                                        const gchar* current_path);
static gchar* _pathbar_get_selected_child (const gchar* current_path,
                                    const gchar* complete_path);
VALA_EXTERN void pathbar_populate_pathbar_menu (gboolean is_folder,
                                    GMenu** menu);
static void pathbar_add_copy_path_section (GMenu** menu);
static void pathbar_add_open_config_section (GMenu** menu);
static GType pathbar_get_type_once (void);

static inline gpointer
adaptative_pathbar_get_instance_private (AdaptativePathbar* self)
{
	return G_STRUCT_MEMBER_P (self, AdaptativePathbar_private_offset);
}

static void
adaptative_pathbar_create_large_pathbar (AdaptativePathbar* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	LargePathbar* _tmp2_;
	LargePathbar* _tmp3_;
	LargePathbar* _tmp4_;
	LargePathbar* _tmp5_;
	LargePathbar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = self->priv->current_path;
	_tmp2_ = large_pathbar_new (_tmp0_, self->priv->current_type, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->large_pathbar);
	self->priv->large_pathbar = _tmp2_;
	_tmp3_ = self->priv->large_pathbar;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_FILL);
	_tmp4_ = self->priv->large_pathbar;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->large_pathbar;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->large_pathbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	self->priv->large_pathbar_created = TRUE;
}

static void
adaptative_pathbar_create_short_pathbar (AdaptativePathbar* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ShortPathbar* _tmp2_;
	ShortPathbar* _tmp3_;
	ShortPathbar* _tmp4_;
	ShortPathbar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = self->priv->current_path;
	_tmp2_ = short_pathbar_new (_tmp0_, self->priv->current_type, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->short_pathbar);
	self->priv->short_pathbar = _tmp2_;
	_tmp3_ = self->priv->short_pathbar;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->short_pathbar;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->short_pathbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	self->priv->short_pathbar_created = TRUE;
}

static void
adaptative_pathbar_create_initial_pathbar (AdaptativePathbar* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->thin_window) {
		ShortPathbar* _tmp0_;
		adaptative_pathbar_create_short_pathbar (self);
		_tmp0_ = self->priv->short_pathbar;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
	} else {
		LargePathbar* _tmp1_;
		adaptative_pathbar_create_large_pathbar (self);
		_tmp1_ = self->priv->large_pathbar;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp1_);
	}
}

static void
adaptative_pathbar_real_set_window_size (AdaptativeWidget* base,
                                         AdaptativeWidgetWindowSize new_size)
{
	AdaptativePathbar * self;
	gboolean _thin_window = FALSE;
	self = (AdaptativePathbar*) base;
	if (self->priv->window_size_not_given) {
		self->priv->thin_window = adaptative_widget_window_size_is_extra_thin (new_size);
		self->priv->window_size_not_given = FALSE;
		if (self->priv->start_infos_not_given) {
			return;
		}
		adaptative_pathbar_create_initial_pathbar (self);
		return;
	}
	_thin_window = adaptative_widget_window_size_is_extra_thin (new_size);
	if (self->priv->thin_window == _thin_window) {
		return;
	}
	self->priv->thin_window = _thin_window;
	if (self->priv->start_infos_not_given) {
		return;
	}
	if (_thin_window) {
		ShortPathbar* _tmp0_;
		if (!self->priv->short_pathbar_created) {
			adaptative_pathbar_create_short_pathbar (self);
		}
		_tmp0_ = self->priv->short_pathbar;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
	} else {
		LargePathbar* _tmp1_;
		if (!self->priv->large_pathbar_created) {
			adaptative_pathbar_create_large_pathbar (self);
		}
		_tmp1_ = self->priv->large_pathbar;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp1_);
	}
}

static void
adaptative_pathbar_real_set_path (Pathbar* base,
                                  ViewType type,
                                  const gchar* path)
{
	AdaptativePathbar * self;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	self = (AdaptativePathbar*) base;
	g_return_if_fail (path != NULL);
	self->priv->current_type = type;
	_tmp0_ = g_strdup (path);
	_g_free0 (self->priv->current_path);
	self->priv->current_path = _tmp0_;
	_tmp3_ = self->priv->complete_path;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !g_str_has_suffix (path, "/");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->complete_path;
		_tmp1_ = !g_str_has_prefix (_tmp4_, path);
	}
	if (_tmp1_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (path);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp5_;
	}
	if (self->priv->start_infos_not_given) {
		self->priv->start_infos_not_given = FALSE;
		if (self->priv->window_size_not_given) {
			return;
		}
		adaptative_pathbar_create_initial_pathbar (self);
		return;
	}
	if (self->priv->window_size_not_given) {
		return;
	}
	if (self->priv->large_pathbar_created) {
		LargePathbar* _tmp6_;
		_tmp6_ = self->priv->large_pathbar;
		pathbar_set_path ((Pathbar*) _tmp6_, type, path);
	}
	if (self->priv->short_pathbar_created) {
		ShortPathbar* _tmp7_;
		_tmp7_ = self->priv->short_pathbar;
		pathbar_set_path ((Pathbar*) _tmp7_, type, path);
	}
}

static gboolean
adaptative_pathbar_real_has_popover (Pathbar* base)
{
	AdaptativePathbar * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (AdaptativePathbar*) base;
	if (self->priv->large_pathbar_created) {
		LargePathbar* _tmp2_;
		_tmp2_ = self->priv->large_pathbar;
		_tmp1_ = pathbar_has_popover ((Pathbar*) _tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->short_pathbar_created) {
			ShortPathbar* _tmp4_;
			_tmp4_ = self->priv->short_pathbar;
			_tmp3_ = pathbar_has_popover ((Pathbar*) _tmp4_);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static void
adaptative_pathbar_real_close_menu (Pathbar* base)
{
	AdaptativePathbar * self;
	self = (AdaptativePathbar*) base;
	if (self->priv->large_pathbar_created) {
		LargePathbar* _tmp0_;
		_tmp0_ = self->priv->large_pathbar;
		pathbar_close_menu ((Pathbar*) _tmp0_);
	}
	if (self->priv->short_pathbar_created) {
		ShortPathbar* _tmp1_;
		_tmp1_ = self->priv->short_pathbar;
		pathbar_close_menu ((Pathbar*) _tmp1_);
	}
}

static void
adaptative_pathbar_real_toggle_menu (Pathbar* base)
{
	AdaptativePathbar * self;
	self = (AdaptativePathbar*) base;
	if (self->priv->thin_window) {
		ShortPathbar* _tmp0_;
		if (!self->priv->short_pathbar_created) {
			g_assert_not_reached ();
		}
		_tmp0_ = self->priv->short_pathbar;
		pathbar_toggle_menu ((Pathbar*) _tmp0_);
	} else {
		LargePathbar* _tmp1_;
		if (!self->priv->large_pathbar_created) {
			g_assert_not_reached ();
		}
		_tmp1_ = self->priv->large_pathbar;
		pathbar_toggle_menu ((Pathbar*) _tmp1_);
	}
}

static void
adaptative_pathbar_real_get_complete_path (Pathbar* base,
                                           gchar** _complete_path)
{
	AdaptativePathbar * self;
	gchar* _vala__complete_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (AdaptativePathbar*) base;
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala__complete_path);
	_vala__complete_path = _tmp1_;
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

static void
adaptative_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                             gchar** _fallback_path,
                                                             gchar** _complete_path)
{
	AdaptativePathbar * self;
	gchar* _vala__fallback_path = NULL;
	gchar* _vala__complete_path = NULL;
	self = (AdaptativePathbar*) base;
	if (self->priv->large_pathbar_created) {
		LargePathbar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp0_ = self->priv->large_pathbar;
		pathbar_get_fallback_path_and_complete_path ((Pathbar*) _tmp0_, &_tmp1_, &_tmp2_);
		_g_free0 (_vala__fallback_path);
		_vala__fallback_path = _tmp1_;
		_g_free0 (_vala__complete_path);
		_vala__complete_path = _tmp2_;
	} else {
		if (self->priv->short_pathbar_created) {
			ShortPathbar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp3_ = self->priv->short_pathbar;
			pathbar_get_fallback_path_and_complete_path ((Pathbar*) _tmp3_, &_tmp4_, &_tmp5_);
			_g_free0 (_vala__fallback_path);
			_vala__fallback_path = _tmp4_;
			_g_free0 (_vala__complete_path);
			_vala__complete_path = _tmp5_;
		} else {
			g_assert_not_reached ();
		}
	}
	if (_fallback_path) {
		*_fallback_path = _vala__fallback_path;
	} else {
		_g_free0 (_vala__fallback_path);
	}
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

static void
adaptative_pathbar_real_update_ghosts (Pathbar* base,
                                       const gchar* non_ghost_path,
                                       gboolean is_search)
{
	AdaptativePathbar * self;
	self = (AdaptativePathbar*) base;
	g_return_if_fail (non_ghost_path != NULL);
	if (self->priv->large_pathbar_created) {
		LargePathbar* _tmp0_;
		_tmp0_ = self->priv->large_pathbar;
		pathbar_update_ghosts ((Pathbar*) _tmp0_, non_ghost_path, is_search);
	}
	if (self->priv->short_pathbar_created) {
		ShortPathbar* _tmp1_;
		_tmp1_ = self->priv->short_pathbar;
		pathbar_update_ghosts ((Pathbar*) _tmp1_, non_ghost_path, is_search);
	}
}

AdaptativePathbar*
adaptative_pathbar_construct (GType object_type)
{
	AdaptativePathbar * self = NULL;
	self = (AdaptativePathbar*) g_object_new (object_type, NULL);
	return self;
}

AdaptativePathbar*
adaptative_pathbar_new (void)
{
	return adaptative_pathbar_construct (TYPE_ADAPTATIVE_PATHBAR);
}

static GObject *
adaptative_pathbar_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AdaptativePathbar * self;
	parent_class = G_OBJECT_CLASS (adaptative_pathbar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbar);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_stack_set_hhomogeneous ((GtkStack*) self, FALSE);
	return obj;
}

static void
adaptative_pathbar_class_init (AdaptativePathbarClass * klass,
                               gpointer klass_data)
{
	adaptative_pathbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdaptativePathbar_private_offset);
	G_OBJECT_CLASS (klass)->constructor = adaptative_pathbar_constructor;
	G_OBJECT_CLASS (klass)->finalize = adaptative_pathbar_finalize;
}

static void
adaptative_pathbar_pathbar_interface_init (PathbarIface * iface,
                                           gpointer iface_data)
{
	adaptative_pathbar_pathbar_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_path = (void (*) (Pathbar*, ViewType, const gchar*)) adaptative_pathbar_real_set_path;
	iface->has_popover = (gboolean (*) (Pathbar*)) adaptative_pathbar_real_has_popover;
	iface->close_menu = (void (*) (Pathbar*)) adaptative_pathbar_real_close_menu;
	iface->toggle_menu = (void (*) (Pathbar*)) adaptative_pathbar_real_toggle_menu;
	iface->get_complete_path = (void (*) (Pathbar*, gchar**)) adaptative_pathbar_real_get_complete_path;
	iface->get_fallback_path_and_complete_path = (void (*) (Pathbar*, gchar**, gchar**)) adaptative_pathbar_real_get_fallback_path_and_complete_path;
	iface->update_ghosts = (void (*) (Pathbar*, const gchar*, gboolean)) adaptative_pathbar_real_update_ghosts;
}

static void
adaptative_pathbar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                     gpointer iface_data)
{
	adaptative_pathbar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) adaptative_pathbar_real_set_window_size;
}

static void
adaptative_pathbar_instance_init (AdaptativePathbar * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	self->priv = adaptative_pathbar_get_instance_private (self);
	self->priv->start_infos_not_given = TRUE;
	self->priv->window_size_not_given = TRUE;
	self->priv->large_pathbar_created = FALSE;
	self->priv->short_pathbar_created = FALSE;
	self->priv->thin_window = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->complete_path = _tmp0_;
}

static void
adaptative_pathbar_finalize (GObject * obj)
{
	AdaptativePathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADAPTATIVE_PATHBAR, AdaptativePathbar);
	_g_object_unref0 (self->priv->large_pathbar);
	_g_object_unref0 (self->priv->short_pathbar);
	_g_free0 (self->priv->current_path);
	_g_free0 (self->priv->complete_path);
	G_OBJECT_CLASS (adaptative_pathbar_parent_class)->finalize (obj);
}

static GType
adaptative_pathbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdaptativePathbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adaptative_pathbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdaptativePathbar), 0, (GInstanceInitFunc) adaptative_pathbar_instance_init, NULL };
	static const GInterfaceInfo pathbar_info = { (GInterfaceInitFunc) adaptative_pathbar_pathbar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) adaptative_pathbar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType adaptative_pathbar_type_id;
	adaptative_pathbar_type_id = g_type_register_static (gtk_stack_get_type (), "AdaptativePathbar", &g_define_type_info, 0);
	g_type_add_interface_static (adaptative_pathbar_type_id, TYPE_PATHBAR, &pathbar_info);
	g_type_add_interface_static (adaptative_pathbar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	AdaptativePathbar_private_offset = g_type_add_instance_private (adaptative_pathbar_type_id, sizeof (AdaptativePathbarPrivate));
	return adaptative_pathbar_type_id;
}

GType
adaptative_pathbar_get_type (void)
{
	static volatile gsize adaptative_pathbar_type_id__once = 0;
	if (g_once_init_enter (&adaptative_pathbar_type_id__once)) {
		GType adaptative_pathbar_type_id;
		adaptative_pathbar_type_id = adaptative_pathbar_get_type_once ();
		g_once_init_leave (&adaptative_pathbar_type_id__once, adaptative_pathbar_type_id);
	}
	return adaptative_pathbar_type_id__once;
}

gboolean
pathbar_has_popover (Pathbar* self)
{
	PathbarIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->has_popover) {
		return _iface_->has_popover (self);
	}
	return FALSE;
}

void
pathbar_close_menu (Pathbar* self)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->close_menu) {
		_iface_->close_menu (self);
	}
}

void
pathbar_toggle_menu (Pathbar* self)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->toggle_menu) {
		_iface_->toggle_menu (self);
	}
}

void
pathbar_set_path (Pathbar* self,
                  ViewType type,
                  const gchar* path)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->set_path) {
		_iface_->set_path (self, type, path);
	}
}

void
pathbar_update_ghosts (Pathbar* self,
                       const gchar* non_ghost_path,
                       gboolean is_search)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->update_ghosts) {
		_iface_->update_ghosts (self, non_ghost_path, is_search);
	}
}

void
pathbar_get_complete_path (Pathbar* self,
                           gchar** _complete_path)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->get_complete_path) {
		_iface_->get_complete_path (self, _complete_path);
	}
}

void
pathbar_get_fallback_path_and_complete_path (Pathbar* self,
                                             gchar** _fallback_path,
                                             gchar** _complete_path)
{
	PathbarIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->get_fallback_path_and_complete_path) {
		_iface_->get_fallback_path_and_complete_path (self, _fallback_path, _complete_path);
	}
}

static gchar*
pathbar_real_get_selected_child (Pathbar* self,
                                 const gchar* current_path)
{
	gchar* complete_path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (current_path != NULL, NULL);
	pathbar_get_complete_path (self, &_tmp0_);
	_g_free0 (complete_path);
	complete_path = _tmp0_;
	_tmp1_ = _pathbar_get_selected_child (current_path, complete_path);
	result = _tmp1_;
	_g_free0 (complete_path);
	return result;
}

gchar*
pathbar_get_selected_child (Pathbar* self,
                            const gchar* current_path)
{
	PathbarIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PATHBAR_GET_INTERFACE (self);
	if (_iface_->get_selected_child) {
		return _iface_->get_selected_child (self, current_path);
	}
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
_pathbar_get_selected_child (const gchar* current_path,
                             const gchar* complete_path)
{
	gboolean _tmp0_ = FALSE;
	gint index_of_last_slash = 0;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* result;
	g_return_val_if_fail (current_path != NULL, NULL);
	g_return_val_if_fail (complete_path != NULL, NULL);
	if (!g_str_has_prefix (complete_path, current_path)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (complete_path, current_path) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = strlen (current_path);
	_tmp3_ = _tmp2_;
	index_of_last_slash = string_index_of (complete_path, "/", _tmp3_);
	if (index_of_last_slash == -1) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (complete_path);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = string_slice (complete_path, (glong) 0, (glong) (index_of_last_slash + 1));
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp6_;
	}
	result = _tmp4_;
	return result;
}

void
pathbar_populate_pathbar_menu (gboolean is_folder,
                               GMenu** menu)
{
	g_return_if_fail (*menu != NULL);
	pathbar_add_copy_path_section (menu);
	if (is_folder) {
		pathbar_add_open_config_section (menu);
	}
}

static void
pathbar_add_copy_path_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Copy current path"), "base.copy-alt");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static void
pathbar_add_open_config_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (*menu != NULL);
	return;
}

static void
pathbar_default_init (PathbarIface * iface,
                      gpointer iface_data)
{
	iface->get_selected_child = pathbar_real_get_selected_child;
}

static GType
pathbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PathbarIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pathbar_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pathbar_type_id;
	pathbar_type_id = g_type_register_static (G_TYPE_INTERFACE, "Pathbar", &g_define_type_info, 0);
	return pathbar_type_id;
}

GType
pathbar_get_type (void)
{
	static volatile gsize pathbar_type_id__once = 0;
	if (g_once_init_enter (&pathbar_type_id__once)) {
		GType pathbar_type_id;
		pathbar_type_id = pathbar_get_type_once ();
		g_once_init_leave (&pathbar_type_id__once, pathbar_type_id);
	}
	return pathbar_type_id__once;
}

