/** generated file, do not edit! */
#ifndef DT_CONFGEN_H
#define DT_CONFGEN_H

#pragma GCC diagnostic ignored "-Wunused-variable"

#include "control/conf.h"

#define WRAP_TRANSLATION(text)

static void _insert_default(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->def);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->def = g_strdup(value);
}

static void _insert_values(const char *name, const char *values)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->enum_values);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->enum_values = g_strdup(values);
}

static void _insert_min(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->min);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->min = g_strdup(value);
}

static void _insert_max(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->max);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->max = g_strdup(value);
}

static void _insert_type(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(!item)
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }

  if      (!strcmp(value, "int"))   item->type = DT_INT;
  else if (!strcmp(value, "int64")) item->type = DT_INT64;
  else if (!strcmp(value, "bool"))  item->type = DT_BOOL;
  else if (!strcmp(value, "float")) item->type = DT_FLOAT;
  else if (!strcmp(value, "enum"))  item->type = DT_ENUM;
  else if (!strcmp(value, "dir"))   item->type = DT_PATH;
  else                              item->type = DT_STRING;
}

static void _insert_shortdescription(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->shortdesc);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->shortdesc = g_strdup(value);
}

static void _insert_longdescription(const char *name, const char *value)
{
  dt_confgen_value_t *item = (dt_confgen_value_t *)g_hash_table_lookup(darktable.conf->x_confgen, name);

  if(item)
  {
     g_free(item->longdesc);
  }
  else
  {
     item = (dt_confgen_value_t *)g_malloc0(sizeof(dt_confgen_value_t));
     g_hash_table_insert(darktable.conf->x_confgen, g_strdup(name), item);
  }
  item->longdesc = g_strdup(value);
}

static void _free_confgen_value(void *value)
{
  dt_confgen_value_t *s = (dt_confgen_value_t *)value;
  g_free(s->def);
  g_free(s->min);
  g_free(s->max);
  g_free(s->enum_values);
  g_free(s->shortdesc);
  g_free(s->longdesc);
  g_free(s);
}

void dt_confgen_init()
{
   darktable.conf->x_confgen = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, _free_confgen_value);

   // themes/usercss
   _insert_type("themes/usercss", "bool");
   _insert_default("themes/usercss", "false");
   _insert_shortdescription("themes/usercss", "modify theme with user tweaks");

   // accel/prefer_focused
   _insert_type("accel/prefer_focused", "bool");
   _insert_default("accel/prefer_focused", "true");
   _insert_shortdescription("accel/prefer_focused", "prefer focused instance");
   _insert_longdescription("accel/prefer_focused", "where multiple instances of a module are present, apply shortcuts to the instance that has focus\nif none are focused, the preferences below control rules that are followed (in order) to decide which module instance shortcuts will be applied to.\nnote: blending shortcuts always apply to the focused instance");

   // accel/prefer_expanded
   _insert_type("accel/prefer_expanded", "bool");
   _insert_default("accel/prefer_expanded", "false");
   _insert_shortdescription("accel/prefer_expanded", "prefer expanded instances");
   _insert_longdescription("accel/prefer_expanded", "if instances of the module are expanded, ignore collapsed instances");

   // accel/prefer_enabled
   _insert_type("accel/prefer_enabled", "bool");
   _insert_default("accel/prefer_enabled", "false");
   _insert_shortdescription("accel/prefer_enabled", "prefer enabled instances");
   _insert_longdescription("accel/prefer_enabled", "after applying the above rule, if instances of the module are active, ignore inactive instances");

   // accel/prefer_unmasked
   _insert_type("accel/prefer_unmasked", "bool");
   _insert_default("accel/prefer_unmasked", "false");
   _insert_shortdescription("accel/prefer_unmasked", "prefer unmasked instances");
   _insert_longdescription("accel/prefer_unmasked", "after applying the above rules, if instances of the module are unmasked, ignore masked instances");

   // accel/select_order
   _insert_type("accel/select_order", "enum");
   _insert_values("accel/select_order", "[first instance][last instance]");
   WRAP_TRANSLATION(C_("preferences", "first instance"));
   WRAP_TRANSLATION(C_("preferences", "last instance"));
   _insert_default("accel/select_order", "last instance");
   _insert_shortdescription("accel/select_order", "selection order");
   _insert_longdescription("accel/select_order", "after applying the above rules, apply the shortcut based on its position in the pixelpipe");

   // accel/assign_instance
   _insert_type("accel/assign_instance", "bool");
   _insert_default("accel/assign_instance", "false");
   _insert_shortdescription("accel/assign_instance", "allow visual assignment to specific instances");
   _insert_longdescription("accel/assign_instance", "when multiple instances are present on an image this allows shortcuts to be visually assigned to those specific instances\notherwise shortcuts will always be assigned to the preferred instance");

   // accel/slider_precision
   _insert_type("accel/slider_precision", "int");
   _insert_default("accel/slider_precision", "0");
   _insert_shortdescription("accel/slider_precision", "keyboard shortcut slider precision");

   // accel/enable_fallbacks
   _insert_type("accel/enable_fallbacks", "bool");
   _insert_default("accel/enable_fallbacks", "false");
   _insert_shortdescription("accel/enable_fallbacks", "enable shortcut fallbacks");
   _insert_longdescription("accel/enable_fallbacks", "enables default meanings for additional buttons, modifiers or moves when used in combination with a base shortcut");

   // accel/load_defaults
   _insert_type("accel/load_defaults", "bool");
   _insert_default("accel/load_defaults", "true");
   _insert_shortdescription("accel/load_defaults", "load default shortcuts at startup");
   _insert_longdescription("accel/load_defaults", "load default shortcuts before user settings. switch off to prevent deleted defaults returning");

   // accel/show_tab_in_prefs
   _insert_type("accel/show_tab_in_prefs", "bool");
   _insert_default("accel/show_tab_in_prefs", "true");
   _insert_shortdescription("accel/show_tab_in_prefs", "show the shortcuts configuration tab in the preferences dialog");

   // accel/hide_notice
   _insert_type("accel/hide_notice", "bool");
   _insert_default("accel/hide_notice", "false");
   _insert_shortdescription("accel/hide_notice", "don't show advice in shortcuts dialog");

   // bauhaus/scale
   _insert_type("bauhaus/scale", "float");
   _insert_default("bauhaus/scale", "1.4");
   _insert_shortdescription("bauhaus/scale", "widget scale");
   _insert_longdescription("bauhaus/scale", "scaling factor for bauhaus widgets, will affect font size");

   // bauhaus/zoom_step
   _insert_type("bauhaus/zoom_step", "bool");
   _insert_default("bauhaus/zoom_step", "true");
   _insert_shortdescription("bauhaus/zoom_step", "scale slider step with min/max");
   _insert_longdescription("bauhaus/zoom_step", "vary slider step size with min/max range");

   // database
   _insert_type("database", "string");
   _insert_default("database", "library.db");
   _insert_shortdescription("database", "database location");
   _insert_longdescription("database", "filename relative to ~/.config/darktable or starting with a slash (needs a restart).");

   // storage/piwigo/last_album
   _insert_type("storage/piwigo/last_album", "string");
   _insert_default("storage/piwigo/last_album", "");
   _insert_shortdescription("storage/piwigo/last_album", "");
   _insert_longdescription("storage/piwigo/last_album", "");

   // storage/piwigo/overwrite
   _insert_type("storage/piwigo/overwrite", "int");
   _insert_default("storage/piwigo/overwrite", "0");
   _insert_shortdescription("storage/piwigo/overwrite", "");
   _insert_longdescription("storage/piwigo/overwrite", "");

   // database/maintenance_freepage_ratio
   _insert_type("database/maintenance_freepage_ratio", "int");
   _insert_default("database/maintenance_freepage_ratio", "25");
   _insert_shortdescription("database/maintenance_freepage_ratio", "database fragmentation ratio threshold");
   _insert_longdescription("database/maintenance_freepage_ratio", "fragmentation ratio above which to ask or carry out automatically database maintenance");

   // database/create_snapshot
   _insert_type("database/create_snapshot", "enum");
   _insert_values("database/create_snapshot", "[never][once a month][once a week][once a day][on close]");
   WRAP_TRANSLATION(C_("preferences", "never"));
   WRAP_TRANSLATION(C_("preferences", "once a month"));
   WRAP_TRANSLATION(C_("preferences", "once a week"));
   WRAP_TRANSLATION(C_("preferences", "once a day"));
   WRAP_TRANSLATION(C_("preferences", "on close"));
   _insert_default("database/create_snapshot", "once a week");
   _insert_shortdescription("database/create_snapshot", "create database snapshot");
   _insert_longdescription("database/create_snapshot", "database snapshots are created right before closing darktable. options allow you to choose how often to make snapshots:\n - 'never': simply don't do snapshots. that way the only snapshots done are mandatory version-upgrade snapshots\n - 'once a month': create snapshot if a month has passed since last snapshot\n - 'once a week': create snapshot if 7 days had passed since last snapshot\n - 'once a day': create snapshot if over 24h passed since last snapshot\n - 'on close': create snapshot every time darktable is closed");

   // database/keep_snapshots
   _insert_type("database/keep_snapshots", "int");
   _insert_default("database/keep_snapshots", "10");
   _insert_shortdescription("database/keep_snapshots", "how many snapshots to keep");
   _insert_longdescription("database/keep_snapshots", "after successfully creating snapshot, how many older snapshots to keep (excluding mandatory version update ones). enter -1 to keep all snapshots\nkeep in mind that snapshots do take some space and you only need the most recent one for successful restore");

   // min_panel_height
   _insert_type("min_panel_height", "int");
   _insert_default("min_panel_height", "64");
   _insert_shortdescription("min_panel_height", "minimum width of the side panels in pixels");
   _insert_longdescription("min_panel_height", "(needs a restart)");

   // max_panel_height
   _insert_type("max_panel_height", "int");
   _insert_default("max_panel_height", "400");
   _insert_shortdescription("max_panel_height", "maximum width of the side panels in pixels");
   _insert_longdescription("max_panel_height", "(needs a restart)");

   // slideshow_delay
   _insert_type("slideshow_delay", "int");
   _insert_default("slideshow_delay", "5");
   _insert_shortdescription("slideshow_delay", "waiting time between each picture in slideshow");

   // ui_last/no_april1st
   _insert_type("ui_last/no_april1st", "bool");
   _insert_default("ui_last/no_april1st", "true");
   _insert_shortdescription("ui_last/no_april1st", "do not show april 1st game");

   // resourcelevel
   _insert_type("resourcelevel", "enum");
   _insert_values("resourcelevel", "[small][default][large][unrestricted]");
   WRAP_TRANSLATION(C_("preferences", "small"));
   WRAP_TRANSLATION(C_("preferences", "default"));
   WRAP_TRANSLATION(C_("preferences", "large"));
   WRAP_TRANSLATION(C_("preferences", "unrestricted"));
   _insert_default("resourcelevel", "default");
   _insert_shortdescription("resourcelevel", "darktable resources");
   _insert_longdescription("resourcelevel", "defines how much darktable may take from your system resources:\n - 'default': darktable takes ~50% of your systems resources and gives darktable enough to be still performant.\n - 'small': should be used if you are simultaneously running applications taking large parts of your systems memory or OpenCL/GL applications like games or Hugin.\n - 'large': is the best option if you are mainly using darktable and want it to take most of your systems resources for performance.\n - 'unrestricted': should only be used for developing extremely large images as darktable will take all of your systems resources\n   and thus might lead to swapping and unexpected performance drops.\n   use with caution and not recommended for general use!");

   // ui/performance
   _insert_type("ui/performance", "bool");
   _insert_default("ui/performance", "false");
   _insert_shortdescription("ui/performance", "prefer performance over quality");
   _insert_longdescription("ui/performance", "if switched on, thumbnails and previews are rendered at lower quality but 4 times faster");

   // backthumbs_inactivity
   _insert_type("backthumbs_inactivity", "float");
   _insert_default("backthumbs_inactivity", "5.0");
   _insert_shortdescription("backthumbs_inactivity", "inactivity time");
   _insert_longdescription("backthumbs_inactivity", "user inactivity time (seconds) while being in lighttable before a thumbnail generation might start");

   // cache_color_managed
   _insert_type("cache_color_managed", "bool");
   _insert_default("cache_color_managed", "true");
   _insert_shortdescription("cache_color_managed", "color manage cached thumbnails");
   _insert_longdescription("cache_color_managed", "if enabled, cached thumbnails will be color managed so that lighttable and filmstrip can show correct colors. otherwise the results may look wrong once the display profile gets changed.");

   // opencl_device_priority
   _insert_type("opencl_device_priority", "string");
   _insert_default("opencl_device_priority", "*/!0,*/*/*/!0,*");
   _insert_shortdescription("opencl_device_priority", "priority of OpenCL devices for each pixelpipe type");
   _insert_longdescription("opencl_device_priority", "defines priorities on how (multiple) OpenCL devices are allocated to the different types of pixelpipe (full, preview, export, thumbnail, preview2). for more details visit our usermanual (needs a restart).");

   // opencl_mandatory_timeout
   _insert_type("opencl_mandatory_timeout", "int");
   _insert_default("opencl_mandatory_timeout", "400");
   _insert_min("opencl_mandatory_timeout", "100");
   _insert_shortdescription("opencl_mandatory_timeout", "timeout period for locking mandatory opencl device");
   _insert_longdescription("opencl_mandatory_timeout", "time period (in units of 5ms) after which we give up try-locking an opencl device for mandatory use. defaults to 400 (2 seconds).");

   // opencl_checksum
   _insert_type("opencl_checksum", "string");
   _insert_default("opencl_checksum", "");
   _insert_shortdescription("opencl_checksum", "checksum representing the setup of opencl devices on this computer");
   _insert_longdescription("opencl_checksum", "darktable re-checks the performance benchmarks of your system in case your setup has changed, which is indicated by a change versus the stored checksum in this config variable; darktable de-activates opencl if the GPU benchmark lies below the one of the CPU; initial value is the empty string; set to OFF if you want to deactivate any automatic checks and prefer to do all configurations manually.");

   // pixelpipe_synchronization_timeout
   _insert_type("pixelpipe_synchronization_timeout", "int");
   _insert_default("pixelpipe_synchronization_timeout", "200");
   _insert_shortdescription("pixelpipe_synchronization_timeout", "timeout period of pixelpipe synchronization");
   _insert_longdescription("pixelpipe_synchronization_timeout", "time period (in units of 5ms) after which synchronization of preview and full pixelpipe is assumed to have failed. set to zero to omit pixelpipe synchronization. defaults to 200.");

   // libraw_extensions
   _insert_type("libraw_extensions", "string");
   _insert_default("libraw_extensions", "");
   _insert_shortdescription("libraw_extensions", "raw file extensions to be processed by libraw");
   _insert_longdescription("libraw_extensions", "space-delimited list of raw file extensions (without a leading dot, in lowercase) to be processed by libraw instead of rawspeed.");

   // write_sidecar_files
   _insert_type("write_sidecar_files", "enum");
   _insert_values("write_sidecar_files", "[never][after edit][on import]");
   WRAP_TRANSLATION(C_("preferences", "never"));
   WRAP_TRANSLATION(C_("preferences", "after edit"));
   WRAP_TRANSLATION(C_("preferences", "on import"));
   _insert_default("write_sidecar_files", "on import");
   _insert_shortdescription("write_sidecar_files", "create XMP files");
   _insert_longdescription("write_sidecar_files", "XMP sidecar files hold information about all your development steps to allow flawless re-importing of image files.\n\ndepending on the selected mode sidecar files will be created:\n - 'never'\n - 'on import': immediately after importing the image\n - 'after edit': after any user change on the image or adding tags.");

   // compress_xmp_tags
   _insert_type("compress_xmp_tags", "enum");
   _insert_values("compress_xmp_tags", "[never][always][only large entries]");
   WRAP_TRANSLATION(C_("preferences", "never"));
   WRAP_TRANSLATION(C_("preferences", "always"));
   WRAP_TRANSLATION(C_("preferences", "only large entries"));
   _insert_default("compress_xmp_tags", "only large entries");
   _insert_shortdescription("compress_xmp_tags", "store XMP tags in compressed format");
   _insert_longdescription("compress_xmp_tags", "entries in XMP tags can get rather large and may exceed the available space to store the history stack in output files.\nthis option allows XMP tags to be compressed and save space.");

   // autosave_interval
   _insert_type("autosave_interval", "int");
   _insert_default("autosave_interval", "10");
   _insert_shortdescription("autosave_interval", "auto-save interval");
   _insert_longdescription("autosave_interval", "automatically save history while developing using the given interval (in seconds); set to zero to disable auto-saving. auto-saving might be disabled on slow drives.");

   // omit_tag_hierarchy
   _insert_type("omit_tag_hierarchy", "bool");
   _insert_default("omit_tag_hierarchy", "false");
   _insert_shortdescription("omit_tag_hierarchy", "omit hierarchy in simple tag lists");
   _insert_longdescription("omit_tag_hierarchy", "when creating an XMP sidecar file the hierarchical tags are also added as a simple list\nof non-hierarchical ones to make them visible to some other programs.\nwhen this option is checked darktable will only include their last part\nand ignore the rest. so 'foo|bar|baz' will only add 'baz'.");

   // plugins/lighttable/tagging/no_uncategorized
   _insert_type("plugins/lighttable/tagging/no_uncategorized", "bool");
   _insert_default("plugins/lighttable/tagging/no_uncategorized", "false");
   _insert_shortdescription("plugins/lighttable/tagging/no_uncategorized", "do not set the 'uncategorized' entry for tags");
   _insert_longdescription("plugins/lighttable/tagging/no_uncategorized", "do not set the 'uncategorized' entry for tags which do not have children");

   // plugins/lighttable/tagging/case_sensitivity
   _insert_type("plugins/lighttable/tagging/case_sensitivity", "enum");
   _insert_values("plugins/lighttable/tagging/case_sensitivity", "[sensitive][insensitive]");
   WRAP_TRANSLATION(C_("preferences", "sensitive"));
   WRAP_TRANSLATION(C_("preferences", "insensitive"));
   _insert_default("plugins/lighttable/tagging/case_sensitivity", "insensitive");
   _insert_shortdescription("plugins/lighttable/tagging/case_sensitivity", "tags case sensitivity");
   _insert_longdescription("plugins/lighttable/tagging/case_sensitivity", "tags case sensitivity. without the Sqlite ICU extension, insensitivity works only for the 26 latin letters");

   // opencl
   _insert_type("opencl", "bool");
   _insert_default("opencl", "true");
   _insert_shortdescription("opencl", "activate OpenCL support");
   _insert_longdescription("opencl", "if found, use OpenCL runtime on your system to speed up processing.\ncan be switched on and off at any time.");

   // opencl_scheduling_profile
   _insert_type("opencl_scheduling_profile", "enum");
   _insert_values("opencl_scheduling_profile", "[default][multiple GPUs][very fast GPU]");
   WRAP_TRANSLATION(C_("preferences", "default"));
   WRAP_TRANSLATION(C_("preferences", "multiple GPUs"));
   WRAP_TRANSLATION(C_("preferences", "very fast GPU"));
   _insert_default("opencl_scheduling_profile", "default");
   _insert_shortdescription("opencl_scheduling_profile", "OpenCL scheduling profile");
   _insert_longdescription("opencl_scheduling_profile", "defines how preview and full pixelpipe tasks are scheduled on OpenCL enabled systems:\n - 'default': GPU processes full and CPU processes preview pipe (adaptable by config parameters),\n - 'multiple GPUs': process both pixelpipes in parallel on two different GPUs,\n - 'very fast GPU': process both pixelpipes sequentially on the GPU.");

   // opencl_tune_headroom
   _insert_type("opencl_tune_headroom", "bool");
   _insert_default("opencl_tune_headroom", "false");
   _insert_shortdescription("opencl_tune_headroom", "use all device memory");
   _insert_longdescription("opencl_tune_headroom", "if enabled darktable will use all device memory except a safety margin (headroom, default is 600MB)");

   // clplatform_intelropenclhdgraphics
   _insert_type("clplatform_intelropenclhdgraphics", "bool");
   _insert_default("clplatform_intelropenclhdgraphics", "true");
   _insert_shortdescription("clplatform_intelropenclhdgraphics", "Intel GPU");
   _insert_longdescription("clplatform_intelropenclhdgraphics", "Intel(R) OpenCL Graphics for all supported platforms (vendor provided)");

   // clplatform_nvidiacuda
   _insert_type("clplatform_nvidiacuda", "bool");
   _insert_default("clplatform_nvidiacuda", "true");
   _insert_shortdescription("clplatform_nvidiacuda", "Nvidia CUDA");
   _insert_longdescription("clplatform_nvidiacuda", "Nvidia CUDA based OpenCL (vendor provided)");

   // clplatform_amdacceleratedparallelprocessing
   _insert_type("clplatform_amdacceleratedparallelprocessing", "bool");
   _insert_default("clplatform_amdacceleratedparallelprocessing", "true");
   _insert_shortdescription("clplatform_amdacceleratedparallelprocessing", "AMD ROCm");
   _insert_longdescription("clplatform_amdacceleratedparallelprocessing", "AMD Accelerated Parallel Processing (vendor provided)");

   // clplatform_rusticl
   _insert_type("clplatform_rusticl", "bool");
   _insert_default("clplatform_rusticl", "false");
   _insert_shortdescription("clplatform_rusticl", "RustiCL");
   _insert_longdescription("clplatform_rusticl", "RustiCL Mesa OpenCL, still unstable. if you want to use this, you should disable the vendor driver");

   // clplatform_apple
   _insert_type("clplatform_apple", "bool");
   _insert_default("clplatform_apple", "false");
   _insert_shortdescription("clplatform_apple", "Apple");
   _insert_longdescription("clplatform_apple", "Apple OpenCL (vendor provided)");

   // clplatform_openclon12
   _insert_type("clplatform_openclon12", "bool");
   _insert_default("clplatform_openclon12", "false");
   _insert_shortdescription("clplatform_openclon12", "Microsoft OpenCLOn12");
   _insert_longdescription("clplatform_openclon12", "Microsoft OpenCLOn12, only use this if the vendor provided driver does not work or there is none provided.");

   // clplatform_other
   _insert_type("clplatform_other", "bool");
   _insert_default("clplatform_other", "false");
   _insert_shortdescription("clplatform_other", "other platforms");
   _insert_longdescription("clplatform_other", "if set, all unspecified platforms are accepted. only do this if no vendor driver is available");

   // opencl_library
   _insert_type("opencl_library", "string");
   _insert_default("opencl_library", "");
   _insert_shortdescription("opencl_library", "system library with OpenCL runtime");
   _insert_longdescription("opencl_library", "OpenCL runtime library is normally detected automatically by darktable. if your OpenCL runtime is at an unusual place and cannot be detected, enter the full pathname here. leave empty for default behavior.");

   // ask_before_remove
   _insert_type("ask_before_remove", "bool");
   _insert_default("ask_before_remove", "true");
   _insert_shortdescription("ask_before_remove", "ask before removing images from the library");
   _insert_longdescription("ask_before_remove", "always ask the user before removing image information from the library");

   // ask_before_delete
   _insert_type("ask_before_delete", "bool");
   _insert_default("ask_before_delete", "true");
   _insert_shortdescription("ask_before_delete", "ask before deleting images from disk");
   _insert_longdescription("ask_before_delete", "always ask the user before any image file is deleted");

   // ask_before_discard
   _insert_type("ask_before_discard", "bool");
   _insert_default("ask_before_discard", "true");
   _insert_shortdescription("ask_before_discard", "ask before discarding history stack");
   _insert_longdescription("ask_before_discard", "always ask the user before history stack is discarded on any image");

   // send_to_trash
   _insert_type("send_to_trash", "bool");
   _insert_default("send_to_trash", "true");
   _insert_shortdescription("send_to_trash", "try to use trash when deleting images");
   _insert_longdescription("send_to_trash", "send files to trash instead of permanently deleting files on system that supports it");

   // ask_before_move
   _insert_type("ask_before_move", "bool");
   _insert_default("ask_before_move", "true");
   _insert_shortdescription("ask_before_move", "ask before moving images from film roll folder");
   _insert_longdescription("ask_before_move", "always ask the user before any image file is moved.");

   // ask_before_copy
   _insert_type("ask_before_copy", "bool");
   _insert_default("ask_before_copy", "true");
   _insert_shortdescription("ask_before_copy", "ask before copying images to new film roll folder");
   _insert_longdescription("ask_before_copy", "always ask the user before any image file is copied.");

   // ask_before_rmdir
   _insert_type("ask_before_rmdir", "bool");
   _insert_default("ask_before_rmdir", "false");
   _insert_shortdescription("ask_before_rmdir", "ask before removing empty folders");
   _insert_longdescription("ask_before_rmdir", "always ask the user before removing any empty folder. this can happen after moving or deleting images.");

   // plugins/lighttable/recentcollect/max_items
   _insert_type("plugins/lighttable/recentcollect/max_items", "int");
   _insert_default("plugins/lighttable/recentcollect/max_items", "10");
   _insert_min("plugins/lighttable/recentcollect/max_items", "1");
   _insert_max("plugins/lighttable/recentcollect/max_items", "50");
   _insert_shortdescription("plugins/lighttable/recentcollect/max_items", "number of collections to be stored");
   _insert_longdescription("plugins/lighttable/recentcollect/max_items", "the number of recent collections to store and show in this list");

   // plugins/lighttable/recentcollect/hide
   _insert_type("plugins/lighttable/recentcollect/hide", "bool");
   _insert_default("plugins/lighttable/recentcollect/hide", "true");
   _insert_shortdescription("plugins/lighttable/recentcollect/hide", "prefer a history button in the collections module");
   _insert_longdescription("plugins/lighttable/recentcollect/hide", "hide this module and instead access collections history with a button in the collections module");

   // plugins/lighttable/collect/history_max
   _insert_type("plugins/lighttable/collect/history_max", "int");
   _insert_default("plugins/lighttable/collect/history_max", "10");
   _insert_min("plugins/lighttable/collect/history_max", "1");
   _insert_max("plugins/lighttable/collect/history_max", "50");
   _insert_shortdescription("plugins/lighttable/collect/history_max", "number of collections to be stored");
   _insert_longdescription("plugins/lighttable/collect/history_max", "the number of recent collections to store and show in this list");

   // plugins/lighttable/collect/history_hide
   _insert_type("plugins/lighttable/collect/history_hide", "bool");
   _insert_default("plugins/lighttable/collect/history_hide", "false");
   _insert_shortdescription("plugins/lighttable/collect/history_hide", "hide the history button and show a specific module instead");
   _insert_longdescription("plugins/lighttable/collect/history_hide", "hide the history button and show the recent collections module instead");

   // plugins/lighttable/filtering/history_max
   _insert_type("plugins/lighttable/filtering/history_max", "int");
   _insert_default("plugins/lighttable/filtering/history_max", "10");
   _insert_min("plugins/lighttable/filtering/history_max", "1");
   _insert_max("plugins/lighttable/filtering/history_max", "50");
   _insert_shortdescription("plugins/lighttable/filtering/history_max", "number of filters to be stored");
   _insert_longdescription("plugins/lighttable/filtering/history_max", "the number of recent filters to store and show in history list");

   // plugins/lighttable/filtering/sort_history_max
   _insert_type("plugins/lighttable/filtering/sort_history_max", "int");
   _insert_default("plugins/lighttable/filtering/sort_history_max", "10");
   _insert_min("plugins/lighttable/filtering/sort_history_max", "1");
   _insert_max("plugins/lighttable/filtering/sort_history_max", "50");
   _insert_shortdescription("plugins/lighttable/filtering/sort_history_max", "number of sort orders to be stored");
   _insert_longdescription("plugins/lighttable/filtering/sort_history_max", "the number of recent sort orders to store and show in history list");

   // plugins/lighttable/filtering/num_sort
   _insert_type("plugins/lighttable/filtering/num_sort", "int");
   _insert_default("plugins/lighttable/filtering/num_sort", "1");
   _insert_shortdescription("plugins/lighttable/filtering/num_sort", "nb of sort orders by default");
   _insert_longdescription("plugins/lighttable/filtering/num_sort", "");

   // plugins/lighttable/filtering/sort0
   _insert_type("plugins/lighttable/filtering/sort0", "int");
   _insert_default("plugins/lighttable/filtering/sort0", "0");
   _insert_shortdescription("plugins/lighttable/filtering/sort0", "first sort orders");
   _insert_longdescription("plugins/lighttable/filtering/sort0", "");

   // plugins/lighttable/filtering/num_rules
   _insert_type("plugins/lighttable/filtering/num_rules", "int");
   _insert_default("plugins/lighttable/filtering/num_rules", "3");
   _insert_shortdescription("plugins/lighttable/filtering/num_rules", "nb of rules by default");
   _insert_longdescription("plugins/lighttable/filtering/num_rules", "");

   // plugins/lighttable/filtering/item0
   _insert_type("plugins/lighttable/filtering/item0", "int");
   _insert_default("plugins/lighttable/filtering/item0", "32");
   _insert_shortdescription("plugins/lighttable/filtering/item0", "first filter");
   _insert_longdescription("plugins/lighttable/filtering/item0", "");

   // plugins/lighttable/filtering/mode0
   _insert_type("plugins/lighttable/filtering/mode0", "int");
   _insert_default("plugins/lighttable/filtering/mode0", "0");
   _insert_shortdescription("plugins/lighttable/filtering/mode0", "first filter");
   _insert_longdescription("plugins/lighttable/filtering/mode0", "");

   // plugins/lighttable/filtering/off0
   _insert_type("plugins/lighttable/filtering/off0", "int");
   _insert_default("plugins/lighttable/filtering/off0", "0");
   _insert_shortdescription("plugins/lighttable/filtering/off0", "first filter");
   _insert_longdescription("plugins/lighttable/filtering/off0", "");

   // plugins/lighttable/filtering/top0
   _insert_type("plugins/lighttable/filtering/top0", "int");
   _insert_default("plugins/lighttable/filtering/top0", "1");
   _insert_shortdescription("plugins/lighttable/filtering/top0", "first filter");
   _insert_longdescription("plugins/lighttable/filtering/top0", "");

   // plugins/lighttable/filtering/string0
   _insert_type("plugins/lighttable/filtering/string0", "string");
   _insert_default("plugins/lighttable/filtering/string0", "%");
   _insert_shortdescription("plugins/lighttable/filtering/string0", "first filter");
   _insert_longdescription("plugins/lighttable/filtering/string0", "");

   // plugins/lighttable/filtering/item1
   _insert_type("plugins/lighttable/filtering/item1", "int");
   _insert_default("plugins/lighttable/filtering/item1", "18");
   _insert_shortdescription("plugins/lighttable/filtering/item1", "second filter");
   _insert_longdescription("plugins/lighttable/filtering/item1", "");

   // plugins/lighttable/filtering/mode1
   _insert_type("plugins/lighttable/filtering/mode1", "int");
   _insert_default("plugins/lighttable/filtering/mode1", "0");
   _insert_shortdescription("plugins/lighttable/filtering/mode1", "second filter");
   _insert_longdescription("plugins/lighttable/filtering/mode1", "");

   // plugins/lighttable/filtering/off1
   _insert_type("plugins/lighttable/filtering/off1", "int");
   _insert_default("plugins/lighttable/filtering/off1", "0");
   _insert_shortdescription("plugins/lighttable/filtering/off1", "second filter");
   _insert_longdescription("plugins/lighttable/filtering/off1", "");

   // plugins/lighttable/filtering/top1
   _insert_type("plugins/lighttable/filtering/top1", "int");
   _insert_default("plugins/lighttable/filtering/top1", "1");
   _insert_shortdescription("plugins/lighttable/filtering/top1", "second filter");
   _insert_longdescription("plugins/lighttable/filtering/top1", "");

   // plugins/lighttable/filtering/string1
   _insert_type("plugins/lighttable/filtering/string1", "string");
   _insert_default("plugins/lighttable/filtering/string1", "");
   _insert_shortdescription("plugins/lighttable/filtering/string1", "second filter");
   _insert_longdescription("plugins/lighttable/filtering/string1", "");

   // plugins/lighttable/filtering/item2
   _insert_type("plugins/lighttable/filtering/item2", "int");
   _insert_default("plugins/lighttable/filtering/item2", "33");
   _insert_shortdescription("plugins/lighttable/filtering/item2", "third filter");
   _insert_longdescription("plugins/lighttable/filtering/item2", "");

   // plugins/lighttable/filtering/mode2
   _insert_type("plugins/lighttable/filtering/mode2", "int");
   _insert_default("plugins/lighttable/filtering/mode2", "0");
   _insert_shortdescription("plugins/lighttable/filtering/mode2", "third filter");
   _insert_longdescription("plugins/lighttable/filtering/mode2", "");

   // plugins/lighttable/filtering/off2
   _insert_type("plugins/lighttable/filtering/off2", "int");
   _insert_default("plugins/lighttable/filtering/off2", "0");
   _insert_shortdescription("plugins/lighttable/filtering/off2", "third filter");
   _insert_longdescription("plugins/lighttable/filtering/off2", "");

   // plugins/lighttable/filtering/top2
   _insert_type("plugins/lighttable/filtering/top2", "int");
   _insert_default("plugins/lighttable/filtering/top2", "1");
   _insert_shortdescription("plugins/lighttable/filtering/top2", "third filter");
   _insert_longdescription("plugins/lighttable/filtering/top2", "");

   // plugins/lighttable/filtering/string2
   _insert_type("plugins/lighttable/filtering/string2", "string");
   _insert_default("plugins/lighttable/filtering/string2", "%%");
   _insert_shortdescription("plugins/lighttable/filtering/string2", "third filter");
   _insert_longdescription("plugins/lighttable/filtering/string2", "");

   // show_folder_levels
   _insert_type("show_folder_levels", "int");
   _insert_default("show_folder_levels", "1");
   _insert_min("show_folder_levels", "1");
   _insert_max("show_folder_levels", "5");
   _insert_shortdescription("show_folder_levels", "number of folder levels to show in lists");
   _insert_longdescription("show_folder_levels", "the number of folder levels to show in film roll names, starting from the right");

   // plugins/collection/film_id
   _insert_type("plugins/collection/film_id", "int");
   _insert_default("plugins/collection/film_id", "1");
   _insert_shortdescription("plugins/collection/film_id", "");
   _insert_longdescription("plugins/collection/film_id", "");

   // plugins/collection/rating
   _insert_type("plugins/collection/rating", "int");
   _insert_default("plugins/collection/rating", "1");
   _insert_shortdescription("plugins/collection/rating", "");
   _insert_longdescription("plugins/collection/rating", "");

   // plugins/collection/rating_comparator
   _insert_type("plugins/collection/rating_comparator", "int");
   _insert_default("plugins/collection/rating_comparator", "3");
   _insert_shortdescription("plugins/collection/rating_comparator", "");
   _insert_longdescription("plugins/collection/rating_comparator", "");

   // plugins/collection/query_flags
   _insert_type("plugins/collection/query_flags", "int");
   _insert_default("plugins/collection/query_flags", "3");
   _insert_shortdescription("plugins/collection/query_flags", "");
   _insert_longdescription("plugins/collection/query_flags", "");

   // plugins/collection/filter_flags
   _insert_type("plugins/collection/filter_flags", "int");
   _insert_default("plugins/collection/filter_flags", "3");
   _insert_shortdescription("plugins/collection/filter_flags", "");
   _insert_longdescription("plugins/collection/filter_flags", "");

   // plugins/collection/colors_filter
   _insert_type("plugins/collection/colors_filter", "string");
   _insert_default("plugins/collection/colors_filter", "80000000");
   _insert_shortdescription("plugins/collection/colors_filter", "");
   _insert_longdescription("plugins/collection/colors_filter", "");

   // plugins/collection/text_filter
   _insert_type("plugins/collection/text_filter", "string");
   _insert_default("plugins/collection/text_filter", "");
   _insert_shortdescription("plugins/collection/text_filter", "");
   _insert_longdescription("plugins/collection/text_filter", "");

   // plugins/collection/descending
   _insert_type("plugins/collection/descending", "bool");
   _insert_default("plugins/collection/descending", "false");
   _insert_shortdescription("plugins/collection/descending", "");
   _insert_longdescription("plugins/collection/descending", "");

   // plugins/collection/sort
   _insert_type("plugins/collection/sort", "int");
   _insert_default("plugins/collection/sort", "0");
   _insert_shortdescription("plugins/collection/sort", "");
   _insert_longdescription("plugins/collection/sort", "");

   // plugins/session/jobcode
   _insert_type("plugins/session/jobcode", "string");
   _insert_default("plugins/session/jobcode", "capture job");
   _insert_shortdescription("plugins/session/jobcode", "name of capture job");
   _insert_longdescription("plugins/session/jobcode", "");

   // plugins/capture/storage/basedirectory
   _insert_type("plugins/capture/storage/basedirectory", "string");
   _insert_default("plugins/capture/storage/basedirectory", "$(PICTURES_FOLDER)/darktable");
   _insert_shortdescription("plugins/capture/storage/basedirectory", "path of storage for captured images");
   _insert_longdescription("plugins/capture/storage/basedirectory", "");

   // plugins/capture/storage/subpath
   _insert_type("plugins/capture/storage/subpath", "string");
   _insert_default("plugins/capture/storage/subpath", "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
   _insert_shortdescription("plugins/capture/storage/subpath", "subpath pattern in storage for captured images");
   _insert_longdescription("plugins/capture/storage/subpath", "");

   // plugins/capture/storage/namepattern
   _insert_type("plugins/capture/storage/namepattern", "string");
   _insert_default("plugins/capture/storage/namepattern", "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
   _insert_shortdescription("plugins/capture/storage/namepattern", "rename pattern for captured images");
   _insert_longdescription("plugins/capture/storage/namepattern", "");

   // plugins/capture/camera/live_view_fps
   _insert_type("plugins/capture/camera/live_view_fps", "int");
   _insert_default("plugins/capture/camera/live_view_fps", "15");
   _insert_shortdescription("plugins/capture/camera/live_view_fps", "maximum fps of live view update in tethering view");
   _insert_longdescription("plugins/capture/camera/live_view_fps", "going too fast will result in too many redraws without a real benefit");

   // plugins/collect/filmroll_sort
   _insert_type("plugins/collect/filmroll_sort", "enum");
   _insert_values("plugins/collect/filmroll_sort", "[import time][folder name]");
   WRAP_TRANSLATION(C_("preferences", "import time"));
   WRAP_TRANSLATION(C_("preferences", "folder name"));
   _insert_default("plugins/collect/filmroll_sort", "import time");
   _insert_shortdescription("plugins/collect/filmroll_sort", "sort film rolls by");
   _insert_longdescription("plugins/collect/filmroll_sort", "sets the collections-list order for film rolls");

   // plugins/collect/descending
   _insert_type("plugins/collect/descending", "bool");
   _insert_default("plugins/collect/descending", "true");
   _insert_shortdescription("plugins/collect/descending", "sort collection descending");
   _insert_longdescription("plugins/collect/descending", "sort the following collections in descending order: 'film roll' by folder, 'folder', 'times' (e.g. 'capture date')");

   // ui_last/colorpicker_model
   _insert_type("ui_last/colorpicker_model", "enum");
   _insert_values("ui_last/colorpicker_model", "[RGB][Lab][LCh][HSL][Hex][none]");
   WRAP_TRANSLATION(C_("preferences", "RGB"));
   WRAP_TRANSLATION(C_("preferences", "Lab"));
   WRAP_TRANSLATION(C_("preferences", "LCh"));
   WRAP_TRANSLATION(C_("preferences", "HSL"));
   WRAP_TRANSLATION(C_("preferences", "Hex"));
   WRAP_TRANSLATION(C_("preferences", "none"));
   _insert_default("ui_last/colorpicker_model", "RGB");
   _insert_shortdescription("ui_last/colorpicker_model", "color model with which to represent primary colorpicker");
   _insert_longdescription("ui_last/colorpicker_model", "");

   // ui_last/colorpicker_mode
   _insert_type("ui_last/colorpicker_mode", "enum");
   _insert_values("ui_last/colorpicker_mode", "[mean][min][max]");
   WRAP_TRANSLATION(C_("preferences", "mean"));
   WRAP_TRANSLATION(C_("preferences", "min"));
   WRAP_TRANSLATION(C_("preferences", "max"));
   _insert_default("ui_last/colorpicker_mode", "mean");
   _insert_shortdescription("ui_last/colorpicker_mode", "statistic used to describe colorpicker box");
   _insert_longdescription("ui_last/colorpicker_mode", "");

   // ui_last/colorpicker_display_samples
   _insert_type("ui_last/colorpicker_display_samples", "boolean");
   _insert_default("ui_last/colorpicker_display_samples", "false");
   _insert_shortdescription("ui_last/colorpicker_display_samples", "display live sample areas on image");
   _insert_longdescription("ui_last/colorpicker_display_samples", "");

   // ui_last/colorpicker_restrict_histogram
   _insert_type("ui_last/colorpicker_restrict_histogram", "boolean");
   _insert_default("ui_last/colorpicker_restrict_histogram", "false");
   _insert_shortdescription("ui_last/colorpicker_restrict_histogram", "restrict histogram to selection");
   _insert_longdescription("ui_last/colorpicker_restrict_histogram", "");

   // ui_last/colorpicker_large
   _insert_type("ui_last/colorpicker_large", "boolean");
   _insert_default("ui_last/colorpicker_large", "false");
   _insert_shortdescription("ui_last/colorpicker_large", "display large colorpicker patch");
   _insert_longdescription("ui_last/colorpicker_large", "");

   // ui_last/fullscreen
   _insert_type("ui_last/fullscreen", "bool");
   _insert_default("ui_last/fullscreen", "false");
   _insert_shortdescription("ui_last/fullscreen", "");
   _insert_longdescription("ui_last/fullscreen", "");

   // ui_last/maximized
   _insert_type("ui_last/maximized", "bool");
   _insert_default("ui_last/maximized", "true");
   _insert_shortdescription("ui_last/maximized", "");
   _insert_longdescription("ui_last/maximized", "");

   // ui_last/grouping
   _insert_type("ui_last/grouping", "bool");
   _insert_default("ui_last/grouping", "false");
   _insert_shortdescription("ui_last/grouping", "grouping of images");
   _insert_longdescription("ui_last/grouping", "only show a single image for each set of grouped images in lighttable and filmstrip");

   // ui_last/view
   _insert_type("ui_last/view", "int");
   _insert_default("ui_last/view", "0");
   _insert_shortdescription("ui_last/view", "");
   _insert_longdescription("ui_last/view", "");

   // ui_last/window_x
   _insert_type("ui_last/window_x", "int");
   _insert_default("ui_last/window_x", "0");
   _insert_shortdescription("ui_last/window_x", "");
   _insert_longdescription("ui_last/window_x", "");

   // ui_last/window_y
   _insert_type("ui_last/window_y", "int");
   _insert_default("ui_last/window_y", "0");
   _insert_shortdescription("ui_last/window_y", "");
   _insert_longdescription("ui_last/window_y", "");

   // ui_last/window_w
   _insert_type("ui_last/window_w", "int");
   _insert_default("ui_last/window_w", "900");
   _insert_shortdescription("ui_last/window_w", "");
   _insert_longdescription("ui_last/window_w", "");

   // ui_last/window_h
   _insert_type("ui_last/window_h", "int");
   _insert_default("ui_last/window_h", "500");
   _insert_shortdescription("ui_last/window_h", "");
   _insert_longdescription("ui_last/window_h", "");

   // ui_last/panel_left
   _insert_type("ui_last/panel_left", "int");
   _insert_default("ui_last/panel_left", "-1");
   _insert_shortdescription("ui_last/panel_left", "");
   _insert_longdescription("ui_last/panel_left", "");

   // ui_last/panel_right
   _insert_type("ui_last/panel_right", "int");
   _insert_default("ui_last/panel_right", "-1");
   _insert_shortdescription("ui_last/panel_right", "");
   _insert_longdescription("ui_last/panel_right", "");

   // ui_last/panel_top
   _insert_type("ui_last/panel_top", "int");
   _insert_default("ui_last/panel_top", "0");
   _insert_shortdescription("ui_last/panel_top", "");
   _insert_longdescription("ui_last/panel_top", "");

   // ui_last/panel_bottom
   _insert_type("ui_last/panel_bottom", "int");
   _insert_default("ui_last/panel_bottom", "0");
   _insert_shortdescription("ui_last/panel_bottom", "");
   _insert_longdescription("ui_last/panel_bottom", "");

   // ui_last/expander_import
   _insert_type("ui_last/expander_import", "bool");
   _insert_default("ui_last/expander_import", "false");
   _insert_shortdescription("ui_last/expander_import", "");
   _insert_longdescription("ui_last/expander_import", "");

   // ui_last/import_dialog_paned_pos
   _insert_type("ui_last/import_dialog_paned_pos", "int");
   _insert_default("ui_last/import_dialog_paned_pos", "0");
   _insert_shortdescription("ui_last/import_dialog_paned_pos", "");
   _insert_longdescription("ui_last/import_dialog_paned_pos", "");

   // ui_last/import_dialog_paned_places_pos
   _insert_type("ui_last/import_dialog_paned_places_pos", "int");
   _insert_default("ui_last/import_dialog_paned_places_pos", "150");
   _insert_shortdescription("ui_last/import_dialog_paned_places_pos", "");
   _insert_longdescription("ui_last/import_dialog_paned_places_pos", "");

   // ui_last/import_dialog_show_home
   _insert_type("ui_last/import_dialog_show_home", "bool");
   _insert_default("ui_last/import_dialog_show_home", "true");
   _insert_shortdescription("ui_last/import_dialog_show_home", "");
   _insert_longdescription("ui_last/import_dialog_show_home", "");

   // ui_last/import_dialog_show_pictures
   _insert_type("ui_last/import_dialog_show_pictures", "bool");
   _insert_default("ui_last/import_dialog_show_pictures", "true");
   _insert_shortdescription("ui_last/import_dialog_show_pictures", "");
   _insert_longdescription("ui_last/import_dialog_show_pictures", "");

   // ui_last/import_dialog_show_mounted
   _insert_type("ui_last/import_dialog_show_mounted", "bool");
   _insert_default("ui_last/import_dialog_show_mounted", "true");
   _insert_shortdescription("ui_last/import_dialog_show_mounted", "");
   _insert_longdescription("ui_last/import_dialog_show_mounted", "");

   // ui_last/import_dialog_width
   _insert_type("ui_last/import_dialog_width", "int");
   _insert_default("ui_last/import_dialog_width", "800");
   _insert_shortdescription("ui_last/import_dialog_width", "");
   _insert_longdescription("ui_last/import_dialog_width", "");

   // ui_last/import_dialog_height
   _insert_type("ui_last/import_dialog_height", "int");
   _insert_default("ui_last/import_dialog_height", "600");
   _insert_shortdescription("ui_last/import_dialog_height", "");
   _insert_longdescription("ui_last/import_dialog_height", "");

   // ui_last/shortcuts_dialog_width
   _insert_type("ui_last/shortcuts_dialog_width", "int");
   _insert_default("ui_last/shortcuts_dialog_width", "1100");
   _insert_shortdescription("ui_last/shortcuts_dialog_width", "");
   _insert_longdescription("ui_last/shortcuts_dialog_width", "");

   // ui_last/shortcuts_dialog_height
   _insert_type("ui_last/shortcuts_dialog_height", "int");
   _insert_default("ui_last/shortcuts_dialog_height", "700");
   _insert_shortdescription("ui_last/shortcuts_dialog_height", "");
   _insert_longdescription("ui_last/shortcuts_dialog_height", "");

   // ui_last/preferences_dialog_width
   _insert_type("ui_last/preferences_dialog_width", "int");
   _insert_default("ui_last/preferences_dialog_width", "1100");
   _insert_shortdescription("ui_last/preferences_dialog_width", "");
   _insert_longdescription("ui_last/preferences_dialog_width", "");

   // ui_last/preferences_dialog_height
   _insert_type("ui_last/preferences_dialog_height", "int");
   _insert_default("ui_last/preferences_dialog_height", "700");
   _insert_shortdescription("ui_last/preferences_dialog_height", "");
   _insert_longdescription("ui_last/preferences_dialog_height", "");

   // ui_last/modulegroups_dialog_width
   _insert_type("ui_last/modulegroups_dialog_width", "int");
   _insert_default("ui_last/modulegroups_dialog_width", "1100");
   _insert_shortdescription("ui_last/modulegroups_dialog_width", "");
   _insert_longdescription("ui_last/modulegroups_dialog_width", "");

   // ui_last/modulegroups_dialog_height
   _insert_type("ui_last/modulegroups_dialog_height", "int");
   _insert_default("ui_last/modulegroups_dialog_height", "700");
   _insert_shortdescription("ui_last/modulegroups_dialog_height", "");
   _insert_longdescription("ui_last/modulegroups_dialog_height", "");

   // ui_last/session_expander_import
   _insert_type("ui_last/session_expander_import", "bool");
   _insert_default("ui_last/session_expander_import", "false");
   _insert_shortdescription("ui_last/session_expander_import", "");
   _insert_longdescription("ui_last/session_expander_import", "");

   // ui_last/import_select_new
   _insert_type("ui_last/import_select_new", "bool");
   _insert_default("ui_last/import_select_new", "true");
   _insert_shortdescription("ui_last/import_select_new", N_("select only new pictures"));
   _insert_longdescription("ui_last/import_select_new", N_("only select images that have not already been imported"));

   // ui_last/import_ignore_nonraws
   _insert_type("ui_last/import_ignore_nonraws", "bool");
   _insert_default("ui_last/import_ignore_nonraws", "false");
   _insert_shortdescription("ui_last/import_ignore_nonraws", N_("ignore non-raw images"));
   _insert_longdescription("ui_last/import_ignore_nonraws", N_("if enabled, only raw files will be allowed to import. non-raw files will not be visible in the dialog and will not be imported."));

   // ui_last/import_apply_metadata
   _insert_type("ui_last/import_apply_metadata", "bool");
   _insert_default("ui_last/import_apply_metadata", "false");
   _insert_shortdescription("ui_last/import_apply_metadata", N_("apply metadata"));
   _insert_longdescription("ui_last/import_apply_metadata", N_("apply some metadata to all newly imported images."));

   // ui_last/import_recursive
   _insert_type("ui_last/import_recursive", "bool");
   _insert_default("ui_last/import_recursive", "false");
   _insert_shortdescription("ui_last/import_recursive", N_("recursive directory"));
   _insert_longdescription("ui_last/import_recursive", N_("recursive directory traversal when importing filmrolls"));

   // ui_last/import_last_creator
   _insert_type("ui_last/import_last_creator", "string");
   _insert_default("ui_last/import_last_creator", "");
   _insert_shortdescription("ui_last/import_last_creator", N_("creator to be applied when importing"));
   _insert_longdescription("ui_last/import_last_creator", "");

   // ui_last/import_last_publisher
   _insert_type("ui_last/import_last_publisher", "string");
   _insert_default("ui_last/import_last_publisher", "");
   _insert_shortdescription("ui_last/import_last_publisher", N_("publisher to be applied when importing"));
   _insert_longdescription("ui_last/import_last_publisher", "");

   // ui_last/import_last_rights
   _insert_type("ui_last/import_last_rights", "string");
   _insert_default("ui_last/import_last_rights", "");
   _insert_shortdescription("ui_last/import_last_rights", N_("rights to be applied when importing"));
   _insert_longdescription("ui_last/import_last_rights", "");

   // ui_last/import_last_tags
   _insert_type("ui_last/import_last_tags", "string");
   _insert_default("ui_last/import_last_tags", "");
   _insert_shortdescription("ui_last/import_last_tags", N_("comma separated tags to be applied when importing"));
   _insert_longdescription("ui_last/import_last_tags", "");

   // ui_last/import_last_tags_imported
   _insert_type("ui_last/import_last_tags_imported", "bool");
   _insert_default("ui_last/import_last_tags_imported", "true");
   _insert_shortdescription("ui_last/import_last_tags_imported", N_("import tags from XMP"));
   _insert_longdescription("ui_last/import_last_tags_imported", "");

   // ui_last/import_last_directory
   _insert_type("ui_last/import_last_directory", "dir");
   {
      gchar *default_path = dt_conf_expand_default_dir("$(home)");
      _insert_default("ui_last/import_last_directory", default_path);
      g_free(default_path);
   }
   _insert_shortdescription("ui_last/import_last_directory", "last opened directory.");
   _insert_longdescription("ui_last/import_last_directory", "");

   // ui_last/import_last_root
   _insert_type("ui_last/import_last_root", "string");
   _insert_default("ui_last/import_last_root", "");
   _insert_shortdescription("ui_last/import_last_root", "last root folder");
   _insert_longdescription("ui_last/import_last_root", "");

   // ui_last/import_last_folder_descending
   _insert_type("ui_last/import_last_folder_descending", "bool");
   _insert_default("ui_last/import_last_folder_descending", "false");
   _insert_shortdescription("ui_last/import_last_folder_descending", "folders display order in folder pane");
   _insert_longdescription("ui_last/import_last_folder_descending", "");

   // ui_last/import_initial_rating
   _insert_type("ui_last/import_initial_rating", "int");
   _insert_default("ui_last/import_initial_rating", "1");
   _insert_min("ui_last/import_initial_rating", "0");
   _insert_max("ui_last/import_initial_rating", "5");
   _insert_shortdescription("ui_last/import_initial_rating", N_("initial rating"));
   _insert_longdescription("ui_last/import_initial_rating", N_("initial star rating for all images when importing a filmroll"));

   // ui_last/ignore_exif_rating
   _insert_type("ui_last/ignore_exif_rating", "bool");
   _insert_default("ui_last/ignore_exif_rating", "false");
   _insert_shortdescription("ui_last/ignore_exif_rating", N_("ignore EXIF rating"));
   _insert_longdescription("ui_last/ignore_exif_rating", N_("ignore EXIF rating. if not set and EXIF rating is found, it overrides 'initial rating'"));

   // ui_last/import_jobcode
   _insert_type("ui_last/import_jobcode", "string");
   _insert_default("ui_last/import_jobcode", "no_name");
   _insert_shortdescription("ui_last/import_jobcode", N_("import job"));
   _insert_longdescription("ui_last/import_jobcode", N_("name of the import job"));

   // ui_last/import_datetime_override
   _insert_type("ui_last/import_datetime_override", "string");
   _insert_default("ui_last/import_datetime_override", "");
   _insert_shortdescription("ui_last/import_datetime_override", N_("override today's date"));
   _insert_longdescription("ui_last/import_datetime_override", N_("type a date in the form: YYYY:MM:DD[ hh:mm:ss[.sss]] if you want to override the current date/time used when expanding variables:\n$(YEAR), $(MONTH), $(DAY), $(HOUR), $(MINUTE), $(SECONDS), $(MSEC).\nlet the field empty otherwise"));

   // ui_last/import_keep_open
   _insert_type("ui_last/import_keep_open", "bool");
   _insert_default("ui_last/import_keep_open", "false");
   _insert_shortdescription("ui_last/import_keep_open", N_("keep this window open"));
   _insert_longdescription("ui_last/import_keep_open", N_("keep this window open to run several imports"));

   // plugins/capture/mode
   _insert_type("plugins/capture/mode", "int");
   _insert_default("plugins/capture/mode", "0");
   _insert_shortdescription("plugins/capture/mode", "capture view mode");
   _insert_longdescription("plugins/capture/mode", "");

   // plugins/lighttable/overlay_timeout
   _insert_type("plugins/lighttable/overlay_timeout", "int");
   _insert_default("plugins/lighttable/overlay_timeout", "3");
   _insert_shortdescription("plugins/lighttable/overlay_timeout", "timeout for overlay hover block in seconds");
   _insert_longdescription("plugins/lighttable/overlay_timeout", "");

   // plugins/lighttable/overlays/0/0
   _insert_type("plugins/lighttable/overlays/0/0", "int");
   _insert_default("plugins/lighttable/overlays/0/0", "0");
   _insert_shortdescription("plugins/lighttable/overlays/0/0", "overlays for filemanager at size 0 = none");
   _insert_longdescription("plugins/lighttable/overlays/0/0", "");

   // plugins/lighttable/overlays/0/1
   _insert_type("plugins/lighttable/overlays/0/1", "int");
   _insert_default("plugins/lighttable/overlays/0/1", "1");
   _insert_shortdescription("plugins/lighttable/overlays/0/1", "overlays for filemanager at size 1 = on hover");
   _insert_longdescription("plugins/lighttable/overlays/0/1", "");

   // plugins/lighttable/overlays/0/2
   _insert_type("plugins/lighttable/overlays/0/2", "int");
   _insert_default("plugins/lighttable/overlays/0/2", "4");
   _insert_shortdescription("plugins/lighttable/overlays/0/2", "overlays for filemanager at size 2 = always extended");
   _insert_longdescription("plugins/lighttable/overlays/0/2", "");

   // plugins/lighttable/overlays/1/0
   _insert_type("plugins/lighttable/overlays/1/0", "int");
   _insert_default("plugins/lighttable/overlays/1/0", "0");
   _insert_shortdescription("plugins/lighttable/overlays/1/0", "overlays for filmstrip at size 0 = none");
   _insert_longdescription("plugins/lighttable/overlays/1/0", "");

   // plugins/lighttable/overlays/1/1
   _insert_type("plugins/lighttable/overlays/1/1", "int");
   _insert_default("plugins/lighttable/overlays/1/1", "1");
   _insert_shortdescription("plugins/lighttable/overlays/1/1", "overlays for filmstrip at size 1 = on hover");
   _insert_longdescription("plugins/lighttable/overlays/1/1", "");

   // plugins/lighttable/overlays/1/2
   _insert_type("plugins/lighttable/overlays/1/2", "int");
   _insert_default("plugins/lighttable/overlays/1/2", "1");
   _insert_shortdescription("plugins/lighttable/overlays/1/2", "overlays for filmstrip at size 2 = on hover");
   _insert_longdescription("plugins/lighttable/overlays/1/2", "");

   // plugins/lighttable/overlays/2/0
   _insert_type("plugins/lighttable/overlays/2/0", "int");
   _insert_default("plugins/lighttable/overlays/2/0", "0");
   _insert_shortdescription("plugins/lighttable/overlays/2/0", "overlays for zomable lighttable at size 0 = none");
   _insert_longdescription("plugins/lighttable/overlays/2/0", "");

   // plugins/lighttable/overlays/2/1
   _insert_type("plugins/lighttable/overlays/2/1", "int");
   _insert_default("plugins/lighttable/overlays/2/1", "1");
   _insert_shortdescription("plugins/lighttable/overlays/2/1", "overlays for zomable lighttable at size 1 = on hover");
   _insert_longdescription("plugins/lighttable/overlays/2/1", "");

   // plugins/lighttable/overlays/2/2
   _insert_type("plugins/lighttable/overlays/2/2", "int");
   _insert_default("plugins/lighttable/overlays/2/2", "4");
   _insert_shortdescription("plugins/lighttable/overlays/2/2", "overlays for zomable lighttable at size 2 = always extended");
   _insert_longdescription("plugins/lighttable/overlays/2/2", "");

   // plugins/lighttable/overlays/culling/0
   _insert_type("plugins/lighttable/overlays/culling/0", "int");
   _insert_default("plugins/lighttable/overlays/culling/0", "6");
   _insert_shortdescription("plugins/lighttable/overlays/culling/0", "overlays for culling = block");
   _insert_longdescription("plugins/lighttable/overlays/culling/0", "");

   // plugins/lighttable/overlays/culling/1
   _insert_type("plugins/lighttable/overlays/culling/1", "int");
   _insert_default("plugins/lighttable/overlays/culling/1", "6");
   _insert_shortdescription("plugins/lighttable/overlays/culling/1", "overlays for full preview = block");
   _insert_longdescription("plugins/lighttable/overlays/culling/1", "");

   // plugins/lighttable/tooltips/0/0
   _insert_type("plugins/lighttable/tooltips/0/0", "bool");
   _insert_default("plugins/lighttable/tooltips/0/0", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/0/0", "tooltips for filemanager at size 0");
   _insert_longdescription("plugins/lighttable/tooltips/0/0", "");

   // plugins/lighttable/tooltips/0/1
   _insert_type("plugins/lighttable/tooltips/0/1", "bool");
   _insert_default("plugins/lighttable/tooltips/0/1", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/0/1", "tooltips for filemanager at size 1");
   _insert_longdescription("plugins/lighttable/tooltips/0/1", "");

   // plugins/lighttable/tooltips/0/2
   _insert_type("plugins/lighttable/tooltips/0/2", "bool");
   _insert_default("plugins/lighttable/tooltips/0/2", "false");
   _insert_shortdescription("plugins/lighttable/tooltips/0/2", "tooltips for filemanager at size 2");
   _insert_longdescription("plugins/lighttable/tooltips/0/2", "");

   // plugins/lighttable/tooltips/1/0
   _insert_type("plugins/lighttable/tooltips/1/0", "bool");
   _insert_default("plugins/lighttable/tooltips/1/0", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/1/0", "tooltips for filmstrip at size 0");
   _insert_longdescription("plugins/lighttable/tooltips/1/0", "");

   // plugins/lighttable/tooltips/1/1
   _insert_type("plugins/lighttable/tooltips/1/1", "bool");
   _insert_default("plugins/lighttable/tooltips/1/1", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/1/1", "tooltips for filmstrip at size 1");
   _insert_longdescription("plugins/lighttable/tooltips/1/1", "");

   // plugins/lighttable/tooltips/1/2
   _insert_type("plugins/lighttable/tooltips/1/2", "bool");
   _insert_default("plugins/lighttable/tooltips/1/2", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/1/2", "tooltips for filmstrip at size 2");
   _insert_longdescription("plugins/lighttable/tooltips/1/2", "");

   // plugins/lighttable/tooltips/2/0
   _insert_type("plugins/lighttable/tooltips/2/0", "bool");
   _insert_default("plugins/lighttable/tooltips/2/0", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/2/0", "tooltips for zomable lighttable at size 0");
   _insert_longdescription("plugins/lighttable/tooltips/2/0", "");

   // plugins/lighttable/tooltips/2/1
   _insert_type("plugins/lighttable/tooltips/2/1", "bool");
   _insert_default("plugins/lighttable/tooltips/2/1", "true");
   _insert_shortdescription("plugins/lighttable/tooltips/2/1", "tooltips for zomable lighttable at size 1");
   _insert_longdescription("plugins/lighttable/tooltips/2/1", "");

   // plugins/lighttable/tooltips/2/2
   _insert_type("plugins/lighttable/tooltips/2/2", "bool");
   _insert_default("plugins/lighttable/tooltips/2/2", "false");
   _insert_shortdescription("plugins/lighttable/tooltips/2/2", "tooltips for zomable lighttable at size 2");
   _insert_longdescription("plugins/lighttable/tooltips/2/2", "");

   // plugins/lighttable/tooltips/culling/0
   _insert_type("plugins/lighttable/tooltips/culling/0", "bool");
   _insert_default("plugins/lighttable/tooltips/culling/0", "false");
   _insert_shortdescription("plugins/lighttable/tooltips/culling/0", "tooltips for culling");
   _insert_longdescription("plugins/lighttable/tooltips/culling/0", "");

   // plugins/lighttable/tooltips/culling/1
   _insert_type("plugins/lighttable/tooltips/culling/1", "bool");
   _insert_default("plugins/lighttable/tooltips/culling/1", "false");
   _insert_shortdescription("plugins/lighttable/tooltips/culling/1", "tooltips for full preview");
   _insert_longdescription("plugins/lighttable/tooltips/culling/1", "");

   // plugins/lighttable/timeline/last_zoom
   _insert_type("plugins/lighttable/timeline/last_zoom", "int");
   _insert_default("plugins/lighttable/timeline/last_zoom", "0");
   _insert_shortdescription("plugins/lighttable/timeline/last_zoom", "last timeline zoom.");
   _insert_longdescription("plugins/lighttable/timeline/last_zoom", "");

   // plugins/lighttable/thumbnail_raw_min_level
   _insert_type("plugins/lighttable/thumbnail_raw_min_level", "enum");
   _insert_values("plugins/lighttable/thumbnail_raw_min_level", "[always][small][VGA][720p][1080p][WQXGA][4K][5K][never]");
   WRAP_TRANSLATION(C_("preferences", "always"));
   WRAP_TRANSLATION(C_("preferences", "small"));
   WRAP_TRANSLATION(C_("preferences", "VGA"));
   WRAP_TRANSLATION(C_("preferences", "720p"));
   WRAP_TRANSLATION(C_("preferences", "1080p"));
   WRAP_TRANSLATION(C_("preferences", "WQXGA"));
   WRAP_TRANSLATION(C_("preferences", "4K"));
   WRAP_TRANSLATION(C_("preferences", "5K"));
   WRAP_TRANSLATION(C_("preferences", "never"));
   _insert_default("plugins/lighttable/thumbnail_raw_min_level", "never");
   _insert_shortdescription("plugins/lighttable/thumbnail_raw_min_level", "use raw file instead of embedded JPEG from size");
   _insert_longdescription("plugins/lighttable/thumbnail_raw_min_level", "if the thumbnail size is greater than this value, it will be processed using raw file instead of the embedded preview JPEG (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)");

   // plugins/lighttable/thumbnail_hq_min_level
   _insert_type("plugins/lighttable/thumbnail_hq_min_level", "enum");
   _insert_values("plugins/lighttable/thumbnail_hq_min_level", "[always][small][VGA][720p][1080p][WQXGA][4K][5K][never]");
   WRAP_TRANSLATION(C_("preferences", "always"));
   WRAP_TRANSLATION(C_("preferences", "small"));
   WRAP_TRANSLATION(C_("preferences", "VGA"));
   WRAP_TRANSLATION(C_("preferences", "720p"));
   WRAP_TRANSLATION(C_("preferences", "1080p"));
   WRAP_TRANSLATION(C_("preferences", "WQXGA"));
   WRAP_TRANSLATION(C_("preferences", "4K"));
   WRAP_TRANSLATION(C_("preferences", "5K"));
   WRAP_TRANSLATION(C_("preferences", "never"));
   _insert_default("plugins/lighttable/thumbnail_hq_min_level", "720p");
   _insert_shortdescription("plugins/lighttable/thumbnail_hq_min_level", "high quality processing from size");
   _insert_longdescription("plugins/lighttable/thumbnail_hq_min_level", "if the thumbnail size is greater than this value, it will be processed using the full quality rendering path (better but slower).\nif you want all thumbnails and pre-rendered images in best quality you should choose the *always* option.\n(more comments in the manual)");

   // cache_disk_backend
   _insert_type("cache_disk_backend", "bool");
   _insert_default("cache_disk_backend", "true");
   _insert_shortdescription("cache_disk_backend", "enable disk backend for thumbnail cache");
   _insert_longdescription("cache_disk_backend", "if enabled, write thumbnails to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached thumbnails again.\nit's safe though to delete these manually, if you want. light table performance will be increased greatly when browsing a lot.\nto generate all thumbnails of your entire collection offline, run 'darktable-generate-cache'.");

   // cache_disk_backend_full
   _insert_type("cache_disk_backend_full", "bool");
   _insert_default("cache_disk_backend_full", "false");
   _insert_shortdescription("cache_disk_backend_full", "enable disk backend for full preview cache");
   _insert_longdescription("cache_disk_backend_full", "if enabled, write full preview to disk (.cache/darktable/) when evicted from the memory cache.\nnote that this can take a lot of memory (several gigabytes for 20k images) and will never delete cached thumbnails again.\nit's safe though to delete these manually, if you want.\nlight table performance will be increased greatly when zooming image in full preview mode.");

   // backthumbs_mipsize
   _insert_type("backthumbs_mipsize", "enum");
   _insert_values("backthumbs_mipsize", "[never][small][VGA][720p][1080p][WQXGA][4K][5K]");
   WRAP_TRANSLATION(C_("preferences", "never"));
   WRAP_TRANSLATION(C_("preferences", "small"));
   WRAP_TRANSLATION(C_("preferences", "VGA"));
   WRAP_TRANSLATION(C_("preferences", "720p"));
   WRAP_TRANSLATION(C_("preferences", "1080p"));
   WRAP_TRANSLATION(C_("preferences", "WQXGA"));
   WRAP_TRANSLATION(C_("preferences", "4K"));
   WRAP_TRANSLATION(C_("preferences", "5K"));
   _insert_default("backthumbs_mipsize", "never");
   _insert_shortdescription("backthumbs_mipsize", "generate thumbnails in background");
   _insert_longdescription("backthumbs_mipsize", "if 'enable disk backend for thumbnail cache' is enabled thumbnails/mipmaps up to the selected size are generated while user is inactive in lighttable.");

   // backthumbs_initialize
   _insert_type("backthumbs_initialize", "bool");
   _insert_default("backthumbs_initialize", "false");
   _insert_shortdescription("backthumbs_initialize", "reset cached thumbnails");
   _insert_longdescription("backthumbs_initialize", "force thumbnails to be regenerated by resetting the database. this may be needed in case some thumbnails have been manually removed or corrupted.");

   // plugins/lighttable/thumbnail_sizes
   _insert_type("plugins/lighttable/thumbnail_sizes", "string");
   _insert_default("plugins/lighttable/thumbnail_sizes", "120|400");
   _insert_shortdescription("plugins/lighttable/thumbnail_sizes", "delimiters for size categories");
   _insert_longdescription("plugins/lighttable/thumbnail_sizes", "size categories are used to be able to set different overlays and CSS values depending of the size of the thumbnail, separated by |.\nfor example, 120|400 means 3 categories of thumbnails: <120px, 120-400px, >400px");

   // plugins/lighttable/extended_pattern
   _insert_type("plugins/lighttable/extended_pattern", "longstring");
   _insert_default("plugins/lighttable/extended_pattern", "$(FILE_NAME).$(FILE_EXTENSION)$(NL)$(EXIF_EXPOSURE) • f/$(EXIF_APERTURE) • $(EXIF_FOCAL_LENGTH)mm • $(EXIF_ISO) ISO $(SIDECAR_TXT)");
   _insert_shortdescription("plugins/lighttable/extended_pattern", "pattern for the thumbnail extended overlay text");
   _insert_longdescription("plugins/lighttable/extended_pattern", "see manual to know all the tags you can use.");

   // plugins/lighttable/thumbnail_tooltip_pattern
   _insert_type("plugins/lighttable/thumbnail_tooltip_pattern", "longstring");
   _insert_default("plugins/lighttable/thumbnail_tooltip_pattern", "<b>$(FILE_NAME).$(FILE_EXTENSION)</b>$(NL)$(EXIF.DATE.REGIONAL) $(EXIF.TIME.REGIONAL)$(NL)$(EXIF_EXPOSURE) • f/$(EXIF_APERTURE) • $(EXIF_FOCAL_LENGTH) mm • $(EXIF_ISO) ISO");
   _insert_shortdescription("plugins/lighttable/thumbnail_tooltip_pattern", "pattern for the thumbnail tooltip (empty to disable)");
   _insert_longdescription("plugins/lighttable/thumbnail_tooltip_pattern", "see manual to know all the tags you can use.");

   // pressure_sensitivity
   _insert_type("pressure_sensitivity", "enum");
   _insert_values("pressure_sensitivity", "[off][hardness (relative)][hardness (absolute)][opacity (relative)][opacity (absolute)][brush size (relative)]");
   WRAP_TRANSLATION(C_("preferences", "off"));
   WRAP_TRANSLATION(C_("preferences", "hardness (relative)"));
   WRAP_TRANSLATION(C_("preferences", "hardness (absolute)"));
   WRAP_TRANSLATION(C_("preferences", "opacity (relative)"));
   WRAP_TRANSLATION(C_("preferences", "opacity (absolute)"));
   WRAP_TRANSLATION(C_("preferences", "brush size (relative)"));
   _insert_default("pressure_sensitivity", "off");
   _insert_shortdescription("pressure_sensitivity", "pen pressure control for brush masks");
   _insert_longdescription("pressure_sensitivity", " - 'off': pressure reading ignored,\n - 'hardness'/'opacity'/'brush size': pressure reading controls specified attribute,\n - 'absolute'/'relative': pressure reading is taken directly as attribute value or multiplied with pre-defined setting.");

   // brush_smoothing
   _insert_type("brush_smoothing", "enum");
   _insert_values("brush_smoothing", "[low][medium][high]");
   WRAP_TRANSLATION(C_("preferences", "low"));
   WRAP_TRANSLATION(C_("preferences", "medium"));
   WRAP_TRANSLATION(C_("preferences", "high"));
   _insert_default("brush_smoothing", "medium");
   _insert_shortdescription("brush_smoothing", "smoothing of brush strokes");
   _insert_longdescription("brush_smoothing", "sets level for smoothing of brush strokes.\nstronger smoothing leads to less nodes and easier editing but with lower control of accuracy.");

   // masks_scroll_down_increases
   _insert_type("masks_scroll_down_increases", "bool");
   _insert_default("masks_scroll_down_increases", "false");
   _insert_shortdescription("masks_scroll_down_increases", "scroll down to increase mask parameters");
   _insert_longdescription("masks_scroll_down_increases", "when using the mouse scroll wheel to change mask parameters, scroll down to increase the mask size, feather size, opacity, brush hardness and gradient curvature\nby default scrolling up increases these parameters");

   // darkroom/mouse/middle_button_cycle_zoom_to_200_percent
   _insert_type("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", "bool");
   _insert_default("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", "true");
   _insert_shortdescription("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", "middle mouse button zooms to 200%");
   _insert_longdescription("darkroom/mouse/middle_button_cycle_zoom_to_200_percent", "if enabled, the zoom level will cycle between 100%, 200% and fit to viewport on middle mouse clicks. if disabled, it will toggle between viewport size and 100%, and the 'ctrl' key can be used to control the zoom level.");

   // channel_display
   _insert_type("channel_display", "enum");
   _insert_values("channel_display", "[false color][grayscale]");
   WRAP_TRANSLATION(C_("preferences", "false color"));
   WRAP_TRANSLATION(C_("preferences", "grayscale"));
   _insert_default("channel_display", "false color");
   _insert_shortdescription("channel_display", "display of individual color channels");
   _insert_longdescription("channel_display", "defines how color channels are displayed when activated in the parametric masks feature.");

   // plugins/darkroom/image_infos_pattern
   _insert_type("plugins/darkroom/image_infos_pattern", "longstring");
   _insert_default("plugins/darkroom/image_infos_pattern", "$(EXIF_EXPOSURE) • f/$(EXIF_APERTURE) • $(EXIF_FOCAL_LENGTH) mm • $(EXIF_ISO) ISO");
   _insert_shortdescription("plugins/darkroom/image_infos_pattern", "pattern for the image information line");
   _insert_longdescription("plugins/darkroom/image_infos_pattern", "see manual for a list of the tags you can use.");

   // plugins/darkroom/image_infos_position
   _insert_type("plugins/darkroom/image_infos_position", "enum");
   _insert_values("plugins/darkroom/image_infos_position", "[top left][top right][top center][bottom][hidden]");
   WRAP_TRANSLATION(C_("preferences", "top left"));
   WRAP_TRANSLATION(C_("preferences", "top right"));
   WRAP_TRANSLATION(C_("preferences", "top center"));
   WRAP_TRANSLATION(C_("preferences", "bottom"));
   WRAP_TRANSLATION(C_("preferences", "hidden"));
   _insert_default("plugins/darkroom/image_infos_position", "bottom");
   _insert_shortdescription("plugins/darkroom/image_infos_position", "position of the image information line");
   _insert_longdescription("plugins/darkroom/image_infos_position", "");

   // database_cache_quality
   _insert_type("database_cache_quality", "int");
   _insert_default("database_cache_quality", "89");
   _insert_shortdescription("database_cache_quality", "JPEG quality of on-disk thumbnails");
   _insert_longdescription("database_cache_quality", "affects only the thumbnail cache used for quick startup.");

   // plugins/lighttable/draw_group_borders
   _insert_type("plugins/lighttable/draw_group_borders", "bool");
   _insert_default("plugins/lighttable/draw_group_borders", "true");
   _insert_shortdescription("plugins/lighttable/draw_group_borders", "draw borders around grouped images");
   _insert_longdescription("plugins/lighttable/draw_group_borders", "draw borders around grouped images when grouping is turned off and the mouse hovers over one of the images of the group");

   // modules/default_presets_first
   _insert_type("modules/default_presets_first", "bool");
   _insert_default("modules/default_presets_first", "true");
   _insert_shortdescription("modules/default_presets_first", "sort built-in presets first");
   _insert_longdescription("modules/default_presets_first", "whether to show built-in presets first before user's presets in presets menu.");

   // plugins/darkroom/hide_default_presets
   _insert_type("plugins/darkroom/hide_default_presets", "bool");
   _insert_default("plugins/darkroom/hide_default_presets", "false");
   _insert_shortdescription("plugins/darkroom/hide_default_presets", "hide built-in presets for processing modules");
   _insert_longdescription("plugins/darkroom/hide_default_presets", "hides built-in presets of processing modules in both presets and favourites menu.");

   // plugins/darkroom/show_guides_in_ui
   _insert_type("plugins/darkroom/show_guides_in_ui", "bool");
   _insert_default("plugins/darkroom/show_guides_in_ui", "true");
   _insert_shortdescription("plugins/darkroom/show_guides_in_ui", "show the guides widget in modules UI");
   _insert_longdescription("plugins/darkroom/show_guides_in_ui", "show the guides widget in modules UI");

   // plugins/lighttable/hide_default_presets
   _insert_type("plugins/lighttable/hide_default_presets", "bool");
   _insert_default("plugins/lighttable/hide_default_presets", "false");
   _insert_shortdescription("plugins/lighttable/hide_default_presets", "hide built-in presets for utility modules");
   _insert_longdescription("plugins/lighttable/hide_default_presets", "hides built-in presets of utility modules in presets menu.");

   // session/base_directory_pattern
   _insert_type("session/base_directory_pattern", "string");
   _insert_default("session/base_directory_pattern", "$(PICTURES_FOLDER)/Darktable");
   _insert_shortdescription("session/base_directory_pattern", "base directory naming pattern");
   _insert_longdescription("session/base_directory_pattern", "part of full import path for an import session");

   // session/sub_directory_pattern
   _insert_type("session/sub_directory_pattern", "string");
   _insert_default("session/sub_directory_pattern", "$(YEAR)$(MONTH)$(DAY)_$(JOBCODE)");
   _insert_shortdescription("session/sub_directory_pattern", "sub directory naming pattern");
   _insert_longdescription("session/sub_directory_pattern", "part of full import path for an import session");

   // session/use_filename
   _insert_type("session/use_filename", "bool");
   _insert_default("session/use_filename", "false");
   _insert_shortdescription("session/use_filename", "keep original filename");
   _insert_longdescription("session/use_filename", "keep original filename instead of a pattern while importing from camera or card");

   // session/filename_pattern
   _insert_type("session/filename_pattern", "string");
   _insert_default("session/filename_pattern", "$(YEAR)$(MONTH)$(DAY)_$(SEQUENCE).$(FILE_EXTENSION)");
   _insert_shortdescription("session/filename_pattern", "file naming pattern");
   _insert_longdescription("session/filename_pattern", "file naming pattern used for a import session");

   // plugins/lighttable/layout
   _insert_type("plugins/lighttable/layout", "int");
   _insert_default("plugins/lighttable/layout", "1");
   _insert_shortdescription("plugins/lighttable/layout", "lighttable layout mode");
   _insert_longdescription("plugins/lighttable/layout", "select a layout for the lighttable: 0 - zoomable lighttable or 1 - file manager or 2 - culling layout.");

   // plugins/lighttable/base_layout
   _insert_type("plugins/lighttable/base_layout", "int");
   _insert_default("plugins/lighttable/base_layout", "1");
   _insert_shortdescription("plugins/lighttable/base_layout", "lighttable basic layout mode");
   _insert_longdescription("plugins/lighttable/base_layout", "the layout to return to when exiting culling layout");

   // plugins/lighttable/images_in_row
   _insert_type("plugins/lighttable/images_in_row", "int");
   _insert_default("plugins/lighttable/images_in_row", "5");
   _insert_shortdescription("plugins/lighttable/images_in_row", "images per row");
   _insert_longdescription("plugins/lighttable/images_in_row", "");

   // plugins/lighttable/culling_num_images
   _insert_type("plugins/lighttable/culling_num_images", "int");
   _insert_default("plugins/lighttable/culling_num_images", "2");
   _insert_shortdescription("plugins/lighttable/culling_num_images", "images to display in culling layout");
   _insert_longdescription("plugins/lighttable/culling_num_images", "");

   // plugins/lighttable/culling_zoom_mode
   _insert_type("plugins/lighttable/culling_zoom_mode", "int");
   _insert_default("plugins/lighttable/culling_zoom_mode", "0");
   _insert_shortdescription("plugins/lighttable/culling_zoom_mode", "zoom mode in culling layout. 0=fixed ; 1=dynamic");
   _insert_longdescription("plugins/lighttable/culling_zoom_mode", "");

   // plugins/lighttable/culling_last_id
   _insert_type("plugins/lighttable/culling_last_id", "int");
   _insert_default("plugins/lighttable/culling_last_id", "-1");
   _insert_shortdescription("plugins/lighttable/culling_last_id", "last culling first image id");
   _insert_longdescription("plugins/lighttable/culling_last_id", "");

   // plugins/lighttable/recentcollect/num_items
   _insert_type("plugins/lighttable/recentcollect/num_items", "int");
   _insert_default("plugins/lighttable/recentcollect/num_items", "0");
   _insert_shortdescription("plugins/lighttable/recentcollect/num_items", "");
   _insert_longdescription("plugins/lighttable/recentcollect/num_items", "");

   // plugins/lighttable/recentcollect/line0
   _insert_type("plugins/lighttable/recentcollect/line0", "string");
   _insert_default("plugins/lighttable/recentcollect/line0", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line0", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line0", "");

   // plugins/lighttable/recentcollect/line1
   _insert_type("plugins/lighttable/recentcollect/line1", "string");
   _insert_default("plugins/lighttable/recentcollect/line1", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line1", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line1", "");

   // plugins/lighttable/recentcollect/line2
   _insert_type("plugins/lighttable/recentcollect/line2", "string");
   _insert_default("plugins/lighttable/recentcollect/line2", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line2", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line2", "");

   // plugins/lighttable/recentcollect/line3
   _insert_type("plugins/lighttable/recentcollect/line3", "string");
   _insert_default("plugins/lighttable/recentcollect/line3", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line3", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line3", "");

   // plugins/lighttable/recentcollect/line4
   _insert_type("plugins/lighttable/recentcollect/line4", "string");
   _insert_default("plugins/lighttable/recentcollect/line4", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line4", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line4", "");

   // plugins/lighttable/recentcollect/line5
   _insert_type("plugins/lighttable/recentcollect/line5", "string");
   _insert_default("plugins/lighttable/recentcollect/line5", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line5", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line5", "");

   // plugins/lighttable/recentcollect/line6
   _insert_type("plugins/lighttable/recentcollect/line6", "string");
   _insert_default("plugins/lighttable/recentcollect/line6", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line6", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line6", "");

   // plugins/lighttable/recentcollect/line7
   _insert_type("plugins/lighttable/recentcollect/line7", "string");
   _insert_default("plugins/lighttable/recentcollect/line7", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line7", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line7", "");

   // plugins/lighttable/recentcollect/line8
   _insert_type("plugins/lighttable/recentcollect/line8", "string");
   _insert_default("plugins/lighttable/recentcollect/line8", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line8", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line8", "");

   // plugins/lighttable/recentcollect/line9
   _insert_type("plugins/lighttable/recentcollect/line9", "string");
   _insert_default("plugins/lighttable/recentcollect/line9", "");
   _insert_shortdescription("plugins/lighttable/recentcollect/line9", "");
   _insert_longdescription("plugins/lighttable/recentcollect/line9", "");

   // plugins/lighttable/copy_history/pastemode
   _insert_type("plugins/lighttable/copy_history/pastemode", "int");
   _insert_default("plugins/lighttable/copy_history/pastemode", "0");
   _insert_shortdescription("plugins/lighttable/copy_history/pastemode", "append or replace history stack if pasted");
   _insert_longdescription("plugins/lighttable/copy_history/pastemode", "0 -- append on top of stack, 1 -- replace it.");

   // plugins/lighttable/collect/single-click
   _insert_type("plugins/lighttable/collect/single-click", "bool");
   _insert_default("plugins/lighttable/collect/single-click", "false");
   _insert_shortdescription("plugins/lighttable/collect/single-click", "use single-click in the collections module");
   _insert_longdescription("plugins/lighttable/collect/single-click", "check this option to use single-click to select items in the collections module. this will allow you to do range selections for date-time and numeric values.");

   // plugins/lighttable/collect/num_rules
   _insert_type("plugins/lighttable/collect/num_rules", "int");
   _insert_default("plugins/lighttable/collect/num_rules", "1");
   _insert_shortdescription("plugins/lighttable/collect/num_rules", "");
   _insert_longdescription("plugins/lighttable/collect/num_rules", "");

   // plugins/lighttable/collect/item0
   _insert_type("plugins/lighttable/collect/item0", "int");
   _insert_default("plugins/lighttable/collect/item0", "0");
   _insert_shortdescription("plugins/lighttable/collect/item0", "");
   _insert_longdescription("plugins/lighttable/collect/item0", "");

   // plugins/lighttable/collect/string0
   _insert_type("plugins/lighttable/collect/string0", "string");
   _insert_default("plugins/lighttable/collect/string0", "%");
   _insert_shortdescription("plugins/lighttable/collect/string0", "");
   _insert_longdescription("plugins/lighttable/collect/string0", "");

   // plugins/lighttable/collect/item1
   _insert_type("plugins/lighttable/collect/item1", "int");
   _insert_default("plugins/lighttable/collect/item1", "0");
   _insert_shortdescription("plugins/lighttable/collect/item1", "");
   _insert_longdescription("plugins/lighttable/collect/item1", "");

   // plugins/lighttable/collect/string1
   _insert_type("plugins/lighttable/collect/string1", "string");
   _insert_default("plugins/lighttable/collect/string1", "");
   _insert_shortdescription("plugins/lighttable/collect/string1", "");
   _insert_longdescription("plugins/lighttable/collect/string1", "");

   // plugins/lighttable/collect/item2
   _insert_type("plugins/lighttable/collect/item2", "int");
   _insert_default("plugins/lighttable/collect/item2", "0");
   _insert_shortdescription("plugins/lighttable/collect/item2", "");
   _insert_longdescription("plugins/lighttable/collect/item2", "");

   // plugins/lighttable/collect/string2
   _insert_type("plugins/lighttable/collect/string2", "string");
   _insert_default("plugins/lighttable/collect/string2", "");
   _insert_shortdescription("plugins/lighttable/collect/string2", "");
   _insert_longdescription("plugins/lighttable/collect/string2", "");

   // plugins/lighttable/collect/item3
   _insert_type("plugins/lighttable/collect/item3", "int");
   _insert_default("plugins/lighttable/collect/item3", "0");
   _insert_shortdescription("plugins/lighttable/collect/item3", "");
   _insert_longdescription("plugins/lighttable/collect/item3", "");

   // plugins/lighttable/collect/string3
   _insert_type("plugins/lighttable/collect/string3", "string");
   _insert_default("plugins/lighttable/collect/string3", "");
   _insert_shortdescription("plugins/lighttable/collect/string3", "");
   _insert_longdescription("plugins/lighttable/collect/string3", "");

   // plugins/lighttable/collect/item4
   _insert_type("plugins/lighttable/collect/item4", "int");
   _insert_default("plugins/lighttable/collect/item4", "0");
   _insert_shortdescription("plugins/lighttable/collect/item4", "");
   _insert_longdescription("plugins/lighttable/collect/item4", "");

   // plugins/lighttable/collect/string4
   _insert_type("plugins/lighttable/collect/string4", "string");
   _insert_default("plugins/lighttable/collect/string4", "");
   _insert_shortdescription("plugins/lighttable/collect/string4", "");
   _insert_longdescription("plugins/lighttable/collect/string4", "");

   // plugins/lighttable/collect/item5
   _insert_type("plugins/lighttable/collect/item5", "int");
   _insert_default("plugins/lighttable/collect/item5", "0");
   _insert_shortdescription("plugins/lighttable/collect/item5", "");
   _insert_longdescription("plugins/lighttable/collect/item5", "");

   // plugins/lighttable/collect/string5
   _insert_type("plugins/lighttable/collect/string5", "string");
   _insert_default("plugins/lighttable/collect/string5", "");
   _insert_shortdescription("plugins/lighttable/collect/string5", "");
   _insert_longdescription("plugins/lighttable/collect/string5", "");

   // plugins/lighttable/collect/item6
   _insert_type("plugins/lighttable/collect/item6", "int");
   _insert_default("plugins/lighttable/collect/item6", "0");
   _insert_shortdescription("plugins/lighttable/collect/item6", "");
   _insert_longdescription("plugins/lighttable/collect/item6", "");

   // plugins/lighttable/collect/string6
   _insert_type("plugins/lighttable/collect/string6", "string");
   _insert_default("plugins/lighttable/collect/string6", "");
   _insert_shortdescription("plugins/lighttable/collect/string6", "");
   _insert_longdescription("plugins/lighttable/collect/string6", "");

   // plugins/lighttable/collect/item7
   _insert_type("plugins/lighttable/collect/item7", "int");
   _insert_default("plugins/lighttable/collect/item7", "0");
   _insert_shortdescription("plugins/lighttable/collect/item7", "");
   _insert_longdescription("plugins/lighttable/collect/item7", "");

   // plugins/lighttable/collect/string7
   _insert_type("plugins/lighttable/collect/string7", "string");
   _insert_default("plugins/lighttable/collect/string7", "");
   _insert_shortdescription("plugins/lighttable/collect/string7", "");
   _insert_longdescription("plugins/lighttable/collect/string7", "");

   // plugins/lighttable/collect/item8
   _insert_type("plugins/lighttable/collect/item8", "int");
   _insert_default("plugins/lighttable/collect/item8", "0");
   _insert_shortdescription("plugins/lighttable/collect/item8", "");
   _insert_longdescription("plugins/lighttable/collect/item8", "");

   // plugins/lighttable/collect/string8
   _insert_type("plugins/lighttable/collect/string8", "string");
   _insert_default("plugins/lighttable/collect/string8", "");
   _insert_shortdescription("plugins/lighttable/collect/string8", "");
   _insert_longdescription("plugins/lighttable/collect/string8", "");

   // plugins/lighttable/collect/item9
   _insert_type("plugins/lighttable/collect/item9", "int");
   _insert_default("plugins/lighttable/collect/item9", "0");
   _insert_shortdescription("plugins/lighttable/collect/item9", "");
   _insert_longdescription("plugins/lighttable/collect/item9", "");

   // plugins/lighttable/collect/string9
   _insert_type("plugins/lighttable/collect/string9", "string");
   _insert_default("plugins/lighttable/collect/string9", "");
   _insert_shortdescription("plugins/lighttable/collect/string9", "");
   _insert_longdescription("plugins/lighttable/collect/string9", "");

   // plugins/lighttable/collect/mode0
   _insert_type("plugins/lighttable/collect/mode0", "int");
   _insert_default("plugins/lighttable/collect/mode0", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode0", "");
   _insert_longdescription("plugins/lighttable/collect/mode0", "");

   // plugins/lighttable/collect/mode1
   _insert_type("plugins/lighttable/collect/mode1", "int");
   _insert_default("plugins/lighttable/collect/mode1", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode1", "");
   _insert_longdescription("plugins/lighttable/collect/mode1", "");

   // plugins/lighttable/collect/mode2
   _insert_type("plugins/lighttable/collect/mode2", "int");
   _insert_default("plugins/lighttable/collect/mode2", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode2", "");
   _insert_longdescription("plugins/lighttable/collect/mode2", "");

   // plugins/lighttable/collect/mode3
   _insert_type("plugins/lighttable/collect/mode3", "int");
   _insert_default("plugins/lighttable/collect/mode3", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode3", "");
   _insert_longdescription("plugins/lighttable/collect/mode3", "");

   // plugins/lighttable/collect/mode4
   _insert_type("plugins/lighttable/collect/mode4", "int");
   _insert_default("plugins/lighttable/collect/mode4", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode4", "");
   _insert_longdescription("plugins/lighttable/collect/mode4", "");

   // plugins/lighttable/collect/mode5
   _insert_type("plugins/lighttable/collect/mode5", "int");
   _insert_default("plugins/lighttable/collect/mode5", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode5", "");
   _insert_longdescription("plugins/lighttable/collect/mode5", "");

   // plugins/lighttable/collect/mode6
   _insert_type("plugins/lighttable/collect/mode6", "int");
   _insert_default("plugins/lighttable/collect/mode6", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode6", "");
   _insert_longdescription("plugins/lighttable/collect/mode6", "");

   // plugins/lighttable/collect/mode7
   _insert_type("plugins/lighttable/collect/mode7", "int");
   _insert_default("plugins/lighttable/collect/mode7", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode7", "");
   _insert_longdescription("plugins/lighttable/collect/mode7", "");

   // plugins/lighttable/collect/mode8
   _insert_type("plugins/lighttable/collect/mode8", "int");
   _insert_default("plugins/lighttable/collect/mode8", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode8", "");
   _insert_longdescription("plugins/lighttable/collect/mode8", "");

   // plugins/lighttable/collect/mode9
   _insert_type("plugins/lighttable/collect/mode9", "int");
   _insert_default("plugins/lighttable/collect/mode9", "0");
   _insert_shortdescription("plugins/lighttable/collect/mode9", "");
   _insert_longdescription("plugins/lighttable/collect/mode9", "");

   // plugins/darkroom/tagging/visible
   _insert_type("plugins/darkroom/tagging/visible", "bool");
   _insert_default("plugins/darkroom/tagging/visible", "true");
   _insert_shortdescription("plugins/darkroom/tagging/visible", "show the tagging module in the darkroom view (as well as in lighttable)");
   _insert_longdescription("plugins/darkroom/tagging/visible", "");

   // plugins/darkroom/export/visible
   _insert_type("plugins/darkroom/export/visible", "bool");
   _insert_default("plugins/darkroom/export/visible", "true");
   _insert_shortdescription("plugins/darkroom/export/visible", "show the export module in the darkroom view (as well as in lighttable)");
   _insert_longdescription("plugins/darkroom/export/visible", "");

   // plugins/lighttable/tagging/ask_before_delete_tag
   _insert_type("plugins/lighttable/tagging/ask_before_delete_tag", "bool");
   _insert_default("plugins/lighttable/tagging/ask_before_delete_tag", "true");
   _insert_shortdescription("plugins/lighttable/tagging/ask_before_delete_tag", "ask before deleting a tag");
   _insert_longdescription("plugins/lighttable/tagging/ask_before_delete_tag", "");

   // plugins/lighttable/tagging/dttags
   _insert_type("plugins/lighttable/tagging/dttags", "bool");
   _insert_default("plugins/lighttable/tagging/dttags", "false");
   _insert_shortdescription("plugins/lighttable/tagging/dttags", "whether to show darktable internal tags");
   _insert_longdescription("plugins/lighttable/tagging/dttags", "");

   // plugins/lighttable/tagging/nosuggestion
   _insert_type("plugins/lighttable/tagging/nosuggestion", "bool");
   _insert_default("plugins/lighttable/tagging/nosuggestion", "false");
   _insert_shortdescription("plugins/lighttable/tagging/nosuggestion", "whether display suggestions");
   _insert_longdescription("plugins/lighttable/tagging/nosuggestion", "");

   // plugins/lighttable/tagging/treeview
   _insert_type("plugins/lighttable/tagging/treeview", "bool");
   _insert_default("plugins/lighttable/tagging/treeview", "false");
   _insert_shortdescription("plugins/lighttable/tagging/treeview", "whether display tags in list or tree");
   _insert_longdescription("plugins/lighttable/tagging/treeview", "");

   // plugins/lighttable/tagging/hidehierarchy
   _insert_type("plugins/lighttable/tagging/hidehierarchy", "bool");
   _insert_default("plugins/lighttable/tagging/hidehierarchy", "false");
   _insert_shortdescription("plugins/lighttable/tagging/hidehierarchy", "whether to show/hide the tag hierarchy");
   _insert_longdescription("plugins/lighttable/tagging/hidehierarchy", "");

   // plugins/lighttable/tagging/listsortedbycount
   _insert_type("plugins/lighttable/tagging/listsortedbycount", "bool");
   _insert_default("plugins/lighttable/tagging/listsortedbycount", "false");
   _insert_shortdescription("plugins/lighttable/tagging/listsortedbycount", "whether to sort tags by count or by name");
   _insert_longdescription("plugins/lighttable/tagging/listsortedbycount", "");

   // plugins/lighttable/tagging/heightattachedwindow
   _insert_type("plugins/lighttable/tagging/heightattachedwindow", "int");
   _insert_default("plugins/lighttable/tagging/heightattachedwindow", "100");
   _insert_shortdescription("plugins/lighttable/tagging/heightattachedwindow", "height of the tagging attached view");
   _insert_longdescription("plugins/lighttable/tagging/heightattachedwindow", "maximum height the tagging attached view will grow to before scrolling");

   // plugins/lighttable/tagging/heightdictionarywindow
   _insert_type("plugins/lighttable/tagging/heightdictionarywindow", "int");
   _insert_default("plugins/lighttable/tagging/heightdictionarywindow", "200");
   _insert_shortdescription("plugins/lighttable/tagging/heightdictionarywindow", "height of the tagging dictionary view");
   _insert_longdescription("plugins/lighttable/tagging/heightdictionarywindow", "maximum height the tagging dictionary view will grow to before scrolling");

   // plugins/lighttable/tagging/confidence
   _insert_type("plugins/lighttable/tagging/confidence", "int");
   _insert_default("plugins/lighttable/tagging/confidence", "50");
   _insert_min("plugins/lighttable/tagging/confidence", "0");
   _insert_max("plugins/lighttable/tagging/confidence", "100");
   _insert_shortdescription("plugins/lighttable/tagging/confidence", "suggested tags level of confidence");
   _insert_longdescription("plugins/lighttable/tagging/confidence", "level of confidence to include the tag in the suggestions list, 0: all associated tags, 99: 99% matching associated tags, 100: no matching tag to show only recent tags (faster)");

   // plugins/lighttable/tagging/nb_recent_tags
   _insert_type("plugins/lighttable/tagging/nb_recent_tags", "int");
   _insert_default("plugins/lighttable/tagging/nb_recent_tags", "20");
   _insert_min("plugins/lighttable/tagging/nb_recent_tags", "-1");
   _insert_max("plugins/lighttable/tagging/nb_recent_tags", "1000");
   _insert_shortdescription("plugins/lighttable/tagging/nb_recent_tags", "number of recently attached tags");
   _insert_longdescription("plugins/lighttable/tagging/nb_recent_tags", "number of recently attached tags which are included in the suggestions list. the value `-1' disables the recent list");

   // plugins/lighttable/tagging/recent_tags
   _insert_type("plugins/lighttable/tagging/recent_tags", "string");
   _insert_default("plugins/lighttable/tagging/recent_tags", "");
   _insert_shortdescription("plugins/lighttable/tagging/recent_tags", "");
   _insert_longdescription("plugins/lighttable/tagging/recent_tags", "");

   // plugins/lighttable/metadata/creator_text_height
   _insert_type("plugins/lighttable/metadata/creator_text_height", "int");
   _insert_default("plugins/lighttable/metadata/creator_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/creator_text_height", "height of the metadata creator field");
   _insert_longdescription("plugins/lighttable/metadata/creator_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/publisher_text_height
   _insert_type("plugins/lighttable/metadata/publisher_text_height", "int");
   _insert_default("plugins/lighttable/metadata/publisher_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/publisher_text_height", "height of the metadata publisher field");
   _insert_longdescription("plugins/lighttable/metadata/publisher_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/title_text_height
   _insert_type("plugins/lighttable/metadata/title_text_height", "int");
   _insert_default("plugins/lighttable/metadata/title_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/title_text_height", "height of the metadata title field");
   _insert_longdescription("plugins/lighttable/metadata/title_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/description_text_height
   _insert_type("plugins/lighttable/metadata/description_text_height", "int");
   _insert_default("plugins/lighttable/metadata/description_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/description_text_height", "height of the metadata description field");
   _insert_longdescription("plugins/lighttable/metadata/description_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/rights_text_height
   _insert_type("plugins/lighttable/metadata/rights_text_height", "int");
   _insert_default("plugins/lighttable/metadata/rights_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/rights_text_height", "height of the metadata rights field");
   _insert_longdescription("plugins/lighttable/metadata/rights_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/notes_text_height
   _insert_type("plugins/lighttable/metadata/notes_text_height", "int");
   _insert_default("plugins/lighttable/metadata/notes_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/notes_text_height", "height of the metadata notes field");
   _insert_longdescription("plugins/lighttable/metadata/notes_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/metadata/version name_text_height
   _insert_type("plugins/lighttable/metadata/version name_text_height", "int");
   _insert_default("plugins/lighttable/metadata/version name_text_height", "1");
   _insert_shortdescription("plugins/lighttable/metadata/version name_text_height", "height of the metadata version name field");
   _insert_longdescription("plugins/lighttable/metadata/version name_text_height", "maximum height the metadata textview will grow to before scrolling");

   // plugins/lighttable/style/ask_before_delete_style
   _insert_type("plugins/lighttable/style/ask_before_delete_style", "bool");
   _insert_default("plugins/lighttable/style/ask_before_delete_style", "true");
   _insert_shortdescription("plugins/lighttable/style/ask_before_delete_style", "ask before deleting a style");
   _insert_longdescription("plugins/lighttable/style/ask_before_delete_style", "");

   // plugins/lighttable/preset/ask_before_delete_preset
   _insert_type("plugins/lighttable/preset/ask_before_delete_preset", "bool");
   _insert_default("plugins/lighttable/preset/ask_before_delete_preset", "true");
   _insert_shortdescription("plugins/lighttable/preset/ask_before_delete_preset", "ask before deleting a preset");
   _insert_longdescription("plugins/lighttable/preset/ask_before_delete_preset", "will ask for confirmation before deleting or overwriting a preset");

   // plugins/lighttable/export/ask_before_export_overwrite
   _insert_type("plugins/lighttable/export/ask_before_export_overwrite", "bool");
   _insert_default("plugins/lighttable/export/ask_before_export_overwrite", "true");
   _insert_shortdescription("plugins/lighttable/export/ask_before_export_overwrite", "ask before exporting in overwrite mode");
   _insert_longdescription("plugins/lighttable/export/ask_before_export_overwrite", "will ask for confirmation before exporting files in overwrite mode");

   // plugins/map/show_map_osd
   _insert_type("plugins/map/show_map_osd", "bool");
   _insert_default("plugins/map/show_map_osd", "true");
   _insert_shortdescription("plugins/map/show_map_osd", N_("show OSD"));
   _insert_longdescription("plugins/map/show_map_osd", N_("toggle the visibility of the map overlays"));

   // plugins/map/filter_images_drawn
   _insert_type("plugins/map/filter_images_drawn", "bool");
   _insert_default("plugins/map/filter_images_drawn", "false");
   _insert_shortdescription("plugins/map/filter_images_drawn", N_("filtered images"));
   _insert_longdescription("plugins/map/filter_images_drawn", N_("when set limit the images drawn to the current filmstrip"));

   // plugins/map/max_images_drawn
   _insert_type("plugins/map/max_images_drawn", "int");
   _insert_default("plugins/map/max_images_drawn", "100");
   _insert_min("plugins/map/max_images_drawn", "10");
   _insert_max("plugins/map/max_images_drawn", "100000");
   _insert_shortdescription("plugins/map/max_images_drawn", N_("max images"));
   _insert_longdescription("plugins/map/max_images_drawn", N_("the maximum number of image thumbnails drawn on the map"));

   // plugins/map/epsilon_factor
   _insert_type("plugins/map/epsilon_factor", "int");
   _insert_default("plugins/map/epsilon_factor", "25");
   _insert_min("plugins/map/epsilon_factor", "1");
   _insert_max("plugins/map/epsilon_factor", "100");
   _insert_shortdescription("plugins/map/epsilon_factor", N_("group size factor"));
   _insert_longdescription("plugins/map/epsilon_factor", N_("increase or decrease the spatial size of images groups on the map. can influence the calculation time"));

   // plugins/map/min_images_per_group
   _insert_type("plugins/map/min_images_per_group", "int");
   _insert_default("plugins/map/min_images_per_group", "1");
   _insert_min("plugins/map/min_images_per_group", "1");
   _insert_max("plugins/map/min_images_per_group", "10");
   _insert_shortdescription("plugins/map/min_images_per_group", N_("min images per group"));
   _insert_longdescription("plugins/map/min_images_per_group", N_("the minimum number of images to set up an images group. can influence the calculation time."));

   // plugins/map/images_thumbnail
   _insert_type("plugins/map/images_thumbnail", "enum");
   _insert_values("plugins/map/images_thumbnail", "[thumbnail][count][none]");
   WRAP_TRANSLATION(C_("preferences", "thumbnail"));
   WRAP_TRANSLATION(C_("preferences", "count"));
   WRAP_TRANSLATION(C_("preferences", "none"));
   _insert_default("plugins/map/images_thumbnail", "thumbnail");
   _insert_shortdescription("plugins/map/images_thumbnail", N_("thumbnail display"));
   _insert_longdescription("plugins/map/images_thumbnail", N_("three options are available: images thumbnails, only the count of images of the group or nothing"));

   // plugins/map/show_outline
   _insert_type("plugins/map/show_outline", "bool");
   _insert_default("plugins/map/show_outline", "true");
   _insert_shortdescription("plugins/map/show_outline", "Whether to highlight the search result on the map");
   _insert_longdescription("plugins/map/show_outline", "");

   // plugins/map/max_outline_nodes
   _insert_type("plugins/map/max_outline_nodes", "int");
   _insert_default("plugins/map/max_outline_nodes", "10000");
   _insert_shortdescription("plugins/map/max_outline_nodes", N_("max polygon points"));
   _insert_longdescription("plugins/map/max_outline_nodes", N_("limit the number of points imported with polygon in find location module"));

   // plugins/lighttable/metadata_view/pretty_location
   _insert_type("plugins/lighttable/metadata_view/pretty_location", "bool");
   _insert_default("plugins/lighttable/metadata_view/pretty_location", "true");
   _insert_shortdescription("plugins/lighttable/metadata_view/pretty_location", "pretty print the image location");
   _insert_longdescription("plugins/lighttable/metadata_view/pretty_location", "show a more readable representation of the location in the image information module");

   // lighttable/ui/single_module
   _insert_type("lighttable/ui/single_module", "bool");
   _insert_default("lighttable/ui/single_module", "false");
   _insert_shortdescription("lighttable/ui/single_module", "expand a single utility module at a time");
   _insert_longdescription("lighttable/ui/single_module", "this option toggles the behavior of shift clicking in lighttable mode");

   // lighttable/ui/expose_statuses
   _insert_type("lighttable/ui/expose_statuses", "bool");
   _insert_default("lighttable/ui/expose_statuses", "false");
   _insert_shortdescription("lighttable/ui/expose_statuses", "always show thumbnail overlays");
   _insert_longdescription("lighttable/ui/expose_statuses", "show overlays (rating stars, 'edited' mark, etc) for all thumbnails in file manager, not only hovered one");

   // darkroom/ui/single_module
   _insert_type("darkroom/ui/single_module", "bool");
   _insert_default("darkroom/ui/single_module", "true");
   _insert_shortdescription("darkroom/ui/single_module", "expand a single processing module at a time");
   _insert_longdescription("darkroom/ui/single_module", "this option toggles the behavior of shift clicking in darkroom mode");

   // darkroom/ui/single_module_group_only
   _insert_type("darkroom/ui/single_module_group_only", "bool");
   _insert_default("darkroom/ui/single_module_group_only", "true");
   _insert_shortdescription("darkroom/ui/single_module_group_only", "only collapse modules in current group");
   _insert_longdescription("darkroom/ui/single_module_group_only", "if only expanding a single module at a time, only collapse other modules in the current group - ignore modules in other groups");

   // darkroom/ui/activate_expand
   _insert_type("darkroom/ui/activate_expand", "bool");
   _insert_default("darkroom/ui/activate_expand", "false");
   _insert_shortdescription("darkroom/ui/activate_expand", "expand the module when it is activated, and collapse it when disabled");
   _insert_longdescription("darkroom/ui/activate_expand", "this option allows to expand or collapse automatically the module when it is enabled or disabled.");

   // darkroom/ui/overlay_contrast
   _insert_type("darkroom/ui/overlay_contrast", "float");
   _insert_default("darkroom/ui/overlay_contrast", "0.5");
   _insert_shortdescription("darkroom/ui/overlay_contrast", "contrast to use in darkroom overlays");

   // lighttable/ui/scroll_to_module
   _insert_type("lighttable/ui/scroll_to_module", "bool");
   _insert_default("lighttable/ui/scroll_to_module", "false");
   _insert_shortdescription("lighttable/ui/scroll_to_module", "scroll utility modules to the top when expanded");
   _insert_longdescription("lighttable/ui/scroll_to_module", "when this option is enabled then darktable will try to scroll the module to the top of the visible list");

   // lighttable/ui/preview/bottom_visible
   _insert_type("lighttable/ui/preview/bottom_visible", "bool");
   _insert_default("lighttable/ui/preview/bottom_visible", "true");
   _insert_shortdescription("lighttable/ui/preview/bottom_visible", "show bottom panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/bottom_visible", "");

   // lighttable/ui/preview/left_visible
   _insert_type("lighttable/ui/preview/left_visible", "bool");
   _insert_default("lighttable/ui/preview/left_visible", "false");
   _insert_shortdescription("lighttable/ui/preview/left_visible", "show left panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/left_visible", "");

   // lighttable/ui/preview/right_visible
   _insert_type("lighttable/ui/preview/right_visible", "bool");
   _insert_default("lighttable/ui/preview/right_visible", "false");
   _insert_shortdescription("lighttable/ui/preview/right_visible", "show right panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/right_visible", "");

   // lighttable/ui/preview/header_visible
   _insert_type("lighttable/ui/preview/header_visible", "bool");
   _insert_default("lighttable/ui/preview/header_visible", "false");
   _insert_shortdescription("lighttable/ui/preview/header_visible", "show header panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/header_visible", "");

   // lighttable/ui/preview/toolbar_bottom_visible
   _insert_type("lighttable/ui/preview/toolbar_bottom_visible", "bool");
   _insert_default("lighttable/ui/preview/toolbar_bottom_visible", "false");
   _insert_shortdescription("lighttable/ui/preview/toolbar_bottom_visible", "show toolbar bottom panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/toolbar_bottom_visible", "");

   // lighttable/ui/preview/toolbar_top_visible
   _insert_type("lighttable/ui/preview/toolbar_top_visible", "bool");
   _insert_default("lighttable/ui/preview/toolbar_top_visible", "false");
   _insert_shortdescription("lighttable/ui/preview/toolbar_top_visible", "show toolbar top panel in preview mode");
   _insert_longdescription("lighttable/ui/preview/toolbar_top_visible", "");

   // lighttable/ui/preview/panels_collapse_controls
   _insert_type("lighttable/ui/preview/panels_collapse_controls", "bool");
   _insert_default("lighttable/ui/preview/panels_collapse_controls", "false");
   _insert_shortdescription("lighttable/ui/preview/panels_collapse_controls", "show borders arrows in preview mode");
   _insert_longdescription("lighttable/ui/preview/panels_collapse_controls", "");

   // lighttable/ui/preview/panel_collaps_state
   _insert_type("lighttable/ui/preview/panel_collaps_state", "int");
   _insert_default("lighttable/ui/preview/panel_collaps_state", "1");
   _insert_shortdescription("lighttable/ui/preview/panel_collaps_state", "panels collapsing state in preview mode");
   _insert_longdescription("lighttable/ui/preview/panel_collaps_state", "");

   // slideshow/ui/panels_collapse_controls
   _insert_type("slideshow/ui/panels_collapse_controls", "bool");
   _insert_default("slideshow/ui/panels_collapse_controls", "false");
   _insert_shortdescription("slideshow/ui/panels_collapse_controls", "show borders arrows in slideshow");
   _insert_longdescription("slideshow/ui/panels_collapse_controls", "");

   // slideshow/ui/panel_collaps_state
   _insert_type("slideshow/ui/panel_collaps_state", "int");
   _insert_default("slideshow/ui/panel_collaps_state", "1");
   _insert_shortdescription("slideshow/ui/panel_collaps_state", "panels collapsing state in slideshow");
   _insert_longdescription("slideshow/ui/panel_collaps_state", "");

   // darkroom/ui/scroll_to_module
   _insert_type("darkroom/ui/scroll_to_module", "bool");
   _insert_default("darkroom/ui/scroll_to_module", "true");
   _insert_shortdescription("darkroom/ui/scroll_to_module", "scroll processing modules to the top when expanded");
   _insert_longdescription("darkroom/ui/scroll_to_module", "when this option is enabled then darktable will try to scroll the module to the top of the visible list");

   // darkroom/ui/sidebar_scroll_default
   _insert_type("darkroom/ui/sidebar_scroll_default", "bool");
   _insert_default("darkroom/ui/sidebar_scroll_default", "false");
   _insert_shortdescription("darkroom/ui/sidebar_scroll_default", "mouse wheel scrolls modules side panel by default");
   _insert_longdescription("darkroom/ui/sidebar_scroll_default", "when enabled, use mouse wheel to scroll modules side panel.  use ctrl+alt to use mouse wheel for data entry.  when disabled, this behavior is reversed");

   // plugins/darkroom/ui/border_size
   _insert_type("plugins/darkroom/ui/border_size", "int");
   _insert_default("plugins/darkroom/ui/border_size", "10");
   _insert_shortdescription("plugins/darkroom/ui/border_size", "border around image in darkroom mode");
   _insert_longdescription("plugins/darkroom/ui/border_size", "process the image in darkroom mode with a small border. set to 0 if you don't want any border.");

   // darkroom/ui/iso12464_border
   _insert_type("darkroom/ui/iso12464_border", "float");
   _insert_default("darkroom/ui/iso12464_border", "4.0");
   _insert_min("darkroom/ui/iso12464_border", "1.0");
   _insert_max("darkroom/ui/iso12464_border", "5.0");
   _insert_shortdescription("darkroom/ui/iso12464_border", "total width of border in iso 12646 mode (cm)");

   // darkroom/ui/iso12464_ratio
   _insert_type("darkroom/ui/iso12464_ratio", "float");
   _insert_default("darkroom/ui/iso12464_ratio", "0.40");
   _insert_min("darkroom/ui/iso12464_ratio", "0.1");
   _insert_max("darkroom/ui/iso12464_ratio", "0.9");
   _insert_shortdescription("darkroom/ui/iso12464_ratio", "fraction of white border part in iso 12646 mode");
   _insert_longdescription("darkroom/ui/iso12464_ratio", "");

   // darkroom/ui/scrollbars
   _insert_type("darkroom/ui/scrollbars", "bool");
   _insert_default("darkroom/ui/scrollbars", "false");
   _insert_shortdescription("darkroom/ui/scrollbars", "show scrollbars for central view");
   _insert_longdescription("darkroom/ui/scrollbars", "defines whether scrollbars should be displayed");

   // panel_scrollbars_always_visible
   _insert_type("panel_scrollbars_always_visible", "bool");
   _insert_default("panel_scrollbars_always_visible", "true");
   _insert_shortdescription("panel_scrollbars_always_visible", "always show panels' scrollbars");
   _insert_longdescription("panel_scrollbars_always_visible", "defines whether the panel scrollbars should be always visible or activated only depending on the content.  (need a restart)");

   // darkroom/ui/transition_duration
   _insert_type("darkroom/ui/transition_duration", "int");
   _insert_default("darkroom/ui/transition_duration", "250");
   _insert_min("darkroom/ui/transition_duration", "0");
   _insert_max("darkroom/ui/transition_duration", "1000");
   _insert_shortdescription("darkroom/ui/transition_duration", "duration of the UI transitions in ms");
   _insert_longdescription("darkroom/ui/transition_duration", "how long the transitions take (in ms) for expanding or collapsing modules and other UI elements");

   // ui/style/preview_size
   _insert_type("ui/style/preview_size", "int");
   _insert_default("ui/style/preview_size", "250");
   _insert_min("ui/style/preview_size", "100");
   _insert_max("ui/style/preview_size", "500");
   _insert_shortdescription("ui/style/preview_size", "max style preview size");

   // ui_last/expander_metadata
   _insert_type("ui_last/expander_metadata", "int");
   _insert_default("ui_last/expander_metadata", "0");
   _insert_shortdescription("ui_last/expander_metadata", "");
   _insert_longdescription("ui_last/expander_metadata", "");

   // ui_last/expander_navigation
   _insert_type("ui_last/expander_navigation", "int");
   _insert_default("ui_last/expander_navigation", "-1");
   _insert_shortdescription("ui_last/expander_navigation", "");
   _insert_longdescription("ui_last/expander_navigation", "");

   // ui_last/expander_histogram
   _insert_type("ui_last/expander_histogram", "int");
   _insert_default("ui_last/expander_histogram", "-1");
   _insert_shortdescription("ui_last/expander_histogram", "");
   _insert_longdescription("ui_last/expander_histogram", "");

   // ui_last/expander_snapshots
   _insert_type("ui_last/expander_snapshots", "int");
   _insert_default("ui_last/expander_snapshots", "-1");
   _insert_shortdescription("ui_last/expander_snapshots", "");
   _insert_longdescription("ui_last/expander_snapshots", "");

   // ui_last/expander_history
   _insert_type("ui_last/expander_history", "int");
   _insert_default("ui_last/expander_history", "-1");
   _insert_shortdescription("ui_last/expander_history", "");
   _insert_longdescription("ui_last/expander_history", "");

   // plugins/lighttable/export/force_lcms2
   _insert_type("plugins/lighttable/export/force_lcms2", "bool");
   _insert_default("plugins/lighttable/export/force_lcms2", "false");
   _insert_shortdescription("plugins/lighttable/export/force_lcms2", "always use LittleCMS 2 to apply output color profile");
   _insert_longdescription("plugins/lighttable/export/force_lcms2", "this is slower than the default.");

   // plugins/lighttable/export/high_quality_processing
   _insert_type("plugins/lighttable/export/high_quality_processing", "bool");
   _insert_default("plugins/lighttable/export/high_quality_processing", "false");
   _insert_shortdescription("plugins/lighttable/export/high_quality_processing", "do high quality resampling during export");
   _insert_longdescription("plugins/lighttable/export/high_quality_processing", "the image will first be processed in full resolution, and downscaled at the very end. this can result in better quality sometimes, but will always be slower.");

   // rating_one_double_tap
   _insert_type("rating_one_double_tap", "bool");
   _insert_default("rating_one_double_tap", "false");
   _insert_shortdescription("rating_one_double_tap", "rating an image one star twice will not zero out the rating");
   _insert_longdescription("rating_one_double_tap", "defines whether rating an image one star twice will zero out star rating");

   // lighttable/ui/scrollbars
   _insert_type("lighttable/ui/scrollbars", "bool");
   _insert_default("lighttable/ui/scrollbars", "true");
   _insert_shortdescription("lighttable/ui/scrollbars", "show scrollbars for central view");
   _insert_longdescription("lighttable/ui/scrollbars", "defines whether scrollbars should be displayed");

   // lighttable/ui/milliseconds
   _insert_type("lighttable/ui/milliseconds", "bool");
   _insert_default("lighttable/ui/milliseconds", "false");
   _insert_shortdescription("lighttable/ui/milliseconds", "show image time with milliseconds");
   _insert_longdescription("lighttable/ui/milliseconds", "defines whether time should be displayed with milliseconds");

   // darkroom/ui/rawoverexposed/mode
   _insert_type("darkroom/ui/rawoverexposed/mode", "int");
   _insert_default("darkroom/ui/rawoverexposed/mode", "0");
   _insert_shortdescription("darkroom/ui/rawoverexposed/mode", "");
   _insert_longdescription("darkroom/ui/rawoverexposed/mode", "");

   // darkroom/ui/rawoverexposed/colorscheme
   _insert_type("darkroom/ui/rawoverexposed/colorscheme", "int");
   _insert_default("darkroom/ui/rawoverexposed/colorscheme", "0");
   _insert_shortdescription("darkroom/ui/rawoverexposed/colorscheme", "");
   _insert_longdescription("darkroom/ui/rawoverexposed/colorscheme", "");

   // darkroom/ui/rawoverexposed/threshold
   _insert_type("darkroom/ui/rawoverexposed/threshold", "float");
   _insert_default("darkroom/ui/rawoverexposed/threshold", "1.0");
   _insert_shortdescription("darkroom/ui/rawoverexposed/threshold", "");
   _insert_longdescription("darkroom/ui/rawoverexposed/threshold", "");

   // darkroom/ui/overexposed/colorscheme
   _insert_type("darkroom/ui/overexposed/colorscheme", "int");
   _insert_default("darkroom/ui/overexposed/colorscheme", "1");
   _insert_shortdescription("darkroom/ui/overexposed/colorscheme", "");
   _insert_longdescription("darkroom/ui/overexposed/colorscheme", "");

   // darkroom/ui/overexposed/lower
   _insert_type("darkroom/ui/overexposed/lower", "float");
   _insert_default("darkroom/ui/overexposed/lower", "-12.69");
   _insert_shortdescription("darkroom/ui/overexposed/lower", "");
   _insert_longdescription("darkroom/ui/overexposed/lower", "");

   // darkroom/ui/overexposed/upper
   _insert_type("darkroom/ui/overexposed/upper", "float");
   _insert_default("darkroom/ui/overexposed/upper", "99.99");
   _insert_shortdescription("darkroom/ui/overexposed/upper", "");
   _insert_longdescription("darkroom/ui/overexposed/upper", "");

   // plugins/darkroom/channelmixerrgb/gui_page
   _insert_type("plugins/darkroom/channelmixerrgb/gui_page", "int");
   _insert_default("plugins/darkroom/channelmixerrgb/gui_page", "0");
   _insert_shortdescription("plugins/darkroom/channelmixerrgb/gui_page", "last page selected in channel mixer rgb notebook");

   // plugins/darkroom/retouch/default_algo
   _insert_type("plugins/darkroom/retouch/default_algo", "int");
   _insert_default("plugins/darkroom/retouch/default_algo", "2");
   _insert_shortdescription("plugins/darkroom/retouch/default_algo", "default algorithm for the retouch module");

   // plugins/darkroom/demosaic/fdc_xover_iso
   _insert_type("plugins/darkroom/demosaic/fdc_xover_iso", "int");
   _insert_default("plugins/darkroom/demosaic/fdc_xover_iso", "1600");
   _insert_shortdescription("plugins/darkroom/demosaic/fdc_xover_iso", "crossover iso for X-Trans fdc demosaicing");
   _insert_longdescription("plugins/darkroom/demosaic/fdc_xover_iso", "up to, and including, this iso, X-Trans frequency domain chroma demosaicing uses the hybrid mode for determining chroma; for all higher iso values the pure fdc is used.");

   // plugins/darkroom/denoiseprofile/show_compute_variance_mode
   _insert_type("plugins/darkroom/denoiseprofile/show_compute_variance_mode", "bool");
   _insert_default("plugins/darkroom/denoiseprofile/show_compute_variance_mode", "false");
   _insert_shortdescription("plugins/darkroom/denoiseprofile/show_compute_variance_mode", "whether to show the compute variance mode in denoiseprofile");
   _insert_longdescription("plugins/darkroom/denoiseprofile/show_compute_variance_mode", "adds a mode in denoiseprofile that allows to compute the variance after the generalized anscombe transform is performed");

   // preview_downsampling
   _insert_type("preview_downsampling", "enum");
   _insert_values("preview_downsampling", "[original][to 1/2][to 1/3][to 1/4]");
   WRAP_TRANSLATION(C_("preferences", "original"));
   WRAP_TRANSLATION(C_("preferences", "to 1/2"));
   WRAP_TRANSLATION(C_("preferences", "to 1/3"));
   WRAP_TRANSLATION(C_("preferences", "to 1/4"));
   _insert_default("preview_downsampling", "original");
   _insert_shortdescription("preview_downsampling", "reduce resolution of preview image");
   _insert_longdescription("preview_downsampling", "decrease to speed up preview rendering, may hinder accurate masking");

   // darkroom/ui/loading_screen
   _insert_type("darkroom/ui/loading_screen", "bool");
   _insert_default("darkroom/ui/loading_screen", "true");
   _insert_shortdescription("darkroom/ui/loading_screen", "show loading screen between images");
   _insert_longdescription("darkroom/ui/loading_screen", "show gray loading screen when navigating between images in the darkroom\ndisable to just show a toast message");

   // darkroom/ui/develop_mask
   _insert_type("darkroom/ui/develop_mask", "bool");
   _insert_default("darkroom/ui/develop_mask", "false");
   _insert_shortdescription("darkroom/ui/develop_mask", "show mask in developer mode");
   _insert_longdescription("darkroom/ui/develop_mask", "if switched on, the mask visualize button will show the 'pure mask' instead of mask and image content.");

   // plugins/lighttable/export/pixel_interpolator_warp
   _insert_type("plugins/lighttable/export/pixel_interpolator_warp", "enum");
   _insert_values("plugins/lighttable/export/pixel_interpolator_warp", "[bilinear][bicubic][lanczos2]");
   WRAP_TRANSLATION(C_("preferences", "bilinear"));
   WRAP_TRANSLATION(C_("preferences", "bicubic"));
   WRAP_TRANSLATION(C_("preferences", "lanczos2"));
   _insert_default("plugins/lighttable/export/pixel_interpolator_warp", "bicubic");
   _insert_shortdescription("plugins/lighttable/export/pixel_interpolator_warp", "pixel interpolator (warp)");
   _insert_longdescription("plugins/lighttable/export/pixel_interpolator_warp", "pixel interpolator used in modules for rotation, lens correction, liquify, cropping and final scaling (bilinear, bicubic, lanczos2).");

   // plugins/lighttable/export/pixel_interpolator
   _insert_type("plugins/lighttable/export/pixel_interpolator", "enum");
   _insert_values("plugins/lighttable/export/pixel_interpolator", "[bilinear][bicubic][lanczos2][lanczos3]");
   WRAP_TRANSLATION(C_("preferences", "bilinear"));
   WRAP_TRANSLATION(C_("preferences", "bicubic"));
   WRAP_TRANSLATION(C_("preferences", "lanczos2"));
   WRAP_TRANSLATION(C_("preferences", "lanczos3"));
   _insert_default("plugins/lighttable/export/pixel_interpolator", "lanczos3");
   _insert_shortdescription("plugins/lighttable/export/pixel_interpolator", "pixel interpolator (scaling)");
   _insert_longdescription("plugins/lighttable/export/pixel_interpolator", "pixel interpolator used for scaling (bilinear, bicubic, lanczos2, lanczos3).");

   // plugins/lighttable/export/dimensions_type
   _insert_type("plugins/lighttable/export/dimensions_type", "int");
   _insert_default("plugins/lighttable/export/dimensions_type", "0");
   _insert_min("plugins/lighttable/export/dimensions_type", "0");
   _insert_shortdescription("plugins/lighttable/export/dimensions_type", "unit of the printing size");
   _insert_longdescription("plugins/lighttable/export/dimensions_type", "unit in which to input the image size.");

   // plugins/lighttable/export/print_dpi
   _insert_type("plugins/lighttable/export/print_dpi", "int");
   _insert_default("plugins/lighttable/export/print_dpi", "300");
   _insert_min("plugins/lighttable/export/print_dpi", "72");
   _insert_max("plugins/lighttable/export/print_dpi", "9600");
   _insert_shortdescription("plugins/lighttable/export/print_dpi", "DPI");
   _insert_longdescription("plugins/lighttable/export/print_dpi", "print resolusion in DPI.");

   // plugins/lighttable/export/width
   _insert_type("plugins/lighttable/export/width", "int");
   _insert_default("plugins/lighttable/export/width", "0");
   _insert_min("plugins/lighttable/export/width", "0");
   _insert_shortdescription("plugins/lighttable/export/width", "width of the exported image");
   _insert_longdescription("plugins/lighttable/export/width", "width of the exported image, or 0 if no scaling should be done.");

   // plugins/lighttable/export/height
   _insert_type("plugins/lighttable/export/height", "int");
   _insert_default("plugins/lighttable/export/height", "0");
   _insert_min("plugins/lighttable/export/height", "0");
   _insert_shortdescription("plugins/lighttable/export/height", "height of the exported image");
   _insert_longdescription("plugins/lighttable/export/height", "height of the exported image, or 0 if no scaling should be done.");

   // plugins/lighttable/export/storage_name
   _insert_type("plugins/lighttable/export/storage_name", "string");
   _insert_default("plugins/lighttable/export/storage_name", "disk");
   _insert_shortdescription("plugins/lighttable/export/storage_name", "");
   _insert_longdescription("plugins/lighttable/export/storage_name", "");

   // plugins/lighttable/export/format_name
   _insert_type("plugins/lighttable/export/format_name", "string");
   _insert_default("plugins/lighttable/export/format_name", "jpeg");
   _insert_shortdescription("plugins/lighttable/export/format_name", "");
   _insert_longdescription("plugins/lighttable/export/format_name", "");

   // plugins/lighttable/export/style
   _insert_type("plugins/lighttable/export/style", "string");
   _insert_default("plugins/lighttable/export/style", "");
   _insert_shortdescription("plugins/lighttable/export/style", "");
   _insert_longdescription("plugins/lighttable/export/style", "");

   // plugins/imageio/storage/disk/file_directory
   _insert_type("plugins/imageio/storage/disk/file_directory", "string");
   _insert_default("plugins/imageio/storage/disk/file_directory", "$(FILE_FOLDER)/darktable_exported/$(FILE_NAME)");
   _insert_shortdescription("plugins/imageio/storage/disk/file_directory", "");
   _insert_longdescription("plugins/imageio/storage/disk/file_directory", "");

   // plugins/imageio/storage/gallery/file_directory
   _insert_type("plugins/imageio/storage/gallery/file_directory", "string");
   _insert_default("plugins/imageio/storage/gallery/file_directory", "$(HOME)/darktable_gallery/img_$(SEQUENCE)");
   _insert_shortdescription("plugins/imageio/storage/gallery/file_directory", "");
   _insert_longdescription("plugins/imageio/storage/gallery/file_directory", "");

   // plugins/imageio/storage/gallery/title
   _insert_type("plugins/imageio/storage/gallery/title", "string");
   _insert_default("plugins/imageio/storage/gallery/title", "darktable gallery");
   _insert_shortdescription("plugins/imageio/storage/gallery/title", "");
   _insert_longdescription("plugins/imageio/storage/gallery/title", "");

   // context_help/use_default_url
   _insert_type("context_help/use_default_url", "boolean");
   _insert_default("context_help/use_default_url", "true");
   _insert_shortdescription("context_help/use_default_url", "");
   _insert_longdescription("context_help/use_default_url", "");

   // context_help/url
   _insert_type("context_help/url", "string");
   _insert_default("context_help/url", "https://docs.darktable.org/usermanual/");
   _insert_shortdescription("context_help/url", "");
   _insert_longdescription("context_help/url", "");

   // plugins/imageio/storage/email/client
   _insert_type("plugins/imageio/storage/email/client", "string");
   _insert_default("plugins/imageio/storage/email/client", "");
   _insert_shortdescription("plugins/imageio/storage/email/client", "client to use, this overrides detection of default client.");
   _insert_longdescription("plugins/imageio/storage/email/client", "");

   // plugins/imageio/storage/gphoto/id
   _insert_type("plugins/imageio/storage/gphoto/id", "string");
   _insert_default("plugins/imageio/storage/gphoto/id", "642055548087-n01fgvugnbns7a9jq8jfucjsn5l1t6so.apps.googleusercontent.com");
   _insert_shortdescription("plugins/imageio/storage/gphoto/id", "google photo client id");
   _insert_longdescription("plugins/imageio/storage/gphoto/id", "");

   // plugins/imageio/storage/gphoto/secret
   _insert_type("plugins/imageio/storage/gphoto/secret", "string");
   _insert_default("plugins/imageio/storage/gphoto/secret", "o29QcbsDWS5cauRqdmGdF3sP");
   _insert_shortdescription("plugins/imageio/storage/gphoto/secret", "google photo client secret");
   _insert_longdescription("plugins/imageio/storage/gphoto/secret", "");

   // plugins/imageio/format/pdf/size
   _insert_type("plugins/imageio/format/pdf/size", "string");
   _insert_default("plugins/imageio/format/pdf/size", "a4");
   _insert_shortdescription("plugins/imageio/format/pdf/size", "");
   _insert_longdescription("plugins/imageio/format/pdf/size", "");

   // plugins/imageio/format/pdf/border
   _insert_type("plugins/imageio/format/pdf/border", "string");
   _insert_default("plugins/imageio/format/pdf/border", "0 mm");
   _insert_shortdescription("plugins/imageio/format/pdf/border", "");
   _insert_longdescription("plugins/imageio/format/pdf/border", "");

   // plugins/imageio/format/pdf/dpi
   _insert_type("plugins/imageio/format/pdf/dpi", "float");
   _insert_default("plugins/imageio/format/pdf/dpi", "300");
   _insert_shortdescription("plugins/imageio/format/pdf/dpi", "");
   _insert_longdescription("plugins/imageio/format/pdf/dpi", "");

   // plugins/imageio/format/pdf/bpp
   _insert_type("plugins/imageio/format/pdf/bpp", "enum");
   _insert_values("plugins/imageio/format/pdf/bpp", "[8][16]");
   _insert_default("plugins/imageio/format/pdf/bpp", "8");
   _insert_shortdescription("plugins/imageio/format/pdf/bpp", "PDF bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/pdf/bpp", "");

   // plugins/imageio/format/pdf/compression
   _insert_type("plugins/imageio/format/pdf/compression", "int");
   _insert_default("plugins/imageio/format/pdf/compression", "1");
   _insert_shortdescription("plugins/imageio/format/pdf/compression", "");
   _insert_longdescription("plugins/imageio/format/pdf/compression", "");

   // plugins/imageio/format/exr/bpp
   _insert_type("plugins/imageio/format/exr/bpp", "enum");
   _insert_values("plugins/imageio/format/exr/bpp", "[16][32]");
   _insert_default("plugins/imageio/format/exr/bpp", "32");
   _insert_shortdescription("plugins/imageio/format/exr/bpp", "EXR float bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/exr/bpp", "");

   // plugins/imageio/format/exr/compression
   _insert_type("plugins/imageio/format/exr/compression", "int");
   _insert_default("plugins/imageio/format/exr/compression", "4");
   _insert_shortdescription("plugins/imageio/format/exr/compression", "");
   _insert_longdescription("plugins/imageio/format/exr/compression", "");

   // plugins/imageio/format/jpeg/quality
   _insert_type("plugins/imageio/format/jpeg/quality", "int");
   _insert_default("plugins/imageio/format/jpeg/quality", "95");
   _insert_min("plugins/imageio/format/jpeg/quality", "5");
   _insert_max("plugins/imageio/format/jpeg/quality", "100");
   _insert_shortdescription("plugins/imageio/format/jpeg/quality", "");
   _insert_longdescription("plugins/imageio/format/jpeg/quality", "");

   // plugins/imageio/format/j2k/quality
   _insert_type("plugins/imageio/format/j2k/quality", "int");
   _insert_default("plugins/imageio/format/j2k/quality", "95");
   _insert_min("plugins/imageio/format/j2k/quality", "5");
   _insert_max("plugins/imageio/format/j2k/quality", "100");
   _insert_shortdescription("plugins/imageio/format/j2k/quality", "");
   _insert_longdescription("plugins/imageio/format/j2k/quality", "");

   // plugins/imageio/format/tiff/bpp
   _insert_type("plugins/imageio/format/tiff/bpp", "enum");
   _insert_values("plugins/imageio/format/tiff/bpp", "[8][16][32]");
   _insert_default("plugins/imageio/format/tiff/bpp", "8");
   _insert_shortdescription("plugins/imageio/format/tiff/bpp", "TIFF bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/tiff/bpp", "");

   // plugins/imageio/format/tiff/pixelformat
   _insert_type("plugins/imageio/format/tiff/pixelformat", "bool");
   _insert_default("plugins/imageio/format/tiff/pixelformat", "false");
   _insert_shortdescription("plugins/imageio/format/tiff/pixelformat", "");
   _insert_longdescription("plugins/imageio/format/tiff/pixelformat", "");

   // plugins/imageio/format/tiff/compress
   _insert_type("plugins/imageio/format/tiff/compress", "int");
   _insert_default("plugins/imageio/format/tiff/compress", "2");
   _insert_min("plugins/imageio/format/tiff/compress", "0");
   _insert_max("plugins/imageio/format/tiff/compress", "2");
   _insert_shortdescription("plugins/imageio/format/tiff/compress", "");
   _insert_longdescription("plugins/imageio/format/tiff/compress", "");

   // plugins/imageio/format/tiff/compresslevel
   _insert_type("plugins/imageio/format/tiff/compresslevel", "int");
   _insert_default("plugins/imageio/format/tiff/compresslevel", "6");
   _insert_min("plugins/imageio/format/tiff/compresslevel", "1");
   _insert_max("plugins/imageio/format/tiff/compresslevel", "9");
   _insert_shortdescription("plugins/imageio/format/tiff/compresslevel", "");
   _insert_longdescription("plugins/imageio/format/tiff/compresslevel", "");

   // plugins/imageio/format/tiff/shortfile
   _insert_type("plugins/imageio/format/tiff/shortfile", "bool");
   _insert_default("plugins/imageio/format/tiff/shortfile", "false");
   _insert_shortdescription("plugins/imageio/format/tiff/shortfile", "");
   _insert_longdescription("plugins/imageio/format/tiff/shortfile", "");

   // plugins/imageio/format/png/bpp
   _insert_type("plugins/imageio/format/png/bpp", "enum");
   _insert_values("plugins/imageio/format/png/bpp", "[8][16]");
   _insert_default("plugins/imageio/format/png/bpp", "8");
   _insert_shortdescription("plugins/imageio/format/png/bpp", "PNG bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/png/bpp", "");

   // plugins/imageio/format/png/compression
   _insert_type("plugins/imageio/format/png/compression", "int");
   _insert_default("plugins/imageio/format/png/compression", "5");
   _insert_min("plugins/imageio/format/png/compression", "0");
   _insert_max("plugins/imageio/format/png/compression", "9");
   _insert_shortdescription("plugins/imageio/format/png/compression", "");
   _insert_longdescription("plugins/imageio/format/png/compression", "");

   // plugins/imageio/format/jxl/bpp
   _insert_type("plugins/imageio/format/jxl/bpp", "enum");
   _insert_values("plugins/imageio/format/jxl/bpp", "[8][10][12][16][32]");
   _insert_default("plugins/imageio/format/jxl/bpp", "8");
   _insert_shortdescription("plugins/imageio/format/jxl/bpp", "JPEG XL bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/jxl/bpp", "");

   // plugins/imageio/format/jxl/pixel_type
   _insert_type("plugins/imageio/format/jxl/pixel_type", "bool");
   _insert_default("plugins/imageio/format/jxl/pixel_type", "false");
   _insert_shortdescription("plugins/imageio/format/jxl/pixel_type", "");
   _insert_longdescription("plugins/imageio/format/jxl/pixel_type", "");

   // plugins/imageio/format/jxl/quality
   _insert_type("plugins/imageio/format/jxl/quality", "int");
   _insert_default("plugins/imageio/format/jxl/quality", "95");
   _insert_min("plugins/imageio/format/jxl/quality", "4");
   _insert_max("plugins/imageio/format/jxl/quality", "100");
   _insert_shortdescription("plugins/imageio/format/jxl/quality", "");
   _insert_longdescription("plugins/imageio/format/jxl/quality", "");

   // plugins/imageio/format/jxl/original
   _insert_type("plugins/imageio/format/jxl/original", "bool");
   _insert_default("plugins/imageio/format/jxl/original", "false");
   _insert_shortdescription("plugins/imageio/format/jxl/original", "");
   _insert_longdescription("plugins/imageio/format/jxl/original", "");

   // plugins/imageio/format/jxl/effort
   _insert_type("plugins/imageio/format/jxl/effort", "int");
   _insert_default("plugins/imageio/format/jxl/effort", "7");
   _insert_min("plugins/imageio/format/jxl/effort", "1");
   _insert_max("plugins/imageio/format/jxl/effort", "9");
   _insert_shortdescription("plugins/imageio/format/jxl/effort", "");
   _insert_longdescription("plugins/imageio/format/jxl/effort", "");

   // plugins/imageio/format/jxl/tier
   _insert_type("plugins/imageio/format/jxl/tier", "int");
   _insert_default("plugins/imageio/format/jxl/tier", "0");
   _insert_min("plugins/imageio/format/jxl/tier", "0");
   _insert_max("plugins/imageio/format/jxl/tier", "4");
   _insert_shortdescription("plugins/imageio/format/jxl/tier", "");
   _insert_longdescription("plugins/imageio/format/jxl/tier", "");

   // plugins/imageio/format/webp/comp_type
   _insert_type("plugins/imageio/format/webp/comp_type", "int");
   _insert_default("plugins/imageio/format/webp/comp_type", "0");
   _insert_min("plugins/imageio/format/webp/comp_type", "0");
   _insert_max("plugins/imageio/format/webp/comp_type", "1");
   _insert_shortdescription("plugins/imageio/format/webp/comp_type", "");
   _insert_longdescription("plugins/imageio/format/webp/comp_type", "");

   // plugins/imageio/format/webp/quality
   _insert_type("plugins/imageio/format/webp/quality", "int");
   _insert_default("plugins/imageio/format/webp/quality", "95");
   _insert_min("plugins/imageio/format/webp/quality", "0");
   _insert_max("plugins/imageio/format/webp/quality", "100");
   _insert_shortdescription("plugins/imageio/format/webp/quality", "");
   _insert_longdescription("plugins/imageio/format/webp/quality", "");

   // plugins/imageio/format/webp/hint
   _insert_type("plugins/imageio/format/webp/hint", "int");
   _insert_default("plugins/imageio/format/webp/hint", "0");
   _insert_shortdescription("plugins/imageio/format/webp/hint", "");
   _insert_longdescription("plugins/imageio/format/webp/hint", "");

   // plugins/imageio/format/avif/bpp
   _insert_type("plugins/imageio/format/avif/bpp", "enum");
   _insert_values("plugins/imageio/format/avif/bpp", "[8][10][12]");
   _insert_default("plugins/imageio/format/avif/bpp", "8");
   _insert_shortdescription("plugins/imageio/format/avif/bpp", "AVIF bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/avif/bpp", "");

   // plugins/imageio/format/avif/color_mode
   _insert_type("plugins/imageio/format/avif/color_mode", "bool");
   _insert_default("plugins/imageio/format/avif/color_mode", "false");
   _insert_shortdescription("plugins/imageio/format/avif/color_mode", "");
   _insert_longdescription("plugins/imageio/format/avif/color_mode", "");

   // plugins/imageio/format/avif/tiling
   _insert_type("plugins/imageio/format/avif/tiling", "bool");
   _insert_default("plugins/imageio/format/avif/tiling", "true");
   _insert_shortdescription("plugins/imageio/format/avif/tiling", "AVIF Tiling");
   _insert_longdescription("plugins/imageio/format/avif/tiling", "");

   // plugins/imageio/format/avif/compression_type
   _insert_type("plugins/imageio/format/avif/compression_type", "int");
   _insert_default("plugins/imageio/format/avif/compression_type", "1");
   _insert_min("plugins/imageio/format/avif/compression_type", "0");
   _insert_max("plugins/imageio/format/avif/compression_type", "1");
   _insert_shortdescription("plugins/imageio/format/avif/compression_type", "");
   _insert_longdescription("plugins/imageio/format/avif/compression_type", "");

   // plugins/imageio/format/avif/quality
   _insert_type("plugins/imageio/format/avif/quality", "int");
   _insert_default("plugins/imageio/format/avif/quality", "90");
   _insert_min("plugins/imageio/format/avif/quality", "0");
   _insert_max("plugins/imageio/format/avif/quality", "100");
   _insert_shortdescription("plugins/imageio/format/avif/quality", "");
   _insert_longdescription("plugins/imageio/format/avif/quality", "");

   // plugins/imageio/format/xcf/bpp
   _insert_type("plugins/imageio/format/xcf/bpp", "enum");
   _insert_values("plugins/imageio/format/xcf/bpp", "[8][16][32]");
   _insert_default("plugins/imageio/format/xcf/bpp", "32");
   _insert_shortdescription("plugins/imageio/format/xcf/bpp", "XCF bit depth (bpp)");
   _insert_longdescription("plugins/imageio/format/xcf/bpp", "");

   // plugins/pwstorage/pwstorage_backend
   _insert_type("plugins/pwstorage/pwstorage_backend", "enum");
   _insert_values("plugins/pwstorage/pwstorage_backend", "[auto][none][libsecret][kwallet]");
   WRAP_TRANSLATION(C_("preferences", "auto"));
   WRAP_TRANSLATION(C_("preferences", "none"));
   WRAP_TRANSLATION(C_("preferences", "libsecret"));
   WRAP_TRANSLATION(C_("preferences", "kwallet"));
   _insert_default("plugins/pwstorage/pwstorage_backend", "auto");
   _insert_shortdescription("plugins/pwstorage/pwstorage_backend", "password storage backend to use");
   _insert_longdescription("plugins/pwstorage/pwstorage_backend", "the storage backend for password storage: auto, none, libsecret, kwallet");

   // plugins/lighttable/export/icctype
   _insert_type("plugins/lighttable/export/icctype", "int");
   _insert_default("plugins/lighttable/export/icctype", "-1");
   _insert_shortdescription("plugins/lighttable/export/icctype", "ICC profile type to use for export");
   _insert_longdescription("plugins/lighttable/export/icctype", "this overrides the per-image settings, if not set to -1.");

   // plugins/lighttable/export/iccprofile
   _insert_type("plugins/lighttable/export/iccprofile", "string");
   _insert_default("plugins/lighttable/export/iccprofile", "");
   _insert_shortdescription("plugins/lighttable/export/iccprofile", "ICC profile filename to use for export");
   _insert_longdescription("plugins/lighttable/export/iccprofile", "this overrides the per-image settings, if icctype not set to -1.");

   // plugins/lighttable/export/iccintent
   _insert_type("plugins/lighttable/export/iccintent", "int");
   _insert_default("plugins/lighttable/export/iccintent", "-1");
   _insert_shortdescription("plugins/lighttable/export/iccintent", "ICC rendering intent");
   _insert_longdescription("plugins/lighttable/export/iccintent", "if non-negative, this overrides the per-image output color profile rendering intent on export.");

   // plugins/darkroom/groups
   _insert_type("plugins/darkroom/groups", "int");
   _insert_default("plugins/darkroom/groups", "2");
   _insert_shortdescription("plugins/darkroom/groups", "");
   _insert_longdescription("plugins/darkroom/groups", "");

   // plugins/darkroom/active
   _insert_type("plugins/darkroom/active", "string");
   _insert_default("plugins/darkroom/active", "");
   _insert_shortdescription("plugins/darkroom/active", "");
   _insert_longdescription("plugins/darkroom/active", "");

   // plugins/darkroom/spots/circle_size
   _insert_type("plugins/darkroom/spots/circle_size", "float");
   _insert_default("plugins/darkroom/spots/circle_size", "0.02");
   _insert_shortdescription("plugins/darkroom/spots/circle_size", "");
   _insert_longdescription("plugins/darkroom/spots/circle_size", "");

   // plugins/darkroom/spots/circle_border
   _insert_type("plugins/darkroom/spots/circle_border", "float");
   _insert_default("plugins/darkroom/spots/circle_border", "0.02");
   _insert_shortdescription("plugins/darkroom/spots/circle_border", "");
   _insert_longdescription("plugins/darkroom/spots/circle_border", "");

   // plugins/darkroom/spots/ellipse_radius_a
   _insert_type("plugins/darkroom/spots/ellipse_radius_a", "float");
   _insert_default("plugins/darkroom/spots/ellipse_radius_a", "0.02");
   _insert_shortdescription("plugins/darkroom/spots/ellipse_radius_a", "");
   _insert_longdescription("plugins/darkroom/spots/ellipse_radius_a", "");

   // plugins/darkroom/spots/ellipse_radius_b
   _insert_type("plugins/darkroom/spots/ellipse_radius_b", "float");
   _insert_default("plugins/darkroom/spots/ellipse_radius_b", "0.01414");
   _insert_shortdescription("plugins/darkroom/spots/ellipse_radius_b", "");
   _insert_longdescription("plugins/darkroom/spots/ellipse_radius_b", "");

   // plugins/darkroom/spots/ellipse_border
   _insert_type("plugins/darkroom/spots/ellipse_border", "float");
   _insert_default("plugins/darkroom/spots/ellipse_border", "0.02");
   _insert_shortdescription("plugins/darkroom/spots/ellipse_border", "");
   _insert_longdescription("plugins/darkroom/spots/ellipse_border", "");

   // plugins/darkroom/spots/ellipse_rotation
   _insert_type("plugins/darkroom/spots/ellipse_rotation", "float");
   _insert_default("plugins/darkroom/spots/ellipse_rotation", "90.0");
   _insert_shortdescription("plugins/darkroom/spots/ellipse_rotation", "");
   _insert_longdescription("plugins/darkroom/spots/ellipse_rotation", "");

   // plugins/darkroom/spots/ellipse_flags
   _insert_type("plugins/darkroom/spots/ellipse_flags", "int");
   _insert_default("plugins/darkroom/spots/ellipse_flags", "0");
   _insert_shortdescription("plugins/darkroom/spots/ellipse_flags", "");
   _insert_longdescription("plugins/darkroom/spots/ellipse_flags", "");

   // plugins/darkroom/spots/path_border
   _insert_type("plugins/darkroom/spots/path_border", "float");
   _insert_default("plugins/darkroom/spots/path_border", "0.05");
   _insert_shortdescription("plugins/darkroom/spots/path_border", "");
   _insert_longdescription("plugins/darkroom/spots/path_border", "");

   // plugins/darkroom/spots/brush_border
   _insert_type("plugins/darkroom/spots/brush_border", "float");
   _insert_default("plugins/darkroom/spots/brush_border", "0.05");
   _insert_shortdescription("plugins/darkroom/spots/brush_border", "");
   _insert_longdescription("plugins/darkroom/spots/brush_border", "");

   // plugins/darkroom/spots/brush_density
   _insert_type("plugins/darkroom/spots/brush_density", "float");
   _insert_default("plugins/darkroom/spots/brush_density", "1.0");
   _insert_shortdescription("plugins/darkroom/spots/brush_density", "");
   _insert_longdescription("plugins/darkroom/spots/brush_density", "");

   // plugins/darkroom/spots/brush_hardness
   _insert_type("plugins/darkroom/spots/brush_hardness", "float");
   _insert_default("plugins/darkroom/spots/brush_hardness", "0.66");
   _insert_shortdescription("plugins/darkroom/spots/brush_hardness", "");
   _insert_longdescription("plugins/darkroom/spots/brush_hardness", "");

   // plugins/darkroom/clipping/ratio_d
   _insert_type("plugins/darkroom/clipping/ratio_d", "int");
   _insert_default("plugins/darkroom/clipping/ratio_d", "0");
   _insert_shortdescription("plugins/darkroom/clipping/ratio_d", "last chosen aspect ratio denominator");
   _insert_longdescription("plugins/darkroom/clipping/ratio_d", "");

   // plugins/darkroom/clipping/ratio_n
   _insert_type("plugins/darkroom/clipping/ratio_n", "int");
   _insert_default("plugins/darkroom/clipping/ratio_n", "0");
   _insert_shortdescription("plugins/darkroom/clipping/ratio_n", "last chosen aspect ratio numerator");
   _insert_longdescription("plugins/darkroom/clipping/ratio_n", "");

   // plugins/darkroom/clipping/guide
   _insert_type("plugins/darkroom/clipping/guide", "int");
   _insert_default("plugins/darkroom/clipping/guide", "0");
   _insert_shortdescription("plugins/darkroom/clipping/guide", "last chosen guide style");
   _insert_longdescription("plugins/darkroom/clipping/guide", "");

   // plugins/darkroom/histogram/aspect_percent
   _insert_type("plugins/darkroom/histogram/aspect_percent", "int");
   _insert_default("plugins/darkroom/histogram/aspect_percent", "56");
   _insert_min("plugins/darkroom/histogram/aspect_percent", "50");
   _insert_max("plugins/darkroom/histogram/aspect_percent", "150");
   _insert_shortdescription("plugins/darkroom/histogram/aspect_percent", "aspect ratio of the scopes module");
   _insert_longdescription("plugins/darkroom/histogram/aspect_percent", "aspect ratio of the scopes module in the darkroom and tethering views");

   // plugins/darkroom/navigation/aspect_percent
   _insert_type("plugins/darkroom/navigation/aspect_percent", "int");
   _insert_default("plugins/darkroom/navigation/aspect_percent", "56");
   _insert_min("plugins/darkroom/navigation/aspect_percent", "50");
   _insert_max("plugins/darkroom/navigation/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/navigation/aspect_percent", "aspect ratio of the navigation module");
   _insert_longdescription("plugins/darkroom/navigation/aspect_percent", "aspect ratio of the navigation module in the darkroom");

   // plugins/darkroom/atrous/aspect_percent
   _insert_type("plugins/darkroom/atrous/aspect_percent", "int");
   _insert_default("plugins/darkroom/atrous/aspect_percent", "56");
   _insert_min("plugins/darkroom/atrous/aspect_percent", "50");
   _insert_max("plugins/darkroom/atrous/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/atrous/aspect_percent", "aspect ratio of contrast equalizer gui in per cent");
   _insert_longdescription("plugins/darkroom/atrous/aspect_percent", "aspect ratio of contrast equalizer gui in per cent");

   // plugins/darkroom/denoiseprofile/aspect_percent
   _insert_type("plugins/darkroom/denoiseprofile/aspect_percent", "int");
   _insert_default("plugins/darkroom/denoiseprofile/aspect_percent", "56");
   _insert_min("plugins/darkroom/denoiseprofile/aspect_percent", "50");
   _insert_max("plugins/darkroom/denoiseprofile/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/denoiseprofile/aspect_percent", "aspect ratio of denoise (profiled) wavelets gui in per cent");
   _insert_longdescription("plugins/darkroom/denoiseprofile/aspect_percent", "aspect ratio of denoise (profiled) wavelets gui in per cent");

   // plugins/darkroom/rawdenoise/aspect_percent
   _insert_type("plugins/darkroom/rawdenoise/aspect_percent", "int");
   _insert_default("plugins/darkroom/rawdenoise/aspect_percent", "56");
   _insert_min("plugins/darkroom/rawdenoise/aspect_percent", "50");
   _insert_max("plugins/darkroom/rawdenoise/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/rawdenoise/aspect_percent", "aspect ratio of raw denoise wavelets gui in per cent");
   _insert_longdescription("plugins/darkroom/rawdenoise/aspect_percent", "aspect ratio of raw denoise wavelets gui in per cent");

   // plugins/darkroom/colorzones/aspect_percent
   _insert_type("plugins/darkroom/colorzones/aspect_percent", "int");
   _insert_default("plugins/darkroom/colorzones/aspect_percent", "56");
   _insert_min("plugins/darkroom/colorzones/aspect_percent", "50");
   _insert_max("plugins/darkroom/colorzones/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/colorzones/aspect_percent", "aspect ratio of color zones graph in per cent");
   _insert_longdescription("plugins/darkroom/colorzones/aspect_percent", "aspect ratio of color zones graph in per cent");

   // plugins/darkroom/lowlight/aspect_percent
   _insert_type("plugins/darkroom/lowlight/aspect_percent", "int");
   _insert_default("plugins/darkroom/lowlight/aspect_percent", "56");
   _insert_min("plugins/darkroom/lowlight/aspect_percent", "50");
   _insert_max("plugins/darkroom/lowlight/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/lowlight/aspect_percent", "aspect ratio of lowlight graph in per cent");
   _insert_longdescription("plugins/darkroom/lowlight/aspect_percent", "aspect ratio of lowlight graph in per cent");

   // plugins/darkroom/levels/aspect_percent
   _insert_type("plugins/darkroom/levels/aspect_percent", "int");
   _insert_default("plugins/darkroom/levels/aspect_percent", "56");
   _insert_min("plugins/darkroom/levels/aspect_percent", "25");
   _insert_max("plugins/darkroom/levels/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/levels/aspect_percent", "aspect ratio of levels graph in per cent");
   _insert_longdescription("plugins/darkroom/levels/aspect_percent", "aspect ratio of levels graph in per cent");

   // plugins/darkroom/rgblevels/aspect_percent
   _insert_type("plugins/darkroom/rgblevels/aspect_percent", "int");
   _insert_default("plugins/darkroom/rgblevels/aspect_percent", "56");
   _insert_min("plugins/darkroom/rgblevels/aspect_percent", "25");
   _insert_max("plugins/darkroom/rgblevels/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/rgblevels/aspect_percent", "aspect ratio of rgb levels graph in per cent");
   _insert_longdescription("plugins/darkroom/rgblevels/aspect_percent", "aspect ratio of rgb levels graph in per cent");

   // plugins/darkroom/filmicrgb/aspect_percent
   _insert_type("plugins/darkroom/filmicrgb/aspect_percent", "int");
   _insert_default("plugins/darkroom/filmicrgb/aspect_percent", "56");
   _insert_min("plugins/darkroom/filmicrgb/aspect_percent", "50");
   _insert_max("plugins/darkroom/filmicrgb/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/filmicrgb/aspect_percent", "aspect ratio of filmic rgb graph in per cent");
   _insert_longdescription("plugins/darkroom/filmicrgb/aspect_percent", "aspect ratio of filmic rgb graph in per cent");

   // plugins/darkroom/colorbalancergb/aspect_percent
   _insert_type("plugins/darkroom/colorbalancergb/aspect_percent", "int");
   _insert_default("plugins/darkroom/colorbalancergb/aspect_percent", "56");
   _insert_min("plugins/darkroom/colorbalancergb/aspect_percent", "50");
   _insert_max("plugins/darkroom/colorbalancergb/aspect_percent", "100");
   _insert_shortdescription("plugins/darkroom/colorbalancergb/aspect_percent", "aspect ratio of color balance rgb graph in per cent");
   _insert_longdescription("plugins/darkroom/colorbalancergb/aspect_percent", "aspect ratio of color balance rgb graph in per cent");

   // plugins/darkroom/histogram/mode
   _insert_type("plugins/darkroom/histogram/mode", "enum");
   _insert_values("plugins/darkroom/histogram/mode", "[vectorscope][waveform][RGB parade][histogram]");
   WRAP_TRANSLATION(C_("preferences", "vectorscope"));
   WRAP_TRANSLATION(C_("preferences", "waveform"));
   WRAP_TRANSLATION(C_("preferences", "RGB parade"));
   WRAP_TRANSLATION(C_("preferences", "histogram"));
   _insert_default("plugins/darkroom/histogram/mode", "histogram");
   _insert_shortdescription("plugins/darkroom/histogram/mode", "");
   _insert_longdescription("plugins/darkroom/histogram/mode", "");

   // plugins/darkroom/histogram/panel_position
   _insert_type("plugins/darkroom/histogram/panel_position", "enum");
   _insert_values("plugins/darkroom/histogram/panel_position", "[left][right]");
   WRAP_TRANSLATION(C_("preferences", "left"));
   WRAP_TRANSLATION(C_("preferences", "right"));
   _insert_default("plugins/darkroom/histogram/panel_position", "right");
   _insert_shortdescription("plugins/darkroom/histogram/panel_position", "position of the scopes module");
   _insert_longdescription("plugins/darkroom/histogram/panel_position", "position the scopes at the top-left or top-right of the screen");

   // plugins/darkroom/histogram/histogram
   _insert_type("plugins/darkroom/histogram/histogram", "enum");
   _insert_values("plugins/darkroom/histogram/histogram", "[logarithmic][linear]");
   WRAP_TRANSLATION(C_("preferences", "logarithmic"));
   WRAP_TRANSLATION(C_("preferences", "linear"));
   _insert_default("plugins/darkroom/histogram/histogram", "logarithmic");
   _insert_shortdescription("plugins/darkroom/histogram/histogram", "");
   _insert_longdescription("plugins/darkroom/histogram/histogram", "");

   // plugins/darkroom/histogram/orient
   _insert_type("plugins/darkroom/histogram/orient", "enum");
   _insert_values("plugins/darkroom/histogram/orient", "[horizontal][vertical]");
   WRAP_TRANSLATION(C_("preferences", "horizontal"));
   WRAP_TRANSLATION(C_("preferences", "vertical"));
   _insert_default("plugins/darkroom/histogram/orient", "horizontal");
   _insert_shortdescription("plugins/darkroom/histogram/orient", "");
   _insert_longdescription("plugins/darkroom/histogram/orient", "");

   // plugins/darkroom/histogram/waveform
   _insert_type("plugins/darkroom/histogram/waveform", "enum");
   _insert_values("plugins/darkroom/histogram/waveform", "[overlaid][parade]");
   WRAP_TRANSLATION(C_("preferences", "overlaid"));
   WRAP_TRANSLATION(C_("preferences", "parade"));
   _insert_default("plugins/darkroom/histogram/waveform", "overlaid");
   _insert_shortdescription("plugins/darkroom/histogram/waveform", "");
   _insert_longdescription("plugins/darkroom/histogram/waveform", "");

   // plugins/darkroom/histogram/vectorscope
   _insert_type("plugins/darkroom/histogram/vectorscope", "enum");
   _insert_values("plugins/darkroom/histogram/vectorscope", "[u*v*][AzBz][RYB]");
   WRAP_TRANSLATION(C_("preferences", "u*v*"));
   WRAP_TRANSLATION(C_("preferences", "AzBz"));
   WRAP_TRANSLATION(C_("preferences", "RYB"));
   _insert_default("plugins/darkroom/histogram/vectorscope", "u*v*");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope", "");

   // plugins/darkroom/histogram/vectorscope/scale
   _insert_type("plugins/darkroom/histogram/vectorscope/scale", "enum");
   _insert_values("plugins/darkroom/histogram/vectorscope/scale", "[logarithmic][linear]");
   WRAP_TRANSLATION(C_("preferences", "logarithmic"));
   WRAP_TRANSLATION(C_("preferences", "linear"));
   _insert_default("plugins/darkroom/histogram/vectorscope/scale", "logarithmic");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/scale", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/scale", "");

   // plugins/darkroom/histogram/vectorscope/angle
   _insert_type("plugins/darkroom/histogram/vectorscope/angle", "int");
   _insert_default("plugins/darkroom/histogram/vectorscope/angle", "270");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/angle", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/angle", "Angle in degrees to orient the vectorscope. 0 is the color science proper orientation (see CIE 1976 UCS diagram). 270 is what video editors are used to when using a vectorscope (with red/magenta in 12:00 position).");

   // plugins/darkroom/histogram/show_red
   _insert_type("plugins/darkroom/histogram/show_red", "bool");
   _insert_default("plugins/darkroom/histogram/show_red", "true");
   _insert_shortdescription("plugins/darkroom/histogram/show_red", "");
   _insert_longdescription("plugins/darkroom/histogram/show_red", "");

   // plugins/darkroom/histogram/show_green
   _insert_type("plugins/darkroom/histogram/show_green", "bool");
   _insert_default("plugins/darkroom/histogram/show_green", "true");
   _insert_shortdescription("plugins/darkroom/histogram/show_green", "");
   _insert_longdescription("plugins/darkroom/histogram/show_green", "");

   // plugins/darkroom/histogram/show_blue
   _insert_type("plugins/darkroom/histogram/show_blue", "bool");
   _insert_default("plugins/darkroom/histogram/show_blue", "true");
   _insert_shortdescription("plugins/darkroom/histogram/show_blue", "");
   _insert_longdescription("plugins/darkroom/histogram/show_blue", "");

   // plugins/darkroom/histogram/vectorscope/harmony_type
   _insert_type("plugins/darkroom/histogram/vectorscope/harmony_type", "enum");
   _insert_values("plugins/darkroom/histogram/vectorscope/harmony_type", "[none][monochromatic][analogous][analogous complementary][complementary][split complementary][dyad][triad][tetrad][square]");
   WRAP_TRANSLATION(C_("preferences", "none"));
   WRAP_TRANSLATION(C_("preferences", "monochromatic"));
   WRAP_TRANSLATION(C_("preferences", "analogous"));
   WRAP_TRANSLATION(C_("preferences", "analogous complementary"));
   WRAP_TRANSLATION(C_("preferences", "complementary"));
   WRAP_TRANSLATION(C_("preferences", "split complementary"));
   WRAP_TRANSLATION(C_("preferences", "dyad"));
   WRAP_TRANSLATION(C_("preferences", "triad"));
   WRAP_TRANSLATION(C_("preferences", "tetrad"));
   WRAP_TRANSLATION(C_("preferences", "square"));
   _insert_default("plugins/darkroom/histogram/vectorscope/harmony_type", "none");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/harmony_type", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/harmony_type", "");

   // plugins/darkroom/histogram/vectorscope/harmony_rotation
   _insert_type("plugins/darkroom/histogram/vectorscope/harmony_rotation", "int");
   _insert_default("plugins/darkroom/histogram/vectorscope/harmony_rotation", "0");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/harmony_rotation", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/harmony_rotation", "");

   // plugins/darkroom/histogram/vectorscope/harmony_width
   _insert_type("plugins/darkroom/histogram/vectorscope/harmony_width", "enum");
   _insert_values("plugins/darkroom/histogram/vectorscope/harmony_width", "[normal][large][narrow][line]");
   WRAP_TRANSLATION(C_("preferences", "normal"));
   WRAP_TRANSLATION(C_("preferences", "large"));
   WRAP_TRANSLATION(C_("preferences", "narrow"));
   WRAP_TRANSLATION(C_("preferences", "line"));
   _insert_default("plugins/darkroom/histogram/vectorscope/harmony_width", "normal");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/harmony_width", "");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/harmony_width", "");

   // plugins/darkroom/histogram/vectorscope/harmony/dim
   _insert_type("plugins/darkroom/histogram/vectorscope/harmony/dim", "float");
   _insert_default("plugins/darkroom/histogram/vectorscope/harmony/dim", "0.7");
   _insert_min("plugins/darkroom/histogram/vectorscope/harmony/dim", "0");
   _insert_max("plugins/darkroom/histogram/vectorscope/harmony/dim", "1");
   _insert_shortdescription("plugins/darkroom/histogram/vectorscope/harmony/dim", "dim pixels outside of guides");
   _insert_longdescription("plugins/darkroom/histogram/vectorscope/harmony/dim", "");

   // plugins/darkroom/masks/opacity
   _insert_type("plugins/darkroom/masks/opacity", "float");
   _insert_default("plugins/darkroom/masks/opacity", "1.0");
   _insert_shortdescription("plugins/darkroom/masks/opacity", "");
   _insert_longdescription("plugins/darkroom/masks/opacity", "");

   // plugins/darkroom/masks/circle/size
   _insert_type("plugins/darkroom/masks/circle/size", "float");
   _insert_default("plugins/darkroom/masks/circle/size", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/circle/size", "");
   _insert_longdescription("plugins/darkroom/masks/circle/size", "");

   // plugins/darkroom/masks/circle/border
   _insert_type("plugins/darkroom/masks/circle/border", "float");
   _insert_default("plugins/darkroom/masks/circle/border", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/circle/border", "");
   _insert_longdescription("plugins/darkroom/masks/circle/border", "");

   // plugins/darkroom/masks/ellipse/radius_a
   _insert_type("plugins/darkroom/masks/ellipse/radius_a", "float");
   _insert_default("plugins/darkroom/masks/ellipse/radius_a", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/ellipse/radius_a", "");
   _insert_longdescription("plugins/darkroom/masks/ellipse/radius_a", "");

   // plugins/darkroom/masks/ellipse/radius_b
   _insert_type("plugins/darkroom/masks/ellipse/radius_b", "float");
   _insert_default("plugins/darkroom/masks/ellipse/radius_b", "0.03535");
   _insert_shortdescription("plugins/darkroom/masks/ellipse/radius_b", "");
   _insert_longdescription("plugins/darkroom/masks/ellipse/radius_b", "");

   // plugins/darkroom/masks/ellipse/border
   _insert_type("plugins/darkroom/masks/ellipse/border", "float");
   _insert_default("plugins/darkroom/masks/ellipse/border", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/ellipse/border", "");
   _insert_longdescription("plugins/darkroom/masks/ellipse/border", "");

   // plugins/darkroom/masks/ellipse/rotation
   _insert_type("plugins/darkroom/masks/ellipse/rotation", "float");
   _insert_default("plugins/darkroom/masks/ellipse/rotation", "90.0");
   _insert_shortdescription("plugins/darkroom/masks/ellipse/rotation", "");
   _insert_longdescription("plugins/darkroom/masks/ellipse/rotation", "");

   // plugins/darkroom/masks/ellipse/flags
   _insert_type("plugins/darkroom/masks/ellipse/flags", "int");
   _insert_default("plugins/darkroom/masks/ellipse/flags", "0");
   _insert_shortdescription("plugins/darkroom/masks/ellipse/flags", "");
   _insert_longdescription("plugins/darkroom/masks/ellipse/flags", "");

   // plugins/darkroom/masks/path/border
   _insert_type("plugins/darkroom/masks/path/border", "float");
   _insert_default("plugins/darkroom/masks/path/border", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/path/border", "");
   _insert_longdescription("plugins/darkroom/masks/path/border", "");

   // plugins/darkroom/masks/gradient/rotation
   _insert_type("plugins/darkroom/masks/gradient/rotation", "float");
   _insert_default("plugins/darkroom/masks/gradient/rotation", "0.0");
   _insert_shortdescription("plugins/darkroom/masks/gradient/rotation", "");
   _insert_longdescription("plugins/darkroom/masks/gradient/rotation", "");

   // plugins/darkroom/masks/gradient/compression
   _insert_type("plugins/darkroom/masks/gradient/compression", "float");
   _insert_default("plugins/darkroom/masks/gradient/compression", "0.5");
   _insert_shortdescription("plugins/darkroom/masks/gradient/compression", "");
   _insert_longdescription("plugins/darkroom/masks/gradient/compression", "");

   // plugins/darkroom/masks/gradient/steepness
   _insert_type("plugins/darkroom/masks/gradient/steepness", "float");
   _insert_default("plugins/darkroom/masks/gradient/steepness", "0.0");
   _insert_shortdescription("plugins/darkroom/masks/gradient/steepness", "");
   _insert_longdescription("plugins/darkroom/masks/gradient/steepness", "");

   // plugins/darkroom/masks/brush/border
   _insert_type("plugins/darkroom/masks/brush/border", "float");
   _insert_default("plugins/darkroom/masks/brush/border", "0.05");
   _insert_shortdescription("plugins/darkroom/masks/brush/border", "");
   _insert_longdescription("plugins/darkroom/masks/brush/border", "");

   // plugins/darkroom/masks/brush/density
   _insert_type("plugins/darkroom/masks/brush/density", "float");
   _insert_default("plugins/darkroom/masks/brush/density", "1.0");
   _insert_shortdescription("plugins/darkroom/masks/brush/density", "");
   _insert_longdescription("plugins/darkroom/masks/brush/density", "");

   // plugins/darkroom/masks/brush/hardness
   _insert_type("plugins/darkroom/masks/brush/hardness", "float");
   _insert_default("plugins/darkroom/masks/brush/hardness", "0.66");
   _insert_shortdescription("plugins/darkroom/masks/brush/hardness", "");
   _insert_longdescription("plugins/darkroom/masks/brush/hardness", "");

   // plugins/darkroom/masks/heightview
   _insert_type("plugins/darkroom/masks/heightview", "int");
   _insert_default("plugins/darkroom/masks/heightview", "300");
   _insert_min("plugins/darkroom/masks/heightview", "100");
   _insert_max("plugins/darkroom/masks/heightview", "1000");
   _insert_shortdescription("plugins/darkroom/masks/heightview", "height of mask manager view window");
   _insert_longdescription("plugins/darkroom/masks/heightview", "maximum height the masks view in darkroom will grow to before scrolling");

   // plugins/darkroom/ashift/near_delta
   _insert_type("plugins/darkroom/ashift/near_delta", "float");
   _insert_default("plugins/darkroom/ashift/near_delta", "20.0");
   _insert_shortdescription("plugins/darkroom/ashift/near_delta", "");
   _insert_longdescription("plugins/darkroom/ashift/near_delta", "");

   // plugins/darkroom/ashift/near_delta_draw
   _insert_type("plugins/darkroom/ashift/near_delta_draw", "float");
   _insert_default("plugins/darkroom/ashift/near_delta_draw", "5.0");
   _insert_shortdescription("plugins/darkroom/ashift/near_delta_draw", "");
   _insert_longdescription("plugins/darkroom/ashift/near_delta_draw", "");

   // plugins/print/print/black_point_compensation
   _insert_type("plugins/print/print/black_point_compensation", "bool");
   _insert_default("plugins/print/print/black_point_compensation", "true");
   _insert_shortdescription("plugins/print/print/black_point_compensation", "");
   _insert_longdescription("plugins/print/print/black_point_compensation", "");

   // plugins/print/print/grid_size
   _insert_type("plugins/print/print/grid_size", "float");
   _insert_default("plugins/print/print/grid_size", "10");
   _insert_min("plugins/print/print/grid_size", "0");
   _insert_max("plugins/print/print/grid_size", "100");
   _insert_shortdescription("plugins/print/print/grid_size", "");
   _insert_longdescription("plugins/print/print/grid_size", "");

   // plugins/print/print/unit
   _insert_type("plugins/print/print/unit", "enum");
   _insert_values("plugins/print/print/unit", "[mm][cm][inch]");
   WRAP_TRANSLATION(C_("preferences", "mm"));
   WRAP_TRANSLATION(C_("preferences", "cm"));
   WRAP_TRANSLATION(C_("preferences", "inch"));
   _insert_default("plugins/print/print/unit", "mm");
   _insert_shortdescription("plugins/print/print/unit", "measurement units");
   _insert_longdescription("plugins/print/print/unit", "");

   // plugins/print/print/top_margin
   _insert_type("plugins/print/print/top_margin", "float");
   _insert_default("plugins/print/print/top_margin", "17");
   _insert_min("plugins/print/print/top_margin", "-50");
   _insert_max("plugins/print/print/top_margin", "500");
   _insert_shortdescription("plugins/print/print/top_margin", "");
   _insert_longdescription("plugins/print/print/top_margin", "");

   // plugins/print/print/bottom_margin
   _insert_type("plugins/print/print/bottom_margin", "float");
   _insert_default("plugins/print/print/bottom_margin", "17");
   _insert_min("plugins/print/print/bottom_margin", "-50");
   _insert_max("plugins/print/print/bottom_margin", "500");
   _insert_shortdescription("plugins/print/print/bottom_margin", "");
   _insert_longdescription("plugins/print/print/bottom_margin", "");

   // plugins/print/print/left_margin
   _insert_type("plugins/print/print/left_margin", "float");
   _insert_default("plugins/print/print/left_margin", "17");
   _insert_min("plugins/print/print/left_margin", "-50");
   _insert_max("plugins/print/print/left_margin", "500");
   _insert_shortdescription("plugins/print/print/left_margin", "");
   _insert_longdescription("plugins/print/print/left_margin", "");

   // plugins/print/print/right_margin
   _insert_type("plugins/print/print/right_margin", "float");
   _insert_default("plugins/print/print/right_margin", "17");
   _insert_min("plugins/print/print/right_margin", "-50");
   _insert_max("plugins/print/print/right_margin", "500");
   _insert_shortdescription("plugins/print/print/right_margin", "");
   _insert_longdescription("plugins/print/print/right_margin", "");

   // ui_last/theme
   _insert_type("ui_last/theme", "string");
   _insert_default("ui_last/theme", "darktable-elegant-grey");
   _insert_shortdescription("ui_last/theme", "darktable theme");

   // ui_last/display_profile_source
   _insert_type("ui_last/display_profile_source", "enum");
   _insert_values("ui_last/display_profile_source", "[all][xatom][colord]");
   WRAP_TRANSLATION(C_("preferences", "all"));
   WRAP_TRANSLATION(C_("preferences", "xatom"));
   WRAP_TRANSLATION(C_("preferences", "colord"));
   _insert_default("ui_last/display_profile_source", "all");
   _insert_shortdescription("ui_last/display_profile_source", "method to use for getting the display profile");
   _insert_longdescription("ui_last/display_profile_source", "this option allows to force a specific means of getting the current display profile.\nthis is useful when one alternative gives wrong results");

   // metadata/resolution
   _insert_type("metadata/resolution", "int");
   _insert_default("metadata/resolution", "300");
   _insert_min("metadata/resolution", "72");
   _insert_max("metadata/resolution", "9600");
   _insert_shortdescription("metadata/resolution", "DPI value for exported files");
   _insert_longdescription("metadata/resolution", "");

   // run_crawler_on_start
   _insert_type("run_crawler_on_start", "bool");
   _insert_default("run_crawler_on_start", "false");
   _insert_shortdescription("run_crawler_on_start", "look for updated XMP files on startup");
   _insert_longdescription("run_crawler_on_start", "check file modification times of all XMP files on startup to check if any got updated in the meantime");

   // plugins/lighttable/audio_player
   _insert_type("plugins/lighttable/audio_player", "string");
   _insert_default("plugins/lighttable/audio_player", "aplay");
   _insert_shortdescription("plugins/lighttable/audio_player", "executable for playing audio files");
   _insert_longdescription("plugins/lighttable/audio_player", "this external program is used to play audio files some cameras record to keep notes for images");

   // plugins/darkroom/lut3d/def_path
   _insert_type("plugins/darkroom/lut3d/def_path", "dir");
   {
      gchar *default_path = dt_conf_expand_default_dir("$(home)");
      _insert_default("plugins/darkroom/lut3d/def_path", default_path);
      g_free(default_path);
   }
   _insert_shortdescription("plugins/darkroom/lut3d/def_path", "LUT 3D root folder");
   _insert_longdescription("plugins/darkroom/lut3d/def_path", "this folder (and sub-folders) contains LUT files used by LUT 3D module. (need a restart).");

   // plugins/darkroom/workflow
   _insert_type("plugins/darkroom/workflow", "enum");
   _insert_values("plugins/darkroom/workflow", "[scene-referred (filmic)][scene-referred (sigmoid)][display-referred (legacy)][none]");
   WRAP_TRANSLATION(C_("preferences", "scene-referred (filmic)"));
   WRAP_TRANSLATION(C_("preferences", "scene-referred (sigmoid)"));
   WRAP_TRANSLATION(C_("preferences", "display-referred (legacy)"));
   WRAP_TRANSLATION(C_("preferences", "none"));
   _insert_default("plugins/darkroom/workflow", "scene-referred (filmic)");
   _insert_shortdescription("plugins/darkroom/workflow", "auto-apply pixel workflow defaults");
   _insert_longdescription("plugins/darkroom/workflow", "scene-referred workflow is based on linear modules and will auto-apply filmic or sigmoid, color calibration and exposure,\ndisplay-referred workflow is based on Lab modules and will auto-apply base curve, white balance and the legacy module pipe order.");

   // plugins/darkroom/basecurve/auto_apply_percamera_presets
   _insert_type("plugins/darkroom/basecurve/auto_apply_percamera_presets", "bool");
   _insert_default("plugins/darkroom/basecurve/auto_apply_percamera_presets", "false");
   _insert_shortdescription("plugins/darkroom/basecurve/auto_apply_percamera_presets", "auto-apply per camera basecurve presets");
   _insert_longdescription("plugins/darkroom/basecurve/auto_apply_percamera_presets", "use the per-camera basecurve by default instead of the generic manufacturer one if there is one available (needs a restart).\nthis option is taken into account when the \"auto-apply pixel workflow defaults\" is set to \"display-referred\".\nto prevent auto-apply basecurve presets \"auto-apply pixel workflow defaults\" should be set to \"none\"");

   // ui/detect_mono_exif
   _insert_type("ui/detect_mono_exif", "bool");
   _insert_default("ui/detect_mono_exif", "false");
   _insert_shortdescription("ui/detect_mono_exif", "detect monochrome previews");
   _insert_longdescription("ui/detect_mono_exif", "many monochrome images can be identified via EXIF and preview data. beware: this slows down imports and reading of EXIF data");

   // plugins/darkroom/show_warnings
   _insert_type("plugins/darkroom/show_warnings", "bool");
   _insert_default("plugins/darkroom/show_warnings", "true");
   _insert_shortdescription("plugins/darkroom/show_warnings", "show warning messages");
   _insert_longdescription("plugins/darkroom/show_warnings", "display messages in modules to warn beginner users when non-standard and possibly harmful settings are used in the pipeline.\nthese messages can be false-positive and should be disregarded if you know what you are doing. this option will hide them all the time.");

   // screen_dpi_overwrite
   _insert_type("screen_dpi_overwrite", "float");
   _insert_default("screen_dpi_overwrite", "-1.0");
   _insert_shortdescription("screen_dpi_overwrite", "overwrite the screen's dpi setting");
   _insert_longdescription("screen_dpi_overwrite", "if this value is > 0.0 then it is used as the screen's dpi setting which is used to scale the gui");

   // plugins/lighttable/preview/max_in_memory_images
   _insert_type("plugins/lighttable/preview/max_in_memory_images", "int");
   _insert_default("plugins/lighttable/preview/max_in_memory_images", "4");
   _insert_shortdescription("plugins/lighttable/preview/max_in_memory_images", "maximum number of full-res images to load in memory");
   _insert_longdescription("plugins/lighttable/preview/max_in_memory_images", "if more images are display in expose mode, zooming will be deactivated");

   // codepaths/openmp_simd
   _insert_type("codepaths/openmp_simd", "bool");
   _insert_default("codepaths/openmp_simd", "false");
   _insert_shortdescription("codepaths/openmp_simd", "enable usage of OpenMP SIMD codepaths. if enabled, and such codepath exists, it will have the highest priority");
   _insert_longdescription("codepaths/openmp_simd", "");

   // allow_lab_output
   _insert_type("allow_lab_output", "bool");
   _insert_default("allow_lab_output", "false");
   _insert_shortdescription("allow_lab_output", "allow XYZ and Lab color spaces as output");
   _insert_longdescription("allow_lab_output", "this is mainly useful for debugging and to create colorchecker LUT styles externally.");

   // plugins/darkroom/rawprepare/allow_editing_crop
   _insert_type("plugins/darkroom/rawprepare/allow_editing_crop", "bool");
   _insert_default("plugins/darkroom/rawprepare/allow_editing_crop", "false");
   _insert_shortdescription("plugins/darkroom/rawprepare/allow_editing_crop", "allow editing raw cropping boundaries");
   _insert_longdescription("plugins/darkroom/rawprepare/allow_editing_crop", "this is mainly useful for debugging and to add new camera support.");

   // darkroom/modules/exposure/lightness
   _insert_type("darkroom/modules/exposure/lightness", "float");
   _insert_default("darkroom/modules/exposure/lightness", "50.0");
   _insert_shortdescription("darkroom/modules/exposure/lightness", "lightness spot in exposure compensation");

   // darkroom/modules/channelmixerrgb/colorchecker
   _insert_type("darkroom/modules/channelmixerrgb/colorchecker", "int");
   _insert_default("darkroom/modules/channelmixerrgb/colorchecker", "0");
   _insert_shortdescription("darkroom/modules/channelmixerrgb/colorchecker", "current colorchecker model used");

   // darkroom/modules/channelmixerrgb/optimization
   _insert_type("darkroom/modules/channelmixerrgb/optimization", "int");
   _insert_default("darkroom/modules/channelmixerrgb/optimization", "0");
   _insert_shortdescription("darkroom/modules/channelmixerrgb/optimization", "current colorchecker optimization mode");

   // darkroom/modules/channelmixerrgb/safety
   _insert_type("darkroom/modules/channelmixerrgb/safety", "float");
   _insert_default("darkroom/modules/channelmixerrgb/safety", "0.5");
   _insert_shortdescription("darkroom/modules/channelmixerrgb/safety", "patch scale, safety margin");

   // plugins/darkroom/modulegroups_preset
   _insert_type("plugins/darkroom/modulegroups_preset", "string");
   _insert_default("plugins/darkroom/modulegroups_preset", "");
   _insert_shortdescription("plugins/darkroom/modulegroups_preset", "preset use for defining iop layout");
   _insert_longdescription("plugins/darkroom/modulegroups_preset", "preset use for defining iop layout");

   // plugins/darkroom/modulegroups_basics_sections_labels
   _insert_type("plugins/darkroom/modulegroups_basics_sections_labels", "bool");
   _insert_default("plugins/darkroom/modulegroups_basics_sections_labels", "true");
   _insert_shortdescription("plugins/darkroom/modulegroups_basics_sections_labels", "show the name of the module of each basic widget");
   _insert_longdescription("plugins/darkroom/modulegroups_basics_sections_labels", "show the name of the module of each basic widget");

   // plugins/lighttable/geotagging/heighttracklist
   _insert_type("plugins/lighttable/geotagging/heighttracklist", "int");
   _insert_default("plugins/lighttable/geotagging/heighttracklist", "50");
   _insert_shortdescription("plugins/lighttable/geotagging/heighttracklist", "height of the track list");
   _insert_longdescription("plugins/lighttable/geotagging/heighttracklist", "maximum height the track list will grow to before scrolling");

   // plugins/lighttable/geotagging/tz
   _insert_type("plugins/lighttable/geotagging/tz", "string");
   _insert_default("plugins/lighttable/geotagging/tz", "UTC");
   _insert_shortdescription("plugins/lighttable/geotagging/tz", N_("camera time zone"));
   _insert_longdescription("plugins/lighttable/geotagging/tz", N_("most cameras don't store the time zone in EXIF. give the correct time zone so the GPX data can be correctly matched"));

   // plugins/map/geotagging_search_url
   _insert_type("plugins/map/geotagging_search_url", "string");
   _insert_default("plugins/map/geotagging_search_url", "https://nominatim.openstreetmap.org/search?q=%s&format=xml&limit=%d&polygon_text=1");
   _insert_shortdescription("plugins/map/geotagging_search_url", "Geotagging search URL");
   _insert_longdescription("plugins/map/geotagging_search_url", "this can be changed when the default OpenStreetMap search URL is broken");

   // plugins/darkroom/temperature/colored_sliders
   _insert_type("plugins/darkroom/temperature/colored_sliders", "enum");
   _insert_values("plugins/darkroom/temperature/colored_sliders", "[no color][illuminant color][effect emulation]");
   WRAP_TRANSLATION(C_("preferences", "no color"));
   WRAP_TRANSLATION(C_("preferences", "illuminant color"));
   WRAP_TRANSLATION(C_("preferences", "effect emulation"));
   _insert_default("plugins/darkroom/temperature/colored_sliders", "no color");
   _insert_shortdescription("plugins/darkroom/temperature/colored_sliders", "white balance slider colors");
   _insert_longdescription("plugins/darkroom/temperature/colored_sliders", "visual indication of temperature adjustments.\nin 'illuminant color' mode slider colors represent the color of the light source,\nin 'effect emulation' slider colors represent the effect the adjustment would have on the scene");

   // plugins/darkroom/temperature/expand_coefficients
   _insert_type("plugins/darkroom/temperature/expand_coefficients", "bool");
   _insert_default("plugins/darkroom/temperature/expand_coefficients", "false");
   _insert_shortdescription("plugins/darkroom/temperature/expand_coefficients", "whether to show coefficients");
   _insert_longdescription("plugins/darkroom/temperature/expand_coefficients", "this is just for remembering whether to show coefficients or not and remember it");

   // plugins/darkroom/temperature/button_bar
   _insert_type("plugins/darkroom/temperature/button_bar", "bool");
   _insert_default("plugins/darkroom/temperature/button_bar", "true");
   _insert_shortdescription("plugins/darkroom/temperature/button_bar", "arange buttons as bar below temp/tint sliders");
   _insert_longdescription("plugins/darkroom/temperature/button_bar", "if enabled, the buttons in white balance module will be arranged below temp/tint sliders, otherwise they'll be shown in a grid to the right of temp/tint sliders");

   // plugins/darkroom/crop/expand_margins
   _insert_type("plugins/darkroom/crop/expand_margins", "bool");
   _insert_default("plugins/darkroom/crop/expand_margins", "false");
   _insert_shortdescription("plugins/darkroom/crop/expand_margins", "whether to show margins");
   _insert_longdescription("plugins/darkroom/crop/expand_margins", "this is just for remembering whether to show margins or not and remember it");

   // plugins/darkroom/ashift/expand_values
   _insert_type("plugins/darkroom/ashift/expand_values", "bool");
   _insert_default("plugins/darkroom/ashift/expand_values", "false");
   _insert_shortdescription("plugins/darkroom/ashift/expand_values", "whether to show values");
   _insert_longdescription("plugins/darkroom/ashift/expand_values", "this is just for remembering whether to show values or not");

   // plugins/darkroom/ashift/autocrop_value
   _insert_type("plugins/darkroom/ashift/autocrop_value", "int");
   _insert_default("plugins/darkroom/ashift/autocrop_value", "1");
   _insert_shortdescription("plugins/darkroom/ashift/autocrop_value", "auto-crop mode");
   _insert_longdescription("plugins/darkroom/ashift/autocrop_value", "0=off ; 1= largest area ; 2= original image");

   // plugins/darkroom/colorzones/bg_sat_factor
   _insert_type("plugins/darkroom/colorzones/bg_sat_factor", "float");
   _insert_default("plugins/darkroom/colorzones/bg_sat_factor", "0.5");
   _insert_min("plugins/darkroom/colorzones/bg_sat_factor", "0.1");
   _insert_max("plugins/darkroom/colorzones/bg_sat_factor", "1.0");
   _insert_shortdescription("plugins/darkroom/colorzones/bg_sat_factor", "saturation factor of the color zones background");
   _insert_longdescription("plugins/darkroom/colorzones/bg_sat_factor", "higher value means more saturated backgrounds in color zones");

   // plugins/darkroom/colorbalance/layout
   _insert_type("plugins/darkroom/colorbalance/layout", "enum");
   _insert_values("plugins/darkroom/colorbalance/layout", "[list][tabs][columns]");
   WRAP_TRANSLATION(C_("preferences", "list"));
   WRAP_TRANSLATION(C_("preferences", "tabs"));
   WRAP_TRANSLATION(C_("preferences", "columns"));
   _insert_default("plugins/darkroom/colorbalance/layout", "list");
   _insert_shortdescription("plugins/darkroom/colorbalance/layout", "color balance slider block layout");
   _insert_longdescription("plugins/darkroom/colorbalance/layout", "choose how to organise the slider blocks for lift, gamma and gain:\n'list' - all sliders are shown in one long list (with headers),\n'tabs' - use tabs to switch between the blocks of sliders,\n'columns' - the blocks of sliders are shown next to each other (in narrow columns)");

   // darkroom/ui/hide_header_buttons
   _insert_type("darkroom/ui/hide_header_buttons", "enum");
   _insert_values("darkroom/ui/hide_header_buttons", "[always][active][dim][auto][fade][fit][smooth][glide]");
   WRAP_TRANSLATION(C_("preferences", "always"));
   WRAP_TRANSLATION(C_("preferences", "active"));
   WRAP_TRANSLATION(C_("preferences", "dim"));
   WRAP_TRANSLATION(C_("preferences", "auto"));
   WRAP_TRANSLATION(C_("preferences", "fade"));
   WRAP_TRANSLATION(C_("preferences", "fit"));
   WRAP_TRANSLATION(C_("preferences", "smooth"));
   WRAP_TRANSLATION(C_("preferences", "glide"));
   _insert_default("darkroom/ui/hide_header_buttons", "always");
   _insert_shortdescription("darkroom/ui/hide_header_buttons", "show right-side buttons in processing module headers");
   _insert_longdescription("darkroom/ui/hide_header_buttons", "when the mouse is not over a module, the multi-instance, reset and preset buttons can be hidden:\n - 'always': always show all buttons,\n - 'active': only show the buttons when the mouse is over the module,\n - 'dim': buttons are dimmed when mouse is away,\n - 'auto': hide the buttons when the panel is narrow,\n - 'fade': fade out all buttons when panel narrows,\n - 'fit': hide all the buttons if the module name doesn't fit,\n - 'smooth': fade out all buttons in one header simultaneously,\n - 'glide': gradually hide individual buttons as needed");

   // darkroom/ui/show_mask_indicator
   _insert_type("darkroom/ui/show_mask_indicator", "bool");
   _insert_default("darkroom/ui/show_mask_indicator", "true");
   _insert_shortdescription("darkroom/ui/show_mask_indicator", "show mask indicator in module headers");
   _insert_longdescription("darkroom/ui/show_mask_indicator", "if enabled, an icon will be shown in the header of any processing modules that have a mask applied");

   // darkroom/ui/rename_new_instance
   _insert_type("darkroom/ui/rename_new_instance", "bool");
   _insert_default("darkroom/ui/rename_new_instance", "false");
   _insert_shortdescription("darkroom/ui/rename_new_instance", "prompt for name on addition of new instance");
   _insert_longdescription("darkroom/ui/rename_new_instance", "if enabled, a rename prompt will be present for each new module instance (either new instance or duplicate)");

   // darkroom/ui/auto_module_name_update
   _insert_type("darkroom/ui/auto_module_name_update", "bool");
   _insert_default("darkroom/ui/auto_module_name_update", "true");
   _insert_shortdescription("darkroom/ui/auto_module_name_update", "automatically update module name");
   _insert_longdescription("darkroom/ui/auto_module_name_update", "if enabled, the module name will be automatically updated to match a preset name or a preset instance name if present.");

   // plugins/darkroom/temperature/visible
   _insert_type("plugins/darkroom/temperature/visible", "bool");
   _insert_default("plugins/darkroom/temperature/visible", "true");
   _insert_shortdescription("plugins/darkroom/temperature/visible", "");
   _insert_longdescription("plugins/darkroom/temperature/visible", "");

   // plugins/darkroom/exposure/visible
   _insert_type("plugins/darkroom/exposure/visible", "bool");
   _insert_default("plugins/darkroom/exposure/visible", "true");
   _insert_shortdescription("plugins/darkroom/exposure/visible", "");
   _insert_longdescription("plugins/darkroom/exposure/visible", "");

   // plugins/darkroom/colorbalance/visible
   _insert_type("plugins/darkroom/colorbalance/visible", "bool");
   _insert_default("plugins/darkroom/colorbalance/visible", "true");
   _insert_shortdescription("plugins/darkroom/colorbalance/visible", "");
   _insert_longdescription("plugins/darkroom/colorbalance/visible", "");

   // plugins/darkroom/colorin/visible
   _insert_type("plugins/darkroom/colorin/visible", "bool");
   _insert_default("plugins/darkroom/colorin/visible", "true");
   _insert_shortdescription("plugins/darkroom/colorin/visible", "");
   _insert_longdescription("plugins/darkroom/colorin/visible", "");

   // plugins/darkroom/clipping/visible
   _insert_type("plugins/darkroom/clipping/visible", "bool");
   _insert_default("plugins/darkroom/clipping/visible", "true");
   _insert_shortdescription("plugins/darkroom/clipping/visible", "");
   _insert_longdescription("plugins/darkroom/clipping/visible", "");

   // plugins/darkroom/crop/visible
   _insert_type("plugins/darkroom/crop/visible", "bool");
   _insert_default("plugins/darkroom/crop/visible", "true");
   _insert_shortdescription("plugins/darkroom/crop/visible", "");
   _insert_longdescription("plugins/darkroom/crop/visible", "");

   // plugins/darkroom/sharpen/visible
   _insert_type("plugins/darkroom/sharpen/visible", "bool");
   _insert_default("plugins/darkroom/sharpen/visible", "true");
   _insert_shortdescription("plugins/darkroom/sharpen/visible", "");
   _insert_longdescription("plugins/darkroom/sharpen/visible", "");

   // plugins/darkroom/basecurve/visible
   _insert_type("plugins/darkroom/basecurve/visible", "bool");
   _insert_default("plugins/darkroom/basecurve/visible", "true");
   _insert_shortdescription("plugins/darkroom/basecurve/visible", "");
   _insert_longdescription("plugins/darkroom/basecurve/visible", "");

   // plugins/darkroom/highlights/visible
   _insert_type("plugins/darkroom/highlights/visible", "bool");
   _insert_default("plugins/darkroom/highlights/visible", "true");
   _insert_shortdescription("plugins/darkroom/highlights/visible", "");
   _insert_longdescription("plugins/darkroom/highlights/visible", "");

   // plugins/darkroom/demosaic/visible
   _insert_type("plugins/darkroom/demosaic/visible", "bool");
   _insert_default("plugins/darkroom/demosaic/visible", "true");
   _insert_shortdescription("plugins/darkroom/demosaic/visible", "");
   _insert_longdescription("plugins/darkroom/demosaic/visible", "");

   // plugins/darkroom/rgblevels/visible
   _insert_type("plugins/darkroom/rgblevels/visible", "bool");
   _insert_default("plugins/darkroom/rgblevels/visible", "true");
   _insert_shortdescription("plugins/darkroom/rgblevels/visible", "");
   _insert_longdescription("plugins/darkroom/rgblevels/visible", "");

   // plugins/darkroom/flip/visible
   _insert_type("plugins/darkroom/flip/visible", "bool");
   _insert_default("plugins/darkroom/flip/visible", "true");
   _insert_shortdescription("plugins/darkroom/flip/visible", "");
   _insert_longdescription("plugins/darkroom/flip/visible", "");

   // plugins/darkroom/bilat/visible
   _insert_type("plugins/darkroom/bilat/visible", "bool");
   _insert_default("plugins/darkroom/bilat/visible", "true");
   _insert_shortdescription("plugins/darkroom/bilat/visible", "");
   _insert_longdescription("plugins/darkroom/bilat/visible", "");

   // plugins/darkroom/denoiseprofile/visible
   _insert_type("plugins/darkroom/denoiseprofile/visible", "bool");
   _insert_default("plugins/darkroom/denoiseprofile/visible", "true");
   _insert_shortdescription("plugins/darkroom/denoiseprofile/visible", "");
   _insert_longdescription("plugins/darkroom/denoiseprofile/visible", "");

   // plugins/darkroom/hazeremoval/visible
   _insert_type("plugins/darkroom/hazeremoval/visible", "bool");
   _insert_default("plugins/darkroom/hazeremoval/visible", "true");
   _insert_shortdescription("plugins/darkroom/hazeremoval/visible", "");
   _insert_longdescription("plugins/darkroom/hazeremoval/visible", "");

   // plugins/darkroom/toneequal/visible
   _insert_type("plugins/darkroom/toneequal/visible", "bool");
   _insert_default("plugins/darkroom/toneequal/visible", "true");
   _insert_shortdescription("plugins/darkroom/toneequal/visible", "");
   _insert_longdescription("plugins/darkroom/toneequal/visible", "");

   // plugins/darkroom/lens/visible
   _insert_type("plugins/darkroom/lens/visible", "bool");
   _insert_default("plugins/darkroom/lens/visible", "true");
   _insert_shortdescription("plugins/darkroom/lens/visible", "");
   _insert_longdescription("plugins/darkroom/lens/visible", "");

   // darkroom/ui/scale_step_multiplier
   _insert_type("darkroom/ui/scale_step_multiplier", "float");
   _insert_default("darkroom/ui/scale_step_multiplier", "1.0");
   _insert_shortdescription("darkroom/ui/scale_step_multiplier", "the multiplier that is applied to any slider value change");
   _insert_longdescription("darkroom/ui/scale_step_multiplier", "any slider value change will be multiplied by this number, when slider precision is set to normal");

   // darkroom/ui/scale_rough_step_multiplier
   _insert_type("darkroom/ui/scale_rough_step_multiplier", "float");
   _insert_default("darkroom/ui/scale_rough_step_multiplier", "10.0");
   _insert_shortdescription("darkroom/ui/scale_rough_step_multiplier", "the multiplier that is applied to any slider rough value change");
   _insert_longdescription("darkroom/ui/scale_rough_step_multiplier", "any slider value change will be multiplied by this number, when slider precision is set to coarse");

   // darkroom/ui/scale_precise_step_multiplier
   _insert_type("darkroom/ui/scale_precise_step_multiplier", "float");
   _insert_default("darkroom/ui/scale_precise_step_multiplier", "0.1");
   _insert_shortdescription("darkroom/ui/scale_precise_step_multiplier", "the multiplier that is applied to any slider precise value change");
   _insert_longdescription("darkroom/ui/scale_precise_step_multiplier", "any slider value change will be multiplied by this number, when slider precision is set to fine");

   // darkroom/undo/merge_same_secs
   _insert_type("darkroom/undo/merge_same_secs", "float");
   _insert_default("darkroom/undo/merge_same_secs", "10");
   _insert_shortdescription("darkroom/undo/merge_same_secs", "the interval within which same widget changes are merged for undo");
   _insert_longdescription("darkroom/undo/merge_same_secs", "when continuously manipulating the same widget (slider, curve) no new undo records are created during this time");

   // darkroom/undo/review_secs
   _insert_type("darkroom/undo/review_secs", "float");
   _insert_default("darkroom/undo/review_secs", "2");
   _insert_shortdescription("darkroom/undo/review_secs", "create new undo record after reviewing last change to same widget this long");
   _insert_longdescription("darkroom/undo/review_secs", "when continuing to change the same widget after a period of review allow undo to return to this state");

   // performance_configuration_version_completed
   _insert_type("performance_configuration_version_completed", "int");
   _insert_default("performance_configuration_version_completed", "0");
   _insert_shortdescription("performance_configuration_version_completed", "version of the last completed performance configuration");
   _insert_longdescription("performance_configuration_version_completed", "what was the last performance configuration which has been completed");

   // plugins/darkroom/duplicate/windowheight
   _insert_type("plugins/darkroom/duplicate/windowheight", "int");
   _insert_default("plugins/darkroom/duplicate/windowheight", "400");
   _insert_shortdescription("plugins/darkroom/duplicate/windowheight", "height of the duplicates view");
   _insert_longdescription("plugins/darkroom/duplicate/windowheight", "maximum height the duplicates view in darkroom will grow to before scrolling");

   // plugins/darkroom/colorpicker/windowheight
   _insert_type("plugins/darkroom/colorpicker/windowheight", "int");
   _insert_default("plugins/darkroom/colorpicker/windowheight", "200");
   _insert_shortdescription("plugins/darkroom/colorpicker/windowheight", "height of the color picker list");
   _insert_longdescription("plugins/darkroom/colorpicker/windowheight", "maximum height the color picker samples list in darkroom will grow to before scrolling");

   // plugins/darkroom/history/windowheight
   _insert_type("plugins/darkroom/history/windowheight", "int");
   _insert_default("plugins/darkroom/history/windowheight", "1000");
   _insert_shortdescription("plugins/darkroom/history/windowheight", "height of the history list");
   _insert_longdescription("plugins/darkroom/history/windowheight", "maximum height the history list in darkroom will grow to before scrolling");

   // plugins/lighttable/metadata_view/windowheight
   _insert_type("plugins/lighttable/metadata_view/windowheight", "int");
   _insert_default("plugins/lighttable/metadata_view/windowheight", "1000");
   _insert_shortdescription("plugins/lighttable/metadata_view/windowheight", "height of the image information view");
   _insert_longdescription("plugins/lighttable/metadata_view/windowheight", "maximum height the image information view in lighttable and darkroom will grow to before scrolling");

   // plugins/lighttable/recentcollect/windowheight
   _insert_type("plugins/lighttable/recentcollect/windowheight", "int");
   _insert_default("plugins/lighttable/recentcollect/windowheight", "1000");
   _insert_shortdescription("plugins/lighttable/recentcollect/windowheight", "height of the recent collections list");
   _insert_longdescription("plugins/lighttable/recentcollect/windowheight", "maximum height the recent collections list in lighttable will grow to before scrolling");

   // plugins/darkroom/snapshots/windowheight
   _insert_type("plugins/darkroom/snapshots/windowheight", "int");
   _insert_default("plugins/darkroom/snapshots/windowheight", "200");
   _insert_shortdescription("plugins/darkroom/snapshots/windowheight", "height of the snapshots list");
   _insert_longdescription("plugins/darkroom/snapshots/windowheight", "maximum height the snapshots list in darkroom will grow to before scrolling");

   // plugins/lighttable/style/windowheight
   _insert_type("plugins/lighttable/style/windowheight", "int");
   _insert_default("plugins/lighttable/style/windowheight", "400");
   _insert_shortdescription("plugins/lighttable/style/windowheight", "height of the styles list");
   _insert_longdescription("plugins/lighttable/style/windowheight", "maximum height the styles list in lighttable will grow to before scrolling");

   // plugins/darkroom/toneequal/gui_page
   _insert_type("plugins/darkroom/toneequal/gui_page", "int");
   _insert_default("plugins/darkroom/toneequal/gui_page", "0");
   _insert_shortdescription("plugins/darkroom/toneequal/gui_page", "active tab in tone equaliser module");
   _insert_longdescription("plugins/darkroom/toneequal/gui_page", "which of simple, advanced or masking tabs will show at startup");

   // plugins/lighttable/collect/windowheight
   _insert_type("plugins/lighttable/collect/windowheight", "int");
   _insert_default("plugins/lighttable/collect/windowheight", "500");
   _insert_shortdescription("plugins/lighttable/collect/windowheight", "height of the collect list");
   _insert_longdescription("plugins/lighttable/collect/windowheight", "maximum height the collect list in lighttable will grow to before scrolling");

   // plugins/midi/devices
   _insert_type("plugins/midi/devices", "string");
   _insert_default("plugins/midi/devices", "");
   _insert_shortdescription("plugins/midi/devices", "order or exclude MIDI devices");
   _insert_longdescription("plugins/midi/devices", "comma-separated list of device name fragments that if matched load MIDI device at id given by location in list\nor if preceded by '-' prevent matching devices from loading. add encoding and number of knobs like 'BeatStep:63:16'");

}
#endif