/*********************                                                        */
/** rewriter_tables.h
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This header file automatically generated by:
 **
 **     /build/cvc4/src/cvc5-1.8/src/theory/mkrewriter /build/cvc4/src/cvc5-1.8/src/theory/rewriter_tables_template.h /build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds /build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds /build/cvc4/src/cvc5-1.8/src/theory/uf/kinds /build/cvc4/src/cvc5-1.8/src/theory/arith/kinds /build/cvc4/src/cvc5-1.8/src/theory/bv/kinds /build/cvc4/src/cvc5-1.8/src/theory/fp/kinds /build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds /build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds /build/cvc4/src/cvc5-1.8/src/theory/sep/kinds /build/cvc4/src/cvc5-1.8/src/theory/sets/kinds /build/cvc4/src/cvc5-1.8/src/theory/strings/kinds /build/cvc4/src/cvc5-1.8/src/theory/quantifiers/kinds
 **
 ** for the CVC4 project.
 **/

/*********************                                                        */
/*! \file rewriter_tables_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Dejan Jovanovic, Tim King, Andres Noetzli
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Rewriter tables for various theories
 **
 ** This file contains template code for the rewriter tables that are generated
 ** from the Theory kinds files.
 **/

#include "cvc4_private.h"

#pragma once

#include "theory/rewriter.h"
#include "theory/rewriter_attributes.h"
#include "expr/attribute_unique_id.h"
#include "expr/attribute.h"

#include "theory/builtin/theory_builtin_rewriter.h"
#include "theory/booleans/theory_bool_rewriter.h"
#include "theory/uf/theory_uf_rewriter.h"
#include "theory/arith/arith_rewriter.h"
#include "theory/bv/theory_bv_rewriter.h"
#include "theory/fp/theory_fp_rewriter.h"
#include "theory/arrays/theory_arrays_rewriter.h"
#include "theory/datatypes/datatypes_rewriter.h"
#include "theory/sep/theory_sep_rewriter.h"
#include "theory/sets/theory_sets_rewriter.h"
#include "theory/strings/sequences_rewriter.h"
#include "theory/quantifiers/quantifiers_rewriter.h"


namespace CVC4 {
namespace theory {

Node Rewriter::getPreRewriteCache(theory::TheoryId theoryId, TNode node) {
  switch(theoryId) {
    case THEORY_BUILTIN: return RewriteAttibute<THEORY_BUILTIN>::getPreRewriteCache(node);
    case THEORY_BOOL: return RewriteAttibute<THEORY_BOOL>::getPreRewriteCache(node);
    case THEORY_UF: return RewriteAttibute<THEORY_UF>::getPreRewriteCache(node);
    case THEORY_ARITH: return RewriteAttibute<THEORY_ARITH>::getPreRewriteCache(node);
    case THEORY_BV: return RewriteAttibute<THEORY_BV>::getPreRewriteCache(node);
    case THEORY_FP: return RewriteAttibute<THEORY_FP>::getPreRewriteCache(node);
    case THEORY_ARRAYS: return RewriteAttibute<THEORY_ARRAYS>::getPreRewriteCache(node);
    case THEORY_DATATYPES: return RewriteAttibute<THEORY_DATATYPES>::getPreRewriteCache(node);
    case THEORY_SEP: return RewriteAttibute<THEORY_SEP>::getPreRewriteCache(node);
    case THEORY_SETS: return RewriteAttibute<THEORY_SETS>::getPreRewriteCache(node);
    case THEORY_STRINGS: return RewriteAttibute<THEORY_STRINGS>::getPreRewriteCache(node);
    case THEORY_QUANTIFIERS: return RewriteAttibute<THEORY_QUANTIFIERS>::getPreRewriteCache(node);

  default:
    Unreachable();
  }
}

Node Rewriter::getPostRewriteCache(theory::TheoryId theoryId, TNode node) {
  switch(theoryId) {
    case THEORY_BUILTIN: return RewriteAttibute<THEORY_BUILTIN>::getPostRewriteCache(node);
    case THEORY_BOOL: return RewriteAttibute<THEORY_BOOL>::getPostRewriteCache(node);
    case THEORY_UF: return RewriteAttibute<THEORY_UF>::getPostRewriteCache(node);
    case THEORY_ARITH: return RewriteAttibute<THEORY_ARITH>::getPostRewriteCache(node);
    case THEORY_BV: return RewriteAttibute<THEORY_BV>::getPostRewriteCache(node);
    case THEORY_FP: return RewriteAttibute<THEORY_FP>::getPostRewriteCache(node);
    case THEORY_ARRAYS: return RewriteAttibute<THEORY_ARRAYS>::getPostRewriteCache(node);
    case THEORY_DATATYPES: return RewriteAttibute<THEORY_DATATYPES>::getPostRewriteCache(node);
    case THEORY_SEP: return RewriteAttibute<THEORY_SEP>::getPostRewriteCache(node);
    case THEORY_SETS: return RewriteAttibute<THEORY_SETS>::getPostRewriteCache(node);
    case THEORY_STRINGS: return RewriteAttibute<THEORY_STRINGS>::getPostRewriteCache(node);
    case THEORY_QUANTIFIERS: return RewriteAttibute<THEORY_QUANTIFIERS>::getPostRewriteCache(node);

    default:
    Unreachable();
  }
}

void Rewriter::setPreRewriteCache(theory::TheoryId theoryId, TNode node, TNode cache) {
  switch(theoryId) {
    case THEORY_BUILTIN: return RewriteAttibute<THEORY_BUILTIN>::setPreRewriteCache(node, cache);
    case THEORY_BOOL: return RewriteAttibute<THEORY_BOOL>::setPreRewriteCache(node, cache);
    case THEORY_UF: return RewriteAttibute<THEORY_UF>::setPreRewriteCache(node, cache);
    case THEORY_ARITH: return RewriteAttibute<THEORY_ARITH>::setPreRewriteCache(node, cache);
    case THEORY_BV: return RewriteAttibute<THEORY_BV>::setPreRewriteCache(node, cache);
    case THEORY_FP: return RewriteAttibute<THEORY_FP>::setPreRewriteCache(node, cache);
    case THEORY_ARRAYS: return RewriteAttibute<THEORY_ARRAYS>::setPreRewriteCache(node, cache);
    case THEORY_DATATYPES: return RewriteAttibute<THEORY_DATATYPES>::setPreRewriteCache(node, cache);
    case THEORY_SEP: return RewriteAttibute<THEORY_SEP>::setPreRewriteCache(node, cache);
    case THEORY_SETS: return RewriteAttibute<THEORY_SETS>::setPreRewriteCache(node, cache);
    case THEORY_STRINGS: return RewriteAttibute<THEORY_STRINGS>::setPreRewriteCache(node, cache);
    case THEORY_QUANTIFIERS: return RewriteAttibute<THEORY_QUANTIFIERS>::setPreRewriteCache(node, cache);

  default:
    Unreachable();
  }
}

void Rewriter::setPostRewriteCache(theory::TheoryId theoryId, TNode node, TNode cache) {
  switch(theoryId) {
    case THEORY_BUILTIN: return RewriteAttibute<THEORY_BUILTIN>::setPostRewriteCache(node, cache);
    case THEORY_BOOL: return RewriteAttibute<THEORY_BOOL>::setPostRewriteCache(node, cache);
    case THEORY_UF: return RewriteAttibute<THEORY_UF>::setPostRewriteCache(node, cache);
    case THEORY_ARITH: return RewriteAttibute<THEORY_ARITH>::setPostRewriteCache(node, cache);
    case THEORY_BV: return RewriteAttibute<THEORY_BV>::setPostRewriteCache(node, cache);
    case THEORY_FP: return RewriteAttibute<THEORY_FP>::setPostRewriteCache(node, cache);
    case THEORY_ARRAYS: return RewriteAttibute<THEORY_ARRAYS>::setPostRewriteCache(node, cache);
    case THEORY_DATATYPES: return RewriteAttibute<THEORY_DATATYPES>::setPostRewriteCache(node, cache);
    case THEORY_SEP: return RewriteAttibute<THEORY_SEP>::setPostRewriteCache(node, cache);
    case THEORY_SETS: return RewriteAttibute<THEORY_SETS>::setPostRewriteCache(node, cache);
    case THEORY_STRINGS: return RewriteAttibute<THEORY_STRINGS>::setPostRewriteCache(node, cache);
    case THEORY_QUANTIFIERS: return RewriteAttibute<THEORY_QUANTIFIERS>::setPostRewriteCache(node, cache);

  default:
    Unreachable();
  }
}

Rewriter::Rewriter()
{
for (size_t i = 0; i < kind::LAST_KIND; ++i)
{
  d_preRewriters[i] = nullptr;
  d_postRewriters[i] = nullptr;
}

for (size_t i = 0; i < theory::THEORY_LAST; ++i)
{
  d_preRewritersEqual[i] = nullptr;
  d_postRewritersEqual[i] = nullptr;
}
}

void Rewriter::clearCachesInternal() {
  typedef CVC4::expr::attr::AttributeUniqueId AttributeUniqueId;
  std::vector<AttributeUniqueId> preids;
   preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BUILTIN>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BOOL>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_UF>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_ARITH>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BV>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_FP>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_ARRAYS>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_DATATYPES>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_SEP>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_SETS>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_STRINGS>::pre_rewrite()));
 preids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_QUANTIFIERS>::pre_rewrite()));


  std::vector<AttributeUniqueId> postids;
   postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BUILTIN>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BOOL>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_UF>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_ARITH>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_BV>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_FP>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_ARRAYS>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_DATATYPES>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_SEP>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_SETS>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_STRINGS>::post_rewrite()));
 postids.push_back(expr::attr::AttributeManager::getAttributeId(RewriteAttibute<THEORY_QUANTIFIERS>::post_rewrite()));


  std::vector<const AttributeUniqueId*> allids;
  for(unsigned i = 0; i < preids.size(); ++i){
    allids.push_back(&preids[i]);
  }
  for(unsigned i = 0; i < postids.size(); ++i){
    allids.push_back(&postids[i]);
  }
  NodeManager::currentNM()->deleteAttributes(allids);
}

}/* CVC4::theory namespace */
}/* CVC4 namespace */
