/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__PRINTER_H
#define CVC4__OPTIONS__PRINTER_H

#include "options/options.h"

#include "options/printer_modes.h"


#define CVC4_OPTIONS__PRINTER__FOR_OPTION_HOLDER \
  flattenHOChains__option_t::type flattenHOChains;\
  bool flattenHOChains__setByUser__; \
  instFormatMode__option_t::type instFormatMode;\
  bool instFormatMode__setByUser__; \
  modelFormatMode__option_t::type modelFormatMode;\
  bool modelFormatMode__setByUser__;


namespace CVC4 {

namespace options {


enum class ModelFormatMode
{
  DEFAULT,
  TABLE
};
std::ostream&
operator<<(std::ostream& os, ModelFormatMode mode) CVC4_PUBLIC;
ModelFormatMode
stringToModelFormatMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC flattenHOChains__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} flattenHOChains CVC4_PUBLIC;
extern struct CVC4_PUBLIC instFormatMode__option_t
{
  typedef InstFormatMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instFormatMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC modelFormatMode__option_t
{
  typedef ModelFormatMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} modelFormatMode CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::flattenHOChains__option_t,
    const options::flattenHOChains__option_t::type& x);
template <> const options::flattenHOChains__option_t::type& Options::operator[](
    options::flattenHOChains__option_t) const;
template <> bool Options::wasSetByUser(options::flattenHOChains__option_t) const;
template <> void Options::assignBool(
    options::flattenHOChains__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instFormatMode__option_t,
    const options::instFormatMode__option_t::type& x);
template <> const options::instFormatMode__option_t::type& Options::operator[](
    options::instFormatMode__option_t) const;
template <> bool Options::wasSetByUser(options::instFormatMode__option_t) const;
template <> void Options::assign(
    options::instFormatMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::modelFormatMode__option_t,
    const options::modelFormatMode__option_t::type& x);
template <> const options::modelFormatMode__option_t::type& Options::operator[](
    options::modelFormatMode__option_t) const;
template <> bool Options::wasSetByUser(options::modelFormatMode__option_t) const;
template <> void Options::assign(
    options::modelFormatMode__option_t,
    std::string option,
    std::string value);


namespace options {

inline flattenHOChains__option_t::type flattenHOChains__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool flattenHOChains__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void flattenHOChains__option_t::set(const flattenHOChains__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instFormatMode__option_t::type instFormatMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instFormatMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instFormatMode__option_t::set(const instFormatMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline modelFormatMode__option_t::type modelFormatMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool modelFormatMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void modelFormatMode__option_t::set(const modelFormatMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__PRINTER_H */
