/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::flattenHOChains__option_t,
    const options::flattenHOChains__option_t::type& x)
{
  d_holder->flattenHOChains = x;
}
template <> const options::flattenHOChains__option_t::type& Options::operator[](
    options::flattenHOChains__option_t) const
{
  return d_holder->flattenHOChains;
}
template <> bool Options::wasSetByUser(options::flattenHOChains__option_t) const
{
  return d_holder->flattenHOChains__setByUser__;
}
template <> void Options::set(
    options::instFormatMode__option_t,
    const options::instFormatMode__option_t::type& x)
{
  d_holder->instFormatMode = x;
}
template <> const options::instFormatMode__option_t::type& Options::operator[](
    options::instFormatMode__option_t) const
{
  return d_holder->instFormatMode;
}
template <> bool Options::wasSetByUser(options::instFormatMode__option_t) const
{
  return d_holder->instFormatMode__setByUser__;
}
template <> void Options::set(
    options::modelFormatMode__option_t,
    const options::modelFormatMode__option_t::type& x)
{
  d_holder->modelFormatMode = x;
}
template <> const options::modelFormatMode__option_t::type& Options::operator[](
    options::modelFormatMode__option_t) const
{
  return d_holder->modelFormatMode;
}
template <> bool Options::wasSetByUser(options::modelFormatMode__option_t) const
{
  return d_holder->modelFormatMode__setByUser__;
}


namespace options {

struct flattenHOChains__option_t flattenHOChains;
struct instFormatMode__option_t instFormatMode;
struct modelFormatMode__option_t modelFormatMode;


std::ostream&
operator<<(std::ostream& os, ModelFormatMode mode)
{
  os << "ModelFormatMode::";
  switch(mode) {
    case ModelFormatMode::DEFAULT:
      os << "DEFAULT";
      break;
    case ModelFormatMode::TABLE:
      os << "TABLE";
      break;
    default:
        Unreachable();
  }
  return os;
}

ModelFormatMode
stringToModelFormatMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "default")
  {
    return ModelFormatMode::DEFAULT;
  }
  else if (optarg == "table")
  {
    return ModelFormatMode::TABLE;
  }
  else if (optarg == "help")
  {
    puts("Model format modes.\n"
         "Available modes for --model-format are:\n"
         "+ default\n"
         "  Print model as expressions in the output language format.\n"
         "+ table\n"
         "  Print functional expressions over finite domains in a table format.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --model-format: `") +
                          optarg + "'.  Try --model-format=help.");
  }
}


}  // namespace options
}  // namespace CVC4
