/*********************                                                        */
/*! \file options_holder_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner, Morgan Deters
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Global (command-line, set-option, ...) parameters for SMT
 **
 ** Global (command-line, set-option, ...) parameters for SMT.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__OPTIONS_HOLDER_H
#define CVC4__OPTIONS__OPTIONS_HOLDER_H

#include "options/arith_options.h"
#include "options/arrays_options.h"
#include "options/base_options.h"
#include "options/booleans_options.h"
#include "options/builtin_options.h"
#include "options/bv_options.h"
#include "options/datatypes_options.h"
#include "options/decision_options.h"
#include "options/expr_options.h"
#include "options/fp_options.h"
#include "options/main_options.h"
#include "options/parser_options.h"
#include "options/printer_options.h"
#include "options/proof_options.h"
#include "options/prop_options.h"
#include "options/quantifiers_options.h"
#include "options/sep_options.h"
#include "options/sets_options.h"
#include "options/smt_options.h"
#include "options/strings_options.h"
#include "options/theory_options.h"
#include "options/uf_options.h"


namespace CVC4 {
namespace options {

struct OptionsHolder {
  OptionsHolder();
  CVC4_OPTIONS__ARITH__FOR_OPTION_HOLDER
  CVC4_OPTIONS__ARRAYS__FOR_OPTION_HOLDER
  CVC4_OPTIONS__BASE__FOR_OPTION_HOLDER
  CVC4_OPTIONS__BOOLEANS__FOR_OPTION_HOLDER
  CVC4_OPTIONS__BUILTIN__FOR_OPTION_HOLDER
  CVC4_OPTIONS__BV__FOR_OPTION_HOLDER
  CVC4_OPTIONS__DATATYPES__FOR_OPTION_HOLDER
  CVC4_OPTIONS__DECISION__FOR_OPTION_HOLDER
  CVC4_OPTIONS__EXPR__FOR_OPTION_HOLDER
  CVC4_OPTIONS__FP__FOR_OPTION_HOLDER
  CVC4_OPTIONS__DRIVER__FOR_OPTION_HOLDER
  CVC4_OPTIONS__PARSER__FOR_OPTION_HOLDER
  CVC4_OPTIONS__PRINTER__FOR_OPTION_HOLDER
  CVC4_OPTIONS__PROOF__FOR_OPTION_HOLDER
  CVC4_OPTIONS__PROP__FOR_OPTION_HOLDER
  CVC4_OPTIONS__QUANTIFIERS__FOR_OPTION_HOLDER
  CVC4_OPTIONS__SEP__FOR_OPTION_HOLDER
  CVC4_OPTIONS__SETS__FOR_OPTION_HOLDER
  CVC4_OPTIONS__SMT__FOR_OPTION_HOLDER
  CVC4_OPTIONS__STRINGS__FOR_OPTION_HOLDER
  CVC4_OPTIONS__THEORY__FOR_OPTION_HOLDER
  CVC4_OPTIONS__UF__FOR_OPTION_HOLDER


};/* struct OptionsHolder */

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__OPTIONS_HOLDER_H */
