/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::earlyExit__option_t::type& Options::operator[](
    options::earlyExit__option_t) const
{
  return d_holder->earlyExit;
}
template <> bool Options::wasSetByUser(options::earlyExit__option_t) const
{
  return d_holder->earlyExit__setByUser__;
}
template <> const options::help__option_t::type& Options::operator[](
    options::help__option_t) const
{
  return d_holder->help;
}
template <> bool Options::wasSetByUser(options::help__option_t) const
{
  return d_holder->help__setByUser__;
}
template <> void Options::set(
    options::interactive__option_t,
    const options::interactive__option_t::type& x)
{
  d_holder->interactive = x;
}
template <> const options::interactive__option_t::type& Options::operator[](
    options::interactive__option_t) const
{
  return d_holder->interactive;
}
template <> bool Options::wasSetByUser(options::interactive__option_t) const
{
  return d_holder->interactive__setByUser__;
}
template <> const options::interactivePrompt__option_t::type& Options::operator[](
    options::interactivePrompt__option_t) const
{
  return d_holder->interactivePrompt;
}
template <> bool Options::wasSetByUser(options::interactivePrompt__option_t) const
{
  return d_holder->interactivePrompt__setByUser__;
}
template <> const options::seed__option_t::type& Options::operator[](
    options::seed__option_t) const
{
  return d_holder->seed;
}
template <> bool Options::wasSetByUser(options::seed__option_t) const
{
  return d_holder->seed__setByUser__;
}
template <> const options::segvSpin__option_t::type& Options::operator[](
    options::segvSpin__option_t) const
{
  return d_holder->segvSpin;
}
template <> bool Options::wasSetByUser(options::segvSpin__option_t) const
{
  return d_holder->segvSpin__setByUser__;
}
template <> const options::tearDownIncremental__option_t::type& Options::operator[](
    options::tearDownIncremental__option_t) const
{
  return d_holder->tearDownIncremental;
}
template <> bool Options::wasSetByUser(options::tearDownIncremental__option_t) const
{
  return d_holder->tearDownIncremental__setByUser__;
}
template <> const options::version__option_t::type& Options::operator[](
    options::version__option_t) const
{
  return d_holder->version;
}
template <> bool Options::wasSetByUser(options::version__option_t) const
{
  return d_holder->version__setByUser__;
}


namespace options {

struct earlyExit__option_t earlyExit;
struct help__option_t help;
struct interactive__option_t interactive;
struct interactivePrompt__option_t interactivePrompt;
struct seed__option_t seed;
struct segvSpin__option_t segvSpin;
struct tearDownIncremental__option_t tearDownIncremental;
struct version__option_t version;



}  // namespace options
}  // namespace CVC4
