/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__FP_H
#define CVC4__OPTIONS__FP_H

#include "options/options.h"




#define CVC4_OPTIONS__FP__FOR_OPTION_HOLDER \
  fpExp__option_t::type fpExp;\
  bool fpExp__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC fpExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fpExp CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::fpExp__option_t,
    const options::fpExp__option_t::type& x);
template <> const options::fpExp__option_t::type& Options::operator[](
    options::fpExp__option_t) const;
template <> bool Options::wasSetByUser(options::fpExp__option_t) const;
template <> void Options::assignBool(
    options::fpExp__option_t,
    std::string option,
    bool value);


namespace options {

inline fpExp__option_t::type fpExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fpExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fpExp__option_t::set(const fpExp__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__FP_H */
