/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::cdtBisimilar__option_t::type& Options::operator[](
    options::cdtBisimilar__option_t) const
{
  return d_holder->cdtBisimilar;
}
template <> bool Options::wasSetByUser(options::cdtBisimilar__option_t) const
{
  return d_holder->cdtBisimilar__setByUser__;
}
template <> const options::dtBinarySplit__option_t::type& Options::operator[](
    options::dtBinarySplit__option_t) const
{
  return d_holder->dtBinarySplit;
}
template <> bool Options::wasSetByUser(options::dtBinarySplit__option_t) const
{
  return d_holder->dtBinarySplit__setByUser__;
}
template <> const options::dtBlastSplits__option_t::type& Options::operator[](
    options::dtBlastSplits__option_t) const
{
  return d_holder->dtBlastSplits;
}
template <> bool Options::wasSetByUser(options::dtBlastSplits__option_t) const
{
  return d_holder->dtBlastSplits__setByUser__;
}
template <> const options::dtCyclic__option_t::type& Options::operator[](
    options::dtCyclic__option_t) const
{
  return d_holder->dtCyclic;
}
template <> bool Options::wasSetByUser(options::dtCyclic__option_t) const
{
  return d_holder->dtCyclic__setByUser__;
}
template <> void Options::set(
    options::dtForceAssignment__option_t,
    const options::dtForceAssignment__option_t::type& x)
{
  d_holder->dtForceAssignment = x;
}
template <> const options::dtForceAssignment__option_t::type& Options::operator[](
    options::dtForceAssignment__option_t) const
{
  return d_holder->dtForceAssignment;
}
template <> bool Options::wasSetByUser(options::dtForceAssignment__option_t) const
{
  return d_holder->dtForceAssignment__setByUser__;
}
template <> const options::dtInferAsLemmas__option_t::type& Options::operator[](
    options::dtInferAsLemmas__option_t) const
{
  return d_holder->dtInferAsLemmas;
}
template <> bool Options::wasSetByUser(options::dtInferAsLemmas__option_t) const
{
  return d_holder->dtInferAsLemmas__setByUser__;
}
template <> const options::dtNestedRec__option_t::type& Options::operator[](
    options::dtNestedRec__option_t) const
{
  return d_holder->dtNestedRec;
}
template <> bool Options::wasSetByUser(options::dtNestedRec__option_t) const
{
  return d_holder->dtNestedRec__setByUser__;
}
template <> void Options::set(
    options::dtRewriteErrorSel__option_t,
    const options::dtRewriteErrorSel__option_t::type& x)
{
  d_holder->dtRewriteErrorSel = x;
}
template <> const options::dtRewriteErrorSel__option_t::type& Options::operator[](
    options::dtRewriteErrorSel__option_t) const
{
  return d_holder->dtRewriteErrorSel;
}
template <> bool Options::wasSetByUser(options::dtRewriteErrorSel__option_t) const
{
  return d_holder->dtRewriteErrorSel__setByUser__;
}
template <> const options::dtSharedSelectors__option_t::type& Options::operator[](
    options::dtSharedSelectors__option_t) const
{
  return d_holder->dtSharedSelectors;
}
template <> bool Options::wasSetByUser(options::dtSharedSelectors__option_t) const
{
  return d_holder->dtSharedSelectors__setByUser__;
}
template <> const options::sygusAbortSize__option_t::type& Options::operator[](
    options::sygusAbortSize__option_t) const
{
  return d_holder->sygusAbortSize;
}
template <> bool Options::wasSetByUser(options::sygusAbortSize__option_t) const
{
  return d_holder->sygusAbortSize__setByUser__;
}
template <> const options::sygusFairMax__option_t::type& Options::operator[](
    options::sygusFairMax__option_t) const
{
  return d_holder->sygusFairMax;
}
template <> bool Options::wasSetByUser(options::sygusFairMax__option_t) const
{
  return d_holder->sygusFairMax__setByUser__;
}
template <> const options::sygusFair__option_t::type& Options::operator[](
    options::sygusFair__option_t) const
{
  return d_holder->sygusFair;
}
template <> bool Options::wasSetByUser(options::sygusFair__option_t) const
{
  return d_holder->sygusFair__setByUser__;
}
template <> const options::sygusSymBreak__option_t::type& Options::operator[](
    options::sygusSymBreak__option_t) const
{
  return d_holder->sygusSymBreak;
}
template <> bool Options::wasSetByUser(options::sygusSymBreak__option_t) const
{
  return d_holder->sygusSymBreak__setByUser__;
}
template <> const options::sygusSymBreakAgg__option_t::type& Options::operator[](
    options::sygusSymBreakAgg__option_t) const
{
  return d_holder->sygusSymBreakAgg;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakAgg__option_t) const
{
  return d_holder->sygusSymBreakAgg__setByUser__;
}
template <> const options::sygusSymBreakDynamic__option_t::type& Options::operator[](
    options::sygusSymBreakDynamic__option_t) const
{
  return d_holder->sygusSymBreakDynamic;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakDynamic__option_t) const
{
  return d_holder->sygusSymBreakDynamic__setByUser__;
}
template <> const options::sygusSymBreakLazy__option_t::type& Options::operator[](
    options::sygusSymBreakLazy__option_t) const
{
  return d_holder->sygusSymBreakLazy;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakLazy__option_t) const
{
  return d_holder->sygusSymBreakLazy__setByUser__;
}
template <> void Options::set(
    options::sygusSymBreakPbe__option_t,
    const options::sygusSymBreakPbe__option_t::type& x)
{
  d_holder->sygusSymBreakPbe = x;
}
template <> const options::sygusSymBreakPbe__option_t::type& Options::operator[](
    options::sygusSymBreakPbe__option_t) const
{
  return d_holder->sygusSymBreakPbe;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakPbe__option_t) const
{
  return d_holder->sygusSymBreakPbe__setByUser__;
}
template <> const options::sygusSymBreakRlv__option_t::type& Options::operator[](
    options::sygusSymBreakRlv__option_t) const
{
  return d_holder->sygusSymBreakRlv;
}
template <> bool Options::wasSetByUser(options::sygusSymBreakRlv__option_t) const
{
  return d_holder->sygusSymBreakRlv__setByUser__;
}


namespace options {

struct cdtBisimilar__option_t cdtBisimilar;
struct dtBinarySplit__option_t dtBinarySplit;
struct dtBlastSplits__option_t dtBlastSplits;
struct dtCyclic__option_t dtCyclic;
struct dtForceAssignment__option_t dtForceAssignment;
struct dtInferAsLemmas__option_t dtInferAsLemmas;
struct dtNestedRec__option_t dtNestedRec;
struct dtRewriteErrorSel__option_t dtRewriteErrorSel;
struct dtSharedSelectors__option_t dtSharedSelectors;
struct sygusAbortSize__option_t sygusAbortSize;
struct sygusFairMax__option_t sygusFairMax;
struct sygusFair__option_t sygusFair;
struct sygusSymBreak__option_t sygusSymBreak;
struct sygusSymBreakAgg__option_t sygusSymBreakAgg;
struct sygusSymBreakDynamic__option_t sygusSymBreakDynamic;
struct sygusSymBreakLazy__option_t sygusSymBreakLazy;
struct sygusSymBreakPbe__option_t sygusSymBreakPbe;
struct sygusSymBreakRlv__option_t sygusSymBreakRlv;


std::ostream&
operator<<(std::ostream& os, SygusFairMode mode)
{
  os << "SygusFairMode::";
  switch(mode) {
    case SygusFairMode::DIRECT:
      os << "DIRECT";
      break;
    case SygusFairMode::DT_SIZE:
      os << "DT_SIZE";
      break;
    case SygusFairMode::DT_HEIGHT_PRED:
      os << "DT_HEIGHT_PRED";
      break;
    case SygusFairMode::DT_SIZE_PRED:
      os << "DT_SIZE_PRED";
      break;
    case SygusFairMode::NONE:
      os << "NONE";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusFairMode
stringToSygusFairMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "direct")
  {
    return SygusFairMode::DIRECT;
  }
  else if (optarg == "dt-size")
  {
    return SygusFairMode::DT_SIZE;
  }
  else if (optarg == "dt-height-bound")
  {
    return SygusFairMode::DT_HEIGHT_PRED;
  }
  else if (optarg == "dt-size-bound")
  {
    return SygusFairMode::DT_SIZE_PRED;
  }
  else if (optarg == "none")
  {
    return SygusFairMode::NONE;
  }
  else if (optarg == "help")
  {
    puts("Modes for enforcing fairness for counterexample guided quantifier instantion.\n"
         "Available modes for --sygus-fair are:\n"
         "+ direct\n"
         "  Enforce fairness using direct conflict lemmas.\n"
         "+ dt-size (default)\n"
         "  Enforce fairness using size operator.\n"
         "+ dt-height-bound\n"
         "  Enforce fairness by height bound predicate.\n"
         "+ dt-size-bound\n"
         "  Enforce fairness by size bound predicate.\n"
         "+ none\n"
         "  Do not enforce fairness.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-fair: `") +
                          optarg + "'.  Try --sygus-fair=help.");
  }
}


}  // namespace options
}  // namespace CVC4
