/* StringUtil.c generated by valac 0.56.4, the Vala compiler
 * generated from StringUtil.vala, do not modify */

/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USACiano
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define CIANO_UTILS_STRING_UTIL_SPACE " "
#define CIANO_UTILS_STRING_UTIL_EMPTY ""
#define CIANO_UTILS_STRING_UTIL_BREAK_LINE "\n"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_UTILS_TYPE_STRING_UTIL (ciano_utils_string_util_get_type ())
#define CIANO_UTILS_STRING_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_UTILS_TYPE_STRING_UTIL, CianoUtilsStringUtil))
#define CIANO_UTILS_STRING_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_UTILS_TYPE_STRING_UTIL, CianoUtilsStringUtilClass))
#define CIANO_UTILS_IS_STRING_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_UTILS_TYPE_STRING_UTIL))
#define CIANO_UTILS_IS_STRING_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_UTILS_TYPE_STRING_UTIL))
#define CIANO_UTILS_STRING_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_UTILS_TYPE_STRING_UTIL, CianoUtilsStringUtilClass))

typedef struct _CianoUtilsStringUtil CianoUtilsStringUtil;
typedef struct _CianoUtilsStringUtilClass CianoUtilsStringUtilClass;
typedef struct _CianoUtilsStringUtilPrivate CianoUtilsStringUtilPrivate;
typedef struct _CianoUtilsParamSpecStringUtil CianoUtilsParamSpecStringUtil;

struct _CianoUtilsStringUtil {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoUtilsStringUtilPrivate * priv;
};

struct _CianoUtilsStringUtilClass {
	GTypeClass parent_class;
	void (*finalize) (CianoUtilsStringUtil *self);
};

struct _CianoUtilsParamSpecStringUtil {
	GParamSpec parent_instance;
};

static gpointer ciano_utils_string_util_parent_class = NULL;

VALA_EXTERN gpointer ciano_utils_string_util_ref (gpointer instance);
VALA_EXTERN void ciano_utils_string_util_unref (gpointer instance);
VALA_EXTERN GParamSpec* ciano_utils_param_spec_string_util (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void ciano_utils_value_set_string_util (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void ciano_utils_value_take_string_util (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer ciano_utils_value_get_string_util (const GValue* value);
VALA_EXTERN GType ciano_utils_string_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoUtilsStringUtil, ciano_utils_string_util_unref)
VALA_EXTERN gboolean ciano_utils_string_util_is_empty (const gchar* value);
VALA_EXTERN gboolean ciano_utils_string_util_is_not_empty (const gchar* value);
VALA_EXTERN gboolean ciano_utils_string_util_is_blank (const gchar* value);
VALA_EXTERN gboolean ciano_utils_string_util_is_not_blank (const gchar* value);
VALA_EXTERN CianoUtilsStringUtil* ciano_utils_string_util_new (void);
VALA_EXTERN CianoUtilsStringUtil* ciano_utils_string_util_construct (GType object_type);
static void ciano_utils_string_util_finalize (CianoUtilsStringUtil * obj);
static GType ciano_utils_string_util_get_type_once (void);

/**
         * Checks if a string is empty ("") or null.
         *
         * Exemple:
         * > StringUtil.is_empty(null)       = true
         * > StringUtil.is_empty("")         = true
         * > StringUtil.is_empty(" ")        = false
         * > StringUtil.is_empty("test")     = false
         * > StringUtil.is_empty("  test  ") = false
         * 
         * @param  {@code string} value - the string to check, not may be null
         * @return {@code bool} true - if the string is empty or null
         */
gboolean
ciano_utils_string_util_is_empty (const gchar* value)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (value);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	result = _tmp0_;
	return result;
}

/**
         * Checks if a string is not empty ("") and not null.
         *
         * Exemple:
         * > StringUtil.is_not_empty(null)       = false
         * > StringUtil.is_not_empty("")         = false
         * > StringUtil.is_not_empty(" ")        = true
         * > StringUtil.is_not_empty("test")     = true
         * > StringUtil.is_not_empty("  test  ") = true
         *
         * @param  {@code string} value - the string to check, may be null
         * @return {@code bool} true -if the string is not empty and not null
         */
gboolean
ciano_utils_string_util_is_not_empty (const gchar* value)
{
	gboolean result;
	result = !ciano_utils_string_util_is_empty (value);
	return result;
}

/**
         * Checks if a string is empty (""), null or with whitespace.
         * 
         * Exemple:
         * > StringUtil.is_blank(null)       = true
         * > StringUtil.is_blank("")         = true
         * > StringUtil.is_blank(" ")        = true
         * > StringUtil.is_blank("test")     = false
         * > StringUtil.is_blank("  test  ") = false
         *
         * @param  {@code string} value - the string to check, may be null
         * @return {@code bool} - true if the string is null, empty or whitespace only
         */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
ciano_utils_string_util_is_blank (const gchar* value)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (value == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (value);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = strlen (value);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				if (string_get (value, (glong) i) != ' ') {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
         * Checks if a string is not empty (""), not null or has no whitespace.
         * 
         * Exemple:
         * > StringUtil.is_not_blank(null)       = false
         * > StringUtil.is_not_blank("")         = false
         * > StringUtil.is_not_blank(" ")        = false
         * > StringUtil.is_not_blank("test")     = true
         * > StringUtil.is_not_blank("  test  ") = true
         *
         * @param  {@code string} value - the string to check, may be null
         * @return {@code bool} - true if the string is not empty and not null and not whitespace only
         */
gboolean
ciano_utils_string_util_is_not_blank (const gchar* value)
{
	gboolean result;
	result = !ciano_utils_string_util_is_blank (value);
	return result;
}

CianoUtilsStringUtil*
ciano_utils_string_util_construct (GType object_type)
{
	CianoUtilsStringUtil* self = NULL;
	self = (CianoUtilsStringUtil*) g_type_create_instance (object_type);
	return self;
}

CianoUtilsStringUtil*
ciano_utils_string_util_new (void)
{
	return ciano_utils_string_util_construct (CIANO_UTILS_TYPE_STRING_UTIL);
}

static void
ciano_utils_value_string_util_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_utils_value_string_util_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_utils_string_util_unref (value->data[0].v_pointer);
	}
}

static void
ciano_utils_value_string_util_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_utils_string_util_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_utils_value_string_util_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_utils_value_string_util_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoUtilsStringUtil * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_utils_string_util_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_utils_value_string_util_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	CianoUtilsStringUtil ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_utils_string_util_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ciano_utils_param_spec_string_util (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	CianoUtilsParamSpecStringUtil* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_UTILS_TYPE_STRING_UTIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ciano_utils_value_get_string_util (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_STRING_UTIL), NULL);
	return value->data[0].v_pointer;
}

void
ciano_utils_value_set_string_util (GValue* value,
                                   gpointer v_object)
{
	CianoUtilsStringUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_STRING_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_STRING_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_utils_string_util_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_string_util_unref (old);
	}
}

void
ciano_utils_value_take_string_util (GValue* value,
                                    gpointer v_object)
{
	CianoUtilsStringUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_STRING_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_STRING_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_string_util_unref (old);
	}
}

static void
ciano_utils_string_util_class_init (CianoUtilsStringUtilClass * klass,
                                    gpointer klass_data)
{
	ciano_utils_string_util_parent_class = g_type_class_peek_parent (klass);
	((CianoUtilsStringUtilClass *) klass)->finalize = ciano_utils_string_util_finalize;
}

static void
ciano_utils_string_util_instance_init (CianoUtilsStringUtil * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
ciano_utils_string_util_finalize (CianoUtilsStringUtil * obj)
{
	CianoUtilsStringUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_UTILS_TYPE_STRING_UTIL, CianoUtilsStringUtil);
	g_signal_handlers_destroy (self);
}

/**
     * The {@code StringUtil} class defines certain words related to
     * string handling.
     *
     * {@code StringUtil} handles {@code null} input strings quietly.
     * That is to say that a {@code null} input will return {@code null}.
     * Where a {@code boolean} or {@code int} is being returned
     * details vary by method.
     *
     * @since 0.1.0
     */
static GType
ciano_utils_string_util_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_utils_value_string_util_init, ciano_utils_value_string_util_free_value, ciano_utils_value_string_util_copy_value, ciano_utils_value_string_util_peek_pointer, "p", ciano_utils_value_string_util_collect_value, "p", ciano_utils_value_string_util_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoUtilsStringUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_utils_string_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoUtilsStringUtil), 0, (GInstanceInitFunc) ciano_utils_string_util_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_utils_string_util_type_id;
	ciano_utils_string_util_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoUtilsStringUtil", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ciano_utils_string_util_type_id;
}

GType
ciano_utils_string_util_get_type (void)
{
	static volatile gsize ciano_utils_string_util_type_id__once = 0;
	if (g_once_init_enter (&ciano_utils_string_util_type_id__once)) {
		GType ciano_utils_string_util_type_id;
		ciano_utils_string_util_type_id = ciano_utils_string_util_get_type_once ();
		g_once_init_leave (&ciano_utils_string_util_type_id__once, ciano_utils_string_util_type_id);
	}
	return ciano_utils_string_util_type_id__once;
}

gpointer
ciano_utils_string_util_ref (gpointer instance)
{
	CianoUtilsStringUtil * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ciano_utils_string_util_unref (gpointer instance)
{
	CianoUtilsStringUtil * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_UTILS_STRING_UTIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

