/* ArrayUtil.c generated by valac 0.56.4, the Vala compiler
 * generated from ArrayUtil.vala, do not modify */

/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_UTILS_TYPE_ARRAY_UTIL (ciano_utils_array_util_get_type ())
#define CIANO_UTILS_ARRAY_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_UTILS_TYPE_ARRAY_UTIL, CianoUtilsArrayUtil))
#define CIANO_UTILS_ARRAY_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_UTILS_TYPE_ARRAY_UTIL, CianoUtilsArrayUtilClass))
#define CIANO_UTILS_IS_ARRAY_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_UTILS_TYPE_ARRAY_UTIL))
#define CIANO_UTILS_IS_ARRAY_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_UTILS_TYPE_ARRAY_UTIL))
#define CIANO_UTILS_ARRAY_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_UTILS_TYPE_ARRAY_UTIL, CianoUtilsArrayUtilClass))

typedef struct _CianoUtilsArrayUtil CianoUtilsArrayUtil;
typedef struct _CianoUtilsArrayUtilClass CianoUtilsArrayUtilClass;
typedef struct _CianoUtilsArrayUtilPrivate CianoUtilsArrayUtilPrivate;
typedef struct _Block7Data Block7Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _CianoUtilsParamSpecArrayUtil CianoUtilsParamSpecArrayUtil;

struct _CianoUtilsArrayUtil {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoUtilsArrayUtilPrivate * priv;
};

struct _CianoUtilsArrayUtilClass {
	GTypeClass parent_class;
	void (*finalize) (CianoUtilsArrayUtil *self);
};

struct _Block7Data {
	int _ref_count_;
	GPtrArray* new_array;
};

struct _CianoUtilsParamSpecArrayUtil {
	GParamSpec parent_instance;
};

static gpointer ciano_utils_array_util_parent_class = NULL;

VALA_EXTERN gpointer ciano_utils_array_util_ref (gpointer instance);
VALA_EXTERN void ciano_utils_array_util_unref (gpointer instance);
VALA_EXTERN GParamSpec* ciano_utils_param_spec_array_util (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void ciano_utils_value_set_array_util (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void ciano_utils_value_take_array_util (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer ciano_utils_value_get_array_util (const GValue* value);
VALA_EXTERN GType ciano_utils_array_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoUtilsArrayUtil, ciano_utils_array_util_unref)
VALA_EXTERN GPtrArray* ciano_utils_array_util_join_generic_string_arrays (GPtrArray* array1,
                                                              GPtrArray* array2);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void __lambda22_ (Block7Data* _data7_,
                  const gchar* str);
static void ___lambda22__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda23_ (Block7Data* _data7_,
                  const gchar* str);
static void ___lambda23__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN CianoUtilsArrayUtil* ciano_utils_array_util_new (void);
VALA_EXTERN CianoUtilsArrayUtil* ciano_utils_array_util_construct (GType object_type);
static void ciano_utils_array_util_finalize (CianoUtilsArrayUtil * obj);
static GType ciano_utils_array_util_get_type_once (void);

/**
         * Join generic string arrays.
         *
         * Exemple:
         * > ArrayUtil.join_generic_string_arrays(new GenericArray<string>, new GenericArray<string>)
         * 
         * @param   {@code GenericArray<string>} array1
         * @param   {@code GenericArray<string>} array2
         * @return  {@code GenericArray} 
         */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_ptr_array_unref0 (_data7_->new_array);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
__lambda22_ (Block7Data* _data7_,
             const gchar* str)
{
	gchar* _tmp0_;
	g_return_if_fail (str != NULL);
	_tmp0_ = g_strdup (str);
	g_ptr_array_add (_data7_->new_array, _tmp0_);
}

static void
___lambda22__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda22_ (self, (const gchar*) data);
}

static void
__lambda23_ (Block7Data* _data7_,
             const gchar* str)
{
	gchar* _tmp0_;
	g_return_if_fail (str != NULL);
	_tmp0_ = g_strdup (str);
	g_ptr_array_add (_data7_->new_array, _tmp0_);
}

static void
___lambda23__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda23_ (self, (const gchar*) data);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

GPtrArray*
ciano_utils_array_util_join_generic_string_arrays (GPtrArray* array1,
                                                   GPtrArray* array2)
{
	Block7Data* _data7_;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* result;
	g_return_val_if_fail (array1 != NULL, NULL);
	g_return_val_if_fail (array2 != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data7_->new_array = _tmp0_;
	g_ptr_array_foreach (array1, ___lambda22__gfunc, _data7_);
	g_ptr_array_foreach (array2, ___lambda23__gfunc, _data7_);
	_tmp1_ = _g_ptr_array_ref0 (_data7_->new_array);
	result = _tmp1_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

CianoUtilsArrayUtil*
ciano_utils_array_util_construct (GType object_type)
{
	CianoUtilsArrayUtil* self = NULL;
	self = (CianoUtilsArrayUtil*) g_type_create_instance (object_type);
	return self;
}

CianoUtilsArrayUtil*
ciano_utils_array_util_new (void)
{
	return ciano_utils_array_util_construct (CIANO_UTILS_TYPE_ARRAY_UTIL);
}

static void
ciano_utils_value_array_util_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_utils_value_array_util_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_utils_array_util_unref (value->data[0].v_pointer);
	}
}

static void
ciano_utils_value_array_util_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_utils_array_util_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_utils_value_array_util_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_utils_value_array_util_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoUtilsArrayUtil * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_utils_array_util_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_utils_value_array_util_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	CianoUtilsArrayUtil ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_utils_array_util_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ciano_utils_param_spec_array_util (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	CianoUtilsParamSpecArrayUtil* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_UTILS_TYPE_ARRAY_UTIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ciano_utils_value_get_array_util (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_ARRAY_UTIL), NULL);
	return value->data[0].v_pointer;
}

void
ciano_utils_value_set_array_util (GValue* value,
                                  gpointer v_object)
{
	CianoUtilsArrayUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_ARRAY_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_ARRAY_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_utils_array_util_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_array_util_unref (old);
	}
}

void
ciano_utils_value_take_array_util (GValue* value,
                                   gpointer v_object)
{
	CianoUtilsArrayUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_ARRAY_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_ARRAY_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_array_util_unref (old);
	}
}

static void
ciano_utils_array_util_class_init (CianoUtilsArrayUtilClass * klass,
                                   gpointer klass_data)
{
	ciano_utils_array_util_parent_class = g_type_class_peek_parent (klass);
	((CianoUtilsArrayUtilClass *) klass)->finalize = ciano_utils_array_util_finalize;
}

static void
ciano_utils_array_util_instance_init (CianoUtilsArrayUtil * self,
                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
ciano_utils_array_util_finalize (CianoUtilsArrayUtil * obj)
{
	CianoUtilsArrayUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_UTILS_TYPE_ARRAY_UTIL, CianoUtilsArrayUtil);
	g_signal_handlers_destroy (self);
}

/**
     * The {@code ArrayUtil} class is responsible for managing arrays.
     *
     * @since 0.1.5
     */
static GType
ciano_utils_array_util_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_utils_value_array_util_init, ciano_utils_value_array_util_free_value, ciano_utils_value_array_util_copy_value, ciano_utils_value_array_util_peek_pointer, "p", ciano_utils_value_array_util_collect_value, "p", ciano_utils_value_array_util_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoUtilsArrayUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_utils_array_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoUtilsArrayUtil), 0, (GInstanceInitFunc) ciano_utils_array_util_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_utils_array_util_type_id;
	ciano_utils_array_util_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoUtilsArrayUtil", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ciano_utils_array_util_type_id;
}

GType
ciano_utils_array_util_get_type (void)
{
	static volatile gsize ciano_utils_array_util_type_id__once = 0;
	if (g_once_init_enter (&ciano_utils_array_util_type_id__once)) {
		GType ciano_utils_array_util_type_id;
		ciano_utils_array_util_type_id = ciano_utils_array_util_get_type_once ();
		g_once_init_leave (&ciano_utils_array_util_type_id__once, ciano_utils_array_util_type_id);
	}
	return ciano_utils_array_util_type_id__once;
}

gpointer
ciano_utils_array_util_ref (gpointer instance)
{
	CianoUtilsArrayUtil * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ciano_utils_array_util_unref (gpointer instance)
{
	CianoUtilsArrayUtil * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_UTILS_ARRAY_UTIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

