/* cheese-application.c generated by valac 0.56.13, the Vala compiler
 * generated from cheese-application.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "cheese-camera.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "cheese-gtk.h"
#include <gdk/gdk.h>
#include <stdio.h>
#include "config.h"
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>
#include "cheese-fileutil.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CHEESE_TYPE_APPLICATION (cheese_application_get_type ())
#define CHEESE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_APPLICATION, CheeseApplication))
#define CHEESE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_APPLICATION, CheeseApplicationClass))
#define CHEESE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_APPLICATION))
#define CHEESE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_APPLICATION))
#define CHEESE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_APPLICATION, CheeseApplicationClass))

typedef struct _CheeseApplication CheeseApplication;
typedef struct _CheeseApplicationClass CheeseApplicationClass;
typedef struct _CheeseApplicationPrivate CheeseApplicationPrivate;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
enum  {
	CHEESE_APPLICATION_0_PROPERTY,
	CHEESE_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* cheese_application_properties[CHEESE_APPLICATION_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _CheeseApplication {
	GtkApplication parent_instance;
	CheeseApplicationPrivate * priv;
};

struct _CheeseApplicationClass {
	GtkApplicationClass parent_class;
};

struct _CheeseApplicationPrivate {
	GSettings* settings;
	guint inhibited;
	CheeseCamera* camera;
	CheesePreferencesDialog* preferences_dialog;
	GtkShortcutsWindow* shortcuts_window;
};

static gint CheeseApplication_private_offset;
static gpointer cheese_application_parent_class = NULL;
static gchar* cheese_application_device;
static gchar* cheese_application_device = NULL;
static CheeseMainWindow* cheese_application_main_window;
static CheeseMainWindow* cheese_application_main_window = NULL;

VALA_EXTERN GType cheese_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseApplication, g_object_unref)
VALA_EXTERN GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheesePreferencesDialog, g_object_unref)
static void cheese_application_on_shoot (CheeseApplication* self);
static void _cheese_application_on_shoot_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void cheese_application_on_action_radio (CheeseApplication* self,
                                         GSimpleAction* action,
                                         GVariant* parameter);
static void _cheese_application_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void cheese_application_on_mode_change (CheeseApplication* self,
                                        GSimpleAction* action,
                                        GVariant* value);
static void _cheese_application_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self);
static void cheese_application_on_action_toggle (CheeseApplication* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _cheese_application_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void cheese_application_on_fullscreen_change (CheeseApplication* self,
                                              GSimpleAction* action,
                                              GVariant* value);
static void _cheese_application_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                    GVariant* value,
                                                                                    gpointer self);
static void cheese_application_on_wide_mode_change (CheeseApplication* self,
                                             GSimpleAction* action,
                                             GVariant* value);
static void _cheese_application_on_wide_mode_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                   GVariant* value,
                                                                                   gpointer self);
static void cheese_application_on_effects_change (CheeseApplication* self,
                                           GSimpleAction* action,
                                           GVariant* value);
static void _cheese_application_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                 GVariant* value,
                                                                                 gpointer self);
static void cheese_application_on_preferences (CheeseApplication* self);
static void _cheese_application_on_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void cheese_application_on_shortcuts (CheeseApplication* self);
static void _cheese_application_on_shortcuts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void cheese_application_on_help (CheeseApplication* self);
static void _cheese_application_on_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void cheese_application_on_about (CheeseApplication* self);
static void _cheese_application_on_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void cheese_application_on_quit (CheeseApplication* self);
static void _cheese_application_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
VALA_EXTERN GType cheese_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheeseMainWindow, g_object_unref)
VALA_EXTERN CheeseApplication* cheese_application_new (void);
VALA_EXTERN CheeseApplication* cheese_application_construct (GType object_type);
static void cheese_application_real_startup (GApplication* base);
static void cheese_application_common_init (CheeseApplication* self);
VALA_EXTERN CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
VALA_EXTERN CheeseMainWindow* cheese_main_window_construct (GType object_type,
                                                GtkApplication* application);
VALA_EXTERN void cheese_main_window_setup_ui (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
static gboolean cheese_application_on_webcam_key_pressed (CheeseApplication* self,
                                                   GdkEventKey* event);
static gboolean _cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                               GdkEventKey* event,
                                                                               gpointer self);
VALA_EXTERN void cheese_application_setup_camera (CheeseApplication* self);
VALA_EXTERN CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
VALA_EXTERN CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type,
                                                              CheeseCamera* camera);
static void cheese_application_on_preferences_enabled (CheeseApplication* self);
static void _cheese_application_on_preferences_enabled_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void cheese_application_real_activate (GApplication* base);
static gint cheese_application_real_command_line (GApplication* base,
                                           GApplicationCommandLine* cl);
static gint cheese_application_real_handle_local_options (GApplication* base,
                                                   GVariantDict* opts);
VALA_EXTERN ClutterActor* cheese_main_window_get_video_preview (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_show_error (CheeseMainWindow* self,
                                    const gchar* _error_);
static void cheese_application_on_camera_state_flags_changed (CheeseApplication* self,
                                                       GstState new_state);
static void _cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender,
                                                                                          GstState new_state,
                                                                                          gpointer self);
VALA_EXTERN void cheese_main_window_set_camera (CheeseMainWindow* self,
                                    CheeseCamera* camera);
VALA_EXTERN void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
static void cheese_application_update_mode (CheeseApplication* self,
                                     CheeseMediaMode mode);
VALA_EXTERN void cheese_main_window_set_current_mode (CheeseMainWindow* self,
                                          CheeseMediaMode mode);
VALA_EXTERN void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self,
                                                 CheeseMediaMode mode);
VALA_EXTERN void cheese_main_window_shoot (CheeseMainWindow* self);
VALA_EXTERN void cheese_main_window_set_fullscreen (CheeseMainWindow* self,
                                        gboolean fullscreen);
VALA_EXTERN void cheese_main_window_set_wide_mode (CheeseMainWindow* self,
                                       gboolean wide_mode);
VALA_EXTERN void cheese_main_window_set_effects (CheeseMainWindow* self,
                                     gboolean effects);
static void ___lambda7_ (CheeseApplication* self,
                  GtkWidget* event);
static void ____lambda7__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static void cheese_application_finalize (GObject * obj);
static GType cheese_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CHEESE_APPLICATION_action_entries[10] = {{"shoot", _cheese_application_on_shoot_gsimple_action_activate_callback}, {"mode", _cheese_application_on_action_radio_gsimple_action_activate_callback, "s", "'photo'", _cheese_application_on_mode_change_gsimple_action_change_state_callback}, {"fullscreen", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_fullscreen_change_gsimple_action_change_state_callback}, {"wide-mode", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_wide_mode_change_gsimple_action_change_state_callback}, {"effects", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_effects_change_gsimple_action_change_state_callback}, {"preferences", _cheese_application_on_preferences_gsimple_action_activate_callback}, {"shortcuts", _cheese_application_on_shortcuts_gsimple_action_activate_callback}, {"help", _cheese_application_on_help_gsimple_action_activate_callback}, {"about", _cheese_application_on_about_gsimple_action_activate_callback}, {"quit", _cheese_application_on_quit_gsimple_action_activate_callback}};
static const GOptionEntry CHEESE_APPLICATION_options[5] = {{"wide", 'w', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Start in wide mode"), NULL}, {"device", 'd', (gint) 0, G_OPTION_ARG_FILENAME, NULL, N_ ("Device to use as a camera"), N_ ("DEVICE")}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Output version information and exit"), NULL}, {"fullscreen", 'f', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Start in fullscreen mode"), NULL}, {NULL}};

static inline gpointer
cheese_application_get_instance_private (CheeseApplication* self)
{
	return G_STRUCT_MEMBER_P (self, CheeseApplication_private_offset);
}

static void
_cheese_application_on_shoot_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	cheese_application_on_shoot ((CheeseApplication*) self);
}

static void
_cheese_application_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	cheese_application_on_action_radio ((CheeseApplication*) self, action, parameter);
}

static void
_cheese_application_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self)
{
	cheese_application_on_mode_change ((CheeseApplication*) self, action, value);
}

static void
_cheese_application_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	cheese_application_on_action_toggle ((CheeseApplication*) self, action, parameter);
}

static void
_cheese_application_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                               GVariant* value,
                                                                               gpointer self)
{
	cheese_application_on_fullscreen_change ((CheeseApplication*) self, action, value);
}

static void
_cheese_application_on_wide_mode_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self)
{
	cheese_application_on_wide_mode_change ((CheeseApplication*) self, action, value);
}

static void
_cheese_application_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                            GVariant* value,
                                                                            gpointer self)
{
	cheese_application_on_effects_change ((CheeseApplication*) self, action, value);
}

static void
_cheese_application_on_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	cheese_application_on_preferences ((CheeseApplication*) self);
}

static void
_cheese_application_on_shortcuts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	cheese_application_on_shortcuts ((CheeseApplication*) self);
}

static void
_cheese_application_on_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	cheese_application_on_help ((CheeseApplication*) self);
}

static void
_cheese_application_on_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	cheese_application_on_about ((CheeseApplication*) self);
}

static void
_cheese_application_on_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	cheese_application_on_quit ((CheeseApplication*) self);
}

CheeseApplication*
cheese_application_construct (GType object_type)
{
	CheeseApplication * self = NULL;
	self = (CheeseApplication*) g_object_new (object_type, "application-id", "org.gnome.Cheese", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHEESE_APPLICATION_options);
	return self;
}

CheeseApplication*
cheese_application_new (void)
{
	return cheese_application_construct (CHEESE_TYPE_APPLICATION);
}

/**
     * Perform one-time initialization tasks.
     */
static void
cheese_application_real_startup (GApplication* base)
{
	CheeseApplication * self;
	GSettings* _tmp0_;
	gchar** args = NULL;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	gchar** arguments = NULL;
	gint arguments_length1;
	gint _arguments_size_;
	gboolean _tmp2_;
	self = (CheeseApplication*) base;
	_tmp0_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_APPLICATION_action_entries, (gint) G_N_ELEMENTS (CHEESE_APPLICATION_action_entries), self);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = NULL;
	args = _tmp1_;
	args_length1 = 1;
	_args_size_ = args_length1;
	arguments = args;
	arguments_length1 = args_length1;
	_arguments_size_ = arguments_length1;
	_tmp2_ = cheese_gtk_init ((gint*) (&arguments_length1), &arguments);
	_arguments_size_ = arguments_length1;
	if (!_tmp2_) {
		g_error ("cheese-application.vala:89: Unable to initialize libcheese-gtk");
	}
	G_APPLICATION_CLASS (cheese_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}

/**
     * Ensure that the main window has been shown, camera set up and so on.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                      GdkEventKey* event,
                                                                      gpointer self)
{
	gboolean result;
	result = cheese_application_on_webcam_key_pressed ((CheeseApplication*) self, event);
	return result;
}

static void
_cheese_application_on_preferences_enabled_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	cheese_application_on_preferences_enabled ((CheeseApplication*) self);
}

static void
cheese_application_common_init (CheeseApplication* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		GtkSettings* gtk_settings = NULL;
		GtkSettings* _tmp1_;
		GtkSettings* _tmp2_;
		GtkSettings* _tmp3_;
		CheeseMainWindow* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		CheeseMainWindow* _tmp9_;
		CheeseMainWindow* _tmp10_;
		CheeseMainWindow* _tmp11_;
		CheeseMainWindow* _tmp12_;
		CheeseMainWindow* _tmp13_;
		CheeseCamera* _tmp14_;
		CheesePreferencesDialog* _tmp15_;
		GAction* preferences = NULL;
		GAction* _tmp16_;
		GAction* _tmp17_;
		GAction* _tmp18_;
		CheeseMainWindow* _tmp19_;
		_tmp1_ = gtk_settings_get_default ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		gtk_settings = _tmp2_;
		_tmp3_ = gtk_settings;
		if (_tmp3_ != NULL) {
			GtkSettings* _tmp4_;
			_tmp4_ = gtk_settings;
			g_object_set (_tmp4_, "gtk-application-prefer-dark-theme", TRUE, NULL);
		}
		_tmp5_ = cheese_main_window_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (cheese_application_main_window);
		cheese_application_main_window = _tmp5_;
		g_setenv ("PULSE_PROP_media.role", "production", TRUE);
		g_set_application_name (_ ("Cheese"));
		gtk_window_set_default_icon_name ("org.gnome.Cheese");
		_tmp6_ = g_strdup ("space");
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) self, "app.shoot", _tmp8_);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		_tmp9_ = cheese_application_main_window;
		cheese_main_window_setup_ui (_tmp9_);
		_tmp10_ = cheese_application_main_window;
		cheese_main_window_start_thumbview_monitors (_tmp10_);
		_tmp11_ = cheese_application_main_window;
		gtk_widget_add_events ((GtkWidget*) _tmp11_, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
		_tmp12_ = cheese_application_main_window;
		g_signal_connect_object ((GtkWidget*) _tmp12_, "key-press-event", (GCallback) _cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event, self, 0);
		_tmp13_ = cheese_application_main_window;
		gtk_widget_show ((GtkWidget*) _tmp13_);
		cheese_application_setup_camera (self);
		_tmp14_ = self->priv->camera;
		_tmp15_ = cheese_preferences_dialog_new (_tmp14_);
		g_object_ref_sink (_tmp15_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp15_;
		_tmp16_ = g_action_map_lookup_action ((GActionMap*) self, "preferences");
		_tmp17_ = _g_object_ref0 (_tmp16_);
		preferences = _tmp17_;
		_tmp18_ = preferences;
		g_signal_connect_object ((GObject*) _tmp18_, "notify::enabled", (GCallback) _cheese_application_on_preferences_enabled_g_object_notify, self, 0);
		_tmp19_ = cheese_application_main_window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp19_);
		_g_object_unref0 (preferences);
		_g_object_unref0 (gtk_settings);
	}
}

/**
     * Present the existing main window, or create a new one.
     */
static void
cheese_application_real_activate (GApplication* base)
{
	CheeseApplication * self;
	GList* _tmp0_;
	self = (CheeseApplication*) base;
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		CheeseMainWindow* _tmp1_;
		_tmp1_ = cheese_application_main_window;
		gtk_window_present ((GtkWindow*) _tmp1_);
	} else {
		cheese_application_common_init (self);
	}
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
cheese_application_real_command_line (GApplication* base,
                                      GApplicationCommandLine* cl)
{
	CheeseApplication * self;
	GVariantDict* opts = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	GVariantDict* _tmp7_;
	GVariantDict* _tmp8_;
	gint result;
	self = (CheeseApplication*) base;
	g_return_val_if_fail (cl != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (cl);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	opts = _tmp1_;
	_tmp2_ = opts;
	_tmp4_ = g_variant_dict_lookup (_tmp2_, "device", "^ay", &_tmp3_, NULL, NULL);
	_g_free0 (cheese_application_device);
	cheese_application_device = _tmp3_;
	if (_tmp4_) {
		GSettings* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->settings;
		_tmp6_ = cheese_application_device;
		g_settings_set_string (_tmp5_, "camera", _tmp6_);
	}
	_tmp7_ = opts;
	if (g_variant_dict_contains (_tmp7_, "fullscreen")) {
		g_action_group_activate_action ((GActionGroup*) self, "fullscreen", NULL);
	}
	_tmp8_ = opts;
	if (g_variant_dict_contains (_tmp8_, "wide")) {
		g_action_group_activate_action ((GActionGroup*) self, "wide-mode", NULL);
	}
	g_application_activate ((GApplication*) self);
	result = 0;
	_g_variant_dict_unref0 (opts);
	return result;
}

static gint
cheese_application_real_handle_local_options (GApplication* base,
                                              GVariantDict* opts)
{
	CheeseApplication * self;
	gint result;
	self = (CheeseApplication*) base;
	g_return_val_if_fail (opts != NULL, 0);
	if (g_variant_dict_contains (opts, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

/**
     * Setup the camera listed in GSettings.
     */
static void
_cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender,
                                                                                     GstState new_state,
                                                                                     gpointer self)
{
	cheese_application_on_camera_state_flags_changed ((CheeseApplication*) self, new_state);
}

void
cheese_application_setup_camera (CheeseApplication* self)
{
	GSimpleAction* effects = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* mode = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* shoot = NULL;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	const gchar* _tmp9_;
	ClutterActor* video_preview = NULL;
	CheeseMainWindow* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	const gchar* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	CheeseCamera* _tmp18_;
	gdouble value = 0.0;
	GSettings* _tmp26_;
	GSettings* _tmp28_;
	GSettings* _tmp30_;
	GSettings* _tmp32_;
	CheeseCamera* _tmp34_;
	CheeseMainWindow* _tmp35_;
	CheeseCamera* _tmp36_;
	CheeseCamera* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	shoot = _tmp5_;
	_tmp6_ = effects;
	g_simple_action_set_enabled (_tmp6_, FALSE);
	_tmp7_ = mode;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = shoot;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = cheese_application_device;
	if (_tmp9_ == NULL) {
		GSettings* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_string (_tmp10_, "camera");
		_g_free0 (cheese_application_device);
		cheese_application_device = _tmp11_;
	}
	_tmp12_ = cheese_application_main_window;
	_tmp13_ = cheese_main_window_get_video_preview (_tmp12_);
	video_preview = _tmp13_;
	_tmp14_ = video_preview;
	_tmp15_ = cheese_application_device;
	_tmp16_ = self->priv->settings;
	_tmp17_ = self->priv->settings;
	_tmp18_ = cheese_camera_new (_tmp14_, _tmp15_, g_settings_get_int (_tmp16_, "photo-x-resolution"), g_settings_get_int (_tmp17_, "photo-y-resolution"));
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp18_;
	{
		CheeseCamera* _tmp19_;
		_tmp19_ = self->priv->camera;
		cheese_camera_setup (_tmp19_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		ClutterActor* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		CheeseMainWindow* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = video_preview;
		clutter_actor_hide (_tmp20_);
		_tmp21_ = err;
		_tmp22_ = _tmp21_->message;
		g_message ("cheese-application.vala:222: Error during camera setup: %s\n", _tmp22_);
		_tmp23_ = cheese_application_main_window;
		_tmp24_ = err;
		_tmp25_ = _tmp24_->message;
		cheese_main_window_show_error (_tmp23_, _tmp25_);
		_g_error_free0 (err);
		_g_object_unref0 (video_preview);
		_g_object_unref0 (shoot);
		_g_object_unref0 (mode);
		_g_object_unref0 (effects);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (video_preview);
		_g_object_unref0 (shoot);
		_g_object_unref0 (mode);
		_g_object_unref0 (effects);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp26_ = self->priv->settings;
	value = g_settings_get_double (_tmp26_, "brightness");
	if (value != 0.0) {
		CheeseCamera* _tmp27_;
		_tmp27_ = self->priv->camera;
		cheese_camera_set_balance_property (_tmp27_, "brightness", value);
	}
	_tmp28_ = self->priv->settings;
	value = g_settings_get_double (_tmp28_, "contrast");
	if (value != 1.0) {
		CheeseCamera* _tmp29_;
		_tmp29_ = self->priv->camera;
		cheese_camera_set_balance_property (_tmp29_, "contrast", value);
	}
	_tmp30_ = self->priv->settings;
	value = g_settings_get_double (_tmp30_, "hue");
	if (value != 0.0) {
		CheeseCamera* _tmp31_;
		_tmp31_ = self->priv->camera;
		cheese_camera_set_balance_property (_tmp31_, "hue", value);
	}
	_tmp32_ = self->priv->settings;
	value = g_settings_get_double (_tmp32_, "saturation");
	if (value != 1.0) {
		CheeseCamera* _tmp33_;
		_tmp33_ = self->priv->camera;
		cheese_camera_set_balance_property (_tmp33_, "saturation", value);
	}
	_tmp34_ = self->priv->camera;
	g_signal_connect_object (_tmp34_, "state-flags-changed", (GCallback) _cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed, self, 0);
	_tmp35_ = cheese_application_main_window;
	_tmp36_ = self->priv->camera;
	cheese_main_window_set_camera (_tmp35_, _tmp36_);
	_tmp37_ = self->priv->camera;
	cheese_camera_play (_tmp37_);
	_g_object_unref0 (video_preview);
	_g_object_unref0 (shoot);
	_g_object_unref0 (mode);
	_g_object_unref0 (effects);
}

/**
     * Handle the webcam take photo button being pressed.
     *
     * @param event the Gdk.KeyEvent
     * @return true to stop other handlers being invoked, false to propagate
     * the event further
     */
static gboolean
cheese_application_on_webcam_key_pressed (CheeseApplication* self,
                                          GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->state != 0) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if ((event->state & GDK_CONTROL_MASK) != 0) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = (event->state & GDK_MOD1_MASK) != 0;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = (event->state & GDK_MOD3_MASK) != 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = (event->state & GDK_MOD4_MASK) != 0;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = (event->state & GDK_MOD5_MASK) != 0;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	switch (event->keyval) {
		case GDK_KEY_WebCam:
		{
			g_action_group_activate_action ((GActionGroup*) self, "shoot", NULL);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

/**
     * Handle the camera state changing.
     *
     * @param new_state the new Cheese.Camera state
     */
static void
cheese_application_on_camera_state_flags_changed (CheeseApplication* self,
                                                  GstState new_state)
{
	GSimpleAction* effects = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* mode = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* shoot = NULL;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	shoot = _tmp5_;
	switch (new_state) {
		case GST_STATE_PLAYING:
		{
			GSimpleAction* _tmp6_;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			gboolean _tmp10_;
			GSimpleAction* _tmp15_;
			CheeseMainWindow* _tmp16_;
			CheeseMainWindow* _tmp17_;
			_tmp6_ = effects;
			_tmp7_ = g_action_get_state ((GAction*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp10_ = g_variant_get_boolean (_tmp9_);
			_g_variant_unref0 (_tmp9_);
			if (_tmp10_) {
				GSimpleAction* _tmp11_;
				GSimpleAction* _tmp12_;
				_tmp11_ = mode;
				g_simple_action_set_enabled (_tmp11_, FALSE);
				_tmp12_ = shoot;
				g_simple_action_set_enabled (_tmp12_, FALSE);
			} else {
				GSimpleAction* _tmp13_;
				GSimpleAction* _tmp14_;
				_tmp13_ = mode;
				g_simple_action_set_enabled (_tmp13_, TRUE);
				_tmp14_ = shoot;
				g_simple_action_set_enabled (_tmp14_, TRUE);
			}
			_tmp15_ = effects;
			g_simple_action_set_enabled (_tmp15_, TRUE);
			_tmp16_ = cheese_application_main_window;
			cheese_main_window_camera_state_change_playing (_tmp16_);
			_tmp17_ = cheese_application_main_window;
			self->priv->inhibited = gtk_application_inhibit ((GtkApplication*) self, (GtkWindow*) _tmp17_, GTK_APPLICATION_INHIBIT_SWITCH | GTK_APPLICATION_INHIBIT_IDLE, _ ("Webcam in use"));
			break;
		}
		case GST_STATE_NULL:
		{
			GSimpleAction* _tmp18_;
			GSimpleAction* _tmp19_;
			GSimpleAction* _tmp20_;
			CheeseMainWindow* _tmp21_;
			_tmp18_ = effects;
			g_simple_action_set_enabled (_tmp18_, FALSE);
			_tmp19_ = mode;
			g_simple_action_set_enabled (_tmp19_, FALSE);
			_tmp20_ = shoot;
			g_simple_action_set_enabled (_tmp20_, FALSE);
			_tmp21_ = cheese_application_main_window;
			cheese_main_window_camera_state_change_null (_tmp21_);
			if (self->priv->inhibited != ((guint) 0)) {
				gtk_application_uninhibit ((GtkApplication*) self, self->priv->inhibited);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_g_object_unref0 (shoot);
	_g_object_unref0 (mode);
	_g_object_unref0 (effects);
}

/**
     * Update the current capture mode in the main window and preferences
     * dialog.
     *
     * @param mode the mode to set
     */
static void
cheese_application_update_mode (CheeseApplication* self,
                                CheeseMediaMode mode)
{
	CheeseMainWindow* _tmp0_;
	CheesePreferencesDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	cheese_main_window_set_current_mode (_tmp0_, mode);
	_tmp1_ = self->priv->preferences_dialog;
	cheese_preferences_dialog_set_current_mode (_tmp1_, mode);
}

/**
     * Handle radio actions by setting the new state.
     *
     * @param action the action which was triggered
     * @param parameter the new value to set on the action
     */
static void
cheese_application_on_action_radio (CheeseApplication* self,
                                    GSimpleAction* action,
                                    GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_signal_emit_by_name (action, "change-state", parameter);
}

/**
     * Handle toggle actions by toggling the current state.
     *
     * @param action the action which was triggered
     * @param parameter unused
     */
static void
cheese_application_on_action_toggle (CheeseApplication* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	GVariant* state = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	state = _tmp0_;
	_tmp1_ = g_variant_new_boolean (!g_variant_get_boolean (state));
	g_variant_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (action, "change-state", _tmp2_);
	_g_variant_unref0 (_tmp2_);
	_g_variant_unref0 (state);
}

/**
     * Handle the shoot action being activated.
     */
static void
cheese_application_on_shoot (CheeseApplication* self)
{
	CheeseMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	cheese_main_window_shoot (_tmp0_);
}

/**
     * Handle the fullscreen state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void
cheese_application_on_fullscreen_change (CheeseApplication* self,
                                         GSimpleAction* action,
                                         GVariant* value)
{
	gboolean state = FALSE;
	CheeseMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	state = g_variant_get_boolean (value);
	cheese_application_common_init (self);
	_tmp0_ = cheese_application_main_window;
	cheese_main_window_set_fullscreen (_tmp0_, state);
	g_simple_action_set_state (action, value);
}

/**
     * Handle the wide-mode state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void
cheese_application_on_wide_mode_change (CheeseApplication* self,
                                        GSimpleAction* action,
                                        GVariant* value)
{
	gboolean state = FALSE;
	CheeseMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	state = g_variant_get_boolean (value);
	cheese_application_common_init (self);
	_tmp0_ = cheese_application_main_window;
	cheese_main_window_set_wide_mode (_tmp0_, state);
	g_simple_action_set_state (action, value);
}

/**
     * Handle the effects state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void
cheese_application_on_effects_change (CheeseApplication* self,
                                      GSimpleAction* action,
                                      GVariant* value)
{
	gboolean state = FALSE;
	GSimpleAction* shoot = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* mode = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	CheeseMainWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	state = g_variant_get_boolean (value);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	shoot = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	g_simple_action_set_enabled (shoot, !state);
	g_simple_action_set_enabled (mode, !state);
	_tmp4_ = cheese_application_main_window;
	cheese_main_window_set_effects (_tmp4_, state);
	g_simple_action_set_state (action, value);
	_g_object_unref0 (mode);
	_g_object_unref0 (shoot);
}

/**
     * Change the media capture mode (photo, video or burst).
     *
     * @param action the action that emitted the signal
     * @param parameter the mode to switch to, or null
     */
static void
cheese_application_on_mode_change (CheeseApplication* self,
                                   GSimpleAction* action,
                                   GVariant* value)
{
	gchar* state = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = g_variant_get_string (value, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	state = _tmp1_;
	_tmp2_ = state;
	if (g_strcmp0 (_tmp2_, "photo") == 0) {
		cheese_application_update_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = state;
		if (g_strcmp0 (_tmp3_, "video") == 0) {
			cheese_application_update_mode (self, CHEESE_MEDIA_MODE_VIDEO);
		} else {
			const gchar* _tmp4_;
			_tmp4_ = state;
			if (g_strcmp0 (_tmp4_, "burst") == 0) {
				cheese_application_update_mode (self, CHEESE_MEDIA_MODE_BURST);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	g_simple_action_set_state (action, value);
	_g_free0 (state);
}

/**
     * Show the preferences dialog.
     */
static void
cheese_application_on_preferences (CheeseApplication* self)
{
	CheesePreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

/**
     * Show the keyboard shortcuts.
     */
static void
___lambda7_ (CheeseApplication* self,
             GtkWidget* event)
{
	g_return_if_fail (event != NULL);
	_g_object_unref0 (self->priv->shortcuts_window);
	self->priv->shortcuts_window = NULL;
}

static void
____lambda7__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	___lambda7_ ((CheeseApplication*) self, _sender);
}

static void
cheese_application_on_shortcuts (CheeseApplication* self)
{
	GtkShortcutsWindow* _tmp0_;
	GtkWindow* _tmp8_;
	GtkShortcutsWindow* _tmp9_;
	GtkWindow* _tmp10_;
	GtkShortcutsWindow* _tmp13_;
	GtkShortcutsWindow* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shortcuts_window;
	if (_tmp0_ == NULL) {
		GtkBuilder* builder = NULL;
		GtkBuilder* _tmp1_;
		GtkBuilder* _tmp4_;
		GObject* _tmp5_;
		GtkShortcutsWindow* _tmp6_;
		GtkShortcutsWindow* _tmp7_;
		_tmp1_ = gtk_builder_new ();
		builder = _tmp1_;
		{
			GtkBuilder* _tmp2_;
			_tmp2_ = builder;
			gtk_builder_add_from_resource (_tmp2_, "/org/gnome/Cheese/shortcuts.ui", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e->message;
			g_error ("cheese-application.vala:497: Error loading shortcuts window UI: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = builder;
		_tmp5_ = gtk_builder_get_object (_tmp4_, "shortcuts-cheese");
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_shortcuts_window_get_type ()) ? ((GtkShortcutsWindow*) _tmp5_) : NULL);
		_g_object_unref0 (self->priv->shortcuts_window);
		self->priv->shortcuts_window = _tmp6_;
		_tmp7_ = self->priv->shortcuts_window;
		g_signal_connect_object ((GtkWidget*) _tmp7_, "destroy", (GCallback) ____lambda7__gtk_widget_destroy, self, 0);
		_g_object_unref0 (builder);
	}
	_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp9_ = self->priv->shortcuts_window;
	_tmp10_ = gtk_window_get_transient_for ((GtkWindow*) _tmp9_);
	if (_tmp8_ != _tmp10_) {
		GtkShortcutsWindow* _tmp11_;
		GtkWindow* _tmp12_;
		_tmp11_ = self->priv->shortcuts_window;
		_tmp12_ = gtk_application_get_active_window ((GtkApplication*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
	}
	_tmp13_ = self->priv->shortcuts_window;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->shortcuts_window;
	gtk_window_present ((GtkWindow*) _tmp14_);
}

/**
     * Show the Cheese help contents.
     */
static void
cheese_application_on_help (CheeseApplication* self)
{
	GdkScreen* screen = NULL;
	CheeseMainWindow* _tmp0_;
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	{
		gtk_show_uri (screen, "help:cheese", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_message ("cheese-application.vala:523: Error opening help: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (screen);
}

/**
     * Show the about dialog.
     */
static void
cheese_application_on_about (CheeseApplication* self)
{
	gchar** artists = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint artists_length1;
	gint _artists_size_;
	gchar** authors = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gint documenters_length1;
	gint _documenters_size_;
	CheeseMainWindow* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Andreas Nilsson <andreas@andreasn.se>");
	_tmp1_ = g_strdup ("Josef Vybíral <josef.vybiral@gmail.com>");
	_tmp2_ = g_strdup ("Kalle Persson <kalle@kallepersson.se>");
	_tmp3_ = g_strdup ("Lapo Calamandrei <calamandrei@gmail.com>");
	_tmp4_ = g_strdup ("Or Dvory <gnudles@nana.co.il>");
	_tmp5_ = g_strdup ("Ulisse Perusin <ulisail@yahoo.it>");
	_tmp6_ = g_new0 (gchar*, 7 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	_tmp6_[6] = NULL;
	artists = _tmp6_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp7_ = g_strdup ("daniel g. siegel <dgsiegel@gnome.org>");
	_tmp8_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp9_ = g_strdup ("Filippo Argiolas <fargiolas@gnome.org>");
	_tmp10_ = g_strdup ("Yuvaraj Pandian T <yuvipanda@yuvi.in>");
	_tmp11_ = g_strdup ("Luciana Fujii Pontello <luciana@fujii.eti.br>");
	_tmp12_ = g_strdup ("David King <amigadave@amigadave.com>");
	_tmp13_ = g_strdup ("");
	_tmp14_ = g_strdup ("Aidan Delaney <a.j.delaney@brighton.ac.uk>");
	_tmp15_ = g_strdup ("Alex \"weej\" Jones <alex@weej.com>");
	_tmp16_ = g_strdup ("Andrea Cimitan <andrea.cimitan@gmail.com>");
	_tmp17_ = g_strdup ("Baptiste Mille-Mathias <bmm80@free.fr>");
	_tmp18_ = g_strdup ("Cosimo Cecchi <anarki@lilik.it>");
	_tmp19_ = g_strdup ("Diego Escalante Urrelo <dieguito@gmail.com>");
	_tmp20_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp21_ = g_strdup ("Gintautas Miliauskas <gintas@akl.lt>");
	_tmp22_ = g_strdup ("Hans de Goede <jwrdegoede@fedoraproject.org>");
	_tmp23_ = g_strdup ("James Liggett <jrliggett@cox.net>");
	_tmp24_ = g_strdup ("Luca Ferretti <elle.uca@libero.it>");
	_tmp25_ = g_strdup ("Mirco \"MacSlow\" Müller <macslow@bangang.de>");
	_tmp26_ = g_strdup ("Patryk Zawadzki <patrys@pld-linux.org>");
	_tmp27_ = g_strdup ("Ryan Zeigler <zeiglerr@gmail.com>");
	_tmp28_ = g_strdup ("Sebastian Keller <sebastian-keller@gmx.de>");
	_tmp29_ = g_strdup ("Steve Magoun <steve.magoun@canonical.com>");
	_tmp30_ = g_strdup ("Thomas Perl <thp@thpinfo.com>");
	_tmp31_ = g_strdup ("Tim Philipp Müller <tim@centricular.net>");
	_tmp32_ = g_strdup ("Todd Eisenberger <teisenberger@gmail.com>");
	_tmp33_ = g_strdup ("Tommi Vainikainen <thv@iki.fi>");
	_tmp34_ = g_new0 (gchar*, 28 + 1);
	_tmp34_[0] = _tmp7_;
	_tmp34_[1] = _tmp8_;
	_tmp34_[2] = _tmp9_;
	_tmp34_[3] = _tmp10_;
	_tmp34_[4] = _tmp11_;
	_tmp34_[5] = _tmp12_;
	_tmp34_[6] = _tmp13_;
	_tmp34_[7] = _tmp14_;
	_tmp34_[8] = _tmp15_;
	_tmp34_[9] = _tmp16_;
	_tmp34_[10] = _tmp17_;
	_tmp34_[11] = _tmp18_;
	_tmp34_[12] = _tmp19_;
	_tmp34_[13] = _tmp20_;
	_tmp34_[14] = _tmp21_;
	_tmp34_[15] = _tmp22_;
	_tmp34_[16] = _tmp23_;
	_tmp34_[17] = _tmp24_;
	_tmp34_[18] = _tmp25_;
	_tmp34_[19] = _tmp26_;
	_tmp34_[20] = _tmp27_;
	_tmp34_[21] = _tmp28_;
	_tmp34_[22] = _tmp29_;
	_tmp34_[23] = _tmp30_;
	_tmp34_[24] = _tmp31_;
	_tmp34_[25] = _tmp32_;
	_tmp34_[26] = _tmp33_;
	_tmp34_[27] = NULL;
	authors = _tmp34_;
	authors_length1 = 28;
	_authors_size_ = authors_length1;
	_tmp35_ = g_strdup ("Joshua Henderson <joshhendo@gmail.com>");
	_tmp36_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp37_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp38_ = g_new0 (gchar*, 4 + 1);
	_tmp38_[0] = _tmp35_;
	_tmp38_[1] = _tmp36_;
	_tmp38_[2] = _tmp37_;
	_tmp38_[3] = NULL;
	documenters = _tmp38_;
	documenters_length1 = 4;
	_documenters_size_ = documenters_length1;
	_tmp39_ = cheese_application_main_window;
	gtk_show_about_dialog ((GtkWindow*) _tmp39_, "artists", artists, "authors", authors, "comments", _ ("Take photos and videos with your webcam, with fun graphical effects"), "copyright", "Copyright © 2011 - 2014 David King <amigadave@amigadave.com>\n" \
"Copyright © 2007 - 2011 daniel g. siegel <dgsiegel@gnome.org>", "documenters", documenters, "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", "org.gnome.Cheese", "program-name", _ ("Cheese"), "translator-credits", _ ("translator-credits"), "website", PACKAGE_URL, "website-label", _ ("Cheese Website"), "version", PACKAGE_VERSION, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}

/**
     * Destroy the main window, and shutdown the application, when quitting.
     */
static void
cheese_application_on_quit (CheeseApplication* self)
{
	CheeseMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

/**
     * Close the preferences dialog when the preferences action is disabled.
     */
static void
cheese_application_on_preferences_enabled (CheeseApplication* self)
{
	GAction* preferences = NULL;
	GAction* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "preferences");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	preferences = _tmp1_;
	_tmp2_ = preferences;
	_tmp3_ = g_action_get_enabled (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		CheesePreferencesDialog* _tmp5_;
		_tmp5_ = self->priv->preferences_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	_g_object_unref0 (preferences);
}

static void
cheese_application_class_init (CheeseApplicationClass * klass,
                               gpointer klass_data)
{
	cheese_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheeseApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) cheese_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) cheese_application_real_activate;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) cheese_application_real_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) cheese_application_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = cheese_application_finalize;
}

static void
cheese_application_instance_init (CheeseApplication * self,
                                  gpointer klass)
{
	self->priv = cheese_application_get_instance_private (self);
	self->priv->inhibited = (guint) 0;
}

static void
cheese_application_finalize (GObject * obj)
{
	CheeseApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_APPLICATION, CheeseApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->shortcuts_window);
	G_OBJECT_CLASS (cheese_application_parent_class)->finalize (obj);
}

static GType
cheese_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheeseApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseApplication), 0, (GInstanceInitFunc) cheese_application_instance_init, NULL };
	GType cheese_application_type_id;
	cheese_application_type_id = g_type_register_static (gtk_application_get_type (), "CheeseApplication", &g_define_type_info, 0);
	CheeseApplication_private_offset = g_type_add_instance_private (cheese_application_type_id, sizeof (CheeseApplicationPrivate));
	return cheese_application_type_id;
}

GType
cheese_application_get_type (void)
{
	static volatile gsize cheese_application_type_id__once = 0;
	if (g_once_init_enter (&cheese_application_type_id__once)) {
		GType cheese_application_type_id;
		cheese_application_type_id = cheese_application_get_type_once ();
		g_once_init_leave (&cheese_application_type_id__once, cheese_application_type_id);
	}
	return cheese_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

