/* run_rule.c generated by valac 0.56.14, the Vala compiler
 * generated from run_rule.vala, do not modify */

/*
* ShufflerIII
* Author: Jacob Vlijm
* Copyright © 2017s Ubuntu Budgie Developers
* Website=https://ubuntubudgie.org
* This program is free software: you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation, either version 3 of the License, or any later version.
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details. You should have received a copy of the GNU General Public
* License along with this prgram.  If not, see
* <https://www.gnu.org/licenses/>.
*/
/* valac --pkg gio-2.0*/
/*
/ args: wm_class, xid
*/

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdio.h>
#include <config.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT (apply_rule_shuffler_info_client_get_type ())
#define APPLY_RULE_SHUFFLER_INFO_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT, ApplyRuleShufflerInfoClient))
#define APPLY_RULE_IS_SHUFFLER_INFO_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT))
#define APPLY_RULE_SHUFFLER_INFO_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT, ApplyRuleShufflerInfoClientIface))

typedef struct _ApplyRuleShufflerInfoClient ApplyRuleShufflerInfoClient;
typedef struct _ApplyRuleShufflerInfoClientIface ApplyRuleShufflerInfoClientIface;

#define APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT_PROXY (apply_rule_shuffler_info_client_proxy_get_type ())
typedef GDBusProxy ApplyRuleShufflerInfoClientProxy;
typedef GDBusProxyClass ApplyRuleShufflerInfoClientProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ApplyRuleShufflerInfoClientIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_rules) (ApplyRuleShufflerInfoClient* self, GError** error);
	GHashTable* (*get_monitorgeometry) (ApplyRuleShufflerInfoClient* self, GError** error);
	GHashTable* (*get_winsdata) (ApplyRuleShufflerInfoClient* self, GError** error);
};

VALA_EXTERN GHashTable* apply_rule_windowrules;
GHashTable* apply_rule_windowrules = NULL;
VALA_EXTERN GHashTable* apply_rule_monitordata;
GHashTable* apply_rule_monitordata = NULL;
VALA_EXTERN ApplyRuleShufflerInfoClient* apply_rule_client;
ApplyRuleShufflerInfoClient* apply_rule_client = NULL;

VALA_EXTERN GType apply_rule_shuffler_info_client_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint apply_rule_shuffler_info_client_register_object (void* object,
                                                       GDBusConnection* connection,
                                                       const gchar* path,
                                                       GError** error);
VALA_EXTERN GType apply_rule_shuffler_info_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ApplyRuleShufflerInfoClient, g_object_unref)
VALA_EXTERN GHashTable* apply_rule_shuffler_info_client_get_rules (ApplyRuleShufflerInfoClient* self,
                                                       GError** error);
VALA_EXTERN GHashTable* apply_rule_shuffler_info_client_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                                 GError** error);
VALA_EXTERN GHashTable* apply_rule_shuffler_info_client_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                                          GError** error);
static GType apply_rule_shuffler_info_client_get_type_once (void);
static void apply_rule_shuffler_info_client_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters);
static GHashTable* apply_rule_shuffler_info_client_proxy_get_rules (ApplyRuleShufflerInfoClient* self,
                                                             GError** error);
static GHashTable* apply_rule_shuffler_info_client_proxy_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                                       GError** error);
static GHashTable* apply_rule_shuffler_info_client_proxy_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                                                GError** error);
static void apply_rule_shuffler_info_client_proxy_apply_rule_shuffler_info_client_interface_init (ApplyRuleShufflerInfoClientIface* iface);
static void _dbus_apply_rule_shuffler_info_client_get_rules (ApplyRuleShufflerInfoClient* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_apply_rule_shuffler_info_client_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation);
static void _dbus_apply_rule_shuffler_info_client_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void apply_rule_shuffler_info_client_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data);
static GVariant* apply_rule_shuffler_info_client_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data);
static gboolean apply_rule_shuffler_info_client_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data);
static void _apply_rule_shuffler_info_client_unregister_object (gpointer user_data);
VALA_EXTERN gboolean apply_rule_string_inlist (const gchar* lookfor,
                                   gchar** arr,
                                   gint arr_length1);
VALA_EXTERN void apply_rule_run_command (const gchar* cmd);
VALA_EXTERN gchar* apply_rule_fixed_newclass (const gchar* xid);
static gchar* _variant_get1 (GVariant* value);
static void apply_rule_main (gchar** args,
                      gint args_length1);
static gchar* _variant_get2 (GVariant* value);
static gchar* _variant_get3 (GVariant* value);
static gchar* _variant_get4 (GVariant* value);
static gchar* _variant_get5 (GVariant* value);
static gchar* _variant_get6 (GVariant* value);
static gchar* _variant_get7 (GVariant* value);
static gchar* _variant_get8 (GVariant* value);
static gchar* _variant_get9 (GVariant* value);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _apply_rule_shuffler_info_client_dbus_arg_info_get_rules_result = {-1, "result", "a{sv}", NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_rules_in[] = {NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_rules_out[] = {&_apply_rule_shuffler_info_client_dbus_arg_info_get_rules_result, NULL};
static const GDBusMethodInfo _apply_rule_shuffler_info_client_dbus_method_info_get_rules = {-1, "GetRules", (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_rules_in), (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_rules_out), NULL};
static const GDBusArgInfo _apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_result = {-1, "result", "a{sv}", NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_in[] = {NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_out[] = {&_apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_result, NULL};
static const GDBusMethodInfo _apply_rule_shuffler_info_client_dbus_method_info_get_monitorgeometry = {-1, "GetMonitorgeometry", (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_in), (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_monitorgeometry_out), NULL};
static const GDBusArgInfo _apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_result = {-1, "result", "a{sv}", NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_in[] = {NULL};
static const GDBusArgInfo * const _apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_out[] = {&_apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_result, NULL};
static const GDBusMethodInfo _apply_rule_shuffler_info_client_dbus_method_info_get_winsdata = {-1, "GetWinsdata", (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_in), (GDBusArgInfo **) (&_apply_rule_shuffler_info_client_dbus_arg_info_get_winsdata_out), NULL};
static const GDBusMethodInfo * const _apply_rule_shuffler_info_client_dbus_method_info[] = {&_apply_rule_shuffler_info_client_dbus_method_info_get_rules, &_apply_rule_shuffler_info_client_dbus_method_info_get_monitorgeometry, &_apply_rule_shuffler_info_client_dbus_method_info_get_winsdata, NULL};
static const GDBusSignalInfo * const _apply_rule_shuffler_info_client_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _apply_rule_shuffler_info_client_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _apply_rule_shuffler_info_client_dbus_interface_info = {-1, "org.UbuntuBudgie.ShufflerInfoDaemon", (GDBusMethodInfo **) (&_apply_rule_shuffler_info_client_dbus_method_info), (GDBusSignalInfo **) (&_apply_rule_shuffler_info_client_dbus_signal_info), (GDBusPropertyInfo **) (&_apply_rule_shuffler_info_client_dbus_property_info), NULL};
static const GDBusInterfaceVTable _apply_rule_shuffler_info_client_dbus_interface_vtable = {apply_rule_shuffler_info_client_dbus_interface_method_call, apply_rule_shuffler_info_client_dbus_interface_get_property, apply_rule_shuffler_info_client_dbus_interface_set_property};

GHashTable*
apply_rule_shuffler_info_client_get_rules (ApplyRuleShufflerInfoClient* self,
                                           GError** error)
{
	ApplyRuleShufflerInfoClientIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = APPLY_RULE_SHUFFLER_INFO_CLIENT_GET_INTERFACE (self);
	if (_iface_->get_rules) {
		return _iface_->get_rules (self, error);
	}
	return NULL;
}

GHashTable*
apply_rule_shuffler_info_client_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                     GError** error)
{
	ApplyRuleShufflerInfoClientIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = APPLY_RULE_SHUFFLER_INFO_CLIENT_GET_INTERFACE (self);
	if (_iface_->get_monitorgeometry) {
		return _iface_->get_monitorgeometry (self, error);
	}
	return NULL;
}

GHashTable*
apply_rule_shuffler_info_client_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                              GError** error)
{
	ApplyRuleShufflerInfoClientIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = APPLY_RULE_SHUFFLER_INFO_CLIENT_GET_INTERFACE (self);
	if (_iface_->get_winsdata) {
		return _iface_->get_winsdata (self, error);
	}
	return NULL;
}

static void
apply_rule_shuffler_info_client_default_init (ApplyRuleShufflerInfoClientIface * iface,
                                              gpointer iface_data)
{
}

static GType
apply_rule_shuffler_info_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplyRuleShufflerInfoClientIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) apply_rule_shuffler_info_client_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType apply_rule_shuffler_info_client_type_id;
	apply_rule_shuffler_info_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "ApplyRuleShufflerInfoClient", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (apply_rule_shuffler_info_client_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (apply_rule_shuffler_info_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) apply_rule_shuffler_info_client_proxy_get_type);
	g_type_set_qdata (apply_rule_shuffler_info_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.UbuntuBudgie.ShufflerInfoDaemon");
	g_type_set_qdata (apply_rule_shuffler_info_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_apply_rule_shuffler_info_client_dbus_interface_info));
	g_type_set_qdata (apply_rule_shuffler_info_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) apply_rule_shuffler_info_client_register_object);
	return apply_rule_shuffler_info_client_type_id;
}

GType
apply_rule_shuffler_info_client_get_type (void)
{
	static volatile gsize apply_rule_shuffler_info_client_type_id__once = 0;
	if (g_once_init_enter (&apply_rule_shuffler_info_client_type_id__once)) {
		GType apply_rule_shuffler_info_client_type_id;
		apply_rule_shuffler_info_client_type_id = apply_rule_shuffler_info_client_get_type_once ();
		g_once_init_leave (&apply_rule_shuffler_info_client_type_id__once, apply_rule_shuffler_info_client_type_id);
	}
	return apply_rule_shuffler_info_client_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (ApplyRuleShufflerInfoClientProxy, apply_rule_shuffler_info_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT, apply_rule_shuffler_info_client_proxy_apply_rule_shuffler_info_client_interface_init) )
static void
apply_rule_shuffler_info_client_proxy_class_init (ApplyRuleShufflerInfoClientProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = apply_rule_shuffler_info_client_proxy_g_signal;
}

static void
apply_rule_shuffler_info_client_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters)
{
}

static void
apply_rule_shuffler_info_client_proxy_init (ApplyRuleShufflerInfoClientProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_apply_rule_shuffler_info_client_dbus_interface_info));
}

static GHashTable*
apply_rule_shuffler_info_client_proxy_get_rules (ApplyRuleShufflerInfoClient* self,
                                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result = NULL;
	GVariant* _tmp0_;
	GHashTable* _tmp1_;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.UbuntuBudgie.ShufflerInfoDaemon", "GetRules");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp2_, _tmp0_);
	while (g_variant_iter_loop (&_tmp2_, "{?*}", &_tmp3_, &_tmp4_)) {
		g_hash_table_insert (_tmp1_, g_variant_dup_string (_tmp3_, NULL), g_variant_get_variant (_tmp4_));
	}
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static GHashTable*
apply_rule_shuffler_info_client_proxy_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result = NULL;
	GVariant* _tmp5_;
	GHashTable* _tmp6_;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.UbuntuBudgie.ShufflerInfoDaemon", "GetMonitorgeometry");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp5_ = g_variant_iter_next_value (&_reply_iter);
	_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp7_, _tmp5_);
	while (g_variant_iter_loop (&_tmp7_, "{?*}", &_tmp8_, &_tmp9_)) {
		g_hash_table_insert (_tmp6_, g_variant_dup_string (_tmp8_, NULL), g_variant_get_variant (_tmp9_));
	}
	_result = _tmp6_;
	g_variant_unref (_tmp5_);
	g_object_unref (_reply_message);
	return _result;
}

static GHashTable*
apply_rule_shuffler_info_client_proxy_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result = NULL;
	GVariant* _tmp10_;
	GHashTable* _tmp11_;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.UbuntuBudgie.ShufflerInfoDaemon", "GetWinsdata");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp10_ = g_variant_iter_next_value (&_reply_iter);
	_tmp11_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp12_, _tmp10_);
	while (g_variant_iter_loop (&_tmp12_, "{?*}", &_tmp13_, &_tmp14_)) {
		g_hash_table_insert (_tmp11_, g_variant_dup_string (_tmp13_, NULL), g_variant_get_variant (_tmp14_));
	}
	_result = _tmp11_;
	g_variant_unref (_tmp10_);
	g_object_unref (_reply_message);
	return _result;
}

static void
apply_rule_shuffler_info_client_proxy_apply_rule_shuffler_info_client_interface_init (ApplyRuleShufflerInfoClientIface* iface)
{
	iface->get_rules = apply_rule_shuffler_info_client_proxy_get_rules;
	iface->get_monitorgeometry = apply_rule_shuffler_info_client_proxy_get_monitorgeometry;
	iface->get_winsdata = apply_rule_shuffler_info_client_proxy_get_winsdata;
}

static void
_dbus_apply_rule_shuffler_info_client_get_rules (ApplyRuleShufflerInfoClient* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp15_;
	GHashTableIter _tmp16_;
	gpointer _tmp17_;
	gpointer _tmp18_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = apply_rule_shuffler_info_client_get_rules (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp16_, result);
	g_variant_builder_init (&_tmp15_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp16_, &_tmp17_, &_tmp18_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp17_;
		_value = (GVariant*) _tmp18_;
		g_variant_builder_add (&_tmp15_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp15_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_apply_rule_shuffler_info_client_get_monitorgeometry (ApplyRuleShufflerInfoClient* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp19_;
	GHashTableIter _tmp20_;
	gpointer _tmp21_;
	gpointer _tmp22_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = apply_rule_shuffler_info_client_get_monitorgeometry (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp20_, result);
	g_variant_builder_init (&_tmp19_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp20_, &_tmp21_, &_tmp22_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp21_;
		_value = (GVariant*) _tmp22_;
		g_variant_builder_add (&_tmp19_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp19_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_apply_rule_shuffler_info_client_get_winsdata (ApplyRuleShufflerInfoClient* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp23_;
	GHashTableIter _tmp24_;
	gpointer _tmp25_;
	gpointer _tmp26_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = apply_rule_shuffler_info_client_get_winsdata (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp24_, result);
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp24_, &_tmp25_, &_tmp26_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp25_;
		_value = (GVariant*) _tmp26_;
		g_variant_builder_add (&_tmp23_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
apply_rule_shuffler_info_client_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetRules") == 0) {
		_dbus_apply_rule_shuffler_info_client_get_rules (object, parameters, invocation);
	} else if (strcmp (method_name, "GetMonitorgeometry") == 0) {
		_dbus_apply_rule_shuffler_info_client_get_monitorgeometry (object, parameters, invocation);
	} else if (strcmp (method_name, "GetWinsdata") == 0) {
		_dbus_apply_rule_shuffler_info_client_get_winsdata (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
apply_rule_shuffler_info_client_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
apply_rule_shuffler_info_client_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
apply_rule_shuffler_info_client_register_object (gpointer object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_apply_rule_shuffler_info_client_dbus_interface_info), &_apply_rule_shuffler_info_client_dbus_interface_vtable, data, _apply_rule_shuffler_info_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_apply_rule_shuffler_info_client_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gboolean
apply_rule_string_inlist (const gchar* lookfor,
                          gchar** arr,
                          gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (lookfor != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < arr_length1)) {
					break;
				}
				_tmp2_ = arr[i];
				if (g_strcmp0 (lookfor, _tmp2_) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
apply_rule_run_command (const gchar* cmd)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (cmd != NULL);
	{
		g_spawn_command_line_async (cmd, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

gchar*
apply_rule_fixed_newclass (const gchar* xid)
{
	gint n_attempt = 0;
	gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (xid != NULL, NULL);
	n_attempt = 0;
	while (TRUE) {
		if (!(n_attempt < 10)) {
			break;
		}
		g_usleep ((gulong) 100000);
		{
			GHashTable* allwins = NULL;
			ApplyRuleShufflerInfoClient* _tmp0_;
			GHashTable* _tmp1_;
			GHashTable* _tmp2_;
			GList* _tmp3_;
			_tmp0_ = apply_rule_client;
			_tmp1_ = apply_rule_shuffler_info_client_get_winsdata (_tmp0_, &_inner_error0_);
			allwins = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = allwins;
			_tmp3_ = g_hash_table_get_keys (_tmp2_);
			{
				GList* key_collection = NULL;
				GList* key_it = NULL;
				key_collection = _tmp3_;
				for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
					gchar* _tmp4_;
					gchar* key = NULL;
					_tmp4_ = g_strdup ((const gchar*) key_it->data);
					key = _tmp4_;
					{
						const gchar* _tmp5_;
						_tmp5_ = key;
						if (g_strcmp0 (_tmp5_, xid) == 0) {
							gchar* alterclass = NULL;
							GHashTable* _tmp6_;
							const gchar* _tmp7_;
							gconstpointer _tmp8_;
							GVariant* _tmp9_;
							GVariant* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							gboolean _tmp16_;
							_tmp6_ = allwins;
							_tmp7_ = key;
							_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
							_tmp9_ = g_variant_get_child_value ((GVariant*) _tmp8_, (gsize) 8);
							_tmp10_ = _tmp9_;
							_tmp11_ = _variant_get1 (_tmp10_);
							_tmp12_ = _tmp11_;
							_g_variant_unref0 (_tmp10_);
							alterclass = _tmp12_;
							_tmp13_ = alterclass;
							_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
							_tmp15_ = _tmp14_;
							_tmp16_ = g_strcmp0 (_tmp15_, "soffice") != 0;
							_g_free0 (_tmp15_);
							if (_tmp16_) {
								result = alterclass;
								_g_free0 (key);
								(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
								_g_hash_table_unref0 (allwins);
								return result;
							}
							_g_free0 (alterclass);
						}
						_g_free0 (key);
					}
				}
				(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
			}
			_g_hash_table_unref0 (allwins);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = stderr;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			fprintf (_tmp17_, "%s\n", _tmp19_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		n_attempt += 1;
	}
	_tmp20_ = g_strdup ("noclass");
	result = _tmp20_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_variant_get2 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get3 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get4 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get5 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get6 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get7 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get8 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gchar*
_variant_get9 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
apply_rule_main (gchar** args,
                 gint args_length1)
{
	gchar* newclass = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* new_xid = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* monitor = NULL;
	gchar* _tmp4_;
	gchar* xposition = NULL;
	gchar* _tmp5_;
	gchar* yposition = NULL;
	gchar* _tmp6_;
	gchar* rows = NULL;
	gchar* _tmp7_;
	gchar* cols = NULL;
	gchar* _tmp8_;
	gchar* xspan = NULL;
	gchar* _tmp9_;
	gchar* yspan = NULL;
	gchar* _tmp10_;
	gchar* targetws = NULL;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = args[1];
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	newclass = _tmp1_;
	_tmp2_ = args[2];
	_tmp3_ = g_strdup (_tmp2_);
	new_xid = _tmp3_;
	_tmp4_ = g_strdup ("");
	monitor = _tmp4_;
	_tmp5_ = g_strdup ("");
	xposition = _tmp5_;
	_tmp6_ = g_strdup ("");
	yposition = _tmp6_;
	_tmp7_ = g_strdup ("");
	rows = _tmp7_;
	_tmp8_ = g_strdup ("");
	cols = _tmp8_;
	_tmp9_ = g_strdup ("");
	xspan = _tmp9_;
	_tmp10_ = g_strdup ("");
	yspan = _tmp10_;
	_tmp11_ = g_strdup ("");
	targetws = _tmp11_;
	{
		ApplyRuleShufflerInfoClient* _tmp12_ = NULL;
		ApplyRuleShufflerInfoClient* _tmp13_;
		ApplyRuleShufflerInfoClient* _tmp14_;
		GHashTable* _tmp15_ = NULL;
		ApplyRuleShufflerInfoClient* _tmp16_;
		GHashTable* _tmp17_;
		GHashTable* _tmp18_;
		GList* keys = NULL;
		GHashTable* _tmp19_;
		GList* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gboolean _tmp24_;
		GList* _tmp27_;
		_tmp13_ = (ApplyRuleShufflerInfoClient*) g_initable_new (APPLY_RULE_TYPE_SHUFFLER_INFO_CLIENT_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.UbuntuBudgie.ShufflerInfoDaemon", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/ubuntubudgie/shufflerinfodaemon", "g-interface-name", "org.UbuntuBudgie.ShufflerInfoDaemon", NULL);
		_tmp12_ = (ApplyRuleShufflerInfoClient*) _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (apply_rule_client);
		apply_rule_client = _tmp14_;
		_tmp16_ = apply_rule_client;
		_tmp17_ = apply_rule_shuffler_info_client_get_rules (_tmp16_, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp12_);
			goto __catch0_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_hash_table_unref0 (apply_rule_windowrules);
		apply_rule_windowrules = _tmp18_;
		_tmp19_ = apply_rule_windowrules;
		_tmp20_ = g_hash_table_get_keys (_tmp19_);
		keys = _tmp20_;
		_tmp21_ = newclass;
		_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strcmp0 (_tmp23_, "soffice") == 0;
		_g_free0 (_tmp23_);
		if (_tmp24_) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = new_xid;
			_tmp26_ = apply_rule_fixed_newclass (_tmp25_);
			_g_free0 (newclass);
			newclass = _tmp26_;
		}
		_tmp27_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp27_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				gchar* _tmp28_;
				gchar* key = NULL;
				_tmp28_ = g_strdup ((const gchar*) key_it->data);
				key = _tmp28_;
				{
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gboolean _tmp33_;
					_tmp29_ = newclass;
					_tmp30_ = key;
					_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) -1);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strcmp0 (_tmp29_, _tmp32_) == 0;
					_g_free0 (_tmp32_);
					if (_tmp33_) {
						GVariant* windowrule = NULL;
						GHashTable* _tmp34_;
						const gchar* _tmp35_;
						gconstpointer _tmp36_;
						GVariant* _tmp37_;
						GVariant* _tmp38_;
						GVariant* _tmp39_;
						GVariant* _tmp40_;
						gchar* _tmp41_;
						GVariant* _tmp42_;
						GVariant* _tmp43_;
						GVariant* _tmp44_;
						gchar* _tmp45_;
						GVariant* _tmp46_;
						GVariant* _tmp47_;
						GVariant* _tmp48_;
						gchar* _tmp49_;
						GVariant* _tmp50_;
						GVariant* _tmp51_;
						GVariant* _tmp52_;
						gchar* _tmp53_;
						GVariant* _tmp54_;
						GVariant* _tmp55_;
						GVariant* _tmp56_;
						gchar* _tmp57_;
						GVariant* _tmp58_;
						GVariant* _tmp59_;
						GVariant* _tmp60_;
						gchar* _tmp61_;
						GVariant* _tmp62_;
						GVariant* _tmp63_;
						GVariant* _tmp64_;
						gchar* _tmp65_;
						GVariant* _tmp66_;
						GVariant* _tmp67_;
						GVariant* _tmp68_;
						gchar* _tmp69_;
						gchar** found_monitors = NULL;
						gchar** _tmp70_;
						gint found_monitors_length1;
						gint _found_monitors_size_;
						GHashTable* _tmp71_ = NULL;
						ApplyRuleShufflerInfoClient* _tmp72_;
						GHashTable* _tmp73_;
						GHashTable* _tmp74_;
						GHashTable* _tmp75_;
						GList* _tmp76_;
						const gchar* _tmp80_;
						gchar** _tmp81_;
						gint _tmp81__length1;
						gchar** position_essentials = NULL;
						const gchar* _tmp85_;
						gchar* _tmp86_;
						const gchar* _tmp87_;
						gchar* _tmp88_;
						const gchar* _tmp89_;
						gchar* _tmp90_;
						const gchar* _tmp91_;
						gchar* _tmp92_;
						gchar** _tmp93_;
						gint position_essentials_length1;
						gint _position_essentials_size_;
						gchar** _tmp94_;
						gint _tmp94__length1;
						gchar* cmd = NULL;
						const gchar* _tmp103_;
						const gchar* _tmp104_;
						const gchar* _tmp105_;
						const gchar* _tmp106_;
						const gchar* _tmp107_;
						const gchar* _tmp108_;
						const gchar* _tmp109_;
						const gchar* _tmp110_;
						const gchar* _tmp111_;
						const gchar* _tmp112_;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
						const gchar* _tmp115_;
						const gchar* _tmp116_;
						const gchar* _tmp117_;
						const gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						const gchar* _tmp121_;
						const gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp127_;
						gchar* _tmp128_;
						const gchar* _tmp129_;
						_tmp34_ = apply_rule_windowrules;
						_tmp35_ = key;
						_tmp36_ = g_hash_table_lookup (_tmp34_, _tmp35_);
						_tmp37_ = _g_variant_ref0 ((GVariant*) _tmp36_);
						windowrule = _tmp37_;
						_tmp38_ = windowrule;
						_tmp39_ = g_variant_get_child_value (_tmp38_, (gsize) 0);
						_tmp40_ = _tmp39_;
						_tmp41_ = _variant_get2 (_tmp40_);
						_g_free0 (monitor);
						monitor = _tmp41_;
						_g_variant_unref0 (_tmp40_);
						_tmp42_ = windowrule;
						_tmp43_ = g_variant_get_child_value (_tmp42_, (gsize) 1);
						_tmp44_ = _tmp43_;
						_tmp45_ = _variant_get3 (_tmp44_);
						_g_free0 (xposition);
						xposition = _tmp45_;
						_g_variant_unref0 (_tmp44_);
						_tmp46_ = windowrule;
						_tmp47_ = g_variant_get_child_value (_tmp46_, (gsize) 2);
						_tmp48_ = _tmp47_;
						_tmp49_ = _variant_get4 (_tmp48_);
						_g_free0 (yposition);
						yposition = _tmp49_;
						_g_variant_unref0 (_tmp48_);
						_tmp50_ = windowrule;
						_tmp51_ = g_variant_get_child_value (_tmp50_, (gsize) 3);
						_tmp52_ = _tmp51_;
						_tmp53_ = _variant_get5 (_tmp52_);
						_g_free0 (rows);
						rows = _tmp53_;
						_g_variant_unref0 (_tmp52_);
						_tmp54_ = windowrule;
						_tmp55_ = g_variant_get_child_value (_tmp54_, (gsize) 4);
						_tmp56_ = _tmp55_;
						_tmp57_ = _variant_get6 (_tmp56_);
						_g_free0 (cols);
						cols = _tmp57_;
						_g_variant_unref0 (_tmp56_);
						_tmp58_ = windowrule;
						_tmp59_ = g_variant_get_child_value (_tmp58_, (gsize) 5);
						_tmp60_ = _tmp59_;
						_tmp61_ = _variant_get7 (_tmp60_);
						_g_free0 (xspan);
						xspan = _tmp61_;
						_g_variant_unref0 (_tmp60_);
						_tmp62_ = windowrule;
						_tmp63_ = g_variant_get_child_value (_tmp62_, (gsize) 6);
						_tmp64_ = _tmp63_;
						_tmp65_ = _variant_get8 (_tmp64_);
						_g_free0 (yspan);
						yspan = _tmp65_;
						_g_variant_unref0 (_tmp64_);
						_tmp66_ = windowrule;
						_tmp67_ = g_variant_get_child_value (_tmp66_, (gsize) 7);
						_tmp68_ = _tmp67_;
						_tmp69_ = _variant_get9 (_tmp68_);
						_g_free0 (targetws);
						targetws = _tmp69_;
						_g_variant_unref0 (_tmp68_);
						_tmp70_ = g_new0 (gchar*, 0 + 1);
						found_monitors = _tmp70_;
						found_monitors_length1 = 0;
						_found_monitors_size_ = found_monitors_length1;
						_tmp72_ = apply_rule_client;
						_tmp73_ = apply_rule_shuffler_info_client_get_monitorgeometry (_tmp72_, &_inner_error0_);
						_tmp71_ = _tmp73_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							found_monitors = (_vala_array_free (found_monitors, found_monitors_length1, (GDestroyNotify) g_free), NULL);
							_g_variant_unref0 (windowrule);
							_g_free0 (key);
							(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
							_g_hash_table_unref0 (_tmp15_);
							_g_object_unref0 (_tmp12_);
							goto __catch0_g_error;
						}
						_tmp74_ = _tmp71_;
						_tmp71_ = NULL;
						_g_hash_table_unref0 (apply_rule_monitordata);
						apply_rule_monitordata = _tmp74_;
						_tmp75_ = apply_rule_monitordata;
						_tmp76_ = g_hash_table_get_keys (_tmp75_);
						{
							GList* k_collection = NULL;
							GList* k_it = NULL;
							k_collection = _tmp76_;
							for (k_it = k_collection; k_it != NULL; k_it = k_it->next) {
								gchar* _tmp77_;
								gchar* k = NULL;
								_tmp77_ = g_strdup ((const gchar*) k_it->data);
								k = _tmp77_;
								{
									const gchar* _tmp78_;
									gchar* _tmp79_;
									_tmp78_ = k;
									_tmp79_ = g_strdup (_tmp78_);
									_vala_array_add1 (&found_monitors, &found_monitors_length1, &_found_monitors_size_, _tmp79_);
									_g_free0 (k);
								}
							}
							(k_collection == NULL) ? NULL : (k_collection = (g_list_free (k_collection), NULL));
						}
						_tmp80_ = monitor;
						_tmp81_ = found_monitors;
						_tmp81__length1 = found_monitors_length1;
						if (apply_rule_string_inlist (_tmp80_, _tmp81_, (gint) _tmp81__length1)) {
							const gchar* _tmp82_;
							const gchar* _tmp83_;
							gchar* _tmp84_;
							_tmp82_ = monitor;
							_tmp83_ = string_to_string (_tmp82_);
							_tmp84_ = g_strconcat ("monitor=", _tmp83_, NULL);
							_g_free0 (monitor);
							monitor = _tmp84_;
						}
						_tmp85_ = xposition;
						_tmp86_ = g_strdup (_tmp85_);
						_tmp87_ = yposition;
						_tmp88_ = g_strdup (_tmp87_);
						_tmp89_ = rows;
						_tmp90_ = g_strdup (_tmp89_);
						_tmp91_ = cols;
						_tmp92_ = g_strdup (_tmp91_);
						_tmp93_ = g_new0 (gchar*, 4 + 1);
						_tmp93_[0] = _tmp86_;
						_tmp93_[1] = _tmp88_;
						_tmp93_[2] = _tmp90_;
						_tmp93_[3] = _tmp92_;
						position_essentials = _tmp93_;
						position_essentials_length1 = 4;
						_position_essentials_size_ = position_essentials_length1;
						_tmp94_ = position_essentials;
						_tmp94__length1 = position_essentials_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp94_;
							s_collection_length1 = _tmp94__length1;
							for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
								gchar* _tmp95_;
								gchar* s = NULL;
								_tmp95_ = g_strdup (s_collection[s_it]);
								s = _tmp95_;
								{
									const gchar* _tmp96_;
									_tmp96_ = s;
									if (g_strcmp0 (_tmp96_, "") == 0) {
										gchar* _tmp97_;
										gchar* _tmp98_;
										gchar* _tmp99_;
										gchar* _tmp100_;
										gchar* _tmp101_;
										gchar* _tmp102_;
										_tmp97_ = g_strdup ("1");
										_g_free0 (xposition);
										xposition = _tmp97_;
										_tmp98_ = g_strdup ("1");
										_g_free0 (yposition);
										yposition = _tmp98_;
										_tmp99_ = g_strdup ("4");
										_g_free0 (rows);
										rows = _tmp99_;
										_tmp100_ = g_strdup ("4");
										_g_free0 (cols);
										cols = _tmp100_;
										_tmp101_ = g_strdup ("2");
										_g_free0 (xspan);
										xspan = _tmp101_;
										_tmp102_ = g_strdup ("2");
										_g_free0 (yspan);
										yspan = _tmp102_;
										_g_free0 (s);
										break;
									}
									_g_free0 (s);
								}
							}
						}
						_tmp103_ = xposition;
						_tmp104_ = string_to_string (_tmp103_);
						_tmp105_ = yposition;
						_tmp106_ = string_to_string (_tmp105_);
						_tmp107_ = cols;
						_tmp108_ = string_to_string (_tmp107_);
						_tmp109_ = rows;
						_tmp110_ = string_to_string (_tmp109_);
						_tmp111_ = xspan;
						_tmp112_ = string_to_string (_tmp111_);
						_tmp113_ = yspan;
						_tmp114_ = string_to_string (_tmp113_);
						_tmp115_ = new_xid;
						_tmp116_ = string_to_string (_tmp115_);
						_tmp117_ = monitor;
						_tmp118_ = string_to_string (_tmp117_);
						_tmp119_ = g_strconcat (_tmp104_, " ", _tmp106_, " ", _tmp108_, " ", _tmp110_, " ", _tmp112_, " ", _tmp114_, " id=", _tmp116_, " windowrule ", _tmp118_, NULL);
						_tmp120_ = _tmp119_;
						_tmp121_ = targetws;
						_tmp122_ = string_to_string (_tmp121_);
						_tmp123_ = g_strconcat ("movetows=", _tmp122_, NULL);
						_tmp124_ = _tmp123_;
						_tmp125_ = g_strconcat ("/tile_active ", _tmp120_, " ", _tmp124_, NULL);
						_tmp126_ = _tmp125_;
						_tmp127_ = g_strconcat (SHUFFLER_DIR, _tmp126_, NULL);
						_tmp128_ = _tmp127_;
						_g_free0 (_tmp126_);
						_g_free0 (_tmp124_);
						_g_free0 (_tmp120_);
						cmd = _tmp128_;
						_tmp129_ = cmd;
						apply_rule_run_command (_tmp129_);
						_g_free0 (cmd);
						position_essentials = (_vala_array_free (position_essentials, position_essentials_length1, (GDestroyNotify) g_free), NULL);
						_g_hash_table_unref0 (_tmp71_);
						found_monitors = (_vala_array_free (found_monitors, found_monitors_length1, (GDestroyNotify) g_free), NULL);
						_g_variant_unref0 (windowrule);
					}
					_g_free0 (key);
				}
			}
		}
		(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
		_g_hash_table_unref0 (_tmp15_);
		_g_object_unref0 (_tmp12_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp130_;
		GError* _tmp131_;
		const gchar* _tmp132_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp130_ = stderr;
		_tmp131_ = e;
		_tmp132_ = _tmp131_->message;
		fprintf (_tmp130_, "%s\n", _tmp132_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (targetws);
		_g_free0 (yspan);
		_g_free0 (xspan);
		_g_free0 (cols);
		_g_free0 (rows);
		_g_free0 (yposition);
		_g_free0 (xposition);
		_g_free0 (monitor);
		_g_free0 (new_xid);
		_g_free0 (newclass);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (targetws);
	_g_free0 (yspan);
	_g_free0 (xspan);
	_g_free0 (cols);
	_g_free0 (rows);
	_g_free0 (yposition);
	_g_free0 (xposition);
	_g_free0 (monitor);
	_g_free0 (new_xid);
	_g_free0 (newclass);
}

int
main (int argc,
      char ** argv)
{
	apply_rule_main (argv, argc);
	return 0;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

