/* wallstreet.c generated by valac 0.56.14, the Vala compiler
 * generated from wallstreet.vala, do not modify */

/*
Budgie WallStreet
Author: Jacob Vlijm
Copyright © 2017 Ubuntu Budgie Developers
Website=https://ubuntubudgie.org
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or any later version. This
program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details. You
should have received a copy of the GNU General Public License along with this
program.  If not, see <https://www.gnu.org/licenses/>.
*/
/*
dir does not exist -> default folder (need set directory again to fix)
file is invalid -> black background
no files in set dir -> set to default wallpaper *
*/

#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _Block1Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

VALA_EXTERN GSettings* wall_street_settings;
GSettings* wall_street_settings = NULL;
VALA_EXTERN GSettings* wall_street_wallpapersettings;
GSettings* wall_street_wallpapersettings = NULL;
VALA_EXTERN GSettings* wall_street_locksettings;
GSettings* wall_street_locksettings = NULL;
VALA_EXTERN gint wall_street_n_images;
gint wall_street_n_images = 0;
VALA_EXTERN gchar* wall_street_currwall;
gchar* wall_street_currwall = NULL;
VALA_EXTERN gboolean wall_street_lockscreen_sync;
gboolean wall_street_lockscreen_sync = FALSE;
VALA_EXTERN GFileMonitor* wall_street_walldir_monitor;
GFileMonitor* wall_street_walldir_monitor = NULL;
VALA_EXTERN GPtrArray* wall_street_getlist;
GPtrArray* wall_street_getlist = NULL;
VALA_EXTERN guint wall_street_currindex;
guint wall_street_currindex = 0U;
VALA_EXTERN gchar* wall_street_wallpaperfolder;
gchar* wall_street_wallpaperfolder = NULL;
VALA_EXTERN gint wall_street_curr_seconds;
gint wall_street_curr_seconds = 0;
VALA_EXTERN gint wall_street_switchinterval;
gint wall_street_switchinterval = 0;
VALA_EXTERN gboolean wall_street_randomwall;
gboolean wall_street_randomwall = FALSE;

static gint wall_street_main (gchar** args,
                       gint args_length1);
VALA_EXTERN void wall_street_update_settings (const gchar* path);
static void _wall_street_update_settings_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
VALA_EXTERN GPtrArray* wall_street_walls (const gchar* directory);
VALA_EXTERN guint wall_street_get_initialwallpaperindex (GPtrArray* gotlist);
VALA_EXTERN void wall_street_set_wallpaper (const gchar* newwall);
VALA_EXTERN GFileMonitor* wall_street_getwallmonitor (const gchar* directory);
VALA_EXTERN void wall_street_rescan_currdir (void);
static void _wall_street_rescan_currdir_g_file_monitor_changed (GFileMonitor* _sender,
                                                         GFile* file,
                                                         GFile* other_file,
                                                         GFileMonitorEvent event_type,
                                                         gpointer self);
static gboolean __lambda4_ (void);
static gboolean ___lambda4__gsource_func (gpointer self);
VALA_EXTERN void wall_street_update_wallpaperlist (void);
static void _g_free0_ (gpointer var);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);

static void
_wall_street_update_settings_g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
	wall_street_update_settings (key);
}

static void
_wall_street_rescan_currdir_g_file_monitor_changed (GFileMonitor* _sender,
                                                    GFile* file,
                                                    GFile* other_file,
                                                    GFileMonitorEvent event_type,
                                                    gpointer self)
{
	wall_street_rescan_currdir ();
}

static gboolean
__lambda4_ (void)
{
	gboolean result;
	if (wall_street_curr_seconds >= wall_street_switchinterval) {
		const gchar* _tmp6_;
		if (wall_street_randomwall) {
			gint random_int = 0;
			GPtrArray* _tmp0_;
			gconstpointer _tmp1_;
			gchar* _tmp2_;
			random_int = (gint) g_random_int_range ((gint32) 0, (gint32) wall_street_n_images);
			_tmp0_ = wall_street_getlist;
			_tmp1_ = g_ptr_array_index (_tmp0_, (guint) random_int);
			_tmp2_ = g_strdup ((const gchar*) _tmp1_);
			_g_free0 (wall_street_currwall);
			wall_street_currwall = _tmp2_;
		} else {
			GPtrArray* _tmp3_;
			gconstpointer _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = wall_street_getlist;
			_tmp4_ = g_ptr_array_index (_tmp3_, wall_street_currindex);
			_tmp5_ = g_strdup ((const gchar*) _tmp4_);
			_g_free0 (wall_street_currwall);
			wall_street_currwall = _tmp5_;
		}
		_tmp6_ = wall_street_currwall;
		wall_street_set_wallpaper (_tmp6_);
		wall_street_currindex = wall_street_currindex + 1;
		wall_street_curr_seconds = 0;
	}
	if (wall_street_currindex >= ((guint) wall_street_n_images)) {
		wall_street_currindex = (guint) 0;
	}
	wall_street_curr_seconds = wall_street_curr_seconds + 1;
	result = TRUE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ();
	return result;
}

static gint
wall_street_main (gchar** args,
                  gint args_length1)
{
	GMainLoop* wallstreetloop = NULL;
	GMainLoop* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	GPtrArray* _tmp11_;
	GPtrArray* _tmp12_;
	GPtrArray* _tmp13_;
	gconstpointer _tmp14_;
	const gchar* _tmp15_;
	GFileMonitor* _tmp16_;
	GFileMonitor* _tmp17_;
	gint result;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	wallstreetloop = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (wall_street_wallpapersettings);
	wall_street_wallpapersettings = _tmp1_;
	_tmp2_ = g_settings_new ("org.ubuntubudgie.budgie-wallstreet");
	_g_object_unref0 (wall_street_settings);
	wall_street_settings = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.desktop.screensaver");
	_g_object_unref0 (wall_street_locksettings);
	wall_street_locksettings = _tmp3_;
	_tmp4_ = wall_street_settings;
	g_signal_connect (_tmp4_, "changed", (GCallback) _wall_street_update_settings_g_settings_changed, NULL);
	_tmp5_ = wall_street_settings;
	wall_street_switchinterval = g_settings_get_int (_tmp5_, "switchinterval");
	_tmp6_ = wall_street_settings;
	_tmp7_ = g_settings_get_string (_tmp6_, "wallpaperfolder");
	_g_free0 (wall_street_wallpaperfolder);
	wall_street_wallpaperfolder = _tmp7_;
	_tmp8_ = wall_street_settings;
	wall_street_randomwall = g_settings_get_boolean (_tmp8_, "random");
	_tmp9_ = wall_street_settings;
	wall_street_lockscreen_sync = g_settings_get_boolean (_tmp9_, "lockscreensync");
	wall_street_curr_seconds = 0;
	_tmp10_ = wall_street_wallpaperfolder;
	_tmp11_ = wall_street_walls (_tmp10_);
	_g_ptr_array_unref0 (wall_street_getlist);
	wall_street_getlist = _tmp11_;
	_tmp12_ = wall_street_getlist;
	wall_street_currindex = wall_street_get_initialwallpaperindex (_tmp12_);
	_tmp13_ = wall_street_getlist;
	_tmp14_ = g_ptr_array_index (_tmp13_, wall_street_currindex);
	wall_street_set_wallpaper ((const gchar*) _tmp14_);
	wall_street_currindex = wall_street_currindex + 1;
	_tmp15_ = wall_street_wallpaperfolder;
	_tmp16_ = wall_street_getwallmonitor (_tmp15_);
	_g_object_unref0 (wall_street_walldir_monitor);
	wall_street_walldir_monitor = _tmp16_;
	_tmp17_ = wall_street_walldir_monitor;
	g_signal_connect (_tmp17_, "changed", (GCallback) _wall_street_rescan_currdir_g_file_monitor_changed, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda4__gsource_func, NULL, NULL);
	g_main_loop_run (wallstreetloop);
	result = 0;
	_g_main_loop_unref0 (wallstreetloop);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return wall_street_main (argv, argc);
}

void
wall_street_update_settings (const gchar* path)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("wallpaperfolder")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = wall_street_settings;
				_tmp4_ = g_settings_get_string (_tmp3_, "wallpaperfolder");
				_g_free0 (wall_street_wallpaperfolder);
				wall_street_wallpaperfolder = _tmp4_;
				wall_street_update_wallpaperlist ();
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("switchinterval")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp5_;
				_tmp5_ = wall_street_settings;
				wall_street_switchinterval = g_settings_get_int (_tmp5_, "switchinterval");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("random")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp6_;
				_tmp6_ = wall_street_settings;
				wall_street_randomwall = g_settings_get_boolean (_tmp6_, "random");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("lockscreensync")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp7_;
				_tmp7_ = wall_street_settings;
				wall_street_lockscreen_sync = g_settings_get_boolean (_tmp7_, "lockscreensync");
				break;
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFileMonitor*
wall_street_getwallmonitor (const gchar* directory)
{
	GFile* triggerdir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	GFileMonitor* result;
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = g_file_new_for_path (directory);
	triggerdir = _tmp0_;
	{
		GFileMonitor* _tmp1_ = NULL;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp2_ = g_file_monitor (triggerdir, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (wall_street_walldir_monitor);
		wall_street_walldir_monitor = _tmp3_;
		_tmp4_ = wall_street_walldir_monitor;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (triggerdir);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_object_unref0 (triggerdir);
		return result;
	}
	__finally0:
	_g_object_unref0 (triggerdir);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
wall_street_set_wallpaper (const gchar* newwall)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (newwall != NULL);
	_tmp0_ = wall_street_wallpapersettings;
	_tmp1_ = g_strconcat ("file:///", newwall, NULL);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "picture-uri", _tmp2_);
	_g_free0 (_tmp2_);
	if (wall_street_lockscreen_sync) {
		GSettings* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = wall_street_locksettings;
		_tmp4_ = g_strconcat ("file:///", newwall, NULL);
		_tmp5_ = _tmp4_;
		g_settings_set_string (_tmp3_, "picture-uri", _tmp5_);
		_g_free0 (_tmp5_);
	}
}

void
wall_street_rescan_currdir (void)
{
	const gchar* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	_tmp0_ = wall_street_wallpaperfolder;
	_tmp1_ = wall_street_walls (_tmp0_);
	_g_ptr_array_unref0 (wall_street_getlist);
	wall_street_getlist = _tmp1_;
	_tmp2_ = wall_street_getlist;
	wall_street_currindex = wall_street_get_initialwallpaperindex (_tmp2_);
}

void
wall_street_update_wallpaperlist (void)
{
	const gchar* _tmp0_;
	GFileMonitor* _tmp1_;
	GFileMonitor* _tmp2_;
	const gchar* _tmp3_;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	_tmp0_ = wall_street_wallpaperfolder;
	_tmp1_ = wall_street_getwallmonitor (_tmp0_);
	_g_object_unref0 (wall_street_walldir_monitor);
	wall_street_walldir_monitor = _tmp1_;
	_tmp2_ = wall_street_walldir_monitor;
	g_signal_connect (_tmp2_, "changed", (GCallback) _wall_street_rescan_currdir_g_file_monitor_changed, NULL);
	_tmp3_ = wall_street_wallpaperfolder;
	_tmp4_ = wall_street_walls (_tmp3_);
	_g_ptr_array_unref0 (wall_street_getlist);
	wall_street_getlist = _tmp4_;
	wall_street_currindex = (guint) 0;
	wall_street_curr_seconds = 0;
	_tmp5_ = wall_street_getlist;
	_tmp6_ = g_ptr_array_index (_tmp5_, wall_street_currindex);
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
	_g_free0 (wall_street_currwall);
	wall_street_currwall = _tmp7_;
	_tmp8_ = wall_street_currwall;
	wall_street_set_wallpaper (_tmp8_);
	wall_street_currindex = wall_street_currindex + 1;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

guint
wall_street_get_initialwallpaperindex (GPtrArray* gotlist)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint index = 0U;
	gboolean found = FALSE;
	const gchar* _tmp4_;
	GEqualFunc _tmp5_;
	guint _tmp6_ = 0U;
	gboolean _tmp7_;
	guint result;
	g_return_val_if_fail (gotlist != NULL, 0U);
	_tmp0_ = wall_street_wallpapersettings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-uri");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "file:///", "");
	_g_free0 (wall_street_currwall);
	wall_street_currwall = _tmp3_;
	_g_free0 (_tmp2_);
	index = (guint) 0;
	_tmp4_ = wall_street_currwall;
	_tmp5_ = g_str_equal;
	_tmp7_ = g_ptr_array_find_with_equal_func (gotlist, _tmp4_, _tmp5_, &_tmp6_);
	index = _tmp6_;
	found = _tmp7_;
	if (!found) {
		index = (guint) 0;
	}
	result = index;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GPtrArray* self;
		self = _data1_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
__lambda0_ (Block1Data* _data1_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data1_->self;
	result = _data1_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block1Data* _data1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_ptr_array_ref (self);
	_data1_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

GPtrArray*
wall_street_walls (const gchar* directory)
{
	GPtrArray* images = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	images = _tmp0_;
	{
		GDir* dr = NULL;
		GDir* _tmp1_;
		gchar* filename = NULL;
		_tmp1_ = g_dir_open (directory, (guint) 0, &_inner_error0_);
		dr = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_ptr_array_unref0 (images);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		filename = NULL;
		while (TRUE) {
			GDir* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* addpic = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			GPtrArray* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp2_ = dr;
			_tmp3_ = g_dir_read_name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (filename);
			filename = _tmp4_;
			_tmp5_ = filename;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = filename;
			_tmp7_ = g_build_filename (directory, _tmp6_, NULL);
			addpic = _tmp7_;
			_tmp8_ = images;
			_tmp9_ = addpic;
			_tmp10_ = g_strdup (_tmp9_);
			g_ptr_array_add (_tmp8_, _tmp10_);
			_g_free0 (addpic);
		}
		_g_free0 (filename);
		_g_dir_close0 (dr);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* err = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GSettings* _tmp14_;
		GPtrArray* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "%s", _tmp13_);
		_tmp14_ = wall_street_settings;
		g_settings_reset (_tmp14_, "wallpaperfolder");
		_tmp15_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (images);
		images = _tmp15_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (images);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp16_ = images;
	_tmp17_ = vala_g_ptr_array_get_length (_tmp16_);
	_tmp18_ = _tmp17_;
	wall_street_n_images = _tmp18_;
	if (wall_street_n_images == 0) {
		GPtrArray* _tmp19_;
		GSettings* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = images;
		_tmp20_ = wall_street_settings;
		_tmp21_ = g_settings_get_string (_tmp20_, "fallbackwallpaper");
		g_ptr_array_add (_tmp19_, _tmp21_);
	} else {
		GPtrArray* _tmp22_;
		GCompareFunc _tmp23_;
		_tmp22_ = images;
		_tmp23_ = ((GCompareFunc) g_strcmp0);
		vala_g_ptr_array_sort (_tmp22_, _tmp23_);
	}
	result = images;
	return result;
}

