/* WifiMenuItem.c generated by valac 0.56.14, the Vala compiler
 * generated from WifiMenuItem.vala, do not modify */

/*
 * Copyright (c) 2015-2018 elementary LLC (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "networkapplet.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "network-wireless-signal-"
#define NETWORK_WIFI_MENU_ITEM_SYMBOLIC "-symbolic"

enum  {
	NETWORK_WIFI_MENU_ITEM_0_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY,
	NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_NUM_PROPERTIES];
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL,
	NETWORK_WIFI_MENU_ITEM_NUM_SIGNALS
};
static guint network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_NUM_SIGNALS] = {0};

struct _NetworkWifiMenuItemPrivate {
	NetworkState _state;
	GBytes* _ssid;
	guint8 _strength;
	GeeLinkedList* all_aps;
	GRecMutex __lock_all_aps;
	GtkRadioButton* radio_button;
	GtkImage* img_strength;
	GtkImage* lock_img;
	GtkImage* error_img;
	GtkSpinner* spinner;
	guint refresh_source;
	GRecMutex __lock_refresh_source;
};

static gint NetworkWifiMenuItem_private_offset;
static gpointer network_wifi_menu_item_parent_class = NULL;
static GType network_wifi_menu_item_type_id = 0;

static void network_wifi_menu_item_update (NetworkWifiMenuItem* self);
static void network_wifi_menu_item_start_refresh (NetworkWifiMenuItem* self);
static gboolean ___lambda5_ (NetworkWifiMenuItem* self);
static gboolean ____lambda5__gsource_func (gpointer self);
static void network_wifi_menu_item_stop_refresh (NetworkWifiMenuItem* self);
static void network_wifi_menu_item_hide_item (NetworkWifiMenuItem* self,
                                       GtkWidget* w);
static void network_wifi_menu_item_show_item (NetworkWifiMenuItem* self,
                                       GtkWidget* w);
static void network_wifi_menu_item_set_strength (NetworkWifiMenuItem* self,
                                          guint8 value);
static const gchar* network_wifi_menu_item_get_strength_symbolic_icon (NetworkWifiMenuItem* self);
static GObject * network_wifi_menu_item_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static gboolean _network_wifi_menu_item___lambda6_ (NetworkWifiMenuItem* self);
static gboolean __network_wifi_menu_item___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self);
static void _network_wifi_menu_item___lambda7_ (NetworkWifiMenuItem* self);
static void __network_wifi_menu_item___lambda7__gtk_list_box_row_activate (GtkListBoxRow* _sender,
                                                                    gpointer self);
static void _network_wifi_menu_item___lambda8_ (NetworkWifiMenuItem* self);
static void __network_wifi_menu_item___lambda8__gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self);
static void _network_wifi_menu_item___lambda9_ (NetworkWifiMenuItem* self);
static void __network_wifi_menu_item___lambda9__gtk_widget_unmap (GtkWidget* _sender,
                                                           gpointer self);
static void network_wifi_menu_item_finalize (GObject * obj);
static void _vala_network_wifi_menu_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_menu_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_menu_item_get_instance_private (NetworkWifiMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiMenuItem_private_offset);
}

NetworkWifiMenuItem*
network_wifi_menu_item_construct (GType object_type,
                                  NMAccessPoint* ap,
                                  NetworkWifiMenuItem* previous)
{
	NetworkWifiMenuItem * self = NULL;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	g_return_val_if_fail (ap != NULL, NULL);
	_tmp0_ = nm_access_point_get_ssid (ap);
	_tmp1_ = _tmp0_;
	self = (NetworkWifiMenuItem*) g_object_new (object_type, "ssid", _tmp1_, "margin-top", 3, NULL);
	network_wifi_menu_item_add_ap (self, ap);
	if (previous != NULL) {
		GtkRadioButton* _tmp2_;
		GtkRadioButton* _tmp3_;
		GSList* _tmp4_;
		_tmp2_ = self->priv->radio_button;
		_tmp3_ = previous->priv->radio_button;
		_tmp4_ = gtk_radio_button_get_group (_tmp3_);
		gtk_radio_button_set_group (_tmp2_, _tmp4_);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

NetworkWifiMenuItem*
network_wifi_menu_item_new (NMAccessPoint* ap,
                            NetworkWifiMenuItem* previous)
{
	return network_wifi_menu_item_construct (NETWORK_TYPE_WIFI_MENU_ITEM, ap, previous);
}

/**
     * Only used for an item which is not displayed: hacky way to have no radio button selected.
     **/
NetworkWifiMenuItem*
network_wifi_menu_item_construct_blank (GType object_type)
{
	NetworkWifiMenuItem * self = NULL;
	GtkWidget* _tmp0_;
	self = (NetworkWifiMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_destroy (_tmp0_);
	return self;
}

NetworkWifiMenuItem*
network_wifi_menu_item_new_blank (void)
{
	return network_wifi_menu_item_construct_blank (NETWORK_TYPE_WIFI_MENU_ITEM);
}

void
network_wifi_menu_item_set_active (NetworkWifiMenuItem* self,
                                   gboolean active)
{
	GtkRadioButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->radio_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, active);
}

void
network_wifi_menu_item_add_ap (NetworkWifiMenuItem* self,
                               NMAccessPoint* ap)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap != NULL);
	{
		GeeLinkedList* _tmp0_;
		_tmp0_ = self->priv->all_aps;
		g_rec_mutex_lock (&self->priv->__lock_all_aps);
		{
			GeeLinkedList* _tmp1_;
			_tmp1_ = self->priv->all_aps;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, ap);
		}
		__finally0:
		{
			GeeLinkedList* _tmp2_;
			_tmp2_ = self->priv->all_aps;
			g_rec_mutex_unlock (&self->priv->__lock_all_aps);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	network_wifi_menu_item_update (self);
}

gboolean
network_wifi_menu_item_remove_ap (NetworkWifiMenuItem* self,
                                  NMAccessPoint* ap)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ap != NULL, FALSE);
	{
		GeeLinkedList* _tmp0_;
		gboolean _tmp7_ = FALSE;
		_tmp0_ = self->priv->all_aps;
		g_rec_mutex_lock (&self->priv->__lock_all_aps);
		{
			GeeLinkedList* _tmp1_;
			GeeLinkedList* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp1_ = self->priv->all_aps;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, ap);
			_tmp2_ = self->priv->all_aps;
			_tmp3_ = gee_collection_get_is_empty ((GeeCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			result = !_tmp4_;
			{
				GeeLinkedList* _tmp5_;
				_tmp5_ = self->priv->all_aps;
				g_rec_mutex_unlock (&self->priv->__lock_all_aps);
			}
			return result;
		}
		__finally0:
		{
			GeeLinkedList* _tmp6_;
			_tmp6_ = self->priv->all_aps;
			g_rec_mutex_unlock (&self->priv->__lock_all_aps);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NMAccessPoint*
network_wifi_menu_item_get_nearest_ap (NetworkWifiMenuItem* self)
{
	GError* _inner_error0_ = NULL;
	NMAccessPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _tmp0_;
		_tmp0_ = self->priv->all_aps;
		g_rec_mutex_lock (&self->priv->__lock_all_aps);
		{
			NMAccessPoint* ap = NULL;
			GeeLinkedList* _tmp1_;
			gpointer _tmp2_;
			_tmp1_ = self->priv->all_aps;
			_tmp2_ = gee_linked_list_first (_tmp1_);
			ap = (NMAccessPoint*) _tmp2_;
			{
				GeeLinkedList* _iter_ap_list = NULL;
				GeeLinkedList* _tmp3_;
				gint _iter_ap_size = 0;
				GeeLinkedList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint _iter_ap_index = 0;
				_tmp3_ = self->priv->all_aps;
				_iter_ap_list = _tmp3_;
				_tmp4_ = _iter_ap_list;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				_iter_ap_size = _tmp6_;
				_iter_ap_index = -1;
				while (TRUE) {
					gint _tmp7_;
					gint _tmp8_;
					NMAccessPoint* iter_ap = NULL;
					GeeLinkedList* _tmp9_;
					gpointer _tmp10_;
					NMAccessPoint* _tmp11_;
					guint8 _tmp12_;
					guint8 _tmp13_;
					NMAccessPoint* _tmp14_;
					guint8 _tmp15_;
					guint8 _tmp16_;
					_iter_ap_index = _iter_ap_index + 1;
					_tmp7_ = _iter_ap_index;
					_tmp8_ = _iter_ap_size;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = _iter_ap_list;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _iter_ap_index);
					iter_ap = (NMAccessPoint*) _tmp10_;
					_tmp11_ = ap;
					_tmp12_ = nm_access_point_get_strength (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = iter_ap;
					_tmp15_ = nm_access_point_get_strength (_tmp14_);
					_tmp16_ = _tmp15_;
					if (_tmp13_ < _tmp16_) {
						NMAccessPoint* _tmp17_;
						NMAccessPoint* _tmp18_;
						_tmp17_ = iter_ap;
						_tmp18_ = _g_object_ref0 (_tmp17_);
						_g_object_unref0 (ap);
						ap = _tmp18_;
					}
					_g_object_unref0 (iter_ap);
				}
			}
			result = ap;
			{
				GeeLinkedList* _tmp19_;
				_tmp19_ = self->priv->all_aps;
				g_rec_mutex_unlock (&self->priv->__lock_all_aps);
			}
			return result;
		}
		__finally0:
		{
			GeeLinkedList* _tmp20_;
			_tmp20_ = self->priv->all_aps;
			g_rec_mutex_unlock (&self->priv->__lock_all_aps);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gboolean
___lambda5_ (NetworkWifiMenuItem* self)
{
	gboolean result;
	network_wifi_menu_item_update (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((NetworkWifiMenuItem*) self);
	return result;
}

static void
network_wifi_menu_item_start_refresh (NetworkWifiMenuItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_rec_mutex_lock (&self->priv->__lock_refresh_source);
		{
			if (self->priv->refresh_source > ((guint) 0)) {
				g_source_remove (self->priv->refresh_source);
			}
			self->priv->refresh_source = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ____lambda5__gsource_func, g_object_ref (self), g_object_unref);
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_refresh_source);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
network_wifi_menu_item_stop_refresh (NetworkWifiMenuItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_rec_mutex_lock (&self->priv->__lock_refresh_source);
		{
			g_source_remove (self->priv->refresh_source);
			self->priv->refresh_source = (guint) 0;
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_refresh_source);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
network_wifi_menu_item_update (NetworkWifiMenuItem* self)
{
	GtkRadioButton* _tmp0_;
	GBytes* _tmp1_;
	gsize _tmp2_ = 0;
	guint8* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	NMAccessPoint* ap = NULL;
	NM80211ApSecurityFlags flags = 0U;
	NMAccessPoint* _tmp10_;
	NM80211ApSecurityFlags _tmp11_;
	NM80211ApSecurityFlags _tmp12_;
	gboolean is_secured = FALSE;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GtkImage* _tmp22_;
	GtkSpinner* _tmp23_;
	NetworkState _tmp24_;
	guint8 next_strength = 0U;
	GtkImage* _tmp43_;
	const gchar* _tmp44_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = self->priv->_ssid;
	_tmp3_ = g_bytes_get_data (_tmp1_, &_tmp2_);
	_tmp4_ = nm_utils_ssid_to_utf8 (_tmp3_, (gsize) _tmp2_);
	_tmp5_ = _tmp4_;
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	ap = NULL;
	{
		GeeLinkedList* _tmp6_;
		_tmp6_ = self->priv->all_aps;
		g_rec_mutex_lock (&self->priv->__lock_all_aps);
		{
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			_tmp7_ = self->priv->all_aps;
			_tmp8_ = gee_linked_list_first (_tmp7_);
			_g_object_unref0 (ap);
			ap = (NMAccessPoint*) _tmp8_;
		}
		__finally0:
		{
			GeeLinkedList* _tmp9_;
			_tmp9_ = self->priv->all_aps;
			g_rec_mutex_unlock (&self->priv->__lock_all_aps);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = ap;
	_tmp11_ = nm_access_point_get_wpa_flags (_tmp10_);
	_tmp12_ = _tmp11_;
	flags = _tmp12_;
	is_secured = FALSE;
	if ((flags & NM_802_11_AP_SEC_GROUP_WEP40) == NM_802_11_AP_SEC_GROUP_WEP40) {
		is_secured = TRUE;
		gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("This network uses 40/64-bit WEP encryption"));
	} else {
		if ((flags & NM_802_11_AP_SEC_GROUP_WEP104) == NM_802_11_AP_SEC_GROUP_WEP104) {
			is_secured = TRUE;
			gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("This network uses 104/128-bit WEP encryption"));
		} else {
			if ((flags & NM_802_11_AP_SEC_KEY_MGMT_PSK) == NM_802_11_AP_SEC_KEY_MGMT_PSK) {
				is_secured = TRUE;
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("This network uses WPA encryption"));
			} else {
				gboolean _tmp13_ = FALSE;
				if (flags != NM_802_11_AP_SEC_NONE) {
					_tmp13_ = TRUE;
				} else {
					NMAccessPoint* _tmp14_;
					NM80211ApSecurityFlags _tmp15_;
					NM80211ApSecurityFlags _tmp16_;
					_tmp14_ = ap;
					_tmp15_ = nm_access_point_get_rsn_flags (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp13_ = _tmp16_ != NM_802_11_AP_SEC_NONE;
				}
				if (_tmp13_) {
					is_secured = TRUE;
					gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("This network uses encryption"));
				} else {
					gtk_widget_set_tooltip_text ((GtkWidget*) self, _ ("This network is unsecured"));
				}
			}
		}
	}
	_tmp17_ = self->priv->lock_img;
	gtk_widget_set_visible ((GtkWidget*) _tmp17_, !is_secured);
	_tmp18_ = self->priv->lock_img;
	_tmp19_ = self->priv->lock_img;
	_tmp20_ = gtk_widget_get_visible ((GtkWidget*) _tmp19_);
	_tmp21_ = _tmp20_;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, !_tmp21_);
	_tmp22_ = self->priv->error_img;
	network_wifi_menu_item_hide_item (self, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->spinner;
	network_wifi_menu_item_hide_item (self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->_state;
	switch (_tmp24_) {
		case NETWORK_STATE_FAILED_WIFI:
		{
			GtkImage* _tmp25_;
			_tmp25_ = self->priv->error_img;
			network_wifi_menu_item_show_item (self, (GtkWidget*) _tmp25_);
			break;
		}
		case NETWORK_STATE_CONNECTING_WIFI:
		{
			GtkSpinner* _tmp26_;
			GtkRadioButton* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_;
			_tmp26_ = self->priv->spinner;
			network_wifi_menu_item_show_item (self, (GtkWidget*) _tmp26_);
			_tmp27_ = self->priv->radio_button;
			_tmp28_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp27_);
			_tmp29_ = _tmp28_;
			if (!_tmp29_) {
				g_critical ("WifiMenuItem.vala:187: An access point is being connected but not acti" \
"ve.");
			}
			break;
		}
		default:
		break;
	}
	next_strength = (guint8) 0;
	{
		GeeLinkedList* _tmp30_;
		_tmp30_ = self->priv->all_aps;
		g_rec_mutex_lock (&self->priv->__lock_all_aps);
		{
			{
				GeeLinkedList* _iter_ap_list = NULL;
				GeeLinkedList* _tmp31_;
				gint _iter_ap_size = 0;
				GeeLinkedList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _iter_ap_index = 0;
				_tmp31_ = self->priv->all_aps;
				_iter_ap_list = _tmp31_;
				_tmp32_ = _iter_ap_list;
				_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_iter_ap_size = _tmp34_;
				_iter_ap_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					NMAccessPoint* iter_ap = NULL;
					GeeLinkedList* _tmp37_;
					gpointer _tmp38_;
					NMAccessPoint* _tmp39_;
					guint8 _tmp40_;
					guint8 _tmp41_;
					_iter_ap_index = _iter_ap_index + 1;
					_tmp35_ = _iter_ap_index;
					_tmp36_ = _iter_ap_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _iter_ap_list;
					_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _iter_ap_index);
					iter_ap = (NMAccessPoint*) _tmp38_;
					_tmp39_ = iter_ap;
					_tmp40_ = nm_access_point_get_strength (_tmp39_);
					_tmp41_ = _tmp40_;
					next_strength = MAX (next_strength, _tmp41_);
					_g_object_unref0 (iter_ap);
				}
			}
		}
		__finally1:
		{
			GeeLinkedList* _tmp42_;
			_tmp42_ = self->priv->all_aps;
			g_rec_mutex_unlock (&self->priv->__lock_all_aps);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	network_wifi_menu_item_set_strength (self, next_strength);
	_tmp43_ = self->priv->img_strength;
	_tmp44_ = network_wifi_menu_item_get_strength_symbolic_icon (self);
	g_object_set (_tmp43_, "icon-name", _tmp44_, NULL);
	_g_object_unref0 (ap);
}

static void
network_wifi_menu_item_show_item (NetworkWifiMenuItem* self,
                                  GtkWidget* w)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, TRUE);
	_tmp0_ = gtk_widget_get_visible (w);
	_tmp1_ = _tmp0_;
	gtk_widget_set_no_show_all (w, !_tmp1_);
}

static void
network_wifi_menu_item_hide_item (NetworkWifiMenuItem* self,
                                  GtkWidget* w)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, FALSE);
	_tmp0_ = gtk_widget_get_visible (w);
	_tmp1_ = _tmp0_;
	gtk_widget_set_no_show_all (w, !_tmp1_);
	gtk_widget_hide (w);
}

static const gchar*
network_wifi_menu_item_get_strength_symbolic_icon (NetworkWifiMenuItem* self)
{
	guint8 _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_strength;
	if (((gint) _tmp0_) < 30) {
		result = NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "weak" NETWORK_WIFI_MENU_ITEM_SYMBOLIC;
		return result;
	} else {
		guint8 _tmp1_;
		_tmp1_ = self->priv->_strength;
		if (((gint) _tmp1_) < 55) {
			result = NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "ok" NETWORK_WIFI_MENU_ITEM_SYMBOLIC;
			return result;
		} else {
			guint8 _tmp2_;
			_tmp2_ = self->priv->_strength;
			if (((gint) _tmp2_) < 80) {
				result = NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "good" NETWORK_WIFI_MENU_ITEM_SYMBOLIC;
				return result;
			} else {
				result = NETWORK_WIFI_MENU_ITEM_BASE_ICON_NAME "excellent" NETWORK_WIFI_MENU_ITEM_SYMBOLIC;
				return result;
			}
		}
	}
}

NetworkState
network_wifi_menu_item_get_state (NetworkWifiMenuItem* self)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
network_wifi_menu_item_set_state (NetworkWifiMenuItem* self,
                                  NetworkState value)
{
	NetworkState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY]);
	}
}

GBytes*
network_wifi_menu_item_get_ssid (NetworkWifiMenuItem* self)
{
	GBytes* result;
	GBytes* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ssid;
	result = _tmp0_;
	return result;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static void
network_wifi_menu_item_set_ssid (NetworkWifiMenuItem* self,
                                 GBytes* value)
{
	GBytes* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_ssid (self);
	if (old_value != value) {
		GBytes* _tmp0_;
		_tmp0_ = _g_bytes_ref0 (value);
		_g_bytes_unref0 (self->priv->_ssid);
		self->priv->_ssid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY]);
	}
}

guint8
network_wifi_menu_item_get_strength (NetworkWifiMenuItem* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_strength;
	return result;
}

static void
network_wifi_menu_item_set_strength (NetworkWifiMenuItem* self,
                                     guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = network_wifi_menu_item_get_strength (self);
	if (old_value != value) {
		self->priv->_strength = value;
		g_object_notify_by_pspec ((GObject *) self, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY]);
	}
}

static void
_network_wifi_menu_item_update_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	network_wifi_menu_item_update ((NetworkWifiMenuItem*) self);
}

static gboolean
_network_wifi_menu_item___lambda6_ (NetworkWifiMenuItem* self)
{
	g_signal_emit_by_name ((GtkListBoxRow*) self, "activate");
}

static gboolean
__network_wifi_menu_item___lambda6__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self)
{
	gboolean result;
	result = _network_wifi_menu_item___lambda6_ ((NetworkWifiMenuItem*) self);
	return result;
}

static void
_network_wifi_menu_item___lambda7_ (NetworkWifiMenuItem* self)
{
	g_signal_emit (self, network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL], 0);
}

static void
__network_wifi_menu_item___lambda7__gtk_list_box_row_activate (GtkListBoxRow* _sender,
                                                               gpointer self)
{
	_network_wifi_menu_item___lambda7_ ((NetworkWifiMenuItem*) self);
}

static void
_network_wifi_menu_item___lambda8_ (NetworkWifiMenuItem* self)
{
	network_wifi_menu_item_start_refresh (self);
}

static void
__network_wifi_menu_item___lambda8__gtk_widget_map (GtkWidget* _sender,
                                                    gpointer self)
{
	_network_wifi_menu_item___lambda8_ ((NetworkWifiMenuItem*) self);
}

static void
_network_wifi_menu_item___lambda9_ (NetworkWifiMenuItem* self)
{
	network_wifi_menu_item_stop_refresh (self);
}

static void
__network_wifi_menu_item___lambda9__gtk_widget_unmap (GtkWidget* _sender,
                                                      gpointer self)
{
	_network_wifi_menu_item___lambda9_ ((NetworkWifiMenuItem*) self);
}

static GObject *
network_wifi_menu_item_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWifiMenuItem * self;
	GeeLinkedList* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkSpinner* _tmp11_;
	GtkSpinner* _tmp12_;
	GtkSpinner* _tmp13_;
	GtkSpinner* _tmp14_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkRadioButton* _tmp18_;
	GtkGrid* _tmp19_;
	GtkSpinner* _tmp20_;
	GtkGrid* _tmp21_;
	GtkImage* _tmp22_;
	GtkGrid* _tmp23_;
	GtkImage* _tmp24_;
	GtkGrid* _tmp25_;
	GtkImage* _tmp26_;
	GtkGrid* _tmp27_;
	GtkRadioButton* _tmp28_;
	parent_class = G_OBJECT_CLASS (network_wifi_menu_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	_tmp0_ = gee_linked_list_new (nm_access_point_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_aps);
	self->priv->all_aps = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "menuitem");
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp2_;
	_tmp3_ = self->priv->radio_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->radio_button;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 6);
	_tmp5_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->img_strength);
	self->priv->img_strength = _tmp5_;
	_tmp6_ = self->priv->img_strength;
	g_object_set (_tmp6_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	_tmp7_ = self->priv->img_strength;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp7_, 6);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("channel-insecure-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->lock_img);
	self->priv->lock_img = _tmp8_;
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("process-error-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->error_img);
	self->priv->error_img = _tmp9_;
	_tmp10_ = self->priv->error_img;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("This wireless network could not be connected to."));
	_tmp11_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp11_;
	_tmp12_ = self->priv->spinner;
	gtk_spinner_start (_tmp12_);
	_tmp13_ = self->priv->spinner;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, FALSE);
	_tmp14_ = self->priv->spinner;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp15_);
	grid = _tmp15_;
	_tmp16_ = grid;
	gtk_grid_set_column_spacing (_tmp16_, 6);
	_tmp17_ = grid;
	_tmp18_ = self->priv->radio_button;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = grid;
	_tmp20_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = grid;
	_tmp22_ = self->priv->error_img;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = grid;
	_tmp24_ = self->priv->lock_img;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = grid;
	_tmp26_ = self->priv->img_strength;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _network_wifi_menu_item_update_g_object_notify, self, 0);
	_tmp28_ = self->priv->radio_button;
	g_signal_connect_object ((GObject*) _tmp28_, "notify::active", (GCallback) _network_wifi_menu_item_update_g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) __network_wifi_menu_item___lambda6__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkListBoxRow*) self, "activate", (GCallback) __network_wifi_menu_item___lambda7__gtk_list_box_row_activate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __network_wifi_menu_item___lambda8__gtk_widget_map, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) __network_wifi_menu_item___lambda9__gtk_widget_unmap, self, 0);
	_g_object_unref0 (grid);
	return obj;
}

static void
network_wifi_menu_item_class_init (NetworkWifiMenuItemClass * klass,
                                   gpointer klass_data)
{
	network_wifi_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_menu_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_wifi_menu_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", NETWORK_TYPE_STATE, NETWORK_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY] = g_param_spec_boxed ("ssid", "ssid", "ssid", G_TYPE_BYTES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY, network_wifi_menu_item_properties[NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY] = g_param_spec_uchar ("strength", "strength", "strength", 0, G_MAXUINT8, (guint8) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	network_wifi_menu_item_signals[NETWORK_WIFI_MENU_ITEM_USER_ACTION_SIGNAL] = g_signal_new ("user-action", NETWORK_TYPE_WIFI_MENU_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
network_wifi_menu_item_instance_init (NetworkWifiMenuItem * self,
                                      gpointer klass)
{
	self->priv = network_wifi_menu_item_get_instance_private (self);
	self->priv->_state = NETWORK_STATE_DISCONNECTED;
	self->priv->_strength = (guint8) 0;
	g_rec_mutex_init (&self->priv->__lock_all_aps);
	g_rec_mutex_init (&self->priv->__lock_refresh_source);
	self->priv->refresh_source = (guint) 0;
}

static void
network_wifi_menu_item_finalize (GObject * obj)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	_g_bytes_unref0 (self->priv->_ssid);
	g_rec_mutex_clear (&self->priv->__lock_all_aps);
	_g_object_unref0 (self->priv->all_aps);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->img_strength);
	_g_object_unref0 (self->priv->lock_img);
	_g_object_unref0 (self->priv->error_img);
	_g_object_unref0 (self->priv->spinner);
	g_rec_mutex_clear (&self->priv->__lock_refresh_source);
	G_OBJECT_CLASS (network_wifi_menu_item_parent_class)->finalize (obj);
}

GType
network_wifi_menu_item_get_type (void)
{
	return network_wifi_menu_item_type_id;
}

GType
network_wifi_menu_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiMenuItem), 0, (GInstanceInitFunc) network_wifi_menu_item_instance_init, NULL };
	network_wifi_menu_item_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "NetworkWifiMenuItem", &g_define_type_info, 0);
	NetworkWifiMenuItem_private_offset = sizeof (NetworkWifiMenuItemPrivate);
	return network_wifi_menu_item_type_id;
}

static void
_vala_network_wifi_menu_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		g_value_set_enum (value, network_wifi_menu_item_get_state (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY:
		g_value_set_boxed (value, network_wifi_menu_item_get_ssid (self));
		break;
		case NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY:
		g_value_set_uchar (value, network_wifi_menu_item_get_strength (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_menu_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem);
	switch (property_id) {
		case NETWORK_WIFI_MENU_ITEM_STATE_PROPERTY:
		network_wifi_menu_item_set_state (self, g_value_get_enum (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_SSID_PROPERTY:
		network_wifi_menu_item_set_ssid (self, g_value_get_boxed (value));
		break;
		case NETWORK_WIFI_MENU_ITEM_STRENGTH_PROPERTY:
		network_wifi_menu_item_set_strength (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

