/* FuzzyClockApplet.c generated by valac 0.56.14, the Vala compiler
 * generated from FuzzyClockApplet.vala, do not modify */

/*
 * This file is part of budgie-extras
 *
 * Copyright © 2019 Ubuntu Budgie Developers
 * Author: Adam Dyess
 * Website=https://ubuntubudgie.org
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details. You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "fuzzyclock.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <plugin.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <locale.h>
#include <config.h>
#include <gio/gdesktopappinfo.h>
#include <libpeas/peas.h>

enum  {
	FUZZY_CLOCK_PLUGIN_0_PROPERTY,
	FUZZY_CLOCK_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* fuzzy_clock_plugin_properties[FUZZY_CLOCK_PLUGIN_NUM_PROPERTIES];
typedef enum  {
	CLOCK_FORMAT_TWENTYFOUR = 0,
	CLOCK_FORMAT_TWELVE = 1
} ClockFormat;

#define TYPE_CLOCK_FORMAT (clock_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ParamSpecFuzzyClockRule ParamSpecFuzzyClockRule;
enum  {
	FUZZY_CLOCK_APPLET_0_PROPERTY,
	FUZZY_CLOCK_APPLET_UUID_PROPERTY,
	FUZZY_CLOCK_APPLET_NUM_PROPERTIES
};
static GParamSpec* fuzzy_clock_applet_properties[FUZZY_CLOCK_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ParamSpecFuzzyClockRule {
	GParamSpec parent_instance;
};

struct _FuzzyClockAppletPrivate {
	gchar* _uuid;
	GSettings* panel_settings;
	GSettings* currpanelsubject_settings;
	gboolean fuzzy_onpanel;
	gchar* general_path;
	gchar* date_format;
	GDateTime* time;
	BudgiePopover* popover;
	GAppInfo* calprov;
	GtkButton* cal_button;
	GtkCheckButton* clock_format;
	GtkCheckButton* check_date;
	gulong check_id;
	GtkOrientation orient;
	BudgiePopoverManager* manager;
};

struct _Block1Data {
	int _ref_count_;
	FuzzyClockApplet* self;
	gchar** applets;
	gint applets_length1;
	gint _applets_size_;
	gchar* uuid;
};

struct _Block2Data {
	int _ref_count_;
	FuzzyClockApplet* self;
	GtkStack* stack;
	gchar* uuid;
};

static gpointer fuzzy_clock_plugin_parent_class = NULL;
static BudgiePluginIface * fuzzy_clock_plugin_budgie_plugin_parent_iface = NULL;
static GType fuzzy_clock_plugin_type_id = 0;
static gpointer fuzzy_clock_rule_parent_class = NULL;
static GType fuzzy_clock_rule_type_id = 0;
static gint FuzzyClockApplet_private_offset;
static gpointer fuzzy_clock_applet_parent_class = NULL;
static GType fuzzy_clock_applet_type_id = 0;

static BudgieApplet* fuzzy_clock_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                        const gchar* uuid);
VALA_EXTERN GType clock_format_get_type (void) G_GNUC_CONST ;
static void fuzzy_clock_rule_finalize (FuzzyClockRule * obj);
static gboolean fuzzy_clock_applet_find_applet (FuzzyClockApplet* self,
                                         const gchar* uuid,
                                         gchar** applets,
                                         gint applets_length1);
static void fuzzy_clock_applet_watchapplet (FuzzyClockApplet* self,
                                     const gchar* uuid);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _____lambda4_ (Block1Data* _data1_);
static void ______lambda4__g_settings_changed (GSettings* _sender,
                                        const gchar* key,
                                        gpointer self);
static GtkButton* fuzzy_clock_applet_new_directional_button (FuzzyClockApplet* self,
                                                      const gchar* label_str,
                                                      GtkPositionType arrow_direction);
static GtkButton* fuzzy_clock_applet_new_plain_button (FuzzyClockApplet* self,
                                                const gchar* label_str);
static void fuzzy_clock_applet_real_panel_position_changed (BudgieApplet* base,
                                                     BudgiePanelPosition position);
static gint fuzzy_clock_applet_get_containingindex (FuzzyClockApplet* self,
                                             gchar** arr,
                                             gint arr_length1,
                                             const gchar* lookfor);
static gchar* fuzzy_clock_applet_read_dateformat (FuzzyClockApplet* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block2Data* _data2_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void fuzzy_clock_applet_on_date_activate (FuzzyClockApplet* self);
static void _fuzzy_clock_applet_on_date_activate_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void fuzzy_clock_applet_on_cal_activate (FuzzyClockApplet* self);
static void _fuzzy_clock_applet_on_cal_activate_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void __lambda6_ (Block2Data* _data2_);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda7_ (FuzzyClockApplet* self);
static void ___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                            gpointer self);
static void __lambda8_ (Block2Data* _data2_);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__budgie_popover_closed (BudgiePopover* _sender,
                                        gpointer self);
static gboolean __lambda10_ (FuzzyClockApplet* self,
                      GdkEventButton* e);
static gboolean ___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean _fuzzy_clock_applet_update_clock_gsource_func (gpointer self);
static void _fuzzy_clock_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self);
static void fuzzy_clock_applet_update_cal (FuzzyClockApplet* self);
static void _fuzzy_clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                gpointer self);
static void fuzzy_clock_applet_real_update_popovers (BudgieApplet* base,
                                              BudgiePopoverManager* manager);
static void fuzzy_clock_applet_finalize (GObject * obj);
static void _vala_fuzzy_clock_applet_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_fuzzy_clock_applet_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static BudgieApplet*
fuzzy_clock_plugin_real_get_panel_widget (BudgiePlugin* base,
                                          const gchar* uuid)
{
	FuzzyClockPlugin * self;
	FuzzyClockApplet* _tmp0_;
	BudgieApplet* result;
	self = (FuzzyClockPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = fuzzy_clock_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

FuzzyClockPlugin*
fuzzy_clock_plugin_construct (GType object_type)
{
	FuzzyClockPlugin * self = NULL;
	self = (FuzzyClockPlugin*) g_object_new (object_type, NULL);
	return self;
}

FuzzyClockPlugin*
fuzzy_clock_plugin_new (void)
{
	return fuzzy_clock_plugin_construct (TYPE_FUZZY_CLOCK_PLUGIN);
}

static void
fuzzy_clock_plugin_class_init (FuzzyClockPluginClass * klass,
                               gpointer klass_data)
{
	fuzzy_clock_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
fuzzy_clock_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                 gpointer iface_data)
{
	fuzzy_clock_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) fuzzy_clock_plugin_real_get_panel_widget;
}

static void
fuzzy_clock_plugin_instance_init (FuzzyClockPlugin * self,
                                  gpointer klass)
{
}

GType
fuzzy_clock_plugin_get_type (void)
{
	return fuzzy_clock_plugin_type_id;
}

GType
fuzzy_clock_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FuzzyClockPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fuzzy_clock_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FuzzyClockPlugin), 0, (GInstanceInitFunc) fuzzy_clock_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) fuzzy_clock_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	fuzzy_clock_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "FuzzyClockPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, fuzzy_clock_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return fuzzy_clock_plugin_type_id;
}

static GType
clock_format_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCK_FORMAT_TWENTYFOUR, "CLOCK_FORMAT_TWENTYFOUR", "twentyfour"}, {CLOCK_FORMAT_TWELVE, "CLOCK_FORMAT_TWELVE", "twelve"}, {0, NULL, NULL}};
	GType clock_format_type_id;
	clock_format_type_id = g_enum_register_static ("ClockFormat", values);
	return clock_format_type_id;
}

GType
clock_format_get_type (void)
{
	static volatile gsize clock_format_type_id__once = 0;
	if (g_once_init_enter (&clock_format_type_id__once)) {
		GType clock_format_type_id;
		clock_format_type_id = clock_format_get_type_once ();
		g_once_init_leave (&clock_format_type_id__once, clock_format_type_id);
	}
	return clock_format_type_id__once;
}

/**
     * Format string rules
     *      one for each of 12 text formats
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

FuzzyClockRule*
fuzzy_clock_rule_construct (GType object_type,
                            const gchar* rule_text,
                            gint hour_offset)
{
	FuzzyClockRule* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (rule_text != NULL, NULL);
	self = (FuzzyClockRule*) g_type_create_instance (object_type);
	_tmp0_ = string_replace (rule_text, FUZZY_CLOCK_RULE_fwd_hour, "");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, FUZZY_CLOCK_RULE_back_hour, "");
	_g_free0 (self->format);
	self->format = _tmp2_;
	_g_free0 (_tmp1_);
	self->hour_offset = hour_offset;
	if (string_contains (rule_text, FUZZY_CLOCK_RULE_fwd_hour)) {
		self->hour_offset = hour_offset + 1;
	} else {
		if (string_contains (rule_text, FUZZY_CLOCK_RULE_back_hour)) {
			self->hour_offset = hour_offset - 1;
		}
	}
	return self;
}

FuzzyClockRule*
fuzzy_clock_rule_new (const gchar* rule_text,
                      gint hour_offset)
{
	return fuzzy_clock_rule_construct (TYPE_FUZZY_CLOCK_RULE, rule_text, hour_offset);
}

static void
value_fuzzy_clock_rule_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_fuzzy_clock_rule_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		fuzzy_clock_rule_unref (value->data[0].v_pointer);
	}
}

static void
value_fuzzy_clock_rule_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fuzzy_clock_rule_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_fuzzy_clock_rule_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_fuzzy_clock_rule_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FuzzyClockRule * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fuzzy_clock_rule_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_fuzzy_clock_rule_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	FuzzyClockRule ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fuzzy_clock_rule_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_fuzzy_clock_rule (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecFuzzyClockRule* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FUZZY_CLOCK_RULE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_fuzzy_clock_rule (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FUZZY_CLOCK_RULE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_fuzzy_clock_rule (GValue* value,
                            gpointer v_object)
{
	FuzzyClockRule * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FUZZY_CLOCK_RULE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FUZZY_CLOCK_RULE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fuzzy_clock_rule_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fuzzy_clock_rule_unref (old);
	}
}

void
value_take_fuzzy_clock_rule (GValue* value,
                             gpointer v_object)
{
	FuzzyClockRule * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FUZZY_CLOCK_RULE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FUZZY_CLOCK_RULE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fuzzy_clock_rule_unref (old);
	}
}

static void
fuzzy_clock_rule_class_init (FuzzyClockRuleClass * klass,
                             gpointer klass_data)
{
	fuzzy_clock_rule_parent_class = g_type_class_peek_parent (klass);
	((FuzzyClockRuleClass *) klass)->finalize = fuzzy_clock_rule_finalize;
}

static void
fuzzy_clock_rule_instance_init (FuzzyClockRule * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	self->format = _tmp0_;
	self->hour_offset = 0;
	self->ref_count = 1;
}

static void
fuzzy_clock_rule_finalize (FuzzyClockRule * obj)
{
	FuzzyClockRule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUZZY_CLOCK_RULE, FuzzyClockRule);
	g_signal_handlers_destroy (self);
	_g_free0 (self->format);
}

GType
fuzzy_clock_rule_get_type (void)
{
	return fuzzy_clock_rule_type_id;
}

GType
fuzzy_clock_rule_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { value_fuzzy_clock_rule_init, value_fuzzy_clock_rule_free_value, value_fuzzy_clock_rule_copy_value, value_fuzzy_clock_rule_peek_pointer, "p", value_fuzzy_clock_rule_collect_value, "p", value_fuzzy_clock_rule_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FuzzyClockRuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fuzzy_clock_rule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FuzzyClockRule), 0, (GInstanceInitFunc) fuzzy_clock_rule_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	fuzzy_clock_rule_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FuzzyClockRule", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return fuzzy_clock_rule_type_id;
}

gpointer
fuzzy_clock_rule_ref (gpointer instance)
{
	FuzzyClockRule * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
fuzzy_clock_rule_unref (gpointer instance)
{
	FuzzyClockRule * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FUZZY_CLOCK_RULE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
fuzzy_clock_applet_get_instance_private (FuzzyClockApplet* self)
{
	return G_STRUCT_MEMBER_P (self, FuzzyClockApplet_private_offset);
}

static gboolean
fuzzy_clock_applet_find_applet (FuzzyClockApplet* self,
                                const gchar* uuid,
                                gchar** applets,
                                gint applets_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uuid != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < applets_length1)) {
					break;
				}
				_tmp2_ = applets[i];
				if (g_strcmp0 (_tmp2_, uuid) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FuzzyClockApplet* self;
		self = _data1_->self;
		_data1_->applets = (_vala_array_free (_data1_->applets, _data1_->applets_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data1_->uuid);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_____lambda4_ (Block1Data* _data1_)
{
	FuzzyClockApplet* self;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = _data1_->self;
	_tmp0_ = self->priv->currpanelsubject_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "applets");
	_data1_->applets = (_vala_array_free (_data1_->applets, _data1_->applets_length1, (GDestroyNotify) g_free), NULL);
	_data1_->applets = _tmp2_;
	_data1_->applets_length1 = _vala_array_length (_tmp1_);
	_data1_->_applets_size_ = _data1_->applets_length1;
	_tmp3_ = _data1_->applets;
	_tmp3__length1 = _data1_->applets_length1;
	if (!fuzzy_clock_applet_find_applet (self, _data1_->uuid, _tmp3_, (gint) _tmp3__length1)) {
		self->priv->fuzzy_onpanel = FALSE;
	}
}

static void
______lambda4__g_settings_changed (GSettings* _sender,
                                   const gchar* key,
                                   gpointer self)
{
	_____lambda4_ (self);
}

static void
fuzzy_clock_applet_watchapplet (FuzzyClockApplet* self,
                                const gchar* uuid)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar** allpanels_list = NULL;
	GSettings* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint allpanels_list_length1;
	gint _allpanels_list_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (uuid);
	_g_free0 (_data1_->uuid);
	_data1_->uuid = _tmp0_;
	_tmp1_ = self->priv->general_path;
	_tmp2_ = g_settings_new (_tmp1_);
	_g_object_unref0 (self->priv->panel_settings);
	self->priv->panel_settings = _tmp2_;
	_tmp3_ = self->priv->panel_settings;
	_tmp5_ = _tmp4_ = g_settings_get_strv (_tmp3_, "panels");
	allpanels_list = _tmp5_;
	allpanels_list_length1 = _vala_array_length (_tmp4_);
	_allpanels_list_size_ = allpanels_list_length1;
	_tmp6_ = allpanels_list;
	_tmp6__length1 = allpanels_list_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp6_;
		p_collection_length1 = _tmp6__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp7_;
			gchar* p = NULL;
			_tmp7_ = g_strdup (p_collection[p_it]);
			p = _tmp7_;
			{
				gchar* panelpath = NULL;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				GSettings* _tmp14_;
				GSettings* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp8_ = p;
				_tmp9_ = g_strconcat ("/com/solus-project/budgie-panel/panels/", "{", _tmp8_, "}/", NULL);
				panelpath = _tmp9_;
				_tmp10_ = self->priv->general_path;
				_tmp11_ = g_strconcat (_tmp10_, ".panel", NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = panelpath;
				_tmp14_ = g_settings_new_with_path (_tmp12_, _tmp13_);
				_g_object_unref0 (self->priv->currpanelsubject_settings);
				self->priv->currpanelsubject_settings = _tmp14_;
				_g_free0 (_tmp12_);
				_tmp15_ = self->priv->currpanelsubject_settings;
				_tmp17_ = _tmp16_ = g_settings_get_strv (_tmp15_, "applets");
				_data1_->applets = (_vala_array_free (_data1_->applets, _data1_->applets_length1, (GDestroyNotify) g_free), NULL);
				_data1_->applets = _tmp17_;
				_data1_->applets_length1 = _vala_array_length (_tmp16_);
				_data1_->_applets_size_ = _data1_->applets_length1;
				_tmp18_ = _data1_->applets;
				_tmp18__length1 = _data1_->applets_length1;
				if (fuzzy_clock_applet_find_applet (self, _data1_->uuid, _tmp18_, (gint) _tmp18__length1)) {
					GSettings* _tmp19_;
					_tmp19_ = self->priv->currpanelsubject_settings;
					g_signal_connect_data (_tmp19_, "changed::applets", (GCallback) ______lambda4__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
					_g_free0 (panelpath);
					_g_free0 (p);
					break;
				}
				_g_free0 (panelpath);
				_g_free0 (p);
			}
		}
	}
	allpanels_list = (_vala_array_free (allpanels_list, allpanels_list_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
     * Helper to create fancy button with a direction indicator
     */
static GtkButton*
fuzzy_clock_applet_new_directional_button (FuzzyClockApplet* self,
                                           const gchar* label_str,
                                           GtkPositionType arrow_direction)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	GtkButton* button = NULL;
	GtkButton* _tmp3_;
	GtkImage* image = NULL;
	GtkImage* _tmp4_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkButton* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_str != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = box;
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_FILL);
	_tmp2_ = (GtkLabel*) gtk_label_new (label_str);
	g_object_ref_sink (_tmp2_);
	label = _tmp2_;
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	button = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	image = _tmp4_;
	if (arrow_direction == GTK_POS_RIGHT) {
		GtkImage* _tmp5_;
		GtkBox* _tmp6_;
		GtkLabel* _tmp7_;
		GtkBox* _tmp8_;
		GtkImage* _tmp9_;
		GtkImage* _tmp10_;
		GtkLabel* _tmp11_;
		_tmp5_ = image;
		gtk_image_set_from_icon_name (_tmp5_, "go-next-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		_tmp6_ = box;
		_tmp7_ = label;
		gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
		_tmp8_ = box;
		_tmp9_ = image;
		gtk_box_pack_end (_tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 1);
		_tmp10_ = image;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp10_, 6);
		_tmp11_ = label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 6);
	} else {
		GtkImage* _tmp12_;
		GtkBox* _tmp13_;
		GtkImage* _tmp14_;
		GtkBox* _tmp15_;
		GtkLabel* _tmp16_;
		GtkImage* _tmp17_;
		_tmp12_ = image;
		gtk_image_set_from_icon_name (_tmp12_, "go-previous-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		_tmp13_ = box;
		_tmp14_ = image;
		gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
		_tmp15_ = box;
		_tmp16_ = label;
		gtk_box_pack_start (_tmp15_, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
		_tmp17_ = image;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 6);
	}
	_tmp18_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	_tmp19_ = label;
	g_object_set ((GtkWidget*) _tmp19_, "margin", 0, NULL);
	_tmp20_ = box;
	g_object_set ((GtkWidget*) _tmp20_, "margin", 0, NULL);
	_tmp21_ = box;
	gtk_container_set_border_width ((GtkContainer*) _tmp21_, (guint) 0);
	_tmp22_ = button;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_add_class (_tmp23_, GTK_STYLE_CLASS_FLAT);
	_tmp24_ = button;
	_tmp25_ = box;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	result = button;
	_g_object_unref0 (image);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	return result;
}

/**
     * Helper to create new dropdown buttons
     */
static GtkButton*
fuzzy_clock_applet_new_plain_button (FuzzyClockApplet* self,
                                     const gchar* label_str)
{
	GtkButton* ret = NULL;
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_str != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_label (label_str);
	g_object_ref_sink (_tmp0_);
	ret = _tmp0_;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) ret);
	gtk_widget_set_halign (_tmp1_, GTK_ALIGN_START);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) ret);
	gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_FLAT);
	result = ret;
	return result;
}

/**
     * Updates the orientation if the panel changes positions
     */
static void
fuzzy_clock_applet_real_panel_position_changed (BudgieApplet* base,
                                                BudgiePanelPosition position)
{
	FuzzyClockApplet * self;
	gboolean _tmp0_ = FALSE;
	GtkBox* _tmp7_;
	self = (FuzzyClockApplet*) base;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		self->priv->orient = GTK_ORIENTATION_VERTICAL;
		if (position == BUDGIE_PANEL_POSITION_RIGHT) {
			GtkLabel* _tmp1_;
			GtkLabel* _tmp2_;
			_tmp1_ = self->clock;
			gtk_label_set_angle (_tmp1_, (gdouble) 270);
			_tmp2_ = self->date_label;
			gtk_label_set_angle (_tmp2_, (gdouble) 270);
		} else {
			GtkLabel* _tmp3_;
			GtkLabel* _tmp4_;
			_tmp3_ = self->clock;
			gtk_label_set_angle (_tmp3_, (gdouble) 90);
			_tmp4_ = self->date_label;
			gtk_label_set_angle (_tmp4_, (gdouble) 90);
		}
	} else {
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		self->priv->orient = GTK_ORIENTATION_HORIZONTAL;
		_tmp5_ = self->clock;
		gtk_label_set_angle (_tmp5_, (gdouble) 0);
		_tmp6_ = self->date_label;
		gtk_label_set_angle (_tmp6_, (gdouble) 0);
	}
	_tmp7_ = self->layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp7_, self->priv->orient);
	fuzzy_clock_applet_update_clock (self);
}

static gint
fuzzy_clock_applet_get_containingindex (FuzzyClockApplet* self,
                                        gchar** arr,
                                        gint arr_length1,
                                        const gchar* lookfor)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (lookfor != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < arr_length1)) {
					break;
				}
				_tmp2_ = arr[i];
				if (string_contains (lookfor, _tmp2_)) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

/**
     * Taken from showtime - calculate the locale dateformat
     */
static gchar*
fuzzy_clock_applet_read_dateformat (FuzzyClockApplet* self)
{
	gchar** monthvars = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint monthvars_length1;
	gint _monthvars_size_;
	gchar** daynamevars = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint daynamevars_length1;
	gint _daynamevars_size_;
	gchar** monthdayvars = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint monthdayvars_length1;
	gint _monthdayvars_size_;
	gchar* cmd = NULL;
	gchar* _tmp22_;
	gchar* output = NULL;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("%B");
	_tmp1_ = g_strdup ("%-b");
	_tmp2_ = g_strdup ("%_b");
	_tmp3_ = g_strdup ("%h");
	_tmp4_ = g_strdup ("%-h");
	_tmp5_ = g_strdup ("%_h");
	_tmp6_ = g_strdup ("%b");
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	monthvars = _tmp7_;
	monthvars_length1 = 7;
	_monthvars_size_ = monthvars_length1;
	_tmp8_ = g_strdup ("%A");
	_tmp9_ = g_strdup ("%a");
	_tmp10_ = g_strdup ("%-a");
	_tmp11_ = g_strdup ("%-A");
	_tmp12_ = g_strdup ("%_a");
	_tmp13_ = g_strdup ("%_A");
	_tmp14_ = g_new0 (gchar*, 6 + 1);
	_tmp14_[0] = _tmp8_;
	_tmp14_[1] = _tmp9_;
	_tmp14_[2] = _tmp10_;
	_tmp14_[3] = _tmp11_;
	_tmp14_[4] = _tmp12_;
	_tmp14_[5] = _tmp13_;
	daynamevars = _tmp14_;
	daynamevars_length1 = 6;
	_daynamevars_size_ = daynamevars_length1;
	_tmp15_ = g_strdup ("%e");
	_tmp16_ = g_strdup ("%-e");
	_tmp17_ = g_strdup ("%_e");
	_tmp18_ = g_strdup ("%d");
	_tmp19_ = g_strdup ("%-d");
	_tmp20_ = g_strdup ("%_d");
	_tmp21_ = g_new0 (gchar*, 6 + 1);
	_tmp21_[0] = _tmp15_;
	_tmp21_[1] = _tmp16_;
	_tmp21_[2] = _tmp17_;
	_tmp21_[3] = _tmp18_;
	_tmp21_[4] = _tmp19_;
	_tmp21_[5] = _tmp20_;
	monthdayvars = _tmp21_;
	monthdayvars_length1 = 6;
	_monthdayvars_size_ = monthdayvars_length1;
	_tmp22_ = g_strdup ("locale date_fmt");
	cmd = _tmp22_;
	_tmp23_ = g_strdup ("");
	output = _tmp23_;
	{
		GString* builder = NULL;
		GString* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar** output_data = NULL;
		const gchar* _tmp26_;
		gchar** _tmp27_;
		gchar** _tmp28_;
		gint output_data_length1;
		gint _output_data_size_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp24_ = g_string_new ("");
		builder = _tmp24_;
		g_spawn_command_line_sync (cmd, &_tmp25_, NULL, NULL, &_inner_error0_);
		_g_free0 (output);
		output = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (builder);
			goto __catch0_g_error;
		}
		_tmp26_ = output;
		_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, " ", 0);
		output_data = _tmp28_;
		output_data_length1 = _vala_array_length (_tmp27_);
		_output_data_size_ = output_data_length1;
		_tmp29_ = output_data;
		_tmp29__length1 = output_data_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp29_;
			s_collection_length1 = _tmp29__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp30_;
				gchar* s = NULL;
				_tmp30_ = g_strdup (s_collection[s_it]);
				s = _tmp30_;
				{
					const gchar* _tmp31_;
					_tmp31_ = s;
					if (fuzzy_clock_applet_get_containingindex (self, monthvars, (gint) monthvars_length1, _tmp31_) != -1) {
						const gchar* _tmp32_;
						GString* _tmp33_;
						_tmp32_ = monthvars[0];
						_tmp33_ = g_string_append (builder, _tmp32_);
						g_string_append (_tmp33_, " ");
					} else {
						const gchar* _tmp34_;
						_tmp34_ = s;
						if (fuzzy_clock_applet_get_containingindex (self, daynamevars, (gint) daynamevars_length1, _tmp34_) != -1) {
							const gchar* _tmp35_;
							GString* _tmp36_;
							_tmp35_ = daynamevars[0];
							_tmp36_ = g_string_append (builder, _tmp35_);
							g_string_append (_tmp36_, " ");
						} else {
							const gchar* _tmp37_;
							_tmp37_ = s;
							if (fuzzy_clock_applet_get_containingindex (self, monthdayvars, (gint) monthdayvars_length1, _tmp37_) != -1) {
								const gchar* _tmp38_;
								GString* _tmp39_;
								_tmp38_ = monthdayvars[0];
								_tmp39_ = g_string_append (builder, _tmp38_);
								g_string_append (_tmp39_, " ");
							}
						}
					}
					_g_free0 (s);
				}
			}
		}
		_tmp40_ = builder->str;
		_tmp41_ = g_strdup (_tmp40_);
		result = _tmp41_;
		output_data = (_vala_array_free (output_data, output_data_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (builder);
		_g_free0 (output);
		_g_free0 (cmd);
		monthdayvars = (_vala_array_free (monthdayvars, monthdayvars_length1, (GDestroyNotify) g_free), NULL);
		daynamevars = (_vala_array_free (daynamevars, daynamevars_length1, (GDestroyNotify) g_free), NULL);
		monthvars = (_vala_array_free (monthvars, monthvars_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp42_;
		g_clear_error (&_inner_error0_);
		_tmp42_ = g_strdup ("");
		result = _tmp42_;
		_g_free0 (output);
		_g_free0 (cmd);
		monthdayvars = (_vala_array_free (monthdayvars, monthdayvars_length1, (GDestroyNotify) g_free), NULL);
		daynamevars = (_vala_array_free (daynamevars, daynamevars_length1, (GDestroyNotify) g_free), NULL);
		monthvars = (_vala_array_free (monthvars, monthvars_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	_g_free0 (output);
	_g_free0 (cmd);
	monthdayvars = (_vala_array_free (monthdayvars, monthdayvars_length1, (GDestroyNotify) g_free), NULL);
	daynamevars = (_vala_array_free (daynamevars, daynamevars_length1, (GDestroyNotify) g_free), NULL);
	monthvars = (_vala_array_free (monthvars, monthvars_length1, (GDestroyNotify) g_free), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
     * Main initialization of the Applet
     */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FuzzyClockApplet* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->stack);
		_g_free0 (_data2_->uuid);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda5_ (Block2Data* _data2_)
{
	FuzzyClockApplet* self;
	gboolean result;
	self = _data2_->self;
	fuzzy_clock_applet_watchapplet (self, _data2_->uuid);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

static void
_fuzzy_clock_applet_on_date_activate_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	fuzzy_clock_applet_on_date_activate ((FuzzyClockApplet*) self);
}

static void
_fuzzy_clock_applet_on_cal_activate_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	fuzzy_clock_applet_on_cal_activate ((FuzzyClockApplet*) self);
}

static void
__lambda6_ (Block2Data* _data2_)
{
	FuzzyClockApplet* self;
	self = _data2_->self;
	gtk_stack_set_visible_child_name (_data2_->stack, "prefs");
}

static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ (self);
}

static void
__lambda7_ (FuzzyClockApplet* self)
{
	ClockFormat f = 0;
	GSettings* _tmp0_;
	ClockFormat _tmp1_ = 0;
	ClockFormat newf = 0;
	GSettings* _tmp2_;
	_tmp0_ = self->settings;
	f = (ClockFormat) g_settings_get_enum (_tmp0_, "clock-format");
	if (f == CLOCK_FORMAT_TWELVE) {
		_tmp1_ = CLOCK_FORMAT_TWENTYFOUR;
	} else {
		_tmp1_ = CLOCK_FORMAT_TWELVE;
	}
	newf = _tmp1_;
	_tmp2_ = self->settings;
	g_settings_set_enum (_tmp2_, "clock-format", (gint) newf);
}

static void
___lambda7__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                       gpointer self)
{
	__lambda7_ ((FuzzyClockApplet*) self);
}

static void
__lambda8_ (Block2Data* _data2_)
{
	FuzzyClockApplet* self;
	self = _data2_->self;
	gtk_stack_set_visible_child_name (_data2_->stack, "root");
}

static void
___lambda8__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda8_ (self);
}

static void
__lambda9_ (Block2Data* _data2_)
{
	FuzzyClockApplet* self;
	self = _data2_->self;
	gtk_stack_set_visible_child_name (_data2_->stack, "root");
}

static void
___lambda9__budgie_popover_closed (BudgiePopover* _sender,
                                   gpointer self)
{
	__lambda9_ (self);
}

static gboolean
__lambda10_ (FuzzyClockApplet* self,
             GdkEventButton* e)
{
	BudgiePopover* _tmp0_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		BudgiePopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgiePopoverManager* _tmp2_;
		GtkEventBox* _tmp3_;
		_tmp2_ = self->priv->manager;
		_tmp3_ = self->widget;
		budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda10__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda10_ ((FuzzyClockApplet*) self, event);
	return result;
}

static gboolean
_fuzzy_clock_applet_update_clock_gsource_func (gpointer self)
{
	gboolean result;
	result = fuzzy_clock_applet_update_clock ((FuzzyClockApplet*) self);
	return result;
}

static void
_fuzzy_clock_applet_on_settings_change_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self)
{
	fuzzy_clock_applet_on_settings_change ((FuzzyClockApplet*) self, key);
}

static void
_fuzzy_clock_applet_update_cal_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                           gpointer self)
{
	fuzzy_clock_applet_update_cal ((FuzzyClockApplet*) self);
}

FuzzyClockApplet*
fuzzy_clock_applet_construct (GType object_type,
                              const gchar* uuid)
{
	FuzzyClockApplet * self = NULL;
	Block2Data* _data2_;
	gchar* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GDateTime* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	gchar* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GSettings* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkEventBox* _tmp21_;
	BudgiePopover* _tmp22_;
	GtkStack* _tmp23_;
	GtkStyleContext* _tmp24_;
	BudgiePopover* _tmp25_;
	GtkBox* menu = NULL;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkButton* time_button = NULL;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkButton* _tmp33_;
	GtkButton* sub_button = NULL;
	GtkButton* _tmp34_;
	GtkButton* _tmp35_;
	GtkBox* _tmp36_;
	GtkButton* _tmp37_;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkBox* _tmp40_;
	GtkCheckButton* _tmp41_;
	GtkCheckButton* _tmp42_;
	GtkWidget* _tmp43_;
	GValue _tmp44_ = {0};
	GSettings* _tmp45_;
	GtkCheckButton* _tmp46_;
	GSettings* _tmp47_;
	GtkLabel* _tmp48_;
	GtkCheckButton* _tmp49_;
	GtkCheckButton* _tmp50_;
	GtkWidget* _tmp51_;
	GValue _tmp52_ = {0};
	GtkCheckButton* _tmp53_;
	gulong _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	GtkBox* _tmp57_;
	GtkButton* _tmp58_;
	GtkBox* _tmp59_;
	GtkSeparator* _tmp60_;
	GtkSeparator* _tmp61_;
	GtkBox* _tmp62_;
	GtkCheckButton* _tmp63_;
	GtkBox* _tmp64_;
	GtkCheckButton* _tmp65_;
	GtkBox* _tmp66_;
	BudgiePopover* _tmp67_;
	GtkEventBox* _tmp68_;
	GSettings* _tmp69_;
	GAppInfo* _tmp70_;
	GAppInfoMonitor* monitor = NULL;
	GAppInfoMonitor* _tmp71_;
	GtkButton* _tmp72_;
	GAppInfo* _tmp73_;
	GtkButton* _tmp74_;
	GtkEventBox* _tmp75_;
	BudgiePopover* _tmp76_;
	GtkWidget* _tmp77_;
	g_return_val_if_fail (uuid != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_strdup (uuid);
	_g_free0 (_data2_->uuid);
	_data2_->uuid = _tmp0_;
	self = (FuzzyClockApplet*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	fuzzy_clock_applet_initialiseLocaleLanguageSupport (self);
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->layout);
	self->layout = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->clock);
	self->clock = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (self->priv->time);
	self->priv->time = _tmp4_;
	_tmp5_ = self->widget;
	_tmp6_ = self->layout;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->layout;
	_tmp8_ = self->clock;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = self->layout;
	g_object_set ((GtkWidget*) _tmp9_, "margin", 0, NULL);
	_tmp10_ = self->layout;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 0);
	_tmp11_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->date_label);
	self->date_label = _tmp11_;
	_tmp12_ = self->layout;
	_tmp13_ = self->date_label;
	gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	_tmp14_ = self->date_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->date_label;
	gtk_widget_hide ((GtkWidget*) _tmp15_);
	_tmp16_ = fuzzy_clock_applet_read_dateformat (self);
	_g_free0 (self->priv->date_format);
	self->priv->date_format = _tmp16_;
	_tmp17_ = self->clock;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	_tmp18_ = self->date_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	_tmp19_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->settings);
	self->settings = _tmp19_;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp20_, "budgie-fuzzy-clock-applet");
	_tmp21_ = self->widget;
	_tmp22_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp21_);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp22_;
	_tmp23_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp23_);
	_data2_->stack = _tmp23_;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _data2_->stack);
	gtk_style_context_add_class (_tmp24_, "fuzzy-clock-applet-stack");
	_tmp25_ = self->priv->popover;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _data2_->stack);
	gtk_stack_set_homogeneous (_data2_->stack, TRUE);
	gtk_stack_set_transition_type (_data2_->stack, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp26_);
	menu = _tmp26_;
	_tmp27_ = menu;
	gtk_container_set_border_width ((GtkContainer*) _tmp27_, (guint) 6);
	_tmp28_ = fuzzy_clock_applet_new_plain_button (self, _ ("Date and Time settings"));
	time_button = _tmp28_;
	_tmp29_ = fuzzy_clock_applet_new_plain_button (self, _ ("Calendar"));
	_g_object_unref0 (self->priv->cal_button);
	self->priv->cal_button = _tmp29_;
	g_signal_connect_object (time_button, "clicked", (GCallback) _fuzzy_clock_applet_on_date_activate_gtk_button_clicked, self, 0);
	_tmp30_ = self->priv->cal_button;
	g_signal_connect_object (_tmp30_, "clicked", (GCallback) _fuzzy_clock_applet_on_cal_activate_gtk_button_clicked, self, 0);
	_tmp31_ = menu;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) time_button, FALSE, FALSE, (guint) 0);
	_tmp32_ = menu;
	_tmp33_ = self->priv->cal_button;
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = fuzzy_clock_applet_new_directional_button (self, _ ("Preferences"), GTK_POS_RIGHT);
	sub_button = _tmp34_;
	_tmp35_ = sub_button;
	g_signal_connect_data (_tmp35_, "clicked", (GCallback) ___lambda6__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp36_ = menu;
	_tmp37_ = sub_button;
	gtk_box_pack_end (_tmp36_, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 2);
	_tmp38_ = menu;
	gtk_stack_add_named (_data2_->stack, (GtkWidget*) _tmp38_, "root");
	_tmp39_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (menu);
	menu = _tmp39_;
	_tmp40_ = menu;
	gtk_container_set_border_width ((GtkContainer*) _tmp40_, (guint) 6);
	_tmp41_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Show date"));
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->check_date);
	self->priv->check_date = _tmp41_;
	_tmp42_ = self->priv->check_date;
	_tmp43_ = gtk_bin_get_child ((GtkBin*) _tmp42_);
	g_value_init (&_tmp44_, G_TYPE_INT);
	g_value_set_int (&_tmp44_, 8);
	g_object_set_property ((GObject*) _tmp43_, "margin-start", &_tmp44_);
	G_IS_VALUE (&_tmp44_) ? (g_value_unset (&_tmp44_), NULL) : NULL;
	_tmp45_ = self->settings;
	_tmp46_ = self->priv->check_date;
	g_settings_bind (_tmp45_, "clock-show-date", (GObject*) _tmp46_, "active", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
	_tmp47_ = self->settings;
	_tmp48_ = self->date_label;
	g_settings_bind (_tmp47_, "clock-show-date", (GObject*) _tmp48_, "visible", G_SETTINGS_BIND_DEFAULT);
	_tmp49_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Use 24 hour time"));
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->clock_format);
	self->priv->clock_format = _tmp49_;
	_tmp50_ = self->priv->clock_format;
	_tmp51_ = gtk_bin_get_child ((GtkBin*) _tmp50_);
	g_value_init (&_tmp52_, G_TYPE_INT);
	g_value_set_int (&_tmp52_, 8);
	g_object_set_property ((GObject*) _tmp51_, "margin-start", &_tmp52_);
	G_IS_VALUE (&_tmp52_) ? (g_value_unset (&_tmp52_), NULL) : NULL;
	_tmp53_ = self->priv->clock_format;
	_tmp54_ = g_signal_connect_object ((GtkToggleButton*) _tmp53_, "toggled", (GCallback) ___lambda7__gtk_toggle_button_toggled, self, G_CONNECT_AFTER);
	self->priv->check_id = _tmp54_;
	_tmp55_ = fuzzy_clock_applet_new_directional_button (self, _ ("Preferences"), GTK_POS_LEFT);
	_g_object_unref0 (sub_button);
	sub_button = _tmp55_;
	_tmp56_ = sub_button;
	g_signal_connect_data (_tmp56_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp57_ = menu;
	_tmp58_ = sub_button;
	gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
	_tmp59_ = menu;
	_tmp60_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp60_);
	_tmp61_ = _tmp60_;
	gtk_box_pack_start (_tmp59_, (GtkWidget*) _tmp61_, FALSE, FALSE, (guint) 2);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = menu;
	_tmp63_ = self->priv->check_date;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 0);
	_tmp64_ = menu;
	_tmp65_ = self->priv->clock_format;
	gtk_box_pack_start (_tmp64_, (GtkWidget*) _tmp65_, FALSE, FALSE, (guint) 0);
	_tmp66_ = menu;
	gtk_stack_add_named (_data2_->stack, (GtkWidget*) _tmp66_, "prefs");
	_tmp67_ = self->priv->popover;
	g_signal_connect_data (_tmp67_, "closed", (GCallback) ___lambda9__budgie_popover_closed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp68_ = self->widget;
	g_signal_connect_object ((GtkWidget*) _tmp68_, "button-press-event", (GCallback) ___lambda10__gtk_widget_button_press_event, self, 0);
	g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 30, _fuzzy_clock_applet_update_clock_gsource_func, g_object_ref (self), g_object_unref);
	_tmp69_ = self->settings;
	g_signal_connect_object (_tmp69_, "changed", (GCallback) _fuzzy_clock_applet_on_settings_change_g_settings_changed, self, 0);
	_tmp70_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp70_;
	_tmp71_ = g_app_info_monitor_get ();
	monitor = _tmp71_;
	g_signal_connect_object (monitor, "changed", (GCallback) _fuzzy_clock_applet_update_cal_g_app_info_monitor_changed, self, 0);
	_tmp72_ = self->priv->cal_button;
	_tmp73_ = self->priv->calprov;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp72_, _tmp73_ != NULL);
	_tmp74_ = self->priv->cal_button;
	g_signal_connect_object (_tmp74_, "clicked", (GCallback) _fuzzy_clock_applet_on_cal_activate_gtk_button_clicked, self, 0);
	fuzzy_clock_applet_update_cal (self);
	fuzzy_clock_applet_update_clock (self);
	_tmp75_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp75_);
	fuzzy_clock_applet_on_settings_change (self, "clock-format");
	_tmp76_ = self->priv->popover;
	_tmp77_ = gtk_bin_get_child ((GtkBin*) _tmp76_);
	gtk_widget_show_all (_tmp77_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (monitor);
	_g_object_unref0 (sub_button);
	_g_object_unref0 (time_button);
	_g_object_unref0 (menu);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

FuzzyClockApplet*
fuzzy_clock_applet_new (const gchar* uuid)
{
	return fuzzy_clock_applet_construct (TYPE_FUZZY_CLOCK_APPLET, uuid);
}

/**
     * Ensure translations are displayed correctly
     * according to the locale
     */
void
fuzzy_clock_applet_initialiseLocaleLanguageSupport (FuzzyClockApplet* self)
{
	g_return_if_fail (self != NULL);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
}

/**
     * This is called to when the calendar app is updated/changed
     */
static void
fuzzy_clock_applet_update_cal (FuzzyClockApplet* self)
{
	GAppInfo* _tmp0_;
	GtkButton* _tmp1_;
	GAppInfo* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_default_for_type (CALENDAR_MIME, FALSE);
	_g_object_unref0 (self->priv->calprov);
	self->priv->calprov = _tmp0_;
	_tmp1_ = self->priv->cal_button;
	_tmp2_ = self->priv->calprov;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
}

/**
     * This is called to launch Date and Time Settings app
     */
static void
fuzzy_clock_applet_on_date_activate (FuzzyClockApplet* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("gnome-datetime-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("FuzzyClockApplet.vala:560: Unable to launch gnome-datetime-panel.deskt" \
"op: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

/**
     * This is called to launch calendar app when user selects from drop-down
     */
static void
fuzzy_clock_applet_on_cal_activate (FuzzyClockApplet* self)
{
	BudgiePopover* _tmp0_;
	GAppInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->calprov;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		GAppInfo* _tmp2_;
		_tmp2_ = self->priv->calprov;
		g_app_info_launch (_tmp2_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GAppInfo* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = self->priv->calprov;
		_tmp4_ = g_app_info_get_name (_tmp3_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_message ("FuzzyClockApplet.vala:577: Unable to launch %s: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
fuzzy_clock_applet_real_update_popovers (BudgieApplet* base,
                                         BudgiePopoverManager* manager)
{
	FuzzyClockApplet * self;
	GtkEventBox* _tmp0_;
	BudgiePopover* _tmp1_;
	self = (FuzzyClockApplet*) base;
	self->priv->manager = manager;
	_tmp0_ = self->widget;
	_tmp1_ = self->priv->popover;
	budgie_popover_manager_register_popover (manager, (GtkWidget*) _tmp0_, _tmp1_);
}

/**
     * This is called when any of the preferences are changed
     */
void
fuzzy_clock_applet_on_settings_change (FuzzyClockApplet* self,
                                       const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("clock-format")))) {
		switch (0) {
			default:
			{
				GtkCheckButton* _tmp3_;
				ClockFormat f = 0;
				GSettings* _tmp4_;
				GtkCheckButton* _tmp5_;
				GtkCheckButton* _tmp6_;
				_tmp3_ = self->priv->clock_format;
				g_signal_handler_block ((void*) _tmp3_, self->priv->check_id);
				_tmp4_ = self->settings;
				f = (ClockFormat) g_settings_get_enum (_tmp4_, key);
				self->ampm = f == CLOCK_FORMAT_TWELVE;
				_tmp5_ = self->priv->clock_format;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, f == CLOCK_FORMAT_TWENTYFOUR);
				fuzzy_clock_applet_update_clock (self);
				_tmp6_ = self->priv->clock_format;
				g_signal_handler_unblock ((void*) _tmp6_, self->priv->check_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("clock-show-date")))) {
		switch (0) {
			default:
			{
				fuzzy_clock_applet_update_clock (self);
				break;
			}
		}
	}
}

/**
     * Update the date if necessary
     */
void
fuzzy_clock_applet_update_date (FuzzyClockApplet* self)
{
	GtkCheckButton* _tmp0_;
	gchar* ftime = NULL;
	gchar* old = NULL;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GDateTime* _tmp10_;
	gchar* ctime = NULL;
	GDateTime* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GtkLabel* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->check_date;
	if (!gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		return;
	}
	if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->date_format;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (ftime);
		ftime = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->date_format;
		_tmp4_ = g_strconcat ("<small>", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "</small>", NULL);
		_g_free0 (ftime);
		ftime = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = self->date_label;
	_tmp8_ = gtk_label_get_label (_tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	old = _tmp9_;
	_tmp10_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (self->priv->time);
	self->priv->time = _tmp10_;
	_tmp11_ = self->priv->time;
	_tmp12_ = ftime;
	_tmp13_ = g_date_time_format (_tmp11_, _tmp12_);
	ctime = _tmp13_;
	_tmp14_ = old;
	_tmp15_ = ctime;
	if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
		_g_free0 (ctime);
		_g_free0 (old);
		_g_free0 (ftime);
		return;
	}
	_tmp16_ = self->date_label;
	_tmp17_ = ctime;
	gtk_label_set_markup (_tmp16_, _tmp17_);
	_g_free0 (ctime);
	_g_free0 (old);
	_g_free0 (ftime);
}

/**
     * This is called once thirty-seconds, updating the displayed time
     */
gboolean
fuzzy_clock_applet_update_clock (FuzzyClockApplet* self)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gint hour = 0;
	GDateTime* _tmp1_;
	gint minute = 0;
	GDateTime* _tmp2_;
	gint rule = 0;
	FuzzyClockRule** _tmp3_;
	gint _tmp3__length1;
	FuzzyClockRule* _tmp4_;
	gchar* ftime = NULL;
	gchar* old = NULL;
	GtkLabel* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* ctime = NULL;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GtkLabel* _tmp23_;
	const gchar* _tmp24_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = now;
	hour = g_date_time_get_hour (_tmp1_);
	_tmp2_ = now;
	minute = g_date_time_get_minute (_tmp2_) + 2;
	rule = ((gint) floor ((gdouble) (minute / 5))) % 12;
	if (minute >= 60) {
		hour += 1;
	}
	_tmp3_ = self->rules;
	_tmp3__length1 = self->rules_length1;
	_tmp4_ = _tmp3_[rule];
	hour += _tmp4_->hour_offset;
	if (hour < 0) {
		hour += 24;
	} else {
		if (hour >= 24) {
			hour -= 24;
		} else {
			gboolean _tmp5_ = FALSE;
			if (self->ampm) {
				_tmp5_ = hour >= 13;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				hour -= 12;
			}
		}
	}
	if (self->priv->orient == GTK_ORIENTATION_HORIZONTAL) {
		FuzzyClockRule** _tmp6_;
		gint _tmp6__length1;
		FuzzyClockRule* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->rules;
		_tmp6__length1 = self->rules_length1;
		_tmp7_ = _tmp6_[rule];
		_tmp8_ = _tmp7_->format;
		_tmp9_ = g_strdup_printf (" %s ", _tmp8_);
		_g_free0 (ftime);
		ftime = _tmp9_;
	} else {
		FuzzyClockRule** _tmp10_;
		gint _tmp10__length1;
		FuzzyClockRule* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = self->rules;
		_tmp10__length1 = self->rules_length1;
		_tmp11_ = _tmp10_[rule];
		_tmp12_ = _tmp11_->format;
		_tmp13_ = g_strdup_printf (" <small>%s</small> ", _tmp12_);
		_g_free0 (ftime);
		ftime = _tmp13_;
	}
	fuzzy_clock_applet_update_date (self);
	_tmp14_ = self->clock;
	_tmp15_ = gtk_label_get_label (_tmp14_);
	_tmp16_ = g_strdup (_tmp15_);
	old = _tmp16_;
	_tmp17_ = ftime;
	_tmp18_ = self->hours;
	_tmp18__length1 = self->hours_length1;
	_tmp19_ = _tmp18_[hour];
	_tmp20_ = g_strdup_printf (_tmp17_, _tmp19_);
	ctime = _tmp20_;
	_tmp21_ = old;
	_tmp22_ = ctime;
	if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
		if (!self->priv->fuzzy_onpanel) {
			result = FALSE;
			_g_free0 (ctime);
			_g_free0 (old);
			_g_free0 (ftime);
			_g_date_time_unref0 (now);
			return result;
		}
		result = TRUE;
		_g_free0 (ctime);
		_g_free0 (old);
		_g_free0 (ftime);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp23_ = self->clock;
	_tmp24_ = ctime;
	gtk_label_set_markup (_tmp23_, _tmp24_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = self->priv->fuzzy_onpanel;
	_g_free0 (ctime);
	_g_free0 (old);
	_g_free0 (ftime);
	_g_date_time_unref0 (now);
	return result;
}

const gchar*
fuzzy_clock_applet_get_uuid (FuzzyClockApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
fuzzy_clock_applet_set_uuid (FuzzyClockApplet* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = fuzzy_clock_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, fuzzy_clock_applet_properties[FUZZY_CLOCK_APPLET_UUID_PROPERTY]);
	}
}

static void
fuzzy_clock_applet_class_init (FuzzyClockAppletClass * klass,
                               gpointer klass_data)
{
	fuzzy_clock_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FuzzyClockApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) fuzzy_clock_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) fuzzy_clock_applet_real_update_popovers;
	G_OBJECT_CLASS (klass)->get_property = _vala_fuzzy_clock_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fuzzy_clock_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = fuzzy_clock_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FUZZY_CLOCK_APPLET_UUID_PROPERTY, fuzzy_clock_applet_properties[FUZZY_CLOCK_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
fuzzy_clock_applet_instance_init (FuzzyClockApplet * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	FuzzyClockRule* _tmp27_;
	FuzzyClockRule* _tmp28_;
	FuzzyClockRule* _tmp29_;
	FuzzyClockRule* _tmp30_;
	FuzzyClockRule* _tmp31_;
	FuzzyClockRule* _tmp32_;
	FuzzyClockRule* _tmp33_;
	FuzzyClockRule* _tmp34_;
	FuzzyClockRule* _tmp35_;
	FuzzyClockRule* _tmp36_;
	FuzzyClockRule* _tmp37_;
	FuzzyClockRule* _tmp38_;
	FuzzyClockRule** _tmp39_;
	self->priv = fuzzy_clock_applet_get_instance_private (self);
	self->priv->fuzzy_onpanel = TRUE;
	_tmp0_ = g_strdup ("com.solus-project.budgie-panel");
	self->priv->general_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->date_format = _tmp1_;
	_tmp2_ = g_strdup (_ ("midnight"));
	_tmp3_ = g_strdup (_ ("one"));
	_tmp4_ = g_strdup (_ ("two"));
	_tmp5_ = g_strdup (_ ("three"));
	_tmp6_ = g_strdup (_ ("four"));
	_tmp7_ = g_strdup (_ ("five"));
	_tmp8_ = g_strdup (_ ("six"));
	_tmp9_ = g_strdup (_ ("seven"));
	_tmp10_ = g_strdup (_ ("eight"));
	_tmp11_ = g_strdup (_ ("nine"));
	_tmp12_ = g_strdup (_ ("ten"));
	_tmp13_ = g_strdup (_ ("eleven"));
	_tmp14_ = g_strdup (_ ("noon"));
	_tmp15_ = g_strdup (_ ("one"));
	_tmp16_ = g_strdup (_ ("two"));
	_tmp17_ = g_strdup (_ ("three"));
	_tmp18_ = g_strdup (_ ("four"));
	_tmp19_ = g_strdup (_ ("five"));
	_tmp20_ = g_strdup (_ ("six"));
	_tmp21_ = g_strdup (_ ("seven"));
	_tmp22_ = g_strdup (_ ("eight"));
	_tmp23_ = g_strdup (_ ("nine"));
	_tmp24_ = g_strdup (_ ("ten"));
	_tmp25_ = g_strdup (_ ("eleven"));
	_tmp26_ = g_new0 (gchar*, 24 + 1);
	_tmp26_[0] = _tmp2_;
	_tmp26_[1] = _tmp3_;
	_tmp26_[2] = _tmp4_;
	_tmp26_[3] = _tmp5_;
	_tmp26_[4] = _tmp6_;
	_tmp26_[5] = _tmp7_;
	_tmp26_[6] = _tmp8_;
	_tmp26_[7] = _tmp9_;
	_tmp26_[8] = _tmp10_;
	_tmp26_[9] = _tmp11_;
	_tmp26_[10] = _tmp12_;
	_tmp26_[11] = _tmp13_;
	_tmp26_[12] = _tmp14_;
	_tmp26_[13] = _tmp15_;
	_tmp26_[14] = _tmp16_;
	_tmp26_[15] = _tmp17_;
	_tmp26_[16] = _tmp18_;
	_tmp26_[17] = _tmp19_;
	_tmp26_[18] = _tmp20_;
	_tmp26_[19] = _tmp21_;
	_tmp26_[20] = _tmp22_;
	_tmp26_[21] = _tmp23_;
	_tmp26_[22] = _tmp24_;
	_tmp26_[23] = _tmp25_;
	self->hours = _tmp26_;
	self->hours_length1 = 24;
	_tmp27_ = fuzzy_clock_rule_new (_ ("%s-ish"), 0);
	_tmp28_ = fuzzy_clock_rule_new (_ ("a bit past %s"), 0);
	_tmp29_ = fuzzy_clock_rule_new (_ ("ten past %s"), 0);
	_tmp30_ = fuzzy_clock_rule_new (_ ("quarter after %s"), 0);
	_tmp31_ = fuzzy_clock_rule_new (_ ("twenty past %s"), 0);
	_tmp32_ = fuzzy_clock_rule_new (_ ("almost half-past %s"), 0);
	_tmp33_ = fuzzy_clock_rule_new (_ ("half-past %s"), 0);
	_tmp34_ = fuzzy_clock_rule_new (_ ("twenty-five 'til %s"), 1);
	_tmp35_ = fuzzy_clock_rule_new (_ ("twenty 'til %s"), 1);
	_tmp36_ = fuzzy_clock_rule_new (_ ("quarter 'til %s"), 1);
	_tmp37_ = fuzzy_clock_rule_new (_ ("ten 'til %s"), 1);
	_tmp38_ = fuzzy_clock_rule_new (_ ("almost %s"), 1);
	_tmp39_ = g_new0 (FuzzyClockRule*, 12 + 1);
	_tmp39_[0] = _tmp27_;
	_tmp39_[1] = _tmp28_;
	_tmp39_[2] = _tmp29_;
	_tmp39_[3] = _tmp30_;
	_tmp39_[4] = _tmp31_;
	_tmp39_[5] = _tmp32_;
	_tmp39_[6] = _tmp33_;
	_tmp39_[7] = _tmp34_;
	_tmp39_[8] = _tmp35_;
	_tmp39_[9] = _tmp36_;
	_tmp39_[10] = _tmp37_;
	_tmp39_[11] = _tmp38_;
	self->rules = _tmp39_;
	self->rules_length1 = 12;
	self->ampm = FALSE;
	self->priv->popover = NULL;
	self->priv->calprov = NULL;
	self->priv->orient = GTK_ORIENTATION_HORIZONTAL;
	self->priv->manager = NULL;
}

static void
fuzzy_clock_applet_finalize (GObject * obj)
{
	FuzzyClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUZZY_CLOCK_APPLET, FuzzyClockApplet);
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->priv->panel_settings);
	_g_object_unref0 (self->priv->currpanelsubject_settings);
	_g_free0 (self->priv->general_path);
	_g_free0 (self->priv->date_format);
	self->hours = (_vala_array_free (self->hours, self->hours_length1, (GDestroyNotify) g_free), NULL);
	self->rules = (_vala_array_free (self->rules, self->rules_length1, (GDestroyNotify) fuzzy_clock_rule_unref), NULL);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->layout);
	_g_object_unref0 (self->clock);
	_g_object_unref0 (self->date_label);
	_g_date_time_unref0 (self->priv->time);
	_g_object_unref0 (self->settings);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->calprov);
	_g_object_unref0 (self->priv->cal_button);
	_g_object_unref0 (self->priv->clock_format);
	_g_object_unref0 (self->priv->check_date);
	G_OBJECT_CLASS (fuzzy_clock_applet_parent_class)->finalize (obj);
}

GType
fuzzy_clock_applet_get_type (void)
{
	return fuzzy_clock_applet_type_id;
}

GType
fuzzy_clock_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FuzzyClockAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fuzzy_clock_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FuzzyClockApplet), 0, (GInstanceInitFunc) fuzzy_clock_applet_instance_init, NULL };
	fuzzy_clock_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "FuzzyClockApplet", &g_define_type_info, 0);
	FuzzyClockApplet_private_offset = sizeof (FuzzyClockAppletPrivate);
	return fuzzy_clock_applet_type_id;
}

static void
_vala_fuzzy_clock_applet_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FuzzyClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FUZZY_CLOCK_APPLET, FuzzyClockApplet);
	switch (property_id) {
		case FUZZY_CLOCK_APPLET_UUID_PROPERTY:
		g_value_set_string (value, fuzzy_clock_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_fuzzy_clock_applet_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FuzzyClockApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FUZZY_CLOCK_APPLET, FuzzyClockApplet);
	switch (property_id) {
		case FUZZY_CLOCK_APPLET_UUID_PROPERTY:
		fuzzy_clock_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	fuzzy_clock_plugin_register_type (module);
	fuzzy_clock_rule_register_type (module);
	fuzzy_clock_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_FUZZY_CLOCK_PLUGIN);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

