/* manager.c generated by valac 0.56.14, the Vala compiler
 * generated from manager.vala, do not modify */

/*
* BudgieExtrasDaemon
* Author: David Mohammed
* Copyright © 2019 Ubuntu Budgie Developers
* Website=https://ubuntubudgie.org
* This program is free software: you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation, either version 3 of the License, or any later version.
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details. You should have received a copy of the GNU General Public
* License along with this program.  If not, see
* <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <keybinder-3.0/keybinder.h>
#include <gobject/gvaluecollector.h>
#include <daemon.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_EXTRAS_TYPE_BDE_FILE (budgie_extras_bde_file_get_type ())
#define BUDGIE_EXTRAS_BDE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_EXTRAS_TYPE_BDE_FILE, BudgieExtrasBDEFile))
#define BUDGIE_EXTRAS_BDE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_EXTRAS_TYPE_BDE_FILE, BudgieExtrasBDEFileClass))
#define BUDGIE_EXTRAS_IS_BDE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_EXTRAS_TYPE_BDE_FILE))
#define BUDGIE_EXTRAS_IS_BDE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_EXTRAS_TYPE_BDE_FILE))
#define BUDGIE_EXTRAS_BDE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_EXTRAS_TYPE_BDE_FILE, BudgieExtrasBDEFileClass))

typedef struct _BudgieExtrasBDEFile BudgieExtrasBDEFile;
typedef struct _BudgieExtrasBDEFileClass BudgieExtrasBDEFileClass;
typedef struct _BudgieExtrasBDEFilePrivate BudgieExtrasBDEFilePrivate;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _BudgieExtrasParamSpecBDEFile BudgieExtrasParamSpecBDEFile;

#define BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER (budgie_extras_keybinder_manager_get_type ())
#define BUDGIE_EXTRAS_KEYBINDER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER, BudgieExtrasKeybinderManager))
#define BUDGIE_EXTRAS_KEYBINDER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER, BudgieExtrasKeybinderManagerClass))
#define BUDGIE_EXTRAS_IS_KEYBINDER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER))
#define BUDGIE_EXTRAS_IS_KEYBINDER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER))
#define BUDGIE_EXTRAS_KEYBINDER_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER, BudgieExtrasKeybinderManagerClass))

typedef struct _BudgieExtrasKeybinderManager BudgieExtrasKeybinderManager;
typedef struct _BudgieExtrasKeybinderManagerClass BudgieExtrasKeybinderManagerClass;
typedef struct _BudgieExtrasKeybinderManagerPrivate BudgieExtrasKeybinderManagerPrivate;

#define BUDGIE_EXTRAS_TYPE_DBUS_MANAGER (budgie_extras_dbus_manager_get_type ())
#define BUDGIE_EXTRAS_DBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_EXTRAS_TYPE_DBUS_MANAGER, BudgieExtrasDbusManager))
#define BUDGIE_EXTRAS_DBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_EXTRAS_TYPE_DBUS_MANAGER, BudgieExtrasDbusManagerClass))
#define BUDGIE_EXTRAS_IS_DBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_EXTRAS_TYPE_DBUS_MANAGER))
#define BUDGIE_EXTRAS_IS_DBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_EXTRAS_TYPE_DBUS_MANAGER))
#define BUDGIE_EXTRAS_DBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_EXTRAS_TYPE_DBUS_MANAGER, BudgieExtrasDbusManagerClass))

typedef struct _BudgieExtrasDbusManager BudgieExtrasDbusManager;
typedef struct _BudgieExtrasDbusManagerClass BudgieExtrasDbusManagerClass;
enum  {
	BUDGIE_EXTRAS_KEYBINDER_MANAGER_0_PROPERTY,
	BUDGIE_EXTRAS_KEYBINDER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_extras_keybinder_manager_properties[BUDGIE_EXTRAS_KEYBINDER_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _budgie_extras_bde_file_unref0(var) ((var == NULL) ? NULL : (var = (budgie_extras_bde_file_unref (var), NULL)))

struct _BudgieExtrasBDEFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieExtrasBDEFilePrivate * priv;
};

struct _BudgieExtrasBDEFileClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieExtrasBDEFile *self);
};

struct _BudgieExtrasBDEFilePrivate {
	gboolean valid_file;
	GKeyFile* keyfile;
	gchar* key_shortcut;
	gchar* settings_path;
	gchar* settings_key;
	gchar* command_action;
	gchar* activate_path;
	gchar* activate_key;
	gchar* overlay_path;
	gchar* overlay_key;
	gchar* name;
};

struct _BudgieExtrasParamSpecBDEFile {
	GParamSpec parent_instance;
};

struct _BudgieExtrasKeybinderManager {
	GObject parent_instance;
	BudgieExtrasKeybinderManagerPrivate * priv;
};

struct _BudgieExtrasKeybinderManagerClass {
	GObjectClass parent_class;
};

struct _BudgieExtrasKeybinderManagerPrivate {
	GHashTable* shortcuts;
	BudgieExtrasDbusManager* dbus;
};

static gint BudgieExtrasBDEFile_private_offset;
static gpointer budgie_extras_bde_file_parent_class = NULL;
static gint BudgieExtrasKeybinderManager_private_offset;
static gpointer budgie_extras_keybinder_manager_parent_class = NULL;

VALA_EXTERN gpointer budgie_extras_bde_file_ref (gpointer instance);
VALA_EXTERN void budgie_extras_bde_file_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_extras_param_spec_bde_file (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void budgie_extras_value_set_bde_file (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void budgie_extras_value_take_bde_file (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer budgie_extras_value_get_bde_file (const GValue* value);
VALA_EXTERN GType budgie_extras_bde_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieExtrasBDEFile, budgie_extras_bde_file_unref)
static gboolean budgie_extras_bde_file_parse_gsettings (BudgieExtrasBDEFile* self,
                                                 const gchar* group,
                                                 const gchar* name,
                                                 gchar** key_path,
                                                 gchar** key_name);
VALA_EXTERN BudgieExtrasBDEFile* budgie_extras_bde_file_new (const gchar* location);
VALA_EXTERN BudgieExtrasBDEFile* budgie_extras_bde_file_construct (GType object_type,
                                                       const gchar* location);
VALA_EXTERN gboolean budgie_extras_bde_file_is_valid (BudgieExtrasBDEFile* self);
VALA_EXTERN gchar* budgie_extras_bde_file_get_shortcut (BudgieExtrasBDEFile* self);
VALA_EXTERN gchar* budgie_extras_bde_file_get_name (BudgieExtrasBDEFile* self);
VALA_EXTERN void budgie_extras_bde_file_callback (BudgieExtrasBDEFile* self,
                                      const gchar* keystring);
VALA_EXTERN void budgie_extras_bde_file_reset_overlay (BudgieExtrasBDEFile* self);
VALA_EXTERN gboolean budgie_extras_bde_file_connect (BudgieExtrasBDEFile* self);
static void _budgie_extras_bde_file_callback_keybinder_handler (const gchar* keystring,
                                                         gpointer self);
static void budgie_extras_bde_file_finalize (BudgieExtrasBDEFile * obj);
static GType budgie_extras_bde_file_get_type_once (void);
VALA_EXTERN GType budgie_extras_keybinder_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieExtrasKeybinderManager, g_object_unref)
VALA_EXTERN GType budgie_extras_dbus_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieExtrasDbusManager, g_object_unref)
VALA_EXTERN guint budgie_extras_dbus_manager_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN gboolean budgie_extras_keybinder_manager_get_shortcut (BudgieExtrasKeybinderManager* self,
                                                       const gchar* key_name,
                                                       gchar** shortcut);
VALA_EXTERN BudgieExtrasKeybinderManager* budgie_extras_keybinder_manager_new (gboolean replace);
VALA_EXTERN BudgieExtrasKeybinderManager* budgie_extras_keybinder_manager_construct (GType object_type,
                                                                         gboolean replace);
VALA_EXTERN BudgieExtrasDbusManager* budgie_extras_dbus_manager_new (BudgieExtrasKeybinderManager* km);
VALA_EXTERN BudgieExtrasDbusManager* budgie_extras_dbus_manager_construct (GType object_type,
                                                               BudgieExtrasKeybinderManager* km);
VALA_EXTERN void budgie_extras_dbus_manager_setup_dbus (BudgieExtrasDbusManager* self,
                                            gboolean replace);
VALA_EXTERN gboolean budgie_extras_keybinder_manager_reload (BudgieExtrasKeybinderManager* self);
static void _g_free0_ (gpointer var);
static void _budgie_extras_bde_file_unref0_ (gpointer var);
static void budgie_extras_keybinder_manager_finalize (GObject * obj);
static GType budgie_extras_keybinder_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_extras_bde_file_get_instance_private (BudgieExtrasBDEFile* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieExtrasBDEFile_private_offset);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
budgie_extras_bde_file_parse_gsettings (BudgieExtrasBDEFile* self,
                                        const gchar* group,
                                        const gchar* name,
                                        gchar** key_path,
                                        gchar** key_name)
{
	gboolean return_val = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_debug ("manager.vala:37: checking name %s", name);
	return_val = TRUE;
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyfile;
		_tmp0_ = g_key_file_has_key (_tmp1_, group, name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		if (_tmp0_) {
			gchar* toggle = NULL;
			GKeyFile* _tmp3_;
			gchar* _tmp4_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar** split_path = NULL;
			gint split_path_length1;
			gint _split_path_size_;
			const gchar* _tmp10_;
			gboolean _tmp15_ = FALSE;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp3_ = self->priv->keyfile;
			_tmp4_ = g_key_file_get_string (_tmp3_, group, name, &_inner_error0_);
			toggle = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp5_ = FALSE;
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp5_;
			}
			_tmp6_ = toggle;
			_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_strip (_tmp8_);
			_g_free0 (toggle);
			toggle = _tmp9_;
			_g_free0 (_tmp8_);
			split_path = NULL;
			split_path_length1 = 0;
			_split_path_size_ = split_path_length1;
			_tmp10_ = toggle;
			if (string_contains (_tmp10_, "gsettings ")) {
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				_tmp11_ = toggle;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, " ", 0);
				split_path = (_vala_array_free (split_path, split_path_length1, (GDestroyNotify) g_free), NULL);
				split_path = _tmp13_;
				split_path_length1 = _vala_array_length (_tmp12_);
				_split_path_size_ = split_path_length1;
				_tmp14_ = split_path;
				_tmp14__length1 = split_path_length1;
				if (_tmp14__length1 != 3) {
					return_val = FALSE;
				}
			}
			_tmp16_ = split_path;
			_tmp16__length1 = split_path_length1;
			if (_tmp16_ != NULL) {
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp17_ = split_path;
				_tmp17__length1 = split_path_length1;
				_tmp15_ = _tmp17__length1 == 3;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp18_ = split_path;
				_tmp18__length1 = split_path_length1;
				_tmp19_ = _tmp18_[1];
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (*key_path);
				*key_path = _tmp20_;
				_tmp21_ = split_path;
				_tmp21__length1 = split_path_length1;
				_tmp22_ = _tmp21_[2];
				_tmp23_ = g_strdup (_tmp22_);
				_g_free0 (*key_name);
				*key_name = _tmp23_;
			}
			if ((*key_path) == NULL) {
				_tmp26_ = TRUE;
			} else {
				_tmp26_ = (*key_name) == NULL;
			}
			if (_tmp26_) {
				_tmp25_ = TRUE;
			} else {
				_tmp25_ = g_strcmp0 (*key_path, "") == 0;
			}
			if (_tmp25_) {
				_tmp24_ = TRUE;
			} else {
				_tmp24_ = g_strcmp0 (*key_name, "") == 0;
			}
			if (_tmp24_) {
				_g_free0 (*key_name);
				*key_name = NULL;
				_g_free0 (*key_path);
				*key_path = NULL;
				return_val = FALSE;
				g_debug ("manager.vala:69: invalid gsettings value");
			}
			g_debug ("manager.vala:71: found key_name %s, key_path %s", *key_name, *key_path);
			split_path = (_vala_array_free (split_path, split_path_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (toggle);
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_message ("manager.vala:76: key error %s: %s", name, _tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp29_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp29_;
	}
	result = return_val;
	return result;
}

/**
    * location: full path to file with .bde extension
    */
BudgieExtrasBDEFile*
budgie_extras_bde_file_construct (GType object_type,
                                  const gchar* location)
{
	BudgieExtrasBDEFile* self = NULL;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	self = (BudgieExtrasBDEFile*) g_type_create_instance (object_type);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	{
		GKeyFile* _tmp1_;
		gchar* group = NULL;
		gchar* _tmp2_;
		GKeyFile* _tmp3_;
		const gchar* _tmp4_;
		gboolean todo = FALSE;
		gboolean _tmp5_ = FALSE;
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		GKeyFile* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		const gchar* _tmp17_;
		gboolean _tmp18_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GKeyFile* _tmp24_;
		const gchar* _tmp25_;
		gboolean _tmp34_ = FALSE;
		GKeyFile* _tmp35_;
		const gchar* _tmp36_;
		_tmp1_ = self->priv->keyfile;
		g_key_file_load_from_file (_tmp1_, location, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_strdup ("Daemon");
		group = _tmp2_;
		g_debug ("manager.vala:91: before has_group");
		_tmp3_ = self->priv->keyfile;
		_tmp4_ = group;
		if (!g_key_file_has_group (_tmp3_, _tmp4_)) {
			_g_free0 (group);
			return self;
		}
		todo = FALSE;
		g_debug ("manager.vala:95: before shortcut");
		_tmp6_ = self->priv->keyfile;
		_tmp7_ = group;
		_tmp5_ = g_key_file_has_key (_tmp6_, _tmp7_, "shortcut", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (group);
			goto __catch0_g_error;
		}
		if (!_tmp5_) {
			_g_free0 (group);
			return self;
		}
		_tmp9_ = self->priv->keyfile;
		_tmp10_ = group;
		_tmp11_ = g_key_file_get_string (_tmp9_, _tmp10_, "shortcut", &_inner_error0_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (group);
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (self->priv->key_shortcut);
		self->priv->key_shortcut = _tmp12_;
		_tmp13_ = self->priv->key_shortcut;
		g_debug ("manager.vala:99: key shortcut %s", _tmp13_);
		_tmp15_ = self->priv->key_shortcut;
		if (_tmp15_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = self->priv->key_shortcut;
			_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
		}
		if (_tmp14_) {
			_g_free0 (_tmp8_);
			_g_free0 (group);
			return self;
		}
		_tmp17_ = group;
		_tmp18_ = budgie_extras_bde_file_parse_gsettings (self, _tmp17_, "toggle", &self->priv->settings_path, &self->priv->settings_key);
		if (_tmp18_) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			todo = TRUE;
			_tmp19_ = self->priv->settings_path;
			_tmp20_ = self->priv->settings_key;
			g_debug ("manager.vala:105: todo %s %s", _tmp19_, _tmp20_);
		}
		_tmp21_ = group;
		budgie_extras_bde_file_parse_gsettings (self, _tmp21_, "onlyactivate", &self->priv->activate_path, &self->priv->activate_key);
		_tmp22_ = group;
		budgie_extras_bde_file_parse_gsettings (self, _tmp22_, "overlay", &self->priv->overlay_path, &self->priv->overlay_key);
		_tmp24_ = self->priv->keyfile;
		_tmp25_ = group;
		_tmp23_ = g_key_file_has_key (_tmp24_, _tmp25_, "command", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_free0 (group);
			goto __catch0_g_error;
		}
		if (_tmp23_) {
			gchar* _tmp26_ = NULL;
			GKeyFile* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			const gchar* _tmp32_;
			_tmp27_ = self->priv->keyfile;
			_tmp28_ = group;
			_tmp29_ = g_key_file_get_string (_tmp27_, _tmp28_, "command", &_inner_error0_);
			_tmp26_ = _tmp29_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_free0 (group);
				goto __catch0_g_error;
			}
			_tmp30_ = _tmp26_;
			_tmp26_ = NULL;
			_g_free0 (self->priv->command_action);
			self->priv->command_action = _tmp30_;
			_tmp32_ = self->priv->command_action;
			if (_tmp32_ == NULL) {
				_tmp31_ = TRUE;
			} else {
				const gchar* _tmp33_;
				_tmp33_ = self->priv->command_action;
				_tmp31_ = g_strcmp0 (_tmp33_, "") == 0;
			}
			if (_tmp31_) {
				_g_free0 (_tmp26_);
				_g_free0 (_tmp8_);
				_g_free0 (group);
				return self;
			}
			todo = TRUE;
			_g_free0 (_tmp26_);
		}
		_tmp35_ = self->priv->keyfile;
		_tmp36_ = group;
		_tmp34_ = g_key_file_has_key (_tmp35_, _tmp36_, "name", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_free0 (group);
			goto __catch0_g_error;
		}
		if (_tmp34_) {
			gchar* _tmp37_ = NULL;
			GKeyFile* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp38_ = self->priv->keyfile;
			_tmp39_ = group;
			_tmp40_ = g_key_file_get_string (_tmp38_, _tmp39_, "name", &_inner_error0_);
			_tmp37_ = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_free0 (group);
				goto __catch0_g_error;
			}
			_tmp41_ = _tmp37_;
			_tmp37_ = NULL;
			_g_free0 (self->priv->name);
			self->priv->name = _tmp41_;
			_g_free0 (_tmp37_);
		}
		if (!todo) {
			_g_free0 (_tmp8_);
			_g_free0 (group);
			return self;
		}
		_g_free0 (_tmp8_);
		_g_free0 (group);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_message ("manager.vala:127: BDE File: %s", _tmp43_);
		_g_error_free0 (e);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	self->priv->valid_file = TRUE;
	return self;
}

BudgieExtrasBDEFile*
budgie_extras_bde_file_new (const gchar* location)
{
	return budgie_extras_bde_file_construct (BUDGIE_EXTRAS_TYPE_BDE_FILE, location);
}

gboolean
budgie_extras_bde_file_is_valid (BudgieExtrasBDEFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->valid_file;
	return result;
}

gchar*
budgie_extras_bde_file_get_shortcut (BudgieExtrasBDEFile* self)
{
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->valid_file) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->key_shortcut;
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("");
	result = _tmp2_;
	return result;
}

gchar*
budgie_extras_bde_file_get_name (BudgieExtrasBDEFile* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

void
budgie_extras_bde_file_callback (BudgieExtrasBDEFile* self,
                                 const gchar* keystring)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keystring != NULL);
	g_debug ("manager.vala:154: callback %s", keystring);
	_tmp1_ = self->priv->command_action;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->command_action;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("manager.vala:157: command_action");
		{
			const gchar* _tmp3_;
			_tmp3_ = self->priv->command_action;
			g_spawn_command_line_async (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			const gchar* _tmp4_;
			g_clear_error (&_inner_error0_);
			_tmp4_ = self->priv->command_action;
			g_message ("manager.vala:164: Failed to spawn %s", _tmp4_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = self->priv->settings_path;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->settings_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GSettings* settings = NULL;
		const gchar* _tmp8_;
		GSettings* _tmp9_;
		gboolean val = FALSE;
		GSettings* _tmp10_;
		const gchar* _tmp11_;
		GSettings* _tmp12_;
		const gchar* _tmp13_;
		g_debug ("manager.vala:171: toggle");
		_tmp8_ = self->priv->settings_path;
		_tmp9_ = g_settings_new (_tmp8_);
		settings = _tmp9_;
		_tmp10_ = settings;
		_tmp11_ = self->priv->settings_key;
		val = g_settings_get_boolean (_tmp10_, _tmp11_);
		_tmp12_ = settings;
		_tmp13_ = self->priv->settings_key;
		g_settings_set_boolean (_tmp12_, _tmp13_, !val);
		_g_object_unref0 (settings);
	}
}

void
budgie_extras_bde_file_reset_overlay (BudgieExtrasBDEFile* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->overlay_path;
	if (_tmp0_ != NULL) {
		GSettings* settings = NULL;
		const gchar* _tmp1_;
		GSettings* _tmp2_;
		gchar** keyval = NULL;
		GSettings* _tmp3_;
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint keyval_length1;
		gint _keyval_size_;
		gboolean _tmp7_ = FALSE;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp1_ = self->priv->overlay_path;
		_tmp2_ = g_settings_new (_tmp1_);
		settings = _tmp2_;
		_tmp3_ = settings;
		_tmp4_ = self->priv->overlay_key;
		_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp3_, _tmp4_);
		keyval = _tmp6_;
		keyval_length1 = _vala_array_length (_tmp5_);
		_keyval_size_ = keyval_length1;
		_tmp8_ = keyval;
		_tmp8__length1 = keyval_length1;
		if (_tmp8__length1 == 1) {
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			_tmp9_ = keyval;
			_tmp9__length1 = keyval_length1;
			_tmp10_ = _tmp9_[0];
			_tmp7_ = g_strcmp0 (_tmp10_, "") == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GSettings* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = settings;
			_tmp12_ = self->priv->overlay_key;
			g_settings_reset (_tmp11_, _tmp12_);
		}
		keyval = (_vala_array_free (keyval, keyval_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
	}
}

static void
_budgie_extras_bde_file_callback_keybinder_handler (const gchar* keystring,
                                                    gpointer self)
{
	budgie_extras_bde_file_callback ((BudgieExtrasBDEFile*) self, keystring);
}

gboolean
budgie_extras_bde_file_connect (BudgieExtrasBDEFile* self)
{
	const gchar* _tmp0_;
	gboolean bind_key = FALSE;
	gboolean return_val = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("manager.vala:194: 1");
	if (!self->priv->valid_file) {
		result = FALSE;
		return result;
	}
	g_debug ("manager.vala:196: 2");
	_tmp0_ = self->priv->key_shortcut;
	g_debug ("manager.vala:197: bind %s", _tmp0_);
	bind_key = FALSE;
	return_val = FALSE;
	_tmp1_ = self->priv->key_shortcut;
	keybinder_unbind_all (_tmp1_);
	_tmp2_ = self->priv->activate_path;
	if (_tmp2_ != NULL) {
		GSettings* settings = NULL;
		const gchar* _tmp3_;
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp3_ = self->priv->activate_path;
		_tmp4_ = g_settings_new (_tmp3_);
		settings = _tmp4_;
		_tmp5_ = settings;
		_tmp6_ = self->priv->activate_key;
		bind_key = g_settings_get_boolean (_tmp5_, _tmp6_);
		_tmp8_ = self->priv->overlay_path;
		if (_tmp8_ != NULL) {
			_tmp7_ = !bind_key;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			budgie_extras_bde_file_reset_overlay (self);
		}
		_tmp10_ = self->priv->overlay_path;
		if (_tmp10_ != NULL) {
			_tmp9_ = bind_key;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp11_;
			GSettings* _tmp12_;
			GVariant* val = NULL;
			GSettings* _tmp13_;
			const gchar* _tmp14_;
			GVariant* _tmp15_;
			GVariant* _tmp16_;
			const gchar* _tmp17_;
			_tmp11_ = self->priv->overlay_path;
			_tmp12_ = g_settings_new (_tmp11_);
			_g_object_unref0 (settings);
			settings = _tmp12_;
			_tmp13_ = settings;
			_tmp14_ = self->priv->overlay_key;
			_tmp15_ = g_settings_get_value (_tmp13_, _tmp14_);
			val = _tmp15_;
			_tmp16_ = val;
			_tmp17_ = g_variant_get_type_string (_tmp16_);
			if (g_strcmp0 (_tmp17_, "as") == 0) {
				GSettings* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				_tmp18_ = settings;
				_tmp19_ = self->priv->overlay_key;
				_tmp20_ = g_strdup ("");
				_tmp21_ = g_new0 (gchar*, 1 + 1);
				_tmp21_[0] = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp22__length1 = 1;
				g_settings_set_strv (_tmp18_, _tmp19_, _tmp22_);
				_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
			} else {
				GSettings* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = settings;
				_tmp24_ = self->priv->overlay_key;
				g_settings_set_string (_tmp23_, _tmp24_, "");
			}
			_g_variant_unref0 (val);
		}
		_g_object_unref0 (settings);
	} else {
		bind_key = TRUE;
	}
	if (bind_key) {
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->key_shortcut;
		g_debug ("manager.vala:232: 3 %s", _tmp25_);
		_tmp26_ = self->priv->key_shortcut;
		return_val = keybinder_bind_full (_tmp26_, _budgie_extras_bde_file_callback_keybinder_handler, budgie_extras_bde_file_ref (self), budgie_extras_bde_file_unref);
	}
	result = return_val;
	return result;
}

static void
budgie_extras_value_bde_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_extras_value_bde_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_extras_bde_file_unref (value->data[0].v_pointer);
	}
}

static void
budgie_extras_value_bde_file_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_extras_bde_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_extras_value_bde_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_extras_value_bde_file_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieExtrasBDEFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_extras_bde_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_extras_value_bde_file_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	BudgieExtrasBDEFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_extras_bde_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_extras_param_spec_bde_file (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	BudgieExtrasParamSpecBDEFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_EXTRAS_TYPE_BDE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_extras_value_get_bde_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_EXTRAS_TYPE_BDE_FILE), NULL);
	return value->data[0].v_pointer;
}

void
budgie_extras_value_set_bde_file (GValue* value,
                                  gpointer v_object)
{
	BudgieExtrasBDEFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_EXTRAS_TYPE_BDE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_EXTRAS_TYPE_BDE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_extras_bde_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_extras_bde_file_unref (old);
	}
}

void
budgie_extras_value_take_bde_file (GValue* value,
                                   gpointer v_object)
{
	BudgieExtrasBDEFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_EXTRAS_TYPE_BDE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_EXTRAS_TYPE_BDE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_extras_bde_file_unref (old);
	}
}

static void
budgie_extras_bde_file_class_init (BudgieExtrasBDEFileClass * klass,
                                   gpointer klass_data)
{
	budgie_extras_bde_file_parent_class = g_type_class_peek_parent (klass);
	((BudgieExtrasBDEFileClass *) klass)->finalize = budgie_extras_bde_file_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieExtrasBDEFile_private_offset);
}

static void
budgie_extras_bde_file_instance_init (BudgieExtrasBDEFile * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = budgie_extras_bde_file_get_instance_private (self);
	self->priv->valid_file = FALSE;
	self->priv->keyfile = NULL;
	self->priv->key_shortcut = NULL;
	self->priv->settings_path = NULL;
	self->priv->settings_key = NULL;
	self->priv->command_action = NULL;
	self->priv->activate_path = NULL;
	self->priv->activate_key = NULL;
	self->priv->overlay_path = NULL;
	self->priv->overlay_key = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->name = _tmp0_;
	self->ref_count = 1;
}

static void
budgie_extras_bde_file_finalize (BudgieExtrasBDEFile * obj)
{
	BudgieExtrasBDEFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_EXTRAS_TYPE_BDE_FILE, BudgieExtrasBDEFile);
	g_signal_handlers_destroy (self);
	_g_key_file_unref0 (self->priv->keyfile);
	_g_free0 (self->priv->key_shortcut);
	_g_free0 (self->priv->settings_path);
	_g_free0 (self->priv->settings_key);
	_g_free0 (self->priv->command_action);
	_g_free0 (self->priv->activate_path);
	_g_free0 (self->priv->activate_key);
	_g_free0 (self->priv->overlay_path);
	_g_free0 (self->priv->overlay_key);
	_g_free0 (self->priv->name);
}

static GType
budgie_extras_bde_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_extras_value_bde_file_init, budgie_extras_value_bde_file_free_value, budgie_extras_value_bde_file_copy_value, budgie_extras_value_bde_file_peek_pointer, "p", budgie_extras_value_bde_file_collect_value, "p", budgie_extras_value_bde_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieExtrasBDEFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_extras_bde_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieExtrasBDEFile), 0, (GInstanceInitFunc) budgie_extras_bde_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_extras_bde_file_type_id;
	budgie_extras_bde_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieExtrasBDEFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgieExtrasBDEFile_private_offset = g_type_add_instance_private (budgie_extras_bde_file_type_id, sizeof (BudgieExtrasBDEFilePrivate));
	return budgie_extras_bde_file_type_id;
}

GType
budgie_extras_bde_file_get_type (void)
{
	static volatile gsize budgie_extras_bde_file_type_id__once = 0;
	if (g_once_init_enter (&budgie_extras_bde_file_type_id__once)) {
		GType budgie_extras_bde_file_type_id;
		budgie_extras_bde_file_type_id = budgie_extras_bde_file_get_type_once ();
		g_once_init_leave (&budgie_extras_bde_file_type_id__once, budgie_extras_bde_file_type_id);
	}
	return budgie_extras_bde_file_type_id__once;
}

gpointer
budgie_extras_bde_file_ref (gpointer instance)
{
	BudgieExtrasBDEFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_extras_bde_file_unref (gpointer instance)
{
	BudgieExtrasBDEFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_EXTRAS_BDE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
budgie_extras_keybinder_manager_get_instance_private (BudgieExtrasKeybinderManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieExtrasKeybinderManager_private_offset);
}

/**
     * Get the shortcut string for a bde file with the key_name
     */
static gpointer
_budgie_extras_bde_file_ref0 (gpointer self)
{
	return self ? budgie_extras_bde_file_ref (self) : NULL;
}

gboolean
budgie_extras_keybinder_manager_get_shortcut (BudgieExtrasKeybinderManager* self,
                                              const gchar* key_name,
                                              gchar** shortcut)
{
	gchar* _vala_shortcut = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	BudgieExtrasBDEFile* bdefile = NULL;
	gchar* compare = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_name != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_shortcut);
	_vala_shortcut = _tmp0_;
	if (key_name == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key_name, "") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		if (shortcut) {
			*shortcut = _vala_shortcut;
		} else {
			_g_free0 (_vala_shortcut);
		}
		return result;
	}
	_tmp2_ = self->priv->shortcuts;
	g_hash_table_iter_init (&iter, _tmp2_);
	_tmp3_ = g_utf8_strdown (key_name, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	compare = _tmp6_;
	while (TRUE) {
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_;
		gchar* _tmp10_;
		BudgieExtrasBDEFile* _tmp11_;
		gchar* found = NULL;
		BudgieExtrasBDEFile* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp9_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
		_g_free0 (_vala_shortcut);
		_tmp10_ = g_strdup ((const gchar*) _tmp7_);
		_vala_shortcut = _tmp10_;
		_budgie_extras_bde_file_unref0 (bdefile);
		_tmp11_ = _budgie_extras_bde_file_ref0 ((BudgieExtrasBDEFile*) _tmp8_);
		bdefile = _tmp11_;
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = bdefile;
		_tmp13_ = budgie_extras_bde_file_get_name (_tmp12_);
		found = _tmp13_;
		_tmp15_ = found;
		if (g_strcmp0 (_tmp15_, "") != 0) {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = found;
			_tmp17_ = compare;
			_tmp14_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			BudgieExtrasBDEFile* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = bdefile;
			_tmp19_ = budgie_extras_bde_file_get_shortcut (_tmp18_);
			_g_free0 (_vala_shortcut);
			_vala_shortcut = _tmp19_;
			result = TRUE;
			_g_free0 (found);
			_g_free0 (compare);
			_budgie_extras_bde_file_unref0 (bdefile);
			if (shortcut) {
				*shortcut = _vala_shortcut;
			} else {
				_g_free0 (_vala_shortcut);
			}
			return result;
		}
		_g_free0 (found);
	}
	result = FALSE;
	_g_free0 (compare);
	_budgie_extras_bde_file_unref0 (bdefile);
	if (shortcut) {
		*shortcut = _vala_shortcut;
	} else {
		_g_free0 (_vala_shortcut);
	}
	return result;
}

/**
     * Construct a new KeybinderManager and initialiase appropriately
     */
BudgieExtrasKeybinderManager*
budgie_extras_keybinder_manager_construct (GType object_type,
                                           gboolean replace)
{
	BudgieExtrasKeybinderManager * self = NULL;
	BudgieExtrasDbusManager* _tmp0_;
	BudgieExtrasDbusManager* _tmp1_;
	const gchar* _tmp2_;
	self = (BudgieExtrasKeybinderManager*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_extras_dbus_manager_new (self);
	_g_object_unref0 (self->priv->dbus);
	self->priv->dbus = _tmp0_;
	_tmp1_ = self->priv->dbus;
	budgie_extras_dbus_manager_setup_dbus (_tmp1_, replace);
	keybinder_init ();
	keybinder_set_use_cooked_accelerators (FALSE);
	g_debug ("manager.vala:285: syspath %s", BUDGIE_EXTRAS_SYSCONFDIR);
	g_debug ("manager.vala:286: datapath %s", BUDGIE_EXTRAS_DATADIR);
	_tmp2_ = g_get_user_data_dir ();
	g_debug ("manager.vala:287: userpath %s/%s", _tmp2_, BUDGIE_EXTRAS_DAEMONNAME);
	budgie_extras_keybinder_manager_reload (self);
	return self;
}

BudgieExtrasKeybinderManager*
budgie_extras_keybinder_manager_new (gboolean replace)
{
	return budgie_extras_keybinder_manager_construct (BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER, replace);
}

/**
     * Reload keyboard shortcuts
     */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_budgie_extras_bde_file_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (budgie_extras_bde_file_unref (var), NULL));
}

gboolean
budgie_extras_keybinder_manager_reload (BudgieExtrasKeybinderManager* self)
{
	gchar* datapath = NULL;
	gchar* _tmp0_;
	gchar* syspath = NULL;
	gchar* _tmp1_;
	gchar* localpath = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* paths[3] = {0};
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_[3] = {0};
	gchar* shortcut = NULL;
	BudgieExtrasBDEFile* bdefile = NULL;
	GHashTable* _tmp14_;
	GHashTable* _tmp18_;
	GHashTableIter iter = {0};
	GHashTable* _tmp70_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup (BUDGIE_EXTRAS_DATADIR);
	datapath = _tmp0_;
	_tmp1_ = g_strdup (BUDGIE_EXTRAS_SYSCONFDIR);
	syspath = _tmp1_;
	_tmp2_ = g_get_user_data_dir ();
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, BUDGIE_EXTRAS_DAEMONNAME, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	localpath = _tmp6_;
	_tmp7_ = datapath;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = syspath;
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = localpath;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_[0] = _tmp8_;
	_tmp13_[1] = _tmp10_;
	_tmp13_[2] = _tmp12_;
	memcpy (paths, _tmp13_, 3 * sizeof (gchar*));
	_tmp14_ = self->priv->shortcuts;
	if (_tmp14_ == NULL) {
		GHashFunc _tmp15_;
		GEqualFunc _tmp16_;
		GHashTable* _tmp17_;
		_tmp15_ = g_str_hash;
		_tmp16_ = g_str_equal;
		_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _budgie_extras_bde_file_unref0_);
		_g_hash_table_unref0 (self->priv->shortcuts);
		self->priv->shortcuts = _tmp17_;
	}
	_tmp18_ = self->priv->shortcuts;
	if (g_hash_table_size (_tmp18_) != ((guint) 0)) {
		GHashTableIter iter = {0};
		GHashTable* _tmp19_;
		GHashTable* _tmp27_;
		_tmp19_ = self->priv->shortcuts;
		g_hash_table_iter_init (&iter, _tmp19_);
		while (TRUE) {
			gconstpointer _tmp20_ = NULL;
			gconstpointer _tmp21_ = NULL;
			gboolean _tmp22_;
			gchar* _tmp23_;
			BudgieExtrasBDEFile* _tmp24_;
			BudgieExtrasBDEFile* _tmp25_;
			const gchar* _tmp26_;
			_tmp22_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp20_), (gpointer*) (&_tmp21_));
			_g_free0 (shortcut);
			_tmp23_ = g_strdup ((const gchar*) _tmp20_);
			shortcut = _tmp23_;
			_budgie_extras_bde_file_unref0 (bdefile);
			_tmp24_ = _budgie_extras_bde_file_ref0 ((BudgieExtrasBDEFile*) _tmp21_);
			bdefile = _tmp24_;
			if (!_tmp22_) {
				break;
			}
			_tmp25_ = bdefile;
			budgie_extras_bde_file_reset_overlay (_tmp25_);
			_tmp26_ = shortcut;
			keybinder_unbind_all (_tmp26_);
		}
		_tmp27_ = self->priv->shortcuts;
		g_hash_table_remove_all (_tmp27_);
	}
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = paths;
		path_collection_length1 = 3;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp28_;
			gchar* path = NULL;
			_tmp28_ = g_strdup (path_collection[path_it]);
			path = _tmp28_;
			{
				GFile* file = NULL;
				const gchar* _tmp29_;
				GFile* _tmp30_;
				GFile* _tmp31_;
				GFileEnumerator* enumerator = NULL;
				GFileInfo* info = NULL;
				_tmp29_ = path;
				_tmp30_ = g_file_new_for_path (_tmp29_);
				file = _tmp30_;
				_tmp31_ = file;
				if (!g_file_query_exists (_tmp31_, NULL)) {
					_g_object_unref0 (file);
					_g_free0 (path);
					continue;
				}
				enumerator = NULL;
				{
					GFileEnumerator* _tmp32_ = NULL;
					GFile* _tmp33_;
					GFileEnumerator* _tmp34_;
					GFileEnumerator* _tmp35_;
					_tmp33_ = file;
					_tmp34_ = g_file_enumerate_children (_tmp33_, "standard::*.bde", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
					_tmp32_ = _tmp34_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp35_ = _tmp32_;
					_tmp32_ = NULL;
					_g_object_unref0 (enumerator);
					enumerator = _tmp35_;
					_g_object_unref0 (_tmp32_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp36_;
					const gchar* _tmp37_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp36_ = e;
					_tmp37_ = _tmp36_->message;
					g_message ("manager.vala:332: Cannot enumerate %s", _tmp37_);
					_g_error_free0 (e);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (file);
					_g_free0 (path);
					continue;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp38_ = FALSE;
					_g_object_unref0 (enumerator);
					_g_object_unref0 (file);
					_g_free0 (path);
					_budgie_extras_bde_file_unref0 (bdefile);
					_g_free0 (shortcut);
					_vala_array_destroy (paths, 3, (GDestroyNotify) g_free);
					_g_free0 (localpath);
					_g_free0 (syspath);
					_g_free0 (datapath);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp38_;
				}
				info = NULL;
				{
					while (TRUE) {
						gboolean _tmp39_ = FALSE;
						GFileEnumerator* _tmp40_;
						GFileInfo* _tmp46_;
						_tmp40_ = enumerator;
						if (_tmp40_ != NULL) {
							GFileInfo* _tmp41_ = NULL;
							GFileEnumerator* _tmp42_;
							GFileInfo* _tmp43_;
							GFileInfo* _tmp44_;
							GFileInfo* _tmp45_;
							_tmp42_ = enumerator;
							_tmp43_ = g_file_enumerator_next_file (_tmp42_, NULL, &_inner_error0_);
							_tmp41_ = _tmp43_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch1_g_error;
							}
							_tmp44_ = _tmp41_;
							_tmp41_ = NULL;
							_g_object_unref0 (info);
							info = _tmp44_;
							_tmp45_ = info;
							_tmp39_ = _tmp45_ != NULL;
							_g_object_unref0 (_tmp41_);
						} else {
							_tmp39_ = FALSE;
						}
						if (!_tmp39_) {
							break;
						}
						_tmp46_ = info;
						if (g_file_info_get_file_type (_tmp46_) == G_FILE_TYPE_REGULAR) {
							GFileInfo* _tmp47_;
							const gchar* _tmp48_;
							BudgieExtrasBDEFile* bfile = NULL;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							GFileInfo* _tmp52_;
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							BudgieExtrasBDEFile* _tmp56_;
							BudgieExtrasBDEFile* _tmp57_;
							BudgieExtrasBDEFile* _tmp58_;
							_tmp47_ = info;
							_tmp48_ = g_file_info_get_name (_tmp47_);
							g_debug ("manager.vala:341: %s\n", _tmp48_);
							_tmp49_ = path;
							_tmp50_ = g_strconcat (_tmp49_, "/", NULL);
							_tmp51_ = _tmp50_;
							_tmp52_ = info;
							_tmp53_ = g_file_info_get_name (_tmp52_);
							_tmp54_ = g_strconcat (_tmp51_, _tmp53_, NULL);
							_tmp55_ = _tmp54_;
							_tmp56_ = budgie_extras_bde_file_new (_tmp55_);
							_tmp57_ = _tmp56_;
							_g_free0 (_tmp55_);
							_g_free0 (_tmp51_);
							bfile = _tmp57_;
							_tmp58_ = bfile;
							if (budgie_extras_bde_file_is_valid (_tmp58_)) {
								BudgieExtrasBDEFile* _tmp59_;
								gchar* _tmp60_;
								gchar* _tmp61_;
								GHashTable* _tmp62_;
								BudgieExtrasBDEFile* _tmp63_;
								gchar* _tmp64_;
								BudgieExtrasBDEFile* _tmp65_;
								BudgieExtrasBDEFile* _tmp66_;
								_tmp59_ = bfile;
								_tmp60_ = budgie_extras_bde_file_get_shortcut (_tmp59_);
								_tmp61_ = _tmp60_;
								g_debug ("manager.vala:347: valid %s", _tmp61_);
								_g_free0 (_tmp61_);
								_tmp62_ = self->priv->shortcuts;
								_tmp63_ = bfile;
								_tmp64_ = budgie_extras_bde_file_get_shortcut (_tmp63_);
								_tmp65_ = bfile;
								_tmp66_ = _budgie_extras_bde_file_ref0 (_tmp65_);
								g_hash_table_insert (_tmp62_, _tmp64_, _tmp66_);
							}
							_budgie_extras_bde_file_unref0 (bfile);
						}
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp67_;
					const gchar* _tmp68_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp67_ = e;
					_tmp68_ = _tmp67_->message;
					g_message ("manager.vala:354: enumerator next file %s", _tmp68_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp69_ = FALSE;
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (file);
					_g_free0 (path);
					_budgie_extras_bde_file_unref0 (bdefile);
					_g_free0 (shortcut);
					_vala_array_destroy (paths, 3, (GDestroyNotify) g_free);
					_g_free0 (localpath);
					_g_free0 (syspath);
					_g_free0 (datapath);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp69_;
				}
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (file);
				_g_free0 (path);
			}
		}
	}
	_tmp70_ = self->priv->shortcuts;
	g_hash_table_iter_init (&iter, _tmp70_);
	while (TRUE) {
		gconstpointer _tmp71_ = NULL;
		gconstpointer _tmp72_ = NULL;
		gboolean _tmp73_;
		gchar* _tmp74_;
		BudgieExtrasBDEFile* _tmp75_;
		BudgieExtrasBDEFile* _tmp76_;
		_tmp73_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp71_), (gpointer*) (&_tmp72_));
		_g_free0 (shortcut);
		_tmp74_ = g_strdup ((const gchar*) _tmp71_);
		shortcut = _tmp74_;
		_budgie_extras_bde_file_unref0 (bdefile);
		_tmp75_ = _budgie_extras_bde_file_ref0 ((BudgieExtrasBDEFile*) _tmp72_);
		bdefile = _tmp75_;
		if (!_tmp73_) {
			break;
		}
		_tmp76_ = bdefile;
		budgie_extras_bde_file_connect (_tmp76_);
	}
	result = TRUE;
	_budgie_extras_bde_file_unref0 (bdefile);
	_g_free0 (shortcut);
	_vala_array_destroy (paths, 3, (GDestroyNotify) g_free);
	_g_free0 (localpath);
	_g_free0 (syspath);
	_g_free0 (datapath);
	return result;
}

static void
budgie_extras_keybinder_manager_class_init (BudgieExtrasKeybinderManagerClass * klass,
                                            gpointer klass_data)
{
	budgie_extras_keybinder_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieExtrasKeybinderManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_extras_keybinder_manager_finalize;
}

static void
budgie_extras_keybinder_manager_instance_init (BudgieExtrasKeybinderManager * self,
                                               gpointer klass)
{
	self->priv = budgie_extras_keybinder_manager_get_instance_private (self);
	self->priv->shortcuts = NULL;
}

static void
budgie_extras_keybinder_manager_finalize (GObject * obj)
{
	BudgieExtrasKeybinderManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_EXTRAS_TYPE_KEYBINDER_MANAGER, BudgieExtrasKeybinderManager);
	_g_hash_table_unref0 (self->priv->shortcuts);
	_g_object_unref0 (self->priv->dbus);
	G_OBJECT_CLASS (budgie_extras_keybinder_manager_parent_class)->finalize (obj);
}

/**
 * Main lifecycle management, handle all the various session and GTK+ bits
 */
static GType
budgie_extras_keybinder_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieExtrasKeybinderManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_extras_keybinder_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieExtrasKeybinderManager), 0, (GInstanceInitFunc) budgie_extras_keybinder_manager_instance_init, NULL };
	GType budgie_extras_keybinder_manager_type_id;
	budgie_extras_keybinder_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieExtrasKeybinderManager", &g_define_type_info, 0);
	BudgieExtrasKeybinderManager_private_offset = g_type_add_instance_private (budgie_extras_keybinder_manager_type_id, sizeof (BudgieExtrasKeybinderManagerPrivate));
	return budgie_extras_keybinder_manager_type_id;
}

GType
budgie_extras_keybinder_manager_get_type (void)
{
	static volatile gsize budgie_extras_keybinder_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_extras_keybinder_manager_type_id__once)) {
		GType budgie_extras_keybinder_manager_type_id;
		budgie_extras_keybinder_manager_type_id = budgie_extras_keybinder_manager_get_type_once ();
		g_once_init_leave (&budgie_extras_keybinder_manager_type_id__once, budgie_extras_keybinder_manager_type_id);
	}
	return budgie_extras_keybinder_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

