/* layouts.c generated by valac 0.56.14, the Vala compiler
 * generated from layouts.vala, do not modify */

/*
* Layouts
* Author: David Mohammed
* Copyright © 2020 Ubuntu Budgie Developers
* Website=https://ubuntubudgie.org
* This program is free software: you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the Free
* Software Foundation, either version 3 of the License, or any later version.
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details. You should have received a copy of the GNU General Public
* License along with this program.  If not, see
* <https://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define LAYOUTS_plank_schema "net.launchpad.plank"
#define LAYOUTS_plank_settings_schema "net.launchpad.plank.dock.settings"
#define LAYOUTS_plank_path "/net/launchpad/plank/docks/xyz/"
#define LAYOUTS_panel_schema "com.solus-project.budgie-panel"
#define LAYOUTS_plank_global_path "/usr/share/applications/plank.desktop"
#define LAYOUTS_appmenu_budgie_schema "org.ubuntubudgie.plugins.budgie-appmenu"
#define LAYOUTS_budgiewm_schema "com.solus-project.budgie-wm"
#define LAYOUTS_nemo_window_schema "org.nemo.window-state"
#define LAYOUTS_nemo_preferences_schema "org.nemo.preferences"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LAYOUTS_TYPE_LAYOUTS_MANAGER (layouts_layouts_manager_get_type ())
#define LAYOUTS_LAYOUTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LAYOUTS_TYPE_LAYOUTS_MANAGER, LayoutsLayoutsManager))
#define LAYOUTS_LAYOUTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LAYOUTS_TYPE_LAYOUTS_MANAGER, LayoutsLayoutsManagerClass))
#define LAYOUTS_IS_LAYOUTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LAYOUTS_TYPE_LAYOUTS_MANAGER))
#define LAYOUTS_IS_LAYOUTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LAYOUTS_TYPE_LAYOUTS_MANAGER))
#define LAYOUTS_LAYOUTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LAYOUTS_TYPE_LAYOUTS_MANAGER, LayoutsLayoutsManagerClass))

typedef struct _LayoutsLayoutsManager LayoutsLayoutsManager;
typedef struct _LayoutsLayoutsManagerClass LayoutsLayoutsManagerClass;
typedef struct _LayoutsLayoutsManagerPrivate LayoutsLayoutsManagerPrivate;
enum  {
	LAYOUTS_LAYOUTS_MANAGER_0_PROPERTY,
	LAYOUTS_LAYOUTS_MANAGER_NUM_PROPERTIES
};
static GParamSpec* layouts_layouts_manager_properties[LAYOUTS_LAYOUTS_MANAGER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _LayoutsLayoutsManager {
	GObject parent_instance;
	LayoutsLayoutsManagerPrivate * priv;
};

struct _LayoutsLayoutsManagerClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	LayoutsLayoutsManager* self;
	GSettings* preference_settings;
	gboolean show_menu;
};

static gpointer layouts_layouts_manager_parent_class = NULL;

VALA_EXTERN GType layouts_layouts_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LayoutsLayoutsManager, g_object_unref)
static void layouts_layouts_manager_run_cmd (LayoutsLayoutsManager* self,
                                      const gchar* commandline,
                                      gboolean async);
static void layouts_layouts_manager_stop_plank (LayoutsLayoutsManager* self);
static void layouts_layouts_manager_show_nemo_menu (LayoutsLayoutsManager* self,
                                             gboolean show_menu);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void layouts_layouts_manager_start_plank (LayoutsLayoutsManager* self,
                                          gboolean centered);
static void layouts_layouts_manager_appmenu_powerstrip (LayoutsLayoutsManager* self,
                                                 gboolean enable);
static void layouts_layouts_manager_appmenu_categoryview (LayoutsLayoutsManager* self,
                                                   gboolean show_category);
static void layouts_layouts_manager_leftside_buttons (LayoutsLayoutsManager* self,
                                               gboolean leftside);
static void layouts_layouts_manager_reset_panel (LayoutsLayoutsManager* self);
VALA_EXTERN void layouts_layouts_manager_reset (LayoutsLayoutsManager* self,
                                    const gchar* layout_name);
static gboolean __lambda5_ (LayoutsLayoutsManager* self);
static gboolean ___lambda5__gsource_func (gpointer self);
VALA_EXTERN LayoutsLayoutsManager* layouts_layouts_manager_new (void);
VALA_EXTERN LayoutsLayoutsManager* layouts_layouts_manager_construct (GType object_type);
static GType layouts_layouts_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
layouts_layouts_manager_run_cmd (LayoutsLayoutsManager* self,
                                 const gchar* commandline,
                                 gboolean async)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (commandline != NULL);
	{
		if (async) {
			g_spawn_command_line_async (commandline, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			g_spawn_command_line_sync (commandline, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("layouts.vala:41: Issue when executing %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
layouts_layouts_manager_stop_plank (LayoutsLayoutsManager* self)
{
	gchar* autostart_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	layouts_layouts_manager_run_cmd (self, "killall plank", FALSE);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/.config/autostart/plank.desktop", NULL);
	autostart_file = _tmp1_;
	_tmp2_ = autostart_file;
	if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp3_;
		_tmp3_ = autostart_file;
		g_debug ("layouts.vala:53: does not exist %s", _tmp3_);
		_g_free0 (autostart_file);
		return;
	}
	{
		GFile* file = NULL;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = autostart_file;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		file = _tmp5_;
		_tmp6_ = file;
		g_file_delete (_tmp6_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("layouts.vala:62: Cannot delete: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (autostart_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (autostart_file);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		LayoutsLayoutsManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->preference_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda4_ (Block1Data* _data1_)
{
	LayoutsLayoutsManager* self;
	GSettings* window_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = g_settings_new (LAYOUTS_nemo_window_schema);
	window_settings = _tmp0_;
	g_settings_set_boolean (window_settings, "start-with-menu-bar", _data1_->show_menu);
	_tmp1_ = _data1_->preference_settings;
	g_settings_set_boolean (_tmp1_, "disable-menu-warning", FALSE);
	result = FALSE;
	_g_object_unref0 (window_settings);
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ (self);
	return result;
}

static void
layouts_layouts_manager_show_nemo_menu (LayoutsLayoutsManager* self,
                                        gboolean show_menu)
{
	Block1Data* _data1_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->show_menu = show_menu;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, LAYOUTS_nemo_window_schema, TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		_g_settings_schema_unref0 (schema);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = g_settings_new (LAYOUTS_nemo_preferences_schema);
	_data1_->preference_settings = _tmp3_;
	_tmp4_ = _data1_->preference_settings;
	g_settings_set_boolean (_tmp4_, "disable-menu-warning", TRUE);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_g_settings_schema_unref0 (schema);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
layouts_layouts_manager_start_plank (LayoutsLayoutsManager* self,
                                     gboolean centered)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	layouts_layouts_manager_stop_plank (self);
	if (!g_file_test (LAYOUTS_plank_global_path, G_FILE_TEST_EXISTS)) {
		g_debug ("layouts.vala:85: does not exist %s", LAYOUTS_plank_global_path);
		return;
	}
	if (centered) {
		GSettings* plank_settings = NULL;
		GSettings* _tmp0_;
		gchar** docks = NULL;
		GSettings* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint docks_length1;
		gint _docks_size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = g_settings_new (LAYOUTS_plank_schema);
		plank_settings = _tmp0_;
		_tmp1_ = plank_settings;
		_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "enabled-docks");
		docks = _tmp3_;
		docks_length1 = _vala_array_length (_tmp2_);
		_docks_size_ = docks_length1;
		_tmp4_ = docks;
		_tmp4__length1 = docks_length1;
		{
			gchar** dock_collection = NULL;
			gint dock_collection_length1 = 0;
			gint _dock_collection_size_ = 0;
			gint dock_it = 0;
			dock_collection = _tmp4_;
			dock_collection_length1 = _tmp4__length1;
			for (dock_it = 0; dock_it < dock_collection_length1; dock_it = dock_it + 1) {
				gchar* _tmp5_;
				gchar* dock = NULL;
				_tmp5_ = g_strdup (dock_collection[dock_it]);
				dock = _tmp5_;
				{
					gchar* path = NULL;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					GSettings* settings = NULL;
					const gchar* _tmp8_;
					GSettings* _tmp9_;
					GSettings* _tmp10_;
					GSettings* _tmp11_;
					GSettings* _tmp12_;
					GSettings* _tmp13_;
					GSettings* _tmp14_;
					GSettings* _tmp15_;
					_tmp6_ = dock;
					_tmp7_ = string_replace (LAYOUTS_plank_path, "xyz", _tmp6_);
					path = _tmp7_;
					_tmp8_ = path;
					_tmp9_ = g_settings_new_with_path (LAYOUTS_plank_settings_schema, _tmp8_);
					settings = _tmp9_;
					_tmp10_ = settings;
					g_settings_set_string (_tmp10_, "position", "bottom");
					_tmp11_ = settings;
					g_settings_set_string (_tmp11_, "theme", "Transparent");
					_tmp12_ = settings;
					g_settings_set_int (_tmp12_, "icon-size", 32);
					_tmp13_ = settings;
					g_settings_set_int (_tmp13_, "hide-delay", 500);
					_tmp14_ = settings;
					g_settings_set_string (_tmp14_, "hide-mode", "window-dodge");
					_tmp15_ = settings;
					g_settings_set_boolean (_tmp15_, "zoom-enabled", TRUE);
					_g_object_unref0 (settings);
					_g_free0 (path);
					_g_free0 (dock);
					break;
				}
			}
		}
		docks = (_vala_array_free (docks, docks_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (plank_settings);
	}
	{
		gchar* autostart_folder = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		GFile* file = NULL;
		GFile* _tmp22_;
		GFile* dest = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		_tmp16_ = g_get_home_dir ();
		_tmp17_ = g_strconcat (_tmp16_, "/.config/autostart/", NULL);
		autostart_folder = _tmp17_;
		_tmp18_ = autostart_folder;
		if (!g_file_test (_tmp18_, G_FILE_TEST_IS_DIR)) {
			GFile* folder = NULL;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			_tmp19_ = autostart_folder;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			folder = _tmp20_;
			_tmp21_ = folder;
			g_file_make_directory (_tmp21_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder);
				_g_free0 (autostart_folder);
				goto __catch0_g_error;
			}
			_g_object_unref0 (folder);
		}
		_tmp22_ = g_file_new_for_path (LAYOUTS_plank_global_path);
		file = _tmp22_;
		_tmp23_ = autostart_folder;
		_tmp24_ = g_strconcat (_tmp23_, "plank.desktop", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_file_new_for_path (_tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		dest = _tmp27_;
		_tmp28_ = file;
		_tmp29_ = dest;
		g_file_copy (_tmp28_, _tmp29_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dest);
			_g_object_unref0 (file);
			_g_free0 (autostart_folder);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dest);
		_g_object_unref0 (file);
		_g_free0 (autostart_folder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("layouts.vala:121: Cannot copy: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	layouts_layouts_manager_run_cmd (self, "nohup plank &>/dev/null", TRUE);
}

static void
layouts_layouts_manager_appmenu_powerstrip (LayoutsLayoutsManager* self,
                                            gboolean enable)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, LAYOUTS_appmenu_budgie_schema, TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		_g_settings_schema_unref0 (schema);
		return;
	}
	_tmp3_ = g_settings_new (LAYOUTS_appmenu_budgie_schema);
	settings = _tmp3_;
	_tmp4_ = settings;
	g_settings_set_boolean (_tmp4_, "enable-powerstrip", enable);
	_g_object_unref0 (settings);
	_g_settings_schema_unref0 (schema);
}

static void
layouts_layouts_manager_appmenu_categoryview (LayoutsLayoutsManager* self,
                                              gboolean show_category)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, LAYOUTS_appmenu_budgie_schema, TRUE);
	schema = _tmp1_;
	_tmp2_ = schema;
	if (_tmp2_ == NULL) {
		_g_settings_schema_unref0 (schema);
		return;
	}
	_tmp3_ = g_settings_new (LAYOUTS_appmenu_budgie_schema);
	settings = _tmp3_;
	_tmp4_ = settings;
	g_settings_set_boolean (_tmp4_, "use-category", show_category);
	_g_object_unref0 (settings);
	_g_settings_schema_unref0 (schema);
}

static void
layouts_layouts_manager_leftside_buttons (LayoutsLayoutsManager* self,
                                          gboolean leftside)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new (LAYOUTS_budgiewm_schema);
	settings = _tmp0_;
	if (leftside) {
		GSettings* _tmp1_;
		_tmp1_ = settings;
		g_settings_set_string (_tmp1_, "button-style", "left");
	} else {
		GSettings* _tmp2_;
		_tmp2_ = settings;
		g_settings_set_string (_tmp2_, "button-style", "traditional");
	}
	_g_object_unref0 (settings);
}

static void
layouts_layouts_manager_reset_panel (LayoutsLayoutsManager* self)
{
	g_return_if_fail (self != NULL);
	layouts_layouts_manager_run_cmd (self, "nohup budgie-panel --reset --replace &>/dev/null", TRUE);
}

static gboolean
__lambda5_ (LayoutsLayoutsManager* self)
{
	gboolean result;
	layouts_layouts_manager_reset_panel (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((LayoutsLayoutsManager*) self);
	return result;
}

void
layouts_layouts_manager_reset (LayoutsLayoutsManager* self,
                               const gchar* layout_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout_name != NULL);
	layouts_layouts_manager_stop_plank (self);
	layouts_layouts_manager_appmenu_powerstrip (self, FALSE);
	layouts_layouts_manager_appmenu_categoryview (self, FALSE);
	layouts_layouts_manager_leftside_buttons (self, FALSE);
	layouts_layouts_manager_show_nemo_menu (self, FALSE);
	_tmp0_ = layout_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("ubuntubudgie")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_start_plank (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("classicubuntubudgie")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_start_plank (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("cupertino")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_start_plank (self, TRUE);
					layouts_layouts_manager_appmenu_powerstrip (self, TRUE);
					layouts_layouts_manager_appmenu_categoryview (self, TRUE);
					layouts_layouts_manager_leftside_buttons (self, TRUE);
					layouts_layouts_manager_show_nemo_menu (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("theone")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_leftside_buttons (self, TRUE);
					layouts_layouts_manager_show_nemo_menu (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("redmond")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_appmenu_powerstrip (self, TRUE);
					layouts_layouts_manager_appmenu_categoryview (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("eleven")))) {
		switch (0) {
			default:
			{
				{
					layouts_layouts_manager_appmenu_powerstrip (self, TRUE);
					break;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("chrome")))) {
		switch (0) {
			default:
			{
				{
					break;
				}
			}
		}
	} else {
		switch (0) {
			default:
			{
				{
					break;
				}
			}
		}
	}
	_tmp3_ = g_settings_new (LAYOUTS_panel_schema);
	settings = _tmp3_;
	g_settings_set_string (settings, "layout", layout_name);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (settings);
}

LayoutsLayoutsManager*
layouts_layouts_manager_construct (GType object_type)
{
	LayoutsLayoutsManager * self = NULL;
	self = (LayoutsLayoutsManager*) g_object_new (object_type, NULL);
	return self;
}

LayoutsLayoutsManager*
layouts_layouts_manager_new (void)
{
	return layouts_layouts_manager_construct (LAYOUTS_TYPE_LAYOUTS_MANAGER);
}

static void
layouts_layouts_manager_class_init (LayoutsLayoutsManagerClass * klass,
                                    gpointer klass_data)
{
	layouts_layouts_manager_parent_class = g_type_class_peek_parent (klass);
}

static void
layouts_layouts_manager_instance_init (LayoutsLayoutsManager * self,
                                       gpointer klass)
{
}

static GType
layouts_layouts_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LayoutsLayoutsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) layouts_layouts_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LayoutsLayoutsManager), 0, (GInstanceInitFunc) layouts_layouts_manager_instance_init, NULL };
	GType layouts_layouts_manager_type_id;
	layouts_layouts_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "LayoutsLayoutsManager", &g_define_type_info, 0);
	return layouts_layouts_manager_type_id;
}

GType
layouts_layouts_manager_get_type (void)
{
	static volatile gsize layouts_layouts_manager_type_id__once = 0;
	if (g_once_init_enter (&layouts_layouts_manager_type_id__once)) {
		GType layouts_layouts_manager_type_id;
		layouts_layouts_manager_type_id = layouts_layouts_manager_get_type_once ();
		g_once_init_leave (&layouts_layouts_manager_type_id__once, layouts_layouts_manager_type_id);
	}
	return layouts_layouts_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

