/* ConfigHelper.c generated by valac 0.56.14, the Vala compiler
 * generated from ConfigHelper.vala, do not modify */

/*
 * BrightnessController 
 * This file is part of budgie-extras
 * 
 * Author: Serdar ŞEN github.com/serdarsen
 * 
 * Copyright © 2018 Ubuntu Budgie Developers
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include "brightnesscontroller.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BrightnessControllerHelpersParamSpecConfigHelper BrightnessControllerHelpersParamSpecConfigHelper;

struct _BrightnessControllerHelpersConfigHelperPrivate {
	gchar* configDirectoryPath;
	gchar* configFilePath;
};

struct _BrightnessControllerHelpersParamSpecConfigHelper {
	GParamSpec parent_instance;
};

static gint BrightnessControllerHelpersConfigHelper_private_offset;
static gpointer brightness_controller_helpers_config_helper_parent_class = NULL;
static GType brightness_controller_helpers_config_helper_type_id = 0;

static void brightness_controller_helpers_config_helper_MakeConfigDirectoryIfNotExist (BrightnessControllerHelpersConfigHelper* self);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void brightness_controller_helpers_config_helper_finalize (BrightnessControllerHelpersConfigHelper * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
brightness_controller_helpers_config_helper_get_instance_private (BrightnessControllerHelpersConfigHelper* self)
{
	return G_STRUCT_MEMBER_P (self, BrightnessControllerHelpersConfigHelper_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

BrightnessControllerHelpersConfigHelper*
brightness_controller_helpers_config_helper_construct (GType object_type,
                                                       const gchar* appDirNameUnderConfig,
                                                       const gchar* fileName)
{
	BrightnessControllerHelpersConfigHelper* self = NULL;
	gchar* userPath = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (appDirNameUnderConfig != NULL, NULL);
	g_return_val_if_fail (fileName != NULL, NULL);
	self = (BrightnessControllerHelpersConfigHelper*) g_type_create_instance (object_type);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	userPath = _tmp1_;
	_tmp2_ = string_to_string (userPath);
	_tmp3_ = string_to_string (appDirNameUnderConfig);
	_tmp4_ = g_strconcat (_tmp2_, "/", _tmp3_, NULL);
	_g_free0 (self->priv->configDirectoryPath);
	self->priv->configDirectoryPath = _tmp4_;
	_tmp5_ = self->priv->configDirectoryPath;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = string_to_string (fileName);
	_tmp8_ = g_strconcat (_tmp6_, "/", _tmp7_, NULL);
	_g_free0 (self->priv->configFilePath);
	self->priv->configFilePath = _tmp8_;
	_g_free0 (userPath);
	return self;
}

BrightnessControllerHelpersConfigHelper*
brightness_controller_helpers_config_helper_new (const gchar* appDirNameUnderConfig,
                                                 const gchar* fileName)
{
	return brightness_controller_helpers_config_helper_construct (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER, appDirNameUnderConfig, fileName);
}

gboolean
brightness_controller_helpers_config_helper_IsFileExist (BrightnessControllerHelpersConfigHelper* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->configFilePath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
    *  Writes given string[] data to the config file line by line. 
    *
    *  eg:  textList:
    *       {"acpi_video0 9 0 false", "intel_backlight 976 172 true"} 
    *
    *       config file content after write:
    *       acpi_video0 9 0 false
    *       intel_backlight 976 172 true
    */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
brightness_controller_helpers_config_helper_Write (BrightnessControllerHelpersConfigHelper* self,
                                                   gchar** textList,
                                                   gint textList_length1)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	brightness_controller_helpers_config_helper_MakeConfigDirectoryIfNotExist (self);
	_tmp0_ = self->priv->configFilePath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		GFileOutputStream* stream = NULL;
		GFile* _tmp2_;
		_tmp2_ = file;
		if (!g_file_query_exists (_tmp2_, NULL)) {
			GFileOutputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileOutputStream* _tmp5_;
			GFileOutputStream* _tmp6_;
			_tmp4_ = file;
			_tmp5_ = g_file_create (_tmp4_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (stream);
			stream = _tmp6_;
			_g_object_unref0 (_tmp3_);
		} else {
			GFileOutputStream* _tmp7_ = NULL;
			GFile* _tmp8_;
			GFileOutputStream* _tmp9_;
			GFileOutputStream* _tmp10_;
			_tmp8_ = file;
			_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (stream);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (stream);
			stream = _tmp10_;
			_g_object_unref0 (_tmp7_);
		}
		{
			gchar** text_collection = NULL;
			gint text_collection_length1 = 0;
			gint _text_collection_size_ = 0;
			gint text_it = 0;
			text_collection = textList;
			text_collection_length1 = textList_length1;
			for (text_it = 0; text_it < text_collection_length1; text_it = text_it + 1) {
				gchar* _tmp11_;
				gchar* text = NULL;
				_tmp11_ = g_strdup (text_collection[text_it]);
				text = _tmp11_;
				{
					GFileOutputStream* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					guint8* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_ = 0;
					guint8* _tmp19_;
					gint _tmp19__length1;
					_tmp12_ = stream;
					_tmp13_ = text;
					_tmp14_ = string_to_string (_tmp13_);
					_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = string_get_data (_tmp16_, &_tmp18_);
					_tmp17__length1 = _tmp18_;
					_tmp19_ = _tmp17_;
					_tmp19__length1 = _tmp17__length1;
					g_output_stream_write ((GOutputStream*) _tmp12_, _tmp19_, (gsize) _tmp19__length1, NULL, &_inner_error0_);
					_g_free0 (_tmp16_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (text);
						_g_object_unref0 (stream);
						goto __catch0_g_error;
					}
					_g_free0 (text);
				}
			}
		}
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_message ("ConfigHelper.vala:69: Failed to write : %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

/**
    *  Reads data from the config file line by line. 
    *  Returns string[] result.
    *
    *  eg:  config file content:
    *       acpi_video0 9 0 false
    *       intel_backlight 976 172 true
    *
    *       Read() result:
    *       {"acpi_video0 9 0 false", "intel_backlight 976 172 true"} 
    */
static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
brightness_controller_helpers_config_helper_Read (BrightnessControllerHelpersConfigHelper* self,
                                                  gint* result_length1)
{
	gchar** data = NULL;
	gchar** _tmp0_;
	gint data_length1;
	gint _data_size_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp1_ = self->priv->configFilePath;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = data;
		_tmp4__length1 = data_length1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		_g_object_unref0 (file);
		return result;
	}
	{
		GFileInputStream* is = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* dis = NULL;
		GFileInputStream* _tmp7_;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		_tmp5_ = file;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		is = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = is;
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
		dis = _tmp8_;
		while (TRUE) {
			gchar* _tmp9_ = NULL;
			GDataInputStream* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = dis;
			_tmp11_ = g_data_input_stream_read_line (_tmp10_, NULL, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (is);
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp9_;
			_tmp9_ = NULL;
			_g_free0 (line);
			line = _tmp12_;
			_tmp13_ = line;
			if (!(_tmp13_ != NULL)) {
				_g_free0 (_tmp9_);
				break;
			}
			_tmp14_ = line;
			_tmp15_ = g_strdup (_tmp14_);
			_vala_array_add5 (&data, &data_length1, &_data_size_, _tmp15_);
			_g_free0 (_tmp9_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (is);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_message ("ConfigHelper.vala:107: Failed to read : %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp18__length1;
	}
	result = _tmp18_;
	_g_object_unref0 (file);
	return result;
}

void
brightness_controller_helpers_config_helper_Delete (BrightnessControllerHelpersConfigHelper* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->configFilePath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_message ("ConfigHelper.vala:119: Failed to delete: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static void
brightness_controller_helpers_config_helper_MakeConfigDirectoryIfNotExist (BrightnessControllerHelpersConfigHelper* self)
{
	GFile* directory = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->configDirectoryPath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	directory = _tmp1_;
	_tmp2_ = directory;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		{
			GFile* _tmp3_;
			_tmp3_ = directory;
			g_file_make_directory (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_message ("ConfigHelper.vala:134: Failed to make dir : %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (directory);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (directory);
}

static void
brightness_controller_helpers_value_config_helper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
brightness_controller_helpers_value_config_helper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		brightness_controller_helpers_config_helper_unref (value->data[0].v_pointer);
	}
}

static void
brightness_controller_helpers_value_config_helper_copy_value (const GValue* src_value,
                                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = brightness_controller_helpers_config_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
brightness_controller_helpers_value_config_helper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
brightness_controller_helpers_value_config_helper_collect_value (GValue* value,
                                                                 guint n_collect_values,
                                                                 GTypeCValue* collect_values,
                                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BrightnessControllerHelpersConfigHelper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = brightness_controller_helpers_config_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
brightness_controller_helpers_value_config_helper_lcopy_value (const GValue* value,
                                                               guint n_collect_values,
                                                               GTypeCValue* collect_values,
                                                               guint collect_flags)
{
	BrightnessControllerHelpersConfigHelper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = brightness_controller_helpers_config_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
brightness_controller_helpers_param_spec_config_helper (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags)
{
	BrightnessControllerHelpersParamSpecConfigHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
brightness_controller_helpers_value_get_config_helper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER), NULL);
	return value->data[0].v_pointer;
}

void
brightness_controller_helpers_value_set_config_helper (GValue* value,
                                                       gpointer v_object)
{
	BrightnessControllerHelpersConfigHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		brightness_controller_helpers_config_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_config_helper_unref (old);
	}
}

void
brightness_controller_helpers_value_take_config_helper (GValue* value,
                                                        gpointer v_object)
{
	BrightnessControllerHelpersConfigHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_config_helper_unref (old);
	}
}

static void
brightness_controller_helpers_config_helper_class_init (BrightnessControllerHelpersConfigHelperClass * klass,
                                                        gpointer klass_data)
{
	brightness_controller_helpers_config_helper_parent_class = g_type_class_peek_parent (klass);
	((BrightnessControllerHelpersConfigHelperClass *) klass)->finalize = brightness_controller_helpers_config_helper_finalize;
	g_type_class_adjust_private_offset (klass, &BrightnessControllerHelpersConfigHelper_private_offset);
}

static void
brightness_controller_helpers_config_helper_instance_init (BrightnessControllerHelpersConfigHelper * self,
                                                           gpointer klass)
{
	self->priv = brightness_controller_helpers_config_helper_get_instance_private (self);
	self->ref_count = 1;
}

static void
brightness_controller_helpers_config_helper_finalize (BrightnessControllerHelpersConfigHelper * obj)
{
	BrightnessControllerHelpersConfigHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_CONFIG_HELPER, BrightnessControllerHelpersConfigHelper);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->configDirectoryPath);
	_g_free0 (self->priv->configFilePath);
}

GType
brightness_controller_helpers_config_helper_get_type (void)
{
	return brightness_controller_helpers_config_helper_type_id;
}

GType
brightness_controller_helpers_config_helper_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { brightness_controller_helpers_value_config_helper_init, brightness_controller_helpers_value_config_helper_free_value, brightness_controller_helpers_value_config_helper_copy_value, brightness_controller_helpers_value_config_helper_peek_pointer, "p", brightness_controller_helpers_value_config_helper_collect_value, "p", brightness_controller_helpers_value_config_helper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BrightnessControllerHelpersConfigHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) brightness_controller_helpers_config_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrightnessControllerHelpersConfigHelper), 0, (GInstanceInitFunc) brightness_controller_helpers_config_helper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	brightness_controller_helpers_config_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BrightnessControllerHelpersConfigHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BrightnessControllerHelpersConfigHelper_private_offset = sizeof (BrightnessControllerHelpersConfigHelperPrivate);
	return brightness_controller_helpers_config_helper_type_id;
}

gpointer
brightness_controller_helpers_config_helper_ref (gpointer instance)
{
	BrightnessControllerHelpersConfigHelper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
brightness_controller_helpers_config_helper_unref (gpointer instance)
{
	BrightnessControllerHelpersConfigHelper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BRIGHTNESS_CONTROLLER_HELPERS_CONFIG_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

