/* link-plugin.c generated by valac 0.56.14, the Vala compiler
 * generated from link-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Magnus Kulke <mkulke@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Magnus Kulke <mkulke@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	SYNAPSE_LINK_PLUGIN_0_PROPERTY,
	SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_LINK_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SynapseLinkPluginSearchData SynapseLinkPluginSearchData;
enum  {
	SYNAPSE_LINK_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_LINK_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseLinkPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseLinkPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseLinkPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	gboolean matched;
	GRegex* _tmp0_;
	SynapseQuery _tmp1_;
	const gchar* _tmp2_;
	SynapseLinkPluginResult* _result_;
	SynapseQuery _tmp3_;
	const gchar* _tmp4_;
	SynapseLinkPluginResult* _tmp5_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp6_;
	SynapseResultSet* _tmp7_;
	SynapseLinkPluginResult* _tmp8_;
	GError* _inner_error0_;
};

struct _SynapseLinkPluginResultPrivate {
	gint _default_relevancy;
	gchar* uri;
	GAppInfo* appinfo;
};

static gint SynapseLinkPlugin_private_offset;
static gpointer synapse_link_plugin_parent_class = NULL;
static gint SynapseLinkPluginResult_private_offset;
static gpointer synapse_link_plugin_result_parent_class = NULL;
static GType synapse_link_plugin_result_type_id = 0;
static SynapseActivatableIface * synapse_link_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_link_plugin_synapse_item_provider_parent_iface = NULL;
static GType synapse_link_plugin_type_id = 0;

static void synapse_link_plugin_real_activate (SynapseActivatable* base);
static void synapse_link_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_link_plugin_register_plugin (void);
static void _synapse_link_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_link_plugin_real_handles_query (SynapseItemProvider* base,
                                                 SynapseQuery* query);
static void synapse_link_plugin_real_search_data_free (gpointer _data);
static void synapse_link_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean synapse_link_plugin_real_search_co (SynapseLinkPluginSearchData* _data_);
static void synapse_link_plugin_result_real_execute (SynapseMatch* base,
                                              SynapseMatch* match);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void synapse_link_plugin_result_finalize (GObject * obj);
static void _vala_synapse_link_plugin_result_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_synapse_link_plugin_result_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GObject * synapse_link_plugin_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void synapse_link_plugin_finalize (GObject * obj);
static void _vala_synapse_link_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_synapse_link_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
synapse_link_plugin_get_instance_private (SynapseLinkPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLinkPlugin_private_offset);
}

static void
synapse_link_plugin_real_activate (SynapseActivatable* base)
{
	SynapseLinkPlugin * self;
	self = (SynapseLinkPlugin*) base;
}

static void
synapse_link_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseLinkPlugin * self;
	self = (SynapseLinkPlugin*) base;
}

static void
_synapse_link_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_link_plugin_register_plugin ();
}

static void
synapse_link_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_LINK_PLUGIN, _ ("Link"), _ ("Open link in default browser"), "web-browser", _synapse_link_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}

static gboolean
synapse_link_plugin_real_handles_query (SynapseItemProvider* base,
                                        SynapseQuery* query)
{
	SynapseLinkPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
	self = (SynapseLinkPlugin*) base;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = *query;
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_TEXT) == SYNAPSE_QUERY_FLAGS_TEXT;
	return result;
}

static void
synapse_link_plugin_real_search_data_free (gpointer _data)
{
	SynapseLinkPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseLinkPluginSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_link_plugin_real_search (SynapseItemProvider* base,
                                 SynapseQuery* query,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SynapseLinkPlugin * self;
	SynapseLinkPluginSearchData* _data_;
	SynapseLinkPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (query != NULL);
	self = (SynapseLinkPlugin*) base;
	_data_ = g_slice_new0 (SynapseLinkPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_link_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *query;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->query);
	_data_->query = _tmp3_;
	synapse_link_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_link_plugin_search_finish (SynapseItemProvider* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	SynapseResultSet* result;
	SynapseLinkPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
synapse_link_plugin_real_search_co (SynapseLinkPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->regex;
	_data_->_tmp1_ = _data_->query;
	_data_->_tmp2_ = _data_->_tmp1_.query_string;
	_data_->matched = g_regex_match (_data_->_tmp0_, _data_->_tmp2_, 0, NULL);
	if (_data_->matched) {
		_data_->_tmp3_ = _data_->query;
		_data_->_tmp4_ = _data_->_tmp3_.query_string;
		_data_->_tmp5_ = synapse_link_plugin_result_new (_data_->_tmp4_);
		_data_->_result_ = _data_->_tmp5_;
		_data_->_tmp6_ = synapse_result_set_new ();
		_data_->results = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->results;
		_data_->_tmp8_ = _data_->_result_;
		synapse_result_set_add (_data_->_tmp7_, (SynapseMatch*) _data_->_tmp8_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
		synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->_result_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->results);
				_g_object_unref0 (_data_->_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->result = _data_->results;
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SynapseLinkPlugin*
synapse_link_plugin_construct (GType object_type)
{
	SynapseLinkPlugin * self = NULL;
	self = (SynapseLinkPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseLinkPlugin*
synapse_link_plugin_new (void)
{
	return synapse_link_plugin_construct (SYNAPSE_TYPE_LINK_PLUGIN);
}

static gboolean
synapse_link_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseLinkPlugin* self;
	self = (SynapseLinkPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_link_plugin_real_set_enabled (SynapseActivatable* base,
                                      gboolean value)
{
	SynapseLinkPlugin* self;
	gboolean old_value;
	self = (SynapseLinkPlugin*) base;
	old_value = synapse_link_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_link_plugin_result_get_instance_private (SynapseLinkPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseLinkPluginResult_private_offset);
}

SynapseLinkPluginResult*
synapse_link_plugin_result_construct (GType object_type,
                                      const gchar* link)
{
	SynapseLinkPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _title = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _icon_name = NULL;
	gchar* _tmp3_;
	GAppInfo* _tmp4_;
	GAppInfo* _tmp5_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_val_if_fail (link != NULL, NULL);
	self = (SynapseLinkPluginResult*) synapse_match_construct (object_type);
	_tmp0_ = g_strdup (link);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	_tmp1_ = self->priv->uri;
	_tmp2_ = g_strdup_printf (_ ("Open %s in default web browser"), _tmp1_);
	_title = _tmp2_;
	_tmp3_ = g_strdup ("web-browser");
	_icon_name = _tmp3_;
	_tmp4_ = g_app_info_get_default_for_type ("x-scheme-handler/http", FALSE);
	_g_object_unref0 (self->priv->appinfo);
	self->priv->appinfo = _tmp4_;
	_tmp5_ = self->priv->appinfo;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		GAppInfo* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GAppInfo* _tmp10_;
		GIcon* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = self->priv->uri;
		_tmp7_ = self->priv->appinfo;
		_tmp8_ = g_app_info_get_display_name (_tmp7_);
		_tmp9_ = g_strdup_printf (_ ("Open %s in %s"), _tmp6_, _tmp8_);
		_g_free0 (_title);
		_title = _tmp9_;
		_tmp10_ = self->priv->appinfo;
		_tmp11_ = g_app_info_get_icon (_tmp10_);
		_tmp12_ = g_icon_to_string (_tmp11_);
		_g_free0 (_icon_name);
		_icon_name = _tmp12_;
	}
	_tmp13_ = _title;
	synapse_match_set_title ((SynapseMatch*) self, _tmp13_);
	_tmp14_ = _icon_name;
	synapse_match_set_icon_name ((SynapseMatch*) self, _tmp14_);
	synapse_match_set_description ((SynapseMatch*) self, _ ("Open this link in default browser"));
	synapse_match_set_has_thumbnail ((SynapseMatch*) self, FALSE);
	synapse_match_set_match_type ((SynapseMatch*) self, SYNAPSE_MATCH_TYPE_ACTION);
	_g_free0 (_icon_name);
	_g_free0 (_title);
	return self;
}

SynapseLinkPluginResult*
synapse_link_plugin_result_new (const gchar* link)
{
	return synapse_link_plugin_result_construct (SYNAPSE_LINK_PLUGIN_TYPE_RESULT, link);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
synapse_link_plugin_result_real_execute (SynapseMatch* base,
                                         SynapseMatch* match)
{
	SynapseLinkPluginResult * self;
	GAppInfo* _tmp0_;
	GList* list = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (SynapseLinkPluginResult*) base;
	_tmp0_ = self->priv->appinfo;
	if (_tmp0_ == NULL) {
		return;
	}
	list = NULL;
	_tmp1_ = self->priv->uri;
	_tmp2_ = g_strdup (_tmp1_);
	list = g_list_append (list, _tmp2_);
	{
		GAppInfo* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = self->priv->appinfo;
		_tmp4_ = list;
		g_app_info_launch_uris (_tmp3_, _tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("link-plugin.vala:65: %s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(list == NULL) ? NULL : (list = (_g_list_free__g_free0_ (list), NULL));
}

gint
synapse_link_plugin_result_get_default_relevancy (SynapseLinkPluginResult* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}

void
synapse_link_plugin_result_set_default_relevancy (SynapseLinkPluginResult* self,
                                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_link_plugin_result_get_default_relevancy (self);
	if (old_value != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}

static void
synapse_link_plugin_result_class_init (SynapseLinkPluginResultClass * klass,
                                       gpointer klass_data)
{
	synapse_link_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseLinkPluginResult_private_offset);
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_link_plugin_result_real_execute;
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_link_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_link_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_link_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_link_plugin_result_properties[SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_link_plugin_result_instance_init (SynapseLinkPluginResult * self,
                                          gpointer klass)
{
	self->priv = synapse_link_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
}

static void
synapse_link_plugin_result_finalize (GObject * obj)
{
	SynapseLinkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
	_g_free0 (self->priv->uri);
	_g_object_unref0 (self->priv->appinfo);
	G_OBJECT_CLASS (synapse_link_plugin_result_parent_class)->finalize (obj);
}

GType
synapse_link_plugin_result_get_type (void)
{
	return synapse_link_plugin_result_type_id;
}

GType
synapse_link_plugin_result_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLinkPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_link_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLinkPluginResult), 0, (GInstanceInitFunc) synapse_link_plugin_result_instance_init, NULL };
	synapse_link_plugin_result_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_MATCH, "SynapseLinkPluginResult", &g_define_type_info, 0);
	SynapseLinkPluginResult_private_offset = sizeof (SynapseLinkPluginResultPrivate);
	return synapse_link_plugin_result_type_id;
}

static void
_vala_synapse_link_plugin_result_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SynapseLinkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
	switch (property_id) {
		case SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_link_plugin_result_get_default_relevancy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_link_plugin_result_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SynapseLinkPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_LINK_PLUGIN_TYPE_RESULT, SynapseLinkPluginResult);
	switch (property_id) {
		case SYNAPSE_LINK_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_link_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
synapse_link_plugin_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseLinkPlugin * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_link_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("[-a-zA-Z0-9@:%._\\+~#=]{2,256}\\.[a-z]{2,4}\\b([-a-zA-Z0-9@:%_\\+.~#?&" \
"//=]*)", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("link-plugin.vala:89: Error creating regexp: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
synapse_link_plugin_class_init (SynapseLinkPluginClass * klass,
                                gpointer klass_data)
{
	synapse_link_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseLinkPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_link_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_link_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_link_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_link_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY, synapse_link_plugin_properties[SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_link_plugin_register_plugin ();
}

static void
synapse_link_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                        gpointer iface_data)
{
	synapse_link_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_link_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_link_plugin_real_deactivate;
	iface->get_enabled = synapse_link_plugin_real_get_enabled;
	iface->set_enabled = synapse_link_plugin_real_set_enabled;
}

static void
synapse_link_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                          gpointer iface_data)
{
	synapse_link_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_link_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_link_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_link_plugin_search_finish;
}

static void
synapse_link_plugin_instance_init (SynapseLinkPlugin * self,
                                   gpointer klass)
{
	self->priv = synapse_link_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_link_plugin_finalize (GObject * obj)
{
	SynapseLinkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
	_g_regex_unref0 (self->priv->regex);
	G_OBJECT_CLASS (synapse_link_plugin_parent_class)->finalize (obj);
}

GType
synapse_link_plugin_get_type (void)
{
	return synapse_link_plugin_type_id;
}

GType
synapse_link_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseLinkPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_link_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseLinkPlugin), 0, (GInstanceInitFunc) synapse_link_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_link_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_link_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	synapse_link_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseLinkPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, synapse_link_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_module_add_interface (module, synapse_link_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseLinkPlugin_private_offset = sizeof (SynapseLinkPluginPrivate);
	return synapse_link_plugin_type_id;
}

static void
_vala_synapse_link_plugin_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SynapseLinkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
	switch (property_id) {
		case SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_link_plugin_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SynapseLinkPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_LINK_PLUGIN, SynapseLinkPlugin);
	switch (property_id) {
		case SYNAPSE_LINK_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

