/* RunnerAction.c generated by valac 0.56.14, the Vala compiler
 * generated from RunnerAction.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*               2020-2021 Justin Haygood
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define SYNAPSE_TYPE_RUNNER_ACTION (synapse_runner_action_get_type ())
#define SYNAPSE_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction))
#define SYNAPSE_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))
#define SYNAPSE_IS_RUNNER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_IS_RUNNER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_TYPE_RUNNER_ACTION))
#define SYNAPSE_RUNNER_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerActionClass))

typedef struct _SynapseRunnerAction SynapseRunnerAction;
typedef struct _SynapseRunnerActionClass SynapseRunnerActionClass;
typedef struct _SynapseRunnerActionPrivate SynapseRunnerActionPrivate;
enum  {
	SYNAPSE_RUNNER_ACTION_0_PROPERTY,
	SYNAPSE_RUNNER_ACTION_NUM_PROPERTIES
};
static GParamSpec* synapse_runner_action_properties[SYNAPSE_RUNNER_ACTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseRunnerAction {
	SynapseBaseAction parent_instance;
	SynapseRunnerActionPrivate * priv;
};

struct _SynapseRunnerActionClass {
	SynapseBaseActionClass parent_class;
};

struct _SynapseRunnerActionPrivate {
	SlingshotBackendSwitcherooControl* switcheroo_control;
};

static gint SynapseRunnerAction_private_offset;
static gpointer synapse_runner_action_parent_class = NULL;
static GType synapse_runner_action_type_id = 0;

GType synapse_runner_action_register_type (GTypeModule * module);
VALA_EXTERN GType synapse_runner_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_new (void);
VALA_EXTERN SynapseRunnerAction* synapse_runner_action_construct (GType object_type);
static void synapse_runner_action_real_do_execute (SynapseBaseAction* base,
                                            SynapseMatch* match,
                                            SynapseMatch* target);
static void _____lambda25_ (SynapseRunnerAction* self,
                     GPid pid,
                     gint status);
static void ______lambda25__gchild_watch_func (GPid pid,
                                        gint wait_status,
                                        gpointer self);
static gboolean synapse_runner_action_real_valid_for_match (SynapseBaseAction* base,
                                                     SynapseMatch* match);
static GObject * synapse_runner_action_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void synapse_runner_action_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_runner_action_get_instance_private (SynapseRunnerAction* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseRunnerAction_private_offset);
}

SynapseRunnerAction*
synapse_runner_action_construct (GType object_type)
{
	SynapseRunnerAction * self = NULL;
	self = (SynapseRunnerAction*) g_object_new (object_type, "title", _ ("Run"), "description", _ ("Run an application, action or script"), "icon-name", "system-run", "has-thumbnail", FALSE, "match-type", SYNAPSE_MATCH_TYPE_ACTION, "default-relevancy", SYNAPSE_MATCH_SCORE_EXCELLENT, NULL);
	return self;
}

SynapseRunnerAction*
synapse_runner_action_new (void)
{
	return synapse_runner_action_construct (SYNAPSE_TYPE_RUNNER_ACTION);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_____lambda25_ (SynapseRunnerAction* self,
                GPid pid,
                gint status)
{
	g_spawn_close_pid (pid);
}

static void
______lambda25__gchild_watch_func (GPid pid,
                                   gint wait_status,
                                   gpointer self)
{
	_____lambda25_ ((SynapseRunnerAction*) self, pid, wait_status);
}

static void
synapse_runner_action_real_do_execute (SynapseBaseAction* base,
                                       SynapseMatch* match,
                                       SynapseMatch* target)
{
	SynapseRunnerAction * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (SynapseRunnerAction*) base;
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SYNAPSE_MATCH_TYPE_APPLICATION) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp2_;
		GDesktopAppInfo* app_info = NULL;
		GAppInfo* app = NULL;
		SynapseApplicationMatch* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		app_match = SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL;
		_tmp2_ = app_match;
		g_return_if_fail (_tmp2_ != NULL);
		app_info = NULL;
		_tmp3_ = app_match;
		_tmp4_ = synapse_application_match_get_app_info (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			SynapseApplicationMatch* _tmp6_;
			GAppInfo* _tmp7_;
			GAppInfo* _tmp8_;
			GAppInfo* _tmp9_;
			_tmp6_ = app_match;
			_tmp7_ = synapse_application_match_get_app_info (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (app);
			app = _tmp9_;
		} else {
			SynapseApplicationMatch* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			GDesktopAppInfo* _tmp13_;
			GDesktopAppInfo* _tmp14_;
			GAppInfo* _tmp15_;
			_tmp10_ = app_match;
			_tmp11_ = synapse_application_match_get_filename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_desktop_app_info_new_from_filename (_tmp12_);
			_g_object_unref0 (app_info);
			app_info = _tmp13_;
			_tmp14_ = app_info;
			_tmp15_ = _g_object_ref0 ((GAppInfo*) _tmp14_);
			_g_object_unref0 (app);
			app = _tmp15_;
		}
		{
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp16_;
			gchar* commandline = NULL;
			GAppInfo* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** spawn_args = NULL;
			gchar** _tmp20_;
			gint spawn_args_length1;
			gint _spawn_args_size_;
			static const char checkstr[] = "pkexec";
			const gchar* _tmp21_;
			gboolean _tmp25_ = FALSE;
			gchar** _tmp26_;
			gint _tmp26__length1;
			_tmp16_ = gdk_display_get_default ();
			display = _tmp16_;
			_tmp17_ = app;
			_tmp18_ = g_app_info_get_commandline (_tmp17_);
			_tmp19_ = g_strdup (_tmp18_);
			commandline = _tmp19_;
			_tmp20_ = g_new0 (gchar*, 0 + 1);
			spawn_args = _tmp20_;
			spawn_args_length1 = 0;
			_spawn_args_size_ = spawn_args_length1;
			_tmp21_ = commandline;
			if (string_contains (_tmp21_, checkstr)) {
				const gchar* _tmp22_;
				gchar** _tmp23_;
				gchar** _tmp24_;
				_tmp22_ = commandline;
				_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, " ", 0);
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				spawn_args = _tmp24_;
				spawn_args_length1 = _vala_array_length (_tmp23_);
				_spawn_args_size_ = spawn_args_length1;
			}
			_tmp26_ = spawn_args;
			_tmp26__length1 = spawn_args_length1;
			if (_tmp26__length1 >= 2) {
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				_tmp27_ = spawn_args;
				_tmp27__length1 = spawn_args_length1;
				_tmp28_ = _tmp27_[0];
				_tmp25_ = g_strcmp0 (_tmp28_, checkstr) == 0;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				gchar** spawn_env = NULL;
				gchar** _tmp29_;
				gchar** _tmp30_;
				gint spawn_env_length1;
				gint _spawn_env_size_;
				GPid child_pid = 0;
				gchar** _tmp31_;
				gint _tmp31__length1;
				gchar** _tmp32_;
				gint _tmp32__length1;
				GPid _tmp33_ = 0;
				_tmp30_ = _tmp29_ = g_get_environ ();
				spawn_env = _tmp30_;
				spawn_env_length1 = _vala_array_length (_tmp29_);
				_spawn_env_size_ = spawn_env_length1;
				_tmp31_ = spawn_args;
				_tmp31__length1 = spawn_args_length1;
				_tmp32_ = spawn_env;
				_tmp32__length1 = spawn_env_length1;
				g_spawn_async ("/", _tmp31_, _tmp32_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp33_, &_inner_error0_);
				child_pid = _tmp33_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
					spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (commandline);
					goto __catch0_g_error;
				}
				g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, ______lambda25__gchild_watch_func, g_object_ref (self), g_object_unref);
				spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			} else {
				GdkAppLaunchContext* context = NULL;
				GdkDisplay* _tmp34_;
				GdkAppLaunchContext* _tmp35_;
				GDesktopAppInfo* _tmp36_;
				GAppInfo* _tmp40_;
				GdkAppLaunchContext* _tmp41_;
				SynapseRelevancyService* _tmp42_;
				SynapseRelevancyService* _tmp43_;
				GAppInfo* _tmp44_;
				_tmp34_ = display;
				_tmp35_ = gdk_display_get_app_launch_context (_tmp34_);
				context = _tmp35_;
				_tmp36_ = app_info;
				if (_tmp36_ != NULL) {
					gboolean use_default_gpu = FALSE;
					GDesktopAppInfo* _tmp37_;
					SlingshotBackendSwitcherooControl* _tmp38_;
					GdkAppLaunchContext* _tmp39_;
					_tmp37_ = app_info;
					use_default_gpu = !g_desktop_app_info_get_boolean (_tmp37_, "PrefersNonDefaultGPU");
					_tmp38_ = self->priv->switcheroo_control;
					_tmp39_ = context;
					slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp38_, (GAppLaunchContext*) _tmp39_, use_default_gpu);
				}
				_tmp40_ = app;
				_tmp41_ = context;
				g_app_info_launch (_tmp40_, NULL, (GAppLaunchContext*) _tmp41_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (context);
					spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (commandline);
					goto __catch0_g_error;
				}
				_tmp42_ = synapse_relevancy_service_get_default ();
				_tmp43_ = _tmp42_;
				_tmp44_ = app;
				synapse_relevancy_service_application_launched (_tmp43_, _tmp44_);
				_g_object_unref0 (_tmp43_);
				_g_object_unref0 (context);
			}
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (commandline);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp45_;
			const gchar* _tmp46_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp45_ = err;
			_tmp46_ = _tmp45_->message;
			g_critical ("RunnerAction.vala:92: %s", _tmp46_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (app);
			_g_object_unref0 (app_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (app);
		_g_object_unref0 (app_info);
	} else {
		synapse_match_execute (match, NULL);
	}
}

static gboolean
synapse_runner_action_real_valid_for_match (SynapseBaseAction* base,
                                            SynapseMatch* match)
{
	SynapseRunnerAction * self;
	SynapseMatchType _tmp0_;
	SynapseMatchType _tmp1_;
	gboolean result;
	self = (SynapseRunnerAction*) base;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = synapse_match_get_match_type (match);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case SYNAPSE_MATCH_TYPE_SEARCH:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_ACTION:
		{
			result = TRUE;
			return result;
		}
		case SYNAPSE_MATCH_TYPE_APPLICATION:
		{
			SynapseApplicationMatch* am = NULL;
			gboolean _tmp2_ = FALSE;
			SynapseApplicationMatch* _tmp3_;
			am = SYNAPSE_IS_APPLICATION_MATCH (match) ? ((SynapseApplicationMatch*) match) : NULL;
			_tmp3_ = am;
			if (_tmp3_ == NULL) {
				_tmp2_ = TRUE;
			} else {
				SynapseApplicationMatch* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp4_ = am;
				_tmp5_ = synapse_application_match_get_needs_terminal (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp2_ = !_tmp6_;
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static GObject *
synapse_runner_action_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseRunnerAction * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	parent_class = G_OBJECT_CLASS (synapse_runner_action_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	return obj;
}

static void
synapse_runner_action_class_init (SynapseRunnerActionClass * klass,
                                  gpointer klass_data)
{
	synapse_runner_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseRunnerAction_private_offset);
	((SynapseBaseActionClass *) klass)->do_execute = (void (*) (SynapseBaseAction*, SynapseMatch*, SynapseMatch*)) synapse_runner_action_real_do_execute;
	((SynapseBaseActionClass *) klass)->valid_for_match = (gboolean (*) (SynapseBaseAction*, SynapseMatch*)) synapse_runner_action_real_valid_for_match;
	G_OBJECT_CLASS (klass)->constructor = synapse_runner_action_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_runner_action_finalize;
}

static void
synapse_runner_action_instance_init (SynapseRunnerAction * self,
                                     gpointer klass)
{
	self->priv = synapse_runner_action_get_instance_private (self);
}

static void
synapse_runner_action_finalize (GObject * obj)
{
	SynapseRunnerAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RUNNER_ACTION, SynapseRunnerAction);
	_g_object_unref0 (self->priv->switcheroo_control);
	G_OBJECT_CLASS (synapse_runner_action_parent_class)->finalize (obj);
}

GType
synapse_runner_action_get_type (void)
{
	return synapse_runner_action_type_id;
}

GType
synapse_runner_action_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseRunnerActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_runner_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseRunnerAction), 0, (GInstanceInitFunc) synapse_runner_action_instance_init, NULL };
	synapse_runner_action_type_id = g_type_module_register_type (module, SYNAPSE_TYPE_BASE_ACTION, "SynapseRunnerAction", &g_define_type_info, 0);
	SynapseRunnerAction_private_offset = sizeof (SynapseRunnerActionPrivate);
	return synapse_runner_action_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

