/* AppListRow.c generated by valac 0.56.14, the Vala compiler
 * generated from AppListRow.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

enum  {
	APP_LIST_ROW_0_PROPERTY,
	APP_LIST_ROW_APP_ID_PROPERTY,
	APP_LIST_ROW_DESKTOP_PATH_PROPERTY,
	APP_LIST_ROW_APP_INFO_PROPERTY,
	APP_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* app_list_row_properties[APP_LIST_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AppListRowPrivate {
	gchar* _app_id;
	gchar* _desktop_path;
	GDesktopAppInfo* _app_info;
};

static gint AppListRow_private_offset;
static gpointer app_list_row_parent_class = NULL;
static GType app_list_row_type_id = 0;

static void ____lambda59_ (AppListRow* self,
                    GPid pid,
                    gint status);
static void _____lambda59__gchild_watch_func (GPid pid,
                                       gint wait_status,
                                       gpointer self);
static void app_list_row_set_app_info (AppListRow* self,
                                GDesktopAppInfo* value);
static GObject * app_list_row_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void app_list_row_finalize (GObject * obj);
static void _vala_app_list_row_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_app_list_row_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
app_list_row_get_instance_private (AppListRow* self)
{
	return G_STRUCT_MEMBER_P (self, AppListRow_private_offset);
}

AppListRow*
app_list_row_construct (GType object_type,
                        const gchar* app_id,
                        const gchar* desktop_path)
{
	AppListRow * self = NULL;
	g_return_val_if_fail (app_id != NULL, NULL);
	g_return_val_if_fail (desktop_path != NULL, NULL);
	self = (AppListRow*) g_object_new (object_type, "app-id", app_id, "desktop-path", desktop_path, NULL);
	return self;
}

AppListRow*
app_list_row_new (const gchar* app_id,
                  const gchar* desktop_path)
{
	return app_list_row_construct (TYPE_APP_LIST_ROW, app_id, desktop_path);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
____lambda59_ (AppListRow* self,
               GPid pid,
               gint status)
{
	g_spawn_close_pid (pid);
}

static void
_____lambda59__gchild_watch_func (GPid pid,
                                  gint wait_status,
                                  gpointer self)
{
	____lambda59_ ((AppListRow*) self, pid, wait_status);
}

void
app_list_row_launch (AppListRow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* commandline = NULL;
		GDesktopAppInfo* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** spawn_args = NULL;
		gchar** _tmp3_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		static const char checkstr[] = "pkexec";
		const gchar* _tmp4_;
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp0_ = self->priv->_app_info;
		_tmp1_ = g_app_info_get_commandline ((GAppInfo*) _tmp0_);
		_tmp2_ = g_strdup (_tmp1_);
		commandline = _tmp2_;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		spawn_args = _tmp3_;
		spawn_args_length1 = 0;
		_spawn_args_size_ = spawn_args_length1;
		_tmp4_ = commandline;
		if (string_contains (_tmp4_, checkstr)) {
			const gchar* _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			_tmp5_ = commandline;
			_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 0);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = _tmp7_;
			spawn_args_length1 = _vala_array_length (_tmp6_);
			_spawn_args_size_ = spawn_args_length1;
		}
		_tmp9_ = spawn_args;
		_tmp9__length1 = spawn_args_length1;
		if (_tmp9__length1 >= 2) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			_tmp10_ = spawn_args;
			_tmp10__length1 = spawn_args_length1;
			_tmp11_ = _tmp10_[0];
			_tmp8_ = g_strcmp0 (_tmp11_, checkstr) == 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar** spawn_env = NULL;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gint spawn_env_length1;
			gint _spawn_env_size_;
			GPid child_pid = 0;
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar** _tmp15_;
			gint _tmp15__length1;
			GPid _tmp16_ = 0;
			_tmp13_ = _tmp12_ = g_get_environ ();
			spawn_env = _tmp13_;
			spawn_env_length1 = _vala_array_length (_tmp12_);
			_spawn_env_size_ = spawn_env_length1;
			_tmp14_ = spawn_args;
			_tmp14__length1 = spawn_args_length1;
			_tmp15_ = spawn_env;
			_tmp15__length1 = spawn_env_length1;
			g_spawn_async ("/", _tmp14_, _tmp15_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp16_, &_inner_error0_);
			child_pid = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (commandline);
				goto __catch0_g_error;
			}
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, _____lambda59__gchild_watch_func, g_object_ref (self), g_object_unref);
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		} else {
			GDesktopAppInfo* _tmp17_;
			_tmp17_ = self->priv->_app_info;
			g_app_info_launch ((GAppInfo*) _tmp17_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (commandline);
				goto __catch0_g_error;
			}
		}
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (commandline);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = _error_;
		_tmp19_ = _tmp18_->message;
		g_critical ("AppListRow.vala:90: %s", _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

const gchar*
app_list_row_get_app_id (AppListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
app_list_row_set_app_id (AppListRow* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = app_list_row_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_list_row_properties[APP_LIST_ROW_APP_ID_PROPERTY]);
	}
}

const gchar*
app_list_row_get_desktop_path (AppListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
app_list_row_set_desktop_path (AppListRow* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = app_list_row_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_list_row_properties[APP_LIST_ROW_DESKTOP_PATH_PROPERTY]);
	}
}

GDesktopAppInfo*
app_list_row_get_app_info (AppListRow* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
app_list_row_set_app_info (AppListRow* self,
                           GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = app_list_row_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_list_row_properties[APP_LIST_ROW_APP_INFO_PROPERTY]);
	}
}

static GObject *
app_list_row_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AppListRow * self;
	const gchar* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GIcon* icon = NULL;
	GDesktopAppInfo* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GIcon* _tmp8_;
	GtkImage* image = NULL;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GIcon* _tmp16_;
	GtkImage* _tmp17_;
	GtkLabel* name_label = NULL;
	GDesktopAppInfo* _tmp18_;
	const gchar* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GDesktopAppInfo* _tmp23_;
	const gchar* _tmp24_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkImage* _tmp28_;
	GtkGrid* _tmp29_;
	GtkLabel* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* _tmp33_;
	parent_class = G_OBJECT_CLASS (app_list_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_LIST_ROW, AppListRow);
	_tmp0_ = self->priv->_app_id;
	_tmp1_ = g_desktop_app_info_new (_tmp0_);
	_tmp2_ = _tmp1_;
	app_list_row_set_app_info (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_app_info;
	_tmp4_ = g_app_info_get_icon ((GAppInfo*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	icon = _tmp5_;
	_tmp6_ = gtk_icon_theme_get_default ();
	theme = _tmp6_;
	_tmp8_ = icon;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GtkIconTheme* _tmp9_;
		GIcon* _tmp10_;
		GtkIconInfo* _tmp11_;
		GtkIconInfo* _tmp12_;
		_tmp9_ = theme;
		_tmp10_ = icon;
		_tmp11_ = gtk_icon_theme_lookup_by_gicon (_tmp9_, _tmp10_, 32, GTK_ICON_LOOKUP_USE_BUILTIN);
		_tmp12_ = _tmp11_;
		_tmp7_ = _tmp12_ == NULL;
		_g_object_unref0 (_tmp12_);
	}
	if (_tmp7_) {
		GThemedIcon* _tmp13_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp13_;
	}
	_tmp14_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp14_);
	image = _tmp14_;
	_tmp15_ = image;
	_tmp16_ = icon;
	g_object_set (_tmp15_, "gicon", _tmp16_, NULL);
	_tmp17_ = image;
	gtk_image_set_pixel_size (_tmp17_, 32);
	_tmp18_ = self->priv->_app_info;
	_tmp19_ = g_app_info_get_display_name ((GAppInfo*) _tmp18_);
	_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	name_label = _tmp20_;
	_tmp21_ = name_label;
	gtk_label_set_ellipsize (_tmp21_, PANGO_ELLIPSIZE_END);
	_tmp22_ = name_label;
	gtk_label_set_xalign (_tmp22_, (gfloat) 0);
	_tmp23_ = self->priv->_app_info;
	_tmp24_ = g_app_info_get_description ((GAppInfo*) _tmp23_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp24_);
	_tmp25_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp25_);
	grid = _tmp25_;
	_tmp26_ = grid;
	gtk_grid_set_column_spacing (_tmp26_, 12);
	_tmp27_ = grid;
	_tmp28_ = image;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = grid;
	_tmp30_ = name_label;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = grid;
	g_object_set ((GtkWidget*) _tmp31_, "margin", 6, NULL);
	_tmp32_ = grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 18);
	_tmp33_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_g_object_unref0 (grid);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image);
	_g_object_unref0 (icon);
	return obj;
}

static void
app_list_row_class_init (AppListRowClass * klass,
                         gpointer klass_data)
{
	app_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_app_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_app_list_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = app_list_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = app_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_LIST_ROW_APP_ID_PROPERTY, app_list_row_properties[APP_LIST_ROW_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_LIST_ROW_DESKTOP_PATH_PROPERTY, app_list_row_properties[APP_LIST_ROW_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_LIST_ROW_APP_INFO_PROPERTY, app_list_row_properties[APP_LIST_ROW_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
app_list_row_instance_init (AppListRow * self,
                            gpointer klass)
{
	self->priv = app_list_row_get_instance_private (self);
}

static void
app_list_row_finalize (GObject * obj)
{
	AppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_LIST_ROW, AppListRow);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_desktop_path);
	_g_object_unref0 (self->priv->_app_info);
	G_OBJECT_CLASS (app_list_row_parent_class)->finalize (obj);
}

GType
app_list_row_get_type (void)
{
	return app_list_row_type_id;
}

GType
app_list_row_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppListRow), 0, (GInstanceInitFunc) app_list_row_instance_init, NULL };
	app_list_row_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "AppListRow", &g_define_type_info, 0);
	AppListRow_private_offset = sizeof (AppListRowPrivate);
	return app_list_row_type_id;
}

static void
_vala_app_list_row_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	AppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_LIST_ROW, AppListRow);
	switch (property_id) {
		case APP_LIST_ROW_APP_ID_PROPERTY:
		g_value_set_string (value, app_list_row_get_app_id (self));
		break;
		case APP_LIST_ROW_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, app_list_row_get_desktop_path (self));
		break;
		case APP_LIST_ROW_APP_INFO_PROPERTY:
		g_value_set_object (value, app_list_row_get_app_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_app_list_row_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	AppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_LIST_ROW, AppListRow);
	switch (property_id) {
		case APP_LIST_ROW_APP_ID_PROPERTY:
		app_list_row_set_app_id (self, g_value_get_string (value));
		break;
		case APP_LIST_ROW_DESKTOP_PATH_PROPERTY:
		app_list_row_set_desktop_path (self, g_value_get_string (value));
		break;
		case APP_LIST_ROW_APP_INFO_PROPERTY:
		app_list_row_set_app_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

