/* unified_props.c generated by valac 0.56.14, the Vala compiler
 * generated from unified_props.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CLICK_POLICY_TYPE_SINGLE = 1,
	CLICK_POLICY_TYPE_DOUBLE = 2
} ClickPolicyType;

#define TYPE_CLICK_POLICY_TYPE (click_policy_type_get_type ())

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;
typedef struct _UnifiedPropsPrivate UnifiedPropsPrivate;

#define TYPE_FILE_MENU (file_menu_get_type ())
#define FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_MENU, FileMenu))
#define FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_MENU, FileMenuClass))
#define IS_FILE_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_MENU))
#define IS_FILE_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_MENU))
#define FILE_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_MENU, FileMenuClass))

typedef struct _FileMenu FileMenu;
typedef struct _FileMenuClass FileMenuClass;
enum  {
	UNIFIED_PROPS_0_PROPERTY,
	UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY,
	UNIFIED_PROPS_IS_SINGLE_CLICK_PROPERTY,
	UNIFIED_PROPS_MAX_THUMBNAIL_SIZE_PROPERTY,
	UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY,
	UNIFIED_PROPS_PREVIOUS_CURSOR_PROPERTY,
	UNIFIED_PROPS_NUM_PROPERTIES
};
static GParamSpec* unified_props_properties[UNIFIED_PROPS_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	UNIFIED_PROPS_CURSOR_CHANGED_SIGNAL,
	UNIFIED_PROPS_THUMBNAIL_SIZE_CHANGED_SIGNAL,
	UNIFIED_PROPS_NUM_SIGNALS
};
static guint unified_props_signals[UNIFIED_PROPS_NUM_SIGNALS] = {0};

struct _UnifiedProps {
	GObject parent_instance;
	UnifiedPropsPrivate * priv;
	GHashTable* files_currently_copying;
	gboolean is_launching;
	GdkCursor* blocked_cursor;
	GdkCursor* hand_cursor;
	GdkCursor* loading_cursor;
	GdkAppLaunchContext* launch_context;
	FileMenu* file_menu;
	GtkIconTheme* icon_theme;
	gint* icon_size;
	gint* s_factor;
};

struct _UnifiedPropsClass {
	GObjectClass parent_class;
};

struct _UnifiedPropsPrivate {
	GSettings* _settings;
	gboolean _is_single_click;
	gint _max_thumbnail_size;
	GdkCursor* _previous_cursor;
	GdkCursor* _current_cursor;
};

static gint UnifiedProps_private_offset;
static gpointer unified_props_parent_class = NULL;

VALA_EXTERN GType click_policy_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN GType file_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileMenu, g_object_unref)
VALA_EXTERN UnifiedProps* unified_props_new (void);
VALA_EXTERN UnifiedProps* unified_props_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gboolean unified_props_is_copying (UnifiedProps* self,
                                   const gchar* file_name);
VALA_EXTERN gboolean unified_props_is_desired_primary_click_type (UnifiedProps* self,
                                                      GdkEventButton* ev);
static void unified_props_update_click_policy (UnifiedProps* self);
static void unified_props_update_max_thumbnail_size (UnifiedProps* self);
VALA_EXTERN GSettings* unified_props_get_desktop_settings (UnifiedProps* self);
VALA_EXTERN void unified_props_set_desktop_settings (UnifiedProps* self,
                                         GSettings* value);
static void _unified_props_update_click_policy_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self);
static void _unified_props_desktop_settings___lambda5_ (UnifiedProps* self);
static void __unified_props_desktop_settings___lambda5__g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
VALA_EXTERN gboolean unified_props_get_is_single_click (UnifiedProps* self);
VALA_EXTERN gint unified_props_get_max_thumbnail_size (UnifiedProps* self);
VALA_EXTERN GdkCursor* unified_props_get_current_cursor (UnifiedProps* self);
VALA_EXTERN void unified_props_set_current_cursor (UnifiedProps* self,
                                       GdkCursor* value);
VALA_EXTERN GdkCursor* unified_props_get_previous_cursor (UnifiedProps* self);
static void unified_props_finalize (GObject * obj);
static GType unified_props_get_type_once (void);
static void _vala_unified_props_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_unified_props_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
click_policy_type_get_type_once (void)
{
	static const GEnumValue values[] = {{CLICK_POLICY_TYPE_SINGLE, "CLICK_POLICY_TYPE_SINGLE", "single"}, {CLICK_POLICY_TYPE_DOUBLE, "CLICK_POLICY_TYPE_DOUBLE", "double"}, {0, NULL, NULL}};
	GType click_policy_type_type_id;
	click_policy_type_type_id = g_enum_register_static ("ClickPolicyType", values);
	return click_policy_type_type_id;
}

GType
click_policy_type_get_type (void)
{
	static volatile gsize click_policy_type_type_id__once = 0;
	if (g_once_init_enter (&click_policy_type_type_id__once)) {
		GType click_policy_type_type_id;
		click_policy_type_type_id = click_policy_type_get_type_once ();
		g_once_init_leave (&click_policy_type_type_id__once, click_policy_type_type_id);
	}
	return click_policy_type_type_id__once;
}

static inline gpointer
unified_props_get_instance_private (UnifiedProps* self)
{
	return G_STRUCT_MEMBER_P (self, UnifiedProps_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

UnifiedProps*
unified_props_construct (GType object_type)
{
	UnifiedProps * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self = (UnifiedProps*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->files_currently_copying);
	self->files_currently_copying = _tmp2_;
	self->is_launching = FALSE;
	self->priv->_is_single_click = TRUE;
	self->priv->_max_thumbnail_size = 10;
	return self;
}

UnifiedProps*
unified_props_new (void)
{
	return unified_props_construct (TYPE_UNIFIED_PROPS);
}

gboolean
unified_props_is_copying (UnifiedProps* self,
                          const gchar* file_name)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file_name != NULL, FALSE);
	_tmp0_ = self->files_currently_copying;
	result = g_hash_table_contains (_tmp0_, file_name);
	return result;
}

gboolean
unified_props_is_desired_primary_click_type (UnifiedProps* self,
                                             GdkEventButton* ev)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	if (ev->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	if (self->priv->_is_single_click) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = ev->type == GDK_DOUBLE_BUTTON_PRESS;
	}
	result = _tmp0_;
	return result;
}

static void
unified_props_update_click_policy (UnifiedProps* self)
{
	ClickPolicyType policy = 0;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	policy = (ClickPolicyType) g_settings_get_enum (_tmp0_, "click-policy");
	self->priv->_is_single_click = policy == CLICK_POLICY_TYPE_SINGLE;
}

static void
unified_props_update_max_thumbnail_size (UnifiedProps* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	self->priv->_max_thumbnail_size = g_settings_get_int (_tmp0_, "max-thumbnail-size");
}

GSettings*
unified_props_get_desktop_settings (UnifiedProps* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_unified_props_update_click_policy_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self)
{
	unified_props_update_click_policy ((UnifiedProps*) self);
}

static void
_unified_props_desktop_settings___lambda5_ (UnifiedProps* self)
{
	unified_props_update_max_thumbnail_size (self);
	g_signal_emit (self, unified_props_signals[UNIFIED_PROPS_THUMBNAIL_SIZE_CHANGED_SIGNAL], 0);
}

static void
__unified_props_desktop_settings___lambda5__g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	_unified_props_desktop_settings___lambda5_ ((UnifiedProps*) self);
}

void
unified_props_set_desktop_settings (UnifiedProps* self,
                                    GSettings* value)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	unified_props_update_max_thumbnail_size (self);
	unified_props_update_click_policy (self);
	_tmp1_ = self->priv->_settings;
	g_signal_connect_object (_tmp1_, "changed::click-policy", (GCallback) _unified_props_update_click_policy_g_settings_changed, self, 0);
	_tmp2_ = self->priv->_settings;
	g_signal_connect_object (_tmp2_, "changed::max-thumbnail-size", (GCallback) __unified_props_desktop_settings___lambda5__g_settings_changed, self, 0);
	g_object_notify_by_pspec ((GObject *) self, unified_props_properties[UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY]);
}

gboolean
unified_props_get_is_single_click (UnifiedProps* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_single_click;
	return result;
}

gint
unified_props_get_max_thumbnail_size (UnifiedProps* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_thumbnail_size;
	return result;
}

GdkCursor*
unified_props_get_current_cursor (UnifiedProps* self)
{
	GdkCursor* result;
	GdkCursor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_cursor;
	result = _tmp0_;
	return result;
}

void
unified_props_set_current_cursor (UnifiedProps* self,
                                  GdkCursor* value)
{
	GdkCursor* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_cursor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_previous_cursor);
	self->priv->_previous_cursor = _tmp1_;
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_cursor);
	self->priv->_current_cursor = _tmp2_;
	_tmp3_ = self->priv->_current_cursor;
	if (_tmp3_ != NULL) {
		GdkCursor* _tmp4_;
		_tmp4_ = self->priv->_current_cursor;
		g_signal_emit (self, unified_props_signals[UNIFIED_PROPS_CURSOR_CHANGED_SIGNAL], 0, _tmp4_);
	}
	g_object_notify_by_pspec ((GObject *) self, unified_props_properties[UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY]);
}

GdkCursor*
unified_props_get_previous_cursor (UnifiedProps* self)
{
	GdkCursor* result;
	GdkCursor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_previous_cursor;
	result = _tmp0_;
	return result;
}

static void
unified_props_class_init (UnifiedPropsClass * klass,
                          gpointer klass_data)
{
	unified_props_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UnifiedProps_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_unified_props_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unified_props_set_property;
	G_OBJECT_CLASS (klass)->finalize = unified_props_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY, unified_props_properties[UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY] = g_param_spec_object ("desktop-settings", "desktop-settings", "desktop-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIFIED_PROPS_IS_SINGLE_CLICK_PROPERTY, unified_props_properties[UNIFIED_PROPS_IS_SINGLE_CLICK_PROPERTY] = g_param_spec_boolean ("is-single-click", "is-single-click", "is-single-click", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIFIED_PROPS_MAX_THUMBNAIL_SIZE_PROPERTY, unified_props_properties[UNIFIED_PROPS_MAX_THUMBNAIL_SIZE_PROPERTY] = g_param_spec_int ("max-thumbnail-size", "max-thumbnail-size", "max-thumbnail-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY, unified_props_properties[UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY] = g_param_spec_object ("current-cursor", "current-cursor", "current-cursor", gdk_cursor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIFIED_PROPS_PREVIOUS_CURSOR_PROPERTY, unified_props_properties[UNIFIED_PROPS_PREVIOUS_CURSOR_PROPERTY] = g_param_spec_object ("previous-cursor", "previous-cursor", "previous-cursor", gdk_cursor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	unified_props_signals[UNIFIED_PROPS_CURSOR_CHANGED_SIGNAL] = g_signal_new ("cursor-changed", TYPE_UNIFIED_PROPS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gdk_cursor_get_type ());
	unified_props_signals[UNIFIED_PROPS_THUMBNAIL_SIZE_CHANGED_SIGNAL] = g_signal_new ("thumbnail-size-changed", TYPE_UNIFIED_PROPS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
unified_props_instance_init (UnifiedProps * self,
                             gpointer klass)
{
	self->priv = unified_props_get_instance_private (self);
}

static void
unified_props_finalize (GObject * obj)
{
	UnifiedProps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIFIED_PROPS, UnifiedProps);
	_g_hash_table_unref0 (self->files_currently_copying);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_previous_cursor);
	_g_object_unref0 (self->priv->_current_cursor);
	_g_object_unref0 (self->blocked_cursor);
	_g_object_unref0 (self->hand_cursor);
	_g_object_unref0 (self->loading_cursor);
	_g_object_unref0 (self->launch_context);
	_g_object_unref0 (self->file_menu);
	_g_object_unref0 (self->icon_theme);
	_g_free0 (self->icon_size);
	_g_free0 (self->s_factor);
	G_OBJECT_CLASS (unified_props_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
unified_props_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnifiedPropsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unified_props_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnifiedProps), 0, (GInstanceInitFunc) unified_props_instance_init, NULL };
	GType unified_props_type_id;
	unified_props_type_id = g_type_register_static (G_TYPE_OBJECT, "UnifiedProps", &g_define_type_info, 0);
	UnifiedProps_private_offset = g_type_add_instance_private (unified_props_type_id, sizeof (UnifiedPropsPrivate));
	return unified_props_type_id;
}

GType
unified_props_get_type (void)
{
	static volatile gsize unified_props_type_id__once = 0;
	if (g_once_init_enter (&unified_props_type_id__once)) {
		GType unified_props_type_id;
		unified_props_type_id = unified_props_get_type_once ();
		g_once_init_leave (&unified_props_type_id__once, unified_props_type_id);
	}
	return unified_props_type_id__once;
}

static void
_vala_unified_props_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	UnifiedProps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIFIED_PROPS, UnifiedProps);
	switch (property_id) {
		case UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY:
		g_value_set_object (value, unified_props_get_desktop_settings (self));
		break;
		case UNIFIED_PROPS_IS_SINGLE_CLICK_PROPERTY:
		g_value_set_boolean (value, unified_props_get_is_single_click (self));
		break;
		case UNIFIED_PROPS_MAX_THUMBNAIL_SIZE_PROPERTY:
		g_value_set_int (value, unified_props_get_max_thumbnail_size (self));
		break;
		case UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY:
		g_value_set_object (value, unified_props_get_current_cursor (self));
		break;
		case UNIFIED_PROPS_PREVIOUS_CURSOR_PROPERTY:
		g_value_set_object (value, unified_props_get_previous_cursor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_unified_props_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	UnifiedProps * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIFIED_PROPS, UnifiedProps);
	switch (property_id) {
		case UNIFIED_PROPS_DESKTOP_SETTINGS_PROPERTY:
		unified_props_set_desktop_settings (self, g_value_get_object (value));
		break;
		case UNIFIED_PROPS_CURRENT_CURSOR_PROPERTY:
		unified_props_set_current_cursor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

