/* screenshot.c generated by valac 0.56.14, the Vala compiler
 * generated from screenshot.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Code has been inspired by the elementaryOS Gala ScreenshotManager.vala
 * and the GNOME 42 shell-screenshot.c techniques.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <meta/compositor-mutter.h>
#include <cairo-gobject.h>
#include <meta/window.h>
#include <meta/main.h>
#include <meta/meta-window-actor.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>
#include <meta/meta-settings.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <meta/meta-selection.h>
#include <meta/meta-selection-source-memory.h>
#include <meta/meta-selection-source.h>
#include <cogl/cogl.h>
#include <graphene-gobject.h>
#include <meta/meta-cursor-tracker.h>

#define BUDGIE_EXTENSION ".png"
#define BUDGIE_DBUS_SCREENSHOT "org.buddiesofbudgie.BudgieScreenshot"
#define BUDGIE_DBUS_SCREENSHOT_PATH "/org/buddiesofbudgie/Screenshot"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SCREENSHOT_MANAGER (budgie_screenshot_manager_get_type ())
#define BUDGIE_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManager))
#define BUDGIE_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))
#define BUDGIE_IS_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_IS_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_SCREENSHOT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))

typedef struct _BudgieScreenshotManager BudgieScreenshotManager;
typedef struct _BudgieScreenshotManagerClass BudgieScreenshotManagerClass;
typedef struct _BudgieScreenshotManagerPrivate BudgieScreenshotManagerPrivate;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;
enum  {
	BUDGIE_SCREENSHOT_MANAGER_0_PROPERTY,
	BUDGIE_SCREENSHOT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_screenshot_manager_properties[BUDGIE_SCREENSHOT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BudgieScreenshotManagerScreenshotData BudgieScreenshotManagerScreenshotData;
typedef struct _BudgieBudgieWMPrivate BudgieBudgieWMPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _BudgieScreenshotManagerScreenshotAreaData BudgieScreenshotManagerScreenshotAreaData;
typedef struct _BudgieScreenshotManagerScreenshotWindowData BudgieScreenshotManagerScreenshotWindowData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _BudgieScreenshotManagerSaveImageData BudgieScreenshotManagerSaveImageData;
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _BudgieScreenshotManagerWaitStageRepaintData BudgieScreenshotManagerWaitStageRepaintData;
typedef struct _BudgieScreenshotManagerScreenshotReadyData BudgieScreenshotManagerScreenshotReadyData;
typedef struct _BudgieScreenshotManagerScreenshotAreaReadyData BudgieScreenshotManagerScreenshotAreaReadyData;
typedef struct _BudgieScreenshotManagerScreenshotWindowReadyData BudgieScreenshotManagerScreenshotWindowReadyData;

struct _BudgieScreenshotManager {
	GObject parent_instance;
	BudgieScreenshotManagerPrivate * priv;
};

struct _BudgieScreenshotManagerClass {
	GObjectClass parent_class;
};

struct _BudgieScreenshotManagerPrivate {
	BudgieBudgieWM* wm;
	MetaDisplay* display;
};

struct _Block5Data {
	int _ref_count_;
	BudgieScreenshotManager* self;
	ClutterActor* top_display_group;
};

struct _BudgieScreenshotManagerScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	gint width;
	gint height;
	MetaDisplay* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _BudgieBudgieWM {
	MetaPlugin parent_instance;
	BudgieBudgieWMPrivate * priv;
	gboolean enable_unredirect;
};

struct _BudgieBudgieWMClass {
	MetaPluginClass parent_class;
};

struct _BudgieScreenshotManagerScreenshotAreaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gint x;
	gint y;
	gint width;
	gint height;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	gboolean existing_unredirect;
	BudgieBudgieWM* _tmp0_;
	BudgieBudgieWM* _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	cairo_surface_t* image;
	cairo_surface_t* _tmp4_;
	BudgieBudgieWM* _tmp5_;
	cairo_surface_t* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError* _tmp9_;
	GError* _inner_error0_;
};

struct _BudgieScreenshotManagerScreenshotWindowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gboolean include_frame;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	gboolean existing_unredirect;
	BudgieBudgieWM* _tmp0_;
	BudgieBudgieWM* _tmp1_;
	MetaWindow* window;
	MetaDisplay* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	GError* _tmp6_;
	MetaWindow* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp9_;
	MetaWindowActor* window_actor;
	MetaWindow* _tmp10_;
	GObject* _tmp11_;
	MetaWindowActor* _tmp12_;
	gfloat actor_x;
	gfloat actor_y;
	MetaWindowActor* _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	MetaRectangle rect;
	MetaWindow* _tmp16_;
	MetaRectangle _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	MetaWindow* _tmp20_;
	gboolean _tmp21_;
	MetaWindow* _tmp22_;
	MetaWindow* _tmp23_;
	MetaRectangle _tmp24_;
	MetaRectangle _tmp25_;
	gboolean _tmp26_;
	MetaRectangle _tmp27_;
	MetaRectangle _tmp28_;
	GError* _tmp29_;
	cairo_rectangle_int_t clip;
	MetaRectangle _tmp30_;
	MetaRectangle _tmp31_;
	MetaRectangle _tmp32_;
	MetaRectangle _tmp33_;
	cairo_rectangle_int_t _tmp34_;
	cairo_surface_t* image;
	MetaWindowActor* _tmp35_;
	cairo_rectangle_int_t _tmp36_;
	cairo_surface_t* _tmp37_;
	cairo_surface_t* _tmp38_;
	GError* _tmp39_;
	cairo_surface_t* _tmp40_;
	MetaRectangle _tmp41_;
	MetaRectangle _tmp42_;
	MetaRectangle _tmp43_;
	MetaRectangle _tmp44_;
	cairo_rectangle_int_t _tmp45_;
	cairo_surface_t* _tmp46_;
	MetaRectangle _tmp47_;
	MetaRectangle _tmp48_;
	MetaRectangle _tmp49_;
	MetaRectangle _tmp50_;
	BudgieBudgieWM* _tmp51_;
	cairo_surface_t* _tmp52_;
	gchar* _tmp53_;
	gboolean _tmp54_;
	GError* _tmp55_;
	GError* _inner_error0_;
};

struct _BudgieScreenshotManagerSaveImageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	cairo_surface_t* image;
	gchar* filename;
	gchar* used_filename;
	gboolean result;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	MetaDisplay* display;
	BudgieBudgieWM* _tmp7_;
	MetaDisplay* _tmp8_;
	MetaDisplay* _tmp9_;
	MetaContext* ctx;
	MetaDisplay* _tmp10_;
	MetaContext* _tmp11_;
	MetaContext* _tmp12_;
	gint scale_factor;
	MetaContext* _tmp13_;
	MetaBackend* _tmp14_;
	MetaSettings* _tmp15_;
	gint scale_pos;
	gint _tmp16_;
	gint _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* path;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GdkPixbuf* screenshot;
	GdkPixbuf* _tmp27_;
	GdkPixbuf* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	MetaSelection* selection;
	MetaDisplay* _tmp31_;
	MetaSelection* _tmp32_;
	MetaSelection* _tmp33_;
	GMemoryOutputStream* stream;
	GMemoryOutputStream* _tmp34_;
	GdkPixbuf* _tmp35_;
	GMemoryOutputStream* _tmp36_;
	GMemoryOutputStream* _tmp37_;
	MetaSelectionSourceMemory* source;
	GMemoryOutputStream* _tmp38_;
	GBytes* _tmp39_;
	GBytes* _tmp40_;
	MetaSelectionSourceMemory* _tmp41_;
	MetaSelectionSourceMemory* _tmp42_;
	MetaSelection* _tmp43_;
	MetaSelectionSourceMemory* _tmp44_;
	GFile* file;
	const gchar* _tmp45_;
	GFile* _tmp46_;
	GFileIOStream* _vala1_stream;
	GFile* _tmp47_;
	GFileIOStream* _tmp48_;
	GFile* _tmp49_;
	GFileIOStream* _tmp50_;
	GFileIOStream* _tmp51_;
	GFileIOStream* _tmp52_;
	GFile* _tmp53_;
	GFileIOStream* _tmp54_;
	GFileIOStream* _tmp55_;
	GdkPixbuf* _tmp56_;
	GFileIOStream* _tmp57_;
	GOutputStream* _tmp58_;
	GOutputStream* _tmp59_;
	GError* e;
	GError* _tmp60_;
	const gchar* _tmp61_;
	GError* _tmp62_;
	const gchar* _tmp63_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	BudgieScreenshotManager* self;
	gulong signal_id;
	ClutterStage* stage;
	gpointer _async_data_;
};

struct _BudgieScreenshotManagerWaitStageRepaintData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	Block6Data* _data6_;
	MetaDisplay* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterStage* _tmp2_;
	gulong _tmp3_;
};

struct _BudgieScreenshotManagerScreenshotReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

struct _BudgieScreenshotManagerScreenshotAreaReadyData {
	GDBusMethodInvocation* _invocation_;
	gint x;
	gint y;
	gint width;
	gint height;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

struct _BudgieScreenshotManagerScreenshotWindowReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean include_frame;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

static gint BudgieScreenshotManager_private_offset;
static gpointer budgie_screenshot_manager_parent_class = NULL;
static BudgieScreenshotManager* budgie_screenshot_manager_instance;
static BudgieScreenshotManager* budgie_screenshot_manager_instance = NULL;

VALA_EXTERN GType budgie_screenshot_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenshotManager, g_object_unref)
VALA_EXTERN guint budgie_screenshot_manager_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType budgie_budgie_wm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieWM, g_object_unref)
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_init (BudgieBudgieWM* wm);
static BudgieScreenshotManager* budgie_screenshot_manager_new (BudgieBudgieWM* _wm);
static BudgieScreenshotManager* budgie_screenshot_manager_construct (GType object_type,
                                                              BudgieBudgieWM* _wm);
VALA_EXTERN void budgie_screenshot_manager_setup_dbus (BudgieScreenshotManager* self);
static void budgie_screenshot_manager_on_bus_acquired (BudgieScreenshotManager* self,
                                                GDBusConnection* conn);
static void _budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self);
static void __lambda10_ (BudgieScreenshotManager* self);
static void ___lambda10__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda11_ (BudgieScreenshotManager* self);
static void ___lambda11__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
VALA_EXTERN void budgie_screenshot_manager_flash_area (BudgieScreenshotManager* self,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height,
                                           GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void __lambda12_ (Block5Data* _data5_,
                  ClutterActor* actor);
static void ___lambda12__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                       gpointer self);
static void budgie_screenshot_manager_screenshot_data_free (gpointer _data);
VALA_EXTERN void budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                           gboolean include_cursor,
                                           gboolean flash,
                                           const gchar* filename,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_finish (BudgieScreenshotManager* self,
                                                  GAsyncResult* _res_,
                                                  gboolean* success,
                                                  gchar** filename_used,
                                                  GError** error);
static gboolean budgie_screenshot_manager_screenshot_co (BudgieScreenshotManagerScreenshotData* _data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                gint x,
                                                gint y,
                                                gint width,
                                                gint height,
                                                gboolean include_cursor,
                                                gboolean flash,
                                                const gchar* filename,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_area_finish (BudgieScreenshotManager* self,
                                                       GAsyncResult* _res_,
                                                       gboolean* success,
                                                       gchar** filename_used,
                                                       GError** error);
static void budgie_screenshot_manager_screenshot_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void budgie_screenshot_manager_screenshot_area_data_free (gpointer _data);
static gboolean budgie_screenshot_manager_screenshot_area_co (BudgieScreenshotManagerScreenshotAreaData* _data_);
VALA_EXTERN void budgie_budgie_wm_set_redirection_mode (BudgieBudgieWM* self,
                                            gboolean enable);
static void budgie_screenshot_manager_wait_stage_repaint (BudgieScreenshotManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void budgie_screenshot_manager_wait_stage_repaint_finish (BudgieScreenshotManager* self,
                                                          GAsyncResult* _res_);
static void budgie_screenshot_manager_screenshot_area_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static cairo_surface_t* budgie_screenshot_manager_take_screenshot (BudgieScreenshotManager* self,
                                                            gint x,
                                                            gint y,
                                                            gint width,
                                                            gint height,
                                                            gboolean include_cursor);
static void budgie_screenshot_manager_save_image (BudgieScreenshotManager* self,
                                           cairo_surface_t* image,
                                           const gchar* filename,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean budgie_screenshot_manager_save_image_finish (BudgieScreenshotManager* self,
                                                      GAsyncResult* _res_,
                                                      gchar** used_filename);
static void budgie_screenshot_manager_screenshot_window_data_free (gpointer _data);
VALA_EXTERN void budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                  gboolean include_frame,
                                                  gboolean include_cursor,
                                                  gboolean flash,
                                                  const gchar* filename,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_window_finish (BudgieScreenshotManager* self,
                                                         GAsyncResult* _res_,
                                                         gboolean* success,
                                                         gchar** filename_used,
                                                         GError** error);
static gboolean budgie_screenshot_manager_screenshot_window_co (BudgieScreenshotManagerScreenshotWindowData* _data_);
static void budgie_screenshot_manager_screenshot_window_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static cairo_surface_t* budgie_screenshot_manager_composite_stage_cursor (BudgieScreenshotManager* self,
                                                                   cairo_surface_t* image,
                                                                   cairo_rectangle_int_t* image_rect);
static void budgie_screenshot_manager_save_image_data_free (gpointer _data);
static gboolean budgie_screenshot_manager_save_image_co (BudgieScreenshotManagerSaveImageData* _data_);
static void budgie_screenshot_manager_save_image_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void budgie_screenshot_manager_wait_stage_repaint_data_free (gpointer _data);
static gboolean budgie_screenshot_manager_wait_stage_repaint_co (BudgieScreenshotManagerWaitStageRepaintData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda13_ (Block6Data* _data6_);
static gboolean _budgie_screenshot_manager_wait_stage_repaint_co_gsource_func (gpointer self);
static void ___lambda13__clutter_stage_after_paint (ClutterStage* _sender,
                                             ClutterStageView* view,
                                             gpointer self);
static void budgie_screenshot_manager_finalize (GObject * obj);
static GType budgie_screenshot_manager_get_type_once (void);
static void _dbus_budgie_screenshot_manager_flash_area (BudgieScreenshotManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_area_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_);
static void _dbus_budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_window_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_);
static void budgie_screenshot_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* budgie_screenshot_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean budgie_screenshot_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _budgie_screenshot_manager_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_flash_area_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_flash_area_y = {-1, "y", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_flash_area_width = {-1, "width", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_flash_area_height = {-1, "height", "i", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_flash_area_in[] = {&_budgie_screenshot_manager_dbus_arg_info_flash_area_x, &_budgie_screenshot_manager_dbus_arg_info_flash_area_y, &_budgie_screenshot_manager_dbus_arg_info_flash_area_width, &_budgie_screenshot_manager_dbus_arg_info_flash_area_height, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_flash_area_out[] = {NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_flash_area = {-1, "FlashArea", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_flash_area_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_flash_area_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot = {-1, "Screenshot", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_y = {-1, "y", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_width = {-1, "width", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_height = {-1, "height", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_area_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_x, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_y, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_width, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_height, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_area_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot_area = {-1, "ScreenshotArea", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_frame = {-1, "include_frame", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_window_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_frame, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_window_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot_window = {-1, "ScreenshotWindow", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_out), NULL};
static const GDBusMethodInfo * const _budgie_screenshot_manager_dbus_method_info[] = {&_budgie_screenshot_manager_dbus_method_info_flash_area, &_budgie_screenshot_manager_dbus_method_info_screenshot, &_budgie_screenshot_manager_dbus_method_info_screenshot_area, &_budgie_screenshot_manager_dbus_method_info_screenshot_window, NULL};
static const GDBusSignalInfo * const _budgie_screenshot_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_screenshot_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_screenshot_manager_dbus_interface_info = {-1, "org.buddiesofbudgie.BudgieScreenshot", (GDBusMethodInfo **) (&_budgie_screenshot_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_screenshot_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_screenshot_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_screenshot_manager_dbus_interface_vtable = {budgie_screenshot_manager_dbus_interface_method_call, budgie_screenshot_manager_dbus_interface_get_property, budgie_screenshot_manager_dbus_interface_set_property};

static inline gpointer
budgie_screenshot_manager_get_instance_private (BudgieScreenshotManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieScreenshotManager_private_offset);
}

BudgieScreenshotManager*
budgie_screenshot_manager_init (BudgieBudgieWM* wm)
{
	BudgieScreenshotManager* _tmp0_;
	BudgieScreenshotManager* _tmp2_;
	BudgieScreenshotManager* result;
	g_return_val_if_fail (wm != NULL, NULL);
	_tmp0_ = budgie_screenshot_manager_instance;
	if (_tmp0_ == NULL) {
		BudgieScreenshotManager* _tmp1_;
		_tmp1_ = budgie_screenshot_manager_new (wm);
		_g_object_unref0 (budgie_screenshot_manager_instance);
		budgie_screenshot_manager_instance = _tmp1_;
	}
	_tmp2_ = budgie_screenshot_manager_instance;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static BudgieScreenshotManager*
budgie_screenshot_manager_construct (GType object_type,
                                     BudgieBudgieWM* _wm)
{
	BudgieScreenshotManager * self = NULL;
	BudgieBudgieWM* _tmp0_;
	BudgieBudgieWM* _tmp1_;
	MetaDisplay* _tmp2_;
	g_return_val_if_fail (_wm != NULL, NULL);
	self = (BudgieScreenshotManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (self->priv->wm);
	self->priv->wm = _tmp0_;
	_tmp1_ = self->priv->wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	self->priv->display = _tmp2_;
	return self;
}

static BudgieScreenshotManager*
budgie_screenshot_manager_new (BudgieBudgieWM* _wm)
{
	return budgie_screenshot_manager_construct (BUDGIE_TYPE_SCREENSHOT_MANAGER, _wm);
}

static void
_budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self)
{
	budgie_screenshot_manager_on_bus_acquired ((BudgieScreenshotManager*) self, connection);
}

static void
__lambda10_ (BudgieScreenshotManager* self)
{
}

static void
___lambda10__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda10_ ((BudgieScreenshotManager*) self);
}

static void
__lambda11_ (BudgieScreenshotManager* self)
{
}

static void
___lambda11__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda11_ ((BudgieScreenshotManager*) self);
}

void
budgie_screenshot_manager_setup_dbus (BudgieScreenshotManager* self)
{
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_DBUS_SCREENSHOT, G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda10__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda10__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda11__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda11__gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static void
budgie_screenshot_manager_on_bus_acquired (BudgieScreenshotManager* self,
                                           GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_screenshot_manager_register_object (self, conn, BUDGIE_DBUS_SCREENSHOT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_message ("screenshot.vala:54: Unable to register Screenshot: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BudgieScreenshotManager* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->top_display_group);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static void
__lambda12_ (Block5Data* _data5_,
             ClutterActor* actor)
{
	BudgieScreenshotManager* self;
	self = _data5_->self;
	g_return_if_fail (actor != NULL);
	clutter_actor_remove_child (_data5_->top_display_group, actor);
	clutter_actor_destroy (actor);
}

static void
___lambda12__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                  gpointer self)
{
	__lambda12_ (self, _sender);
}

void
budgie_screenshot_manager_flash_area (BudgieScreenshotManager* self,
                                      gint x,
                                      gint y,
                                      gint width,
                                      gint height,
                                      GError** error)
{
	Block5Data* _data5_;
	gdouble* keyframes = NULL;
	gdouble* _tmp0_;
	gint keyframes_length1;
	gint _keyframes_size_;
	GValue* values = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue* _tmp3_;
	gint values_length1;
	gint _values_size_;
	gboolean _tmp4_ = FALSE;
	ClutterKeyframeTransition* transition = NULL;
	ClutterKeyframeTransition* _tmp6_ = NULL;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	GValue* _tmp8_;
	gint _tmp8__length1;
	GValue _tmp9_ = {0};
	ClutterActor* flash_actor = NULL;
	ClutterActor* _tmp10_;
	MetaDisplay* _tmp11_;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gdouble, 2);
	_tmp0_[0] = (gdouble) 0.3f;
	_tmp0_[1] = (gdouble) 0.8f;
	keyframes = _tmp0_;
	keyframes_length1 = 2;
	_keyframes_size_ = keyframes_length1;
	g_value_init (&_tmp1_, G_TYPE_UINT);
	g_value_set_uint (&_tmp1_, 180U);
	g_value_init (&_tmp2_, G_TYPE_UINT);
	g_value_set_uint (&_tmp2_, 0U);
	_tmp3_ = g_new0 (GValue, 2);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	values = _tmp3_;
	values_length1 = 2;
	_values_size_ = values_length1;
	if (width >= 1) {
		_tmp4_ = height >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "flash area - Invalid sizing parameters");
		_inner_error0_ = _tmp5_;
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			keyframes = (g_free (keyframes), NULL);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			keyframes = (g_free (keyframes), NULL);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = (ClutterKeyframeTransition*) clutter_keyframe_transition_new ("opacity");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp6_, (guint) 200);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp6_, TRUE);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp6_, CLUTTER_LINEAR);
	transition = _tmp6_;
	_tmp7_ = keyframes;
	_tmp7__length1 = keyframes_length1;
	clutter_keyframe_transition_set_key_frames (transition, (guint) _tmp7__length1, _tmp7_);
	_tmp8_ = values;
	_tmp8__length1 = values_length1;
	clutter_keyframe_transition_set_values (transition, (guint) _tmp8__length1, _tmp8_);
	g_value_init (&_tmp9_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp9_, 0.0f);
	clutter_transition_set_to_value ((ClutterTransition*) transition, &_tmp9_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	_tmp10_ = clutter_actor_new ();
	g_object_ref_sink (_tmp10_);
	flash_actor = _tmp10_;
	clutter_actor_set_size (flash_actor, (gfloat) width, (gfloat) height);
	clutter_actor_set_position (flash_actor, (gfloat) x, (gfloat) y);
	clutter_actor_set_background_color (flash_actor, clutter_color_get_static (CLUTTER_COLOR_WHITE));
	clutter_actor_set_opacity (flash_actor, (guint8) 0);
	_tmp11_ = self->priv->display;
	_tmp12_ = meta_get_top_window_group_for_display (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_data5_->top_display_group = _tmp13_;
	g_signal_connect_data (flash_actor, "transitions-completed", (GCallback) ___lambda12__clutter_actor_transitions_completed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	clutter_actor_add_child (_data5_->top_display_group, flash_actor);
	clutter_actor_add_transition (flash_actor, "flash", (ClutterTransition*) transition);
	_g_object_unref0 (flash_actor);
	_g_object_unref0 (transition);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	keyframes = (g_free (keyframes), NULL);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
budgie_screenshot_manager_screenshot_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotData, _data_);
}

void
budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                      gboolean include_cursor,
                                      gboolean flash,
                                      const gchar* filename,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_co (_data_);
}

void
budgie_screenshot_manager_screenshot_finish (BudgieScreenshotManager* self,
                                             GAsyncResult* _res_,
                                             gboolean* success,
                                             gchar** filename_used,
                                             GError** error)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static void
budgie_screenshot_manager_screenshot_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_screenshot_manager_screenshot_co (_data_);
}

static gboolean
budgie_screenshot_manager_screenshot_co (BudgieScreenshotManagerScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->display;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = 0;
	meta_display_get_size (_data_->_tmp0_, &_data_->_tmp1_, &_data_->_tmp2_);
	_data_->width = _data_->_tmp1_;
	_data_->height = _data_->_tmp2_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp4_ = NULL;
	_data_->_state_ = 1;
	budgie_screenshot_manager_screenshot_area (_data_->self, 0, 0, _data_->width, _data_->height, _data_->include_cursor, _data_->flash, _data_->filename, budgie_screenshot_manager_screenshot_ready, _data_);
	return FALSE;
	_state_1:
	budgie_screenshot_manager_screenshot_area_finish (_data_->self, _data_->_res_, &_data_->_tmp3_, &_data_->_tmp4_, &_data_->_inner_error0_);
	_data_->success = _data_->_tmp3_;
	_g_free0 (_data_->filename_used);
	_data_->filename_used = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_screenshot_area_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotAreaData, _data_);
}

void
budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height,
                                           gboolean include_cursor,
                                           gboolean flash,
                                           const gchar* filename,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotAreaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_area_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->x = x;
	_data_->y = y;
	_data_->width = width;
	_data_->height = height;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_area_co (_data_);
}

void
budgie_screenshot_manager_screenshot_area_finish (BudgieScreenshotManager* self,
                                                  GAsyncResult* _res_,
                                                  gboolean* success,
                                                  gchar** filename_used,
                                                  GError** error)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static void
budgie_screenshot_manager_screenshot_area_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_screenshot_manager_screenshot_area_co (_data_);
}

static gboolean
budgie_screenshot_manager_screenshot_area_co (BudgieScreenshotManagerScreenshotAreaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->wm;
	_data_->existing_unredirect = _data_->_tmp0_->enable_unredirect;
	_data_->_tmp1_ = _data_->self->priv->wm;
	budgie_budgie_wm_set_redirection_mode (_data_->_tmp1_, FALSE);
	_data_->_state_ = 1;
	budgie_screenshot_manager_wait_stage_repaint (_data_->self, budgie_screenshot_manager_screenshot_area_ready, _data_);
	return FALSE;
	_state_1:
	budgie_screenshot_manager_wait_stage_repaint_finish (_data_->self, _data_->_res_);
	if (_data_->width >= 1) {
		_data_->_tmp2_ = _data_->height >= 1;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (!_data_->_tmp2_) {
		_data_->success = FALSE;
		_data_->_tmp3_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "screenshot_area Invalid sizing parameters");
		_data_->_inner_error0_ = _data_->_tmp3_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp4_ = budgie_screenshot_manager_take_screenshot (_data_->self, _data_->x, _data_->y, _data_->width, _data_->height, _data_->include_cursor);
	_data_->image = _data_->_tmp4_;
	if (_data_->flash) {
		budgie_screenshot_manager_flash_area (_data_->self, _data_->x, _data_->y, _data_->width, _data_->height, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_cairo_surface_destroy0 (_data_->image);
				_g_free0 (_data_->filename_used);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_cairo_surface_destroy0 (_data_->image);
				_g_free0 (_data_->filename_used);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp5_ = _data_->self->priv->wm;
	budgie_budgie_wm_set_redirection_mode (_data_->_tmp5_, _data_->existing_unredirect);
	_data_->_tmp6_ = _data_->image;
	_data_->_tmp7_ = NULL;
	_data_->_state_ = 2;
	budgie_screenshot_manager_save_image (_data_->self, _data_->_tmp6_, _data_->filename, budgie_screenshot_manager_screenshot_area_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp8_ = budgie_screenshot_manager_save_image_finish (_data_->self, _data_->_res_, &_data_->_tmp7_);
	_g_free0 (_data_->filename_used);
	_data_->filename_used = _data_->_tmp7_;
	_data_->success = _data_->_tmp8_;
	if (!_data_->success) {
		_data_->_tmp9_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to save image");
		_data_->_inner_error0_ = _data_->_tmp9_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_cairo_surface_destroy0 (_data_->image);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_cairo_surface_destroy0 (_data_->image);
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_cairo_surface_destroy0 (_data_->image);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_screenshot_window_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotWindowData, _data_);
}

void
budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                             gboolean include_frame,
                                             gboolean include_cursor,
                                             gboolean flash,
                                             const gchar* filename,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotWindowData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_window_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->include_frame = include_frame;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_window_co (_data_);
}

void
budgie_screenshot_manager_screenshot_window_finish (BudgieScreenshotManager* self,
                                                    GAsyncResult* _res_,
                                                    gboolean* success,
                                                    gchar** filename_used,
                                                    GError** error)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static void
budgie_screenshot_manager_screenshot_window_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_screenshot_manager_screenshot_window_co (_data_);
}

static gboolean
budgie_screenshot_manager_screenshot_window_co (BudgieScreenshotManagerScreenshotWindowData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->wm;
	_data_->existing_unredirect = _data_->_tmp0_->enable_unredirect;
	_data_->_tmp1_ = _data_->self->priv->wm;
	budgie_budgie_wm_set_redirection_mode (_data_->_tmp1_, FALSE);
	_data_->_state_ = 1;
	budgie_screenshot_manager_wait_stage_repaint (_data_->self, budgie_screenshot_manager_screenshot_window_ready, _data_);
	return FALSE;
	_state_1:
	budgie_screenshot_manager_wait_stage_repaint_finish (_data_->self, _data_->_res_);
	_data_->_tmp2_ = _data_->self->priv->display;
	_data_->_tmp3_ = meta_display_get_focus_window (_data_->_tmp2_);
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->window = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->window;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Cannot find active window");
		_data_->_inner_error0_ = _data_->_tmp6_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp7_ = _data_->window;
	if (meta_window_get_window_type (_data_->_tmp7_) == META_WINDOW_DESKTOP) {
		_data_->_tmp8_ = FALSE;
		_data_->_tmp9_ = NULL;
		_data_->_state_ = 2;
		budgie_screenshot_manager_screenshot (_data_->self, _data_->include_cursor, _data_->flash, _data_->filename, budgie_screenshot_manager_screenshot_window_ready, _data_);
		return FALSE;
		_state_2:
		budgie_screenshot_manager_screenshot_finish (_data_->self, _data_->_res_, &_data_->_tmp8_, &_data_->_tmp9_, &_data_->_inner_error0_);
		_data_->success = _data_->_tmp8_;
		_g_free0 (_data_->filename_used);
		_data_->filename_used = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->window);
				_g_free0 (_data_->filename_used);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->window);
				_g_free0 (_data_->filename_used);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->window);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->window;
	_data_->_tmp11_ = meta_window_get_compositor_private (_data_->_tmp10_);
	_data_->_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, meta_window_actor_get_type (), MetaWindowActor));
	_data_->window_actor = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->window_actor;
	_data_->_tmp14_ = 0.0F;
	_data_->_tmp15_ = 0.0F;
	clutter_actor_get_position ((ClutterActor*) _data_->_tmp13_, &_data_->_tmp14_, &_data_->_tmp15_);
	_data_->actor_x = _data_->_tmp14_;
	_data_->actor_y = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->window;
	memset (&_data_->_tmp17_, 0, sizeof (MetaRectangle));
	meta_window_get_frame_rect (_data_->_tmp16_, &_data_->_tmp17_);
	_data_->rect = _data_->_tmp17_;
	if (_data_->include_frame) {
		_data_->_tmp20_ = _data_->window;
		_data_->_tmp19_ = meta_window_is_client_decorated (_data_->_tmp20_);
	} else {
		_data_->_tmp19_ = FALSE;
	}
	if (_data_->_tmp19_) {
		_data_->_tmp18_ = TRUE;
	} else {
		if (!_data_->include_frame) {
			_data_->_tmp22_ = _data_->window;
			_data_->_tmp21_ = !meta_window_is_client_decorated (_data_->_tmp22_);
		} else {
			_data_->_tmp21_ = FALSE;
		}
		_data_->_tmp18_ = _data_->_tmp21_;
	}
	if (_data_->_tmp18_) {
		_data_->_tmp23_ = _data_->window;
		_data_->_tmp24_ = _data_->rect;
		memset (&_data_->_tmp25_, 0, sizeof (MetaRectangle));
		meta_window_frame_rect_to_client_rect (_data_->_tmp23_, &_data_->_tmp24_, &_data_->_tmp25_);
		_data_->rect = _data_->_tmp25_;
	}
	_data_->_tmp27_ = _data_->rect;
	if (_data_->_tmp27_.width >= 1) {
		_data_->_tmp28_ = _data_->rect;
		_data_->_tmp26_ = _data_->_tmp28_.height >= 1;
	} else {
		_data_->_tmp26_ = FALSE;
	}
	if (!_data_->_tmp26_) {
		_data_->_tmp29_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "screenshot_window Invalid sizing parameters");
		_data_->_inner_error0_ = _data_->_tmp29_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp30_ = _data_->rect;
	_data_->_tmp31_ = _data_->rect;
	_data_->_tmp32_ = _data_->rect;
	_data_->_tmp33_ = _data_->rect;
	memset (&_data_->_tmp34_, 0, sizeof (cairo_rectangle_int_t));
	_data_->_tmp34_.x = _data_->_tmp30_.x - ((gint) _data_->actor_x);
	_data_->_tmp34_.y = _data_->_tmp31_.y - ((gint) _data_->actor_y);
	_data_->_tmp34_.width = _data_->_tmp32_.width;
	_data_->_tmp34_.height = _data_->_tmp33_.height;
	_data_->clip = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->window_actor;
	_data_->_tmp36_ = _data_->clip;
	_data_->_tmp37_ = meta_window_actor_get_image (_data_->_tmp35_, &_data_->_tmp36_);
	_data_->image = (cairo_surface_t*) _data_->_tmp37_;
	_data_->_tmp38_ = _data_->image;
	if (_data_->_tmp38_ == NULL) {
		_data_->_tmp39_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to get image from the focus window");
		_data_->_inner_error0_ = _data_->_tmp39_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_cairo_surface_destroy0 (_data_->image);
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_cairo_surface_destroy0 (_data_->image);
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->include_cursor) {
		_data_->_tmp40_ = _data_->image;
		_data_->_tmp41_ = _data_->rect;
		_data_->_tmp42_ = _data_->rect;
		_data_->_tmp43_ = _data_->rect;
		_data_->_tmp44_ = _data_->rect;
		memset (&_data_->_tmp45_, 0, sizeof (cairo_rectangle_int_t));
		_data_->_tmp45_.x = _data_->_tmp41_.x;
		_data_->_tmp45_.y = _data_->_tmp42_.y;
		_data_->_tmp45_.width = _data_->_tmp43_.width;
		_data_->_tmp45_.height = _data_->_tmp44_.height;
		_data_->_tmp46_ = budgie_screenshot_manager_composite_stage_cursor (_data_->self, _data_->_tmp40_, &_data_->_tmp45_);
		_cairo_surface_destroy0 (_data_->image);
		_data_->image = _data_->_tmp46_;
	}
	if (_data_->flash) {
		_data_->_tmp47_ = _data_->rect;
		_data_->_tmp48_ = _data_->rect;
		_data_->_tmp49_ = _data_->rect;
		_data_->_tmp50_ = _data_->rect;
		budgie_screenshot_manager_flash_area (_data_->self, _data_->_tmp47_.x, _data_->_tmp48_.y, _data_->_tmp49_.width, _data_->_tmp50_.height, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_cairo_surface_destroy0 (_data_->image);
				_g_object_unref0 (_data_->window_actor);
				_g_object_unref0 (_data_->window);
				_g_free0 (_data_->filename_used);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_cairo_surface_destroy0 (_data_->image);
				_g_object_unref0 (_data_->window_actor);
				_g_object_unref0 (_data_->window);
				_g_free0 (_data_->filename_used);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp51_ = _data_->self->priv->wm;
	budgie_budgie_wm_set_redirection_mode (_data_->_tmp51_, _data_->existing_unredirect);
	_data_->_tmp52_ = _data_->image;
	_data_->_tmp53_ = NULL;
	_data_->_state_ = 3;
	budgie_screenshot_manager_save_image (_data_->self, _data_->_tmp52_, _data_->filename, budgie_screenshot_manager_screenshot_window_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp54_ = budgie_screenshot_manager_save_image_finish (_data_->self, _data_->_res_, &_data_->_tmp53_);
	_g_free0 (_data_->filename_used);
	_data_->filename_used = _data_->_tmp53_;
	_data_->success = _data_->_tmp54_;
	if (!_data_->success) {
		_data_->_tmp55_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to save image");
		_data_->_inner_error0_ = _data_->_tmp55_;
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_cairo_surface_destroy0 (_data_->image);
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_cairo_surface_destroy0 (_data_->image);
			_g_object_unref0 (_data_->window_actor);
			_g_object_unref0 (_data_->window);
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_cairo_surface_destroy0 (_data_->image);
	_g_object_unref0 (_data_->window_actor);
	_g_object_unref0 (_data_->window);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_save_image_data_free (gpointer _data)
{
	BudgieScreenshotManagerSaveImageData* _data_;
	_data_ = _data;
	_cairo_surface_destroy0 (_data_->image);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerSaveImageData, _data_);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static void
budgie_screenshot_manager_save_image (BudgieScreenshotManager* self,
                                      cairo_surface_t* image,
                                      const gchar* filename,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BudgieScreenshotManagerSaveImageData* _data_;
	BudgieScreenshotManager* _tmp0_;
	cairo_surface_t* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerSaveImageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_save_image_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _cairo_surface_reference0 (image);
	_cairo_surface_destroy0 (_data_->image);
	_data_->image = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	budgie_screenshot_manager_save_image_co (_data_);
}

static gboolean
budgie_screenshot_manager_save_image_finish (BudgieScreenshotManager* self,
                                             GAsyncResult* _res_,
                                             gchar** used_filename)
{
	gboolean result;
	BudgieScreenshotManagerSaveImageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (used_filename) {
		*used_filename = _data_->used_filename;
	} else {
		_g_free0 (_data_->used_filename);
	}
	_data_->used_filename = NULL;
	result = _data_->result;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static void
budgie_screenshot_manager_save_image_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	BudgieScreenshotManagerSaveImageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_screenshot_manager_save_image_co (_data_);
}

static gboolean
budgie_screenshot_manager_save_image_co (BudgieScreenshotManagerSaveImageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup (_data_->filename);
	_g_free0 (_data_->used_filename);
	_data_->used_filename = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->used_filename;
	if (g_strcmp0 (_data_->_tmp2_, "") != 0) {
		_data_->_tmp3_ = _data_->used_filename;
		_data_->_tmp1_ = !g_path_is_absolute (_data_->_tmp3_);
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp4_ = _data_->used_filename;
		if (!g_str_has_suffix (_data_->_tmp4_, BUDGIE_EXTENSION)) {
			_data_->_tmp5_ = _data_->used_filename;
			_data_->_tmp6_ = g_strconcat (_data_->_tmp5_, BUDGIE_EXTENSION, NULL);
			_g_free0 (_data_->used_filename);
			_data_->used_filename = _data_->_tmp6_;
		}
		_data_->_tmp7_ = _data_->self->priv->wm;
		_data_->_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _data_->_tmp7_);
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
		_data_->display = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->display;
		_data_->_tmp11_ = meta_display_get_context (_data_->_tmp10_);
		_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
		_data_->ctx = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->ctx;
		_data_->_tmp14_ = meta_context_get_backend (_data_->_tmp13_);
		_data_->_tmp15_ = meta_backend_get_settings (_data_->_tmp14_);
		_data_->scale_factor = meta_settings_get_ui_scaling_factor (_data_->_tmp15_);
		if (_data_->scale_factor > 1) {
			_data_->_tmp16_ = strlen (BUDGIE_EXTENSION);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->scale_pos = -_data_->_tmp17_;
			_data_->_tmp18_ = _data_->used_filename;
			_data_->_tmp19_ = g_strdup_printf ("@%ix", _data_->scale_factor);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = string_splice (_data_->_tmp18_, (glong) _data_->scale_pos, (glong) _data_->scale_pos, _data_->_tmp20_);
			_g_free0 (_data_->used_filename);
			_data_->used_filename = _data_->_tmp21_;
			_g_free0 (_data_->_tmp20_);
		}
		_data_->_tmp22_ = g_get_tmp_dir ();
		_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
		_data_->path = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->path;
		_data_->_tmp25_ = _data_->used_filename;
		_data_->_tmp26_ = g_build_filename (_data_->_tmp24_, _data_->_tmp25_, NULL, NULL);
		_g_free0 (_data_->used_filename);
		_data_->used_filename = _data_->_tmp26_;
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->ctx);
		_g_object_unref0 (_data_->display);
	}
	{
		_data_->_tmp27_ = gdk_pixbuf_get_from_surface (_data_->image, 0, 0, cairo_image_surface_get_width (_data_->image), cairo_image_surface_get_height (_data_->image));
		_data_->screenshot = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->screenshot;
		if (_data_->_tmp28_ == NULL) {
			_data_->_tmp29_ = g_error_new ((GQuark) 0, 1, "Invalid surface image to get pixbuf from");
			_data_->_inner_error0_ = _data_->_tmp29_;
			_g_object_unref0 (_data_->screenshot);
			goto __catch0_g_error;
		}
		_data_->_tmp30_ = _data_->used_filename;
		if (g_strcmp0 (_data_->_tmp30_, "") == 0) {
			_data_->_tmp31_ = _data_->self->priv->display;
			_data_->_tmp32_ = meta_display_get_selection (_data_->_tmp31_);
			_data_->_tmp33_ = _g_object_ref0 (_data_->_tmp32_);
			_data_->selection = _data_->_tmp33_;
			_data_->_tmp34_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
			_data_->stream = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->screenshot;
			_data_->_tmp36_ = _data_->stream;
			_data_->_state_ = 1;
			gdk_pixbuf_save_to_stream_async (_data_->_tmp35_, (GOutputStream*) _data_->_tmp36_, "png", NULL, budgie_screenshot_manager_save_image_ready, _data_, NULL);
			return FALSE;
			_state_1:
			gdk_pixbuf_save_to_stream_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				_g_object_unref0 (_data_->selection);
				_g_object_unref0 (_data_->screenshot);
				goto __catch0_g_error;
			}
			_data_->_tmp37_ = _data_->stream;
			g_output_stream_close ((GOutputStream*) _data_->_tmp37_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				_g_object_unref0 (_data_->selection);
				_g_object_unref0 (_data_->screenshot);
				goto __catch0_g_error;
			}
			_data_->_tmp38_ = _data_->stream;
			_data_->_tmp39_ = g_memory_output_stream_steal_as_bytes (_data_->_tmp38_);
			_data_->_tmp40_ = _data_->_tmp39_;
			_data_->_tmp41_ = (MetaSelectionSourceMemory*) meta_selection_source_memory_new ("image/png", _data_->_tmp40_);
			_data_->_tmp42_ = _data_->_tmp41_;
			_g_bytes_unref0 (_data_->_tmp40_);
			_data_->source = _data_->_tmp42_;
			_data_->_tmp43_ = _data_->selection;
			_data_->_tmp44_ = _data_->source;
			meta_selection_set_owner (_data_->_tmp43_, META_SELECTION_CLIPBOARD, (MetaSelectionSource*) _data_->_tmp44_);
			_g_object_unref0 (_data_->source);
			_g_object_unref0 (_data_->stream);
			_g_object_unref0 (_data_->selection);
		} else {
			_data_->_tmp45_ = _data_->used_filename;
			_data_->_tmp46_ = g_file_new_for_path (_data_->_tmp45_);
			_data_->file = _data_->_tmp46_;
			_data_->_tmp47_ = _data_->file;
			if (g_file_query_exists (_data_->_tmp47_, NULL)) {
				_data_->_tmp49_ = _data_->file;
				_data_->_state_ = 2;
				g_file_open_readwrite_async (_data_->_tmp49_, (gint) G_FILE_CREATE_NONE, NULL, budgie_screenshot_manager_save_image_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp50_ = g_file_open_readwrite_finish (_data_->_tmp49_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp48_ = _data_->_tmp50_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->_vala1_stream);
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->screenshot);
					goto __catch0_g_error;
				}
				_data_->_tmp51_ = _data_->_tmp48_;
				_data_->_tmp48_ = NULL;
				_g_object_unref0 (_data_->_vala1_stream);
				_data_->_vala1_stream = _data_->_tmp51_;
				_g_object_unref0 (_data_->_tmp48_);
			} else {
				_data_->_tmp53_ = _data_->file;
				_data_->_state_ = 3;
				g_file_create_readwrite_async (_data_->_tmp53_, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, NULL, budgie_screenshot_manager_save_image_ready, _data_);
				return FALSE;
				_state_3:
				_data_->_tmp54_ = g_file_create_readwrite_finish (_data_->_tmp53_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp52_ = _data_->_tmp54_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->_vala1_stream);
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->screenshot);
					goto __catch0_g_error;
				}
				_data_->_tmp55_ = _data_->_tmp52_;
				_data_->_tmp52_ = NULL;
				_g_object_unref0 (_data_->_vala1_stream);
				_data_->_vala1_stream = _data_->_tmp55_;
				_g_object_unref0 (_data_->_tmp52_);
			}
			_data_->_tmp56_ = _data_->screenshot;
			_data_->_tmp57_ = _data_->_vala1_stream;
			_data_->_tmp58_ = g_io_stream_get_output_stream ((GIOStream*) _data_->_tmp57_);
			_data_->_tmp59_ = _data_->_tmp58_;
			_data_->_state_ = 4;
			gdk_pixbuf_save_to_stream_async (_data_->_tmp56_, _data_->_tmp59_, "png", NULL, budgie_screenshot_manager_save_image_ready, _data_, NULL);
			return FALSE;
			_state_4:
			gdk_pixbuf_save_to_stream_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_vala1_stream);
				_g_object_unref0 (_data_->file);
				_g_object_unref0 (_data_->screenshot);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->_vala1_stream);
			_g_object_unref0 (_data_->file);
		}
		_data_->result = TRUE;
		_g_object_unref0 (_data_->screenshot);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp60_ = _data_->e;
		_data_->_tmp61_ = _data_->_tmp60_->message;
		if (_data_->_tmp61_ != NULL) {
			_data_->_tmp62_ = _data_->e;
			_data_->_tmp63_ = _data_->_tmp62_->message;
			g_warning ("screenshot.vala:222: could not save file: %s", _data_->_tmp63_);
		}
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_free0 (_data_->used_filename);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static cairo_surface_t*
budgie_screenshot_manager_take_screenshot (BudgieScreenshotManager* self,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height,
                                           gboolean include_cursor)
{
	cairo_surface_t* image = NULL;
	gint image_width = 0;
	gint image_height = 0;
	gfloat scale = 0.0F;
	ClutterStage* stage = NULL;
	MetaDisplay* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterStage* _tmp2_;
	ClutterStage* _tmp3_;
	cairo_rectangle_int_t _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gfloat _tmp7_ = 0.0F;
	cairo_surface_t* _tmp8_;
	ClutterPaintFlag paint_flags = 0U;
	gboolean is_little_endian = FALSE;
	cairo_surface_t* _tmp18_ = NULL;
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_get_stage_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, clutter_stage_get_type ()) ? ((ClutterStage*) _tmp1_) : NULL);
	stage = _tmp2_;
	_tmp3_ = stage;
	_tmp4_.x = x;
	_tmp4_.y = y;
	_tmp4_.width = width;
	_tmp4_.height = height;
	clutter_stage_get_capture_final_size (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	image_width = _tmp5_;
	image_height = _tmp6_;
	scale = _tmp7_;
	_tmp8_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, image_width, image_height);
	_cairo_surface_destroy0 (image);
	image = _tmp8_;
	paint_flags = CLUTTER_PAINT_FLAG_CLEAR | CLUTTER_PAINT_FLAG_NO_CURSORS;
	is_little_endian = G_BYTE_ORDER == G_LITTLE_ENDIAN;
	{
		CoglPixelFormat _tmp9_ = 0U;
		ClutterStage* _tmp10_;
		cairo_rectangle_int_t _tmp11_ = {0};
		cairo_surface_t* _tmp12_;
		guchar* _tmp13_;
		cairo_surface_t* _tmp14_;
		if (is_little_endian) {
			_tmp9_ = COGL_PIXEL_FORMAT_BGRA_8888_PRE;
		} else {
			_tmp9_ = COGL_PIXEL_FORMAT_ARGB_8888_PRE;
		}
		_tmp10_ = stage;
		_tmp11_.x = x;
		_tmp11_.y = y;
		_tmp11_.width = width;
		_tmp11_.height = height;
		_tmp12_ = image;
		_tmp13_ = cairo_image_surface_get_data (_tmp12_);
		_tmp14_ = image;
		clutter_stage_paint_to_buffer (_tmp10_, &_tmp11_, scale, _tmp13_, cairo_image_surface_get_stride (_tmp14_), _tmp9_, paint_flags, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (is_little_endian) {
			_tmp15_ = "BGRA";
		} else {
			_tmp15_ = "RGBA";
		}
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_message ("screenshot.vala:253: Unable to paint_to_buffer (%s): %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (stage);
		_cairo_surface_destroy0 (image);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (include_cursor) {
		cairo_surface_t* _tmp19_;
		cairo_rectangle_int_t _tmp20_ = {0};
		cairo_surface_t* _tmp21_;
		_tmp19_ = image;
		_tmp20_.x = x;
		_tmp20_.y = y;
		_tmp20_.width = width;
		_tmp20_.height = height;
		_tmp21_ = budgie_screenshot_manager_composite_stage_cursor (self, _tmp19_, &_tmp20_);
		_cairo_surface_destroy0 (_tmp18_);
		_tmp18_ = _tmp21_;
	} else {
		cairo_surface_t* _tmp22_;
		cairo_surface_t* _tmp23_;
		_tmp22_ = image;
		_tmp23_ = _cairo_surface_reference0 (_tmp22_);
		_cairo_surface_destroy0 (_tmp18_);
		_tmp18_ = _tmp23_;
	}
	result = _tmp18_;
	_g_object_unref0 (stage);
	_cairo_surface_destroy0 (image);
	return result;
}

static cairo_surface_t*
budgie_screenshot_manager_composite_stage_cursor (BudgieScreenshotManager* self,
                                                  cairo_surface_t* image,
                                                  cairo_rectangle_int_t* image_rect)
{
	graphene_point_t coords = {0};
	graphene_point_t _tmp0_ = {0};
	gint xhot = 0;
	gint yhot = 0;
	MetaCursorTracker* cursor_tracker = NULL;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* _tmp2_;
	CoglTexture* texture = NULL;
	MetaCursorTracker* _tmp3_;
	CoglTexture* _tmp4_;
	CoglTexture* _tmp5_;
	cairo_region_t* region = NULL;
	cairo_rectangle_int_t _tmp7_;
	cairo_region_t* _tmp8_;
	MetaCursorTracker* _tmp9_;
	graphene_point_t _tmp10_ = {0};
	cairo_region_t* _tmp11_;
	graphene_point_t _tmp12_;
	graphene_point_t _tmp13_;
	MetaCursorTracker* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint width = 0;
	CoglTexture* _tmp18_;
	gint height = 0;
	CoglTexture* _tmp19_;
	guint8* data = NULL;
	guint8* _tmp20_;
	gint data_length1;
	gint _data_size_;
	CoglTexture* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	cairo_surface_t* cursor_image = NULL;
	guint8* _tmp23_;
	gint _tmp23__length1;
	cairo_surface_t* _tmp24_;
	cairo_surface_t* target = NULL;
	cairo_rectangle_int_t _tmp25_;
	cairo_rectangle_int_t _tmp26_;
	cairo_surface_t* _tmp27_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_surface_t* _tmp35_;
	graphene_point_t _tmp36_;
	cairo_rectangle_int_t _tmp37_;
	graphene_point_t _tmp38_;
	cairo_rectangle_int_t _tmp39_;
	cairo_t* _tmp40_;
	cairo_t* _tmp41_;
	cairo_surface_t* _tmp42_;
	cairo_surface_t* _tmp43_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image != NULL, NULL);
	g_return_val_if_fail (image_rect != NULL, NULL);
	coords = _tmp0_;
	_tmp1_ = self->priv->display;
	_tmp2_ = meta_cursor_tracker_get_for_display (_tmp1_);
	cursor_tracker = _tmp2_;
	_tmp3_ = cursor_tracker;
	_tmp4_ = meta_cursor_tracker_get_sprite (_tmp3_);
	texture = _tmp4_;
	_tmp5_ = texture;
	if (_tmp5_ == NULL) {
		cairo_surface_t* _tmp6_;
		_tmp6_ = _cairo_surface_reference0 (image);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = *image_rect;
	_tmp8_ = cairo_region_create_rectangle (&_tmp7_);
	region = _tmp8_;
	_tmp9_ = cursor_tracker;
	meta_cursor_tracker_get_pointer (_tmp9_, &_tmp10_, NULL);
	coords = _tmp10_;
	_tmp11_ = region;
	_tmp12_ = coords;
	_tmp13_ = coords;
	if (!cairo_region_contains_point (_tmp11_, (gint) _tmp12_.x, (gint) _tmp13_.y)) {
		cairo_surface_t* _tmp14_;
		_tmp14_ = _cairo_surface_reference0 (image);
		result = _tmp14_;
		_cairo_region_destroy0 (region);
		return result;
	}
	_tmp15_ = cursor_tracker;
	meta_cursor_tracker_get_hot (_tmp15_, &_tmp16_, &_tmp17_);
	xhot = _tmp16_;
	yhot = _tmp17_;
	_tmp18_ = texture;
	width = (gint) cogl_texture_get_width (_tmp18_);
	_tmp19_ = texture;
	height = (gint) cogl_texture_get_height (_tmp19_);
	_tmp20_ = g_new0 (guint8, (width * height) * 4);
	data = _tmp20_;
	data_length1 = (width * height) * 4;
	_data_size_ = data_length1;
	_tmp21_ = texture;
	_tmp22_ = data;
	_tmp22__length1 = data_length1;
	cogl_texture_get_data (_tmp21_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) 0, _tmp22_);
	_tmp23_ = data;
	_tmp23__length1 = data_length1;
	_tmp24_ = cairo_image_surface_create_for_data (_tmp23_, CAIRO_FORMAT_ARGB32, width, height, width * 4);
	cursor_image = _tmp24_;
	_tmp25_ = *image_rect;
	_tmp26_ = *image_rect;
	_tmp27_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp25_.width, _tmp26_.height);
	target = _tmp27_;
	_tmp28_ = target;
	_tmp29_ = cairo_create (_tmp28_);
	cr = _tmp29_;
	_tmp30_ = cr;
	cairo_set_operator (_tmp30_, CAIRO_OPERATOR_OVER);
	cairo_surface_mark_dirty (image);
	_tmp31_ = cr;
	cairo_set_source_surface (_tmp31_, image, (gdouble) 0, (gdouble) 0);
	_tmp32_ = cr;
	cairo_paint (_tmp32_);
	_tmp33_ = cr;
	cairo_set_operator (_tmp33_, CAIRO_OPERATOR_OVER);
	_tmp34_ = cr;
	_tmp35_ = cursor_image;
	_tmp36_ = coords;
	_tmp37_ = *image_rect;
	_tmp38_ = coords;
	_tmp39_ = *image_rect;
	cairo_set_source_surface (_tmp34_, _tmp35_, (gdouble) ((_tmp36_.x - _tmp37_.x) - xhot), (gdouble) ((_tmp38_.y - _tmp39_.y) - yhot));
	_tmp40_ = cr;
	cairo_paint (_tmp40_);
	_tmp41_ = cr;
	_tmp42_ = cairo_get_target (_tmp41_);
	_tmp43_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp42_);
	result = _tmp43_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (target);
	_cairo_surface_destroy0 (cursor_image);
	data = (g_free (data), NULL);
	_cairo_region_destroy0 (region);
	return result;
}

static void
budgie_screenshot_manager_wait_stage_repaint_data_free (gpointer _data)
{
	BudgieScreenshotManagerWaitStageRepaintData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerWaitStageRepaintData, _data_);
}

static void
budgie_screenshot_manager_wait_stage_repaint (BudgieScreenshotManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	BudgieScreenshotManagerWaitStageRepaintData* _data_;
	BudgieScreenshotManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerWaitStageRepaintData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_wait_stage_repaint_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_screenshot_manager_wait_stage_repaint_co (_data_);
}

static void
budgie_screenshot_manager_wait_stage_repaint_finish (BudgieScreenshotManager* self,
                                                     GAsyncResult* _res_)
{
	BudgieScreenshotManagerWaitStageRepaintData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BudgieScreenshotManager* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->stage);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
_budgie_screenshot_manager_wait_stage_repaint_co_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_screenshot_manager_wait_stage_repaint_co (self);
	return result;
}

static void
__lambda13_ (Block6Data* _data6_)
{
	BudgieScreenshotManager* self;
	self = _data6_->self;
	g_signal_handler_disconnect ((GObject*) _data6_->stage, _data6_->signal_id);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_screenshot_manager_wait_stage_repaint_co_gsource_func, _data6_->_async_data_, NULL);
}

static void
___lambda13__clutter_stage_after_paint (ClutterStage* _sender,
                                        ClutterStageView* view,
                                        gpointer self)
{
	__lambda13_ (self);
}

static gboolean
budgie_screenshot_manager_wait_stage_repaint_co (BudgieScreenshotManagerWaitStageRepaintData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_data6_->signal_id = 0UL;
	_data_->_tmp0_ = _data_->self->priv->display;
	_data_->_tmp1_ = meta_get_stage_for_display (_data_->_tmp0_);
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, clutter_stage_get_type ()) ? ((ClutterStage*) _data_->_tmp1_) : NULL);
	_data_->_data6_->stage = _data_->_tmp2_;
	_data_->_tmp3_ = g_signal_connect_data (_data_->_data6_->stage, "after-paint", (GCallback) ___lambda13__clutter_stage_after_paint, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
	_data_->_data6_->signal_id = _data_->_tmp3_;
	clutter_actor_queue_redraw ((ClutterActor*) _data_->_data6_->stage);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_class_init (BudgieScreenshotManagerClass * klass,
                                      gpointer klass_data)
{
	budgie_screenshot_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieScreenshotManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_screenshot_manager_finalize;
}

static void
budgie_screenshot_manager_instance_init (BudgieScreenshotManager * self,
                                         gpointer klass)
{
	self->priv = budgie_screenshot_manager_get_instance_private (self);
	self->priv->wm = NULL;
	self->priv->display = NULL;
}

static void
budgie_screenshot_manager_finalize (GObject * obj)
{
	BudgieScreenshotManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManager);
	_g_object_unref0 (self->priv->wm);
	G_OBJECT_CLASS (budgie_screenshot_manager_parent_class)->finalize (obj);
}

static GType
budgie_screenshot_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenshotManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screenshot_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreenshotManager), 0, (GInstanceInitFunc) budgie_screenshot_manager_instance_init, NULL };
	GType budgie_screenshot_manager_type_id;
	budgie_screenshot_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieScreenshotManager", &g_define_type_info, 0);
	g_type_set_qdata (budgie_screenshot_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_screenshot_manager_register_object);
	BudgieScreenshotManager_private_offset = g_type_add_instance_private (budgie_screenshot_manager_type_id, sizeof (BudgieScreenshotManagerPrivate));
	return budgie_screenshot_manager_type_id;
}

GType
budgie_screenshot_manager_get_type (void)
{
	static volatile gsize budgie_screenshot_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_screenshot_manager_type_id__once)) {
		GType budgie_screenshot_manager_type_id;
		budgie_screenshot_manager_type_id = budgie_screenshot_manager_get_type_once ();
		g_once_init_leave (&budgie_screenshot_manager_type_id__once, budgie_screenshot_manager_type_id);
	}
	return budgie_screenshot_manager_type_id__once;
}

static void
_dbus_budgie_screenshot_manager_flash_area (BudgieScreenshotManager* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp86_;
	gint y = 0;
	GVariant* _tmp87_;
	gint width = 0;
	GVariant* _tmp88_;
	gint height = 0;
	GVariant* _tmp89_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp86_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp86_);
	g_variant_unref (_tmp86_);
	_tmp87_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp87_);
	g_variant_unref (_tmp87_);
	_tmp88_ = g_variant_iter_next_value (&_arguments_iter);
	width = g_variant_get_int32 (_tmp88_);
	g_variant_unref (_tmp88_);
	_tmp89_ = g_variant_iter_next_value (&_arguments_iter);
	height = g_variant_get_int32 (_tmp89_);
	g_variant_unref (_tmp89_);
	budgie_screenshot_manager_flash_area (self, x, y, width, height, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotReadyData* _ready_data;
	GVariant* _tmp90_;
	GVariant* _tmp91_;
	GVariant* _tmp92_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp90_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp90_);
	g_variant_unref (_tmp90_);
	_tmp91_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp91_);
	g_variant_unref (_tmp91_);
	_tmp92_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp92_, NULL);
	g_variant_unref (_tmp92_);
	budgie_screenshot_manager_screenshot (self, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotReadyData, _ready_data);
}

static void
_dbus_budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotAreaReadyData* _ready_data;
	GVariant* _tmp93_;
	GVariant* _tmp94_;
	GVariant* _tmp95_;
	GVariant* _tmp96_;
	GVariant* _tmp97_;
	GVariant* _tmp98_;
	GVariant* _tmp99_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotAreaReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp93_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->x = g_variant_get_int32 (_tmp93_);
	g_variant_unref (_tmp93_);
	_tmp94_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->y = g_variant_get_int32 (_tmp94_);
	g_variant_unref (_tmp94_);
	_tmp95_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->width = g_variant_get_int32 (_tmp95_);
	g_variant_unref (_tmp95_);
	_tmp96_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->height = g_variant_get_int32 (_tmp96_);
	g_variant_unref (_tmp96_);
	_tmp97_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp97_);
	g_variant_unref (_tmp97_);
	_tmp98_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp98_);
	g_variant_unref (_tmp98_);
	_tmp99_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp99_, NULL);
	g_variant_unref (_tmp99_);
	budgie_screenshot_manager_screenshot_area (self, _ready_data->x, _ready_data->y, _ready_data->width, _ready_data->height, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_area_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_area_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotAreaReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_area_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotAreaReadyData, _ready_data);
}

static void
_dbus_budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotWindowReadyData* _ready_data;
	GVariant* _tmp100_;
	GVariant* _tmp101_;
	GVariant* _tmp102_;
	GVariant* _tmp103_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotWindowReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp100_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_frame = g_variant_get_boolean (_tmp100_);
	g_variant_unref (_tmp100_);
	_tmp101_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp101_);
	g_variant_unref (_tmp101_);
	_tmp102_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp102_);
	g_variant_unref (_tmp102_);
	_tmp103_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp103_, NULL);
	g_variant_unref (_tmp103_);
	budgie_screenshot_manager_screenshot_window (self, _ready_data->include_frame, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_window_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_window_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotWindowReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_window_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotWindowReadyData, _ready_data);
}

static void
budgie_screenshot_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FlashArea") == 0) {
		_dbus_budgie_screenshot_manager_flash_area (object, parameters, invocation);
	} else if (strcmp (method_name, "Screenshot") == 0) {
		_dbus_budgie_screenshot_manager_screenshot (object, parameters, invocation);
	} else if (strcmp (method_name, "ScreenshotArea") == 0) {
		_dbus_budgie_screenshot_manager_screenshot_area (object, parameters, invocation);
	} else if (strcmp (method_name, "ScreenshotWindow") == 0) {
		_dbus_budgie_screenshot_manager_screenshot_window (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_screenshot_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_screenshot_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_screenshot_manager_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_screenshot_manager_dbus_interface_info), &_budgie_screenshot_manager_dbus_interface_vtable, data, _budgie_screenshot_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_screenshot_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

