/* mpris_gui.c generated by valac 0.56.14, the Vala compiler
 * generated from mpris_gui.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include "org.buddiesofbudgie.budgie-desktop.raven.widget.MediaControls.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define BACKGROUND_SIZE 250

enum  {
	MPRIS_CLIENT_WIDGET_0_PROPERTY,
	MPRIS_CLIENT_WIDGET_NUM_PROPERTIES
};
static GParamSpec* mpris_client_widget_properties[MPRIS_CLIENT_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MprisClientWidgetDownloadArtData MprisClientWidgetDownloadArtData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _MprisClientWidgetPrivate {
	GtkBox* header;
	GtkImage* header_icon;
	GtkLabel* header_label;
	GtkButton* header_reveal_button;
	GtkButton* header_close_button;
	GtkRevealer* content_revealer;
	GtkImage* background;
	GtkEventBox* background_wrap;
	MprisClient* client;
	GtkLabel* title_label;
	GtkLabel* artist_label;
	GtkLabel* album_label;
	GtkButton* prev_btn;
	GtkButton* play_btn;
	GtkButton* next_btn;
	gchar* filename;
	GCancellable* cancel;
	gint our_width;
};

struct _Block2Data {
	int _ref_count_;
	MprisClientWidget* self;
	MprisClient* client;
};

struct _MprisClientWidgetDownloadArtData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MprisClientWidget* self;
	gchar* uri;
	gchar* proper_uri;
	gchar* _tmp0_;
	GFile* art_file;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* ins;
	GFile* _tmp3_;
	GCancellable* _tmp4_;
	GFileInputStream* _tmp5_;
	GdkPixbuf* pbuf;
	GFileInputStream* _tmp6_;
	GCancellable* _tmp7_;
	GdkPixbuf* _tmp8_;
	GtkImage* _tmp9_;
	GdkPixbuf* _tmp10_;
	GtkStyleContext* _tmp11_;
	GError* _inner_error0_;
};

static gint MprisClientWidget_private_offset;
static gpointer mpris_client_widget_parent_class = NULL;
static GType mpris_client_widget_type_id = 0;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean mpris_client_widget_on_raise_player (MprisClientWidget* self);
static gboolean _mpris_client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                               GdkEventButton* event,
                                                                               gpointer self);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda6_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda6__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda7_ (Block2Data* _data2_);
static void __lambda8_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda10_ (Block2Data* _data2_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda10__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void mpris_client_widget_update_play_status (MprisClientWidget* self);
static void mpris_client_widget_update_controls (MprisClientWidget* self);
static void __lambda11_ (MprisClientWidget* self,
                  const gchar* i,
                  GHashTable* p,
                  gchar** inv,
                  gint inv_length1);
static void ___lambda12_ (MprisClientWidget* self,
                   const gchar* k,
                   GVariant* v);
static void ____lambda12__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void ___lambda11__mpris_dbus_prop_iface_properties_changed (MprisDbusPropIface* _sender,
                                                            const gchar* iface,
                                                            GHashTable* changed,
                                                            gchar** invalid,
                                                            gint invalid_length1,
                                                            gpointer self);
static void __lambda13_ (MprisClientWidget* self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void ___lambda14_ (Block2Data* _data2_);
static void ___lambda15_ (Block2Data* _data2_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda15__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ____lambda14__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void mpris_client_widget_update_art (MprisClientWidget* self,
                                     const gchar* uri,
                                     gboolean force_reload);
static void __lambda4_ (MprisClientWidget* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void mpris_client_widget_download_art (MprisClientWidget* self,
                                       const gchar* uri,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void mpris_client_widget_download_art_finish (MprisClientWidget* self,
                                              GAsyncResult* _res_);
static void mpris_client_widget_update_art_fallback (MprisClientWidget* self);
static void mpris_client_widget_download_art_data_free (gpointer _data);
static gboolean mpris_client_widget_download_art_co (MprisClientWidgetDownloadArtData* _data_);
static void mpris_client_widget_download_art_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static gchar* mpris_client_widget_get_meta_string (MprisClientWidget* self,
                                            const gchar* key,
                                            const gchar* fallback);
static void mpris_client_widget_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mpris_client_widget_get_instance_private (MprisClientWidget* self)
{
	return G_STRUCT_MEMBER_P (self, MprisClientWidget_private_offset);
}

/**
 * Create a new ClientWidget
 *
 * @param client The underlying MprisClient instance to use
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MprisClientWidget* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->client);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_mpris_client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self)
{
	gboolean result;
	result = mpris_client_widget_on_raise_player ((MprisClientWidget*) self);
	return result;
}

static void
___lambda6_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* res)
{
	MprisClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		{
			MprisPlayerIface* _tmp0_;
			MprisPlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data2_->client);
			_tmp1_ = _tmp0_;
			mpris_player_iface_previous_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisPlayerIface* _tmp2_;
			MprisPlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data2_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("mpris_gui.vala:132: Error going to the previous track %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisPlayerIface* _tmp9_;
		MprisPlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data2_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("mpris_gui.vala:135: Error going to the previous track %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda6__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda6_ (self, source_object, res);
	block2_data_unref (self);
}

static void
__lambda5_ (Block2Data* _data2_)
{
	MprisClientWidget* self;
	MprisPlayerIface* _tmp0_;
	MprisPlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp0_ = mpris_client_get_player (_data2_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = mpris_player_iface_get_can_go_previous (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		MprisPlayerIface* _tmp4_;
		MprisPlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data2_->client);
		_tmp5_ = _tmp4_;
		mpris_player_iface_previous (_tmp5_, ____lambda6__gasync_ready_callback, block2_data_ref (_data2_));
	}
}

static void
___lambda5__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda8_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	MprisClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		{
			MprisPlayerIface* _tmp0_;
			MprisPlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data2_->client);
			_tmp1_ = _tmp0_;
			mpris_player_iface_play_pause_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisPlayerIface* _tmp2_;
			MprisPlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data2_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("mpris_gui.vala:152: Error toggling play state %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisPlayerIface* _tmp9_;
		MprisPlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data2_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("mpris_gui.vala:155: Error toggling the play state %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ (self, source_object, res);
	block2_data_unref (self);
}

static void
__lambda7_ (Block2Data* _data2_)
{
	MprisClientWidget* self;
	MprisPlayerIface* _tmp0_;
	MprisPlayerIface* _tmp1_;
	self = _data2_->self;
	_tmp0_ = mpris_client_get_player (_data2_->client);
	_tmp1_ = _tmp0_;
	mpris_player_iface_play_pause (_tmp1_, ___lambda8__gasync_ready_callback, block2_data_ref (_data2_));
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ (self);
}

static void
___lambda10_ (Block2Data* _data2_,
              GObject* obj,
              GAsyncResult* res)
{
	MprisClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		{
			MprisPlayerIface* _tmp0_;
			MprisPlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data2_->client);
			_tmp1_ = _tmp0_;
			mpris_player_iface_next_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisPlayerIface* _tmp2_;
			MprisPlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data2_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("mpris_gui.vala:173: Error going to the next track %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisPlayerIface* _tmp9_;
		MprisPlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data2_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("mpris_gui.vala:176: Error going to the next track %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda10__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda10_ (self, source_object, res);
	block2_data_unref (self);
}

static void
__lambda9_ (Block2Data* _data2_)
{
	MprisClientWidget* self;
	MprisPlayerIface* _tmp0_;
	MprisPlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp0_ = mpris_client_get_player (_data2_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = mpris_player_iface_get_can_go_next (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		MprisPlayerIface* _tmp4_;
		MprisPlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data2_->client);
		_tmp5_ = _tmp4_;
		mpris_player_iface_next (_tmp5_, ____lambda10__gasync_ready_callback, block2_data_ref (_data2_));
	}
}

static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda9_ (self);
}

static void
___lambda12_ (MprisClientWidget* self,
              const gchar* k,
              GVariant* v)
{
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	if (g_strcmp0 (k, "Metadata") == 0) {
		mpris_client_widget_update_from_meta (self);
	} else {
		if (g_strcmp0 (k, "PlaybackStatus") == 0) {
			mpris_client_widget_update_play_status (self);
		} else {
			gboolean _tmp0_ = FALSE;
			if (g_strcmp0 (k, "CanGoNext") == 0) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_strcmp0 (k, "CanGoPrevious") == 0;
			}
			if (_tmp0_) {
				mpris_client_widget_update_controls (self);
			}
		}
	}
}

static void
____lambda12__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda12_ ((MprisClientWidget*) self, (const gchar*) key, (GVariant*) value);
}

static void
__lambda11_ (MprisClientWidget* self,
             const gchar* i,
             GHashTable* p,
             gchar** inv,
             gint inv_length1)
{
	g_return_if_fail (i != NULL);
	g_return_if_fail (p != NULL);
	if (g_strcmp0 (i, "org.mpris.MediaPlayer2.Player") == 0) {
		g_hash_table_foreach (p, ____lambda12__gh_func, self);
	}
}

static void
___lambda11__mpris_dbus_prop_iface_properties_changed (MprisDbusPropIface* _sender,
                                                       const gchar* iface,
                                                       GHashTable* changed,
                                                       gchar** invalid,
                                                       gint invalid_length1,
                                                       gpointer self)
{
	__lambda11_ ((MprisClientWidget*) self, iface, changed, invalid, invalid_length1);
}

static void
__lambda13_ (MprisClientWidget* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkImage* image = NULL;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkImage* _tmp6_;
	GtkRevealer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	_tmp0_ = self->priv->content_revealer;
	_tmp1_ = self->priv->content_revealer;
	_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->header_reveal_button;
	_tmp5_ = gtk_button_get_image (_tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage));
	image = _tmp6_;
	_tmp7_ = self->priv->content_revealer;
	_tmp8_ = gtk_revealer_get_reveal_child (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkImage* _tmp10_;
		_tmp10_ = image;
		gtk_image_set_from_icon_name (_tmp10_, "pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = image;
		gtk_image_set_from_icon_name (_tmp11_, "pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_g_object_unref0 (image);
}

static void
___lambda13__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda13_ ((MprisClientWidget*) self);
}

static void
___lambda15_ (Block2Data* _data2_,
              GObject* obj,
              GAsyncResult* res)
{
	MprisClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		{
			MprisPlayerIface* _tmp0_;
			MprisPlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data2_->client);
			_tmp1_ = _tmp0_;
			mpris_iface_quit_finish ((MprisIface*) _tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisPlayerIface* _tmp2_;
			MprisPlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data2_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("mpris_gui.vala:254: Error closing %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisPlayerIface* _tmp9_;
		MprisPlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data2_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("mpris_gui.vala:257: Error closing %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda15__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda15_ (self, source_object, res);
	block2_data_unref (self);
}

static void
___lambda14_ (Block2Data* _data2_)
{
	MprisClientWidget* self;
	MprisPlayerIface* _tmp0_;
	MprisPlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data2_->self;
	_tmp0_ = mpris_client_get_player (_data2_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = mpris_iface_get_can_quit ((MprisIface*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		MprisPlayerIface* _tmp4_;
		MprisPlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data2_->client);
		_tmp5_ = _tmp4_;
		mpris_iface_quit ((MprisIface*) _tmp5_, ____lambda15__gasync_ready_callback, block2_data_ref (_data2_));
	}
}

static void
____lambda14__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda14_ (self);
}

MprisClientWidget*
mpris_client_widget_construct (GType object_type,
                               MprisClient* client,
                               gint width)
{
	MprisClientWidget * self = NULL;
	Block2Data* _data2_;
	MprisClient* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkBox* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkBox* _tmp9_;
	GtkImage* _tmp10_;
	MprisPlayerIface* _tmp11_;
	MprisPlayerIface* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_;
	MprisPlayerIface* _tmp18_;
	MprisPlayerIface* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GtkBox* _tmp23_;
	GtkLabel* _tmp24_;
	GtkWidget* row = NULL;
	GCancellable* _tmp25_;
	MprisClient* _tmp26_;
	GtkBox* player_box = NULL;
	GtkBox* _tmp27_;
	GtkImage* _tmp28_;
	GtkImage* _tmp29_;
	GtkImage* _tmp30_;
	GtkImage* _tmp31_;
	GtkImage* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkEventBox* _tmp34_;
	GtkEventBox* _tmp35_;
	GtkImage* _tmp36_;
	GtkEventBox* _tmp37_;
	GtkBox* layout = NULL;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkBox* _tmp40_;
	GtkBox* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	GtkEventBox* _tmp45_;
	GtkBox* box = NULL;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	GtkBox* _tmp49_;
	GtkGrid* controls = NULL;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkStyleContext* _tmp52_;
	GtkGrid* _tmp53_;
	GtkGrid* _tmp54_;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	gconstpointer _tmp57_;
	GtkLabel* _tmp58_;
	GtkBox* _tmp59_;
	GtkWidget* _tmp60_;
	GtkWidget* _tmp61_;
	GtkWidget* _tmp62_;
	gconstpointer _tmp63_;
	GtkLabel* _tmp64_;
	GtkBox* _tmp65_;
	GtkWidget* _tmp66_;
	GtkWidget* _tmp67_;
	GtkWidget* _tmp68_;
	gconstpointer _tmp69_;
	GtkLabel* _tmp70_;
	GtkBox* _tmp71_;
	GtkWidget* _tmp72_;
	GtkBox* _tmp73_;
	GtkGrid* _tmp74_;
	GtkButton* btn = NULL;
	GtkButton* _tmp75_;
	GtkButton* _tmp76_;
	GtkButton* _tmp77_;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* _tmp80_;
	GtkButton* _tmp81_;
	GtkButton* _tmp82_;
	GtkStyleContext* _tmp83_;
	GtkGrid* _tmp84_;
	GtkButton* _tmp85_;
	GtkButton* _tmp86_;
	GtkButton* _tmp87_;
	GtkButton* _tmp88_;
	GtkButton* _tmp89_;
	GtkButton* _tmp90_;
	GtkButton* _tmp91_;
	GtkStyleContext* _tmp92_;
	GtkGrid* _tmp93_;
	GtkButton* _tmp94_;
	GtkButton* _tmp95_;
	GtkButton* _tmp96_;
	GtkButton* _tmp97_;
	GtkButton* _tmp98_;
	GtkButton* _tmp99_;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	GtkButton* _tmp102_;
	GtkStyleContext* _tmp103_;
	GtkGrid* _tmp104_;
	GtkButton* _tmp105_;
	GtkButton* _tmp106_;
	GtkGrid* _tmp107_;
	GtkGrid* _tmp108_;
	GtkBox* _tmp109_;
	GtkBox* _tmp110_;
	MprisDbusPropIface* _tmp111_;
	MprisDbusPropIface* _tmp112_;
	GtkBox* _tmp113_;
	GtkStyleContext* _tmp114_;
	gboolean _tmp115_ = FALSE;
	MprisPlayerIface* _tmp116_;
	MprisPlayerIface* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gboolean _tmp121_;
	GtkStyleContext* _tmp147_;
	GtkRevealer* _tmp148_;
	GtkRevealer* _tmp149_;
	GtkBox* _tmp150_;
	GtkRevealer* _tmp151_;
	GtkRevealer* _tmp152_;
	GtkButton* _tmp153_;
	GtkButton* _tmp154_;
	GtkStyleContext* _tmp155_;
	GtkButton* _tmp156_;
	GtkStyleContext* _tmp157_;
	GtkButton* _tmp158_;
	GtkButton* _tmp159_;
	GtkButton* _tmp160_;
	GtkBox* _tmp161_;
	GtkButton* _tmp162_;
	MprisPlayerIface* _tmp163_;
	MprisPlayerIface* _tmp164_;
	gboolean _tmp165_;
	gboolean _tmp166_;
	g_return_val_if_fail (client != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (client);
	_g_object_unref0 (_data2_->client);
	_data2_->client = _tmp0_;
	self = (MprisClientWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_data2_->self = g_object_ref (self);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp1_;
	_tmp2_ = self->priv->header;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "raven-header");
	_tmp4_ = self->priv->header;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-music-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->header_icon);
	self->priv->header_icon = _tmp5_;
	_tmp6_ = self->priv->header_icon;
	g_object_set ((GtkWidget*) _tmp6_, "margin", 4, NULL);
	_tmp7_ = self->priv->header_icon;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 12);
	_tmp8_ = self->priv->header_icon;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp8_, 10);
	_tmp9_ = self->priv->header;
	_tmp10_ = self->priv->header_icon;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = mpris_client_get_player (_data2_->client);
	_tmp12_ = _tmp11_;
	_tmp13_ = mpris_iface_get_identity ((MprisIface*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_tmp15_);
	gtk_label_set_xalign (_tmp16_, 0.0f);
	gtk_label_set_max_width_chars (_tmp16_, 1);
	gtk_label_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->header_label);
	self->priv->header_label = _tmp16_;
	_g_free0 (_tmp15_);
	_tmp17_ = self->priv->header_label;
	_tmp18_ = mpris_client_get_player (_data2_->client);
	_tmp19_ = _tmp18_;
	_tmp20_ = mpris_iface_get_identity ((MprisIface*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->header;
	_tmp24_ = self->priv->header_label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	row = NULL;
	_tmp25_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp25_;
	self->priv->our_width = width;
	_tmp26_ = _g_object_ref0 (_data2_->client);
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp26_;
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp27_);
	player_box = _tmp27_;
	_tmp28_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-music-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp28_;
	_tmp29_ = self->priv->background;
	gtk_widget_set_size_request ((GtkWidget*) _tmp29_, 80, 80);
	_tmp30_ = self->priv->background;
	gtk_image_set_pixel_size (_tmp30_, 64);
	_tmp31_ = self->priv->background;
	gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_START);
	_tmp32_ = self->priv->background;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_add_class (_tmp33_, "raven-mpris");
	_tmp34_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->background_wrap);
	self->priv->background_wrap = _tmp34_;
	_tmp35_ = self->priv->background_wrap;
	_tmp36_ = self->priv->background;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->background_wrap;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "button-release-event", (GCallback) _mpris_client_widget_on_raise_player_gtk_widget_button_release_event, self, 0);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp38_);
	layout = _tmp38_;
	_tmp39_ = layout;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp39_, 12);
	_tmp40_ = layout;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp40_, 12);
	_tmp41_ = layout;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, 12);
	_tmp42_ = player_box;
	_tmp43_ = layout;
	gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
	_tmp44_ = layout;
	_tmp45_ = self->priv->background_wrap;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp46_);
	box = _tmp46_;
	_tmp47_ = box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp47_, 12);
	_tmp48_ = box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp48_, 12);
	_tmp49_ = box;
	gtk_widget_set_valign ((GtkWidget*) _tmp49_, GTK_ALIGN_CENTER);
	_tmp50_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp50_);
	controls = _tmp50_;
	_tmp51_ = controls;
	_tmp52_ = gtk_widget_get_style_context ((GtkWidget*) _tmp51_);
	gtk_style_context_add_class (_tmp52_, "raven-mpris-controls");
	_tmp53_ = controls;
	gtk_grid_set_column_spacing (_tmp53_, (guint) 6);
	_tmp54_ = controls;
	gtk_grid_set_column_homogeneous (_tmp54_, TRUE);
	_tmp55_ = create_row (_ ("Unknown Title"), "emblem-music-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp55_;
	_tmp56_ = row;
	_tmp57_ = g_object_get_data ((GObject*) _tmp56_, "label_item");
	_tmp58_ = _g_object_ref0 ((GtkLabel*) _tmp57_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp58_;
	_tmp59_ = box;
	_tmp60_ = row;
	gtk_box_pack_start (_tmp59_, _tmp60_, FALSE, FALSE, (guint) 0);
	_tmp61_ = create_row (_ ("Unknown Artist"), "user-info-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp61_;
	_tmp62_ = row;
	_tmp63_ = g_object_get_data ((GObject*) _tmp62_, "label_item");
	_tmp64_ = _g_object_ref0 ((GtkLabel*) _tmp63_);
	_g_object_unref0 (self->priv->artist_label);
	self->priv->artist_label = _tmp64_;
	_tmp65_ = box;
	_tmp66_ = row;
	gtk_box_pack_start (_tmp65_, _tmp66_, FALSE, FALSE, (guint) 0);
	_tmp67_ = create_row (_ ("Unknown Album"), "media-optical-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp67_;
	_tmp68_ = row;
	_tmp69_ = g_object_get_data ((GObject*) _tmp68_, "label_item");
	_tmp70_ = _g_object_ref0 ((GtkLabel*) _tmp69_);
	_g_object_unref0 (self->priv->album_label);
	self->priv->album_label = _tmp70_;
	_tmp71_ = box;
	_tmp72_ = row;
	gtk_box_pack_start (_tmp71_, _tmp72_, FALSE, FALSE, (guint) 0);
	_tmp73_ = player_box;
	_tmp74_ = controls;
	gtk_box_pack_start (_tmp73_, (GtkWidget*) _tmp74_, TRUE, FALSE, (guint) 6);
	_tmp75_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-backward-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp75_);
	btn = _tmp75_;
	_tmp76_ = btn;
	gtk_widget_set_size_request ((GtkWidget*) _tmp76_, (gint) GTK_ICON_SIZE_DND, (gint) GTK_ICON_SIZE_DND);
	_tmp77_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp77_, FALSE);
	_tmp78_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp78_, FALSE);
	_tmp79_ = btn;
	_tmp80_ = _g_object_ref0 (_tmp79_);
	_g_object_unref0 (self->priv->prev_btn);
	self->priv->prev_btn = _tmp80_;
	_tmp81_ = btn;
	g_signal_connect_data (_tmp81_, "clicked", (GCallback) ___lambda5__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp82_ = btn;
	_tmp83_ = gtk_widget_get_style_context ((GtkWidget*) _tmp82_);
	gtk_style_context_add_class (_tmp83_, "flat");
	_tmp84_ = controls;
	_tmp85_ = btn;
	gtk_grid_attach (_tmp84_, (GtkWidget*) _tmp85_, 0, 0, 1, 1);
	_tmp86_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp86_);
	_g_object_unref0 (btn);
	btn = _tmp86_;
	_tmp87_ = btn;
	_tmp88_ = _g_object_ref0 (_tmp87_);
	_g_object_unref0 (self->priv->play_btn);
	self->priv->play_btn = _tmp88_;
	_tmp89_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp89_, FALSE);
	_tmp90_ = btn;
	g_signal_connect_data (_tmp90_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp91_ = btn;
	_tmp92_ = gtk_widget_get_style_context ((GtkWidget*) _tmp91_);
	gtk_style_context_add_class (_tmp92_, "flat");
	_tmp93_ = controls;
	_tmp94_ = btn;
	_tmp95_ = self->priv->prev_btn;
	gtk_grid_attach_next_to (_tmp93_, (GtkWidget*) _tmp94_, (GtkWidget*) _tmp95_, GTK_POS_RIGHT, 1, 1);
	_tmp96_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-forward-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp96_);
	_g_object_unref0 (btn);
	btn = _tmp96_;
	_tmp97_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp97_, FALSE);
	_tmp98_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp98_, FALSE);
	_tmp99_ = btn;
	_tmp100_ = _g_object_ref0 (_tmp99_);
	_g_object_unref0 (self->priv->next_btn);
	self->priv->next_btn = _tmp100_;
	_tmp101_ = btn;
	g_signal_connect_data (_tmp101_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp102_ = btn;
	_tmp103_ = gtk_widget_get_style_context ((GtkWidget*) _tmp102_);
	gtk_style_context_add_class (_tmp103_, "flat");
	_tmp104_ = controls;
	_tmp105_ = btn;
	_tmp106_ = self->priv->play_btn;
	gtk_grid_attach_next_to (_tmp104_, (GtkWidget*) _tmp105_, (GtkWidget*) _tmp106_, GTK_POS_RIGHT, 1, 1);
	_tmp107_ = controls;
	gtk_widget_set_halign ((GtkWidget*) _tmp107_, GTK_ALIGN_CENTER);
	_tmp108_ = controls;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp108_, 6);
	_tmp109_ = layout;
	_tmp110_ = box;
	gtk_container_add ((GtkContainer*) _tmp109_, (GtkWidget*) _tmp110_);
	mpris_client_widget_update_from_meta (self);
	mpris_client_widget_update_play_status (self);
	mpris_client_widget_update_controls (self);
	_tmp111_ = mpris_client_get_prop (_data2_->client);
	_tmp112_ = _tmp111_;
	g_signal_connect_object (_tmp112_, "properties-changed", (GCallback) ___lambda11__mpris_dbus_prop_iface_properties_changed, self, 0);
	_tmp113_ = player_box;
	_tmp114_ = gtk_widget_get_style_context ((GtkWidget*) _tmp113_);
	gtk_style_context_add_class (_tmp114_, "raven-background");
	_tmp116_ = mpris_client_get_player (_data2_->client);
	_tmp117_ = _tmp116_;
	_tmp118_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = _tmp119_;
	_tmp121_ = _tmp120_ != NULL;
	_g_free0 (_tmp120_);
	if (_tmp121_) {
		MprisPlayerIface* _tmp122_;
		MprisPlayerIface* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp122_ = mpris_client_get_player (_data2_->client);
		_tmp123_ = _tmp122_;
		_tmp124_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp123_);
		_tmp125_ = _tmp124_;
		_tmp126_ = _tmp125_;
		_tmp115_ = g_strcmp0 (_tmp126_, "") != 0;
		_g_free0 (_tmp126_);
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		GtkStyleContext* _tmp127_;
		MprisPlayerIface* _tmp128_;
		MprisPlayerIface* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		_tmp127_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp128_ = mpris_client_get_player (_data2_->client);
		_tmp129_ = _tmp128_;
		_tmp130_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp129_);
		_tmp131_ = _tmp130_;
		_tmp132_ = _tmp131_;
		gtk_style_context_add_class (_tmp127_, _tmp132_);
		_g_free0 (_tmp132_);
	} else {
		MprisPlayerIface* _tmp133_;
		MprisPlayerIface* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gboolean _tmp138_;
		_tmp133_ = mpris_client_get_player (_data2_->client);
		_tmp134_ = _tmp133_;
		_tmp135_ = mpris_iface_get_identity ((MprisIface*) _tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = _tmp136_;
		_tmp138_ = _tmp137_ != NULL;
		_g_free0 (_tmp137_);
		if (_tmp138_) {
			GtkStyleContext* _tmp139_;
			MprisPlayerIface* _tmp140_;
			MprisPlayerIface* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			_tmp139_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp140_ = mpris_client_get_player (_data2_->client);
			_tmp141_ = _tmp140_;
			_tmp142_ = mpris_iface_get_identity ((MprisIface*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = _tmp143_;
			_tmp145_ = g_utf8_strdown (_tmp144_, (gssize) -1);
			_tmp146_ = _tmp145_;
			gtk_style_context_add_class (_tmp139_, _tmp146_);
			_g_free0 (_tmp146_);
			_g_free0 (_tmp144_);
		}
	}
	_tmp147_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp147_, "mpris-widget");
	_tmp148_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp148_);
	_g_object_unref0 (self->priv->content_revealer);
	self->priv->content_revealer = _tmp148_;
	_tmp149_ = self->priv->content_revealer;
	_tmp150_ = player_box;
	gtk_container_add ((GtkContainer*) _tmp149_, (GtkWidget*) _tmp150_);
	_tmp151_ = self->priv->content_revealer;
	gtk_revealer_set_reveal_child (_tmp151_, TRUE);
	_tmp152_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp152_);
	_tmp153_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp153_);
	_g_object_unref0 (self->priv->header_reveal_button);
	self->priv->header_reveal_button = _tmp153_;
	_tmp154_ = self->priv->header_reveal_button;
	_tmp155_ = gtk_widget_get_style_context ((GtkWidget*) _tmp154_);
	gtk_style_context_add_class (_tmp155_, "flat");
	_tmp156_ = self->priv->header_reveal_button;
	_tmp157_ = gtk_widget_get_style_context ((GtkWidget*) _tmp156_);
	gtk_style_context_add_class (_tmp157_, "expander-button");
	_tmp158_ = self->priv->header_reveal_button;
	g_object_set ((GtkWidget*) _tmp158_, "margin", 4, NULL);
	_tmp159_ = self->priv->header_reveal_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp159_, GTK_ALIGN_CENTER);
	_tmp160_ = self->priv->header_reveal_button;
	g_signal_connect_object (_tmp160_, "clicked", (GCallback) ___lambda13__gtk_button_clicked, self, 0);
	_tmp161_ = self->priv->header;
	_tmp162_ = self->priv->header_reveal_button;
	gtk_box_pack_end (_tmp161_, (GtkWidget*) _tmp162_, FALSE, FALSE, (guint) 0);
	_tmp163_ = mpris_client_get_player (_data2_->client);
	_tmp164_ = _tmp163_;
	_tmp165_ = mpris_iface_get_can_quit ((MprisIface*) _tmp164_);
	_tmp166_ = _tmp165_;
	if (_tmp166_) {
		GtkButton* _tmp167_;
		GtkButton* _tmp168_;
		GtkStyleContext* _tmp169_;
		GtkButton* _tmp170_;
		GtkStyleContext* _tmp171_;
		GtkButton* _tmp172_;
		GtkButton* _tmp173_;
		GtkBox* _tmp174_;
		GtkButton* _tmp175_;
		_tmp167_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp167_);
		_g_object_unref0 (self->priv->header_close_button);
		self->priv->header_close_button = _tmp167_;
		_tmp168_ = self->priv->header_close_button;
		_tmp169_ = gtk_widget_get_style_context ((GtkWidget*) _tmp168_);
		gtk_style_context_add_class (_tmp169_, "flat");
		_tmp170_ = self->priv->header_close_button;
		_tmp171_ = gtk_widget_get_style_context ((GtkWidget*) _tmp170_);
		gtk_style_context_add_class (_tmp171_, "primary-control");
		_tmp172_ = self->priv->header_close_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp172_, GTK_ALIGN_CENTER);
		_tmp173_ = self->priv->header_close_button;
		g_signal_connect_data (_tmp173_, "clicked", (GCallback) ____lambda14__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp174_ = self->priv->header;
		_tmp175_ = self->priv->header_close_button;
		gtk_box_pack_end (_tmp174_, (GtkWidget*) _tmp175_, FALSE, FALSE, (guint) 0);
	}
	_g_object_unref0 (btn);
	_g_object_unref0 (controls);
	_g_object_unref0 (box);
	_g_object_unref0 (layout);
	_g_object_unref0 (player_box);
	_g_object_unref0 (row);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

MprisClientWidget*
mpris_client_widget_new (MprisClient* client,
                         gint width)
{
	return mpris_client_widget_construct (TYPE_MPRIS_CLIENT_WIDGET, client, width);
}

void
mpris_client_widget_update_width (MprisClientWidget* self,
                                  gint new_width)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->our_width = new_width;
	_tmp0_ = self->priv->filename;
	mpris_client_widget_update_art (self, _tmp0_, TRUE);
}

/**
 * You raise me up ...
 */
static void
__lambda4_ (MprisClientWidget* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		{
			MprisClient* _tmp0_;
			MprisPlayerIface* _tmp1_;
			MprisPlayerIface* _tmp2_;
			_tmp0_ = self->priv->client;
			_tmp1_ = mpris_client_get_player (_tmp0_);
			_tmp2_ = _tmp1_;
			mpris_iface_raise_finish ((MprisIface*) _tmp2_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisClient* _tmp3_;
			MprisPlayerIface* _tmp4_;
			MprisPlayerIface* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = self->priv->client;
			_tmp4_ = mpris_client_get_player (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = mpris_iface_get_identity ((MprisIface*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("mpris_gui.vala:285: Error raising the client for %s: %s", _tmp8_, _tmp10_);
			_g_free0 (_tmp8_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisClient* _tmp11_;
		MprisPlayerIface* _tmp12_;
		MprisPlayerIface* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = self->priv->client;
		_tmp12_ = mpris_client_get_player (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = mpris_iface_get_identity ((MprisIface*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("mpris_gui.vala:288: Error raising the client for %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((MprisClientWidget*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
mpris_client_widget_on_raise_player (MprisClientWidget* self)
{
	gboolean _tmp0_ = FALSE;
	MprisClient* _tmp1_;
	MprisClient* _tmp7_;
	MprisPlayerIface* _tmp8_;
	MprisPlayerIface* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->client;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		MprisClient* _tmp2_;
		MprisPlayerIface* _tmp3_;
		MprisPlayerIface* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = self->priv->client;
		_tmp3_ = mpris_client_get_player (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = mpris_iface_get_can_raise ((MprisIface*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	mpris_iface_raise ((MprisIface*) _tmp9_, ___lambda4__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * Update play status based on player requirements
 */
static void
mpris_client_widget_update_play_status (MprisClientWidget* self)
{
	MprisClient* _tmp0_;
	MprisPlayerIface* _tmp1_;
	MprisPlayerIface* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = mpris_player_iface_get_playback_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				GtkImage* _tmp8_;
				gchar* text = NULL;
				MprisClient* _tmp9_;
				MprisPlayerIface* _tmp10_;
				MprisPlayerIface* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GtkLabel* _tmp17_;
				const gchar* _tmp18_;
				GtkLabel* _tmp19_;
				const gchar* _tmp20_;
				GtkButton* _tmp21_;
				GtkWidget* _tmp22_;
				_tmp8_ = self->priv->header_icon;
				gtk_image_set_from_icon_name (_tmp8_, "media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
				_tmp9_ = self->priv->client;
				_tmp10_ = mpris_client_get_player (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = mpris_iface_get_identity ((MprisIface*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup_printf (_ ("Playing - %s"), _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				text = _tmp16_;
				_tmp17_ = self->priv->header_label;
				_tmp18_ = text;
				gtk_label_set_text (_tmp17_, _tmp18_);
				_tmp19_ = self->priv->header_label;
				_tmp20_ = text;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _tmp20_);
				_tmp21_ = self->priv->play_btn;
				_tmp22_ = gtk_button_get_image (_tmp21_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_image_get_type (), GtkImage), "media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				_g_free0 (text);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				GtkImage* _tmp23_;
				gchar* text = NULL;
				MprisClient* _tmp24_;
				MprisPlayerIface* _tmp25_;
				MprisPlayerIface* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				GtkLabel* _tmp32_;
				const gchar* _tmp33_;
				GtkLabel* _tmp34_;
				const gchar* _tmp35_;
				GtkButton* _tmp36_;
				GtkWidget* _tmp37_;
				_tmp23_ = self->priv->header_icon;
				gtk_image_set_from_icon_name (_tmp23_, "media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
				_tmp24_ = self->priv->client;
				_tmp25_ = mpris_client_get_player (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = mpris_iface_get_identity ((MprisIface*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup_printf (_ ("Paused - %s"), _tmp29_);
				_tmp31_ = _tmp30_;
				_g_free0 (_tmp29_);
				text = _tmp31_;
				_tmp32_ = self->priv->header_label;
				_tmp33_ = text;
				gtk_label_set_text (_tmp32_, _tmp33_);
				_tmp34_ = self->priv->header_label;
				_tmp35_ = text;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp34_, _tmp35_);
				_tmp36_ = self->priv->play_btn;
				_tmp37_ = gtk_button_get_image (_tmp36_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_image_get_type (), GtkImage), "media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				_g_free0 (text);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkImage* _tmp38_;
				GtkLabel* _tmp39_;
				MprisClient* _tmp40_;
				MprisPlayerIface* _tmp41_;
				MprisPlayerIface* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				GtkLabel* _tmp46_;
				MprisClient* _tmp47_;
				MprisPlayerIface* _tmp48_;
				MprisPlayerIface* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				GtkButton* _tmp53_;
				GtkWidget* _tmp54_;
				_tmp38_ = self->priv->header_icon;
				gtk_image_set_from_icon_name (_tmp38_, "media-playback-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
				_tmp39_ = self->priv->header_label;
				_tmp40_ = self->priv->client;
				_tmp41_ = mpris_client_get_player (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = mpris_iface_get_identity ((MprisIface*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_;
				gtk_label_set_text (_tmp39_, _tmp45_);
				_g_free0 (_tmp45_);
				_tmp46_ = self->priv->header_label;
				_tmp47_ = self->priv->client;
				_tmp48_ = mpris_client_get_player (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = mpris_iface_get_identity ((MprisIface*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = _tmp51_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp46_, _tmp52_);
				_g_free0 (_tmp52_);
				_tmp53_ = self->priv->play_btn;
				_tmp54_ = gtk_button_get_image (_tmp53_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_image_get_type (), GtkImage), "media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	}
}

/**
 * Update prev/next sensitivity based on player requirements
 */
static void
mpris_client_widget_update_controls (MprisClientWidget* self)
{
	GtkButton* _tmp0_;
	MprisClient* _tmp1_;
	MprisPlayerIface* _tmp2_;
	MprisPlayerIface* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkButton* _tmp6_;
	MprisClient* _tmp7_;
	MprisPlayerIface* _tmp8_;
	MprisPlayerIface* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_btn;
	_tmp1_ = self->priv->client;
	_tmp2_ = mpris_client_get_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = mpris_player_iface_get_can_go_previous (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp5_);
	_tmp6_ = self->priv->next_btn;
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = mpris_player_iface_get_can_go_next (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp11_);
}

/**
 * Utility, handle updating the album art
 */
static void
mpris_client_widget_update_art (MprisClientWidget* self,
                                const gchar* uri,
                                gboolean force_reload)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp1_ = self->priv->filename;
	if (g_strcmp0 (uri, _tmp1_) == 0) {
		_tmp0_ = !force_reload;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (g_str_has_prefix (uri, "http")) {
		GCancellable* _tmp2_;
		GCancellable* _tmp4_;
		_tmp2_ = self->priv->cancel;
		if (!g_cancellable_is_cancelled (_tmp2_)) {
			GCancellable* _tmp3_;
			_tmp3_ = self->priv->cancel;
			g_cancellable_cancel (_tmp3_);
		}
		_tmp4_ = self->priv->cancel;
		g_cancellable_reset (_tmp4_);
		mpris_client_widget_download_art (self, uri, NULL, NULL);
	} else {
		if (g_str_has_prefix (uri, "file://")) {
			gchar* fname = NULL;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = _tmp5_ = g_strsplit (uri, "file://", 0);
			_tmp7_ = _tmp6_;
			_tmp7__length1 = _vala_array_length (_tmp5_);
			_tmp8_ = _tmp7_[1];
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			fname = _tmp10_;
			{
				GdkPixbuf* pbuf = NULL;
				const gchar* _tmp11_;
				GdkPixbuf* _tmp12_;
				GtkImage* _tmp13_;
				GdkPixbuf* _tmp14_;
				GtkStyleContext* _tmp15_;
				_tmp11_ = fname;
				_tmp12_ = gdk_pixbuf_new_from_file_at_size (_tmp11_, 80, 80, &_inner_error0_);
				pbuf = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = self->priv->background;
				_tmp14_ = pbuf;
				gtk_image_set_from_pixbuf (_tmp13_, _tmp14_);
				_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
				gtk_style_context_remove_class (_tmp15_, "no-album-art");
				_g_object_unref0 (pbuf);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
				mpris_client_widget_update_art_fallback (self);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (fname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (fname);
		} else {
			mpris_client_widget_update_art_fallback (self);
		}
	}
	_tmp16_ = g_strdup (uri);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp16_;
}

static void
mpris_client_widget_update_art_fallback (MprisClientWidget* self)
{
	GtkStyleContext* _tmp0_;
	GtkImage* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "no-album-art");
	_tmp1_ = self->priv->background;
	gtk_image_set_from_icon_name (_tmp1_, "emblem-music-symbolic", (GtkIconSize) GTK_ICON_SIZE_INVALID);
}

static void
mpris_client_widget_download_art_data_free (gpointer _data)
{
	MprisClientWidgetDownloadArtData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (MprisClientWidgetDownloadArtData, _data_);
}

static void
mpris_client_widget_download_art (MprisClientWidget* self,
                                  const gchar* uri,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	MprisClientWidgetDownloadArtData* _data_;
	MprisClientWidget* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (MprisClientWidgetDownloadArtData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mpris_client_widget_download_art_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	mpris_client_widget_download_art_co (_data_);
}

static void
mpris_client_widget_download_art_finish (MprisClientWidget* self,
                                         GAsyncResult* _res_)
{
	MprisClientWidgetDownloadArtData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Fetch the cover art asynchronously and set it as the background image
 */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
mpris_client_widget_download_art_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	MprisClientWidgetDownloadArtData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mpris_client_widget_download_art_co (_data_);
}

static gboolean
mpris_client_widget_download_art_co (MprisClientWidgetDownloadArtData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = string_replace (_data_->uri, "https://open.spotify.com/image/", "https://i.scdn.co/image/");
	_data_->proper_uri = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->proper_uri;
		_data_->_tmp2_ = g_file_new_for_uri (_data_->_tmp1_);
		_data_->art_file = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->art_file;
		_data_->_tmp4_ = _data_->self->priv->cancel;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp3_, G_PRIORITY_DEFAULT, _data_->_tmp4_, mpris_client_widget_download_art_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_read_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->ins = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->art_file);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->ins;
		_data_->_tmp7_ = _data_->self->priv->cancel;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async ((GInputStream*) _data_->_tmp6_, 80, 80, TRUE, _data_->_tmp7_, mpris_client_widget_download_art_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pbuf = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->ins);
			_g_object_unref0 (_data_->art_file);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->self->priv->background;
		_data_->_tmp10_ = _data_->pbuf;
		gtk_image_set_from_pixbuf (_data_->_tmp9_, _data_->_tmp10_);
		_data_->_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _data_->self);
		gtk_style_context_remove_class (_data_->_tmp11_, "no-album-art");
		_g_object_unref0 (_data_->pbuf);
		_g_object_unref0 (_data_->ins);
		_g_object_unref0 (_data_->art_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		mpris_client_widget_update_art_fallback (_data_->self);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->proper_uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->proper_uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
mpris_client_widget_get_meta_string (MprisClientWidget* self,
                                     const gchar* key,
                                     const gchar* fallback)
{
	MprisClient* _tmp0_;
	MprisPlayerIface* _tmp1_;
	MprisPlayerIface* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp33_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (fallback != NULL, NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = mpris_player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_hash_table_contains (_tmp5_, key);
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp6_) {
		GVariant* label = NULL;
		MprisClient* _tmp7_;
		MprisPlayerIface* _tmp8_;
		MprisPlayerIface* _tmp9_;
		GHashTable* _tmp10_;
		GHashTable* _tmp11_;
		GHashTable* _tmp12_;
		gconstpointer _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		gchar* lab = NULL;
		const GVariantType* type = NULL;
		GVariant* _tmp16_;
		const GVariantType* _tmp17_;
		const GVariantType* _tmp18_;
		const GVariantType* _tmp19_;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		_tmp7_ = self->priv->client;
		_tmp8_ = mpris_client_get_player (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = mpris_player_iface_get_metadata (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = g_hash_table_lookup (_tmp12_, key);
		_tmp14_ = _g_variant_ref0 ((GVariant*) _tmp13_);
		_tmp15_ = _tmp14_;
		_g_hash_table_unref0 (_tmp12_);
		label = _tmp15_;
		lab = NULL;
		_tmp16_ = label;
		_tmp17_ = g_variant_get_type (_tmp16_);
		type = _tmp17_;
		_tmp18_ = type;
		_tmp19_ = G_VARIANT_TYPE_STRING;
		if (g_variant_type_is_subtype_of (_tmp18_, _tmp19_)) {
			GVariant* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp20_ = label;
			_tmp21_ = g_variant_get_string (_tmp20_, NULL);
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (lab);
			lab = _tmp22_;
		} else {
			const GVariantType* _tmp23_;
			const GVariantType* _tmp24_;
			_tmp23_ = type;
			_tmp24_ = G_VARIANT_TYPE_STRING_ARRAY;
			if (g_variant_type_is_subtype_of (_tmp23_, _tmp24_)) {
				gchar** vals = NULL;
				GVariant* _tmp25_;
				gsize _tmp26_ = 0;
				gchar** _tmp27_;
				gint vals_length1;
				gint _vals_size_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar* _tmp29_;
				_tmp25_ = label;
				_tmp27_ = g_variant_dup_strv (_tmp25_, &_tmp26_);
				vals = _tmp27_;
				vals_length1 = _tmp26_;
				_vals_size_ = vals_length1;
				_tmp28_ = vals;
				_tmp28__length1 = vals_length1;
				_tmp29_ = _vala_g_strjoinv (", ", _tmp28_, (gint) _tmp28__length1);
				_g_free0 (lab);
				lab = _tmp29_;
				vals = (_vala_array_free (vals, vals_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp31_ = lab;
		if (_tmp31_ != NULL) {
			const gchar* _tmp32_;
			_tmp32_ = lab;
			_tmp30_ = g_strcmp0 (_tmp32_, "") != 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			result = lab;
			_g_variant_unref0 (label);
			return result;
		}
		_g_free0 (lab);
		_g_variant_unref0 (label);
	}
	_tmp33_ = g_strdup (fallback);
	result = _tmp33_;
	return result;
}

/**
 * Update display info such as artist, the background image, etc.
 */
void
mpris_client_widget_update_from_meta (MprisClientWidget* self)
{
	MprisClient* _tmp0_;
	MprisPlayerIface* _tmp1_;
	MprisPlayerIface* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gboolean _tmp6_;
	MprisClient* _tmp7_;
	MprisPlayerIface* _tmp8_;
	MprisPlayerIface* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	gboolean _tmp13_;
	gchar* title = NULL;
	gchar* _tmp25_;
	GtkLabel* _tmp26_;
	const gchar* _tmp27_;
	GtkLabel* _tmp28_;
	const gchar* _tmp29_;
	gchar* artist = NULL;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GtkLabel* _tmp37_;
	const gchar* _tmp38_;
	gchar* album = NULL;
	gchar* _tmp39_;
	GtkLabel* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GtkLabel* _tmp46_;
	const gchar* _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = mpris_player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp6_) {
		return;
	}
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = mpris_player_iface_get_metadata (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = g_hash_table_contains (_tmp12_, "mpris:artUrl");
	_g_hash_table_unref0 (_tmp12_);
	if (_tmp13_) {
		gchar* url = NULL;
		MprisClient* _tmp14_;
		MprisPlayerIface* _tmp15_;
		MprisPlayerIface* _tmp16_;
		GHashTable* _tmp17_;
		GHashTable* _tmp18_;
		GHashTable* _tmp19_;
		gconstpointer _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp14_ = self->priv->client;
		_tmp15_ = mpris_client_get_player (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = mpris_player_iface_get_metadata (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = g_hash_table_lookup (_tmp19_, "mpris:artUrl");
		_tmp21_ = g_variant_get_string ((GVariant*) _tmp20_, NULL);
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = _tmp22_;
		_g_hash_table_unref0 (_tmp19_);
		url = _tmp23_;
		_tmp24_ = url;
		mpris_client_widget_update_art (self, _tmp24_, FALSE);
		_g_free0 (url);
	} else {
		mpris_client_widget_update_art_fallback (self);
	}
	_tmp25_ = mpris_client_widget_get_meta_string (self, "xesam:title", _ ("Unknown Title"));
	title = _tmp25_;
	_tmp26_ = self->priv->title_label;
	_tmp27_ = title;
	gtk_label_set_text (_tmp26_, _tmp27_);
	_tmp28_ = self->priv->title_label;
	_tmp29_ = title;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _tmp29_);
	_tmp30_ = mpris_client_widget_get_meta_string (self, "xesam:artist", _ ("Unknown Artist"));
	artist = _tmp30_;
	_tmp31_ = self->priv->artist_label;
	_tmp32_ = artist;
	_tmp33_ = g_markup_escape_text (_tmp32_, (gssize) -1);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strdup_printf ("%s", _tmp34_);
	_tmp36_ = _tmp35_;
	gtk_label_set_markup (_tmp31_, _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_tmp37_ = self->priv->artist_label;
	_tmp38_ = artist;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp37_, _tmp38_);
	_tmp39_ = mpris_client_widget_get_meta_string (self, "xesam:album", _ ("Unknown Album"));
	album = _tmp39_;
	_tmp40_ = self->priv->album_label;
	_tmp41_ = album;
	_tmp42_ = g_markup_escape_text (_tmp41_, (gssize) -1);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strdup_printf ("%s", _tmp43_);
	_tmp45_ = _tmp44_;
	gtk_label_set_markup (_tmp40_, _tmp45_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = self->priv->album_label;
	_tmp47_ = album;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp46_, _tmp47_);
	_g_free0 (album);
	_g_free0 (artist);
	_g_free0 (title);
}

static void
mpris_client_widget_class_init (MprisClientWidgetClass * klass,
                                gpointer klass_data)
{
	mpris_client_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MprisClientWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mpris_client_widget_finalize;
}

static void
mpris_client_widget_instance_init (MprisClientWidget * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = mpris_client_widget_get_instance_private (self);
	self->priv->header = NULL;
	self->priv->header_icon = NULL;
	self->priv->header_label = NULL;
	self->priv->header_reveal_button = NULL;
	self->priv->header_close_button = NULL;
	self->priv->content_revealer = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->filename = _tmp0_;
	self->priv->our_width = BACKGROUND_SIZE;
}

static void
mpris_client_widget_finalize (GObject * obj)
{
	MprisClientWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MPRIS_CLIENT_WIDGET, MprisClientWidget);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->header_icon);
	_g_object_unref0 (self->priv->header_label);
	_g_object_unref0 (self->priv->header_reveal_button);
	_g_object_unref0 (self->priv->header_close_button);
	_g_object_unref0 (self->priv->content_revealer);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->background_wrap);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->artist_label);
	_g_object_unref0 (self->priv->album_label);
	_g_object_unref0 (self->priv->prev_btn);
	_g_object_unref0 (self->priv->play_btn);
	_g_object_unref0 (self->priv->next_btn);
	_g_free0 (self->priv->filename);
	_g_object_unref0 (self->priv->cancel);
	G_OBJECT_CLASS (mpris_client_widget_parent_class)->finalize (obj);
}

/**
 * A ClientWidget is simply used to control and display information in a two-way
 * fashion with an underlying MPRIS provider (MediaPlayer2)
 * It is "designed" to be self contained and added to a large UI, enabling multiple
 * MPRIS clients to be controlled with multiple widgets
 */
GType
mpris_client_widget_get_type (void)
{
	return mpris_client_widget_type_id;
}

GType
mpris_client_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MprisClientWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris_client_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MprisClientWidget), 0, (GInstanceInitFunc) mpris_client_widget_instance_init, NULL };
	mpris_client_widget_type_id = g_type_module_register_type (module, gtk_box_get_type (), "MprisClientWidget", &g_define_type_info, 0);
	MprisClientWidget_private_offset = sizeof (MprisClientWidgetPrivate);
	return mpris_client_widget_type_id;
}

/**
 * Boring utility function, create an image/label row
 *
 * @param name Label to appear on row
 * @param icon Icon name to use, or NULL if using gicon
 * @param gicon A gicon to use, if not using icon
 *
 * @return A Gtk.Box with the boilerplate cruft out of the way
 */
GtkWidget*
create_row (const gchar* name,
            const gchar* icon,
            GIcon* gicon)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkImage* img = NULL;
	gboolean _tmp1_ = FALSE;
	GtkImage* _tmp4_;
	GtkBox* _tmp5_;
	GtkImage* _tmp6_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkWidget* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	if (icon == NULL) {
		_tmp1_ = gicon != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkImage* _tmp2_;
		_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (gicon, (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (img);
		img = _tmp2_;
	} else {
		GtkImage* _tmp3_;
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (icon, (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (img);
		img = _tmp3_;
	}
	_tmp4_ = img;
	gtk_image_set_pixel_size (_tmp4_, 12);
	_tmp5_ = box;
	_tmp6_ = img;
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (name);
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp7_, 0.0f);
	gtk_label_set_max_width_chars (_tmp7_, 1);
	gtk_label_set_ellipsize (_tmp7_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	gtk_label_set_line_wrap (label, TRUE);
	_tmp8_ = box;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp9_ = box;
	_tmp10_ = _g_object_ref0 (label);
	g_object_set_data_full ((GObject*) _tmp9_, "label_item", _tmp10_, g_object_unref);
	_tmp11_ = box;
	_tmp12_ = img;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	g_object_set_data_full ((GObject*) _tmp11_, "image_item", _tmp13_, g_object_unref);
	result = (GtkWidget*) box;
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

