/* raven.c generated by valac 0.56.14, the Vala compiler
 * generated from raven.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>
#include "budgie-private.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdio.h>
#include <gdk/gdkx.h>
#include "plugin.h"
#include <budgie-config.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieParamSpecRavenIface BudgieParamSpecRavenIface;
enum  {
	BUDGIE_RAVEN_IFACE_EXPANSION_CHANGED_SIGNAL,
	BUDGIE_RAVEN_IFACE_ANCHOR_CHANGED_SIGNAL,
	BUDGIE_RAVEN_IFACE_NOTIFICATIONS_CHANGED_SIGNAL,
	BUDGIE_RAVEN_IFACE_CLEAR_ALL_NOTIFICATIONS_SIGNAL,
	BUDGIE_RAVEN_IFACE_UNREAD_NOTIFICATIONS_SIGNAL,
	BUDGIE_RAVEN_IFACE_READ_NOTIFICATIONS_SIGNAL,
	BUDGIE_RAVEN_IFACE_NUM_SIGNALS
};
static guint budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_NUM_SIGNALS] = {0};
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_RAVEN_0_PROPERTY,
	BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY,
	BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY,
	BUDGIE_RAVEN_MANAGER_PROPERTY,
	BUDGIE_RAVEN_NSCALE_PROPERTY,
	BUDGIE_RAVEN_NUM_PROPERTIES
};
static GParamSpec* budgie_raven_properties[BUDGIE_RAVEN_NUM_PROPERTIES];
#define _budgie_raven_iface_unref0(var) ((var == NULL) ? NULL : (var = (budgie_raven_iface_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _budgie_raven_widget_data_unref0(var) ((var == NULL) ? NULL : (var = (budgie_raven_widget_data_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	BUDGIE_RAVEN_REQUEST_SETTINGS_UI_SIGNAL,
	BUDGIE_RAVEN_ON_WIDGET_ADDED_SIGNAL,
	BUDGIE_RAVEN_NUM_SIGNALS
};
static guint budgie_raven_signals[BUDGIE_RAVEN_NUM_SIGNALS] = {0};

struct _BudgieRavenIfacePrivate {
	BudgieRaven* parent;
};

struct _BudgieParamSpecRavenIface {
	GParamSpec parent_instance;
};

struct _BudgieRavenPrivate {
	GtkPositionType _screen_edge;
	GList* widgets;
	gint our_width;
	gint our_height;
	gint our_x;
	gint our_y;
	BudgieShadowBlock* shadow;
	BudgieRavenIface* iface;
	GSettings* settings;
	GSettings* widget_settings;
	gboolean expanded;
	GdkRectangle old_rect;
	GtkBox* layout;
	gdouble scale;
	gint _required_size;
	BudgieMainView* main_view;
	guint n_count;
	BudgieDesktopManager* _manager;
	BudgieRavenPluginManager* plugin_manager;
};

struct _Block4Data {
	int _ref_count_;
	BudgieRaven* self;
	gchar** uuids;
	gint uuids_length1;
	gint _uuids_size_;
};

static gint BudgieRavenIface_private_offset;
static gpointer budgie_raven_iface_parent_class = NULL;
static gint BudgieRaven_private_offset;
static gpointer budgie_raven_parent_class = NULL;
static BudgieRaven* budgie_raven__instance;
static BudgieRaven* budgie_raven__instance = NULL;

static void budgie_raven_iface_finalize (BudgieRavenIface * obj);
static GType budgie_raven_iface_get_type_once (void);
static void _dbus_budgie_raven_iface_ClearNotifications (BudgieRavenIface* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_GetExpanded (BudgieRavenIface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_GetLeftAnchored (BudgieRavenIface* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_SetExpanded (BudgieRavenIface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_Toggle (BudgieRavenIface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_ToggleAppletView (BudgieRavenIface* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_ToggleNotificationsView (BudgieRavenIface* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_Dismiss (BudgieRavenIface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_GetNotificationCount (BudgieRavenIface* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_budgie_raven_iface_get_version (BudgieRavenIface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void budgie_raven_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* budgie_raven_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_budgie_raven_iface_get_is_expanded (BudgieRavenIface* self);
static gboolean budgie_raven_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _dbus_budgie_raven_iface_set_is_expanded (BudgieRavenIface* self,
                                               GVariant* _value);
static void _dbus_budgie_raven_iface_expansion_changed (GObject* _sender,
                                                 gboolean expanded,
                                                 gpointer* _data);
static void _dbus_budgie_raven_iface_anchor_changed (GObject* _sender,
                                              gboolean anchored,
                                              gpointer* _data);
static void _dbus_budgie_raven_iface_notifications_changed (GObject* _sender,
                                                     gpointer* _data);
static void _dbus_budgie_raven_iface_clear_all_notifications (GObject* _sender,
                                                       gpointer* _data);
static void _dbus_budgie_raven_iface_unread_notifications (GObject* _sender,
                                                    gpointer* _data);
static void _dbus_budgie_raven_iface_read_notifications (GObject* _sender,
                                                  gpointer* _data);
static void _budgie_raven_iface_unregister_object (gpointer user_data);
static void _budgie_raven_widget_data_unref0_ (gpointer var);
static inline void _g_list_free__budgie_raven_widget_data_unref0_ (GList* self);
static void budgie_raven_on_bus_acquired (BudgieRaven* self,
                                   GDBusConnection* conn);
static void budgie_raven_load_existing_widgets (BudgieRaven* self);
static gboolean budgie_raven_on_focus_out (BudgieRaven* self);
static void budgie_raven_steal_focus (BudgieRaven* self);
static void __lambda15_ (BudgieRaven* self);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean _budgie_raven_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                GdkEventFocus* event,
                                                                gpointer self);
static gboolean __lambda16_ (BudgieRaven* self,
                      GdkEventCrossing* e);
static gboolean ___lambda16__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static void __lambda17_ (BudgieRaven* self);
static void ___lambda17__budgie_main_view_requested_draw (BudgieMainView* _sender,
                                                   gpointer self);
static void budgie_raven_real_size_allocate (GtkWidget* base,
                                      GtkAllocation* rect);
static void _budgie_raven_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                           const gchar* name,
                                                           gpointer self);
static void __lambda18_ (BudgieRaven* self);
static void ___lambda18__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda19_ (BudgieRaven* self);
static void ___lambda19__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static void budgie_raven_real_get_preferred_height (GtkWidget* base,
                                             gint* m,
                                             gint* n);
static void budgie_raven_real_get_preferred_height_for_width (GtkWidget* base,
                                                       gint w,
                                                       gint* m,
                                                       gint* n);
static gboolean budgie_raven_real_draw (GtkWidget* base,
                                 cairo_t* cr);
static gdouble _budgie_expo_ease_out_budgie_tween_func (gdouble factor,
                                                 gpointer self);
static gdouble _budgie_sine_ease_in_budgie_tween_func (gdouble factor,
                                                gpointer self);
static void _vala_BudgiePropChange_array_free (BudgiePropChange * array,
                                        gssize array_length);
static void __lambda13_ (BudgieRaven* self,
                  BudgieAnimation* a);
static void ___lambda13__budgie_anim_completion_func (BudgieAnimation* src,
                                               gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda14_ (Block4Data* _data4_,
                  BudgieRavenWidgetData* widget_data);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda14__gfunc (gconstpointer data,
                         gpointer self);
static void budgie_raven_create_widget_instance_with_uuid (BudgieRaven* self,
                                                    const gchar* module_name,
                                                    const gchar* uuid);
static gboolean budgie_raven_load_default_from_config (BudgieRaven* self,
                                                const gchar* uri);
static void g_cclosure_user_marshal_VOID__BUDGIE_RAVEN_WIDGET_DATA (GClosure * closure,
                                                             GValue * return_value,
                                                             guint n_param_values,
                                                             const GValue * param_values,
                                                             gpointer invocation_hint,
                                                             gpointer marshal_data);
static void budgie_raven_finalize (GObject * obj);
static GType budgie_raven_get_type_once (void);
static void _vala_budgie_raven_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_budgie_raven_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ClearNotifications_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ClearNotifications_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_ClearNotifications = {-1, "ClearNotifications", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ClearNotifications_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ClearNotifications_out), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_GetExpanded_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetExpanded_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetExpanded_out[] = {&_budgie_raven_iface_dbus_arg_info_GetExpanded_result, NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_GetExpanded = {-1, "GetExpanded", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetExpanded_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetExpanded_out), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_GetLeftAnchored_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetLeftAnchored_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetLeftAnchored_out[] = {&_budgie_raven_iface_dbus_arg_info_GetLeftAnchored_result, NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_GetLeftAnchored = {-1, "GetLeftAnchored", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetLeftAnchored_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetLeftAnchored_out), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_SetExpanded_b = {-1, "b", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_SetExpanded_in[] = {&_budgie_raven_iface_dbus_arg_info_SetExpanded_b, NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_SetExpanded_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_SetExpanded = {-1, "SetExpanded", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_SetExpanded_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_SetExpanded_out), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_Toggle_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_Toggle_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_Toggle = {-1, "Toggle", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_Toggle_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_Toggle_out), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ToggleAppletView_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ToggleAppletView_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_ToggleAppletView = {-1, "ToggleAppletView", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ToggleAppletView_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ToggleAppletView_out), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ToggleNotificationsView_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_ToggleNotificationsView_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_ToggleNotificationsView = {-1, "ToggleNotificationsView", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ToggleNotificationsView_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_ToggleNotificationsView_out), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_Dismiss_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_Dismiss_out[] = {NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_Dismiss = {-1, "Dismiss", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_Dismiss_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_Dismiss_out), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_GetNotificationCount_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetNotificationCount_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_GetNotificationCount_out[] = {&_budgie_raven_iface_dbus_arg_info_GetNotificationCount_result, NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_GetNotificationCount = {-1, "GetNotificationCount", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetNotificationCount_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_GetNotificationCount_out), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_get_version_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_get_version_in[] = {NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_get_version_out[] = {&_budgie_raven_iface_dbus_arg_info_get_version_result, NULL};
static const GDBusMethodInfo _budgie_raven_iface_dbus_method_info_get_version = {-1, "GetVersion", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_get_version_in), (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_get_version_out), NULL};
static const GDBusMethodInfo * const _budgie_raven_iface_dbus_method_info[] = {&_budgie_raven_iface_dbus_method_info_ClearNotifications, &_budgie_raven_iface_dbus_method_info_GetExpanded, &_budgie_raven_iface_dbus_method_info_GetLeftAnchored, &_budgie_raven_iface_dbus_method_info_SetExpanded, &_budgie_raven_iface_dbus_method_info_Toggle, &_budgie_raven_iface_dbus_method_info_ToggleAppletView, &_budgie_raven_iface_dbus_method_info_ToggleNotificationsView, &_budgie_raven_iface_dbus_method_info_Dismiss, &_budgie_raven_iface_dbus_method_info_GetNotificationCount, &_budgie_raven_iface_dbus_method_info_get_version, NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_expansion_changed_expanded = {-1, "expanded", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_expansion_changed[] = {&_budgie_raven_iface_dbus_arg_info_expansion_changed_expanded, NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_expansion_changed = {-1, "ExpansionChanged", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_expansion_changed), NULL};
static const GDBusArgInfo _budgie_raven_iface_dbus_arg_info_anchor_changed_anchored = {-1, "anchored", "b", NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_anchor_changed[] = {&_budgie_raven_iface_dbus_arg_info_anchor_changed_anchored, NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_anchor_changed = {-1, "AnchorChanged", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_anchor_changed), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_notifications_changed[] = {NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_notifications_changed = {-1, "NotificationsChanged", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_notifications_changed), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_clear_all_notifications[] = {NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_clear_all_notifications = {-1, "ClearAllNotifications", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_clear_all_notifications), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_unread_notifications[] = {NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_unread_notifications = {-1, "UnreadNotifications", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_unread_notifications), NULL};
static const GDBusArgInfo * const _budgie_raven_iface_dbus_arg_info_read_notifications[] = {NULL};
static const GDBusSignalInfo _budgie_raven_iface_dbus_signal_info_read_notifications = {-1, "ReadNotifications", (GDBusArgInfo **) (&_budgie_raven_iface_dbus_arg_info_read_notifications), NULL};
static const GDBusSignalInfo * const _budgie_raven_iface_dbus_signal_info[] = {&_budgie_raven_iface_dbus_signal_info_expansion_changed, &_budgie_raven_iface_dbus_signal_info_anchor_changed, &_budgie_raven_iface_dbus_signal_info_notifications_changed, &_budgie_raven_iface_dbus_signal_info_clear_all_notifications, &_budgie_raven_iface_dbus_signal_info_unread_notifications, &_budgie_raven_iface_dbus_signal_info_read_notifications, NULL};
static const GDBusPropertyInfo _budgie_raven_iface_dbus_property_info_is_expanded = {-1, "IsExpanded", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _budgie_raven_iface_dbus_property_info[] = {&_budgie_raven_iface_dbus_property_info_is_expanded, NULL};
static const GDBusInterfaceInfo _budgie_raven_iface_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_budgie_raven_iface_dbus_method_info), (GDBusSignalInfo **) (&_budgie_raven_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_raven_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_raven_iface_dbus_interface_vtable = {budgie_raven_iface_dbus_interface_method_call, budgie_raven_iface_dbus_interface_get_property, budgie_raven_iface_dbus_interface_set_property};

/**
 * Possible positions for Raven to be in.
 *
 * Automatic positioning will make Raven open on whichever side
 * of the screen that the Raven toggle button is on.
 */
/**
 * Get a user-friendly localized name for the position.
 */
gchar*
budgie_raven_position_get_display_name (BudgieRavenPosition self)
{
	gchar* result;
	switch (self) {
		case BUDGIE_RAVEN_POSITION_LEFT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Left"));
			result = _tmp0_;
			return result;
		}
		case BUDGIE_RAVEN_POSITION_RIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Right"));
			result = _tmp1_;
			return result;
		}
		default:
		case BUDGIE_RAVEN_POSITION_AUTOMATIC:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Automatic"));
			result = _tmp2_;
			return result;
		}
	}
}

static GType
budgie_raven_position_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_RAVEN_POSITION_AUTOMATIC, "BUDGIE_RAVEN_POSITION_AUTOMATIC", "automatic"}, {BUDGIE_RAVEN_POSITION_LEFT, "BUDGIE_RAVEN_POSITION_LEFT", "left"}, {BUDGIE_RAVEN_POSITION_RIGHT, "BUDGIE_RAVEN_POSITION_RIGHT", "right"}, {0, NULL, NULL}};
	GType budgie_raven_position_type_id;
	budgie_raven_position_type_id = g_enum_register_static ("BudgieRavenPosition", values);
	return budgie_raven_position_type_id;
}

GType
budgie_raven_position_get_type (void)
{
	static volatile gsize budgie_raven_position_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_position_type_id__once)) {
		GType budgie_raven_position_type_id;
		budgie_raven_position_type_id = budgie_raven_position_get_type_once ();
		g_once_init_leave (&budgie_raven_position_type_id__once, budgie_raven_position_type_id);
	}
	return budgie_raven_position_type_id__once;
}

gchar*
budgie_notification_sort_get_display_name (BudgieNotificationSort self)
{
	gchar* result;
	switch (self) {
		case BUDGIE_NOTIFICATION_SORT_OLD_NEW:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Oldest to newest"));
			result = _tmp0_;
			return result;
		}
		default:
		case BUDGIE_NOTIFICATION_SORT_NEW_OLD:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Newest to oldest"));
			result = _tmp1_;
			return result;
		}
	}
}

static GType
budgie_notification_sort_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_SORT_NEW_OLD, "BUDGIE_NOTIFICATION_SORT_NEW_OLD", "new-old"}, {BUDGIE_NOTIFICATION_SORT_OLD_NEW, "BUDGIE_NOTIFICATION_SORT_OLD_NEW", "old-new"}, {0, NULL, NULL}};
	GType budgie_notification_sort_type_id;
	budgie_notification_sort_type_id = g_enum_register_static ("BudgieNotificationSort", values);
	return budgie_notification_sort_type_id;
}

GType
budgie_notification_sort_get_type (void)
{
	static volatile gsize budgie_notification_sort_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_sort_type_id__once)) {
		GType budgie_notification_sort_type_id;
		budgie_notification_sort_type_id = budgie_notification_sort_get_type_once ();
		g_once_init_leave (&budgie_notification_sort_type_id__once, budgie_notification_sort_type_id);
	}
	return budgie_notification_sort_type_id__once;
}

static inline gpointer
budgie_raven_iface_get_instance_private (BudgieRavenIface* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenIface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieRavenIface*
budgie_raven_iface_construct (GType object_type,
                              BudgieRaven* parent)
{
	BudgieRavenIface* self = NULL;
	BudgieRaven* _tmp0_;
	self = (BudgieRavenIface*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp0_;
	return self;
}

BudgieRavenIface*
budgie_raven_iface_new (BudgieRaven* parent)
{
	return budgie_raven_iface_construct (BUDGIE_TYPE_RAVEN_IFACE, parent);
}

void
budgie_raven_iface_ClearNotifications (BudgieRavenIface* self,
                                       GError** error)
{
	g_return_if_fail (self != NULL);
	self->notifications = (guint) 0;
	g_signal_emit (self, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_READ_NOTIFICATIONS_SIGNAL], 0);
	g_signal_emit (self, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_CLEAR_ALL_NOTIFICATIONS_SIGNAL], 0);
}

gboolean
budgie_raven_iface_GetExpanded (BudgieRavenIface* self,
                                GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = budgie_raven_iface_get_is_expanded (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

gboolean
budgie_raven_iface_GetLeftAnchored (BudgieRavenIface* self,
                                    GError** error)
{
	BudgieRaven* _tmp0_;
	GtkPositionType _tmp1_;
	GtkPositionType _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->parent;
	_tmp1_ = budgie_raven_get_screen_edge (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == GTK_POS_LEFT;
	return result;
}

void
budgie_raven_iface_SetExpanded (BudgieRavenIface* self,
                                gboolean b,
                                GError** error)
{
	g_return_if_fail (self != NULL);
	budgie_raven_iface_set_is_expanded (self, b);
}

void
budgie_raven_iface_Toggle (BudgieRavenIface* self,
                           GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_raven_iface_get_is_expanded (self);
	_tmp1_ = _tmp0_;
	budgie_raven_iface_set_is_expanded (self, !_tmp1_);
	_tmp2_ = budgie_raven_iface_get_is_expanded (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		if (self->notifications == ((guint) 0)) {
			BudgieRaven* _tmp4_;
			_tmp4_ = self->priv->parent;
			budgie_raven_expose_main_view (_tmp4_);
		} else {
			BudgieRaven* _tmp5_;
			_tmp5_ = self->priv->parent;
			budgie_raven_expose_notification (_tmp5_);
			g_signal_emit (self, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_READ_NOTIFICATIONS_SIGNAL], 0);
		}
	}
}

/**
* Toggle Raven, opening only the "main" applet view
*/
void
budgie_raven_iface_ToggleAppletView (BudgieRavenIface* self,
                                     GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BudgieRaven* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_raven_iface_get_is_expanded (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = budgie_raven_iface_get_is_expanded (self);
		_tmp3_ = _tmp2_;
		budgie_raven_iface_set_is_expanded (self, !_tmp3_);
		return;
	}
	_tmp4_ = self->priv->parent;
	budgie_raven_expose_main_view (_tmp4_);
	_tmp5_ = budgie_raven_iface_get_is_expanded (self);
	_tmp6_ = _tmp5_;
	budgie_raven_iface_set_is_expanded (self, !_tmp6_);
}

/**
* Toggle Raven, opening only the "main" applet view
*/
void
budgie_raven_iface_ToggleNotificationsView (BudgieRavenIface* self,
                                            GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BudgieRaven* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_raven_iface_get_is_expanded (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = budgie_raven_iface_get_is_expanded (self);
		_tmp3_ = _tmp2_;
		budgie_raven_iface_set_is_expanded (self, !_tmp3_);
		return;
	}
	_tmp4_ = self->priv->parent;
	budgie_raven_expose_notification (_tmp4_);
	_tmp5_ = budgie_raven_iface_get_is_expanded (self);
	_tmp6_ = _tmp5_;
	budgie_raven_iface_set_is_expanded (self, !_tmp6_);
}

void
budgie_raven_iface_Dismiss (BudgieRavenIface* self,
                            GError** error)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_raven_iface_get_is_expanded (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = budgie_raven_iface_get_is_expanded (self);
		_tmp3_ = _tmp2_;
		budgie_raven_iface_set_is_expanded (self, !_tmp3_);
	}
}

guint
budgie_raven_iface_GetNotificationCount (BudgieRavenIface* self,
                                         GError** error)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->notifications;
	return result;
}

gchar*
budgie_raven_iface_get_version (BudgieRavenIface* self,
                                GError** error)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("1");
	result = _tmp0_;
	return result;
}

gboolean
budgie_raven_iface_get_is_expanded (BudgieRavenIface* self)
{
	gboolean result;
	BudgieRaven* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->parent;
	result = budgie_raven_get_expanded (_tmp0_);
	return result;
}

void
budgie_raven_iface_set_is_expanded (BudgieRavenIface* self,
                                    gboolean value)
{
	BudgieRaven* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parent;
	budgie_raven_set_expanded (_tmp0_, value);
}

static void
budgie_value_raven_iface_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_raven_iface_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_raven_iface_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_raven_iface_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_raven_iface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_raven_iface_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_raven_iface_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieRavenIface * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_raven_iface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_raven_iface_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	BudgieRavenIface ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_raven_iface_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_raven_iface (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	BudgieParamSpecRavenIface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_RAVEN_IFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_raven_iface (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_IFACE), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_raven_iface (GValue* value,
                              gpointer v_object)
{
	BudgieRavenIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_raven_iface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_iface_unref (old);
	}
}

void
budgie_value_take_raven_iface (GValue* value,
                               gpointer v_object)
{
	BudgieRavenIface * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_iface_unref (old);
	}
}

static void
budgie_raven_iface_class_init (BudgieRavenIfaceClass * klass,
                               gpointer klass_data)
{
	budgie_raven_iface_parent_class = g_type_class_peek_parent (klass);
	((BudgieRavenIfaceClass *) klass)->finalize = budgie_raven_iface_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieRavenIface_private_offset);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_EXPANSION_CHANGED_SIGNAL] = g_signal_new ("expansion-changed", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_ANCHOR_CHANGED_SIGNAL] = g_signal_new ("anchor-changed", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_NOTIFICATIONS_CHANGED_SIGNAL] = g_signal_new ("notifications-changed", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_CLEAR_ALL_NOTIFICATIONS_SIGNAL] = g_signal_new ("clear-all-notifications", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_UNREAD_NOTIFICATIONS_SIGNAL] = g_signal_new ("unread-notifications", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_READ_NOTIFICATIONS_SIGNAL] = g_signal_new ("read-notifications", BUDGIE_TYPE_RAVEN_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_raven_iface_instance_init (BudgieRavenIface * self,
                                  gpointer klass)
{
	self->priv = budgie_raven_iface_get_instance_private (self);
	self->priv->parent = NULL;
	self->notifications = (guint) 0;
	self->ref_count = 1;
}

static void
budgie_raven_iface_finalize (BudgieRavenIface * obj)
{
	BudgieRavenIface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_IFACE, BudgieRavenIface);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->parent);
}

static GType
budgie_raven_iface_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_raven_iface_init, budgie_value_raven_iface_free_value, budgie_value_raven_iface_copy_value, budgie_value_raven_iface_peek_pointer, "p", budgie_value_raven_iface_collect_value, "p", budgie_value_raven_iface_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenIfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_iface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenIface), 0, (GInstanceInitFunc) budgie_raven_iface_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_raven_iface_type_id;
	budgie_raven_iface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieRavenIface", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_raven_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_raven_iface_register_object);
	BudgieRavenIface_private_offset = g_type_add_instance_private (budgie_raven_iface_type_id, sizeof (BudgieRavenIfacePrivate));
	return budgie_raven_iface_type_id;
}

GType
budgie_raven_iface_get_type (void)
{
	static volatile gsize budgie_raven_iface_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_iface_type_id__once)) {
		GType budgie_raven_iface_type_id;
		budgie_raven_iface_type_id = budgie_raven_iface_get_type_once ();
		g_once_init_leave (&budgie_raven_iface_type_id__once, budgie_raven_iface_type_id);
	}
	return budgie_raven_iface_type_id__once;
}

gpointer
budgie_raven_iface_ref (gpointer instance)
{
	BudgieRavenIface * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_raven_iface_unref (gpointer instance)
{
	BudgieRavenIface * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_RAVEN_IFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_raven_iface_ClearNotifications (BudgieRavenIface* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_raven_iface_ClearNotifications (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_GetExpanded (BudgieRavenIface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_raven_iface_GetExpanded (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_GetLeftAnchored (BudgieRavenIface* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_raven_iface_GetLeftAnchored (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_SetExpanded (BudgieRavenIface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean b = FALSE;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	b = g_variant_get_boolean (_tmp29_);
	g_variant_unref (_tmp29_);
	budgie_raven_iface_SetExpanded (self, b, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_Toggle (BudgieRavenIface* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_raven_iface_Toggle (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_ToggleAppletView (BudgieRavenIface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_raven_iface_ToggleAppletView (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_ToggleNotificationsView (BudgieRavenIface* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_raven_iface_ToggleNotificationsView (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_Dismiss (BudgieRavenIface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_raven_iface_Dismiss (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_GetNotificationCount (BudgieRavenIface* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_raven_iface_GetNotificationCount (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_raven_iface_get_version (BudgieRavenIface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_raven_iface_get_version (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_raven_iface_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ClearNotifications") == 0) {
		_dbus_budgie_raven_iface_ClearNotifications (object, parameters, invocation);
	} else if (strcmp (method_name, "GetExpanded") == 0) {
		_dbus_budgie_raven_iface_GetExpanded (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLeftAnchored") == 0) {
		_dbus_budgie_raven_iface_GetLeftAnchored (object, parameters, invocation);
	} else if (strcmp (method_name, "SetExpanded") == 0) {
		_dbus_budgie_raven_iface_SetExpanded (object, parameters, invocation);
	} else if (strcmp (method_name, "Toggle") == 0) {
		_dbus_budgie_raven_iface_Toggle (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleAppletView") == 0) {
		_dbus_budgie_raven_iface_ToggleAppletView (object, parameters, invocation);
	} else if (strcmp (method_name, "ToggleNotificationsView") == 0) {
		_dbus_budgie_raven_iface_ToggleNotificationsView (object, parameters, invocation);
	} else if (strcmp (method_name, "Dismiss") == 0) {
		_dbus_budgie_raven_iface_Dismiss (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNotificationCount") == 0) {
		_dbus_budgie_raven_iface_GetNotificationCount (object, parameters, invocation);
	} else if (strcmp (method_name, "GetVersion") == 0) {
		_dbus_budgie_raven_iface_get_version (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_budgie_raven_iface_get_is_expanded (BudgieRavenIface* self)
{
	gboolean result;
	GVariant* _reply;
	result = budgie_raven_iface_get_is_expanded (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
budgie_raven_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "IsExpanded") == 0) {
		return _dbus_budgie_raven_iface_get_is_expanded (object);
	}
	return NULL;
}

static void
_dbus_budgie_raven_iface_set_is_expanded (BudgieRavenIface* self,
                                          GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	budgie_raven_iface_set_is_expanded (self, value);
}

static gboolean
budgie_raven_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "IsExpanded") == 0) {
		_dbus_budgie_raven_iface_set_is_expanded (object, value);
		return TRUE;
	}
	return FALSE;
}

static void
_dbus_budgie_raven_iface_expansion_changed (GObject* _sender,
                                            gboolean expanded,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (expanded));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ExpansionChanged", _arguments, NULL);
}

static void
_dbus_budgie_raven_iface_anchor_changed (GObject* _sender,
                                         gboolean anchored,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (anchored));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "AnchorChanged", _arguments, NULL);
}

static void
_dbus_budgie_raven_iface_notifications_changed (GObject* _sender,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "NotificationsChanged", _arguments, NULL);
}

static void
_dbus_budgie_raven_iface_clear_all_notifications (GObject* _sender,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ClearAllNotifications", _arguments, NULL);
}

static void
_dbus_budgie_raven_iface_unread_notifications (GObject* _sender,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "UnreadNotifications", _arguments, NULL);
}

static void
_dbus_budgie_raven_iface_read_notifications (GObject* _sender,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ReadNotifications", _arguments, NULL);
}

guint
budgie_raven_iface_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_raven_iface_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_raven_iface_dbus_interface_info), &_budgie_raven_iface_dbus_interface_vtable, data, _budgie_raven_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "expansion-changed", (GCallback) _dbus_budgie_raven_iface_expansion_changed, data);
	g_signal_connect (object, "anchor-changed", (GCallback) _dbus_budgie_raven_iface_anchor_changed, data);
	g_signal_connect (object, "notifications-changed", (GCallback) _dbus_budgie_raven_iface_notifications_changed, data);
	g_signal_connect (object, "clear-all-notifications", (GCallback) _dbus_budgie_raven_iface_clear_all_notifications, data);
	g_signal_connect (object, "unread-notifications", (GCallback) _dbus_budgie_raven_iface_unread_notifications, data);
	g_signal_connect (object, "read-notifications", (GCallback) _dbus_budgie_raven_iface_read_notifications, data);
	return result;
}

static void
_budgie_raven_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_expansion_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_anchor_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_notifications_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_clear_all_notifications, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_unread_notifications, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_raven_iface_read_notifications, data);
	budgie_raven_iface_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_raven_get_instance_private (BudgieRaven* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRaven_private_offset);
}

static void
_budgie_raven_widget_data_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (budgie_raven_widget_data_unref (var), NULL));
}

static inline void
_g_list_free__budgie_raven_widget_data_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _budgie_raven_widget_data_unref0_);
}

void
budgie_raven_ReadNotifications (BudgieRaven* self)
{
	BudgieRavenIface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->iface;
	if (_tmp0_ != NULL) {
		BudgieRavenIface* _tmp1_;
		_tmp1_ = self->priv->iface;
		g_signal_emit (_tmp1_, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_READ_NOTIFICATIONS_SIGNAL], 0);
	}
}

void
budgie_raven_UnreadNotifications (BudgieRaven* self)
{
	BudgieRavenIface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->iface;
	if (_tmp0_ != NULL) {
		BudgieRavenIface* _tmp1_;
		_tmp1_ = self->priv->iface;
		g_signal_emit (_tmp1_, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_UNREAD_NOTIFICATIONS_SIGNAL], 0);
	}
}

static void
budgie_raven_on_bus_acquired (BudgieRaven* self,
                              GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		BudgieRavenIface* _tmp0_;
		BudgieRavenIface* _tmp1_;
		BudgieRavenPluginManager* _tmp2_;
		_tmp0_ = budgie_raven_iface_new (self);
		_budgie_raven_iface_unref0 (self->priv->iface);
		self->priv->iface = _tmp0_;
		_tmp1_ = self->priv->iface;
		budgie_raven_iface_register_object (_tmp1_, conn, BUDGIE_RAVEN_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->plugin_manager;
		budgie_raven_plugin_manager_setup_plugins (_tmp2_);
		budgie_raven_load_existing_widgets (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e->message;
		fprintf (_tmp3_, "Error registering Raven: %s\n", _tmp4_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
budgie_raven_expose_main_view (BudgieRaven* self)
{
	BudgieMainView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	budgie_main_view_set_clean (_tmp0_);
}

void
budgie_raven_expose_notification (BudgieRaven* self)
{
	BudgieMainView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	budgie_main_view_expose_notification (_tmp0_);
}

BudgieRaven*
budgie_raven_get_instance (void)
{
	BudgieRaven* _tmp0_;
	BudgieRaven* result;
	_tmp0_ = budgie_raven__instance;
	result = _tmp0_;
	return result;
}

void
budgie_raven_set_notification_count (BudgieRaven* self,
                                     guint count)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->n_count != count) {
		BudgieRavenIface* _tmp1_;
		_tmp1_ = self->priv->iface;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BudgieRavenIface* _tmp2_;
		BudgieRavenIface* _tmp3_;
		self->priv->n_count = count;
		_tmp2_ = self->priv->iface;
		_tmp2_->notifications = count;
		_tmp3_ = self->priv->iface;
		g_signal_emit (_tmp3_, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_NOTIFICATIONS_CHANGED_SIGNAL], 0);
	}
}

static gboolean
budgie_raven_on_focus_out (BudgieRaven* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->expanded) {
		budgie_raven_set_expanded (self, FALSE);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
budgie_raven_steal_focus (BudgieRaven* self)
{
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		return;
	}
	g_object_get ((GtkWindow*) self, "has-toplevel-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GdkDisplay* display = NULL;
		GdkScreen* _tmp4_;
		GdkScreen* _tmp5_;
		GdkDisplay* _tmp6_;
		GdkDisplay* _tmp7_;
		GdkDisplay* _tmp8_;
		_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gdk_screen_get_display (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		display = _tmp7_;
		_tmp8_ = display;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gdk_x11_display_get_type ())) {
			GdkWindow* _tmp9_;
			GdkDisplay* _tmp10_;
			_tmp9_ = window;
			_tmp10_ = display;
			gdk_window_focus (_tmp9_, gdk_x11_display_get_user_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gdk_x11_display_get_type (), GdkX11Display)));
		} else {
			GdkWindow* _tmp11_;
			_tmp11_ = window;
			gdk_window_focus (_tmp11_, gtk_get_current_event_time ());
		}
		_g_object_unref0 (display);
	}
}

static void
__lambda15_ (BudgieRaven* self)
{
	GdkRectangle _tmp0_;
	_tmp0_ = self->priv->old_rect;
	budgie_raven_update_geometry (self, &_tmp0_);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ ((BudgieRaven*) self);
}

static gboolean
_budgie_raven_on_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                       GdkEventFocus* event,
                                                       gpointer self)
{
	gboolean result;
	result = budgie_raven_on_focus_out ((BudgieRaven*) self);
	return result;
}

static gboolean
__lambda16_ (BudgieRaven* self,
             GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	budgie_raven_steal_focus (self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda16__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda16_ ((BudgieRaven*) self, event);
	return result;
}

static void
__lambda17_ (BudgieRaven* self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda17__budgie_main_view_requested_draw (BudgieMainView* _sender,
                                              gpointer self)
{
	__lambda17_ ((BudgieRaven*) self);
}

BudgieRaven*
budgie_raven_construct (GType object_type,
                        BudgieDesktopManager* manager,
                        BudgieRavenPluginManager* plugin_manager)
{
	BudgieRaven * self = NULL;
	GtkStyleContext* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	BudgieRaven* _tmp3_;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp4_;
	GdkScreen* _tmp5_;
	GdkVisual* _tmp6_;
	GdkVisual* _tmp7_;
	GdkVisual* _tmp8_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	BudgieShadowBlock* _tmp12_;
	GtkBox* _tmp13_;
	BudgieShadowBlock* _tmp14_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp15_;
	GtkFrame* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkBox* _tmp18_;
	GtkFrame* _tmp19_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkFrame* _tmp23_;
	GtkBox* _tmp24_;
	BudgieMainView* _tmp25_;
	GtkBox* _tmp26_;
	BudgieMainView* _tmp27_;
	BudgieMainView* _tmp28_;
	GtkWidget* _tmp29_;
	self = (BudgieRaven*) g_object_new (object_type, "type-hint", GDK_WINDOW_TYPE_HINT_DOCK, "manager", manager, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "budgie-container");
	_tmp1_ = g_settings_new ("com.solus-project.budgie-raven");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.buddiesofbudgie.budgie-desktop.raven.widgets");
	_g_object_unref0 (self->priv->widget_settings);
	self->priv->widget_settings = _tmp2_;
	_tmp3_ = _g_object_ref0 (self);
	_g_object_unref0 (budgie_raven__instance);
	budgie_raven__instance = _tmp3_;
	(self->priv->widgets == NULL) ? NULL : (self->priv->widgets = (_g_list_free__budgie_raven_widget_data_unref0_ (self->priv->widgets), NULL));
	self->priv->widgets = NULL;
	self->priv->plugin_manager = plugin_manager;
	_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gdk_screen_get_rgba_visual (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	vis = _tmp7_;
	_tmp8_ = vis;
	if (_tmp8_ == NULL) {
		g_warning ("raven.vala:310: No RGBA functionality");
	} else {
		GdkVisual* _tmp9_;
		_tmp9_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp9_);
	}
	g_signal_connect_object ((GObject*) self, "notify::scale-factor", (GCallback) ___lambda15__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _budgie_raven_on_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp10_;
	_tmp11_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda16__gtk_widget_enter_notify_event, self, 0);
	_tmp12_ = budgie_shadow_block_new (BUDGIE_PANEL_POSITION_RIGHT);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->shadow);
	self->priv->shadow = _tmp12_;
	_tmp13_ = self->priv->layout;
	_tmp14_ = self->priv->shadow;
	gtk_box_pack_start (_tmp13_, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp15_);
	frame = _tmp15_;
	_tmp16_ = frame;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "raven-frame");
	_tmp18_ = self->priv->layout;
	_tmp19_ = frame;
	gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, TRUE, TRUE, (guint) 0);
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp20_);
	main_box = _tmp20_;
	_tmp21_ = main_box;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, "raven");
	_tmp23_ = frame;
	_tmp24_ = main_box;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = budgie_main_view_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp25_;
	_tmp26_ = main_box;
	_tmp27_ = self->priv->main_view;
	gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = self->priv->main_view;
	g_signal_connect_object (_tmp28_, "requested-draw", (GCallback) ___lambda17__budgie_main_view_requested_draw, self, 0);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, -1);
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	_tmp29_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp29_);
	budgie_raven_set_screen_edge (self, GTK_POS_LEFT);
	_g_object_unref0 (main_box);
	_g_object_unref0 (frame);
	_g_object_unref0 (vis);
	return self;
}

BudgieRaven*
budgie_raven_new (BudgieDesktopManager* manager,
                  BudgieRavenPluginManager* plugin_manager)
{
	return budgie_raven_construct (BUDGIE_TYPE_RAVEN, manager, plugin_manager);
}

static void
budgie_raven_real_size_allocate (GtkWidget* base,
                                 GtkAllocation* rect)
{
	BudgieRaven * self;
	gint w = 0;
	GtkAllocation _tmp0_;
	gint _tmp1_;
	self = (BudgieRaven*) base;
	g_return_if_fail (rect != NULL);
	w = 0;
	_tmp0_ = *rect;
	GTK_WIDGET_CLASS (budgie_raven_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_);
	w = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = self->priv->_required_size;
	if (w != _tmp1_) {
		GdkRectangle _tmp2_;
		budgie_raven_set_required_size (self, w);
		_tmp2_ = self->priv->old_rect;
		budgie_raven_update_geometry (self, &_tmp2_);
	}
}

static void
_budgie_raven_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                      const gchar* name,
                                                      gpointer self)
{
	budgie_raven_on_bus_acquired ((BudgieRaven*) self, connection);
}

static void
__lambda18_ (BudgieRaven* self)
{
}

static void
___lambda18__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda18_ ((BudgieRaven*) self);
}

static void
__lambda19_ (BudgieRaven* self)
{
	g_warning ("raven.vala:380: Raven could not take dbus!");
}

static void
___lambda19__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda19_ ((BudgieRaven*) self);
}

void
budgie_raven_setup_dbus (BudgieRaven* self)
{
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_RAVEN_DBUS_NAME, G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_raven_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_raven_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda18__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda18__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda19__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda19__gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

/**
* Update our geometry based on other panels in the neighbourhood, and the screen we
* need to be on */
void
budgie_raven_update_geometry (BudgieRaven* self,
                              GdkRectangle* rect)
{
	gint width = 0;
	GtkBox* _tmp0_;
	gint x = 0;
	GtkPositionType _tmp1_;
	GtkPositionType _tmp2_;
	gint y = 0;
	GdkRectangle _tmp6_;
	gint height = 0;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = self->priv->layout;
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	_tmp1_ = budgie_raven_get_screen_edge (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GTK_POS_RIGHT) {
		GdkRectangle _tmp3_;
		GdkRectangle _tmp4_;
		_tmp3_ = *rect;
		_tmp4_ = *rect;
		x = (_tmp3_.x + _tmp4_.width) - width;
	} else {
		GdkRectangle _tmp5_;
		_tmp5_ = *rect;
		x = _tmp5_.x;
	}
	_tmp6_ = *rect;
	y = _tmp6_.y;
	_tmp7_ = *rect;
	height = _tmp7_.height;
	_tmp8_ = *rect;
	self->priv->old_rect = _tmp8_;
	gtk_window_move ((GtkWindow*) self, x, y);
	self->priv->our_height = height;
	self->priv->our_width = width;
	self->priv->our_x = x;
	self->priv->our_y = y;
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
}

static void
budgie_raven_real_get_preferred_height (GtkWidget* base,
                                        gint* m,
                                        gint* n)
{
	BudgieRaven * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	self = (BudgieRaven*) base;
	_vala_m = self->priv->our_height;
	_vala_n = self->priv->our_height;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}

static void
budgie_raven_real_get_preferred_height_for_width (GtkWidget* base,
                                                  gint w,
                                                  gint* m,
                                                  gint* n)
{
	BudgieRaven * self;
	gint _vala_m = 0;
	gint _vala_n = 0;
	self = (BudgieRaven*) base;
	_vala_m = self->priv->our_height;
	_vala_n = self->priv->our_height;
	if (m) {
		*m = _vala_m;
	}
	if (n) {
		*n = _vala_n;
	}
}

static gboolean
budgie_raven_real_draw (GtkWidget* base,
                        cairo_t* cr)
{
	BudgieRaven * self;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp5_;
	GdkWindow* _tmp6_;
	GdkWindow* _tmp7_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp8_ = {0};
	cairo_surface_t* buffer = NULL;
	GdkWindow* _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_t* cr2 = NULL;
	cairo_surface_t* _tmp19_;
	cairo_t* _tmp20_;
	GtkWidget* _tmp21_;
	cairo_t* _tmp22_;
	gdouble x = 0.0;
	GtkAllocation _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	GtkPositionType _tmp26_;
	GtkPositionType _tmp27_;
	gboolean result;
	self = (BudgieRaven*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp1_ = budgie_raven_get_nscale (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0.0) {
		_tmp0_ = TRUE;
	} else {
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp3_ = budgie_raven_get_nscale (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == 1.0;
	}
	if (_tmp0_) {
		result = GTK_WIDGET_CLASS (budgie_raven_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), cr);
		return result;
	}
	cairo_save (cr);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.0);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	cairo_paint (cr);
	cairo_restore (cr);
	_tmp5_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	window = _tmp6_;
	_tmp7_ = window;
	if (_tmp7_ == NULL) {
		result = GDK_EVENT_STOP;
		_g_object_unref0 (window);
		return result;
	}
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp8_);
	alloc = _tmp8_;
	_tmp9_ = window;
	_tmp10_ = alloc;
	_tmp11_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = alloc;
	_tmp14_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gtk_widget_get_scale_factor ((GtkWidget*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = gdk_window_create_similar_image_surface (_tmp9_, CAIRO_FORMAT_ARGB32, _tmp10_.width * _tmp12_, _tmp13_.height * _tmp15_, _tmp17_);
	buffer = _tmp18_;
	_tmp19_ = buffer;
	_tmp20_ = cairo_create (_tmp19_);
	cr2 = _tmp20_;
	_tmp21_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp22_ = cr2;
	gtk_container_propagate_draw ((GtkContainer*) self, _tmp21_, _tmp22_);
	_tmp23_ = alloc;
	_tmp24_ = budgie_raven_get_nscale (self);
	_tmp25_ = _tmp24_;
	x = ((gdouble) _tmp23_.width) * _tmp25_;
	_tmp26_ = budgie_raven_get_screen_edge (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == GTK_POS_RIGHT) {
		cairo_surface_t* _tmp28_;
		GtkAllocation _tmp29_;
		_tmp28_ = buffer;
		_tmp29_ = alloc;
		cairo_set_source_surface (cr, _tmp28_, _tmp29_.width - x, (gdouble) 0);
	} else {
		cairo_surface_t* _tmp30_;
		GtkAllocation _tmp31_;
		_tmp30_ = buffer;
		_tmp31_ = alloc;
		cairo_set_source_surface (cr, _tmp30_, x - _tmp31_.width, (gdouble) 0);
	}
	cairo_paint (cr);
	result = GDK_EVENT_STOP;
	_cairo_destroy0 (cr2);
	_cairo_surface_destroy0 (buffer);
	_g_object_unref0 (window);
	return result;
}

/**
* Slide Raven in or out of view
*/
static gdouble
_budgie_expo_ease_out_budgie_tween_func (gdouble factor,
                                         gpointer self)
{
	gdouble result;
	result = budgie_expo_ease_out (factor);
	return result;
}

static gdouble
_budgie_sine_ease_in_budgie_tween_func (gdouble factor,
                                        gpointer self)
{
	gdouble result;
	result = budgie_sine_ease_in (factor);
	return result;
}

static void
_vala_BudgiePropChange_array_free (BudgiePropChange * array,
                                   gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_prop_change_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
__lambda13_ (BudgieRaven* self,
             BudgieAnimation* a)
{
	BudgieRaven* r = NULL;
	GtkWidget* _tmp0_;
	BudgieRaven* _tmp1_;
	GtkWindow* w = NULL;
	GtkWidget* _tmp2_;
	GtkWindow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BudgieRaven* _tmp5_;
	_tmp0_ = a->widget;
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_RAVEN (_tmp0_) ? ((BudgieRaven*) _tmp0_) : NULL);
	r = _tmp1_;
	_tmp2_ = a->widget;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL);
	w = _tmp3_;
	_tmp5_ = r;
	if (_tmp5_ != NULL) {
		BudgieRaven* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp6_ = r;
		_tmp7_ = budgie_raven_get_nscale (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0.0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		BudgieRaven* _tmp9_;
		_tmp9_ = r;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
	} else {
		GtkWindow* _tmp10_;
		_tmp10_ = w;
		if (_tmp10_ != NULL) {
			GtkWindow* _tmp11_;
			GtkWindow* _tmp12_;
			_tmp11_ = w;
			gtk_window_present (_tmp11_);
			_tmp12_ = w;
			gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
			budgie_raven_steal_focus (self);
			budgie_raven_steal_focus (self);
		}
	}
	_g_object_unref0 (w);
	_g_object_unref0 (r);
}

static void
___lambda13__budgie_anim_completion_func (BudgieAnimation* src,
                                          gpointer self)
{
	__lambda13_ ((BudgieRaven*) self, src);
}

void
budgie_raven_set_expanded (BudgieRaven* self,
                           gboolean exp)
{
	gdouble old_op = 0.0;
	gdouble new_op = 0.0;
	BudgieMainView* _tmp1_;
	BudgieRavenIface* _tmp2_;
	GtkSettings* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	BudgieAnimation* anim = NULL;
	BudgieAnimation* _tmp6_;
	BudgieAnimation* _tmp7_;
	BudgieAnimation* _tmp12_;
	gchar* _tmp13_;
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	BudgiePropChange _tmp16_ = {0};
	BudgiePropChange* _tmp17_;
	BudgieAnimation* _tmp18_;
	g_return_if_fail (self != NULL);
	if (exp == self->priv->expanded) {
		return;
	}
	if (exp) {
		GdkRectangle _tmp0_;
		_tmp0_ = self->priv->old_rect;
		budgie_raven_update_geometry (self, &_tmp0_);
		old_op = 0.0;
		new_op = 1.0;
	} else {
		old_op = 1.0;
		new_op = 0.0;
	}
	budgie_raven_set_nscale (self, old_op);
	if (exp) {
		gtk_widget_show ((GtkWidget*) self);
	}
	self->priv->expanded = exp;
	_tmp1_ = self->priv->main_view;
	budgie_main_view_raven_expanded (_tmp1_, self->priv->expanded);
	_tmp2_ = self->priv->iface;
	g_signal_emit (_tmp2_, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_EXPANSION_CHANGED_SIGNAL], 0, self->priv->expanded);
	_tmp3_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp3_, "gtk-enable-animations", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		if (!exp) {
			budgie_raven_set_nscale (self, 0.0);
			gtk_widget_hide ((GtkWidget*) self);
		} else {
			budgie_raven_set_nscale (self, 1.0);
			gtk_window_present ((GtkWindow*) self);
			gtk_widget_grab_focus ((GtkWidget*) self);
			budgie_raven_steal_focus (self);
		}
		return;
	}
	_tmp6_ = budgie_animation_new ();
	anim = _tmp6_;
	_tmp7_ = anim;
	_tmp7_->widget = (GtkWidget*) self;
	if (exp) {
		BudgieAnimation* _tmp8_;
		BudgieAnimation* _tmp9_;
		_tmp8_ = anim;
		_tmp8_->length = 360 * BUDGIE_MSECOND;
		_tmp9_ = anim;
		_tmp9_->tween = _budgie_expo_ease_out_budgie_tween_func;
		_tmp9_->tween_target = NULL;
	} else {
		BudgieAnimation* _tmp10_;
		BudgieAnimation* _tmp11_;
		_tmp10_ = anim;
		_tmp10_->tween = _budgie_sine_ease_in_budgie_tween_func;
		_tmp10_->tween_target = NULL;
		_tmp11_ = anim;
		_tmp11_->length = 190 * BUDGIE_MSECOND;
	}
	_tmp12_ = anim;
	_tmp13_ = g_strdup ("nscale");
	g_value_init (&_tmp14_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp14_, old_op);
	g_value_init (&_tmp15_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp15_, new_op);
	memset (&_tmp16_, 0, sizeof (BudgiePropChange));
	_g_free0 (_tmp16_.property);
	_tmp16_.property = _tmp13_;
	G_IS_VALUE (&_tmp16_.old) ? (g_value_unset (&_tmp16_.old), NULL) : NULL;
	_tmp16_.old = _tmp14_;
	G_IS_VALUE (&_tmp16_.new) ? (g_value_unset (&_tmp16_.new), NULL) : NULL;
	_tmp16_.new = _tmp15_;
	_tmp17_ = g_new0 (BudgiePropChange, 1);
	_tmp17_[0] = _tmp16_;
	_tmp12_->changes = (_vala_BudgiePropChange_array_free (_tmp12_->changes, _tmp12_->changes_length1), NULL);
	_tmp12_->changes = _tmp17_;
	_tmp12_->changes_length1 = 1;
	_tmp18_ = anim;
	budgie_animation_start (_tmp18_, ___lambda13__budgie_anim_completion_func, self);
	_g_object_unref0 (anim);
}

gboolean
budgie_raven_get_expanded (BudgieRaven* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->expanded;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieRaven* self;
		self = _data4_->self;
		_data4_->uuids = (_vala_array_free (_data4_->uuids, _data4_->uuids_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda14_ (Block4Data* _data4_,
             BudgieRavenWidgetData* widget_data)
{
	BudgieRaven* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data4_->self;
	g_return_if_fail (widget_data != NULL);
	_tmp0_ = budgie_raven_widget_data_get_uuid (widget_data);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_vala_array_add1 (&_data4_->uuids, &_data4_->uuids_length1, &_data4_->_uuids_size_, _tmp2_);
}

static void
___lambda14__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda14_ (self, (BudgieRavenWidgetData*) data);
}

void
budgie_raven_update_uuids (BudgieRaven* self)
{
	Block4Data* _data4_;
	GList* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->uuids = NULL;
	_data4_->uuids_length1 = 0;
	_data4_->_uuids_size_ = _data4_->uuids_length1;
	_tmp0_ = self->priv->widgets;
	g_list_foreach (_tmp0_, ___lambda14__gfunc, _data4_);
	_tmp1_ = self->priv->widget_settings;
	g_settings_set_strv (_tmp1_, "uuids", _data4_->uuids);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static gpointer
_budgie_raven_widget_data_ref0 (gpointer self)
{
	return self ? budgie_raven_widget_data_ref (self) : NULL;
}

BudgieRavenWidgetCreationResult
budgie_raven_create_widget_instance (BudgieRaven* self,
                                     const gchar* module_name)
{
	BudgieRavenWidgetData* widget_data = NULL;
	BudgieRavenWidgetCreationResult _result_ = 0;
	BudgieRavenPluginManager* _tmp0_;
	BudgieRavenWidgetData* _tmp1_ = NULL;
	BudgieRavenWidgetCreationResult _tmp2_;
	BudgieRavenWidgetCreationResult result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (module_name != NULL, 0);
	_tmp0_ = self->priv->plugin_manager;
	_tmp2_ = budgie_raven_plugin_manager_new_widget_instance_for_plugin (_tmp0_, module_name, NULL, &_tmp1_);
	_budgie_raven_widget_data_unref0 (widget_data);
	widget_data = _tmp1_;
	_result_ = _tmp2_;
	if (_result_ == BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS) {
		BudgieRavenWidgetData* _tmp3_;
		BudgieRavenWidgetData* _tmp4_;
		BudgieMainView* _tmp5_;
		BudgieRavenWidgetData* _tmp6_;
		GtkBin* _tmp7_;
		GtkBin* _tmp8_;
		BudgieRavenWidgetData* _tmp9_;
		_tmp3_ = widget_data;
		_tmp4_ = _budgie_raven_widget_data_ref0 (_tmp3_);
		self->priv->widgets = g_list_append (self->priv->widgets, _tmp4_);
		_tmp5_ = self->priv->main_view;
		_tmp6_ = widget_data;
		_tmp7_ = budgie_raven_widget_data_get_widget_instance (_tmp6_);
		_tmp8_ = _tmp7_;
		budgie_main_view_add_widget_instance (_tmp5_, _tmp8_);
		_tmp9_ = widget_data;
		g_signal_emit (self, budgie_raven_signals[BUDGIE_RAVEN_ON_WIDGET_ADDED_SIGNAL], 0, _tmp9_);
		budgie_raven_update_uuids (self);
	}
	result = _result_;
	_budgie_raven_widget_data_unref0 (widget_data);
	return result;
}

static void
budgie_raven_create_widget_instance_with_uuid (BudgieRaven* self,
                                               const gchar* module_name,
                                               const gchar* uuid)
{
	BudgieRavenWidgetData* widget_data = NULL;
	BudgieRavenWidgetCreationResult _result_ = 0;
	BudgieRavenPluginManager* _tmp0_;
	BudgieRavenWidgetData* _tmp1_ = NULL;
	BudgieRavenWidgetCreationResult _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (module_name != NULL);
	_tmp0_ = self->priv->plugin_manager;
	_tmp2_ = budgie_raven_plugin_manager_new_widget_instance_for_plugin (_tmp0_, module_name, uuid, &_tmp1_);
	_budgie_raven_widget_data_unref0 (widget_data);
	widget_data = _tmp1_;
	_result_ = _tmp2_;
	switch (_result_) {
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS:
		{
			BudgieRavenWidgetData* _tmp3_;
			BudgieRavenWidgetData* _tmp4_;
			BudgieMainView* _tmp5_;
			BudgieRavenWidgetData* _tmp6_;
			GtkBin* _tmp7_;
			GtkBin* _tmp8_;
			BudgieRavenWidgetData* _tmp9_;
			_tmp3_ = widget_data;
			_tmp4_ = _budgie_raven_widget_data_ref0 (_tmp3_);
			self->priv->widgets = g_list_append (self->priv->widgets, _tmp4_);
			_tmp5_ = self->priv->main_view;
			_tmp6_ = widget_data;
			_tmp7_ = budgie_raven_widget_data_get_widget_instance (_tmp6_);
			_tmp8_ = _tmp7_;
			budgie_main_view_add_widget_instance (_tmp5_, _tmp8_);
			_tmp9_ = widget_data;
			g_signal_emit (self, budgie_raven_signals[BUDGIE_RAVEN_ON_WIDGET_ADDED_SIGNAL], 0, _tmp9_);
			break;
		}
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_INFO_MISSING:
		{
			g_warning ("raven.vala:571: Failed to create Raven widget instance with uuid %s: N" \
"o plugin info found for module %s", uuid, module_name);
			break;
		}
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INVALID_MODULE_NAME:
		{
			GString* builder = NULL;
			GString* _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			GString* _tmp13_;
			const gchar* _tmp14_;
			_tmp10_ = g_string_new ("");
			builder = _tmp10_;
			_tmp11_ = builder;
			g_string_append (_tmp11_, "Failed to create Raven widget instance with uuid %s: Module name must " \
"be in reverse-DNS format.");
			_tmp12_ = builder;
			g_string_append (_tmp12_, "(e.g. 'tld.domain.group.WidgetName.so' for C/Vala or 'tld_domain_group" \
"_WidgetName' for Python)");
			_tmp13_ = builder;
			_tmp14_ = _tmp13_->str;
			g_warning (_tmp14_, uuid, module_name);
			_g_string_free0 (builder);
			break;
		}
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_LOAD_FAILED:
		{
			g_warning ("raven.vala:580: Failed to create Raven widget instance with uuid %s: P" \
"lugin with module %s failed to load", uuid, module_name);
			break;
		}
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SCHEMA_LOAD_FAILED:
		{
			g_warning ("raven.vala:583: Failed to create Raven widget instance with uuid %s: P" \
"lugin with module %s supports settings, but does not install a schema " \
"with the same name", uuid, module_name);
			break;
		}
		case BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INSTANCE_CREATION_FAILED:
		{
			g_warning ("raven.vala:586: Failed to create Raven widget instance with uuid %s: U" \
"nknown failure", uuid);
			break;
		}
		default:
		break;
	}
	_budgie_raven_widget_data_unref0 (widget_data);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
budgie_raven_load_existing_widgets (BudgieRaven* self)
{
	gchar** stored_uuids = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint stored_uuids_length1;
	gint _stored_uuids_size_;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSettings* _tmp16_;
	const gchar* uuid = NULL;
	GSettings* widget_info = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "uuids");
	stored_uuids = _tmp2_;
	stored_uuids_length1 = _vala_array_length (_tmp1_);
	_stored_uuids_size_ = stored_uuids_length1;
	_tmp4_ = stored_uuids;
	_tmp4__length1 = stored_uuids_length1;
	if (_tmp4__length1 == 0) {
		GSettings* _tmp5_;
		_tmp5_ = self->priv->widget_settings;
		_tmp3_ = !g_settings_get_boolean (_tmp5_, "initialized");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** system_configs = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint system_configs_length1;
		gint _system_configs_size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		budgie_raven_update_uuids (self);
		_tmp6_ = string_to_string (BUDGIE_CONFDIR);
		_tmp7_ = g_strconcat ("file://", _tmp6_, "/budgie-desktop/raven/widgets.ini", NULL);
		_tmp8_ = string_to_string (BUDGIE_DATADIR);
		_tmp9_ = g_strconcat ("file://", _tmp8_, "/budgie-desktop/raven/widgets.ini", NULL);
		_tmp10_ = g_strdup ("resource:///org/buddiesofbudgie/budgie-desktop/raven/widgets.ini");
		_tmp11_ = g_new0 (gchar*, 3 + 1);
		_tmp11_[0] = _tmp7_;
		_tmp11_[1] = _tmp9_;
		_tmp11_[2] = _tmp10_;
		system_configs = _tmp11_;
		system_configs_length1 = 3;
		_system_configs_size_ = system_configs_length1;
		_tmp12_ = system_configs;
		_tmp12__length1 = system_configs_length1;
		{
			gchar** filepath_collection = NULL;
			gint filepath_collection_length1 = 0;
			gint _filepath_collection_size_ = 0;
			gint filepath_it = 0;
			filepath_collection = _tmp12_;
			filepath_collection_length1 = _tmp12__length1;
			for (filepath_it = 0; filepath_it < filepath_collection_length1; filepath_it = filepath_it + 1) {
				gchar* _tmp13_;
				gchar* filepath = NULL;
				_tmp13_ = g_strdup (filepath_collection[filepath_it]);
				filepath = _tmp13_;
				{
					const gchar* _tmp14_;
					_tmp14_ = filepath;
					if (budgie_raven_load_default_from_config (self, _tmp14_)) {
						GSettings* _tmp15_;
						budgie_raven_update_uuids (self);
						_tmp15_ = self->priv->widget_settings;
						g_settings_set_boolean (_tmp15_, "initialized", TRUE);
						_g_free0 (filepath);
						break;
					}
					_g_free0 (filepath);
				}
			}
		}
		system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
		stored_uuids = (_vala_array_free (stored_uuids, stored_uuids_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp16_ = self->priv->widget_settings;
	g_settings_set_boolean (_tmp16_, "initialized", TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar** _tmp19_;
				gint _tmp19__length1;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				BudgieRavenPluginManager* _tmp22_;
				const gchar* _tmp23_;
				GSettings* _tmp24_;
				GSettings* _tmp25_;
				gchar* module_name = NULL;
				GSettings* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = stored_uuids;
				_tmp19__length1 = stored_uuids_length1;
				if (!(i < _tmp19__length1)) {
					break;
				}
				_tmp20_ = stored_uuids;
				_tmp20__length1 = stored_uuids_length1;
				_tmp21_ = _tmp20_[i];
				uuid = _tmp21_;
				_tmp22_ = self->priv->plugin_manager;
				_tmp23_ = uuid;
				_tmp24_ = budgie_raven_plugin_manager_get_widget_info_from_uuid (_tmp22_, _tmp23_);
				_g_object_unref0 (widget_info);
				widget_info = _tmp24_;
				_tmp25_ = widget_info;
				if (_tmp25_ == NULL) {
					const gchar* _tmp26_;
					_tmp26_ = uuid;
					g_warning ("raven.vala:630: Widget info for uuid %s is null", _tmp26_);
					continue;
				}
				_tmp27_ = widget_info;
				_tmp28_ = g_settings_get_string (_tmp27_, "module");
				module_name = _tmp28_;
				_tmp29_ = module_name;
				if (_tmp29_ == NULL) {
					const gchar* _tmp30_;
					_tmp30_ = uuid;
					g_warning ("raven.vala:636: Module name of widget instance %s is null", _tmp30_);
					_g_free0 (module_name);
					continue;
				}
				_tmp31_ = module_name;
				_tmp32_ = uuid;
				budgie_raven_create_widget_instance_with_uuid (self, _tmp31_, _tmp32_);
				_g_free0 (module_name);
			}
		}
	}
	budgie_raven_update_uuids (self);
	_g_object_unref0 (widget_info);
	stored_uuids = (_vala_array_free (stored_uuids, stored_uuids_length1, (GDestroyNotify) g_free), NULL);
}

GList*
budgie_raven_get_existing_widgets (BudgieRaven* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->widgets;
	_tmp1_ = g_list_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
budgie_raven_remove_widget (BudgieRaven* self,
                            BudgieRavenWidgetData* widget_data)
{
	BudgieMainView* _tmp0_;
	GtkBin* _tmp1_;
	GtkBin* _tmp2_;
	BudgieRavenPluginManager* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget_data != NULL);
	self->priv->widgets = vala_g_list_remove_full (self->priv->widgets, widget_data, _budgie_raven_widget_data_unref0_);
	_tmp0_ = self->priv->main_view;
	_tmp1_ = budgie_raven_widget_data_get_widget_instance (widget_data);
	_tmp2_ = _tmp1_;
	budgie_main_view_remove_widget_instance (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->plugin_manager;
	_tmp4_ = budgie_raven_widget_data_get_uuid (widget_data);
	_tmp5_ = _tmp4_;
	budgie_raven_plugin_manager_clear_widget_instance_info (_tmp3_, _tmp5_);
	_tmp6_ = budgie_raven_widget_data_get_supports_settings (widget_data);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		BudgieRavenPluginManager* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = self->priv->plugin_manager;
		_tmp9_ = budgie_raven_widget_data_get_uuid (widget_data);
		_tmp10_ = _tmp9_;
		budgie_raven_plugin_manager_clear_widget_instance_settings (_tmp8_, _tmp10_);
	}
	budgie_raven_update_uuids (self);
}

void
budgie_raven_move_widget_by_offset (BudgieRaven* self,
                                    BudgieRavenWidgetData* widget_data,
                                    gint offset)
{
	gint new_index = 0;
	GList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget_data != NULL);
	_tmp0_ = self->priv->widgets;
	new_index = g_list_index (_tmp0_, widget_data) + offset;
	_tmp2_ = self->priv->widgets;
	if (((guint) new_index) < g_list_length (_tmp2_)) {
		_tmp1_ = new_index >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BudgieRavenWidgetData* _tmp3_;
		BudgieMainView* _tmp4_;
		GtkBin* _tmp5_;
		GtkBin* _tmp6_;
		self->priv->widgets = vala_g_list_remove_full (self->priv->widgets, widget_data, _budgie_raven_widget_data_unref0_);
		_tmp3_ = _budgie_raven_widget_data_ref0 (widget_data);
		self->priv->widgets = g_list_insert (self->priv->widgets, _tmp3_, new_index);
		_tmp4_ = self->priv->main_view;
		_tmp5_ = budgie_raven_widget_data_get_widget_instance (widget_data);
		_tmp6_ = _tmp5_;
		budgie_main_view_move_widget_instance_by_offset (_tmp4_, _tmp6_, offset);
		budgie_raven_update_uuids (self);
	}
}

/**
* Attempt to load the configuration from the given URL
*/
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
budgie_raven_load_default_from_config (BudgieRaven* self,
                                       const gchar* uri)
{
	GFile* f = NULL;
	GKeyFile* config_file = NULL;
	GKeyFile* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gchar* line = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	f = NULL;
	_tmp0_ = g_key_file_new ();
	config_file = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	line = NULL;
	{
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp7_;
		GKeyFile* _tmp15_;
		GString* _tmp16_;
		const gchar* _tmp17_;
		GString* _tmp18_;
		_tmp2_ = g_file_new_for_uri (uri);
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		if (!g_file_query_exists (_tmp3_, NULL)) {
			result = FALSE;
			_g_free0 (line);
			_g_string_free0 (builder);
			_g_key_file_unref0 (config_file);
			_g_object_unref0 (f);
			return result;
		}
		_tmp5_ = f;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		dis = _tmp7_;
		while (TRUE) {
			gchar* _tmp8_ = NULL;
			GDataInputStream* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			GString* _tmp13_;
			const gchar* _tmp14_;
			_tmp9_ = dis;
			_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_free0 (line);
			line = _tmp11_;
			_tmp12_ = line;
			if (!(_tmp12_ != NULL)) {
				_g_free0 (_tmp8_);
				break;
			}
			_tmp13_ = builder;
			_tmp14_ = line;
			g_string_append_printf (_tmp13_, "%s\n", _tmp14_);
			_g_free0 (_tmp8_);
		}
		_tmp15_ = config_file;
		_tmp16_ = builder;
		_tmp17_ = _tmp16_->str;
		_tmp18_ = builder;
		g_key_file_load_from_data (_tmp15_, _tmp17_, (gsize) _tmp18_->len, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp4_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("raven.vala:691: Failed to load default Raven widget config: %s", _tmp20_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	{
		gboolean _tmp22_ = FALSE;
		GKeyFile* _tmp23_;
		gchar** widgets = NULL;
		GKeyFile* _tmp24_;
		gsize _tmp25_ = 0;
		gchar** _tmp26_;
		gint widgets_length1;
		gint _widgets_size_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp23_ = config_file;
		_tmp22_ = g_key_file_has_key (_tmp23_, "Widgets", "Widgets", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (!_tmp22_) {
			g_warning ("raven.vala:697: widgets.ini is missing required Widgets section");
			result = FALSE;
			_g_free0 (line);
			_g_string_free0 (builder);
			_g_key_file_unref0 (config_file);
			_g_object_unref0 (f);
			return result;
		}
		_tmp24_ = config_file;
		_tmp26_ = g_key_file_get_string_list (_tmp24_, "Widgets", "Widgets", &_tmp25_, &_inner_error0_);
		widgets = _tmp26_;
		widgets_length1 = _tmp25_;
		_widgets_size_ = widgets_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp27_ = widgets;
		_tmp27__length1 = widgets_length1;
		{
			gchar** widget_collection = NULL;
			gint widget_collection_length1 = 0;
			gint _widget_collection_size_ = 0;
			gint widget_it = 0;
			widget_collection = _tmp27_;
			widget_collection_length1 = _tmp27__length1;
			for (widget_it = 0; widget_it < widget_collection_length1; widget_it = widget_it + 1) {
				gchar* _tmp28_;
				gchar* widget = NULL;
				_tmp28_ = g_strdup (widget_collection[widget_it]);
				widget = _tmp28_;
				{
					const gchar* _tmp29_;
					gchar* _tmp30_;
					GKeyFile* _tmp31_;
					const gchar* _tmp32_;
					gboolean _tmp34_ = FALSE;
					GKeyFile* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp38_ = NULL;
					GKeyFile* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* module_name = NULL;
					gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp29_ = widget;
					_tmp30_ = string_strip (_tmp29_);
					_g_free0 (widget);
					widget = _tmp30_;
					_tmp31_ = config_file;
					_tmp32_ = widget;
					if (!g_key_file_has_group (_tmp31_, _tmp32_)) {
						const gchar* _tmp33_;
						_tmp33_ = widget;
						g_warning ("raven.vala:707: Raven widget %s missing from widgets.ini", _tmp33_);
						_g_free0 (widget);
						continue;
					}
					_tmp35_ = config_file;
					_tmp36_ = widget;
					_tmp34_ = g_key_file_has_key (_tmp35_, _tmp36_, "Module", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (widget);
						widgets = (_vala_array_free (widgets, widgets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch1_g_error;
					}
					if (!_tmp34_) {
						const gchar* _tmp37_;
						_tmp37_ = widget;
						g_warning ("raven.vala:712: Raven widget %s is missing Module key in widgets.ini", _tmp37_);
						_g_free0 (widget);
						continue;
					}
					_tmp39_ = config_file;
					_tmp40_ = widget;
					_tmp41_ = g_key_file_get_string (_tmp39_, _tmp40_, "Module", &_inner_error0_);
					_tmp38_ = _tmp41_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (widget);
						widgets = (_vala_array_free (widgets, widgets_length1, (GDestroyNotify) g_free), NULL);
						goto __catch1_g_error;
					}
					_tmp42_ = string_strip (_tmp38_);
					module_name = _tmp42_;
					_tmp43_ = module_name;
					budgie_raven_create_widget_instance_with_uuid (self, _tmp43_, NULL);
					_g_free0 (module_name);
					_g_free0 (_tmp38_);
					_g_free0 (widget);
				}
			}
		}
		widgets = (_vala_array_free (widgets, widgets_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_warning ("raven.vala:720: Error configuring Raven widgets from raven-widget.ini:" \
" %s", _tmp45_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp46_ = FALSE;
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp46_;
	}
	result = TRUE;
	_g_free0 (line);
	_g_string_free0 (builder);
	_g_key_file_unref0 (config_file);
	_g_object_unref0 (f);
	return result;
}

GtkPositionType
budgie_raven_get_screen_edge (BudgieRaven* self)
{
	GtkPositionType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_screen_edge;
	return result;
}

void
budgie_raven_set_screen_edge (BudgieRaven* self,
                              GtkPositionType value)
{
	BudgieRavenIface* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_screen_edge = value;
	_tmp0_ = self->priv->iface;
	if (_tmp0_ != NULL) {
		BudgieRavenIface* _tmp1_;
		GtkPositionType _tmp2_;
		GtkPositionType _tmp3_;
		_tmp1_ = self->priv->iface;
		_tmp2_ = budgie_raven_get_screen_edge (self);
		_tmp3_ = _tmp2_;
		g_signal_emit (_tmp1_, budgie_raven_iface_signals[BUDGIE_RAVEN_IFACE_ANCHOR_CHANGED_SIGNAL], 0, _tmp3_ == GTK_POS_LEFT);
	}
	if (self->priv->_screen_edge == GTK_POS_RIGHT) {
		GtkBox* _tmp4_;
		BudgieShadowBlock* _tmp5_;
		GtkStyleContext* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GtkStyleContext* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		BudgieShadowBlock* _tmp12_;
		_tmp4_ = self->priv->layout;
		_tmp5_ = self->priv->shadow;
		gtk_container_child_set ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_, "position", 0, NULL);
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp7_ = budgie_position_class_name (BUDGIE_PANEL_POSITION_RIGHT);
		_tmp8_ = _tmp7_;
		gtk_style_context_add_class (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp10_ = budgie_position_class_name (BUDGIE_PANEL_POSITION_LEFT);
		_tmp11_ = _tmp10_;
		gtk_style_context_remove_class (_tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->shadow;
		budgie_shadow_block_set_position (_tmp12_, BUDGIE_PANEL_POSITION_RIGHT);
	} else {
		GtkBox* _tmp13_;
		BudgieShadowBlock* _tmp14_;
		GtkStyleContext* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GtkStyleContext* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		BudgieShadowBlock* _tmp21_;
		_tmp13_ = self->priv->layout;
		_tmp14_ = self->priv->shadow;
		gtk_container_child_set ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_, "position", 1, NULL);
		_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp16_ = budgie_position_class_name (BUDGIE_PANEL_POSITION_LEFT);
		_tmp17_ = _tmp16_;
		gtk_style_context_add_class (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp19_ = budgie_position_class_name (BUDGIE_PANEL_POSITION_RIGHT);
		_tmp20_ = _tmp19_;
		gtk_style_context_remove_class (_tmp18_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->shadow;
		budgie_shadow_block_set_position (_tmp21_, BUDGIE_PANEL_POSITION_LEFT);
	}
	g_object_notify_by_pspec ((GObject *) self, budgie_raven_properties[BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY]);
}

gint
budgie_raven_get_required_size (BudgieRaven* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_required_size;
	return result;
}

void
budgie_raven_set_required_size (BudgieRaven* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_raven_get_required_size (self);
	if (old_value != value) {
		self->priv->_required_size = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_raven_properties[BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY]);
	}
}

BudgieDesktopManager*
budgie_raven_get_manager (BudgieRaven* self)
{
	BudgieDesktopManager* result;
	BudgieDesktopManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	result = _tmp0_;
	return result;
}

void
budgie_raven_set_manager (BudgieRaven* self,
                          BudgieDesktopManager* value)
{
	BudgieDesktopManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_raven_get_manager (self);
	if (old_value != value) {
		BudgieDesktopManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manager);
		self->priv->_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_raven_properties[BUDGIE_RAVEN_MANAGER_PROPERTY]);
	}
}

gdouble
budgie_raven_get_nscale (BudgieRaven* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->scale;
	return result;
}

void
budgie_raven_set_nscale (BudgieRaven* self,
                         gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->scale = value;
	g_object_notify_by_pspec ((GObject *) self, budgie_raven_properties[BUDGIE_RAVEN_NSCALE_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__BUDGIE_RAVEN_WIDGET_DATA (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BUDGIE_RAVEN_WIDGET_DATA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BUDGIE_RAVEN_WIDGET_DATA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BUDGIE_RAVEN_WIDGET_DATA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, budgie_value_get_raven_widget_data (param_values + 1), data2);
}

static void
budgie_raven_class_init (BudgieRavenClass * klass,
                         gpointer klass_data)
{
	budgie_raven_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRaven_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) budgie_raven_real_size_allocate;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) budgie_raven_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) budgie_raven_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) budgie_raven_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_raven_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_raven_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_raven_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY, budgie_raven_properties[BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY] = g_param_spec_enum ("screen-edge", "screen-edge", "screen-edge", gtk_position_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY, budgie_raven_properties[BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY] = g_param_spec_int ("required-size", "required-size", "required-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_MANAGER_PROPERTY, budgie_raven_properties[BUDGIE_RAVEN_MANAGER_PROPERTY] = g_param_spec_object ("manager", "manager", "manager", BUDGIE_TYPE_DESKTOP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_RAVEN_NSCALE_PROPERTY, budgie_raven_properties[BUDGIE_RAVEN_NSCALE_PROPERTY] = g_param_spec_double ("nscale", "nscale", "nscale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	budgie_raven_signals[BUDGIE_RAVEN_REQUEST_SETTINGS_UI_SIGNAL] = g_signal_new ("request-settings-ui", BUDGIE_TYPE_RAVEN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_raven_signals[BUDGIE_RAVEN_ON_WIDGET_ADDED_SIGNAL] = g_signal_new ("on-widget-added", BUDGIE_TYPE_RAVEN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BUDGIE_RAVEN_WIDGET_DATA, G_TYPE_NONE, 1, BUDGIE_TYPE_RAVEN_WIDGET_DATA);
}

static void
budgie_raven_instance_init (BudgieRaven * self,
                            gpointer klass)
{
	self->priv = budgie_raven_get_instance_private (self);
	self->priv->_screen_edge = GTK_POS_RIGHT;
	self->priv->widgets = NULL;
	self->priv->our_width = 0;
	self->priv->our_height = 0;
	self->priv->our_x = 0;
	self->priv->our_y = 0;
	self->priv->iface = NULL;
	self->priv->settings = NULL;
	self->priv->widget_settings = NULL;
	self->priv->expanded = FALSE;
	self->priv->scale = 0.0;
	self->priv->main_view = NULL;
	self->priv->n_count = (guint) 0;
}

static void
budgie_raven_finalize (GObject * obj)
{
	BudgieRaven * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN, BudgieRaven);
	(self->priv->widgets == NULL) ? NULL : (self->priv->widgets = (_g_list_free__budgie_raven_widget_data_unref0_ (self->priv->widgets), NULL));
	_g_object_unref0 (self->priv->shadow);
	_budgie_raven_iface_unref0 (self->priv->iface);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->widget_settings);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->_manager);
	G_OBJECT_CLASS (budgie_raven_parent_class)->finalize (obj);
}

static GType
budgie_raven_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRaven), 0, (GInstanceInitFunc) budgie_raven_instance_init, NULL };
	GType budgie_raven_type_id;
	budgie_raven_type_id = g_type_register_static (gtk_window_get_type (), "BudgieRaven", &g_define_type_info, 0);
	BudgieRaven_private_offset = g_type_add_instance_private (budgie_raven_type_id, sizeof (BudgieRavenPrivate));
	return budgie_raven_type_id;
}

GType
budgie_raven_get_type (void)
{
	static volatile gsize budgie_raven_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_type_id__once)) {
		GType budgie_raven_type_id;
		budgie_raven_type_id = budgie_raven_get_type_once ();
		g_once_init_leave (&budgie_raven_type_id__once, budgie_raven_type_id);
	}
	return budgie_raven_type_id__once;
}

static void
_vala_budgie_raven_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BudgieRaven * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN, BudgieRaven);
	switch (property_id) {
		case BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY:
		g_value_set_enum (value, budgie_raven_get_screen_edge (self));
		break;
		case BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY:
		g_value_set_int (value, budgie_raven_get_required_size (self));
		break;
		case BUDGIE_RAVEN_MANAGER_PROPERTY:
		g_value_set_object (value, budgie_raven_get_manager (self));
		break;
		case BUDGIE_RAVEN_NSCALE_PROPERTY:
		g_value_set_double (value, budgie_raven_get_nscale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_raven_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BudgieRaven * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_RAVEN, BudgieRaven);
	switch (property_id) {
		case BUDGIE_RAVEN_SCREEN_EDGE_PROPERTY:
		budgie_raven_set_screen_edge (self, g_value_get_enum (value));
		break;
		case BUDGIE_RAVEN_REQUIRED_SIZE_PROPERTY:
		budgie_raven_set_required_size (self, g_value_get_int (value));
		break;
		case BUDGIE_RAVEN_MANAGER_PROPERTY:
		budgie_raven_set_manager (self, g_value_get_object (value));
		break;
		case BUDGIE_RAVEN_NSCALE_PROPERTY:
		budgie_raven_set_nscale (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

