/* plugin_manager.c generated by valac 0.56.14, the Vala compiler
 * generated from plugin_manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <libpeas/peas.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <girepository.h>
#include <budgie-config.h>
#include "raven-plugin.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <uuid.h>
#include <gobject/gvaluecollector.h>

#define BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_SETTINGS_PREFIX "org/buddiesofbudgie/budgie-desktop/raven/widgets/instance-settings"
#define BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_INFO_PREFIX "org/buddiesofbudgie/budgie-desktop/raven/widgets/instance-info"
#define BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_INFO_SCHEMA "org.buddiesofbudgie.budgie-desktop.raven.widgets.instance-info"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _budgie_raven_widget_data_unref0(var) ((var == NULL) ? NULL : (var = (budgie_raven_widget_data_unref (var), NULL)))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _BudgieParamSpecRavenPluginManager BudgieParamSpecRavenPluginManager;
enum  {
	BUDGIE_RAVEN_PLUGIN_MANAGER_EXISTING_WIDGETS_LOADED_SIGNAL,
	BUDGIE_RAVEN_PLUGIN_MANAGER_NUM_SIGNALS
};
static guint budgie_raven_plugin_manager_signals[BUDGIE_RAVEN_PLUGIN_MANAGER_NUM_SIGNALS] = {0};
typedef struct _BudgieParamSpecRavenWidgetData BudgieParamSpecRavenWidgetData;

struct _BudgieRavenPluginManagerPrivate {
	PeasEngine* engine;
	PeasExtensionSet* plugin_set;
	GHashTable* plugins;
	GRecMutex __lock_plugins;
};

struct _BudgieParamSpecRavenPluginManager {
	GParamSpec parent_instance;
};

struct _BudgieRavenWidgetDataPrivate {
	GtkBin* _widget_instance;
	PeasPluginInfo* _plugin_info;
	gchar* _uuid;
	gboolean _supports_settings;
};

struct _BudgieParamSpecRavenWidgetData {
	GParamSpec parent_instance;
};

static gint BudgieRavenPluginManager_private_offset;
static gpointer budgie_raven_plugin_manager_parent_class = NULL;
static gint BudgieRavenWidgetData_private_offset;
static gpointer budgie_raven_widget_data_parent_class = NULL;

static void _g_free0_ (gpointer var);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void __vala_PeasPluginInfo_free0_ (gpointer var);
static void budgie_raven_plugin_manager_on_plugin_loaded (BudgieRavenPluginManager* self,
                                                   PeasPluginInfo* info);
static void _budgie_raven_plugin_manager_on_plugin_loaded_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                       PeasPluginInfo* info,
                                                                                       GObject* exten,
                                                                                       gpointer self);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void budgie_raven_plugin_manager_reset_dconf_path (const gchar* path);
static gchar* budgie_raven_plugin_manager_module_name_to_schema_name (const gchar* module_name);
static gchar* budgie_raven_plugin_manager_generate_uuid (void);
static gboolean budgie_raven_plugin_manager_schema_exists (const gchar* schema_name);
static void budgie_raven_plugin_manager_finalize (BudgieRavenPluginManager * obj);
static GType budgie_raven_plugin_manager_get_type_once (void);
static void budgie_raven_widget_data_set_widget_instance (BudgieRavenWidgetData* self,
                                                   GtkBin* value);
static void budgie_raven_widget_data_set_plugin_info (BudgieRavenWidgetData* self,
                                               PeasPluginInfo* value);
static void budgie_raven_widget_data_set_uuid (BudgieRavenWidgetData* self,
                                        const gchar* value);
static void budgie_raven_widget_data_set_supports_settings (BudgieRavenWidgetData* self,
                                                     gboolean value);
static void budgie_raven_widget_data_finalize (BudgieRavenWidgetData * obj);
static GType budgie_raven_widget_data_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
budgie_raven_widget_creation_result_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS", "success"}, {BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_INFO_MISSING, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_INFO_MISSING", "plugin-info-missing"}, {BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INVALID_MODULE_NAME, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INVALID_MODULE_NAME", "invalid-module-name"}, {BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_LOAD_FAILED, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_LOAD_FAILED", "plugin-load-failed"}, {BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SCHEMA_LOAD_FAILED, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SCHEMA_LOAD_FAILED", "schema-load-failed"}, {BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INSTANCE_CREATION_FAILED, "BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INSTANCE_CREATION_FAILED", "instance-creation-failed"}, {0, NULL, NULL}};
	GType budgie_raven_widget_creation_result_type_id;
	budgie_raven_widget_creation_result_type_id = g_enum_register_static ("BudgieRavenWidgetCreationResult", values);
	return budgie_raven_widget_creation_result_type_id;
}

GType
budgie_raven_widget_creation_result_get_type (void)
{
	static volatile gsize budgie_raven_widget_creation_result_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_widget_creation_result_type_id__once)) {
		GType budgie_raven_widget_creation_result_type_id;
		budgie_raven_widget_creation_result_type_id = budgie_raven_widget_creation_result_get_type_once ();
		g_once_init_leave (&budgie_raven_widget_creation_result_type_id__once, budgie_raven_widget_creation_result_type_id);
	}
	return budgie_raven_widget_creation_result_type_id__once;
}

static inline gpointer
budgie_raven_plugin_manager_get_instance_private (BudgieRavenPluginManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenPluginManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static void
__vala_PeasPluginInfo_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL));
}

BudgieRavenPluginManager*
budgie_raven_plugin_manager_construct (GType object_type)
{
	BudgieRavenPluginManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self = (BudgieRavenPluginManager*) g_type_create_instance (object_type);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_PeasPluginInfo_free0_);
	_g_hash_table_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp2_;
	return self;
}

BudgieRavenPluginManager*
budgie_raven_plugin_manager_new (void)
{
	return budgie_raven_plugin_manager_construct (BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER);
}

/**
* Initialise the plugin engine, paths, loaders, etc.
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_raven_plugin_manager_on_plugin_loaded_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                  PeasPluginInfo* info,
                                                                                  GObject* exten,
                                                                                  gpointer self)
{
	budgie_raven_plugin_manager_on_plugin_loaded ((BudgieRavenPluginManager*) self, info);
}

void
budgie_raven_plugin_manager_setup_plugins (BudgieRavenPluginManager* self)
{
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	gchar* dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	PeasEngine* _tmp11_;
	gchar* user_mod = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* hdata = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	PeasEngine* _tmp17_;
	PeasEngine* _tmp18_;
	PeasEngine* _tmp19_;
	PeasExtensionSet* _tmp20_;
	PeasExtensionSet* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = peas_engine_new ();
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = self->priv->engine;
	peas_engine_enable_loader (_tmp1_, "python3");
	{
		GIRepository* repo = NULL;
		GIRepository* _tmp2_;
		GIRepository* _tmp3_;
		GIRepository* _tmp4_;
		GIRepository* _tmp5_;
		GIRepository* _tmp6_;
		_tmp2_ = g_irepository_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		repo = _tmp3_;
		_tmp4_ = repo;
		g_irepository_require (_tmp4_, "Peas", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_tmp5_ = repo;
		g_irepository_require (_tmp5_, "PeasGtk", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_tmp6_ = repo;
		g_irepository_require (_tmp6_, "BudgieRaven", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (repo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_message ("plugin_manager.vala:50: Error loading typelibs: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = g_get_user_data_dir ();
	_tmp10_ = g_strdup (_tmp9_);
	dir = _tmp10_;
	_tmp11_ = self->priv->engine;
	peas_engine_add_search_path (_tmp11_, BUDGIE_RAVEN_PLUGIN_LIBDIR, BUDGIE_RAVEN_PLUGIN_DATADIR);
	if (BUDGIE_HAS_SECONDARY_PLUGIN_DIRS) {
		PeasEngine* _tmp12_;
		_tmp12_ = self->priv->engine;
		peas_engine_add_search_path (_tmp12_, BUDGIE_RAVEN_PLUGIN_LIBDIR_SECONDARY, BUDGIE_RAVEN_PLUGIN_DATADIR_SECONDARY);
	}
	_tmp13_ = dir;
	_tmp14_ = g_build_path (G_DIR_SEPARATOR_S, _tmp13_, "budgie-desktop", "raven-plugins", NULL);
	user_mod = _tmp14_;
	_tmp15_ = dir;
	_tmp16_ = g_build_path (G_DIR_SEPARATOR_S, _tmp15_, "budgie-desktop", "raven-data", NULL);
	hdata = _tmp16_;
	_tmp17_ = self->priv->engine;
	peas_engine_add_search_path (_tmp17_, user_mod, hdata);
	_tmp18_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp18_);
	_tmp19_ = self->priv->engine;
	_tmp20_ = peas_extension_set_new (_tmp19_, budgie_raven_plugin_get_type (), NULL);
	_g_object_unref0 (self->priv->plugin_set);
	self->priv->plugin_set = _tmp20_;
	_tmp21_ = self->priv->plugin_set;
	g_signal_connect (_tmp21_, "extension-added", (GCallback) _budgie_raven_plugin_manager_on_plugin_loaded_peas_extension_set_extension_added, self);
	_g_free0 (hdata);
	_g_free0 (user_mod);
	_g_free0 (dir);
}

/**
* Handle plugin loading
*/
static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
budgie_raven_plugin_manager_on_plugin_loaded (BudgieRavenPluginManager* self,
                                              PeasPluginInfo* info)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->plugins;
		g_rec_mutex_lock (&self->priv->__lock_plugins);
		{
			GHashTable* _tmp1_;
			const gchar* _tmp2_;
			GHashTable* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			PeasPluginInfo* _tmp7_;
			_tmp1_ = self->priv->plugins;
			_tmp2_ = peas_plugin_info_get_module_name (info);
			if (g_hash_table_contains (_tmp1_, _tmp2_)) {
				{
					GHashTable* _tmp3_;
					_tmp3_ = self->priv->plugins;
					g_rec_mutex_unlock (&self->priv->__lock_plugins);
				}
				return;
			}
			_tmp4_ = self->priv->plugins;
			_tmp5_ = peas_plugin_info_get_module_name (info);
			_tmp6_ = g_strdup (_tmp5_);
			_tmp7_ = __vala_PeasPluginInfo_copy0 (info);
			g_hash_table_insert (_tmp4_, _tmp6_, _tmp7_);
		}
		__finally0:
		{
			GHashTable* _tmp8_;
			_tmp8_ = self->priv->plugins;
			g_rec_mutex_unlock (&self->priv->__lock_plugins);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
budgie_raven_plugin_manager_is_plugin_loaded (BudgieRavenPluginManager* self,
                                              const gchar* module_name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (module_name != NULL, FALSE);
	{
		GHashTable* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->plugins;
		g_rec_mutex_lock (&self->priv->__lock_plugins);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->plugins;
			result = g_hash_table_contains (_tmp1_, module_name);
			{
				GHashTable* _tmp2_;
				_tmp2_ = self->priv->plugins;
				g_rec_mutex_unlock (&self->priv->__lock_plugins);
			}
			return result;
		}
		__finally0:
		{
			GHashTable* _tmp3_;
			_tmp3_ = self->priv->plugins;
			g_rec_mutex_unlock (&self->priv->__lock_plugins);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

GSettings*
budgie_raven_plugin_manager_get_widget_info_from_uuid (BudgieRavenPluginManager* self,
                                                       const gchar* uuid)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/%s/%s/", BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_INFO_PREFIX, uuid);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_new_with_path (BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_INFO_SCHEMA, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
budgie_raven_plugin_manager_clear_widget_instance_info (BudgieRavenPluginManager* self,
                                                        const gchar* uuid)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = g_strdup_printf ("/%s/%s/", BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_INFO_PREFIX, uuid);
	_tmp1_ = _tmp0_;
	budgie_raven_plugin_manager_reset_dconf_path (_tmp1_);
	_g_free0 (_tmp1_);
}

void
budgie_raven_plugin_manager_clear_widget_instance_settings (BudgieRavenPluginManager* self,
                                                            const gchar* uuid)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = g_strdup_printf ("/%s/%s/", BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_SETTINGS_PREFIX, uuid);
	_tmp1_ = _tmp0_;
	budgie_raven_plugin_manager_reset_dconf_path (_tmp1_);
	_g_free0 (_tmp1_);
}

BudgieRavenWidgetCreationResult
budgie_raven_plugin_manager_new_widget_instance_for_plugin (BudgieRavenPluginManager* self,
                                                            const gchar* module_name,
                                                            const gchar* existing_uuid,
                                                            BudgieRavenWidgetData** widget_data)
{
	BudgieRavenWidgetData* _vala_widget_data = NULL;
	PeasPluginInfo* plugin_info = NULL;
	PeasEngine* _tmp0_;
	PeasPluginInfo* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	gchar* instance_settings_schema_name = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_;
	PeasExtension* extension = NULL;
	PeasExtensionSet* _tmp12_;
	PeasPluginInfo* _tmp13_;
	PeasExtension* _tmp14_;
	PeasExtension* _tmp15_;
	BudgieRavenPlugin* plugin = NULL;
	PeasExtension* _tmp16_;
	BudgieRavenPlugin* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* uuid = NULL;
	gchar* _tmp21_;
	GSettings* instance_settings = NULL;
	BudgieRavenPlugin* _tmp22_;
	BudgieRavenWidget* instance = NULL;
	BudgieRavenPlugin* _tmp31_;
	const gchar* _tmp32_;
	GSettings* _tmp33_;
	BudgieRavenWidget* _tmp34_;
	BudgieRavenWidget* _tmp35_;
	GSettings* instance_info = NULL;
	const gchar* _tmp36_;
	GSettings* _tmp37_;
	GSettings* _tmp38_;
	BudgieRavenWidget* _tmp39_;
	PeasPluginInfo* _tmp40_;
	const gchar* _tmp41_;
	BudgieRavenPlugin* _tmp42_;
	BudgieRavenWidgetData* _tmp43_;
	BudgieRavenWidgetCreationResult result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (module_name != NULL, 0);
	_budgie_raven_widget_data_unref0 (_vala_widget_data);
	_vala_widget_data = NULL;
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_info (_tmp0_, module_name);
	_tmp2_ = __vala_PeasPluginInfo_copy0 (_tmp1_);
	plugin_info = _tmp2_;
	_tmp3_ = plugin_info;
	if (_tmp3_ == NULL) {
		result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_INFO_MISSING;
		__vala_PeasPluginInfo_free0 (plugin_info);
		if (widget_data) {
			*widget_data = _vala_widget_data;
		} else {
			_budgie_raven_widget_data_unref0 (_vala_widget_data);
		}
		return result;
	}
	_tmp4_ = budgie_raven_plugin_manager_module_name_to_schema_name (module_name);
	instance_settings_schema_name = _tmp4_;
	_tmp5_ = instance_settings_schema_name;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ".", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = _vala_array_length (_tmp6_) < 3;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp9_) {
		result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INVALID_MODULE_NAME;
		_g_free0 (instance_settings_schema_name);
		__vala_PeasPluginInfo_free0 (plugin_info);
		if (widget_data) {
			*widget_data = _vala_widget_data;
		} else {
			_budgie_raven_widget_data_unref0 (_vala_widget_data);
		}
		return result;
	}
	if (!budgie_raven_plugin_manager_is_plugin_loaded (self, module_name)) {
		PeasEngine* _tmp10_;
		PeasPluginInfo* _tmp11_;
		_tmp10_ = self->priv->engine;
		_tmp11_ = plugin_info;
		if (!peas_engine_load_plugin (_tmp10_, _tmp11_)) {
			result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_PLUGIN_LOAD_FAILED;
			_g_free0 (instance_settings_schema_name);
			__vala_PeasPluginInfo_free0 (plugin_info);
			if (widget_data) {
				*widget_data = _vala_widget_data;
			} else {
				_budgie_raven_widget_data_unref0 (_vala_widget_data);
			}
			return result;
		}
	}
	_tmp12_ = self->priv->plugin_set;
	_tmp13_ = plugin_info;
	_tmp14_ = peas_extension_set_get_extension (_tmp12_, _tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	extension = _tmp15_;
	_tmp16_ = extension;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, budgie_raven_plugin_get_type ()) ? ((BudgieRavenPlugin*) _tmp16_) : NULL);
	plugin = _tmp17_;
	if (existing_uuid != NULL) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (existing_uuid);
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp19_;
	} else {
		gchar* _tmp20_;
		_tmp20_ = budgie_raven_plugin_manager_generate_uuid ();
		_g_free0 (_tmp18_);
		_tmp18_ = _tmp20_;
	}
	_tmp21_ = g_strdup (_tmp18_);
	uuid = _tmp21_;
	instance_settings = NULL;
	_tmp22_ = plugin;
	if (budgie_raven_plugin_supports_settings (_tmp22_)) {
		gchar* instance_settings_path = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		GSettings* _tmp29_;
		GSettings* _tmp30_;
		_tmp23_ = uuid;
		_tmp24_ = g_strdup_printf ("/%s/%s/", BUDGIE_RAVEN_PLUGIN_MANAGER_WIDGET_INSTANCE_SETTINGS_PREFIX, _tmp23_);
		instance_settings_path = _tmp24_;
		_tmp25_ = instance_settings_schema_name;
		if (!budgie_raven_plugin_manager_schema_exists (_tmp25_)) {
			const gchar* _tmp26_;
			_tmp26_ = instance_settings_schema_name;
			g_warning ("plugin_manager.vala:122: %s", _tmp26_);
			result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SCHEMA_LOAD_FAILED;
			_g_free0 (instance_settings_path);
			_g_object_unref0 (instance_settings);
			_g_free0 (uuid);
			_g_free0 (_tmp18_);
			_g_object_unref0 (plugin);
			_g_object_unref0 (extension);
			_g_free0 (instance_settings_schema_name);
			__vala_PeasPluginInfo_free0 (plugin_info);
			if (widget_data) {
				*widget_data = _vala_widget_data;
			} else {
				_budgie_raven_widget_data_unref0 (_vala_widget_data);
			}
			return result;
		}
		_tmp27_ = instance_settings_schema_name;
		_tmp28_ = instance_settings_path;
		_tmp29_ = g_settings_new_with_path (_tmp27_, _tmp28_);
		_g_object_unref0 (instance_settings);
		instance_settings = _tmp29_;
		_tmp30_ = instance_settings;
		g_object_ref ((GObject*) _tmp30_);
		_g_free0 (instance_settings_path);
	}
	_tmp31_ = plugin;
	_tmp32_ = uuid;
	_tmp33_ = instance_settings;
	_tmp34_ = budgie_raven_plugin_new_widget_instance (_tmp31_, _tmp32_, _tmp33_);
	instance = _tmp34_;
	_tmp35_ = instance;
	if (_tmp35_ == NULL) {
		result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_INSTANCE_CREATION_FAILED;
		_g_object_unref0 (instance);
		_g_object_unref0 (instance_settings);
		_g_free0 (uuid);
		_g_free0 (_tmp18_);
		_g_object_unref0 (plugin);
		_g_object_unref0 (extension);
		_g_free0 (instance_settings_schema_name);
		__vala_PeasPluginInfo_free0 (plugin_info);
		if (widget_data) {
			*widget_data = _vala_widget_data;
		} else {
			_budgie_raven_widget_data_unref0 (_vala_widget_data);
		}
		return result;
	}
	_tmp36_ = uuid;
	_tmp37_ = budgie_raven_plugin_manager_get_widget_info_from_uuid (self, _tmp36_);
	instance_info = _tmp37_;
	_tmp38_ = instance_info;
	g_settings_set_string (_tmp38_, "module", module_name);
	_tmp39_ = instance;
	_tmp40_ = plugin_info;
	_tmp41_ = uuid;
	_tmp42_ = plugin;
	_tmp43_ = budgie_raven_widget_data_new ((GtkBin*) _tmp39_, _tmp40_, _tmp41_, budgie_raven_plugin_supports_settings (_tmp42_));
	_budgie_raven_widget_data_unref0 (_vala_widget_data);
	_vala_widget_data = _tmp43_;
	result = BUDGIE_RAVEN_WIDGET_CREATION_RESULT_SUCCESS;
	_g_object_unref0 (instance_info);
	_g_object_unref0 (instance);
	_g_object_unref0 (instance_settings);
	_g_free0 (uuid);
	_g_free0 (_tmp18_);
	_g_object_unref0 (plugin);
	_g_object_unref0 (extension);
	_g_free0 (instance_settings_schema_name);
	__vala_PeasPluginInfo_free0 (plugin_info);
	if (widget_data) {
		*widget_data = _vala_widget_data;
	} else {
		_budgie_raven_widget_data_unref0 (_vala_widget_data);
	}
	return result;
}

GList*
budgie_raven_plugin_manager_get_all_plugins (BudgieRavenPluginManager* self)
{
	GList* ret = NULL;
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp1_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* info = NULL;
			info = (PeasPluginInfo*) info_it->data;
			{
				PeasPluginInfo* _tmp2_;
				PeasPluginInfo* _tmp3_;
				_tmp2_ = info;
				_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
				ret = g_list_append (ret, _tmp3_);
			}
		}
	}
	result = ret;
	return result;
}

void
budgie_raven_plugin_manager_rescan_plugins (BudgieRavenPluginManager* self)
{
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	peas_engine_garbage_collect (_tmp0_);
	_tmp1_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp1_);
}

void
budgie_raven_plugin_manager_modprobe (BudgieRavenPluginManager* self,
                                      const gchar* module_name)
{
	PeasPluginInfo* i = NULL;
	PeasEngine* _tmp0_;
	PeasPluginInfo* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasEngine* _tmp4_;
	PeasPluginInfo* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (module_name != NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_info (_tmp0_, module_name);
	_tmp2_ = __vala_PeasPluginInfo_copy0 (_tmp1_);
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ == NULL) {
		g_warning ("plugin_manager.vala:156: budgie_panel_modprobe called for non existent" \
" module: %s", module_name);
		__vala_PeasPluginInfo_free0 (i);
		return;
	}
	_tmp4_ = self->priv->engine;
	_tmp5_ = i;
	peas_engine_load_plugin (_tmp4_, _tmp5_);
	__vala_PeasPluginInfo_free0 (i);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
budgie_raven_plugin_manager_module_name_to_schema_name (const gchar* module_name)
{
	gchar* schema_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (module_name != NULL, NULL);
	_tmp0_ = g_strdup (module_name);
	schema_name = _tmp0_;
	if (g_str_has_suffix (module_name, ".so")) {
		gchar* _tmp1_;
		_tmp1_ = string_slice (module_name, (glong) 0, (glong) string_last_index_of (module_name, ".", 0));
		_g_free0 (schema_name);
		schema_name = _tmp1_;
	}
	_tmp2_ = schema_name;
	_tmp3_ = string_replace (_tmp2_, "_", ".");
	result = _tmp3_;
	_g_free0 (schema_name);
	return result;
}

static gboolean
budgie_raven_plugin_manager_schema_exists (const gchar* schema_name)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (schema_name != NULL, FALSE);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, schema_name, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
budgie_raven_plugin_manager_generate_uuid (void)
{
	guint8 time[16] = {0};
	gchar uuid[37] = {0};
	gchar* _tmp0_;
	gchar* result;
	uuid_generate (time);
	uuid_unparse_lower (time, uuid);
	_tmp0_ = g_strdup ((const gchar*) uuid);
	result = _tmp0_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
budgie_raven_plugin_manager_reset_dconf_path (const gchar* path)
{
	gchar* argv[4] = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_[4] = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	g_settings_sync ();
	_tmp0_ = g_strdup ("dconf");
	_tmp1_ = g_strdup ("reset");
	_tmp2_ = g_strdup ("-f");
	_tmp3_ = g_strdup (path);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	memcpy (argv, _tmp4_, 4 * sizeof (gchar*));
	g_message ("plugin_manager.vala:189: Resetting dconf path: %s", path);
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = _vala_g_strjoinv (" ", argv, (gint) 4);
		_tmp6_ = _tmp5_;
		g_spawn_command_line_sync (_tmp6_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("plugin_manager.vala:194: Failed to reset dconf path %s: %s", path, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_array_destroy (argv, 4, (GDestroyNotify) g_free);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_settings_sync ();
	_vala_array_destroy (argv, 4, (GDestroyNotify) g_free);
}

static void
budgie_value_raven_plugin_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_raven_plugin_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_raven_plugin_manager_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_raven_plugin_manager_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_raven_plugin_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_raven_plugin_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_raven_plugin_manager_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieRavenPluginManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_raven_plugin_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_raven_plugin_manager_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	BudgieRavenPluginManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_raven_plugin_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_raven_plugin_manager (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	BudgieParamSpecRavenPluginManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_raven_plugin_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_raven_plugin_manager (GValue* value,
                                       gpointer v_object)
{
	BudgieRavenPluginManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_raven_plugin_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_plugin_manager_unref (old);
	}
}

void
budgie_value_take_raven_plugin_manager (GValue* value,
                                        gpointer v_object)
{
	BudgieRavenPluginManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_plugin_manager_unref (old);
	}
}

static void
budgie_raven_plugin_manager_class_init (BudgieRavenPluginManagerClass * klass,
                                        gpointer klass_data)
{
	budgie_raven_plugin_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieRavenPluginManagerClass *) klass)->finalize = budgie_raven_plugin_manager_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieRavenPluginManager_private_offset);
	budgie_raven_plugin_manager_signals[BUDGIE_RAVEN_PLUGIN_MANAGER_EXISTING_WIDGETS_LOADED_SIGNAL] = g_signal_new ("existing-widgets-loaded", BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
}

static void
budgie_raven_plugin_manager_instance_init (BudgieRavenPluginManager * self,
                                           gpointer klass)
{
	self->priv = budgie_raven_plugin_manager_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_plugins);
	self->ref_count = 1;
}

static void
budgie_raven_plugin_manager_finalize (BudgieRavenPluginManager * obj)
{
	BudgieRavenPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_PLUGIN_MANAGER, BudgieRavenPluginManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->plugin_set);
	g_rec_mutex_clear (&self->priv->__lock_plugins);
	_g_hash_table_unref0 (self->priv->plugins);
}

static GType
budgie_raven_plugin_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_raven_plugin_manager_init, budgie_value_raven_plugin_manager_free_value, budgie_value_raven_plugin_manager_copy_value, budgie_value_raven_plugin_manager_peek_pointer, "p", budgie_value_raven_plugin_manager_collect_value, "p", budgie_value_raven_plugin_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenPluginManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_plugin_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenPluginManager), 0, (GInstanceInitFunc) budgie_raven_plugin_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_raven_plugin_manager_type_id;
	budgie_raven_plugin_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieRavenPluginManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgieRavenPluginManager_private_offset = g_type_add_instance_private (budgie_raven_plugin_manager_type_id, sizeof (BudgieRavenPluginManagerPrivate));
	return budgie_raven_plugin_manager_type_id;
}

GType
budgie_raven_plugin_manager_get_type (void)
{
	static volatile gsize budgie_raven_plugin_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_plugin_manager_type_id__once)) {
		GType budgie_raven_plugin_manager_type_id;
		budgie_raven_plugin_manager_type_id = budgie_raven_plugin_manager_get_type_once ();
		g_once_init_leave (&budgie_raven_plugin_manager_type_id__once, budgie_raven_plugin_manager_type_id);
	}
	return budgie_raven_plugin_manager_type_id__once;
}

gpointer
budgie_raven_plugin_manager_ref (gpointer instance)
{
	BudgieRavenPluginManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_raven_plugin_manager_unref (gpointer instance)
{
	BudgieRavenPluginManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_RAVEN_PLUGIN_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
budgie_raven_widget_data_get_instance_private (BudgieRavenWidgetData* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRavenWidgetData_private_offset);
}

BudgieRavenWidgetData*
budgie_raven_widget_data_construct (GType object_type,
                                    GtkBin* widget_instance,
                                    PeasPluginInfo* plugin_info,
                                    const gchar* uuid,
                                    gboolean supports_settings)
{
	BudgieRavenWidgetData* self = NULL;
	g_return_val_if_fail (widget_instance != NULL, NULL);
	g_return_val_if_fail (plugin_info != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (BudgieRavenWidgetData*) g_type_create_instance (object_type);
	budgie_raven_widget_data_set_widget_instance (self, widget_instance);
	budgie_raven_widget_data_set_plugin_info (self, plugin_info);
	budgie_raven_widget_data_set_uuid (self, uuid);
	budgie_raven_widget_data_set_supports_settings (self, supports_settings);
	return self;
}

BudgieRavenWidgetData*
budgie_raven_widget_data_new (GtkBin* widget_instance,
                              PeasPluginInfo* plugin_info,
                              const gchar* uuid,
                              gboolean supports_settings)
{
	return budgie_raven_widget_data_construct (BUDGIE_TYPE_RAVEN_WIDGET_DATA, widget_instance, plugin_info, uuid, supports_settings);
}

GtkBin*
budgie_raven_widget_data_get_widget_instance (BudgieRavenWidgetData* self)
{
	GtkBin* result;
	GtkBin* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget_instance;
	result = _tmp0_;
	return result;
}

static void
budgie_raven_widget_data_set_widget_instance (BudgieRavenWidgetData* self,
                                              GtkBin* value)
{
	GtkBin* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_widget_instance);
	self->priv->_widget_instance = _tmp0_;
}

PeasPluginInfo*
budgie_raven_widget_data_get_plugin_info (BudgieRavenWidgetData* self)
{
	PeasPluginInfo* result;
	PeasPluginInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin_info;
	result = _tmp0_;
	return result;
}

static void
budgie_raven_widget_data_set_plugin_info (BudgieRavenWidgetData* self,
                                          PeasPluginInfo* value)
{
	PeasPluginInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __vala_PeasPluginInfo_copy0 (value);
	__vala_PeasPluginInfo_free0 (self->priv->_plugin_info);
	self->priv->_plugin_info = _tmp0_;
}

const gchar*
budgie_raven_widget_data_get_uuid (BudgieRavenWidgetData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

static void
budgie_raven_widget_data_set_uuid (BudgieRavenWidgetData* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uuid);
	self->priv->_uuid = _tmp0_;
}

gboolean
budgie_raven_widget_data_get_supports_settings (BudgieRavenWidgetData* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_supports_settings;
	return result;
}

static void
budgie_raven_widget_data_set_supports_settings (BudgieRavenWidgetData* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_supports_settings = value;
}

static void
budgie_value_raven_widget_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_raven_widget_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_raven_widget_data_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_raven_widget_data_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_raven_widget_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_raven_widget_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_raven_widget_data_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieRavenWidgetData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_raven_widget_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_raven_widget_data_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	BudgieRavenWidgetData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_raven_widget_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_raven_widget_data (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	BudgieParamSpecRavenWidgetData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_RAVEN_WIDGET_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_raven_widget_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_WIDGET_DATA), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_raven_widget_data (GValue* value,
                                    gpointer v_object)
{
	BudgieRavenWidgetData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_WIDGET_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_WIDGET_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_raven_widget_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_widget_data_unref (old);
	}
}

void
budgie_value_take_raven_widget_data (GValue* value,
                                     gpointer v_object)
{
	BudgieRavenWidgetData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_RAVEN_WIDGET_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_RAVEN_WIDGET_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_raven_widget_data_unref (old);
	}
}

static void
budgie_raven_widget_data_class_init (BudgieRavenWidgetDataClass * klass,
                                     gpointer klass_data)
{
	budgie_raven_widget_data_parent_class = g_type_class_peek_parent (klass);
	((BudgieRavenWidgetDataClass *) klass)->finalize = budgie_raven_widget_data_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieRavenWidgetData_private_offset);
}

static void
budgie_raven_widget_data_instance_init (BudgieRavenWidgetData * self,
                                        gpointer klass)
{
	self->priv = budgie_raven_widget_data_get_instance_private (self);
	self->ref_count = 1;
}

static void
budgie_raven_widget_data_finalize (BudgieRavenWidgetData * obj)
{
	BudgieRavenWidgetData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RAVEN_WIDGET_DATA, BudgieRavenWidgetData);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_widget_instance);
	__vala_PeasPluginInfo_free0 (self->priv->_plugin_info);
	_g_free0 (self->priv->_uuid);
}

static GType
budgie_raven_widget_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_raven_widget_data_init, budgie_value_raven_widget_data_free_value, budgie_value_raven_widget_data_copy_value, budgie_value_raven_widget_data_peek_pointer, "p", budgie_value_raven_widget_data_collect_value, "p", budgie_value_raven_widget_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRavenWidgetDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_raven_widget_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRavenWidgetData), 0, (GInstanceInitFunc) budgie_raven_widget_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_raven_widget_data_type_id;
	budgie_raven_widget_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieRavenWidgetData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgieRavenWidgetData_private_offset = g_type_add_instance_private (budgie_raven_widget_data_type_id, sizeof (BudgieRavenWidgetDataPrivate));
	return budgie_raven_widget_data_type_id;
}

GType
budgie_raven_widget_data_get_type (void)
{
	static volatile gsize budgie_raven_widget_data_type_id__once = 0;
	if (g_once_init_enter (&budgie_raven_widget_data_type_id__once)) {
		GType budgie_raven_widget_data_type_id;
		budgie_raven_widget_data_type_id = budgie_raven_widget_data_get_type_once ();
		g_once_init_leave (&budgie_raven_widget_data_type_id__once, budgie_raven_widget_data_type_id);
	}
	return budgie_raven_widget_data_type_id__once;
}

gpointer
budgie_raven_widget_data_ref (gpointer instance)
{
	BudgieRavenWidgetData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_raven_widget_data_unref (gpointer instance)
{
	BudgieRavenWidgetData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_RAVEN_WIDGET_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

