/* notifications_group.c generated by valac 0.56.14, the Vala compiler
 * generated from notifications_group.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "budgie-private.h"
#include <pango/pango.h>

enum  {
	BUDGIE_NOTIFICATION_GROUP_0_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY,
	BUDGIE_NOTIFICATION_GROUP_NUM_PROPERTIES
};
static GParamSpec* budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
enum  {
	BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL,
	BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL,
	BUDGIE_NOTIFICATION_GROUP_NUM_SIGNALS
};
static guint budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_NUM_SIGNALS] = {0};

struct _BudgieNotificationGroupPrivate {
	GHashTable* notifications;
	GtkLabel* name_label;
	GtkButton* dismiss_button;
	GtkListBox* noti_box;
	gchar* _app_name;
	GtkImage* _image;
	guint _tokeep;
	BudgieNotificationSort _noti_sort_mode;
	gint _noti_count;
};

struct _Block2Data {
	int _ref_count_;
	BudgieNotificationGroup* self;
	BudgieNotification* notification;
};

static gint BudgieNotificationGroup_private_offset;
static gpointer budgie_notification_group_parent_class = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void budgie_notification_group_update_count (BudgieNotificationGroup* self);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__notification_widget_closed_individually (NotificationWidget* _sender,
                                                          gpointer self);
static gboolean __lambda10_ (BudgieNotificationGroup* self,
                      guint32 id,
                      NotificationWidget* widget);
static gboolean ___lambda10__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gint __lambda8_ (guint32 a,
                 guint32 b);
static gint ___lambda8__gcompare_func (gconstpointer a,
                                gconstpointer b);
static void budgie_notification_group_set_noti_count (BudgieNotificationGroup* self,
                                               gint value);
static gint budgie_notification_group_sort_notifications (BudgieNotificationGroup* self,
                                                   GtkListBoxRow* a,
                                                   GtkListBoxRow* b);
static GObject * budgie_notification_group_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static gint _budgie_notification_group_sort_notifications_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                           GtkListBoxRow* row2,
                                                                           gpointer self);
static void _budgie_notification_group_dismiss_all_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void budgie_notification_group_finalize (GObject * obj);
static GType budgie_notification_group_get_type_once (void);
static void _vala_budgie_notification_group_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_budgie_notification_group_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
budgie_notification_group_get_instance_private (BudgieNotificationGroup* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationGroup_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieNotificationGroup*
budgie_notification_group_construct (GType object_type,
                                     BudgieNotification* notification,
                                     BudgieNotificationSort sort_mode,
                                     guint keep)
{
	BudgieNotificationGroup * self = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_val_if_fail (notification != NULL, NULL);
	_tmp1_ = budgie_notification_get_app_image (notification);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		GtkImage* _tmp4_ = NULL;
		GtkImage* _tmp5_;
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* _tmp9_;
		_tmp5_ = budgie_notification_get_image (notification);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_tmp4_ = _tmp7_;
		if (_tmp4_ == NULL) {
			GtkImage* _tmp8_;
			_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("applications-internet", (GtkIconSize) GTK_ICON_SIZE_DND);
			g_object_ref_sink (_tmp8_);
			_g_object_unref0 (_tmp4_);
			_tmp4_ = _tmp8_;
		}
		_tmp9_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp9_;
		_g_object_unref0 (_tmp4_);
	}
	_tmp10_ = budgie_notification_get_app_name (notification);
	_tmp11_ = _tmp10_;
	self = (BudgieNotificationGroup*) g_object_new (object_type, "app-name", _tmp11_, "image", _tmp0_, "tokeep", keep, "noti-sort-mode", sort_mode, "activatable", FALSE, "selectable", FALSE, "can-focus", FALSE, "focus-on-click", FALSE, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

BudgieNotificationGroup*
budgie_notification_group_new (BudgieNotification* notification,
                               BudgieNotificationSort sort_mode,
                               guint keep)
{
	return budgie_notification_group_construct (BUDGIE_TYPE_NOTIFICATION_GROUP, notification, sort_mode, keep);
}

/**
 * add_notification is responsible for adding a notification (if it doesn't exist) and updating our counter
 */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieNotificationGroup* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->notification);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda9_ (Block2Data* _data2_)
{
	BudgieNotificationGroup* self;
	guint32 _tmp0_;
	guint32 _tmp1_;
	self = _data2_->self;
	_tmp0_ = budgie_notification_get_id (_data2_->notification);
	_tmp1_ = _tmp0_;
	budgie_notification_group_remove_notification (self, (guint32) ((guint) _tmp1_));
}

static void
___lambda9__notification_widget_closed_individually (NotificationWidget* _sender,
                                                     gpointer self)
{
	__lambda9_ (self);
}

void
budgie_notification_group_add_notification (BudgieNotificationGroup* self,
                                            guint32 id,
                                            BudgieNotification* notification)
{
	Block2Data* _data2_;
	BudgieNotification* _tmp0_;
	GHashTable* _tmp1_;
	NotificationWidget* widget = NULL;
	NotificationWidget* _tmp2_;
	GHashTable* _tmp3_;
	NotificationWidget* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data2_->notification);
	_data2_->notification = _tmp0_;
	_tmp1_ = self->priv->notifications;
	if (g_hash_table_contains (_tmp1_, (gpointer) ((guintptr) id))) {
		budgie_notification_group_remove_notification (self, id);
	}
	_tmp2_ = notification_widget_new (_data2_->notification);
	g_object_ref_sink (_tmp2_);
	widget = _tmp2_;
	_tmp3_ = self->priv->notifications;
	_tmp4_ = _g_object_ref0 (widget);
	g_hash_table_insert (_tmp3_, (gpointer) ((guintptr) id), _tmp4_);
	_tmp5_ = self->priv->noti_box;
	gtk_list_box_prepend (_tmp5_, (GtkWidget*) widget);
	_tmp6_ = self->priv->noti_box;
	gtk_list_box_invalidate_sort (_tmp6_);
	budgie_notification_group_update_count (self);
	g_signal_connect_data (widget, "closed-individually", (GCallback) ___lambda9__notification_widget_closed_individually, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (widget);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

/**
 * dismiss_all is responsible for dismissing all notifications
 */
static gboolean
__lambda10_ (BudgieNotificationGroup* self,
             guint32 id,
             NotificationWidget* widget)
{
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	gtk_widget_destroy ((GtkWidget*) widget);
	g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL], 0, id);
	result = TRUE;
	return result;
}

static gboolean
___lambda10__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda10_ ((BudgieNotificationGroup*) self, (guint32) ((guintptr) key), (NotificationWidget*) value);
	return result;
}

void
budgie_notification_group_dismiss_all (BudgieNotificationGroup* self)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	g_hash_table_foreach_remove (_tmp0_, ___lambda10__ghr_func, self);
	budgie_notification_group_update_count (self);
	_tmp1_ = self->priv->_app_name;
	g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL], 0, _tmp1_);
}

/**
 * remove_notification is responsible for removing a notification (if it exists) and updating our counter
 */
void
budgie_notification_group_remove_notification (BudgieNotificationGroup* self,
                                               guint32 id)
{
	NotificationWidget* widget = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	NotificationWidget* _tmp2_;
	NotificationWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((NotificationWidget*) _tmp1_);
	widget = _tmp2_;
	_tmp3_ = widget;
	if (_tmp3_ != NULL) {
		GHashTable* _tmp4_;
		NotificationWidget* _tmp5_;
		GtkListBox* _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->notifications;
		g_hash_table_remove (_tmp4_, (gpointer) ((guintptr) id));
		_tmp5_ = widget;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->noti_box;
		gtk_list_box_invalidate_sort (_tmp6_);
		budgie_notification_group_update_count (self);
		g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL], 0, id);
		_tmp7_ = self->priv->_noti_count;
		if (_tmp7_ == 0) {
			const gchar* _tmp8_;
			_tmp8_ = self->priv->_app_name;
			g_signal_emit (self, budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL], 0, _tmp8_);
		}
	}
	_g_object_unref0 (widget);
}

/**
 * too many notifications will choke raven and the desktop, so let's set a limit;
 * keep the latest n-notifications of current group, delete older ones
 */
static gint
__lambda8_ (guint32 a,
            guint32 b)
{
	gint result;
	result = ((gint) (a > b)) - ((gint) (a < b));
	return result;
}

static gint
___lambda8__gcompare_func (gconstpointer a,
                           gconstpointer b)
{
	gint result;
	result = __lambda8_ ((guint32) ((guintptr) a), (guint32) ((guintptr) b));
	return result;
}

void
budgie_notification_group_limit_notifications (BudgieNotificationGroup* self)
{
	GList* currnotifs = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	guint n_currnotifs = 0U;
	GList* _tmp2_;
	guint _tmp3_;
	guint n_remove = 0U;
	guint _tmp4_;
	gint count = 0;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	currnotifs = _tmp1_;
	currnotifs = g_list_sort (currnotifs, ___lambda8__gcompare_func);
	_tmp2_ = currnotifs;
	n_currnotifs = g_list_length (_tmp2_);
	_tmp3_ = self->priv->_tokeep;
	if (n_currnotifs <= _tmp3_) {
		(currnotifs == NULL) ? NULL : (currnotifs = (g_list_free (currnotifs), NULL));
		return;
	}
	_tmp4_ = self->priv->_tokeep;
	n_remove = n_currnotifs - _tmp4_;
	count = 0;
	_tmp5_ = currnotifs;
	{
		GList* n_collection = NULL;
		GList* n_it = NULL;
		n_collection = _tmp5_;
		for (n_it = n_collection; n_it != NULL; n_it = n_it->next) {
			guint n = 0U;
			n = (guint) ((guint32) ((guintptr) n_it->data));
			{
				gint _tmp6_;
				if (((guint) count) >= n_remove) {
					break;
				}
				budgie_notification_group_remove_notification (self, (guint32) n);
				_tmp6_ = count;
				count = _tmp6_ + 1;
			}
		}
	}
	(currnotifs == NULL) ? NULL : (currnotifs = (g_list_free (currnotifs), NULL));
}

/**
 * if the total number of notifications exceeds threshold, NotificationsView will
 * update the max number per group ('tokeep')
 */
void
budgie_notification_group_set_group_max_notifications (BudgieNotificationGroup* self,
                                                       guint keep)
{
	g_return_if_fail (self != NULL);
	budgie_notification_group_set_tokeep (self, keep);
}

/**
 * update_count updates our notifications count for this group
 */
static void
budgie_notification_group_update_count (BudgieNotificationGroup* self)
{
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	guint _tmp4_;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	budgie_notification_group_set_noti_count (self, (gint) _tmp2_);
	_tmp3_ = self->priv->_noti_count;
	_tmp4_ = self->priv->_tokeep;
	if (((guint) _tmp3_) > _tmp4_) {
		budgie_notification_group_limit_notifications (self);
	}
	_tmp5_ = self->priv->name_label;
	_tmp6_ = self->priv->_app_name;
	_tmp7_ = self->priv->_noti_count;
	_tmp8_ = g_strdup_printf ("<b>%s (%i)</b>", _tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_markup (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
}

static gint
budgie_notification_group_sort_notifications (BudgieNotificationGroup* self,
                                              GtkListBoxRow* a,
                                              GtkListBoxRow* b)
{
	NotificationWidget* noti_a = NULL;
	NotificationWidget* _tmp0_;
	NotificationWidget* noti_b = NULL;
	NotificationWidget* _tmp1_;
	BudgieNotificationSort _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (IS_NOTIFICATION_WIDGET (a) ? ((NotificationWidget*) a) : NULL);
	noti_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (IS_NOTIFICATION_WIDGET (b) ? ((NotificationWidget*) b) : NULL);
	noti_b = _tmp1_;
	_tmp2_ = self->priv->_noti_sort_mode;
	switch (_tmp2_) {
		case BUDGIE_NOTIFICATION_SORT_NEW_OLD:
		{
			NotificationWidget* _tmp3_;
			BudgieNotification* _tmp4_;
			BudgieNotification* _tmp5_;
			gint64 _tmp6_;
			gint64 _tmp7_;
			NotificationWidget* _tmp8_;
			BudgieNotification* _tmp9_;
			BudgieNotification* _tmp10_;
			gint64 _tmp11_;
			gint64 _tmp12_;
			_tmp3_ = noti_b;
			_tmp4_ = notification_widget_get_notification (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = budgie_notification_get_timestamp (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = noti_a;
			_tmp9_ = notification_widget_get_notification (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = budgie_notification_get_timestamp (_tmp10_);
			_tmp12_ = _tmp11_;
			result = (gint) (_tmp7_ - _tmp12_);
			_g_object_unref0 (noti_b);
			_g_object_unref0 (noti_a);
			return result;
		}
		case BUDGIE_NOTIFICATION_SORT_OLD_NEW:
		{
			NotificationWidget* _tmp13_;
			BudgieNotification* _tmp14_;
			BudgieNotification* _tmp15_;
			gint64 _tmp16_;
			gint64 _tmp17_;
			NotificationWidget* _tmp18_;
			BudgieNotification* _tmp19_;
			BudgieNotification* _tmp20_;
			gint64 _tmp21_;
			gint64 _tmp22_;
			_tmp13_ = noti_a;
			_tmp14_ = notification_widget_get_notification (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = budgie_notification_get_timestamp (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = noti_b;
			_tmp19_ = notification_widget_get_notification (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = budgie_notification_get_timestamp (_tmp20_);
			_tmp22_ = _tmp21_;
			result = (gint) (_tmp17_ - _tmp22_);
			_g_object_unref0 (noti_b);
			_g_object_unref0 (noti_a);
			return result;
		}
		default:
		break;
	}
	result = 0;
	_g_object_unref0 (noti_b);
	_g_object_unref0 (noti_a);
	return result;
}

/**
 * Set the sort mode for this notification group.
 */
void
budgie_notification_group_set_sort_mode (BudgieNotificationGroup* self,
                                         BudgieNotificationSort sort_mode)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	budgie_notification_group_set_noti_sort_mode (self, sort_mode);
	_tmp0_ = self->priv->noti_box;
	gtk_list_box_invalidate_sort (_tmp0_);
}

const gchar*
budgie_notification_group_get_app_name (BudgieNotificationGroup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_group_set_app_name (BudgieNotificationGroup* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_group_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY]);
	}
}

GtkImage*
budgie_notification_group_get_image (BudgieNotificationGroup* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_group_set_image (BudgieNotificationGroup* self,
                                     GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_group_get_image (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_image);
		self->priv->_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY]);
	}
}

guint
budgie_notification_group_get_tokeep (BudgieNotificationGroup* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_tokeep;
	return result;
}

void
budgie_notification_group_set_tokeep (BudgieNotificationGroup* self,
                                      guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_group_get_tokeep (self);
	if (old_value != value) {
		self->priv->_tokeep = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY]);
	}
}

BudgieNotificationSort
budgie_notification_group_get_noti_sort_mode (BudgieNotificationGroup* self)
{
	BudgieNotificationSort result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_noti_sort_mode;
	return result;
}

void
budgie_notification_group_set_noti_sort_mode (BudgieNotificationGroup* self,
                                              BudgieNotificationSort value)
{
	BudgieNotificationSort old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_group_get_noti_sort_mode (self);
	if (old_value != value) {
		self->priv->_noti_sort_mode = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY]);
	}
}

gint
budgie_notification_group_get_noti_count (BudgieNotificationGroup* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_noti_count;
	return result;
}

static void
budgie_notification_group_set_noti_count (BudgieNotificationGroup* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_group_get_noti_count (self);
	if (old_value != value) {
		self->priv->_noti_count = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY]);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gint
_budgie_notification_group_sort_notifications_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self)
{
	gint result;
	result = budgie_notification_group_sort_notifications ((BudgieNotificationGroup*) self, row1, row2);
	return result;
}

static void
_budgie_notification_group_dismiss_all_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	budgie_notification_group_dismiss_all ((BudgieNotificationGroup*) self);
}

static GObject *
budgie_notification_group_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationGroup * self;
	GtkStyleContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_;
	GtkBox* header = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkImage* app_icon = NULL;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	const gchar* _tmp14_;
	GtkLabel* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkButton* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkButton* _tmp21_;
	GtkBox* _tmp22_;
	GtkImage* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkButton* _tmp27_;
	GtkBox* box = NULL;
	GtkBox* _tmp28_ = NULL;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkListBox* _tmp32_;
	GtkBox* _tmp33_;
	parent_class = G_OBJECT_CLASS (budgie_notification_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "raven-notifications-group");
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp3_;
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp4_, FALSE);
	gtk_widget_set_focus_on_click ((GtkWidget*) _tmp4_, FALSE);
	gtk_list_box_set_selection_mode (_tmp4_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->noti_box);
	self->priv->noti_box = _tmp4_;
	_tmp5_ = self->priv->noti_box;
	gtk_list_box_set_sort_func (_tmp5_, _budgie_notification_group_sort_notifications_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	header = _tmp6_;
	_tmp7_ = header;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "raven-notifications-group-header");
	_tmp9_ = self->priv->_image;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	app_icon = _tmp10_;
	_tmp11_ = app_icon;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
	_tmp12_ = app_icon;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp12_, 5);
	_tmp13_ = app_icon;
	gtk_image_set_pixel_size (_tmp13_, 32);
	_tmp14_ = self->priv->_app_name;
	_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
	gtk_label_set_ellipsize (_tmp15_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	gtk_label_set_justify (_tmp15_, GTK_JUSTIFY_LEFT);
	gtk_label_set_use_markup (_tmp15_, TRUE);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp15_;
	_tmp16_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-all-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->dismiss_button);
	self->priv->dismiss_button = _tmp16_;
	_tmp17_ = self->priv->dismiss_button;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "flat");
	_tmp19_ = self->priv->dismiss_button;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	gtk_style_context_add_class (_tmp20_, "image-button");
	_tmp21_ = self->priv->dismiss_button;
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) _budgie_notification_group_dismiss_all_gtk_button_clicked, self, 0);
	_tmp22_ = header;
	_tmp23_ = app_icon;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 0);
	_tmp24_ = header;
	_tmp25_ = self->priv->name_label;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	_tmp26_ = header;
	_tmp27_ = self->priv->dismiss_button;
	gtk_box_pack_end (_tmp26_, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 4);
	g_object_set ((GtkWidget*) _tmp28_, "margin", 4, NULL);
	g_object_ref_sink (_tmp28_);
	box = _tmp28_;
	_tmp29_ = box;
	_tmp30_ = header;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, TRUE, TRUE, (guint) 0);
	_tmp31_ = box;
	_tmp32_ = self->priv->noti_box;
	gtk_box_pack_start (_tmp31_, (GtkWidget*) _tmp32_, TRUE, TRUE, (guint) 0);
	_tmp33_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_g_object_unref0 (box);
	_g_object_unref0 (app_icon);
	_g_object_unref0 (header);
	return obj;
}

static void
budgie_notification_group_class_init (BudgieNotificationGroupClass * klass,
                                      gpointer klass_data)
{
	budgie_notification_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationGroup_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notification_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notification_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notification_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY] = g_param_spec_uint ("tokeep", "tokeep", "tokeep", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY] = g_param_spec_enum ("noti-sort-mode", "noti-sort-mode", "noti-sort-mode", BUDGIE_TYPE_NOTIFICATION_SORT, BUDGIE_NOTIFICATION_SORT_NEW_OLD, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY, budgie_notification_group_properties[BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY] = g_param_spec_int ("noti-count", "noti-count", "noti-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_GROUP_SIGNAL] = g_signal_new ("dismissed-group", BUDGIE_TYPE_NOTIFICATION_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	budgie_notification_group_signals[BUDGIE_NOTIFICATION_GROUP_DISMISSED_NOTIFICATION_SIGNAL] = g_signal_new ("dismissed-notification", BUDGIE_TYPE_NOTIFICATION_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
budgie_notification_group_instance_init (BudgieNotificationGroup * self,
                                         gpointer klass)
{
	self->priv = budgie_notification_group_get_instance_private (self);
	self->priv->_noti_sort_mode = BUDGIE_NOTIFICATION_SORT_NEW_OLD;
	self->priv->_noti_count = 0;
}

static void
budgie_notification_group_finalize (GObject * obj)
{
	BudgieNotificationGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup);
	_g_hash_table_unref0 (self->priv->notifications);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->dismiss_button);
	_g_object_unref0 (self->priv->noti_box);
	_g_free0 (self->priv->_app_name);
	_g_object_unref0 (self->priv->_image);
	G_OBJECT_CLASS (budgie_notification_group_parent_class)->finalize (obj);
}

/**
 * NotificationGroup is a group of notifications.
 */
static GType
budgie_notification_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationGroup), 0, (GInstanceInitFunc) budgie_notification_group_instance_init, NULL };
	GType budgie_notification_group_type_id;
	budgie_notification_group_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BudgieNotificationGroup", &g_define_type_info, 0);
	BudgieNotificationGroup_private_offset = g_type_add_instance_private (budgie_notification_group_type_id, sizeof (BudgieNotificationGroupPrivate));
	return budgie_notification_group_type_id;
}

GType
budgie_notification_group_get_type (void)
{
	static volatile gsize budgie_notification_group_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_group_type_id__once)) {
		GType budgie_notification_group_type_id;
		budgie_notification_group_type_id = budgie_notification_group_get_type_once ();
		g_once_init_leave (&budgie_notification_group_type_id__once, budgie_notification_group_type_id);
	}
	return budgie_notification_group_type_id__once;
}

static void
_vala_budgie_notification_group_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY:
		g_value_set_string (value, budgie_notification_group_get_app_name (self));
		break;
		case BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY:
		g_value_set_object (value, budgie_notification_group_get_image (self));
		break;
		case BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY:
		g_value_set_uint (value, budgie_notification_group_get_tokeep (self));
		break;
		case BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY:
		g_value_set_enum (value, budgie_notification_group_get_noti_sort_mode (self));
		break;
		case BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY:
		g_value_set_int (value, budgie_notification_group_get_noti_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notification_group_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION_GROUP, BudgieNotificationGroup);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_GROUP_APP_NAME_PROPERTY:
		budgie_notification_group_set_app_name (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_GROUP_IMAGE_PROPERTY:
		budgie_notification_group_set_image (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATION_GROUP_TOKEEP_PROPERTY:
		budgie_notification_group_set_tokeep (self, g_value_get_uint (value));
		break;
		case BUDGIE_NOTIFICATION_GROUP_NOTI_SORT_MODE_PROPERTY:
		budgie_notification_group_set_noti_sort_mode (self, g_value_get_enum (value));
		break;
		case BUDGIE_NOTIFICATION_GROUP_NOTI_COUNT_PROPERTY:
		budgie_notification_group_set_noti_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

