/* main_view.c generated by valac 0.56.14, the Vala compiler
 * generated from main_view.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raven.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include "raven-plugin.h"

enum  {
	BUDGIE_MAIN_VIEW_0_PROPERTY,
	BUDGIE_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* budgie_main_view_properties[BUDGIE_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
enum  {
	BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL,
	BUDGIE_MAIN_VIEW_NUM_SIGNALS
};
static guint budgie_main_view_signals[BUDGIE_MAIN_VIEW_NUM_SIGNALS] = {0};

struct _BudgieMainViewPrivate {
	GtkBox* box;
	GtkLabel* widget_placeholder;
	GSettings* raven_settings;
	GtkScrolledWindow* scroll;
	GtkStack* main_stack;
	GtkStackSwitcher* switcher;
};

struct _Block1Data {
	int _ref_count_;
	BudgieMainView* self;
	gboolean expanded;
};

static gint BudgieMainView_private_offset;
static gpointer budgie_main_view_parent_class = NULL;

static void budgie_main_view_on_raven_settings_changed (BudgieMainView* self,
                                                 const gchar* key);
static void _budgie_main_view_on_raven_settings_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void budgie_main_view_on_name_change (BudgieMainView* self);
static void _budgie_main_view_on_name_change_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda12_ (Block1Data* _data1_,
                  GtkWidget* child);
static void ___lambda12__gfunc (gconstpointer data,
                         gpointer self);
static void budgie_main_view_finalize (GObject * obj);
static GType budgie_main_view_get_type_once (void);

static inline gpointer
budgie_main_view_get_instance_private (BudgieMainView* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMainView_private_offset);
}

void
budgie_main_view_expose_notification (BudgieMainView* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "notifications");
}

static void
_budgie_main_view_on_raven_settings_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	budgie_main_view_on_raven_settings_changed ((BudgieMainView*) self, key);
}

static void
_budgie_main_view_on_name_change_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	budgie_main_view_on_name_change ((BudgieMainView*) self);
}

BudgieMainView*
budgie_main_view_construct (GType object_type)
{
	BudgieMainView * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkBox* header = NULL;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStack* _tmp5_;
	GtkStack* _tmp6_;
	GtkStackSwitcher* _tmp7_;
	GtkStackSwitcher* _tmp8_;
	GtkStackSwitcher* _tmp9_;
	GtkStackSwitcher* _tmp10_;
	GtkStackSwitcher* _tmp11_;
	GtkStackSwitcher* _tmp12_;
	GtkStack* _tmp13_;
	GtkStackSwitcher* _tmp14_;
	GtkStack* _tmp15_;
	GtkScrolledWindow* _tmp16_;
	GtkStack* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	BudgieNotificationsView* not = NULL;
	BudgieNotificationsView* _tmp19_;
	GtkStack* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkLabel* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkLabel* _tmp33_;
	GtkScrolledWindow* _tmp34_;
	GtkBox* _tmp35_;
	GtkScrolledWindow* _tmp36_;
	GtkStack* _tmp37_;
	self = (BudgieMainView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_tmp0_ = g_settings_new ("com.solus-project.budgie-raven");
	_g_object_unref0 (self->priv->raven_settings);
	self->priv->raven_settings = _tmp0_;
	_tmp1_ = self->priv->raven_settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _budgie_main_view_on_raven_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	header = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp3_, "raven-header");
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp4_, "top");
	_tmp5_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp5_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) header, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp7_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->switcher);
	self->priv->switcher = _tmp7_;
	_tmp8_ = self->priv->switcher;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = self->priv->switcher;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp9_, 4);
	_tmp10_ = self->priv->switcher;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 4);
	_tmp11_ = self->priv->switcher;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->priv->switcher;
	_tmp13_ = self->priv->main_stack;
	gtk_stack_switcher_set_stack (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->switcher;
	gtk_box_pack_start (header, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_tmp15_ = self->priv->main_stack;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	_tmp16_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->scroll);
	self->priv->scroll = _tmp16_;
	_tmp17_ = self->priv->main_stack;
	_tmp18_ = self->priv->scroll;
	gtk_stack_add_titled (_tmp17_, (GtkWidget*) _tmp18_, "widgets", _ ("Widgets"));
	_tmp19_ = budgie_notifications_view_new ();
	g_object_ref_sink (_tmp19_);
	not = _tmp19_;
	_tmp20_ = self->priv->main_stack;
	gtk_stack_add_titled (_tmp20_, (GtkWidget*) not, "notifications", _ ("Notifications"));
	_tmp21_ = self->priv->scroll;
	gtk_scrolled_window_set_policy (_tmp21_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_set (_tmp22_, "wrap", TRUE, NULL);
	g_object_set (_tmp22_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp22_, 1);
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->widget_placeholder);
	self->priv->widget_placeholder = _tmp22_;
	_tmp23_ = self->priv->widget_placeholder;
	_tmp24_ = g_strdup_printf ("<big>%s</big>", _ ("No widgets added."));
	_tmp25_ = _tmp24_;
	gtk_label_set_markup (_tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->widget_placeholder;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
	gtk_style_context_add_class (_tmp27_, "dim-label");
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 8);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp28_;
	_tmp29_ = self->priv->box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp29_, 8);
	_tmp30_ = self->priv->box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp30_, 8);
	_tmp31_ = self->priv->box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp31_, 250, -1);
	_tmp32_ = self->priv->box;
	_tmp33_ = self->priv->widget_placeholder;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->scroll;
	_tmp35_ = self->priv->box;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->scroll;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->main_stack;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::visible-child-name", (GCallback) _budgie_main_view_on_name_change_g_object_notify, self, 0);
	budgie_main_view_set_clean (self);
	_g_object_unref0 (not);
	_g_object_unref0 (header);
	return self;
}

BudgieMainView*
budgie_main_view_new (void)
{
	return budgie_main_view_construct (BUDGIE_TYPE_MAIN_VIEW);
}

void
budgie_main_view_add_widget_instance (BudgieMainView* self,
                                      GtkBin* widget_instance)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->box;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) widget_instance);
	_tmp1_ = self->priv->box;
	_tmp2_ = self->priv->widget_placeholder;
	gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	g_signal_emit (self, budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL], 0);
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

void
budgie_main_view_remove_widget_instance (BudgieMainView* self,
                                         GtkBin* widget_instance)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->box;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) widget_instance);
	_tmp1_ = self->priv->box;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_g_list_is_empty (_tmp3_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	if (_tmp4_) {
		GtkBox* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp5_ = self->priv->box;
		_tmp6_ = self->priv->widget_placeholder;
		gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	}
	g_signal_emit (self, budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL], 0);
}

void
budgie_main_view_move_widget_instance_by_offset (BudgieMainView* self,
                                                 GtkBin* widget_instance,
                                                 gint offset)
{
	gint new_index = 0;
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkBox* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_index (_tmp2_, (GtkWidget*) widget_instance) + offset;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	new_index = _tmp3_;
	_tmp5_ = self->priv->box;
	_tmp6_ = gtk_container_get_children ((GtkContainer*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = ((guint) new_index) < g_list_length (_tmp7_);
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (g_list_free (_tmp7_), NULL));
	if (_tmp8_) {
		_tmp4_ = new_index >= 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkBox* _tmp9_;
		_tmp9_ = self->priv->box;
		gtk_box_reorder_child (_tmp9_, (GtkWidget*) widget_instance, new_index);
	}
}

static void
budgie_main_view_on_name_change (BudgieMainView* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "notifications") == 0) {
		BudgieRaven* _tmp2_;
		_tmp2_ = budgie_raven_get_instance ();
		budgie_raven_ReadNotifications (_tmp2_);
	}
}

/**
* on_raven_settings_changed will handle when the settings for Raven widgets have changed
*/
static void
budgie_main_view_on_raven_settings_changed (BudgieMainView* self,
                                            const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "raven-position") == 0) {
		return;
	}
	g_signal_emit (self, budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL], 0);
}

void
budgie_main_view_set_clean (BudgieMainView* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "widgets");
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieMainView* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda12_ (Block1Data* _data1_,
             GtkWidget* child)
{
	BudgieMainView* self;
	BudgieRavenWidget* widget = NULL;
	BudgieRavenWidget* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (child, budgie_raven_widget_get_type ()) ? ((BudgieRavenWidget*) child) : NULL);
	widget = _tmp0_;
	g_signal_emit_by_name (widget, "raven-expanded", _data1_->expanded);
	_g_object_unref0 (widget);
}

static void
___lambda12__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda12_ (self, (GtkWidget*) data);
}

void
budgie_main_view_raven_expanded (BudgieMainView* self,
                                 gboolean expanded)
{
	Block1Data* _data1_;
	GtkBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->expanded = expanded;
	_tmp0_ = self->priv->box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda12__gfunc, _data1_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
budgie_main_view_class_init (BudgieMainViewClass * klass,
                             gpointer klass_data)
{
	budgie_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMainView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_main_view_finalize;
	budgie_main_view_signals[BUDGIE_MAIN_VIEW_REQUESTED_DRAW_SIGNAL] = g_signal_new ("requested-draw", BUDGIE_TYPE_MAIN_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_main_view_instance_init (BudgieMainView * self,
                                gpointer klass)
{
	self->priv = budgie_main_view_get_instance_private (self);
	self->priv->box = NULL;
	self->priv->widget_placeholder = NULL;
	self->priv->raven_settings = NULL;
	self->priv->scroll = NULL;
	self->priv->main_stack = NULL;
	self->priv->switcher = NULL;
}

static void
budgie_main_view_finalize (GObject * obj)
{
	BudgieMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_MAIN_VIEW, BudgieMainView);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->widget_placeholder);
	_g_object_unref0 (self->priv->raven_settings);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->switcher);
	G_OBJECT_CLASS (budgie_main_view_parent_class)->finalize (obj);
}

static GType
budgie_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMainView), 0, (GInstanceInitFunc) budgie_main_view_instance_init, NULL };
	GType budgie_main_view_type_id;
	budgie_main_view_type_id = g_type_register_static (gtk_box_get_type (), "BudgieMainView", &g_define_type_info, 0);
	BudgieMainView_private_offset = g_type_add_instance_private (budgie_main_view_type_id, sizeof (BudgieMainViewPrivate));
	return budgie_main_view_type_id;
}

GType
budgie_main_view_get_type (void)
{
	static volatile gsize budgie_main_view_type_id__once = 0;
	if (g_once_init_enter (&budgie_main_view_type_id__once)) {
		GType budgie_main_view_type_id;
		budgie_main_view_type_id = budgie_main_view_get_type_once ();
		g_once_init_leave (&budgie_main_view_type_id__once, budgie_main_view_type_id);
	}
	return budgie_main_view_type_id__once;
}

