/* settings_style.c generated by valac 0.56.14, the Vala compiler
 * generated from settings_style.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "budgie-private.h"
#include <pango/pango.h>

#define BUDGIE_SETTINGS_GROUP_APPEARANCE "appearance"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;

#define BUDGIE_TYPE_STYLE_PAGE (budgie_style_page_get_type ())
#define BUDGIE_STYLE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePage))
#define BUDGIE_STYLE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePageClass))
#define BUDGIE_IS_STYLE_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_STYLE_PAGE))
#define BUDGIE_IS_STYLE_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_STYLE_PAGE))
#define BUDGIE_STYLE_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_STYLE_PAGE, BudgieStylePageClass))

typedef struct _BudgieStylePage BudgieStylePage;
typedef struct _BudgieStylePageClass BudgieStylePageClass;
typedef struct _BudgieStylePagePrivate BudgieStylePagePrivate;

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;

#define TYPE_THEME_SCANNER (theme_scanner_get_type ())
#define THEME_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SCANNER, ThemeScanner))
#define THEME_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SCANNER, ThemeScannerClass))
#define IS_THEME_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SCANNER))
#define IS_THEME_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SCANNER))
#define THEME_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SCANNER, ThemeScannerClass))

typedef struct _ThemeScanner ThemeScanner;
typedef struct _ThemeScannerClass ThemeScannerClass;
enum  {
	BUDGIE_STYLE_PAGE_0_PROPERTY,
	BUDGIE_STYLE_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_style_page_properties[BUDGIE_STYLE_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieStylePage {
	BudgieSettingsPage parent_instance;
	BudgieStylePagePrivate * priv;
};

struct _BudgieStylePageClass {
	BudgieSettingsPageClass parent_class;
};

struct _BudgieStylePagePrivate {
	GtkComboBox* combobox_gtk;
	GtkComboBox* combobox_icon;
	GtkComboBox* combobox_cursor;
	GtkComboBox* combobox_notification_position;
	GtkSwitch* switch_dark;
	GtkSwitch* switch_builtin;
	GtkSwitch* switch_animations;
	GSettings* ui_settings;
	GSettings* budgie_settings;
	BudgieSettingsRow* builtin_row;
	ThemeScanner* theme_scanner;
};

static gint BudgieStylePage_private_offset;
static gpointer budgie_style_page_parent_class = NULL;

VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_style_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieStylePage, g_object_unref)
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN GType theme_scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeScanner, g_object_unref)
VALA_EXTERN BudgieStylePage* budgie_style_page_new (void);
VALA_EXTERN BudgieStylePage* budgie_style_page_construct (GType object_type);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
VALA_EXTERN gchar* budgie_style_page_notification_position_to_display (BudgieStylePage* self,
                                                           BudgieNotificationPosition position);
VALA_EXTERN ThemeScanner* theme_scanner_new (void);
VALA_EXTERN ThemeScanner* theme_scanner_construct (GType object_type);
static gboolean __lambda13_ (BudgieStylePage* self);
VALA_EXTERN void budgie_style_page_load_themes (BudgieStylePage* self);
static gboolean ___lambda13__gsource_func (gpointer self);
VALA_EXTERN void theme_scanner_scan_themes (ThemeScanner* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void theme_scanner_scan_themes_finish (ThemeScanner* self,
                                       GAsyncResult* _res_);
static void __lambda14_ (BudgieStylePage* self);
VALA_EXTERN gchar** theme_scanner_get_gtk_themes (ThemeScanner* self,
                                      gint* result_length1);
VALA_EXTERN gchar** theme_scanner_get_icon_themes (ThemeScanner* self,
                                       gint* result_length1);
VALA_EXTERN gchar** theme_scanner_get_cursor_themes (ThemeScanner* self,
                                         gint* result_length1);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void budgie_style_page_finalize (GObject * obj);
static GType budgie_style_page_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
budgie_style_page_get_instance_private (BudgieStylePage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieStylePage_private_offset);
}

static gboolean
__lambda13_ (BudgieStylePage* self)
{
	gboolean result;
	budgie_style_page_load_themes (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((BudgieStylePage*) self);
	return result;
}

BudgieStylePage*
budgie_style_page_construct (GType object_type)
{
	BudgieStylePage * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSizeGroup* group = NULL;
	GtkSizeGroup* _tmp2_;
	BudgieSettingsGrid* grid = NULL;
	BudgieSettingsGrid* _tmp3_;
	BudgieSettingsGrid* _tmp4_;
	GtkComboBox* _tmp5_;
	BudgieSettingsGrid* _tmp6_;
	GtkComboBox* _tmp7_;
	BudgieSettingsRow* _tmp8_;
	BudgieSettingsRow* _tmp9_;
	GtkComboBox* _tmp10_;
	BudgieSettingsGrid* _tmp11_;
	GtkComboBox* _tmp12_;
	BudgieSettingsRow* _tmp13_;
	BudgieSettingsRow* _tmp14_;
	GtkComboBox* _tmp15_;
	BudgieSettingsGrid* _tmp16_;
	GtkComboBox* _tmp17_;
	BudgieSettingsRow* _tmp18_;
	BudgieSettingsRow* _tmp19_;
	GtkComboBox* _tmp20_;
	BudgieSettingsGrid* _tmp21_;
	GtkComboBox* _tmp22_;
	BudgieSettingsRow* _tmp23_;
	BudgieSettingsRow* _tmp24_;
	GtkSizeGroup* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkSizeGroup* _tmp27_;
	GtkComboBox* _tmp28_;
	GtkSizeGroup* _tmp29_;
	GtkComboBox* _tmp30_;
	GtkSizeGroup* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkSwitch* _tmp33_;
	BudgieSettingsGrid* _tmp34_;
	GtkSwitch* _tmp35_;
	BudgieSettingsRow* _tmp36_;
	BudgieSettingsRow* _tmp37_;
	gboolean show_builtin = FALSE;
	GSettings* _tmp38_;
	GtkSwitch* _tmp44_;
	BudgieSettingsGrid* _tmp45_;
	GtkSwitch* _tmp46_;
	BudgieSettingsRow* _tmp47_;
	BudgieSettingsRow* _tmp48_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp49_;
	GtkTreeIter iter = {0};
	static const BudgieNotificationPosition positions[4] = {BUDGIE_NOTIFICATION_POSITION_TOP_LEFT, BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT, BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT, BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT};
	GtkComboBox* _tmp57_;
	GtkListStore* _tmp58_;
	GtkComboBox* _tmp59_;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp60_;
	GtkCellRendererText* _tmp61_;
	GtkCellRendererText* _tmp62_;
	GtkComboBox* _tmp63_;
	GtkCellRendererText* _tmp64_;
	GtkComboBox* _tmp65_;
	GtkCellRendererText* _tmp66_;
	GtkComboBox* _tmp67_;
	GtkCellRendererText* _tmp68_;
	GtkComboBox* _tmp69_;
	GtkCellRendererText* _tmp70_;
	GtkComboBox* _tmp71_;
	GtkCellRendererText* _tmp72_;
	GtkComboBox* _tmp73_;
	GtkCellRendererText* _tmp74_;
	GtkComboBox* _tmp75_;
	GtkCellRendererText* _tmp76_;
	GtkComboBox* _tmp77_;
	GtkCellRendererText* _tmp78_;
	GSettings* _tmp79_;
	GtkSwitch* _tmp80_;
	GSettings* _tmp83_;
	GtkComboBox* _tmp84_;
	GSettings* _tmp85_;
	GtkSwitch* _tmp86_;
	ThemeScanner* _tmp87_;
	self = (BudgieStylePage*) g_object_new (object_type, "group", BUDGIE_SETTINGS_GROUP_APPEARANCE, "content-id", "style", "title", _ ("Style"), "display-weight", 0, "icon-name", "preferences-desktop-theme", NULL);
	_tmp0_ = g_settings_new ("com.solus-project.budgie-panel");
	_g_object_unref0 (self->priv->budgie_settings);
	self->priv->budgie_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp1_;
	_tmp2_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	group = _tmp2_;
	_tmp3_ = budgie_settings_grid_new ();
	g_object_ref_sink (_tmp3_);
	grid = _tmp3_;
	_tmp4_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->combobox_gtk);
	self->priv->combobox_gtk = _tmp5_;
	_tmp6_ = grid;
	_tmp7_ = self->priv->combobox_gtk;
	_tmp8_ = budgie_settings_row_new ((GtkWidget*) _tmp7_, _ ("Widgets"), _ ("Set the appearance of window decorations and controls"));
	_tmp9_ = _tmp8_;
	budgie_settings_grid_add_row (_tmp6_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->combobox_icon);
	self->priv->combobox_icon = _tmp10_;
	_tmp11_ = grid;
	_tmp12_ = self->priv->combobox_icon;
	_tmp13_ = budgie_settings_row_new ((GtkWidget*) _tmp12_, _ ("Icons"), _ ("Set the globally used icon theme"));
	_tmp14_ = _tmp13_;
	budgie_settings_grid_add_row (_tmp11_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->combobox_cursor);
	self->priv->combobox_cursor = _tmp15_;
	_tmp16_ = grid;
	_tmp17_ = self->priv->combobox_cursor;
	_tmp18_ = budgie_settings_row_new ((GtkWidget*) _tmp17_, _ ("Cursors"), _ ("Set the globally used mouse cursor theme"));
	_tmp19_ = _tmp18_;
	budgie_settings_grid_add_row (_tmp16_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->combobox_notification_position);
	self->priv->combobox_notification_position = _tmp20_;
	_tmp21_ = grid;
	_tmp22_ = self->priv->combobox_notification_position;
	_tmp23_ = budgie_settings_row_new ((GtkWidget*) _tmp22_, _ ("Notification Position"), _ ("Set the location for notification popups"));
	_tmp24_ = _tmp23_;
	budgie_settings_grid_add_row (_tmp21_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = group;
	_tmp26_ = self->priv->combobox_gtk;
	gtk_size_group_add_widget (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = group;
	_tmp28_ = self->priv->combobox_icon;
	gtk_size_group_add_widget (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = group;
	_tmp30_ = self->priv->combobox_cursor;
	gtk_size_group_add_widget (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = group;
	_tmp32_ = self->priv->combobox_notification_position;
	gtk_size_group_add_widget (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->switch_dark);
	self->priv->switch_dark = _tmp33_;
	_tmp34_ = grid;
	_tmp35_ = self->priv->switch_dark;
	_tmp36_ = budgie_settings_row_new ((GtkWidget*) _tmp35_, _ ("Dark theme"), NULL);
	_tmp37_ = _tmp36_;
	budgie_settings_grid_add_row (_tmp34_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = self->priv->budgie_settings;
	show_builtin = g_settings_get_boolean (_tmp38_, "show-builtin-theme-option");
	if (show_builtin) {
		GtkSwitch* _tmp39_;
		GtkSwitch* _tmp40_;
		BudgieSettingsRow* _tmp41_;
		BudgieSettingsGrid* _tmp42_;
		BudgieSettingsRow* _tmp43_;
		_tmp39_ = (GtkSwitch*) gtk_switch_new ();
		g_object_ref_sink (_tmp39_);
		_g_object_unref0 (self->priv->switch_builtin);
		self->priv->switch_builtin = _tmp39_;
		_tmp40_ = self->priv->switch_builtin;
		_tmp41_ = budgie_settings_row_new ((GtkWidget*) _tmp40_, _ ("Built-in theme"), _ ("When enabled, the built-in theme will override the desktop component s" \
"tyling"));
		_g_object_unref0 (self->priv->builtin_row);
		self->priv->builtin_row = _tmp41_;
		_tmp42_ = grid;
		_tmp43_ = self->priv->builtin_row;
		budgie_settings_grid_add_row (_tmp42_, _tmp43_);
	}
	_tmp44_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->switch_animations);
	self->priv->switch_animations = _tmp44_;
	_tmp45_ = grid;
	_tmp46_ = self->priv->switch_animations;
	_tmp47_ = budgie_settings_row_new ((GtkWidget*) _tmp46_, _ ("Animations"), _ ("Control whether windows and controls use animations"));
	_tmp48_ = _tmp47_;
	budgie_settings_grid_add_row (_tmp45_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, BUDGIE_TYPE_NOTIFICATION_POSITION, -1);
	model = _tmp49_;
	{
		BudgieNotificationPosition* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
		pos_collection = positions;
		pos_collection_length1 = G_N_ELEMENTS (positions);
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
			BudgieNotificationPosition pos = 0;
			pos = pos_collection[pos_it];
			{
				GtkListStore* _tmp50_;
				GtkTreeIter _tmp51_ = {0};
				GtkListStore* _tmp52_;
				GtkTreeIter _tmp53_;
				GEnumValue* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp50_ = model;
				gtk_list_store_append (_tmp50_, &_tmp51_);
				iter = _tmp51_;
				_tmp52_ = model;
				_tmp53_ = iter;
				_tmp54_ = g_enum_get_value (g_type_class_ref (BUDGIE_TYPE_NOTIFICATION_POSITION), pos);
				_tmp55_ = budgie_style_page_notification_position_to_display (self, pos);
				_tmp56_ = _tmp55_;
				gtk_list_store_set (_tmp52_, &_tmp53_, 0, (_tmp54_ != NULL) ? _tmp54_->value_name : NULL, 1, _tmp56_, 2, pos, -1, -1);
				_g_free0 (_tmp56_);
			}
		}
	}
	_tmp57_ = self->priv->combobox_notification_position;
	_tmp58_ = model;
	gtk_combo_box_set_model (_tmp57_, (GtkTreeModel*) _tmp58_);
	_tmp59_ = self->priv->combobox_notification_position;
	gtk_combo_box_set_id_column (_tmp59_, 0);
	_tmp60_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp60_);
	render = _tmp60_;
	_tmp61_ = render;
	g_object_set (_tmp61_, "width-chars", 1, NULL);
	_tmp62_ = render;
	g_object_set (_tmp62_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp63_ = self->priv->combobox_gtk;
	_tmp64_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp63_, (GtkCellRenderer*) _tmp64_, TRUE);
	_tmp65_ = self->priv->combobox_gtk;
	_tmp66_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp65_, (GtkCellRenderer*) _tmp66_, "text", 0);
	_tmp67_ = self->priv->combobox_icon;
	_tmp68_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp67_, (GtkCellRenderer*) _tmp68_, TRUE);
	_tmp69_ = self->priv->combobox_icon;
	_tmp70_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp69_, (GtkCellRenderer*) _tmp70_, "text", 0);
	_tmp71_ = self->priv->combobox_cursor;
	_tmp72_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp71_, (GtkCellRenderer*) _tmp72_, TRUE);
	_tmp73_ = self->priv->combobox_cursor;
	_tmp74_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp73_, (GtkCellRenderer*) _tmp74_, "text", 0);
	_tmp75_ = self->priv->combobox_notification_position;
	_tmp76_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp75_, (GtkCellRenderer*) _tmp76_, TRUE);
	_tmp77_ = self->priv->combobox_notification_position;
	_tmp78_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp77_, (GtkCellRenderer*) _tmp78_, "text", 1);
	_tmp79_ = self->priv->budgie_settings;
	_tmp80_ = self->priv->switch_dark;
	g_settings_bind (_tmp79_, "dark-theme", (GObject*) _tmp80_, "active", G_SETTINGS_BIND_DEFAULT);
	if (show_builtin) {
		GSettings* _tmp81_;
		GtkSwitch* _tmp82_;
		_tmp81_ = self->priv->budgie_settings;
		_tmp82_ = self->priv->switch_builtin;
		g_settings_bind (_tmp81_, "builtin-theme", (GObject*) _tmp82_, "active", G_SETTINGS_BIND_DEFAULT);
	}
	_tmp83_ = self->priv->budgie_settings;
	_tmp84_ = self->priv->combobox_notification_position;
	g_settings_bind (_tmp83_, "notification-position", (GObject*) _tmp84_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_tmp85_ = self->priv->ui_settings;
	_tmp86_ = self->priv->switch_animations;
	g_settings_bind (_tmp85_, "enable-animations", (GObject*) _tmp86_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp87_ = theme_scanner_new ();
	_g_object_unref0 (self->priv->theme_scanner);
	self->priv->theme_scanner = _tmp87_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (render);
	_g_object_unref0 (model);
	_g_object_unref0 (grid);
	_g_object_unref0 (group);
	return self;
}

BudgieStylePage*
budgie_style_page_new (void)
{
	return budgie_style_page_construct (BUDGIE_TYPE_STYLE_PAGE);
}

static void
__lambda14_ (BudgieStylePage* self)
{
	{
		GtkTreeIter iter = {0};
		GtkListStore* model = NULL;
		GtkListStore* _tmp0_;
		gboolean hit = FALSE;
		ThemeScanner* _tmp1_;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		GtkComboBox* _tmp10_;
		GtkListStore* _tmp11_;
		GtkComboBox* _tmp12_;
		GtkListStore* _tmp13_;
		_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		model = _tmp0_;
		hit = FALSE;
		_tmp1_ = self->priv->theme_scanner;
		_tmp3_ = theme_scanner_get_gtk_themes (_tmp1_, &_tmp2_);
		{
			gchar** theme_collection = NULL;
			gint theme_collection_length1 = 0;
			gint _theme_collection_size_ = 0;
			gint theme_it = 0;
			theme_collection = _tmp3_;
			theme_collection_length1 = _tmp2_;
			for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
				gchar* _tmp4_;
				gchar* theme = NULL;
				_tmp4_ = g_strdup (theme_collection[theme_it]);
				theme = _tmp4_;
				{
					GtkListStore* _tmp5_;
					GtkTreeIter _tmp6_ = {0};
					GtkListStore* _tmp7_;
					GtkTreeIter _tmp8_;
					const gchar* _tmp9_;
					_tmp5_ = model;
					gtk_list_store_append (_tmp5_, &_tmp6_);
					iter = _tmp6_;
					_tmp7_ = model;
					_tmp8_ = iter;
					_tmp9_ = theme;
					gtk_list_store_set (_tmp7_, &_tmp8_, 0, _tmp9_, -1, -1);
					hit = TRUE;
					_g_free0 (theme);
				}
			}
			theme_collection = (_vala_array_free (theme_collection, theme_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp10_ = self->priv->combobox_gtk;
		_tmp11_ = model;
		gtk_combo_box_set_model (_tmp10_, (GtkTreeModel*) _tmp11_);
		_tmp12_ = self->priv->combobox_gtk;
		gtk_combo_box_set_id_column (_tmp12_, 0);
		_tmp13_ = model;
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp13_, 0, GTK_SORT_ASCENDING);
		if (hit) {
			GtkComboBox* _tmp14_;
			GSettings* _tmp15_;
			GtkComboBox* _tmp16_;
			GtkComboBox* _tmp17_;
			GSettings* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = self->priv->combobox_gtk;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
			_tmp15_ = self->priv->ui_settings;
			_tmp16_ = self->priv->combobox_gtk;
			g_settings_bind (_tmp15_, "gtk-theme", (GObject*) _tmp16_, "active-id", G_SETTINGS_BIND_DEFAULT);
			_tmp17_ = self->priv->combobox_gtk;
			_tmp18_ = self->priv->ui_settings;
			_tmp19_ = g_settings_get_string (_tmp18_, "gtk-theme");
			_tmp20_ = _tmp19_;
			gtk_combo_box_set_active_id (_tmp17_, _tmp20_);
			_g_free0 (_tmp20_);
		}
		_g_object_unref0 (model);
	}
	{
		GtkTreeIter iter = {0};
		GtkListStore* model = NULL;
		GtkListStore* _tmp21_;
		gboolean hit = FALSE;
		ThemeScanner* _tmp22_;
		gint _tmp23_ = 0;
		gchar** _tmp24_;
		GtkComboBox* _tmp31_;
		GtkListStore* _tmp32_;
		GtkComboBox* _tmp33_;
		GtkListStore* _tmp34_;
		_tmp21_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		model = _tmp21_;
		hit = FALSE;
		_tmp22_ = self->priv->theme_scanner;
		_tmp24_ = theme_scanner_get_icon_themes (_tmp22_, &_tmp23_);
		{
			gchar** theme_collection = NULL;
			gint theme_collection_length1 = 0;
			gint _theme_collection_size_ = 0;
			gint theme_it = 0;
			theme_collection = _tmp24_;
			theme_collection_length1 = _tmp23_;
			for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
				gchar* _tmp25_;
				gchar* theme = NULL;
				_tmp25_ = g_strdup (theme_collection[theme_it]);
				theme = _tmp25_;
				{
					GtkListStore* _tmp26_;
					GtkTreeIter _tmp27_ = {0};
					GtkListStore* _tmp28_;
					GtkTreeIter _tmp29_;
					const gchar* _tmp30_;
					_tmp26_ = model;
					gtk_list_store_append (_tmp26_, &_tmp27_);
					iter = _tmp27_;
					_tmp28_ = model;
					_tmp29_ = iter;
					_tmp30_ = theme;
					gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, -1, -1);
					hit = TRUE;
					_g_free0 (theme);
				}
			}
			theme_collection = (_vala_array_free (theme_collection, theme_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp31_ = self->priv->combobox_icon;
		_tmp32_ = model;
		gtk_combo_box_set_model (_tmp31_, (GtkTreeModel*) _tmp32_);
		_tmp33_ = self->priv->combobox_icon;
		gtk_combo_box_set_id_column (_tmp33_, 0);
		_tmp34_ = model;
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp34_, 0, GTK_SORT_ASCENDING);
		if (hit) {
			GtkComboBox* _tmp35_;
			GSettings* _tmp36_;
			GtkComboBox* _tmp37_;
			GtkComboBox* _tmp38_;
			GSettings* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp35_ = self->priv->combobox_icon;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, TRUE);
			_tmp36_ = self->priv->ui_settings;
			_tmp37_ = self->priv->combobox_icon;
			g_settings_bind (_tmp36_, "icon-theme", (GObject*) _tmp37_, "active-id", G_SETTINGS_BIND_DEFAULT);
			_tmp38_ = self->priv->combobox_icon;
			_tmp39_ = self->priv->ui_settings;
			_tmp40_ = g_settings_get_string (_tmp39_, "icon-theme");
			_tmp41_ = _tmp40_;
			gtk_combo_box_set_active_id (_tmp38_, _tmp41_);
			_g_free0 (_tmp41_);
		}
		_g_object_unref0 (model);
	}
	{
		GtkTreeIter iter = {0};
		GtkListStore* model = NULL;
		GtkListStore* _tmp42_;
		gboolean hit = FALSE;
		ThemeScanner* _tmp43_;
		gint _tmp44_ = 0;
		gchar** _tmp45_;
		GtkComboBox* _tmp52_;
		GtkListStore* _tmp53_;
		GtkComboBox* _tmp54_;
		GtkListStore* _tmp55_;
		_tmp42_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		model = _tmp42_;
		hit = FALSE;
		_tmp43_ = self->priv->theme_scanner;
		_tmp45_ = theme_scanner_get_cursor_themes (_tmp43_, &_tmp44_);
		{
			gchar** theme_collection = NULL;
			gint theme_collection_length1 = 0;
			gint _theme_collection_size_ = 0;
			gint theme_it = 0;
			theme_collection = _tmp45_;
			theme_collection_length1 = _tmp44_;
			for (theme_it = 0; theme_it < theme_collection_length1; theme_it = theme_it + 1) {
				gchar* _tmp46_;
				gchar* theme = NULL;
				_tmp46_ = g_strdup (theme_collection[theme_it]);
				theme = _tmp46_;
				{
					GtkListStore* _tmp47_;
					GtkTreeIter _tmp48_ = {0};
					GtkListStore* _tmp49_;
					GtkTreeIter _tmp50_;
					const gchar* _tmp51_;
					_tmp47_ = model;
					gtk_list_store_append (_tmp47_, &_tmp48_);
					iter = _tmp48_;
					_tmp49_ = model;
					_tmp50_ = iter;
					_tmp51_ = theme;
					gtk_list_store_set (_tmp49_, &_tmp50_, 0, _tmp51_, -1, -1);
					hit = TRUE;
					_g_free0 (theme);
				}
			}
			theme_collection = (_vala_array_free (theme_collection, theme_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp52_ = self->priv->combobox_cursor;
		_tmp53_ = model;
		gtk_combo_box_set_model (_tmp52_, (GtkTreeModel*) _tmp53_);
		_tmp54_ = self->priv->combobox_cursor;
		gtk_combo_box_set_id_column (_tmp54_, 0);
		_tmp55_ = model;
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp55_, 0, GTK_SORT_ASCENDING);
		if (hit) {
			GtkComboBox* _tmp56_;
			GSettings* _tmp57_;
			GtkComboBox* _tmp58_;
			GtkComboBox* _tmp59_;
			GSettings* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp56_ = self->priv->combobox_cursor;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, TRUE);
			_tmp57_ = self->priv->ui_settings;
			_tmp58_ = self->priv->combobox_cursor;
			g_settings_bind (_tmp57_, "cursor-theme", (GObject*) _tmp58_, "active-id", G_SETTINGS_BIND_DEFAULT);
			_tmp59_ = self->priv->combobox_cursor;
			_tmp60_ = self->priv->ui_settings;
			_tmp61_ = g_settings_get_string (_tmp60_, "cursor-theme");
			_tmp62_ = _tmp61_;
			gtk_combo_box_set_active_id (_tmp59_, _tmp62_);
			_g_free0 (_tmp62_);
		}
		_g_object_unref0 (model);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda14_ ((BudgieStylePage*) self);
	g_object_unref (self);
}

void
budgie_style_page_load_themes (BudgieStylePage* self)
{
	ThemeScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->theme_scanner;
	theme_scanner_scan_themes (_tmp0_, ___lambda14__gasync_ready_callback, g_object_ref (self));
}

/**
* Get a user-friendly name for each position.
*/
gchar*
budgie_style_page_notification_position_to_display (BudgieStylePage* self,
                                                    BudgieNotificationPosition position)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (position) {
		case BUDGIE_NOTIFICATION_POSITION_TOP_LEFT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Top Left"));
			result = _tmp0_;
			return result;
		}
		case BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Bottom Left"));
			result = _tmp1_;
			return result;
		}
		case BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Bottom Right"));
			result = _tmp2_;
			return result;
		}
		default:
		case BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Top Right"));
			result = _tmp3_;
			return result;
		}
	}
}

static void
budgie_style_page_class_init (BudgieStylePageClass * klass,
                              gpointer klass_data)
{
	budgie_style_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieStylePage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_style_page_finalize;
}

static void
budgie_style_page_instance_init (BudgieStylePage * self,
                                 gpointer klass)
{
	self->priv = budgie_style_page_get_instance_private (self);
}

static void
budgie_style_page_finalize (GObject * obj)
{
	BudgieStylePage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_STYLE_PAGE, BudgieStylePage);
	_g_object_unref0 (self->priv->combobox_gtk);
	_g_object_unref0 (self->priv->combobox_icon);
	_g_object_unref0 (self->priv->combobox_cursor);
	_g_object_unref0 (self->priv->combobox_notification_position);
	_g_object_unref0 (self->priv->switch_dark);
	_g_object_unref0 (self->priv->switch_builtin);
	_g_object_unref0 (self->priv->switch_animations);
	_g_object_unref0 (self->priv->ui_settings);
	_g_object_unref0 (self->priv->budgie_settings);
	_g_object_unref0 (self->priv->builtin_row);
	_g_object_unref0 (self->priv->theme_scanner);
	G_OBJECT_CLASS (budgie_style_page_parent_class)->finalize (obj);
}

/**
* StylePage simply provides a bunch of theme controls
*/
static GType
budgie_style_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieStylePageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_style_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieStylePage), 0, (GInstanceInitFunc) budgie_style_page_instance_init, NULL };
	GType budgie_style_page_type_id;
	budgie_style_page_type_id = g_type_register_static (BUDGIE_TYPE_SETTINGS_PAGE, "BudgieStylePage", &g_define_type_info, 0);
	BudgieStylePage_private_offset = g_type_add_instance_private (budgie_style_page_type_id, sizeof (BudgieStylePagePrivate));
	return budgie_style_page_type_id;
}

GType
budgie_style_page_get_type (void)
{
	static volatile gsize budgie_style_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_style_page_type_id__once)) {
		GType budgie_style_page_type_id;
		budgie_style_page_type_id = budgie_style_page_get_type_once ();
		g_once_init_leave (&budgie_style_page_type_id__once, budgie_style_page_type_id);
	}
	return budgie_style_page_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

