/* settings_panel.c generated by valac 0.56.14, the Vala compiler
 * generated from settings_panel.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "budgie-private.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "plugin.h"
#include <float.h>
#include <math.h>

#define BUDGIE_SETTINGS_GROUP_PANEL "panel"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_TRASH_BUTTON (budgie_trash_button_get_type ())
#define BUDGIE_TRASH_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TRASH_BUTTON, BudgieTrashButton))
#define BUDGIE_TRASH_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TRASH_BUTTON, BudgieTrashButtonClass))
#define BUDGIE_IS_TRASH_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TRASH_BUTTON))
#define BUDGIE_IS_TRASH_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TRASH_BUTTON))
#define BUDGIE_TRASH_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TRASH_BUTTON, BudgieTrashButtonClass))

typedef struct _BudgieTrashButton BudgieTrashButton;
typedef struct _BudgieTrashButtonClass BudgieTrashButtonClass;
typedef struct _BudgieTrashButtonPrivate BudgieTrashButtonPrivate;
enum  {
	BUDGIE_TRASH_BUTTON_0_PROPERTY,
	BUDGIE_TRASH_BUTTON_NUM_PROPERTIES
};
static GParamSpec* budgie_trash_button_properties[BUDGIE_TRASH_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;

#define BUDGIE_TYPE_PANEL_PAGE (budgie_panel_page_get_type ())
#define BUDGIE_PANEL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPage))
#define BUDGIE_PANEL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPageClass))
#define BUDGIE_IS_PANEL_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_PAGE))
#define BUDGIE_IS_PANEL_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_PAGE))
#define BUDGIE_PANEL_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPageClass))

typedef struct _BudgiePanelPage BudgiePanelPage;
typedef struct _BudgiePanelPageClass BudgiePanelPageClass;
typedef struct _BudgiePanelPagePrivate BudgiePanelPagePrivate;
enum  {
	BUDGIE_PANEL_PAGE_0_PROPERTY,
	BUDGIE_PANEL_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_panel_page_properties[BUDGIE_PANEL_PAGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;

#define BUDGIE_TYPE_APPLETS_PAGE (budgie_applets_page_get_type ())
#define BUDGIE_APPLETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPage))
#define BUDGIE_APPLETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPageClass))
#define BUDGIE_IS_APPLETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLETS_PAGE))
#define BUDGIE_IS_APPLETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLETS_PAGE))
#define BUDGIE_APPLETS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPageClass))

typedef struct _BudgieAppletsPage BudgieAppletsPage;
typedef struct _BudgieAppletsPageClass BudgieAppletsPageClass;

#define BUDGIE_TYPE_REMOVE_PANEL_DIALOG (budgie_remove_panel_dialog_get_type ())
#define BUDGIE_REMOVE_PANEL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_REMOVE_PANEL_DIALOG, BudgieRemovePanelDialog))
#define BUDGIE_REMOVE_PANEL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_REMOVE_PANEL_DIALOG, BudgieRemovePanelDialogClass))
#define BUDGIE_IS_REMOVE_PANEL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_REMOVE_PANEL_DIALOG))
#define BUDGIE_IS_REMOVE_PANEL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_REMOVE_PANEL_DIALOG))
#define BUDGIE_REMOVE_PANEL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_REMOVE_PANEL_DIALOG, BudgieRemovePanelDialogClass))

typedef struct _BudgieRemovePanelDialog BudgieRemovePanelDialog;
typedef struct _BudgieRemovePanelDialogClass BudgieRemovePanelDialogClass;

struct _BudgieTrashButton {
	GtkButton parent_instance;
	BudgieTrashButtonPrivate * priv;
};

struct _BudgieTrashButtonClass {
	GtkButtonClass parent_class;
};

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgiePanelPage {
	BudgieSettingsPage parent_instance;
	BudgiePanelPagePrivate * priv;
};

struct _BudgiePanelPageClass {
	BudgieSettingsPageClass parent_class;
};

struct _BudgiePanelPagePrivate {
	BudgieToplevel* toplevel;
	GtkStack* stack;
	GtkStackSwitcher* switcher;
	GtkComboBox* combobox_position;
	gulong position_id;
	GtkComboBox* combobox_autohide;
	gulong autohide_id;
	GtkComboBox* combobox_transparency;
	gulong transparency_id;
	GtkSwitch* switch_shadow;
	gulong shadow_id;
	GtkSwitch* switch_regions;
	gulong region_id;
	GtkSwitch* switch_dock;
	gulong dock_id;
	GtkSpinButton* spinbutton_size;
	gulong size_id;
	GtkSpinButton* spinbutton_spacing;
	gulong spacing_id;
	GtkButton* button_remove_panel;
	BudgieDesktopManager* manager;
};

static gpointer budgie_trash_button_parent_class = NULL;
static gint BudgiePanelPage_private_offset;
static gpointer budgie_panel_page_parent_class = NULL;

VALA_EXTERN GType budgie_trash_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTrashButton, g_object_unref)
VALA_EXTERN BudgieTrashButton* budgie_trash_button_new (void);
VALA_EXTERN BudgieTrashButton* budgie_trash_button_construct (GType object_type);
static GType budgie_trash_button_get_type_once (void);
VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_panel_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelPage, g_object_unref)
VALA_EXTERN BudgiePanelPage* budgie_panel_page_new (BudgieDesktopManager* manager,
                                        BudgieToplevel* toplevel);
VALA_EXTERN BudgiePanelPage* budgie_panel_page_construct (GType object_type,
                                              BudgieDesktopManager* manager,
                                              BudgieToplevel* toplevel);
static gchar* budgie_panel_page_get_panel_name (BudgieToplevel* panel);
static gint budgie_panel_page_get_panel_weight (BudgieToplevel* toplevel);
static GtkWidget* budgie_panel_page_applets_page (BudgiePanelPage* self);
static GtkWidget* budgie_panel_page_settings_page (BudgiePanelPage* self);
static void budgie_panel_page_delete_panel (BudgiePanelPage* self);
static void _budgie_panel_page_delete_panel_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
static void budgie_panel_page_on_panels_changed (BudgiePanelPage* self);
static void _budgie_panel_page_on_panels_changed_budgie_desktop_manager_panels_changed (BudgieDesktopManager* _sender,
                                                                                 gpointer self);
VALA_EXTERN void budgie_settings_page_set_display_weight (BudgieSettingsPage* self,
                                              gint value);
static gchar* budgie_panel_page_pos_to_display (BudgiePanelPosition position);
static gchar* budgie_panel_page_transparency_to_display (BudgiePanelTransparency transp);
static gchar* budgie_panel_page_policy_to_display (BudgieAutohidePolicy policy);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
static void budgie_panel_page_set_position (BudgiePanelPage* self);
static void _budgie_panel_page_set_position_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self);
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
static void budgie_panel_page_set_size (BudgiePanelPage* self);
static void _budgie_panel_page_set_size_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                gpointer self);
static void budgie_panel_page_set_applet_spacing (BudgiePanelPage* self);
static void _budgie_panel_page_set_applet_spacing_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                          gpointer self);
static void budgie_panel_page_set_autohide (BudgiePanelPage* self);
static void _budgie_panel_page_set_autohide_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self);
static void budgie_panel_page_set_transparency (BudgiePanelPage* self);
static void _budgie_panel_page_set_transparency_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self);
static void budgie_panel_page_set_shadow (BudgiePanelPage* self);
static void _budgie_panel_page_set_shadow_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void budgie_panel_page_set_region (BudgiePanelPage* self);
static void _budgie_panel_page_set_region_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void budgie_panel_page_set_dock (BudgiePanelPage* self);
static void _budgie_panel_page_set_dock_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void budgie_panel_page_update_from_property (BudgiePanelPage* self,
                                             const gchar* property);
static void budgie_panel_page_panel_notify (BudgiePanelPage* self,
                                     GObject* o,
                                     GParamSpec* ps);
static void _budgie_panel_page_panel_notify_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
VALA_EXTERN BudgieAppletsPage* budgie_applets_page_new (BudgieDesktopManager* manager,
                                            BudgieToplevel* toplevel);
VALA_EXTERN BudgieAppletsPage* budgie_applets_page_construct (GType object_type,
                                                  BudgieDesktopManager* manager,
                                                  BudgieToplevel* toplevel);
VALA_EXTERN GType budgie_applets_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletsPage, g_object_unref)
VALA_EXTERN void budgie_settings_page_set_title (BudgieSettingsPage* self,
                                     const gchar* value);
VALA_EXTERN GType budgie_remove_panel_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRemovePanelDialog, g_object_unref)
VALA_EXTERN BudgieRemovePanelDialog* budgie_remove_panel_dialog_new (GtkWindow* parent);
VALA_EXTERN BudgieRemovePanelDialog* budgie_remove_panel_dialog_construct (GType object_type,
                                                               GtkWindow* parent);
VALA_EXTERN gboolean budgie_remove_panel_dialog_run (BudgieRemovePanelDialog* self);
static void budgie_panel_page_finalize (GObject * obj);
static GType budgie_panel_page_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieTrashButton*
budgie_trash_button_construct (GType object_type)
{
	BudgieTrashButton * self = NULL;
	GtkImage* img = NULL;
	GtkImage* _tmp0_;
	GtkStyleContext* st = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	self = (BudgieTrashButton*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	img = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) img);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	st = _tmp2_;
	gtk_style_context_add_class (st, "image-button");
	gtk_style_context_add_class (st, GTK_STYLE_CLASS_FLAT);
	gtk_style_context_add_class (st, "budgie-trash-button");
	_g_object_unref0 (st);
	_g_object_unref0 (img);
	return self;
}

BudgieTrashButton*
budgie_trash_button_new (void)
{
	return budgie_trash_button_construct (BUDGIE_TYPE_TRASH_BUTTON);
}

static void
budgie_trash_button_class_init (BudgieTrashButtonClass * klass,
                                gpointer klass_data)
{
	budgie_trash_button_parent_class = g_type_class_peek_parent (klass);
}

static void
budgie_trash_button_instance_init (BudgieTrashButton * self,
                                   gpointer klass)
{
}

/**
* Simple trash button which can then be styled by the GTK theme
*/
static GType
budgie_trash_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTrashButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_trash_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTrashButton), 0, (GInstanceInitFunc) budgie_trash_button_instance_init, NULL };
	GType budgie_trash_button_type_id;
	budgie_trash_button_type_id = g_type_register_static (gtk_button_get_type (), "BudgieTrashButton", &g_define_type_info, 0);
	return budgie_trash_button_type_id;
}

GType
budgie_trash_button_get_type (void)
{
	static volatile gsize budgie_trash_button_type_id__once = 0;
	if (g_once_init_enter (&budgie_trash_button_type_id__once)) {
		GType budgie_trash_button_type_id;
		budgie_trash_button_type_id = budgie_trash_button_get_type_once ();
		g_once_init_leave (&budgie_trash_button_type_id__once, budgie_trash_button_type_id);
	}
	return budgie_trash_button_type_id__once;
}

static inline gpointer
budgie_panel_page_get_instance_private (BudgiePanelPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePanelPage_private_offset);
}

static void
_budgie_panel_page_delete_panel_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	budgie_panel_page_delete_panel ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_on_panels_changed_budgie_desktop_manager_panels_changed (BudgieDesktopManager* _sender,
                                                                            gpointer self)
{
	budgie_panel_page_on_panels_changed ((BudgiePanelPage*) self);
}

BudgiePanelPage*
budgie_panel_page_construct (GType object_type,
                             BudgieDesktopManager* manager,
                             BudgieToplevel* toplevel)
{
	BudgiePanelPage * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkBox* swbox = NULL;
	GtkBox* _tmp6_;
	GtkStackSwitcher* _tmp7_;
	GtkStackSwitcher* _tmp8_;
	GtkStack* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	GtkStack* _tmp12_;
	GtkStackSwitcher* _tmp13_;
	GtkStack* _tmp14_;
	GtkStackSwitcher* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	GtkWidget* _tmp18_;
	GtkWidget* _tmp19_;
	GtkStack* _tmp20_;
	GtkWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	_tmp0_ = budgie_toplevel_get_uuid (toplevel);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("panel-%s", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = budgie_panel_page_get_panel_name (toplevel);
	_tmp5_ = _tmp4_;
	self = (BudgiePanelPage*) g_object_new (object_type, "group", BUDGIE_SETTINGS_GROUP_PANEL, "content-id", _tmp3_, "title", _tmp5_, "display-weight", budgie_panel_page_get_panel_weight (toplevel), "icon-name", "user-desktop", NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	self->priv->manager = manager;
	self->priv->toplevel = toplevel;
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	gtk_widget_set_margin_top ((GtkWidget*) self, 8);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 8);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	swbox = _tmp6_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) swbox, FALSE, FALSE, (guint) 0);
	_tmp7_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->switcher);
	self->priv->switcher = _tmp7_;
	_tmp8_ = self->priv->switcher;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp9_;
	_tmp10_ = self->priv->stack;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 12);
	_tmp11_ = self->priv->stack;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 12);
	_tmp12_ = self->priv->stack;
	gtk_stack_set_homogeneous (_tmp12_, FALSE);
	_tmp13_ = self->priv->switcher;
	_tmp14_ = self->priv->stack;
	gtk_stack_switcher_set_stack (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->switcher;
	gtk_box_pack_start (swbox, (GtkWidget*) _tmp15_, TRUE, TRUE, (guint) 0);
	_tmp16_ = self->priv->stack;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	_tmp17_ = self->priv->stack;
	_tmp18_ = budgie_panel_page_applets_page (self);
	_tmp19_ = _tmp18_;
	gtk_stack_add_titled (_tmp17_, _tmp19_, "main", _ ("Applets"));
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->stack;
	_tmp21_ = budgie_panel_page_settings_page (self);
	_tmp22_ = _tmp21_;
	gtk_stack_add_titled (_tmp20_, _tmp22_, "applets", _ ("Settings"));
	_g_object_unref0 (_tmp22_);
	_tmp23_ = (GtkButton*) gtk_button_new_with_label (_ ("Remove Panel"));
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->button_remove_panel);
	self->priv->button_remove_panel = _tmp23_;
	_tmp24_ = self->priv->button_remove_panel;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ ("Remove this panel from the screen"));
	_tmp25_ = self->priv->button_remove_panel;
	g_signal_connect_object (_tmp25_, "clicked", (GCallback) _budgie_panel_page_delete_panel_gtk_button_clicked, self, G_CONNECT_AFTER);
	_tmp26_ = self->priv->button_remove_panel;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
	gtk_style_context_add_class (_tmp27_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp28_ = self->priv->button_remove_panel;
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_CENTER);
	_tmp29_ = self->priv->button_remove_panel;
	gtk_widget_set_valign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	_tmp30_ = self->priv->button_remove_panel;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp30_, 8);
	_tmp31_ = self->priv->button_remove_panel;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, FALSE);
	_tmp32_ = self->priv->button_remove_panel;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (manager, "panels-changed", (GCallback) _budgie_panel_page_on_panels_changed_budgie_desktop_manager_panels_changed, self, 0);
	budgie_panel_page_on_panels_changed (self);
	gtk_widget_show_all ((GtkWidget*) self);
	budgie_panel_page_on_panels_changed (self);
	_g_object_unref0 (swbox);
	return self;
}

BudgiePanelPage*
budgie_panel_page_new (BudgieDesktopManager* manager,
                       BudgieToplevel* toplevel)
{
	return budgie_panel_page_construct (BUDGIE_TYPE_PANEL_PAGE, manager, toplevel);
}

static void
budgie_panel_page_on_panels_changed (BudgiePanelPage* self)
{
	GtkButton* _tmp0_;
	BudgieDesktopManager* _tmp1_;
	BudgieToplevel* _tmp2_;
	BudgieDesktopManager* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_remove_panel;
	_tmp1_ = self->priv->manager;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, budgie_desktop_manager_slots_used (_tmp1_) > ((guint) 1));
	_tmp2_ = self->priv->toplevel;
	budgie_settings_page_set_display_weight ((BudgieSettingsPage*) self, budgie_panel_page_get_panel_weight (_tmp2_));
	_tmp3_ = self->priv->manager;
	if (budgie_desktop_manager_slots_used (_tmp3_) > ((guint) 1)) {
		GtkButton* _tmp4_;
		_tmp4_ = self->priv->button_remove_panel;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	} else {
		GtkButton* _tmp5_;
		_tmp5_ = self->priv->button_remove_panel;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
}

/**
* Determine a human readable named based on the panel's position on screen
* For brownie points we'll identify docks differently
*/
static gchar*
budgie_panel_page_get_panel_name (BudgieToplevel* panel)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* result;
	_tmp0_ = budgie_toplevel_get_dock_mode (panel);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BudgiePanelPosition _tmp2_;
		BudgiePanelPosition _tmp3_;
		_tmp2_ = budgie_toplevel_get_position (panel);
		_tmp3_ = _tmp2_;
		switch (_tmp3_) {
			case BUDGIE_PANEL_POSITION_TOP:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("Top Dock"));
				result = _tmp4_;
				return result;
			}
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("Right Dock"));
				result = _tmp5_;
				return result;
			}
			case BUDGIE_PANEL_POSITION_LEFT:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup (_ ("Left Dock"));
				result = _tmp6_;
				return result;
			}
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (_ ("Bottom Dock"));
				result = _tmp7_;
				return result;
			}
		}
	} else {
		BudgiePanelPosition _tmp8_;
		BudgiePanelPosition _tmp9_;
		_tmp8_ = budgie_toplevel_get_position (panel);
		_tmp9_ = _tmp8_;
		switch (_tmp9_) {
			case BUDGIE_PANEL_POSITION_TOP:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup (_ ("Top Panel"));
				result = _tmp10_;
				return result;
			}
			case BUDGIE_PANEL_POSITION_RIGHT:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup (_ ("Right Panel"));
				result = _tmp11_;
				return result;
			}
			case BUDGIE_PANEL_POSITION_LEFT:
			{
				gchar* _tmp12_;
				_tmp12_ = g_strdup (_ ("Left Panel"));
				result = _tmp12_;
				return result;
			}
			default:
			{
				gchar* _tmp13_;
				_tmp13_ = g_strdup (_ ("Bottom Panel"));
				result = _tmp13_;
				return result;
			}
		}
	}
}

/**
* Assign a display weight to a given panel
*/
static gint
budgie_panel_page_get_panel_weight (BudgieToplevel* toplevel)
{
	gint base_score = 0;
	BudgiePanelPosition _tmp0_;
	BudgiePanelPosition _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint result;
	base_score = 0;
	_tmp0_ = budgie_toplevel_get_position (toplevel);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			base_score = 1;
			break;
		}
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			base_score = 2;
			break;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			base_score = 3;
			break;
		}
		default:
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			base_score = 4;
			break;
		}
	}
	_tmp2_ = budgie_toplevel_get_dock_mode (toplevel);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		base_score += 10;
	}
	result = base_score;
	return result;
}

/**
* Convert a position into a usable, renderable Thing™
*/
static gchar*
budgie_panel_page_pos_to_display (BudgiePanelPosition position)
{
	gchar* result;
	switch (position) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Top"));
			result = _tmp0_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Right"));
			result = _tmp1_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Left"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Bottom"));
			result = _tmp3_;
			return result;
		}
	}
}

/**
* Get a usable display string for the transparency type
*/
static gchar*
budgie_panel_page_transparency_to_display (BudgiePanelTransparency transp)
{
	gchar* result;
	switch (transp) {
		case BUDGIE_PANEL_TRANSPARENCY_ALWAYS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Always"));
			result = _tmp0_;
			return result;
		}
		case BUDGIE_PANEL_TRANSPARENCY_DYNAMIC:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Dynamic"));
			result = _tmp1_;
			return result;
		}
		default:
		case BUDGIE_PANEL_TRANSPARENCY_NONE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("None"));
			result = _tmp2_;
			return result;
		}
	}
}

/**
* Get a usable display string for the autohide type
*/
static gchar*
budgie_panel_page_policy_to_display (BudgieAutohidePolicy policy)
{
	gchar* result;
	switch (policy) {
		case BUDGIE_AUTOHIDE_POLICY_AUTOMATIC:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Automatic"));
			result = _tmp0_;
			return result;
		}
		case BUDGIE_AUTOHIDE_POLICY_INTELLIGENT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Intelligent"));
			result = _tmp1_;
			return result;
		}
		default:
		case BUDGIE_AUTOHIDE_POLICY_NONE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Never"));
			result = _tmp2_;
			return result;
		}
	}
}

static void
_budgie_panel_page_set_position_gtk_combo_box_changed (GtkComboBox* _sender,
                                                       gpointer self)
{
	budgie_panel_page_set_position ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_size_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                           gpointer self)
{
	budgie_panel_page_set_size ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_applet_spacing_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                     gpointer self)
{
	budgie_panel_page_set_applet_spacing ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_autohide_gtk_combo_box_changed (GtkComboBox* _sender,
                                                       gpointer self)
{
	budgie_panel_page_set_autohide ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_transparency_gtk_combo_box_changed (GtkComboBox* _sender,
                                                           gpointer self)
{
	budgie_panel_page_set_transparency ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_shadow_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	budgie_panel_page_set_shadow ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_region_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	budgie_panel_page_set_region ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_set_dock_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	budgie_panel_page_set_dock ((BudgiePanelPage*) self);
}

static void
_budgie_panel_page_panel_notify_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	budgie_panel_page_panel_notify ((BudgiePanelPage*) self, _sender, pspec);
}

static GtkWidget*
budgie_panel_page_settings_page (BudgiePanelPage* self)
{
	BudgieSettingsGrid* ret = NULL;
	BudgieSettingsGrid* _tmp0_ = NULL;
	GtkSizeGroup* group = NULL;
	GtkSizeGroup* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	gulong _tmp4_;
	GtkSizeGroup* _tmp5_;
	GtkComboBox* _tmp6_;
	BudgieSettingsGrid* _tmp7_;
	GtkComboBox* _tmp8_;
	BudgieSettingsRow* _tmp9_;
	BudgieSettingsRow* _tmp10_;
	GtkSpinButton* _tmp11_;
	GtkSpinButton* _tmp12_;
	GtkSpinButton* _tmp13_;
	gulong _tmp14_;
	GtkSizeGroup* _tmp15_;
	GtkSpinButton* _tmp16_;
	BudgieSettingsGrid* _tmp17_;
	GtkSpinButton* _tmp18_;
	BudgieSettingsRow* _tmp19_;
	BudgieSettingsRow* _tmp20_;
	GtkSpinButton* _tmp21_;
	GtkSpinButton* _tmp22_;
	GtkSpinButton* _tmp23_;
	gulong _tmp24_;
	GtkSizeGroup* _tmp25_;
	GtkSpinButton* _tmp26_;
	BudgieSettingsGrid* _tmp27_;
	GtkSpinButton* _tmp28_;
	BudgieSettingsRow* _tmp29_;
	BudgieSettingsRow* _tmp30_;
	GtkComboBox* _tmp31_;
	GtkComboBox* _tmp32_;
	gulong _tmp33_;
	GtkSizeGroup* _tmp34_;
	GtkComboBox* _tmp35_;
	BudgieSettingsGrid* _tmp36_;
	GtkComboBox* _tmp37_;
	BudgieSettingsRow* _tmp38_;
	BudgieSettingsRow* _tmp39_;
	GtkComboBox* _tmp40_;
	GtkComboBox* _tmp41_;
	gulong _tmp42_;
	GtkSizeGroup* _tmp43_;
	GtkComboBox* _tmp44_;
	BudgieSettingsGrid* _tmp45_;
	GtkComboBox* _tmp46_;
	BudgieSettingsRow* _tmp47_;
	BudgieSettingsRow* _tmp48_;
	GtkSwitch* _tmp49_;
	BudgieSettingsGrid* _tmp50_;
	GtkSwitch* _tmp51_;
	BudgieSettingsRow* _tmp52_;
	BudgieSettingsRow* _tmp53_;
	GtkSwitch* _tmp54_;
	gulong _tmp55_;
	GtkSwitch* _tmp56_;
	BudgieSettingsGrid* _tmp57_;
	GtkSwitch* _tmp58_;
	BudgieSettingsRow* _tmp59_;
	BudgieSettingsRow* _tmp60_;
	GtkSwitch* _tmp61_;
	gulong _tmp62_;
	GtkSwitch* _tmp63_;
	BudgieSettingsGrid* _tmp64_;
	GtkSwitch* _tmp65_;
	BudgieSettingsRow* _tmp66_;
	BudgieSettingsRow* _tmp67_;
	GtkSwitch* _tmp68_;
	gulong _tmp69_;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp70_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp71_;
	GtkTreeIter iter = {0};
	static const BudgiePanelPosition positions[4] = {BUDGIE_PANEL_POSITION_TOP, BUDGIE_PANEL_POSITION_BOTTOM, BUDGIE_PANEL_POSITION_LEFT, BUDGIE_PANEL_POSITION_RIGHT};
	GtkComboBox* _tmp79_;
	GtkListStore* _tmp80_;
	GtkComboBox* _tmp81_;
	GtkCellRendererText* _tmp82_;
	GtkComboBox* _tmp83_;
	GtkCellRendererText* _tmp84_;
	GtkComboBox* _tmp85_;
	GtkListStore* _tmp86_;
	static const BudgiePanelTransparency transps[3] = {BUDGIE_PANEL_TRANSPARENCY_ALWAYS, BUDGIE_PANEL_TRANSPARENCY_DYNAMIC, BUDGIE_PANEL_TRANSPARENCY_NONE};
	GtkComboBox* _tmp94_;
	GtkListStore* _tmp95_;
	GtkComboBox* _tmp96_;
	GtkCellRendererText* _tmp97_;
	GtkComboBox* _tmp98_;
	GtkCellRendererText* _tmp99_;
	GtkComboBox* _tmp100_;
	GtkListStore* _tmp101_;
	static const BudgieAutohidePolicy policies[3] = {BUDGIE_AUTOHIDE_POLICY_AUTOMATIC, BUDGIE_AUTOHIDE_POLICY_INTELLIGENT, BUDGIE_AUTOHIDE_POLICY_NONE};
	GtkComboBox* _tmp109_;
	GtkListStore* _tmp110_;
	GtkComboBox* _tmp111_;
	GtkCellRendererText* _tmp112_;
	GtkComboBox* _tmp113_;
	GtkCellRendererText* _tmp114_;
	GtkComboBox* _tmp115_;
	static const gchar* needed_props[8] = {"position", "intended-size", "spacing", "transparency", "autohide", "shadow-visible", "theme-regions", "dock-mode"};
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = budgie_settings_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 8);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 20);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 20);
	g_object_ref_sink (_tmp0_);
	ret = _tmp0_;
	_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	group = _tmp1_;
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->combobox_position);
	self->priv->combobox_position = _tmp2_;
	_tmp3_ = self->priv->combobox_position;
	_tmp4_ = g_signal_connect_object (_tmp3_, "changed", (GCallback) _budgie_panel_page_set_position_gtk_combo_box_changed, self, 0);
	self->priv->position_id = _tmp4_;
	_tmp5_ = group;
	_tmp6_ = self->priv->combobox_position;
	gtk_size_group_add_widget (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = ret;
	_tmp8_ = self->priv->combobox_position;
	_tmp9_ = budgie_settings_row_new ((GtkWidget*) _tmp8_, _ ("Position"), _ ("Set the edge of the screen that this panel will stay on"));
	_tmp10_ = _tmp9_;
	budgie_settings_grid_add_row (_tmp7_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 16, (gdouble) 200, (gdouble) 1);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->spinbutton_size);
	self->priv->spinbutton_size = _tmp11_;
	_tmp12_ = self->priv->spinbutton_size;
	gtk_spin_button_set_numeric (_tmp12_, TRUE);
	_tmp13_ = self->priv->spinbutton_size;
	_tmp14_ = g_signal_connect_object (_tmp13_, "value-changed", (GCallback) _budgie_panel_page_set_size_gtk_spin_button_value_changed, self, 0);
	self->priv->size_id = _tmp14_;
	_tmp15_ = group;
	_tmp16_ = self->priv->spinbutton_size;
	gtk_size_group_add_widget (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = ret;
	_tmp18_ = self->priv->spinbutton_size;
	_tmp19_ = budgie_settings_row_new ((GtkWidget*) _tmp18_, _ ("Size"), _ ("Set the size (width or height, depending on orientation) of this panel"));
	_tmp20_ = _tmp19_;
	budgie_settings_grid_add_row (_tmp17_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) 64, (gdouble) 1);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->spinbutton_spacing);
	self->priv->spinbutton_spacing = _tmp21_;
	_tmp22_ = self->priv->spinbutton_spacing;
	gtk_spin_button_set_numeric (_tmp22_, TRUE);
	_tmp23_ = self->priv->spinbutton_spacing;
	_tmp24_ = g_signal_connect_object (_tmp23_, "value-changed", (GCallback) _budgie_panel_page_set_applet_spacing_gtk_spin_button_value_changed, self, 0);
	self->priv->spacing_id = _tmp24_;
	_tmp25_ = group;
	_tmp26_ = self->priv->spinbutton_spacing;
	gtk_size_group_add_widget (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = ret;
	_tmp28_ = self->priv->spinbutton_spacing;
	_tmp29_ = budgie_settings_row_new ((GtkWidget*) _tmp28_, _ ("Spacing"), _ ("Set the spacing between applets for this panel"));
	_tmp30_ = _tmp29_;
	budgie_settings_grid_add_row (_tmp27_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->combobox_autohide);
	self->priv->combobox_autohide = _tmp31_;
	_tmp32_ = self->priv->combobox_autohide;
	_tmp33_ = g_signal_connect_object (_tmp32_, "changed", (GCallback) _budgie_panel_page_set_autohide_gtk_combo_box_changed, self, 0);
	self->priv->autohide_id = _tmp33_;
	_tmp34_ = group;
	_tmp35_ = self->priv->combobox_autohide;
	gtk_size_group_add_widget (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = ret;
	_tmp37_ = self->priv->combobox_autohide;
	_tmp38_ = budgie_settings_row_new ((GtkWidget*) _tmp37_, _ ("Automatically hide"), _ ("When set, this panel will hide from view to maximize screen estate"));
	_tmp39_ = _tmp38_;
	budgie_settings_grid_add_row (_tmp36_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->combobox_transparency);
	self->priv->combobox_transparency = _tmp40_;
	_tmp41_ = self->priv->combobox_transparency;
	_tmp42_ = g_signal_connect_object (_tmp41_, "changed", (GCallback) _budgie_panel_page_set_transparency_gtk_combo_box_changed, self, 0);
	self->priv->transparency_id = _tmp42_;
	_tmp43_ = group;
	_tmp44_ = self->priv->combobox_transparency;
	gtk_size_group_add_widget (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = ret;
	_tmp46_ = self->priv->combobox_transparency;
	_tmp47_ = budgie_settings_row_new ((GtkWidget*) _tmp46_, _ ("Transparency"), _ ("Control when this panel should have a solid background"));
	_tmp48_ = _tmp47_;
	budgie_settings_grid_add_row (_tmp45_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->switch_shadow);
	self->priv->switch_shadow = _tmp49_;
	_tmp50_ = ret;
	_tmp51_ = self->priv->switch_shadow;
	_tmp52_ = budgie_settings_row_new ((GtkWidget*) _tmp51_, _ ("Shadow"), _ ("Adds a decorative drop-shadow, ideal for opaque panels"));
	_tmp53_ = _tmp52_;
	budgie_settings_grid_add_row (_tmp50_, _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = self->priv->switch_shadow;
	_tmp55_ = g_signal_connect_object ((GObject*) _tmp54_, "notify::active", (GCallback) _budgie_panel_page_set_shadow_g_object_notify, self, 0);
	self->priv->shadow_id = _tmp55_;
	_tmp56_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->switch_regions);
	self->priv->switch_regions = _tmp56_;
	_tmp57_ = ret;
	_tmp58_ = self->priv->switch_regions;
	_tmp59_ = budgie_settings_row_new ((GtkWidget*) _tmp58_, _ ("Stylize regions"), _ ("Adds a hint to the panel so that each of the panel's three main areas " "may be themed differently."));
	_tmp60_ = _tmp59_;
	budgie_settings_grid_add_row (_tmp57_, _tmp60_);
	_g_object_unref0 (_tmp60_);
	_tmp61_ = self->priv->switch_regions;
	_tmp62_ = g_signal_connect_object ((GObject*) _tmp61_, "notify::active", (GCallback) _budgie_panel_page_set_region_g_object_notify, self, 0);
	self->priv->region_id = _tmp62_;
	_tmp63_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->switch_dock);
	self->priv->switch_dock = _tmp63_;
	_tmp64_ = ret;
	_tmp65_ = self->priv->switch_dock;
	_tmp66_ = budgie_settings_row_new ((GtkWidget*) _tmp65_, _ ("Dock mode"), _ ("When in dock mode, the panel will use the minimal amount of space poss" \
"ible, " "freeing up valuable screen estate"));
	_tmp67_ = _tmp66_;
	budgie_settings_grid_add_row (_tmp64_, _tmp67_);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = self->priv->switch_dock;
	_tmp69_ = g_signal_connect_object ((GObject*) _tmp68_, "notify::active", (GCallback) _budgie_panel_page_set_dock_g_object_notify, self, 0);
	self->priv->dock_id = _tmp69_;
	_tmp70_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp70_);
	render = _tmp70_;
	_tmp71_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, budgie_panel_position_get_type (), -1);
	model = _tmp71_;
	{
		BudgiePanelPosition* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
		pos_collection = positions;
		pos_collection_length1 = G_N_ELEMENTS (positions);
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
			BudgiePanelPosition pos = 0U;
			pos = pos_collection[pos_it];
			{
				GtkListStore* _tmp72_;
				GtkTreeIter _tmp73_ = {0};
				GtkListStore* _tmp74_;
				GtkTreeIter _tmp75_;
				GFlagsValue* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				_tmp72_ = model;
				gtk_list_store_append (_tmp72_, &_tmp73_);
				iter = _tmp73_;
				_tmp74_ = model;
				_tmp75_ = iter;
				_tmp76_ = g_flags_get_first_value (g_type_class_ref (budgie_panel_position_get_type ()), pos);
				_tmp77_ = budgie_panel_page_pos_to_display (pos);
				_tmp78_ = _tmp77_;
				gtk_list_store_set (_tmp74_, &_tmp75_, 0, (_tmp76_ != NULL) ? _tmp76_->value_name : NULL, 1, _tmp78_, 2, pos, -1, -1);
				_g_free0 (_tmp78_);
			}
		}
	}
	_tmp79_ = self->priv->combobox_position;
	_tmp80_ = model;
	gtk_combo_box_set_model (_tmp79_, (GtkTreeModel*) _tmp80_);
	_tmp81_ = self->priv->combobox_position;
	_tmp82_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp81_, (GtkCellRenderer*) _tmp82_, TRUE);
	_tmp83_ = self->priv->combobox_position;
	_tmp84_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp83_, (GtkCellRenderer*) _tmp84_, "text", 1);
	_tmp85_ = self->priv->combobox_position;
	gtk_combo_box_set_id_column (_tmp85_, 0);
	_tmp86_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, BUDGIE_TYPE_PANEL_TRANSPARENCY, -1);
	_g_object_unref0 (model);
	model = _tmp86_;
	{
		BudgiePanelTransparency* t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = transps;
		t_collection_length1 = G_N_ELEMENTS (transps);
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			BudgiePanelTransparency t = 0U;
			t = t_collection[t_it];
			{
				GtkListStore* _tmp87_;
				GtkTreeIter _tmp88_ = {0};
				GtkListStore* _tmp89_;
				GtkTreeIter _tmp90_;
				GFlagsValue* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				_tmp87_ = model;
				gtk_list_store_append (_tmp87_, &_tmp88_);
				iter = _tmp88_;
				_tmp89_ = model;
				_tmp90_ = iter;
				_tmp91_ = g_flags_get_first_value (g_type_class_ref (BUDGIE_TYPE_PANEL_TRANSPARENCY), t);
				_tmp92_ = budgie_panel_page_transparency_to_display (t);
				_tmp93_ = _tmp92_;
				gtk_list_store_set (_tmp89_, &_tmp90_, 0, (_tmp91_ != NULL) ? _tmp91_->value_name : NULL, 1, _tmp93_, 2, t, -1, -1);
				_g_free0 (_tmp93_);
			}
		}
	}
	_tmp94_ = self->priv->combobox_transparency;
	_tmp95_ = model;
	gtk_combo_box_set_model (_tmp94_, (GtkTreeModel*) _tmp95_);
	_tmp96_ = self->priv->combobox_transparency;
	_tmp97_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp96_, (GtkCellRenderer*) _tmp97_, TRUE);
	_tmp98_ = self->priv->combobox_transparency;
	_tmp99_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp98_, (GtkCellRenderer*) _tmp99_, "text", 1);
	_tmp100_ = self->priv->combobox_transparency;
	gtk_combo_box_set_id_column (_tmp100_, 0);
	_tmp101_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, BUDGIE_TYPE_AUTOHIDE_POLICY, -1);
	_g_object_unref0 (model);
	model = _tmp101_;
	{
		BudgieAutohidePolicy* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = policies;
		p_collection_length1 = G_N_ELEMENTS (policies);
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			BudgieAutohidePolicy p = 0U;
			p = p_collection[p_it];
			{
				GtkListStore* _tmp102_;
				GtkTreeIter _tmp103_ = {0};
				GtkListStore* _tmp104_;
				GtkTreeIter _tmp105_;
				GFlagsValue* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				_tmp102_ = model;
				gtk_list_store_append (_tmp102_, &_tmp103_);
				iter = _tmp103_;
				_tmp104_ = model;
				_tmp105_ = iter;
				_tmp106_ = g_flags_get_first_value (g_type_class_ref (BUDGIE_TYPE_AUTOHIDE_POLICY), p);
				_tmp107_ = budgie_panel_page_policy_to_display (p);
				_tmp108_ = _tmp107_;
				gtk_list_store_set (_tmp104_, &_tmp105_, 0, (_tmp106_ != NULL) ? _tmp106_->value_name : NULL, 1, _tmp108_, 2, p, -1, -1);
				_g_free0 (_tmp108_);
			}
		}
	}
	_tmp109_ = self->priv->combobox_autohide;
	_tmp110_ = model;
	gtk_combo_box_set_model (_tmp109_, (GtkTreeModel*) _tmp110_);
	_tmp111_ = self->priv->combobox_autohide;
	_tmp112_ = render;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp111_, (GtkCellRenderer*) _tmp112_, TRUE);
	_tmp113_ = self->priv->combobox_autohide;
	_tmp114_ = render;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp113_, (GtkCellRenderer*) _tmp114_, "text", 1);
	_tmp115_ = self->priv->combobox_autohide;
	gtk_combo_box_set_id_column (_tmp115_, 0);
	{
		const gchar** init_collection = NULL;
		gint init_collection_length1 = 0;
		gint _init_collection_size_ = 0;
		gint init_it = 0;
		init_collection = needed_props;
		init_collection_length1 = G_N_ELEMENTS (needed_props);
		for (init_it = 0; init_it < init_collection_length1; init_it = init_it + 1) {
			const gchar* init = NULL;
			init = init_collection[init_it];
			{
				const gchar* _tmp116_;
				BudgieToplevel* _tmp117_;
				const gchar* _tmp118_;
				gchar* _tmp119_;
				_tmp116_ = init;
				budgie_panel_page_update_from_property (self, _tmp116_);
				_tmp117_ = self->priv->toplevel;
				_tmp118_ = init;
				_tmp119_ = g_strconcat ("notify::", _tmp118_, NULL);
				g_signal_connect_object ((GObject*) _tmp117_, _tmp119_, (GCallback) _budgie_panel_page_panel_notify_g_object_notify, self, G_CONNECT_AFTER);
				_g_free0 (_tmp119_);
			}
		}
	}
	result = (GtkWidget*) ret;
	_g_object_unref0 (model);
	_g_object_unref0 (render);
	_g_object_unref0 (group);
	return result;
}

static GtkWidget*
budgie_panel_page_applets_page (BudgiePanelPage* self)
{
	BudgieDesktopManager* _tmp0_;
	BudgieToplevel* _tmp1_;
	BudgieAppletsPage* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->toplevel;
	_tmp2_ = budgie_applets_page_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	result = (GtkWidget*) _tmp2_;
	return result;
}

static void
budgie_panel_page_panel_notify (BudgiePanelPage* self,
                                GObject* o,
                                GParamSpec* ps)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = ps->name;
	budgie_panel_page_update_from_property (self, _tmp0_);
}

/**
* Update our state from a given property, taking care to not
* fire off our own handlers and causing a cycle
*/
static void
budgie_panel_page_update_from_property (BudgiePanelPage* self,
                                        const gchar* property)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property != NULL);
	_tmp0_ = property;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("position")))) {
		switch (0) {
			default:
			{
				GtkComboBox* _tmp3_;
				GtkComboBox* _tmp4_;
				BudgieToplevel* _tmp5_;
				BudgiePanelPosition _tmp6_;
				BudgiePanelPosition _tmp7_;
				GFlagsValue* _tmp8_;
				BudgieToplevel* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GtkComboBox* _tmp12_;
				_tmp3_ = self->priv->combobox_position;
				g_signal_handler_block (_tmp3_, self->priv->position_id);
				_tmp4_ = self->priv->combobox_position;
				_tmp5_ = self->priv->toplevel;
				_tmp6_ = budgie_toplevel_get_position (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_flags_get_first_value (g_type_class_ref (budgie_panel_position_get_type ()), _tmp7_);
				gtk_combo_box_set_active_id (_tmp4_, (_tmp8_ != NULL) ? _tmp8_->value_name : NULL);
				_tmp9_ = self->priv->toplevel;
				_tmp10_ = budgie_panel_page_get_panel_name (_tmp9_);
				_tmp11_ = _tmp10_;
				budgie_settings_page_set_title ((BudgieSettingsPage*) self, _tmp11_);
				_g_free0 (_tmp11_);
				_tmp12_ = self->priv->combobox_position;
				g_signal_handler_unblock (_tmp12_, self->priv->position_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("intended-size")))) {
		switch (0) {
			default:
			{
				GtkSpinButton* _tmp13_;
				GtkSpinButton* _tmp14_;
				BudgieToplevel* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				GtkSpinButton* _tmp18_;
				_tmp13_ = self->priv->spinbutton_size;
				g_signal_handler_block (_tmp13_, self->priv->size_id);
				_tmp14_ = self->priv->spinbutton_size;
				_tmp15_ = self->priv->toplevel;
				_tmp16_ = budgie_toplevel_get_intended_size (_tmp15_);
				_tmp17_ = _tmp16_;
				gtk_spin_button_set_value (_tmp14_, (gdouble) _tmp17_);
				_tmp18_ = self->priv->spinbutton_size;
				g_signal_handler_unblock (_tmp18_, self->priv->size_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("spacing")))) {
		switch (0) {
			default:
			{
				GtkSpinButton* _tmp19_;
				GtkSpinButton* _tmp20_;
				BudgieToplevel* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				GtkSpinButton* _tmp24_;
				_tmp19_ = self->priv->spinbutton_spacing;
				g_signal_handler_block (_tmp19_, self->priv->spacing_id);
				_tmp20_ = self->priv->spinbutton_spacing;
				_tmp21_ = self->priv->toplevel;
				_tmp22_ = budgie_toplevel_get_intended_spacing (_tmp21_);
				_tmp23_ = _tmp22_;
				gtk_spin_button_set_value (_tmp20_, (gdouble) _tmp23_);
				_tmp24_ = self->priv->spinbutton_spacing;
				g_signal_handler_unblock (_tmp24_, self->priv->spacing_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("transparency")))) {
		switch (0) {
			default:
			{
				GtkComboBox* _tmp25_;
				GtkComboBox* _tmp26_;
				BudgieToplevel* _tmp27_;
				BudgiePanelTransparency _tmp28_;
				BudgiePanelTransparency _tmp29_;
				GFlagsValue* _tmp30_;
				GtkComboBox* _tmp31_;
				_tmp25_ = self->priv->combobox_transparency;
				g_signal_handler_block (_tmp25_, self->priv->transparency_id);
				_tmp26_ = self->priv->combobox_transparency;
				_tmp27_ = self->priv->toplevel;
				_tmp28_ = budgie_toplevel_get_transparency (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_flags_get_first_value (g_type_class_ref (BUDGIE_TYPE_PANEL_TRANSPARENCY), _tmp29_);
				gtk_combo_box_set_active_id (_tmp26_, (_tmp30_ != NULL) ? _tmp30_->value_name : NULL);
				_tmp31_ = self->priv->combobox_transparency;
				g_signal_handler_unblock (_tmp31_, self->priv->transparency_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("autohide")))) {
		switch (0) {
			default:
			{
				GtkComboBox* _tmp32_;
				GtkComboBox* _tmp33_;
				BudgieToplevel* _tmp34_;
				BudgieAutohidePolicy _tmp35_;
				BudgieAutohidePolicy _tmp36_;
				GFlagsValue* _tmp37_;
				GtkComboBox* _tmp38_;
				_tmp32_ = self->priv->combobox_autohide;
				g_signal_handler_block (_tmp32_, self->priv->autohide_id);
				_tmp33_ = self->priv->combobox_autohide;
				_tmp34_ = self->priv->toplevel;
				_tmp35_ = budgie_toplevel_get_autohide (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_flags_get_first_value (g_type_class_ref (BUDGIE_TYPE_AUTOHIDE_POLICY), _tmp36_);
				gtk_combo_box_set_active_id (_tmp33_, (_tmp37_ != NULL) ? _tmp37_->value_name : NULL);
				_tmp38_ = self->priv->combobox_autohide;
				g_signal_handler_unblock (_tmp38_, self->priv->autohide_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("shadow-visible")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp39_;
				GtkSwitch* _tmp40_;
				BudgieToplevel* _tmp41_;
				gboolean _tmp42_;
				gboolean _tmp43_;
				GtkSwitch* _tmp44_;
				_tmp39_ = self->priv->switch_shadow;
				g_signal_handler_block (_tmp39_, self->priv->shadow_id);
				_tmp40_ = self->priv->switch_shadow;
				_tmp41_ = self->priv->toplevel;
				_tmp42_ = budgie_toplevel_get_shadow_visible (_tmp41_);
				_tmp43_ = _tmp42_;
				gtk_switch_set_active (_tmp40_, _tmp43_);
				_tmp44_ = self->priv->switch_shadow;
				g_signal_handler_unblock (_tmp44_, self->priv->shadow_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("theme-regions")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp45_;
				GtkSwitch* _tmp46_;
				BudgieToplevel* _tmp47_;
				gboolean _tmp48_;
				gboolean _tmp49_;
				GtkSwitch* _tmp50_;
				_tmp45_ = self->priv->switch_regions;
				g_signal_handler_block (_tmp45_, self->priv->region_id);
				_tmp46_ = self->priv->switch_regions;
				_tmp47_ = self->priv->toplevel;
				_tmp48_ = budgie_toplevel_get_theme_regions (_tmp47_);
				_tmp49_ = _tmp48_;
				gtk_switch_set_active (_tmp46_, _tmp49_);
				_tmp50_ = self->priv->switch_regions;
				g_signal_handler_unblock (_tmp50_, self->priv->region_id);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("dock-mode")))) {
		switch (0) {
			default:
			{
				GtkSwitch* _tmp51_;
				GtkSwitch* _tmp52_;
				BudgieToplevel* _tmp53_;
				gboolean _tmp54_;
				gboolean _tmp55_;
				BudgieToplevel* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				GtkSwitch* _tmp59_;
				_tmp51_ = self->priv->switch_dock;
				g_signal_handler_block (_tmp51_, self->priv->dock_id);
				_tmp52_ = self->priv->switch_dock;
				_tmp53_ = self->priv->toplevel;
				_tmp54_ = budgie_toplevel_get_dock_mode (_tmp53_);
				_tmp55_ = _tmp54_;
				gtk_switch_set_active (_tmp52_, _tmp55_);
				_tmp56_ = self->priv->toplevel;
				_tmp57_ = budgie_panel_page_get_panel_name (_tmp56_);
				_tmp58_ = _tmp57_;
				budgie_settings_page_set_title ((BudgieSettingsPage*) self, _tmp58_);
				_g_free0 (_tmp58_);
				_tmp59_ = self->priv->switch_dock;
				g_signal_handler_unblock (_tmp59_, self->priv->dock_id);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

/**
* We're asking the panel to update the shadow state
*/
static void
budgie_panel_page_set_shadow (BudgiePanelPage* self)
{
	BudgieToplevel* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = self->priv->switch_shadow;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	budgie_toplevel_set_shadow_visible (_tmp0_, _tmp3_);
}

/**
* We're asking the panel to update the shadow state
*/
static void
budgie_panel_page_set_region (BudgiePanelPage* self)
{
	BudgieToplevel* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = self->priv->switch_regions;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	budgie_toplevel_set_theme_regions (_tmp0_, _tmp3_);
}

/**
* Ask the manager to change the dock state of the panel
*/
static void
budgie_panel_page_set_dock (BudgiePanelPage* self)
{
	BudgieDesktopManager* _tmp0_;
	BudgieToplevel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkSwitch* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->toplevel;
	_tmp2_ = budgie_toplevel_get_uuid (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->switch_dock;
	_tmp5_ = gtk_switch_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	budgie_desktop_manager_set_dock_mode (_tmp0_, _tmp3_, _tmp6_);
}

/**
* Update the panel position on screen
*/
static void
budgie_panel_page_set_position (BudgiePanelPage* self)
{
	GtkTreeIter iter = {0};
	BudgiePanelPosition position = 0U;
	BudgieToplevel* _tmp0_;
	BudgiePanelPosition _tmp1_;
	BudgiePanelPosition _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_;
	BudgiePanelPosition _tmp10_ = 0U;
	BudgieDesktopManager* _tmp11_;
	BudgieToplevel* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = budgie_toplevel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	_tmp3_ = self->priv->combobox_position;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->combobox_position;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, 2, &_tmp10_, -1, -1);
	position = _tmp10_;
	_tmp11_ = self->priv->manager;
	_tmp12_ = self->priv->toplevel;
	_tmp13_ = budgie_toplevel_get_uuid (_tmp12_);
	_tmp14_ = _tmp13_;
	budgie_desktop_manager_set_placement (_tmp11_, _tmp14_, position);
}

/**
* Update the autohide policy for the panel
*/
static void
budgie_panel_page_set_autohide (BudgiePanelPage* self)
{
	GtkTreeIter iter = {0};
	BudgieAutohidePolicy policy = 0U;
	BudgieToplevel* _tmp0_;
	BudgieAutohidePolicy _tmp1_;
	BudgieAutohidePolicy _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_;
	BudgieAutohidePolicy _tmp10_ = 0U;
	BudgieDesktopManager* _tmp11_;
	BudgieToplevel* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = budgie_toplevel_get_autohide (_tmp0_);
	_tmp2_ = _tmp1_;
	policy = _tmp2_;
	_tmp3_ = self->priv->combobox_autohide;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->combobox_autohide;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, 2, &_tmp10_, -1, -1);
	policy = _tmp10_;
	_tmp11_ = self->priv->manager;
	_tmp12_ = self->priv->toplevel;
	_tmp13_ = budgie_toplevel_get_uuid (_tmp12_);
	_tmp14_ = _tmp13_;
	budgie_desktop_manager_set_autohide (_tmp11_, _tmp14_, policy);
}

/**
* Update the transparency setting for the panel
*/
static void
budgie_panel_page_set_transparency (BudgiePanelPage* self)
{
	GtkTreeIter iter = {0};
	BudgiePanelTransparency transparency = 0U;
	BudgieToplevel* _tmp0_;
	BudgiePanelTransparency _tmp1_;
	BudgiePanelTransparency _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_;
	BudgiePanelTransparency _tmp10_ = 0U;
	BudgieDesktopManager* _tmp11_;
	BudgieToplevel* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = budgie_toplevel_get_transparency (_tmp0_);
	_tmp2_ = _tmp1_;
	transparency = _tmp2_;
	_tmp3_ = self->priv->combobox_transparency;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->combobox_transparency;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, 2, &_tmp10_, -1, -1);
	transparency = _tmp10_;
	_tmp11_ = self->priv->manager;
	_tmp12_ = self->priv->toplevel;
	_tmp13_ = budgie_toplevel_get_uuid (_tmp12_);
	_tmp14_ = _tmp13_;
	budgie_desktop_manager_set_transparency (_tmp11_, _tmp14_, transparency);
}

/**
* Update the panel size
*/
static void
budgie_panel_page_set_size (BudgiePanelPage* self)
{
	BudgieDesktopManager* _tmp0_;
	BudgieToplevel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkSpinButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->toplevel;
	_tmp2_ = budgie_toplevel_get_uuid (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->spinbutton_size;
	budgie_desktop_manager_set_size (_tmp0_, _tmp3_, (gint) gtk_spin_button_get_value (_tmp4_));
}

/**
* Update the panel spacing
*/
static void
budgie_panel_page_set_applet_spacing (BudgiePanelPage* self)
{
	BudgieDesktopManager* _tmp0_;
	BudgieToplevel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkSpinButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->toplevel;
	_tmp2_ = budgie_toplevel_get_uuid (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->spinbutton_spacing;
	budgie_desktop_manager_set_spacing (_tmp0_, _tmp3_, (gint) gtk_spin_button_get_value (_tmp4_));
}

/**
* Delete ourselves
*/
static void
budgie_panel_page_delete_panel (BudgiePanelPage* self)
{
	BudgieDesktopManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	if (budgie_desktop_manager_slots_used (_tmp0_) > ((guint) 1)) {
		BudgieRemovePanelDialog* dlg = NULL;
		GtkWidget* _tmp1_;
		BudgieRemovePanelDialog* _tmp2_;
		gboolean del = FALSE;
		BudgieRemovePanelDialog* _tmp3_;
		BudgieRemovePanelDialog* _tmp4_;
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp2_ = budgie_remove_panel_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
		g_object_ref_sink (_tmp2_);
		dlg = _tmp2_;
		_tmp3_ = dlg;
		del = budgie_remove_panel_dialog_run (_tmp3_);
		_tmp4_ = dlg;
		gtk_widget_destroy ((GtkWidget*) _tmp4_);
		if (del) {
			BudgieDesktopManager* _tmp5_;
			BudgieToplevel* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = self->priv->manager;
			_tmp6_ = self->priv->toplevel;
			_tmp7_ = budgie_toplevel_get_uuid (_tmp6_);
			_tmp8_ = _tmp7_;
			budgie_desktop_manager_delete_panel (_tmp5_, _tmp8_);
		}
		_g_object_unref0 (dlg);
	}
}

static void
budgie_panel_page_class_init (BudgiePanelPageClass * klass,
                              gpointer klass_data)
{
	budgie_panel_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePanelPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_panel_page_finalize;
}

static void
budgie_panel_page_instance_init (BudgiePanelPage * self,
                                 gpointer klass)
{
	self->priv = budgie_panel_page_get_instance_private (self);
	self->priv->manager = NULL;
}

static void
budgie_panel_page_finalize (GObject * obj)
{
	BudgiePanelPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_PAGE, BudgiePanelPage);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->switcher);
	_g_object_unref0 (self->priv->combobox_position);
	_g_object_unref0 (self->priv->combobox_autohide);
	_g_object_unref0 (self->priv->combobox_transparency);
	_g_object_unref0 (self->priv->switch_shadow);
	_g_object_unref0 (self->priv->switch_regions);
	_g_object_unref0 (self->priv->switch_dock);
	_g_object_unref0 (self->priv->spinbutton_size);
	_g_object_unref0 (self->priv->spinbutton_spacing);
	_g_object_unref0 (self->priv->button_remove_panel);
	G_OBJECT_CLASS (budgie_panel_page_parent_class)->finalize (obj);
}

/**
* PanelPage allows users to change aspects of the fonts used
*/
static GType
budgie_panel_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelPage), 0, (GInstanceInitFunc) budgie_panel_page_instance_init, NULL };
	GType budgie_panel_page_type_id;
	budgie_panel_page_type_id = g_type_register_static (BUDGIE_TYPE_SETTINGS_PAGE, "BudgiePanelPage", &g_define_type_info, 0);
	BudgiePanelPage_private_offset = g_type_add_instance_private (budgie_panel_page_type_id, sizeof (BudgiePanelPagePrivate));
	return budgie_panel_page_type_id;
}

GType
budgie_panel_page_get_type (void)
{
	static volatile gsize budgie_panel_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_page_type_id__once)) {
		GType budgie_panel_page_type_id;
		budgie_panel_page_type_id = budgie_panel_page_get_type_once ();
		g_once_init_leave (&budgie_panel_page_type_id__once, budgie_panel_page_type_id);
	}
	return budgie_panel_page_type_id__once;
}

