/* WorkspaceItem.c generated by valac 0.56.14, the Vala compiler
 * generated from WorkspaceItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib.h>
#include "workspacesapplet.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include "plugin.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo-gobject.h>

enum  {
	WORKSPACES_WORKSPACE_ITEM_0_PROPERTY,
	WORKSPACES_WORKSPACE_ITEM_NUM_PROPERTIES
};
static GParamSpec* workspaces_workspace_item_properties[WORKSPACES_WORKSPACE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
enum  {
	WORKSPACES_WORKSPACE_ITEM_REMOVE_WORKSPACE_SIGNAL,
	WORKSPACES_WORKSPACE_ITEM_PLS_UPDATE_WINDOWS_SIGNAL,
	WORKSPACES_WORKSPACE_ITEM_NUM_SIGNALS
};
static guint workspaces_workspace_item_signals[WORKSPACES_WORKSPACE_ITEM_NUM_SIGNALS] = {0};

struct _WorkspacesWorkspaceItemPrivate {
	XfwWorkspace* workspace;
	BudgiePopover* popover;
	GtkStack* popover_stack;
	GtkFlowBox* rest_of_the_icons;
	GtkGrid* icon_grid;
	GtkAllocation real_alloc;
	gfloat size_multiplier;
};

struct _Block5Data {
	int _ref_count_;
	WorkspacesWorkspaceItem* self;
	GtkLabel* name_label;
	GtkBox* button_box;
	GtkBox* rename_box;
	GtkEntry* entry;
};

struct _Block6Data {
	int _ref_count_;
	WorkspacesWorkspaceItem* self;
	gint num_columns;
	gint num_rows;
	gint max_items;
	gint num_windows;
	gint window_counter;
	gint row_counter;
	gint column_counter;
	GtkLabel* more_label;
};

static gint WorkspacesWorkspaceItem_private_offset;
static gpointer workspaces_workspace_item_parent_class = NULL;
static GType workspaces_workspace_item_type_id = 0;

static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda4_ (WorkspacesWorkspaceItem* self,
                     GdkEventButton* event);
static gboolean ___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean workspaces_workspace_item_on_drag_drop (WorkspacesWorkspaceItem* self,
                                                 GtkWidget* widget,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 guint time);
static gboolean _workspaces_workspace_item_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                       GdkDragContext* context,
                                                                       gint x,
                                                                       gint y,
                                                                       guint time_,
                                                                       gpointer self);
static void workspaces_workspace_item_on_drag_data_received (WorkspacesWorkspaceItem* self,
                                                      GtkWidget* widget,
                                                      GdkDragContext* context,
                                                      gint x,
                                                      gint y,
                                                      GtkSelectionData* selection_data,
                                                      guint target_type,
                                                      guint time);
static void _workspaces_workspace_item_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                     GdkDragContext* context,
                                                                                     gint x,
                                                                                     gint y,
                                                                                     GtkSelectionData* selection_data,
                                                                                     guint info,
                                                                                     guint time_,
                                                                                     gpointer self);
static void __lambda5_ (Block5Data* _data5_);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda6_ (Block5Data* _data5_);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda7_ (Block5Data* _data5_);
static void ___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                     gpointer self);
static void __lambda8_ (Block5Data* _data5_);
static void ___lambda8__budgie_popover_closed (BudgiePopover* _sender,
                                        gpointer self);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__libxfce4windowing_workspace_name_changed (XfwWorkspace* _sender,
                                                           gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_,
                  XfwWindow* window);
static gboolean ____lambda13_ (WorkspacesWorkspaceItem* self);
static gboolean _____lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static void workspaces_workspace_item_real_size_allocate (GtkWidget* base,
                                                   GtkAllocation* allocation);
static gboolean workspaces_workspace_item_real_button_release_event (GtkWidget* base,
                                                              GdkEventButton* event);
static void workspaces_workspace_item_real_get_preferred_width (GtkWidget* base,
                                                         gint* min,
                                                         gint* nat);
static void workspaces_workspace_item_real_get_preferred_height (GtkWidget* base,
                                                          gint* min,
                                                          gint* nat);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void workspaces_workspace_item_finalize (GObject * obj);

const GtkTargetEntry WORKSPACES_target_list[1] = {{"application/x-wnck-window-id", (guint) 0, (guint) 0}};

static inline gpointer
workspaces_workspace_item_get_instance_private (WorkspacesWorkspaceItem* self)
{
	return G_STRUCT_MEMBER_P (self, WorkspacesWorkspaceItem_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		WorkspacesWorkspaceItem* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->entry);
		_g_object_unref0 (_data5_->rename_box);
		_g_object_unref0 (_data5_->button_box);
		_g_object_unref0 (_data5_->name_label);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
__lambda4_ (WorkspacesWorkspaceItem* self,
            GdkEventButton* event)
{
	BudgiePopover* _tmp0_;
	XfwWorkspace* _tmp1_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->workspace;
	g_signal_emit (self, workspaces_workspace_item_signals[WORKSPACES_WORKSPACE_ITEM_REMOVE_WORKSPACE_SIGNAL], 0, xfw_workspace_get_number (_tmp1_), event->time);
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gtk_widget_button_release_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda4_ ((WorkspacesWorkspaceItem*) self, event);
	return result;
}

static gboolean
_workspaces_workspace_item_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              gint x,
                                                              gint y,
                                                              guint time_,
                                                              gpointer self)
{
	gboolean result;
	result = workspaces_workspace_item_on_drag_drop ((WorkspacesWorkspaceItem*) self, _sender, context, x, y, time_);
	return result;
}

static void
_workspaces_workspace_item_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                GdkDragContext* context,
                                                                                gint x,
                                                                                gint y,
                                                                                GtkSelectionData* selection_data,
                                                                                guint info,
                                                                                guint time_,
                                                                                gpointer self)
{
	workspaces_workspace_item_on_drag_data_received ((WorkspacesWorkspaceItem*) self, _sender, context, x, y, selection_data, info, time_);
}

static void
__lambda5_ (Block5Data* _data5_)
{
	WorkspacesWorkspaceItem* self;
	GtkStack* _tmp0_;
	self = _data5_->self;
	_tmp0_ = self->priv->popover_stack;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _data5_->rename_box);
}

static void
___lambda5__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda5_ (self);
}

static void
__lambda6_ (Block5Data* _data5_)
{
	WorkspacesWorkspaceItem* self;
	BudgiePopover* _tmp0_;
	XfwWorkspace* _tmp1_;
	const gchar* _tmp2_;
	self = _data5_->self;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->workspace;
	_tmp2_ = gtk_entry_get_text (_data5_->entry);
	g_object_set (_tmp1_, "name", _tmp2_, NULL);
}

static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ (self);
}

static void
__lambda7_ (Block5Data* _data5_)
{
	WorkspacesWorkspaceItem* self;
	BudgiePopover* _tmp0_;
	XfwWorkspace* _tmp1_;
	const gchar* _tmp2_;
	self = _data5_->self;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->workspace;
	_tmp2_ = gtk_entry_get_text (_data5_->entry);
	g_object_set (_tmp1_, "name", _tmp2_, NULL);
}

static void
___lambda7__gtk_entry_activate (GtkEntry* _sender,
                                gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda8_ (Block5Data* _data5_)
{
	WorkspacesWorkspaceItem* self;
	GtkStack* _tmp0_;
	XfwWorkspace* _tmp1_;
	const gchar* _tmp2_;
	BudgiePopoverManager* _tmp3_;
	self = _data5_->self;
	_tmp0_ = self->priv->popover_stack;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _data5_->button_box);
	_tmp1_ = self->priv->workspace;
	_tmp2_ = xfw_workspace_get_name (_tmp1_);
	gtk_entry_set_text (_data5_->entry, _tmp2_);
	_tmp3_ = workspaces_workspaces_applet_manager;
	budgie_popover_manager_unregister_popover (_tmp3_, (GtkWidget*) self);
	workspaces_workspaces_applet_dragging = FALSE;
}

static void
___lambda8__budgie_popover_closed (BudgiePopover* _sender,
                                   gpointer self)
{
	__lambda8_ (self);
}

static void
__lambda9_ (Block5Data* _data5_)
{
	WorkspacesWorkspaceItem* self;
	XfwWorkspace* _tmp0_;
	const gchar* _tmp1_;
	XfwWorkspace* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	XfwWorkspace* _tmp7_;
	const gchar* _tmp8_;
	self = _data5_->self;
	_tmp0_ = self->priv->workspace;
	_tmp1_ = xfw_workspace_get_name (_tmp0_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp1_);
	_tmp2_ = self->priv->workspace;
	_tmp3_ = xfw_workspace_get_name (_tmp2_);
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("<big>", _tmp4_, "</big>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_data5_->name_label, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->workspace;
	_tmp8_ = xfw_workspace_get_name (_tmp7_);
	gtk_entry_set_text (_data5_->entry, _tmp8_);
}

static void
___lambda9__libxfce4windowing_workspace_name_changed (XfwWorkspace* _sender,
                                                      gpointer self)
{
	__lambda9_ (self);
}

WorkspacesWorkspaceItem*
workspaces_workspace_item_construct (GType object_type,
                                     XfwWorkspace* space,
                                     gfloat multiplier)
{
	WorkspacesWorkspaceItem * self = NULL;
	Block5Data* _data5_;
	GtkStyleContext* _tmp0_;
	XfwWorkspace* _tmp1_;
	XfwWorkspace* _tmp2_;
	const gchar* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	BudgiePopover* _tmp11_;
	BudgiePopover* _tmp12_;
	GtkStyleContext* _tmp13_;
	BudgiePopover* _tmp14_;
	GtkBox* popover_box = NULL;
	GtkBox* _tmp15_;
	BudgiePopover* _tmp16_;
	XfwWorkspace* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp25_;
	GtkStack* _tmp26_;
	GtkStack* _tmp27_;
	GtkStack* _tmp28_;
	GtkStack* _tmp29_;
	GtkStack* _tmp30_;
	GtkBox* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkStack* _tmp33_;
	GtkButton* rename_button = NULL;
	GtkButton* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* _tmp36_;
	GtkSeparator* sep1 = NULL;
	GtkSeparator* _tmp37_;
	GtkButton* remove_button = NULL;
	GtkButton* _tmp38_;
	GtkWidget* _tmp39_;
	GtkWidget* _tmp40_;
	GtkBox* _tmp41_;
	GtkStack* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkEntry* _tmp44_;
	XfwWorkspace* _tmp45_;
	const gchar* _tmp46_;
	GtkButton* rename_confirm = NULL;
	GtkButton* _tmp47_;
	GtkFlowBox* _tmp48_;
	GtkFlowBox* _tmp49_;
	GtkFlowBox* _tmp50_;
	GtkFlowBox* _tmp51_;
	GtkFlowBox* _tmp52_;
	GtkFlowBox* _tmp53_;
	GtkFlowBox* _tmp54_;
	GtkStack* _tmp55_;
	GtkFlowBox* _tmp56_;
	BudgiePopover* _tmp57_;
	XfwWorkspace* _tmp58_;
	g_return_val_if_fail (space != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	self = (WorkspacesWorkspaceItem*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "workspace-item");
	_tmp1_ = _g_object_ref0 (space);
	_g_object_unref0 (self->priv->workspace);
	self->priv->workspace = _tmp1_;
	self->priv->size_multiplier = multiplier;
	_tmp2_ = self->priv->workspace;
	_tmp3_ = xfw_workspace_get_name (_tmp2_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp3_);
	self->priv->real_alloc.width = 0;
	self->priv->real_alloc.height = 0;
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->icon_grid);
	self->priv->icon_grid = _tmp4_;
	_tmp5_ = self->priv->icon_grid;
	gtk_grid_set_column_spacing (_tmp5_, (guint) 1);
	_tmp6_ = self->priv->icon_grid;
	gtk_grid_set_row_spacing (_tmp6_, (guint) 1);
	_tmp7_ = self->priv->icon_grid;
	gtk_grid_set_row_homogeneous (_tmp7_, TRUE);
	_tmp8_ = self->priv->icon_grid;
	gtk_grid_set_column_homogeneous (_tmp8_, TRUE);
	_tmp9_ = self->priv->icon_grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp9_, (guint) 2);
	_tmp10_ = self->priv->icon_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp11_;
	_tmp12_ = self->priv->popover;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "workspace-popover");
	_tmp14_ = self->priv->popover;
	gtk_widget_set_size_request ((GtkWidget*) _tmp14_, 150, -1);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	popover_box = _tmp15_;
	_tmp16_ = self->priv->popover;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) popover_box);
	_tmp17_ = self->priv->workspace;
	_tmp18_ = xfw_workspace_get_name (_tmp17_);
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("<big>", _tmp19_, "</big>", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_data5_->name_label = _tmp23_;
	gtk_box_pack_start (popover_box, (GtkWidget*) _data5_->name_label, FALSE, FALSE, (guint) 0);
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _data5_->name_label);
	gtk_style_context_add_class (_tmp24_, "dim-label");
	gtk_widget_set_halign ((GtkWidget*) _data5_->name_label, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) _data5_->name_label, 5);
	gtk_widget_set_margin_top ((GtkWidget*) _data5_->name_label, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) _data5_->name_label, 5);
	gtk_label_set_use_markup (_data5_->name_label, TRUE);
	_tmp25_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp25_);
	sep = _tmp25_;
	gtk_box_pack_start (popover_box, (GtkWidget*) sep, TRUE, FALSE, (guint) 0);
	_tmp26_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->popover_stack);
	self->priv->popover_stack = _tmp26_;
	_tmp27_ = self->priv->popover_stack;
	gtk_container_add ((GtkContainer*) popover_box, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->popover_stack;
	gtk_stack_set_transition_type (_tmp28_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT);
	_tmp29_ = self->priv->popover_stack;
	gtk_stack_set_interpolate_size (_tmp29_, TRUE);
	_tmp30_ = self->priv->popover_stack;
	gtk_stack_set_homogeneous (_tmp30_, FALSE);
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp31_);
	_data5_->button_box = _tmp31_;
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _data5_->button_box);
	gtk_style_context_add_class (_tmp32_, "workspace-popover-button-box");
	_tmp33_ = self->priv->popover_stack;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _data5_->button_box);
	_tmp34_ = (GtkButton*) gtk_button_new_with_label (_ ("Rename"));
	g_object_ref_sink (_tmp34_);
	rename_button = _tmp34_;
	gtk_box_pack_start (_data5_->button_box, (GtkWidget*) rename_button, TRUE, TRUE, (guint) 0);
	_tmp35_ = gtk_bin_get_child ((GtkBin*) rename_button);
	gtk_widget_set_halign (_tmp35_, GTK_ALIGN_START);
	_tmp36_ = gtk_bin_get_child ((GtkBin*) rename_button);
	gtk_widget_set_margin_start (_tmp36_, 0);
	gtk_button_set_relief (rename_button, GTK_RELIEF_NONE);
	_tmp37_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp37_);
	sep1 = _tmp37_;
	gtk_box_pack_start (_data5_->button_box, (GtkWidget*) sep1, TRUE, FALSE, (guint) 0);
	_tmp38_ = (GtkButton*) gtk_button_new_with_label (_ ("Remove"));
	g_object_ref_sink (_tmp38_);
	remove_button = _tmp38_;
	gtk_box_pack_start (_data5_->button_box, (GtkWidget*) remove_button, TRUE, TRUE, (guint) 0);
	_tmp39_ = gtk_bin_get_child ((GtkBin*) remove_button);
	gtk_widget_set_halign (_tmp39_, GTK_ALIGN_START);
	_tmp40_ = gtk_bin_get_child ((GtkBin*) remove_button);
	gtk_widget_set_margin_start (_tmp40_, 0);
	gtk_button_set_relief (remove_button, GTK_RELIEF_NONE);
	g_signal_connect_object ((GtkWidget*) remove_button, "button-release-event", (GCallback) ___lambda4__gtk_widget_button_release_event, self, 0);
	_tmp41_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp41_);
	_data5_->rename_box = _tmp41_;
	_tmp42_ = self->priv->popover_stack;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _data5_->rename_box);
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _data5_->rename_box);
	gtk_style_context_add_class (_tmp43_, GTK_STYLE_CLASS_LINKED);
	gtk_widget_set_margin_start ((GtkWidget*) _data5_->rename_box, 5);
	gtk_widget_set_margin_end ((GtkWidget*) _data5_->rename_box, 5);
	gtk_widget_set_margin_top ((GtkWidget*) _data5_->rename_box, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) _data5_->rename_box, 5);
	_tmp44_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp44_);
	_data5_->entry = _tmp44_;
	_tmp45_ = self->priv->workspace;
	_tmp46_ = xfw_workspace_get_name (_tmp45_);
	gtk_entry_set_text (_data5_->entry, _tmp46_);
	gtk_box_pack_start (_data5_->rename_box, (GtkWidget*) _data5_->entry, TRUE, TRUE, (guint) 0);
	_tmp47_ = (GtkButton*) gtk_button_new_from_icon_name ("emblem-ok-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp47_);
	rename_confirm = _tmp47_;
	gtk_box_pack_start (_data5_->rename_box, (GtkWidget*) rename_confirm, FALSE, FALSE, (guint) 0);
	_tmp48_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->rest_of_the_icons);
	self->priv->rest_of_the_icons = _tmp48_;
	_tmp49_ = self->priv->rest_of_the_icons;
	gtk_flow_box_set_max_children_per_line (_tmp49_, (guint) 4);
	_tmp50_ = self->priv->rest_of_the_icons;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp50_, GTK_ORIENTATION_HORIZONTAL);
	_tmp51_ = self->priv->rest_of_the_icons;
	gtk_flow_box_set_row_spacing (_tmp51_, (guint) 0);
	_tmp52_ = self->priv->rest_of_the_icons;
	gtk_flow_box_set_column_spacing (_tmp52_, (guint) 0);
	_tmp53_ = self->priv->rest_of_the_icons;
	gtk_flow_box_set_selection_mode (_tmp53_, GTK_SELECTION_NONE);
	_tmp54_ = self->priv->rest_of_the_icons;
	gtk_flow_box_set_homogeneous (_tmp54_, TRUE);
	_tmp55_ = self->priv->popover_stack;
	_tmp56_ = self->priv->rest_of_the_icons;
	gtk_stack_add_named (_tmp55_, (GtkWidget*) _tmp56_, "icons");
	gtk_widget_show_all ((GtkWidget*) popover_box);
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_HIGHLIGHT, WORKSPACES_target_list, (gint) G_N_ELEMENTS (WORKSPACES_target_list), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) _workspaces_workspace_item_on_drag_drop_gtk_widget_drag_drop, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _workspaces_workspace_item_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_data (rename_button, "clicked", (GCallback) ___lambda5__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (rename_confirm, "clicked", (GCallback) ___lambda6__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (_data5_->entry, "activate", (GCallback) ___lambda7__gtk_entry_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp57_ = self->priv->popover;
	g_signal_connect_data (_tmp57_, "closed", (GCallback) ___lambda8__budgie_popover_closed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp58_ = self->priv->workspace;
	g_signal_connect_data (_tmp58_, "name-changed", (GCallback) ___lambda9__libxfce4windowing_workspace_name_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (rename_confirm);
	_g_object_unref0 (remove_button);
	_g_object_unref0 (sep1);
	_g_object_unref0 (rename_button);
	_g_object_unref0 (sep);
	_g_object_unref0 (popover_box);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}

WorkspacesWorkspaceItem*
workspaces_workspace_item_new (XfwWorkspace* space,
                               gfloat multiplier)
{
	return workspaces_workspace_item_construct (WORKSPACES_TYPE_WORKSPACE_ITEM, space, multiplier);
}

static gboolean
workspaces_workspace_item_on_drag_drop (WorkspacesWorkspaceItem* self,
                                        GtkWidget* widget,
                                        GdkDragContext* context,
                                        gint x,
                                        gint y,
                                        guint time)
{
	gboolean is_valid_drop_site = FALSE;
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	is_valid_drop_site = TRUE;
	_tmp0_ = gdk_drag_context_list_targets (context);
	if (_tmp0_ != NULL) {
		GdkAtom target_type = (GdkAtom) 0U;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = gdk_drag_context_list_targets (context);
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
		target_type = (GdkAtom) ((GdkAtom) ((guintptr) _tmp2_));
		gtk_drag_get_data (widget, context, target_type, (guint32) time);
	} else {
		is_valid_drop_site = FALSE;
	}
	result = is_valid_drop_site;
	return result;
}

static void
workspaces_workspace_item_on_drag_data_received (WorkspacesWorkspaceItem* self,
                                                 GtkWidget* widget,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint target_type,
                                                 guint time)
{
	gboolean dnd_success = FALSE;
	gulong* data = NULL;
	guint8* _tmp0_;
	gulong* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	dnd_success = FALSE;
	_tmp0_ = gtk_selection_data_get_data (selection_data);
	data = (gulong*) _tmp0_;
	_tmp1_ = data;
	if (_tmp1_ != NULL) {
		{
			XfwScreen* _tmp2_;
			GList* _tmp3_;
			_tmp2_ = workspaces_workspaces_applet_xfce_screen;
			_tmp3_ = xfw_screen_get_windows (_tmp2_);
			{
				GList* window_collection = NULL;
				GList* window_it = NULL;
				window_collection = _tmp3_;
				for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
					XfwWindow* _tmp4_;
					XfwWindow* window = NULL;
					_tmp4_ = _g_object_ref0 ((XfwWindow*) window_it->data);
					window = _tmp4_;
					{
						XfwWindow* _tmp5_;
						gulong* _tmp6_;
						_tmp5_ = window;
						_tmp6_ = data;
						if (xfw_window_x11_get_xid (_tmp5_) == ((Window) (*_tmp6_))) {
							XfwWindow* _tmp7_;
							XfwWorkspace* _tmp8_;
							_tmp7_ = window;
							_tmp8_ = self->priv->workspace;
							xfw_window_move_to_workspace (_tmp7_, _tmp8_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (window);
								goto __catch0_g_error;
							}
							dnd_success = TRUE;
							_g_object_unref0 (window);
							break;
						}
						_g_object_unref0 (window);
					}
				}
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("WorkspaceItem.vala:189: Failed to move window to workspace: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gtk_drag_finish (context, dnd_success, TRUE, (guint32) time);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		WorkspacesWorkspaceItem* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->more_label);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
____lambda13_ (WorkspacesWorkspaceItem* self)
{
	GtkStack* _tmp0_;
	GtkFlowBox* _tmp1_;
	BudgiePopoverManager* _tmp2_;
	BudgiePopover* _tmp3_;
	BudgiePopoverManager* _tmp4_;
	gboolean result;
	_tmp0_ = self->priv->popover_stack;
	_tmp1_ = self->priv->rest_of_the_icons;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	workspaces_workspaces_applet_dragging = TRUE;
	_tmp2_ = workspaces_workspaces_applet_manager;
	_tmp3_ = self->priv->popover;
	budgie_popover_manager_register_popover (_tmp2_, (GtkWidget*) self, _tmp3_);
	_tmp4_ = workspaces_workspaces_applet_manager;
	budgie_popover_manager_show_popover (_tmp4_, (GtkWidget*) self);
	result = TRUE;
	return result;
}

static gboolean
_____lambda13__gtk_widget_button_press_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = ____lambda13_ ((WorkspacesWorkspaceItem*) self);
	return result;
}

static void
__lambda10_ (Block6Data* _data6_,
             XfwWindow* window)
{
	WorkspacesWorkspaceItem* self;
	WorkspacesWindowIcon* icon = NULL;
	WorkspacesWindowIcon* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gint _tmp20_;
	gint _tmp21_;
	self = _data6_->self;
	g_return_if_fail (window != NULL);
	_tmp0_ = workspaces_window_icon_new (window);
	g_object_ref_sink (_tmp0_);
	icon = _tmp0_;
	if (_data6_->window_counter < _data6_->max_items) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _data6_->num_windows == _data6_->max_items;
	}
	if (_tmp1_) {
		GtkGrid* _tmp2_;
		WorkspacesWindowIcon* _tmp3_;
		WorkspacesWindowIcon* _tmp4_;
		WorkspacesWindowIcon* _tmp5_;
		_tmp2_ = self->priv->icon_grid;
		_tmp3_ = icon;
		gtk_grid_attach (_tmp2_, (GtkWidget*) _tmp3_, _data6_->column_counter, _data6_->row_counter, 1, 1);
		_tmp4_ = icon;
		gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
		_tmp5_ = icon;
		gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	} else {
		if (_data6_->window_counter == _data6_->max_items) {
			GtkEventBox* ebox = NULL;
			GtkEventBox* _tmp6_;
			GtkEventBox* _tmp7_;
			GtkLabel* _tmp8_;
			GtkGrid* _tmp9_;
			GtkEventBox* _tmp10_;
			GtkEventBox* _tmp11_;
			GtkEventBox* _tmp12_;
			GtkEventBox* _tmp13_;
			GtkEventBox* _tmp14_;
			_tmp6_ = (GtkEventBox*) gtk_event_box_new ();
			g_object_ref_sink (_tmp6_);
			ebox = _tmp6_;
			_tmp7_ = ebox;
			_tmp8_ = _data6_->more_label;
			gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
			_tmp9_ = self->priv->icon_grid;
			_tmp10_ = ebox;
			gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, _data6_->column_counter, _data6_->row_counter, 1, 1);
			_tmp11_ = ebox;
			gtk_widget_show_all ((GtkWidget*) _tmp11_);
			_tmp12_ = ebox;
			g_signal_connect_object ((GtkWidget*) _tmp12_, "button-press-event", (GCallback) _____lambda13__gtk_widget_button_press_event, self, 0);
			_tmp13_ = ebox;
			gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
			_tmp14_ = ebox;
			gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_CENTER);
			_g_object_unref0 (ebox);
		}
	}
	if (_data6_->window_counter >= _data6_->max_items) {
		WorkspacesWindowIcon* _tmp16_;
		GtkContainer* _tmp17_;
		_tmp16_ = icon;
		_tmp17_ = gtk_widget_get_parent ((GtkWidget*) _tmp16_);
		_tmp15_ = _tmp17_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GtkFlowBox* _tmp18_;
		WorkspacesWindowIcon* _tmp19_;
		_tmp18_ = self->priv->rest_of_the_icons;
		_tmp19_ = icon;
		gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	}
	_tmp20_ = _data6_->window_counter;
	_data6_->window_counter = _tmp20_ + 1;
	_tmp21_ = _data6_->column_counter;
	_data6_->column_counter = _tmp21_ + 1;
	if (_data6_->column_counter >= _data6_->num_columns) {
		gint _tmp22_;
		_data6_->column_counter = 0;
		_tmp22_ = _data6_->row_counter;
		_data6_->row_counter = _tmp22_ + 1;
	}
	if (_data6_->row_counter >= _data6_->num_rows) {
		_g_object_unref0 (icon);
		return;
	}
	_g_object_unref0 (icon);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ (self, (XfwWindow*) data);
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

void
workspaces_workspace_item_update_windows (WorkspacesWorkspaceItem* self,
                                          GList* window_list)
{
	Block6Data* _data6_;
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkGrid* _tmp12_;
	GList* _tmp13_;
	GtkFlowBox* _tmp16_;
	GList* _tmp17_;
	GtkFlowBox* _tmp20_;
	GList* _tmp21_;
	GList* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->real_alloc;
	_data6_->num_columns = (_tmp0_.width - 4) / 20;
	_tmp1_ = self->priv->real_alloc;
	_data6_->num_rows = (_tmp1_.height - 4) / 20;
	if (_data6_->num_columns <= 0) {
		_data6_->num_columns = 1;
	}
	if (_data6_->num_rows <= 0) {
		_data6_->num_rows = 1;
	}
	_data6_->max_items = _data6_->num_rows * _data6_->num_columns;
	_data6_->num_windows = (gint) g_list_length (window_list);
	_data6_->window_counter = 1;
	_data6_->row_counter = 0;
	_data6_->column_counter = 0;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	_data6_->more_label = _tmp2_;
	_tmp3_ = _data6_->more_label;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "workspace-more-label");
	_tmp5_ = _data6_->more_label;
	_tmp6_ = g_strdup_printf ("%i", (_data6_->num_windows - _data6_->max_items) + 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("<small>+", _tmp7_, "</small>", NULL);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp10_ = _data6_->more_label;
	gtk_label_set_use_markup (_tmp10_, TRUE);
	_tmp11_ = _data6_->more_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp11_, 15, 15);
	_tmp12_ = self->priv->icon_grid;
	_tmp13_ = gtk_container_get_children ((GtkContainer*) _tmp12_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp13_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp14_;
			GtkWidget* widget = NULL;
			_tmp14_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp14_;
			{
				GtkWidget* _tmp15_;
				_tmp15_ = widget;
				gtk_widget_destroy (_tmp15_);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	_tmp16_ = self->priv->rest_of_the_icons;
	_tmp17_ = gtk_container_get_children ((GtkContainer*) _tmp16_);
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
		widget_collection = _tmp17_;
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
			GtkWidget* _tmp18_;
			GtkWidget* widget = NULL;
			_tmp18_ = _g_object_ref0 ((GtkWidget*) widget_it->data);
			widget = _tmp18_;
			{
				GtkWidget* _tmp19_;
				_tmp19_ = widget;
				gtk_widget_destroy (_tmp19_);
				_g_object_unref0 (widget);
			}
		}
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
	}
	g_list_foreach (window_list, ___lambda10__gfunc, _data6_);
	_tmp20_ = self->priv->rest_of_the_icons;
	_tmp21_ = gtk_container_get_children ((GtkContainer*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_g_list_is_empty (_tmp22_);
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (g_list_free (_tmp22_), NULL));
	if (_tmp23_) {
		BudgiePopover* _tmp24_;
		_tmp24_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp24_);
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

void
workspaces_workspace_item_set_size_multiplier (WorkspacesWorkspaceItem* self,
                                               gfloat multiplier)
{
	g_return_if_fail (self != NULL);
	self->priv->size_multiplier = multiplier;
}

static void
workspaces_workspace_item_real_size_allocate (GtkWidget* base,
                                              GtkAllocation* allocation)
{
	WorkspacesWorkspaceItem * self;
	GtkAllocation _tmp0_;
	self = (WorkspacesWorkspaceItem*) base;
	g_return_if_fail (allocation != NULL);
	gtk_widget_queue_resize ((GtkWidget*) self);
	_tmp0_ = self->priv->real_alloc;
	GTK_WIDGET_CLASS (workspaces_workspace_item_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox), &_tmp0_);
}

static gboolean
workspaces_workspace_item_real_button_release_event (GtkWidget* base,
                                                     GdkEventButton* event)
{
	WorkspacesWorkspaceItem * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (WorkspacesWorkspaceItem*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		XfwWorkspace* _workspace = NULL;
		XfwWorkspaceGroup* _tmp0_;
		XfwWorkspace* _tmp1_;
		XfwWorkspace* _tmp2_;
		gboolean _tmp3_ = FALSE;
		XfwWorkspace* _tmp4_;
		_tmp0_ = workspaces_workspaces_applet_workspace_group;
		_tmp1_ = xfw_workspace_group_get_active_workspace (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_workspace = _tmp2_;
		_tmp4_ = _workspace;
		if (_tmp4_ != NULL) {
			XfwWorkspace* _tmp5_;
			XfwWorkspace* _tmp6_;
			_tmp5_ = _workspace;
			_tmp6_ = self->priv->workspace;
			_tmp3_ = _tmp5_ == _tmp6_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = GDK_EVENT_STOP;
			_g_object_unref0 (_workspace);
			return result;
		}
		{
			XfwWorkspace* _tmp7_;
			_tmp7_ = self->priv->workspace;
			xfw_workspace_activate (_tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("WorkspaceItem.vala:291: Failed to activate workspace: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			_g_object_unref0 (_workspace);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		_g_object_unref0 (_workspace);
	} else {
		if (event->button == ((guint) 3)) {
			BudgiePopoverManager* _tmp11_;
			BudgiePopover* _tmp12_;
			BudgiePopoverManager* _tmp13_;
			_tmp11_ = workspaces_workspaces_applet_manager;
			_tmp12_ = self->priv->popover;
			budgie_popover_manager_register_popover (_tmp11_, (GtkWidget*) self, _tmp12_);
			_tmp13_ = workspaces_workspaces_applet_manager;
			budgie_popover_manager_show_popover (_tmp13_, (GtkWidget*) self);
		} else {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
	result = GDK_EVENT_STOP;
	return result;
}

static void
workspaces_workspace_item_real_get_preferred_width (GtkWidget* base,
                                                    gint* min,
                                                    gint* nat)
{
	WorkspacesWorkspaceItem * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gfloat height = 0.0F;
	self = (WorkspacesWorkspaceItem*) base;
	if (workspaces_workspaces_applet_get_orientation () == GTK_ORIENTATION_VERTICAL) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GTK_WIDGET_CLASS (workspaces_workspace_item_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox), &_tmp0_, &_tmp1_);
		_vala_min = _tmp0_;
		_vala_nat = _tmp1_;
		self->priv->real_alloc.width = workspaces_workspaces_applet_panel_size;
		_vala_nat = self->priv->real_alloc.width;
		_vala_min = _vala_nat;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	height = (gfloat) workspaces_workspaces_applet_panel_size;
	_vala_nat = (gint) ((height * 2.9) * self->priv->size_multiplier);
	_vala_min = _vala_nat;
	self->priv->real_alloc.width = (gint) ((height * 2.9) * self->priv->size_multiplier);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
workspaces_workspace_item_real_get_preferred_height (GtkWidget* base,
                                                     gint* min,
                                                     gint* nat)
{
	WorkspacesWorkspaceItem * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gfloat height = 0.0F;
	self = (WorkspacesWorkspaceItem*) base;
	if (workspaces_workspaces_applet_get_orientation () == GTK_ORIENTATION_HORIZONTAL) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GTK_WIDGET_CLASS (workspaces_workspace_item_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox), &_tmp0_, &_tmp1_);
		_vala_min = _tmp0_;
		_vala_nat = _tmp1_;
		self->priv->real_alloc.height = workspaces_workspaces_applet_panel_size;
		_vala_nat = self->priv->real_alloc.height;
		_vala_min = _vala_nat;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	height = (gfloat) workspaces_workspaces_applet_panel_size;
	_vala_nat = (gint) ((height * 2) * self->priv->size_multiplier);
	_vala_min = _vala_nat;
	self->priv->real_alloc.height = (gint) ((height * 2) * self->priv->size_multiplier);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

XfwWorkspace*
workspaces_workspace_item_get_workspace (WorkspacesWorkspaceItem* self)
{
	XfwWorkspace* _tmp0_;
	XfwWorkspace* _tmp1_;
	XfwWorkspace* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->workspace;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint32 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}

static void
workspaces_workspace_item_class_init (WorkspacesWorkspaceItemClass * klass,
                                      gpointer klass_data)
{
	workspaces_workspace_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WorkspacesWorkspaceItem_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) workspaces_workspace_item_real_size_allocate;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) workspaces_workspace_item_real_button_release_event;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) workspaces_workspace_item_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) workspaces_workspace_item_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->finalize = workspaces_workspace_item_finalize;
	workspaces_workspace_item_signals[WORKSPACES_WORKSPACE_ITEM_REMOVE_WORKSPACE_SIGNAL] = g_signal_new ("remove-workspace", WORKSPACES_TYPE_WORKSPACE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	workspaces_workspace_item_signals[WORKSPACES_WORKSPACE_ITEM_PLS_UPDATE_WINDOWS_SIGNAL] = g_signal_new ("pls-update-windows", WORKSPACES_TYPE_WORKSPACE_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
workspaces_workspace_item_instance_init (WorkspacesWorkspaceItem * self,
                                         gpointer klass)
{
	self->priv = workspaces_workspace_item_get_instance_private (self);
}

static void
workspaces_workspace_item_finalize (GObject * obj)
{
	WorkspacesWorkspaceItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WORKSPACE_ITEM, WorkspacesWorkspaceItem);
	_g_object_unref0 (self->priv->workspace);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->popover_stack);
	_g_object_unref0 (self->priv->rest_of_the_icons);
	_g_object_unref0 (self->priv->icon_grid);
	G_OBJECT_CLASS (workspaces_workspace_item_parent_class)->finalize (obj);
}

GType
workspaces_workspace_item_get_type (void)
{
	return workspaces_workspace_item_type_id;
}

GType
workspaces_workspace_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWorkspaceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_workspace_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWorkspaceItem), 0, (GInstanceInitFunc) workspaces_workspace_item_instance_init, NULL };
	workspaces_workspace_item_type_id = g_type_module_register_type (module, gtk_event_box_get_type (), "WorkspacesWorkspaceItem", &g_define_type_info, 0);
	WorkspacesWorkspaceItem_private_offset = sizeof (WorkspacesWorkspaceItemPrivate);
	return workspaces_workspace_item_type_id;
}

