/* UserIndicator.c generated by valac 0.56.14, the Vala compiler
 * generated from UserIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "userindicator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libpeas/peas.h>

enum  {
	USER_INDICATOR_0_PROPERTY,
	USER_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* user_indicator_properties[USER_INDICATOR_NUM_PROPERTIES];

#define TYPE_POWER_DIALOG_INTERFACE (power_dialog_interface_get_type ())
#define POWER_DIALOG_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POWER_DIALOG_INTERFACE, PowerDialogInterface))
#define IS_POWER_DIALOG_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POWER_DIALOG_INTERFACE))
#define POWER_DIALOG_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POWER_DIALOG_INTERFACE, PowerDialogInterfaceIface))

typedef struct _PowerDialogInterface PowerDialogInterface;
typedef struct _PowerDialogInterfaceIface PowerDialogInterfaceIface;

#define TYPE_POWER_DIALOG_INTERFACE_PROXY (power_dialog_interface_proxy_get_type ())
enum  {
	USER_INDICATOR_APPLET_0_PROPERTY,
	USER_INDICATOR_APPLET_UUID_PROPERTY,
	USER_INDICATOR_APPLET_NUM_PROPERTIES
};
static GParamSpec* user_indicator_applet_properties[USER_INDICATOR_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PowerDialogInterfaceIface {
	GTypeInterface parent_iface;
	void (*Toggle) (PowerDialogInterface* self, GError** error);
};

struct _UserIndicatorAppletPrivate {
	GtkButton* button;
	PowerDialogInterface* power_dialog;
	gchar* _uuid;
};

static gpointer user_indicator_parent_class = NULL;
static BudgiePluginIface * user_indicator_budgie_plugin_parent_iface = NULL;
static GType user_indicator_type_id = 0;
static gint UserIndicatorApplet_private_offset;
static gpointer user_indicator_applet_parent_class = NULL;
static GType user_indicator_applet_type_id = 0;

static BudgieApplet* user_indicator_real_get_panel_widget (BudgiePlugin* base,
                                                    const gchar* uuid);
VALA_EXTERN GType power_dialog_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void power_dialog_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint power_dialog_interface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
GType power_dialog_interface_register_type (GTypeModule * module);
VALA_EXTERN GType power_dialog_interface_get_type (void) G_GNUC_CONST ;
static void user_indicator_applet_on_dialog_acquired (UserIndicatorApplet* self,
                                               GObject* obj,
                                               GAsyncResult* res);
static void _user_indicator_applet_on_dialog_acquired_gasync_ready_callback (GObject* source_object,
                                                                      GAsyncResult* res,
                                                                      gpointer self);
static void user_indicator_applet_on_button_clicked (UserIndicatorApplet* self);
static void _user_indicator_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
VALA_EXTERN void power_dialog_interface_Toggle (PowerDialogInterface* self,
                                    GError** error);
static void user_indicator_applet_finalize (GObject * obj);
static void _vala_user_indicator_applet_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_user_indicator_applet_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
GType power_dialog_interface_register_type (GTypeModule * module);
VALA_EXTERN void power_dialog_interface_proxy_register_dynamic_type (GTypeModule* module);

static BudgieApplet*
user_indicator_real_get_panel_widget (BudgiePlugin* base,
                                      const gchar* uuid)
{
	UserIndicator * self;
	UserIndicatorApplet* _tmp0_;
	BudgieApplet* result;
	self = (UserIndicator*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = user_indicator_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

UserIndicator*
user_indicator_construct (GType object_type)
{
	UserIndicator * self = NULL;
	self = (UserIndicator*) g_object_new (object_type, NULL);
	return self;
}

UserIndicator*
user_indicator_new (void)
{
	return user_indicator_construct (TYPE_USER_INDICATOR);
}

static void
user_indicator_class_init (UserIndicatorClass * klass,
                           gpointer klass_data)
{
	user_indicator_parent_class = g_type_class_peek_parent (klass);
}

static void
user_indicator_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                             gpointer iface_data)
{
	user_indicator_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) user_indicator_real_get_panel_widget;
}

static void
user_indicator_instance_init (UserIndicator * self,
                              gpointer klass)
{
}

GType
user_indicator_get_type (void)
{
	return user_indicator_type_id;
}

GType
user_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicator), 0, (GInstanceInitFunc) user_indicator_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) user_indicator_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	user_indicator_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "UserIndicator", &g_define_type_info, 0);
	g_type_module_add_interface (module, user_indicator_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return user_indicator_type_id;
}

static inline gpointer
user_indicator_applet_get_instance_private (UserIndicatorApplet* self)
{
	return G_STRUCT_MEMBER_P (self, UserIndicatorApplet_private_offset);
}

static void
_user_indicator_applet_on_dialog_acquired_gasync_ready_callback (GObject* source_object,
                                                                 GAsyncResult* res,
                                                                 gpointer self)
{
	user_indicator_applet_on_dialog_acquired ((UserIndicatorApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
_user_indicator_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	user_indicator_applet_on_button_clicked ((UserIndicatorApplet*) self);
}

UserIndicatorApplet*
user_indicator_applet_construct (GType object_type,
                                 const gchar* uuid)
{
	UserIndicatorApplet * self = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (UserIndicatorApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name (USER_SYMBOLIC_ICON, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->button);
	self->priv->button = _tmp0_;
	_tmp1_ = self->priv->button;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "flat");
	g_async_initable_new_async (TYPE_POWER_DIALOG_INTERFACE_PROXY, 0, NULL, _user_indicator_applet_on_dialog_acquired_gasync_ready_callback, g_object_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.buddiesofbudgie.PowerDialog", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/buddiesofbudgie/PowerDialog", "g-interface-name", "org.buddiesofbudgie.PowerDialog", NULL);
	_tmp3_ = self->priv->button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) _user_indicator_applet_on_button_clicked_gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

UserIndicatorApplet*
user_indicator_applet_new (const gchar* uuid)
{
	return user_indicator_applet_construct (TYPE_USER_INDICATOR_APPLET, uuid);
}

static void
user_indicator_applet_on_dialog_acquired (UserIndicatorApplet* self,
                                          GObject* obj,
                                          GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PowerDialogInterface* _tmp0_ = NULL;
		PowerDialogInterface* _tmp1_;
		PowerDialogInterface* _tmp2_;
		PowerDialogInterface* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (PowerDialogInterface*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (PowerDialogInterface*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->power_dialog);
		self->priv->power_dialog = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("UserIndicator.vala:52: Unable to get PowerDialog proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
user_indicator_applet_on_button_clicked (UserIndicatorApplet* self)
{
	PowerDialogInterface* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_dialog;
	if (_tmp0_ == NULL) {
		g_warning ("UserIndicator.vala:58: Attempted to toggle PowerDialog, but we don't h" \
"ave a DBus proxy!");
		return;
	}
	{
		PowerDialogInterface* _tmp1_;
		_tmp1_ = self->priv->power_dialog;
		power_dialog_interface_Toggle (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("UserIndicator.vala:65: Error toggling PowerDialog: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

const gchar*
user_indicator_applet_get_uuid (UserIndicatorApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
user_indicator_applet_set_uuid (UserIndicatorApplet* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = user_indicator_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, user_indicator_applet_properties[USER_INDICATOR_APPLET_UUID_PROPERTY]);
	}
}

static void
user_indicator_applet_class_init (UserIndicatorAppletClass * klass,
                                  gpointer klass_data)
{
	user_indicator_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UserIndicatorApplet_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_user_indicator_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_indicator_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_indicator_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_INDICATOR_APPLET_UUID_PROPERTY, user_indicator_applet_properties[USER_INDICATOR_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
user_indicator_applet_instance_init (UserIndicatorApplet * self,
                                     gpointer klass)
{
	self->priv = user_indicator_applet_get_instance_private (self);
	self->priv->button = NULL;
	self->priv->power_dialog = NULL;
}

static void
user_indicator_applet_finalize (GObject * obj)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->priv->power_dialog);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (user_indicator_applet_parent_class)->finalize (obj);
}

GType
user_indicator_applet_get_type (void)
{
	return user_indicator_applet_type_id;
}

GType
user_indicator_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicatorApplet), 0, (GInstanceInitFunc) user_indicator_applet_instance_init, NULL };
	user_indicator_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "UserIndicatorApplet", &g_define_type_info, 0);
	UserIndicatorApplet_private_offset = sizeof (UserIndicatorAppletPrivate);
	return user_indicator_applet_type_id;
}

static void
_vala_user_indicator_applet_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	switch (property_id) {
		case USER_INDICATOR_APPLET_UUID_PROPERTY:
		g_value_set_string (value, user_indicator_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_user_indicator_applet_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	UserIndicatorApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_INDICATOR_APPLET, UserIndicatorApplet);
	switch (property_id) {
		case USER_INDICATOR_APPLET_UUID_PROPERTY:
		user_indicator_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	user_indicator_register_type (module);
	user_indicator_applet_register_type (module);
	power_dialog_interface_register_type (module);
	power_dialog_interface_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_USER_INDICATOR);
	_g_object_unref0 (objmodule);
}

