/* TrayItem.c generated by valac 0.56.14, the Vala compiler
 * generated from TrayItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "trayapplet.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>

#define TARGET_ICON_SCALE (2.0 / 3.0)

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SN_ITEM_PROPERTIES (sn_item_properties_get_type ())
#define SN_ITEM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SN_ITEM_PROPERTIES, SnItemProperties))
#define IS_SN_ITEM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SN_ITEM_PROPERTIES))
#define SN_ITEM_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SN_ITEM_PROPERTIES, SnItemPropertiesIface))

typedef struct _SnItemProperties SnItemProperties;
typedef struct _SnItemPropertiesIface SnItemPropertiesIface;

#define TYPE_SN_ITEM_PROPERTIES_PROXY (sn_item_properties_proxy_get_type ())
typedef GDBusProxy SnItemPropertiesProxy;
typedef GDBusProxyClass SnItemPropertiesProxyClass;

#define TYPE_SN_ITEM_INTERFACE (sn_item_interface_get_type ())
#define SN_ITEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SN_ITEM_INTERFACE, SnItemInterface))
#define IS_SN_ITEM_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SN_ITEM_INTERFACE))
#define SN_ITEM_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SN_ITEM_INTERFACE, SnItemInterfaceIface))

typedef struct _SnItemInterface SnItemInterface;
typedef struct _SnItemInterfaceIface SnItemInterfaceIface;

#define TYPE_SN_ITEM_INTERFACE_PROXY (sn_item_interface_proxy_get_type ())
enum  {
	SN_ITEM_INTERFACE_NEW_TITLE_SIGNAL,
	SN_ITEM_INTERFACE_NEW_ICON_SIGNAL,
	SN_ITEM_INTERFACE_NEW_ICON_THEME_PATH_SIGNAL,
	SN_ITEM_INTERFACE_NEW_ATTENTION_ICON_SIGNAL,
	SN_ITEM_INTERFACE_NEW_OVERLAY_ICON_SIGNAL,
	SN_ITEM_INTERFACE_NEW_TOOL_TIP_SIGNAL,
	SN_ITEM_INTERFACE_NEW_STATUS_SIGNAL,
	SN_ITEM_INTERFACE_NUM_SIGNALS
};
static guint sn_item_interface_signals[SN_ITEM_INTERFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy SnItemInterfaceProxy;
typedef GDBusProxyClass SnItemInterfaceProxyClass;

#define TYPE_TRAY_ITEM (tray_item_get_type ())
#define TRAY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRAY_ITEM, TrayItem))
#define TRAY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRAY_ITEM, TrayItemClass))
#define IS_TRAY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRAY_ITEM))
#define IS_TRAY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRAY_ITEM))
#define TRAY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRAY_ITEM, TrayItemClass))

typedef struct _TrayItem TrayItem;
typedef struct _TrayItemClass TrayItemClass;
typedef struct _TrayItemPrivate TrayItemPrivate;
enum  {
	TRAY_ITEM_0_PROPERTY,
	TRAY_ITEM_NUM_PROPERTIES
};
static GParamSpec* tray_item_properties[TRAY_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sn_icon_pixmap_free0(var) ((var == NULL) ? NULL : (var = (sn_icon_pixmap_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _SnItemPropertiesIface {
	GTypeInterface parent_iface;
	gchar* (*get_category) (SnItemProperties* self);
	gchar* (*get_id) (SnItemProperties* self);
	gchar* (*get_title) (SnItemProperties* self);
	gchar* (*get_status) (SnItemProperties* self);
	guint32 (*get_window_id) (SnItemProperties* self);
	gchar* (*get_icon_name) (SnItemProperties* self);
	SnIconPixmap* (*get_icon_pixmap) (SnItemProperties* self, gint* result_length1);
	gchar* (*get_overlay_icon_name) (SnItemProperties* self);
	SnIconPixmap* (*get_overlay_icon_pixmap) (SnItemProperties* self, gint* result_length1);
	gchar* (*get_attention_icon_name) (SnItemProperties* self);
	SnIconPixmap* (*get_attention_icon_pixmap) (SnItemProperties* self, gint* result_length1);
	gchar* (*get_attention_movie_name) (SnItemProperties* self);
	gchar* (*get_icon_theme_path) (SnItemProperties* self);
	GVariant* (*get_tool_tip) (SnItemProperties* self);
	gboolean (*get_item_is_menu) (SnItemProperties* self);
	char* (*get_menu) (SnItemProperties* self);
};

struct _SnItemInterfaceIface {
	GTypeInterface parent_iface;
	void (*context_menu) (SnItemInterface* self, gint x, gint y, GError** error);
	void (*activate) (SnItemInterface* self, gint x, gint y, GError** error);
	void (*secondary_activate) (SnItemInterface* self, gint x, gint y, GError** error);
	void (*scroll) (SnItemInterface* self, gint delta, const gchar* orientation, GError** error);
};

struct _TrayItem {
	GtkEventBox parent_instance;
	TrayItemPrivate * priv;
	gint target_icon_size;
};

struct _TrayItemClass {
	GtkEventBoxClass parent_class;
};

struct _TrayItemPrivate {
	SnItemInterface* dbus_item;
	SnItemProperties* dbus_properties;
	gchar* dbus_name;
	gchar* dbus_object_path;
	DBusMenu* context_menu;
	gchar* icon_theme_path;
	GtkImage* primary_icon;
	GtkImage* overlay_icon;
};

static GType sn_item_properties_type_id = 0;
static GType sn_item_interface_type_id = 0;
static gint TrayItem_private_offset;
static gpointer tray_item_parent_class = NULL;
static GType tray_item_type_id = 0;

static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static void _vala_SnIconPixmap_array_free (SnIconPixmap * array,
                                    gssize array_length);
static SnIconPixmap* _vala_array_dup2 (SnIconPixmap* self,
                                gssize length);
GType sn_item_properties_register_type (GTypeModule * module);
VALA_EXTERN GType sn_item_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType sn_item_properties_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sn_item_properties_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint sn_item_properties_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN gchar* sn_item_properties_get_category (SnItemProperties* self);
VALA_EXTERN gchar* sn_item_properties_get_id (SnItemProperties* self);
VALA_EXTERN gchar* sn_item_properties_get_title (SnItemProperties* self);
VALA_EXTERN gchar* sn_item_properties_get_status (SnItemProperties* self);
VALA_EXTERN guint32 sn_item_properties_get_window_id (SnItemProperties* self);
VALA_EXTERN gchar* sn_item_properties_get_icon_name (SnItemProperties* self);
VALA_EXTERN SnIconPixmap* sn_item_properties_get_icon_pixmap (SnItemProperties* self,
                                                  gint* result_length1);
VALA_EXTERN gchar* sn_item_properties_get_overlay_icon_name (SnItemProperties* self);
VALA_EXTERN SnIconPixmap* sn_item_properties_get_overlay_icon_pixmap (SnItemProperties* self,
                                                          gint* result_length1);
VALA_EXTERN gchar* sn_item_properties_get_attention_icon_name (SnItemProperties* self);
VALA_EXTERN SnIconPixmap* sn_item_properties_get_attention_icon_pixmap (SnItemProperties* self,
                                                            gint* result_length1);
VALA_EXTERN gchar* sn_item_properties_get_attention_movie_name (SnItemProperties* self);
VALA_EXTERN gchar* sn_item_properties_get_icon_theme_path (SnItemProperties* self);
VALA_EXTERN GVariant* sn_item_properties_get_tool_tip (SnItemProperties* self);
VALA_EXTERN gboolean sn_item_properties_get_item_is_menu (SnItemProperties* self);
VALA_EXTERN char* sn_item_properties_get_menu (SnItemProperties* self);
static void sn_item_properties_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static gchar* sn_item_properties_dbus_proxy_get_category (SnItemProperties* self);
static gchar* sn_item_properties_dbus_proxy_get_id (SnItemProperties* self);
static gchar* sn_item_properties_dbus_proxy_get_title (SnItemProperties* self);
static gchar* sn_item_properties_dbus_proxy_get_status (SnItemProperties* self);
static guint32 sn_item_properties_dbus_proxy_get_window_id (SnItemProperties* self);
static gchar* sn_item_properties_dbus_proxy_get_icon_name (SnItemProperties* self);
static SnIconPixmap* sn_item_properties_dbus_proxy_get_icon_pixmap (SnItemProperties* self,
                                                             gint* result_length1);
static gchar* sn_item_properties_dbus_proxy_get_overlay_icon_name (SnItemProperties* self);
static SnIconPixmap* sn_item_properties_dbus_proxy_get_overlay_icon_pixmap (SnItemProperties* self,
                                                                     gint* result_length1);
static gchar* sn_item_properties_dbus_proxy_get_attention_icon_name (SnItemProperties* self);
static SnIconPixmap* sn_item_properties_dbus_proxy_get_attention_icon_pixmap (SnItemProperties* self,
                                                                       gint* result_length1);
static gchar* sn_item_properties_dbus_proxy_get_attention_movie_name (SnItemProperties* self);
static gchar* sn_item_properties_dbus_proxy_get_icon_theme_path (SnItemProperties* self);
static GVariant* sn_item_properties_dbus_proxy_get_tool_tip (SnItemProperties* self);
static gboolean sn_item_properties_dbus_proxy_get_item_is_menu (SnItemProperties* self);
static char* sn_item_properties_dbus_proxy_get_menu (SnItemProperties* self);
static void sn_item_properties_proxy_sn_item_properties_interface_init (SnItemPropertiesIface* iface);
static void sn_item_properties_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* sn_item_properties_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_sn_item_properties_get_category (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_id (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_title (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_status (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_window_id (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_icon_name (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_icon_pixmap (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_overlay_icon_name (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_overlay_icon_pixmap (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_attention_icon_name (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_attention_icon_pixmap (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_attention_movie_name (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_icon_theme_path (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_tool_tip (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_item_is_menu (SnItemProperties* self);
static GVariant* _dbus_sn_item_properties_get_menu (SnItemProperties* self);
static gboolean sn_item_properties_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _sn_item_properties_unregister_object (gpointer user_data);
VALA_EXTERN GType sn_item_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sn_item_interface_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint sn_item_interface_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
GType sn_item_interface_register_type (GTypeModule * module);
VALA_EXTERN GType sn_item_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sn_item_interface_context_menu (SnItemInterface* self,
                                     gint x,
                                     gint y,
                                     GError** error);
VALA_EXTERN void sn_item_interface_activate (SnItemInterface* self,
                                 gint x,
                                 gint y,
                                 GError** error);
VALA_EXTERN void sn_item_interface_secondary_activate (SnItemInterface* self,
                                           gint x,
                                           gint y,
                                           GError** error);
VALA_EXTERN void sn_item_interface_scroll (SnItemInterface* self,
                               gint delta,
                               const gchar* orientation,
                               GError** error);
static void sn_item_interface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_title (SnItemInterface* self,
                                               GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_icon (SnItemInterface* self,
                                              GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_icon_theme_path (SnItemInterface* self,
                                                         GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_attention_icon (SnItemInterface* self,
                                                        GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_overlay_icon (SnItemInterface* self,
                                                      GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_tool_tip (SnItemInterface* self,
                                                  GVariant* parameters);
static void _dbus_handle_sn_item_interface_new_status (SnItemInterface* self,
                                                GVariant* parameters);
static void sn_item_interface_proxy_context_menu (SnItemInterface* self,
                                           gint x,
                                           gint y,
                                           GError** error);
static void sn_item_interface_proxy_activate (SnItemInterface* self,
                                       gint x,
                                       gint y,
                                       GError** error);
static void sn_item_interface_proxy_secondary_activate (SnItemInterface* self,
                                                 gint x,
                                                 gint y,
                                                 GError** error);
static void sn_item_interface_proxy_scroll (SnItemInterface* self,
                                     gint delta,
                                     const gchar* orientation,
                                     GError** error);
static void sn_item_interface_proxy_sn_item_interface_interface_init (SnItemInterfaceIface* iface);
static void _dbus_sn_item_interface_context_menu (SnItemInterface* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_sn_item_interface_activate (SnItemInterface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_sn_item_interface_secondary_activate (SnItemInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_sn_item_interface_scroll (SnItemInterface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void sn_item_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* sn_item_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean sn_item_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_sn_item_interface_new_title (GObject* _sender,
                                        gpointer* _data);
static void _dbus_sn_item_interface_new_icon (GObject* _sender,
                                       gpointer* _data);
static void _dbus_sn_item_interface_new_icon_theme_path (GObject* _sender,
                                                  const gchar* new_path,
                                                  gpointer* _data);
static void _dbus_sn_item_interface_new_attention_icon (GObject* _sender,
                                                 gpointer* _data);
static void _dbus_sn_item_interface_new_overlay_icon (GObject* _sender,
                                               gpointer* _data);
static void _dbus_sn_item_interface_new_tool_tip (GObject* _sender,
                                           gpointer* _data);
static void _dbus_sn_item_interface_new_status (GObject* _sender,
                                         const gchar* new_status,
                                         gpointer* _data);
static void _sn_item_interface_unregister_object (gpointer user_data);
GType tray_item_register_type (GTypeModule * module);
VALA_EXTERN GType tray_item_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TrayItem* tray_item_new (const gchar* dbus_name,
                         const gchar* dbus_object_path,
                         gint applet_size,
                         GError** error);
VALA_EXTERN TrayItem* tray_item_construct (GType object_type,
                               const gchar* dbus_name,
                               const gchar* dbus_object_path,
                               gint applet_size,
                               GError** error);
static void tray_item_reset_icon_theme (TrayItem* self,
                                 const gchar* new_path);
VALA_EXTERN void tray_item_resize (TrayItem* self,
                       gint applet_size);
static void tray_item_reset_tooltip (TrayItem* self);
static void __lambda16_ (TrayItem* self);
static void tray_item_update_dbus_properties (TrayItem* self);
static void tray_item_reset_icon (TrayItem* self,
                           const gchar* status);
static void ___lambda16__sn_item_interface_new_icon (SnItemInterface* _sender,
                                              gpointer self);
static void __lambda17_ (TrayItem* self);
static void ___lambda17__sn_item_interface_new_attention_icon (SnItemInterface* _sender,
                                                        gpointer self);
static void __lambda18_ (TrayItem* self,
                  const gchar* new_path);
static void ___lambda18__sn_item_interface_new_icon_theme_path (SnItemInterface* _sender,
                                                         const gchar* new_path,
                                                         gpointer self);
static void __lambda19_ (TrayItem* self,
                  const gchar* new_status);
static void ___lambda19__sn_item_interface_new_status (SnItemInterface* _sender,
                                                const gchar* new_status,
                                                gpointer self);
static void __lambda20_ (TrayItem* self);
static void ___lambda20__sn_item_interface_new_tool_tip (SnItemInterface* _sender,
                                                  gpointer self);
static void tray_item_update_icon (TrayItem* self,
                            GtkImage* icon,
                            const gchar* icon_name,
                            SnIconPixmap* icon_pixmaps,
                            gint icon_pixmaps_length1,
                            const gchar* fallback_icon_name);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
static void _g_free_gdk_pixbuf_destroy_notify (guint8* pixels,
                                        gpointer self);
static gboolean tray_item_real_button_release_event (GtkWidget* base,
                                              GdkEventButton* event);
static void tray_item_secondary_activate (TrayItem* self,
                                   GdkEventButton* event);
static void tray_item_show_context_menu (TrayItem* self,
                                  GdkEventButton* event);
static void tray_item_primary_activate (TrayItem* self,
                                 GdkEventButton* event);
static gboolean tray_item_real_scroll_event (GtkWidget* base,
                                      GdkEventScroll* event);
static void tray_item_send_scroll_event (TrayItem* self,
                                  gint delta,
                                  const gchar* orientation);
static void tray_item_finalize (GObject * obj);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusMethodInfo * const _sn_item_properties_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _sn_item_properties_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_category = {-1, "Category", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_id = {-1, "Id", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_title = {-1, "Title", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_status = {-1, "Status", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_window_id = {-1, "WindowId", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_icon_name = {-1, "IconName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_icon_pixmap = {-1, "IconPixmap", "a(iiay)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_overlay_icon_name = {-1, "OverlayIconName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_overlay_icon_pixmap = {-1, "OverlayIconPixmap", "a(iiay)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_attention_icon_name = {-1, "AttentionIconName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_attention_icon_pixmap = {-1, "AttentionIconPixmap", "a(iiay)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_attention_movie_name = {-1, "AttentionMovieName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_icon_theme_path = {-1, "IconThemePath", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_tool_tip = {-1, "ToolTip", "(sa(iiay)ss)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_item_is_menu = {-1, "ItemIsMenu", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _sn_item_properties_dbus_property_info_menu = {-1, "Menu", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _sn_item_properties_dbus_property_info[] = {&_sn_item_properties_dbus_property_info_category, &_sn_item_properties_dbus_property_info_id, &_sn_item_properties_dbus_property_info_title, &_sn_item_properties_dbus_property_info_status, &_sn_item_properties_dbus_property_info_window_id, &_sn_item_properties_dbus_property_info_icon_name, &_sn_item_properties_dbus_property_info_icon_pixmap, &_sn_item_properties_dbus_property_info_overlay_icon_name, &_sn_item_properties_dbus_property_info_overlay_icon_pixmap, &_sn_item_properties_dbus_property_info_attention_icon_name, &_sn_item_properties_dbus_property_info_attention_icon_pixmap, &_sn_item_properties_dbus_property_info_attention_movie_name, &_sn_item_properties_dbus_property_info_icon_theme_path, &_sn_item_properties_dbus_property_info_tool_tip, &_sn_item_properties_dbus_property_info_item_is_menu, &_sn_item_properties_dbus_property_info_menu, NULL};
static const GDBusInterfaceInfo _sn_item_properties_dbus_interface_info = {-1, "org.kde.StatusNotifierItem", (GDBusMethodInfo **) (&_sn_item_properties_dbus_method_info), (GDBusSignalInfo **) (&_sn_item_properties_dbus_signal_info), (GDBusPropertyInfo **) (&_sn_item_properties_dbus_property_info), NULL};
static const GDBusInterfaceVTable _sn_item_properties_dbus_interface_vtable = {sn_item_properties_dbus_interface_method_call, sn_item_properties_dbus_interface_get_property, sn_item_properties_dbus_interface_set_property};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_context_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_context_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_context_menu_in[] = {&_sn_item_interface_dbus_arg_info_context_menu_x, &_sn_item_interface_dbus_arg_info_context_menu_y, NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_context_menu_out[] = {NULL};
static const GDBusMethodInfo _sn_item_interface_dbus_method_info_context_menu = {-1, "ContextMenu", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_context_menu_in), (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_context_menu_out), NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_activate_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_activate_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_activate_in[] = {&_sn_item_interface_dbus_arg_info_activate_x, &_sn_item_interface_dbus_arg_info_activate_y, NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_activate_out[] = {NULL};
static const GDBusMethodInfo _sn_item_interface_dbus_method_info_activate = {-1, "Activate", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_activate_in), (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_activate_out), NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_secondary_activate_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_secondary_activate_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_secondary_activate_in[] = {&_sn_item_interface_dbus_arg_info_secondary_activate_x, &_sn_item_interface_dbus_arg_info_secondary_activate_y, NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_secondary_activate_out[] = {NULL};
static const GDBusMethodInfo _sn_item_interface_dbus_method_info_secondary_activate = {-1, "SecondaryActivate", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_secondary_activate_in), (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_secondary_activate_out), NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_scroll_delta = {-1, "delta", "i", NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_scroll_orientation = {-1, "orientation", "s", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_scroll_in[] = {&_sn_item_interface_dbus_arg_info_scroll_delta, &_sn_item_interface_dbus_arg_info_scroll_orientation, NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_scroll_out[] = {NULL};
static const GDBusMethodInfo _sn_item_interface_dbus_method_info_scroll = {-1, "Scroll", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_scroll_in), (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_scroll_out), NULL};
static const GDBusMethodInfo * const _sn_item_interface_dbus_method_info[] = {&_sn_item_interface_dbus_method_info_context_menu, &_sn_item_interface_dbus_method_info_activate, &_sn_item_interface_dbus_method_info_secondary_activate, &_sn_item_interface_dbus_method_info_scroll, NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_title[] = {NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_title = {-1, "NewTitle", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_title), NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_icon[] = {NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_icon = {-1, "NewIcon", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_icon), NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_new_icon_theme_path_new_path = {-1, "new_path", "s", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_icon_theme_path[] = {&_sn_item_interface_dbus_arg_info_new_icon_theme_path_new_path, NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_icon_theme_path = {-1, "NewIconThemePath", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_icon_theme_path), NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_attention_icon[] = {NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_attention_icon = {-1, "NewAttentionIcon", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_attention_icon), NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_overlay_icon[] = {NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_overlay_icon = {-1, "NewOverlayIcon", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_overlay_icon), NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_tool_tip[] = {NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_tool_tip = {-1, "NewToolTip", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_tool_tip), NULL};
static const GDBusArgInfo _sn_item_interface_dbus_arg_info_new_status_new_status = {-1, "new_status", "s", NULL};
static const GDBusArgInfo * const _sn_item_interface_dbus_arg_info_new_status[] = {&_sn_item_interface_dbus_arg_info_new_status_new_status, NULL};
static const GDBusSignalInfo _sn_item_interface_dbus_signal_info_new_status = {-1, "NewStatus", (GDBusArgInfo **) (&_sn_item_interface_dbus_arg_info_new_status), NULL};
static const GDBusSignalInfo * const _sn_item_interface_dbus_signal_info[] = {&_sn_item_interface_dbus_signal_info_new_title, &_sn_item_interface_dbus_signal_info_new_icon, &_sn_item_interface_dbus_signal_info_new_icon_theme_path, &_sn_item_interface_dbus_signal_info_new_attention_icon, &_sn_item_interface_dbus_signal_info_new_overlay_icon, &_sn_item_interface_dbus_signal_info_new_tool_tip, &_sn_item_interface_dbus_signal_info_new_status, NULL};
static const GDBusPropertyInfo * const _sn_item_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _sn_item_interface_dbus_interface_info = {-1, "org.kde.StatusNotifierItem", (GDBusMethodInfo **) (&_sn_item_interface_dbus_method_info), (GDBusSignalInfo **) (&_sn_item_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_sn_item_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _sn_item_interface_dbus_interface_vtable = {sn_item_interface_dbus_interface_method_call, sn_item_interface_dbus_interface_get_property, sn_item_interface_dbus_interface_set_property};

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
sn_icon_pixmap_copy (const SnIconPixmap* self,
                     SnIconPixmap* dest)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
	_tmp0_ = (*self).data;
	_tmp0__length1 = (*self).data_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp1_;
	(*dest).data_length1 = _tmp1__length1;
}

void
sn_icon_pixmap_destroy (SnIconPixmap* self)
{
	(*self).data = (g_free ((*self).data), NULL);
}

SnIconPixmap*
sn_icon_pixmap_dup (const SnIconPixmap* self)
{
	SnIconPixmap* dup;
	dup = g_new0 (SnIconPixmap, 1);
	sn_icon_pixmap_copy (self, dup);
	return dup;
}

void
sn_icon_pixmap_free (SnIconPixmap* self)
{
	sn_icon_pixmap_destroy (self);
	g_free (self);
}

static GType
sn_icon_pixmap_get_type_once (void)
{
	GType sn_icon_pixmap_type_id;
	sn_icon_pixmap_type_id = g_boxed_type_register_static ("SnIconPixmap", (GBoxedCopyFunc) sn_icon_pixmap_dup, (GBoxedFreeFunc) sn_icon_pixmap_free);
	return sn_icon_pixmap_type_id;
}

GType
sn_icon_pixmap_get_type (void)
{
	static volatile gsize sn_icon_pixmap_type_id__once = 0;
	if (g_once_init_enter (&sn_icon_pixmap_type_id__once)) {
		GType sn_icon_pixmap_type_id;
		sn_icon_pixmap_type_id = sn_icon_pixmap_get_type_once ();
		g_once_init_leave (&sn_icon_pixmap_type_id__once, sn_icon_pixmap_type_id);
	}
	return sn_icon_pixmap_type_id__once;
}

static void
_vala_SnIconPixmap_array_free (SnIconPixmap * array,
                               gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			sn_icon_pixmap_destroy (&array[i]);
		}
	}
	g_free (array);
}

static SnIconPixmap*
_vala_array_dup2 (SnIconPixmap* self,
                  gssize length)
{
	if (length > 0) {
		SnIconPixmap* result;
		gssize i;
		result = g_new0 (SnIconPixmap, length);
		for (i = 0; i < length; i++) {
			SnIconPixmap _tmp0_;
			SnIconPixmap _tmp1_ = {0};
			_tmp0_ = self[i];
			sn_icon_pixmap_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

void
sn_tool_tip_copy (const SnToolTip* self,
                  SnToolTip* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SnIconPixmap* _tmp2_;
	gint _tmp2__length1;
	SnIconPixmap* _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).icon_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).icon_name);
	(*dest).icon_name = _tmp1_;
	_tmp2_ = (*self).icon_data;
	_tmp2__length1 = (*self).icon_data_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).icon_data = (_vala_SnIconPixmap_array_free ((*dest).icon_data, (*dest).icon_data_length1), NULL);
	(*dest).icon_data = _tmp3_;
	(*dest).icon_data_length1 = _tmp3__length1;
	_tmp4_ = (*self).title;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp5_;
	_tmp6_ = (*self).markup;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).markup);
	(*dest).markup = _tmp7_;
}

void
sn_tool_tip_destroy (SnToolTip* self)
{
	_g_free0 ((*self).icon_name);
	(*self).icon_data = (_vala_SnIconPixmap_array_free ((*self).icon_data, (*self).icon_data_length1), NULL);
	_g_free0 ((*self).title);
	_g_free0 ((*self).markup);
}

SnToolTip*
sn_tool_tip_dup (const SnToolTip* self)
{
	SnToolTip* dup;
	dup = g_new0 (SnToolTip, 1);
	sn_tool_tip_copy (self, dup);
	return dup;
}

void
sn_tool_tip_free (SnToolTip* self)
{
	sn_tool_tip_destroy (self);
	g_free (self);
}

static GType
sn_tool_tip_get_type_once (void)
{
	GType sn_tool_tip_type_id;
	sn_tool_tip_type_id = g_boxed_type_register_static ("SnToolTip", (GBoxedCopyFunc) sn_tool_tip_dup, (GBoxedFreeFunc) sn_tool_tip_free);
	return sn_tool_tip_type_id;
}

GType
sn_tool_tip_get_type (void)
{
	static volatile gsize sn_tool_tip_type_id__once = 0;
	if (g_once_init_enter (&sn_tool_tip_type_id__once)) {
		GType sn_tool_tip_type_id;
		sn_tool_tip_type_id = sn_tool_tip_get_type_once ();
		g_once_init_leave (&sn_tool_tip_type_id__once, sn_tool_tip_type_id);
	}
	return sn_tool_tip_type_id__once;
}

gchar*
sn_item_properties_get_category (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_category) {
		return _iface_->get_category (self);
	}
	return NULL;
}

gchar*
sn_item_properties_get_id (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_id) {
		return _iface_->get_id (self);
	}
	return NULL;
}

gchar*
sn_item_properties_get_title (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_title) {
		return _iface_->get_title (self);
	}
	return NULL;
}

gchar*
sn_item_properties_get_status (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_status) {
		return _iface_->get_status (self);
	}
	return NULL;
}

guint32
sn_item_properties_get_window_id (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_window_id) {
		return _iface_->get_window_id (self);
	}
	return 0U;
}

gchar*
sn_item_properties_get_icon_name (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_icon_name) {
		return _iface_->get_icon_name (self);
	}
	return NULL;
}

SnIconPixmap*
sn_item_properties_get_icon_pixmap (SnItemProperties* self,
                                    gint* result_length1)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_icon_pixmap) {
		return _iface_->get_icon_pixmap (self, result_length1);
	}
	return NULL;
}

gchar*
sn_item_properties_get_overlay_icon_name (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_overlay_icon_name) {
		return _iface_->get_overlay_icon_name (self);
	}
	return NULL;
}

SnIconPixmap*
sn_item_properties_get_overlay_icon_pixmap (SnItemProperties* self,
                                            gint* result_length1)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_overlay_icon_pixmap) {
		return _iface_->get_overlay_icon_pixmap (self, result_length1);
	}
	return NULL;
}

gchar*
sn_item_properties_get_attention_icon_name (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_attention_icon_name) {
		return _iface_->get_attention_icon_name (self);
	}
	return NULL;
}

SnIconPixmap*
sn_item_properties_get_attention_icon_pixmap (SnItemProperties* self,
                                              gint* result_length1)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_attention_icon_pixmap) {
		return _iface_->get_attention_icon_pixmap (self, result_length1);
	}
	return NULL;
}

gchar*
sn_item_properties_get_attention_movie_name (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_attention_movie_name) {
		return _iface_->get_attention_movie_name (self);
	}
	return NULL;
}

gchar*
sn_item_properties_get_icon_theme_path (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_icon_theme_path) {
		return _iface_->get_icon_theme_path (self);
	}
	return NULL;
}

GVariant*
sn_item_properties_get_tool_tip (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_tool_tip) {
		return _iface_->get_tool_tip (self);
	}
	return NULL;
}

gboolean
sn_item_properties_get_item_is_menu (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_item_is_menu) {
		return _iface_->get_item_is_menu (self);
	}
	return FALSE;
}

char*
sn_item_properties_get_menu (SnItemProperties* self)
{
	SnItemPropertiesIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SN_ITEM_PROPERTIES_GET_INTERFACE (self);
	if (_iface_->get_menu) {
		return _iface_->get_menu (self);
	}
	return NULL;
}

static void
sn_item_properties_default_init (SnItemPropertiesIface * iface,
                                 gpointer iface_data)
{
}

GType
sn_item_properties_get_type (void)
{
	return sn_item_properties_type_id;
}

GType
sn_item_properties_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnItemPropertiesIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sn_item_properties_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	sn_item_properties_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SnItemProperties", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sn_item_properties_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (sn_item_properties_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) sn_item_properties_proxy_get_type);
	g_type_set_qdata (sn_item_properties_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.kde.StatusNotifierItem");
	g_type_set_qdata (sn_item_properties_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_sn_item_properties_dbus_interface_info));
	g_type_set_qdata (sn_item_properties_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) sn_item_properties_register_object);
	return sn_item_properties_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SnItemPropertiesProxy, sn_item_properties_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SN_ITEM_PROPERTIES, sn_item_properties_proxy_sn_item_properties_interface_init) )
static void
sn_item_properties_proxy_class_init (SnItemPropertiesProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = sn_item_properties_proxy_g_signal;
}

static void
sn_item_properties_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
sn_item_properties_proxy_class_finalize (SnItemPropertiesProxyClass* klass)
{
}

void
sn_item_properties_proxy_register_dynamic_type (GTypeModule* module)
{
	sn_item_properties_proxy_register_type (module);
}

static void
sn_item_properties_proxy_init (SnItemPropertiesProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_sn_item_properties_dbus_interface_info));
}

static gchar*
sn_item_properties_dbus_proxy_get_category (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Category");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Category"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_id (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Id");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Id"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_title (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Title");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Title"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_status (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Status");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Status"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint32
sn_item_properties_dbus_proxy_get_window_id (SnItemProperties* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "WindowId");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("WindowId"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp105_ = 0U;
			return _tmp105_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_icon_name (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IconName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IconName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static SnIconPixmap*
sn_item_properties_dbus_proxy_get_icon_pixmap (SnItemProperties* self,
                                               gint* result_length1)
{
	GVariant *_inner_reply;
	SnIconPixmap* _result;
	gint _result_length1;
	SnIconPixmap* _tmp106_;
	gint _tmp106__length;
	gint _tmp106__size;
	gint _tmp106__length1;
	GVariantIter _tmp107_;
	GVariant* _tmp108_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IconPixmap");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IconPixmap"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp106_ = g_new (SnIconPixmap, 5);
	_tmp106__length = 0;
	_tmp106__size = 4;
	_tmp106__length1 = 0;
	g_variant_iter_init (&_tmp107_, _inner_reply);
	for (; (_tmp108_ = g_variant_iter_next_value (&_tmp107_)) != NULL; _tmp106__length1++) {
		SnIconPixmap _tmp109_;
		GVariantIter _tmp110_;
		GVariant* _tmp111_;
		GVariant* _tmp112_;
		GVariant* _tmp113_;
		gsize _tmp114__length;
		guint8* _tmp114_;
		if (_tmp106__size == _tmp106__length) {
			_tmp106__size = 2 * _tmp106__size;
			_tmp106_ = g_renew (SnIconPixmap, _tmp106_, _tmp106__size + 1);
		}
		g_variant_iter_init (&_tmp110_, _tmp108_);
		_tmp111_ = g_variant_iter_next_value (&_tmp110_);
		_tmp109_.width = g_variant_get_int32 (_tmp111_);
		g_variant_unref (_tmp111_);
		_tmp112_ = g_variant_iter_next_value (&_tmp110_);
		_tmp109_.height = g_variant_get_int32 (_tmp112_);
		g_variant_unref (_tmp112_);
		_tmp113_ = g_variant_iter_next_value (&_tmp110_);
		_tmp114__length = g_variant_get_size (_tmp113_);
		_tmp114_ = _vala_memdup2 (g_variant_get_data (_tmp113_), _tmp114__length);
		_tmp109_.data_length1 = _tmp114__length;
		_tmp109_.data = _tmp114_;
		g_variant_unref (_tmp113_);
		_tmp106_[_tmp106__length++] = _tmp109_;
		g_variant_unref (_tmp108_);
	}
	_result_length1 = _tmp106__length1;
	_result = _tmp106_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_overlay_icon_name (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "OverlayIconName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("OverlayIconName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static SnIconPixmap*
sn_item_properties_dbus_proxy_get_overlay_icon_pixmap (SnItemProperties* self,
                                                       gint* result_length1)
{
	GVariant *_inner_reply;
	SnIconPixmap* _result;
	gint _result_length1;
	SnIconPixmap* _tmp115_;
	gint _tmp115__length;
	gint _tmp115__size;
	gint _tmp115__length1;
	GVariantIter _tmp116_;
	GVariant* _tmp117_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "OverlayIconPixmap");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("OverlayIconPixmap"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp115_ = g_new (SnIconPixmap, 5);
	_tmp115__length = 0;
	_tmp115__size = 4;
	_tmp115__length1 = 0;
	g_variant_iter_init (&_tmp116_, _inner_reply);
	for (; (_tmp117_ = g_variant_iter_next_value (&_tmp116_)) != NULL; _tmp115__length1++) {
		SnIconPixmap _tmp118_;
		GVariantIter _tmp119_;
		GVariant* _tmp120_;
		GVariant* _tmp121_;
		GVariant* _tmp122_;
		gsize _tmp123__length;
		guint8* _tmp123_;
		if (_tmp115__size == _tmp115__length) {
			_tmp115__size = 2 * _tmp115__size;
			_tmp115_ = g_renew (SnIconPixmap, _tmp115_, _tmp115__size + 1);
		}
		g_variant_iter_init (&_tmp119_, _tmp117_);
		_tmp120_ = g_variant_iter_next_value (&_tmp119_);
		_tmp118_.width = g_variant_get_int32 (_tmp120_);
		g_variant_unref (_tmp120_);
		_tmp121_ = g_variant_iter_next_value (&_tmp119_);
		_tmp118_.height = g_variant_get_int32 (_tmp121_);
		g_variant_unref (_tmp121_);
		_tmp122_ = g_variant_iter_next_value (&_tmp119_);
		_tmp123__length = g_variant_get_size (_tmp122_);
		_tmp123_ = _vala_memdup2 (g_variant_get_data (_tmp122_), _tmp123__length);
		_tmp118_.data_length1 = _tmp123__length;
		_tmp118_.data = _tmp123_;
		g_variant_unref (_tmp122_);
		_tmp115_[_tmp115__length++] = _tmp118_;
		g_variant_unref (_tmp117_);
	}
	_result_length1 = _tmp115__length1;
	_result = _tmp115_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_attention_icon_name (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AttentionIconName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AttentionIconName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static SnIconPixmap*
sn_item_properties_dbus_proxy_get_attention_icon_pixmap (SnItemProperties* self,
                                                         gint* result_length1)
{
	GVariant *_inner_reply;
	SnIconPixmap* _result;
	gint _result_length1;
	SnIconPixmap* _tmp124_;
	gint _tmp124__length;
	gint _tmp124__size;
	gint _tmp124__length1;
	GVariantIter _tmp125_;
	GVariant* _tmp126_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AttentionIconPixmap");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AttentionIconPixmap"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp124_ = g_new (SnIconPixmap, 5);
	_tmp124__length = 0;
	_tmp124__size = 4;
	_tmp124__length1 = 0;
	g_variant_iter_init (&_tmp125_, _inner_reply);
	for (; (_tmp126_ = g_variant_iter_next_value (&_tmp125_)) != NULL; _tmp124__length1++) {
		SnIconPixmap _tmp127_;
		GVariantIter _tmp128_;
		GVariant* _tmp129_;
		GVariant* _tmp130_;
		GVariant* _tmp131_;
		gsize _tmp132__length;
		guint8* _tmp132_;
		if (_tmp124__size == _tmp124__length) {
			_tmp124__size = 2 * _tmp124__size;
			_tmp124_ = g_renew (SnIconPixmap, _tmp124_, _tmp124__size + 1);
		}
		g_variant_iter_init (&_tmp128_, _tmp126_);
		_tmp129_ = g_variant_iter_next_value (&_tmp128_);
		_tmp127_.width = g_variant_get_int32 (_tmp129_);
		g_variant_unref (_tmp129_);
		_tmp130_ = g_variant_iter_next_value (&_tmp128_);
		_tmp127_.height = g_variant_get_int32 (_tmp130_);
		g_variant_unref (_tmp130_);
		_tmp131_ = g_variant_iter_next_value (&_tmp128_);
		_tmp132__length = g_variant_get_size (_tmp131_);
		_tmp132_ = _vala_memdup2 (g_variant_get_data (_tmp131_), _tmp132__length);
		_tmp127_.data_length1 = _tmp132__length;
		_tmp127_.data = _tmp132_;
		g_variant_unref (_tmp131_);
		_tmp124_[_tmp124__length++] = _tmp127_;
		g_variant_unref (_tmp126_);
	}
	_result_length1 = _tmp124__length1;
	_result = _tmp124_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_attention_movie_name (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AttentionMovieName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AttentionMovieName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
sn_item_properties_dbus_proxy_get_icon_theme_path (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "IconThemePath");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("IconThemePath"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static GVariant*
sn_item_properties_dbus_proxy_get_tool_tip (SnItemProperties* self)
{
	GVariant *_inner_reply;
	GVariant* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ToolTip");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ToolTip"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = _inner_reply;
	return _result;
}

static gboolean
sn_item_properties_dbus_proxy_get_item_is_menu (SnItemProperties* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ItemIsMenu");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ItemIsMenu"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp133_ = FALSE;
			return _tmp133_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
sn_item_properties_dbus_proxy_get_menu (SnItemProperties* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Menu");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.kde.StatusNotifierItem"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Menu"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
sn_item_properties_proxy_sn_item_properties_interface_init (SnItemPropertiesIface* iface)
{
	iface->get_category = sn_item_properties_dbus_proxy_get_category;
	iface->get_id = sn_item_properties_dbus_proxy_get_id;
	iface->get_title = sn_item_properties_dbus_proxy_get_title;
	iface->get_status = sn_item_properties_dbus_proxy_get_status;
	iface->get_window_id = sn_item_properties_dbus_proxy_get_window_id;
	iface->get_icon_name = sn_item_properties_dbus_proxy_get_icon_name;
	iface->get_icon_pixmap = sn_item_properties_dbus_proxy_get_icon_pixmap;
	iface->get_overlay_icon_name = sn_item_properties_dbus_proxy_get_overlay_icon_name;
	iface->get_overlay_icon_pixmap = sn_item_properties_dbus_proxy_get_overlay_icon_pixmap;
	iface->get_attention_icon_name = sn_item_properties_dbus_proxy_get_attention_icon_name;
	iface->get_attention_icon_pixmap = sn_item_properties_dbus_proxy_get_attention_icon_pixmap;
	iface->get_attention_movie_name = sn_item_properties_dbus_proxy_get_attention_movie_name;
	iface->get_icon_theme_path = sn_item_properties_dbus_proxy_get_icon_theme_path;
	iface->get_tool_tip = sn_item_properties_dbus_proxy_get_tool_tip;
	iface->get_item_is_menu = sn_item_properties_dbus_proxy_get_item_is_menu;
	iface->get_menu = sn_item_properties_dbus_proxy_get_menu;
}

static void
sn_item_properties_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_sn_item_properties_get_category (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_category (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_id (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_id (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_title (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_title (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_status (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_status (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_window_id (SnItemProperties* self)
{
	guint32 result;
	GVariant* _reply;
	result = sn_item_properties_get_window_id (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_icon_name (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_icon_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_icon_pixmap (SnItemProperties* self)
{
	SnIconPixmap* result;
	gint result_length1 = 0;
	GVariant* _reply;
	SnIconPixmap* _tmp134_;
	GVariantBuilder _tmp135_;
	gint _tmp136_;
	result = sn_item_properties_get_icon_pixmap (self, &result_length1);
	_tmp134_ = result;
	g_variant_builder_init (&_tmp135_, G_VARIANT_TYPE ("a(iiay)"));
	for (_tmp136_ = 0; _tmp136_ < result_length1; _tmp136_++) {
		GVariantBuilder _tmp137_;
		guint8* _tmp138_;
		g_variant_builder_init (&_tmp137_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp137_, g_variant_new_int32 ((*_tmp134_).width));
		g_variant_builder_add_value (&_tmp137_, g_variant_new_int32 ((*_tmp134_).height));
		_tmp138_ = _vala_memdup2 ((*_tmp134_).data, (*_tmp134_).data_length1);
		g_variant_builder_add_value (&_tmp137_, g_variant_new_from_data (G_VARIANT_TYPE ("ay"), _tmp138_, (*_tmp134_).data_length1, TRUE, g_free, _tmp138_));
		g_variant_builder_add_value (&_tmp135_, g_variant_builder_end (&_tmp137_));
		_tmp134_++;
	}
	_reply = g_variant_builder_end (&_tmp135_);
	result = (_vala_SnIconPixmap_array_free (result, result_length1), NULL);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_overlay_icon_name (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_overlay_icon_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_overlay_icon_pixmap (SnItemProperties* self)
{
	SnIconPixmap* result;
	gint result_length1 = 0;
	GVariant* _reply;
	SnIconPixmap* _tmp139_;
	GVariantBuilder _tmp140_;
	gint _tmp141_;
	result = sn_item_properties_get_overlay_icon_pixmap (self, &result_length1);
	_tmp139_ = result;
	g_variant_builder_init (&_tmp140_, G_VARIANT_TYPE ("a(iiay)"));
	for (_tmp141_ = 0; _tmp141_ < result_length1; _tmp141_++) {
		GVariantBuilder _tmp142_;
		guint8* _tmp143_;
		g_variant_builder_init (&_tmp142_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp142_, g_variant_new_int32 ((*_tmp139_).width));
		g_variant_builder_add_value (&_tmp142_, g_variant_new_int32 ((*_tmp139_).height));
		_tmp143_ = _vala_memdup2 ((*_tmp139_).data, (*_tmp139_).data_length1);
		g_variant_builder_add_value (&_tmp142_, g_variant_new_from_data (G_VARIANT_TYPE ("ay"), _tmp143_, (*_tmp139_).data_length1, TRUE, g_free, _tmp143_));
		g_variant_builder_add_value (&_tmp140_, g_variant_builder_end (&_tmp142_));
		_tmp139_++;
	}
	_reply = g_variant_builder_end (&_tmp140_);
	result = (_vala_SnIconPixmap_array_free (result, result_length1), NULL);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_attention_icon_name (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_attention_icon_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_attention_icon_pixmap (SnItemProperties* self)
{
	SnIconPixmap* result;
	gint result_length1 = 0;
	GVariant* _reply;
	SnIconPixmap* _tmp144_;
	GVariantBuilder _tmp145_;
	gint _tmp146_;
	result = sn_item_properties_get_attention_icon_pixmap (self, &result_length1);
	_tmp144_ = result;
	g_variant_builder_init (&_tmp145_, G_VARIANT_TYPE ("a(iiay)"));
	for (_tmp146_ = 0; _tmp146_ < result_length1; _tmp146_++) {
		GVariantBuilder _tmp147_;
		guint8* _tmp148_;
		g_variant_builder_init (&_tmp147_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp147_, g_variant_new_int32 ((*_tmp144_).width));
		g_variant_builder_add_value (&_tmp147_, g_variant_new_int32 ((*_tmp144_).height));
		_tmp148_ = _vala_memdup2 ((*_tmp144_).data, (*_tmp144_).data_length1);
		g_variant_builder_add_value (&_tmp147_, g_variant_new_from_data (G_VARIANT_TYPE ("ay"), _tmp148_, (*_tmp144_).data_length1, TRUE, g_free, _tmp148_));
		g_variant_builder_add_value (&_tmp145_, g_variant_builder_end (&_tmp147_));
		_tmp144_++;
	}
	_reply = g_variant_builder_end (&_tmp145_);
	result = (_vala_SnIconPixmap_array_free (result, result_length1), NULL);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_attention_movie_name (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_attention_movie_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_icon_theme_path (SnItemProperties* self)
{
	gchar* result;
	GVariant* _reply;
	result = sn_item_properties_get_icon_theme_path (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_tool_tip (SnItemProperties* self)
{
	GVariant* result;
	GVariant* _reply;
	result = sn_item_properties_get_tool_tip (self);
	_reply = result;
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_item_is_menu (SnItemProperties* self)
{
	gboolean result;
	GVariant* _reply;
	result = sn_item_properties_get_item_is_menu (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_sn_item_properties_get_menu (SnItemProperties* self)
{
	char* result;
	GVariant* _reply;
	result = sn_item_properties_get_menu (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
sn_item_properties_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Category") == 0) {
		return _dbus_sn_item_properties_get_category (object);
	} else if (strcmp (property_name, "Id") == 0) {
		return _dbus_sn_item_properties_get_id (object);
	} else if (strcmp (property_name, "Title") == 0) {
		return _dbus_sn_item_properties_get_title (object);
	} else if (strcmp (property_name, "Status") == 0) {
		return _dbus_sn_item_properties_get_status (object);
	} else if (strcmp (property_name, "WindowId") == 0) {
		return _dbus_sn_item_properties_get_window_id (object);
	} else if (strcmp (property_name, "IconName") == 0) {
		return _dbus_sn_item_properties_get_icon_name (object);
	} else if (strcmp (property_name, "IconPixmap") == 0) {
		return _dbus_sn_item_properties_get_icon_pixmap (object);
	} else if (strcmp (property_name, "OverlayIconName") == 0) {
		return _dbus_sn_item_properties_get_overlay_icon_name (object);
	} else if (strcmp (property_name, "OverlayIconPixmap") == 0) {
		return _dbus_sn_item_properties_get_overlay_icon_pixmap (object);
	} else if (strcmp (property_name, "AttentionIconName") == 0) {
		return _dbus_sn_item_properties_get_attention_icon_name (object);
	} else if (strcmp (property_name, "AttentionIconPixmap") == 0) {
		return _dbus_sn_item_properties_get_attention_icon_pixmap (object);
	} else if (strcmp (property_name, "AttentionMovieName") == 0) {
		return _dbus_sn_item_properties_get_attention_movie_name (object);
	} else if (strcmp (property_name, "IconThemePath") == 0) {
		return _dbus_sn_item_properties_get_icon_theme_path (object);
	} else if (strcmp (property_name, "ToolTip") == 0) {
		return _dbus_sn_item_properties_get_tool_tip (object);
	} else if (strcmp (property_name, "ItemIsMenu") == 0) {
		return _dbus_sn_item_properties_get_item_is_menu (object);
	} else if (strcmp (property_name, "Menu") == 0) {
		return _dbus_sn_item_properties_get_menu (object);
	}
	return NULL;
}

static gboolean
sn_item_properties_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
sn_item_properties_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_sn_item_properties_dbus_interface_info), &_sn_item_properties_dbus_interface_vtable, data, _sn_item_properties_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_sn_item_properties_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
sn_item_interface_context_menu (SnItemInterface* self,
                                gint x,
                                gint y,
                                GError** error)
{
	SnItemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SN_ITEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->context_menu) {
		_iface_->context_menu (self, x, y, error);
	}
}

void
sn_item_interface_activate (SnItemInterface* self,
                            gint x,
                            gint y,
                            GError** error)
{
	SnItemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SN_ITEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->activate) {
		_iface_->activate (self, x, y, error);
	}
}

void
sn_item_interface_secondary_activate (SnItemInterface* self,
                                      gint x,
                                      gint y,
                                      GError** error)
{
	SnItemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SN_ITEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->secondary_activate) {
		_iface_->secondary_activate (self, x, y, error);
	}
}

void
sn_item_interface_scroll (SnItemInterface* self,
                          gint delta,
                          const gchar* orientation,
                          GError** error)
{
	SnItemInterfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SN_ITEM_INTERFACE_GET_INTERFACE (self);
	if (_iface_->scroll) {
		_iface_->scroll (self, delta, orientation, error);
	}
}

static void
sn_item_interface_default_init (SnItemInterfaceIface * iface,
                                gpointer iface_data)
{
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_TITLE_SIGNAL] = g_signal_new ("new-title", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_ICON_SIGNAL] = g_signal_new ("new-icon", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_ICON_THEME_PATH_SIGNAL] = g_signal_new ("new-icon-theme-path", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_ATTENTION_ICON_SIGNAL] = g_signal_new ("new-attention-icon", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_OVERLAY_ICON_SIGNAL] = g_signal_new ("new-overlay-icon", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_TOOL_TIP_SIGNAL] = g_signal_new ("new-tool-tip", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sn_item_interface_signals[SN_ITEM_INTERFACE_NEW_STATUS_SIGNAL] = g_signal_new ("new-status", TYPE_SN_ITEM_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

GType
sn_item_interface_get_type (void)
{
	return sn_item_interface_type_id;
}

GType
sn_item_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnItemInterfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sn_item_interface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	sn_item_interface_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SnItemInterface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sn_item_interface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (sn_item_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) sn_item_interface_proxy_get_type);
	g_type_set_qdata (sn_item_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.kde.StatusNotifierItem");
	g_type_set_qdata (sn_item_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_sn_item_interface_dbus_interface_info));
	g_type_set_qdata (sn_item_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) sn_item_interface_register_object);
	return sn_item_interface_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SnItemInterfaceProxy, sn_item_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SN_ITEM_INTERFACE, sn_item_interface_proxy_sn_item_interface_interface_init) )
static void
sn_item_interface_proxy_class_init (SnItemInterfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = sn_item_interface_proxy_g_signal;
}

static void
_dbus_handle_sn_item_interface_new_title (SnItemInterface* self,
                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "new-title");
}

static void
_dbus_handle_sn_item_interface_new_icon (SnItemInterface* self,
                                         GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "new-icon");
}

static void
_dbus_handle_sn_item_interface_new_icon_theme_path (SnItemInterface* self,
                                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* new_path = NULL;
	GVariant* _tmp149_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp149_ = g_variant_iter_next_value (&_arguments_iter);
	new_path = g_variant_dup_string (_tmp149_, NULL);
	g_variant_unref (_tmp149_);
	g_signal_emit_by_name (self, "new-icon-theme-path", new_path);
	_g_free0 (new_path);
}

static void
_dbus_handle_sn_item_interface_new_attention_icon (SnItemInterface* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "new-attention-icon");
}

static void
_dbus_handle_sn_item_interface_new_overlay_icon (SnItemInterface* self,
                                                 GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "new-overlay-icon");
}

static void
_dbus_handle_sn_item_interface_new_tool_tip (SnItemInterface* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "new-tool-tip");
}

static void
_dbus_handle_sn_item_interface_new_status (SnItemInterface* self,
                                           GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* new_status = NULL;
	GVariant* _tmp150_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp150_ = g_variant_iter_next_value (&_arguments_iter);
	new_status = g_variant_dup_string (_tmp150_, NULL);
	g_variant_unref (_tmp150_);
	g_signal_emit_by_name (self, "new-status", new_status);
	_g_free0 (new_status);
}

static void
sn_item_interface_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "NewTitle") == 0) {
		_dbus_handle_sn_item_interface_new_title ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewIcon") == 0) {
		_dbus_handle_sn_item_interface_new_icon ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewIconThemePath") == 0) {
		_dbus_handle_sn_item_interface_new_icon_theme_path ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewAttentionIcon") == 0) {
		_dbus_handle_sn_item_interface_new_attention_icon ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewOverlayIcon") == 0) {
		_dbus_handle_sn_item_interface_new_overlay_icon ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewToolTip") == 0) {
		_dbus_handle_sn_item_interface_new_tool_tip ((SnItemInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "NewStatus") == 0) {
		_dbus_handle_sn_item_interface_new_status ((SnItemInterface*) proxy, parameters);
	}
}

static void
sn_item_interface_proxy_class_finalize (SnItemInterfaceProxyClass* klass)
{
}

void
sn_item_interface_proxy_register_dynamic_type (GTypeModule* module)
{
	sn_item_interface_proxy_register_type (module);
}

static void
sn_item_interface_proxy_init (SnItemInterfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_sn_item_interface_dbus_interface_info));
}

static void
sn_item_interface_proxy_context_menu (SnItemInterface* self,
                                      gint x,
                                      gint y,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.kde.StatusNotifierItem", "ContextMenu");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
sn_item_interface_proxy_activate (SnItemInterface* self,
                                  gint x,
                                  gint y,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.kde.StatusNotifierItem", "Activate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
sn_item_interface_proxy_secondary_activate (SnItemInterface* self,
                                            gint x,
                                            gint y,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.kde.StatusNotifierItem", "SecondaryActivate");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
sn_item_interface_proxy_scroll (SnItemInterface* self,
                                gint delta,
                                const gchar* orientation,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.kde.StatusNotifierItem", "Scroll");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (delta));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (orientation));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
sn_item_interface_proxy_sn_item_interface_interface_init (SnItemInterfaceIface* iface)
{
	iface->context_menu = sn_item_interface_proxy_context_menu;
	iface->activate = sn_item_interface_proxy_activate;
	iface->secondary_activate = sn_item_interface_proxy_secondary_activate;
	iface->scroll = sn_item_interface_proxy_scroll;
}

static void
_dbus_sn_item_interface_context_menu (SnItemInterface* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp151_;
	gint y = 0;
	GVariant* _tmp152_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp151_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp151_);
	g_variant_unref (_tmp151_);
	_tmp152_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp152_);
	g_variant_unref (_tmp152_);
	sn_item_interface_context_menu (self, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_sn_item_interface_activate (SnItemInterface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp153_;
	gint y = 0;
	GVariant* _tmp154_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp153_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp153_);
	g_variant_unref (_tmp153_);
	_tmp154_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp154_);
	g_variant_unref (_tmp154_);
	sn_item_interface_activate (self, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_sn_item_interface_secondary_activate (SnItemInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp155_;
	gint y = 0;
	GVariant* _tmp156_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp155_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp155_);
	g_variant_unref (_tmp155_);
	_tmp156_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp156_);
	g_variant_unref (_tmp156_);
	sn_item_interface_secondary_activate (self, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_sn_item_interface_scroll (SnItemInterface* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint delta = 0;
	GVariant* _tmp157_;
	gchar* orientation = NULL;
	GVariant* _tmp158_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp157_ = g_variant_iter_next_value (&_arguments_iter);
	delta = g_variant_get_int32 (_tmp157_);
	g_variant_unref (_tmp157_);
	_tmp158_ = g_variant_iter_next_value (&_arguments_iter);
	orientation = g_variant_dup_string (_tmp158_, NULL);
	g_variant_unref (_tmp158_);
	sn_item_interface_scroll (self, delta, orientation, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (orientation);
	;
}

static void
sn_item_interface_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ContextMenu") == 0) {
		_dbus_sn_item_interface_context_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "Activate") == 0) {
		_dbus_sn_item_interface_activate (object, parameters, invocation);
	} else if (strcmp (method_name, "SecondaryActivate") == 0) {
		_dbus_sn_item_interface_secondary_activate (object, parameters, invocation);
	} else if (strcmp (method_name, "Scroll") == 0) {
		_dbus_sn_item_interface_scroll (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
sn_item_interface_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
sn_item_interface_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_sn_item_interface_new_title (GObject* _sender,
                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewTitle", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_icon (GObject* _sender,
                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewIcon", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_icon_theme_path (GObject* _sender,
                                             const gchar* new_path,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewIconThemePath", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_attention_icon (GObject* _sender,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewAttentionIcon", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_overlay_icon (GObject* _sender,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewOverlayIcon", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_tool_tip (GObject* _sender,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewToolTip", _arguments, NULL);
}

static void
_dbus_sn_item_interface_new_status (GObject* _sender,
                                    const gchar* new_status,
                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_status));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.kde.StatusNotifierItem", "NewStatus", _arguments, NULL);
}

guint
sn_item_interface_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_sn_item_interface_dbus_interface_info), &_sn_item_interface_dbus_interface_vtable, data, _sn_item_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "new-title", (GCallback) _dbus_sn_item_interface_new_title, data);
	g_signal_connect (object, "new-icon", (GCallback) _dbus_sn_item_interface_new_icon, data);
	g_signal_connect (object, "new-icon-theme-path", (GCallback) _dbus_sn_item_interface_new_icon_theme_path, data);
	g_signal_connect (object, "new-attention-icon", (GCallback) _dbus_sn_item_interface_new_attention_icon, data);
	g_signal_connect (object, "new-overlay-icon", (GCallback) _dbus_sn_item_interface_new_overlay_icon, data);
	g_signal_connect (object, "new-tool-tip", (GCallback) _dbus_sn_item_interface_new_tool_tip, data);
	g_signal_connect (object, "new-status", (GCallback) _dbus_sn_item_interface_new_status, data);
	return result;
}

static void
_sn_item_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_title, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_icon, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_icon_theme_path, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_attention_icon, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_overlay_icon, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_tool_tip, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_sn_item_interface_new_status, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
tray_item_get_instance_private (TrayItem* self)
{
	return G_STRUCT_MEMBER_P (self, TrayItem_private_offset);
}

static void
__lambda16_ (TrayItem* self)
{
	tray_item_update_dbus_properties (self);
	tray_item_reset_icon (self, NULL);
}

static void
___lambda16__sn_item_interface_new_icon (SnItemInterface* _sender,
                                         gpointer self)
{
	__lambda16_ ((TrayItem*) self);
}

static void
__lambda17_ (TrayItem* self)
{
	tray_item_update_dbus_properties (self);
	tray_item_reset_icon (self, NULL);
}

static void
___lambda17__sn_item_interface_new_attention_icon (SnItemInterface* _sender,
                                                   gpointer self)
{
	__lambda17_ ((TrayItem*) self);
}

static void
__lambda18_ (TrayItem* self,
             const gchar* new_path)
{
	g_return_if_fail (new_path != NULL);
	tray_item_reset_icon_theme (self, new_path);
}

static void
___lambda18__sn_item_interface_new_icon_theme_path (SnItemInterface* _sender,
                                                    const gchar* new_path,
                                                    gpointer self)
{
	__lambda18_ ((TrayItem*) self, new_path);
}

static void
__lambda19_ (TrayItem* self,
             const gchar* new_status)
{
	g_return_if_fail (new_status != NULL);
	tray_item_reset_icon (self, new_status);
}

static void
___lambda19__sn_item_interface_new_status (SnItemInterface* _sender,
                                           const gchar* new_status,
                                           gpointer self)
{
	__lambda19_ ((TrayItem*) self, new_status);
}

static void
__lambda20_ (TrayItem* self)
{
	tray_item_update_dbus_properties (self);
	tray_item_reset_tooltip (self);
}

static void
___lambda20__sn_item_interface_new_tool_tip (SnItemInterface* _sender,
                                             gpointer self)
{
	__lambda20_ ((TrayItem*) self);
}

TrayItem*
tray_item_construct (GType object_type,
                     const gchar* dbus_name,
                     const gchar* dbus_object_path,
                     gint applet_size,
                     GError** error)
{
	TrayItem * self = NULL;
	SnItemInterface* _tmp0_ = NULL;
	SnItemInterface* _tmp1_;
	SnItemInterface* _tmp2_;
	SnItemProperties* _tmp3_ = NULL;
	SnItemProperties* _tmp4_;
	SnItemProperties* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp10_;
	GtkOverlay* _tmp11_;
	GtkImage* _tmp12_;
	GtkOverlay* _tmp13_;
	GtkImage* _tmp14_;
	GtkOverlay* _tmp15_;
	SnItemProperties* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	gboolean _tmp20_;
	SnItemInterface* _tmp29_;
	SnItemInterface* _tmp30_;
	SnItemInterface* _tmp31_;
	SnItemInterface* _tmp32_;
	SnItemInterface* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dbus_name != NULL, NULL);
	g_return_val_if_fail (dbus_object_path != NULL, NULL);
	self = (TrayItem*) g_object_new (object_type, NULL);
	_tmp1_ = (SnItemInterface*) g_initable_new (TYPE_SN_ITEM_INTERFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", dbus_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", dbus_object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
	_tmp0_ = (SnItemInterface*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->dbus_item);
	self->priv->dbus_item = _tmp2_;
	_tmp4_ = (SnItemProperties*) g_initable_new (TYPE_SN_ITEM_PROPERTIES_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", dbus_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", dbus_object_path, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
	_tmp3_ = (SnItemProperties*) _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->dbus_properties);
	self->priv->dbus_properties = _tmp5_;
	_tmp6_ = g_strdup (dbus_name);
	_g_free0 (self->priv->dbus_name);
	self->priv->dbus_name = _tmp6_;
	_tmp7_ = g_strdup (dbus_object_path);
	_g_free0 (self->priv->dbus_object_path);
	self->priv->dbus_object_path = _tmp7_;
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_SCROLL_MASK);
	tray_item_reset_icon_theme (self, NULL);
	_tmp8_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->primary_icon);
	self->priv->primary_icon = _tmp8_;
	_tmp9_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->overlay_icon);
	self->priv->overlay_icon = _tmp9_;
	_tmp10_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp10_);
	overlay = _tmp10_;
	_tmp11_ = overlay;
	_tmp12_ = self->priv->primary_icon;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = overlay;
	_tmp14_ = self->priv->overlay_icon;
	gtk_overlay_add_overlay (_tmp13_, (GtkWidget*) _tmp14_);
	tray_item_resize (self, applet_size);
	_tmp15_ = overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	tray_item_reset_tooltip (self);
	_tmp16_ = self->priv->dbus_properties;
	_tmp17_ = sn_item_properties_get_menu (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_ != NULL;
	_g_free0 (_tmp19_);
	if (_tmp20_) {
		DBusMenu* _tmp21_ = NULL;
		SnItemProperties* _tmp22_;
		char* _tmp23_;
		char* _tmp24_;
		char* _tmp25_;
		DBusMenu* _tmp26_;
		DBusMenu* _tmp27_;
		DBusMenu* _tmp28_;
		_tmp22_ = self->priv->dbus_properties;
		_tmp23_ = sn_item_properties_get_menu (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = dbus_menu_new (dbus_name, _tmp25_, &_inner_error0_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_tmp21_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (overlay);
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (_tmp0_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_object_unref0 (overlay);
				_g_object_unref0 (_tmp3_);
				_g_object_unref0 (_tmp0_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp28_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (self->priv->context_menu);
		self->priv->context_menu = _tmp28_;
		_g_object_unref0 (_tmp21_);
	}
	_tmp29_ = self->priv->dbus_item;
	g_signal_connect_object (_tmp29_, "new-icon", (GCallback) ___lambda16__sn_item_interface_new_icon, self, 0);
	_tmp30_ = self->priv->dbus_item;
	g_signal_connect_object (_tmp30_, "new-attention-icon", (GCallback) ___lambda17__sn_item_interface_new_attention_icon, self, 0);
	_tmp31_ = self->priv->dbus_item;
	g_signal_connect_object (_tmp31_, "new-icon-theme-path", (GCallback) ___lambda18__sn_item_interface_new_icon_theme_path, self, 0);
	_tmp32_ = self->priv->dbus_item;
	g_signal_connect_object (_tmp32_, "new-status", (GCallback) ___lambda19__sn_item_interface_new_status, self, 0);
	_tmp33_ = self->priv->dbus_item;
	g_signal_connect_object (_tmp33_, "new-tool-tip", (GCallback) ___lambda20__sn_item_interface_new_tool_tip, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (overlay);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp0_);
	return self;
}

TrayItem*
tray_item_new (const gchar* dbus_name,
               const gchar* dbus_object_path,
               gint applet_size,
               GError** error)
{
	return tray_item_construct (TYPE_TRAY_ITEM, dbus_name, dbus_object_path, applet_size, error);
}

static void
tray_item_update_dbus_properties (TrayItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SnItemProperties* _tmp0_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		SnItemProperties* _tmp3_;
		SnItemProperties* _tmp4_;
		_tmp1_ = self->priv->dbus_name;
		_tmp2_ = self->priv->dbus_object_path;
		_tmp3_ = (SnItemProperties*) g_initable_new (TYPE_SN_ITEM_PROPERTIES_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", _tmp1_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp2_, "g-interface-name", "org.kde.StatusNotifierItem", NULL);
		_tmp0_ = (SnItemProperties*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->dbus_properties);
		self->priv->dbus_properties = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("TrayItem.vala:132: Failed to update dbus properties: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tray_item_reset_icon (TrayItem* self,
                      const gchar* status)
{
	gchar* icon_name = NULL;
	SnIconPixmap* icon_pixmaps = NULL;
	SnIconPixmap* _tmp0_;
	gint icon_pixmaps_length1;
	gint _icon_pixmaps_size_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkImage* _tmp20_;
	const gchar* _tmp21_;
	SnIconPixmap* _tmp22_;
	gint _tmp22__length1;
	GtkImage* _tmp23_;
	SnItemProperties* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SnItemProperties* _tmp28_;
	SnIconPixmap* _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_ = 0;
	SnIconPixmap* _tmp31_;
	gint _tmp31__length1;
	SnIconPixmap* _tmp32_;
	gint _tmp32__length1;
	g_return_if_fail (self != NULL);
	icon_name = NULL;
	_tmp0_ = g_new0 (SnIconPixmap, 0);
	icon_pixmaps = _tmp0_;
	icon_pixmaps_length1 = 0;
	_icon_pixmaps_size_ = icon_pixmaps_length1;
	_tmp2_ = g_strdup (status);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		SnItemProperties* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->dbus_properties;
		_tmp4_ = sn_item_properties_get_status (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	if (g_strcmp0 (_tmp1_, "NeedsAttention") == 0) {
		SnItemProperties* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		SnItemProperties* _tmp9_;
		SnIconPixmap* _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_ = 0;
		SnIconPixmap* _tmp12_;
		gint _tmp12__length1;
		_tmp6_ = self->priv->dbus_properties;
		_tmp7_ = sn_item_properties_get_attention_icon_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (icon_name);
		icon_name = _tmp8_;
		_tmp9_ = self->priv->dbus_properties;
		_tmp10_ = sn_item_properties_get_attention_icon_pixmap (_tmp9_, &_tmp11_);
		_tmp10__length1 = _tmp11_;
		_tmp12_ = _tmp10_;
		_tmp12__length1 = _tmp10__length1;
		icon_pixmaps = (_vala_SnIconPixmap_array_free (icon_pixmaps, icon_pixmaps_length1), NULL);
		icon_pixmaps = _tmp12_;
		icon_pixmaps_length1 = _tmp12__length1;
		_icon_pixmaps_size_ = icon_pixmaps_length1;
	} else {
		SnItemProperties* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		SnItemProperties* _tmp16_;
		SnIconPixmap* _tmp17_;
		gint _tmp17__length1;
		gint _tmp18_ = 0;
		SnIconPixmap* _tmp19_;
		gint _tmp19__length1;
		_tmp13_ = self->priv->dbus_properties;
		_tmp14_ = sn_item_properties_get_icon_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (icon_name);
		icon_name = _tmp15_;
		_tmp16_ = self->priv->dbus_properties;
		_tmp17_ = sn_item_properties_get_icon_pixmap (_tmp16_, &_tmp18_);
		_tmp17__length1 = _tmp18_;
		_tmp19_ = _tmp17_;
		_tmp19__length1 = _tmp17__length1;
		icon_pixmaps = (_vala_SnIconPixmap_array_free (icon_pixmaps, icon_pixmaps_length1), NULL);
		icon_pixmaps = _tmp19_;
		icon_pixmaps_length1 = _tmp19__length1;
		_icon_pixmaps_size_ = icon_pixmaps_length1;
	}
	_tmp20_ = self->priv->primary_icon;
	_tmp21_ = icon_name;
	_tmp22_ = icon_pixmaps;
	_tmp22__length1 = icon_pixmaps_length1;
	tray_item_update_icon (self, _tmp20_, _tmp21_, _tmp22_, (gint) _tmp22__length1, "application-default-icon");
	_tmp23_ = self->priv->overlay_icon;
	_tmp24_ = self->priv->dbus_properties;
	_tmp25_ = sn_item_properties_get_overlay_icon_name (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->dbus_properties;
	_tmp29_ = sn_item_properties_get_overlay_icon_pixmap (_tmp28_, &_tmp30_);
	_tmp29__length1 = _tmp30_;
	_tmp31_ = _tmp29_;
	_tmp31__length1 = _tmp29__length1;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp31__length1;
	tray_item_update_icon (self, _tmp23_, _tmp27_, _tmp32_, (gint) _tmp31__length1, NULL);
	_tmp32_ = (_vala_SnIconPixmap_array_free (_tmp32_, _tmp32__length1), NULL);
	_g_free0 (_tmp27_);
	if (self->target_icon_size > 0) {
		GtkImage* _tmp33_;
		GtkImage* _tmp34_;
		_tmp33_ = self->priv->primary_icon;
		gtk_image_set_pixel_size (_tmp33_, self->target_icon_size);
		_tmp34_ = self->priv->overlay_icon;
		gtk_image_set_pixel_size (_tmp34_, self->target_icon_size);
	}
	_g_free0 (_tmp1_);
	icon_pixmaps = (_vala_SnIconPixmap_array_free (icon_pixmaps, icon_pixmaps_length1), NULL);
	_g_free0 (icon_name);
}

static gpointer
_sn_icon_pixmap_dup0 (gpointer self)
{
	return self ? sn_icon_pixmap_dup (self) : NULL;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
_g_free_gdk_pixbuf_destroy_notify (guint8* pixels,
                                   gpointer self)
{
	g_free (pixels);
}

static void
tray_item_update_icon (TrayItem* self,
                       GtkImage* icon,
                       const gchar* icon_name,
                       SnIconPixmap* icon_pixmaps,
                       gint icon_pixmaps_length1,
                       const gchar* fallback_icon_name)
{
	SnIconPixmap* icon_pixmap = NULL;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	icon_pixmap = NULL;
	{
		SnIconPixmap* pixmap_collection = NULL;
		gint pixmap_collection_length1 = 0;
		gint _pixmap_collection_size_ = 0;
		gint pixmap_it = 0;
		pixmap_collection = icon_pixmaps;
		pixmap_collection_length1 = icon_pixmaps_length1;
		for (pixmap_it = 0; pixmap_it < pixmap_collection_length1; pixmap_it = pixmap_it + 1) {
			SnIconPixmap _tmp0_;
			SnIconPixmap _tmp1_ = {0};
			SnIconPixmap pixmap = {0};
			_tmp0_ = pixmap_collection[pixmap_it];
			sn_icon_pixmap_copy (&_tmp0_, &_tmp1_);
			pixmap = _tmp1_;
			{
				SnIconPixmap _tmp2_;
				SnIconPixmap _tmp3_;
				SnIconPixmap* _tmp4_;
				gboolean _tmp5_ = FALSE;
				SnIconPixmap* _tmp6_;
				_tmp2_ = pixmap;
				_tmp3_ = _tmp2_;
				_tmp4_ = _sn_icon_pixmap_dup0 (&_tmp3_);
				_sn_icon_pixmap_free0 (icon_pixmap);
				icon_pixmap = _tmp4_;
				_tmp6_ = icon_pixmap;
				if ((*_tmp6_).width >= self->target_icon_size) {
					SnIconPixmap* _tmp7_;
					_tmp7_ = icon_pixmap;
					_tmp5_ = (*_tmp7_).height >= self->target_icon_size;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					sn_icon_pixmap_destroy (&pixmap);
					break;
				}
				sn_icon_pixmap_destroy (&pixmap);
			}
		}
	}
	if (icon_name != NULL) {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = strlen (icon_name);
		_tmp10_ = _tmp9_;
		_tmp8_ = _tmp10_ > 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		_tmp12_ = self->priv->icon_theme_path;
		if (_tmp12_ != NULL) {
			GtkIconTheme* _tmp13_;
			_tmp13_ = gtk_icon_theme_get_default ();
			_tmp11_ = !gtk_icon_theme_has_icon (_tmp13_, icon_name);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkIconTheme* icon_theme = NULL;
			GtkIconTheme* _tmp14_;
			GtkIconTheme* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = gtk_icon_theme_new ();
			icon_theme = _tmp14_;
			_tmp15_ = icon_theme;
			_tmp16_ = self->priv->icon_theme_path;
			gtk_icon_theme_prepend_search_path (_tmp15_, _tmp16_);
			{
				GdkPixbuf* pixbuf = NULL;
				GtkIconTheme* _tmp17_;
				GdkPixbuf* _tmp18_;
				GdkPixbuf* _tmp19_;
				_tmp17_ = icon_theme;
				_tmp18_ = gtk_icon_theme_load_icon (_tmp17_, icon_name, self->target_icon_size, 0, &_inner_error0_);
				pixbuf = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp19_ = pixbuf;
				if (_tmp19_ != NULL) {
					GdkPixbuf* _tmp20_;
					_tmp20_ = pixbuf;
					gtk_image_set_from_pixbuf (icon, _tmp20_);
				} else {
					gtk_image_set_from_icon_name (icon, fallback_icon_name, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
				}
				_g_object_unref0 (pixbuf);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp21_;
				const gchar* _tmp22_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				g_warning ("TrayItem.vala:177: Failed to fetch icon with name %s for tray icon: %s", icon_name, _tmp22_);
				gtk_image_set_from_icon_name (icon, fallback_icon_name, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (icon_theme);
				_sn_icon_pixmap_free0 (icon_pixmap);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (icon_theme);
		} else {
			gtk_image_set_from_icon_name (icon, icon_name, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		}
		gtk_widget_set_visible ((GtkWidget*) icon, TRUE);
	} else {
		SnIconPixmap* _tmp23_;
		_tmp23_ = icon_pixmap;
		if (_tmp23_ != NULL) {
			guint8* array = NULL;
			SnIconPixmap* _tmp24_;
			guint8* _tmp25_;
			gint _tmp25__length1;
			gint array_length1;
			gint _array_size_;
			GdkPixbuf* pixbuf = NULL;
			guint8* _tmp45_;
			gint _tmp45__length1;
			guint8* _tmp46_;
			gint _tmp46__length1;
			SnIconPixmap* _tmp47_;
			SnIconPixmap* _tmp48_;
			SnIconPixmap* _tmp49_;
			GdkPixbuf* _tmp50_;
			GdkPixbuf* _tmp51_;
			GdkPixbuf* _tmp52_;
			GdkPixbuf* _tmp53_;
			_tmp24_ = icon_pixmap;
			_tmp25_ = ((*_tmp24_).data != NULL) ? _vala_array_dup3 ((*_tmp24_).data, (*_tmp24_).data_length1) : (*_tmp24_).data;
			_tmp25__length1 = (*_tmp24_).data_length1;
			array = _tmp25_;
			array_length1 = _tmp25__length1;
			_array_size_ = array_length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp26_ = FALSE;
					_tmp26_ = TRUE;
					while (TRUE) {
						SnIconPixmap* _tmp27_;
						guint8* _tmp28_;
						gint _tmp28__length1;
						guint8* _tmp29_;
						gint _tmp29__length1;
						SnIconPixmap* _tmp30_;
						guint8* _tmp31_;
						gint _tmp31__length1;
						guint8 _tmp32_;
						guint8* _tmp33_;
						gint _tmp33__length1;
						SnIconPixmap* _tmp34_;
						guint8* _tmp35_;
						gint _tmp35__length1;
						guint8 _tmp36_;
						guint8* _tmp37_;
						gint _tmp37__length1;
						SnIconPixmap* _tmp38_;
						guint8* _tmp39_;
						gint _tmp39__length1;
						guint8 _tmp40_;
						guint8* _tmp41_;
						gint _tmp41__length1;
						SnIconPixmap* _tmp42_;
						guint8* _tmp43_;
						gint _tmp43__length1;
						guint8 _tmp44_;
						if (!_tmp26_) {
							i += 4;
						}
						_tmp26_ = FALSE;
						_tmp27_ = icon_pixmap;
						_tmp28_ = (*_tmp27_).data;
						_tmp28__length1 = (*_tmp27_).data_length1;
						if (!(i < _tmp28__length1)) {
							break;
						}
						_tmp29_ = array;
						_tmp29__length1 = array_length1;
						_tmp30_ = icon_pixmap;
						_tmp31_ = (*_tmp30_).data;
						_tmp31__length1 = (*_tmp30_).data_length1;
						_tmp32_ = _tmp31_[i + 1];
						_tmp29_[i] = _tmp32_;
						_tmp33_ = array;
						_tmp33__length1 = array_length1;
						_tmp34_ = icon_pixmap;
						_tmp35_ = (*_tmp34_).data;
						_tmp35__length1 = (*_tmp34_).data_length1;
						_tmp36_ = _tmp35_[i + 2];
						_tmp33_[i + 1] = _tmp36_;
						_tmp37_ = array;
						_tmp37__length1 = array_length1;
						_tmp38_ = icon_pixmap;
						_tmp39_ = (*_tmp38_).data;
						_tmp39__length1 = (*_tmp38_).data_length1;
						_tmp40_ = _tmp39_[i + 3];
						_tmp37_[i + 2] = _tmp40_;
						_tmp41_ = array;
						_tmp41__length1 = array_length1;
						_tmp42_ = icon_pixmap;
						_tmp43_ = (*_tmp42_).data;
						_tmp43__length1 = (*_tmp42_).data_length1;
						_tmp44_ = _tmp43_[i];
						_tmp41_[i + 3] = _tmp44_;
					}
				}
			}
			_tmp45_ = array;
			_tmp45__length1 = array_length1;
			_tmp46_ = (_tmp45_ != NULL) ? _vala_array_dup4 (_tmp45_, _tmp45__length1) : _tmp45_;
			_tmp46__length1 = _tmp45__length1;
			_tmp47_ = icon_pixmap;
			_tmp48_ = icon_pixmap;
			_tmp49_ = icon_pixmap;
			_tmp50_ = gdk_pixbuf_new_from_data (_tmp46_, GDK_COLORSPACE_RGB, TRUE, 8, (*_tmp47_).width, (*_tmp48_).height, cairo_format_stride_for_width (CAIRO_FORMAT_ARGB32, (*_tmp49_).width), _g_free_gdk_pixbuf_destroy_notify, NULL);
			pixbuf = _tmp50_;
			_tmp51_ = pixbuf;
			_tmp52_ = gdk_pixbuf_scale_simple (_tmp51_, self->target_icon_size, self->target_icon_size, GDK_INTERP_BILINEAR);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp52_;
			_tmp53_ = pixbuf;
			gtk_image_set_from_pixbuf (icon, _tmp53_);
			gtk_widget_set_visible ((GtkWidget*) icon, TRUE);
			_g_object_unref0 (pixbuf);
			array = (g_free (array), NULL);
		} else {
			if (fallback_icon_name != NULL) {
				gtk_image_set_from_icon_name (icon, fallback_icon_name, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
			} else {
				gtk_widget_set_visible ((GtkWidget*) icon, FALSE);
			}
		}
	}
	_sn_icon_pixmap_free0 (icon_pixmap);
}

static void
tray_item_reset_icon_theme (TrayItem* self,
                            const gchar* new_path)
{
	g_return_if_fail (self != NULL);
	if (new_path != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (new_path);
		_g_free0 (self->priv->icon_theme_path);
		self->priv->icon_theme_path = _tmp0_;
	} else {
		SnItemProperties* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->priv->dbus_properties;
		_tmp2_ = sn_item_properties_get_icon_theme_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_ != NULL;
		_g_free0 (_tmp4_);
		if (_tmp5_) {
			SnItemProperties* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->dbus_properties;
			_tmp7_ = sn_item_properties_get_icon_theme_path (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (self->priv->icon_theme_path);
			self->priv->icon_theme_path = _tmp8_;
		}
	}
}

static void
tray_item_reset_tooltip (TrayItem* self)
{
	SnItemProperties* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dbus_properties;
	_tmp1_ = sn_item_properties_get_tool_tip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_variant_unref0 (_tmp3_);
	if (_tmp4_) {
		SnItemProperties* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = self->priv->dbus_properties;
		_tmp6_ = sn_item_properties_get_tool_tip (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_variant_get_type_string (_tmp8_);
		_tmp10_ = g_strcmp0 (_tmp9_, "(sa(iiay)ss)") == 0;
		_g_variant_unref0 (_tmp8_);
		if (_tmp10_) {
			gchar* title = NULL;
			SnItemProperties* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			GVariant* _tmp14_;
			GVariant* _tmp15_;
			GVariant* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* markup = NULL;
			SnItemProperties* _tmp20_;
			GVariant* _tmp21_;
			GVariant* _tmp22_;
			GVariant* _tmp23_;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp11_ = self->priv->dbus_properties;
			_tmp12_ = sn_item_properties_get_tool_tip (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = g_variant_get_child_value (_tmp14_, (gsize) 2);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_variant_get_string (_tmp16_, NULL);
			_tmp18_ = g_strdup (_tmp17_);
			_tmp19_ = _tmp18_;
			_g_variant_unref0 (_tmp16_);
			_g_variant_unref0 (_tmp14_);
			title = _tmp19_;
			_tmp20_ = self->priv->dbus_properties;
			_tmp21_ = sn_item_properties_get_tool_tip (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp24_ = g_variant_get_child_value (_tmp23_, (gsize) 3);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_variant_get_string (_tmp25_, NULL);
			_tmp27_ = g_strdup (_tmp26_);
			_tmp28_ = _tmp27_;
			_g_variant_unref0 (_tmp25_);
			_g_variant_unref0 (_tmp23_);
			markup = _tmp28_;
			_tmp29_ = markup;
			if (g_strcmp0 (_tmp29_, "") != 0) {
				const gchar* _tmp30_;
				_tmp30_ = markup;
				gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp30_);
			} else {
				const gchar* _tmp31_;
				_tmp31_ = title;
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp31_);
			}
			_g_free0 (markup);
			_g_free0 (title);
			return;
		} else {
			SnItemProperties* _tmp32_;
			GVariant* _tmp33_;
			GVariant* _tmp34_;
			GVariant* _tmp35_;
			const GVariantType* _tmp36_;
			gboolean _tmp37_;
			_tmp32_ = self->priv->dbus_properties;
			_tmp33_ = sn_item_properties_get_tool_tip (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp36_ = G_VARIANT_TYPE_STRING;
			_tmp37_ = g_variant_is_of_type (_tmp35_, _tmp36_);
			_g_variant_unref0 (_tmp35_);
			if (_tmp37_) {
				SnItemProperties* _tmp38_;
				GVariant* _tmp39_;
				GVariant* _tmp40_;
				GVariant* _tmp41_;
				const gchar* _tmp42_;
				_tmp38_ = self->priv->dbus_properties;
				_tmp39_ = sn_item_properties_get_tool_tip (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _tmp40_;
				_tmp42_ = g_variant_get_string (_tmp41_, NULL);
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp42_);
				_g_variant_unref0 (_tmp41_);
				return;
			}
		}
	}
	gtk_widget_set_tooltip_text ((GtkWidget*) self, NULL);
}

static gboolean
tray_item_real_button_release_event (GtkWidget* base,
                                     GdkEventButton* event)
{
	TrayItem * self;
	gboolean result;
	self = (TrayItem*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 2)) {
		tray_item_secondary_activate (self, event);
		result = GDK_EVENT_STOP;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (event->button == ((guint) 3)) {
			_tmp0_ = TRUE;
		} else {
			SnItemProperties* _tmp1_;
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp1_ = self->priv->dbus_properties;
			_tmp2_ = sn_item_properties_get_item_is_menu (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp0_ = _tmp3_;
		}
		if (_tmp0_) {
			tray_item_show_context_menu (self, event);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			if (event->button == ((guint) 1)) {
				tray_item_primary_activate (self, event);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GTK_WIDGET_CLASS (tray_item_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox), event);
	return result;
}

static gboolean
tray_item_real_scroll_event (GtkWidget* base,
                             GdkEventScroll* event)
{
	TrayItem * self;
	gboolean result;
	self = (TrayItem*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->direction) {
		case GDK_SCROLL_UP:
		{
			tray_item_send_scroll_event (self, 1, "vertical");
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_SCROLL_DOWN:
		{
			tray_item_send_scroll_event (self, -1, "vertical");
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_SCROLL_LEFT:
		{
			tray_item_send_scroll_event (self, -1, "horizontal");
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_SCROLL_RIGHT:
		{
			tray_item_send_scroll_event (self, 1, "horizontal");
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		{
			{
				if (fabs (event->delta_x) > 0.0) {
					tray_item_send_scroll_event (self, (gint) ceil (event->delta_x), "horizontal");
				}
				if (fabs (event->delta_y) > 0.0) {
					tray_item_send_scroll_event (self, (gint) ceil (event->delta_y), "vertical");
				}
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
}

static void
tray_item_primary_activate (TrayItem* self,
                            GdkEventButton* event)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		SnItemInterface* _tmp0_;
		_tmp0_ = self->priv->dbus_item;
		sn_item_interface_activate (_tmp0_, (gint) event->x_root, (gint) event->y_root, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("TrayItem.vala:292: Failed to call activate method on StatusNotifier it" \
"em: %s", _tmp2_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("TrayItem.vala:294: Failed to call activate method on StatusNotifier it" \
"em: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tray_item_secondary_activate (TrayItem* self,
                              GdkEventButton* event)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		SnItemInterface* _tmp0_;
		_tmp0_ = self->priv->dbus_item;
		sn_item_interface_secondary_activate (_tmp0_, (gint) event->x_root, (gint) event->y_root, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("TrayItem.vala:303: Failed to call secondary activate method on StatusN" \
"otifier item: %s", _tmp2_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("TrayItem.vala:305: Failed to call secondary activate method on StatusN" \
"otifier item: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tray_item_show_context_menu (TrayItem* self,
                             GdkEventButton* event)
{
	DBusMenu* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->context_menu;
	if (_tmp0_ != NULL) {
		DBusMenu* _tmp1_;
		_tmp1_ = self->priv->context_menu;
		dbus_menu_popup_at_pointer (_tmp1_, (GdkEvent*) event);
	} else {
		{
			SnItemInterface* _tmp2_;
			_tmp2_ = self->priv->dbus_item;
			sn_item_interface_context_menu (_tmp2_, (gint) event->x_root, (gint) event->y_root, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_DBUS_ERROR) {
					goto __catch0_g_dbus_error;
				}
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_dbus_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_debug ("TrayItem.vala:316: Failed to show context menu on StatusNotifier item:" \
" %s", _tmp4_);
			_g_error_free0 (e);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("TrayItem.vala:318: Failed to show context menu on StatusNotifier item:" \
" %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
tray_item_send_scroll_event (TrayItem* self,
                             gint delta,
                             const gchar* orientation)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (orientation != NULL);
	{
		SnItemInterface* _tmp0_;
		_tmp0_ = self->priv->dbus_item;
		sn_item_interface_scroll (_tmp0_, delta, orientation, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("TrayItem.vala:327: Failed to call scroll method on StatusNotifier item" \
": %s", _tmp2_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("TrayItem.vala:329: Failed to call scroll method on StatusNotifier item" \
": %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
tray_item_resize (TrayItem* self,
                  gint applet_size)
{
	g_return_if_fail (self != NULL);
	self->target_icon_size = (gint) round (TARGET_ICON_SCALE * applet_size);
	tray_item_reset_icon (self, NULL);
}

static void
tray_item_class_init (TrayItemClass * klass,
                      gpointer klass_data)
{
	tray_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrayItem_private_offset);
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) tray_item_real_button_release_event;
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) tray_item_real_scroll_event;
	G_OBJECT_CLASS (klass)->finalize = tray_item_finalize;
}

static void
tray_item_instance_init (TrayItem * self,
                         gpointer klass)
{
	self->priv = tray_item_get_instance_private (self);
	self->priv->icon_theme_path = NULL;
	self->target_icon_size = 8;
}

static void
tray_item_finalize (GObject * obj)
{
	TrayItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_ITEM, TrayItem);
	_g_object_unref0 (self->priv->dbus_item);
	_g_object_unref0 (self->priv->dbus_properties);
	_g_free0 (self->priv->dbus_name);
	_g_free0 (self->priv->dbus_object_path);
	_g_object_unref0 (self->priv->context_menu);
	_g_free0 (self->priv->icon_theme_path);
	_g_object_unref0 (self->priv->primary_icon);
	_g_object_unref0 (self->priv->overlay_icon);
	G_OBJECT_CLASS (tray_item_parent_class)->finalize (obj);
}

GType
tray_item_get_type (void)
{
	return tray_item_type_id;
}

GType
tray_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrayItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayItem), 0, (GInstanceInitFunc) tray_item_instance_init, NULL };
	tray_item_type_id = g_type_module_register_type (module, gtk_event_box_get_type (), "TrayItem", &g_define_type_info, 0);
	TrayItem_private_offset = sizeof (TrayItemPrivate);
	return tray_item_type_id;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

