/* DBusMenuNode.c generated by valac 0.56.14, the Vala compiler
 * generated from DBusMenuNode.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "trayapplet.h"
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define TYPE_PROPERTIES (properties_get_type ())
#define PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES, Properties))
#define PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES, PropertiesClass))
#define IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES))
#define IS_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES))
#define PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES, PropertiesClass))

typedef struct _Properties Properties;
typedef struct _PropertiesClass PropertiesClass;
enum  {
	DBUS_MENU_NODE_0_PROPERTY,
	DBUS_MENU_NODE_NUM_PROPERTIES
};
static GParamSpec* dbus_menu_node_properties[DBUS_MENU_NODE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _properties_unref0(var) ((var == NULL) ? NULL : (var = (properties_unref (var), NULL)))

#define TYPE_DBUS_MENU_ITEM (dbus_menu_item_get_type ())
#define DBUS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBUS_MENU_ITEM, DBusMenuItem))
#define DBUS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBUS_MENU_ITEM, DBusMenuItemClass))
#define IS_DBUS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBUS_MENU_ITEM))
#define IS_DBUS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBUS_MENU_ITEM))
#define DBUS_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBUS_MENU_ITEM, DBusMenuItemClass))

typedef struct _DBusMenuItem DBusMenuItem;
typedef struct _DBusMenuItemClass DBusMenuItemClass;
typedef struct _Block2Data Block2Data;
typedef struct _PropertiesPrivate PropertiesPrivate;
typedef struct _DBusMenuItemPrivate DBusMenuItemPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	DBUS_MENU_NODE_CLICKED_SIGNAL,
	DBUS_MENU_NODE_HOVERED_SIGNAL,
	DBUS_MENU_NODE_OPENED_SIGNAL,
	DBUS_MENU_NODE_CLOSED_SIGNAL,
	DBUS_MENU_NODE_NUM_SIGNALS
};
static guint dbus_menu_node_signals[DBUS_MENU_NODE_NUM_SIGNALS] = {0};
enum  {
	DBUS_MENU_ITEM_0_PROPERTY,
	DBUS_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* dbus_menu_item_properties[DBUS_MENU_ITEM_NUM_PROPERTIES];
typedef struct _Block3Data Block3Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ParamSpecProperties ParamSpecProperties;

struct _DBusMenuNodePrivate {
	Properties* properties;
	gulong activate_signal_handler;
};

struct _Block2Data {
	int _ref_count_;
	DBusMenuNode* self;
	DBusMenuItem* dbus_item;
};

struct _Properties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PropertiesPrivate * priv;
	gboolean visible;
	gboolean enabled;
	gchar* label;
	gchar* type;
	gchar* disposition;
	gchar* children_display;
	gchar* toggle_type;
	gboolean* toggle_state;
	gchar* icon_name;
	GBytes* icon_data;
	GList* shortcut;
};

struct _PropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (Properties *self);
};

struct _DBusMenuItem {
	GtkCheckMenuItem parent_instance;
	DBusMenuItemPrivate * priv;
	gboolean should_draw_indicator;
};

struct _DBusMenuItemClass {
	GtkCheckMenuItemClass parent_class;
};

struct _DBusMenuItemPrivate {
	GtkBox* box;
	GtkAccelLabel* label;
	GtkImage* icon;
};

struct _Block3Data {
	int _ref_count_;
	DBusMenuItem* self;
	guint key;
	GdkModifierType modifier;
};

struct _ParamSpecProperties {
	GParamSpec parent_instance;
};

static gint DBusMenuNode_private_offset;
static gpointer dbus_menu_node_parent_class = NULL;
static GType dbus_menu_node_type_id = 0;
static gint DBusMenuItem_private_offset;
static gpointer dbus_menu_item_parent_class = NULL;
static GType dbus_menu_item_type_id = 0;
static gpointer properties_parent_class = NULL;
static GType properties_type_id = 0;

VALA_EXTERN gpointer properties_ref (gpointer instance);
VALA_EXTERN void properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_properties (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_properties (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_properties (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_properties (const GValue* value);
GType properties_register_type (GTypeModule * module);
VALA_EXTERN GType properties_get_type (void) G_GNUC_CONST ;
GType dbus_menu_item_register_type (GTypeModule * module);
VALA_EXTERN GType dbus_menu_item_get_type (void) G_GNUC_CONST ;
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN Properties* properties_new (GVariant* props);
VALA_EXTERN Properties* properties_construct (GType object_type,
                                  GVariant* props);
static void __lambda4_ (DBusMenuNode* self);
static void ___lambda4__gtk_widget_map (GtkWidget* _sender,
                                 gpointer self);
static void __lambda5_ (DBusMenuNode* self);
static void ___lambda5__gtk_widget_unmap (GtkWidget* _sender,
                                   gpointer self);
VALA_EXTERN DBusMenuItem* dbus_menu_item_new (Properties* properties,
                                  GtkMenu* submenu);
VALA_EXTERN DBusMenuItem* dbus_menu_item_construct (GType object_type,
                                        Properties* properties,
                                        GtkMenu* submenu);
static void __lambda7_ (Block2Data* _data2_);
static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self);
static void __lambda8_ (Block2Data* _data2_);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN gboolean properties_set_property (Properties* self,
                                  const gchar* key,
                                  GVariant* value);
VALA_EXTERN void dbus_menu_item_update_label (DBusMenuItem* self,
                                  const gchar* new_mnemonic_text);
VALA_EXTERN void dbus_menu_item_update_disposition (DBusMenuItem* self,
                                        const gchar* new_disposition);
VALA_EXTERN void dbus_menu_item_update_submenu (DBusMenuItem* self,
                                    const gchar* new_children_display,
                                    GtkMenu* submenu);
VALA_EXTERN void dbus_menu_item_update_toggle_type (DBusMenuItem* self,
                                        const gchar* new_toggle_type);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN void dbus_menu_item_update_icon (DBusMenuItem* self,
                                 const gchar* icon_name,
                                 GBytes* icon_data);
VALA_EXTERN void dbus_menu_item_update_shortcut (DBusMenuItem* self,
                                     GList* new_shortcut);
static void dbus_menu_node_finalize (GObject * obj);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_,
                 const gchar* it);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void dbus_menu_item_real_toggle_size_request (GtkMenuItem* base,
                                              void* request);
static void dbus_menu_item_real_toggle_size_allocate (GtkMenuItem* base,
                                               gint alloc);
static void dbus_menu_item_real_draw_indicator (GtkCheckMenuItem* base,
                                         cairo_t* cr);
static void dbus_menu_item_finalize (GObject * obj);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _g_variant_unref0_ (gpointer var);
static gboolean properties_parse_bool (GVariant* variant,
                                gboolean _default_);
static gchar* properties_parse_string (GVariant* variant,
                                const gchar* _default_);
static gboolean* properties_parse_int32_bool (GVariant* variant,
                                       gboolean* _default_);
static GBytes* properties_parse_bytes (GVariant* variant,
                                GBytes* _default_);
static GList* properties_parse_shortcuts (GVariant* variant);
static GVariant* properties_unbox (GVariant* variant);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
static void properties_finalize (Properties * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
dbus_menu_node_get_instance_private (DBusMenuNode* self)
{
	return G_STRUCT_MEMBER_P (self, DBusMenuNode_private_offset);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DBusMenuNode* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dbus_item);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda4_ (DBusMenuNode* self)
{
	g_signal_emit (self, dbus_menu_node_signals[DBUS_MENU_NODE_OPENED_SIGNAL], 0);
}

static void
___lambda4__gtk_widget_map (GtkWidget* _sender,
                            gpointer self)
{
	__lambda4_ ((DBusMenuNode*) self);
}

static void
__lambda5_ (DBusMenuNode* self)
{
	g_signal_emit (self, dbus_menu_node_signals[DBUS_MENU_NODE_CLOSED_SIGNAL], 0);
}

static void
___lambda5__gtk_widget_unmap (GtkWidget* _sender,
                              gpointer self)
{
	__lambda5_ ((DBusMenuNode*) self);
}

static void
__lambda7_ (Block2Data* _data2_)
{
	DBusMenuNode* self;
	DBusMenuItem* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	self = _data2_->self;
	_tmp0_ = _data2_->dbus_item;
	_tmp1_ = gtk_menu_item_get_submenu ((GtkMenuItem*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		g_signal_emit (self, dbus_menu_node_signals[DBUS_MENU_NODE_HOVERED_SIGNAL], 0);
	} else {
		GVariant* _tmp3_ = NULL;
		DBusMenuItem* _tmp4_;
		_tmp4_ = _data2_->dbus_item;
		if (_tmp4_->should_draw_indicator) {
			DBusMenuItem* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			GVariant* _tmp8_;
			_tmp5_ = _data2_->dbus_item;
			_tmp6_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_variant_new_boolean (_tmp7_);
			g_variant_ref_sink (_tmp8_);
			_g_variant_unref0 (_tmp3_);
			_tmp3_ = _tmp8_;
		} else {
			_g_variant_unref0 (_tmp3_);
			_tmp3_ = NULL;
		}
		g_signal_emit (self, dbus_menu_node_signals[DBUS_MENU_NODE_CLICKED_SIGNAL], 0, _tmp3_);
		_g_variant_unref0 (_tmp3_);
	}
}

static void
___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                    gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda8_ (Block2Data* _data2_)
{
	DBusMenuNode* self;
	DBusMenuItem* _tmp0_;
	Properties* _tmp1_;
	self = _data2_->self;
	_tmp0_ = _data2_->dbus_item;
	_tmp1_ = self->priv->properties;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_->visible);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DBusMenuNode*
dbus_menu_node_construct (GType object_type,
                          gint32 id,
                          GVariant* props)
{
	DBusMenuNode * self = NULL;
	Block2Data* _data2_;
	Properties* _tmp0_;
	Properties* _tmp1_;
	const gchar* _tmp2_;
	GtkMenu* _tmp8_;
	GtkMenu* _tmp9_;
	GtkMenu* _tmp10_;
	Properties* _tmp11_;
	GtkMenu* _tmp12_;
	DBusMenuItem* _tmp13_;
	DBusMenuItem* _tmp14_;
	gulong _tmp15_;
	DBusMenuItem* _tmp16_;
	DBusMenuItem* _tmp17_;
	GtkMenuItem* _tmp18_;
	g_return_val_if_fail (props != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	self = (DBusMenuNode*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	self->id = id;
	_tmp0_ = properties_new (props);
	_properties_unref0 (self->priv->properties);
	self->priv->properties = _tmp0_;
	_tmp1_ = self->priv->properties;
	_tmp2_ = _tmp1_->type;
	if (g_strcmp0 (_tmp2_, "separator") == 0) {
		GtkSeparatorMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
		Properties* _tmp5_;
		GtkMenuItem* _tmp6_;
		Properties* _tmp7_;
		_tmp3_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->item);
		self->item = (GtkMenuItem*) _tmp3_;
		_tmp4_ = self->item;
		_tmp5_ = self->priv->properties;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp5_->visible);
		_tmp6_ = self->item;
		_tmp7_ = self->priv->properties;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp7_->enabled);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return self;
	}
	_tmp8_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->submenu);
	self->submenu = _tmp8_;
	_tmp9_ = self->submenu;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "map", (GCallback) ___lambda4__gtk_widget_map, self, 0);
	_tmp10_ = self->submenu;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "unmap", (GCallback) ___lambda5__gtk_widget_unmap, self, 0);
	_tmp11_ = self->priv->properties;
	_tmp12_ = self->submenu;
	_tmp13_ = dbus_menu_item_new (_tmp11_, _tmp12_);
	g_object_ref_sink (_tmp13_);
	_data2_->dbus_item = _tmp13_;
	_tmp14_ = _data2_->dbus_item;
	_tmp15_ = g_signal_connect_data ((GtkMenuItem*) _tmp14_, "activate", (GCallback) ___lambda7__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->activate_signal_handler = _tmp15_;
	_tmp16_ = _data2_->dbus_item;
	g_signal_connect_data ((GObject*) _tmp16_, "notify::visible", (GCallback) ___lambda8__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp17_ = _data2_->dbus_item;
	_tmp18_ = _g_object_ref0 ((GtkMenuItem*) _tmp17_);
	_g_object_unref0 (self->item);
	self->item = _tmp18_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

DBusMenuNode*
dbus_menu_node_new (gint32 id,
                    GVariant* props)
{
	return dbus_menu_node_construct (TYPE_DBUS_MENU_NODE, id, props);
}

void
dbus_menu_node_update_children (DBusMenuNode* self,
                                GList* new_children)
{
	GList* old_children = NULL;
	GtkMenu* _tmp20_;
	GList* _tmp21_;
	GtkMenu* _tmp33_;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkMenuItem* item = NULL;
				gconstpointer _tmp2_;
				GtkMenuItem* _tmp3_;
				GtkMenuItem* _tmp4_;
				GtkMenuItem* _tmp5_;
				GtkContainer* _tmp6_;
				GtkContainer* _tmp7_;
				GtkMenuItem* _tmp12_;
				GtkContainer* _tmp13_;
				GtkContainer* _tmp14_;
				GtkMenu* _tmp15_;
				GtkMenu* _tmp18_;
				GtkMenuItem* _tmp19_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g_list_length (new_children))) {
					break;
				}
				_tmp2_ = g_list_nth_data (new_children, (guint) i);
				_tmp3_ = ((DBusMenuNode*) _tmp2_)->item;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				item = _tmp4_;
				_tmp5_ = item;
				_tmp6_ = gtk_widget_get_parent ((GtkWidget*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ != NULL) {
					GtkMenuItem* _tmp8_;
					GtkContainer* _tmp9_;
					GtkContainer* _tmp10_;
					GtkMenuItem* _tmp11_;
					_tmp8_ = item;
					_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = item;
					gtk_container_remove (_tmp10_, (GtkWidget*) _tmp11_);
				}
				_tmp12_ = item;
				_tmp13_ = gtk_widget_get_parent ((GtkWidget*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = self->submenu;
				if (_tmp14_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer)) {
					GtkMenu* _tmp16_;
					GtkMenuItem* _tmp17_;
					_tmp16_ = self->submenu;
					_tmp17_ = item;
					gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
				}
				_tmp18_ = self->submenu;
				_tmp19_ = item;
				gtk_menu_reorder_child (_tmp18_, (GtkWidget*) _tmp19_, i);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp20_ = self->submenu;
	_tmp21_ = gtk_container_get_children ((GtkContainer*) _tmp20_);
	old_children = _tmp21_;
	{
		guint i = 0U;
		GList* _tmp22_;
		_tmp22_ = old_children;
		i = g_list_length (_tmp22_) - 1;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				GtkWidget* item = NULL;
				GtkMenu* _tmp25_;
				GList* _tmp26_;
				GList* _tmp27_;
				gconstpointer _tmp28_;
				GtkWidget* _tmp29_;
				GtkWidget* _tmp30_;
				GtkMenu* _tmp31_;
				GtkWidget* _tmp32_;
				if (!_tmp23_) {
					guint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ - 1;
				}
				_tmp23_ = FALSE;
				if (!(i > (g_list_length (new_children) - 1))) {
					break;
				}
				_tmp25_ = self->submenu;
				_tmp26_ = gtk_container_get_children ((GtkContainer*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_list_nth_data (_tmp27_, i);
				_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
				_tmp30_ = _tmp29_;
				(_tmp27_ == NULL) ? NULL : (_tmp27_ = (g_list_free (_tmp27_), NULL));
				item = _tmp30_;
				_tmp31_ = self->submenu;
				_tmp32_ = item;
				gtk_container_remove ((GtkContainer*) _tmp31_, _tmp32_);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp33_ = self->submenu;
	gtk_widget_queue_resize ((GtkWidget*) _tmp33_);
	(old_children == NULL) ? NULL : (old_children = (g_list_free (old_children), NULL));
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

void
dbus_menu_node_update_property (DBusMenuNode* self,
                                const gchar* key,
                                GVariant* value)
{
	Properties* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	GtkMenuItem* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->properties;
	if (!properties_set_property (_tmp0_, key, value)) {
		return;
	}
	if (self->priv->activate_signal_handler > ((gulong) 0)) {
		GtkMenuItem* _tmp2_;
		_tmp2_ = self->item;
		_tmp1_ = IS_DBUS_MENU_ITEM (_tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkMenuItem* _tmp3_;
		_tmp3_ = self->item;
		g_signal_handler_block (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DBUS_MENU_ITEM, DBusMenuItem), self->priv->activate_signal_handler);
	}
	_tmp4_ = key;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("visible")))) {
		switch (0) {
			default:
			{
				GtkMenuItem* _tmp7_;
				Properties* _tmp8_;
				_tmp7_ = self->item;
				_tmp8_ = self->priv->properties;
				gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_->visible);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("enabled")))) {
		switch (0) {
			default:
			{
				GtkMenuItem* _tmp9_;
				Properties* _tmp10_;
				_tmp9_ = self->item;
				_tmp10_ = self->priv->properties;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_->enabled);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp11_ = self->item;
	if (IS_DBUS_MENU_ITEM (_tmp11_)) {
		DBusMenuItem* dbus_item = NULL;
		GtkMenuItem* _tmp12_;
		DBusMenuItem* _tmp13_;
		const gchar* _tmp14_;
		GQuark _tmp16_ = 0U;
		static GQuark _tmp15_label0 = 0;
		static GQuark _tmp15_label1 = 0;
		static GQuark _tmp15_label2 = 0;
		static GQuark _tmp15_label3 = 0;
		static GQuark _tmp15_label4 = 0;
		static GQuark _tmp15_label5 = 0;
		static GQuark _tmp15_label6 = 0;
		static GQuark _tmp15_label7 = 0;
		static GQuark _tmp15_label8 = 0;
		_tmp12_ = self->item;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DBUS_MENU_ITEM, DBusMenuItem));
		dbus_item = _tmp13_;
		_tmp14_ = key;
		_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
		if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("label")))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp17_;
					Properties* _tmp18_;
					const gchar* _tmp19_;
					_tmp17_ = dbus_item;
					_tmp18_ = self->priv->properties;
					_tmp19_ = _tmp18_->label;
					dbus_menu_item_update_label (_tmp17_, _tmp19_);
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("type")))) {
			switch (0) {
				default:
				{
					g_warning ("DBusMenuNode.vala:94: Attempted to change the type of an existing item");
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label2) ? _tmp15_label2 : (_tmp15_label2 = g_quark_from_static_string ("disposition")))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp20_;
					Properties* _tmp21_;
					const gchar* _tmp22_;
					_tmp20_ = dbus_item;
					_tmp21_ = self->priv->properties;
					_tmp22_ = _tmp21_->disposition;
					dbus_menu_item_update_disposition (_tmp20_, _tmp22_);
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label3) ? _tmp15_label3 : (_tmp15_label3 = g_quark_from_static_string ("children-display")))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp23_;
					Properties* _tmp24_;
					const gchar* _tmp25_;
					GtkMenu* _tmp26_;
					_tmp23_ = dbus_item;
					_tmp24_ = self->priv->properties;
					_tmp25_ = _tmp24_->children_display;
					_tmp26_ = self->submenu;
					dbus_menu_item_update_submenu (_tmp23_, _tmp25_, _tmp26_);
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label4) ? _tmp15_label4 : (_tmp15_label4 = g_quark_from_static_string ("toggle-type")))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp27_;
					Properties* _tmp28_;
					const gchar* _tmp29_;
					_tmp27_ = dbus_item;
					_tmp28_ = self->priv->properties;
					_tmp29_ = _tmp28_->toggle_type;
					dbus_menu_item_update_toggle_type (_tmp27_, _tmp29_);
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label5) ? _tmp15_label5 : (_tmp15_label5 = g_quark_from_static_string ("toggle-state")))) {
			switch (0) {
				default:
				{
					gboolean* _tmp30_ = NULL;
					Properties* _tmp31_;
					gboolean* _tmp32_;
					gboolean* _tmp33_;
					DBusMenuItem* _tmp36_;
					_tmp31_ = self->priv->properties;
					_tmp32_ = _tmp31_->toggle_state;
					_tmp33_ = __bool_dup0 (_tmp32_);
					_tmp30_ = _tmp33_;
					if (_tmp30_ == NULL) {
						gboolean _tmp34_;
						gboolean* _tmp35_;
						_tmp34_ = FALSE;
						_tmp35_ = __bool_dup0 (&_tmp34_);
						_g_free0 (_tmp30_);
						_tmp30_ = _tmp35_;
					}
					_tmp36_ = dbus_item;
					gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp36_, *_tmp30_);
					_g_free0 (_tmp30_);
					break;
				}
			}
		} else if ((_tmp16_ == ((0 != _tmp15_label6) ? _tmp15_label6 : (_tmp15_label6 = g_quark_from_static_string ("icon-name")))) || (_tmp16_ == ((0 != _tmp15_label7) ? _tmp15_label7 : (_tmp15_label7 = g_quark_from_static_string ("icon-data"))))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp37_;
					Properties* _tmp38_;
					const gchar* _tmp39_;
					Properties* _tmp40_;
					GBytes* _tmp41_;
					_tmp37_ = dbus_item;
					_tmp38_ = self->priv->properties;
					_tmp39_ = _tmp38_->icon_name;
					_tmp40_ = self->priv->properties;
					_tmp41_ = _tmp40_->icon_data;
					dbus_menu_item_update_icon (_tmp37_, _tmp39_, _tmp41_);
					break;
				}
			}
		} else if (_tmp16_ == ((0 != _tmp15_label8) ? _tmp15_label8 : (_tmp15_label8 = g_quark_from_static_string ("shortcut")))) {
			switch (0) {
				default:
				{
					DBusMenuItem* _tmp42_;
					Properties* _tmp43_;
					GList* _tmp44_;
					_tmp42_ = dbus_item;
					_tmp43_ = self->priv->properties;
					_tmp44_ = _tmp43_->shortcut;
					dbus_menu_item_update_shortcut (_tmp42_, _tmp44_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
		if (self->priv->activate_signal_handler > ((gulong) 0)) {
			DBusMenuItem* _tmp45_;
			_tmp45_ = dbus_item;
			g_signal_handler_unblock (_tmp45_, self->priv->activate_signal_handler);
		}
		_g_object_unref0 (dbus_item);
	}
}

static void
dbus_menu_node_class_init (DBusMenuNodeClass * klass,
                           gpointer klass_data)
{
	dbus_menu_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DBusMenuNode_private_offset);
	G_OBJECT_CLASS (klass)->finalize = dbus_menu_node_finalize;
	dbus_menu_node_signals[DBUS_MENU_NODE_CLICKED_SIGNAL] = g_signal_new ("clicked", TYPE_DBUS_MENU_NODE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
	dbus_menu_node_signals[DBUS_MENU_NODE_HOVERED_SIGNAL] = g_signal_new ("hovered", TYPE_DBUS_MENU_NODE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	dbus_menu_node_signals[DBUS_MENU_NODE_OPENED_SIGNAL] = g_signal_new ("opened", TYPE_DBUS_MENU_NODE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	dbus_menu_node_signals[DBUS_MENU_NODE_CLOSED_SIGNAL] = g_signal_new ("closed", TYPE_DBUS_MENU_NODE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
dbus_menu_node_instance_init (DBusMenuNode * self,
                              gpointer klass)
{
	self->priv = dbus_menu_node_get_instance_private (self);
	self->priv->activate_signal_handler = (gulong) 0;
}

static void
dbus_menu_node_finalize (GObject * obj)
{
	DBusMenuNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DBUS_MENU_NODE, DBusMenuNode);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->submenu);
	_properties_unref0 (self->priv->properties);
	G_OBJECT_CLASS (dbus_menu_node_parent_class)->finalize (obj);
}

GType
dbus_menu_node_get_type (void)
{
	return dbus_menu_node_type_id;
}

GType
dbus_menu_node_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (DBusMenuNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dbus_menu_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DBusMenuNode), 0, (GInstanceInitFunc) dbus_menu_node_instance_init, NULL };
	dbus_menu_node_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "DBusMenuNode", &g_define_type_info, 0);
	DBusMenuNode_private_offset = sizeof (DBusMenuNodePrivate);
	return dbus_menu_node_type_id;
}

static inline gpointer
dbus_menu_item_get_instance_private (DBusMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, DBusMenuItem_private_offset);
}

DBusMenuItem*
dbus_menu_item_construct (GType object_type,
                          Properties* properties,
                          GtkMenu* submenu)
{
	DBusMenuItem * self = NULL;
	gboolean* _tmp0_ = NULL;
	gboolean* _tmp1_;
	gboolean* _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GtkBox* _tmp8_;
	GtkImage* _tmp9_;
	const gchar* _tmp10_;
	GBytes* _tmp11_;
	GtkAccelLabel* _tmp12_;
	GtkAccelLabel* _tmp13_;
	const gchar* _tmp14_;
	GList* _tmp15_;
	GtkBox* _tmp16_;
	GtkAccelLabel* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	g_return_val_if_fail (properties != NULL, NULL);
	g_return_val_if_fail (submenu != NULL, NULL);
	self = (DBusMenuItem*) g_object_new (object_type, NULL);
	_tmp1_ = properties->toggle_state;
	_tmp2_ = __bool_dup0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp3_ = FALSE;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) self, *_tmp0_);
	_tmp5_ = properties->toggle_type;
	dbus_menu_item_update_toggle_type (self, _tmp5_);
	_tmp6_ = properties->disposition;
	dbus_menu_item_update_disposition (self, _tmp6_);
	_tmp7_ = properties->children_display;
	dbus_menu_item_update_submenu (self, _tmp7_, submenu);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp8_;
	_tmp9_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp9_;
	_tmp10_ = properties->icon_name;
	_tmp11_ = properties->icon_data;
	dbus_menu_item_update_icon (self, _tmp10_, _tmp11_);
	_tmp12_ = (GtkAccelLabel*) gtk_accel_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp12_;
	_tmp13_ = self->priv->label;
	_tmp14_ = properties->label;
	gtk_label_set_text_with_mnemonic ((GtkLabel*) _tmp13_, _tmp14_);
	_tmp15_ = properties->shortcut;
	dbus_menu_item_update_shortcut (self, _tmp15_);
	_tmp16_ = self->priv->box;
	_tmp17_ = self->priv->label;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->box;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp19_);
	gtk_widget_set_visible ((GtkWidget*) self, properties->visible);
	gtk_widget_set_sensitive ((GtkWidget*) self, properties->enabled);
	_g_free0 (_tmp0_);
	return self;
}

DBusMenuItem*
dbus_menu_item_new (Properties* properties,
                    GtkMenu* submenu)
{
	return dbus_menu_item_construct (TYPE_DBUS_MENU_ITEM, properties, submenu);
}

void
dbus_menu_item_update_label (DBusMenuItem* self,
                             const gchar* new_mnemonic_text)
{
	GtkAccelLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_mnemonic_text != NULL);
	_tmp0_ = self->priv->label;
	gtk_label_set_text_with_mnemonic ((GtkLabel*) _tmp0_, new_mnemonic_text);
}

void
dbus_menu_item_update_toggle_type (DBusMenuItem* self,
                                   const gchar* new_toggle_type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_toggle_type != NULL);
	gtk_check_menu_item_set_draw_as_radio ((GtkCheckMenuItem*) self, g_strcmp0 (new_toggle_type, "radio") == 0);
	self->should_draw_indicator = g_strcmp0 (new_toggle_type, "") != 0;
}

void
dbus_menu_item_update_disposition (DBusMenuItem* self,
                                   const gchar* new_disposition)
{
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_disposition != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp2_ = style_context;
	gtk_style_context_remove_class (_tmp2_, "info");
	_tmp3_ = style_context;
	gtk_style_context_remove_class (_tmp3_, "warning");
	_tmp4_ = style_context;
	gtk_style_context_remove_class (_tmp4_, "error");
	if (g_strcmp0 (new_disposition, "informative") == 0) {
		GtkStyleContext* _tmp5_;
		_tmp5_ = style_context;
		gtk_style_context_add_class (_tmp5_, "info");
	} else {
		if (g_strcmp0 (new_disposition, "warning") == 0) {
			GtkStyleContext* _tmp6_;
			_tmp6_ = style_context;
			gtk_style_context_add_class (_tmp6_, "warning");
		} else {
			if (g_strcmp0 (new_disposition, "alert") == 0) {
				GtkStyleContext* _tmp7_;
				_tmp7_ = style_context;
				gtk_style_context_add_class (_tmp7_, "error");
			}
		}
	}
	_g_object_unref0 (style_context);
}

void
dbus_menu_item_update_submenu (DBusMenuItem* self,
                               const gchar* new_children_display,
                               GtkMenu* submenu)
{
	gboolean _tmp0_ = FALSE;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_children_display != NULL);
	g_return_if_fail (submenu != NULL);
	_tmp1_ = gtk_menu_item_get_submenu ((GtkMenuItem*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = g_strcmp0 (new_children_display, "submenu") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_menu_item_set_submenu ((GtkMenuItem*) self, submenu);
	} else {
		gboolean _tmp3_ = FALSE;
		GtkMenu* _tmp4_;
		GtkMenu* _tmp5_;
		_tmp4_ = gtk_menu_item_get_submenu ((GtkMenuItem*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			_tmp3_ = g_strcmp0 (new_children_display, "submenu") != 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gtk_menu_item_set_submenu ((GtkMenuItem*) self, NULL);
		}
	}
}

void
dbus_menu_item_update_icon (DBusMenuItem* self,
                            const gchar* icon_name,
                            GBytes* icon_data)
{
	gboolean _tmp0_ = FALSE;
	GIcon* gicon = NULL;
	GIcon* _tmp7_ = NULL;
	GIcon* _tmp12_;
	GtkImage* _tmp13_;
	GIcon* _tmp14_;
	GtkImage* _tmp15_;
	GtkBox* _tmp16_;
	GtkImage* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (icon_data != NULL);
	if (g_strcmp0 (icon_name, "") == 0) {
		_tmp0_ = g_bytes_get_size (icon_data) == ((gsize) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkImage* _tmp1_;
		GtkContainer* _tmp2_;
		GtkContainer* _tmp3_;
		GtkBox* _tmp4_;
		_tmp1_ = self->priv->icon;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->box;
		if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer)) {
			GtkBox* _tmp5_;
			GtkImage* _tmp6_;
			_tmp5_ = self->priv->box;
			_tmp6_ = self->priv->icon;
			gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
		}
		return;
	}
	if (g_strcmp0 (icon_name, "") != 0) {
		GThemedIcon* _tmp8_;
		_tmp8_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (icon_name);
		_g_object_unref0 (_tmp7_);
		_tmp7_ = (GIcon*) _tmp8_;
	} else {
		GBytesIcon* _tmp9_;
		GIcon* _tmp10_;
		GIcon* _tmp11_;
		_tmp9_ = (GBytesIcon*) g_bytes_icon_new (icon_data);
		_g_object_unref0 (gicon);
		gicon = (GIcon*) _tmp9_;
		_tmp10_ = gicon;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (gicon);
	gicon = _tmp12_;
	_tmp13_ = self->priv->icon;
	_tmp14_ = gicon;
	gtk_image_set_from_gicon (_tmp13_, _tmp14_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	_tmp15_ = self->priv->icon;
	gtk_image_set_pixel_size (_tmp15_, 16);
	_tmp16_ = self->priv->box;
	_tmp17_ = self->priv->icon;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 2);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (gicon);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DBusMenuItem* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda6_ (Block3Data* _data3_,
            const gchar* it)
{
	DBusMenuItem* self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	self = _data3_->self;
	g_return_if_fail (it != NULL);
	_tmp0_ = it;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Control")))) {
		switch (0) {
			default:
			{
				_data3_->modifier |= GDK_CONTROL_MASK;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Alt")))) {
		switch (0) {
			default:
			{
				_data3_->modifier |= GDK_MOD1_MASK;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Shift")))) {
		switch (0) {
			default:
			{
				_data3_->modifier |= GDK_SHIFT_MASK;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Super")))) {
		switch (0) {
			default:
			{
				_data3_->modifier |= GDK_SUPER_MASK;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GdkModifierType temp_modifier = 0U;
				guint _tmp3_ = 0U;
				GdkModifierType _tmp4_ = 0U;
				gtk_accelerator_parse (it, &_tmp3_, &_tmp4_);
				_data3_->key = _tmp3_;
				temp_modifier = _tmp4_;
				break;
			}
		}
	}
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (const gchar*) data);
}

void
dbus_menu_item_update_shortcut (DBusMenuItem* self,
                                GList* new_shortcut)
{
	Block3Data* _data3_;
	GtkAccelLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	if (new_shortcut == NULL) {
		GtkAccelLabel* _tmp0_;
		_tmp0_ = self->priv->label;
		gtk_accel_label_set_accel (_tmp0_, (guint) 0, 0);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_data3_->key = (guint) 0;
	_data3_->modifier = 0;
	g_list_foreach (new_shortcut, ___lambda6__gfunc, _data3_);
	_tmp1_ = self->priv->label;
	gtk_accel_label_set_accel (_tmp1_, _data3_->key, _data3_->modifier);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
dbus_menu_item_real_toggle_size_request (GtkMenuItem* base,
                                         void* request)
{
	DBusMenuItem * self;
	gboolean _tmp0_ = FALSE;
	self = (DBusMenuItem*) base;
	if (self->should_draw_indicator) {
		_tmp0_ = TRUE;
	} else {
		GtkImage* _tmp1_;
		GtkContainer* _tmp2_;
		GtkContainer* _tmp3_;
		_tmp1_ = self->priv->icon;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		GTK_MENU_ITEM_CLASS (dbus_menu_item_parent_class)->toggle_size_request ((GtkMenuItem*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_check_menu_item_get_type (), GtkCheckMenuItem), request);
	} else {
		gint* request_int = NULL;
		gint* _tmp4_;
		request_int = request;
		_tmp4_ = request_int;
		*_tmp4_ = 0;
	}
}

static void
dbus_menu_item_real_toggle_size_allocate (GtkMenuItem* base,
                                          gint alloc)
{
	DBusMenuItem * self;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	self = (DBusMenuItem*) base;
	if (self->should_draw_indicator) {
		_tmp1_ = TRUE;
	} else {
		GtkImage* _tmp2_;
		GtkContainer* _tmp3_;
		GtkContainer* _tmp4_;
		_tmp2_ = self->priv->icon;
		_tmp3_ = gtk_widget_get_parent ((GtkWidget*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = alloc;
	} else {
		_tmp0_ = 0;
	}
	GTK_MENU_ITEM_CLASS (dbus_menu_item_parent_class)->toggle_size_allocate ((GtkMenuItem*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_check_menu_item_get_type (), GtkCheckMenuItem), _tmp0_);
}

static void
dbus_menu_item_real_draw_indicator (GtkCheckMenuItem* base,
                                    cairo_t* cr)
{
	DBusMenuItem * self;
	self = (DBusMenuItem*) base;
	g_return_if_fail (cr != NULL);
	if (self->should_draw_indicator) {
		GTK_CHECK_MENU_ITEM_CLASS (dbus_menu_item_parent_class)->draw_indicator (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_check_menu_item_get_type (), GtkCheckMenuItem), cr);
	}
}

static void
dbus_menu_item_class_init (DBusMenuItemClass * klass,
                           gpointer klass_data)
{
	dbus_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DBusMenuItem_private_offset);
	((GtkMenuItemClass *) klass)->toggle_size_request = (void (*) (GtkMenuItem*, void*)) dbus_menu_item_real_toggle_size_request;
	((GtkMenuItemClass *) klass)->toggle_size_allocate = (void (*) (GtkMenuItem*, gint)) dbus_menu_item_real_toggle_size_allocate;
	((GtkCheckMenuItemClass *) klass)->draw_indicator = (void (*) (GtkCheckMenuItem*, cairo_t*)) dbus_menu_item_real_draw_indicator;
	G_OBJECT_CLASS (klass)->finalize = dbus_menu_item_finalize;
}

static void
dbus_menu_item_instance_init (DBusMenuItem * self,
                              gpointer klass)
{
	self->priv = dbus_menu_item_get_instance_private (self);
	self->should_draw_indicator = FALSE;
}

static void
dbus_menu_item_finalize (GObject * obj)
{
	DBusMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DBUS_MENU_ITEM, DBusMenuItem);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (dbus_menu_item_parent_class)->finalize (obj);
}

GType
dbus_menu_item_get_type (void)
{
	return dbus_menu_item_type_id;
}

GType
dbus_menu_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (DBusMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dbus_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DBusMenuItem), 0, (GInstanceInitFunc) dbus_menu_item_instance_init, NULL };
	dbus_menu_item_type_id = g_type_module_register_type (module, gtk_check_menu_item_get_type (), "DBusMenuItem", &g_define_type_info, 0);
	DBusMenuItem_private_offset = sizeof (DBusMenuItemPrivate);
	return dbus_menu_item_type_id;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

Properties*
properties_construct (GType object_type,
                      GVariant* props)
{
	Properties* self = NULL;
	GHashTable* props_table = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GVariantIter* prop_it = NULL;
	GVariantIter* _tmp3_;
	gchar* key = NULL;
	GVariant* value = NULL;
	GHashTable* _tmp13_;
	gconstpointer _tmp14_;
	GHashTable* _tmp15_;
	gconstpointer _tmp16_;
	GHashTable* _tmp17_;
	gconstpointer _tmp18_;
	gchar* _tmp19_;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_;
	gchar* _tmp22_;
	GHashTable* _tmp23_;
	gconstpointer _tmp24_;
	gchar* _tmp25_;
	GHashTable* _tmp26_;
	gconstpointer _tmp27_;
	gchar* _tmp28_;
	GHashTable* _tmp29_;
	gconstpointer _tmp30_;
	gchar* _tmp31_;
	GHashTable* _tmp32_;
	gconstpointer _tmp33_;
	gboolean* _tmp34_;
	GHashTable* _tmp35_;
	gconstpointer _tmp36_;
	gchar* _tmp37_;
	GHashTable* _tmp38_;
	gconstpointer _tmp39_;
	guint8* _tmp40_;
	guint8* _tmp41_;
	gint _tmp41__length1;
	GBytes* _tmp42_;
	GBytes* _tmp43_;
	GBytes* _tmp44_;
	GHashTable* _tmp45_;
	gconstpointer _tmp46_;
	GList* _tmp47_;
	g_return_val_if_fail (props != NULL, NULL);
	self = (Properties*) g_type_create_instance (object_type);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	props_table = _tmp2_;
	_tmp3_ = g_variant_iter_new (props);
	prop_it = _tmp3_;
	while (TRUE) {
		GVariantIter* _tmp4_;
		gchar* _tmp5_ = NULL;
		GVariant* _tmp6_ = NULL;
		gboolean _tmp7_;
		GHashTable* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp4_ = prop_it;
		_tmp7_ = g_variant_iter_next (_tmp4_, "{sv}", &_tmp5_, &_tmp6_, NULL);
		_g_free0 (key);
		key = _tmp5_;
		_g_variant_unref0 (value);
		value = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = props_table;
		_tmp9_ = key;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = value;
		_tmp12_ = _g_variant_ref0 (_tmp11_);
		g_hash_table_insert (_tmp8_, _tmp10_, _tmp12_);
	}
	_tmp13_ = props_table;
	_tmp14_ = g_hash_table_lookup (_tmp13_, "visible");
	self->visible = properties_parse_bool ((GVariant*) _tmp14_, TRUE);
	_tmp15_ = props_table;
	_tmp16_ = g_hash_table_lookup (_tmp15_, "enabled");
	self->enabled = properties_parse_bool ((GVariant*) _tmp16_, TRUE);
	_tmp17_ = props_table;
	_tmp18_ = g_hash_table_lookup (_tmp17_, "label");
	_tmp19_ = properties_parse_string ((GVariant*) _tmp18_, "");
	_g_free0 (self->label);
	self->label = _tmp19_;
	_tmp20_ = props_table;
	_tmp21_ = g_hash_table_lookup (_tmp20_, "type");
	_tmp22_ = properties_parse_string ((GVariant*) _tmp21_, "standard");
	_g_free0 (self->type);
	self->type = _tmp22_;
	_tmp23_ = props_table;
	_tmp24_ = g_hash_table_lookup (_tmp23_, "disposition");
	_tmp25_ = properties_parse_string ((GVariant*) _tmp24_, "normal");
	_g_free0 (self->disposition);
	self->disposition = _tmp25_;
	_tmp26_ = props_table;
	_tmp27_ = g_hash_table_lookup (_tmp26_, "children-display");
	_tmp28_ = properties_parse_string ((GVariant*) _tmp27_, "");
	_g_free0 (self->children_display);
	self->children_display = _tmp28_;
	_tmp29_ = props_table;
	_tmp30_ = g_hash_table_lookup (_tmp29_, "toggle-type");
	_tmp31_ = properties_parse_string ((GVariant*) _tmp30_, "");
	_g_free0 (self->toggle_type);
	self->toggle_type = _tmp31_;
	_tmp32_ = props_table;
	_tmp33_ = g_hash_table_lookup (_tmp32_, "toggle-state");
	_tmp34_ = properties_parse_int32_bool ((GVariant*) _tmp33_, NULL);
	_g_free0 (self->toggle_state);
	self->toggle_state = _tmp34_;
	_tmp35_ = props_table;
	_tmp36_ = g_hash_table_lookup (_tmp35_, "icon-name");
	_tmp37_ = properties_parse_string ((GVariant*) _tmp36_, "");
	_g_free0 (self->icon_name);
	self->icon_name = _tmp37_;
	_tmp38_ = props_table;
	_tmp39_ = g_hash_table_lookup (_tmp38_, "icon-data");
	_tmp40_ = g_new0 (guint8, 0);
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 0;
	_tmp42_ = g_bytes_new (_tmp41_, 0);
	_tmp43_ = _tmp42_;
	_tmp44_ = properties_parse_bytes ((GVariant*) _tmp39_, _tmp43_);
	_g_bytes_unref0 (self->icon_data);
	self->icon_data = _tmp44_;
	_g_bytes_unref0 (_tmp43_);
	_tmp41_ = (g_free (_tmp41_), NULL);
	_tmp45_ = props_table;
	_tmp46_ = g_hash_table_lookup (_tmp45_, "shortcut");
	_tmp47_ = properties_parse_shortcuts ((GVariant*) _tmp46_);
	(self->shortcut == NULL) ? NULL : (self->shortcut = (_g_list_free__g_free0_ (self->shortcut), NULL));
	self->shortcut = _tmp47_;
	_g_variant_unref0 (value);
	_g_free0 (key);
	_g_variant_iter_free0 (prop_it);
	_g_hash_table_unref0 (props_table);
	return self;
}

Properties*
properties_new (GVariant* props)
{
	return properties_construct (TYPE_PROPERTIES, props);
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

gboolean
properties_set_property (Properties* self,
                         const gchar* key,
                         GVariant* value)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("visible")))) {
		switch (0) {
			default:
			{
				gboolean old_value = FALSE;
				GVariant* _tmp3_;
				GVariant* _tmp4_;
				old_value = self->visible;
				_tmp3_ = properties_unbox (value);
				_tmp4_ = _tmp3_;
				self->visible = properties_parse_bool (_tmp4_, TRUE);
				_g_variant_unref0 (_tmp4_);
				result = self->visible != old_value;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("enabled")))) {
		switch (0) {
			default:
			{
				gboolean old_value = FALSE;
				GVariant* _tmp5_;
				GVariant* _tmp6_;
				old_value = self->enabled;
				_tmp5_ = properties_unbox (value);
				_tmp6_ = _tmp5_;
				self->enabled = properties_parse_bool (_tmp6_, TRUE);
				_g_variant_unref0 (_tmp6_);
				result = self->enabled != old_value;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				GVariant* _tmp9_;
				GVariant* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp7_ = self->label;
				_tmp8_ = g_strdup (_tmp7_);
				old_value = _tmp8_;
				_tmp9_ = properties_unbox (value);
				_tmp10_ = _tmp9_;
				_tmp11_ = properties_parse_string (_tmp10_, "");
				_g_free0 (self->label);
				self->label = _tmp11_;
				_g_variant_unref0 (_tmp10_);
				_tmp12_ = self->label;
				_tmp13_ = old_value;
				result = g_strcmp0 (_tmp12_, _tmp13_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("type")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				GVariant* _tmp16_;
				GVariant* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp14_ = self->type;
				_tmp15_ = g_strdup (_tmp14_);
				old_value = _tmp15_;
				_tmp16_ = properties_unbox (value);
				_tmp17_ = _tmp16_;
				_tmp18_ = properties_parse_string (_tmp17_, "standard");
				_g_free0 (self->type);
				self->type = _tmp18_;
				_g_variant_unref0 (_tmp17_);
				_tmp19_ = self->type;
				_tmp20_ = old_value;
				result = g_strcmp0 (_tmp19_, _tmp20_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("disposition")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				GVariant* _tmp23_;
				GVariant* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp21_ = self->disposition;
				_tmp22_ = g_strdup (_tmp21_);
				old_value = _tmp22_;
				_tmp23_ = properties_unbox (value);
				_tmp24_ = _tmp23_;
				_tmp25_ = properties_parse_string (_tmp24_, "normal");
				_g_free0 (self->disposition);
				self->disposition = _tmp25_;
				_g_variant_unref0 (_tmp24_);
				_tmp26_ = self->disposition;
				_tmp27_ = old_value;
				result = g_strcmp0 (_tmp26_, _tmp27_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("children-display")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				GVariant* _tmp30_;
				GVariant* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp28_ = self->children_display;
				_tmp29_ = g_strdup (_tmp28_);
				old_value = _tmp29_;
				_tmp30_ = properties_unbox (value);
				_tmp31_ = _tmp30_;
				_tmp32_ = properties_parse_string (_tmp31_, "");
				_g_free0 (self->children_display);
				self->children_display = _tmp32_;
				_g_variant_unref0 (_tmp31_);
				_tmp33_ = self->children_display;
				_tmp34_ = old_value;
				result = g_strcmp0 (_tmp33_, _tmp34_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("toggle-type")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				GVariant* _tmp37_;
				GVariant* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp35_ = self->toggle_type;
				_tmp36_ = g_strdup (_tmp35_);
				old_value = _tmp36_;
				_tmp37_ = properties_unbox (value);
				_tmp38_ = _tmp37_;
				_tmp39_ = properties_parse_string (_tmp38_, "");
				_g_free0 (self->toggle_type);
				self->toggle_type = _tmp39_;
				_g_variant_unref0 (_tmp38_);
				_tmp40_ = self->toggle_type;
				_tmp41_ = old_value;
				result = g_strcmp0 (_tmp40_, _tmp41_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("toggle-state")))) {
		switch (0) {
			default:
			{
				gboolean* old_value = NULL;
				gboolean* _tmp42_;
				gboolean* _tmp43_;
				GVariant* _tmp44_;
				GVariant* _tmp45_;
				gboolean* _tmp46_;
				gboolean* _tmp47_;
				gboolean* _tmp48_;
				_tmp42_ = self->toggle_state;
				_tmp43_ = __bool_dup0 (_tmp42_);
				old_value = _tmp43_;
				_tmp44_ = properties_unbox (value);
				_tmp45_ = _tmp44_;
				_tmp46_ = properties_parse_int32_bool (_tmp45_, NULL);
				_g_free0 (self->toggle_state);
				self->toggle_state = _tmp46_;
				_g_variant_unref0 (_tmp45_);
				_tmp47_ = self->toggle_state;
				_tmp48_ = old_value;
				result = _bool_equal (_tmp47_, _tmp48_) != TRUE;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("icon-name")))) {
		switch (0) {
			default:
			{
				gchar* old_value = NULL;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				GVariant* _tmp51_;
				GVariant* _tmp52_;
				gchar* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp49_ = self->icon_name;
				_tmp50_ = g_strdup (_tmp49_);
				old_value = _tmp50_;
				_tmp51_ = properties_unbox (value);
				_tmp52_ = _tmp51_;
				_tmp53_ = properties_parse_string (_tmp52_, "");
				_g_free0 (self->icon_name);
				self->icon_name = _tmp53_;
				_g_variant_unref0 (_tmp52_);
				_tmp54_ = self->icon_name;
				_tmp55_ = old_value;
				result = g_strcmp0 (_tmp54_, _tmp55_) != 0;
				_g_free0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("icon-data")))) {
		switch (0) {
			default:
			{
				GBytes* old_value = NULL;
				GBytes* _tmp56_;
				GBytes* _tmp57_;
				GVariant* _tmp58_;
				GVariant* _tmp59_;
				guint8* _tmp60_;
				guint8* _tmp61_;
				gint _tmp61__length1;
				GBytes* _tmp62_;
				GBytes* _tmp63_;
				GBytes* _tmp64_;
				GBytes* _tmp65_;
				GBytes* _tmp66_;
				_tmp56_ = self->icon_data;
				_tmp57_ = _g_bytes_ref0 (_tmp56_);
				old_value = _tmp57_;
				_tmp58_ = properties_unbox (value);
				_tmp59_ = _tmp58_;
				_tmp60_ = g_new0 (guint8, 0);
				_tmp61_ = _tmp60_;
				_tmp61__length1 = 0;
				_tmp62_ = g_bytes_new (_tmp61_, 0);
				_tmp63_ = _tmp62_;
				_tmp64_ = properties_parse_bytes (_tmp59_, _tmp63_);
				_g_bytes_unref0 (self->icon_data);
				self->icon_data = _tmp64_;
				_g_bytes_unref0 (_tmp63_);
				_tmp61_ = (g_free (_tmp61_), NULL);
				_g_variant_unref0 (_tmp59_);
				_tmp65_ = self->icon_data;
				_tmp66_ = old_value;
				result = _tmp65_ != _tmp66_;
				_g_bytes_unref0 (old_value);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("shortcut")))) {
		switch (0) {
			default:
			{
				GList* _tmp67_;
				_tmp67_ = properties_parse_shortcuts (value);
				(self->shortcut == NULL) ? NULL : (self->shortcut = (_g_list_free__g_free0_ (self->shortcut), NULL));
				self->shortcut = _tmp67_;
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
properties_parse_bool (GVariant* variant,
                       gboolean _default_)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (variant != NULL) {
		const GVariantType* _tmp2_;
		_tmp2_ = G_VARIANT_TYPE_BOOLEAN;
		_tmp1_ = g_variant_is_of_type (variant, _tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_variant_get_boolean (variant);
	} else {
		_tmp0_ = _default_;
	}
	result = _tmp0_;
	return result;
}

static gboolean*
properties_parse_int32_bool (GVariant* variant,
                             gboolean* _default_)
{
	gboolean _tmp0_ = FALSE;
	gint32 value = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean* _tmp5_;
	gboolean* result;
	if (variant == NULL) {
		_tmp0_ = TRUE;
	} else {
		const GVariantType* _tmp1_;
		_tmp1_ = G_VARIANT_TYPE_INT32;
		_tmp0_ = !g_variant_is_of_type (variant, _tmp1_);
	}
	if (_tmp0_) {
		gboolean* _tmp2_;
		_tmp2_ = __bool_dup0 (_default_);
		result = _tmp2_;
		return result;
	}
	value = g_variant_get_int32 (variant);
	if (value == ((gint32) 0)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = value == ((gint32) 1);
	}
	if (_tmp4_) {
		_tmp3_ = value == ((gint32) 1);
	} else {
		_tmp3_ = *_default_;
	}
	_tmp5_ = __bool_dup0 (&_tmp3_);
	result = _tmp5_;
	return result;
}

static gchar*
properties_parse_string (GVariant* variant,
                         const gchar* _default_)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (_default_ != NULL, NULL);
	if (variant != NULL) {
		const GVariantType* _tmp2_;
		_tmp2_ = G_VARIANT_TYPE_STRING;
		_tmp1_ = g_variant_is_of_type (variant, _tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp3_;
		_tmp3_ = g_variant_get_string (variant, NULL);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = _default_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	result = _tmp4_;
	return result;
}

static GBytes*
properties_parse_bytes (GVariant* variant,
                        GBytes* _default_)
{
	GBytes* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GBytes* result;
	g_return_val_if_fail (_default_ != NULL, NULL);
	if (variant != NULL) {
		const GVariantType* _tmp2_;
		_tmp2_ = G_VARIANT_TYPE_BYTESTRING;
		_tmp1_ = g_variant_is_of_type (variant, _tmp2_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GBytes* _tmp3_;
		_tmp3_ = g_variant_get_data_as_bytes (variant);
		_g_bytes_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		GBytes* _tmp4_;
		_tmp4_ = _g_bytes_ref0 (_default_);
		_g_bytes_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static GList*
properties_parse_shortcuts (GVariant* variant)
{
	GList* ret = NULL;
	GVariantIter* prop_it = NULL;
	GVariantIter* _tmp0_;
	gchar* key = NULL;
	gchar** values = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	GVariantIter* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gboolean _tmp4_;
	GList* result;
	ret = NULL;
	if (variant == NULL) {
		result = ret;
		return result;
	}
	_tmp0_ = g_variant_iter_new (variant);
	prop_it = _tmp0_;
	_tmp1_ = prop_it;
	_tmp4_ = g_variant_iter_next (_tmp1_, "{as}", &_tmp2_, &_tmp3_, NULL);
	_g_free0 (key);
	key = _tmp2_;
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	values = _tmp3_;
	values_length1 = -1;
	_values_size_ = values_length1;
	if (_tmp4_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		(ret == NULL) ? NULL : (ret = (_g_list_free__g_free0_ (ret), NULL));
		ret = NULL;
		_tmp5_ = values;
		_tmp5__length1 = values_length1;
		{
			gchar** val_collection = NULL;
			gint val_collection_length1 = 0;
			gint _val_collection_size_ = 0;
			gint val_it = 0;
			val_collection = _tmp5_;
			val_collection_length1 = _tmp5__length1;
			for (val_it = 0; val_it < val_collection_length1; val_it = val_it + 1) {
				gchar* _tmp6_;
				gchar* val = NULL;
				_tmp6_ = g_strdup (val_collection[val_it]);
				val = _tmp6_;
				{
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = val;
					_tmp8_ = g_strdup (_tmp7_);
					ret = g_list_append (ret, _tmp8_);
					_g_free0 (val);
				}
			}
		}
	}
	result = ret;
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (key);
	_g_variant_iter_free0 (prop_it);
	return result;
}

static GVariant*
properties_unbox (GVariant* variant)
{
	gint levels = 0;
	GVariant* temp = NULL;
	GVariant* _tmp0_;
	GVariant* result;
	levels = 0;
	_tmp0_ = _g_variant_ref0 (variant);
	temp = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		GVariant* _tmp3_;
		GVariant* _tmp6_;
		_tmp3_ = temp;
		if (_tmp3_ != NULL) {
			GVariant* _tmp4_;
			const GVariantType* _tmp5_;
			_tmp4_ = temp;
			_tmp5_ = G_VARIANT_TYPE_VARIANT;
			_tmp2_ = g_variant_is_of_type (_tmp4_, _tmp5_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = levels < 8;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp6_ = g_variant_get_variant (variant);
		_g_variant_unref0 (temp);
		temp = _tmp6_;
	}
	result = temp;
	return result;
}

static void
value_properties_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_properties_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		properties_unref (value->data[0].v_pointer);
	}
}

static void
value_properties_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = properties_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_properties_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_properties_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Properties * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = properties_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_properties_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	Properties ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = properties_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_properties (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecProperties* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROPERTIES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_properties (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROPERTIES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_properties (GValue* value,
                      gpointer v_object)
{
	Properties * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROPERTIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROPERTIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		properties_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		properties_unref (old);
	}
}

void
value_take_properties (GValue* value,
                       gpointer v_object)
{
	Properties * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROPERTIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROPERTIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		properties_unref (old);
	}
}

static void
properties_class_init (PropertiesClass * klass,
                       gpointer klass_data)
{
	properties_parent_class = g_type_class_peek_parent (klass);
	((PropertiesClass *) klass)->finalize = properties_finalize;
}

static void
properties_instance_init (Properties * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
properties_finalize (Properties * obj)
{
	Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTIES, Properties);
	g_signal_handlers_destroy (self);
	_g_free0 (self->label);
	_g_free0 (self->type);
	_g_free0 (self->disposition);
	_g_free0 (self->children_display);
	_g_free0 (self->toggle_type);
	_g_free0 (self->toggle_state);
	_g_free0 (self->icon_name);
	_g_bytes_unref0 (self->icon_data);
	(self->shortcut == NULL) ? NULL : (self->shortcut = (_g_list_free__g_free0_ (self->shortcut), NULL));
}

GType
properties_get_type (void)
{
	return properties_type_id;
}

GType
properties_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { value_properties_init, value_properties_free_value, value_properties_copy_value, value_properties_peek_pointer, "p", value_properties_collect_value, "p", value_properties_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Properties), 0, (GInstanceInitFunc) properties_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	properties_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Properties", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return properties_type_id;
}

gpointer
properties_ref (gpointer instance)
{
	Properties * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
properties_unref (gpointer instance)
{
	Properties * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROPERTIES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

