/* PowerIndicator.c generated by valac 0.56.14, the Vala compiler
 * generated from PowerIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "statusapplet.h"
#include <upower.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "plugin.h"
#include <gio/gdesktopappinfo.h>

#define POWER_PROFILES_DBUS_NAME "net.hadess.PowerProfiles"
#define POWER_PROFILES_DBUS_OBJECT_NAME "/net/hadess/PowerProfiles"

enum  {
	BATTERY_ICON_0_PROPERTY,
	BATTERY_ICON_BATTERY_PROPERTY,
	BATTERY_ICON_LABEL_VISIBLE_PROPERTY,
	BATTERY_ICON_NUM_PROPERTIES
};
static GParamSpec* battery_icon_properties[BATTERY_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef GDBusProxy PowerProfilesDBusProxy;
typedef GDBusProxyClass PowerProfilesDBusProxyClass;
enum  {
	POWER_PROFILES_OPTION_0_PROPERTY,
	POWER_PROFILES_OPTION_NUM_PROPERTIES
};
static GParamSpec* power_profiles_option_properties[POWER_PROFILES_OPTION_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
enum  {
	POWER_PROFILES_SELECTOR_0_PROPERTY,
	POWER_PROFILES_SELECTOR_NUM_PROPERTIES
};
static GParamSpec* power_profiles_selector_properties[POWER_PROFILES_SELECTOR_NUM_PROPERTIES];
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	POWER_INDICATOR_0_PROPERTY,
	POWER_INDICATOR_CLIENT_PROPERTY,
	POWER_INDICATOR_LABEL_VISIBLE_PROPERTY,
	POWER_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* power_indicator_properties[POWER_INDICATOR_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

struct _BatteryIconPrivate {
	UpDevice* _battery;
	gboolean changing;
	gboolean emitted_warning;
	GtkImage* image;
	GtkLabel* percent_label;
};

struct _Block2Data {
	int _ref_count_;
	PowerProfilesOption* self;
	PowerProfilesDBus* profiles_proxy;
	gchar* profile_name;
};

struct _PowerProfilesSelectorPrivate {
	PowerProfilesOption* radio_power_save;
	PowerProfilesOption* radio_power_balanced;
	PowerProfilesOption* radio_power_performance;
};

struct _Block3Data {
	int _ref_count_;
	PowerProfilesSelector* self;
	PowerProfilesDBus* profiles_proxy;
};

struct _PowerIndicatorPrivate {
	GtkBox* widget;
	GtkBox* box;
	PowerProfilesDBus* profiles_proxy;
	PowerProfilesSelector* power_profiles_selector;
	UpClient* _client;
	GHashTable* devices;
	gboolean _label_visible;
};

static gint BatteryIcon_private_offset;
static gpointer battery_icon_parent_class = NULL;
static GType battery_icon_type_id = 0;
static GType power_profiles_dbus_type_id = 0;
static gpointer power_profiles_option_parent_class = NULL;
static GType power_profiles_option_type_id = 0;
static gint PowerProfilesSelector_private_offset;
static gpointer power_profiles_selector_parent_class = NULL;
static GType power_profiles_selector_type_id = 0;
static gint PowerIndicator_private_offset;
static gpointer power_indicator_parent_class = NULL;
static GType power_indicator_type_id = 0;

static void battery_icon_on_battery_change (BatteryIcon* self,
                                     GObject* o,
                                     GParamSpec* sp);
static void _battery_icon_on_battery_change_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void battery_icon_finalize (GObject * obj);
static void _vala_battery_icon_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_battery_icon_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void power_profiles_dbus_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static GHashTable** power_profiles_dbus_dbus_proxy_get_profiles (PowerProfilesDBus* self,
                                                          gint* result_length1);
static gchar* power_profiles_dbus_dbus_proxy_get_active_profile (PowerProfilesDBus* self);
static void power_profiles_dbus_dbus_proxy_set_active_profile (PowerProfilesDBus* self,
                                                        const gchar* value);
static void power_profiles_dbus_proxy_power_profiles_dbus_interface_init (PowerProfilesDBusIface* iface);
static void power_profiles_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* power_profiles_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static GVariant* _dbus_power_profiles_dbus_get_profiles (PowerProfilesDBus* self);
static GVariant* _dbus_power_profiles_dbus_get_active_profile (PowerProfilesDBus* self);
static gboolean power_profiles_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_power_profiles_dbus_set_active_profile (PowerProfilesDBus* self,
                                                   GVariant* _value);
static void _power_profiles_dbus_unregister_object (gpointer user_data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda34_ (Block2Data* _data2_);
static void ___lambda34__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void power_profiles_selector_on_active_profile_changed (PowerProfilesSelector* self,
                                                        const gchar* active_profile);
static void __lambda35_ (Block3Data* _data3_);
static void ___lambda35__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void power_profiles_selector_finalize (GObject * obj);
static void _g_object_unref0_ (gpointer var);
static void power_indicator_open_power_settings (PowerIndicator* self);
static void _power_indicator_open_power_settings_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void power_indicator_has_power_profiles (PowerIndicator* self);
static void _power_indicator_has_power_profiles_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      const gchar* name_owner,
                                                                      gpointer self);
static void power_indicator_lost_power_profiles (PowerIndicator* self);
static void _power_indicator_lost_power_profiles_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                       const gchar* name,
                                                                       gpointer self);
static void power_indicator_sync_devices (PowerIndicator* self);
static void power_indicator_on_device_added (PowerIndicator* self,
                                      UpDevice* device);
static void _power_indicator_on_device_added_up__client_device_added (UpClient* _sender,
                                                               UpDevice* device,
                                                               gpointer self);
static void power_indicator_on_device_removed (PowerIndicator* self,
                                        const gchar* object_path);
static void _power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender,
                                                                   const gchar* object_path,
                                                                   gpointer self);
static void power_indicator_toggle_show (PowerIndicator* self);
static void power_indicator_create_power_profiles_options (PowerIndicator* self);
static void power_indicator_on_proxy_get (PowerIndicator* self,
                                   GObject* o,
                                   GAsyncResult* res);
static void _power_indicator_on_proxy_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static gboolean power_indicator_is_interesting (PowerIndicator* self,
                                         UpDevice* device);
static void __lambda36_ (PowerIndicator* self,
                  UpDevice* device);
static void ___lambda36__gfunc (gconstpointer data,
                         gpointer self);
static void power_indicator_finalize (GObject * obj);
static void _vala_power_indicator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_power_indicator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _power_profiles_dbus_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _power_profiles_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _power_profiles_dbus_dbus_property_info_profiles = {-1, "Profiles", "aa{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _power_profiles_dbus_dbus_property_info_active_profile = {-1, "ActiveProfile", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _power_profiles_dbus_dbus_property_info[] = {&_power_profiles_dbus_dbus_property_info_profiles, &_power_profiles_dbus_dbus_property_info_active_profile, NULL};
static const GDBusInterfaceInfo _power_profiles_dbus_dbus_interface_info = {-1, "net.hadess.PowerProfiles", (GDBusMethodInfo **) (&_power_profiles_dbus_dbus_method_info), (GDBusSignalInfo **) (&_power_profiles_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_power_profiles_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _power_profiles_dbus_dbus_interface_vtable = {power_profiles_dbus_dbus_interface_method_call, power_profiles_dbus_dbus_interface_get_property, power_profiles_dbus_dbus_interface_set_property};

static inline gpointer
battery_icon_get_instance_private (BatteryIcon* self)
{
	return G_STRUCT_MEMBER_P (self, BatteryIcon_private_offset);
}

static void
_battery_icon_on_battery_change_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	battery_icon_on_battery_change ((BatteryIcon*) self, _sender, pspec);
}

BatteryIcon*
battery_icon_construct (GType object_type,
                        UpDevice* battery)
{
	BatteryIcon * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	g_return_val_if_fail (battery != NULL, NULL);
	self = (BatteryIcon*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "battery-icon");
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->percent_label);
	self->priv->percent_label = _tmp1_;
	_tmp2_ = self->priv->percent_label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "percent-label");
	_tmp4_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp4_;
	_tmp5_ = self->priv->image;
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->image;
	gtk_image_set_pixel_size (_tmp6_, 0);
	_tmp7_ = self->priv->image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = self->priv->percent_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = self->priv->percent_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp9_, 4);
	_tmp10_ = self->priv->percent_label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->priv->percent_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
	battery_icon_update_ui (self, battery);
	g_signal_connect_object ((GObject*) battery, "notify", (GCallback) _battery_icon_on_battery_change_g_object_notify, self, 0);
	return self;
}

BatteryIcon*
battery_icon_new (UpDevice* battery)
{
	return battery_icon_construct (TYPE_BATTERY_ICON, battery);
}

static void
battery_icon_on_battery_change (BatteryIcon* self,
                                GObject* o,
                                GParamSpec* sp)
{
	UpDevice* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (sp != NULL);
	if (self->priv->changing) {
		return;
	}
	self->priv->changing = TRUE;
	{
		UpDevice* _tmp0_;
		_tmp0_ = self->priv->_battery;
		up_device_refresh_sync (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		if (!self->priv->emitted_warning) {
			GError* _tmp1_;
			const gchar* _tmp2_;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_warning ("PowerIndicator.vala:66: Failed to refresh battery: %s", _tmp2_);
			self->priv->emitted_warning = TRUE;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->_battery;
	battery_icon_update_ui (self, _tmp3_);
	self->priv->changing = FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
battery_icon_update_ui (BatteryIcon* self,
                        UpDevice* battery)
{
	gchar* tip = NULL;
	gchar* image_name = NULL;
	gint rounded = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* image_fallback = NULL;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gchar* labe = NULL;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gchar* _tmp46_;
	gchar* old = NULL;
	GtkLabel* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp54_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp55_;
	GtkIconTheme* _tmp56_;
	GtkIconInfo* _result_ = NULL;
	GtkIconTheme* _tmp57_;
	const gchar* _tmp58_;
	GtkIconInfo* _tmp59_;
	const gchar* _tmp60_ = NULL;
	GtkIconInfo* _tmp61_;
	GtkImage* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (battery != NULL);
	battery_icon_set_battery (self, battery);
	g_object_get (battery, "percentage", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	rounded = ((gint) round (_tmp1_ / 10)) * 10;
	g_object_get (battery, "percentage", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= ((gdouble) 10)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("battery-empty");
		_g_free0 (image_fallback);
		image_fallback = _tmp4_;
	} else {
		gdouble _tmp5_;
		gdouble _tmp6_;
		g_object_get (battery, "percentage", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		if (_tmp6_ <= ((gdouble) 35)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("battery-low");
			_g_free0 (image_fallback);
			image_fallback = _tmp7_;
		} else {
			gdouble _tmp8_;
			gdouble _tmp9_;
			g_object_get (battery, "percentage", &_tmp8_, NULL);
			_tmp9_ = _tmp8_;
			if (_tmp9_ <= ((gdouble) 75)) {
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("battery-good");
				_g_free0 (image_fallback);
				image_fallback = _tmp10_;
			} else {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("battery-full");
				_g_free0 (image_fallback);
				image_fallback = _tmp11_;
			}
		}
	}
	_tmp12_ = g_strdup_printf ("battery-level-%d", rounded);
	_g_free0 (image_name);
	image_name = _tmp12_;
	g_object_get (battery, "state", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == ((guint) 4)) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_strdup ("battery-full-charged-symbolic");
		_g_free0 (image_name);
		image_name = _tmp15_;
		_tmp16_ = g_strdup (_ ("Battery fully charged."));
		_g_free0 (tip);
		tip = _tmp16_;
	} else {
		guint _tmp17_;
		guint _tmp18_;
		g_object_get (battery, "state", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == ((guint) 1)) {
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* time_to_full_str = NULL;
			gchar* _tmp23_;
			gint time_to_full = 0;
			gint64 _tmp24_;
			gint64 _tmp25_;
			gdouble _tmp27_;
			gdouble _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp19_ = image_name;
			_tmp20_ = g_strconcat (_tmp19_, "-charging-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp20_;
			_tmp21_ = image_fallback;
			_tmp22_ = g_strconcat (_tmp21_, "-charging-symbolic", NULL);
			_g_free0 (image_fallback);
			image_fallback = _tmp22_;
			_tmp23_ = g_strdup (_ ("Unknown"));
			time_to_full_str = _tmp23_;
			g_object_get (battery, "time-to-full", &_tmp24_, NULL);
			_tmp25_ = _tmp24_;
			time_to_full = (gint) _tmp25_;
			if (time_to_full > 0) {
				gint hours = 0;
				gint minutes = 0;
				gchar* _tmp26_;
				hours = time_to_full / (60 * 60);
				minutes = (time_to_full / 60) - (hours * 60);
				_tmp26_ = g_strdup_printf ("%d:%02d", hours, minutes);
				_g_free0 (time_to_full_str);
				time_to_full_str = _tmp26_;
			}
			g_object_get (battery, "percentage", &_tmp27_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = time_to_full_str;
			_tmp30_ = g_strdup_printf (": %d%% (%s)", (gint) _tmp28_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_ ("Battery charging"), _tmp31_, NULL);
			_g_free0 (tip);
			tip = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (time_to_full_str);
		} else {
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gint hours = 0;
			gint64 _tmp35_;
			gint64 _tmp36_;
			gint minutes = 0;
			gint64 _tmp37_;
			gint64 _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp33_ = image_name;
			_tmp34_ = g_strconcat (_tmp33_, "-symbolic", NULL);
			_g_free0 (image_name);
			image_name = _tmp34_;
			g_object_get (battery, "time-to-empty", &_tmp35_, NULL);
			_tmp36_ = _tmp35_;
			hours = ((gint) _tmp36_) / (60 * 60);
			g_object_get (battery, "time-to-empty", &_tmp37_, NULL);
			_tmp38_ = _tmp37_;
			minutes = (((gint) _tmp38_) / 60) - (hours * 60);
			g_object_get (battery, "percentage", &_tmp39_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf (": %d%% (%d:%02d)", (gint) _tmp40_, hours, minutes);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_ ("Battery remaining"), _tmp42_, NULL);
			_g_free0 (tip);
			tip = _tmp43_;
			_g_free0 (_tmp42_);
		}
	}
	g_object_get (battery, "percentage", &_tmp44_, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("%d%%", (gint) _tmp45_);
	labe = _tmp46_;
	_tmp47_ = self->priv->percent_label;
	_tmp48_ = gtk_label_get_label (_tmp47_);
	_tmp49_ = g_strdup (_tmp48_);
	old = _tmp49_;
	_tmp50_ = old;
	_tmp51_ = labe;
	if (g_strcmp0 (_tmp50_, _tmp51_) != 0) {
		GtkLabel* _tmp52_;
		const gchar* _tmp53_;
		_tmp52_ = self->priv->percent_label;
		_tmp53_ = labe;
		gtk_label_set_text (_tmp52_, _tmp53_);
	}
	_tmp54_ = tip;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp54_);
	_tmp55_ = gtk_icon_theme_get_default ();
	_tmp56_ = _g_object_ref0 (_tmp55_);
	theme = _tmp56_;
	_tmp57_ = theme;
	_tmp58_ = image_name;
	_tmp59_ = gtk_icon_theme_lookup_icon (_tmp57_, _tmp58_, (gint) GTK_ICON_SIZE_MENU, 0);
	_result_ = _tmp59_;
	_tmp61_ = _result_;
	if (_tmp61_ != NULL) {
		const gchar* _tmp62_;
		_tmp62_ = image_name;
		_tmp60_ = _tmp62_;
	} else {
		const gchar* _tmp63_;
		_tmp63_ = image_fallback;
		_tmp60_ = _tmp63_;
	}
	_tmp64_ = self->priv->image;
	gtk_image_set_from_icon_name (_tmp64_, _tmp60_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (_result_);
	_g_object_unref0 (theme);
	_g_free0 (old);
	_g_free0 (labe);
	_g_free0 (image_fallback);
	_g_free0 (image_name);
	_g_free0 (tip);
}

UpDevice*
battery_icon_get_battery (BatteryIcon* self)
{
	UpDevice* result;
	UpDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_battery;
	result = _tmp0_;
	return result;
}

void
battery_icon_set_battery (BatteryIcon* self,
                          UpDevice* value)
{
	UpDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = battery_icon_get_battery (self);
	if (old_value != value) {
		self->priv->_battery = value;
		g_object_notify_by_pspec ((GObject *) self, battery_icon_properties[BATTERY_ICON_BATTERY_PROPERTY]);
	}
}

gboolean
battery_icon_get_label_visible (BatteryIcon* self)
{
	gboolean result;
	GtkLabel* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->percent_label;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
battery_icon_set_label_visible (BatteryIcon* self,
                                gboolean value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->percent_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, battery_icon_properties[BATTERY_ICON_LABEL_VISIBLE_PROPERTY]);
}

static void
battery_icon_class_init (BatteryIconClass * klass,
                         gpointer klass_data)
{
	battery_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BatteryIcon_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_battery_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_battery_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = battery_icon_finalize;
	/** The battery associated with this icon */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BATTERY_ICON_BATTERY_PROPERTY, battery_icon_properties[BATTERY_ICON_BATTERY_PROPERTY] = g_param_spec_object ("battery", "battery", "battery", up_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Expose a simple property so the UI can update whether we show
	 * labels or not
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BATTERY_ICON_LABEL_VISIBLE_PROPERTY, battery_icon_properties[BATTERY_ICON_LABEL_VISIBLE_PROPERTY] = g_param_spec_boolean ("label-visible", "label-visible", "label-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
battery_icon_instance_init (BatteryIcon * self,
                            gpointer klass)
{
	self->priv = battery_icon_get_instance_private (self);
	self->priv->changing = FALSE;
	self->priv->emitted_warning = FALSE;
}

static void
battery_icon_finalize (GObject * obj)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATTERY_ICON, BatteryIcon);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->percent_label);
	G_OBJECT_CLASS (battery_icon_parent_class)->finalize (obj);
}

GType
battery_icon_get_type (void)
{
	return battery_icon_type_id;
}

GType
battery_icon_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BatteryIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) battery_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatteryIcon), 0, (GInstanceInitFunc) battery_icon_instance_init, NULL };
	battery_icon_type_id = g_type_module_register_type (module, gtk_box_get_type (), "BatteryIcon", &g_define_type_info, 0);
	BatteryIcon_private_offset = sizeof (BatteryIconPrivate);
	return battery_icon_type_id;
}

static void
_vala_battery_icon_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY_PROPERTY:
		g_value_set_object (value, battery_icon_get_battery (self));
		break;
		case BATTERY_ICON_LABEL_VISIBLE_PROPERTY:
		g_value_set_boolean (value, battery_icon_get_label_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_battery_icon_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	BatteryIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BATTERY_ICON, BatteryIcon);
	switch (property_id) {
		case BATTERY_ICON_BATTERY_PROPERTY:
		battery_icon_set_battery (self, g_value_get_object (value));
		break;
		case BATTERY_ICON_LABEL_VISIBLE_PROPERTY:
		battery_icon_set_label_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GHashTable**
power_profiles_dbus_get_profiles (PowerProfilesDBus* self,
                                  gint* result_length1)
{
	PowerProfilesDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_PROFILES_DBUS_GET_INTERFACE (self);
	if (_iface_->get_profiles) {
		return _iface_->get_profiles (self, result_length1);
	}
	return NULL;
}

gchar*
power_profiles_dbus_get_active_profile (PowerProfilesDBus* self)
{
	PowerProfilesDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = POWER_PROFILES_DBUS_GET_INTERFACE (self);
	if (_iface_->get_active_profile) {
		return _iface_->get_active_profile (self);
	}
	return NULL;
}

void
power_profiles_dbus_set_active_profile (PowerProfilesDBus* self,
                                        const gchar* value)
{
	PowerProfilesDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = POWER_PROFILES_DBUS_GET_INTERFACE (self);
	if (_iface_->set_active_profile) {
		_iface_->set_active_profile (self, value);
	}
}

static void
power_profiles_dbus_default_init (PowerProfilesDBusIface * iface,
                                  gpointer iface_data)
{
}

GType
power_profiles_dbus_get_type (void)
{
	return power_profiles_dbus_type_id;
}

GType
power_profiles_dbus_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerProfilesDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_profiles_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	power_profiles_dbus_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "PowerProfilesDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (power_profiles_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (power_profiles_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) power_profiles_dbus_proxy_get_type);
	g_type_set_qdata (power_profiles_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.hadess.PowerProfiles");
	g_type_set_qdata (power_profiles_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_power_profiles_dbus_dbus_interface_info));
	g_type_set_qdata (power_profiles_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) power_profiles_dbus_register_object);
	return power_profiles_dbus_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (PowerProfilesDBusProxy, power_profiles_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_POWER_PROFILES_DBUS, power_profiles_dbus_proxy_power_profiles_dbus_interface_init) )
static void
power_profiles_dbus_proxy_class_init (PowerProfilesDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = power_profiles_dbus_proxy_g_signal;
}

static void
power_profiles_dbus_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
}

static void
power_profiles_dbus_proxy_class_finalize (PowerProfilesDBusProxyClass* klass)
{
}

void
power_profiles_dbus_proxy_register_dynamic_type (GTypeModule* module)
{
	power_profiles_dbus_proxy_register_type (module);
}

static void
power_profiles_dbus_proxy_init (PowerProfilesDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_power_profiles_dbus_dbus_interface_info));
}

static GHashTable**
power_profiles_dbus_dbus_proxy_get_profiles (PowerProfilesDBus* self,
                                             gint* result_length1)
{
	GVariant *_inner_reply;
	GHashTable** _result;
	gint _result_length1;
	GHashTable** _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Profiles");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Profiles"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp0_ = g_new (GHashTable*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
	g_variant_iter_init (&_tmp1_, _inner_reply);
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
		GHashTable* _tmp3_;
		GVariantIter _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		if (_tmp0__size == _tmp0__length) {
			_tmp0__size = 2 * _tmp0__size;
			_tmp0_ = g_renew (GHashTable*, _tmp0_, _tmp0__size + 1);
		}
		_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp4_, _tmp2_);
		while (g_variant_iter_loop (&_tmp4_, "{?*}", &_tmp5_, &_tmp6_)) {
			g_hash_table_insert (_tmp3_, g_variant_dup_string (_tmp5_, NULL), g_variant_get_variant (_tmp6_));
		}
		_tmp0_[_tmp0__length++] = _tmp3_;
		g_variant_unref (_tmp2_);
	}
	_result_length1 = _tmp0__length1;
	_tmp0_[_tmp0__length] = NULL;
	_result = _tmp0_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
power_profiles_dbus_dbus_proxy_get_active_profile (PowerProfilesDBus* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ActiveProfile");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActiveProfile"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
power_profiles_dbus_dbus_proxy_set_active_profile (PowerProfilesDBus* self,
                                                   const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.PowerProfiles"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActiveProfile"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
power_profiles_dbus_proxy_power_profiles_dbus_interface_init (PowerProfilesDBusIface* iface)
{
	iface->get_profiles = power_profiles_dbus_dbus_proxy_get_profiles;
	iface->get_active_profile = power_profiles_dbus_dbus_proxy_get_active_profile;
	iface->set_active_profile = power_profiles_dbus_dbus_proxy_set_active_profile;
}

static void
power_profiles_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_power_profiles_dbus_get_profiles (PowerProfilesDBus* self)
{
	GHashTable** result;
	gint result_length1 = 0;
	GVariant* _reply;
	GHashTable** _tmp7_;
	GVariantBuilder _tmp8_;
	gint _tmp9_;
	result = power_profiles_dbus_get_profiles (self, &result_length1);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		GVariantBuilder _tmp10_;
		GHashTableIter _tmp11_;
		gpointer _tmp12_;
		gpointer _tmp13_;
		g_hash_table_iter_init (&_tmp11_, *_tmp7_);
		g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp11_, &_tmp12_, &_tmp13_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp12_;
			_value = (GVariant*) _tmp13_;
			g_variant_builder_add (&_tmp10_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp8_, g_variant_builder_end (&_tmp10_));
		_tmp7_++;
	}
	_reply = g_variant_builder_end (&_tmp8_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	return _reply;
}

static GVariant*
_dbus_power_profiles_dbus_get_active_profile (PowerProfilesDBus* self)
{
	gchar* result;
	GVariant* _reply;
	result = power_profiles_dbus_get_active_profile (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
power_profiles_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Profiles") == 0) {
		return _dbus_power_profiles_dbus_get_profiles (object);
	} else if (strcmp (property_name, "ActiveProfile") == 0) {
		return _dbus_power_profiles_dbus_get_active_profile (object);
	}
	return NULL;
}

static void
_dbus_power_profiles_dbus_set_active_profile (PowerProfilesDBus* self,
                                              GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	power_profiles_dbus_set_active_profile (self, value);
	_g_free0 (value);
}

static gboolean
power_profiles_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "ActiveProfile") == 0) {
		_dbus_power_profiles_dbus_set_active_profile (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
power_profiles_dbus_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_power_profiles_dbus_dbus_interface_info), &_power_profiles_dbus_dbus_interface_vtable, data, _power_profiles_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_power_profiles_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PowerProfilesOption* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->profiles_proxy);
		_g_free0 (_data2_->profile_name);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda34_ (Block2Data* _data2_)
{
	PowerProfilesOption* self;
	self = _data2_->self;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self)) {
		power_profiles_dbus_set_active_profile (_data2_->profiles_proxy, _data2_->profile_name);
	}
}

static void
___lambda34__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda34_ (self);
}

PowerProfilesOption*
power_profiles_option_construct (GType object_type,
                                 PowerProfilesDBus* profiles_proxy,
                                 const gchar* profile_name,
                                 const gchar* display_name)
{
	PowerProfilesOption * self = NULL;
	Block2Data* _data2_;
	PowerProfilesDBus* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (profiles_proxy != NULL, NULL);
	g_return_val_if_fail (profile_name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (profiles_proxy);
	_g_object_unref0 (_data2_->profiles_proxy);
	_data2_->profiles_proxy = _tmp0_;
	_tmp1_ = g_strdup (profile_name);
	_g_free0 (_data2_->profile_name);
	_data2_->profile_name = _tmp1_;
	self = (PowerProfilesOption*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	gtk_button_set_label ((GtkButton*) self, display_name);
	g_signal_connect_data ((GtkToggleButton*) self, "toggled", (GCallback) ___lambda34__gtk_toggle_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

PowerProfilesOption*
power_profiles_option_new (PowerProfilesDBus* profiles_proxy,
                           const gchar* profile_name,
                           const gchar* display_name)
{
	return power_profiles_option_construct (TYPE_POWER_PROFILES_OPTION, profiles_proxy, profile_name, display_name);
}

static void
power_profiles_option_class_init (PowerProfilesOptionClass * klass,
                                  gpointer klass_data)
{
	power_profiles_option_parent_class = g_type_class_peek_parent (klass);
}

static void
power_profiles_option_instance_init (PowerProfilesOption * self,
                                     gpointer klass)
{
}

GType
power_profiles_option_get_type (void)
{
	return power_profiles_option_type_id;
}

GType
power_profiles_option_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerProfilesOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_profiles_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerProfilesOption), 0, (GInstanceInitFunc) power_profiles_option_instance_init, NULL };
	power_profiles_option_type_id = g_type_module_register_type (module, gtk_radio_button_get_type (), "PowerProfilesOption", &g_define_type_info, 0);
	return power_profiles_option_type_id;
}

static inline gpointer
power_profiles_selector_get_instance_private (PowerProfilesSelector* self)
{
	return G_STRUCT_MEMBER_P (self, PowerProfilesSelector_private_offset);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PowerProfilesSelector* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->profiles_proxy);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
__lambda35_ (Block3Data* _data3_)
{
	PowerProfilesSelector* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data3_->self;
	_tmp0_ = power_profiles_dbus_get_active_profile (_data3_->profiles_proxy);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	power_profiles_selector_on_active_profile_changed (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda35__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	__lambda35_ (self);
}

PowerProfilesSelector*
power_profiles_selector_construct (GType object_type,
                                   PowerProfilesDBus* profiles_proxy)
{
	PowerProfilesSelector * self = NULL;
	Block3Data* _data3_;
	PowerProfilesDBus* _tmp0_;
	GHashTable* profiles = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	GHashTable** _tmp6_;
	gint _tmp6__length1;
	GHashTable* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp20_;
	GtkSeparator* _tmp21_;
	GtkLabel* header = NULL;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkBox* power_profiles_radio_box = NULL;
	GtkBox* _tmp28_;
	GtkRadioButton* radio_group = NULL;
	GHashTable* _tmp29_;
	GHashTable* _tmp37_;
	GHashTable* _tmp45_;
	GtkBox* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	g_return_val_if_fail (profiles_proxy != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (profiles_proxy);
	_g_object_unref0 (_data3_->profiles_proxy);
	_data3_->profiles_proxy = _tmp0_;
	self = (PowerProfilesSelector*) g_object_new (object_type, NULL);
	_data3_->self = g_object_ref (self);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_free0_);
	profiles = _tmp3_;
	_tmp4_ = power_profiles_dbus_get_profiles (_data3_->profiles_proxy, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	{
		GHashTable** profile_collection = NULL;
		gint profile_collection_length1 = 0;
		gint _profile_collection_size_ = 0;
		gint profile_it = 0;
		profile_collection = _tmp6_;
		profile_collection_length1 = _tmp6__length1;
		for (profile_it = 0; profile_it < profile_collection_length1; profile_it = profile_it + 1) {
			GHashTable* _tmp7_;
			GHashTable* profile = NULL;
			_tmp7_ = _g_hash_table_ref0 (profile_collection[profile_it]);
			profile = _tmp7_;
			{
				GVariant* profile_value = NULL;
				GHashTable* _tmp8_;
				gconstpointer _tmp9_;
				GVariant* _tmp10_;
				GVariant* _tmp11_;
				const GVariantType* _tmp12_;
				GHashTable* _tmp13_;
				GVariant* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp8_ = profile;
				_tmp9_ = g_hash_table_lookup (_tmp8_, "Profile");
				_tmp10_ = _g_variant_ref0 ((GVariant*) _tmp9_);
				profile_value = _tmp10_;
				_tmp11_ = profile_value;
				_tmp12_ = G_VARIANT_TYPE_STRING;
				if (!g_variant_is_of_type (_tmp11_, _tmp12_)) {
					_g_variant_unref0 (profile_value);
					_g_hash_table_unref0 (profile);
					continue;
				}
				_tmp13_ = profiles;
				_tmp14_ = profile_value;
				_tmp15_ = g_variant_get_string (_tmp14_, NULL);
				_tmp16_ = g_strdup (_tmp15_);
				g_hash_table_add (_tmp13_, _tmp16_);
				_g_variant_unref0 (profile_value);
				_g_hash_table_unref0 (profile);
			}
		}
		profile_collection = (_vala_array_free (profile_collection, profile_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	}
	_tmp17_ = profiles;
	_tmp18_ = g_hash_table_size (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ < ((guint) 2)) {
		_g_hash_table_unref0 (profiles);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return self;
	}
	_tmp20_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp20_);
	sep = _tmp20_;
	_tmp21_ = sep;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp21_, FALSE, FALSE, (guint) 1);
	_tmp22_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp22_);
	header = _tmp22_;
	_tmp23_ = header;
	_tmp24_ = g_strdup_printf ("<b>%s</b>", _ ("Performance Mode"));
	_tmp25_ = _tmp24_;
	gtk_label_set_markup (_tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = header;
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_START);
	_tmp27_ = header;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp28_);
	power_profiles_radio_box = _tmp28_;
	radio_group = NULL;
	_tmp29_ = profiles;
	if (g_hash_table_contains (_tmp29_, "power-saver")) {
		PowerProfilesOption* _tmp30_;
		PowerProfilesOption* _tmp31_;
		GtkRadioButton* _tmp32_;
		PowerProfilesOption* _tmp33_;
		GtkRadioButton* _tmp34_;
		GtkBox* _tmp35_;
		PowerProfilesOption* _tmp36_;
		_tmp30_ = power_profiles_option_new (_data3_->profiles_proxy, "power-saver", _ ("Power Saver"));
		g_object_ref_sink (_tmp30_);
		_g_object_unref0 (self->priv->radio_power_save);
		self->priv->radio_power_save = _tmp30_;
		_tmp31_ = self->priv->radio_power_save;
		_tmp32_ = radio_group;
		gtk_radio_button_join_group ((GtkRadioButton*) _tmp31_, _tmp32_);
		_tmp33_ = self->priv->radio_power_save;
		_tmp34_ = _g_object_ref0 ((GtkRadioButton*) _tmp33_);
		_g_object_unref0 (radio_group);
		radio_group = _tmp34_;
		_tmp35_ = power_profiles_radio_box;
		_tmp36_ = self->priv->radio_power_save;
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 1);
	}
	_tmp37_ = profiles;
	if (g_hash_table_contains (_tmp37_, "balanced")) {
		PowerProfilesOption* _tmp38_;
		PowerProfilesOption* _tmp39_;
		GtkRadioButton* _tmp40_;
		PowerProfilesOption* _tmp41_;
		GtkRadioButton* _tmp42_;
		GtkBox* _tmp43_;
		PowerProfilesOption* _tmp44_;
		_tmp38_ = power_profiles_option_new (_data3_->profiles_proxy, "balanced", _ ("Balanced"));
		g_object_ref_sink (_tmp38_);
		_g_object_unref0 (self->priv->radio_power_balanced);
		self->priv->radio_power_balanced = _tmp38_;
		_tmp39_ = self->priv->radio_power_balanced;
		_tmp40_ = radio_group;
		gtk_radio_button_join_group ((GtkRadioButton*) _tmp39_, _tmp40_);
		_tmp41_ = self->priv->radio_power_balanced;
		_tmp42_ = _g_object_ref0 ((GtkRadioButton*) _tmp41_);
		_g_object_unref0 (radio_group);
		radio_group = _tmp42_;
		_tmp43_ = power_profiles_radio_box;
		_tmp44_ = self->priv->radio_power_balanced;
		gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 1);
	}
	_tmp45_ = profiles;
	if (g_hash_table_contains (_tmp45_, "performance")) {
		PowerProfilesOption* _tmp46_;
		PowerProfilesOption* _tmp47_;
		GtkRadioButton* _tmp48_;
		PowerProfilesOption* _tmp49_;
		GtkRadioButton* _tmp50_;
		GtkBox* _tmp51_;
		PowerProfilesOption* _tmp52_;
		_tmp46_ = power_profiles_option_new (_data3_->profiles_proxy, "performance", _ ("Performance"));
		g_object_ref_sink (_tmp46_);
		_g_object_unref0 (self->priv->radio_power_performance);
		self->priv->radio_power_performance = _tmp46_;
		_tmp47_ = self->priv->radio_power_performance;
		_tmp48_ = radio_group;
		gtk_radio_button_join_group ((GtkRadioButton*) _tmp47_, _tmp48_);
		_tmp49_ = self->priv->radio_power_performance;
		_tmp50_ = _g_object_ref0 ((GtkRadioButton*) _tmp49_);
		_g_object_unref0 (radio_group);
		radio_group = _tmp50_;
		_tmp51_ = power_profiles_radio_box;
		_tmp52_ = self->priv->radio_power_performance;
		gtk_box_pack_start (_tmp51_, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 1);
	}
	_tmp53_ = power_profiles_radio_box;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp53_, TRUE, TRUE, (guint) 0);
	_tmp54_ = power_profiles_dbus_get_active_profile (_data3_->profiles_proxy);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp55_;
	power_profiles_selector_on_active_profile_changed (self, _tmp56_);
	_g_free0 (_tmp56_);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data3_->profiles_proxy, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ___lambda35__g_dbus_proxy_g_properties_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (radio_group);
	_g_object_unref0 (power_profiles_radio_box);
	_g_object_unref0 (header);
	_g_object_unref0 (sep);
	_g_hash_table_unref0 (profiles);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

PowerProfilesSelector*
power_profiles_selector_new (PowerProfilesDBus* profiles_proxy)
{
	return power_profiles_selector_construct (TYPE_POWER_PROFILES_SELECTOR, profiles_proxy);
}

static void
power_profiles_selector_on_active_profile_changed (PowerProfilesSelector* self,
                                                   const gchar* active_profile)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_profile != NULL);
	_tmp0_ = active_profile;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("power-saver")))) {
		switch (0) {
			default:
			{
				PowerProfilesOption* _tmp3_;
				_tmp3_ = self->priv->radio_power_save;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("balanced")))) {
		switch (0) {
			default:
			{
				PowerProfilesOption* _tmp4_;
				_tmp4_ = self->priv->radio_power_balanced;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp4_, TRUE);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("performance")))) {
		switch (0) {
			default:
			{
				PowerProfilesOption* _tmp5_;
				_tmp5_ = self->priv->radio_power_performance;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, TRUE);
				break;
			}
		}
	}
}

static void
power_profiles_selector_class_init (PowerProfilesSelectorClass * klass,
                                    gpointer klass_data)
{
	power_profiles_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerProfilesSelector_private_offset);
	G_OBJECT_CLASS (klass)->finalize = power_profiles_selector_finalize;
}

static void
power_profiles_selector_instance_init (PowerProfilesSelector * self,
                                       gpointer klass)
{
	self->priv = power_profiles_selector_get_instance_private (self);
}

static void
power_profiles_selector_finalize (GObject * obj)
{
	PowerProfilesSelector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POWER_PROFILES_SELECTOR, PowerProfilesSelector);
	_g_object_unref0 (self->priv->radio_power_save);
	_g_object_unref0 (self->priv->radio_power_balanced);
	_g_object_unref0 (self->priv->radio_power_performance);
	G_OBJECT_CLASS (power_profiles_selector_parent_class)->finalize (obj);
}

GType
power_profiles_selector_get_type (void)
{
	return power_profiles_selector_type_id;
}

GType
power_profiles_selector_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerProfilesSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_profiles_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerProfilesSelector), 0, (GInstanceInitFunc) power_profiles_selector_instance_init, NULL };
	power_profiles_selector_type_id = g_type_module_register_type (module, gtk_box_get_type (), "PowerProfilesSelector", &g_define_type_info, 0);
	PowerProfilesSelector_private_offset = sizeof (PowerProfilesSelectorPrivate);
	return power_profiles_selector_type_id;
}

static inline gpointer
power_indicator_get_instance_private (PowerIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, PowerIndicator_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_power_indicator_open_power_settings_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	power_indicator_open_power_settings ((PowerIndicator*) self);
}

static void
_power_indicator_has_power_profiles_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                 const gchar* name,
                                                                 const gchar* name_owner,
                                                                 gpointer self)
{
	power_indicator_has_power_profiles ((PowerIndicator*) self);
}

static void
_power_indicator_lost_power_profiles_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self)
{
	power_indicator_lost_power_profiles ((PowerIndicator*) self);
}

static void
_power_indicator_on_device_added_up__client_device_added (UpClient* _sender,
                                                          UpDevice* device,
                                                          gpointer self)
{
	power_indicator_on_device_added ((PowerIndicator*) self, device);
}

static void
_power_indicator_on_device_removed_up__client_device_removed (UpClient* _sender,
                                                              const gchar* object_path,
                                                              gpointer self)
{
	power_indicator_on_device_removed ((PowerIndicator*) self, object_path);
}

PowerIndicator*
power_indicator_construct (GType object_type)
{
	PowerIndicator * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkEventBox* _tmp8_;
	BudgiePopover* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	BudgiePopover* _tmp12_;
	GtkBox* _tmp13_;
	GtkButton* button = NULL;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkWidget* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	UpClient* _tmp19_;
	UpClient* _tmp20_;
	UpClient* _tmp21_;
	UpClient* _tmp22_;
	self = (PowerIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp2_;
	_tmp3_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp3_;
	_tmp4_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 2);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp5_;
	_tmp6_ = self->ebox;
	_tmp7_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->ebox;
	_tmp9_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp10_;
	_tmp11_ = self->priv->box;
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 6);
	_tmp12_ = self->popover;
	_tmp13_ = self->priv->box;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_ ("Power settings"));
	g_object_ref_sink (_tmp14_);
	button = _tmp14_;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) button);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_FLAT);
	g_signal_connect_object (button, "clicked", (GCallback) _power_indicator_open_power_settings_gtk_button_clicked, self, 0);
	_tmp16_ = gtk_bin_get_child ((GtkBin*) button);
	gtk_widget_set_halign (_tmp16_, GTK_ALIGN_START);
	_tmp17_ = self->priv->box;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	_tmp18_ = self->priv->box;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = up_client_new ();
	_tmp20_ = _tmp19_;
	power_indicator_set_client (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, POWER_PROFILES_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_power_indicator_has_power_profiles_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _power_indicator_has_power_profiles_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_power_indicator_lost_power_profiles_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _power_indicator_lost_power_profiles_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	power_indicator_sync_devices (self);
	_tmp21_ = self->priv->_client;
	g_signal_connect_object (_tmp21_, "device-added", (GCallback) _power_indicator_on_device_added_up__client_device_added, self, 0);
	_tmp22_ = self->priv->_client;
	g_signal_connect_object (_tmp22_, "device-removed", (GCallback) _power_indicator_on_device_removed_up__client_device_removed, self, 0);
	power_indicator_toggle_show (self);
	_g_object_unref0 (button);
	return self;
}

PowerIndicator*
power_indicator_new (void)
{
	return power_indicator_construct (TYPE_POWER_INDICATOR);
}

static void
_power_indicator_on_proxy_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	power_indicator_on_proxy_get ((PowerIndicator*) self, source_object, res);
	g_object_unref (self);
}

static void
power_indicator_has_power_profiles (PowerIndicator* self)
{
	PowerProfilesDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->profiles_proxy;
	if (_tmp0_ != NULL) {
		power_indicator_create_power_profiles_options (self);
		return;
	}
	g_async_initable_new_async (TYPE_POWER_PROFILES_DBUS_PROXY, 0, NULL, _power_indicator_on_proxy_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", POWER_PROFILES_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", POWER_PROFILES_DBUS_OBJECT_NAME, "g-interface-name", "net.hadess.PowerProfiles", NULL);
}

static void
power_indicator_lost_power_profiles (PowerIndicator* self)
{
	PowerProfilesSelector* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_profiles_selector;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
power_indicator_on_proxy_get (PowerIndicator* self,
                              GObject* o,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PowerProfilesDBus* _tmp0_ = NULL;
		PowerProfilesDBus* _tmp1_;
		PowerProfilesDBus* _tmp2_;
		PowerProfilesDBus* _tmp3_;
		PowerProfilesDBus* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (PowerProfilesDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (PowerProfilesDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->profiles_proxy);
		self->priv->profiles_proxy = _tmp3_;
		_tmp4_ = self->priv->profiles_proxy;
		_tmp5_ = power_profiles_dbus_get_active_profile (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ != NULL;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			power_indicator_create_power_profiles_options (self);
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("PowerIndicator.vala:314: unable to connect to net.hadess.PowerProfiles" \
": %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
power_indicator_create_power_profiles_options (PowerIndicator* self)
{
	PowerProfilesDBus* _tmp0_;
	PowerProfilesSelector* _tmp1_;
	GtkBox* _tmp2_;
	PowerProfilesSelector* _tmp3_;
	GtkBox* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->profiles_proxy;
	_tmp1_ = power_profiles_selector_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->power_profiles_selector);
	self->priv->power_profiles_selector = _tmp1_;
	_tmp2_ = self->priv->box;
	_tmp3_ = self->priv->power_profiles_selector;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	_tmp4_ = self->priv->box;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
}

void
power_indicator_change_orientation (PowerIndicator* self,
                                    GtkOrientation orient)
{
	gint _tmp0_ = 0;
	gint spacing = 0;
	BatteryIcon* icon = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	GtkBox* _tmp6_;
	g_return_if_fail (self != NULL);
	if (orient == GTK_ORIENTATION_VERTICAL) {
		_tmp0_ = 5;
	} else {
		_tmp0_ = 0;
	}
	spacing = _tmp0_;
	icon = NULL;
	_tmp1_ = self->priv->devices;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_;
		BatteryIcon* _tmp4_;
		BatteryIcon* _tmp5_;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp2_));
		icon = (BatteryIcon*) _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = icon;
		gtk_box_set_spacing ((GtkBox*) _tmp4_, spacing);
		_tmp5_ = icon;
		gtk_orientable_set_orientation ((GtkOrientable*) _tmp5_, orient);
	}
	_tmp6_ = self->priv->widget;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, orient);
}

void
power_indicator_update_labels (PowerIndicator* self,
                               gboolean visible)
{
	BatteryIcon* icon = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_;
	GtkWidget* _tmp5_;
	g_return_if_fail (self != NULL);
	power_indicator_set_label_visible (self, visible);
	icon = NULL;
	_tmp0_ = self->priv->devices;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		BatteryIcon* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		icon = (BatteryIcon*) _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = icon;
		_tmp4_ = self->priv->_label_visible;
		battery_icon_set_label_visible (_tmp3_, _tmp4_);
	}
	_tmp5_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_queue_draw (_tmp5_);
}

static gboolean
power_indicator_is_interesting (PowerIndicator* self,
                                UpDevice* device)
{
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	g_object_get (device, "kind", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == ((guint) UP_DEVICE_KIND_BATTERY);
	return result;
}

static void
power_indicator_open_power_settings (PowerIndicator* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("budgie-power-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("PowerIndicator.vala:361: Unable to launch gnome-power-panel.desktop: %" \
"s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

/**
 * Add a new device to the tree
 */
static void
power_indicator_on_device_added (PowerIndicator* self,
                                 UpDevice* device)
{
	gchar* object_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	BatteryIcon* icon = NULL;
	BatteryIcon* _tmp7_;
	BatteryIcon* _tmp8_;
	gboolean _tmp9_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	BatteryIcon* _tmp13_;
	BatteryIcon* _tmp14_;
	GtkBox* _tmp15_;
	BatteryIcon* _tmp16_;
	GtkBox* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = up_device_get_object_path (device);
	_tmp1_ = g_strdup (_tmp0_);
	object_path = _tmp1_;
	_tmp2_ = self->priv->devices;
	_tmp3_ = object_path;
	if (g_hash_table_contains (_tmp2_, _tmp3_)) {
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		gconstpointer _tmp6_;
		_tmp4_ = self->priv->devices;
		_tmp5_ = object_path;
		_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
		battery_icon_update_ui ((BatteryIcon*) _tmp6_, device);
		_g_free0 (object_path);
		return;
	}
	if (!power_indicator_is_interesting (self, device)) {
		_g_free0 (object_path);
		return;
	}
	_tmp7_ = battery_icon_new (device);
	g_object_ref_sink (_tmp7_);
	icon = _tmp7_;
	_tmp8_ = icon;
	_tmp9_ = self->priv->_label_visible;
	battery_icon_set_label_visible (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->devices;
	_tmp11_ = object_path;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = icon;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
	_tmp15_ = self->priv->widget;
	_tmp16_ = icon;
	gtk_box_pack_start (_tmp15_, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	_tmp17_ = self->priv->widget;
	power_indicator_change_orientation (self, gtk_orientable_get_orientation ((GtkOrientable*) _tmp17_));
	power_indicator_toggle_show (self);
	_g_object_unref0 (icon);
	_g_free0 (object_path);
}

static void
power_indicator_toggle_show (PowerIndicator* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	if (g_hash_table_size (_tmp0_) < ((guint) 1)) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_show_all ((GtkWidget*) self);
	}
}

/**
 * Remove a device from our display
 */
static void
power_indicator_on_device_removed (PowerIndicator* self,
                                   const gchar* object_path)
{
	GHashTable* _tmp0_;
	BatteryIcon* icon = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GtkBox* _tmp3_;
	BatteryIcon* _tmp4_;
	GHashTable* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->devices;
	if (!g_hash_table_contains (_tmp0_, object_path)) {
		return;
	}
	_tmp1_ = self->priv->devices;
	_tmp2_ = g_hash_table_lookup (_tmp1_, object_path);
	icon = (BatteryIcon*) _tmp2_;
	_tmp3_ = self->priv->widget;
	_tmp4_ = icon;
	gtk_container_remove ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->devices;
	g_hash_table_remove (_tmp5_, object_path);
	power_indicator_toggle_show (self);
}

static void
__lambda36_ (PowerIndicator* self,
             UpDevice* device)
{
	g_return_if_fail (device != NULL);
	power_indicator_on_device_added (self, device);
}

static void
___lambda36__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda36_ ((PowerIndicator*) self, (UpDevice*) data);
}

static void
power_indicator_sync_devices (PowerIndicator* self)
{
	GPtrArray* devices = NULL;
	UpClient* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_client;
	_tmp1_ = up_client_get_devices (_tmp0_);
	devices = _tmp1_;
	g_ptr_array_foreach (devices, ___lambda36__gfunc, self);
	power_indicator_toggle_show (self);
	_g_ptr_array_unref0 (devices);
}

UpClient*
power_indicator_get_client (PowerIndicator* self)
{
	UpClient* result;
	UpClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	result = _tmp0_;
	return result;
}

void
power_indicator_set_client (PowerIndicator* self,
                            UpClient* value)
{
	UpClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_client (self);
	if (old_value != value) {
		UpClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_client);
		self->priv->_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_CLIENT_PROPERTY]);
	}
}

gboolean
power_indicator_get_label_visible (PowerIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_label_visible;
	return result;
}

void
power_indicator_set_label_visible (PowerIndicator* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_label_visible (self);
	if (old_value != value) {
		self->priv->_label_visible = value;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_LABEL_VISIBLE_PROPERTY]);
	}
}

static void
power_indicator_class_init (PowerIndicatorClass * klass,
                            gpointer klass_data)
{
	power_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerIndicator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = power_indicator_finalize;
	/** Our upower client */
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_CLIENT_PROPERTY, power_indicator_properties[POWER_INDICATOR_CLIENT_PROPERTY] = g_param_spec_object ("client", "client", "client", up_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_LABEL_VISIBLE_PROPERTY, power_indicator_properties[POWER_INDICATOR_LABEL_VISIBLE_PROPERTY] = g_param_spec_boolean ("label-visible", "label-visible", "label-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
power_indicator_instance_init (PowerIndicator * self,
                               gpointer klass)
{
	self->priv = power_indicator_get_instance_private (self);
	self->ebox = NULL;
	self->popover = NULL;
	self->priv->widget = NULL;
	self->priv->box = NULL;
	self->priv->_label_visible = FALSE;
}

static void
power_indicator_finalize (GObject * obj)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POWER_INDICATOR, PowerIndicator);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->profiles_proxy);
	_g_object_unref0 (self->priv->power_profiles_selector);
	_g_object_unref0 (self->priv->_client);
	_g_hash_table_unref0 (self->priv->devices);
	G_OBJECT_CLASS (power_indicator_parent_class)->finalize (obj);
}

GType
power_indicator_get_type (void)
{
	return power_indicator_type_id;
}

GType
power_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerIndicator), 0, (GInstanceInitFunc) power_indicator_instance_init, NULL };
	power_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "PowerIndicator", &g_define_type_info, 0);
	PowerIndicator_private_offset = sizeof (PowerIndicatorPrivate);
	return power_indicator_type_id;
}

static void
_vala_power_indicator_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT_PROPERTY:
		g_value_set_object (value, power_indicator_get_client (self));
		break;
		case POWER_INDICATOR_LABEL_VISIBLE_PROPERTY:
		g_value_set_boolean (value, power_indicator_get_label_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_indicator_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POWER_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_CLIENT_PROPERTY:
		power_indicator_set_client (self, g_value_get_object (value));
		break;
		case POWER_INDICATOR_LABEL_VISIBLE_PROPERTY:
		power_indicator_set_label_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

