/* BluetoothIndicator.c generated by valac 0.56.14, the Vala compiler
 * generated from BluetoothIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 * Copyright © 2015 Alberts Muktupāvels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BluetoothIndicator is largely inspired by gnome-flashback.
 */

#include "statusapplet.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include "plugin.h"
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <upower.h>
#include <pango/pango.h>
#include <math.h>
#include <float.h>

#define BT_DEVICE_ROW_OBEX_AGENT "org.bluez.obex.Agent1"
#define BT_DEVICE_ROW_OBEX_PATH "/org/bluez/obex/budgie"
#define BT_DEVICE_ROW_SMARTPHONE_MASK ((guint32) 0x20C)
#define BT_DEVICE_ROW_DESKTOP_MASK ((guint32) 0x104)
#define BT_DEVICE_ROW_LAPTOP_MASK ((guint32) 0x10C)

#define TYPE_BLUETOOTH_CLIENT (bluetooth_client_get_type ())
#define BLUETOOTH_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLUETOOTH_CLIENT, BluetoothClient))
#define BLUETOOTH_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLUETOOTH_CLIENT, BluetoothClientClass))
#define IS_BLUETOOTH_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLUETOOTH_CLIENT))
#define IS_BLUETOOTH_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLUETOOTH_CLIENT))
#define BLUETOOTH_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLUETOOTH_CLIENT, BluetoothClientClass))

typedef struct _BluetoothClient BluetoothClient;
typedef struct _BluetoothClientClass BluetoothClientClass;
enum  {
	BLUETOOTH_INDICATOR_0_PROPERTY,
	BLUETOOTH_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* bluetooth_indicator_properties[BLUETOOTH_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
enum  {
	BT_DEVICE_ROW_0_PROPERTY,
	BT_DEVICE_ROW_DEVICE_PROPERTY,
	BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY,
	BT_DEVICE_ROW_UP_DEVICE_PROPERTY,
	BT_DEVICE_ROW_NUM_PROPERTIES
};
static GParamSpec* bt_device_row_properties[BT_DEVICE_ROW_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _BtDeviceRowToggleConnectionData BtDeviceRowToggleConnectionData;
enum  {
	BT_DEVICE_ROW_PROPERTIES_UPDATED_SIGNAL,
	BT_DEVICE_ROW_NUM_SIGNALS
};
static guint bt_device_row_signals[BT_DEVICE_ROW_NUM_SIGNALS] = {0};

struct _BluetoothIndicatorPrivate {
	GtkListBox* devices_box;
	GtkSwitch* bluetooth_switch;
	GtkLabel* placeholder_label;
	GtkLabel* placeholder_sublabel;
	BluetoothClient* client;
	ObexManager* obex_manager;
	gulong switch_handler_id;
};

struct _Block8Data {
	int _ref_count_;
	BluetoothIndicator* self;
	Device1* device;
};

struct _Block9Data {
	int _ref_count_;
	BluetoothIndicator* self;
	UpDevice* up_device;
};

struct _Block10Data {
	int _ref_count_;
	BluetoothIndicator* self;
	gchar* path;
};

struct _BTDeviceRowPrivate {
	GtkImage* image;
	GtkLabel* name_label;
	GtkRevealer* battery_revealer;
	GtkImage* battery_icon;
	GtkLabel* battery_label;
	GtkRevealer* revealer;
	GtkSpinner* spinner;
	GtkLabel* status_label;
	GtkButton* send_button;
	GtkButton* connection_button;
	GtkRevealer* progress_revealer;
	GtkLabel* file_label;
	GtkLabel* progress_label;
	GtkProgressBar* progress_bar;
	Device1* _device;
	ObexManager* _obex_manager;
	gulong up_handler_id;
	UpDevice* _up_device;
};

struct _BtDeviceRowToggleConnectionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BTDeviceRow* self;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GDBusConnection* conn;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	Transfer* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GtkSpinner* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkSpinner* _tmp18_;
	GtkRevealer* _tmp19_;
	Device1* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkLabel* _tmp23_;
	Device1* _tmp24_;
	GtkLabel* _tmp25_;
	Device1* _tmp26_;
	GError* _vala1_e;
	Device1* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GError* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	Device1* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GtkLabel* _tmp37_;
	GtkRevealer* _tmp38_;
	GtkSpinner* _tmp39_;
	GError* _inner_error0_;
};

static gint BluetoothIndicator_private_offset;
static gpointer bluetooth_indicator_parent_class = NULL;
static GType bluetooth_indicator_type_id = 0;
static gint BTDeviceRow_private_offset;
static gpointer bt_device_row_parent_class = NULL;
static GType bt_device_row_type_id = 0;

GType bluetooth_client_register_type (GTypeModule * module);
VALA_EXTERN GType bluetooth_client_get_type (void) G_GNUC_CONST ;
static gboolean bluetooth_indicator_on_button_released (BluetoothIndicator* self,
                                                 GdkEventButton* e);
VALA_EXTERN gboolean bluetooth_client_airplane_mode_enabled (BluetoothClient* self);
VALA_EXTERN void bluetooth_client_set_airplane_mode (BluetoothClient* self,
                                         gboolean enabled);
static void bluetooth_indicator_on_settings_activate (BluetoothIndicator* self);
static void bluetooth_indicator_on_switch_activate (BluetoothIndicator* self);
static void bluetooth_indicator_add_device (BluetoothIndicator* self,
                                     Device1* device);
static void __lambda22_ (BluetoothIndicator* self);
static void ___lambda22__bt_device_row_properties_updated (BTDeviceRow* _sender,
                                                    gpointer self);
static void bluetooth_indicator_remove_device (BluetoothIndicator* self,
                                        Device1* device);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda23_ (Block8Data* _data8_,
                  GtkWidget* row);
static void ___lambda23__gtk_callback (GtkWidget* widget,
                                gpointer self);
static gint bluetooth_indicator_sort_devices (BluetoothIndicator* self,
                                       GtkListBoxRow* a,
                                       GtkListBoxRow* b);
static gboolean bluetooth_indicator_filter_paired_devices (BluetoothIndicator* self,
                                                    GtkListBoxRow* row);
static void bluetooth_indicator_update_state_ui (BluetoothIndicator* self);
static GObject * bluetooth_indicator_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _bluetooth_indicator_on_button_released_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self);
VALA_EXTERN BluetoothClient* bluetooth_client_new (void);
VALA_EXTERN BluetoothClient* bluetooth_client_construct (GType object_type);
static void _bluetooth_indicator___lambda24_ (BluetoothIndicator* self,
                                       Device1* device);
static void __bluetooth_indicator___lambda24__bluetooth_client_device_added (BluetoothClient* _sender,
                                                                      Device1* device,
                                                                      gpointer self);
static void _bluetooth_indicator___lambda25_ (BluetoothIndicator* self,
                                       Device1* device);
static void __bluetooth_indicator___lambda25__bluetooth_client_device_removed (BluetoothClient* _sender,
                                                                        Device1* device,
                                                                        gpointer self);
static void _bluetooth_indicator___lambda26_ (BluetoothIndicator* self,
                                       UpDevice* up_device);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda27_ (Block9Data* _data9_,
                  GtkWidget* row);
static void ___lambda27__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void __bluetooth_indicator___lambda26__bluetooth_client_upower_device_added (BluetoothClient* _sender,
                                                                             UpDevice* up_device,
                                                                             gpointer self);
static void _bluetooth_indicator___lambda28_ (BluetoothIndicator* self,
                                       const gchar* path);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda29_ (Block10Data* _data10_,
                  GtkWidget* row);
static void ___lambda29__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void __bluetooth_indicator___lambda28__bluetooth_client_upower_device_removed (BluetoothClient* _sender,
                                                                               const gchar* object_path,
                                                                               gpointer self);
static void _bluetooth_indicator_update_state_ui_bluetooth_client_airplane_mode_changed (BluetoothClient* _sender,
                                                                                  gpointer self);
static void _bluetooth_indicator___lambda30_ (BluetoothIndicator* self);
VALA_EXTERN gboolean bluetooth_client_get_has_adapter (BluetoothClient* self);
static void __bluetooth_indicator___lambda30__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _bluetooth_indicator_on_settings_activate_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _bluetooth_indicator_on_switch_activate_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static gboolean _bluetooth_indicator_filter_paired_devices_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                              gpointer self);
static gint _bluetooth_indicator_sort_devices_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                               GtkListBoxRow* row2,
                                                               gpointer self);
static void _bluetooth_indicator___lambda31_ (BluetoothIndicator* self,
                                       GtkListBoxRow* row);
static void __bluetooth_indicator___lambda31__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void bluetooth_indicator_finalize (GObject * obj);
static void bt_device_row_hide_progress_revealer (BTDeviceRow* self);
static void bt_device_row_toggle_connection_data_free (gpointer _data);
static gboolean bt_device_row_toggle_connection_co (BtDeviceRowToggleConnectionData* _data_);
static void bt_device_row_toggle_connection_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void bt_device_row_transfer_active (BTDeviceRow* self,
                                    const gchar* address);
static void bt_device_row_update_transfer_progress (BTDeviceRow* self);
static void bt_device_row_transfer_added (BTDeviceRow* self,
                                   const gchar* address,
                                   Transfer* transfer);
static void bt_device_row_transfer_removed (BTDeviceRow* self,
                                     Transfer* transfer);
static void bt_device_row_update_battery (BTDeviceRow* self);
static void bt_device_row_update_status (BTDeviceRow* self);
static void _bt_device_row_up_device___lambda19_ (BTDeviceRow* self);
static void __bt_device_row_up_device___lambda19__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static GObject * bt_device_row_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void _bt_device_row_transfer_active_obex_manager_transfer_active (ObexManager* _sender,
                                                                  const gchar* address,
                                                                  gpointer self);
static void _bt_device_row_transfer_added_obex_manager_transfer_added (ObexManager* _sender,
                                                                const gchar* address,
                                                                Transfer* transfer,
                                                                gpointer self);
static void _bt_device_row_transfer_removed_obex_manager_transfer_removed (ObexManager* _sender,
                                                                    Transfer* transfer,
                                                                    gpointer self);
static void _bt_device_row___lambda20_ (BTDeviceRow* self);
static void __bt_device_row___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _bt_device_row___lambda21_ (BTDeviceRow* self);
static void __bt_device_row___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _bt_device_row_update_status_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                     GVariant* changed_properties,
                                                                     gchar** invalidated_properties,
                                                                     gpointer self);
static void bt_device_row_finalize (GObject * obj);
static void _vala_bt_device_row_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_bt_device_row_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bluetooth_indicator_get_instance_private (BluetoothIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothIndicator_private_offset);
}

static gboolean
bluetooth_indicator_on_button_released (BluetoothIndicator* self,
                                        GdkEventButton* e)
{
	gboolean enabled = FALSE;
	BluetoothClient* _tmp0_;
	BluetoothClient* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button != ((guint) GDK_BUTTON_MIDDLE)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->client;
	enabled = bluetooth_client_airplane_mode_enabled (_tmp0_);
	_tmp1_ = self->priv->client;
	bluetooth_client_set_airplane_mode (_tmp1_, !enabled);
	result = GDK_EVENT_STOP;
	return result;
}

static void
bluetooth_indicator_on_settings_activate (BluetoothIndicator* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("budgie-bluetooth-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("BluetoothIndicator.vala:206: Unable to launch budgie-bluetooth-panel.d" \
"esktop: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

static void
bluetooth_indicator_on_switch_activate (BluetoothIndicator* self)
{
	gboolean active = FALSE;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BluetoothClient* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bluetooth_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	_tmp3_ = self->priv->client;
	bluetooth_client_set_airplane_mode (_tmp3_, !active);
}

static void
__lambda22_ (BluetoothIndicator* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	_tmp0_ = self->priv->devices_box;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp1_ = self->priv->devices_box;
	gtk_list_box_invalidate_sort (_tmp1_);
}

static void
___lambda22__bt_device_row_properties_updated (BTDeviceRow* _sender,
                                               gpointer self)
{
	__lambda22_ ((BluetoothIndicator*) self);
}

static void
bluetooth_indicator_add_device (BluetoothIndicator* self,
                                Device1* device)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BTDeviceRow* widget = NULL;
	ObexManager* _tmp3_;
	BTDeviceRow* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device1_get_alias (device);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("BluetoothIndicator.vala:217: Bluetooth device added: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->obex_manager;
	_tmp4_ = bt_device_row_new (device, _tmp3_);
	g_object_ref_sink (_tmp4_);
	widget = _tmp4_;
	g_signal_connect_object (widget, "properties-updated", (GCallback) ___lambda22__bt_device_row_properties_updated, self, 0);
	_tmp5_ = self->priv->devices_box;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) widget);
	_tmp6_ = self->priv->devices_box;
	gtk_list_box_invalidate_filter (_tmp6_);
	_tmp7_ = self->priv->devices_box;
	gtk_list_box_invalidate_sort (_tmp7_);
	_g_object_unref0 (widget);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BluetoothIndicator* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->device);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda23_ (Block8Data* _data8_,
             GtkWidget* row)
{
	BluetoothIndicator* self;
	BTDeviceRow* child = NULL;
	BTDeviceRow* _tmp0_;
	BTDeviceRow* _tmp1_;
	Device1* _tmp2_;
	Device1* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	self = _data8_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (IS_BT_DEVICE_ROW (row) ? ((BTDeviceRow*) row) : NULL);
	child = _tmp0_;
	_tmp1_ = child;
	_tmp2_ = bt_device_row_get_device (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = device1_get_address (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = device1_get_address (_data8_->device);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strcmp0 (_tmp6_, _tmp9_) == 0;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	if (_tmp10_) {
		gtk_widget_destroy (row);
	}
	_g_object_unref0 (child);
}

static void
___lambda23__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda23_ (self, widget);
}

static void
bluetooth_indicator_remove_device (BluetoothIndicator* self,
                                   Device1* device)
{
	Block8Data* _data8_;
	Device1* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data8_->device);
	_data8_->device = _tmp0_;
	_tmp1_ = device1_get_alias (_data8_->device);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_debug ("BluetoothIndicator.vala:232: Bluetooth device removed: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->devices_box;
	gtk_container_foreach ((GtkContainer*) _tmp4_, ___lambda23__gtk_callback, _data8_);
	_tmp5_ = self->priv->devices_box;
	gtk_list_box_invalidate_filter (_tmp5_);
	_tmp6_ = self->priv->devices_box;
	gtk_list_box_invalidate_sort (_tmp6_);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

/**
 * Sorts items based on their names and connection status.
 *
 * Items are sorted alphabetically, with connected devices at the top of the list.
 */
static gint
bluetooth_indicator_sort_devices (BluetoothIndicator* self,
                                  GtkListBoxRow* a,
                                  GtkListBoxRow* b)
{
	BTDeviceRow* a_device = NULL;
	BTDeviceRow* _tmp0_;
	BTDeviceRow* b_device = NULL;
	BTDeviceRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BTDeviceRow* _tmp3_;
	Device1* _tmp4_;
	Device1* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (IS_BT_DEVICE_ROW (a) ? ((BTDeviceRow*) a) : NULL);
	a_device = _tmp0_;
	_tmp1_ = _g_object_ref0 (IS_BT_DEVICE_ROW (b) ? ((BTDeviceRow*) b) : NULL);
	b_device = _tmp1_;
	_tmp3_ = a_device;
	_tmp4_ = bt_device_row_get_device (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = device1_get_connected (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		BTDeviceRow* _tmp8_;
		Device1* _tmp9_;
		Device1* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp8_ = b_device;
		_tmp9_ = bt_device_row_get_device (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = device1_get_connected (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GCompareFunc _tmp13_;
		BTDeviceRow* _tmp14_;
		Device1* _tmp15_;
		Device1* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		BTDeviceRow* _tmp20_;
		Device1* _tmp21_;
		Device1* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gint _tmp26_;
		_tmp13_ = ((GCompareFunc) g_strcmp0);
		_tmp14_ = a_device;
		_tmp15_ = bt_device_row_get_device (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = device1_get_alias (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = b_device;
		_tmp21_ = bt_device_row_get_device (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = device1_get_alias (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp13_ (_tmp19_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp19_);
		result = _tmp26_;
		_g_object_unref0 (b_device);
		_g_object_unref0 (a_device);
		return result;
	} else {
		BTDeviceRow* _tmp27_;
		Device1* _tmp28_;
		Device1* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp27_ = a_device;
		_tmp28_ = bt_device_row_get_device (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = device1_get_connected (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_) {
			result = -1;
			_g_object_unref0 (b_device);
			_g_object_unref0 (a_device);
			return result;
		} else {
			BTDeviceRow* _tmp32_;
			Device1* _tmp33_;
			Device1* _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			_tmp32_ = b_device;
			_tmp33_ = bt_device_row_get_device (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = device1_get_connected (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_) {
				result = 1;
				_g_object_unref0 (b_device);
				_g_object_unref0 (a_device);
				return result;
			} else {
				GCompareFunc _tmp37_;
				BTDeviceRow* _tmp38_;
				Device1* _tmp39_;
				Device1* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				BTDeviceRow* _tmp44_;
				Device1* _tmp45_;
				Device1* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gint _tmp50_;
				_tmp37_ = ((GCompareFunc) g_strcmp0);
				_tmp38_ = a_device;
				_tmp39_ = bt_device_row_get_device (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = device1_get_alias (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _tmp42_;
				_tmp44_ = b_device;
				_tmp45_ = bt_device_row_get_device (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = device1_get_alias (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_;
				_tmp50_ = _tmp37_ (_tmp43_, _tmp49_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp43_);
				result = _tmp50_;
				_g_object_unref0 (b_device);
				_g_object_unref0 (a_device);
				return result;
			}
		}
	}
}

/**
 * Filters out any unpaired devices from our listbox.
 */
static gboolean
bluetooth_indicator_filter_paired_devices (BluetoothIndicator* self,
                                           GtkListBoxRow* row)
{
	BluetoothClient* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Device1* _tmp2_;
	Device1* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->client;
	if (bluetooth_client_airplane_mode_enabled (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = bt_device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (row, TYPE_BT_DEVICE_ROW, BTDeviceRow));
	_tmp3_ = _tmp2_;
	_tmp4_ = device1_get_paired (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		Device1* _tmp6_;
		Device1* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = bt_device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (row, TYPE_BT_DEVICE_ROW, BTDeviceRow));
		_tmp7_ = _tmp6_;
		_tmp8_ = device1_get_connected (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp1_ = _tmp9_;
	}
	result = _tmp1_;
	return result;
}

/**
 * Update the tray icon and Bluetooth switch state to reflect the current
 * state of airplane mode.
 */
static void
bluetooth_indicator_update_state_ui (BluetoothIndicator* self)
{
	gboolean enabled = FALSE;
	BluetoothClient* _tmp0_;
	GtkSwitch* _tmp7_;
	GtkSwitch* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	enabled = bluetooth_client_airplane_mode_enabled (_tmp0_);
	if (enabled) {
		GtkImage* _tmp1_;
		GtkLabel* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp1_ = self->image;
		gtk_image_set_from_icon_name (_tmp1_, "bluetooth-disabled-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		_tmp2_ = self->priv->placeholder_label;
		gtk_label_set_label (_tmp2_, _ ("Airplane mode is on."));
		_tmp3_ = self->priv->placeholder_sublabel;
		gtk_label_set_label (_tmp3_, _ ("Bluetooth is disabled while airplane mode is on."));
	} else {
		GtkImage* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp4_ = self->image;
		gtk_image_set_from_icon_name (_tmp4_, "bluetooth-active-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		_tmp5_ = self->priv->placeholder_label;
		gtk_label_set_label (_tmp5_, _ ("No paired Bluetooth devices found."));
		_tmp6_ = self->priv->placeholder_sublabel;
		gtk_label_set_label (_tmp6_, _ ("Visit Bluetooth settings to pair a device."));
	}
	_tmp7_ = self->priv->bluetooth_switch;
	g_signal_handler_block (_tmp7_, self->priv->switch_handler_id);
	_tmp8_ = self->priv->bluetooth_switch;
	gtk_switch_set_active (_tmp8_, !enabled);
	_tmp9_ = self->priv->bluetooth_switch;
	g_signal_handler_unblock (_tmp9_, self->priv->switch_handler_id);
	_tmp10_ = self->priv->devices_box;
	gtk_list_box_invalidate_filter (_tmp10_);
	_tmp11_ = self->priv->devices_box;
	gtk_list_box_invalidate_sort (_tmp11_);
}

BluetoothIndicator*
bluetooth_indicator_construct (GType object_type)
{
	BluetoothIndicator * self = NULL;
	self = (BluetoothIndicator*) g_object_new (object_type, NULL);
	return self;
}

BluetoothIndicator*
bluetooth_indicator_new (void)
{
	return bluetooth_indicator_construct (TYPE_BLUETOOTH_INDICATOR);
}

static gboolean
_bluetooth_indicator_on_button_released_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self)
{
	gboolean result;
	result = bluetooth_indicator_on_button_released ((BluetoothIndicator*) self, event);
	return result;
}

static void
_bluetooth_indicator___lambda24_ (BluetoothIndicator* self,
                                  Device1* device)
{
	g_return_if_fail (device != NULL);
	bluetooth_indicator_remove_device (self, device);
	bluetooth_indicator_add_device (self, device);
}

static void
__bluetooth_indicator___lambda24__bluetooth_client_device_added (BluetoothClient* _sender,
                                                                 Device1* device,
                                                                 gpointer self)
{
	_bluetooth_indicator___lambda24_ ((BluetoothIndicator*) self, device);
}

static void
_bluetooth_indicator___lambda25_ (BluetoothIndicator* self,
                                  Device1* device)
{
	g_return_if_fail (device != NULL);
	bluetooth_indicator_remove_device (self, device);
}

static void
__bluetooth_indicator___lambda25__bluetooth_client_device_removed (BluetoothClient* _sender,
                                                                   Device1* device,
                                                                   gpointer self)
{
	_bluetooth_indicator___lambda25_ ((BluetoothIndicator*) self, device);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BluetoothIndicator* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->up_device);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda27_ (Block9Data* _data9_,
             GtkWidget* row)
{
	BluetoothIndicator* self;
	BTDeviceRow* device_row = NULL;
	BTDeviceRow* _tmp0_;
	BTDeviceRow* _tmp1_;
	Device1* _tmp2_;
	Device1* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	self = _data9_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (IS_BT_DEVICE_ROW (row) ? ((BTDeviceRow*) row) : NULL);
	device_row = _tmp0_;
	_tmp1_ = device_row;
	_tmp2_ = bt_device_row_get_device (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = device1_get_address (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	g_object_get (_data9_->up_device, "serial", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strcmp0 (_tmp6_, _tmp9_) == 0;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	if (_tmp10_) {
		BTDeviceRow* _tmp11_;
		_tmp11_ = device_row;
		bt_device_row_set_up_device (_tmp11_, _data9_->up_device);
	}
	_g_object_unref0 (device_row);
}

static void
___lambda27__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda27_ (self, widget);
}

static void
_bluetooth_indicator___lambda26_ (BluetoothIndicator* self,
                                  UpDevice* up_device)
{
	Block9Data* _data9_;
	UpDevice* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (up_device != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (up_device);
	_g_object_unref0 (_data9_->up_device);
	_data9_->up_device = _tmp0_;
	_tmp1_ = self->priv->devices_box;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda27__gtk_callback, _data9_);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
__bluetooth_indicator___lambda26__bluetooth_client_upower_device_added (BluetoothClient* _sender,
                                                                        UpDevice* up_device,
                                                                        gpointer self)
{
	_bluetooth_indicator___lambda26_ ((BluetoothIndicator*) self, up_device);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BluetoothIndicator* self;
		self = _data10_->self;
		_g_free0 (_data10_->path);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda29_ (Block10Data* _data10_,
             GtkWidget* row)
{
	BluetoothIndicator* self;
	BTDeviceRow* device_row = NULL;
	BTDeviceRow* _tmp0_;
	BTDeviceRow* _tmp1_;
	Device1* _tmp2_;
	Device1* _tmp3_;
	const gchar* _tmp4_;
	self = _data10_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (IS_BT_DEVICE_ROW (row) ? ((BTDeviceRow*) row) : NULL);
	device_row = _tmp0_;
	_tmp1_ = device_row;
	_tmp2_ = bt_device_row_get_device (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_dbus_proxy_get_object_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_dbus_proxy_get_type (), GDBusProxy));
	if (g_strcmp0 (_tmp4_, _data10_->path) == 0) {
		BTDeviceRow* _tmp5_;
		_tmp5_ = device_row;
		bt_device_row_set_up_device (_tmp5_, NULL);
	}
	_g_object_unref0 (device_row);
}

static void
___lambda29__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda29_ (self, widget);
}

static void
_bluetooth_indicator___lambda28_ (BluetoothIndicator* self,
                                  const gchar* path)
{
	Block10Data* _data10_;
	gchar* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (path != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_strdup (path);
	_g_free0 (_data10_->path);
	_data10_->path = _tmp0_;
	_tmp1_ = self->priv->devices_box;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda29__gtk_callback, _data10_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
__bluetooth_indicator___lambda28__bluetooth_client_upower_device_removed (BluetoothClient* _sender,
                                                                          const gchar* object_path,
                                                                          gpointer self)
{
	_bluetooth_indicator___lambda28_ ((BluetoothIndicator*) self, object_path);
}

static void
_bluetooth_indicator_update_state_ui_bluetooth_client_airplane_mode_changed (BluetoothClient* _sender,
                                                                             gpointer self)
{
	bluetooth_indicator_update_state_ui ((BluetoothIndicator*) self);
}

static void
_bluetooth_indicator___lambda30_ (BluetoothIndicator* self)
{
	BluetoothClient* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->client;
	_tmp1_ = bluetooth_client_get_has_adapter (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gtk_widget_show_all ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}

static void
__bluetooth_indicator___lambda30__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_bluetooth_indicator___lambda30_ ((BluetoothIndicator*) self);
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
_bluetooth_indicator_on_settings_activate_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	bluetooth_indicator_on_settings_activate ((BluetoothIndicator*) self);
}

static void
_bluetooth_indicator_on_switch_activate_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	bluetooth_indicator_on_switch_activate ((BluetoothIndicator*) self);
}

static gboolean
_bluetooth_indicator_filter_paired_devices_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                     gpointer self)
{
	gboolean result;
	result = bluetooth_indicator_filter_paired_devices ((BluetoothIndicator*) self, row);
	return result;
}

static gint
_bluetooth_indicator_sort_devices_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self)
{
	gint result;
	result = bluetooth_indicator_sort_devices ((BluetoothIndicator*) self, row1, row2);
	return result;
}

static void
_bluetooth_indicator___lambda31_ (BluetoothIndicator* self,
                                  GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	bt_device_row_toggle_connection (G_TYPE_CHECK_INSTANCE_CAST (row, TYPE_BT_DEVICE_ROW, BTDeviceRow), NULL, NULL);
}

static void
__bluetooth_indicator___lambda31__gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	_bluetooth_indicator___lambda31_ ((BluetoothIndicator*) self, row);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static GObject *
bluetooth_indicator_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothIndicator * self;
	GtkImage* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkImage* _tmp3_;
	GtkEventBox* _tmp4_;
	GtkEventBox* _tmp5_;
	BluetoothClient* _tmp6_;
	ObexManager* _tmp7_;
	BluetoothClient* _tmp8_;
	BluetoothClient* _tmp9_;
	BluetoothClient* _tmp10_;
	BluetoothClient* _tmp11_;
	BluetoothClient* _tmp12_;
	BluetoothClient* _tmp13_;
	GtkEventBox* _tmp14_;
	BudgiePopover* _tmp15_;
	BudgiePopover* _tmp16_;
	BudgiePopover* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkBox* box = NULL;
	GtkBox* _tmp19_;
	GtkBox* header = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	GtkStyleContext* _tmp22_;
	PangoAttrList* header_attributes = NULL;
	PangoAttrList* _tmp23_;
	PangoFontDescription* weight_attr = NULL;
	PangoFontDescription* _tmp24_;
	PangoFontDescription* _tmp25_;
	PangoAttrList* _tmp26_;
	PangoFontDescription* _tmp27_;
	PangoAttrFontDesc* _tmp28_;
	GtkLabel* switch_label = NULL;
	PangoAttrList* _tmp29_;
	PangoAttrList* _tmp30_;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkButton* settings_button = NULL;
	gchar* _tmp34_;
	GtkButton* _tmp35_ = NULL;
	GtkButton* _tmp36_;
	gchar* _tmp37_;
	GtkSwitch* _tmp38_ = NULL;
	GtkSwitch* _tmp39_;
	gulong _tmp40_;
	GtkBox* _tmp41_;
	GtkLabel* _tmp42_;
	GtkBox* _tmp43_;
	GtkSwitch* _tmp44_;
	GtkBox* _tmp45_;
	GtkButton* _tmp46_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp47_ = NULL;
	GtkListBox* _tmp48_ = NULL;
	GtkListBox* _tmp49_;
	GtkListBox* _tmp50_;
	GtkListBox* _tmp51_;
	GtkStyleContext* _tmp52_;
	GtkListBox* _tmp53_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp54_ = NULL;
	PangoAttrList* label_attributes = NULL;
	PangoAttrList* _tmp55_;
	PangoAttrList* _tmp56_;
	PangoFontDescription* _tmp57_;
	PangoAttrFontDesc* _tmp58_;
	PangoAttrList* _tmp59_;
	PangoAttrList* _tmp60_;
	GtkLabel* _tmp61_ = NULL;
	GtkLabel* _tmp62_;
	GtkStyleContext* _tmp63_;
	GtkLabel* _tmp64_;
	GtkStyleContext* _tmp65_;
	GtkLabel* _tmp66_ = NULL;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	GtkBox* _tmp69_;
	GtkLabel* _tmp70_;
	GtkBox* _tmp71_;
	GtkListBox* _tmp72_;
	GtkBox* _tmp73_;
	GtkScrolledWindow* _tmp74_;
	GtkListBox* _tmp75_;
	GtkEventBox* _tmp76_;
	GtkBox* _tmp77_;
	GtkBox* _tmp78_;
	GtkBox* _tmp79_;
	GtkSeparator* _tmp80_;
	GtkSeparator* _tmp81_;
	GtkBox* _tmp82_;
	GtkScrolledWindow* _tmp83_;
	GtkBox* _tmp84_;
	BudgiePopover* _tmp85_;
	GtkBox* _tmp86_;
	BluetoothClient* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	parent_class = G_OBJECT_CLASS (bluetooth_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_INDICATOR, BluetoothIndicator);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->image);
	self->image = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp1_;
	_tmp2_ = self->ebox;
	_tmp3_ = self->image;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->ebox;
	gtk_widget_add_events ((GtkWidget*) _tmp4_, (gint) GDK_BUTTON_RELEASE_MASK);
	_tmp5_ = self->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-release-event", (GCallback) _bluetooth_indicator_on_button_released_gtk_widget_button_release_event, self, 0);
	_tmp6_ = bluetooth_client_new ();
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp6_;
	_tmp7_ = obex_manager_new ();
	_g_object_unref0 (self->priv->obex_manager);
	self->priv->obex_manager = _tmp7_;
	_tmp8_ = self->priv->client;
	g_signal_connect_object (_tmp8_, "device-added", (GCallback) __bluetooth_indicator___lambda24__bluetooth_client_device_added, self, 0);
	_tmp9_ = self->priv->client;
	g_signal_connect_object (_tmp9_, "device-removed", (GCallback) __bluetooth_indicator___lambda25__bluetooth_client_device_removed, self, 0);
	_tmp10_ = self->priv->client;
	g_signal_connect_object (_tmp10_, "upower-device-added", (GCallback) __bluetooth_indicator___lambda26__bluetooth_client_upower_device_added, self, 0);
	_tmp11_ = self->priv->client;
	g_signal_connect_object (_tmp11_, "upower-device-removed", (GCallback) __bluetooth_indicator___lambda28__bluetooth_client_upower_device_removed, self, 0);
	_tmp12_ = self->priv->client;
	g_signal_connect_object (_tmp12_, "airplane-mode-changed", (GCallback) _bluetooth_indicator_update_state_ui_bluetooth_client_airplane_mode_changed, self, 0);
	_tmp13_ = self->priv->client;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::has-adapter", (GCallback) __bluetooth_indicator___lambda30__g_object_notify, self, 0);
	_tmp14_ = self->ebox;
	_tmp15_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp14_);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp15_;
	_tmp16_ = self->popover;
	gtk_widget_set_size_request ((GtkWidget*) _tmp16_, 275, -1);
	_tmp17_ = self->popover;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "bluetooth-popover");
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp19_);
	box = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 4);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 4);
	g_object_ref_sink (_tmp20_);
	header = _tmp20_;
	_tmp21_ = header;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, "bluetooth-header");
	_tmp23_ = pango_attr_list_new ();
	header_attributes = _tmp23_;
	_tmp24_ = pango_font_description_new ();
	weight_attr = _tmp24_;
	_tmp25_ = weight_attr;
	pango_font_description_set_weight (_tmp25_, PANGO_WEIGHT_BOLD);
	_tmp26_ = header_attributes;
	_tmp27_ = weight_attr;
	_tmp28_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp27_);
	pango_attr_list_insert (_tmp26_, (PangoAttribute*) _tmp28_);
	_tmp29_ = header_attributes;
	_tmp30_ = _pango_attr_list_ref0 (_tmp29_);
	_tmp31_ = (GtkLabel*) gtk_label_new (_ ("Bluetooth"));
	gtk_label_set_attributes (_tmp31_, _tmp30_);
	_pango_attr_list_unref0 (_tmp30_);
	gtk_widget_set_halign ((GtkWidget*) _tmp31_, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp31_, 4);
	g_object_ref_sink (_tmp31_);
	switch_label = _tmp31_;
	_tmp32_ = switch_label;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp34_ = g_strdup (_ ("Bluetooth Settings"));
	_tmp35_ = (GtkButton*) gtk_button_new_from_icon_name ("preferences-system-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_button_set_relief (_tmp35_, GTK_RELIEF_NONE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp34_);
	_g_free0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	settings_button = _tmp35_;
	_tmp36_ = settings_button;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) _bluetooth_indicator_on_settings_activate_gtk_button_clicked, self, 0);
	_tmp37_ = g_strdup (_ ("Turn Bluetooth on or off"));
	_tmp38_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp38_, _tmp37_);
	_g_free0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->bluetooth_switch);
	self->priv->bluetooth_switch = _tmp38_;
	_tmp39_ = self->priv->bluetooth_switch;
	_tmp40_ = g_signal_connect_object ((GObject*) _tmp39_, "notify::active", (GCallback) _bluetooth_indicator_on_switch_activate_g_object_notify, self, 0);
	self->priv->switch_handler_id = _tmp40_;
	_tmp41_ = header;
	_tmp42_ = switch_label;
	gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, TRUE, TRUE, (guint) 0);
	_tmp43_ = header;
	_tmp44_ = self->priv->bluetooth_switch;
	gtk_box_pack_end (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
	_tmp45_ = header;
	_tmp46_ = settings_button;
	gtk_box_pack_end (_tmp45_, (GtkWidget*) _tmp46_, FALSE, FALSE, (guint) 0);
	_tmp47_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp47_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_min_content_height (_tmp47_, 190);
	gtk_scrolled_window_set_max_content_height (_tmp47_, 190);
	gtk_scrolled_window_set_propagate_natural_height (_tmp47_, TRUE);
	g_object_ref_sink (_tmp47_);
	scrolled_window = _tmp47_;
	_tmp48_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp48_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->devices_box);
	self->priv->devices_box = _tmp48_;
	_tmp49_ = self->priv->devices_box;
	gtk_list_box_set_filter_func (_tmp49_, _bluetooth_indicator_filter_paired_devices_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp50_ = self->priv->devices_box;
	gtk_list_box_set_sort_func (_tmp50_, _bluetooth_indicator_sort_devices_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp51_ = self->priv->devices_box;
	_tmp52_ = gtk_widget_get_style_context ((GtkWidget*) _tmp51_);
	gtk_style_context_add_class (_tmp52_, "bluetooth-device-listbox");
	_tmp53_ = self->priv->devices_box;
	g_signal_connect_object (_tmp53_, "row-activated", (GCallback) __bluetooth_indicator___lambda31__gtk_list_box_row_activated, self, 0);
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 18);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp54_, 18);
	g_object_ref_sink (_tmp54_);
	placeholder = _tmp54_;
	_tmp55_ = pango_attr_list_new ();
	label_attributes = _tmp55_;
	_tmp56_ = label_attributes;
	_tmp57_ = weight_attr;
	_tmp58_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp57_);
	pango_attr_list_insert (_tmp56_, (PangoAttribute*) _tmp58_);
	_tmp59_ = label_attributes;
	_tmp60_ = _pango_attr_list_ref0 (_tmp59_);
	_tmp61_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_attributes (_tmp61_, _tmp60_);
	_pango_attr_list_unref0 (_tmp60_);
	gtk_label_set_justify (_tmp61_, GTK_JUSTIFY_CENTER);
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->placeholder_label);
	self->priv->placeholder_label = _tmp61_;
	_tmp62_ = self->priv->placeholder_label;
	_tmp63_ = gtk_widget_get_style_context ((GtkWidget*) _tmp62_);
	gtk_style_context_add_class (_tmp63_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp64_ = self->priv->placeholder_label;
	_tmp65_ = gtk_widget_get_style_context ((GtkWidget*) _tmp64_);
	gtk_style_context_add_class (_tmp65_, "bluetooth-placeholder");
	_tmp66_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_justify (_tmp66_, GTK_JUSTIFY_CENTER);
	g_object_set (_tmp66_, "wrap", TRUE, NULL);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->placeholder_sublabel);
	self->priv->placeholder_sublabel = _tmp66_;
	_tmp67_ = placeholder;
	_tmp68_ = self->priv->placeholder_label;
	gtk_box_pack_start (_tmp67_, (GtkWidget*) _tmp68_, FALSE, TRUE, (guint) 0);
	_tmp69_ = placeholder;
	_tmp70_ = self->priv->placeholder_sublabel;
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, FALSE, TRUE, (guint) 0);
	_tmp71_ = placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp71_);
	_tmp72_ = self->priv->devices_box;
	_tmp73_ = placeholder;
	gtk_list_box_set_placeholder (_tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = scrolled_window;
	_tmp75_ = self->priv->devices_box;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	bluetooth_indicator_update_state_ui (self);
	_tmp76_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp76_);
	_tmp77_ = box;
	_tmp78_ = header;
	gtk_box_pack_start (_tmp77_, (GtkWidget*) _tmp78_, TRUE, TRUE, (guint) 0);
	_tmp79_ = box;
	_tmp80_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp80_);
	_tmp81_ = _tmp80_;
	gtk_box_pack_start (_tmp79_, (GtkWidget*) _tmp81_, TRUE, TRUE, (guint) 4);
	_g_object_unref0 (_tmp81_);
	_tmp82_ = box;
	_tmp83_ = scrolled_window;
	gtk_box_pack_start (_tmp82_, (GtkWidget*) _tmp83_, TRUE, TRUE, (guint) 0);
	_tmp84_ = box;
	gtk_widget_show_all ((GtkWidget*) _tmp84_);
	_tmp85_ = self->popover;
	_tmp86_ = box;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = self->priv->client;
	_tmp88_ = bluetooth_client_get_has_adapter (_tmp87_);
	_tmp89_ = _tmp88_;
	if (_tmp89_) {
		gtk_widget_show_all ((GtkWidget*) self);
	}
	_pango_attr_list_unref0 (label_attributes);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (settings_button);
	_g_object_unref0 (switch_label);
	__vala_PangoFontDescription_free0 (weight_attr);
	_pango_attr_list_unref0 (header_attributes);
	_g_object_unref0 (header);
	_g_object_unref0 (box);
	return obj;
}

static void
bluetooth_indicator_class_init (BluetoothIndicatorClass * klass,
                                gpointer klass_data)
{
	bluetooth_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothIndicator_private_offset);
	G_OBJECT_CLASS (klass)->constructor = bluetooth_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_finalize;
}

static void
bluetooth_indicator_instance_init (BluetoothIndicator * self,
                                   gpointer klass)
{
	self->priv = bluetooth_indicator_get_instance_private (self);
	self->image = NULL;
	self->ebox = NULL;
	self->popover = NULL;
	self->priv->devices_box = NULL;
	self->priv->bluetooth_switch = NULL;
	self->priv->placeholder_label = NULL;
	self->priv->placeholder_sublabel = NULL;
}

static void
bluetooth_indicator_finalize (GObject * obj)
{
	BluetoothIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_INDICATOR, BluetoothIndicator);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->devices_box);
	_g_object_unref0 (self->priv->bluetooth_switch);
	_g_object_unref0 (self->priv->placeholder_label);
	_g_object_unref0 (self->priv->placeholder_sublabel);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->obex_manager);
	G_OBJECT_CLASS (bluetooth_indicator_parent_class)->finalize (obj);
}

GType
bluetooth_indicator_get_type (void)
{
	return bluetooth_indicator_type_id;
}

GType
bluetooth_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicator), 0, (GInstanceInitFunc) bluetooth_indicator_instance_init, NULL };
	bluetooth_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "BluetoothIndicator", &g_define_type_info, 0);
	BluetoothIndicator_private_offset = sizeof (BluetoothIndicatorPrivate);
	return bluetooth_indicator_type_id;
}

static inline gpointer
bt_device_row_get_instance_private (BTDeviceRow* self)
{
	return G_STRUCT_MEMBER_P (self, BTDeviceRow_private_offset);
}

BTDeviceRow*
bt_device_row_construct (GType object_type,
                         Device1* device,
                         ObexManager* obex_manager)
{
	BTDeviceRow * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (obex_manager != NULL, NULL);
	self = (BTDeviceRow*) g_object_new (object_type, "device", device, "obex-manager", obex_manager, NULL);
	return self;
}

BTDeviceRow*
bt_device_row_new (Device1* device,
                   ObexManager* obex_manager)
{
	return bt_device_row_construct (TYPE_BT_DEVICE_ROW, device, obex_manager);
}

static void
bt_device_row_hide_progress_revealer (BTDeviceRow* self)
{
	GtkLabel* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_label;
	gtk_label_set_label (_tmp0_, "");
	_tmp1_ = self->priv->progress_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
}

static void
bt_device_row_toggle_connection_data_free (gpointer _data)
{
	BtDeviceRowToggleConnectionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BtDeviceRowToggleConnectionData, _data_);
}

void
bt_device_row_toggle_connection (BTDeviceRow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BtDeviceRowToggleConnectionData* _data_;
	BTDeviceRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BtDeviceRowToggleConnectionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bt_device_row_toggle_connection_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bt_device_row_toggle_connection_co (_data_);
}

void
bt_device_row_toggle_connection_finish (BTDeviceRow* self,
                                        GAsyncResult* _res_)
{
	BtDeviceRowToggleConnectionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Attempts to either connect to or disconnect from the Bluetooth
 * device depending on its current connection state.
 */
static void
bt_device_row_toggle_connection_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BtDeviceRowToggleConnectionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bt_device_row_toggle_connection_co (_data_);
}

static gboolean
bt_device_row_toggle_connection_co (BtDeviceRowToggleConnectionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->progress_revealer;
	_data_->_tmp1_ = gtk_revealer_get_child_revealed (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_) {
		{
			_data_->_state_ = 1;
			g_bus_get (G_BUS_TYPE_SESSION, NULL, bt_device_row_toggle_connection_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->conn = _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp4_ = _data_->conn;
			_data_->_tmp5_ = _data_->self->transfer;
			_data_->_tmp6_ = transfer_get_session (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = g_variant_new ("(s)", _data_->_tmp8_, NULL);
			g_variant_ref_sink (_data_->_tmp9_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_state_ = 2;
			g_dbus_connection_call (_data_->_tmp4_, BT_DEVICE_ROW_OBEX_AGENT, BT_DEVICE_ROW_OBEX_PATH, BT_DEVICE_ROW_OBEX_AGENT, "TransferActive", _data_->_tmp10_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, bt_device_row_toggle_connection_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp11_ = g_dbus_connection_call_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_g_variant_unref0 (_data_->_tmp12_);
			_g_variant_unref0 (_data_->_tmp10_);
			_g_free0 (_data_->_tmp8_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->conn);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->conn);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_warning ("BluetoothIndicator.vala:564: Error activating Bluetooth file transfer:" \
" %s", _data_->_tmp14_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->self->priv->spinner;
	g_object_get (_data_->_tmp15_, "active", &_data_->_tmp16_, NULL);
	_data_->_tmp17_ = _data_->_tmp16_;
	if (_data_->_tmp17_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->self->priv->spinner;
	g_object_set (_data_->_tmp18_, "active", TRUE, NULL);
	_data_->_tmp19_ = _data_->self->priv->revealer;
	gtk_revealer_set_reveal_child (_data_->_tmp19_, TRUE);
	{
		_data_->_tmp20_ = _data_->self->priv->_device;
		_data_->_tmp21_ = device1_get_connected (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		if (_data_->_tmp22_) {
			_data_->_tmp23_ = _data_->self->priv->status_label;
			gtk_label_set_label (_data_->_tmp23_, _ ("Disconnecting…"));
			_data_->_tmp24_ = _data_->self->priv->_device;
			_data_->_state_ = 3;
			device1_disconnect (_data_->_tmp24_, bt_device_row_toggle_connection_ready, _data_);
			return FALSE;
			_state_3:
			device1_disconnect_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		} else {
			_data_->_tmp25_ = _data_->self->priv->status_label;
			gtk_label_set_label (_data_->_tmp25_, _ ("Connecting…"));
			_data_->_tmp26_ = _data_->self->priv->_device;
			_data_->_state_ = 4;
			device1_connect (_data_->_tmp26_, bt_device_row_toggle_connection_ready, _data_);
			return FALSE;
			_state_4:
			device1_connect_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->self->priv->_device;
		_data_->_tmp28_ = device1_get_alias (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = _data_->_vala1_e;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		g_warning ("BluetoothIndicator.vala:584: Failed to connect or disconnect Bluetooth" \
" device %s: %s", _data_->_tmp30_, _data_->_tmp32_);
		_g_free0 (_data_->_tmp30_);
		_data_->_tmp34_ = _data_->self->priv->_device;
		_data_->_tmp35_ = device1_get_connected (_data_->_tmp34_);
		_data_->_tmp36_ = _data_->_tmp35_;
		if (_data_->_tmp36_) {
			_data_->_tmp33_ = _ ("Failed to disconnect");
		} else {
			_data_->_tmp33_ = _ ("Failed to connect");
		}
		_data_->_tmp37_ = _data_->self->priv->status_label;
		gtk_label_set_label (_data_->_tmp37_, _data_->_tmp33_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->self->priv->revealer;
	gtk_revealer_set_reveal_child (_data_->_tmp38_, TRUE);
	_data_->_tmp39_ = _data_->self->priv->spinner;
	g_object_set (_data_->_tmp39_, "active", FALSE, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bt_device_row_transfer_active (BTDeviceRow* self,
                               const gchar* address)
{
	Device1* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = device1_get_address (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (address, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		bt_device_row_update_transfer_progress (self);
	}
}

static void
bt_device_row_transfer_added (BTDeviceRow* self,
                              const gchar* address,
                              Transfer* transfer)
{
	Device1* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	g_return_if_fail (transfer != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = device1_get_address (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (address, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		Transfer* _tmp5_;
		_tmp5_ = _g_object_ref0 (transfer);
		_g_object_unref0 (self->transfer);
		self->transfer = _tmp5_;
	}
}

static void
bt_device_row_transfer_removed (BTDeviceRow* self,
                                Transfer* transfer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (transfer != NULL);
	bt_device_row_hide_progress_revealer (self);
}

static void
bt_device_row_update_battery (BTDeviceRow* self)
{
	UpDevice* _tmp0_;
	UpDevice* _tmp1_;
	gchar* fallback_icon_name = NULL;
	gchar* icon_name = NULL;
	gint rounded = 0;
	UpDevice* _tmp3_;
	UpDevice* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	UpDevice* _tmp7_;
	UpDevice* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gchar* _tmp28_;
	UpDevice* _tmp29_;
	UpDevice* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp44_;
	GtkIconTheme* _tmp45_;
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp46_;
	const gchar* _tmp47_;
	GtkIconInfo* _tmp48_;
	GtkIconInfo* _tmp49_;
	GtkLabel* _tmp54_;
	UpDevice* _tmp55_;
	UpDevice* _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GtkRevealer* _tmp61_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bt_device_row_get_up_device (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GtkRevealer* _tmp2_;
		_tmp2_ = self->priv->battery_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, FALSE);
		return;
	}
	fallback_icon_name = NULL;
	icon_name = NULL;
	_tmp3_ = bt_device_row_get_up_device (self);
	_tmp4_ = _tmp3_;
	g_object_get (_tmp4_, "percentage", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	rounded = ((gint) round (_tmp6_ / 10)) * 10;
	_tmp7_ = bt_device_row_get_up_device (self);
	_tmp8_ = _tmp7_;
	g_object_get (_tmp8_, "percentage", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	if (_tmp10_ <= ((gdouble) 10)) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("battery-empty");
		_g_free0 (fallback_icon_name);
		fallback_icon_name = _tmp11_;
	} else {
		UpDevice* _tmp12_;
		UpDevice* _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_;
		_tmp12_ = bt_device_row_get_up_device (self);
		_tmp13_ = _tmp12_;
		g_object_get (_tmp13_, "percentage", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_ <= ((gdouble) 25)) {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("battery-caution");
			_g_free0 (fallback_icon_name);
			fallback_icon_name = _tmp16_;
		} else {
			UpDevice* _tmp17_;
			UpDevice* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			_tmp17_ = bt_device_row_get_up_device (self);
			_tmp18_ = _tmp17_;
			g_object_get (_tmp18_, "percentage", &_tmp19_, NULL);
			_tmp20_ = _tmp19_;
			if (_tmp20_ <= ((gdouble) 50)) {
				gchar* _tmp21_;
				_tmp21_ = g_strdup ("battery-low");
				_g_free0 (fallback_icon_name);
				fallback_icon_name = _tmp21_;
			} else {
				UpDevice* _tmp22_;
				UpDevice* _tmp23_;
				gdouble _tmp24_;
				gdouble _tmp25_;
				_tmp22_ = bt_device_row_get_up_device (self);
				_tmp23_ = _tmp22_;
				g_object_get (_tmp23_, "percentage", &_tmp24_, NULL);
				_tmp25_ = _tmp24_;
				if (_tmp25_ <= ((gdouble) 75)) {
					gchar* _tmp26_;
					_tmp26_ = g_strdup ("battery-good");
					_g_free0 (fallback_icon_name);
					fallback_icon_name = _tmp26_;
				} else {
					gchar* _tmp27_;
					_tmp27_ = g_strdup ("battery-full");
					_g_free0 (fallback_icon_name);
					fallback_icon_name = _tmp27_;
				}
			}
		}
	}
	_tmp28_ = g_strdup_printf ("battery-level-%d", rounded);
	_g_free0 (icon_name);
	icon_name = _tmp28_;
	_tmp29_ = bt_device_row_get_up_device (self);
	_tmp30_ = _tmp29_;
	g_object_get (_tmp30_, "state", &_tmp31_, NULL);
	_tmp32_ = _tmp31_;
	if (_tmp32_ == ((guint) 4)) {
		gchar* _tmp33_;
		_tmp33_ = g_strdup ("battery-full-charged");
		_g_free0 (icon_name);
		icon_name = _tmp33_;
	} else {
		UpDevice* _tmp34_;
		UpDevice* _tmp35_;
		guint _tmp36_;
		guint _tmp37_;
		_tmp34_ = bt_device_row_get_up_device (self);
		_tmp35_ = _tmp34_;
		g_object_get (_tmp35_, "state", &_tmp36_, NULL);
		_tmp37_ = _tmp36_;
		if (_tmp37_ == ((guint) 1)) {
			const gchar* _tmp38_;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp38_ = icon_name;
			_tmp39_ = g_strconcat (_tmp38_, "-charging-symbolic", NULL);
			_g_free0 (icon_name);
			icon_name = _tmp39_;
			_tmp40_ = fallback_icon_name;
			_tmp41_ = g_strconcat (_tmp40_, "-charging-symbolic", NULL);
			_g_free0 (fallback_icon_name);
			fallback_icon_name = _tmp41_;
		} else {
			const gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = icon_name;
			_tmp43_ = g_strconcat (_tmp42_, "-symbolic", NULL);
			_g_free0 (icon_name);
			icon_name = _tmp43_;
		}
	}
	_tmp44_ = gtk_icon_theme_get_default ();
	_tmp45_ = _g_object_ref0 (_tmp44_);
	theme = _tmp45_;
	_tmp46_ = theme;
	_tmp47_ = icon_name;
	_tmp48_ = gtk_icon_theme_lookup_icon (_tmp46_, _tmp47_, (gint) GTK_ICON_SIZE_MENU, 0);
	icon_info = _tmp48_;
	_tmp49_ = icon_info;
	if (_tmp49_ == NULL) {
		GtkImage* _tmp50_;
		const gchar* _tmp51_;
		_tmp50_ = self->priv->battery_icon;
		_tmp51_ = fallback_icon_name;
		gtk_image_set_from_icon_name (_tmp50_, _tmp51_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp52_;
		const gchar* _tmp53_;
		_tmp52_ = self->priv->battery_icon;
		_tmp53_ = icon_name;
		gtk_image_set_from_icon_name (_tmp52_, _tmp53_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_tmp54_ = self->priv->battery_label;
	_tmp55_ = bt_device_row_get_up_device (self);
	_tmp56_ = _tmp55_;
	g_object_get (_tmp56_, "percentage", &_tmp57_, NULL);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strdup_printf ("%d%%", (gint) _tmp58_);
	_tmp60_ = _tmp59_;
	gtk_label_set_label (_tmp54_, _tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = self->priv->battery_revealer;
	gtk_revealer_set_reveal_child (_tmp61_, TRUE);
	_g_object_unref0 (icon_info);
	_g_object_unref0 (theme);
	_g_free0 (icon_name);
	_g_free0 (fallback_icon_name);
}

static void
bt_device_row_update_status (BTDeviceRow* self)
{
	const gchar* _tmp0_ = NULL;
	Device1* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkLabel* _tmp4_;
	Device1* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	Device1* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkLabel* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_device;
	_tmp2_ = device1_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = _ ("Connected");
	} else {
		_tmp0_ = _ ("Disconnected");
	}
	_tmp4_ = self->priv->status_label;
	gtk_label_set_text (_tmp4_, _tmp0_);
	_tmp5_ = self->priv->_device;
	_tmp6_ = device1_get_connected (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkButton* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Device1* _tmp11_;
		guint32 _tmp12_;
		guint32 _tmp13_;
		_tmp8_ = self->priv->connection_button;
		gtk_widget_show ((GtkWidget*) _tmp8_);
		_tmp11_ = self->priv->_device;
		_tmp12_ = device1_get_class (_tmp11_);
		_tmp13_ = _tmp12_;
		if ((_tmp13_ & BT_DEVICE_ROW_SMARTPHONE_MASK) == BT_DEVICE_ROW_SMARTPHONE_MASK) {
			_tmp10_ = TRUE;
		} else {
			Device1* _tmp14_;
			guint32 _tmp15_;
			guint32 _tmp16_;
			_tmp14_ = self->priv->_device;
			_tmp15_ = device1_get_class (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp10_ = (_tmp16_ & BT_DEVICE_ROW_DESKTOP_MASK) == BT_DEVICE_ROW_DESKTOP_MASK;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Device1* _tmp17_;
			guint32 _tmp18_;
			guint32 _tmp19_;
			_tmp17_ = self->priv->_device;
			_tmp18_ = device1_get_class (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp9_ = (_tmp19_ & BT_DEVICE_ROW_LAPTOP_MASK) == BT_DEVICE_ROW_LAPTOP_MASK;
		}
		if (_tmp9_) {
			GtkButton* _tmp20_;
			_tmp20_ = self->priv->send_button;
			gtk_widget_show ((GtkWidget*) _tmp20_);
		}
		bt_device_row_update_battery (self);
	} else {
		GtkButton* _tmp21_;
		GtkButton* _tmp22_;
		GtkRevealer* _tmp23_;
		_tmp21_ = self->priv->connection_button;
		gtk_widget_hide ((GtkWidget*) _tmp21_);
		_tmp22_ = self->priv->send_button;
		gtk_widget_hide ((GtkWidget*) _tmp22_);
		_tmp23_ = self->priv->battery_revealer;
		gtk_revealer_set_reveal_child (_tmp23_, FALSE);
	}
	_tmp24_ = self->priv->_device;
	_tmp25_ = device1_get_alias (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->name_label;
	_tmp29_ = gtk_label_get_label (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strcmp0 (_tmp27_, _tmp30_) != 0;
	_g_free0 (_tmp27_);
	if (_tmp31_) {
		GtkLabel* _tmp32_;
		Device1* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GtkLabel* _tmp37_;
		Device1* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp32_ = self->priv->name_label;
		_tmp33_ = self->priv->_device;
		_tmp34_ = device1_get_alias (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_;
		gtk_label_set_label (_tmp32_, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = self->priv->name_label;
		_tmp38_ = self->priv->_device;
		_tmp39_ = device1_get_alias (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp37_, _tmp41_);
		_g_free0 (_tmp41_);
	}
	g_signal_emit (self, bt_device_row_signals[BT_DEVICE_ROW_PROPERTIES_UPDATED_SIGNAL], 0);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
bt_device_row_update_transfer_progress (BTDeviceRow* self)
{
	Transfer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->transfer;
	_tmp1_ = transfer_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("error")))) {
		switch (0) {
			default:
			{
				bt_device_row_hide_progress_revealer (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("queued")))) {
		switch (0) {
			default:
			{
				bt_device_row_hide_progress_revealer (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("active")))) {
		switch (0) {
			default:
			{
				GtkProgressBar* _tmp6_;
				Transfer* _tmp7_;
				guint64 _tmp8_;
				guint64 _tmp9_;
				Transfer* _tmp10_;
				guint64 _tmp11_;
				guint64 _tmp12_;
				GtkRevealer* _tmp13_;
				gchar* name = NULL;
				Transfer* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* file_name = NULL;
				Transfer* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				_tmp6_ = self->priv->progress_bar;
				_tmp7_ = self->transfer;
				_tmp8_ = transfer_get_transferred (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->transfer;
				_tmp11_ = transfer_get_size (_tmp10_);
				_tmp12_ = _tmp11_;
				gtk_progress_bar_set_fraction (_tmp6_, ((gdouble) _tmp9_) / ((gdouble) _tmp12_));
				_tmp13_ = self->priv->progress_revealer;
				gtk_revealer_set_reveal_child (_tmp13_, TRUE);
				gtk_list_box_row_set_activatable ((GtkListBoxRow*) self, TRUE);
				_tmp14_ = self->transfer;
				_tmp15_ = transfer_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				name = _tmp16_;
				_tmp17_ = name;
				if (_tmp17_ != NULL) {
					GtkLabel* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = self->priv->file_label;
					_tmp19_ = name;
					_tmp20_ = g_markup_escape_text (_tmp19_, (gssize) -1);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup_printf (_ ("<b>Filename</b>: %s"), _tmp21_);
					_tmp23_ = _tmp22_;
					gtk_label_set_markup (_tmp18_, _tmp23_);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
				}
				_tmp24_ = self->transfer;
				_tmp25_ = transfer_get_filename (_tmp24_);
				_tmp26_ = _tmp25_;
				file_name = _tmp26_;
				_tmp27_ = file_name;
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = file_name;
					if (string_contains (_tmp28_, "/.cache/obexd")) {
						GtkLabel* _tmp29_;
						Transfer* _tmp30_;
						guint64 _tmp31_;
						guint64 _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						Transfer* _tmp35_;
						guint64 _tmp36_;
						guint64 _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp29_ = self->priv->progress_label;
						_tmp30_ = self->transfer;
						_tmp31_ = transfer_get_transferred (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_format_size_full (_tmp32_, G_FORMAT_SIZE_DEFAULT);
						_tmp34_ = _tmp33_;
						_tmp35_ = self->transfer;
						_tmp36_ = transfer_get_size (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = g_format_size_full (_tmp37_, G_FORMAT_SIZE_DEFAULT);
						_tmp39_ = _tmp38_;
						_tmp40_ = g_strdup_printf (_ ("Receiving… %s of %s"), _tmp34_, _tmp39_);
						_tmp41_ = _tmp40_;
						gtk_label_set_label (_tmp29_, _tmp41_);
						_g_free0 (_tmp41_);
						_g_free0 (_tmp39_);
						_g_free0 (_tmp34_);
					} else {
						GtkLabel* _tmp42_;
						Transfer* _tmp43_;
						guint64 _tmp44_;
						guint64 _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						Transfer* _tmp48_;
						guint64 _tmp49_;
						guint64 _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						_tmp42_ = self->priv->progress_label;
						_tmp43_ = self->transfer;
						_tmp44_ = transfer_get_transferred (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_format_size_full (_tmp45_, G_FORMAT_SIZE_DEFAULT);
						_tmp47_ = _tmp46_;
						_tmp48_ = self->transfer;
						_tmp49_ = transfer_get_size (_tmp48_);
						_tmp50_ = _tmp49_;
						_tmp51_ = g_format_size_full (_tmp50_, G_FORMAT_SIZE_DEFAULT);
						_tmp52_ = _tmp51_;
						_tmp53_ = g_strdup_printf (_ ("Sending… %s of %s"), _tmp47_, _tmp52_);
						_tmp54_ = _tmp53_;
						gtk_label_set_label (_tmp42_, _tmp54_);
						_g_free0 (_tmp54_);
						_g_free0 (_tmp52_);
						_g_free0 (_tmp47_);
					}
				}
				_g_free0 (file_name);
				_g_free0 (name);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("complete")))) {
		switch (0) {
			default:
			{
				Device1* _tmp55_;
				gboolean _tmp56_;
				gboolean _tmp57_;
				bt_device_row_hide_progress_revealer (self);
				_tmp55_ = self->priv->_device;
				_tmp56_ = device1_get_connected (_tmp55_);
				_tmp57_ = _tmp56_;
				if (_tmp57_) {
					gtk_list_box_row_set_activatable ((GtkListBoxRow*) self, FALSE);
				}
				break;
			}
		}
	}
}

Device1*
bt_device_row_get_device (BTDeviceRow* self)
{
	Device1* result;
	Device1* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
bt_device_row_set_device (BTDeviceRow* self,
                          Device1* value)
{
	Device1* old_value;
	g_return_if_fail (self != NULL);
	old_value = bt_device_row_get_device (self);
	if (old_value != value) {
		Device1* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bt_device_row_properties[BT_DEVICE_ROW_DEVICE_PROPERTY]);
	}
}

ObexManager*
bt_device_row_get_obex_manager (BTDeviceRow* self)
{
	ObexManager* result;
	ObexManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_obex_manager;
	result = _tmp0_;
	return result;
}

static void
bt_device_row_set_obex_manager (BTDeviceRow* self,
                                ObexManager* value)
{
	ObexManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = bt_device_row_get_obex_manager (self);
	if (old_value != value) {
		ObexManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_obex_manager);
		self->priv->_obex_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bt_device_row_properties[BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY]);
	}
}

UpDevice*
bt_device_row_get_up_device (BTDeviceRow* self)
{
	UpDevice* result;
	UpDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_up_device;
	result = _tmp0_;
	return result;
}

static void
_bt_device_row_up_device___lambda19_ (BTDeviceRow* self)
{
	bt_device_row_update_battery (self);
}

static void
__bt_device_row_up_device___lambda19__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_bt_device_row_up_device___lambda19_ ((BTDeviceRow*) self);
}

void
bt_device_row_set_up_device (BTDeviceRow* self,
                             UpDevice* value)
{
	UpDevice* _tmp1_;
	UpDevice* _tmp2_;
	UpDevice* _tmp3_;
	gulong _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->up_handler_id != ((gulong) 0)) {
		UpDevice* _tmp0_;
		_tmp0_ = self->priv->_up_device;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->up_handler_id);
		self->priv->up_handler_id = (gulong) 0;
	}
	_tmp1_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_up_device);
	self->priv->_up_device = _tmp1_;
	bt_device_row_update_battery (self);
	_tmp2_ = self->priv->_up_device;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->_up_device;
	_tmp4_ = g_signal_connect_object ((GObject*) _tmp3_, "notify", (GCallback) __bt_device_row_up_device___lambda19__g_object_notify, self, 0);
	self->priv->up_handler_id = _tmp4_;
	g_object_notify_by_pspec ((GObject *) self, bt_device_row_properties[BT_DEVICE_ROW_UP_DEVICE_PROPERTY]);
}

static void
_bt_device_row_transfer_active_obex_manager_transfer_active (ObexManager* _sender,
                                                             const gchar* address,
                                                             gpointer self)
{
	bt_device_row_transfer_active ((BTDeviceRow*) self, address);
}

static void
_bt_device_row_transfer_added_obex_manager_transfer_added (ObexManager* _sender,
                                                           const gchar* address,
                                                           Transfer* transfer,
                                                           gpointer self)
{
	bt_device_row_transfer_added ((BTDeviceRow*) self, address, transfer);
}

static void
_bt_device_row_transfer_removed_obex_manager_transfer_removed (ObexManager* _sender,
                                                               Transfer* transfer,
                                                               gpointer self)
{
	bt_device_row_transfer_removed ((BTDeviceRow*) self, transfer);
}

static void
_bt_device_row___lambda20_ (BTDeviceRow* self)
{
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Device1* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint args_length1;
	gint _args_size_;
	gchar** env = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint env_length1;
	gint _env_size_;
	GPid pid = 0;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_strdup ("org.buddiesofbudgie.sendto");
	_tmp1_ = g_strdup ("-a");
	_tmp2_ = self->priv->_device;
	_tmp3_ = device1_get_address (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup ("-f");
	_tmp6_ = g_new0 (gchar*, 4 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp4_;
	_tmp6_[3] = _tmp5_;
	args = _tmp6_;
	args_length1 = 4;
	_args_size_ = args_length1;
	_tmp8_ = _tmp7_ = g_get_environ ();
	env = _tmp8_;
	env_length1 = _vala_array_length (_tmp7_);
	_env_size_ = env_length1;
	{
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** _tmp10_;
		gint _tmp10__length1;
		GPid _tmp11_ = 0;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = env;
		_tmp10__length1 = env_length1;
		g_spawn_async (NULL, _tmp9_, _tmp10_, G_SPAWN_SEARCH_PATH_FROM_ENVP, NULL, NULL, &_tmp11_, &_inner_error0_);
		pid = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("BluetoothIndicator.vala:458: Error starting sendto: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}

static void
__bt_device_row___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	_bt_device_row___lambda20_ ((BTDeviceRow*) self);
}

static void
_bt_device_row___lambda21_ (BTDeviceRow* self)
{
	bt_device_row_toggle_connection (self, NULL, NULL);
}

static void
__bt_device_row___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	_bt_device_row___lambda21_ ((BTDeviceRow*) self);
}

static void
_bt_device_row_update_status_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                GVariant* changed_properties,
                                                                gchar** invalidated_properties,
                                                                gpointer self)
{
	bt_device_row_update_status ((BTDeviceRow*) self);
}

static GObject *
bt_device_row_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BTDeviceRow * self;
	GtkStyleContext* _tmp0_;
	ObexManager* _tmp1_;
	ObexManager* _tmp2_;
	ObexManager* _tmp3_;
	GtkBox* box = NULL;
	GtkBox* _tmp4_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Device1* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* icon_name = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	GtkImage* _tmp16_ = NULL;
	GtkImage* _tmp17_;
	GtkStyleContext* _tmp18_;
	Device1* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	Device1* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkRevealer* _tmp29_ = NULL;
	GtkBox* battery_box = NULL;
	GtkBox* _tmp30_;
	GtkImage* _tmp31_;
	PangoAttrList* label_attributes = NULL;
	PangoAttrList* _tmp32_;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp33_;
	PangoFontDescription* _tmp34_;
	PangoFontDescription* _tmp35_;
	PangoAttrList* _tmp36_;
	PangoFontDescription* _tmp37_;
	PangoAttrFontDesc* _tmp38_;
	PangoAttrList* _tmp39_;
	PangoAttrList* _tmp40_;
	GtkLabel* _tmp41_ = NULL;
	GtkLabel* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkLabel* _tmp44_;
	GtkStyleContext* _tmp45_;
	GtkBox* _tmp46_;
	GtkImage* _tmp47_;
	GtkBox* _tmp48_;
	GtkLabel* _tmp49_;
	GtkRevealer* _tmp50_;
	GtkBox* _tmp51_;
	GtkBox* status_box = NULL;
	GtkBox* _tmp52_;
	GtkRevealer* _tmp53_ = NULL;
	GtkRevealer* _tmp54_;
	GtkStyleContext* _tmp55_;
	GtkSpinner* _tmp56_;
	PangoAttrList* _tmp57_;
	PangoAttrList* _tmp58_;
	GtkLabel* _tmp59_ = NULL;
	GtkLabel* _tmp60_;
	GtkStyleContext* _tmp61_;
	GtkLabel* _tmp62_;
	GtkStyleContext* _tmp63_;
	GtkRevealer* _tmp64_;
	GtkSpinner* _tmp65_;
	GtkBox* _tmp66_;
	GtkLabel* _tmp67_;
	GtkBox* _tmp68_;
	GtkRevealer* _tmp69_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp70_ = NULL;
	gchar* _tmp71_;
	GtkButton* _tmp72_ = NULL;
	GtkButton* _tmp73_;
	GtkStyleContext* _tmp74_;
	GtkButton* _tmp75_;
	gchar* _tmp76_;
	GtkButton* _tmp77_ = NULL;
	GtkButton* _tmp78_;
	GtkStyleContext* _tmp79_;
	GtkButton* _tmp80_;
	GtkStyleContext* _tmp81_;
	GtkButton* _tmp82_;
	GtkBox* _tmp83_;
	GtkButton* _tmp84_;
	GtkBox* _tmp85_;
	GtkButton* _tmp86_;
	GtkRevealer* _tmp87_ = NULL;
	GtkLabel* _tmp88_ = NULL;
	GtkProgressBar* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	GtkGrid* progress_grid = NULL;
	GtkGrid* _tmp91_;
	GtkGrid* _tmp92_;
	GtkLabel* _tmp93_;
	GtkGrid* _tmp94_;
	GtkProgressBar* _tmp95_;
	GtkGrid* _tmp96_;
	GtkLabel* _tmp97_;
	GtkRevealer* _tmp98_;
	GtkGrid* _tmp99_;
	Device1* _tmp100_;
	GtkGrid* _tmp101_;
	GtkImage* _tmp102_;
	GtkGrid* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkBox* _tmp106_;
	GtkGrid* _tmp107_;
	GtkBox* _tmp108_;
	GtkGrid* _tmp109_;
	GtkRevealer* _tmp110_;
	GtkGrid* box_grid = NULL;
	GtkGrid* _tmp111_;
	GtkGrid* _tmp112_;
	GtkGrid* _tmp113_;
	GtkGrid* _tmp114_;
	GtkRevealer* _tmp115_;
	GtkBox* _tmp116_;
	GtkGrid* _tmp117_;
	GtkBox* _tmp118_;
	GtkButton* _tmp119_;
	parent_class = G_OBJECT_CLASS (bt_device_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BT_DEVICE_ROW, BTDeviceRow);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "bluetooth-device-row");
	_tmp1_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp1_, "transfer-active", (GCallback) _bt_device_row_transfer_active_obex_manager_transfer_active, self, 0);
	_tmp2_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp2_, "transfer-added", (GCallback) _bt_device_row_transfer_added_obex_manager_transfer_added, self, 0);
	_tmp3_ = self->priv->_obex_manager;
	g_signal_connect_object (_tmp3_, "transfer-removed", (GCallback) _bt_device_row_transfer_removed_obex_manager_transfer_removed, self, 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp4_);
	box = _tmp4_;
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp5_, 6);
	g_object_ref_sink (_tmp5_);
	grid = _tmp5_;
	_tmp7_ = self->priv->_device;
	_tmp8_ = device1_get_icon (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp6_ = _tmp9_;
	if (_tmp6_ == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("bluetooth-active");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = _tmp6_;
	_tmp6_ = NULL;
	icon_name = _tmp11_;
	_tmp12_ = icon_name;
	if (!g_str_has_suffix (_tmp12_, "-symbolic")) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = icon_name;
		_tmp14_ = g_strconcat (_tmp13_, "-symbolic", NULL);
		_g_free0 (icon_name);
		icon_name = _tmp14_;
	}
	_tmp15_ = icon_name;
	_tmp16_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp15_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 4);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp16_, 4);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp16_;
	_tmp17_ = self->priv->image;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, "bluetooth-device-image");
	_tmp19_ = self->priv->_device;
	_tmp20_ = device1_get_alias (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->_device;
	_tmp24_ = device1_get_alias (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp22_);
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp26_, 0.0f);
	gtk_label_set_max_width_chars (_tmp26_, 1);
	gtk_label_set_ellipsize (_tmp26_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, TRUE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp26_, _tmp25_);
	_g_free0 (_tmp25_);
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp26_;
	_g_free0 (_tmp22_);
	_tmp27_ = self->priv->name_label;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, "bluetooth-device-name");
	_tmp29_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp29_, FALSE);
	gtk_revealer_set_transition_duration (_tmp29_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp29_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp29_, 2);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->battery_revealer);
	self->priv->battery_revealer = _tmp29_;
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp30_);
	battery_box = _tmp30_;
	_tmp31_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->battery_icon);
	self->priv->battery_icon = _tmp31_;
	_tmp32_ = pango_attr_list_new ();
	label_attributes = _tmp32_;
	_tmp33_ = pango_font_description_new ();
	desc = _tmp33_;
	_tmp34_ = desc;
	pango_font_description_set_stretch (_tmp34_, PANGO_STRETCH_ULTRA_CONDENSED);
	_tmp35_ = desc;
	pango_font_description_set_weight (_tmp35_, PANGO_WEIGHT_SEMILIGHT);
	_tmp36_ = label_attributes;
	_tmp37_ = desc;
	_tmp38_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp37_);
	pango_attr_list_insert (_tmp36_, (PangoAttribute*) _tmp38_);
	_tmp39_ = label_attributes;
	_tmp40_ = _pango_attr_list_ref0 (_tmp39_);
	_tmp41_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_attributes (_tmp41_, _tmp40_);
	_pango_attr_list_unref0 (_tmp40_);
	gtk_widget_set_halign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->battery_label);
	self->priv->battery_label = _tmp41_;
	_tmp42_ = self->priv->battery_label;
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _tmp42_);
	gtk_style_context_add_class (_tmp43_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp44_ = self->priv->battery_label;
	_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
	gtk_style_context_add_class (_tmp45_, "bluetooth-battery-label");
	_tmp46_ = battery_box;
	_tmp47_ = self->priv->battery_icon;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, FALSE, FALSE, (guint) 2);
	_tmp48_ = battery_box;
	_tmp49_ = self->priv->battery_label;
	gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, FALSE, FALSE, (guint) 2);
	_tmp50_ = self->priv->battery_revealer;
	_tmp51_ = battery_box;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp52_);
	status_box = _tmp52_;
	_tmp53_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp53_, FALSE);
	gtk_revealer_set_transition_duration (_tmp53_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp53_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp53_;
	_tmp54_ = self->priv->revealer;
	_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
	gtk_style_context_add_class (_tmp55_, "bluetooth-device-revealer");
	_tmp56_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp56_;
	_tmp57_ = label_attributes;
	_tmp58_ = _pango_attr_list_ref0 (_tmp57_);
	_tmp59_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_attributes (_tmp59_, _tmp58_);
	_pango_attr_list_unref0 (_tmp58_);
	gtk_widget_set_halign ((GtkWidget*) _tmp59_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp59_;
	_tmp60_ = self->priv->status_label;
	_tmp61_ = gtk_widget_get_style_context ((GtkWidget*) _tmp60_);
	gtk_style_context_add_class (_tmp61_, "bluetooth-device-status");
	_tmp62_ = self->priv->status_label;
	_tmp63_ = gtk_widget_get_style_context ((GtkWidget*) _tmp62_);
	gtk_style_context_add_class (_tmp63_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp64_ = self->priv->revealer;
	_tmp65_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = status_box;
	_tmp67_ = self->priv->status_label;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, TRUE, (guint) 0);
	_tmp68_ = status_box;
	_tmp69_ = self->priv->revealer;
	gtk_box_pack_start (_tmp68_, (GtkWidget*) _tmp69_, FALSE, TRUE, (guint) 0);
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp70_, FALSE);
	g_object_ref_sink (_tmp70_);
	button_box = _tmp70_;
	_tmp71_ = g_strdup (_ ("Send file"));
	_tmp72_ = (GtkButton*) gtk_button_new_from_icon_name ("folder-download-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_button_set_relief (_tmp72_, GTK_RELIEF_NONE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp72_, _tmp71_);
	_g_free0 (_tmp71_);
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (self->priv->send_button);
	self->priv->send_button = _tmp72_;
	_tmp73_ = self->priv->send_button;
	_tmp74_ = gtk_widget_get_style_context ((GtkWidget*) _tmp73_);
	gtk_style_context_add_class (_tmp74_, "circular");
	_tmp75_ = self->priv->send_button;
	g_signal_connect_object (_tmp75_, "clicked", (GCallback) __bt_device_row___lambda20__gtk_button_clicked, self, 0);
	_tmp76_ = g_strdup (_ ("Disconnect"));
	_tmp77_ = (GtkButton*) gtk_button_new_from_icon_name ("bluetooth-disabled-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_button_set_relief (_tmp77_, GTK_RELIEF_NONE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp77_, _tmp76_);
	_g_free0 (_tmp76_);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->connection_button);
	self->priv->connection_button = _tmp77_;
	_tmp78_ = self->priv->connection_button;
	_tmp79_ = gtk_widget_get_style_context ((GtkWidget*) _tmp78_);
	gtk_style_context_add_class (_tmp79_, "circular");
	_tmp80_ = self->priv->connection_button;
	_tmp81_ = gtk_widget_get_style_context ((GtkWidget*) _tmp80_);
	gtk_style_context_add_class (_tmp81_, "bluetooth-connection-button");
	_tmp82_ = self->priv->connection_button;
	g_signal_connect_object (_tmp82_, "clicked", (GCallback) __bt_device_row___lambda21__gtk_button_clicked, self, 0);
	_tmp83_ = button_box;
	_tmp84_ = self->priv->send_button;
	gtk_box_pack_start (_tmp83_, (GtkWidget*) _tmp84_, TRUE, TRUE, (guint) 0);
	_tmp85_ = button_box;
	_tmp86_ = self->priv->connection_button;
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, TRUE, TRUE, (guint) 0);
	_tmp87_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp87_, FALSE);
	gtk_revealer_set_transition_duration (_tmp87_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp87_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	gtk_widget_set_margin_left ((GtkWidget*) _tmp87_, 4);
	gtk_widget_set_margin_right ((GtkWidget*) _tmp87_, 4);
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (self->priv->progress_revealer);
	self->priv->progress_revealer = _tmp87_;
	_tmp88_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp88_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp88_, GTK_ALIGN_END);
	gtk_label_set_use_markup (_tmp88_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp88_, TRUE);
	g_object_ref_sink (_tmp88_);
	_g_object_unref0 (self->priv->progress_label);
	self->priv->progress_label = _tmp88_;
	_tmp89_ = (GtkProgressBar*) gtk_progress_bar_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp89_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp89_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp89_, 6);
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->progress_bar);
	self->priv->progress_bar = _tmp89_;
	_tmp90_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_ellipsize (_tmp90_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_widget_set_halign ((GtkWidget*) _tmp90_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp90_, GTK_ALIGN_END);
	gtk_label_set_use_markup (_tmp90_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp90_, TRUE);
	g_object_ref_sink (_tmp90_);
	_g_object_unref0 (self->priv->file_label);
	self->priv->file_label = _tmp90_;
	_tmp91_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp91_);
	progress_grid = _tmp91_;
	_tmp92_ = progress_grid;
	_tmp93_ = self->priv->file_label;
	gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 0, 0, 1, 1);
	_tmp94_ = progress_grid;
	_tmp95_ = self->priv->progress_bar;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 0, 1, 1, 1);
	_tmp96_ = progress_grid;
	_tmp97_ = self->priv->progress_label;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 2, 1, 1);
	_tmp98_ = self->priv->progress_revealer;
	_tmp99_ = progress_grid;
	gtk_container_add ((GtkContainer*) _tmp98_, (GtkWidget*) _tmp99_);
	_tmp100_ = self->priv->_device;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _bt_device_row_update_status_g_dbus_proxy_g_properties_changed, self, 0);
	_tmp101_ = grid;
	_tmp102_ = self->priv->image;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 0, 0, 2, 2);
	_tmp103_ = grid;
	_tmp104_ = self->priv->name_label;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 2, 0, 2, 1);
	_tmp105_ = grid;
	_tmp106_ = button_box;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 4, 0, 1, 2);
	_tmp107_ = grid;
	_tmp108_ = status_box;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 2, 1, 2, 1);
	_tmp109_ = grid;
	_tmp110_ = self->priv->battery_revealer;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 2, 2, 1, 1);
	_tmp111_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp111_);
	box_grid = _tmp111_;
	_tmp112_ = box_grid;
	_tmp113_ = grid;
	gtk_grid_attach (_tmp112_, (GtkWidget*) _tmp113_, 0, 0, 1, 1);
	_tmp114_ = box_grid;
	_tmp115_ = self->priv->progress_revealer;
	gtk_grid_attach (_tmp114_, (GtkWidget*) _tmp115_, 0, 1, 1, 1);
	_tmp116_ = box;
	_tmp117_ = box_grid;
	gtk_box_pack_start (_tmp116_, (GtkWidget*) _tmp117_, TRUE, TRUE, (guint) 0);
	_tmp118_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp118_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp119_ = self->priv->send_button;
	gtk_widget_hide ((GtkWidget*) _tmp119_);
	bt_device_row_update_status (self);
	_g_object_unref0 (box_grid);
	_g_object_unref0 (progress_grid);
	_g_object_unref0 (button_box);
	_g_object_unref0 (status_box);
	__vala_PangoFontDescription_free0 (desc);
	_pango_attr_list_unref0 (label_attributes);
	_g_object_unref0 (battery_box);
	_g_free0 (icon_name);
	_g_free0 (_tmp6_);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	return obj;
}

static void
bt_device_row_class_init (BTDeviceRowClass * klass,
                          gpointer klass_data)
{
	bt_device_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BTDeviceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bt_device_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bt_device_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = bt_device_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = bt_device_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BT_DEVICE_ROW_DEVICE_PROPERTY, bt_device_row_properties[BT_DEVICE_ROW_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", TYPE_DEVICE1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY, bt_device_row_properties[BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY] = g_param_spec_object ("obex-manager", "obex-manager", "obex-manager", TYPE_OBEX_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BT_DEVICE_ROW_UP_DEVICE_PROPERTY, bt_device_row_properties[BT_DEVICE_ROW_UP_DEVICE_PROPERTY] = g_param_spec_object ("up-device", "up-device", "up-device", up_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bt_device_row_signals[BT_DEVICE_ROW_PROPERTIES_UPDATED_SIGNAL] = g_signal_new ("properties-updated", TYPE_BT_DEVICE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bt_device_row_instance_init (BTDeviceRow * self,
                             gpointer klass)
{
	self->priv = bt_device_row_get_instance_private (self);
	self->priv->image = NULL;
	self->priv->name_label = NULL;
	self->priv->battery_revealer = NULL;
	self->priv->battery_icon = NULL;
	self->priv->battery_label = NULL;
	self->priv->revealer = NULL;
	self->priv->spinner = NULL;
	self->priv->status_label = NULL;
	self->priv->send_button = NULL;
	self->priv->connection_button = NULL;
	self->priv->progress_revealer = NULL;
	self->priv->file_label = NULL;
	self->priv->progress_label = NULL;
	self->priv->progress_bar = NULL;
	self->priv->up_handler_id = (gulong) 0;
}

static void
bt_device_row_finalize (GObject * obj)
{
	BTDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BT_DEVICE_ROW, BTDeviceRow);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->battery_revealer);
	_g_object_unref0 (self->priv->battery_icon);
	_g_object_unref0 (self->priv->battery_label);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->connection_button);
	_g_object_unref0 (self->priv->progress_revealer);
	_g_object_unref0 (self->priv->file_label);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->_obex_manager);
	_g_object_unref0 (self->transfer);
	_g_object_unref0 (self->priv->_up_device);
	G_OBJECT_CLASS (bt_device_row_parent_class)->finalize (obj);
}

/**
 * Widget for displaying a Bluetooth device in a ListBox.
 */
GType
bt_device_row_get_type (void)
{
	return bt_device_row_type_id;
}

GType
bt_device_row_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BTDeviceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bt_device_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BTDeviceRow), 0, (GInstanceInitFunc) bt_device_row_instance_init, NULL };
	bt_device_row_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "BTDeviceRow", &g_define_type_info, 0);
	BTDeviceRow_private_offset = sizeof (BTDeviceRowPrivate);
	return bt_device_row_type_id;
}

static void
_vala_bt_device_row_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	BTDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BT_DEVICE_ROW, BTDeviceRow);
	switch (property_id) {
		case BT_DEVICE_ROW_DEVICE_PROPERTY:
		g_value_set_object (value, bt_device_row_get_device (self));
		break;
		case BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY:
		g_value_set_object (value, bt_device_row_get_obex_manager (self));
		break;
		case BT_DEVICE_ROW_UP_DEVICE_PROPERTY:
		g_value_set_object (value, bt_device_row_get_up_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bt_device_row_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	BTDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BT_DEVICE_ROW, BTDeviceRow);
	switch (property_id) {
		case BT_DEVICE_ROW_DEVICE_PROPERTY:
		bt_device_row_set_device (self, g_value_get_object (value));
		break;
		case BT_DEVICE_ROW_OBEX_MANAGER_PROPERTY:
		bt_device_row_set_obex_manager (self, g_value_get_object (value));
		break;
		case BT_DEVICE_ROW_UP_DEVICE_PROPERTY:
		bt_device_row_set_up_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

