/* BluetoothDBus.c generated by valac 0.56.14, the Vala compiler
 * generated from BluetoothDBus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 * Copyright (C) 2015 Alberts Muktupāvels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "statusapplet.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

typedef GDBusProxy Adapter1Proxy;
typedef GDBusProxyClass Adapter1ProxyClass;
typedef struct _Adapter1StartDiscoveryReadyData Adapter1StartDiscoveryReadyData;
typedef struct _Adapter1StopDiscoveryReadyData Adapter1StopDiscoveryReadyData;
typedef struct _Adapter1RemoveDeviceReadyData Adapter1RemoveDeviceReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Adapter1SetDiscoveryFilterReadyData Adapter1SetDiscoveryFilterReadyData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef GDBusProxy Device1Proxy;
typedef GDBusProxyClass Device1ProxyClass;
typedef struct _Device1ConnectReadyData Device1ConnectReadyData;
typedef struct _Device1DisconnectReadyData Device1DisconnectReadyData;
typedef struct _Device1ConnectProfileReadyData Device1ConnectProfileReadyData;
typedef struct _Device1DisconnectProfileReadyData Device1DisconnectProfileReadyData;
typedef struct _Device1PairReadyData Device1PairReadyData;
typedef struct _Device1CancelPairingReadyData Device1CancelPairingReadyData;
typedef GDBusProxy TransferProxy;
typedef GDBusProxyClass TransferProxyClass;
typedef GDBusProxy SessionProxy;
typedef GDBusProxyClass SessionProxyClass;
typedef GDBusProxy RfkillProxy;
typedef GDBusProxyClass RfkillProxyClass;

struct _Adapter1StartDiscoveryReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _Adapter1StopDiscoveryReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _Adapter1RemoveDeviceReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
};

struct _Adapter1SetDiscoveryFilterReadyData {
	GDBusMethodInvocation* _invocation_;
	GHashTable* properties;
};

struct _Device1ConnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _Device1DisconnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _Device1ConnectProfileReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* uuid;
};

struct _Device1DisconnectProfileReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* uuid;
};

struct _Device1PairReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _Device1CancelPairingReadyData {
	GDBusMethodInvocation* _invocation_;
};

static GType adapter1_type_id = 0;
static GType device1_type_id = 0;
static GType transfer_type_id = 0;
static GType session_type_id = 0;
static GType rfkill_type_id = 0;

static void adapter1_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void adapter1_proxy_start_discovery_async (Adapter1* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void adapter1_proxy_start_discovery_finish (Adapter1* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void adapter1_proxy_stop_discovery_async (Adapter1* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void adapter1_proxy_stop_discovery_finish (Adapter1* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void adapter1_proxy_remove_device_async (Adapter1* self,
                                         const char* device,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void adapter1_proxy_remove_device_finish (Adapter1* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void adapter1_proxy_set_discovery_filter_async (Adapter1* self,
                                                GHashTable* properties,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void adapter1_proxy_set_discovery_filter_finish (Adapter1* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static gchar* adapter1_dbus_proxy_get_address (Adapter1* self);
static gchar* adapter1_dbus_proxy_get_name (Adapter1* self);
static gchar* adapter1_dbus_proxy_get_alias (Adapter1* self);
static void adapter1_dbus_proxy_set_alias (Adapter1* self,
                                    const gchar* value);
static guint32 adapter1_dbus_proxy_get_class (Adapter1* self);
static gboolean adapter1_dbus_proxy_get_powered (Adapter1* self);
static void adapter1_dbus_proxy_set_powered (Adapter1* self,
                                      gboolean value);
static gchar* adapter1_dbus_proxy_get_powered_state (Adapter1* self);
static gboolean adapter1_dbus_proxy_get_discoverable (Adapter1* self);
static void adapter1_dbus_proxy_set_discoverable (Adapter1* self,
                                           gboolean value);
static guint32 adapter1_dbus_proxy_get_discoverable_timeout (Adapter1* self);
static void adapter1_dbus_proxy_set_discoverable_timeout (Adapter1* self,
                                                   guint32 value);
static gboolean adapter1_dbus_proxy_get_pairable (Adapter1* self);
static void adapter1_dbus_proxy_set_pairable (Adapter1* self,
                                       gboolean value);
static guint32 adapter1_dbus_proxy_get_pairable_timeout (Adapter1* self);
static void adapter1_dbus_proxy_set_pairable_timeout (Adapter1* self,
                                               guint32 value);
static gboolean adapter1_dbus_proxy_get_discovering (Adapter1* self);
static void adapter1_dbus_proxy_set_discovering (Adapter1* self,
                                          gboolean value);
static gchar** adapter1_dbus_proxy_get_UUIDS (Adapter1* self,
                                       gint* result_length1);
static gchar* adapter1_dbus_proxy_get_modalias (Adapter1* self);
static void adapter1_proxy_adapter1_interface_init (Adapter1Iface* iface);
static void _dbus_adapter1_start_discovery (Adapter1* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_adapter1_start_discovery_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_adapter1_stop_discovery (Adapter1* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_adapter1_stop_discovery_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_);
static void _dbus_adapter1_remove_device (Adapter1* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_adapter1_remove_device_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_adapter1_set_discovery_filter (Adapter1* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_adapter1_set_discovery_filter_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void adapter1_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data);
static GVariant* adapter1_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data);
static GVariant* _dbus_adapter1_get_address (Adapter1* self);
static GVariant* _dbus_adapter1_get_name (Adapter1* self);
static GVariant* _dbus_adapter1_get_alias (Adapter1* self);
static GVariant* _dbus_adapter1_get_class (Adapter1* self);
static GVariant* _dbus_adapter1_get_powered (Adapter1* self);
static GVariant* _dbus_adapter1_get_powered_state (Adapter1* self);
static GVariant* _dbus_adapter1_get_discoverable (Adapter1* self);
static GVariant* _dbus_adapter1_get_discoverable_timeout (Adapter1* self);
static GVariant* _dbus_adapter1_get_pairable (Adapter1* self);
static GVariant* _dbus_adapter1_get_pairable_timeout (Adapter1* self);
static GVariant* _dbus_adapter1_get_discovering (Adapter1* self);
static GVariant* _dbus_adapter1_get_UUIDS (Adapter1* self);
static GVariant* _dbus_adapter1_get_modalias (Adapter1* self);
static gboolean adapter1_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data);
static void _dbus_adapter1_set_alias (Adapter1* self,
                               GVariant* _value);
static void _dbus_adapter1_set_powered (Adapter1* self,
                                 GVariant* _value);
static void _dbus_adapter1_set_discoverable (Adapter1* self,
                                      GVariant* _value);
static void _dbus_adapter1_set_discoverable_timeout (Adapter1* self,
                                              GVariant* _value);
static void _dbus_adapter1_set_pairable (Adapter1* self,
                                  GVariant* _value);
static void _dbus_adapter1_set_pairable_timeout (Adapter1* self,
                                          GVariant* _value);
static void _dbus_adapter1_set_discovering (Adapter1* self,
                                     GVariant* _value);
static void _adapter1_unregister_object (gpointer user_data);
static void device1_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters);
static void device1_proxy_connect_async (Device1* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void device1_proxy_connect_finish (Device1* self,
                                   GAsyncResult* _res_,
                                   GError** error);
static void device1_proxy_disconnect_async (Device1* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void device1_proxy_disconnect_finish (Device1* self,
                                      GAsyncResult* _res_,
                                      GError** error);
static void device1_proxy_connect_profile_async (Device1* self,
                                          const gchar* uuid,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void device1_proxy_connect_profile_finish (Device1* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void device1_proxy_disconnect_profile_async (Device1* self,
                                             const gchar* uuid,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void device1_proxy_disconnect_profile_finish (Device1* self,
                                              GAsyncResult* _res_,
                                              GError** error);
static void device1_proxy_pair_async (Device1* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void device1_proxy_pair_finish (Device1* self,
                                GAsyncResult* _res_,
                                GError** error);
static void device1_proxy_cancel_pairing_async (Device1* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void device1_proxy_cancel_pairing_finish (Device1* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static gchar* device1_dbus_proxy_get_address (Device1* self);
static gchar* device1_dbus_proxy_get_name (Device1* self);
static gchar* device1_dbus_proxy_get_alias (Device1* self);
static void device1_dbus_proxy_set_alias (Device1* self,
                                   const gchar* value);
static guint32 device1_dbus_proxy_get_class (Device1* self);
static guint16 device1_dbus_proxy_get_appearance (Device1* self);
static gchar* device1_dbus_proxy_get_icon (Device1* self);
static gboolean device1_dbus_proxy_get_paired (Device1* self);
static gboolean device1_dbus_proxy_get_trusted (Device1* self);
static void device1_dbus_proxy_set_trusted (Device1* self,
                                     gboolean value);
static gboolean device1_dbus_proxy_get_blocked (Device1* self);
static void device1_dbus_proxy_set_blocked (Device1* self,
                                     gboolean value);
static gboolean device1_dbus_proxy_get_legacy_pairing (Device1* self);
static gint16 device1_dbus_proxy_get_RSSI (Device1* self);
static gboolean device1_dbus_proxy_get_connected (Device1* self);
static gchar** device1_dbus_proxy_get_UUIDs (Device1* self,
                                      gint* result_length1);
static gchar* device1_dbus_proxy_get_modalias (Device1* self);
static char* device1_dbus_proxy_get_adapter (Device1* self);
static void device1_proxy_device1_interface_init (Device1Iface* iface);
static void _dbus_device1_connect (Device1* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation);
static void _dbus_device1_connect_ready (GObject * source_object,
                                  GAsyncResult * _res_,
                                  gpointer _user_data_);
static void _dbus_device1_disconnect (Device1* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation);
static void _dbus_device1_disconnect_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_);
static void _dbus_device1_connect_profile (Device1* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_device1_connect_profile_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_);
static void _dbus_device1_disconnect_profile (Device1* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_device1_disconnect_profile_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_);
static void _dbus_device1_pair (Device1* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation);
static void _dbus_device1_pair_ready (GObject * source_object,
                               GAsyncResult * _res_,
                               gpointer _user_data_);
static void _dbus_device1_cancel_pairing (Device1* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_device1_cancel_pairing_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void device1_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data);
static GVariant* device1_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data);
static GVariant* _dbus_device1_get_address (Device1* self);
static GVariant* _dbus_device1_get_name (Device1* self);
static GVariant* _dbus_device1_get_alias (Device1* self);
static GVariant* _dbus_device1_get_class (Device1* self);
static GVariant* _dbus_device1_get_appearance (Device1* self);
static GVariant* _dbus_device1_get_icon (Device1* self);
static GVariant* _dbus_device1_get_paired (Device1* self);
static GVariant* _dbus_device1_get_trusted (Device1* self);
static GVariant* _dbus_device1_get_blocked (Device1* self);
static GVariant* _dbus_device1_get_legacy_pairing (Device1* self);
static GVariant* _dbus_device1_get_RSSI (Device1* self);
static GVariant* _dbus_device1_get_connected (Device1* self);
static GVariant* _dbus_device1_get_UUIDs (Device1* self);
static GVariant* _dbus_device1_get_modalias (Device1* self);
static GVariant* _dbus_device1_get_adapter (Device1* self);
static gboolean device1_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data);
static void _dbus_device1_set_alias (Device1* self,
                              GVariant* _value);
static void _dbus_device1_set_trusted (Device1* self,
                                GVariant* _value);
static void _dbus_device1_set_blocked (Device1* self,
                                GVariant* _value);
static void _device1_unregister_object (gpointer user_data);
static void transfer_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters);
static void transfer_proxy_cancel (Transfer* self,
                            GError** error);
static gchar* transfer_dbus_proxy_get_status (Transfer* self);
static char* transfer_dbus_proxy_get_session (Transfer* self);
static gchar* transfer_dbus_proxy_get_name (Transfer* self);
static gchar* transfer_dbus_proxy_get_Type (Transfer* self);
static guint64 transfer_dbus_proxy_get_time (Transfer* self);
static guint64 transfer_dbus_proxy_get_size (Transfer* self);
static guint64 transfer_dbus_proxy_get_transferred (Transfer* self);
static gchar* transfer_dbus_proxy_get_filename (Transfer* self);
static void transfer_proxy_transfer_interface_init (TransferIface* iface);
static void _dbus_transfer_cancel (Transfer* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation);
static void transfer_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data);
static GVariant* transfer_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data);
static GVariant* _dbus_transfer_get_status (Transfer* self);
static GVariant* _dbus_transfer_get_session (Transfer* self);
static GVariant* _dbus_transfer_get_name (Transfer* self);
static GVariant* _dbus_transfer_get_Type (Transfer* self);
static GVariant* _dbus_transfer_get_time (Transfer* self);
static GVariant* _dbus_transfer_get_size (Transfer* self);
static GVariant* _dbus_transfer_get_transferred (Transfer* self);
static GVariant* _dbus_transfer_get_filename (Transfer* self);
static gboolean transfer_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data);
static void _transfer_unregister_object (gpointer user_data);
static void session_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters);
static gchar* session_dbus_proxy_get_source (Session* self);
static gchar* session_dbus_proxy_get_destination (Session* self);
static guchar session_dbus_proxy_get_channel (Session* self);
static gchar* session_dbus_proxy_get_target (Session* self);
static gchar* session_dbus_proxy_get_root (Session* self);
static void session_proxy_session_interface_init (SessionIface* iface);
static void session_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data);
static GVariant* session_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data);
static GVariant* _dbus_session_get_source (Session* self);
static GVariant* _dbus_session_get_destination (Session* self);
static GVariant* _dbus_session_get_channel (Session* self);
static GVariant* _dbus_session_get_target (Session* self);
static GVariant* _dbus_session_get_root (Session* self);
static gboolean session_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data);
static void _session_unregister_object (gpointer user_data);
static void rfkill_proxy_g_signal (GDBusProxy* proxy,
                            const gchar* sender_name,
                            const gchar* signal_name,
                            GVariant* parameters);
static gboolean rfkill_dbus_proxy_get_bluetooth_airplane_mode (Rfkill* self);
static void rfkill_dbus_proxy_set_bluetooth_airplane_mode (Rfkill* self,
                                                    gboolean value);
static void rfkill_proxy_rfkill_interface_init (RfkillIface* iface);
static void rfkill_dbus_interface_method_call (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* method_name,
                                        GVariant* parameters,
                                        GDBusMethodInvocation* invocation,
                                        gpointer user_data);
static GVariant* rfkill_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data);
static GVariant* _dbus_rfkill_get_bluetooth_airplane_mode (Rfkill* self);
static gboolean rfkill_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data);
static void _dbus_rfkill_set_bluetooth_airplane_mode (Rfkill* self,
                                               GVariant* _value);
static void _rfkill_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo * const _adapter1_dbus_arg_info_start_discovery_in[] = {NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_start_discovery_out[] = {NULL};
static const GDBusMethodInfo _adapter1_dbus_method_info_start_discovery = {-1, "StartDiscovery", (GDBusArgInfo **) (&_adapter1_dbus_arg_info_start_discovery_in), (GDBusArgInfo **) (&_adapter1_dbus_arg_info_start_discovery_out), NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_stop_discovery_in[] = {NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_stop_discovery_out[] = {NULL};
static const GDBusMethodInfo _adapter1_dbus_method_info_stop_discovery = {-1, "StopDiscovery", (GDBusArgInfo **) (&_adapter1_dbus_arg_info_stop_discovery_in), (GDBusArgInfo **) (&_adapter1_dbus_arg_info_stop_discovery_out), NULL};
static const GDBusArgInfo _adapter1_dbus_arg_info_remove_device_device = {-1, "device", "o", NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_remove_device_in[] = {&_adapter1_dbus_arg_info_remove_device_device, NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_remove_device_out[] = {NULL};
static const GDBusMethodInfo _adapter1_dbus_method_info_remove_device = {-1, "RemoveDevice", (GDBusArgInfo **) (&_adapter1_dbus_arg_info_remove_device_in), (GDBusArgInfo **) (&_adapter1_dbus_arg_info_remove_device_out), NULL};
static const GDBusArgInfo _adapter1_dbus_arg_info_set_discovery_filter_properties = {-1, "properties", "a{sv}", NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_set_discovery_filter_in[] = {&_adapter1_dbus_arg_info_set_discovery_filter_properties, NULL};
static const GDBusArgInfo * const _adapter1_dbus_arg_info_set_discovery_filter_out[] = {NULL};
static const GDBusMethodInfo _adapter1_dbus_method_info_set_discovery_filter = {-1, "SetDiscoveryFilter", (GDBusArgInfo **) (&_adapter1_dbus_arg_info_set_discovery_filter_in), (GDBusArgInfo **) (&_adapter1_dbus_arg_info_set_discovery_filter_out), NULL};
static const GDBusMethodInfo * const _adapter1_dbus_method_info[] = {&_adapter1_dbus_method_info_start_discovery, &_adapter1_dbus_method_info_stop_discovery, &_adapter1_dbus_method_info_remove_device, &_adapter1_dbus_method_info_set_discovery_filter, NULL};
static const GDBusSignalInfo * const _adapter1_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_address = {-1, "Address", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_class = {-1, "Class", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_powered = {-1, "Powered", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_powered_state = {-1, "PoweredState", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_discoverable = {-1, "Discoverable", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_discoverable_timeout = {-1, "DiscoverableTimeout", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_pairable = {-1, "Pairable", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_pairable_timeout = {-1, "PairableTimeout", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_discovering = {-1, "Discovering", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_UUIDS = {-1, "UUIDS", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _adapter1_dbus_property_info_modalias = {-1, "Modalias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _adapter1_dbus_property_info[] = {&_adapter1_dbus_property_info_address, &_adapter1_dbus_property_info_name, &_adapter1_dbus_property_info_alias, &_adapter1_dbus_property_info_class, &_adapter1_dbus_property_info_powered, &_adapter1_dbus_property_info_powered_state, &_adapter1_dbus_property_info_discoverable, &_adapter1_dbus_property_info_discoverable_timeout, &_adapter1_dbus_property_info_pairable, &_adapter1_dbus_property_info_pairable_timeout, &_adapter1_dbus_property_info_discovering, &_adapter1_dbus_property_info_UUIDS, &_adapter1_dbus_property_info_modalias, NULL};
static const GDBusInterfaceInfo _adapter1_dbus_interface_info = {-1, "org.bluez.Adapter1", (GDBusMethodInfo **) (&_adapter1_dbus_method_info), (GDBusSignalInfo **) (&_adapter1_dbus_signal_info), (GDBusPropertyInfo **) (&_adapter1_dbus_property_info), NULL};
static const GDBusInterfaceVTable _adapter1_dbus_interface_vtable = {adapter1_dbus_interface_method_call, adapter1_dbus_interface_get_property, adapter1_dbus_interface_set_property};
static const GDBusArgInfo * const _device1_dbus_arg_info_connect_in[] = {NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_connect_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_connect = {-1, "Connect", (GDBusArgInfo **) (&_device1_dbus_arg_info_connect_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_connect_out), NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_disconnect_in[] = {NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_disconnect_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_disconnect = {-1, "Disconnect", (GDBusArgInfo **) (&_device1_dbus_arg_info_disconnect_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_disconnect_out), NULL};
static const GDBusArgInfo _device1_dbus_arg_info_connect_profile_uuid = {-1, "uuid", "s", NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_connect_profile_in[] = {&_device1_dbus_arg_info_connect_profile_uuid, NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_connect_profile_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_connect_profile = {-1, "ConnectProfile", (GDBusArgInfo **) (&_device1_dbus_arg_info_connect_profile_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_connect_profile_out), NULL};
static const GDBusArgInfo _device1_dbus_arg_info_disconnect_profile_uuid = {-1, "uuid", "s", NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_disconnect_profile_in[] = {&_device1_dbus_arg_info_disconnect_profile_uuid, NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_disconnect_profile_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_disconnect_profile = {-1, "DisconnectProfile", (GDBusArgInfo **) (&_device1_dbus_arg_info_disconnect_profile_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_disconnect_profile_out), NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_pair_in[] = {NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_pair_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_pair = {-1, "Pair", (GDBusArgInfo **) (&_device1_dbus_arg_info_pair_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_pair_out), NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_cancel_pairing_in[] = {NULL};
static const GDBusArgInfo * const _device1_dbus_arg_info_cancel_pairing_out[] = {NULL};
static const GDBusMethodInfo _device1_dbus_method_info_cancel_pairing = {-1, "CancelPairing", (GDBusArgInfo **) (&_device1_dbus_arg_info_cancel_pairing_in), (GDBusArgInfo **) (&_device1_dbus_arg_info_cancel_pairing_out), NULL};
static const GDBusMethodInfo * const _device1_dbus_method_info[] = {&_device1_dbus_method_info_connect, &_device1_dbus_method_info_disconnect, &_device1_dbus_method_info_connect_profile, &_device1_dbus_method_info_disconnect_profile, &_device1_dbus_method_info_pair, &_device1_dbus_method_info_cancel_pairing, NULL};
static const GDBusSignalInfo * const _device1_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_address = {-1, "Address", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_class = {-1, "Class", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_appearance = {-1, "Appearance", "q", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_icon = {-1, "Icon", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_paired = {-1, "Paired", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_trusted = {-1, "Trusted", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_blocked = {-1, "Blocked", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_legacy_pairing = {-1, "LegacyPairing", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_RSSI = {-1, "RSSI", "n", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_connected = {-1, "Connected", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_UUIDs = {-1, "UUIDs", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_modalias = {-1, "Modalias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _device1_dbus_property_info_adapter = {-1, "Adapter", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _device1_dbus_property_info[] = {&_device1_dbus_property_info_address, &_device1_dbus_property_info_name, &_device1_dbus_property_info_alias, &_device1_dbus_property_info_class, &_device1_dbus_property_info_appearance, &_device1_dbus_property_info_icon, &_device1_dbus_property_info_paired, &_device1_dbus_property_info_trusted, &_device1_dbus_property_info_blocked, &_device1_dbus_property_info_legacy_pairing, &_device1_dbus_property_info_RSSI, &_device1_dbus_property_info_connected, &_device1_dbus_property_info_UUIDs, &_device1_dbus_property_info_modalias, &_device1_dbus_property_info_adapter, NULL};
static const GDBusInterfaceInfo _device1_dbus_interface_info = {-1, "org.bluez.Device1", (GDBusMethodInfo **) (&_device1_dbus_method_info), (GDBusSignalInfo **) (&_device1_dbus_signal_info), (GDBusPropertyInfo **) (&_device1_dbus_property_info), NULL};
static const GDBusInterfaceVTable _device1_dbus_interface_vtable = {device1_dbus_interface_method_call, device1_dbus_interface_get_property, device1_dbus_interface_set_property};
static const GDBusArgInfo * const _transfer_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _transfer_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _transfer_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_transfer_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_transfer_dbus_arg_info_cancel_out), NULL};
static const GDBusMethodInfo * const _transfer_dbus_method_info[] = {&_transfer_dbus_method_info_cancel, NULL};
static const GDBusSignalInfo * const _transfer_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_status = {-1, "Status", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_session = {-1, "Session", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_Type = {-1, "Type", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_time = {-1, "Time", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_size = {-1, "Size", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_transferred = {-1, "Transferred", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _transfer_dbus_property_info_filename = {-1, "Filename", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _transfer_dbus_property_info[] = {&_transfer_dbus_property_info_status, &_transfer_dbus_property_info_session, &_transfer_dbus_property_info_name, &_transfer_dbus_property_info_Type, &_transfer_dbus_property_info_time, &_transfer_dbus_property_info_size, &_transfer_dbus_property_info_transferred, &_transfer_dbus_property_info_filename, NULL};
static const GDBusInterfaceInfo _transfer_dbus_interface_info = {-1, "org.bluez.obex.Transfer1", (GDBusMethodInfo **) (&_transfer_dbus_method_info), (GDBusSignalInfo **) (&_transfer_dbus_signal_info), (GDBusPropertyInfo **) (&_transfer_dbus_property_info), NULL};
static const GDBusInterfaceVTable _transfer_dbus_interface_vtable = {transfer_dbus_interface_method_call, transfer_dbus_interface_get_property, transfer_dbus_interface_set_property};
static const GDBusMethodInfo * const _session_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _session_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _session_dbus_property_info_source = {-1, "Source", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _session_dbus_property_info_destination = {-1, "Destination", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _session_dbus_property_info_channel = {-1, "Channel", "y", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _session_dbus_property_info_target = {-1, "Target", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _session_dbus_property_info_root = {-1, "Root", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _session_dbus_property_info[] = {&_session_dbus_property_info_source, &_session_dbus_property_info_destination, &_session_dbus_property_info_channel, &_session_dbus_property_info_target, &_session_dbus_property_info_root, NULL};
static const GDBusInterfaceInfo _session_dbus_interface_info = {-1, "org.bluez.obex.Session1", (GDBusMethodInfo **) (&_session_dbus_method_info), (GDBusSignalInfo **) (&_session_dbus_signal_info), (GDBusPropertyInfo **) (&_session_dbus_property_info), NULL};
static const GDBusInterfaceVTable _session_dbus_interface_vtable = {session_dbus_interface_method_call, session_dbus_interface_get_property, session_dbus_interface_set_property};
static const GDBusMethodInfo * const _rfkill_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _rfkill_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _rfkill_dbus_property_info_bluetooth_airplane_mode = {-1, "BluetoothAirplaneMode", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _rfkill_dbus_property_info[] = {&_rfkill_dbus_property_info_bluetooth_airplane_mode, NULL};
static const GDBusInterfaceInfo _rfkill_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Rfkill", (GDBusMethodInfo **) (&_rfkill_dbus_method_info), (GDBusSignalInfo **) (&_rfkill_dbus_signal_info), (GDBusPropertyInfo **) (&_rfkill_dbus_property_info), NULL};
static const GDBusInterfaceVTable _rfkill_dbus_interface_vtable = {rfkill_dbus_interface_method_call, rfkill_dbus_interface_get_property, rfkill_dbus_interface_set_property};

void
adapter1_start_discovery (Adapter1* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->start_discovery) {
		_iface_->start_discovery (self, _callback_, _user_data_);
	}
}

void
adapter1_start_discovery_finish (Adapter1* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->start_discovery_finish) {
		_iface_->start_discovery_finish (self, _res_, error);
	}
}

void
adapter1_stop_discovery (Adapter1* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->stop_discovery) {
		_iface_->stop_discovery (self, _callback_, _user_data_);
	}
}

void
adapter1_stop_discovery_finish (Adapter1* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->stop_discovery_finish) {
		_iface_->stop_discovery_finish (self, _res_, error);
	}
}

void
adapter1_remove_device (Adapter1* self,
                        const char* device,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->remove_device) {
		_iface_->remove_device (self, device, _callback_, _user_data_);
	}
}

void
adapter1_remove_device_finish (Adapter1* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->remove_device_finish) {
		_iface_->remove_device_finish (self, _res_, error);
	}
}

void
adapter1_set_discovery_filter (Adapter1* self,
                               GHashTable* properties,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_discovery_filter) {
		_iface_->set_discovery_filter (self, properties, _callback_, _user_data_);
	}
}

void
adapter1_set_discovery_filter_finish (Adapter1* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	Adapter1Iface* _iface_;
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_discovery_filter_finish) {
		_iface_->set_discovery_filter_finish (self, _res_, error);
	}
}

gchar*
adapter1_get_address (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_address) {
		return _iface_->get_address (self);
	}
	return NULL;
}

gchar*
adapter1_get_name (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gchar*
adapter1_get_alias (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_alias) {
		return _iface_->get_alias (self);
	}
	return NULL;
}

void
adapter1_set_alias (Adapter1* self,
                    const gchar* value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_alias) {
		_iface_->set_alias (self, value);
	}
}

guint32
adapter1_get_class (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_class) {
		return _iface_->get_class (self);
	}
	return 0U;
}

gboolean
adapter1_get_powered (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_powered) {
		return _iface_->get_powered (self);
	}
	return FALSE;
}

void
adapter1_set_powered (Adapter1* self,
                      gboolean value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_powered) {
		_iface_->set_powered (self, value);
	}
}

gchar*
adapter1_get_powered_state (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_powered_state) {
		return _iface_->get_powered_state (self);
	}
	return NULL;
}

gboolean
adapter1_get_discoverable (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_discoverable) {
		return _iface_->get_discoverable (self);
	}
	return FALSE;
}

void
adapter1_set_discoverable (Adapter1* self,
                           gboolean value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_discoverable) {
		_iface_->set_discoverable (self, value);
	}
}

guint32
adapter1_get_discoverable_timeout (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_discoverable_timeout) {
		return _iface_->get_discoverable_timeout (self);
	}
	return 0U;
}

void
adapter1_set_discoverable_timeout (Adapter1* self,
                                   guint32 value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_discoverable_timeout) {
		_iface_->set_discoverable_timeout (self, value);
	}
}

gboolean
adapter1_get_pairable (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_pairable) {
		return _iface_->get_pairable (self);
	}
	return FALSE;
}

void
adapter1_set_pairable (Adapter1* self,
                       gboolean value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_pairable) {
		_iface_->set_pairable (self, value);
	}
}

guint32
adapter1_get_pairable_timeout (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_pairable_timeout) {
		return _iface_->get_pairable_timeout (self);
	}
	return 0U;
}

void
adapter1_set_pairable_timeout (Adapter1* self,
                               guint32 value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_pairable_timeout) {
		_iface_->set_pairable_timeout (self, value);
	}
}

gboolean
adapter1_get_discovering (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_discovering) {
		return _iface_->get_discovering (self);
	}
	return FALSE;
}

void
adapter1_set_discovering (Adapter1* self,
                          gboolean value)
{
	Adapter1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->set_discovering) {
		_iface_->set_discovering (self, value);
	}
}

gchar**
adapter1_get_UUIDS (Adapter1* self,
                    gint* result_length1)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_UUIDS) {
		return _iface_->get_UUIDS (self, result_length1);
	}
	return NULL;
}

gchar*
adapter1_get_modalias (Adapter1* self)
{
	Adapter1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ADAPTER1_GET_INTERFACE (self);
	if (_iface_->get_modalias) {
		return _iface_->get_modalias (self);
	}
	return NULL;
}

static void
adapter1_default_init (Adapter1Iface * iface,
                       gpointer iface_data)
{
}

/**
 * Definition for Bluez Adapter1 interface.
 */
GType
adapter1_get_type (void)
{
	return adapter1_type_id;
}

GType
adapter1_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (Adapter1Iface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adapter1_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	adapter1_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Adapter1", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (adapter1_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (adapter1_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) adapter1_proxy_get_type);
	g_type_set_qdata (adapter1_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Adapter1");
	g_type_set_qdata (adapter1_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_adapter1_dbus_interface_info));
	g_type_set_qdata (adapter1_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) adapter1_register_object);
	return adapter1_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (Adapter1Proxy, adapter1_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_ADAPTER1, adapter1_proxy_adapter1_interface_init) )
static void
adapter1_proxy_class_init (Adapter1ProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = adapter1_proxy_g_signal;
}

static void
adapter1_proxy_g_signal (GDBusProxy* proxy,
                         const gchar* sender_name,
                         const gchar* signal_name,
                         GVariant* parameters)
{
}

static void
adapter1_proxy_class_finalize (Adapter1ProxyClass* klass)
{
}

void
adapter1_proxy_register_dynamic_type (GTypeModule* module)
{
	adapter1_proxy_register_type (module);
}

static void
adapter1_proxy_init (Adapter1Proxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_adapter1_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
adapter1_proxy_start_discovery_async (Adapter1* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Adapter1", "StartDiscovery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
adapter1_proxy_start_discovery_finish (Adapter1* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
adapter1_proxy_stop_discovery_async (Adapter1* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Adapter1", "StopDiscovery");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
adapter1_proxy_stop_discovery_finish (Adapter1* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
adapter1_proxy_remove_device_async (Adapter1* self,
                                    const char* device,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Adapter1", "RemoveDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (device));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
adapter1_proxy_remove_device_finish (Adapter1* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
adapter1_proxy_set_discovery_filter_async (Adapter1* self,
                                           GHashTable* properties,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp14_;
	GHashTableIter _tmp15_;
	gpointer _tmp16_;
	gpointer _tmp17_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Adapter1", "SetDiscoveryFilter");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp15_, properties);
	g_variant_builder_init (&_tmp14_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp15_, &_tmp16_, &_tmp17_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp16_;
		_value = (GVariant*) _tmp17_;
		g_variant_builder_add (&_tmp14_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp14_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
adapter1_proxy_set_discovery_filter_finish (Adapter1* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
adapter1_dbus_proxy_get_address (Adapter1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Address");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Address"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
adapter1_dbus_proxy_get_name (Adapter1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
adapter1_dbus_proxy_get_alias (Adapter1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_alias (Adapter1* self,
                               const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static guint32
adapter1_dbus_proxy_get_class (Adapter1* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Class");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Class"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp18_ = 0U;
			return _tmp18_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
adapter1_dbus_proxy_get_powered (Adapter1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Powered");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Powered"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp19_ = FALSE;
			return _tmp19_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_powered (Adapter1* self,
                                 gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Powered"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gchar*
adapter1_dbus_proxy_get_powered_state (Adapter1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PoweredState");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PoweredState"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
adapter1_dbus_proxy_get_discoverable (Adapter1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Discoverable");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Discoverable"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp20_ = FALSE;
			return _tmp20_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_discoverable (Adapter1* self,
                                      gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Discoverable"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static guint32
adapter1_dbus_proxy_get_discoverable_timeout (Adapter1* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DiscoverableTimeout");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DiscoverableTimeout"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp21_ = 0U;
			return _tmp21_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_discoverable_timeout (Adapter1* self,
                                              guint32 value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DiscoverableTimeout"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
adapter1_dbus_proxy_get_pairable (Adapter1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Pairable");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Pairable"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp22_ = FALSE;
			return _tmp22_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_pairable (Adapter1* self,
                                  gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Pairable"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static guint32
adapter1_dbus_proxy_get_pairable_timeout (Adapter1* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PairableTimeout");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PairableTimeout"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp23_ = 0U;
			return _tmp23_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_pairable_timeout (Adapter1* self,
                                          guint32 value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PairableTimeout"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
adapter1_dbus_proxy_get_discovering (Adapter1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Discovering");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Discovering"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp24_ = FALSE;
			return _tmp24_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_dbus_proxy_set_discovering (Adapter1* self,
                                     gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Discovering"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gchar**
adapter1_dbus_proxy_get_UUIDS (Adapter1* self,
                               gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UUIDS");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UUIDS"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp25_ = g_new (gchar*, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _inner_reply);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (gchar*, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
	}
	_result_length1 = _tmp25__length1;
	_tmp25_[_tmp25__length] = NULL;
	_result = _tmp25_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
adapter1_dbus_proxy_get_modalias (Adapter1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Modalias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Adapter1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Modalias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
adapter1_proxy_adapter1_interface_init (Adapter1Iface* iface)
{
	iface->start_discovery = adapter1_proxy_start_discovery_async;
	iface->start_discovery_finish = adapter1_proxy_start_discovery_finish;
	iface->stop_discovery = adapter1_proxy_stop_discovery_async;
	iface->stop_discovery_finish = adapter1_proxy_stop_discovery_finish;
	iface->remove_device = adapter1_proxy_remove_device_async;
	iface->remove_device_finish = adapter1_proxy_remove_device_finish;
	iface->set_discovery_filter = adapter1_proxy_set_discovery_filter_async;
	iface->set_discovery_filter_finish = adapter1_proxy_set_discovery_filter_finish;
	iface->get_address = adapter1_dbus_proxy_get_address;
	iface->get_name = adapter1_dbus_proxy_get_name;
	iface->get_alias = adapter1_dbus_proxy_get_alias;
	iface->set_alias = adapter1_dbus_proxy_set_alias;
	iface->get_class = adapter1_dbus_proxy_get_class;
	iface->get_powered = adapter1_dbus_proxy_get_powered;
	iface->set_powered = adapter1_dbus_proxy_set_powered;
	iface->get_powered_state = adapter1_dbus_proxy_get_powered_state;
	iface->get_discoverable = adapter1_dbus_proxy_get_discoverable;
	iface->set_discoverable = adapter1_dbus_proxy_set_discoverable;
	iface->get_discoverable_timeout = adapter1_dbus_proxy_get_discoverable_timeout;
	iface->set_discoverable_timeout = adapter1_dbus_proxy_set_discoverable_timeout;
	iface->get_pairable = adapter1_dbus_proxy_get_pairable;
	iface->set_pairable = adapter1_dbus_proxy_set_pairable;
	iface->get_pairable_timeout = adapter1_dbus_proxy_get_pairable_timeout;
	iface->set_pairable_timeout = adapter1_dbus_proxy_set_pairable_timeout;
	iface->get_discovering = adapter1_dbus_proxy_get_discovering;
	iface->set_discovering = adapter1_dbus_proxy_set_discovering;
	iface->get_UUIDS = adapter1_dbus_proxy_get_UUIDS;
	iface->get_modalias = adapter1_dbus_proxy_get_modalias;
}

static void
_dbus_adapter1_start_discovery (Adapter1* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Adapter1StartDiscoveryReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Adapter1StartDiscoveryReadyData);
	_ready_data->_invocation_ = invocation;
	adapter1_start_discovery (self, (GAsyncReadyCallback) _dbus_adapter1_start_discovery_ready, _ready_data);
}

static void
_dbus_adapter1_start_discovery_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	Adapter1StartDiscoveryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	adapter1_start_discovery_finish ((Adapter1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Adapter1StartDiscoveryReadyData, _ready_data);
}

static void
_dbus_adapter1_stop_discovery (Adapter1* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Adapter1StopDiscoveryReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Adapter1StopDiscoveryReadyData);
	_ready_data->_invocation_ = invocation;
	adapter1_stop_discovery (self, (GAsyncReadyCallback) _dbus_adapter1_stop_discovery_ready, _ready_data);
}

static void
_dbus_adapter1_stop_discovery_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_)
{
	Adapter1StopDiscoveryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	adapter1_stop_discovery_finish ((Adapter1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Adapter1StopDiscoveryReadyData, _ready_data);
}

static void
_dbus_adapter1_remove_device (Adapter1* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Adapter1RemoveDeviceReadyData* _ready_data;
	GVariant* _tmp28_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Adapter1RemoveDeviceReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	adapter1_remove_device (self, _ready_data->device, (GAsyncReadyCallback) _dbus_adapter1_remove_device_ready, _ready_data);
	_error:
	;
}

static void
_dbus_adapter1_remove_device_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	Adapter1RemoveDeviceReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	adapter1_remove_device_finish ((Adapter1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (Adapter1RemoveDeviceReadyData, _ready_data);
}

static void
_dbus_adapter1_set_discovery_filter (Adapter1* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Adapter1SetDiscoveryFilterReadyData* _ready_data;
	GVariant* _tmp29_;
	GHashTable* _tmp30_;
	GVariantIter _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Adapter1SetDiscoveryFilterReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp30_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp31_, _tmp29_);
	while (g_variant_iter_loop (&_tmp31_, "{?*}", &_tmp32_, &_tmp33_)) {
		g_hash_table_insert (_tmp30_, g_variant_dup_string (_tmp32_, NULL), g_variant_get_variant (_tmp33_));
	}
	_ready_data->properties = _tmp30_;
	g_variant_unref (_tmp29_);
	adapter1_set_discovery_filter (self, _ready_data->properties, (GAsyncReadyCallback) _dbus_adapter1_set_discovery_filter_ready, _ready_data);
	_error:
	;
}

static void
_dbus_adapter1_set_discovery_filter_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	Adapter1SetDiscoveryFilterReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	adapter1_set_discovery_filter_finish ((Adapter1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (_ready_data->properties);
	g_slice_free (Adapter1SetDiscoveryFilterReadyData, _ready_data);
}

static void
adapter1_dbus_interface_method_call (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* method_name,
                                     GVariant* parameters,
                                     GDBusMethodInvocation* invocation,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "StartDiscovery") == 0) {
		_dbus_adapter1_start_discovery (object, parameters, invocation);
	} else if (strcmp (method_name, "StopDiscovery") == 0) {
		_dbus_adapter1_stop_discovery (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveDevice") == 0) {
		_dbus_adapter1_remove_device (object, parameters, invocation);
	} else if (strcmp (method_name, "SetDiscoveryFilter") == 0) {
		_dbus_adapter1_set_discovery_filter (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_adapter1_get_address (Adapter1* self)
{
	gchar* result;
	GVariant* _reply;
	result = adapter1_get_address (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_name (Adapter1* self)
{
	gchar* result;
	GVariant* _reply;
	result = adapter1_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_alias (Adapter1* self)
{
	gchar* result;
	GVariant* _reply;
	result = adapter1_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_class (Adapter1* self)
{
	guint32 result;
	GVariant* _reply;
	result = adapter1_get_class (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_powered (Adapter1* self)
{
	gboolean result;
	GVariant* _reply;
	result = adapter1_get_powered (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_powered_state (Adapter1* self)
{
	gchar* result;
	GVariant* _reply;
	result = adapter1_get_powered_state (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_discoverable (Adapter1* self)
{
	gboolean result;
	GVariant* _reply;
	result = adapter1_get_discoverable (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_discoverable_timeout (Adapter1* self)
{
	guint32 result;
	GVariant* _reply;
	result = adapter1_get_discoverable_timeout (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_pairable (Adapter1* self)
{
	gboolean result;
	GVariant* _reply;
	result = adapter1_get_pairable (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_pairable_timeout (Adapter1* self)
{
	guint32 result;
	GVariant* _reply;
	result = adapter1_get_pairable_timeout (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_discovering (Adapter1* self)
{
	gboolean result;
	GVariant* _reply;
	result = adapter1_get_discovering (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_UUIDS (Adapter1* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp34_;
	GVariantBuilder _tmp35_;
	gint _tmp36_;
	result = adapter1_get_UUIDS (self, &result_length1);
	_tmp34_ = result;
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE ("as"));
	for (_tmp36_ = 0; _tmp36_ < result_length1; _tmp36_++) {
		g_variant_builder_add_value (&_tmp35_, g_variant_new_string (*_tmp34_));
		_tmp34_++;
	}
	_reply = g_variant_builder_end (&_tmp35_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
_dbus_adapter1_get_modalias (Adapter1* self)
{
	gchar* result;
	GVariant* _reply;
	result = adapter1_get_modalias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
adapter1_dbus_interface_get_property (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* property_name,
                                      GError** error,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Address") == 0) {
		return _dbus_adapter1_get_address (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_adapter1_get_name (object);
	} else if (strcmp (property_name, "Alias") == 0) {
		return _dbus_adapter1_get_alias (object);
	} else if (strcmp (property_name, "Class") == 0) {
		return _dbus_adapter1_get_class (object);
	} else if (strcmp (property_name, "Powered") == 0) {
		return _dbus_adapter1_get_powered (object);
	} else if (strcmp (property_name, "PoweredState") == 0) {
		return _dbus_adapter1_get_powered_state (object);
	} else if (strcmp (property_name, "Discoverable") == 0) {
		return _dbus_adapter1_get_discoverable (object);
	} else if (strcmp (property_name, "DiscoverableTimeout") == 0) {
		return _dbus_adapter1_get_discoverable_timeout (object);
	} else if (strcmp (property_name, "Pairable") == 0) {
		return _dbus_adapter1_get_pairable (object);
	} else if (strcmp (property_name, "PairableTimeout") == 0) {
		return _dbus_adapter1_get_pairable_timeout (object);
	} else if (strcmp (property_name, "Discovering") == 0) {
		return _dbus_adapter1_get_discovering (object);
	} else if (strcmp (property_name, "UUIDS") == 0) {
		return _dbus_adapter1_get_UUIDS (object);
	} else if (strcmp (property_name, "Modalias") == 0) {
		return _dbus_adapter1_get_modalias (object);
	}
	return NULL;
}

static void
_dbus_adapter1_set_alias (Adapter1* self,
                          GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	adapter1_set_alias (self, value);
	_g_free0 (value);
}

static void
_dbus_adapter1_set_powered (Adapter1* self,
                            GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	adapter1_set_powered (self, value);
}

static void
_dbus_adapter1_set_discoverable (Adapter1* self,
                                 GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	adapter1_set_discoverable (self, value);
}

static void
_dbus_adapter1_set_discoverable_timeout (Adapter1* self,
                                         GVariant* _value)
{
	guint32 value = 0U;
	value = g_variant_get_uint32 (_value);
	adapter1_set_discoverable_timeout (self, value);
}

static void
_dbus_adapter1_set_pairable (Adapter1* self,
                             GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	adapter1_set_pairable (self, value);
}

static void
_dbus_adapter1_set_pairable_timeout (Adapter1* self,
                                     GVariant* _value)
{
	guint32 value = 0U;
	value = g_variant_get_uint32 (_value);
	adapter1_set_pairable_timeout (self, value);
}

static void
_dbus_adapter1_set_discovering (Adapter1* self,
                                GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	adapter1_set_discovering (self, value);
}

static gboolean
adapter1_dbus_interface_set_property (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* property_name,
                                      GVariant* value,
                                      GError** error,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Alias") == 0) {
		_dbus_adapter1_set_alias (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Powered") == 0) {
		_dbus_adapter1_set_powered (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Discoverable") == 0) {
		_dbus_adapter1_set_discoverable (object, value);
		return TRUE;
	} else if (strcmp (property_name, "DiscoverableTimeout") == 0) {
		_dbus_adapter1_set_discoverable_timeout (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Pairable") == 0) {
		_dbus_adapter1_set_pairable (object, value);
		return TRUE;
	} else if (strcmp (property_name, "PairableTimeout") == 0) {
		_dbus_adapter1_set_pairable_timeout (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Discovering") == 0) {
		_dbus_adapter1_set_discovering (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
adapter1_register_object (gpointer object,
                          GDBusConnection* connection,
                          const gchar* path,
                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_adapter1_dbus_interface_info), &_adapter1_dbus_interface_vtable, data, _adapter1_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_adapter1_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
device1_connect (Device1* self,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->connect) {
		_iface_->connect (self, _callback_, _user_data_);
	}
}

void
device1_connect_finish (Device1* self,
                        GAsyncResult* _res_,
                        GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->connect_finish) {
		_iface_->connect_finish (self, _res_, error);
	}
}

void
device1_disconnect (Device1* self,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->disconnect) {
		_iface_->disconnect (self, _callback_, _user_data_);
	}
}

void
device1_disconnect_finish (Device1* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->disconnect_finish) {
		_iface_->disconnect_finish (self, _res_, error);
	}
}

void
device1_connect_profile (Device1* self,
                         const gchar* uuid,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->connect_profile) {
		_iface_->connect_profile (self, uuid, _callback_, _user_data_);
	}
}

void
device1_connect_profile_finish (Device1* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->connect_profile_finish) {
		_iface_->connect_profile_finish (self, _res_, error);
	}
}

void
device1_disconnect_profile (Device1* self,
                            const gchar* uuid,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->disconnect_profile) {
		_iface_->disconnect_profile (self, uuid, _callback_, _user_data_);
	}
}

void
device1_disconnect_profile_finish (Device1* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->disconnect_profile_finish) {
		_iface_->disconnect_profile_finish (self, _res_, error);
	}
}

void
device1_pair (Device1* self,
              GAsyncReadyCallback _callback_,
              gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->pair) {
		_iface_->pair (self, _callback_, _user_data_);
	}
}

void
device1_pair_finish (Device1* self,
                     GAsyncResult* _res_,
                     GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->pair_finish) {
		_iface_->pair_finish (self, _res_, error);
	}
}

void
device1_cancel_pairing (Device1* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->cancel_pairing) {
		_iface_->cancel_pairing (self, _callback_, _user_data_);
	}
}

void
device1_cancel_pairing_finish (Device1* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	Device1Iface* _iface_;
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->cancel_pairing_finish) {
		_iface_->cancel_pairing_finish (self, _res_, error);
	}
}

gchar*
device1_get_address (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_address) {
		return _iface_->get_address (self);
	}
	return NULL;
}

gchar*
device1_get_name (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gchar*
device1_get_alias (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_alias) {
		return _iface_->get_alias (self);
	}
	return NULL;
}

void
device1_set_alias (Device1* self,
                   const gchar* value)
{
	Device1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->set_alias) {
		_iface_->set_alias (self, value);
	}
}

guint32
device1_get_class (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_class) {
		return _iface_->get_class (self);
	}
	return 0U;
}

guint16
device1_get_appearance (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_appearance) {
		return _iface_->get_appearance (self);
	}
	return 0U;
}

gchar*
device1_get_icon (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_icon) {
		return _iface_->get_icon (self);
	}
	return NULL;
}

gboolean
device1_get_paired (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_paired) {
		return _iface_->get_paired (self);
	}
	return FALSE;
}

gboolean
device1_get_trusted (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_trusted) {
		return _iface_->get_trusted (self);
	}
	return FALSE;
}

void
device1_set_trusted (Device1* self,
                     gboolean value)
{
	Device1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->set_trusted) {
		_iface_->set_trusted (self, value);
	}
}

gboolean
device1_get_blocked (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_blocked) {
		return _iface_->get_blocked (self);
	}
	return FALSE;
}

void
device1_set_blocked (Device1* self,
                     gboolean value)
{
	Device1Iface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->set_blocked) {
		_iface_->set_blocked (self, value);
	}
}

gboolean
device1_get_legacy_pairing (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_legacy_pairing) {
		return _iface_->get_legacy_pairing (self);
	}
	return FALSE;
}

gint16
device1_get_RSSI (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_RSSI) {
		return _iface_->get_RSSI (self);
	}
	return -1;
}

gboolean
device1_get_connected (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_connected) {
		return _iface_->get_connected (self);
	}
	return FALSE;
}

gchar**
device1_get_UUIDs (Device1* self,
                   gint* result_length1)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_UUIDs) {
		return _iface_->get_UUIDs (self, result_length1);
	}
	return NULL;
}

gchar*
device1_get_modalias (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_modalias) {
		return _iface_->get_modalias (self);
	}
	return NULL;
}

char*
device1_get_adapter (Device1* self)
{
	Device1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DEVICE1_GET_INTERFACE (self);
	if (_iface_->get_adapter) {
		return _iface_->get_adapter (self);
	}
	return NULL;
}

static void
device1_default_init (Device1Iface * iface,
                      gpointer iface_data)
{
}

/**
 * Definition of the Bluez Device1 interface.
 */
GType
device1_get_type (void)
{
	return device1_type_id;
}

GType
device1_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (Device1Iface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device1_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	device1_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Device1", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (device1_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (device1_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) device1_proxy_get_type);
	g_type_set_qdata (device1_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Device1");
	g_type_set_qdata (device1_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_device1_dbus_interface_info));
	g_type_set_qdata (device1_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) device1_register_object);
	return device1_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (Device1Proxy, device1_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_DEVICE1, device1_proxy_device1_interface_init) )
static void
device1_proxy_class_init (Device1ProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = device1_proxy_g_signal;
}

static void
device1_proxy_g_signal (GDBusProxy* proxy,
                        const gchar* sender_name,
                        const gchar* signal_name,
                        GVariant* parameters)
{
}

static void
device1_proxy_class_finalize (Device1ProxyClass* klass)
{
}

void
device1_proxy_register_dynamic_type (GTypeModule* module)
{
	device1_proxy_register_type (module);
}

static void
device1_proxy_init (Device1Proxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_device1_dbus_interface_info));
}

static void
device1_proxy_connect_async (Device1* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Connect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_connect_finish (Device1* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
device1_proxy_disconnect_async (Device1* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Disconnect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_disconnect_finish (Device1* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
device1_proxy_connect_profile_async (Device1* self,
                                     const gchar* uuid,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "ConnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uuid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_connect_profile_finish (Device1* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
device1_proxy_disconnect_profile_async (Device1* self,
                                        const gchar* uuid,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "DisconnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uuid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_disconnect_profile_finish (Device1* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
device1_proxy_pair_async (Device1* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Pair");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_pair_finish (Device1* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
device1_proxy_cancel_pairing_async (Device1* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "CancelPairing");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
device1_proxy_cancel_pairing_finish (Device1* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
device1_dbus_proxy_get_address (Device1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Address");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Address"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
device1_dbus_proxy_get_name (Device1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
device1_dbus_proxy_get_alias (Device1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
device1_dbus_proxy_set_alias (Device1* self,
                              const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static guint32
device1_dbus_proxy_get_class (Device1* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Class");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Class"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp37_ = 0U;
			return _tmp37_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint16
device1_dbus_proxy_get_appearance (Device1* self)
{
	GVariant *_inner_reply;
	guint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Appearance");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Appearance"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint16 _tmp38_ = 0U;
			return _tmp38_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
device1_dbus_proxy_get_icon (Device1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Icon");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Icon"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
device1_dbus_proxy_get_paired (Device1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Paired");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Paired"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp39_ = FALSE;
			return _tmp39_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
device1_dbus_proxy_get_trusted (Device1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Trusted");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp40_ = FALSE;
			return _tmp40_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
device1_dbus_proxy_set_trusted (Device1* self,
                                gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
device1_dbus_proxy_get_blocked (Device1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Blocked");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp41_ = FALSE;
			return _tmp41_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
device1_dbus_proxy_set_blocked (Device1* self,
                                gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
device1_dbus_proxy_get_legacy_pairing (Device1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LegacyPairing");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LegacyPairing"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp42_ = FALSE;
			return _tmp42_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gint16
device1_dbus_proxy_get_RSSI (Device1* self)
{
	GVariant *_inner_reply;
	gint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RSSI");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RSSI"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint16 _tmp43_ = 0;
			return _tmp43_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
device1_dbus_proxy_get_connected (Device1* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Connected");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Connected"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp44_ = FALSE;
			return _tmp44_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar**
device1_dbus_proxy_get_UUIDs (Device1* self,
                              gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp45_;
	gint _tmp45__length;
	gint _tmp45__size;
	gint _tmp45__length1;
	GVariantIter _tmp46_;
	GVariant* _tmp47_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UUIDs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UUIDs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp45_ = g_new (gchar*, 5);
	_tmp45__length = 0;
	_tmp45__size = 4;
	_tmp45__length1 = 0;
	g_variant_iter_init (&_tmp46_, _inner_reply);
	for (; (_tmp47_ = g_variant_iter_next_value (&_tmp46_)) != NULL; _tmp45__length1++) {
		if (_tmp45__size == _tmp45__length) {
			_tmp45__size = 2 * _tmp45__size;
			_tmp45_ = g_renew (gchar*, _tmp45_, _tmp45__size + 1);
		}
		_tmp45_[_tmp45__length++] = g_variant_dup_string (_tmp47_, NULL);
		g_variant_unref (_tmp47_);
	}
	_result_length1 = _tmp45__length1;
	_tmp45_[_tmp45__length] = NULL;
	_result = _tmp45_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
device1_dbus_proxy_get_modalias (Device1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Modalias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Modalias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
device1_dbus_proxy_get_adapter (Device1* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Adapter");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Adapter"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
device1_proxy_device1_interface_init (Device1Iface* iface)
{
	iface->connect = device1_proxy_connect_async;
	iface->connect_finish = device1_proxy_connect_finish;
	iface->disconnect = device1_proxy_disconnect_async;
	iface->disconnect_finish = device1_proxy_disconnect_finish;
	iface->connect_profile = device1_proxy_connect_profile_async;
	iface->connect_profile_finish = device1_proxy_connect_profile_finish;
	iface->disconnect_profile = device1_proxy_disconnect_profile_async;
	iface->disconnect_profile_finish = device1_proxy_disconnect_profile_finish;
	iface->pair = device1_proxy_pair_async;
	iface->pair_finish = device1_proxy_pair_finish;
	iface->cancel_pairing = device1_proxy_cancel_pairing_async;
	iface->cancel_pairing_finish = device1_proxy_cancel_pairing_finish;
	iface->get_address = device1_dbus_proxy_get_address;
	iface->get_name = device1_dbus_proxy_get_name;
	iface->get_alias = device1_dbus_proxy_get_alias;
	iface->set_alias = device1_dbus_proxy_set_alias;
	iface->get_class = device1_dbus_proxy_get_class;
	iface->get_appearance = device1_dbus_proxy_get_appearance;
	iface->get_icon = device1_dbus_proxy_get_icon;
	iface->get_paired = device1_dbus_proxy_get_paired;
	iface->get_trusted = device1_dbus_proxy_get_trusted;
	iface->set_trusted = device1_dbus_proxy_set_trusted;
	iface->get_blocked = device1_dbus_proxy_get_blocked;
	iface->set_blocked = device1_dbus_proxy_set_blocked;
	iface->get_legacy_pairing = device1_dbus_proxy_get_legacy_pairing;
	iface->get_RSSI = device1_dbus_proxy_get_RSSI;
	iface->get_connected = device1_dbus_proxy_get_connected;
	iface->get_UUIDs = device1_dbus_proxy_get_UUIDs;
	iface->get_modalias = device1_dbus_proxy_get_modalias;
	iface->get_adapter = device1_dbus_proxy_get_adapter;
}

static void
_dbus_device1_connect (Device1* self,
                       GVariant* _parameters_,
                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1ConnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1ConnectReadyData);
	_ready_data->_invocation_ = invocation;
	device1_connect (self, (GAsyncReadyCallback) _dbus_device1_connect_ready, _ready_data);
}

static void
_dbus_device1_connect_ready (GObject * source_object,
                             GAsyncResult * _res_,
                             gpointer _user_data_)
{
	Device1ConnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_connect_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Device1ConnectReadyData, _ready_data);
}

static void
_dbus_device1_disconnect (Device1* self,
                          GVariant* _parameters_,
                          GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1DisconnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1DisconnectReadyData);
	_ready_data->_invocation_ = invocation;
	device1_disconnect (self, (GAsyncReadyCallback) _dbus_device1_disconnect_ready, _ready_data);
}

static void
_dbus_device1_disconnect_ready (GObject * source_object,
                                GAsyncResult * _res_,
                                gpointer _user_data_)
{
	Device1DisconnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_disconnect_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Device1DisconnectReadyData, _ready_data);
}

static void
_dbus_device1_connect_profile (Device1* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1ConnectProfileReadyData* _ready_data;
	GVariant* _tmp48_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1ConnectProfileReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->uuid = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	device1_connect_profile (self, _ready_data->uuid, (GAsyncReadyCallback) _dbus_device1_connect_profile_ready, _ready_data);
	_error:
	;
}

static void
_dbus_device1_connect_profile_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_)
{
	Device1ConnectProfileReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_connect_profile_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->uuid);
	g_slice_free (Device1ConnectProfileReadyData, _ready_data);
}

static void
_dbus_device1_disconnect_profile (Device1* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1DisconnectProfileReadyData* _ready_data;
	GVariant* _tmp49_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1DisconnectProfileReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->uuid = g_variant_dup_string (_tmp49_, NULL);
	g_variant_unref (_tmp49_);
	device1_disconnect_profile (self, _ready_data->uuid, (GAsyncReadyCallback) _dbus_device1_disconnect_profile_ready, _ready_data);
	_error:
	;
}

static void
_dbus_device1_disconnect_profile_ready (GObject * source_object,
                                        GAsyncResult * _res_,
                                        gpointer _user_data_)
{
	Device1DisconnectProfileReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_disconnect_profile_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->uuid);
	g_slice_free (Device1DisconnectProfileReadyData, _ready_data);
}

static void
_dbus_device1_pair (Device1* self,
                    GVariant* _parameters_,
                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1PairReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1PairReadyData);
	_ready_data->_invocation_ = invocation;
	device1_pair (self, (GAsyncReadyCallback) _dbus_device1_pair_ready, _ready_data);
}

static void
_dbus_device1_pair_ready (GObject * source_object,
                          GAsyncResult * _res_,
                          gpointer _user_data_)
{
	Device1PairReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_pair_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Device1PairReadyData, _ready_data);
}

static void
_dbus_device1_cancel_pairing (Device1* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Device1CancelPairingReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Device1CancelPairingReadyData);
	_ready_data->_invocation_ = invocation;
	device1_cancel_pairing (self, (GAsyncReadyCallback) _dbus_device1_cancel_pairing_ready, _ready_data);
}

static void
_dbus_device1_cancel_pairing_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	Device1CancelPairingReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	device1_cancel_pairing_finish ((Device1*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (Device1CancelPairingReadyData, _ready_data);
}

static void
device1_dbus_interface_method_call (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* method_name,
                                    GVariant* parameters,
                                    GDBusMethodInvocation* invocation,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Connect") == 0) {
		_dbus_device1_connect (object, parameters, invocation);
	} else if (strcmp (method_name, "Disconnect") == 0) {
		_dbus_device1_disconnect (object, parameters, invocation);
	} else if (strcmp (method_name, "ConnectProfile") == 0) {
		_dbus_device1_connect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "DisconnectProfile") == 0) {
		_dbus_device1_disconnect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Pair") == 0) {
		_dbus_device1_pair (object, parameters, invocation);
	} else if (strcmp (method_name, "CancelPairing") == 0) {
		_dbus_device1_cancel_pairing (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_device1_get_address (Device1* self)
{
	gchar* result;
	GVariant* _reply;
	result = device1_get_address (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_name (Device1* self)
{
	gchar* result;
	GVariant* _reply;
	result = device1_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_alias (Device1* self)
{
	gchar* result;
	GVariant* _reply;
	result = device1_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_class (Device1* self)
{
	guint32 result;
	GVariant* _reply;
	result = device1_get_class (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_appearance (Device1* self)
{
	guint16 result;
	GVariant* _reply;
	result = device1_get_appearance (self);
	_reply = g_variant_new_uint16 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_icon (Device1* self)
{
	gchar* result;
	GVariant* _reply;
	result = device1_get_icon (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_paired (Device1* self)
{
	gboolean result;
	GVariant* _reply;
	result = device1_get_paired (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_trusted (Device1* self)
{
	gboolean result;
	GVariant* _reply;
	result = device1_get_trusted (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_blocked (Device1* self)
{
	gboolean result;
	GVariant* _reply;
	result = device1_get_blocked (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_legacy_pairing (Device1* self)
{
	gboolean result;
	GVariant* _reply;
	result = device1_get_legacy_pairing (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_RSSI (Device1* self)
{
	gint16 result;
	GVariant* _reply;
	result = device1_get_RSSI (self);
	_reply = g_variant_new_int16 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_connected (Device1* self)
{
	gboolean result;
	GVariant* _reply;
	result = device1_get_connected (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_UUIDs (Device1* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp50_;
	GVariantBuilder _tmp51_;
	gint _tmp52_;
	result = device1_get_UUIDs (self, &result_length1);
	_tmp50_ = result;
	g_variant_builder_init (&_tmp51_, G_VARIANT_TYPE ("as"));
	for (_tmp52_ = 0; _tmp52_ < result_length1; _tmp52_++) {
		g_variant_builder_add_value (&_tmp51_, g_variant_new_string (*_tmp50_));
		_tmp50_++;
	}
	_reply = g_variant_builder_end (&_tmp51_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
_dbus_device1_get_modalias (Device1* self)
{
	gchar* result;
	GVariant* _reply;
	result = device1_get_modalias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_device1_get_adapter (Device1* self)
{
	char* result;
	GVariant* _reply;
	result = device1_get_adapter (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
device1_dbus_interface_get_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Address") == 0) {
		return _dbus_device1_get_address (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_device1_get_name (object);
	} else if (strcmp (property_name, "Alias") == 0) {
		return _dbus_device1_get_alias (object);
	} else if (strcmp (property_name, "Class") == 0) {
		return _dbus_device1_get_class (object);
	} else if (strcmp (property_name, "Appearance") == 0) {
		return _dbus_device1_get_appearance (object);
	} else if (strcmp (property_name, "Icon") == 0) {
		return _dbus_device1_get_icon (object);
	} else if (strcmp (property_name, "Paired") == 0) {
		return _dbus_device1_get_paired (object);
	} else if (strcmp (property_name, "Trusted") == 0) {
		return _dbus_device1_get_trusted (object);
	} else if (strcmp (property_name, "Blocked") == 0) {
		return _dbus_device1_get_blocked (object);
	} else if (strcmp (property_name, "LegacyPairing") == 0) {
		return _dbus_device1_get_legacy_pairing (object);
	} else if (strcmp (property_name, "RSSI") == 0) {
		return _dbus_device1_get_RSSI (object);
	} else if (strcmp (property_name, "Connected") == 0) {
		return _dbus_device1_get_connected (object);
	} else if (strcmp (property_name, "UUIDs") == 0) {
		return _dbus_device1_get_UUIDs (object);
	} else if (strcmp (property_name, "Modalias") == 0) {
		return _dbus_device1_get_modalias (object);
	} else if (strcmp (property_name, "Adapter") == 0) {
		return _dbus_device1_get_adapter (object);
	}
	return NULL;
}

static void
_dbus_device1_set_alias (Device1* self,
                         GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	device1_set_alias (self, value);
	_g_free0 (value);
}

static void
_dbus_device1_set_trusted (Device1* self,
                           GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	device1_set_trusted (self, value);
}

static void
_dbus_device1_set_blocked (Device1* self,
                           GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	device1_set_blocked (self, value);
}

static gboolean
device1_dbus_interface_set_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GVariant* value,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Alias") == 0) {
		_dbus_device1_set_alias (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Trusted") == 0) {
		_dbus_device1_set_trusted (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Blocked") == 0) {
		_dbus_device1_set_blocked (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
device1_register_object (gpointer object,
                         GDBusConnection* connection,
                         const gchar* path,
                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_device1_dbus_interface_info), &_device1_dbus_interface_vtable, data, _device1_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_device1_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
transfer_cancel (Transfer* self,
                 GError** error)
{
	TransferIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->cancel) {
		_iface_->cancel (self, error);
	}
}

gchar*
transfer_get_status (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_status) {
		return _iface_->get_status (self);
	}
	return NULL;
}

char*
transfer_get_session (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_session) {
		return _iface_->get_session (self);
	}
	return NULL;
}

gchar*
transfer_get_name (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

gchar*
transfer_get_Type (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_Type) {
		return _iface_->get_Type (self);
	}
	return NULL;
}

guint64
transfer_get_time (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_time) {
		return _iface_->get_time (self);
	}
	return 0ULL;
}

guint64
transfer_get_size (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_size) {
		return _iface_->get_size (self);
	}
	return 0ULL;
}

guint64
transfer_get_transferred (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_transferred) {
		return _iface_->get_transferred (self);
	}
	return 0ULL;
}

gchar*
transfer_get_filename (Transfer* self)
{
	TransferIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = TRANSFER_GET_INTERFACE (self);
	if (_iface_->get_filename) {
		return _iface_->get_filename (self);
	}
	return NULL;
}

static void
transfer_default_init (TransferIface * iface,
                       gpointer iface_data)
{
}

GType
transfer_get_type (void)
{
	return transfer_type_id;
}

GType
transfer_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TransferIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) transfer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	transfer_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Transfer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (transfer_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (transfer_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) transfer_proxy_get_type);
	g_type_set_qdata (transfer_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.Transfer1");
	g_type_set_qdata (transfer_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_transfer_dbus_interface_info));
	g_type_set_qdata (transfer_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) transfer_register_object);
	return transfer_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (TransferProxy, transfer_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_TRANSFER, transfer_proxy_transfer_interface_init) )
static void
transfer_proxy_class_init (TransferProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = transfer_proxy_g_signal;
}

static void
transfer_proxy_g_signal (GDBusProxy* proxy,
                         const gchar* sender_name,
                         const gchar* signal_name,
                         GVariant* parameters)
{
}

static void
transfer_proxy_class_finalize (TransferProxyClass* klass)
{
}

void
transfer_proxy_register_dynamic_type (GTypeModule* module)
{
	transfer_proxy_register_type (module);
}

static void
transfer_proxy_init (TransferProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_transfer_dbus_interface_info));
}

static void
transfer_proxy_cancel (Transfer* self,
                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.Transfer1", "Cancel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
transfer_dbus_proxy_get_status (Transfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Status");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Status"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
transfer_dbus_proxy_get_session (Transfer* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Session");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Session"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
transfer_dbus_proxy_get_name (Transfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
transfer_dbus_proxy_get_Type (Transfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Type");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Type"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
transfer_dbus_proxy_get_time (Transfer* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Time");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Time"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp53_ = 0ULL;
			return _tmp53_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
transfer_dbus_proxy_get_size (Transfer* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Size");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Size"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp54_ = 0ULL;
			return _tmp54_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
transfer_dbus_proxy_get_transferred (Transfer* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Transferred");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Transferred"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp55_ = 0ULL;
			return _tmp55_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
transfer_dbus_proxy_get_filename (Transfer* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Filename");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Transfer1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Filename"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
transfer_proxy_transfer_interface_init (TransferIface* iface)
{
	iface->cancel = transfer_proxy_cancel;
	iface->get_status = transfer_dbus_proxy_get_status;
	iface->get_session = transfer_dbus_proxy_get_session;
	iface->get_name = transfer_dbus_proxy_get_name;
	iface->get_Type = transfer_dbus_proxy_get_Type;
	iface->get_time = transfer_dbus_proxy_get_time;
	iface->get_size = transfer_dbus_proxy_get_size;
	iface->get_transferred = transfer_dbus_proxy_get_transferred;
	iface->get_filename = transfer_dbus_proxy_get_filename;
}

static void
_dbus_transfer_cancel (Transfer* self,
                       GVariant* _parameters_,
                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	transfer_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
transfer_dbus_interface_method_call (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* method_name,
                                     GVariant* parameters,
                                     GDBusMethodInvocation* invocation,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Cancel") == 0) {
		_dbus_transfer_cancel (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_transfer_get_status (Transfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = transfer_get_status (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_session (Transfer* self)
{
	char* result;
	GVariant* _reply;
	result = transfer_get_session (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_name (Transfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = transfer_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_Type (Transfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = transfer_get_Type (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_time (Transfer* self)
{
	guint64 result;
	GVariant* _reply;
	result = transfer_get_time (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_size (Transfer* self)
{
	guint64 result;
	GVariant* _reply;
	result = transfer_get_size (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_transferred (Transfer* self)
{
	guint64 result;
	GVariant* _reply;
	result = transfer_get_transferred (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
_dbus_transfer_get_filename (Transfer* self)
{
	gchar* result;
	GVariant* _reply;
	result = transfer_get_filename (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
transfer_dbus_interface_get_property (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* property_name,
                                      GError** error,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Status") == 0) {
		return _dbus_transfer_get_status (object);
	} else if (strcmp (property_name, "Session") == 0) {
		return _dbus_transfer_get_session (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_transfer_get_name (object);
	} else if (strcmp (property_name, "Type") == 0) {
		return _dbus_transfer_get_Type (object);
	} else if (strcmp (property_name, "Time") == 0) {
		return _dbus_transfer_get_time (object);
	} else if (strcmp (property_name, "Size") == 0) {
		return _dbus_transfer_get_size (object);
	} else if (strcmp (property_name, "Transferred") == 0) {
		return _dbus_transfer_get_transferred (object);
	} else if (strcmp (property_name, "Filename") == 0) {
		return _dbus_transfer_get_filename (object);
	}
	return NULL;
}

static gboolean
transfer_dbus_interface_set_property (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* property_name,
                                      GVariant* value,
                                      GError** error,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
transfer_register_object (gpointer object,
                          GDBusConnection* connection,
                          const gchar* path,
                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_transfer_dbus_interface_info), &_transfer_dbus_interface_vtable, data, _transfer_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_transfer_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
session_get_source (Session* self)
{
	SessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SESSION_GET_INTERFACE (self);
	if (_iface_->get_source) {
		return _iface_->get_source (self);
	}
	return NULL;
}

gchar*
session_get_destination (Session* self)
{
	SessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SESSION_GET_INTERFACE (self);
	if (_iface_->get_destination) {
		return _iface_->get_destination (self);
	}
	return NULL;
}

guchar
session_get_channel (Session* self)
{
	SessionIface* _iface_;
	g_return_val_if_fail (self != NULL, '\0');
	_iface_ = SESSION_GET_INTERFACE (self);
	if (_iface_->get_channel) {
		return _iface_->get_channel (self);
	}
	return '\0';
}

gchar*
session_get_target (Session* self)
{
	SessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SESSION_GET_INTERFACE (self);
	if (_iface_->get_target) {
		return _iface_->get_target (self);
	}
	return NULL;
}

gchar*
session_get_root (Session* self)
{
	SessionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SESSION_GET_INTERFACE (self);
	if (_iface_->get_root) {
		return _iface_->get_root (self);
	}
	return NULL;
}

static void
session_default_init (SessionIface * iface,
                      gpointer iface_data)
{
}

GType
session_get_type (void)
{
	return session_type_id;
}

GType
session_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SessionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	session_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Session", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (session_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (session_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) session_proxy_get_type);
	g_type_set_qdata (session_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.Session1");
	g_type_set_qdata (session_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_session_dbus_interface_info));
	g_type_set_qdata (session_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) session_register_object);
	return session_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (SessionProxy, session_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_SESSION, session_proxy_session_interface_init) )
static void
session_proxy_class_init (SessionProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = session_proxy_g_signal;
}

static void
session_proxy_g_signal (GDBusProxy* proxy,
                        const gchar* sender_name,
                        const gchar* signal_name,
                        GVariant* parameters)
{
}

static void
session_proxy_class_finalize (SessionProxyClass* klass)
{
}

void
session_proxy_register_dynamic_type (GTypeModule* module)
{
	session_proxy_register_type (module);
}

static void
session_proxy_init (SessionProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_session_dbus_interface_info));
}

static gchar*
session_dbus_proxy_get_source (Session* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Source");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Session1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Source"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
session_dbus_proxy_get_destination (Session* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Destination");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Session1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Destination"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guchar
session_dbus_proxy_get_channel (Session* self)
{
	GVariant *_inner_reply;
	guchar _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Channel");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Session1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Channel"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guchar _tmp56_ = '\0';
			return _tmp56_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_byte (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
session_dbus_proxy_get_target (Session* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Target");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Session1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Target"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
session_dbus_proxy_get_root (Session* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Root");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.obex.Session1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Root"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
session_proxy_session_interface_init (SessionIface* iface)
{
	iface->get_source = session_dbus_proxy_get_source;
	iface->get_destination = session_dbus_proxy_get_destination;
	iface->get_channel = session_dbus_proxy_get_channel;
	iface->get_target = session_dbus_proxy_get_target;
	iface->get_root = session_dbus_proxy_get_root;
}

static void
session_dbus_interface_method_call (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* method_name,
                                    GVariant* parameters,
                                    GDBusMethodInvocation* invocation,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_session_get_source (Session* self)
{
	gchar* result;
	GVariant* _reply;
	result = session_get_source (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_session_get_destination (Session* self)
{
	gchar* result;
	GVariant* _reply;
	result = session_get_destination (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_session_get_channel (Session* self)
{
	guchar result;
	GVariant* _reply;
	result = session_get_channel (self);
	_reply = g_variant_new_byte (result);
	return _reply;
}

static GVariant*
_dbus_session_get_target (Session* self)
{
	gchar* result;
	GVariant* _reply;
	result = session_get_target (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_session_get_root (Session* self)
{
	gchar* result;
	GVariant* _reply;
	result = session_get_root (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
session_dbus_interface_get_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Source") == 0) {
		return _dbus_session_get_source (object);
	} else if (strcmp (property_name, "Destination") == 0) {
		return _dbus_session_get_destination (object);
	} else if (strcmp (property_name, "Channel") == 0) {
		return _dbus_session_get_channel (object);
	} else if (strcmp (property_name, "Target") == 0) {
		return _dbus_session_get_target (object);
	} else if (strcmp (property_name, "Root") == 0) {
		return _dbus_session_get_root (object);
	}
	return NULL;
}

static gboolean
session_dbus_interface_set_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GVariant* value,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
session_register_object (gpointer object,
                         GDBusConnection* connection,
                         const gchar* path,
                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_session_dbus_interface_info), &_session_dbus_interface_vtable, data, _session_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_session_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gboolean
rfkill_get_bluetooth_airplane_mode (Rfkill* self)
{
	RfkillIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RFKILL_GET_INTERFACE (self);
	if (_iface_->get_bluetooth_airplane_mode) {
		return _iface_->get_bluetooth_airplane_mode (self);
	}
	return FALSE;
}

void
rfkill_set_bluetooth_airplane_mode (Rfkill* self,
                                    gboolean value)
{
	RfkillIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RFKILL_GET_INTERFACE (self);
	if (_iface_->set_bluetooth_airplane_mode) {
		_iface_->set_bluetooth_airplane_mode (self, value);
	}
}

static void
rfkill_default_init (RfkillIface * iface,
                     gpointer iface_data)
{
}

GType
rfkill_get_type (void)
{
	return rfkill_type_id;
}

GType
rfkill_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RfkillIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rfkill_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	rfkill_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Rfkill", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rfkill_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rfkill_proxy_get_type);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Rfkill");
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rfkill_dbus_interface_info));
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rfkill_register_object);
	return rfkill_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (RfkillProxy, rfkill_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RFKILL, rfkill_proxy_rfkill_interface_init) )
static void
rfkill_proxy_class_init (RfkillProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = rfkill_proxy_g_signal;
}

static void
rfkill_proxy_g_signal (GDBusProxy* proxy,
                       const gchar* sender_name,
                       const gchar* signal_name,
                       GVariant* parameters)
{
}

static void
rfkill_proxy_class_finalize (RfkillProxyClass* klass)
{
}

void
rfkill_proxy_register_dynamic_type (GTypeModule* module)
{
	rfkill_proxy_register_type (module);
}

static void
rfkill_proxy_init (RfkillProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_rfkill_dbus_interface_info));
}

static gboolean
rfkill_dbus_proxy_get_bluetooth_airplane_mode (Rfkill* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BluetoothAirplaneMode");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp57_ = FALSE;
			return _tmp57_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
rfkill_dbus_proxy_set_bluetooth_airplane_mode (Rfkill* self,
                                               gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
rfkill_proxy_rfkill_interface_init (RfkillIface* iface)
{
	iface->get_bluetooth_airplane_mode = rfkill_dbus_proxy_get_bluetooth_airplane_mode;
	iface->set_bluetooth_airplane_mode = rfkill_dbus_proxy_set_bluetooth_airplane_mode;
}

static void
rfkill_dbus_interface_method_call (GDBusConnection* connection,
                                   const gchar* sender,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* method_name,
                                   GVariant* parameters,
                                   GDBusMethodInvocation* invocation,
                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_rfkill_get_bluetooth_airplane_mode (Rfkill* self)
{
	gboolean result;
	GVariant* _reply;
	result = rfkill_get_bluetooth_airplane_mode (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
rfkill_dbus_interface_get_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		return _dbus_rfkill_get_bluetooth_airplane_mode (object);
	}
	return NULL;
}

static void
_dbus_rfkill_set_bluetooth_airplane_mode (Rfkill* self,
                                          GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	rfkill_set_bluetooth_airplane_mode (self, value);
}

static gboolean
rfkill_dbus_interface_set_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GVariant* value,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		_dbus_rfkill_set_bluetooth_airplane_mode (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
rfkill_register_object (gpointer object,
                        GDBusConnection* connection,
                        const gchar* path,
                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rfkill_dbus_interface_info), &_rfkill_dbus_interface_vtable, data, _rfkill_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_rfkill_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

