/* BluetoothClient.c generated by valac 0.56.14, the Vala compiler
 * generated from BluetoothClient.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 * Copyright (C) 2015 Alberts Muktupāvels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Inspired by gnome-bluetooth and Elementary.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <upower.h>
#include "statusapplet.h"

#define BLUEZ_DBUS_NAME "org.bluez"
#define BLUEZ_MANAGER_PATH "/"
#define BLUEZ_ADAPTER_INTERFACE "org.bluez.Adapter1"
#define BLUEZ_DEVICE_INTERFACE "org.bluez.Device1"
#define BLUETOOTH_ADDRESS_PREFIX "/org/bluez/"
#define RFKILL_DBUS_NAME "org.gnome.SettingsDaemon.Rfkill"
#define RFKILL_DBUS_PATH "/org/gnome/SettingsDaemon/Rfkill"

#define TYPE_BLUETOOTH_CLIENT (bluetooth_client_get_type ())
#define BLUETOOTH_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLUETOOTH_CLIENT, BluetoothClient))
#define BLUETOOTH_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLUETOOTH_CLIENT, BluetoothClientClass))
#define IS_BLUETOOTH_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLUETOOTH_CLIENT))
#define IS_BLUETOOTH_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLUETOOTH_CLIENT))
#define BLUETOOTH_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLUETOOTH_CLIENT, BluetoothClientClass))

typedef struct _BluetoothClient BluetoothClient;
typedef struct _BluetoothClientClass BluetoothClientClass;
typedef struct _BluetoothClientPrivate BluetoothClientPrivate;
enum  {
	BLUETOOTH_CLIENT_0_PROPERTY,
	BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY,
	BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY,
	BLUETOOTH_CLIENT_NUM_PROPERTIES
};
static GParamSpec* bluetooth_client_properties[BLUETOOTH_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothClientCreateUpowerClientData BluetoothClientCreateUpowerClientData;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _BluetoothClientCreateObjectManagerData BluetoothClientCreateObjectManagerData;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
enum  {
	BLUETOOTH_CLIENT_DEVICE_ADDED_SIGNAL,
	BLUETOOTH_CLIENT_DEVICE_REMOVED_SIGNAL,
	BLUETOOTH_CLIENT_UPOWER_DEVICE_ADDED_SIGNAL,
	BLUETOOTH_CLIENT_UPOWER_DEVICE_REMOVED_SIGNAL,
	BLUETOOTH_CLIENT_AIRPLANE_MODE_CHANGED_SIGNAL,
	BLUETOOTH_CLIENT_NUM_SIGNALS
};
static guint bluetooth_client_signals[BLUETOOTH_CLIENT_NUM_SIGNALS] = {0};

struct _BluetoothClient {
	GObject parent_instance;
	BluetoothClientPrivate * priv;
};

struct _BluetoothClientClass {
	GObjectClass parent_class;
};

struct _BluetoothClientPrivate {
	GCancellable* cancellable;
	GDBusObjectManagerClient* object_manager;
	UpClient* upower_client;
	Rfkill* rfkill;
	gboolean _has_adapter;
	gboolean _retrieve_finished;
};

struct _BluetoothClientCreateUpowerClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothClient* self;
	UpClient* _tmp0_;
	GCancellable* _tmp1_;
	UpClient* _tmp2_;
	UpClient* _tmp3_;
	UpClient* _tmp4_;
	UpClient* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	BluetoothClient* self;
	GDBusObject* object;
};

struct _Block5Data {
	int _ref_count_;
	BluetoothClient* self;
	GDBusObject* object;
};

struct _Block6Data {
	int _ref_count_;
	BluetoothClient* self;
	GDBusObject* object;
};

struct _BluetoothClientCreateObjectManagerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothClient* self;
	GDBusObjectManagerClient* _tmp0_;
	GCancellable* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GDBusObjectManagerClient* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GDBusObjectManagerClient* _tmp7_;
	GDBusObjectManagerClient* _tmp8_;
	GDBusObjectManagerClient* _tmp9_;
	GDBusObjectManagerClient* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	BluetoothClient* self;
	GList* adapters;
};

static gint BluetoothClient_private_offset;
static gpointer bluetooth_client_parent_class = NULL;
static GType bluetooth_client_type_id = 0;

GType bluetooth_client_register_type (GTypeModule * module);
VALA_EXTERN GType bluetooth_client_get_type (void) G_GNUC_CONST ;
GType adapter1_proxy_get_type (void);
GType device1_proxy_get_type (void);
static GType bluetooth_client_get_proxy_type_func (BluetoothClient* self,
                                            GDBusObjectManagerClient* manager,
                                            const gchar* object_path,
                                            const gchar* interface_name);
static void bluetooth_client_create_upower_client_data_free (gpointer _data);
static void bluetooth_client_create_upower_client (BluetoothClient* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void bluetooth_client_create_upower_client_finish (BluetoothClient* self,
                                                   GAsyncResult* _res_);
static gboolean bluetooth_client_create_upower_client_co (BluetoothClientCreateUpowerClientData* _data_);
static void bluetooth_client_create_upower_client_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void bluetooth_client_upower_device_added_cb (BluetoothClient* self,
                                              UpDevice* up_device);
static void _bluetooth_client_upower_device_added_cb_up__client_device_added (UpClient* _sender,
                                                                       UpDevice* device,
                                                                       gpointer self);
static void bluetooth_client_upower_device_removed_cb (BluetoothClient* self,
                                                const gchar* object_path);
static void _bluetooth_client_upower_device_removed_cb_up__client_device_removed (UpClient* _sender,
                                                                           const gchar* object_path,
                                                                           gpointer self);
static void bluetooth_client_coldplug_client (BluetoothClient* self);
static void bluetooth_client_create_object_manager_data_free (gpointer _data);
static void bluetooth_client_create_object_manager (BluetoothClient* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void bluetooth_client_create_object_manager_finish (BluetoothClient* self,
                                                    GAsyncResult* _res_);
static gboolean bluetooth_client_create_object_manager_co (BluetoothClientCreateObjectManagerData* _data_);
static GType _bluetooth_client_get_proxy_type_func_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    gpointer self);
static void bluetooth_client_create_object_manager_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void ___lambda4_ (BluetoothClient* self,
                  GDBusObject* object);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda5_ (Block4Data* _data4_,
                 GDBusInterface* iface);
static void bluetooth_client_on_interface_added (BluetoothClient* self,
                                          GDBusObject* object,
                                          GDBusInterface* iface);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda4__gfunc (gconstpointer data,
                         gpointer self);
static void _bluetooth_client_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                 GDBusObject* object,
                                                                                 GDBusInterface* interface_,
                                                                                 gpointer self);
static void bluetooth_client_on_interface_removed (BluetoothClient* self,
                                            GDBusObject* object,
                                            GDBusInterface* iface);
static void _bluetooth_client_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                     GDBusObject* object,
                                                                                     GDBusInterface* interface_,
                                                                                     gpointer self);
static void ___lambda7_ (BluetoothClient* self,
                  GDBusObject* object);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_,
                 GDBusInterface* iface);
static void ___lambda8__gfunc (gconstpointer data,
                        gpointer self);
static void ____lambda7__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                      GDBusObject* object,
                                                      gpointer self);
static void ___lambda9_ (BluetoothClient* self,
                  GDBusObject* object);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_,
                  GDBusInterface* iface);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda9__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                        GDBusObject* object,
                                                        gpointer self);
static void bluetooth_client_set_retrieve_finished (BluetoothClient* self,
                                             gboolean value);
static void bluetooth_client_create_rfkill_proxy (BluetoothClient* self);
static void ___lambda11_ (BluetoothClient* self,
                   GVariant* changed,
                   gchar** invalid);
static void ____lambda11__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
static void bluetooth_client_set_has_adapter (BluetoothClient* self,
                                       gboolean value);
static GList* bluetooth_client_get_adapters (BluetoothClient* self);
static gboolean bluetooth_client_is_valid_address (BluetoothClient* self,
                                            const gchar* address);
static void bluetooth_client_upower_get_devices_cb (BluetoothClient* self,
                                             GObject* obj,
                                             GAsyncResult* res);
static void _bluetooth_client_upower_get_devices_cb_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda6_ (Block7Data* _data7_,
                 GDBusObject* object);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN gboolean bluetooth_client_airplane_mode_enabled (BluetoothClient* self);
VALA_EXTERN void bluetooth_client_set_airplane_mode (BluetoothClient* self,
                                         gboolean enabled);
VALA_EXTERN BluetoothClient* bluetooth_client_new (void);
VALA_EXTERN BluetoothClient* bluetooth_client_construct (GType object_type);
VALA_EXTERN gboolean bluetooth_client_get_has_adapter (BluetoothClient* self);
VALA_EXTERN gboolean bluetooth_client_get_retrieve_finished (BluetoothClient* self);
static GObject * bluetooth_client_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void bluetooth_client_finalize (GObject * obj);
static void _vala_bluetooth_client_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_bluetooth_client_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
bluetooth_client_get_instance_private (BluetoothClient* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothClient_private_offset);
}

static GType
bluetooth_client_get_proxy_type_func (BluetoothClient* self,
                                      GDBusObjectManagerClient* manager,
                                      const gchar* object_path,
                                      const gchar* interface_name)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (object_path != NULL, 0UL);
	if (interface_name == NULL) {
		result = g_dbus_object_proxy_get_type ();
		return result;
	}
	if (g_strcmp0 (interface_name, BLUEZ_ADAPTER_INTERFACE) == 0) {
		result = adapter1_proxy_get_type ();
		return result;
	}
	if (g_strcmp0 (interface_name, BLUEZ_DEVICE_INTERFACE) == 0) {
		result = device1_proxy_get_type ();
		return result;
	}
	result = g_dbus_proxy_get_type ();
	return result;
}

static void
bluetooth_client_create_upower_client_data_free (gpointer _data)
{
	BluetoothClientCreateUpowerClientData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothClientCreateUpowerClientData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_client_create_upower_client (BluetoothClient* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	BluetoothClientCreateUpowerClientData* _data_;
	BluetoothClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothClientCreateUpowerClientData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_client_create_upower_client_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_client_create_upower_client_co (_data_);
}

static void
bluetooth_client_create_upower_client_finish (BluetoothClient* self,
                                              GAsyncResult* _res_)
{
	BluetoothClientCreateUpowerClientData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Create and setup our UPower client.
 */
static void
bluetooth_client_create_upower_client_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	BluetoothClientCreateUpowerClientData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_client_create_upower_client_co (_data_);
}

static void
_bluetooth_client_upower_device_added_cb_up__client_device_added (UpClient* _sender,
                                                                  UpDevice* device,
                                                                  gpointer self)
{
	bluetooth_client_upower_device_added_cb ((BluetoothClient*) self, device);
}

static void
_bluetooth_client_upower_device_removed_cb_up__client_device_removed (UpClient* _sender,
                                                                      const gchar* object_path,
                                                                      gpointer self)
{
	bluetooth_client_upower_device_removed_cb ((BluetoothClient*) self, object_path);
}

static gboolean
bluetooth_client_create_upower_client_co (BluetoothClientCreateUpowerClientData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		up_client_new_async (_data_->_tmp1_, bluetooth_client_create_upower_client_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = up_client_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->upower_client);
		_data_->self->priv->upower_client = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->upower_client;
		g_signal_connect_object (_data_->_tmp4_, "device-added", (GCallback) _bluetooth_client_upower_device_added_cb_up__client_device_added, _data_->self, 0);
		_data_->_tmp5_ = _data_->self->priv->upower_client;
		g_signal_connect_object (_data_->_tmp5_, "device-removed", (GCallback) _bluetooth_client_upower_device_removed_cb_up__client_device_removed, _data_->self, 0);
		bluetooth_client_coldplug_client (_data_->self);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_critical ("BluetoothClient.vala:95: Error creating UPower client: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_client_create_object_manager_data_free (gpointer _data)
{
	BluetoothClientCreateObjectManagerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothClientCreateObjectManagerData, _data_);
}

static void
bluetooth_client_create_object_manager (BluetoothClient* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	BluetoothClientCreateObjectManagerData* _data_;
	BluetoothClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothClientCreateObjectManagerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_client_create_object_manager_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_client_create_object_manager_co (_data_);
}

static void
bluetooth_client_create_object_manager_finish (BluetoothClient* self,
                                               GAsyncResult* _res_)
{
	BluetoothClientCreateObjectManagerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Create and setup our Bluez DBus object manager client.
 */
static GType
_bluetooth_client_get_proxy_type_func_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              gpointer self)
{
	GType result;
	result = bluetooth_client_get_proxy_type_func ((BluetoothClient*) self, manager, object_path, interface_name);
	return result;
}

static void
bluetooth_client_create_object_manager_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	BluetoothClientCreateObjectManagerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_client_create_object_manager_co (_data_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BluetoothClient* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->object);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda5_ (Block4Data* _data4_,
            GDBusInterface* iface)
{
	BluetoothClient* self;
	self = _data4_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_client_on_interface_added (self, _data4_->object, iface);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (GDBusInterface*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda4_ (BluetoothClient* self,
             GDBusObject* object)
{
	Block4Data* _data4_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data4_->object);
	_data4_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data4_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda5__gfunc, _data4_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
____lambda4__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda4_ ((BluetoothClient*) self, (GDBusObject*) data);
}

static void
_bluetooth_client_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                            GDBusObject* object,
                                                                            GDBusInterface* interface_,
                                                                            gpointer self)
{
	bluetooth_client_on_interface_added ((BluetoothClient*) self, object, interface_);
}

static void
_bluetooth_client_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                GDBusObject* object,
                                                                                GDBusInterface* interface_,
                                                                                gpointer self)
{
	bluetooth_client_on_interface_removed ((BluetoothClient*) self, object, interface_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BluetoothClient* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->object);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda8_ (Block5Data* _data5_,
            GDBusInterface* iface)
{
	BluetoothClient* self;
	self = _data5_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_client_on_interface_added (self, _data5_->object, iface);
}

static void
___lambda8__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda8_ (self, (GDBusInterface*) data);
}

static void
___lambda7_ (BluetoothClient* self,
             GDBusObject* object)
{
	Block5Data* _data5_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data5_->object);
	_data5_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data5_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda8__gfunc, _data5_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
____lambda7__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                 GDBusObject* object,
                                                 gpointer self)
{
	___lambda7_ ((BluetoothClient*) self, object);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BluetoothClient* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->object);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda10_ (Block6Data* _data6_,
             GDBusInterface* iface)
{
	BluetoothClient* self;
	self = _data6_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_client_on_interface_removed (self, _data6_->object, iface);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ (self, (GDBusInterface*) data);
}

static void
___lambda9_ (BluetoothClient* self,
             GDBusObject* object)
{
	Block6Data* _data6_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data6_->object);
	_data6_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data6_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda10__gfunc, _data6_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
____lambda9__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                   GDBusObject* object,
                                                   gpointer self)
{
	___lambda9_ ((BluetoothClient*) self, object);
}

static gboolean
bluetooth_client_create_object_manager_co (BluetoothClientCreateObjectManagerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, BLUEZ_DBUS_NAME, BLUEZ_MANAGER_PATH, _bluetooth_client_get_proxy_type_func_gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, _data_->_tmp1_, bluetooth_client_create_object_manager_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->object_manager);
		_data_->self->priv->object_manager = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->object_manager;
		_data_->_tmp5_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_list_foreach (_data_->_tmp6_, ____lambda4__gfunc, _data_->self);
		(_data_->_tmp6_ == NULL) ? NULL : (_data_->_tmp6_ = (_g_list_free__g_object_unref0_ (_data_->_tmp6_), NULL));
		_data_->_tmp7_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp7_, "interface-added", (GCallback) _bluetooth_client_on_interface_added_g_dbus_object_manager_interface_added, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp8_, "interface-removed", (GCallback) _bluetooth_client_on_interface_removed_g_dbus_object_manager_interface_removed, _data_->self, 0);
		_data_->_tmp9_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp9_, "object-added", (GCallback) ____lambda7__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->_tmp10_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp10_, "object-removed", (GCallback) ____lambda9__g_dbus_object_manager_object_removed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("BluetoothClient.vala:129: Error getting DBus Object Manager: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	bluetooth_client_set_retrieve_finished (_data_->self, TRUE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
___lambda11_ (BluetoothClient* self,
              GVariant* changed,
              gchar** invalid)
{
	GVariant* variant = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "BluetoothAirplaneMode", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	variant = _tmp3_;
	_tmp4_ = variant;
	if (_tmp4_ == NULL) {
		_g_variant_unref0 (variant);
		return;
	}
	g_signal_emit (self, bluetooth_client_signals[BLUETOOTH_CLIENT_AIRPLANE_MODE_CHANGED_SIGNAL], 0);
	_g_variant_unref0 (variant);
}

static void
____lambda11__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	___lambda11_ ((BluetoothClient*) self, changed_properties, invalidated_properties);
}

static void
bluetooth_client_create_rfkill_proxy (BluetoothClient* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		Rfkill* _tmp0_ = NULL;
		GCancellable* _tmp1_;
		Rfkill* _tmp2_;
		Rfkill* _tmp3_;
		Rfkill* _tmp4_;
		_tmp1_ = self->priv->cancellable;
		_tmp2_ = (Rfkill*) g_initable_new (TYPE_RFKILL_PROXY, _tmp1_, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", RFKILL_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RFKILL_DBUS_PATH, "g-interface-name", "org.gnome.SettingsDaemon.Rfkill", NULL);
		_tmp0_ = (Rfkill*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->rfkill);
		self->priv->rfkill = _tmp3_;
		_tmp4_ = self->priv->rfkill;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda11__g_dbus_proxy_g_properties_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("BluetoothClient.vala:151: Error getting RFKill proxy: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Handles the addition of a DBus object interface.
 */
static void
bluetooth_client_on_interface_added (BluetoothClient* self,
                                     GDBusObject* object,
                                     GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (IS_ADAPTER1 (iface)) {
		bluetooth_client_set_has_adapter (self, TRUE);
	} else {
		if (IS_DEVICE1 (iface)) {
			Device1* device = NULL;
			Device1* _tmp0_;
			device = IS_DEVICE1 (iface) ? ((Device1*) iface) : NULL;
			_tmp0_ = device;
			g_signal_emit (self, bluetooth_client_signals[BLUETOOTH_CLIENT_DEVICE_ADDED_SIGNAL], 0, _tmp0_);
		}
	}
}

/**
 * Handles the removal of a DBus object interface.
 */
static void
bluetooth_client_on_interface_removed (BluetoothClient* self,
                                       GDBusObject* object,
                                       GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (IS_ADAPTER1 (iface)) {
		GList* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = bluetooth_client_get_adapters (self);
		_tmp1_ = _tmp0_;
		bluetooth_client_set_has_adapter (self, g_list_length (_tmp1_) > ((guint) 0));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
	} else {
		if (IS_DEVICE1 (iface)) {
			g_signal_emit (self, bluetooth_client_signals[BLUETOOTH_CLIENT_DEVICE_REMOVED_SIGNAL], 0, IS_DEVICE1 (iface) ? ((Device1*) iface) : NULL);
		}
	}
}

/**
 * Handle when a UPower device is being added.
 */
static void
bluetooth_client_upower_device_added_cb (BluetoothClient* self,
                                         UpDevice* up_device)
{
	gchar* serial = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (up_device != NULL);
	g_object_get (up_device, "serial", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	serial = _tmp1_;
	_tmp3_ = serial;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = serial;
		_tmp2_ = !bluetooth_client_is_valid_address (self, _tmp4_);
	}
	if (_tmp2_) {
		_g_free0 (serial);
		return;
	}
	g_object_get (up_device, "native-path", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = !g_str_has_prefix (_tmp7_, BLUETOOTH_ADDRESS_PREFIX);
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		_g_free0 (serial);
		return;
	}
	g_signal_emit (self, bluetooth_client_signals[BLUETOOTH_CLIENT_UPOWER_DEVICE_ADDED_SIGNAL], 0, up_device);
	_g_free0 (serial);
}

/**
 * Handles the removal of a UPower device.
 *
 * The Bluetooth device corresponding to the UPower device will have its
 * association removed, and its battery properties reset.
 */
static void
bluetooth_client_upower_device_removed_cb (BluetoothClient* self,
                                           const gchar* object_path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object_path != NULL);
	if (!g_str_has_prefix (object_path, BLUETOOTH_ADDRESS_PREFIX)) {
		return;
	}
	g_signal_emit (self, bluetooth_client_signals[BLUETOOTH_CLIENT_UPOWER_DEVICE_REMOVED_SIGNAL], 0, object_path);
}

/**
 * Gets the result of the asynchronous UPower get_devices call and
 * calls our device_added function to try to map them to Bluetooth
 * devices.
 */
static void
bluetooth_client_upower_get_devices_cb (BluetoothClient* self,
                                        GObject* obj,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GPtrArray* devices = NULL;
		UpClient* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		GPtrArray* _tmp3_;
		_tmp0_ = self->priv->upower_client;
		_tmp1_ = up_client_get_devices_finish (_tmp0_, res, &_inner_error0_);
		devices = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = devices;
		if (_tmp2_ == NULL) {
			g_warning ("BluetoothClient.vala:216: No UPower devices found");
			_g_ptr_array_unref0 (devices);
			return;
		}
		_tmp3_ = devices;
		{
			GPtrArray* device_collection = NULL;
			guint device_index = 0U;
			device_collection = _tmp3_;
			for (device_index = 0; device_index < device_collection->len; device_index = device_index + 1) {
				UpDevice* _tmp4_;
				UpDevice* device = NULL;
				_tmp4_ = _g_object_ref0 (g_ptr_array_index (device_collection, device_index));
				device = _tmp4_;
				{
					UpDevice* _tmp5_;
					_tmp5_ = device;
					bluetooth_client_upower_device_added_cb (self, _tmp5_);
					_g_object_unref0 (device);
				}
			}
		}
		_g_ptr_array_unref0 (devices);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("BluetoothClient.vala:225: Error getting UPower devices: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Gets all UPower devices for the current Upower client, and tries to associate
 * each UPower device with the corresponding Bluetooth device.
 */
static void
_bluetooth_client_upower_get_devices_cb_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	bluetooth_client_upower_get_devices_cb ((BluetoothClient*) self, source_object, res);
	g_object_unref (self);
}

static void
bluetooth_client_coldplug_client (BluetoothClient* self)
{
	UpClient* _tmp0_;
	UpClient* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upower_client;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->upower_client;
	_tmp2_ = self->priv->cancellable;
	up_client_get_devices_async (_tmp1_, _tmp2_, _bluetooth_client_upower_get_devices_cb_gasync_ready_callback, g_object_ref (self));
}

/**
 * Check if a Bluetooth address is valid.
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
bluetooth_client_is_valid_address (BluetoothClient* self,
                                   const gchar* address)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = strlen (address);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 17) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 17)) {
					break;
				}
				if (((i + 1) % 3) == 0) {
					if (string_get (address, (glong) i) != ':') {
						result = FALSE;
						return result;
					}
					continue;
				}
				if (!g_ascii_isxdigit (string_get (address, (glong) i))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
 * Get all Bluetooth adapters from our Bluez object manager.
 */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BluetoothClient* self;
		self = _data7_->self;
		(_data7_->adapters == NULL) ? NULL : (_data7_->adapters = (_g_list_free__g_object_unref0_ (_data7_->adapters), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda6_ (Block7Data* _data7_,
            GDBusObject* object)
{
	BluetoothClient* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GDBusInterface* _tmp2_;
	Adapter1* _tmp3_;
	self = _data7_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, BLUEZ_ADAPTER_INTERFACE);
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = iface;
	_tmp3_ = _g_object_ref0 (IS_ADAPTER1 (_tmp2_) ? ((Adapter1*) _tmp2_) : NULL);
	_data7_->adapters = g_list_append (_data7_->adapters, _tmp3_);
	_g_object_unref0 (iface);
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (GDBusObject*) data);
}

static GList*
bluetooth_client_get_adapters (BluetoothClient* self)
{
	Block7Data* _data7_;
	GDBusObjectManagerClient* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->adapters = NULL;
	_tmp0_ = self->priv->object_manager;
	_tmp1_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda6__gfunc, _data7_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	_tmp3_ = _data7_->adapters;
	_data7_->adapters = NULL;
	result = _tmp3_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

/**
 * Get whether or not Bluetooth airplane mode is enabled.
 */
gboolean
bluetooth_client_airplane_mode_enabled (BluetoothClient* self)
{
	Rfkill* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->rfkill;
	_tmp1_ = rfkill_get_bluetooth_airplane_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
 * Set whether or not Bluetooth airplane mode is enabled.
 */
void
bluetooth_client_set_airplane_mode (BluetoothClient* self,
                                    gboolean enabled)
{
	Rfkill* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->rfkill;
	rfkill_set_bluetooth_airplane_mode (_tmp0_, enabled);
}

BluetoothClient*
bluetooth_client_construct (GType object_type)
{
	BluetoothClient * self = NULL;
	self = (BluetoothClient*) g_object_new (object_type, NULL);
	return self;
}

BluetoothClient*
bluetooth_client_new (void)
{
	return bluetooth_client_construct (TYPE_BLUETOOTH_CLIENT);
}

gboolean
bluetooth_client_get_has_adapter (BluetoothClient* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_adapter;
	return result;
}

static void
bluetooth_client_set_has_adapter (BluetoothClient* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_client_get_has_adapter (self);
	if (old_value != value) {
		self->priv->_has_adapter = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_client_properties[BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY]);
	}
}

gboolean
bluetooth_client_get_retrieve_finished (BluetoothClient* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_retrieve_finished;
	return result;
}

static void
bluetooth_client_set_retrieve_finished (BluetoothClient* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_client_get_retrieve_finished (self);
	if (old_value != value) {
		self->priv->_retrieve_finished = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_client_properties[BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY]);
	}
}

static GObject *
bluetooth_client_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothClient * self;
	GCancellable* _tmp0_;
	parent_class = G_OBJECT_CLASS (bluetooth_client_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_CLIENT, BluetoothClient);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	bluetooth_client_create_rfkill_proxy (self);
	bluetooth_client_create_upower_client (self, NULL, NULL);
	bluetooth_client_create_object_manager (self, NULL, NULL);
	return obj;
}

static void
bluetooth_client_class_init (BluetoothClientClass * klass,
                             gpointer klass_data)
{
	bluetooth_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothClient_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_client_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_client_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY, bluetooth_client_properties[BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY] = g_param_spec_boolean ("has-adapter", "has-adapter", "has-adapter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY, bluetooth_client_properties[BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY] = g_param_spec_boolean ("retrieve-finished", "retrieve-finished", "retrieve-finished", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Signal emitted when a Bluetooth device has been added. */
	bluetooth_client_signals[BLUETOOTH_CLIENT_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", TYPE_BLUETOOTH_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DEVICE1);
	/** Signal emitted when a Bluetooth device has been removed. */
	bluetooth_client_signals[BLUETOOTH_CLIENT_DEVICE_REMOVED_SIGNAL] = g_signal_new ("device-removed", TYPE_BLUETOOTH_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DEVICE1);
	/** Signal emitted when a UPower device for a Bluetooth device has been detected. */
	bluetooth_client_signals[BLUETOOTH_CLIENT_UPOWER_DEVICE_ADDED_SIGNAL] = g_signal_new ("upower-device-added", TYPE_BLUETOOTH_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, up_device_get_type ());
	/** Signal emitted when a UPower device for a Bluetooth device has been removed. */
	bluetooth_client_signals[BLUETOOTH_CLIENT_UPOWER_DEVICE_REMOVED_SIGNAL] = g_signal_new ("upower-device-removed", TYPE_BLUETOOTH_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/** Signal emitted when airplane mode state has been changed. */
	bluetooth_client_signals[BLUETOOTH_CLIENT_AIRPLANE_MODE_CHANGED_SIGNAL] = g_signal_new ("airplane-mode-changed", TYPE_BLUETOOTH_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bluetooth_client_instance_init (BluetoothClient * self,
                                gpointer klass)
{
	self->priv = bluetooth_client_get_instance_private (self);
	self->priv->_has_adapter = FALSE;
	self->priv->_retrieve_finished = FALSE;
}

static void
bluetooth_client_finalize (GObject * obj)
{
	BluetoothClient * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_CLIENT, BluetoothClient);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->object_manager);
	_g_object_unref0 (self->priv->upower_client);
	_g_object_unref0 (self->priv->rfkill);
	G_OBJECT_CLASS (bluetooth_client_parent_class)->finalize (obj);
}

GType
bluetooth_client_get_type (void)
{
	return bluetooth_client_type_id;
}

GType
bluetooth_client_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothClient), 0, (GInstanceInitFunc) bluetooth_client_instance_init, NULL };
	bluetooth_client_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "BluetoothClient", &g_define_type_info, 0);
	BluetoothClient_private_offset = sizeof (BluetoothClientPrivate);
	return bluetooth_client_type_id;
}

static void
_vala_bluetooth_client_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BluetoothClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLUETOOTH_CLIENT, BluetoothClient);
	switch (property_id) {
		case BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY:
		g_value_set_boolean (value, bluetooth_client_get_has_adapter (self));
		break;
		case BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY:
		g_value_set_boolean (value, bluetooth_client_get_retrieve_finished (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_client_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	BluetoothClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BLUETOOTH_CLIENT, BluetoothClient);
	switch (property_id) {
		case BLUETOOTH_CLIENT_HAS_ADAPTER_PROPERTY:
		bluetooth_client_set_has_adapter (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_CLIENT_RETRIEVE_FINISHED_PROPERTY:
		bluetooth_client_set_retrieve_finished (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

