/* RavenTriggerApplet.c generated by valac 0.56.14, the Vala compiler
 * generated from RavenTriggerApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "raventriggerapplet.h"
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libpeas/peas.h>

enum  {
	RAVEN_TRIGGER_PROXY_EXPANSION_CHANGED_SIGNAL,
	RAVEN_TRIGGER_PROXY_ANCHOR_CHANGED_SIGNAL,
	RAVEN_TRIGGER_PROXY_NUM_SIGNALS
};
static guint raven_trigger_proxy_signals[RAVEN_TRIGGER_PROXY_NUM_SIGNALS] = {0};
typedef GDBusProxy RavenTriggerProxyProxy;
typedef GDBusProxyClass RavenTriggerProxyProxyClass;
typedef struct _raven_trigger_proxy_ToggleAppletViewReadyData raven_trigger_proxy_ToggleAppletViewReadyData;
enum  {
	RAVEN_TRIGGER_PLUGIN_0_PROPERTY,
	RAVEN_TRIGGER_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* raven_trigger_plugin_properties[RAVEN_TRIGGER_PLUGIN_NUM_PROPERTIES];
enum  {
	RAVEN_TRIGGER_APPLET_0_PROPERTY,
	RAVEN_TRIGGER_APPLET_NUM_PROPERTIES
};
static GParamSpec* raven_trigger_applet_properties[RAVEN_TRIGGER_APPLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))

struct _raven_trigger_proxy_ToggleAppletViewReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _RavenTriggerAppletPrivate {
	RavenTriggerProxy* raven_proxy;
	gboolean raven_expanded;
	gchar* raven_show_icon;
	gchar* raven_hide_icon;
};

struct _Block1Data {
	int _ref_count_;
	RavenTriggerApplet* self;
	gboolean e;
};

struct _Block2Data {
	int _ref_count_;
	RavenTriggerApplet* self;
	gboolean e;
};

static GType raven_trigger_proxy_type_id = 0;
static gpointer raven_trigger_plugin_parent_class = NULL;
static BudgiePluginIface * raven_trigger_plugin_budgie_plugin_parent_iface = NULL;
static GType raven_trigger_plugin_type_id = 0;
static gint RavenTriggerApplet_private_offset;
static gpointer raven_trigger_applet_parent_class = NULL;
static GMutex raven_trigger_applet_anchor_mutex;
static GMutex raven_trigger_applet_anchor_mutex = {0};
static GType raven_trigger_applet_type_id = 0;

static void raven_trigger_proxy_proxy_g_signal (GDBusProxy* proxy,
                                         const gchar* sender_name,
                                         const gchar* signal_name,
                                         GVariant* parameters);
static void _dbus_handle_raven_trigger_proxy_expansion_changed (RavenTriggerProxy* self,
                                                         GVariant* parameters);
static void _dbus_handle_raven_trigger_proxy_anchor_changed (RavenTriggerProxy* self,
                                                      GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void raven_trigger_proxy_proxy_ToggleAppletView_async (RavenTriggerProxy* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void raven_trigger_proxy_proxy_ToggleAppletView_finish (RavenTriggerProxy* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean raven_trigger_proxy_proxy_GetExpanded (RavenTriggerProxy* self,
                                                GError** error);
static gboolean raven_trigger_proxy_proxy_GetLeftAnchored (RavenTriggerProxy* self,
                                                    GError** error);
static void raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init (RavenTriggerProxyIface* iface);
static void _dbus_raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_raven_trigger_proxy_ToggleAppletView_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_raven_trigger_proxy_GetLeftAnchored (RavenTriggerProxy* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void raven_trigger_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* raven_trigger_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean raven_trigger_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_raven_trigger_proxy_expansion_changed (GObject* _sender,
                                                  gboolean expanded,
                                                  gpointer* _data);
static void _dbus_raven_trigger_proxy_anchor_changed (GObject* _sender,
                                               gboolean left_anchor,
                                               gpointer* _data);
static void _raven_trigger_proxy_unregister_object (gpointer user_data);
static BudgieApplet* raven_trigger_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                          const gchar* uuid);
static void raven_trigger_applet_on_button_clicked (RavenTriggerApplet* self);
static void _raven_trigger_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void raven_trigger_applet_get_raven (RavenTriggerApplet* self);
static gboolean raven_trigger_applet_toggle_raven (RavenTriggerApplet* self);
static gboolean _raven_trigger_applet_toggle_raven_gsource_func (gpointer self);
static void __lambda4_ (RavenTriggerApplet* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void raven_trigger_applet_on_raven_get (RavenTriggerApplet* self,
                                        GObject* o,
                                        GAsyncResult* res);
static void _raven_trigger_applet_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self);
static void raven_trigger_applet_on_prop_changed (RavenTriggerApplet* self,
                                           gboolean expanded);
static void raven_trigger_applet_on_anchor_changed (RavenTriggerApplet* self,
                                             gboolean left_anchor);
static void* raven_trigger_applet_update_anchors (RavenTriggerApplet* self);
static void ___lambda5_ (RavenTriggerApplet* self,
                  gboolean e);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block1Data* _data1_);
static gboolean ___lambda6__gsource_func (gpointer self);
static void ____lambda5__raven_trigger_proxy_expansion_changed (RavenTriggerProxy* _sender,
                                                         gboolean expanded,
                                                         gpointer self);
static void ___lambda7_ (RavenTriggerApplet* self,
                  gboolean e);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void ____lambda7__raven_trigger_proxy_anchor_changed (RavenTriggerProxy* _sender,
                                                      gboolean left_anchor,
                                                      gpointer self);
static gpointer _raven_trigger_applet_update_anchors_gthread_func (gpointer self);
static void raven_trigger_applet_finalize (GObject * obj);

static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_ToggleAppletView_in[] = {NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_ToggleAppletView_out[] = {NULL};
static const GDBusMethodInfo _raven_trigger_proxy_dbus_method_info_ToggleAppletView = {-1, "ToggleAppletView", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_ToggleAppletView_in), (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_ToggleAppletView_out), NULL};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_GetExpanded_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetExpanded_in[] = {NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetExpanded_out[] = {&_raven_trigger_proxy_dbus_arg_info_GetExpanded_result, NULL};
static const GDBusMethodInfo _raven_trigger_proxy_dbus_method_info_GetExpanded = {-1, "GetExpanded", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetExpanded_in), (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetExpanded_out), NULL};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_in[] = {NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_out[] = {&_raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_result, NULL};
static const GDBusMethodInfo _raven_trigger_proxy_dbus_method_info_GetLeftAnchored = {-1, "GetLeftAnchored", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_in), (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetLeftAnchored_out), NULL};
static const GDBusMethodInfo * const _raven_trigger_proxy_dbus_method_info[] = {&_raven_trigger_proxy_dbus_method_info_ToggleAppletView, &_raven_trigger_proxy_dbus_method_info_GetExpanded, &_raven_trigger_proxy_dbus_method_info_GetLeftAnchored, NULL};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_expansion_changed_expanded = {-1, "expanded", "b", NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_expansion_changed[] = {&_raven_trigger_proxy_dbus_arg_info_expansion_changed_expanded, NULL};
static const GDBusSignalInfo _raven_trigger_proxy_dbus_signal_info_expansion_changed = {-1, "ExpansionChanged", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_expansion_changed), NULL};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_anchor_changed_left_anchor = {-1, "left_anchor", "b", NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_anchor_changed[] = {&_raven_trigger_proxy_dbus_arg_info_anchor_changed_left_anchor, NULL};
static const GDBusSignalInfo _raven_trigger_proxy_dbus_signal_info_anchor_changed = {-1, "AnchorChanged", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_anchor_changed), NULL};
static const GDBusSignalInfo * const _raven_trigger_proxy_dbus_signal_info[] = {&_raven_trigger_proxy_dbus_signal_info_expansion_changed, &_raven_trigger_proxy_dbus_signal_info_anchor_changed, NULL};
static const GDBusPropertyInfo * const _raven_trigger_proxy_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_trigger_proxy_dbus_interface_info = {-1, "org.budgie_desktop.Raven", (GDBusMethodInfo **) (&_raven_trigger_proxy_dbus_method_info), (GDBusSignalInfo **) (&_raven_trigger_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_trigger_proxy_dbus_property_info), NULL};
static const GDBusInterfaceVTable _raven_trigger_proxy_dbus_interface_vtable = {raven_trigger_proxy_dbus_interface_method_call, raven_trigger_proxy_dbus_interface_get_property, raven_trigger_proxy_dbus_interface_set_property};

void
raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RavenTriggerProxyIface* _iface_;
	_iface_ = RAVEN_TRIGGER_PROXY_GET_INTERFACE (self);
	if (_iface_->ToggleAppletView) {
		_iface_->ToggleAppletView (self, _callback_, _user_data_);
	}
}

void
raven_trigger_proxy_ToggleAppletView_finish (RavenTriggerProxy* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	RavenTriggerProxyIface* _iface_;
	_iface_ = RAVEN_TRIGGER_PROXY_GET_INTERFACE (self);
	if (_iface_->ToggleAppletView_finish) {
		_iface_->ToggleAppletView_finish (self, _res_, error);
	}
}

gboolean
raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self,
                                 GError** error)
{
	RavenTriggerProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RAVEN_TRIGGER_PROXY_GET_INTERFACE (self);
	if (_iface_->GetExpanded) {
		return _iface_->GetExpanded (self, error);
	}
	return FALSE;
}

gboolean
raven_trigger_proxy_GetLeftAnchored (RavenTriggerProxy* self,
                                     GError** error)
{
	RavenTriggerProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RAVEN_TRIGGER_PROXY_GET_INTERFACE (self);
	if (_iface_->GetLeftAnchored) {
		return _iface_->GetLeftAnchored (self, error);
	}
	return FALSE;
}

static void
raven_trigger_proxy_default_init (RavenTriggerProxyIface * iface,
                                  gpointer iface_data)
{
	raven_trigger_proxy_signals[RAVEN_TRIGGER_PROXY_EXPANSION_CHANGED_SIGNAL] = g_signal_new ("expansion-changed", TYPE_RAVEN_TRIGGER_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	raven_trigger_proxy_signals[RAVEN_TRIGGER_PROXY_ANCHOR_CHANGED_SIGNAL] = g_signal_new ("anchor-changed", TYPE_RAVEN_TRIGGER_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

GType
raven_trigger_proxy_get_type (void)
{
	return raven_trigger_proxy_type_id;
}

GType
raven_trigger_proxy_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerProxyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_trigger_proxy_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	raven_trigger_proxy_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "RavenTriggerProxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_trigger_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_trigger_proxy_proxy_get_type);
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.budgie_desktop.Raven");
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_trigger_proxy_dbus_interface_info));
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_trigger_proxy_register_object);
	return raven_trigger_proxy_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (RavenTriggerProxyProxy, raven_trigger_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RAVEN_TRIGGER_PROXY, raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init) )
static void
raven_trigger_proxy_proxy_class_init (RavenTriggerProxyProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_trigger_proxy_proxy_g_signal;
}

static void
_dbus_handle_raven_trigger_proxy_expansion_changed (RavenTriggerProxy* self,
                                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean expanded = FALSE;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	expanded = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "expansion-changed", expanded);
}

static void
_dbus_handle_raven_trigger_proxy_anchor_changed (RavenTriggerProxy* self,
                                                 GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean left_anchor = FALSE;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	left_anchor = g_variant_get_boolean (_tmp1_);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "anchor-changed", left_anchor);
}

static void
raven_trigger_proxy_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters)
{
	if (strcmp (signal_name, "ExpansionChanged") == 0) {
		_dbus_handle_raven_trigger_proxy_expansion_changed ((RavenTriggerProxy*) proxy, parameters);
	} else if (strcmp (signal_name, "AnchorChanged") == 0) {
		_dbus_handle_raven_trigger_proxy_anchor_changed ((RavenTriggerProxy*) proxy, parameters);
	}
}

static void
raven_trigger_proxy_proxy_class_finalize (RavenTriggerProxyProxyClass* klass)
{
}

void
raven_trigger_proxy_proxy_register_dynamic_type (GTypeModule* module)
{
	raven_trigger_proxy_proxy_register_type (module);
}

static void
raven_trigger_proxy_proxy_init (RavenTriggerProxyProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_raven_trigger_proxy_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
raven_trigger_proxy_proxy_ToggleAppletView_async (RavenTriggerProxy* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "ToggleAppletView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
raven_trigger_proxy_proxy_ToggleAppletView_finish (RavenTriggerProxy* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
raven_trigger_proxy_proxy_GetExpanded (RavenTriggerProxy* self,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp4_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "GetExpanded");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp2_ = FALSE;
		return _tmp2_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp3_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp3_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp4_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp4_);
	g_variant_unref (_tmp4_);
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
raven_trigger_proxy_proxy_GetLeftAnchored (RavenTriggerProxy* self,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp7_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.budgie_desktop.Raven", "GetLeftAnchored");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp5_ = FALSE;
		return _tmp5_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp6_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp6_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp7_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp7_);
	g_variant_unref (_tmp7_);
	g_object_unref (_reply_message);
	return _result;
}

static void
raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init (RavenTriggerProxyIface* iface)
{
	iface->ToggleAppletView = raven_trigger_proxy_proxy_ToggleAppletView_async;
	iface->ToggleAppletView_finish = raven_trigger_proxy_proxy_ToggleAppletView_finish;
	iface->GetExpanded = raven_trigger_proxy_proxy_GetExpanded;
	iface->GetLeftAnchored = raven_trigger_proxy_proxy_GetLeftAnchored;
}

static void
_dbus_raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	raven_trigger_proxy_ToggleAppletViewReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (raven_trigger_proxy_ToggleAppletViewReadyData);
	_ready_data->_invocation_ = invocation;
	raven_trigger_proxy_ToggleAppletView (self, (GAsyncReadyCallback) _dbus_raven_trigger_proxy_ToggleAppletView_ready, _ready_data);
}

static void
_dbus_raven_trigger_proxy_ToggleAppletView_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	raven_trigger_proxy_ToggleAppletViewReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	raven_trigger_proxy_ToggleAppletView_finish ((RavenTriggerProxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (raven_trigger_proxy_ToggleAppletViewReadyData, _ready_data);
}

static void
_dbus_raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = raven_trigger_proxy_GetExpanded (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_raven_trigger_proxy_GetLeftAnchored (RavenTriggerProxy* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = raven_trigger_proxy_GetLeftAnchored (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
raven_trigger_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ToggleAppletView") == 0) {
		_dbus_raven_trigger_proxy_ToggleAppletView (object, parameters, invocation);
	} else if (strcmp (method_name, "GetExpanded") == 0) {
		_dbus_raven_trigger_proxy_GetExpanded (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLeftAnchored") == 0) {
		_dbus_raven_trigger_proxy_GetLeftAnchored (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
raven_trigger_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
raven_trigger_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_raven_trigger_proxy_expansion_changed (GObject* _sender,
                                             gboolean expanded,
                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (expanded));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "ExpansionChanged", _arguments, NULL);
}

static void
_dbus_raven_trigger_proxy_anchor_changed (GObject* _sender,
                                          gboolean left_anchor,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (left_anchor));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Raven", "AnchorChanged", _arguments, NULL);
}

guint
raven_trigger_proxy_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_trigger_proxy_dbus_interface_info), &_raven_trigger_proxy_dbus_interface_vtable, data, _raven_trigger_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "expansion-changed", (GCallback) _dbus_raven_trigger_proxy_expansion_changed, data);
	g_signal_connect (object, "anchor-changed", (GCallback) _dbus_raven_trigger_proxy_anchor_changed, data);
	return result;
}

static void
_raven_trigger_proxy_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_trigger_proxy_expansion_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_trigger_proxy_anchor_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static BudgieApplet*
raven_trigger_plugin_real_get_panel_widget (BudgiePlugin* base,
                                            const gchar* uuid)
{
	RavenTriggerPlugin * self;
	RavenTriggerApplet* _tmp0_;
	BudgieApplet* result;
	self = (RavenTriggerPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = raven_trigger_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

RavenTriggerPlugin*
raven_trigger_plugin_construct (GType object_type)
{
	RavenTriggerPlugin * self = NULL;
	self = (RavenTriggerPlugin*) g_object_new (object_type, NULL);
	return self;
}

RavenTriggerPlugin*
raven_trigger_plugin_new (void)
{
	return raven_trigger_plugin_construct (TYPE_RAVEN_TRIGGER_PLUGIN);
}

static void
raven_trigger_plugin_class_init (RavenTriggerPluginClass * klass,
                                 gpointer klass_data)
{
	raven_trigger_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
raven_trigger_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                                   gpointer iface_data)
{
	raven_trigger_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) raven_trigger_plugin_real_get_panel_widget;
}

static void
raven_trigger_plugin_instance_init (RavenTriggerPlugin * self,
                                    gpointer klass)
{
}

GType
raven_trigger_plugin_get_type (void)
{
	return raven_trigger_plugin_type_id;
}

GType
raven_trigger_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_trigger_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RavenTriggerPlugin), 0, (GInstanceInitFunc) raven_trigger_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) raven_trigger_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	raven_trigger_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "RavenTriggerPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, raven_trigger_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return raven_trigger_plugin_type_id;
}

static inline gpointer
raven_trigger_applet_get_instance_private (RavenTriggerApplet* self)
{
	return G_STRUCT_MEMBER_P (self, RavenTriggerApplet_private_offset);
}

static void
_raven_trigger_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	raven_trigger_applet_on_button_clicked ((RavenTriggerApplet*) self);
}

RavenTriggerApplet*
raven_trigger_applet_construct (GType object_type)
{
	RavenTriggerApplet * self = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	const gchar* _tmp6_;
	GtkImage* _tmp7_;
	const gchar* _tmp8_;
	GtkImage* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	GtkImage* _tmp12_;
	GtkStack* _tmp13_;
	GtkImage* _tmp14_;
	GtkStack* _tmp15_;
	GtkButton* _tmp16_;
	GtkStack* _tmp17_;
	GtkButton* _tmp18_;
	self = (RavenTriggerApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp0_;
	_tmp1_ = self->widget;
	g_signal_connect_object (_tmp1_, "clicked", (GCallback) _raven_trigger_applet_on_button_clicked_gtk_button_clicked, self, G_CONNECT_AFTER);
	_tmp2_ = self->widget;
	gtk_button_set_relief (_tmp2_, GTK_RELIEF_NONE);
	_tmp3_ = self->widget;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->widget;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "raven-trigger");
	_tmp6_ = self->priv->raven_show_icon;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp6_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->img_hidden);
	self->img_hidden = _tmp7_;
	_tmp8_ = self->priv->raven_hide_icon;
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->img_expanded);
	self->img_expanded = _tmp9_;
	_tmp10_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->img_stack);
	self->img_stack = _tmp10_;
	_tmp11_ = self->img_stack;
	_tmp12_ = self->img_hidden;
	gtk_stack_add_named (_tmp11_, (GtkWidget*) _tmp12_, "hidden");
	_tmp13_ = self->img_stack;
	_tmp14_ = self->img_expanded;
	gtk_stack_add_named (_tmp13_, (GtkWidget*) _tmp14_, "expanded");
	_tmp15_ = self->img_stack;
	gtk_stack_set_transition_type (_tmp15_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp16_ = self->widget;
	_tmp17_ = self->img_stack;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp18_);
	gtk_widget_show_all ((GtkWidget*) self);
	raven_trigger_applet_get_raven (self);
	return self;
}

RavenTriggerApplet*
raven_trigger_applet_new (void)
{
	return raven_trigger_applet_construct (TYPE_RAVEN_TRIGGER_APPLET);
}

/**
 * Schedule toggle_raven on the idle loop
 */
static gboolean
_raven_trigger_applet_toggle_raven_gsource_func (gpointer self)
{
	gboolean result;
	result = raven_trigger_applet_toggle_raven ((RavenTriggerApplet*) self);
	return result;
}

static void
raven_trigger_applet_on_button_clicked (RavenTriggerApplet* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _raven_trigger_applet_toggle_raven_gsource_func, g_object_ref (self), g_object_unref);
}

/**
 * Toggle the Raven Applet View, we'll update view state on callback
 */
static void
__lambda4_ (RavenTriggerApplet* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		RavenTriggerProxy* _tmp0_;
		_tmp0_ = self->priv->raven_proxy;
		raven_trigger_proxy_ToggleAppletView_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_message ("RavenTriggerApplet.vala:85: Error in dbus: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((RavenTriggerApplet*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
raven_trigger_applet_toggle_raven (RavenTriggerApplet* self)
{
	RavenTriggerProxy* _tmp0_;
	RavenTriggerProxy* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->raven_proxy;
	raven_trigger_proxy_ToggleAppletView (_tmp1_, ___lambda4__gasync_ready_callback, g_object_ref (self));
	result = FALSE;
	return result;
}

/**
 * Asynchronously fetch a Raven proxy
 */
static void
_raven_trigger_applet_on_raven_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self)
{
	raven_trigger_applet_on_raven_get ((RavenTriggerApplet*) self, source_object, res);
	g_object_unref (self);
}

static void
raven_trigger_applet_get_raven (RavenTriggerApplet* self)
{
	RavenTriggerProxy* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (TYPE_RAVEN_TRIGGER_PROXY_PROXY, 0, NULL, _raven_trigger_applet_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "org.budgie_desktop.Raven", NULL);
	}
}

/**
 * Handle Raven expansion state changing
 */
static void
raven_trigger_applet_on_prop_changed (RavenTriggerApplet* self,
                                      gboolean expanded)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&raven_trigger_applet_anchor_mutex);
	self->priv->raven_expanded = expanded;
	if (self->priv->raven_expanded) {
		GtkStack* _tmp0_;
		_tmp0_ = self->img_stack;
		gtk_stack_set_visible_child_name (_tmp0_, "expanded");
	} else {
		GtkStack* _tmp1_;
		_tmp1_ = self->img_stack;
		gtk_stack_set_visible_child_name (_tmp1_, "hidden");
	}
	g_mutex_unlock (&raven_trigger_applet_anchor_mutex);
}

static void
raven_trigger_applet_on_anchor_changed (RavenTriggerApplet* self,
                                        gboolean left_anchor)
{
	GtkImage* _tmp4_;
	const gchar* _tmp5_;
	GtkImage* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&raven_trigger_applet_anchor_mutex);
	if (left_anchor) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup ("pane-hide-symbolic");
		_g_free0 (self->priv->raven_show_icon);
		self->priv->raven_show_icon = _tmp0_;
		_tmp1_ = g_strdup ("pane-show-symbolic");
		_g_free0 (self->priv->raven_hide_icon);
		self->priv->raven_hide_icon = _tmp1_;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup ("pane-show-symbolic");
		_g_free0 (self->priv->raven_show_icon);
		self->priv->raven_show_icon = _tmp2_;
		_tmp3_ = g_strdup ("pane-hide-symbolic");
		_g_free0 (self->priv->raven_hide_icon);
		self->priv->raven_hide_icon = _tmp3_;
	}
	_tmp4_ = self->img_hidden;
	_tmp5_ = self->priv->raven_show_icon;
	gtk_image_set_from_icon_name (_tmp4_, _tmp5_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	_tmp6_ = self->img_expanded;
	_tmp7_ = self->priv->raven_hide_icon;
	gtk_image_set_from_icon_name (_tmp6_, _tmp7_, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_mutex_unlock (&raven_trigger_applet_anchor_mutex);
}

static void*
raven_trigger_applet_update_anchors (RavenTriggerApplet* self)
{
	gboolean b = FALSE;
	GError* _inner_error0_ = NULL;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		RavenTriggerProxy* _tmp1_;
		_tmp1_ = self->priv->raven_proxy;
		_tmp0_ = raven_trigger_proxy_GetLeftAnchored (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		b = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("RavenTriggerApplet.vala:138: Failed to get left anchored status of rav" \
"en trigger for update: %s", _tmp3_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	raven_trigger_applet_on_anchor_changed (self, b);
	result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RavenTriggerApplet* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda6_ (Block1Data* _data1_)
{
	RavenTriggerApplet* self;
	gboolean result;
	self = _data1_->self;
	raven_trigger_applet_on_prop_changed (self, _data1_->e);
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

static void
___lambda5_ (RavenTriggerApplet* self,
             gboolean e)
{
	Block1Data* _data1_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->e = e;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
____lambda5__raven_trigger_proxy_expansion_changed (RavenTriggerProxy* _sender,
                                                    gboolean expanded,
                                                    gpointer self)
{
	___lambda5_ ((RavenTriggerApplet*) self, expanded);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RavenTriggerApplet* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda8_ (Block2Data* _data2_)
{
	RavenTriggerApplet* self;
	gboolean result;
	self = _data2_->self;
	raven_trigger_applet_on_anchor_changed (self, _data2_->e);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ (self);
	return result;
}

static void
___lambda7_ (RavenTriggerApplet* self,
             gboolean e)
{
	Block2Data* _data2_;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->e = e;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
____lambda7__raven_trigger_proxy_anchor_changed (RavenTriggerProxy* _sender,
                                                 gboolean left_anchor,
                                                 gpointer self)
{
	___lambda7_ ((RavenTriggerApplet*) self, left_anchor);
}

static gpointer
_raven_trigger_applet_update_anchors_gthread_func (gpointer self)
{
	gpointer result;
	result = raven_trigger_applet_update_anchors ((RavenTriggerApplet*) self);
	g_object_unref (self);
	return result;
}

static void
raven_trigger_applet_on_raven_get (RavenTriggerApplet* self,
                                   GObject* o,
                                   GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RavenTriggerProxy* _tmp0_ = NULL;
		RavenTriggerProxy* _tmp1_;
		RavenTriggerProxy* _tmp2_;
		RavenTriggerProxy* _tmp3_;
		RavenTriggerProxy* _tmp4_;
		RavenTriggerProxy* _tmp5_;
		GThread* _tmp6_;
		GThread* _tmp7_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (RavenTriggerProxy*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (RavenTriggerProxy*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp3_;
		_tmp4_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp4_, "expansion-changed", (GCallback) ____lambda5__raven_trigger_proxy_expansion_changed, self, G_CONNECT_AFTER);
		_tmp5_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp5_, "anchor-changed", (GCallback) ____lambda7__raven_trigger_proxy_anchor_changed, self, 0);
		_tmp6_ = g_thread_try_new ("raven-update-anchors", _raven_trigger_applet_update_anchors_gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_thread_unref0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("RavenTriggerApplet.vala:166: Failed to gain Raven proxy: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
raven_trigger_applet_class_init (RavenTriggerAppletClass * klass,
                                 gpointer klass_data)
{
	raven_trigger_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RavenTriggerApplet_private_offset);
	G_OBJECT_CLASS (klass)->finalize = raven_trigger_applet_finalize;
}

static void
raven_trigger_applet_instance_init (RavenTriggerApplet * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = raven_trigger_applet_get_instance_private (self);
	self->priv->raven_proxy = NULL;
	self->priv->raven_expanded = FALSE;
	_tmp0_ = g_strdup ("pane-show-symbolic");
	self->priv->raven_show_icon = _tmp0_;
	_tmp1_ = g_strdup ("pane-hide-symbolic");
	self->priv->raven_hide_icon = _tmp1_;
}

static void
raven_trigger_applet_finalize (GObject * obj)
{
	RavenTriggerApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->img_expanded);
	_g_object_unref0 (self->img_hidden);
	_g_object_unref0 (self->img_stack);
	_g_object_unref0 (self->priv->raven_proxy);
	_g_free0 (self->priv->raven_show_icon);
	_g_free0 (self->priv->raven_hide_icon);
	G_OBJECT_CLASS (raven_trigger_applet_parent_class)->finalize (obj);
}

GType
raven_trigger_applet_get_type (void)
{
	return raven_trigger_applet_type_id;
}

GType
raven_trigger_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_trigger_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RavenTriggerApplet), 0, (GInstanceInitFunc) raven_trigger_applet_instance_init, NULL };
	raven_trigger_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "RavenTriggerApplet", &g_define_type_info, 0);
	RavenTriggerApplet_private_offset = sizeof (RavenTriggerAppletPrivate);
	return raven_trigger_applet_type_id;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	raven_trigger_plugin_register_type (module);
	raven_trigger_applet_register_type (module);
	raven_trigger_proxy_register_type (module);
	raven_trigger_proxy_proxy_register_dynamic_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_RAVEN_TRIGGER_PLUGIN);
	_g_object_unref0 (objmodule);
}

